/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.7.9
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/app.h>
        #include <wx/event.h>
        #include <wx/window.h>
        #include <wx/vidmode.h>
        #include <wx/app.h>
        #include <wx/apptrait.h>
        #include <wx/evtloop.h>
        #include <wx/object.h>
        #include <wx/eventfilter.h>
        #include <wx/event.h>
        #include <wx/object.h>
        #include <wx/object.h>
        
        #ifdef __WXGTK__
        #include <gdk/gdkx.h>
        #include <gtk/gtk.h>
        #endif
        
        #ifdef __WXMAC__
        #include <wx/osx/private.h>
        #endif
        
        #ifdef __WXMSW__
        #include <wx/msw/private.h>
        #include <wx/msw/winundef.h>
        #include <wx/msw/msvcrt.h>
        #endif
        
        
        #ifdef __WXMSW__             // If building for Windows...
        
        //----------------------------------------------------------------------
        // This gets run when the DLL is loaded.  We just need to save the
        // instance handle.
        //----------------------------------------------------------------------
        
        extern "C"
        BOOL WINAPI DllMain(
            HINSTANCE   hinstDLL,    // handle to DLL module
            DWORD       fdwReason,   // reason for calling function
            LPVOID      lpvReserved  // reserved
           )
        {
            // If wxPython is embedded in another wxWidgets app then
            // the instance has already been set.
            if (! wxGetInstance())
                wxSetInstance(hinstDLL);
        
            return TRUE;
        }
        #endif  // __WXMSW__
        
        //----------------------------------------------------------------------
        // Classes for implementing the wxp main application shell.
        //----------------------------------------------------------------------
        
        
        class wxPyApp : public wxApp
        {
            DECLARE_ABSTRACT_CLASS(wxPyApp)
        
        public:
            wxPyApp() : wxApp() {
                m_assertMode = wxAPP_ASSERT_EXCEPTION;
                m_startupComplete = false;
                //m_callFilterEvent = false;
                wxApp::SetInstance(this);
            }
        
            ~wxPyApp() {
                wxApp::SetInstance(NULL);
            }
        
        
        #ifndef __WXMAC__
            virtual void MacNewFile() {}
            virtual void MacOpenFile(const wxString &) {}
            virtual void MacOpenFiles(const wxArrayString& fileNames) {}
            virtual void MacOpenURL(const wxString &) {}
            virtual void MacPrintFile(const wxString &) {}
            virtual void MacReopenApp() {}
            virtual bool OSXIsGUIApplication() { return true; }
            void OSXEnableAutomaticTabbing(bool) {}
        #endif
        
        #ifdef __WXMAC__
            static long GetMacAboutMenuItemId()               { return s_macAboutMenuItemId; }
            static long GetMacPreferencesMenuItemId()         { return s_macPreferencesMenuItemId; }
            static long GetMacExitMenuItemId()                { return s_macExitMenuItemId; }
            static wxString GetMacHelpMenuTitleName()         { return s_macHelpMenuTitleName; }
            static void SetMacAboutMenuItemId(long val)       { s_macAboutMenuItemId = val; }
            static void SetMacPreferencesMenuItemId(long val) { s_macPreferencesMenuItemId = val; }
            static void SetMacExitMenuItemId(long val)        { s_macExitMenuItemId = val; }
            static void SetMacHelpMenuTitleName(const wxString& val) { s_macHelpMenuTitleName = val; }
        #else
            static long GetMacAboutMenuItemId()               { return 0; }
            static long GetMacPreferencesMenuItemId()         { return 0; }
            static long GetMacExitMenuItemId()                { return 0; }
            static wxString GetMacHelpMenuTitleName()         { return wxEmptyString; }
            static void SetMacAboutMenuItemId(long)           { }
            static void SetMacPreferencesMenuItemId(long)     { }
            static void SetMacExitMenuItemId(long)            { }
            static void SetMacHelpMenuTitleName(const wxString&) { }
        #endif
        
            wxAppAssertMode  GetAssertMode() { return m_assertMode; }
            void SetAssertMode(wxAppAssertMode mode) {
                m_assertMode = mode;
                if (mode & wxAPP_ASSERT_SUPPRESS)
                    wxDisableAsserts();
                else
                    wxSetDefaultAssertHandler();
            }
        
            virtual void OnAssertFailure(const wxChar *file,
                                         int line,
                                         const wxChar *func,
                                         const wxChar *cond,
                                         const wxChar *msg);
        
        
            // Implementing OnInit is optional for wxPython apps
            virtual bool OnInit()     { return true; }
            virtual void OnPreInit()  { }
        
            void _BootstrapApp();
            virtual int MainLoop();
        
            static bool IsDisplayAvailable();
        
            // implementation only
            void SetStartupComplete(bool val) { m_startupComplete = val; }
        
        private:
            wxAppAssertMode m_assertMode;
            bool m_startupComplete;
            //bool m_callFilterEvent;
        };
        
        IMPLEMENT_ABSTRACT_CLASS(wxPyApp, wxApp);
        
        extern PyObject* wxAssertionError;         // Exception object raised for wxASSERT failures
        
        
        void wxPyApp::OnAssertFailure(const wxChar *file,
                                      int line,
                                      const wxChar *func,
                                      const wxChar *cond,
                                      const wxChar *msg)
        {
            // ignore it?
            if (m_assertMode & wxAPP_ASSERT_SUPPRESS)
                return;
        
            // turn it into a Python exception?
            if (m_assertMode & wxAPP_ASSERT_EXCEPTION) {
                wxString buf;
                buf.Alloc(4096);
                buf.Printf(wxT("C++ assertion \"%s\" failed at %s(%d)"), cond, file, line);
                if ( func && *func )
                    buf << wxT(" in ") << func << wxT("()");
                if (msg != NULL)
                    buf << wxT(": ") << msg;
        
                // set the exception
                wxPyThreadBlocker blocker;
                PyObject* s = wx2PyString(buf);
                PyErr_SetObject(wxAssertionError, s);
                Py_DECREF(s);
        
                // Now when control returns to whatever API wrapper was called from
                // Python it should detect that an exception is set and will return
                // NULL, signalling the exception to Python.
            }
        
            // Send it to the normal log destination, but only if
            // not _DIALOG because it will call this too
            if ( (m_assertMode & wxAPP_ASSERT_LOG) && !(m_assertMode & wxAPP_ASSERT_DIALOG)) {
                wxString buf;
                buf.Alloc(4096);
                buf.Printf(wxT("%s(%d): assert \"%s\" failed"),
                           file, line, cond);
                if ( func && *func )
                    buf << wxT(" in ") << func << wxT("()");
                if (msg != NULL)
                    buf << wxT(": ") << msg;
                wxLogDebug(buf);
            }
        
            // do the normal wx assert dialog?
            if (m_assertMode & wxAPP_ASSERT_DIALOG)
                wxApp::OnAssertFailure(file, line, func, cond, msg);
        }
        
        
        void wxPyApp::_BootstrapApp()
        {
            static      bool haveInitialized = false;
            bool        result;
        
            // Only initialize wxWidgets once
            if (! haveInitialized) {
        
                // Copy the values in Python's sys.argv list to a C array of char* to
                // be passed to the wxEntryStart function below.
                #if PY_MAJOR_VERSION >= 3
                    #define argType   wchar_t
                #else
                    #define argType   char
                #endif
                int       argc = 0;
                argType** argv = NULL;
                {
                    wxPyThreadBlocker blocker;
                    PyObject* sysargv = PySys_GetObject("argv");
                    if (sysargv != NULL) {
                        argc = PyList_Size(sysargv);
                        argv = new argType*[argc+1];
                        int x;
                        for(x=0; x<argc; x++) {
                            PyObject *pyArg = PyList_GetItem(sysargv, x); // borrowed reference
                            // if there isn't anything in sys.argv[0] then set it to the python executable
                            if (x == 0 && PyObject_Length(pyArg) < 1)
                                pyArg = PySys_GetObject("executable");
                            #if PY_MAJOR_VERSION >= 3
                                int len = PyObject_Length(pyArg);
                                argv[x] = new argType[len+1];
                                wxPyUnicode_AsWideChar(pyArg, argv[x], len+1);
                            #else
                                argv[x] = strdup(PyBytes_AsString(pyArg));
                            #endif
                        }
                        argv[argc] = NULL;
                    }
                }
        
                // Initialize wxWidgets
        #ifdef __WXOSX__
                wxMacAutoreleasePool autoreleasePool;
        #endif
                result = wxEntryStart(argc, argv);
                // wxApp takes ownership of the argv array, don't delete it here
        
                if (! result)  {
                    wxPyThreadBlocker blocker;
                    PyErr_SetString(PyExc_SystemError,
                                      "wxEntryStart failed, unable to initialize wxWidgets!"
        #ifdef __WXGTK__
                                      "  (Is DISPLAY set properly?)"
        #endif
                        );
                    goto error;
                }
            }
            else {
                this->argc = 0;
            }
        
            // It's now ok to generate exceptions for assertion errors.
            SetStartupComplete(true);
        
            // Call the Python wxApp's OnPreInit and OnInit functions if they exist
            OnPreInit();
        
            // Only use CallOnInit the first time, otherwise it will block on [NSApp run] in wxOSX_Cocoa;
            if (! haveInitialized)
                result = CallOnInit();
            else
                result = OnInit();
        
        //#ifdef __WXOSX_COCOA__
        //    OSXSetInitWasCalled(true);  TODO: consider adding this method to wxApp
        //#endif
        
            if (! result) {
                wxPyErr_SetString(PyExc_SystemExit, "OnInit returned false, exiting...");
            }
        
            haveInitialized = true;
        
        error:
            return;
        }
        
        
        int wxPyApp::MainLoop()
        {
            int retval = 0;
        
            {
        #ifdef __WXOSX__
                wxMacAutoreleasePool autoreleasePool;
        #endif
                DeletePendingObjects();
            }
            bool initialized = wxTopLevelWindows.GetCount() != 0;
            if (initialized) {
                if ( m_exitOnFrameDelete == Later ) {
                    m_exitOnFrameDelete = Yes;
                }
        
                retval = wxApp::MainLoop();
                OnExit();
            }
            return retval;
        }
        
        
        // Function to test if the Display (or whatever is the platform equivallent)
        // can be connected to.
        bool wxPyApp::IsDisplayAvailable()
        {
        #ifdef __WXGTK__
            Display* display;
            display = XOpenDisplay(NULL);
            if (display == NULL)
                return false;
            XCloseDisplay(display);
            return true;
        #endif
        
        #ifdef __WXMAC__
            // This is adapted from Python's Mac/Modules/MacOS.c in the
            // MacOS_WMAvailable function.
            bool rv;
            ProcessSerialNumber psn;
        
            /*
            ** This is a fairly innocuous call to make if we don't have a window
            ** manager, or if we have no permission to talk to it. It will print
            ** a message on stderr, but at least it won't abort the process.
            ** It appears the function caches the result itself, and it's cheap, so
            ** no need for us to cache.
            */
        #ifdef kCGNullDirectDisplay
            /* On 10.1 CGMainDisplayID() isn't available, and
            ** kCGNullDirectDisplay isn't defined.
            */
            if (CGMainDisplayID() == 0) {
                rv = false;
            } else
        #endif
            {
                // Assume all is well... Until something better is found again.
                rv = true;
            }
            return rv;
        #endif
        
        #ifdef __WXMSW__
            // TODO...
            return true;
        #endif
        }
        
        
        
        wxAppConsole* wxGetApp()
        {
            return wxApp::GetInstance();
        }
    void _wxPyApp_GTKSuppressDiagnostics(int flags)
    {
        #ifdef __WXGTK__
            wxApp::GTKSuppressDiagnostics(flags);
        #endif
    }
    void _wxPyApp_GTKAllowDiagnosticsControl()
    {
        #ifdef __WXGTK__
            wxApp::GTKAllowDiagnosticsControl();
        #endif
    }
    void _wxPyApp_MacHideApp(wxPyApp* self)
    {
        #ifdef __WXMAC__
            self->MacHideApp();
        #endif
    }
    int _wxPyApp_GetComCtl32Version()
    {
        #ifdef __WXMSW__
            return wxApp::GetComCtl32Version();
        #else
            wxPyRaiseNotImplemented();
            return 0;
        #endif
    }


class sipwxPyApp : public  ::wxPyApp
{
public:
    sipwxPyApp();
    virtual ~sipwxPyApp();

    /*
     * There is a public method for every protected method visible from
     * this class.
     */
    bool sipProtectVirt_TryBefore(bool, ::wxEvent&);
    bool sipProtectVirt_TryAfter(bool, ::wxEvent&);

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    bool OnInitGui() SIP_OVERRIDE;
    void OnPreInit() SIP_OVERRIDE;
    bool OSXIsGUIApplication() SIP_OVERRIDE;
    void MacReopenApp() SIP_OVERRIDE;
    void MacPrintFile(const  ::wxString&) SIP_OVERRIDE;
    void MacOpenURL(const  ::wxString&) SIP_OVERRIDE;
    void MacOpenFile(const  ::wxString&) SIP_OVERRIDE;
    void MacOpenFiles(const  ::wxArrayString&) SIP_OVERRIDE;
    void MacNewFile() SIP_OVERRIDE;
    bool TryAfter( ::wxEvent&) SIP_OVERRIDE;
    bool TryBefore( ::wxEvent&) SIP_OVERRIDE;
    bool ProcessEvent( ::wxEvent&) SIP_OVERRIDE;
    int FilterEvent( ::wxEvent&) SIP_OVERRIDE;
    int MainLoop() SIP_OVERRIDE;
    void ExitMainLoop() SIP_OVERRIDE;
    bool UsesEventLoop() const SIP_OVERRIDE;
    void ProcessPendingEvents() SIP_OVERRIDE;
    void OnEventLoopEnter( ::wxEventLoopBase*) SIP_OVERRIDE;
    void OnEventLoopExit( ::wxEventLoopBase*) SIP_OVERRIDE;
    int OnExit() SIP_OVERRIDE;
    bool OnInit() SIP_OVERRIDE;
    int OnRun() SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxPyApp(const sipwxPyApp &);
    sipwxPyApp &operator = (const sipwxPyApp &);

    char sipPyMethods[22];
};

sipwxPyApp::sipwxPyApp():  ::wxPyApp(), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxPyApp::~sipwxPyApp()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

bool sipwxPyApp::OnInitGui()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[0], &sipPySelf, SIP_NULLPTR, sipName_OnInitGui);

    if (!sipMeth)
        return  ::wxPyApp::OnInitGui();

    extern bool sipVH__core_6(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_6(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxPyApp::OnPreInit()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[1], &sipPySelf, SIP_NULLPTR, sipName_OnPreInit);

    if (!sipMeth)
    {
         ::wxPyApp::OnPreInit();
        return;
    }

    extern void sipVH__core_57(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__core_57(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxPyApp::OSXIsGUIApplication()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[2], &sipPySelf, SIP_NULLPTR, sipName_OSXIsGUIApplication);

    if (!sipMeth)
        return  ::wxPyApp::OSXIsGUIApplication();

    extern bool sipVH__core_6(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_6(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxPyApp::MacReopenApp()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[3], &sipPySelf, SIP_NULLPTR, sipName_MacReopenApp);

    if (!sipMeth)
    {
         ::wxPyApp::MacReopenApp();
        return;
    }

    extern void sipVH__core_57(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__core_57(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxPyApp::MacPrintFile(const  ::wxString& fileName)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[4], &sipPySelf, SIP_NULLPTR, sipName_MacPrintFile);

    if (!sipMeth)
    {
         ::wxPyApp::MacPrintFile(fileName);
        return;
    }

    extern void sipVH__core_60(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&);

    sipVH__core_60(sipGILState, 0, sipPySelf, sipMeth, fileName);
}

void sipwxPyApp::MacOpenURL(const  ::wxString& url)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[5], &sipPySelf, SIP_NULLPTR, sipName_MacOpenURL);

    if (!sipMeth)
    {
         ::wxPyApp::MacOpenURL(url);
        return;
    }

    extern void sipVH__core_60(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&);

    sipVH__core_60(sipGILState, 0, sipPySelf, sipMeth, url);
}

void sipwxPyApp::MacOpenFile(const  ::wxString& fileName)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[6], &sipPySelf, SIP_NULLPTR, sipName_MacOpenFile);

    if (!sipMeth)
    {
         ::wxPyApp::MacOpenFile(fileName);
        return;
    }

    extern void sipVH__core_60(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&);

    sipVH__core_60(sipGILState, 0, sipPySelf, sipMeth, fileName);
}

void sipwxPyApp::MacOpenFiles(const  ::wxArrayString& fileNames)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[7], &sipPySelf, SIP_NULLPTR, sipName_MacOpenFiles);

    if (!sipMeth)
    {
         ::wxPyApp::MacOpenFiles(fileNames);
        return;
    }

    extern void sipVH__core_122(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxArrayString&);

    sipVH__core_122(sipGILState, 0, sipPySelf, sipMeth, fileNames);
}

void sipwxPyApp::MacNewFile()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[8], &sipPySelf, SIP_NULLPTR, sipName_MacNewFile);

    if (!sipMeth)
    {
         ::wxPyApp::MacNewFile();
        return;
    }

    extern void sipVH__core_57(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__core_57(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxPyApp::TryAfter( ::wxEvent& event)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[9], &sipPySelf, SIP_NULLPTR, sipName_TryAfter);

    if (!sipMeth)
        return  ::wxPyApp::TryAfter(event);

    extern bool sipVH__core_102(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxEvent&);

    return sipVH__core_102(sipGILState, 0, sipPySelf, sipMeth, event);
}

bool sipwxPyApp::TryBefore( ::wxEvent& event)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[10], &sipPySelf, SIP_NULLPTR, sipName_TryBefore);

    if (!sipMeth)
        return  ::wxPyApp::TryBefore(event);

    extern bool sipVH__core_102(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxEvent&);

    return sipVH__core_102(sipGILState, 0, sipPySelf, sipMeth, event);
}

bool sipwxPyApp::ProcessEvent( ::wxEvent& event)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[11], &sipPySelf, SIP_NULLPTR, sipName_ProcessEvent);

    if (!sipMeth)
        return  ::wxPyApp::ProcessEvent(event);

    extern bool sipVH__core_102(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxEvent&);

    return sipVH__core_102(sipGILState, 0, sipPySelf, sipMeth, event);
}

int sipwxPyApp::FilterEvent( ::wxEvent& event)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[12], &sipPySelf, SIP_NULLPTR, sipName_FilterEvent);

    if (!sipMeth)
        return  ::wxPyApp::FilterEvent(event);

    extern int sipVH__core_110(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxEvent&);

    return sipVH__core_110(sipGILState, 0, sipPySelf, sipMeth, event);
}

int sipwxPyApp::MainLoop()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[13], &sipPySelf, SIP_NULLPTR, sipName_MainLoop);

    if (!sipMeth)
        return  ::wxPyApp::MainLoop();

    extern int sipVH__core_111(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_111(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxPyApp::ExitMainLoop()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[14], &sipPySelf, SIP_NULLPTR, sipName_ExitMainLoop);

    if (!sipMeth)
    {
         ::wxPyApp::ExitMainLoop();
        return;
    }

    extern void sipVH__core_57(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__core_57(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxPyApp::UsesEventLoop() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[15]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_UsesEventLoop);

    if (!sipMeth)
        return  ::wxPyApp::UsesEventLoop();

    extern bool sipVH__core_6(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_6(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxPyApp::ProcessPendingEvents()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[16], &sipPySelf, SIP_NULLPTR, sipName_ProcessPendingEvents);

    if (!sipMeth)
    {
         ::wxPyApp::ProcessPendingEvents();
        return;
    }

    extern void sipVH__core_57(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__core_57(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxPyApp::OnEventLoopEnter( ::wxEventLoopBase*loop)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[17], &sipPySelf, SIP_NULLPTR, sipName_OnEventLoopEnter);

    if (!sipMeth)
    {
         ::wxPyApp::OnEventLoopEnter(loop);
        return;
    }

    extern void sipVH__core_121(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxEventLoopBase*);

    sipVH__core_121(sipGILState, 0, sipPySelf, sipMeth, loop);
}

void sipwxPyApp::OnEventLoopExit( ::wxEventLoopBase*loop)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[18], &sipPySelf, SIP_NULLPTR, sipName_OnEventLoopExit);

    if (!sipMeth)
    {
         ::wxPyApp::OnEventLoopExit(loop);
        return;
    }

    extern void sipVH__core_121(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxEventLoopBase*);

    sipVH__core_121(sipGILState, 0, sipPySelf, sipMeth, loop);
}

int sipwxPyApp::OnExit()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[19], &sipPySelf, SIP_NULLPTR, sipName_OnExit);

    if (!sipMeth)
        return  ::wxPyApp::OnExit();

    extern int sipVH__core_111(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_111(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxPyApp::OnInit()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[20], &sipPySelf, SIP_NULLPTR, sipName_OnInit);

    if (!sipMeth)
        return  ::wxPyApp::OnInit();

    extern bool sipVH__core_6(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_6(sipGILState, 0, sipPySelf, sipMeth);
}

int sipwxPyApp::OnRun()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[21], &sipPySelf, SIP_NULLPTR, sipName_OnRun);

    if (!sipMeth)
        return  ::wxPyApp::OnRun();

    extern int sipVH__core_111(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_111(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxPyApp::sipProtectVirt_TryBefore(bool sipSelfWasArg, ::wxEvent& event)
{
    return (sipSelfWasArg ?  ::wxPyApp::TryBefore(event) : TryBefore(event));
}

bool sipwxPyApp::sipProtectVirt_TryAfter(bool sipSelfWasArg, ::wxEvent& event)
{
    return (sipSelfWasArg ?  ::wxPyApp::TryAfter(event) : TryAfter(event));
}


PyDoc_STRVAR(doc_wxPyApp_GTKSuppressDiagnostics, "GTKSuppressDiagnostics(flags=-1)\n"
"\n"
"Disables the printing of various GTK messages.");

extern "C" {static PyObject *meth_wxPyApp_GTKSuppressDiagnostics(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_GTKSuppressDiagnostics(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int flags = -1;

        static const char *sipKwdList[] = {
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "|i", &flags))
        {
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxPyApp_GTKSuppressDiagnostics(flags);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_GTKSuppressDiagnostics, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_GTKAllowDiagnosticsControl, "GTKAllowDiagnosticsControl()\n"
"\n"
"Allows wxWidgets to selectively suppress some GTK messages.");

extern "C" {static PyObject *meth_wxPyApp_GTKAllowDiagnosticsControl(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_GTKAllowDiagnosticsControl(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxPyApp_GTKAllowDiagnosticsControl();
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_GTKAllowDiagnosticsControl, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_MacNewFile, "MacNewFile()\n"
"\n"
"Called in response of an \"open-application\" Apple event.");

extern "C" {static PyObject *meth_wxPyApp_MacNewFile(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_MacNewFile(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxPyApp::MacNewFile() : sipCpp->MacNewFile());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_MacNewFile, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_MacOpenFiles, "MacOpenFiles(fileNames)\n"
"\n"
"Called in response of an openFiles message.");

extern "C" {static PyObject *meth_wxPyApp_MacOpenFiles(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_MacOpenFiles(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxArrayString* fileNames;
        int fileNamesState = 0;
         ::wxPyApp *sipCpp;

        static const char *sipKwdList[] = {
            sipName_fileNames,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPyApp, &sipCpp, sipType_wxArrayString, &fileNames, &fileNamesState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxPyApp::MacOpenFiles(*fileNames) : sipCpp->MacOpenFiles(*fileNames));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxArrayString *>(fileNames), sipType_wxArrayString, fileNamesState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_MacOpenFiles, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_MacOpenFile, "MacOpenFile(fileName)\n"
"\n"
"Called in response of an \"open-document\" Apple event.");

extern "C" {static PyObject *meth_wxPyApp_MacOpenFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_MacOpenFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString* fileName;
        int fileNameState = 0;
         ::wxPyApp *sipCpp;

        static const char *sipKwdList[] = {
            sipName_fileName,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPyApp, &sipCpp, sipType_wxString, &fileName, &fileNameState))
        {
            if (sipDeprecated(sipName_PyApp,sipName_MacOpenFile) < 0)
                return SIP_NULLPTR;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxPyApp::MacOpenFile(*fileName) : sipCpp->MacOpenFile(*fileName));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(fileName), sipType_wxString, fileNameState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_MacOpenFile, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_MacOpenURL, "MacOpenURL(url)\n"
"\n"
"Called in response of a \"get-url\" Apple event.");

extern "C" {static PyObject *meth_wxPyApp_MacOpenURL(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_MacOpenURL(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString* url;
        int urlState = 0;
         ::wxPyApp *sipCpp;

        static const char *sipKwdList[] = {
            sipName_url,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPyApp, &sipCpp, sipType_wxString, &url, &urlState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxPyApp::MacOpenURL(*url) : sipCpp->MacOpenURL(*url));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(url), sipType_wxString, urlState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_MacOpenURL, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_MacPrintFile, "MacPrintFile(fileName)\n"
"\n"
"Called in response of a \"print-document\" Apple event.");

extern "C" {static PyObject *meth_wxPyApp_MacPrintFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_MacPrintFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString* fileName;
        int fileNameState = 0;
         ::wxPyApp *sipCpp;

        static const char *sipKwdList[] = {
            sipName_fileName,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPyApp, &sipCpp, sipType_wxString, &fileName, &fileNameState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxPyApp::MacPrintFile(*fileName) : sipCpp->MacPrintFile(*fileName));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(fileName), sipType_wxString, fileNameState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_MacPrintFile, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_MacReopenApp, "MacReopenApp()\n"
"\n"
"Called in response of a \"reopen-application\" Apple event.");

extern "C" {static PyObject *meth_wxPyApp_MacReopenApp(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_MacReopenApp(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxPyApp::MacReopenApp() : sipCpp->MacReopenApp());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_MacReopenApp, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_OSXIsGUIApplication, "OSXIsGUIApplication() -> bool\n"
"\n"
"May be overridden to indicate that the application is not a foreground\n"
"GUI application under macOS.");

extern "C" {static PyObject *meth_wxPyApp_OSXIsGUIApplication(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_OSXIsGUIApplication(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxPyApp::OSXIsGUIApplication() : sipCpp->OSXIsGUIApplication());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_OSXIsGUIApplication, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_OSXEnableAutomaticTabbing, "OSXEnableAutomaticTabbing(enable)\n"
"\n"
"Enable the automatic tabbing features of macOS.");

extern "C" {static PyObject *meth_wxPyApp_OSXEnableAutomaticTabbing(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_OSXEnableAutomaticTabbing(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool enable;
         ::wxPyApp *sipCpp;

        static const char *sipKwdList[] = {
            sipName_enable,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxPyApp, &sipCpp, &enable))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->OSXEnableAutomaticTabbing(enable);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_OSXEnableAutomaticTabbing, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_GetDisplayMode, "GetDisplayMode() -> VideoMode\n"
"\n"
"Get display mode that is used use.");

extern "C" {static PyObject *meth_wxPyApp_GetDisplayMode(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_GetDisplayMode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
             ::wxVideoMode*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxVideoMode(sipCpp->GetDisplayMode());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxVideoMode,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_GetDisplayMode, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_GetExitOnFrameDelete, "GetExitOnFrameDelete() -> bool\n"
"\n"
"Returns true if the application will exit when the top-level frame is\n"
"deleted.");

extern "C" {static PyObject *meth_wxPyApp_GetExitOnFrameDelete(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_GetExitOnFrameDelete(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetExitOnFrameDelete();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_GetExitOnFrameDelete, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_GetLayoutDirection, "GetLayoutDirection() -> LayoutDirection\n"
"\n"
"Return the layout direction for the current locale or wxLayout_Default\n"
"if it's unknown.");

extern "C" {static PyObject *meth_wxPyApp_GetLayoutDirection(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_GetLayoutDirection(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
             ::wxLayoutDirection sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetLayoutDirection();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxLayoutDirection);
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_GetLayoutDirection, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_GetUseBestVisual, "GetUseBestVisual() -> bool\n"
"\n"
"Returns true if the application will use the best visual on systems\n"
"that support different visuals, false otherwise.");

extern "C" {static PyObject *meth_wxPyApp_GetUseBestVisual(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_GetUseBestVisual(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetUseBestVisual();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_GetUseBestVisual, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_GetTopWindow, "GetTopWindow() -> Window\n"
"\n"
"Returns a pointer to the top window.");

extern "C" {static PyObject *meth_wxPyApp_GetTopWindow(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_GetTopWindow(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
             ::wxWindow*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetTopWindow();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxWindow,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_GetTopWindow, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_IsActive, "IsActive() -> bool\n"
"\n"
"Returns true if the application is active, i.e. if one of its windows\n"
"is currently in the foreground.");

extern "C" {static PyObject *meth_wxPyApp_IsActive(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_IsActive(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsActive();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_IsActive, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_SafeYield, "SafeYield(win, onlyIfNeeded) -> bool\n"
"\n"
"This function is similar to wxYield(), except that it disables the\n"
"user input to all program windows before calling wxAppConsole::Yield\n"
"and re-enables it again afterwards.");

extern "C" {static PyObject *meth_wxPyApp_SafeYield(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_SafeYield(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxWindow* win;
        bool onlyIfNeeded;
         ::wxPyApp *sipCpp;

        static const char *sipKwdList[] = {
            sipName_win,
            sipName_onlyIfNeeded,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8b", &sipSelf, sipType_wxPyApp, &sipCpp, sipType_wxWindow, &win, &onlyIfNeeded))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SafeYield(win,onlyIfNeeded);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_SafeYield, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_SafeYieldFor, "SafeYieldFor(win, eventsToProcess) -> bool\n"
"\n"
"Works like SafeYield() with onlyIfNeeded == true except that it allows\n"
"the caller to specify a mask of events to be processed.");

extern "C" {static PyObject *meth_wxPyApp_SafeYieldFor(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_SafeYieldFor(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxWindow* win;
        long eventsToProcess;
         ::wxPyApp *sipCpp;

        static const char *sipKwdList[] = {
            sipName_win,
            sipName_eventsToProcess,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8l", &sipSelf, sipType_wxPyApp, &sipCpp, sipType_wxWindow, &win, &eventsToProcess))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SafeYieldFor(win,eventsToProcess);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_SafeYieldFor, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_SetDisplayMode, "SetDisplayMode(info) -> bool\n"
"\n"
"Set display mode to use.");

extern "C" {static PyObject *meth_wxPyApp_SetDisplayMode(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_SetDisplayMode(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxVideoMode* info;
         ::wxPyApp *sipCpp;

        static const char *sipKwdList[] = {
            sipName_info,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxPyApp, &sipCpp, sipType_wxVideoMode, &info))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetDisplayMode(*info);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_SetDisplayMode, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_SetExitOnFrameDelete, "SetExitOnFrameDelete(flag)\n"
"\n"
"Allows the programmer to specify whether the application will exit\n"
"when the top-level frame is deleted.");

extern "C" {static PyObject *meth_wxPyApp_SetExitOnFrameDelete(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_SetExitOnFrameDelete(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool flag;
         ::wxPyApp *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flag,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxPyApp, &sipCpp, &flag))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetExitOnFrameDelete(flag);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_SetExitOnFrameDelete, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_SetNativeTheme, "SetNativeTheme(theme) -> bool\n"
"\n"
"Allows runtime switching of the UI environment theme.");

extern "C" {static PyObject *meth_wxPyApp_SetNativeTheme(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_SetNativeTheme(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* theme;
        int themeState = 0;
         ::wxPyApp *sipCpp;

        static const char *sipKwdList[] = {
            sipName_theme,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPyApp, &sipCpp, sipType_wxString, &theme, &themeState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetNativeTheme(*theme);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(theme), sipType_wxString, themeState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_SetNativeTheme, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_SetTopWindow, "SetTopWindow(window)\n"
"\n"
"Sets the 'top' window.");

extern "C" {static PyObject *meth_wxPyApp_SetTopWindow(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_SetTopWindow(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxWindow* window;
         ::wxPyApp *sipCpp;

        static const char *sipKwdList[] = {
            sipName_window,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxPyApp, &sipCpp, sipType_wxWindow, &window))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetTopWindow(window);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_SetTopWindow, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_SetUseBestVisual, "SetUseBestVisual(flag, forceTrueColour=False)\n"
"\n"
"Allows the programmer to specify whether the application will use the\n"
"best visual on systems that support several visual on the same\n"
"display.");

extern "C" {static PyObject *meth_wxPyApp_SetUseBestVisual(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_SetUseBestVisual(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool flag;
        bool forceTrueColour = 0;
         ::wxPyApp *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flag,
            sipName_forceTrueColour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb|b", &sipSelf, sipType_wxPyApp, &sipCpp, &flag, &forceTrueColour))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetUseBestVisual(flag,forceTrueColour);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_SetUseBestVisual, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_GetMainTopWindow, "GetMainTopWindow() -> Window\n"
"\n"
"Returns a pointer to the top application window if any.");

extern "C" {static PyObject *meth_wxPyApp_GetMainTopWindow(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_GetMainTopWindow(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::wxWindow*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxPyApp::GetMainTopWindow();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxWindow,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_GetMainTopWindow, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_MacHideApp, "MacHideApp()\n"
"\n"
"Hide all application windows just as the user can do with the\n"
"system Hide command.  Mac only.");

extern "C" {static PyObject *meth_wxPyApp_MacHideApp(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_MacHideApp(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxPyApp_MacHideApp(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_MacHideApp, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_GetComCtl32Version, "GetComCtl32Version() -> int\n"
"\n"
"Returns 400, 470, 471, etc. for comctl32.dll 4.00, 4.70, 4.71 or 0 if\n"
"it wasn't found at all.  Raises an exception on non-Windows platforms.");

extern "C" {static PyObject *meth_wxPyApp_GetComCtl32Version(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_GetComCtl32Version(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            int sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxPyApp_GetComCtl32Version();
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_GetComCtl32Version, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_TryBefore, "TryBefore(self, event: Event) -> bool");

extern "C" {static PyObject *meth_wxPyApp_TryBefore(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_TryBefore(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxEvent* event;
        sipwxPyApp *sipCpp;

        static const char *sipKwdList[] = {
            sipName_event,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxPyApp, &sipCpp, sipType_wxEvent, &event))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtectVirt_TryBefore(sipSelfWasArg,*event);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_TryBefore, doc_wxPyApp_TryBefore);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_TryAfter, "TryAfter(self, event: Event) -> bool");

extern "C" {static PyObject *meth_wxPyApp_TryAfter(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_TryAfter(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxEvent* event;
        sipwxPyApp *sipCpp;

        static const char *sipKwdList[] = {
            sipName_event,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxPyApp, &sipCpp, sipType_wxEvent, &event))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtectVirt_TryAfter(sipSelfWasArg,*event);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_TryAfter, doc_wxPyApp_TryAfter);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_MainLoop, "MainLoop(self) -> int");

extern "C" {static PyObject *meth_wxPyApp_MainLoop(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_MainLoop(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxPyApp::MainLoop() : sipCpp->MainLoop());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_MainLoop, doc_wxPyApp_MainLoop);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_OnPreInit, "OnPreInit(self)");

extern "C" {static PyObject *meth_wxPyApp_OnPreInit(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_OnPreInit(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxPyApp::OnPreInit() : sipCpp->OnPreInit());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_OnPreInit, doc_wxPyApp_OnPreInit);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_OnInit, "OnInit(self) -> bool");

extern "C" {static PyObject *meth_wxPyApp_OnInit(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_OnInit(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxPyApp::OnInit() : sipCpp->OnInit());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_OnInit, doc_wxPyApp_OnInit);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_OnInitGui, "OnInitGui(self) -> bool");

extern "C" {static PyObject *meth_wxPyApp_OnInitGui(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_OnInitGui(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxPyApp::OnInitGui() : sipCpp->OnInitGui());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_OnInitGui, doc_wxPyApp_OnInitGui);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_OnRun, "OnRun(self) -> int");

extern "C" {static PyObject *meth_wxPyApp_OnRun(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_OnRun(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxPyApp::OnRun() : sipCpp->OnRun());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_OnRun, doc_wxPyApp_OnRun);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_OnExit, "OnExit(self) -> int");

extern "C" {static PyObject *meth_wxPyApp_OnExit(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_OnExit(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxPyApp::OnExit() : sipCpp->OnExit());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_OnExit, doc_wxPyApp_OnExit);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp__BootstrapApp, "_BootstrapApp(self)");

extern "C" {static PyObject *meth_wxPyApp__BootstrapApp(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp__BootstrapApp(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->_BootstrapApp();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName__BootstrapApp, doc_wxPyApp__BootstrapApp);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_GetMacAboutMenuItemId, "GetMacAboutMenuItemId() -> int");

extern "C" {static PyObject *meth_wxPyApp_GetMacAboutMenuItemId(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_GetMacAboutMenuItemId(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxPyApp::GetMacAboutMenuItemId();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_GetMacAboutMenuItemId, doc_wxPyApp_GetMacAboutMenuItemId);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_GetMacPreferencesMenuItemId, "GetMacPreferencesMenuItemId() -> int");

extern "C" {static PyObject *meth_wxPyApp_GetMacPreferencesMenuItemId(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_GetMacPreferencesMenuItemId(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxPyApp::GetMacPreferencesMenuItemId();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_GetMacPreferencesMenuItemId, doc_wxPyApp_GetMacPreferencesMenuItemId);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_GetMacExitMenuItemId, "GetMacExitMenuItemId() -> int");

extern "C" {static PyObject *meth_wxPyApp_GetMacExitMenuItemId(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_GetMacExitMenuItemId(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxPyApp::GetMacExitMenuItemId();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_GetMacExitMenuItemId, doc_wxPyApp_GetMacExitMenuItemId);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_GetMacHelpMenuTitleName, "GetMacHelpMenuTitleName() -> object");

extern "C" {static PyObject *meth_wxPyApp_GetMacHelpMenuTitleName(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_GetMacHelpMenuTitleName(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString( ::wxPyApp::GetMacHelpMenuTitleName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_GetMacHelpMenuTitleName, doc_wxPyApp_GetMacHelpMenuTitleName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_SetMacAboutMenuItemId, "SetMacAboutMenuItemId(val: int)");

extern "C" {static PyObject *meth_wxPyApp_SetMacAboutMenuItemId(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_SetMacAboutMenuItemId(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long val;

        static const char *sipKwdList[] = {
            sipName_val,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "l", &val))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxPyApp::SetMacAboutMenuItemId(val);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_SetMacAboutMenuItemId, doc_wxPyApp_SetMacAboutMenuItemId);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_SetMacPreferencesMenuItemId, "SetMacPreferencesMenuItemId(val: int)");

extern "C" {static PyObject *meth_wxPyApp_SetMacPreferencesMenuItemId(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_SetMacPreferencesMenuItemId(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long val;

        static const char *sipKwdList[] = {
            sipName_val,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "l", &val))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxPyApp::SetMacPreferencesMenuItemId(val);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_SetMacPreferencesMenuItemId, doc_wxPyApp_SetMacPreferencesMenuItemId);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_SetMacExitMenuItemId, "SetMacExitMenuItemId(val: int)");

extern "C" {static PyObject *meth_wxPyApp_SetMacExitMenuItemId(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_SetMacExitMenuItemId(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long val;

        static const char *sipKwdList[] = {
            sipName_val,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "l", &val))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxPyApp::SetMacExitMenuItemId(val);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_SetMacExitMenuItemId, doc_wxPyApp_SetMacExitMenuItemId);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_SetMacHelpMenuTitleName, "SetMacHelpMenuTitleName(val: object)");

extern "C" {static PyObject *meth_wxPyApp_SetMacHelpMenuTitleName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_SetMacHelpMenuTitleName(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* val;
        int valState = 0;

        static const char *sipKwdList[] = {
            sipName_val,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1", sipType_wxString, &val, &valState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxPyApp::SetMacHelpMenuTitleName(*val);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(val), sipType_wxString, valState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_SetMacHelpMenuTitleName, doc_wxPyApp_SetMacHelpMenuTitleName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_GetAssertMode, "GetAssertMode() -> AppAssertMode\n"
"\n"
"Returns the current mode for how the application responds to wx\n"
"asserts.");

extern "C" {static PyObject *meth_wxPyApp_GetAssertMode(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_GetAssertMode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxPyApp *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPyApp, &sipCpp))
        {
             ::wxAppAssertMode sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetAssertMode();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxAppAssertMode);
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_GetAssertMode, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_SetAssertMode, "SetAssertMode(wxAppAssertMode)\n"
"\n"
"Set the mode indicating how the application responds to wx assertion\n"
"statements. Valid settings are a combination of these flags:\n"
"\n"
"    - wx.APP_ASSERT_SUPPRESS\n"
"    - wx.APP_ASSERT_EXCEPTION\n"
"    - wx.APP_ASSERT_DIALOG\n"
"    - wx.APP_ASSERT_LOG\n"
"\n"
"The default behavior is to raise a wx.wxAssertionError exception.");

extern "C" {static PyObject *meth_wxPyApp_SetAssertMode(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_SetAssertMode(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxAppAssertMode wxAppAssertMode;
         ::wxPyApp *sipCpp;

        static const char *sipKwdList[] = {
            sipName_wxAppAssertMode,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxPyApp, &sipCpp, sipType_wxAppAssertMode, &wxAppAssertMode))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetAssertMode(wxAppAssertMode);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_SetAssertMode, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPyApp_IsDisplayAvailable, "IsDisplayAvailable() -> bool\n"
"\n"
"Returns True if the application is able to connect to the system's\n"
"display, or whatever the equivallent is for the platform.");

extern "C" {static PyObject *meth_wxPyApp_IsDisplayAvailable(PyObject *, PyObject *);}
static PyObject *meth_wxPyApp_IsDisplayAvailable(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxPyApp::IsDisplayAvailable();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PyApp, sipName_IsDisplayAvailable, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxPyApp(void *, const sipTypeDef *);}
static void *cast_wxPyApp(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxPyApp *sipCpp = reinterpret_cast< ::wxPyApp *>(sipCppV);

    if (targetType == sipType_wxPyApp)
        return sipCppV;

    sipCppV = ((const sipClassTypeDef *)sipType_wxAppConsole)->ctd_cast(static_cast< ::wxAppConsole *>(sipCpp), targetType);
    if (sipCppV)
        return sipCppV;

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxPyApp(void *, int);}
static void release_wxPyApp(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxPyApp *>(sipCppV);
    else
        delete reinterpret_cast< ::wxPyApp *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxPyApp(Py_ssize_t);}
static void *array_wxPyApp(Py_ssize_t sipNrElem)
{
    return new  ::wxPyApp[sipNrElem];
}


extern "C" {static void dealloc_wxPyApp(sipSimpleWrapper *);}
static void dealloc_wxPyApp(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxPyApp *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxPyApp(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxPyApp(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxPyApp(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxPyApp *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxPyApp();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxPyApp[] = {{20, 255, 1}};


static PyMethodDef methods_wxPyApp[] = {
    {sipName_GTKAllowDiagnosticsControl, meth_wxPyApp_GTKAllowDiagnosticsControl, METH_VARARGS, doc_wxPyApp_GTKAllowDiagnosticsControl},
    {sipName_GTKSuppressDiagnostics, SIP_MLMETH_CAST(meth_wxPyApp_GTKSuppressDiagnostics), METH_VARARGS|METH_KEYWORDS, doc_wxPyApp_GTKSuppressDiagnostics},
    {sipName_GetAssertMode, meth_wxPyApp_GetAssertMode, METH_VARARGS, doc_wxPyApp_GetAssertMode},
    {sipName_GetComCtl32Version, meth_wxPyApp_GetComCtl32Version, METH_VARARGS, doc_wxPyApp_GetComCtl32Version},
    {sipName_GetDisplayMode, meth_wxPyApp_GetDisplayMode, METH_VARARGS, doc_wxPyApp_GetDisplayMode},
    {sipName_GetExitOnFrameDelete, meth_wxPyApp_GetExitOnFrameDelete, METH_VARARGS, doc_wxPyApp_GetExitOnFrameDelete},
    {sipName_GetLayoutDirection, meth_wxPyApp_GetLayoutDirection, METH_VARARGS, doc_wxPyApp_GetLayoutDirection},
    {sipName_GetMacAboutMenuItemId, meth_wxPyApp_GetMacAboutMenuItemId, METH_VARARGS, doc_wxPyApp_GetMacAboutMenuItemId},
    {sipName_GetMacExitMenuItemId, meth_wxPyApp_GetMacExitMenuItemId, METH_VARARGS, doc_wxPyApp_GetMacExitMenuItemId},
    {sipName_GetMacHelpMenuTitleName, meth_wxPyApp_GetMacHelpMenuTitleName, METH_VARARGS, doc_wxPyApp_GetMacHelpMenuTitleName},
    {sipName_GetMacPreferencesMenuItemId, meth_wxPyApp_GetMacPreferencesMenuItemId, METH_VARARGS, doc_wxPyApp_GetMacPreferencesMenuItemId},
    {sipName_GetMainTopWindow, meth_wxPyApp_GetMainTopWindow, METH_VARARGS, doc_wxPyApp_GetMainTopWindow},
    {sipName_GetTopWindow, meth_wxPyApp_GetTopWindow, METH_VARARGS, doc_wxPyApp_GetTopWindow},
    {sipName_GetUseBestVisual, meth_wxPyApp_GetUseBestVisual, METH_VARARGS, doc_wxPyApp_GetUseBestVisual},
    {sipName_IsActive, meth_wxPyApp_IsActive, METH_VARARGS, doc_wxPyApp_IsActive},
    {sipName_IsDisplayAvailable, meth_wxPyApp_IsDisplayAvailable, METH_VARARGS, doc_wxPyApp_IsDisplayAvailable},
    {sipName_MacHideApp, meth_wxPyApp_MacHideApp, METH_VARARGS, doc_wxPyApp_MacHideApp},
    {sipName_MacNewFile, meth_wxPyApp_MacNewFile, METH_VARARGS, doc_wxPyApp_MacNewFile},
    {sipName_MacOpenFile, SIP_MLMETH_CAST(meth_wxPyApp_MacOpenFile), METH_VARARGS|METH_KEYWORDS, doc_wxPyApp_MacOpenFile},
    {sipName_MacOpenFiles, SIP_MLMETH_CAST(meth_wxPyApp_MacOpenFiles), METH_VARARGS|METH_KEYWORDS, doc_wxPyApp_MacOpenFiles},
    {sipName_MacOpenURL, SIP_MLMETH_CAST(meth_wxPyApp_MacOpenURL), METH_VARARGS|METH_KEYWORDS, doc_wxPyApp_MacOpenURL},
    {sipName_MacPrintFile, SIP_MLMETH_CAST(meth_wxPyApp_MacPrintFile), METH_VARARGS|METH_KEYWORDS, doc_wxPyApp_MacPrintFile},
    {sipName_MacReopenApp, meth_wxPyApp_MacReopenApp, METH_VARARGS, doc_wxPyApp_MacReopenApp},
    {sipName_MainLoop, meth_wxPyApp_MainLoop, METH_VARARGS, doc_wxPyApp_MainLoop},
    {sipName_OSXEnableAutomaticTabbing, SIP_MLMETH_CAST(meth_wxPyApp_OSXEnableAutomaticTabbing), METH_VARARGS|METH_KEYWORDS, doc_wxPyApp_OSXEnableAutomaticTabbing},
    {sipName_OSXIsGUIApplication, meth_wxPyApp_OSXIsGUIApplication, METH_VARARGS, doc_wxPyApp_OSXIsGUIApplication},
    {sipName_OnExit, meth_wxPyApp_OnExit, METH_VARARGS, doc_wxPyApp_OnExit},
    {sipName_OnInit, meth_wxPyApp_OnInit, METH_VARARGS, doc_wxPyApp_OnInit},
    {sipName_OnInitGui, meth_wxPyApp_OnInitGui, METH_VARARGS, doc_wxPyApp_OnInitGui},
    {sipName_OnPreInit, meth_wxPyApp_OnPreInit, METH_VARARGS, doc_wxPyApp_OnPreInit},
    {sipName_OnRun, meth_wxPyApp_OnRun, METH_VARARGS, doc_wxPyApp_OnRun},
    {sipName_SafeYield, SIP_MLMETH_CAST(meth_wxPyApp_SafeYield), METH_VARARGS|METH_KEYWORDS, doc_wxPyApp_SafeYield},
    {sipName_SafeYieldFor, SIP_MLMETH_CAST(meth_wxPyApp_SafeYieldFor), METH_VARARGS|METH_KEYWORDS, doc_wxPyApp_SafeYieldFor},
    {sipName_SetAssertMode, SIP_MLMETH_CAST(meth_wxPyApp_SetAssertMode), METH_VARARGS|METH_KEYWORDS, doc_wxPyApp_SetAssertMode},
    {sipName_SetDisplayMode, SIP_MLMETH_CAST(meth_wxPyApp_SetDisplayMode), METH_VARARGS|METH_KEYWORDS, doc_wxPyApp_SetDisplayMode},
    {sipName_SetExitOnFrameDelete, SIP_MLMETH_CAST(meth_wxPyApp_SetExitOnFrameDelete), METH_VARARGS|METH_KEYWORDS, doc_wxPyApp_SetExitOnFrameDelete},
    {sipName_SetMacAboutMenuItemId, SIP_MLMETH_CAST(meth_wxPyApp_SetMacAboutMenuItemId), METH_VARARGS|METH_KEYWORDS, doc_wxPyApp_SetMacAboutMenuItemId},
    {sipName_SetMacExitMenuItemId, SIP_MLMETH_CAST(meth_wxPyApp_SetMacExitMenuItemId), METH_VARARGS|METH_KEYWORDS, doc_wxPyApp_SetMacExitMenuItemId},
    {sipName_SetMacHelpMenuTitleName, SIP_MLMETH_CAST(meth_wxPyApp_SetMacHelpMenuTitleName), METH_VARARGS|METH_KEYWORDS, doc_wxPyApp_SetMacHelpMenuTitleName},
    {sipName_SetMacPreferencesMenuItemId, SIP_MLMETH_CAST(meth_wxPyApp_SetMacPreferencesMenuItemId), METH_VARARGS|METH_KEYWORDS, doc_wxPyApp_SetMacPreferencesMenuItemId},
    {sipName_SetNativeTheme, SIP_MLMETH_CAST(meth_wxPyApp_SetNativeTheme), METH_VARARGS|METH_KEYWORDS, doc_wxPyApp_SetNativeTheme},
    {sipName_SetTopWindow, SIP_MLMETH_CAST(meth_wxPyApp_SetTopWindow), METH_VARARGS|METH_KEYWORDS, doc_wxPyApp_SetTopWindow},
    {sipName_SetUseBestVisual, SIP_MLMETH_CAST(meth_wxPyApp_SetUseBestVisual), METH_VARARGS|METH_KEYWORDS, doc_wxPyApp_SetUseBestVisual},
    {sipName_TryAfter, SIP_MLMETH_CAST(meth_wxPyApp_TryAfter), METH_VARARGS|METH_KEYWORDS, doc_wxPyApp_TryAfter},
    {sipName_TryBefore, SIP_MLMETH_CAST(meth_wxPyApp_TryBefore), METH_VARARGS|METH_KEYWORDS, doc_wxPyApp_TryBefore},
    {sipName__BootstrapApp, meth_wxPyApp__BootstrapApp, METH_VARARGS, doc_wxPyApp__BootstrapApp}
};

sipVariableDef variables_wxPyApp[] = {
    {PropertyVariable, sipName_TopWindow, &methods_wxPyApp[12], &methods_wxPyApp[41], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_UseBestVisual, &methods_wxPyApp[13], &methods_wxPyApp[42], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_LayoutDirection, &methods_wxPyApp[6], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ExitOnFrameDelete, &methods_wxPyApp[5], &methods_wxPyApp[35], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_DisplayMode, &methods_wxPyApp[4], &methods_wxPyApp[34], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_AssertMode, &methods_wxPyApp[2], &methods_wxPyApp[33], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxPyApp, "PyApp()\n"
"\n"
"The wxApp class represents the application itself when wxUSE_GUI=1.");


sipClassTypeDef sipTypeDef__core_wxPyApp = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxPyApp,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_PyApp,
        {0, 0, 1},
        46, methods_wxPyApp,
        0, SIP_NULLPTR,
        6, variables_wxPyApp,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxPyApp,
    -1,
    -1,
    supers_wxPyApp,
    SIP_NULLPTR,
    init_type_wxPyApp,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxPyApp,
    SIP_NULLPTR,
    array_wxPyApp,
    SIP_NULLPTR,
    release_wxPyApp,
    cast_wxPyApp,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
