# میان‌افزار - middleware

شما میتوانید میان‌افزارها را در **FastAPI** اضافه کنید.

"میان‌افزار" یک تابع است که با هر درخواست(request) قبل از پردازش توسط هر path operation (عملیات مسیر) خاص کار می‌کند. همچنین با هر پاسخ(response) قبل از بازگشت آن نیز کار می‌کند.

* هر **درخواستی (request)** که به برنامه شما می آید را می گیرد.
* سپس می تواند کاری برای آن **درخواست** انجام دهید یا هر کد مورد نیازتان را اجرا کنید.
* سپس **درخواست** را به بخش دیگری از برنامه (توسط یک path operation مشخص) برای پردازش ارسال می کند.
* سپس **پاسخ** تولید شده توسط برنامه را (توسط یک path operation مشخص) دریافت می‌کند.
* می تواند کاری با **پاسخ** انجام دهید یا هر کد مورد نیازتان را اجرا کند.
* سپس **پاسخ** را برمی گرداند.

/// توجه | "جزئیات فنی"

در صورت وجود وابستگی هایی با `yield`، کد خروجی **پس از** اجرای میان‌‌افزار اجرا خواهد شد.

در صورت وجود هر گونه وظایف پس زمینه (که در ادامه توضیح داده می‌شوند)، تمام میان‌افزارها *پس از آن* اجرا خواهند شد.

///

## ساخت یک میان افزار

برای ایجاد یک میان‌افزار، از دکوریتور `@app.middleware("http")` در بالای یک تابع استفاده می‌شود.

تابع میان افزار دریافت می کند:
* `درخواست`
* تابع `call_next` که `درخواست` را به عنوان پارامتر دریافت می کند
    * این تابع `درخواست` را به *path operation* مربوطه ارسال می کند.
    * سپس `پاسخ` تولید شده توسط *path operation* مربوطه را برمی‌گرداند.
* شما می‌توانید سپس `پاسخ` را تغییر داده و پس از آن را برگردانید.

```Python hl_lines="8-9  11  14"
{!../../../docs_src/middleware/tutorial001.py!}
```

/// نکته | به خاطر داشته باشید که هدرهای اختصاصی سفارشی را می توان با استفاده از پیشوند "X-" اضافه کرد.

اما اگر هدرهای سفارشی دارید که می‌خواهید مرورگر کاربر بتواند آنها را ببیند، باید آنها را با استفاده از پارامتر `expose_headers` که در مستندات <a href="https://www.starlette.io/middleware/#corsmiddleware" class="external-link" target="_blank">CORS از Starlette</a> توضیح داده شده است، به پیکربندی CORS خود اضافه کنید.

///

/// توجه | "جزئیات فنی"

شما همچنین می‌توانید از `from starlette.requests import Request` استفاده کنید.

**FastAPI** این را به عنوان یک سهولت برای شما به عنوان برنامه‌نویس فراهم می‌کند. اما این مستقیما از Starlette به دست می‌آید.

///

### قبل و بعد از `پاسخ`

شما می‌توانید کدی را برای اجرا با `درخواست`، قبل از اینکه هر *path operation* آن را دریافت کند، اضافه کنید.

همچنین پس از تولید `پاسخ`، قبل از بازگشت آن، می‌توانید کدی را اضافه کنید.

به عنوان مثال، می‌توانید یک هدر سفارشی به نام `X-Process-Time` که شامل زمان پردازش درخواست و تولید پاسخ به صورت ثانیه است، اضافه کنید.

```Python hl_lines="10  12-13"
{!../../../docs_src/middleware/tutorial001.py!}
```

 ## سایر میان افزار

شما می‌توانید بعداً در مورد میان‌افزارهای دیگر در [راهنمای کاربر پیشرفته: میان‌افزار پیشرفته](../advanced/middleware.md){.internal-link target=_blank} بیشتر بخوانید.

شما در بخش بعدی در مورد این که چگونه با استفاده از یک میان‌افزار، <abbr title="Cross-Origin Resource Sharing">CORS</abbr> را مدیریت کنید، خواهید خواند.
