// Protocol Buffers - Google's data interchange format
// Copyright 2023 Google LLC.  All rights reserved.
//
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file or at
// https://developers.google.com/open-source/licenses/bsd
//

#include <stddef.h>

#define UPB_BUILD_API

// go/keep-sorted start
#include "upb/mem/arena.h"           // IWYU pragma: keep
#include "upb/message/accessors.h"   // IWYU pragma: keep
#include "upb/message/array.h"       // IWYU pragma: keep
#include "upb/message/compare.h"     // IWYU pragma: keep
#include "upb/message/copy.h"        // IWYU pragma: keep
#include "upb/message/map.h"         // IWYU pragma: keep
#include "upb/message/merge.h"       // IWYU pragma: keep
#include "upb/mini_table/message.h"  // IWYU pragma: keep
#include "upb/text/debug_string.h"   // IWYU pragma: keep
// go/keep-sorted end

const size_t __rust_proto_kUpb_Map_Begin = kUpb_Map_Begin;
