// Code generated by go-swagger; DO NOT EDIT.

//
// Copyright 2021 The Sigstore Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Rfc3161V001Schema Timestamp v0.0.1 Schema
//
// # Schema for RFC3161 entries
//
// swagger:model rfc3161V001Schema
type Rfc3161V001Schema struct {

	// tsr
	// Required: true
	Tsr *Rfc3161V001SchemaTsr `json:"tsr"`
}

// Validate validates this rfc3161 v001 schema
func (m *Rfc3161V001Schema) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateTsr(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Rfc3161V001Schema) validateTsr(formats strfmt.Registry) error {

	if err := validate.Required("tsr", "body", m.Tsr); err != nil {
		return err
	}

	if m.Tsr != nil {
		if err := m.Tsr.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tsr")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("tsr")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this rfc3161 v001 schema based on the context it is used
func (m *Rfc3161V001Schema) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateTsr(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Rfc3161V001Schema) contextValidateTsr(ctx context.Context, formats strfmt.Registry) error {

	if m.Tsr != nil {

		if err := m.Tsr.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tsr")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("tsr")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Rfc3161V001Schema) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Rfc3161V001Schema) UnmarshalBinary(b []byte) error {
	var res Rfc3161V001Schema
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// Rfc3161V001SchemaTsr Information about the tsr file associated with the entry
//
// swagger:model Rfc3161V001SchemaTsr
type Rfc3161V001SchemaTsr struct {

	// Specifies the tsr file content inline within the document
	// Required: true
	// Format: byte
	Content *strfmt.Base64 `json:"content"`
}

// Validate validates this rfc3161 v001 schema tsr
func (m *Rfc3161V001SchemaTsr) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateContent(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Rfc3161V001SchemaTsr) validateContent(formats strfmt.Registry) error {

	if err := validate.Required("tsr"+"."+"content", "body", m.Content); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this rfc3161 v001 schema tsr based on context it is used
func (m *Rfc3161V001SchemaTsr) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *Rfc3161V001SchemaTsr) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Rfc3161V001SchemaTsr) UnmarshalBinary(b []byte) error {
	var res Rfc3161V001SchemaTsr
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
