// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.
// ************************************************************************* //
//                            avtCEAucdFileFormat.h                           //
// ************************************************************************* //

#ifndef AVT_CEAucd_FILE_FORMAT_H
#define AVT_CEAucd_FILE_FORMAT_H

#include <avtSTMDFileFormat.h>

#include <string>
#include <vector>
#include <map>

class     vtkCEAucdReader;


// ****************************************************************************
//  Class: avtCEAucdFileFormat
//
//  Purpose:
//      Reads in CEAucd files as a plugin to VisIt.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Tue Nov 27 09:05:11 PDT 2007
//
// ****************************************************************************

class avtCEAucdFileFormat : public avtSTMDFileFormat
{
  public:
                       avtCEAucdFileFormat(const char *);
    virtual           ~avtCEAucdFileFormat() {;};

    virtual void      *GetAuxiliaryData(const char *var, int domain,
                                        const char *type, void *args, 
                                        DestructorFunction &);

    void               AddFileInThisDirectory(const std::string &);
    virtual int        GetCycle(void);
    virtual double     GetTime(void);

    virtual const char    *GetType(void)   { return "CEAucd"; };
    virtual void           FreeUpResources(void); 

    virtual vtkDataSet    *GetMesh(int, const char *);
    virtual vtkDataArray  *GetVar(int, const char *);
    virtual vtkDataArray  *GetVectorVar(int, const char *);

  protected:
    bool                      readRoot;
    bool                      setUpFiles;

    vtkCEAucdReader          *reader;
    bool                      readInData;
    int                       domainRead;

    std::string               fileOpened;
    std::string               stem;
    std::string               dir;
    std::string               root;
    std::vector<std::string>  domains;
    std::vector<std::string>  variables;
    std::map<std::string, bool> nodeCentered;

    int                       cycle;
    double                    dtime;
    std::vector<std::string>  matnames;
    int                       dimension;

    void                      ReadRootFile(void);
    void                      SetUpFiles(void);
    virtual void              PopulateDatabaseMetaData(avtDatabaseMetaData *);
    virtual void              RegisterVariableList(const char *,
                                          const std::vector<CharStrRef> &);
    void                      ReadInData(int);
};


#endif


