Minutes from 156th OpenVDB TSC meeting, November 29th, 2022

Attendees: *Jeff* L., *Andre* P, *Dan* B., *Ken* M., *Nick* A.

Additional Attendees: Tomas Skrivan (SideFX), Greg Hurst (United Therapeutics),
Sebastian Gaida, Robin Rowe

Regrets: *Rich* J.

Agenda:

1) Confirm quorum
2) Secretary
3) Unitialized Point Flags in VolumeToMesh (PR1523)
4) NanoVDB Static Asserts (PR1522)
5) Hollow Mesh (PR1525)
6) Next meeting

------------

1) Confirm quorum

Quorum is present.

2) Secretary

Secretary is Dan Bailey.

3) Unitialized Point Flags in VolumeToMesh (PR1523)

Jeff has tracked down a bug where point flags can be uninitialized in the
VolumeToMesh tool as a result of changing one of the arrays into std::array
recently.

Nick has reviewed and offers to do a 10.0.1 bugfix release for this issue.

4) NanoVDB Static Asserts (PR1522)

Jeff wants to switch on the NanoVDB static asserts as there are compiler
warnings when using Clang15 due to the nullptr checks.

5) Hollow Mesh (PR1525)

Tomas Skrivan from SideFX presents a proposed new hollow mesh addition to VDB.
This is to try and resolve issues arising from converting a level set volume to
a mesh using the VolumeToMesh tool. Specifically, any internal structure can be
erased by the signed flood fill. One application where this has been shown to
be a problem is bubbles inside a water surface.

This is particularly noticeable in the Houdini VDB integration as there are a
lot of places where an implicit rebuild is performed resulting in internal
structure being silently eliminated due to the volume->mesh->volume
conversion.

This feature introduces a new oracle to the VolumeToMesh tool so as to be able
to provide different ways to deduce the correct sign. An example provided in
the implementation is simply checking the sign of the original input volume.

One of the big questions is what the default behavior should be and whether this
needs to be an opt-in improvement or not. Jeff thinks this should be considered
a bug and the behavior changed to address this issue. Ken mentions that
sometimes users rely on the current behavior to intentionally clean up internal
structure. Question of default is more one for SideFX to make the final call
on.

The new SideFX implementation uses winding numbers functionality which is
currently unreleased until the next major Houdini release. An earlier version
of the code has been released as open-source and shared through a Siggraph
presentation. Means that there is functionality available in Houdini that is
not available in the native VDB library. A generic winding numbers
implementation would be a welcome addition to VDB, but shouldn't hold up
getting this feature in.

In terms of performance, this feature lies somewhere in the range of a few
percent up to 20-30% decrease in performance when enabled depending on the
exact situation. Tomas shows a number of cases where this new algorithm does a
better job than the current algorithm. Question from Greg about whether it
resolves an earlier question he had about incorrect results when trying to
resolve a thin tube of a few voxels wide that intersects a box. Tomas
demonstrates that it is a significant improvement on the existing algorithm for
this case. Extending the existing algorthm to consider a larger stencil pattern
of 26 neighbors instead of 6 neighbours would also be expected to improve
results at greater computational cost.

Remaining aspect to resolve is how to expose this in the API. The use of an
oracle in the existing proposal means that explicit template instantiation
cannot be used. Given the complexity and instantiation cost of the current
algorithm, this is a concern. Worth checking if using a std::function argument
instead of a template argument would significantly affect the performance,
particularly for the case where the oracle is being checked only once every
tile. A std::function argument would allow the use of explicit template
instantiation once more, another option is to refactor the method so that
portions of the algorithm could still be explicitly instantiated.

CI checks are failing due to issues with explicit template instantiation. This
implementation is also missing unit tests currently. All in favor of working
towards resolving these issues so that this very worthwhile improvement can be
included in OpenVDB.

6) Next meeting

Next meeting is on December 6th, 2022. 2pm-3pm EDT (GMT-4).
