<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

OCIO v2 WORKING GROUP MEETING  
2019-03-28  
via Zoom  

Participants:
  * Mark Boorer (ILM)
  * Sean Cooper (DNeg)
  * Joseph Goldstone (ARRI)
  * Bernard Lefebvre (Autodesk)
  * Thomas Mansencal (Weta)
  * Kevin Wheatley (Framestore)

Hosts:
  * Doug Walker (Autodesk)
  * Patrick Hodoul (Autodesk)

Recording on Zoom cloud:  
<https://autodesk.zoom.us/rec/share/dqMnt15_mQTmdVWhtwInNP0POdL2NxBTCW6r4hR9nOOhtjdb3LQ-cvzip8vR455a.QmLgsTVCb0GZESsI>


**CTF FORMAT REFERENCE SUPPORT**

   - PR #712 adds support for the Reference feature of the CTF file format.
   - This allows other CTFs to be incorporated via file reference.
   - Implementation leverages existing OCIO FileTransform
   - Also added an alternate method of specifying search_paths in the config
file that is more Windows-friendly (and perhaps more readable).
   - Mark:  The intention of the original search_path design was that UNC paths
would be used for Windows since they are cross-platform and don't require the
':'.
   - Please review the PR and provide feedback.

**SUPPORT FOR INTEGER PIXEL FORMATS**

   - Draft PR #699 proposes a feature for supporting 8/10/12/16-bit integer
pixel buffers.
   - Offers potential for a large speed-up in CPU performance for important
use-cases.
   - Minimal changes to ops that don't benefit from integer optimization (most
ops).  Simply adjust signature from in-place processing to separate src/dest
buffers.
   - Ops such as Lut1D are allowed direct access to the integer values via
templates.
   - Kevin:  Is an integer output buffer supported as well?  (Yes)
   - Design supports integer access at start and end of op list but is float32
in between.  
   - (We have some prior experience in supporting integers in all ops but we
found the benefit was not worth the cost in complexity or template logistics. 
Our goal is to only introduce complexity where there is a sufficiently large
benefit.)
   - Upcoming optimization will allow converting any separable ops at the start
of the chain into a single LUT when the input pixel type allows look-ups.
   - Please review the PR and provide feedback.

**OPEN DISCUSSION ON PIXEL FORMAT SUPPORT**

   - Are people happy with the OCIO v1 ImageDesc functionality?
   - Mark:  Important use-cases are multi-part EXRs as well as multi-channel
EXRs where the B, G, R channels are not adjacent.
   - Mark:  Important similar implementations to compare against are OIIO and
ffmpeg.  Would be nice to keep enums similar to OIIO.
   - Autodesk team described some of the design questions they are currently
investigating related to integer pixel formats, optimization, etc.  These
include:
       - Should bit-depth and channel reformatting be done as a prefix/postfix
on the op list or as part of the ImageDesc and ScanlineHelper mechanism?
       - How to avoid duplication of LUT arrays (e.g. OpData and OpCPU)?
       - How to have better control over the when/how of op list optimization? 
Would like to unbundle optimization from the getProcessor call.
   - Mark:  Would prefer to add args to getProcessor rather than have a separate
optimization call.
   - Doug:  Reasons we were leaning towards a separate call were first to avoid
changes to the v1 API, and also to allow client apps to have more control over
the original and optimized op lists (which may be very different).
   - Mark:  It's OK to make API changes of this nature, given that it's a major
version number upgrade.

**MISCELLANEOUS ITEMS**

   - Thomas: Ociolutimage is currently broken using homebrew. This is an ongoing
source of trouble with package managers, etc. Is it in the plan for ASWF or OCIO
to manage this?
   - Mark: The package manager situation is difficult, homebrew is a mess. The
ASWF has a goal to provide artifacts, although it will be very difficult due to
all the different versions of the dependencies that are in use.
   - Thomas/Patrick: Also issues due to OIIO changes. Would be nice for our CI
to verify that the upstreams don't break OCIO.
   - Next meeting planned for late April.
