<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

January 18, 2021

Host: Michael Dolan

Attendees:
  * [X] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [ ] Mei Chu (_TSC_) - Sony Pictures Imageworks
  * [X] Sean Cooper (_TSC ACES TAC Rep_) - ARRI
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [X] Patrick Hodoul (_TSC_) - Autodesk
  * [ ] John Mertic - Academy Software Foundation / Linux Foundation
  * [X] Carol Payne (_TSC_) - Netflix
  * [X] Mark Titchener (_TSC_) - Foundry
  * [X] Carl Rand (_TSC_) - Weta Digital
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Kevin Wheatley (_TSC_) - Framestore
  * [X] Bernard Lefebvre - Autodesk

Apologies:
  * Mei Chu

# **OCIO TSC Meeting Notes**

* Doug to summarize in-progress work:
    - Doug: Number of PRs landing this week. Bug fixes in Python bindings, etc. 
      No new features. Small but appreciate quick turn around.

* Any volunteers to help get the OpenFX plug-ins compiling (PR #1232)?
    - Doug: Contributor needs help with compilation and loading in OFX 
      compliant app. Doesn't need help writing plugins, just initial step of 
      getting it built.
    - Michael: Currently is swapping code into a Resolve plugin example I 
      believe.
    - Carol: Is there more we can do to help people get up and running with 
      OCIO? Many new developers are struggling to get up and running. Not sure 
      what the issue is.
    - Doug: Valid point. Heard similar feedback from ACES community too. Not 
      all those trying to build OCIO are necessarily developers.
    - Sean: Might be lack of familiarity with C++ build env.
    - Carol: Could link to some CMake help for getting started, etc.
    - Sean: After release, when we get into other package envs, those 
      complaints will go away.
    - Michael: I brought this up in the last CI working group. Pushed for 
      making one of the goals this year to work on standardized package manager 
      support across ASWF projects.
    - Mark T: He had example plugins building. I talked to him about some of 
      that. Is able to build examples now, but not able to build his plugin.
    - Michael: We can do zoom to help support if needed.

* VFX Reference Platform 2.0.x -> 2.x:
    - Michael: I reached out to the platform working group and the TAC about 
      the change and got good feedback. OpenVDB has always had a variable minor 
      version, but has to be handled carefully. Stance from VFX ref platform is
      that a CY version range must be ABI compatible.
    - Doug: Challenge is we may want to do 2.x release that breaks ABI 
      compatibility. Lots of things could break it.
    - Michael: Can do minor version ranges in platform, if we could commit to 
      certain minor versions being ABI compatible.
    - Doug: Anyone rememberer when tetrahedral interpolation was added to 
      OCIO v1? Did that break ABI compatibility?
    - Kevin: It didn't quite. Was able to put binary from Nuke into Mari and 
      it worked.
    - Patrick: Can add enum, but add at end.
    - Doug: Risk is committing to all 2.x not breaking ABI.
    - Patrick: Need to say that for next 9 months, no change will break ABI 
      compatibility. Since v2 is first being used, challenge to say that.
    - Carol: Have not done enough testing to be confident.
    - Michael: Semver doesn't explicitly say ABI compatibility, but sort of 
      implies it in minor version changes being backwards compatible. That 
      would impact the decision too.
    - Patrick: We will have to change API.
    - Carol: Might be 6 months before we see v2 release with Nuke.
    - Mark T: Yes, taking longer than we hoped. also delay getting into 
      production once it's in DCCs.
    - Michael: Suggest we back out changes if we're not confident in adhering 
      to the rule.
    - Doug: Will need to be 2.0.1 as bug fix, and then eventually 2.1.
    - Carol: Can push bigger changes to CY2022.
    - Mark B: Don't forsee needing to use these new features at facility scale 
      in 2021. Not a huge deal if VFX ref misses some of those minor features.
    - Michael: We're currently missing builtin transforms needed for the ACES 
      config. Would we need to resort to LUTs to get that out?
    - Doug: Can do like was pasted in Slack a while back, building the output 
      transforms in the config.
    - Michael: Any performance cost? Or since builtin transform just builds ops 
      directly, is it about the same?
    - Doug: Shouldn't be. Have not tested yet.
    - Michael: Complicates config build script a bit. ACES 1.3 can wait, but we 
      will need output transforms.
    - Kevin: How many releases could we have this year? How many versions on 
      active support? Committing to support VFX ref platform. Minor versions 
      could be more to support. Tradeoff of not locking ref platform down.
    - Mark B: Could add broken endpoints for features we're planning to add. 
      Then API won't change.
    - Michael: Good idea. I have seen other libraries do that. Let's continue 
      this discussion in the config wg meeting tomorrow. I will followup with 
      platform working group after that.

* Release plan discussion for 2.0.0:
    - Doug: Would like to do 2.0.0 release next week, Monday or Tuesday. Minor 
      PRs in this week to merge quickly.

* Issues, Built-in Transform, Documentation, or other “must haves” for 2.0.0:
    - Doug: If there are things people feel are must haves, want to get them on 
      table. Bernard working on issues. Not currently working on reported 
      OpenEXR 2.5 CMake issue. 
    - **TODO**: Michael will roll back OIIO find module to resolve that 
      issue for now.

* Ociocheck behavior for missing roles:
    - Doug: ociocheck looks for known set of roles. If they are missing it 
      prints error message. Added new roles to OCIO v2, so was going to add 
      them to OCIO check, but they aren't mandatory. some of the roles it is 
      currently complaining about don't seem mandatory. Propose changing 
      message to warning instead of error.
    - Kevin: Difference in behavior with new roles. They are required in 
      certain circumstances. Without matte_paint role config will work. Would 
      like a strict check that validates as an error. Agree on some other roles 
      being warnings though.
    - Sean: Core roles could be hard coded in DCCs and know that those exist. 
      More for DCC/API compatibility. With newer v2.0 features, can question 
      whether they are necessary.

* Should inactive color spaces be included by parseColorSpaceFromString?
    - Doug: Inactive spaces won't be in menus. Should we parse inactive color 
      spaces from strings?
    - Kevin: I think so. Useful for loading historical color spaces. Like to be 
      able to load file on disk.
    - Mark, Sean: Agree. Good to load them still if it's defined.

* Scope of image IO support for app refactor (to remove OpenImageIO dependency):
    - Michael: I've been building simple image interface to load EXRs for apps. 
      OpenEXR is a broad interface though, with many types of files. Should we 
      support them all? Or limit it since the apps only operate on RGBA?
    - Mark B: Think we can keep the OIIO dependency. If needed can change how 
      they are built, with apps in another repo, or a separate CMake build.
    - Kevin: Package managers would prefer library and tools separate.
    - Mark B: That's what debian and brew do. 
    - Patrick: Agree not a huge problem, but falls in problem category. Two 
      types of commandline tools. Helpers and apps like ociodisplay, which are 
      useful for development. Moving tools for external users outside could be 
      good. But ocioperf less convinced. ocioperf would be ok only having 
      OpenEXR format. Tool we really need OIIO for is ociodisplay.
    - Group agrees to continue discussion next week and in GH issue. Leaning 
      toward keeping OIIO dependency and implementing one of Mark's 
      suggestions.

* ASWF 2020 CCLA 2.1 transition:
    - Sean: What would the timeline by for this change? 6 months?
    - Michael: I talked to John and it sounds like we can get the new CCLA 
      signed before we switch and then switch it over once we know there will
      be no disruption to contributions. Will follow up more on this next week.

* Items for next TSC meeting agenda:
    - Removing apps from repo or main build.
    - ASWF 2020 CCLA 2.1 transition plan.
