<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

October 19, 2020

Host: Michael Dolan

Attendees:
  * [X] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [X] Mei Chu (_TSC_) - Sony Pictures Imageworks
  * [ ] Sean Cooper (_TSC ACES TAC Rep_) - DNEG
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [X] Patrick Hodoul (_TSC_) - Autodesk
  * [ ] John Mertic - Academy Software Foundation / Linux Foundation
  * [X] Carol Payne (_TSC_) - Netflix
  * [X] Mark Titchener (_TSC_) - Foundry
  * [X] Carl Rand (_TSC_) - Weta Digital
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [ ] Kevin Wheatley (_TSC_) - Framestore
  * [X] Bernard Lefebvre - Autodesk
  * [X] J Schulte - Industrial Light & Magic

# **OCIO TSC Meeting Notes**

* ASWF usage/feedback survey questions for OCIO:
    - Michael: ASWF will be sending out a survey on project usage/feedback and 
      asking that we provide OCIO specific questions we want industry input on.
      Any specific questions you would like feedback on?
    - Mark B: Feature usage. How many users create configs from scratch vs. use 
      distributed configs. How many use and rely on context variables and look 
      transforms? How many use look transform expression language?
    - Carol: What software do you most use OCIO in?
    - Mark B: Any areas of color management we aren't helping with? Do you 
      build OCIO or rely on package manager. Do you need to replace builtin 
      OCIO shipping with DCC?
    - Michael: OCIO v2 transition concerns?
    - J: Any requirement for specialized documentation? UX/UI convention 
      document, etc? Any more levels of docs that help people get on board.
    - Mark B: Are you aware of documentation efforts and new website?

* New PRs:
    - #1172: Improve the FileRules behavior for some limited cases:
        - Patrick: Fixes inconsistencies with file rules after using and 
          documenting them. Small change.
        - Doug: How to handle case where string is empty - no rule. An edge 
          case.
    - #1171: Change the ICC monitor profile reader:
        - Patrick: Bug discovered by Rémi. Fixed.
    - Doug: Going to create issue for cleanup - removing unknown direction 
      enum. Will clean up a lot of code and be better for error handling. 
      Errors will show up at parse time instead of evaluation time.
    - Patrick: Pasted PRs in Slack awaiting feedback.

* General discussion:
    - Doug: Anyone watching VIEW conference? Like FMX, European VFX conference 
      in Italy. Free this year. Rob Bredow did a session and gave shout out to 
      ASWF and OCIO. Encouraged people that ASWF is a great way to get 
      involved. Encouraging to see support for the project.
    - Patrick: New contributor with work to look at. PR #1169.
    - Michael: Since October is almost over, what is the timeline for 
      stabilization period? Are we targeting end of year or looking to push 
      into new year?
    - Doug: Good topic for future TSC meeting. A number of projects have been 
      accepted into VFX ref platform 2021, with releases at end of year or 
      early next year. OpenEXR 3, OpenVDB 8. Talked with Larry about how he 
      releases OIIO (RC releases, etc.). Think it's a decision for TSC, about 
      when release will be. Will certainly need 2.0.1 next year for bug fixes. 
      Hoped to get a lot of testing this fall, opportunity to fix bugs for 
      release. If we could extend into next year will help with stability. VFX 
      ref platform starts in calendar year.
    - Michael: Any work on integration at Foundry?
    - Mark T: A bit, but waiting for engineering team to free up off another 
      project. Will start investigating Nuke integration in coming weeks. 
      Hopefully can make good progress.
    - Michael: Is Autodesk working on implementation? Deciding what to do in 
      terms of UI/UX will be a discussion point, since not much has been done 
      yet with related new features.
    - Doug: We are looking at it, but requires more documentation. UI one of 
      biggest ways to take advantage of new features.
    - Mark B: For studio to upgrade, the last app to use v1 has to disappear. 
      Probably a long lead time.
    - Doug: Is it possible to have two configs side by side? v1 and v2?
    - Mark: Depends how complex. Not ideal.
    - Michael: I have been answering questions for an SPI engineer looking at
      v2 integration. He might be a good source of feedback.
    - Mei: Yes, we have a developer looking into it. Installed and playing 
      around with it. Will have more feedback soon.
    - Carol: At Netflix people very excited about new ACES config and config 
      generation tools. Most conversations around that. When those tools are 
      ready to pick up, will be time that dev work would happen.
    - Michael: Reminder that the next config working group meeting is tomorrow.
      Now alternating weeks with the documentation working group to free up 
      schedules a bit.
    - Patrick: Related to UI - have a look at the code. Have apphelpers static 
      lib to help. C++ only. Demonstrates how to filter color spaces, how to 
      present them, color picker, etc. See if it fits your needs.
    - Mark T: From Zoom chat: Any work on OFX reference yet?
    - Doug: Someone was going to get started but hasn't panned out. Updated 
      issue and someone else expressed interest. Student so may need some help. 
      Anyone want to collaborate? Would be welcome.
    - Michael: OFX plugins will be a big job, and are a good opportunity for a 
      UX first pass if anyone has strong opinions on that.
    - J: OFX example could be really valuable for UX/UI, making sure a tool 
      embodies all of that, as reference. Having something usable beyond docs 
      would be good to evangelize the work. 
    - Michael: Agree. Good opportunity to help steer the UX work.
    - Doug: Told interested contributor first pass could be simple and second 
      pass can refine UI. Break work into milestones. First PR might be bones, 
      and then several could collaborate on how UI should work.
    - Mark T, J: Interested in helping with that. Could help test and feedback 
      designs. 
    - **TODO**: Michael will open an issue to discuss. Can help DCCs be 
      consistent.
    - J: Hopefully enough stuff for new developers. Standards, etc.
    - Doug: Alluding to this with documentation. UI mockups could find way into 
      docs and tutorial. How to build UI for OCIO v2.
    - Carol: Would be great. The more visual the better.

* Items for next TSC meeting agenda:
    - **TODO**: Mark B organizing OCIO v2 feature discussion points. Will add 
      to agenda next week.
