<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

January 4, 2021

Host: Michael Dolan

Attendees:
  * [X] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [ ] Mei Chu (_TSC_) - Sony Pictures Imageworks
  * [ ] Sean Cooper (_TSC ACES TAC Rep_) - DNEG
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [X] Patrick Hodoul (_TSC_) - Autodesk
  * [ ] John Mertic - Academy Software Foundation / Linux Foundation
  * [ ] Carol Payne (_TSC_) - Netflix
  * [X] Mark Titchener (_TSC_) - Foundry
  * [X] Carl Rand (_TSC_) - Weta Digital
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Kevin Wheatley (_TSC_) - Framestore
  * [X] Bernard Lefebvre - Autodesk
  * [X] Robin Rowe - CinePaint

Apologies:
  * Carol Payne
  * Mei Chu

# **OCIO TSC Meeting Notes**

* rawtoaces:
    - Michael: rawtoaces was accepted as an ASWF incubation project at the 
      last TAC meeting. Might be some interesting collaboration opportunity 
      there.

* Doug to summarize in-progress work:
    - Doug: New PRs two weeks ago, some updated commits last week.
        - Grading op implementation now complete.
        - Minor fixes/changes: v1/v2 serialization issue (#1244). 
          to_reference/from_reference synonyms. Default view transform 
          specification.
        - #1241 implements color space alias feature.
        - Michael: Use case for config name added in PR? Comment seemed to 
          imply could be used as a color space namespace, and referenced 
          externally?
        - Doug: Optional config name, could be useful for:
            - Alternative to filename for tracking config.
            - Indicate version. 
            - Future use as more fully qualified name for a color space. 
            - Reference for USD, other projects, etc.
        - Just metadata for now.
        - **TODO**: Bernard will clarify comment in API that config name has no
          influence on color space lookups.

* Seeking approval to merge PRs #1220, 1234, 1241 (today), 1244, 1245 
  (tomorrow):
    - Doug: Want to get OCIO v2 out there, since we're over the VFX ref 
      platform release date a bit. Suggest releasing 2.0.0 by mid-January. 
      Want to get last PRs merged and RC tag to communicate final testing 
      state.
    - Michael: Have a Python binding fix for CPUProcessor that should be in 
      RC release.
    - Mark: Did apphelpers (#1220) add dependecy to core? OpenGL?
    - Doug: No, that's in another helpers lib separate from core.
    - No objections to proposed merges.

* Version handling discussion:
    - Doug: Once config v2 version starts getting used, will be need to bump 
      version for future changes. Want to discuss how to handle versioning. If 
      config syntax needs tweaking, what to do. Currently will throw for v3 
      and warn for v2.1.
    - Michael: Currently just single int right?
    - Doug: Yes, and added ability to have minor version in OCIO v2.
    - Kevin: What additions would we make to need a version warning? Fixed 
      transform?
    - Doug: Yes, and some things would throw. A new style string for a 
      transform for example.
    - Mark: Don't think there's need to be future compatible. Would prefer to 
      fail fast vs. silently ignoring incompatibility. OCIO and config version 
      numbers can diverge.
    - Patrick: For debugging would be useful to keep major version in sync 
      between lib and config.
    - Kevin: Does the minor version increment sequentially, or is it tied to 
      lib release? Under what circumstances is a warning valid. Or is it just 
      valid or not valid, ok or throw.
    - Doug: If an older version config is not using new features, it could 
      try to load.
    - Michael: Failing fast would avoid subtle differences, like 
      ExponentTransform negative handling changing for example.
    - Kevin: Or changed defaults.
    - Michael: Could have metadata in config with exact lib version if needed.
    - Patrick: Need to be careful with optional metadata. Could get out of date 
      and be confusing.
    - Mark: If having minor version helps keep it organized, have no problem 
      with it.
    - All agree to allow minor version, and fail on unknown/unsupported version 
      rather than raising a warning.
    - **TODO**: Bernard will push updated to #1244, which is related.

* Discussion about creating a RB-2.0 release branch:
    - Doug: After these PRs get merged, will create the branch. Should RC tag 
      begin that?
    - Kevin: If we create them together we are saying they are the same. If 
      separated, might be different.
    - Patrick: Where do we put the tag? In main or in RB-2.0?
    - Mark: Have it in both, and cherry pick main changes into RB-2.0.
    - Patrick: Only consequence is main will be tagged as RC.
    - All agree to create tag in main and branch RB-2.0 from that.

* General discussion:
    - Kevin: If we are concerned with ABI compatibility, should we put 
      something in place to warn about it? Extra symbol appears or disappears, 
      etc.
    - Mark: OCIO is good at avoiding this since all symbols have version 
      namespace. Only issue if you don't update the version number.
    - Patrick: If we are consistent, won't happen. Should be caught in review.
    - Mark: Difficult to comare symbols to detect change. Would need two builds 
      or maintained list of symbols.
    - Patrick: Even changing order could be an issue.
    - Kevin: What about for Python?
    - Michael: We are setting __version__ currently.
    - Mark: It is likely used in setup.py, etc.
    - Michael: We will eventually setup PyPi, so could be used there too.
    - Follow up: See PEP 396: https://www.python.org/dev/peps/pep-0396/
