import { Neovim } from '../api/Neovim';
import { Spec } from '../types/Spec';
export interface NvimPluginOptions {
    dev?: boolean;
    alwaysInit?: boolean;
}
export interface AutocmdOptions {
    pattern?: string;
    eval?: string;
    sync?: boolean;
}
export interface CommandOptions {
    sync?: boolean;
    range?: string;
    nargs?: string;
    complete?: string;
}
export interface NvimFunctionOptions {
    sync?: boolean;
    range?: string;
    eval?: string;
}
export interface Handler {
    fn: Function;
    spec: Spec;
}
export declare function callable(fn: Function): Function;
export declare function callable(fn: [any, Function]): Function;
export declare class NvimPlugin {
    filename: string;
    nvim: Neovim;
    instance: any;
    dev: boolean;
    alwaysInit: boolean;
    autocmds: {
        [index: string]: Handler;
    };
    commands: {
        [index: string]: Handler;
    };
    functions: {
        [index: string]: Handler;
    };
    constructor(filename: string, plugin: any, nvim: Neovim);
    setOptions(options: NvimPluginOptions): void;
    get shouldCacheModule(): boolean;
    registerAutocmd(name: string, fn: Function, options: AutocmdOptions): void;
    registerAutocmd(name: string, fn: [any, Function], options: AutocmdOptions): void;
    registerCommand(name: string, fn: Function, options?: CommandOptions): void;
    registerCommand(name: string, fn: [any, Function], options?: CommandOptions): void;
    registerFunction(name: string, fn: Function, options?: NvimFunctionOptions): void;
    registerFunction(name: string, fn: [any, Function], options?: NvimFunctionOptions): void;
    get specs(): Spec[];
    handleRequest(name: string, type: string, args: any[]): Promise<any>;
}
