"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.attach = attach;
const node_net_1 = require("node:net");
const client_1 = require("../api/client");
const logger_1 = require("../utils/logger");
function attach({ reader: _reader, writer: _writer, proc, socket, options = {}, }) {
    let writer;
    let reader;
    if (socket) {
        const client = (0, node_net_1.createConnection)(socket);
        writer = client;
        reader = client;
    }
    else if (_reader && _writer) {
        writer = _writer;
        reader = _reader;
    }
    else if (proc) {
        writer = proc.stdin;
        reader = proc.stdout;
    }
    if (writer && reader) {
        const loggerInstance = options.logger || (0, logger_1.getLogger)(); // lazy load to winston only if needed
        const neovim = new client_1.NeovimClient({ logger: loggerInstance });
        neovim.attach({
            writer,
            reader,
        });
        return neovim;
    }
    throw new Error('Invalid arguments, could not attach');
}
