; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=instsimplify -S < %s | FileCheck %s

; Verify that we don't crash with an assertion failure when constant folding
; a call to intrinsic 'convert.from.fp16' if the return type is not 'float'.

define float @fold_from_fp16_to_fp32() {
; CHECK-LABEL: @fold_from_fp16_to_fp32(
; CHECK-NEXT:    ret float 0.000000e+00
;
  %r = call float @llvm.convert.from.fp16.f32(i16 0)
  ret float %r
}

define double @fold_from_fp16_to_fp64() {
; CHECK-LABEL: @fold_from_fp16_to_fp64(
; CHECK-NEXT:    ret double 0.000000e+00
;
  %r = call double @llvm.convert.from.fp16.f64(i16 0)
  ret double %r
}

define x86_fp80 @fold_from_fp16_to_fp80() {
; CHECK-LABEL: @fold_from_fp16_to_fp80(
; CHECK-NEXT:    ret x86_fp80 0xK00000000000000000000
;
  %r = call x86_fp80 @llvm.convert.from.fp16.f80(i16 0)
  ret x86_fp80 %r
}

define fp128 @fold_from_fp16_to_fp128() {
; CHECK-LABEL: @fold_from_fp16_to_fp128(
; CHECK-NEXT:    ret fp128 0xL00000000000000000000000000000000
;
  %r = call fp128 @llvm.convert.from.fp16.f128(i16 0)
  ret fp128 %r
}

define ppc_fp128 @fold_from_fp16_to_ppcfp128() {
; CHECK-LABEL: @fold_from_fp16_to_ppcfp128(
; CHECK-NEXT:    ret ppc_fp128 0xM00000000000000000000000000000000
;
  %r = call ppc_fp128 @llvm.convert.from.fp16.ppcf128(i16 0)
  ret ppc_fp128 %r
}

define float @fold_from_fp16_to_fp32_b() {
; CHECK-LABEL: @fold_from_fp16_to_fp32_b(
; CHECK-NEXT:    ret float 4.000000e+00
;
  %a = call i16 @llvm.convert.to.fp16.f64(double 4.0)
  %r = call float @llvm.convert.from.fp16.f32(i16 %a)
  ret float %r
}

define double @fold_from_fp16_to_fp64_b() {
; CHECK-LABEL: @fold_from_fp16_to_fp64_b(
; CHECK-NEXT:    ret double 4.000000e+00
;
  %a = call i16 @llvm.convert.to.fp16.f64(double 4.0)
  %r = call double @llvm.convert.from.fp16.f64(i16 %a)
  ret double %r
}

define x86_fp80 @fold_from_fp16_to_fp80_b() {
; CHECK-LABEL: @fold_from_fp16_to_fp80_b(
; CHECK-NEXT:    ret x86_fp80 0xK40018000000000000000
;
  %a = call i16 @llvm.convert.to.fp16.f64(double 4.0)
  %r = call x86_fp80 @llvm.convert.from.fp16.f80(i16 %a)
  ret x86_fp80 %r
}

define fp128 @fold_from_fp16_to_fp128_b() {
; CHECK-LABEL: @fold_from_fp16_to_fp128_b(
; CHECK-NEXT:    ret fp128 0xL00000000000000004001000000000000
;
  %a = call i16 @llvm.convert.to.fp16.f64(double 4.0)
  %r = call fp128 @llvm.convert.from.fp16.f128(i16 %a)
  ret fp128 %r
}

define ppc_fp128 @fold_from_fp16_to_ppcfp128_b() {
; CHECK-LABEL: @fold_from_fp16_to_ppcfp128_b(
; CHECK-NEXT:    ret ppc_fp128 0xM40100000000000000000000000000000
;
  %a = call i16 @llvm.convert.to.fp16.f64(double 4.0)
  %r = call ppc_fp128 @llvm.convert.from.fp16.ppcf128(i16 %a)
  ret ppc_fp128 %r
}

; This would assert because converting SNAN causes an invalidOp status.
; PR56981

define float @convert_snan() {
; CHECK-LABEL: @convert_snan(
; CHECK-NEXT:    ret float 0x7FF8040000000000
;
  %r = call float @llvm.convert.from.fp16.f32(i16 31745) ; 0x7c01
  ret float %r
}

declare i16 @llvm.convert.to.fp16.f64(double)
declare float @llvm.convert.from.fp16.f32(i16)
declare double @llvm.convert.from.fp16.f64(i16)
declare x86_fp80 @llvm.convert.from.fp16.f80(i16)
declare fp128 @llvm.convert.from.fp16.f128(i16)
declare ppc_fp128 @llvm.convert.from.fp16.ppcf128(i16)
