; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=dse -enable-dse-initializes-attr-improvement -S | FileCheck %s

declare void @p1_write_only(ptr nocapture noundef writeonly initializes((0, 2)) dead_on_unwind)
declare void @p1_write_then_read(ptr nocapture noundef initializes((0, 2)) dead_on_unwind)
declare void @p1_clobber(ptr nocapture noundef)
declare void @p2_same_range(ptr nocapture noundef initializes((0, 2)) dead_on_unwind, ptr nocapture noundef initializes((0, 2)) dead_on_unwind)
declare void @p2_no_init(ptr nocapture noundef initializes((0, 2)) dead_on_unwind, ptr nocapture noundef dead_on_unwind)
declare void @p2_no_dead_on_unwind(ptr nocapture noundef initializes((0, 2)) dead_on_unwind, ptr nocapture noundef initializes((0, 2)))
declare void @p2_no_dead_on_unwind_but_nounwind(ptr nocapture noundef initializes((0, 2)) dead_on_unwind, ptr nocapture noundef initializes((0, 2))) nounwind

; Function Attrs: mustprogress nounwind uwtable
define i16 @p1_write_only_caller() {
; CHECK-LABEL: @p1_write_only_caller(
; CHECK-NEXT:    [[PTR:%.*]] = alloca i16, align 2
; CHECK-NEXT:    call void @p1_write_only(ptr [[PTR]])
; CHECK-NEXT:    [[L:%.*]] = load i16, ptr [[PTR]], align 2
; CHECK-NEXT:    ret i16 [[L]]
;
  %ptr = alloca i16
  store i16 0, ptr %ptr
  call void @p1_write_only(ptr %ptr)
  %l = load i16, ptr %ptr
  ret i16 %l
}

; Function Attrs: mustprogress nounwind uwtable
define i16 @p1_write_then_read_caller() {
; CHECK-LABEL: @p1_write_then_read_caller(
; CHECK-NEXT:    [[PTR:%.*]] = alloca i16, align 2
; CHECK-NEXT:    call void @p1_write_then_read(ptr [[PTR]])
; CHECK-NEXT:    [[L:%.*]] = load i16, ptr [[PTR]], align 2
; CHECK-NEXT:    ret i16 [[L]]
;
  %ptr = alloca i16
  store i16 0, ptr %ptr
  call void @p1_write_then_read(ptr %ptr)
  %l = load i16, ptr %ptr
  ret i16 %l
}

declare void @fn_capture(ptr)
define i16 @p1_write_then_read_caller_escape() {
; CHECK-LABEL: @p1_write_then_read_caller_escape(
; CHECK-NEXT:    [[PTR:%.*]] = alloca i16, align 2
; CHECK-NEXT:    store i16 0, ptr [[PTR]], align 2
; CHECK-NEXT:    call void @fn_capture(ptr [[PTR]])
; CHECK-NEXT:    call void @p1_write_then_read(ptr [[PTR]])
; CHECK-NEXT:    [[L:%.*]] = load i16, ptr [[PTR]], align 2
; CHECK-NEXT:    ret i16 [[L]]
;
  %ptr = alloca i16
  store i16 0, ptr %ptr
  call void @fn_capture(ptr %ptr)
  call void @p1_write_then_read(ptr %ptr)
  %l = load i16, ptr %ptr
  ret i16 %l
}


; Function Attrs: mustprogress nounwind uwtable
define i16 @p1_write_then_read_caller_with_clobber() {
; CHECK-LABEL: @p1_write_then_read_caller_with_clobber(
; CHECK-NEXT:    [[PTR:%.*]] = alloca i16, align 2
; CHECK-NEXT:    store i16 0, ptr [[PTR]], align 2
; CHECK-NEXT:    call void @p1_clobber(ptr [[PTR]])
; CHECK-NEXT:    call void @p1_write_then_read(ptr [[PTR]])
; CHECK-NEXT:    [[L:%.*]] = load i16, ptr [[PTR]], align 2
; CHECK-NEXT:    ret i16 [[L]]
;
  %ptr = alloca i16
  store i16 0, ptr %ptr
  call void @p1_clobber(ptr %ptr)
  call void @p1_write_then_read(ptr %ptr)
  %l = load i16, ptr %ptr
  ret i16 %l
}

declare void @p1_write_then_read_raw(ptr nocapture noundef initializes((0, 2)))
define i16 @p1_initializes_invoke() personality ptr undef {
; CHECK-LABEL: @p1_initializes_invoke(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[PTR:%.*]] = alloca i16, align 2
; CHECK-NEXT:    store i16 0, ptr [[PTR]], align 2
; CHECK-NEXT:    invoke void @p1_write_then_read_raw(ptr [[PTR]])
; CHECK-NEXT:            to label [[BB1:%.*]] unwind label [[BB2:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    ret i16 0
; CHECK:       bb2:
; CHECK-NEXT:    [[TMP:%.*]] = landingpad { ptr, i32 }
; CHECK-NEXT:            cleanup
; CHECK-NEXT:    [[L:%.*]] = load i16, ptr [[PTR]], align 2
; CHECK-NEXT:    ret i16 [[L]]
;
entry:
  %ptr = alloca i16
  store i16 0, ptr %ptr
  invoke void @p1_write_then_read_raw(ptr %ptr) to label %bb1 unwind label %bb2
bb1:
  ret i16 0
bb2:
  %tmp = landingpad { ptr, i32 }
  cleanup
  %l = load i16, ptr %ptr
  ret i16 %l
}

; Function Attrs: mustprogress nounwind uwtable
define i16 @p2_same_range_noalias_caller() {
; CHECK-LABEL: @p2_same_range_noalias_caller(
; CHECK-NEXT:    [[PTR1:%.*]] = alloca i16, align 2
; CHECK-NEXT:    [[PTR2:%.*]] = alloca i16, align 2
; CHECK-NEXT:    call void @p2_same_range(ptr [[PTR1]], ptr [[PTR2]])
; CHECK-NEXT:    [[L:%.*]] = load i16, ptr [[PTR1]], align 2
; CHECK-NEXT:    ret i16 [[L]]
;
  %ptr1 = alloca i16
  %ptr2 = alloca i16
  store i16 0, ptr %ptr1
  store i16 0, ptr %ptr2
  call void @p2_same_range(ptr %ptr1, ptr %ptr2)
  %l = load i16, ptr %ptr1
  ret i16 %l
}

; Function Attrs: mustprogress nounwind uwtable
define i16 @p2_same_range_must_alias_caller() {
; CHECK-LABEL: @p2_same_range_must_alias_caller(
; CHECK-NEXT:    [[PTR:%.*]] = alloca i16, align 2
; CHECK-NEXT:    call void @p2_same_range(ptr [[PTR]], ptr [[PTR]])
; CHECK-NEXT:    [[L:%.*]] = load i16, ptr [[PTR]], align 2
; CHECK-NEXT:    ret i16 [[L]]
;
  %ptr = alloca i16
  store i16 0, ptr %ptr
  call void @p2_same_range(ptr %ptr, ptr %ptr)
  %l = load i16, ptr %ptr
  ret i16 %l
}

; Function Attrs: mustprogress nounwind uwtable
define i16 @p2_same_range_may_or_partial_alias_caller1(ptr %base, i1 %x) {
; CHECK-LABEL: @p2_same_range_may_or_partial_alias_caller1(
; CHECK-NEXT:    [[BASEPLUS:%.*]] = getelementptr i8, ptr [[BASE:%.*]], i64 1
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[X:%.*]], ptr [[BASEPLUS]], ptr [[BASE]]
; CHECK-NEXT:    store i32 0, ptr [[BASE]], align 4
; CHECK-NEXT:    call void @p2_same_range(ptr [[BASE]], ptr [[SEL]])
; CHECK-NEXT:    [[L:%.*]] = load i16, ptr [[BASE]], align 2
; CHECK-NEXT:    ret i16 [[L]]
;
  %baseplus = getelementptr i8, ptr %base, i64 1
  %sel = select i1 %x, ptr %baseplus, ptr %base
  store i32 0, ptr %base
  call void @p2_same_range(ptr %base, ptr %sel)
  %l = load i16, ptr %base
  ret i16 %l
}

; Function Attrs: mustprogress nounwind uwtable
define i16 @p2_same_range_may_or_partial_alias_caller2(ptr %base1, ptr %base2) {
; CHECK-LABEL: @p2_same_range_may_or_partial_alias_caller2(
; CHECK-NEXT:    store i32 0, ptr [[BASE1:%.*]], align 4
; CHECK-NEXT:    call void @p2_same_range(ptr [[BASE1]], ptr [[BASE2:%.*]])
; CHECK-NEXT:    [[L:%.*]] = load i16, ptr [[BASE1]], align 2
; CHECK-NEXT:    ret i16 [[L]]
;
  store i32 0, ptr %base1
  call void @p2_same_range(ptr %base1, ptr %base2)
  %l = load i16, ptr %base1
  ret i16 %l
}

; Function Attrs: mustprogress nounwind uwtable
define i16 @p2_no_init_alias_caller() {
; CHECK-LABEL: @p2_no_init_alias_caller(
; CHECK-NEXT:    [[PTR:%.*]] = alloca i16, align 2
; CHECK-NEXT:    store i16 0, ptr [[PTR]], align 2
; CHECK-NEXT:    call void @p2_no_init(ptr [[PTR]], ptr [[PTR]])
; CHECK-NEXT:    [[L:%.*]] = load i16, ptr [[PTR]], align 2
; CHECK-NEXT:    ret i16 [[L]]
;
  %ptr = alloca i16
  store i16 0, ptr %ptr
  call void @p2_no_init(ptr %ptr, ptr %ptr)
  %l = load i16, ptr %ptr
  ret i16 %l
}

; Althrough the 2nd parameter of `p2_no_dead_on_unwind` doesn't have
; the 'dead_on_unwind' attribute, it's invisble to caller on unwind.
; DSE still uses the 'initializes' attribute and kill the dead store.
; Function Attrs: mustprogress nounwind uwtable
define i16 @p2_no_dead_on_unwind_but_invisible_to_caller_alias_caller() {
; CHECK-LABEL: @p2_no_dead_on_unwind_but_invisible_to_caller_alias_caller(
; CHECK-NEXT:    [[PTR:%.*]] = alloca i16, align 2
; CHECK-NEXT:    call void @p2_no_dead_on_unwind(ptr [[PTR]], ptr [[PTR]])
; CHECK-NEXT:    [[L:%.*]] = load i16, ptr [[PTR]], align 2
; CHECK-NEXT:    ret i16 [[L]]
;
  %ptr = alloca i16
  store i16 0, ptr %ptr
  call void @p2_no_dead_on_unwind(ptr %ptr, ptr %ptr)
  %l = load i16, ptr %ptr
  ret i16 %l
}

; Function Attrs: mustprogress nounwind uwtable
define i16 @p2_no_dead_on_unwind_alias_caller(ptr %ptr) {
; CHECK-LABEL: @p2_no_dead_on_unwind_alias_caller(
; CHECK-NEXT:    store i16 0, ptr [[PTR:%.*]], align 2
; CHECK-NEXT:    call void @p2_no_dead_on_unwind(ptr [[PTR]], ptr [[PTR]])
; CHECK-NEXT:    [[L:%.*]] = load i16, ptr [[PTR]], align 2
; CHECK-NEXT:    ret i16 [[L]]
;
  store i16 0, ptr %ptr
  call void @p2_no_dead_on_unwind(ptr %ptr, ptr %ptr)
  %l = load i16, ptr %ptr
  ret i16 %l
}

; Function Attrs: mustprogress nounwind uwtable
define i16 @p2_no_dead_on_unwind_but_nounwind_alias_caller() {
; CHECK-LABEL: @p2_no_dead_on_unwind_but_nounwind_alias_caller(
; CHECK-NEXT:    [[PTR:%.*]] = alloca i16, align 2
; CHECK-NEXT:    call void @p2_no_dead_on_unwind_but_nounwind(ptr [[PTR]], ptr [[PTR]])
; CHECK-NEXT:    [[L:%.*]] = load i16, ptr [[PTR]], align 2
; CHECK-NEXT:    ret i16 [[L]]
;
  %ptr = alloca i16
  store i16 0, ptr %ptr
  call void @p2_no_dead_on_unwind_but_nounwind(ptr %ptr, ptr %ptr)
  %l = load i16, ptr %ptr
  ret i16 %l
}

declare void @llvm.memset.p0.i64(ptr nocapture, i8, i64, i1) nounwind
declare void @large_p1(ptr nocapture noundef initializes((0, 200))) nounwind
declare void @large_p2(ptr nocapture noundef initializes((0, 200)), ptr nocapture noundef initializes((0, 100))) nounwind

; Function Attrs: mustprogress nounwind uwtable
define i16 @large_p1_caller() {
; CHECK-LABEL: @large_p1_caller(
; CHECK-NEXT:    [[PTR:%.*]] = alloca [300 x i8], align 1
; CHECK-NEXT:    [[TMP:%.*]] = getelementptr i8, ptr [[PTR]], i64 100
; CHECK-NEXT:    call void @large_p1(ptr [[TMP]])
; CHECK-NEXT:    [[L:%.*]] = load i16, ptr [[TMP]], align 2
; CHECK-NEXT:    ret i16 [[L]]
;
  %ptr = alloca [300 x i8]
  %tmp = getelementptr i8, ptr %ptr, i64 100
  call void @llvm.memset.p0.i64(ptr %tmp, i8 42, i64 100, i1 false)
  call void @large_p1(ptr %tmp)
  %l = load i16, ptr %tmp
  ret i16 %l
}

; Function Attrs: mustprogress nounwind uwtable
define i16 @large_p2_nonalias_caller() {
; CHECK-LABEL: @large_p2_nonalias_caller(
; CHECK-NEXT:    [[PTR1:%.*]] = alloca [200 x i8], align 1
; CHECK-NEXT:    [[PTR2:%.*]] = alloca [100 x i8], align 1
; CHECK-NEXT:    call void @large_p2(ptr [[PTR1]], ptr [[PTR2]])
; CHECK-NEXT:    [[L:%.*]] = load i16, ptr [[PTR1]], align 2
; CHECK-NEXT:    ret i16 [[L]]
;
  %ptr1 = alloca [200 x i8]
  %ptr2 = alloca [100 x i8]
  call void @llvm.memset.p0.i64(ptr %ptr1, i8 42, i64 200, i1 false)
  call void @llvm.memset.p0.i64(ptr %ptr2, i8 42, i64 100, i1 false)
  call void @large_p2(ptr %ptr1, ptr %ptr2)
  %l = load i16, ptr %ptr1
  ret i16 %l
}


; Function Attrs: mustprogress nounwind uwtable
define i16 @large_p2_must_alias_caller() {
; CHECK-LABEL: @large_p2_must_alias_caller(
; CHECK-NEXT:    [[PTR:%.*]] = alloca [300 x i8], align 1
; CHECK-NEXT:    [[TMP1:%.*]] = getelementptr inbounds i8, ptr [[PTR]], i64 100
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP1]], i8 42, i64 200, i1 false)
; CHECK-NEXT:    call void @large_p2(ptr [[PTR]], ptr [[PTR]])
; CHECK-NEXT:    [[L:%.*]] = load i16, ptr [[PTR]], align 2
; CHECK-NEXT:    ret i16 [[L]]
;
  %ptr = alloca [300 x i8]
  call void @llvm.memset.p0.i64(ptr %ptr, i8 42, i64 300, i1 false)
  call void @large_p2(ptr %ptr, ptr %ptr)
  %l = load i16, ptr %ptr
  ret i16 %l
}

; Function Attrs: mustprogress nounwind uwtable
define i16 @large_p2_may_or_partial_alias_caller1(ptr %base) {
; CHECK-LABEL: @large_p2_may_or_partial_alias_caller1(
; CHECK-NEXT:    [[BASEPLUS:%.*]] = getelementptr i8, ptr [[BASE:%.*]], i64 100
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr [[BASE]], i8 42, i64 300, i1 false)
; CHECK-NEXT:    call void @large_p2(ptr [[BASE]], ptr [[BASEPLUS]])
; CHECK-NEXT:    [[L:%.*]] = load i16, ptr [[BASE]], align 2
; CHECK-NEXT:    ret i16 [[L]]
;
  %baseplus = getelementptr i8, ptr %base, i64 100
  call void @llvm.memset.p0.i64(ptr %base, i8 42, i64 300, i1 false)
  call void @large_p2(ptr %base, ptr %baseplus)
  %l = load i16, ptr %base
  ret i16 %l
}

; Function Attrs: mustprogress nounwind uwtable
define i16 @large_p2_may_or_partial_alias_caller2(ptr %base1, ptr %base2) {
; CHECK-LABEL: @large_p2_may_or_partial_alias_caller2(
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr [[BASE1:%.*]], i8 42, i64 300, i1 false)
; CHECK-NEXT:    call void @large_p2(ptr [[BASE1]], ptr [[BASE2:%.*]])
; CHECK-NEXT:    [[L:%.*]] = load i16, ptr [[BASE1]], align 2
; CHECK-NEXT:    ret i16 [[L]]
;
  call void @llvm.memset.p0.i64(ptr %base1, i8 42, i64 300, i1 false)
  call void @large_p2(ptr %base1, ptr %base2)
  %l = load i16, ptr %base1
  ret i16 %l
}

@g = global i16 123, align 2

declare void @read_global(ptr nocapture noundef initializes((0, 2))) nounwind
  memory(read, argmem: write, inaccessiblemem: none) nounwind

define i16 @global_var_alias() {
; CHECK-LABEL: @global_var_alias(
; CHECK-NEXT:    store i16 0, ptr @g, align 4
; CHECK-NEXT:    call void @read_global(ptr @g)
; CHECK-NEXT:    [[L:%.*]] = load i16, ptr @g, align 2
; CHECK-NEXT:    ret i16 [[L]]
;
  store i16 0, ptr @g, align 4
  call void @read_global(ptr @g)
  %l = load i16, ptr @g
  ret i16 %l
}

declare void @byval_fn(ptr byval(i32) initializes((0, 4)) %am)

define void @test_byval() {
; CHECK-LABEL: @test_byval(
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    store i32 0, ptr [[A]], align 4
; CHECK-NEXT:    call void @byval_fn(ptr [[A]])
; CHECK-NEXT:    ret void
;
  %a = alloca i32
  store i32 0, ptr %a
  call void @byval_fn(ptr %a)
  ret void
}
