; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature
; RUN: opt < %s -passes='module(sanmd-module)' -sanitizer-metadata-atomics -S | FileCheck %s

target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

declare void @escape(ptr)

@sink = global ptr null, align 4
@const_global = external constant i32
@non_const_global = global i32 0, align 4
@const_global_array = external constant [10 x i32]

define i32 @notcaptured() {
; CHECK-LABEL: define {{[^@]+}}@notcaptured() {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[PTR:%.*]] = alloca i32, align 4
; CHECK-NEXT:    store i32 42, ptr [[PTR]], align 4
; CHECK-NEXT:    [[TMP:%.*]] = load i32, ptr [[PTR]], align 4
; CHECK-NEXT:    ret i32 [[TMP]]
;
entry:
  %ptr = alloca i32, align 4
  store i32 42, ptr %ptr, align 4
  %tmp = load i32, ptr %ptr, align 4
  ret i32 %tmp
}

define void @captured0() {
; CHECK-LABEL: define {{[^@]+}}@captured0() !pcsections !0 {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[PTR:%.*]] = alloca i32, align 4
; CHECK-NEXT:    call void @escape(ptr [[PTR]])
; CHECK-NEXT:    store i32 42, ptr [[PTR]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %ptr = alloca i32, align 4
  ; escapes due to call
  call void @escape(ptr %ptr)
  store i32 42, ptr %ptr, align 4
  ret void
}

define void @captured1() {
; CHECK-LABEL: define {{[^@]+}}@captured1() !pcsections !0 {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[PTR:%.*]] = alloca i32, align 4
; CHECK-NEXT:    store ptr [[PTR]], ptr @sink, align 8
; CHECK-NEXT:    store i32 42, ptr [[PTR]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %ptr = alloca i32, align 4
  ; escapes due to store into global
  store ptr %ptr, ptr @sink, align 8
  store i32 42, ptr %ptr, align 4
  ret void
}

define void @captured2() {
; CHECK-LABEL: define {{[^@]+}}@captured2() !pcsections !0 {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[PTR:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
; CHECK-NEXT:    store ptr [[PTR]], ptr [[TMP]], align 8
; CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[TMP]], align 8
; CHECK-NEXT:    store ptr [[TMP0]], ptr @sink, align 8
; CHECK-NEXT:    store i32 42, ptr [[PTR]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %ptr = alloca i32, align 4
  %tmp = alloca ptr, align 8
  ; transitive escape
  store ptr %ptr, ptr %tmp, align 8
  %0 = load ptr, ptr %tmp, align 8
  store ptr %0, ptr @sink, align 8
  store i32 42, ptr %ptr, align 4
  ret void
}

define i32 @read_from_const_global() {
; CHECK-LABEL: define {{[^@]+}}@read_from_const_global() {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr @const_global, align 4
; CHECK-NEXT:    ret i32 [[TMP0]]
;
entry:
  %0 = load i32, ptr @const_global, align 4
  ret i32 %0
}

define i32 @read_from_non_const_global() {
; CHECK-LABEL: define {{[^@]+}}@read_from_non_const_global() !pcsections !0 {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr @non_const_global, align 4
; CHECK-NEXT:    ret i32 [[TMP0]]
;
entry:
  %0 = load i32, ptr @non_const_global, align 4
  ret i32 %0
}

define i32 @read_from_const_global_array(i32 %idx) {
; CHECK-LABEL: define {{[^@]+}}@read_from_const_global_array
; CHECK-SAME: (i32 [[IDX:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[IDXPROM:%.*]] = sext i32 [[IDX]] to i64
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], ptr @const_global_array, i64 0, i64 [[IDXPROM]]
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
; CHECK-NEXT:    ret i32 [[TMP0]]
;
entry:
  %idxprom = sext i32 %idx to i64
  %arrayidx = getelementptr inbounds [10 x i32], ptr @const_global_array, i64 0, i64 %idxprom
  %0 = load i32, ptr %arrayidx, align 4
  ret i32 %0
}

define i32 @notcaptured_and_global_access() {
; CHECK-LABEL: define {{[^@]+}}@notcaptured_and_global_access() !pcsections !0 {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[PTR:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[A:%.*]] = load i32, ptr @non_const_global, align 4
; CHECK-NEXT:    store i32 [[A]], ptr [[PTR]], align 4
; CHECK-NEXT:    [[B:%.*]] = load i32, ptr [[PTR]], align 4
; CHECK-NEXT:    ret i32 [[B]]
;
entry:
  %ptr = alloca i32, align 4
  %a = load i32, ptr @non_const_global, align 4
  store i32 %a, ptr %ptr, align 4
  %b = load i32, ptr %ptr, align 4
  ret i32 %b
}

define i32 @notcaptured_and_const_global_access() {
; CHECK-LABEL: define {{[^@]+}}@notcaptured_and_const_global_access() {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[PTR:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[A:%.*]] = load i32, ptr @const_global, align 4
; CHECK-NEXT:    store i32 [[A]], ptr [[PTR]], align 4
; CHECK-NEXT:    [[B:%.*]] = load i32, ptr [[PTR]], align 4
; CHECK-NEXT:    ret i32 [[B]]
;
entry:
  %ptr = alloca i32, align 4
  %a = load i32, ptr @const_global, align 4
  store i32 %a, ptr %ptr, align 4
  %b = load i32, ptr %ptr, align 4
  ret i32 %b
}
