; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+f -verify-machineinstrs < %s \
; RUN:   -target-abi=ilp32f | FileCheck -check-prefixes=CHECKIF,RV32IF %s
; RUN: llc -mtriple=riscv64 -mattr=+f -verify-machineinstrs < %s \
; RUN:   -target-abi=lp64f | FileCheck -check-prefixes=CHECKIF,RV64IF %s
; RUN: llc -mtriple=riscv32 -mattr=+zfinx -verify-machineinstrs < %s \
; RUN:   -target-abi=ilp32 | FileCheck -check-prefixes=CHECKIZFINX,RV32IZFINX %s
; RUN: llc -mtriple=riscv64 -mattr=+zfinx -verify-machineinstrs < %s \
; RUN:   -target-abi=lp64 | FileCheck -check-prefixes=CHECKIZFINX,RV64IZFINX %s
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV32I %s
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV64I %s

define i32 @fcvt_w_s(float %a) nounwind {
; CHECKIF-LABEL: fcvt_w_s:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fcvt.w.s a0, fa0, rtz
; CHECKIF-NEXT:    ret
;
; CHECKIZFINX-LABEL: fcvt_w_s:
; CHECKIZFINX:       # %bb.0:
; CHECKIZFINX-NEXT:    fcvt.w.s a0, a0, rtz
; CHECKIZFINX-NEXT:    ret
;
; RV32I-LABEL: fcvt_w_s:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __fixsfsi
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_w_s:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __fixsfsi
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = fptosi float %a to i32
  ret i32 %1
}

define i32 @fcvt_w_s_sat(float %a) nounwind {
; CHECKIF-LABEL: fcvt_w_s_sat:
; CHECKIF:       # %bb.0: # %start
; CHECKIF-NEXT:    fcvt.w.s a0, fa0, rtz
; CHECKIF-NEXT:    feq.s a1, fa0, fa0
; CHECKIF-NEXT:    seqz a1, a1
; CHECKIF-NEXT:    addi a1, a1, -1
; CHECKIF-NEXT:    and a0, a1, a0
; CHECKIF-NEXT:    ret
;
; CHECKIZFINX-LABEL: fcvt_w_s_sat:
; CHECKIZFINX:       # %bb.0: # %start
; CHECKIZFINX-NEXT:    fcvt.w.s a1, a0, rtz
; CHECKIZFINX-NEXT:    feq.s a0, a0, a0
; CHECKIZFINX-NEXT:    seqz a0, a0
; CHECKIZFINX-NEXT:    addi a0, a0, -1
; CHECKIZFINX-NEXT:    and a0, a0, a1
; CHECKIZFINX-NEXT:    ret
;
; RV32I-LABEL: fcvt_w_s_sat:
; RV32I:       # %bb.0: # %start
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lui a1, 847872
; RV32I-NEXT:    call __gesf2
; RV32I-NEXT:    mv s2, a0
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __fixsfsi
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    lui s3, 524288
; RV32I-NEXT:    bgez s2, .LBB1_2
; RV32I-NEXT:  # %bb.1: # %start
; RV32I-NEXT:    lui s1, 524288
; RV32I-NEXT:  .LBB1_2: # %start
; RV32I-NEXT:    lui a1, 323584
; RV32I-NEXT:    addi a1, a1, -1
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __gtsf2
; RV32I-NEXT:    blez a0, .LBB1_4
; RV32I-NEXT:  # %bb.3: # %start
; RV32I-NEXT:    addi s1, s3, -1
; RV32I-NEXT:  .LBB1_4: # %start
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    call __unordsf2
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    addi a0, a0, -1
; RV32I-NEXT:    and a0, a0, s1
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_w_s_sat:
; RV64I:       # %bb.0: # %start
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lui a1, 847872
; RV64I-NEXT:    call __gesf2
; RV64I-NEXT:    mv s2, a0
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __fixsfdi
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    lui s3, 524288
; RV64I-NEXT:    bgez s2, .LBB1_2
; RV64I-NEXT:  # %bb.1: # %start
; RV64I-NEXT:    lui s1, 524288
; RV64I-NEXT:  .LBB1_2: # %start
; RV64I-NEXT:    lui a1, 323584
; RV64I-NEXT:    addiw a1, a1, -1
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __gtsf2
; RV64I-NEXT:    blez a0, .LBB1_4
; RV64I-NEXT:  # %bb.3: # %start
; RV64I-NEXT:    addiw s1, s3, -1
; RV64I-NEXT:  .LBB1_4: # %start
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a1, s0
; RV64I-NEXT:    call __unordsf2
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    and a0, a0, s1
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s3, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
start:
  %0 = tail call i32 @llvm.fptosi.sat.i32.f32(float %a)
  ret i32 %0
}
declare i32 @llvm.fptosi.sat.i32.f32(float)

define i32 @fcvt_wu_s(float %a) nounwind {
; CHECKIF-LABEL: fcvt_wu_s:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fcvt.wu.s a0, fa0, rtz
; CHECKIF-NEXT:    ret
;
; CHECKIZFINX-LABEL: fcvt_wu_s:
; CHECKIZFINX:       # %bb.0:
; CHECKIZFINX-NEXT:    fcvt.wu.s a0, a0, rtz
; CHECKIZFINX-NEXT:    ret
;
; RV32I-LABEL: fcvt_wu_s:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __fixunssfsi
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_wu_s:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __fixunssfsi
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = fptoui float %a to i32
  ret i32 %1
}

; Test where the fptoui has multiple uses, one of which causes a sext to be
; inserted on RV64.
define i32 @fcvt_wu_s_multiple_use(float %x, ptr %y) nounwind {
; CHECKIF-LABEL: fcvt_wu_s_multiple_use:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fcvt.wu.s a0, fa0, rtz
; CHECKIF-NEXT:    seqz a1, a0
; CHECKIF-NEXT:    add a0, a0, a1
; CHECKIF-NEXT:    ret
;
; CHECKIZFINX-LABEL: fcvt_wu_s_multiple_use:
; CHECKIZFINX:       # %bb.0:
; CHECKIZFINX-NEXT:    fcvt.wu.s a0, a0, rtz
; CHECKIZFINX-NEXT:    seqz a1, a0
; CHECKIZFINX-NEXT:    add a0, a0, a1
; CHECKIZFINX-NEXT:    ret
;
; RV32I-LABEL: fcvt_wu_s_multiple_use:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __fixunssfsi
; RV32I-NEXT:    seqz a1, a0
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_wu_s_multiple_use:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __fixunssfsi
; RV64I-NEXT:    seqz a1, a0
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %a = fptoui float %x to i32
  %b = icmp eq i32 %a, 0
  %c = select i1 %b, i32 1, i32 %a
  ret i32 %c
}

define i32 @fcvt_wu_s_sat(float %a) nounwind {
; RV32IF-LABEL: fcvt_wu_s_sat:
; RV32IF:       # %bb.0: # %start
; RV32IF-NEXT:    fcvt.wu.s a0, fa0, rtz
; RV32IF-NEXT:    feq.s a1, fa0, fa0
; RV32IF-NEXT:    seqz a1, a1
; RV32IF-NEXT:    addi a1, a1, -1
; RV32IF-NEXT:    and a0, a1, a0
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: fcvt_wu_s_sat:
; RV64IF:       # %bb.0: # %start
; RV64IF-NEXT:    fcvt.wu.s a0, fa0, rtz
; RV64IF-NEXT:    feq.s a1, fa0, fa0
; RV64IF-NEXT:    seqz a1, a1
; RV64IF-NEXT:    addi a1, a1, -1
; RV64IF-NEXT:    and a0, a0, a1
; RV64IF-NEXT:    slli a0, a0, 32
; RV64IF-NEXT:    srli a0, a0, 32
; RV64IF-NEXT:    ret
;
; RV32IZFINX-LABEL: fcvt_wu_s_sat:
; RV32IZFINX:       # %bb.0: # %start
; RV32IZFINX-NEXT:    fcvt.wu.s a1, a0, rtz
; RV32IZFINX-NEXT:    feq.s a0, a0, a0
; RV32IZFINX-NEXT:    seqz a0, a0
; RV32IZFINX-NEXT:    addi a0, a0, -1
; RV32IZFINX-NEXT:    and a0, a0, a1
; RV32IZFINX-NEXT:    ret
;
; RV64IZFINX-LABEL: fcvt_wu_s_sat:
; RV64IZFINX:       # %bb.0: # %start
; RV64IZFINX-NEXT:    fcvt.wu.s a1, a0, rtz
; RV64IZFINX-NEXT:    feq.s a0, a0, a0
; RV64IZFINX-NEXT:    seqz a0, a0
; RV64IZFINX-NEXT:    addi a0, a0, -1
; RV64IZFINX-NEXT:    and a0, a1, a0
; RV64IZFINX-NEXT:    slli a0, a0, 32
; RV64IZFINX-NEXT:    srli a0, a0, 32
; RV64IZFINX-NEXT:    ret
;
; RV32I-LABEL: fcvt_wu_s_sat:
; RV32I:       # %bb.0: # %start
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    call __gesf2
; RV32I-NEXT:    slti a0, a0, 0
; RV32I-NEXT:    addi s1, a0, -1
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __fixunssfsi
; RV32I-NEXT:    and s1, s1, a0
; RV32I-NEXT:    lui a1, 325632
; RV32I-NEXT:    addi a1, a1, -1
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __gtsf2
; RV32I-NEXT:    sgtz a0, a0
; RV32I-NEXT:    neg a0, a0
; RV32I-NEXT:    or a0, a0, s1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_wu_s_sat:
; RV64I:       # %bb.0: # %start
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s2, a0
; RV64I-NEXT:    li a1, 0
; RV64I-NEXT:    call __gesf2
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    mv a0, s2
; RV64I-NEXT:    call __fixunssfdi
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    lui a1, 325632
; RV64I-NEXT:    addiw a1, a1, -1
; RV64I-NEXT:    mv a0, s2
; RV64I-NEXT:    call __gtsf2
; RV64I-NEXT:    blez a0, .LBB4_2
; RV64I-NEXT:  # %bb.1: # %start
; RV64I-NEXT:    li a0, -1
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    j .LBB4_3
; RV64I-NEXT:  .LBB4_2:
; RV64I-NEXT:    slti a0, s0, 0
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    and a0, a0, s1
; RV64I-NEXT:  .LBB4_3: # %start
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
start:
  %0 = tail call i32 @llvm.fptoui.sat.i32.f32(float %a)
  ret i32 %0
}
declare i32 @llvm.fptoui.sat.i32.f32(float)

define signext i32 @fmv_x_w(float %a, float %b) nounwind {
; CHECKIF-LABEL: fmv_x_w:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fadd.s fa5, fa0, fa1
; CHECKIF-NEXT:    fmv.x.w a0, fa5
; CHECKIF-NEXT:    ret
;
; RV32IZFINX-LABEL: fmv_x_w:
; RV32IZFINX:       # %bb.0:
; RV32IZFINX-NEXT:    fadd.s a0, a0, a1
; RV32IZFINX-NEXT:    ret
;
; RV64IZFINX-LABEL: fmv_x_w:
; RV64IZFINX:       # %bb.0:
; RV64IZFINX-NEXT:    fadd.s a0, a0, a1
; RV64IZFINX-NEXT:    sext.w a0, a0
; RV64IZFINX-NEXT:    ret
;
; RV32I-LABEL: fmv_x_w:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __addsf3
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fmv_x_w:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __addsf3
; RV64I-NEXT:    sext.w a0, a0
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
; Ensure fmv.x.w is generated even for a soft float calling convention
  %1 = fadd float %a, %b
  %2 = bitcast float %1 to i32
  ret i32 %2
}

define float @fcvt_s_w(i32 %a) nounwind {
; CHECKIF-LABEL: fcvt_s_w:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fcvt.s.w fa0, a0
; CHECKIF-NEXT:    ret
;
; CHECKIZFINX-LABEL: fcvt_s_w:
; CHECKIZFINX:       # %bb.0:
; CHECKIZFINX-NEXT:    fcvt.s.w a0, a0
; CHECKIZFINX-NEXT:    ret
;
; RV32I-LABEL: fcvt_s_w:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __floatsisf
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_s_w:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sext.w a0, a0
; RV64I-NEXT:    call __floatsisf
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = sitofp i32 %a to float
  ret float %1
}

define float @fcvt_s_w_load(ptr %p) nounwind {
; CHECKIF-LABEL: fcvt_s_w_load:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    lw a0, 0(a0)
; CHECKIF-NEXT:    fcvt.s.w fa0, a0
; CHECKIF-NEXT:    ret
;
; CHECKIZFINX-LABEL: fcvt_s_w_load:
; CHECKIZFINX:       # %bb.0:
; CHECKIZFINX-NEXT:    lw a0, 0(a0)
; CHECKIZFINX-NEXT:    fcvt.s.w a0, a0
; CHECKIZFINX-NEXT:    ret
;
; RV32I-LABEL: fcvt_s_w_load:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lw a0, 0(a0)
; RV32I-NEXT:    call __floatsisf
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_s_w_load:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lw a0, 0(a0)
; RV64I-NEXT:    call __floatsisf
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %a = load i32, ptr %p
  %1 = sitofp i32 %a to float
  ret float %1
}

define float @fcvt_s_wu(i32 %a) nounwind {
; CHECKIF-LABEL: fcvt_s_wu:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fcvt.s.wu fa0, a0
; CHECKIF-NEXT:    ret
;
; CHECKIZFINX-LABEL: fcvt_s_wu:
; CHECKIZFINX:       # %bb.0:
; CHECKIZFINX-NEXT:    fcvt.s.wu a0, a0
; CHECKIZFINX-NEXT:    ret
;
; RV32I-LABEL: fcvt_s_wu:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __floatunsisf
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_s_wu:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sext.w a0, a0
; RV64I-NEXT:    call __floatunsisf
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = uitofp i32 %a to float
  ret float %1
}

define float @fcvt_s_wu_load(ptr %p) nounwind {
; RV32IF-LABEL: fcvt_s_wu_load:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    lw a0, 0(a0)
; RV32IF-NEXT:    fcvt.s.wu fa0, a0
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: fcvt_s_wu_load:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    lwu a0, 0(a0)
; RV64IF-NEXT:    fcvt.s.wu fa0, a0
; RV64IF-NEXT:    ret
;
; RV32IZFINX-LABEL: fcvt_s_wu_load:
; RV32IZFINX:       # %bb.0:
; RV32IZFINX-NEXT:    lw a0, 0(a0)
; RV32IZFINX-NEXT:    fcvt.s.wu a0, a0
; RV32IZFINX-NEXT:    ret
;
; RV64IZFINX-LABEL: fcvt_s_wu_load:
; RV64IZFINX:       # %bb.0:
; RV64IZFINX-NEXT:    lwu a0, 0(a0)
; RV64IZFINX-NEXT:    fcvt.s.wu a0, a0
; RV64IZFINX-NEXT:    ret
;
; RV32I-LABEL: fcvt_s_wu_load:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lw a0, 0(a0)
; RV32I-NEXT:    call __floatunsisf
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_s_wu_load:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lw a0, 0(a0)
; RV64I-NEXT:    call __floatunsisf
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %a = load i32, ptr %p
  %1 = uitofp i32 %a to float
  ret float %1
}

define float @fmv_w_x(i32 %a, i32 %b) nounwind {
; CHECKIF-LABEL: fmv_w_x:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fmv.w.x fa5, a0
; CHECKIF-NEXT:    fmv.w.x fa4, a1
; CHECKIF-NEXT:    fadd.s fa0, fa5, fa4
; CHECKIF-NEXT:    ret
;
; CHECKIZFINX-LABEL: fmv_w_x:
; CHECKIZFINX:       # %bb.0:
; CHECKIZFINX-NEXT:    fadd.s a0, a0, a1
; CHECKIZFINX-NEXT:    ret
;
; RV32I-LABEL: fmv_w_x:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __addsf3
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fmv_w_x:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __addsf3
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
; Ensure fmv.w.x is generated even for a soft float calling convention
  %1 = bitcast i32 %a to float
  %2 = bitcast i32 %b to float
  %3 = fadd float %1, %2
  ret float %3
}

define i64 @fcvt_l_s(float %a) nounwind {
; RV32IF-LABEL: fcvt_l_s:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    call __fixsfdi
; RV32IF-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: fcvt_l_s:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fcvt.l.s a0, fa0, rtz
; RV64IF-NEXT:    ret
;
; RV32IZFINX-LABEL: fcvt_l_s:
; RV32IZFINX:       # %bb.0:
; RV32IZFINX-NEXT:    addi sp, sp, -16
; RV32IZFINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    call __fixsfdi
; RV32IZFINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    addi sp, sp, 16
; RV32IZFINX-NEXT:    ret
;
; RV64IZFINX-LABEL: fcvt_l_s:
; RV64IZFINX:       # %bb.0:
; RV64IZFINX-NEXT:    fcvt.l.s a0, a0, rtz
; RV64IZFINX-NEXT:    ret
;
; RV32I-LABEL: fcvt_l_s:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __fixsfdi
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_l_s:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __fixsfdi
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = fptosi float %a to i64
  ret i64 %1
}

define i64 @fcvt_l_s_sat(float %a) nounwind {
; RV32IF-LABEL: fcvt_l_s_sat:
; RV32IF:       # %bb.0: # %start
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs0, fa0
; RV32IF-NEXT:    lui a0, 913408
; RV32IF-NEXT:    fmv.w.x fa5, a0
; RV32IF-NEXT:    fle.s s0, fa5, fa0
; RV32IF-NEXT:    call __fixsfdi
; RV32IF-NEXT:    lui a3, 524288
; RV32IF-NEXT:    lui a2, 524288
; RV32IF-NEXT:    beqz s0, .LBB12_2
; RV32IF-NEXT:  # %bb.1: # %start
; RV32IF-NEXT:    mv a2, a1
; RV32IF-NEXT:  .LBB12_2: # %start
; RV32IF-NEXT:    lui a1, %hi(.LCPI12_0)
; RV32IF-NEXT:    flw fa5, %lo(.LCPI12_0)(a1)
; RV32IF-NEXT:    flt.s a1, fa5, fs0
; RV32IF-NEXT:    beqz a1, .LBB12_4
; RV32IF-NEXT:  # %bb.3:
; RV32IF-NEXT:    addi a2, a3, -1
; RV32IF-NEXT:  .LBB12_4: # %start
; RV32IF-NEXT:    feq.s a3, fs0, fs0
; RV32IF-NEXT:    neg a4, s0
; RV32IF-NEXT:    neg a5, a1
; RV32IF-NEXT:    neg a3, a3
; RV32IF-NEXT:    and a0, a4, a0
; RV32IF-NEXT:    and a1, a3, a2
; RV32IF-NEXT:    or a0, a5, a0
; RV32IF-NEXT:    and a0, a3, a0
; RV32IF-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: fcvt_l_s_sat:
; RV64IF:       # %bb.0: # %start
; RV64IF-NEXT:    fcvt.l.s a0, fa0, rtz
; RV64IF-NEXT:    feq.s a1, fa0, fa0
; RV64IF-NEXT:    seqz a1, a1
; RV64IF-NEXT:    addi a1, a1, -1
; RV64IF-NEXT:    and a0, a1, a0
; RV64IF-NEXT:    ret
;
; RV32IZFINX-LABEL: fcvt_l_s_sat:
; RV32IZFINX:       # %bb.0: # %start
; RV32IZFINX-NEXT:    addi sp, sp, -16
; RV32IZFINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    mv s0, a0
; RV32IZFINX-NEXT:    lui a0, 913408
; RV32IZFINX-NEXT:    fle.s s1, a0, s0
; RV32IZFINX-NEXT:    mv a0, s0
; RV32IZFINX-NEXT:    call __fixsfdi
; RV32IZFINX-NEXT:    lui a3, 524288
; RV32IZFINX-NEXT:    lui a2, 524288
; RV32IZFINX-NEXT:    beqz s1, .LBB12_2
; RV32IZFINX-NEXT:  # %bb.1: # %start
; RV32IZFINX-NEXT:    mv a2, a1
; RV32IZFINX-NEXT:  .LBB12_2: # %start
; RV32IZFINX-NEXT:    lui a1, 389120
; RV32IZFINX-NEXT:    addi a1, a1, -1
; RV32IZFINX-NEXT:    flt.s a1, a1, s0
; RV32IZFINX-NEXT:    beqz a1, .LBB12_4
; RV32IZFINX-NEXT:  # %bb.3:
; RV32IZFINX-NEXT:    addi a2, a3, -1
; RV32IZFINX-NEXT:  .LBB12_4: # %start
; RV32IZFINX-NEXT:    feq.s a3, s0, s0
; RV32IZFINX-NEXT:    neg a4, s1
; RV32IZFINX-NEXT:    neg a5, a1
; RV32IZFINX-NEXT:    neg a3, a3
; RV32IZFINX-NEXT:    and a0, a4, a0
; RV32IZFINX-NEXT:    and a1, a3, a2
; RV32IZFINX-NEXT:    or a0, a5, a0
; RV32IZFINX-NEXT:    and a0, a3, a0
; RV32IZFINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    addi sp, sp, 16
; RV32IZFINX-NEXT:    ret
;
; RV64IZFINX-LABEL: fcvt_l_s_sat:
; RV64IZFINX:       # %bb.0: # %start
; RV64IZFINX-NEXT:    fcvt.l.s a1, a0, rtz
; RV64IZFINX-NEXT:    feq.s a0, a0, a0
; RV64IZFINX-NEXT:    seqz a0, a0
; RV64IZFINX-NEXT:    addi a0, a0, -1
; RV64IZFINX-NEXT:    and a0, a0, a1
; RV64IZFINX-NEXT:    ret
;
; RV32I-LABEL: fcvt_l_s_sat:
; RV32I:       # %bb.0: # %start
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s4, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s5, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    lui a1, 913408
; RV32I-NEXT:    call __gesf2
; RV32I-NEXT:    mv s2, a0
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    call __fixsfdi
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    mv s3, a1
; RV32I-NEXT:    lui s5, 524288
; RV32I-NEXT:    bgez s2, .LBB12_2
; RV32I-NEXT:  # %bb.1: # %start
; RV32I-NEXT:    lui s3, 524288
; RV32I-NEXT:  .LBB12_2: # %start
; RV32I-NEXT:    lui a1, 389120
; RV32I-NEXT:    addi a1, a1, -1
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    call __gtsf2
; RV32I-NEXT:    mv s4, a0
; RV32I-NEXT:    blez a0, .LBB12_4
; RV32I-NEXT:  # %bb.3: # %start
; RV32I-NEXT:    addi s3, s5, -1
; RV32I-NEXT:  .LBB12_4: # %start
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    mv a1, s1
; RV32I-NEXT:    call __unordsf2
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    slti a1, s2, 0
; RV32I-NEXT:    sgtz a2, s4
; RV32I-NEXT:    addi a0, a0, -1
; RV32I-NEXT:    addi a3, a1, -1
; RV32I-NEXT:    and a1, a0, s3
; RV32I-NEXT:    and a3, a3, s0
; RV32I-NEXT:    neg a2, a2
; RV32I-NEXT:    or a2, a2, a3
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s4, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s5, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_l_s_sat:
; RV64I:       # %bb.0: # %start
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lui a1, 913408
; RV64I-NEXT:    call __gesf2
; RV64I-NEXT:    mv s2, a0
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __fixsfdi
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    li s3, -1
; RV64I-NEXT:    bgez s2, .LBB12_2
; RV64I-NEXT:  # %bb.1: # %start
; RV64I-NEXT:    slli s1, s3, 63
; RV64I-NEXT:  .LBB12_2: # %start
; RV64I-NEXT:    lui a1, 389120
; RV64I-NEXT:    addiw a1, a1, -1
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __gtsf2
; RV64I-NEXT:    blez a0, .LBB12_4
; RV64I-NEXT:  # %bb.3: # %start
; RV64I-NEXT:    srli s1, s3, 1
; RV64I-NEXT:  .LBB12_4: # %start
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a1, s0
; RV64I-NEXT:    call __unordsf2
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    and a0, a0, s1
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s3, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
start:
  %0 = tail call i64 @llvm.fptosi.sat.i64.f32(float %a)
  ret i64 %0
}
declare i64 @llvm.fptosi.sat.i64.f32(float)

define i64 @fcvt_lu_s(float %a) nounwind {
; RV32IF-LABEL: fcvt_lu_s:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    call __fixunssfdi
; RV32IF-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: fcvt_lu_s:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fcvt.lu.s a0, fa0, rtz
; RV64IF-NEXT:    ret
;
; RV32IZFINX-LABEL: fcvt_lu_s:
; RV32IZFINX:       # %bb.0:
; RV32IZFINX-NEXT:    addi sp, sp, -16
; RV32IZFINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    call __fixunssfdi
; RV32IZFINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    addi sp, sp, 16
; RV32IZFINX-NEXT:    ret
;
; RV64IZFINX-LABEL: fcvt_lu_s:
; RV64IZFINX:       # %bb.0:
; RV64IZFINX-NEXT:    fcvt.lu.s a0, a0, rtz
; RV64IZFINX-NEXT:    ret
;
; RV32I-LABEL: fcvt_lu_s:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __fixunssfdi
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_lu_s:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __fixunssfdi
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = fptoui float %a to i64
  ret i64 %1
}

define i64 @fcvt_lu_s_sat(float %a) nounwind {
; RV32IF-LABEL: fcvt_lu_s_sat:
; RV32IF:       # %bb.0: # %start
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs0, fa0
; RV32IF-NEXT:    fmv.w.x fa5, zero
; RV32IF-NEXT:    fle.s a0, fa5, fa0
; RV32IF-NEXT:    neg s0, a0
; RV32IF-NEXT:    call __fixunssfdi
; RV32IF-NEXT:    lui a2, %hi(.LCPI14_0)
; RV32IF-NEXT:    flw fa5, %lo(.LCPI14_0)(a2)
; RV32IF-NEXT:    and a0, s0, a0
; RV32IF-NEXT:    and a1, s0, a1
; RV32IF-NEXT:    flt.s a2, fa5, fs0
; RV32IF-NEXT:    neg a2, a2
; RV32IF-NEXT:    or a0, a2, a0
; RV32IF-NEXT:    or a1, a2, a1
; RV32IF-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: fcvt_lu_s_sat:
; RV64IF:       # %bb.0: # %start
; RV64IF-NEXT:    fcvt.lu.s a0, fa0, rtz
; RV64IF-NEXT:    feq.s a1, fa0, fa0
; RV64IF-NEXT:    seqz a1, a1
; RV64IF-NEXT:    addi a1, a1, -1
; RV64IF-NEXT:    and a0, a1, a0
; RV64IF-NEXT:    ret
;
; RV32IZFINX-LABEL: fcvt_lu_s_sat:
; RV32IZFINX:       # %bb.0: # %start
; RV32IZFINX-NEXT:    addi sp, sp, -16
; RV32IZFINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    mv s0, a0
; RV32IZFINX-NEXT:    fle.s a0, zero, a0
; RV32IZFINX-NEXT:    neg s1, a0
; RV32IZFINX-NEXT:    mv a0, s0
; RV32IZFINX-NEXT:    call __fixunssfdi
; RV32IZFINX-NEXT:    and a0, s1, a0
; RV32IZFINX-NEXT:    lui a2, 391168
; RV32IZFINX-NEXT:    and a1, s1, a1
; RV32IZFINX-NEXT:    addi a2, a2, -1
; RV32IZFINX-NEXT:    flt.s a2, a2, s0
; RV32IZFINX-NEXT:    neg a2, a2
; RV32IZFINX-NEXT:    or a0, a2, a0
; RV32IZFINX-NEXT:    or a1, a2, a1
; RV32IZFINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    addi sp, sp, 16
; RV32IZFINX-NEXT:    ret
;
; RV64IZFINX-LABEL: fcvt_lu_s_sat:
; RV64IZFINX:       # %bb.0: # %start
; RV64IZFINX-NEXT:    fcvt.lu.s a1, a0, rtz
; RV64IZFINX-NEXT:    feq.s a0, a0, a0
; RV64IZFINX-NEXT:    seqz a0, a0
; RV64IZFINX-NEXT:    addi a0, a0, -1
; RV64IZFINX-NEXT:    and a0, a0, a1
; RV64IZFINX-NEXT:    ret
;
; RV32I-LABEL: fcvt_lu_s_sat:
; RV32I:       # %bb.0: # %start
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    call __gesf2
; RV32I-NEXT:    slti a0, a0, 0
; RV32I-NEXT:    addi s2, a0, -1
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __fixunssfdi
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    and s3, s2, a0
; RV32I-NEXT:    lui a1, 391168
; RV32I-NEXT:    addi a1, a1, -1
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __gtsf2
; RV32I-NEXT:    sgtz a0, a0
; RV32I-NEXT:    and a1, s2, s1
; RV32I-NEXT:    neg a2, a0
; RV32I-NEXT:    or a0, a2, s3
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_lu_s_sat:
; RV64I:       # %bb.0: # %start
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lui a1, 391168
; RV64I-NEXT:    addiw a1, a1, -1
; RV64I-NEXT:    call __gtsf2
; RV64I-NEXT:    sgtz a0, a0
; RV64I-NEXT:    neg s1, a0
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    li a1, 0
; RV64I-NEXT:    call __gesf2
; RV64I-NEXT:    slti a0, a0, 0
; RV64I-NEXT:    addi s2, a0, -1
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __fixunssfdi
; RV64I-NEXT:    and a0, s2, a0
; RV64I-NEXT:    or a0, s1, a0
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
start:
  %0 = tail call i64 @llvm.fptoui.sat.i64.f32(float %a)
  ret i64 %0
}
declare i64 @llvm.fptoui.sat.i64.f32(float)

define float @fcvt_s_l(i64 %a) nounwind {
; RV32IF-LABEL: fcvt_s_l:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    call __floatdisf
; RV32IF-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: fcvt_s_l:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fcvt.s.l fa0, a0
; RV64IF-NEXT:    ret
;
; RV32IZFINX-LABEL: fcvt_s_l:
; RV32IZFINX:       # %bb.0:
; RV32IZFINX-NEXT:    addi sp, sp, -16
; RV32IZFINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    call __floatdisf
; RV32IZFINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    addi sp, sp, 16
; RV32IZFINX-NEXT:    ret
;
; RV64IZFINX-LABEL: fcvt_s_l:
; RV64IZFINX:       # %bb.0:
; RV64IZFINX-NEXT:    fcvt.s.l a0, a0
; RV64IZFINX-NEXT:    ret
;
; RV32I-LABEL: fcvt_s_l:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __floatdisf
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_s_l:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __floatdisf
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = sitofp i64 %a to float
  ret float %1
}

define float @fcvt_s_lu(i64 %a) nounwind {
; RV32IF-LABEL: fcvt_s_lu:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    call __floatundisf
; RV32IF-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: fcvt_s_lu:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fcvt.s.lu fa0, a0
; RV64IF-NEXT:    ret
;
; RV32IZFINX-LABEL: fcvt_s_lu:
; RV32IZFINX:       # %bb.0:
; RV32IZFINX-NEXT:    addi sp, sp, -16
; RV32IZFINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    call __floatundisf
; RV32IZFINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    addi sp, sp, 16
; RV32IZFINX-NEXT:    ret
;
; RV64IZFINX-LABEL: fcvt_s_lu:
; RV64IZFINX:       # %bb.0:
; RV64IZFINX-NEXT:    fcvt.s.lu a0, a0
; RV64IZFINX-NEXT:    ret
;
; RV32I-LABEL: fcvt_s_lu:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __floatundisf
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_s_lu:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __floatundisf
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = uitofp i64 %a to float
  ret float %1
}

define float @fcvt_s_w_i8(i8 signext %a) nounwind {
; CHECKIF-LABEL: fcvt_s_w_i8:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fcvt.s.w fa0, a0
; CHECKIF-NEXT:    ret
;
; CHECKIZFINX-LABEL: fcvt_s_w_i8:
; CHECKIZFINX:       # %bb.0:
; CHECKIZFINX-NEXT:    fcvt.s.w a0, a0
; CHECKIZFINX-NEXT:    ret
;
; RV32I-LABEL: fcvt_s_w_i8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __floatsisf
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_s_w_i8:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __floatsisf
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = sitofp i8 %a to float
  ret float %1
}

define float @fcvt_s_wu_i8(i8 zeroext %a) nounwind {
; CHECKIF-LABEL: fcvt_s_wu_i8:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fcvt.s.wu fa0, a0
; CHECKIF-NEXT:    ret
;
; CHECKIZFINX-LABEL: fcvt_s_wu_i8:
; CHECKIZFINX:       # %bb.0:
; CHECKIZFINX-NEXT:    fcvt.s.wu a0, a0
; CHECKIZFINX-NEXT:    ret
;
; RV32I-LABEL: fcvt_s_wu_i8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __floatunsisf
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_s_wu_i8:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __floatunsisf
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = uitofp i8 %a to float
  ret float %1
}

define float @fcvt_s_w_i16(i16 signext %a) nounwind {
; CHECKIF-LABEL: fcvt_s_w_i16:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fcvt.s.w fa0, a0
; CHECKIF-NEXT:    ret
;
; CHECKIZFINX-LABEL: fcvt_s_w_i16:
; CHECKIZFINX:       # %bb.0:
; CHECKIZFINX-NEXT:    fcvt.s.w a0, a0
; CHECKIZFINX-NEXT:    ret
;
; RV32I-LABEL: fcvt_s_w_i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __floatsisf
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_s_w_i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __floatsisf
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = sitofp i16 %a to float
  ret float %1
}

define float @fcvt_s_wu_i16(i16 zeroext %a) nounwind {
; CHECKIF-LABEL: fcvt_s_wu_i16:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fcvt.s.wu fa0, a0
; CHECKIF-NEXT:    ret
;
; CHECKIZFINX-LABEL: fcvt_s_wu_i16:
; CHECKIZFINX:       # %bb.0:
; CHECKIZFINX-NEXT:    fcvt.s.wu a0, a0
; CHECKIZFINX-NEXT:    ret
;
; RV32I-LABEL: fcvt_s_wu_i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __floatunsisf
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_s_wu_i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __floatunsisf
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = uitofp i16 %a to float
  ret float %1
}

; Make sure we select W version of addi on RV64.
define signext i32 @fcvt_s_w_demanded_bits(i32 signext %0, ptr %1) nounwind {
; RV32IF-LABEL: fcvt_s_w_demanded_bits:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi a0, a0, 1
; RV32IF-NEXT:    fcvt.s.w fa5, a0
; RV32IF-NEXT:    fsw fa5, 0(a1)
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: fcvt_s_w_demanded_bits:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    addiw a0, a0, 1
; RV64IF-NEXT:    fcvt.s.w fa5, a0
; RV64IF-NEXT:    fsw fa5, 0(a1)
; RV64IF-NEXT:    ret
;
; RV32IZFINX-LABEL: fcvt_s_w_demanded_bits:
; RV32IZFINX:       # %bb.0:
; RV32IZFINX-NEXT:    addi a0, a0, 1
; RV32IZFINX-NEXT:    fcvt.s.w a2, a0
; RV32IZFINX-NEXT:    sw a2, 0(a1)
; RV32IZFINX-NEXT:    ret
;
; RV64IZFINX-LABEL: fcvt_s_w_demanded_bits:
; RV64IZFINX:       # %bb.0:
; RV64IZFINX-NEXT:    addiw a0, a0, 1
; RV64IZFINX-NEXT:    fcvt.s.w a2, a0
; RV64IZFINX-NEXT:    sw a2, 0(a1)
; RV64IZFINX-NEXT:    ret
;
; RV32I-LABEL: fcvt_s_w_demanded_bits:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    addi s1, a0, 1
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    call __floatsisf
; RV32I-NEXT:    sw a0, 0(s0)
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_s_w_demanded_bits:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a1
; RV64I-NEXT:    addiw s1, a0, 1
; RV64I-NEXT:    mv a0, s1
; RV64I-NEXT:    call __floatsisf
; RV64I-NEXT:    sw a0, 0(s0)
; RV64I-NEXT:    mv a0, s1
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
  %3 = add i32 %0, 1
  %4 = sitofp i32 %3 to float
  store float %4, ptr %1, align 4
  ret i32 %3
}

; Make sure we select W version of addi on RV64.
define signext i32 @fcvt_s_wu_demanded_bits(i32 signext %0, ptr %1) nounwind {
; RV32IF-LABEL: fcvt_s_wu_demanded_bits:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi a0, a0, 1
; RV32IF-NEXT:    fcvt.s.wu fa5, a0
; RV32IF-NEXT:    fsw fa5, 0(a1)
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: fcvt_s_wu_demanded_bits:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    addiw a0, a0, 1
; RV64IF-NEXT:    fcvt.s.wu fa5, a0
; RV64IF-NEXT:    fsw fa5, 0(a1)
; RV64IF-NEXT:    ret
;
; RV32IZFINX-LABEL: fcvt_s_wu_demanded_bits:
; RV32IZFINX:       # %bb.0:
; RV32IZFINX-NEXT:    addi a0, a0, 1
; RV32IZFINX-NEXT:    fcvt.s.wu a2, a0
; RV32IZFINX-NEXT:    sw a2, 0(a1)
; RV32IZFINX-NEXT:    ret
;
; RV64IZFINX-LABEL: fcvt_s_wu_demanded_bits:
; RV64IZFINX:       # %bb.0:
; RV64IZFINX-NEXT:    addiw a0, a0, 1
; RV64IZFINX-NEXT:    fcvt.s.wu a2, a0
; RV64IZFINX-NEXT:    sw a2, 0(a1)
; RV64IZFINX-NEXT:    ret
;
; RV32I-LABEL: fcvt_s_wu_demanded_bits:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    addi s1, a0, 1
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    call __floatunsisf
; RV32I-NEXT:    sw a0, 0(s0)
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_s_wu_demanded_bits:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a1
; RV64I-NEXT:    addiw s1, a0, 1
; RV64I-NEXT:    mv a0, s1
; RV64I-NEXT:    call __floatunsisf
; RV64I-NEXT:    sw a0, 0(s0)
; RV64I-NEXT:    mv a0, s1
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
  %3 = add i32 %0, 1
  %4 = uitofp i32 %3 to float
  store float %4, ptr %1, align 4
  ret i32 %3
}

define signext i16 @fcvt_w_s_i16(float %a) nounwind {
; RV32IF-LABEL: fcvt_w_s_i16:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fcvt.w.s a0, fa0, rtz
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: fcvt_w_s_i16:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fcvt.l.s a0, fa0, rtz
; RV64IF-NEXT:    ret
;
; RV32IZFINX-LABEL: fcvt_w_s_i16:
; RV32IZFINX:       # %bb.0:
; RV32IZFINX-NEXT:    fcvt.w.s a0, a0, rtz
; RV32IZFINX-NEXT:    ret
;
; RV64IZFINX-LABEL: fcvt_w_s_i16:
; RV64IZFINX:       # %bb.0:
; RV64IZFINX-NEXT:    fcvt.l.s a0, a0, rtz
; RV64IZFINX-NEXT:    ret
;
; RV32I-LABEL: fcvt_w_s_i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __fixsfsi
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_w_s_i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __fixsfdi
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = fptosi float %a to i16
  ret i16 %1
}

define signext i16 @fcvt_w_s_sat_i16(float %a) nounwind {
; RV32IF-LABEL: fcvt_w_s_sat_i16:
; RV32IF:       # %bb.0: # %start
; RV32IF-NEXT:    feq.s a0, fa0, fa0
; RV32IF-NEXT:    lui a1, %hi(.LCPI24_0)
; RV32IF-NEXT:    flw fa5, %lo(.LCPI24_0)(a1)
; RV32IF-NEXT:    lui a1, 815104
; RV32IF-NEXT:    fmv.w.x fa4, a1
; RV32IF-NEXT:    fmax.s fa4, fa0, fa4
; RV32IF-NEXT:    neg a0, a0
; RV32IF-NEXT:    fmin.s fa5, fa4, fa5
; RV32IF-NEXT:    fcvt.w.s a1, fa5, rtz
; RV32IF-NEXT:    and a0, a0, a1
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: fcvt_w_s_sat_i16:
; RV64IF:       # %bb.0: # %start
; RV64IF-NEXT:    feq.s a0, fa0, fa0
; RV64IF-NEXT:    lui a1, %hi(.LCPI24_0)
; RV64IF-NEXT:    flw fa5, %lo(.LCPI24_0)(a1)
; RV64IF-NEXT:    lui a1, 815104
; RV64IF-NEXT:    fmv.w.x fa4, a1
; RV64IF-NEXT:    fmax.s fa4, fa0, fa4
; RV64IF-NEXT:    neg a0, a0
; RV64IF-NEXT:    fmin.s fa5, fa4, fa5
; RV64IF-NEXT:    fcvt.l.s a1, fa5, rtz
; RV64IF-NEXT:    and a0, a0, a1
; RV64IF-NEXT:    ret
;
; RV32IZFINX-LABEL: fcvt_w_s_sat_i16:
; RV32IZFINX:       # %bb.0: # %start
; RV32IZFINX-NEXT:    feq.s a1, a0, a0
; RV32IZFINX-NEXT:    lui a2, 815104
; RV32IZFINX-NEXT:    fmax.s a0, a0, a2
; RV32IZFINX-NEXT:    lui a2, 290816
; RV32IZFINX-NEXT:    neg a1, a1
; RV32IZFINX-NEXT:    addi a2, a2, -512
; RV32IZFINX-NEXT:    fmin.s a0, a0, a2
; RV32IZFINX-NEXT:    fcvt.w.s a0, a0, rtz
; RV32IZFINX-NEXT:    and a0, a1, a0
; RV32IZFINX-NEXT:    ret
;
; RV64IZFINX-LABEL: fcvt_w_s_sat_i16:
; RV64IZFINX:       # %bb.0: # %start
; RV64IZFINX-NEXT:    feq.s a1, a0, a0
; RV64IZFINX-NEXT:    lui a2, 815104
; RV64IZFINX-NEXT:    fmax.s a0, a0, a2
; RV64IZFINX-NEXT:    lui a2, 290816
; RV64IZFINX-NEXT:    neg a1, a1
; RV64IZFINX-NEXT:    addiw a2, a2, -512
; RV64IZFINX-NEXT:    fmin.s a0, a0, a2
; RV64IZFINX-NEXT:    fcvt.l.s a0, a0, rtz
; RV64IZFINX-NEXT:    and a0, a1, a0
; RV64IZFINX-NEXT:    ret
;
; RV32I-LABEL: fcvt_w_s_sat_i16:
; RV32I:       # %bb.0: # %start
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 0(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lui a1, 815104
; RV32I-NEXT:    call __gesf2
; RV32I-NEXT:    mv s2, a0
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __fixsfsi
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    bgez s2, .LBB24_2
; RV32I-NEXT:  # %bb.1: # %start
; RV32I-NEXT:    lui s1, 1048568
; RV32I-NEXT:  .LBB24_2: # %start
; RV32I-NEXT:    lui a0, 290816
; RV32I-NEXT:    addi a1, a0, -512
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __gtsf2
; RV32I-NEXT:    blez a0, .LBB24_4
; RV32I-NEXT:  # %bb.3: # %start
; RV32I-NEXT:    lui s1, 8
; RV32I-NEXT:    addi s1, s1, -1
; RV32I-NEXT:  .LBB24_4: # %start
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    call __unordsf2
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    addi a0, a0, -1
; RV32I-NEXT:    and a0, a0, s1
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srai a0, a0, 16
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 0(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_w_s_sat_i16:
; RV64I:       # %bb.0: # %start
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lui a1, 815104
; RV64I-NEXT:    call __gesf2
; RV64I-NEXT:    mv s2, a0
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __fixsfdi
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    bgez s2, .LBB24_2
; RV64I-NEXT:  # %bb.1: # %start
; RV64I-NEXT:    lui s1, 1048568
; RV64I-NEXT:  .LBB24_2: # %start
; RV64I-NEXT:    lui a0, 290816
; RV64I-NEXT:    addiw a1, a0, -512
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __gtsf2
; RV64I-NEXT:    blez a0, .LBB24_4
; RV64I-NEXT:  # %bb.3: # %start
; RV64I-NEXT:    lui s1, 8
; RV64I-NEXT:    addi s1, s1, -1
; RV64I-NEXT:  .LBB24_4: # %start
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a1, s0
; RV64I-NEXT:    call __unordsf2
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    and a0, a0, s1
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srai a0, a0, 48
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
start:
  %0 = tail call i16 @llvm.fptosi.sat.i16.f32(float %a)
  ret i16 %0
}
declare i16 @llvm.fptosi.sat.i16.f32(float)

define zeroext i16 @fcvt_wu_s_i16(float %a) nounwind {
; RV32IF-LABEL: fcvt_wu_s_i16:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fcvt.wu.s a0, fa0, rtz
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: fcvt_wu_s_i16:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fcvt.lu.s a0, fa0, rtz
; RV64IF-NEXT:    ret
;
; RV32IZFINX-LABEL: fcvt_wu_s_i16:
; RV32IZFINX:       # %bb.0:
; RV32IZFINX-NEXT:    fcvt.wu.s a0, a0, rtz
; RV32IZFINX-NEXT:    ret
;
; RV64IZFINX-LABEL: fcvt_wu_s_i16:
; RV64IZFINX:       # %bb.0:
; RV64IZFINX-NEXT:    fcvt.lu.s a0, a0, rtz
; RV64IZFINX-NEXT:    ret
;
; RV32I-LABEL: fcvt_wu_s_i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __fixunssfsi
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_wu_s_i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __fixunssfdi
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = fptoui float %a to i16
  ret i16 %1
}

define zeroext i16 @fcvt_wu_s_sat_i16(float %a) nounwind {
; RV32IF-LABEL: fcvt_wu_s_sat_i16:
; RV32IF:       # %bb.0: # %start
; RV32IF-NEXT:    lui a0, %hi(.LCPI26_0)
; RV32IF-NEXT:    flw fa5, %lo(.LCPI26_0)(a0)
; RV32IF-NEXT:    fmv.w.x fa4, zero
; RV32IF-NEXT:    fmax.s fa4, fa0, fa4
; RV32IF-NEXT:    fmin.s fa5, fa4, fa5
; RV32IF-NEXT:    fcvt.wu.s a0, fa5, rtz
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: fcvt_wu_s_sat_i16:
; RV64IF:       # %bb.0: # %start
; RV64IF-NEXT:    lui a0, %hi(.LCPI26_0)
; RV64IF-NEXT:    flw fa5, %lo(.LCPI26_0)(a0)
; RV64IF-NEXT:    fmv.w.x fa4, zero
; RV64IF-NEXT:    fmax.s fa4, fa0, fa4
; RV64IF-NEXT:    fmin.s fa5, fa4, fa5
; RV64IF-NEXT:    fcvt.lu.s a0, fa5, rtz
; RV64IF-NEXT:    ret
;
; RV32IZFINX-LABEL: fcvt_wu_s_sat_i16:
; RV32IZFINX:       # %bb.0: # %start
; RV32IZFINX-NEXT:    fmax.s a0, a0, zero
; RV32IZFINX-NEXT:    lui a1, 292864
; RV32IZFINX-NEXT:    addi a1, a1, -256
; RV32IZFINX-NEXT:    fmin.s a0, a0, a1
; RV32IZFINX-NEXT:    fcvt.wu.s a0, a0, rtz
; RV32IZFINX-NEXT:    ret
;
; RV64IZFINX-LABEL: fcvt_wu_s_sat_i16:
; RV64IZFINX:       # %bb.0: # %start
; RV64IZFINX-NEXT:    fmax.s a0, a0, zero
; RV64IZFINX-NEXT:    lui a1, 292864
; RV64IZFINX-NEXT:    addiw a1, a1, -256
; RV64IZFINX-NEXT:    fmin.s a0, a0, a1
; RV64IZFINX-NEXT:    fcvt.lu.s a0, a0, rtz
; RV64IZFINX-NEXT:    ret
;
; RV32I-LABEL: fcvt_wu_s_sat_i16:
; RV32I:       # %bb.0: # %start
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 0(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s2, a0
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    call __gesf2
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    mv a0, s2
; RV32I-NEXT:    call __fixunssfsi
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    lui a0, 292864
; RV32I-NEXT:    addi a1, a0, -256
; RV32I-NEXT:    mv a0, s2
; RV32I-NEXT:    call __gtsf2
; RV32I-NEXT:    lui a1, 16
; RV32I-NEXT:    addi a1, a1, -1
; RV32I-NEXT:    blez a0, .LBB26_2
; RV32I-NEXT:  # %bb.1: # %start
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    j .LBB26_3
; RV32I-NEXT:  .LBB26_2:
; RV32I-NEXT:    slti a0, s0, 0
; RV32I-NEXT:    addi a0, a0, -1
; RV32I-NEXT:    and a0, a0, s1
; RV32I-NEXT:  .LBB26_3: # %start
; RV32I-NEXT:    and a0, a0, a1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 0(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_wu_s_sat_i16:
; RV64I:       # %bb.0: # %start
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s2, a0
; RV64I-NEXT:    li a1, 0
; RV64I-NEXT:    call __gesf2
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    mv a0, s2
; RV64I-NEXT:    call __fixunssfdi
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    lui a0, 292864
; RV64I-NEXT:    addiw a1, a0, -256
; RV64I-NEXT:    mv a0, s2
; RV64I-NEXT:    call __gtsf2
; RV64I-NEXT:    lui a1, 16
; RV64I-NEXT:    addiw a1, a1, -1
; RV64I-NEXT:    blez a0, .LBB26_2
; RV64I-NEXT:  # %bb.1: # %start
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:    j .LBB26_3
; RV64I-NEXT:  .LBB26_2:
; RV64I-NEXT:    slti a0, s0, 0
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    and a0, a0, s1
; RV64I-NEXT:  .LBB26_3: # %start
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
start:
  %0 = tail call i16 @llvm.fptoui.sat.i16.f32(float %a)
  ret i16 %0
}
declare i16 @llvm.fptoui.sat.i16.f32(float)

define signext i8 @fcvt_w_s_i8(float %a) nounwind {
; RV32IF-LABEL: fcvt_w_s_i8:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fcvt.w.s a0, fa0, rtz
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: fcvt_w_s_i8:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fcvt.l.s a0, fa0, rtz
; RV64IF-NEXT:    ret
;
; RV32IZFINX-LABEL: fcvt_w_s_i8:
; RV32IZFINX:       # %bb.0:
; RV32IZFINX-NEXT:    fcvt.w.s a0, a0, rtz
; RV32IZFINX-NEXT:    ret
;
; RV64IZFINX-LABEL: fcvt_w_s_i8:
; RV64IZFINX:       # %bb.0:
; RV64IZFINX-NEXT:    fcvt.l.s a0, a0, rtz
; RV64IZFINX-NEXT:    ret
;
; RV32I-LABEL: fcvt_w_s_i8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __fixsfsi
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_w_s_i8:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __fixsfdi
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = fptosi float %a to i8
  ret i8 %1
}

define signext i8 @fcvt_w_s_sat_i8(float %a) nounwind {
; RV32IF-LABEL: fcvt_w_s_sat_i8:
; RV32IF:       # %bb.0: # %start
; RV32IF-NEXT:    feq.s a0, fa0, fa0
; RV32IF-NEXT:    lui a1, 798720
; RV32IF-NEXT:    fmv.w.x fa5, a1
; RV32IF-NEXT:    lui a1, 274400
; RV32IF-NEXT:    neg a0, a0
; RV32IF-NEXT:    fmax.s fa5, fa0, fa5
; RV32IF-NEXT:    fmv.w.x fa4, a1
; RV32IF-NEXT:    fmin.s fa5, fa5, fa4
; RV32IF-NEXT:    fcvt.w.s a1, fa5, rtz
; RV32IF-NEXT:    and a0, a0, a1
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: fcvt_w_s_sat_i8:
; RV64IF:       # %bb.0: # %start
; RV64IF-NEXT:    feq.s a0, fa0, fa0
; RV64IF-NEXT:    lui a1, 798720
; RV64IF-NEXT:    fmv.w.x fa5, a1
; RV64IF-NEXT:    lui a1, 274400
; RV64IF-NEXT:    neg a0, a0
; RV64IF-NEXT:    fmax.s fa5, fa0, fa5
; RV64IF-NEXT:    fmv.w.x fa4, a1
; RV64IF-NEXT:    fmin.s fa5, fa5, fa4
; RV64IF-NEXT:    fcvt.l.s a1, fa5, rtz
; RV64IF-NEXT:    and a0, a0, a1
; RV64IF-NEXT:    ret
;
; RV32IZFINX-LABEL: fcvt_w_s_sat_i8:
; RV32IZFINX:       # %bb.0: # %start
; RV32IZFINX-NEXT:    feq.s a1, a0, a0
; RV32IZFINX-NEXT:    lui a2, 798720
; RV32IZFINX-NEXT:    neg a1, a1
; RV32IZFINX-NEXT:    fmax.s a0, a0, a2
; RV32IZFINX-NEXT:    lui a2, 274400
; RV32IZFINX-NEXT:    fmin.s a0, a0, a2
; RV32IZFINX-NEXT:    fcvt.w.s a0, a0, rtz
; RV32IZFINX-NEXT:    and a0, a1, a0
; RV32IZFINX-NEXT:    ret
;
; RV64IZFINX-LABEL: fcvt_w_s_sat_i8:
; RV64IZFINX:       # %bb.0: # %start
; RV64IZFINX-NEXT:    feq.s a1, a0, a0
; RV64IZFINX-NEXT:    lui a2, 798720
; RV64IZFINX-NEXT:    neg a1, a1
; RV64IZFINX-NEXT:    fmax.s a0, a0, a2
; RV64IZFINX-NEXT:    lui a2, 274400
; RV64IZFINX-NEXT:    fmin.s a0, a0, a2
; RV64IZFINX-NEXT:    fcvt.l.s a0, a0, rtz
; RV64IZFINX-NEXT:    and a0, a1, a0
; RV64IZFINX-NEXT:    ret
;
; RV32I-LABEL: fcvt_w_s_sat_i8:
; RV32I:       # %bb.0: # %start
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 0(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lui a1, 798720
; RV32I-NEXT:    call __gesf2
; RV32I-NEXT:    mv s2, a0
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __fixsfsi
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    bgez s2, .LBB28_2
; RV32I-NEXT:  # %bb.1: # %start
; RV32I-NEXT:    li s1, -128
; RV32I-NEXT:  .LBB28_2: # %start
; RV32I-NEXT:    lui a1, 274400
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __gtsf2
; RV32I-NEXT:    blez a0, .LBB28_4
; RV32I-NEXT:  # %bb.3: # %start
; RV32I-NEXT:    li s1, 127
; RV32I-NEXT:  .LBB28_4: # %start
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    call __unordsf2
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    addi a0, a0, -1
; RV32I-NEXT:    and a0, a0, s1
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    srai a0, a0, 24
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 0(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_w_s_sat_i8:
; RV64I:       # %bb.0: # %start
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lui a1, 798720
; RV64I-NEXT:    call __gesf2
; RV64I-NEXT:    mv s2, a0
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __fixsfdi
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    bgez s2, .LBB28_2
; RV64I-NEXT:  # %bb.1: # %start
; RV64I-NEXT:    li s1, -128
; RV64I-NEXT:  .LBB28_2: # %start
; RV64I-NEXT:    lui a1, 274400
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __gtsf2
; RV64I-NEXT:    blez a0, .LBB28_4
; RV64I-NEXT:  # %bb.3: # %start
; RV64I-NEXT:    li s1, 127
; RV64I-NEXT:  .LBB28_4: # %start
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a1, s0
; RV64I-NEXT:    call __unordsf2
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    and a0, a0, s1
; RV64I-NEXT:    slli a0, a0, 56
; RV64I-NEXT:    srai a0, a0, 56
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
start:
  %0 = tail call i8 @llvm.fptosi.sat.i8.f32(float %a)
  ret i8 %0
}
declare i8 @llvm.fptosi.sat.i8.f32(float)

define zeroext i8 @fcvt_wu_s_i8(float %a) nounwind {
; RV32IF-LABEL: fcvt_wu_s_i8:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fcvt.wu.s a0, fa0, rtz
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: fcvt_wu_s_i8:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fcvt.lu.s a0, fa0, rtz
; RV64IF-NEXT:    ret
;
; RV32IZFINX-LABEL: fcvt_wu_s_i8:
; RV32IZFINX:       # %bb.0:
; RV32IZFINX-NEXT:    fcvt.wu.s a0, a0, rtz
; RV32IZFINX-NEXT:    ret
;
; RV64IZFINX-LABEL: fcvt_wu_s_i8:
; RV64IZFINX:       # %bb.0:
; RV64IZFINX-NEXT:    fcvt.lu.s a0, a0, rtz
; RV64IZFINX-NEXT:    ret
;
; RV32I-LABEL: fcvt_wu_s_i8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __fixunssfsi
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_wu_s_i8:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __fixunssfdi
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = fptoui float %a to i8
  ret i8 %1
}

define zeroext i8 @fcvt_wu_s_sat_i8(float %a) nounwind {
; RV32IF-LABEL: fcvt_wu_s_sat_i8:
; RV32IF:       # %bb.0: # %start
; RV32IF-NEXT:    fmv.w.x fa5, zero
; RV32IF-NEXT:    lui a0, 276464
; RV32IF-NEXT:    fmax.s fa5, fa0, fa5
; RV32IF-NEXT:    fmv.w.x fa4, a0
; RV32IF-NEXT:    fmin.s fa5, fa5, fa4
; RV32IF-NEXT:    fcvt.wu.s a0, fa5, rtz
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: fcvt_wu_s_sat_i8:
; RV64IF:       # %bb.0: # %start
; RV64IF-NEXT:    fmv.w.x fa5, zero
; RV64IF-NEXT:    lui a0, 276464
; RV64IF-NEXT:    fmax.s fa5, fa0, fa5
; RV64IF-NEXT:    fmv.w.x fa4, a0
; RV64IF-NEXT:    fmin.s fa5, fa5, fa4
; RV64IF-NEXT:    fcvt.lu.s a0, fa5, rtz
; RV64IF-NEXT:    ret
;
; RV32IZFINX-LABEL: fcvt_wu_s_sat_i8:
; RV32IZFINX:       # %bb.0: # %start
; RV32IZFINX-NEXT:    fmax.s a0, a0, zero
; RV32IZFINX-NEXT:    lui a1, 276464
; RV32IZFINX-NEXT:    fmin.s a0, a0, a1
; RV32IZFINX-NEXT:    fcvt.wu.s a0, a0, rtz
; RV32IZFINX-NEXT:    ret
;
; RV64IZFINX-LABEL: fcvt_wu_s_sat_i8:
; RV64IZFINX:       # %bb.0: # %start
; RV64IZFINX-NEXT:    fmax.s a0, a0, zero
; RV64IZFINX-NEXT:    lui a1, 276464
; RV64IZFINX-NEXT:    fmin.s a0, a0, a1
; RV64IZFINX-NEXT:    fcvt.lu.s a0, a0, rtz
; RV64IZFINX-NEXT:    ret
;
; RV32I-LABEL: fcvt_wu_s_sat_i8:
; RV32I:       # %bb.0: # %start
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 0(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s2, a0
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    call __gesf2
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    mv a0, s2
; RV32I-NEXT:    call __fixunssfsi
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    lui a1, 276464
; RV32I-NEXT:    mv a0, s2
; RV32I-NEXT:    call __gtsf2
; RV32I-NEXT:    blez a0, .LBB30_2
; RV32I-NEXT:  # %bb.1: # %start
; RV32I-NEXT:    li a0, 255
; RV32I-NEXT:    j .LBB30_3
; RV32I-NEXT:  .LBB30_2:
; RV32I-NEXT:    slti a0, s0, 0
; RV32I-NEXT:    addi a0, a0, -1
; RV32I-NEXT:    and a0, a0, s1
; RV32I-NEXT:  .LBB30_3: # %start
; RV32I-NEXT:    andi a0, a0, 255
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 0(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_wu_s_sat_i8:
; RV64I:       # %bb.0: # %start
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s2, a0
; RV64I-NEXT:    li a1, 0
; RV64I-NEXT:    call __gesf2
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    mv a0, s2
; RV64I-NEXT:    call __fixunssfdi
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    lui a1, 276464
; RV64I-NEXT:    mv a0, s2
; RV64I-NEXT:    call __gtsf2
; RV64I-NEXT:    blez a0, .LBB30_2
; RV64I-NEXT:  # %bb.1: # %start
; RV64I-NEXT:    li a0, 255
; RV64I-NEXT:    j .LBB30_3
; RV64I-NEXT:  .LBB30_2:
; RV64I-NEXT:    slti a0, s0, 0
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    and a0, a0, s1
; RV64I-NEXT:  .LBB30_3: # %start
; RV64I-NEXT:    andi a0, a0, 255
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
start:
  %0 = tail call i8 @llvm.fptoui.sat.i8.f32(float %a)
  ret i8 %0
}
declare i8 @llvm.fptoui.sat.i8.f32(float)

define zeroext i32 @fcvt_wu_s_sat_zext(float %a) nounwind {
; RV32IF-LABEL: fcvt_wu_s_sat_zext:
; RV32IF:       # %bb.0: # %start
; RV32IF-NEXT:    fcvt.wu.s a0, fa0, rtz
; RV32IF-NEXT:    feq.s a1, fa0, fa0
; RV32IF-NEXT:    seqz a1, a1
; RV32IF-NEXT:    addi a1, a1, -1
; RV32IF-NEXT:    and a0, a1, a0
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: fcvt_wu_s_sat_zext:
; RV64IF:       # %bb.0: # %start
; RV64IF-NEXT:    fcvt.wu.s a0, fa0, rtz
; RV64IF-NEXT:    feq.s a1, fa0, fa0
; RV64IF-NEXT:    seqz a1, a1
; RV64IF-NEXT:    addi a1, a1, -1
; RV64IF-NEXT:    and a0, a0, a1
; RV64IF-NEXT:    slli a0, a0, 32
; RV64IF-NEXT:    srli a0, a0, 32
; RV64IF-NEXT:    ret
;
; RV32IZFINX-LABEL: fcvt_wu_s_sat_zext:
; RV32IZFINX:       # %bb.0: # %start
; RV32IZFINX-NEXT:    fcvt.wu.s a1, a0, rtz
; RV32IZFINX-NEXT:    feq.s a0, a0, a0
; RV32IZFINX-NEXT:    seqz a0, a0
; RV32IZFINX-NEXT:    addi a0, a0, -1
; RV32IZFINX-NEXT:    and a0, a0, a1
; RV32IZFINX-NEXT:    ret
;
; RV64IZFINX-LABEL: fcvt_wu_s_sat_zext:
; RV64IZFINX:       # %bb.0: # %start
; RV64IZFINX-NEXT:    fcvt.wu.s a1, a0, rtz
; RV64IZFINX-NEXT:    feq.s a0, a0, a0
; RV64IZFINX-NEXT:    seqz a0, a0
; RV64IZFINX-NEXT:    addi a0, a0, -1
; RV64IZFINX-NEXT:    and a0, a1, a0
; RV64IZFINX-NEXT:    slli a0, a0, 32
; RV64IZFINX-NEXT:    srli a0, a0, 32
; RV64IZFINX-NEXT:    ret
;
; RV32I-LABEL: fcvt_wu_s_sat_zext:
; RV32I:       # %bb.0: # %start
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    call __gesf2
; RV32I-NEXT:    slti a0, a0, 0
; RV32I-NEXT:    addi s1, a0, -1
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __fixunssfsi
; RV32I-NEXT:    and s1, s1, a0
; RV32I-NEXT:    lui a1, 325632
; RV32I-NEXT:    addi a1, a1, -1
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __gtsf2
; RV32I-NEXT:    sgtz a0, a0
; RV32I-NEXT:    neg a0, a0
; RV32I-NEXT:    or a0, a0, s1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_wu_s_sat_zext:
; RV64I:       # %bb.0: # %start
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s2, a0
; RV64I-NEXT:    li a1, 0
; RV64I-NEXT:    call __gesf2
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    mv a0, s2
; RV64I-NEXT:    call __fixunssfdi
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    lui a1, 325632
; RV64I-NEXT:    addiw a1, a1, -1
; RV64I-NEXT:    mv a0, s2
; RV64I-NEXT:    call __gtsf2
; RV64I-NEXT:    blez a0, .LBB31_2
; RV64I-NEXT:  # %bb.1: # %start
; RV64I-NEXT:    li a0, -1
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    j .LBB31_3
; RV64I-NEXT:  .LBB31_2:
; RV64I-NEXT:    slti a0, s0, 0
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    and a0, a0, s1
; RV64I-NEXT:  .LBB31_3: # %start
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
start:
  %0 = tail call i32 @llvm.fptoui.sat.i32.f32(float %a)
  ret i32 %0
}

define signext i32 @fcvt_w_s_sat_sext(float %a) nounwind {
; CHECKIF-LABEL: fcvt_w_s_sat_sext:
; CHECKIF:       # %bb.0: # %start
; CHECKIF-NEXT:    fcvt.w.s a0, fa0, rtz
; CHECKIF-NEXT:    feq.s a1, fa0, fa0
; CHECKIF-NEXT:    seqz a1, a1
; CHECKIF-NEXT:    addi a1, a1, -1
; CHECKIF-NEXT:    and a0, a1, a0
; CHECKIF-NEXT:    ret
;
; CHECKIZFINX-LABEL: fcvt_w_s_sat_sext:
; CHECKIZFINX:       # %bb.0: # %start
; CHECKIZFINX-NEXT:    fcvt.w.s a1, a0, rtz
; CHECKIZFINX-NEXT:    feq.s a0, a0, a0
; CHECKIZFINX-NEXT:    seqz a0, a0
; CHECKIZFINX-NEXT:    addi a0, a0, -1
; CHECKIZFINX-NEXT:    and a0, a0, a1
; CHECKIZFINX-NEXT:    ret
;
; RV32I-LABEL: fcvt_w_s_sat_sext:
; RV32I:       # %bb.0: # %start
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lui a1, 847872
; RV32I-NEXT:    call __gesf2
; RV32I-NEXT:    mv s2, a0
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __fixsfsi
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    lui s3, 524288
; RV32I-NEXT:    bgez s2, .LBB32_2
; RV32I-NEXT:  # %bb.1: # %start
; RV32I-NEXT:    lui s1, 524288
; RV32I-NEXT:  .LBB32_2: # %start
; RV32I-NEXT:    lui a1, 323584
; RV32I-NEXT:    addi a1, a1, -1
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call __gtsf2
; RV32I-NEXT:    blez a0, .LBB32_4
; RV32I-NEXT:  # %bb.3: # %start
; RV32I-NEXT:    addi s1, s3, -1
; RV32I-NEXT:  .LBB32_4: # %start
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    call __unordsf2
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    addi a0, a0, -1
; RV32I-NEXT:    and a0, a0, s1
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_w_s_sat_sext:
; RV64I:       # %bb.0: # %start
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    lui a1, 847872
; RV64I-NEXT:    call __gesf2
; RV64I-NEXT:    mv s2, a0
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __fixsfdi
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    lui s3, 524288
; RV64I-NEXT:    bgez s2, .LBB32_2
; RV64I-NEXT:  # %bb.1: # %start
; RV64I-NEXT:    lui s1, 524288
; RV64I-NEXT:  .LBB32_2: # %start
; RV64I-NEXT:    lui a1, 323584
; RV64I-NEXT:    addiw a1, a1, -1
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __gtsf2
; RV64I-NEXT:    blez a0, .LBB32_4
; RV64I-NEXT:  # %bb.3: # %start
; RV64I-NEXT:    addi s1, s3, -1
; RV64I-NEXT:  .LBB32_4: # %start
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a1, s0
; RV64I-NEXT:    call __unordsf2
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    and a0, a0, s1
; RV64I-NEXT:    sext.w a0, a0
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s3, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
start:
  %0 = tail call i32 @llvm.fptosi.sat.i32.f32(float %a)
  ret i32 %0
}
