; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s --mattr=+complxnum,+neon,+fullfp16 -o - | FileCheck %s

target triple = "aarch64"

; Expected to not transform
define <2 x half> @complex_mul_v2f16(<2 x half> %a, <2 x half> %b) {
; CHECK-LABEL: complex_mul_v2f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov h2, v0.h[1]
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    fmul h3, h0, v1.h[1]
; CHECK-NEXT:    fmul h2, h2, v1.h[1]
; CHECK-NEXT:    fmla h3, h1, v0.h[1]
; CHECK-NEXT:    fnmsub h0, h1, h0, h2
; CHECK-NEXT:    mov v0.h[1], v3.h[0]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
entry:
  %a.real   = shufflevector <2 x half> %a, <2 x half> poison, <1 x i32> <i32 0>
  %a.imag = shufflevector <2 x half> %a, <2 x half> poison, <1 x i32> <i32 1>
  %b.real = shufflevector <2 x half> %b, <2 x half> poison, <1 x i32> <i32 0>
  %b.imag = shufflevector <2 x half> %b, <2 x half> poison, <1 x i32> <i32 1>
  %0 = fmul fast <1 x half> %b.imag, %a.real
  %1 = fmul fast <1 x half> %b.real, %a.imag
  %2 = fadd fast <1 x half> %1, %0
  %3 = fmul fast <1 x half> %b.real, %a.real
  %4 = fmul fast <1 x half> %a.imag, %b.imag
  %5 = fsub fast <1 x half> %3, %4
  %interleaved.vec = shufflevector <1 x half> %5, <1 x half> %2, <2 x i32> <i32 0, i32 1>
  ret <2 x half> %interleaved.vec
}

; Expected to transform
define <4 x half> @complex_mul_v4f16(<4 x half> %a, <4 x half> %b) {
; CHECK-LABEL: complex_mul_v4f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi d2, #0000000000000000
; CHECK-NEXT:    fcmla v2.4h, v1.4h, v0.4h, #0
; CHECK-NEXT:    fcmla v2.4h, v1.4h, v0.4h, #90
; CHECK-NEXT:    fmov d0, d2
; CHECK-NEXT:    ret
entry:
  %a.real   = shufflevector <4 x half> %a, <4 x half> poison, <2 x i32> <i32 0, i32 2>
  %a.imag = shufflevector <4 x half> %a, <4 x half> poison, <2 x i32> <i32 1, i32 3>
  %b.real = shufflevector <4 x half> %b, <4 x half> poison, <2 x i32> <i32 0, i32 2>
  %b.imag = shufflevector <4 x half> %b, <4 x half> poison, <2 x i32> <i32 1, i32 3>
  %0 = fmul fast <2 x half> %b.imag, %a.real
  %1 = fmul fast <2 x half> %b.real, %a.imag
  %2 = fadd fast <2 x half> %1, %0
  %3 = fmul fast <2 x half> %b.real, %a.real
  %4 = fmul fast <2 x half> %a.imag, %b.imag
  %5 = fsub fast <2 x half> %3, %4
  %interleaved.vec = shufflevector <2 x half> %5, <2 x half> %2, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
  ret <4 x half> %interleaved.vec
}

; Expected to transform
define <8 x half> @complex_mul_v8f16(<8 x half> %a, <8 x half> %b) {
; CHECK-LABEL: complex_mul_v8f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi v2.2d, #0000000000000000
; CHECK-NEXT:    fcmla v2.8h, v1.8h, v0.8h, #0
; CHECK-NEXT:    fcmla v2.8h, v1.8h, v0.8h, #90
; CHECK-NEXT:    mov v0.16b, v2.16b
; CHECK-NEXT:    ret
entry:
  %a.real   = shufflevector <8 x half> %a, <8 x half> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %a.imag = shufflevector <8 x half> %a, <8 x half> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %b.real = shufflevector <8 x half> %b, <8 x half> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %b.imag = shufflevector <8 x half> %b, <8 x half> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %0 = fmul fast <4 x half> %b.imag, %a.real
  %1 = fmul fast <4 x half> %b.real, %a.imag
  %2 = fadd fast <4 x half> %1, %0
  %3 = fmul fast <4 x half> %b.real, %a.real
  %4 = fmul fast <4 x half> %a.imag, %b.imag
  %5 = fsub fast <4 x half> %3, %4
  %interleaved.vec = shufflevector <4 x half> %5, <4 x half> %2, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
  ret <8 x half> %interleaved.vec
}

; Expected to transform
define <16 x half> @complex_mul_v16f16(<16 x half> %a, <16 x half> %b) {
; CHECK-LABEL: complex_mul_v16f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi v4.2d, #0000000000000000
; CHECK-NEXT:    movi v5.2d, #0000000000000000
; CHECK-NEXT:    fcmla v5.8h, v2.8h, v0.8h, #0
; CHECK-NEXT:    fcmla v4.8h, v3.8h, v1.8h, #0
; CHECK-NEXT:    fcmla v5.8h, v2.8h, v0.8h, #90
; CHECK-NEXT:    fcmla v4.8h, v3.8h, v1.8h, #90
; CHECK-NEXT:    mov v0.16b, v5.16b
; CHECK-NEXT:    mov v1.16b, v4.16b
; CHECK-NEXT:    ret
entry:
  %a.real   = shufflevector <16 x half> %a, <16 x half> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %a.imag = shufflevector <16 x half> %a, <16 x half> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %b.real = shufflevector <16 x half> %b, <16 x half> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %b.imag = shufflevector <16 x half> %b, <16 x half> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %0 = fmul fast <8 x half> %b.imag, %a.real
  %1 = fmul fast <8 x half> %b.real, %a.imag
  %2 = fadd fast <8 x half> %1, %0
  %3 = fmul fast <8 x half> %b.real, %a.real
  %4 = fmul fast <8 x half> %a.imag, %b.imag
  %5 = fsub fast <8 x half> %3, %4
  %interleaved.vec = shufflevector <8 x half> %5, <8 x half> %2, <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
  ret <16 x half> %interleaved.vec
}

; Expected to transform
define <32 x half> @complex_mul_v32f16(<32 x half> %a, <32 x half> %b) {
; CHECK-LABEL: complex_mul_v32f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi v16.2d, #0000000000000000
; CHECK-NEXT:    movi v17.2d, #0000000000000000
; CHECK-NEXT:    movi v18.2d, #0000000000000000
; CHECK-NEXT:    movi v19.2d, #0000000000000000
; CHECK-NEXT:    fcmla v16.8h, v4.8h, v0.8h, #0
; CHECK-NEXT:    fcmla v18.8h, v5.8h, v1.8h, #0
; CHECK-NEXT:    fcmla v17.8h, v7.8h, v3.8h, #0
; CHECK-NEXT:    fcmla v19.8h, v6.8h, v2.8h, #0
; CHECK-NEXT:    fcmla v16.8h, v4.8h, v0.8h, #90
; CHECK-NEXT:    fcmla v18.8h, v5.8h, v1.8h, #90
; CHECK-NEXT:    fcmla v17.8h, v7.8h, v3.8h, #90
; CHECK-NEXT:    fcmla v19.8h, v6.8h, v2.8h, #90
; CHECK-NEXT:    mov v0.16b, v16.16b
; CHECK-NEXT:    mov v1.16b, v18.16b
; CHECK-NEXT:    mov v3.16b, v17.16b
; CHECK-NEXT:    mov v2.16b, v19.16b
; CHECK-NEXT:    ret
entry:
  %a.real   = shufflevector <32 x half> %a, <32 x half> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
  %a.imag = shufflevector <32 x half> %a, <32 x half> poison, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
  %b.real = shufflevector <32 x half> %b, <32 x half> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
  %b.imag = shufflevector <32 x half> %b, <32 x half> poison, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
  %0 = fmul fast <16 x half> %b.imag, %a.real
  %1 = fmul fast <16 x half> %b.real, %a.imag
  %2 = fadd fast <16 x half> %1, %0
  %3 = fmul fast <16 x half> %b.real, %a.real
  %4 = fmul fast <16 x half> %a.imag, %b.imag
  %5 = fsub fast <16 x half> %3, %4
  %interleaved.vec = shufflevector <16 x half> %5, <16 x half> %2, <32 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23, i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
  ret <32 x half> %interleaved.vec
}
