; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 5
; RUN: opt -passes='print<access-info>' -disable-output %s 2>&1 | FileCheck %s

target datalayout = "e-m:e-p270:32:32-p271:32:32-p272:64:64-i64:64-i128:128-f80:128-n8:16:32:64-S128"

define void @loads_of_same_pointer_with_different_sizes1(ptr %A, ptr %B, i64 %N) {
; CHECK-LABEL: 'loads_of_same_pointer_with_different_sizes1'
; CHECK-NEXT:    loop:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group ([[GRP1:0x[0-9a-f]+]]):
; CHECK-NEXT:          %gep.B = getelementptr inbounds i32, ptr %B, i64 %iv
; CHECK-NEXT:        Against group ([[GRP2:0x[0-9a-f]+]]):
; CHECK-NEXT:          %gep.A = getelementptr inbounds i8, ptr %A, i64 %iv
; CHECK-NEXT:          %gep.A = getelementptr inbounds i8, ptr %A, i64 %iv
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group [[GRP1]]:
; CHECK-NEXT:          (Low: %B High: ((4 * %N) + %B))
; CHECK-NEXT:            Member: {%B,+,4}<nuw><%loop>
; CHECK-NEXT:        Group [[GRP2]]:
; CHECK-NEXT:          (Low: %A High: (3 + %N + %A))
; CHECK-NEXT:            Member: {%A,+,1}<nuw><%loop>
; CHECK-NEXT:            Member: {%A,+,1}<nuw><%loop>
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %gep.A = getelementptr inbounds i8, ptr %A, i64 %iv
  %l0 = load i8, ptr %gep.A, align 1
  %l1 = load i32, ptr %gep.A, align 1
  %l0.ext = sext i8 %l0 to i32
  %iv.trunc = trunc nuw i64 %iv to i32
  %sub.0 = sub i32 %l0.ext, %iv.trunc
  %sub.1 = sub i32 %l1, %sub.0
  %gep.B = getelementptr inbounds i32, ptr %B, i64 %iv
  store i32 %sub.1, ptr %gep.B, align 4
  %iv.next = add nuw nsw i64 %iv, 1
  %exitcond.not = icmp eq i64 %iv.next, %N
  br i1 %exitcond.not, label %exit, label %loop

exit:
  ret void
}

define void @loads_of_same_pointer_with_different_sizes2(ptr %A, ptr %B, i64 %N) {
; CHECK-LABEL: 'loads_of_same_pointer_with_different_sizes2'
; CHECK-NEXT:    loop:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group ([[GRP3:0x[0-9a-f]+]]):
; CHECK-NEXT:          %gep.B = getelementptr inbounds i32, ptr %B, i64 %iv
; CHECK-NEXT:        Against group ([[GRP4:0x[0-9a-f]+]]):
; CHECK-NEXT:          %gep.A = getelementptr inbounds i8, ptr %A, i64 %iv
; CHECK-NEXT:          %gep.A = getelementptr inbounds i8, ptr %A, i64 %iv
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group [[GRP3]]:
; CHECK-NEXT:          (Low: %B High: ((4 * %N) + %B))
; CHECK-NEXT:            Member: {%B,+,4}<nuw><%loop>
; CHECK-NEXT:        Group [[GRP4]]:
; CHECK-NEXT:          (Low: %A High: (3 + %N + %A))
; CHECK-NEXT:            Member: {%A,+,1}<nuw><%loop>
; CHECK-NEXT:            Member: {%A,+,1}<nuw><%loop>
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %gep.A = getelementptr inbounds i8, ptr %A, i64 %iv
  %l1 = load i32, ptr %gep.A, align 1
  %l0 = load i8, ptr %gep.A, align 1
  %l0.ext = sext i8 %l0 to i32
  %iv.trunc = trunc nuw i64 %iv to i32
  %sub.0 = sub i32 %l0.ext, %iv.trunc
  %sub.1 = sub i32 %l1, %sub.0
  %gep.B = getelementptr inbounds i32, ptr %B, i64 %iv
  store i32 %sub.1, ptr %gep.B, align 4
  %iv.next = add nuw nsw i64 %iv, 1
  %exitcond.not = icmp eq i64 %iv.next, %N
  br i1 %exitcond.not, label %exit, label %loop

exit:
  ret void
}

define void @loads_of_same_pointer_with_different_sizes_retry_with_runtime_checks(ptr %A, ptr %B, i64 %N, i64 %off) {
; CHECK-LABEL: 'loads_of_same_pointer_with_different_sizes_retry_with_runtime_checks'
; CHECK-NEXT:    loop:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group ([[GRP5:0x[0-9a-f]+]]):
; CHECK-NEXT:          %gep.B.iv = getelementptr inbounds i32, ptr %B, i64 %iv
; CHECK-NEXT:        Against group ([[GRP6:0x[0-9a-f]+]]):
; CHECK-NEXT:          %gep.B.inc = getelementptr inbounds i32, ptr %B, i64 %inc
; CHECK-NEXT:      Check 1:
; CHECK-NEXT:        Comparing group ([[GRP5]]):
; CHECK-NEXT:          %gep.B.iv = getelementptr inbounds i32, ptr %B, i64 %iv
; CHECK-NEXT:        Against group ([[GRP7:0x[0-9a-f]+]]):
; CHECK-NEXT:          %gep.A = getelementptr inbounds i8, ptr %A, i64 %iv
; CHECK-NEXT:      Check 2:
; CHECK-NEXT:        Comparing group ([[GRP5]]):
; CHECK-NEXT:          %gep.B.iv = getelementptr inbounds i32, ptr %B, i64 %iv
; CHECK-NEXT:        Against group ([[GRP8:0x[0-9a-f]+]]):
; CHECK-NEXT:          %gep.A = getelementptr inbounds i8, ptr %A, i64 %iv
; CHECK-NEXT:      Check 3:
; CHECK-NEXT:        Comparing group ([[GRP6]]):
; CHECK-NEXT:          %gep.B.inc = getelementptr inbounds i32, ptr %B, i64 %inc
; CHECK-NEXT:        Against group ([[GRP7]]):
; CHECK-NEXT:          %gep.A = getelementptr inbounds i8, ptr %A, i64 %iv
; CHECK-NEXT:      Check 4:
; CHECK-NEXT:        Comparing group ([[GRP6]]):
; CHECK-NEXT:          %gep.B.inc = getelementptr inbounds i32, ptr %B, i64 %inc
; CHECK-NEXT:        Against group ([[GRP8]]):
; CHECK-NEXT:          %gep.A = getelementptr inbounds i8, ptr %A, i64 %iv
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group [[GRP5]]:
; CHECK-NEXT:          (Low: %B High: ((4 * %N) + %B))
; CHECK-NEXT:            Member: {%B,+,4}<nuw><%loop>
; CHECK-NEXT:        Group [[GRP6]]:
; CHECK-NEXT:          (Low: ((4 * %off) + %B) High: ((4 * %N) + (4 * %off) + %B))
; CHECK-NEXT:            Member: {((4 * %off) + %B),+,4}<%loop>
; CHECK-NEXT:        Group [[GRP7]]:
; CHECK-NEXT:          (Low: %A High: (%N + %A))
; CHECK-NEXT:            Member: {%A,+,1}<nuw><%loop>
; CHECK-NEXT:        Group [[GRP8]]:
; CHECK-NEXT:          (Low: %A High: (3 + %N + %A))
; CHECK-NEXT:            Member: {%A,+,1}<nuw><%loop>
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %gep.A = getelementptr inbounds i8, ptr %A, i64 %iv
  %l0 = load i8, ptr %gep.A, align 1
  %l1 = load i32, ptr %gep.A, align 1
  %l0.ext = sext i8 %l0 to i32
  %iv.trunc = trunc nuw i64 %iv to i32
  %sub.0 = sub i32 %l0.ext, %iv.trunc
  %sub.1 = sub i32 %l1, %iv.trunc
  %gep.B.iv = getelementptr inbounds i32, ptr %B, i64 %iv
  store i32 %sub.0, ptr %gep.B.iv, align 4
  %inc = add nuw nsw i64 %iv, %off
  %gep.B.inc = getelementptr inbounds i32, ptr %B, i64 %inc
  store i32 %sub.1, ptr %gep.B.inc , align 4
  %iv.next = add nuw nsw i64 %iv, 1
  %exitcond.not = icmp eq i64 %iv.next, %N
  br i1 %exitcond.not, label %exit, label %loop

exit:
  ret void
}
