; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefix=AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefix=AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vpopcntdq | FileCheck %s --check-prefix=AVX512VPOPCNTDQ
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vpopcntdq,+avx512vl | FileCheck %s --check-prefix=AVX512VPOPCNTDQVL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bitalg | FileCheck %s --check-prefix=BITALG_NOVLX
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bitalg,+avx512vl | FileCheck %s --check-prefix=BITALG


define <32 x i8> @ugt_1_v32i8(<32 x i8> %0) {
; AVX1-LABEL: ugt_1_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpaddb %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpaddb %xmm2, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpeqb %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpxor %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_1_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpaddb %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_1_v32i8:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512VPOPCNTDQ-NEXT:    vpaddb %ymm1, %ymm0, %ymm1
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VPOPCNTDQ-NEXT:    vpcmpeqb %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpternlogq {{.*#+}} zmm0 = ~zmm0
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_1_v32i8:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512VPOPCNTDQVL-NEXT:    vpaddb %ymm1, %ymm0, %ymm1
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VPOPCNTDQVL-NEXT:    vpcmpeqb %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpternlogq {{.*#+}} ymm0 = ~ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_1_v32i8:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_1_v32i8:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <32 x i8> @llvm.ctpop.v32i8(<32 x i8> %0)
  %3 = icmp ugt <32 x i8> %2, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %4 = sext <32 x i1> %3 to <32 x i8>
  ret <32 x i8> %4
}

define <32 x i8> @ult_2_v32i8(<32 x i8> %0) {
; AVX1-LABEL: ult_2_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpaddb %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpaddb %xmm2, %xmm0, %xmm2
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpeqb %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_2_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpaddb %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpeqb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_2_v32i8:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512VPOPCNTDQ-NEXT:    vpaddb %ymm1, %ymm0, %ymm1
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VPOPCNTDQ-NEXT:    vpcmpeqb %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_2_v32i8:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512VPOPCNTDQVL-NEXT:    vpaddb %ymm1, %ymm0, %ymm1
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VPOPCNTDQVL-NEXT:    vpcmpeqb %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_2_v32i8:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2]
; BITALG_NOVLX-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_2_v32i8:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2]
; BITALG-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <32 x i8> @llvm.ctpop.v32i8(<32 x i8> %0)
  %3 = icmp ult <32 x i8> %2, <i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2>
  %4 = sext <32 x i1> %3 to <32 x i8>
  ret <32 x i8> %4
}

define <32 x i8> @ugt_2_v32i8(<32 x i8> %0) {
; AVX1-LABEL: ugt_2_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2]
; AVX1-NEXT:    vpcmpgtb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_2_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_2_v32i8:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512VPOPCNTDQ-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512VPOPCNTDQ-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512VPOPCNTDQ-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX512VPOPCNTDQ-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_2_v32i8:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512VPOPCNTDQVL-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512VPOPCNTDQVL-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512VPOPCNTDQVL-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX512VPOPCNTDQVL-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_2_v32i8:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_2_v32i8:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <32 x i8> @llvm.ctpop.v32i8(<32 x i8> %0)
  %3 = icmp ugt <32 x i8> %2, <i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2>
  %4 = sext <32 x i1> %3 to <32 x i8>
  ret <32 x i8> %4
}

define <32 x i8> @ult_3_v32i8(<32 x i8> %0) {
; AVX1-LABEL: ult_3_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3]
; AVX1-NEXT:    vpcmpgtb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_3_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3]
; AVX2-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_3_v32i8:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512VPOPCNTDQ-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512VPOPCNTDQ-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512VPOPCNTDQ-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX512VPOPCNTDQ-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_3_v32i8:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512VPOPCNTDQVL-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512VPOPCNTDQVL-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512VPOPCNTDQVL-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX512VPOPCNTDQVL-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_3_v32i8:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3]
; BITALG_NOVLX-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_3_v32i8:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3]
; BITALG-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <32 x i8> @llvm.ctpop.v32i8(<32 x i8> %0)
  %3 = icmp ult <32 x i8> %2, <i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3>
  %4 = sext <32 x i1> %3 to <32 x i8>
  ret <32 x i8> %4
}

define <32 x i8> @ugt_3_v32i8(<32 x i8> %0) {
; AVX1-LABEL: ugt_3_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3]
; AVX1-NEXT:    vpcmpgtb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_3_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_3_v32i8:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512VPOPCNTDQ-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512VPOPCNTDQ-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512VPOPCNTDQ-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX512VPOPCNTDQ-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_3_v32i8:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512VPOPCNTDQVL-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512VPOPCNTDQVL-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512VPOPCNTDQVL-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX512VPOPCNTDQVL-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_3_v32i8:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_3_v32i8:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <32 x i8> @llvm.ctpop.v32i8(<32 x i8> %0)
  %3 = icmp ugt <32 x i8> %2, <i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3>
  %4 = sext <32 x i1> %3 to <32 x i8>
  ret <32 x i8> %4
}

define <32 x i8> @ult_4_v32i8(<32 x i8> %0) {
; AVX1-LABEL: ult_4_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4]
; AVX1-NEXT:    vpcmpgtb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_4_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4]
; AVX2-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_4_v32i8:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512VPOPCNTDQ-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512VPOPCNTDQ-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512VPOPCNTDQ-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX512VPOPCNTDQ-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_4_v32i8:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512VPOPCNTDQVL-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512VPOPCNTDQVL-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512VPOPCNTDQVL-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX512VPOPCNTDQVL-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_4_v32i8:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4]
; BITALG_NOVLX-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_4_v32i8:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4]
; BITALG-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <32 x i8> @llvm.ctpop.v32i8(<32 x i8> %0)
  %3 = icmp ult <32 x i8> %2, <i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4>
  %4 = sext <32 x i1> %3 to <32 x i8>
  ret <32 x i8> %4
}

define <32 x i8> @ugt_4_v32i8(<32 x i8> %0) {
; AVX1-LABEL: ugt_4_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4]
; AVX1-NEXT:    vpcmpgtb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_4_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_4_v32i8:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512VPOPCNTDQ-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512VPOPCNTDQ-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512VPOPCNTDQ-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX512VPOPCNTDQ-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_4_v32i8:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512VPOPCNTDQVL-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512VPOPCNTDQVL-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512VPOPCNTDQVL-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX512VPOPCNTDQVL-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_4_v32i8:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_4_v32i8:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <32 x i8> @llvm.ctpop.v32i8(<32 x i8> %0)
  %3 = icmp ugt <32 x i8> %2, <i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4>
  %4 = sext <32 x i1> %3 to <32 x i8>
  ret <32 x i8> %4
}

define <32 x i8> @ult_5_v32i8(<32 x i8> %0) {
; AVX1-LABEL: ult_5_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5]
; AVX1-NEXT:    vpcmpgtb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_5_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5]
; AVX2-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_5_v32i8:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512VPOPCNTDQ-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512VPOPCNTDQ-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512VPOPCNTDQ-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX512VPOPCNTDQ-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_5_v32i8:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512VPOPCNTDQVL-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512VPOPCNTDQVL-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512VPOPCNTDQVL-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX512VPOPCNTDQVL-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_5_v32i8:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5]
; BITALG_NOVLX-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_5_v32i8:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5]
; BITALG-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <32 x i8> @llvm.ctpop.v32i8(<32 x i8> %0)
  %3 = icmp ult <32 x i8> %2, <i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5>
  %4 = sext <32 x i1> %3 to <32 x i8>
  ret <32 x i8> %4
}

define <32 x i8> @ugt_5_v32i8(<32 x i8> %0) {
; AVX1-LABEL: ugt_5_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5]
; AVX1-NEXT:    vpcmpgtb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_5_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_5_v32i8:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512VPOPCNTDQ-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512VPOPCNTDQ-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512VPOPCNTDQ-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX512VPOPCNTDQ-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_5_v32i8:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512VPOPCNTDQVL-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512VPOPCNTDQVL-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512VPOPCNTDQVL-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX512VPOPCNTDQVL-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_5_v32i8:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_5_v32i8:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <32 x i8> @llvm.ctpop.v32i8(<32 x i8> %0)
  %3 = icmp ugt <32 x i8> %2, <i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5>
  %4 = sext <32 x i1> %3 to <32 x i8>
  ret <32 x i8> %4
}

define <32 x i8> @ult_6_v32i8(<32 x i8> %0) {
; AVX1-LABEL: ult_6_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6]
; AVX1-NEXT:    vpcmpgtb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_6_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6]
; AVX2-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_6_v32i8:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512VPOPCNTDQ-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512VPOPCNTDQ-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512VPOPCNTDQ-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX512VPOPCNTDQ-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_6_v32i8:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512VPOPCNTDQVL-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512VPOPCNTDQVL-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512VPOPCNTDQVL-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX512VPOPCNTDQVL-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_6_v32i8:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6]
; BITALG_NOVLX-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_6_v32i8:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6]
; BITALG-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <32 x i8> @llvm.ctpop.v32i8(<32 x i8> %0)
  %3 = icmp ult <32 x i8> %2, <i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6>
  %4 = sext <32 x i1> %3 to <32 x i8>
  ret <32 x i8> %4
}

define <32 x i8> @ugt_6_v32i8(<32 x i8> %0) {
; AVX1-LABEL: ugt_6_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6]
; AVX1-NEXT:    vpcmpgtb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_6_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_6_v32i8:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512VPOPCNTDQ-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512VPOPCNTDQ-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512VPOPCNTDQ-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX512VPOPCNTDQ-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_6_v32i8:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512VPOPCNTDQVL-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512VPOPCNTDQVL-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512VPOPCNTDQVL-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX512VPOPCNTDQVL-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_6_v32i8:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_6_v32i8:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <32 x i8> @llvm.ctpop.v32i8(<32 x i8> %0)
  %3 = icmp ugt <32 x i8> %2, <i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6>
  %4 = sext <32 x i1> %3 to <32 x i8>
  ret <32 x i8> %4
}

define <32 x i8> @ult_7_v32i8(<32 x i8> %0) {
; AVX1-LABEL: ult_7_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; AVX1-NEXT:    vpcmpgtb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_7_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; AVX2-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_7_v32i8:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512VPOPCNTDQ-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512VPOPCNTDQ-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512VPOPCNTDQ-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX512VPOPCNTDQ-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_7_v32i8:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512VPOPCNTDQVL-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512VPOPCNTDQVL-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512VPOPCNTDQVL-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX512VPOPCNTDQVL-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_7_v32i8:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; BITALG_NOVLX-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_7_v32i8:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; BITALG-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <32 x i8> @llvm.ctpop.v32i8(<32 x i8> %0)
  %3 = icmp ult <32 x i8> %2, <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7>
  %4 = sext <32 x i1> %3 to <32 x i8>
  ret <32 x i8> %4
}

define <16 x i16> @ugt_1_v16i16(<16 x i16> %0) {
; AVX1-LABEL: ugt_1_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpaddw %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpaddw %xmm2, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpeqw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpxor %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_1_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpaddw %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_1_v16i16:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512VPOPCNTDQ-NEXT:    vpaddw %ymm1, %ymm0, %ymm1
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VPOPCNTDQ-NEXT:    vpcmpeqw %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpternlogq {{.*#+}} zmm0 = ~zmm0
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_1_v16i16:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512VPOPCNTDQVL-NEXT:    vpaddw %ymm1, %ymm0, %ymm1
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VPOPCNTDQVL-NEXT:    vpcmpeqw %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpternlogq {{.*#+}} ymm0 = ~ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_1_v16i16:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntw %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_1_v16i16:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntw %ymm0, %ymm0
; BITALG-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %0)
  %3 = icmp ugt <16 x i16> %2, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %4 = sext <16 x i1> %3 to <16 x i16>
  ret <16 x i16> %4
}

define <16 x i16> @ult_2_v16i16(<16 x i16> %0) {
; AVX1-LABEL: ult_2_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpaddw %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpaddw %xmm2, %xmm0, %xmm2
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpeqw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_2_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpaddw %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpeqw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_2_v16i16:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512VPOPCNTDQ-NEXT:    vpaddw %ymm1, %ymm0, %ymm1
; AVX512VPOPCNTDQ-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VPOPCNTDQ-NEXT:    vpcmpeqw %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_2_v16i16:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512VPOPCNTDQVL-NEXT:    vpaddw %ymm1, %ymm0, %ymm1
; AVX512VPOPCNTDQVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VPOPCNTDQVL-NEXT:    vpcmpeqw %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_2_v16i16:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntw %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2]
; BITALG_NOVLX-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_2_v16i16:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntw %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2]
; BITALG-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %0)
  %3 = icmp ult <16 x i16> %2, <i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2>
  %4 = sext <16 x i1> %3 to <16 x i16>
  ret <16 x i16> %4
}

define <16 x i16> @ugt_2_v16i16(<16 x i16> %0) {
; AVX1-LABEL: ugt_2_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsllw $8, %xmm2, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $8, %xmm0, %xmm1
; AVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [2,2,2,2,2,2,2,2]
; AVX1-NEXT:    vpcmpgtw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_2_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw $8, %ymm0, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_2_v16i16:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_2_v16i16:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQVL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_2_v16i16:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntw %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_2_v16i16:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntw %ymm0, %ymm0
; BITALG-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %0)
  %3 = icmp ugt <16 x i16> %2, <i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2>
  %4 = sext <16 x i1> %3 to <16 x i16>
  ret <16 x i16> %4
}

define <16 x i16> @ult_3_v16i16(<16 x i16> %0) {
; AVX1-LABEL: ult_3_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsllw $8, %xmm2, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $8, %xmm0, %xmm1
; AVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [3,3,3,3,3,3,3,3]
; AVX1-NEXT:    vpcmpgtw %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_3_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw $8, %ymm0, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3]
; AVX2-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_3_v16i16:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_3_v16i16:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQVL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_3_v16i16:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntw %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3]
; BITALG_NOVLX-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_3_v16i16:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntw %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3]
; BITALG-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %0)
  %3 = icmp ult <16 x i16> %2, <i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3>
  %4 = sext <16 x i1> %3 to <16 x i16>
  ret <16 x i16> %4
}

define <16 x i16> @ugt_3_v16i16(<16 x i16> %0) {
; AVX1-LABEL: ugt_3_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsllw $8, %xmm2, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $8, %xmm0, %xmm1
; AVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [3,3,3,3,3,3,3,3]
; AVX1-NEXT:    vpcmpgtw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_3_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw $8, %ymm0, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_3_v16i16:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_3_v16i16:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQVL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_3_v16i16:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntw %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_3_v16i16:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntw %ymm0, %ymm0
; BITALG-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %0)
  %3 = icmp ugt <16 x i16> %2, <i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3>
  %4 = sext <16 x i1> %3 to <16 x i16>
  ret <16 x i16> %4
}

define <16 x i16> @ult_4_v16i16(<16 x i16> %0) {
; AVX1-LABEL: ult_4_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsllw $8, %xmm2, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $8, %xmm0, %xmm1
; AVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [4,4,4,4,4,4,4,4]
; AVX1-NEXT:    vpcmpgtw %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_4_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw $8, %ymm0, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4]
; AVX2-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_4_v16i16:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_4_v16i16:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQVL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_4_v16i16:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntw %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4]
; BITALG_NOVLX-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_4_v16i16:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntw %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4]
; BITALG-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %0)
  %3 = icmp ult <16 x i16> %2, <i16 4, i16 4, i16 4, i16 4, i16 4, i16 4, i16 4, i16 4, i16 4, i16 4, i16 4, i16 4, i16 4, i16 4, i16 4, i16 4>
  %4 = sext <16 x i1> %3 to <16 x i16>
  ret <16 x i16> %4
}

define <16 x i16> @ugt_4_v16i16(<16 x i16> %0) {
; AVX1-LABEL: ugt_4_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsllw $8, %xmm2, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $8, %xmm0, %xmm1
; AVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [4,4,4,4,4,4,4,4]
; AVX1-NEXT:    vpcmpgtw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_4_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw $8, %ymm0, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_4_v16i16:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_4_v16i16:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQVL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_4_v16i16:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntw %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_4_v16i16:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntw %ymm0, %ymm0
; BITALG-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %0)
  %3 = icmp ugt <16 x i16> %2, <i16 4, i16 4, i16 4, i16 4, i16 4, i16 4, i16 4, i16 4, i16 4, i16 4, i16 4, i16 4, i16 4, i16 4, i16 4, i16 4>
  %4 = sext <16 x i1> %3 to <16 x i16>
  ret <16 x i16> %4
}

define <16 x i16> @ult_5_v16i16(<16 x i16> %0) {
; AVX1-LABEL: ult_5_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsllw $8, %xmm2, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $8, %xmm0, %xmm1
; AVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [5,5,5,5,5,5,5,5]
; AVX1-NEXT:    vpcmpgtw %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_5_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw $8, %ymm0, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5]
; AVX2-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_5_v16i16:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_5_v16i16:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQVL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_5_v16i16:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntw %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5]
; BITALG_NOVLX-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_5_v16i16:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntw %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5]
; BITALG-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %0)
  %3 = icmp ult <16 x i16> %2, <i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5>
  %4 = sext <16 x i1> %3 to <16 x i16>
  ret <16 x i16> %4
}

define <16 x i16> @ugt_5_v16i16(<16 x i16> %0) {
; AVX1-LABEL: ugt_5_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsllw $8, %xmm2, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $8, %xmm0, %xmm1
; AVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [5,5,5,5,5,5,5,5]
; AVX1-NEXT:    vpcmpgtw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_5_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw $8, %ymm0, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_5_v16i16:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_5_v16i16:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQVL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_5_v16i16:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntw %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_5_v16i16:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntw %ymm0, %ymm0
; BITALG-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %0)
  %3 = icmp ugt <16 x i16> %2, <i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5>
  %4 = sext <16 x i1> %3 to <16 x i16>
  ret <16 x i16> %4
}

define <16 x i16> @ult_6_v16i16(<16 x i16> %0) {
; AVX1-LABEL: ult_6_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsllw $8, %xmm2, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $8, %xmm0, %xmm1
; AVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [6,6,6,6,6,6,6,6]
; AVX1-NEXT:    vpcmpgtw %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_6_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw $8, %ymm0, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6]
; AVX2-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_6_v16i16:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_6_v16i16:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQVL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_6_v16i16:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntw %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6]
; BITALG_NOVLX-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_6_v16i16:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntw %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6]
; BITALG-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %0)
  %3 = icmp ult <16 x i16> %2, <i16 6, i16 6, i16 6, i16 6, i16 6, i16 6, i16 6, i16 6, i16 6, i16 6, i16 6, i16 6, i16 6, i16 6, i16 6, i16 6>
  %4 = sext <16 x i1> %3 to <16 x i16>
  ret <16 x i16> %4
}

define <16 x i16> @ugt_6_v16i16(<16 x i16> %0) {
; AVX1-LABEL: ugt_6_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsllw $8, %xmm2, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $8, %xmm0, %xmm1
; AVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [6,6,6,6,6,6,6,6]
; AVX1-NEXT:    vpcmpgtw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_6_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw $8, %ymm0, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_6_v16i16:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_6_v16i16:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQVL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_6_v16i16:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntw %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_6_v16i16:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntw %ymm0, %ymm0
; BITALG-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %0)
  %3 = icmp ugt <16 x i16> %2, <i16 6, i16 6, i16 6, i16 6, i16 6, i16 6, i16 6, i16 6, i16 6, i16 6, i16 6, i16 6, i16 6, i16 6, i16 6, i16 6>
  %4 = sext <16 x i1> %3 to <16 x i16>
  ret <16 x i16> %4
}

define <16 x i16> @ult_7_v16i16(<16 x i16> %0) {
; AVX1-LABEL: ult_7_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsllw $8, %xmm2, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $8, %xmm0, %xmm1
; AVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [7,7,7,7,7,7,7,7]
; AVX1-NEXT:    vpcmpgtw %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_7_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw $8, %ymm0, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; AVX2-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_7_v16i16:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_7_v16i16:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQVL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_7_v16i16:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntw %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; BITALG_NOVLX-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_7_v16i16:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntw %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; BITALG-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %0)
  %3 = icmp ult <16 x i16> %2, <i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7>
  %4 = sext <16 x i1> %3 to <16 x i16>
  ret <16 x i16> %4
}

define <16 x i16> @ugt_7_v16i16(<16 x i16> %0) {
; AVX1-LABEL: ugt_7_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsllw $8, %xmm2, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $8, %xmm0, %xmm1
; AVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [7,7,7,7,7,7,7,7]
; AVX1-NEXT:    vpcmpgtw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_7_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw $8, %ymm0, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_7_v16i16:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_7_v16i16:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQVL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_7_v16i16:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntw %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_7_v16i16:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntw %ymm0, %ymm0
; BITALG-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %0)
  %3 = icmp ugt <16 x i16> %2, <i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7>
  %4 = sext <16 x i1> %3 to <16 x i16>
  ret <16 x i16> %4
}

define <16 x i16> @ult_8_v16i16(<16 x i16> %0) {
; AVX1-LABEL: ult_8_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsllw $8, %xmm2, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $8, %xmm0, %xmm1
; AVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [8,8,8,8,8,8,8,8]
; AVX1-NEXT:    vpcmpgtw %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_8_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw $8, %ymm0, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX2-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_8_v16i16:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_8_v16i16:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQVL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_8_v16i16:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntw %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; BITALG_NOVLX-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_8_v16i16:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntw %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; BITALG-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %0)
  %3 = icmp ult <16 x i16> %2, <i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8>
  %4 = sext <16 x i1> %3 to <16 x i16>
  ret <16 x i16> %4
}

define <16 x i16> @ugt_8_v16i16(<16 x i16> %0) {
; AVX1-LABEL: ugt_8_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsllw $8, %xmm2, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $8, %xmm0, %xmm1
; AVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [8,8,8,8,8,8,8,8]
; AVX1-NEXT:    vpcmpgtw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_8_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw $8, %ymm0, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_8_v16i16:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_8_v16i16:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQVL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_8_v16i16:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntw %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_8_v16i16:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntw %ymm0, %ymm0
; BITALG-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %0)
  %3 = icmp ugt <16 x i16> %2, <i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8>
  %4 = sext <16 x i1> %3 to <16 x i16>
  ret <16 x i16> %4
}

define <16 x i16> @ult_9_v16i16(<16 x i16> %0) {
; AVX1-LABEL: ult_9_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsllw $8, %xmm2, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $8, %xmm0, %xmm1
; AVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [9,9,9,9,9,9,9,9]
; AVX1-NEXT:    vpcmpgtw %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_9_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw $8, %ymm0, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9]
; AVX2-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_9_v16i16:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_9_v16i16:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQVL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_9_v16i16:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntw %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9]
; BITALG_NOVLX-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_9_v16i16:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntw %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9]
; BITALG-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %0)
  %3 = icmp ult <16 x i16> %2, <i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9>
  %4 = sext <16 x i1> %3 to <16 x i16>
  ret <16 x i16> %4
}

define <16 x i16> @ugt_9_v16i16(<16 x i16> %0) {
; AVX1-LABEL: ugt_9_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsllw $8, %xmm2, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $8, %xmm0, %xmm1
; AVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [9,9,9,9,9,9,9,9]
; AVX1-NEXT:    vpcmpgtw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_9_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw $8, %ymm0, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_9_v16i16:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_9_v16i16:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQVL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_9_v16i16:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntw %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_9_v16i16:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntw %ymm0, %ymm0
; BITALG-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %0)
  %3 = icmp ugt <16 x i16> %2, <i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9>
  %4 = sext <16 x i1> %3 to <16 x i16>
  ret <16 x i16> %4
}

define <16 x i16> @ult_10_v16i16(<16 x i16> %0) {
; AVX1-LABEL: ult_10_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsllw $8, %xmm2, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $8, %xmm0, %xmm1
; AVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [10,10,10,10,10,10,10,10]
; AVX1-NEXT:    vpcmpgtw %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_10_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw $8, %ymm0, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10]
; AVX2-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_10_v16i16:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_10_v16i16:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQVL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_10_v16i16:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntw %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10]
; BITALG_NOVLX-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_10_v16i16:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntw %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10]
; BITALG-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %0)
  %3 = icmp ult <16 x i16> %2, <i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10>
  %4 = sext <16 x i1> %3 to <16 x i16>
  ret <16 x i16> %4
}

define <16 x i16> @ugt_10_v16i16(<16 x i16> %0) {
; AVX1-LABEL: ugt_10_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsllw $8, %xmm2, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $8, %xmm0, %xmm1
; AVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [10,10,10,10,10,10,10,10]
; AVX1-NEXT:    vpcmpgtw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_10_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw $8, %ymm0, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_10_v16i16:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_10_v16i16:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQVL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_10_v16i16:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntw %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_10_v16i16:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntw %ymm0, %ymm0
; BITALG-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %0)
  %3 = icmp ugt <16 x i16> %2, <i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10>
  %4 = sext <16 x i1> %3 to <16 x i16>
  ret <16 x i16> %4
}

define <16 x i16> @ult_11_v16i16(<16 x i16> %0) {
; AVX1-LABEL: ult_11_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsllw $8, %xmm2, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $8, %xmm0, %xmm1
; AVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [11,11,11,11,11,11,11,11]
; AVX1-NEXT:    vpcmpgtw %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_11_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw $8, %ymm0, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11]
; AVX2-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_11_v16i16:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_11_v16i16:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQVL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_11_v16i16:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntw %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11]
; BITALG_NOVLX-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_11_v16i16:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntw %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11]
; BITALG-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %0)
  %3 = icmp ult <16 x i16> %2, <i16 11, i16 11, i16 11, i16 11, i16 11, i16 11, i16 11, i16 11, i16 11, i16 11, i16 11, i16 11, i16 11, i16 11, i16 11, i16 11>
  %4 = sext <16 x i1> %3 to <16 x i16>
  ret <16 x i16> %4
}

define <16 x i16> @ugt_11_v16i16(<16 x i16> %0) {
; AVX1-LABEL: ugt_11_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsllw $8, %xmm2, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $8, %xmm0, %xmm1
; AVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [11,11,11,11,11,11,11,11]
; AVX1-NEXT:    vpcmpgtw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_11_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw $8, %ymm0, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_11_v16i16:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_11_v16i16:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQVL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_11_v16i16:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntw %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_11_v16i16:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntw %ymm0, %ymm0
; BITALG-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %0)
  %3 = icmp ugt <16 x i16> %2, <i16 11, i16 11, i16 11, i16 11, i16 11, i16 11, i16 11, i16 11, i16 11, i16 11, i16 11, i16 11, i16 11, i16 11, i16 11, i16 11>
  %4 = sext <16 x i1> %3 to <16 x i16>
  ret <16 x i16> %4
}

define <16 x i16> @ult_12_v16i16(<16 x i16> %0) {
; AVX1-LABEL: ult_12_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsllw $8, %xmm2, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $8, %xmm0, %xmm1
; AVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [12,12,12,12,12,12,12,12]
; AVX1-NEXT:    vpcmpgtw %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_12_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw $8, %ymm0, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12]
; AVX2-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_12_v16i16:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_12_v16i16:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQVL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_12_v16i16:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntw %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12]
; BITALG_NOVLX-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_12_v16i16:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntw %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12]
; BITALG-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %0)
  %3 = icmp ult <16 x i16> %2, <i16 12, i16 12, i16 12, i16 12, i16 12, i16 12, i16 12, i16 12, i16 12, i16 12, i16 12, i16 12, i16 12, i16 12, i16 12, i16 12>
  %4 = sext <16 x i1> %3 to <16 x i16>
  ret <16 x i16> %4
}

define <16 x i16> @ugt_12_v16i16(<16 x i16> %0) {
; AVX1-LABEL: ugt_12_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsllw $8, %xmm2, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $8, %xmm0, %xmm1
; AVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [12,12,12,12,12,12,12,12]
; AVX1-NEXT:    vpcmpgtw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_12_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw $8, %ymm0, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_12_v16i16:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_12_v16i16:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQVL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_12_v16i16:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntw %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_12_v16i16:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntw %ymm0, %ymm0
; BITALG-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %0)
  %3 = icmp ugt <16 x i16> %2, <i16 12, i16 12, i16 12, i16 12, i16 12, i16 12, i16 12, i16 12, i16 12, i16 12, i16 12, i16 12, i16 12, i16 12, i16 12, i16 12>
  %4 = sext <16 x i1> %3 to <16 x i16>
  ret <16 x i16> %4
}

define <16 x i16> @ult_13_v16i16(<16 x i16> %0) {
; AVX1-LABEL: ult_13_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsllw $8, %xmm2, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $8, %xmm0, %xmm1
; AVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [13,13,13,13,13,13,13,13]
; AVX1-NEXT:    vpcmpgtw %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_13_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw $8, %ymm0, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13]
; AVX2-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_13_v16i16:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_13_v16i16:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQVL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_13_v16i16:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntw %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13]
; BITALG_NOVLX-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_13_v16i16:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntw %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13]
; BITALG-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %0)
  %3 = icmp ult <16 x i16> %2, <i16 13, i16 13, i16 13, i16 13, i16 13, i16 13, i16 13, i16 13, i16 13, i16 13, i16 13, i16 13, i16 13, i16 13, i16 13, i16 13>
  %4 = sext <16 x i1> %3 to <16 x i16>
  ret <16 x i16> %4
}

define <16 x i16> @ugt_13_v16i16(<16 x i16> %0) {
; AVX1-LABEL: ugt_13_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsllw $8, %xmm2, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $8, %xmm0, %xmm1
; AVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [13,13,13,13,13,13,13,13]
; AVX1-NEXT:    vpcmpgtw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_13_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw $8, %ymm0, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_13_v16i16:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_13_v16i16:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQVL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_13_v16i16:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntw %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_13_v16i16:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntw %ymm0, %ymm0
; BITALG-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %0)
  %3 = icmp ugt <16 x i16> %2, <i16 13, i16 13, i16 13, i16 13, i16 13, i16 13, i16 13, i16 13, i16 13, i16 13, i16 13, i16 13, i16 13, i16 13, i16 13, i16 13>
  %4 = sext <16 x i1> %3 to <16 x i16>
  ret <16 x i16> %4
}

define <16 x i16> @ult_14_v16i16(<16 x i16> %0) {
; AVX1-LABEL: ult_14_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsllw $8, %xmm2, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $8, %xmm0, %xmm1
; AVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [14,14,14,14,14,14,14,14]
; AVX1-NEXT:    vpcmpgtw %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_14_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw $8, %ymm0, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14]
; AVX2-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_14_v16i16:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_14_v16i16:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQVL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_14_v16i16:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntw %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14]
; BITALG_NOVLX-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_14_v16i16:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntw %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14]
; BITALG-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %0)
  %3 = icmp ult <16 x i16> %2, <i16 14, i16 14, i16 14, i16 14, i16 14, i16 14, i16 14, i16 14, i16 14, i16 14, i16 14, i16 14, i16 14, i16 14, i16 14, i16 14>
  %4 = sext <16 x i1> %3 to <16 x i16>
  ret <16 x i16> %4
}

define <16 x i16> @ugt_14_v16i16(<16 x i16> %0) {
; AVX1-LABEL: ugt_14_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsllw $8, %xmm2, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $8, %xmm0, %xmm1
; AVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [14,14,14,14,14,14,14,14]
; AVX1-NEXT:    vpcmpgtw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_14_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw $8, %ymm0, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_14_v16i16:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_14_v16i16:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQVL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_14_v16i16:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntw %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_14_v16i16:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntw %ymm0, %ymm0
; BITALG-NEXT:    vpcmpgtw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %0)
  %3 = icmp ugt <16 x i16> %2, <i16 14, i16 14, i16 14, i16 14, i16 14, i16 14, i16 14, i16 14, i16 14, i16 14, i16 14, i16 14, i16 14, i16 14, i16 14, i16 14>
  %4 = sext <16 x i1> %3 to <16 x i16>
  ret <16 x i16> %4
}

define <16 x i16> @ult_15_v16i16(<16 x i16> %0) {
; AVX1-LABEL: ult_15_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsllw $8, %xmm2, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $8, %xmm0, %xmm1
; AVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpcmpgtw %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_15_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw $8, %ymm0, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_15_v16i16:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_15_v16i16:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQVL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_15_v16i16:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntw %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; BITALG_NOVLX-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_15_v16i16:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntw %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; BITALG-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %0)
  %3 = icmp ult <16 x i16> %2, <i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15>
  %4 = sext <16 x i1> %3 to <16 x i16>
  ret <16 x i16> %4
}

define <8 x i32> @ugt_1_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ugt_1_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpaddd %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpaddd %xmm2, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpxor %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_1_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpaddd %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_1_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [1,1,1,1,1,1,1,1]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_1_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [1,1,1,1,1,1,1,1]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_1_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; BITALG_NOVLX-NEXT:    vpaddd %ymm1, %ymm0, %ymm1
; BITALG_NOVLX-NEXT:    vpand %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpcmpeqd %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpternlogq {{.*#+}} zmm0 = ~zmm0
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_1_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; BITALG-NEXT:    vpaddd %ymm1, %ymm0, %ymm1
; BITALG-NEXT:    vpand %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpcmpeqd %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpternlogq {{.*#+}} ymm0 = ~ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ugt <8 x i32> %2, <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ult_2_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ult_2_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpaddd %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpaddd %xmm2, %xmm0, %xmm2
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_2_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpaddd %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_2_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [2,2,2,2,2,2,2,2]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_2_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [2,2,2,2,2,2,2,2]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_2_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; BITALG_NOVLX-NEXT:    vpaddd %ymm1, %ymm0, %ymm1
; BITALG_NOVLX-NEXT:    vpand %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpcmpeqd %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_2_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; BITALG-NEXT:    vpaddd %ymm1, %ymm0, %ymm1
; BITALG-NEXT:    vpand %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpcmpeqd %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ult <8 x i32> %2, <i32 2, i32 2, i32 2, i32 2, i32 2, i32 2, i32 2, i32 2>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ugt_2_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ugt_2_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} ymm1 = [2.0E+0,2.0E+0,2.0E+0,2.0E+0,2.0E+0,2.0E+0,2.0E+0,2.0E+0]
; AVX1-NEXT:    vcmpltps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_2_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [2,2,2,2,2,2,2,2]
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_2_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [2,2,2,2,2,2,2,2]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_2_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [2,2,2,2,2,2,2,2]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_2_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [2,2,2,2,2,2,2,2]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_2_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [2,2,2,2,2,2,2,2]
; BITALG-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ugt <8 x i32> %2, <i32 2, i32 2, i32 2, i32 2, i32 2, i32 2, i32 2, i32 2>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ult_3_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ult_3_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vcmpltps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_3_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [3,3,3,3,3,3,3,3]
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_3_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [3,3,3,3,3,3,3,3]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_3_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [3,3,3,3,3,3,3,3]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_3_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [3,3,3,3,3,3,3,3]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_3_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [3,3,3,3,3,3,3,3]
; BITALG-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ult <8 x i32> %2, <i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ugt_3_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ugt_3_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} ymm1 = [3.0E+0,3.0E+0,3.0E+0,3.0E+0,3.0E+0,3.0E+0,3.0E+0,3.0E+0]
; AVX1-NEXT:    vcmpltps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_3_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [3,3,3,3,3,3,3,3]
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_3_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [3,3,3,3,3,3,3,3]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_3_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [3,3,3,3,3,3,3,3]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_3_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [3,3,3,3,3,3,3,3]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_3_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [3,3,3,3,3,3,3,3]
; BITALG-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ugt <8 x i32> %2, <i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ult_4_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ult_4_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vcmpltps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_4_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [4,4,4,4,4,4,4,4]
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_4_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [4,4,4,4,4,4,4,4]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_4_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [4,4,4,4,4,4,4,4]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_4_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [4,4,4,4,4,4,4,4]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_4_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [4,4,4,4,4,4,4,4]
; BITALG-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ult <8 x i32> %2, <i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ugt_4_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ugt_4_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} ymm1 = [4.0E+0,4.0E+0,4.0E+0,4.0E+0,4.0E+0,4.0E+0,4.0E+0,4.0E+0]
; AVX1-NEXT:    vcmpltps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_4_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [4,4,4,4,4,4,4,4]
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_4_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [4,4,4,4,4,4,4,4]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_4_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [4,4,4,4,4,4,4,4]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_4_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [4,4,4,4,4,4,4,4]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_4_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [4,4,4,4,4,4,4,4]
; BITALG-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ugt <8 x i32> %2, <i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ult_5_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ult_5_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vcmpltps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_5_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [5,5,5,5,5,5,5,5]
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_5_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [5,5,5,5,5,5,5,5]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_5_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [5,5,5,5,5,5,5,5]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_5_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [5,5,5,5,5,5,5,5]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_5_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [5,5,5,5,5,5,5,5]
; BITALG-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ult <8 x i32> %2, <i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ugt_5_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ugt_5_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} ymm1 = [5.0E+0,5.0E+0,5.0E+0,5.0E+0,5.0E+0,5.0E+0,5.0E+0,5.0E+0]
; AVX1-NEXT:    vcmpltps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_5_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [5,5,5,5,5,5,5,5]
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_5_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [5,5,5,5,5,5,5,5]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_5_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [5,5,5,5,5,5,5,5]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_5_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [5,5,5,5,5,5,5,5]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_5_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [5,5,5,5,5,5,5,5]
; BITALG-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ugt <8 x i32> %2, <i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ult_6_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ult_6_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vcmpltps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_6_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [6,6,6,6,6,6,6,6]
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_6_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [6,6,6,6,6,6,6,6]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_6_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [6,6,6,6,6,6,6,6]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_6_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [6,6,6,6,6,6,6,6]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_6_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [6,6,6,6,6,6,6,6]
; BITALG-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ult <8 x i32> %2, <i32 6, i32 6, i32 6, i32 6, i32 6, i32 6, i32 6, i32 6>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ugt_6_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ugt_6_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} ymm1 = [6.0E+0,6.0E+0,6.0E+0,6.0E+0,6.0E+0,6.0E+0,6.0E+0,6.0E+0]
; AVX1-NEXT:    vcmpltps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_6_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [6,6,6,6,6,6,6,6]
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_6_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [6,6,6,6,6,6,6,6]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_6_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [6,6,6,6,6,6,6,6]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_6_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [6,6,6,6,6,6,6,6]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_6_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [6,6,6,6,6,6,6,6]
; BITALG-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ugt <8 x i32> %2, <i32 6, i32 6, i32 6, i32 6, i32 6, i32 6, i32 6, i32 6>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ult_7_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ult_7_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vcmpltps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_7_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [7,7,7,7,7,7,7,7]
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_7_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [7,7,7,7,7,7,7,7]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_7_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [7,7,7,7,7,7,7,7]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_7_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [7,7,7,7,7,7,7,7]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_7_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [7,7,7,7,7,7,7,7]
; BITALG-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ult <8 x i32> %2, <i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ugt_7_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ugt_7_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} ymm1 = [7.0E+0,7.0E+0,7.0E+0,7.0E+0,7.0E+0,7.0E+0,7.0E+0,7.0E+0]
; AVX1-NEXT:    vcmpltps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_7_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [7,7,7,7,7,7,7,7]
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_7_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [7,7,7,7,7,7,7,7]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_7_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [7,7,7,7,7,7,7,7]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_7_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [7,7,7,7,7,7,7,7]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_7_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [7,7,7,7,7,7,7,7]
; BITALG-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ugt <8 x i32> %2, <i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ult_8_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ult_8_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vcmpltps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_8_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [8,8,8,8,8,8,8,8]
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_8_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [8,8,8,8,8,8,8,8]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_8_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [8,8,8,8,8,8,8,8]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_8_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [8,8,8,8,8,8,8,8]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_8_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [8,8,8,8,8,8,8,8]
; BITALG-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ult <8 x i32> %2, <i32 8, i32 8, i32 8, i32 8, i32 8, i32 8, i32 8, i32 8>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ugt_8_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ugt_8_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} ymm1 = [8.0E+0,8.0E+0,8.0E+0,8.0E+0,8.0E+0,8.0E+0,8.0E+0,8.0E+0]
; AVX1-NEXT:    vcmpltps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_8_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [8,8,8,8,8,8,8,8]
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_8_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [8,8,8,8,8,8,8,8]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_8_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [8,8,8,8,8,8,8,8]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_8_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [8,8,8,8,8,8,8,8]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_8_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [8,8,8,8,8,8,8,8]
; BITALG-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ugt <8 x i32> %2, <i32 8, i32 8, i32 8, i32 8, i32 8, i32 8, i32 8, i32 8>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ult_9_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ult_9_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vcmpltps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_9_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [9,9,9,9,9,9,9,9]
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_9_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [9,9,9,9,9,9,9,9]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_9_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [9,9,9,9,9,9,9,9]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_9_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [9,9,9,9,9,9,9,9]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_9_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [9,9,9,9,9,9,9,9]
; BITALG-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ult <8 x i32> %2, <i32 9, i32 9, i32 9, i32 9, i32 9, i32 9, i32 9, i32 9>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ugt_9_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ugt_9_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} ymm1 = [9.0E+0,9.0E+0,9.0E+0,9.0E+0,9.0E+0,9.0E+0,9.0E+0,9.0E+0]
; AVX1-NEXT:    vcmpltps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_9_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [9,9,9,9,9,9,9,9]
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_9_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [9,9,9,9,9,9,9,9]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_9_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [9,9,9,9,9,9,9,9]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_9_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [9,9,9,9,9,9,9,9]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_9_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [9,9,9,9,9,9,9,9]
; BITALG-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ugt <8 x i32> %2, <i32 9, i32 9, i32 9, i32 9, i32 9, i32 9, i32 9, i32 9>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ult_10_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ult_10_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vcmpltps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_10_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [10,10,10,10,10,10,10,10]
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_10_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [10,10,10,10,10,10,10,10]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_10_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [10,10,10,10,10,10,10,10]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_10_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [10,10,10,10,10,10,10,10]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_10_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [10,10,10,10,10,10,10,10]
; BITALG-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ult <8 x i32> %2, <i32 10, i32 10, i32 10, i32 10, i32 10, i32 10, i32 10, i32 10>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ugt_10_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ugt_10_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} ymm1 = [1.0E+1,1.0E+1,1.0E+1,1.0E+1,1.0E+1,1.0E+1,1.0E+1,1.0E+1]
; AVX1-NEXT:    vcmpltps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_10_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [10,10,10,10,10,10,10,10]
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_10_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [10,10,10,10,10,10,10,10]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_10_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [10,10,10,10,10,10,10,10]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_10_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [10,10,10,10,10,10,10,10]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_10_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [10,10,10,10,10,10,10,10]
; BITALG-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ugt <8 x i32> %2, <i32 10, i32 10, i32 10, i32 10, i32 10, i32 10, i32 10, i32 10>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ult_11_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ult_11_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vcmpltps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_11_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [11,11,11,11,11,11,11,11]
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_11_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [11,11,11,11,11,11,11,11]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_11_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [11,11,11,11,11,11,11,11]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_11_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [11,11,11,11,11,11,11,11]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_11_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [11,11,11,11,11,11,11,11]
; BITALG-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ult <8 x i32> %2, <i32 11, i32 11, i32 11, i32 11, i32 11, i32 11, i32 11, i32 11>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ugt_11_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ugt_11_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} ymm1 = [1.1E+1,1.1E+1,1.1E+1,1.1E+1,1.1E+1,1.1E+1,1.1E+1,1.1E+1]
; AVX1-NEXT:    vcmpltps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_11_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [11,11,11,11,11,11,11,11]
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_11_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [11,11,11,11,11,11,11,11]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_11_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [11,11,11,11,11,11,11,11]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_11_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [11,11,11,11,11,11,11,11]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_11_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [11,11,11,11,11,11,11,11]
; BITALG-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ugt <8 x i32> %2, <i32 11, i32 11, i32 11, i32 11, i32 11, i32 11, i32 11, i32 11>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ult_12_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ult_12_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vcmpltps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_12_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [12,12,12,12,12,12,12,12]
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_12_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [12,12,12,12,12,12,12,12]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_12_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [12,12,12,12,12,12,12,12]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_12_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [12,12,12,12,12,12,12,12]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_12_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [12,12,12,12,12,12,12,12]
; BITALG-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ult <8 x i32> %2, <i32 12, i32 12, i32 12, i32 12, i32 12, i32 12, i32 12, i32 12>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ugt_12_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ugt_12_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} ymm1 = [1.2E+1,1.2E+1,1.2E+1,1.2E+1,1.2E+1,1.2E+1,1.2E+1,1.2E+1]
; AVX1-NEXT:    vcmpltps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_12_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [12,12,12,12,12,12,12,12]
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_12_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [12,12,12,12,12,12,12,12]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_12_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [12,12,12,12,12,12,12,12]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_12_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [12,12,12,12,12,12,12,12]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_12_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [12,12,12,12,12,12,12,12]
; BITALG-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ugt <8 x i32> %2, <i32 12, i32 12, i32 12, i32 12, i32 12, i32 12, i32 12, i32 12>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ult_13_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ult_13_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vcmpltps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_13_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [13,13,13,13,13,13,13,13]
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_13_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [13,13,13,13,13,13,13,13]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_13_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [13,13,13,13,13,13,13,13]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_13_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [13,13,13,13,13,13,13,13]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_13_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [13,13,13,13,13,13,13,13]
; BITALG-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ult <8 x i32> %2, <i32 13, i32 13, i32 13, i32 13, i32 13, i32 13, i32 13, i32 13>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ugt_13_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ugt_13_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} ymm1 = [1.3E+1,1.3E+1,1.3E+1,1.3E+1,1.3E+1,1.3E+1,1.3E+1,1.3E+1]
; AVX1-NEXT:    vcmpltps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_13_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [13,13,13,13,13,13,13,13]
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_13_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [13,13,13,13,13,13,13,13]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_13_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [13,13,13,13,13,13,13,13]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_13_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [13,13,13,13,13,13,13,13]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_13_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [13,13,13,13,13,13,13,13]
; BITALG-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ugt <8 x i32> %2, <i32 13, i32 13, i32 13, i32 13, i32 13, i32 13, i32 13, i32 13>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ult_14_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ult_14_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vcmpltps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_14_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [14,14,14,14,14,14,14,14]
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_14_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [14,14,14,14,14,14,14,14]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_14_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [14,14,14,14,14,14,14,14]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_14_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [14,14,14,14,14,14,14,14]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_14_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [14,14,14,14,14,14,14,14]
; BITALG-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ult <8 x i32> %2, <i32 14, i32 14, i32 14, i32 14, i32 14, i32 14, i32 14, i32 14>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ugt_14_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ugt_14_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} ymm1 = [1.4E+1,1.4E+1,1.4E+1,1.4E+1,1.4E+1,1.4E+1,1.4E+1,1.4E+1]
; AVX1-NEXT:    vcmpltps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_14_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [14,14,14,14,14,14,14,14]
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_14_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [14,14,14,14,14,14,14,14]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_14_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [14,14,14,14,14,14,14,14]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_14_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [14,14,14,14,14,14,14,14]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_14_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [14,14,14,14,14,14,14,14]
; BITALG-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ugt <8 x i32> %2, <i32 14, i32 14, i32 14, i32 14, i32 14, i32 14, i32 14, i32 14>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ult_15_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ult_15_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vcmpltps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_15_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_15_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_15_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_15_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_15_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15]
; BITALG-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ult <8 x i32> %2, <i32 15, i32 15, i32 15, i32 15, i32 15, i32 15, i32 15, i32 15>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ugt_15_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ugt_15_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} ymm1 = [1.5E+1,1.5E+1,1.5E+1,1.5E+1,1.5E+1,1.5E+1,1.5E+1,1.5E+1]
; AVX1-NEXT:    vcmpltps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_15_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_15_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_15_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_15_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_15_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15]
; BITALG-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ugt <8 x i32> %2, <i32 15, i32 15, i32 15, i32 15, i32 15, i32 15, i32 15, i32 15>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ult_16_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ult_16_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vcmpltps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_16_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [16,16,16,16,16,16,16,16]
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_16_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [16,16,16,16,16,16,16,16]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_16_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [16,16,16,16,16,16,16,16]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_16_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [16,16,16,16,16,16,16,16]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_16_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [16,16,16,16,16,16,16,16]
; BITALG-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ult <8 x i32> %2, <i32 16, i32 16, i32 16, i32 16, i32 16, i32 16, i32 16, i32 16>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ugt_16_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ugt_16_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} ymm1 = [1.6E+1,1.6E+1,1.6E+1,1.6E+1,1.6E+1,1.6E+1,1.6E+1,1.6E+1]
; AVX1-NEXT:    vcmpltps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_16_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [16,16,16,16,16,16,16,16]
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_16_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [16,16,16,16,16,16,16,16]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_16_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [16,16,16,16,16,16,16,16]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_16_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [16,16,16,16,16,16,16,16]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_16_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [16,16,16,16,16,16,16,16]
; BITALG-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ugt <8 x i32> %2, <i32 16, i32 16, i32 16, i32 16, i32 16, i32 16, i32 16, i32 16>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ult_17_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ult_17_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vcmpltps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_17_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [17,17,17,17,17,17,17,17]
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_17_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [17,17,17,17,17,17,17,17]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_17_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [17,17,17,17,17,17,17,17]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_17_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [17,17,17,17,17,17,17,17]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_17_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [17,17,17,17,17,17,17,17]
; BITALG-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ult <8 x i32> %2, <i32 17, i32 17, i32 17, i32 17, i32 17, i32 17, i32 17, i32 17>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ugt_17_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ugt_17_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} ymm1 = [1.7E+1,1.7E+1,1.7E+1,1.7E+1,1.7E+1,1.7E+1,1.7E+1,1.7E+1]
; AVX1-NEXT:    vcmpltps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_17_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [17,17,17,17,17,17,17,17]
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_17_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [17,17,17,17,17,17,17,17]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_17_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [17,17,17,17,17,17,17,17]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_17_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [17,17,17,17,17,17,17,17]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_17_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [17,17,17,17,17,17,17,17]
; BITALG-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ugt <8 x i32> %2, <i32 17, i32 17, i32 17, i32 17, i32 17, i32 17, i32 17, i32 17>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ult_18_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ult_18_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vcmpltps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_18_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [18,18,18,18,18,18,18,18]
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_18_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [18,18,18,18,18,18,18,18]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_18_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [18,18,18,18,18,18,18,18]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_18_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [18,18,18,18,18,18,18,18]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_18_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [18,18,18,18,18,18,18,18]
; BITALG-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ult <8 x i32> %2, <i32 18, i32 18, i32 18, i32 18, i32 18, i32 18, i32 18, i32 18>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ugt_18_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ugt_18_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} ymm1 = [1.8E+1,1.8E+1,1.8E+1,1.8E+1,1.8E+1,1.8E+1,1.8E+1,1.8E+1]
; AVX1-NEXT:    vcmpltps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_18_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [18,18,18,18,18,18,18,18]
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_18_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [18,18,18,18,18,18,18,18]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_18_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [18,18,18,18,18,18,18,18]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_18_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [18,18,18,18,18,18,18,18]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_18_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [18,18,18,18,18,18,18,18]
; BITALG-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ugt <8 x i32> %2, <i32 18, i32 18, i32 18, i32 18, i32 18, i32 18, i32 18, i32 18>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ult_19_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ult_19_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vcmpltps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_19_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [19,19,19,19,19,19,19,19]
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_19_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [19,19,19,19,19,19,19,19]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_19_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [19,19,19,19,19,19,19,19]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_19_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [19,19,19,19,19,19,19,19]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_19_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [19,19,19,19,19,19,19,19]
; BITALG-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ult <8 x i32> %2, <i32 19, i32 19, i32 19, i32 19, i32 19, i32 19, i32 19, i32 19>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ugt_19_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ugt_19_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} ymm1 = [1.9E+1,1.9E+1,1.9E+1,1.9E+1,1.9E+1,1.9E+1,1.9E+1,1.9E+1]
; AVX1-NEXT:    vcmpltps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_19_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [19,19,19,19,19,19,19,19]
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_19_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [19,19,19,19,19,19,19,19]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_19_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [19,19,19,19,19,19,19,19]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_19_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [19,19,19,19,19,19,19,19]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_19_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [19,19,19,19,19,19,19,19]
; BITALG-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ugt <8 x i32> %2, <i32 19, i32 19, i32 19, i32 19, i32 19, i32 19, i32 19, i32 19>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ult_20_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ult_20_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vcmpltps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_20_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [20,20,20,20,20,20,20,20]
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_20_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [20,20,20,20,20,20,20,20]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_20_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [20,20,20,20,20,20,20,20]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_20_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [20,20,20,20,20,20,20,20]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_20_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [20,20,20,20,20,20,20,20]
; BITALG-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ult <8 x i32> %2, <i32 20, i32 20, i32 20, i32 20, i32 20, i32 20, i32 20, i32 20>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ugt_20_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ugt_20_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} ymm1 = [2.0E+1,2.0E+1,2.0E+1,2.0E+1,2.0E+1,2.0E+1,2.0E+1,2.0E+1]
; AVX1-NEXT:    vcmpltps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_20_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [20,20,20,20,20,20,20,20]
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_20_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [20,20,20,20,20,20,20,20]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_20_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [20,20,20,20,20,20,20,20]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_20_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [20,20,20,20,20,20,20,20]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_20_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [20,20,20,20,20,20,20,20]
; BITALG-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ugt <8 x i32> %2, <i32 20, i32 20, i32 20, i32 20, i32 20, i32 20, i32 20, i32 20>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ult_21_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ult_21_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vcmpltps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_21_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [21,21,21,21,21,21,21,21]
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_21_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [21,21,21,21,21,21,21,21]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_21_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [21,21,21,21,21,21,21,21]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_21_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [21,21,21,21,21,21,21,21]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_21_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [21,21,21,21,21,21,21,21]
; BITALG-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ult <8 x i32> %2, <i32 21, i32 21, i32 21, i32 21, i32 21, i32 21, i32 21, i32 21>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ugt_21_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ugt_21_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} ymm1 = [2.1E+1,2.1E+1,2.1E+1,2.1E+1,2.1E+1,2.1E+1,2.1E+1,2.1E+1]
; AVX1-NEXT:    vcmpltps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_21_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [21,21,21,21,21,21,21,21]
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_21_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [21,21,21,21,21,21,21,21]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_21_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [21,21,21,21,21,21,21,21]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_21_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [21,21,21,21,21,21,21,21]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_21_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [21,21,21,21,21,21,21,21]
; BITALG-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ugt <8 x i32> %2, <i32 21, i32 21, i32 21, i32 21, i32 21, i32 21, i32 21, i32 21>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ult_22_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ult_22_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vcmpltps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_22_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [22,22,22,22,22,22,22,22]
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_22_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [22,22,22,22,22,22,22,22]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_22_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [22,22,22,22,22,22,22,22]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_22_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [22,22,22,22,22,22,22,22]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_22_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [22,22,22,22,22,22,22,22]
; BITALG-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ult <8 x i32> %2, <i32 22, i32 22, i32 22, i32 22, i32 22, i32 22, i32 22, i32 22>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ugt_22_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ugt_22_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} ymm1 = [2.2E+1,2.2E+1,2.2E+1,2.2E+1,2.2E+1,2.2E+1,2.2E+1,2.2E+1]
; AVX1-NEXT:    vcmpltps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_22_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [22,22,22,22,22,22,22,22]
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_22_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [22,22,22,22,22,22,22,22]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_22_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [22,22,22,22,22,22,22,22]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_22_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [22,22,22,22,22,22,22,22]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_22_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [22,22,22,22,22,22,22,22]
; BITALG-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ugt <8 x i32> %2, <i32 22, i32 22, i32 22, i32 22, i32 22, i32 22, i32 22, i32 22>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ult_23_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ult_23_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vcmpltps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_23_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [23,23,23,23,23,23,23,23]
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_23_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [23,23,23,23,23,23,23,23]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_23_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [23,23,23,23,23,23,23,23]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_23_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [23,23,23,23,23,23,23,23]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_23_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [23,23,23,23,23,23,23,23]
; BITALG-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ult <8 x i32> %2, <i32 23, i32 23, i32 23, i32 23, i32 23, i32 23, i32 23, i32 23>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ugt_23_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ugt_23_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} ymm1 = [2.3E+1,2.3E+1,2.3E+1,2.3E+1,2.3E+1,2.3E+1,2.3E+1,2.3E+1]
; AVX1-NEXT:    vcmpltps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_23_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [23,23,23,23,23,23,23,23]
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_23_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [23,23,23,23,23,23,23,23]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_23_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [23,23,23,23,23,23,23,23]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_23_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [23,23,23,23,23,23,23,23]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_23_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [23,23,23,23,23,23,23,23]
; BITALG-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ugt <8 x i32> %2, <i32 23, i32 23, i32 23, i32 23, i32 23, i32 23, i32 23, i32 23>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ult_24_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ult_24_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vcmpltps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_24_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [24,24,24,24,24,24,24,24]
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_24_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [24,24,24,24,24,24,24,24]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_24_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [24,24,24,24,24,24,24,24]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_24_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [24,24,24,24,24,24,24,24]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_24_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [24,24,24,24,24,24,24,24]
; BITALG-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ult <8 x i32> %2, <i32 24, i32 24, i32 24, i32 24, i32 24, i32 24, i32 24, i32 24>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ugt_24_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ugt_24_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} ymm1 = [2.4E+1,2.4E+1,2.4E+1,2.4E+1,2.4E+1,2.4E+1,2.4E+1,2.4E+1]
; AVX1-NEXT:    vcmpltps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_24_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [24,24,24,24,24,24,24,24]
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_24_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [24,24,24,24,24,24,24,24]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_24_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [24,24,24,24,24,24,24,24]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_24_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [24,24,24,24,24,24,24,24]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_24_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [24,24,24,24,24,24,24,24]
; BITALG-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ugt <8 x i32> %2, <i32 24, i32 24, i32 24, i32 24, i32 24, i32 24, i32 24, i32 24>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ult_25_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ult_25_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vcmpltps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_25_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [25,25,25,25,25,25,25,25]
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_25_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [25,25,25,25,25,25,25,25]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_25_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [25,25,25,25,25,25,25,25]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_25_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [25,25,25,25,25,25,25,25]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_25_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [25,25,25,25,25,25,25,25]
; BITALG-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ult <8 x i32> %2, <i32 25, i32 25, i32 25, i32 25, i32 25, i32 25, i32 25, i32 25>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ugt_25_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ugt_25_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} ymm1 = [2.5E+1,2.5E+1,2.5E+1,2.5E+1,2.5E+1,2.5E+1,2.5E+1,2.5E+1]
; AVX1-NEXT:    vcmpltps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_25_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [25,25,25,25,25,25,25,25]
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_25_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [25,25,25,25,25,25,25,25]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_25_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [25,25,25,25,25,25,25,25]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_25_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [25,25,25,25,25,25,25,25]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_25_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [25,25,25,25,25,25,25,25]
; BITALG-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ugt <8 x i32> %2, <i32 25, i32 25, i32 25, i32 25, i32 25, i32 25, i32 25, i32 25>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ult_26_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ult_26_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vcmpltps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_26_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [26,26,26,26,26,26,26,26]
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_26_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [26,26,26,26,26,26,26,26]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_26_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [26,26,26,26,26,26,26,26]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_26_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [26,26,26,26,26,26,26,26]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_26_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [26,26,26,26,26,26,26,26]
; BITALG-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ult <8 x i32> %2, <i32 26, i32 26, i32 26, i32 26, i32 26, i32 26, i32 26, i32 26>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ugt_26_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ugt_26_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} ymm1 = [2.6E+1,2.6E+1,2.6E+1,2.6E+1,2.6E+1,2.6E+1,2.6E+1,2.6E+1]
; AVX1-NEXT:    vcmpltps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_26_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [26,26,26,26,26,26,26,26]
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_26_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [26,26,26,26,26,26,26,26]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_26_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [26,26,26,26,26,26,26,26]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_26_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [26,26,26,26,26,26,26,26]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_26_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [26,26,26,26,26,26,26,26]
; BITALG-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ugt <8 x i32> %2, <i32 26, i32 26, i32 26, i32 26, i32 26, i32 26, i32 26, i32 26>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ult_27_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ult_27_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vcmpltps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_27_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [27,27,27,27,27,27,27,27]
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_27_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [27,27,27,27,27,27,27,27]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_27_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [27,27,27,27,27,27,27,27]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_27_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [27,27,27,27,27,27,27,27]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_27_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [27,27,27,27,27,27,27,27]
; BITALG-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ult <8 x i32> %2, <i32 27, i32 27, i32 27, i32 27, i32 27, i32 27, i32 27, i32 27>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ugt_27_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ugt_27_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} ymm1 = [2.7E+1,2.7E+1,2.7E+1,2.7E+1,2.7E+1,2.7E+1,2.7E+1,2.7E+1]
; AVX1-NEXT:    vcmpltps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_27_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [27,27,27,27,27,27,27,27]
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_27_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [27,27,27,27,27,27,27,27]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_27_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [27,27,27,27,27,27,27,27]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_27_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [27,27,27,27,27,27,27,27]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_27_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [27,27,27,27,27,27,27,27]
; BITALG-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ugt <8 x i32> %2, <i32 27, i32 27, i32 27, i32 27, i32 27, i32 27, i32 27, i32 27>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ult_28_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ult_28_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vcmpltps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_28_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [28,28,28,28,28,28,28,28]
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_28_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [28,28,28,28,28,28,28,28]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_28_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [28,28,28,28,28,28,28,28]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_28_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [28,28,28,28,28,28,28,28]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_28_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [28,28,28,28,28,28,28,28]
; BITALG-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ult <8 x i32> %2, <i32 28, i32 28, i32 28, i32 28, i32 28, i32 28, i32 28, i32 28>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ugt_28_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ugt_28_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} ymm1 = [2.8E+1,2.8E+1,2.8E+1,2.8E+1,2.8E+1,2.8E+1,2.8E+1,2.8E+1]
; AVX1-NEXT:    vcmpltps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_28_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [28,28,28,28,28,28,28,28]
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_28_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [28,28,28,28,28,28,28,28]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_28_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [28,28,28,28,28,28,28,28]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_28_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [28,28,28,28,28,28,28,28]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_28_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [28,28,28,28,28,28,28,28]
; BITALG-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ugt <8 x i32> %2, <i32 28, i32 28, i32 28, i32 28, i32 28, i32 28, i32 28, i32 28>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ult_29_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ult_29_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vcmpltps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_29_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [29,29,29,29,29,29,29,29]
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_29_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [29,29,29,29,29,29,29,29]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_29_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [29,29,29,29,29,29,29,29]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_29_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [29,29,29,29,29,29,29,29]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_29_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [29,29,29,29,29,29,29,29]
; BITALG-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ult <8 x i32> %2, <i32 29, i32 29, i32 29, i32 29, i32 29, i32 29, i32 29, i32 29>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ugt_29_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ugt_29_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} ymm1 = [2.9E+1,2.9E+1,2.9E+1,2.9E+1,2.9E+1,2.9E+1,2.9E+1,2.9E+1]
; AVX1-NEXT:    vcmpltps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_29_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [29,29,29,29,29,29,29,29]
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_29_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [29,29,29,29,29,29,29,29]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_29_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [29,29,29,29,29,29,29,29]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_29_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [29,29,29,29,29,29,29,29]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_29_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [29,29,29,29,29,29,29,29]
; BITALG-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ugt <8 x i32> %2, <i32 29, i32 29, i32 29, i32 29, i32 29, i32 29, i32 29, i32 29>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ult_30_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ult_30_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vcmpltps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_30_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [30,30,30,30,30,30,30,30]
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_30_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [30,30,30,30,30,30,30,30]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_30_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [30,30,30,30,30,30,30,30]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_30_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [30,30,30,30,30,30,30,30]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_30_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [30,30,30,30,30,30,30,30]
; BITALG-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ult <8 x i32> %2, <i32 30, i32 30, i32 30, i32 30, i32 30, i32 30, i32 30, i32 30>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ugt_30_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ugt_30_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} ymm1 = [3.0E+1,3.0E+1,3.0E+1,3.0E+1,3.0E+1,3.0E+1,3.0E+1,3.0E+1]
; AVX1-NEXT:    vcmpltps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_30_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [30,30,30,30,30,30,30,30]
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_30_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [30,30,30,30,30,30,30,30]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_30_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [30,30,30,30,30,30,30,30]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_30_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [30,30,30,30,30,30,30,30]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_30_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [30,30,30,30,30,30,30,30]
; BITALG-NEXT:    vpcmpgtd %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ugt <8 x i32> %2, <i32 30, i32 30, i32 30, i32 30, i32 30, i32 30, i32 30, i32 30>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <8 x i32> @ult_31_v8i32(<8 x i32> %0) {
; AVX1-LABEL: ult_31_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsadbw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vcmpltps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_31_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [31,31,31,31,31,31,31,31]
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_31_v8i32:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntd %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [31,31,31,31,31,31,31,31]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_31_v8i32:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [31,31,31,31,31,31,31,31]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_31_v8i32:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG_NOVLX-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [31,31,31,31,31,31,31,31]
; BITALG_NOVLX-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_31_v8i32:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; BITALG-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [31,31,31,31,31,31,31,31]
; BITALG-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %0)
  %3 = icmp ult <8 x i32> %2, <i32 31, i32 31, i32 31, i32 31, i32 31, i32 31, i32 31, i32 31>
  %4 = sext <8 x i1> %3 to <8 x i32>
  ret <8 x i32> %4
}

define <4 x i64> @ugt_1_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_1_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpaddq %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqq %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpaddq %xmm2, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpeqq %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpxor %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_1_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpaddq %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_1_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [1,1,1,1]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_1_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [1,1,1,1]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_1_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; BITALG_NOVLX-NEXT:    vpaddq %ymm1, %ymm0, %ymm1
; BITALG_NOVLX-NEXT:    vpand %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpcmpeqq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpternlogq {{.*#+}} zmm0 = ~zmm0
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_1_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; BITALG-NEXT:    vpaddq %ymm1, %ymm0, %ymm1
; BITALG-NEXT:    vpand %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpcmpeqq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpternlogq {{.*#+}} ymm0 = ~ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 1, i64 1, i64 1, i64 1>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_2_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_2_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpaddq %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqq %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpaddq %xmm2, %xmm0, %xmm2
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpeqq %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_2_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpaddq %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpeqq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_2_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [2,2,2,2]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_2_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [2,2,2,2]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_2_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; BITALG_NOVLX-NEXT:    vpaddq %ymm1, %ymm0, %ymm1
; BITALG_NOVLX-NEXT:    vpand %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpcmpeqq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_2_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; BITALG-NEXT:    vpaddq %ymm1, %ymm0, %ymm1
; BITALG-NEXT:    vpand %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpcmpeqq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 2, i64 2, i64 2, i64 2>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_2_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_2_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [2,2]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_2_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [2,2,2,2]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_2_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [2,2,2,2]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_2_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [2,2,2,2]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_2_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [2,2,2,2]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_2_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [2,2,2,2]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 2, i64 2, i64 2, i64 2>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_3_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_3_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [3,3]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_3_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [3,3,3,3]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_3_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [3,3,3,3]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_3_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [3,3,3,3]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_3_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [3,3,3,3]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_3_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [3,3,3,3]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 3, i64 3, i64 3, i64 3>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_3_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_3_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [3,3]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_3_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [3,3,3,3]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_3_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [3,3,3,3]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_3_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [3,3,3,3]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_3_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [3,3,3,3]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_3_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [3,3,3,3]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 3, i64 3, i64 3, i64 3>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_4_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_4_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [4,4]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_4_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [4,4,4,4]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_4_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [4,4,4,4]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_4_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [4,4,4,4]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_4_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [4,4,4,4]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_4_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [4,4,4,4]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 4, i64 4, i64 4, i64 4>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_4_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_4_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [4,4]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_4_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [4,4,4,4]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_4_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [4,4,4,4]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_4_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [4,4,4,4]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_4_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [4,4,4,4]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_4_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [4,4,4,4]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 4, i64 4, i64 4, i64 4>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_5_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_5_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [5,5]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_5_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [5,5,5,5]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_5_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [5,5,5,5]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_5_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [5,5,5,5]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_5_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [5,5,5,5]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_5_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [5,5,5,5]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 5, i64 5, i64 5, i64 5>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_5_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_5_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [5,5]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_5_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [5,5,5,5]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_5_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [5,5,5,5]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_5_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [5,5,5,5]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_5_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [5,5,5,5]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_5_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [5,5,5,5]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 5, i64 5, i64 5, i64 5>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_6_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_6_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [6,6]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_6_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [6,6,6,6]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_6_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [6,6,6,6]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_6_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [6,6,6,6]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_6_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [6,6,6,6]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_6_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [6,6,6,6]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 6, i64 6, i64 6, i64 6>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_6_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_6_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [6,6]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_6_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [6,6,6,6]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_6_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [6,6,6,6]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_6_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [6,6,6,6]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_6_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [6,6,6,6]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_6_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [6,6,6,6]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 6, i64 6, i64 6, i64 6>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_7_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_7_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [7,7]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_7_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [7,7,7,7]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_7_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [7,7,7,7]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_7_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [7,7,7,7]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_7_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [7,7,7,7]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_7_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [7,7,7,7]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 7, i64 7, i64 7, i64 7>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_7_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_7_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [7,7]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_7_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [7,7,7,7]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_7_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [7,7,7,7]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_7_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [7,7,7,7]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_7_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [7,7,7,7]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_7_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [7,7,7,7]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 7, i64 7, i64 7, i64 7>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_8_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_8_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [8,8]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_8_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [8,8,8,8]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_8_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [8,8,8,8]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_8_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [8,8,8,8]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_8_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [8,8,8,8]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_8_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [8,8,8,8]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 8, i64 8, i64 8, i64 8>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_8_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_8_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [8,8]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_8_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [8,8,8,8]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_8_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [8,8,8,8]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_8_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [8,8,8,8]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_8_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [8,8,8,8]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_8_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [8,8,8,8]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 8, i64 8, i64 8, i64 8>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_9_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_9_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [9,9]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_9_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [9,9,9,9]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_9_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [9,9,9,9]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_9_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [9,9,9,9]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_9_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [9,9,9,9]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_9_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [9,9,9,9]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 9, i64 9, i64 9, i64 9>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_9_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_9_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [9,9]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_9_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [9,9,9,9]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_9_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [9,9,9,9]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_9_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [9,9,9,9]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_9_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [9,9,9,9]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_9_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [9,9,9,9]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 9, i64 9, i64 9, i64 9>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_10_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_10_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [10,10]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_10_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [10,10,10,10]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_10_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [10,10,10,10]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_10_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [10,10,10,10]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_10_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [10,10,10,10]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_10_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [10,10,10,10]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 10, i64 10, i64 10, i64 10>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_10_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_10_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [10,10]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_10_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [10,10,10,10]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_10_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [10,10,10,10]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_10_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [10,10,10,10]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_10_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [10,10,10,10]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_10_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [10,10,10,10]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 10, i64 10, i64 10, i64 10>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_11_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_11_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [11,11]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_11_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [11,11,11,11]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_11_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [11,11,11,11]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_11_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [11,11,11,11]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_11_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [11,11,11,11]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_11_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [11,11,11,11]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 11, i64 11, i64 11, i64 11>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_11_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_11_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [11,11]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_11_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [11,11,11,11]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_11_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [11,11,11,11]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_11_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [11,11,11,11]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_11_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [11,11,11,11]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_11_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [11,11,11,11]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 11, i64 11, i64 11, i64 11>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_12_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_12_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [12,12]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_12_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [12,12,12,12]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_12_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [12,12,12,12]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_12_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [12,12,12,12]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_12_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [12,12,12,12]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_12_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [12,12,12,12]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 12, i64 12, i64 12, i64 12>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_12_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_12_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [12,12]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_12_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [12,12,12,12]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_12_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [12,12,12,12]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_12_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [12,12,12,12]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_12_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [12,12,12,12]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_12_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [12,12,12,12]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 12, i64 12, i64 12, i64 12>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_13_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_13_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [13,13]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_13_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [13,13,13,13]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_13_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [13,13,13,13]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_13_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [13,13,13,13]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_13_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [13,13,13,13]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_13_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [13,13,13,13]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 13, i64 13, i64 13, i64 13>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_13_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_13_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [13,13]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_13_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [13,13,13,13]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_13_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [13,13,13,13]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_13_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [13,13,13,13]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_13_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [13,13,13,13]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_13_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [13,13,13,13]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 13, i64 13, i64 13, i64 13>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_14_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_14_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [14,14]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_14_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [14,14,14,14]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_14_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [14,14,14,14]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_14_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [14,14,14,14]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_14_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [14,14,14,14]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_14_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [14,14,14,14]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 14, i64 14, i64 14, i64 14>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_14_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_14_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [14,14]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_14_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [14,14,14,14]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_14_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [14,14,14,14]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_14_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [14,14,14,14]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_14_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [14,14,14,14]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_14_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [14,14,14,14]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 14, i64 14, i64 14, i64 14>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_15_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_15_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [15,15]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_15_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [15,15,15,15]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_15_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [15,15,15,15]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_15_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [15,15,15,15]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_15_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [15,15,15,15]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_15_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [15,15,15,15]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 15, i64 15, i64 15, i64 15>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_15_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_15_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [15,15]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_15_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [15,15,15,15]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_15_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [15,15,15,15]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_15_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [15,15,15,15]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_15_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [15,15,15,15]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_15_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [15,15,15,15]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 15, i64 15, i64 15, i64 15>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_16_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_16_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [16,16]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_16_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [16,16,16,16]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_16_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [16,16,16,16]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_16_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [16,16,16,16]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_16_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [16,16,16,16]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_16_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [16,16,16,16]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 16, i64 16, i64 16, i64 16>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_16_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_16_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [16,16]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_16_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [16,16,16,16]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_16_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [16,16,16,16]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_16_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [16,16,16,16]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_16_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [16,16,16,16]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_16_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [16,16,16,16]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 16, i64 16, i64 16, i64 16>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_17_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_17_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [17,17]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_17_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [17,17,17,17]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_17_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [17,17,17,17]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_17_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [17,17,17,17]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_17_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [17,17,17,17]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_17_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [17,17,17,17]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 17, i64 17, i64 17, i64 17>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_17_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_17_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [17,17]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_17_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [17,17,17,17]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_17_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [17,17,17,17]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_17_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [17,17,17,17]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_17_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [17,17,17,17]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_17_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [17,17,17,17]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 17, i64 17, i64 17, i64 17>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_18_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_18_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [18,18]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_18_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [18,18,18,18]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_18_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [18,18,18,18]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_18_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [18,18,18,18]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_18_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [18,18,18,18]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_18_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [18,18,18,18]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 18, i64 18, i64 18, i64 18>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_18_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_18_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [18,18]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_18_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [18,18,18,18]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_18_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [18,18,18,18]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_18_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [18,18,18,18]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_18_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [18,18,18,18]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_18_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [18,18,18,18]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 18, i64 18, i64 18, i64 18>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_19_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_19_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [19,19]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_19_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [19,19,19,19]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_19_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [19,19,19,19]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_19_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [19,19,19,19]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_19_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [19,19,19,19]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_19_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [19,19,19,19]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 19, i64 19, i64 19, i64 19>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_19_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_19_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [19,19]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_19_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [19,19,19,19]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_19_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [19,19,19,19]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_19_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [19,19,19,19]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_19_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [19,19,19,19]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_19_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [19,19,19,19]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 19, i64 19, i64 19, i64 19>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_20_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_20_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [20,20]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_20_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [20,20,20,20]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_20_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [20,20,20,20]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_20_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [20,20,20,20]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_20_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [20,20,20,20]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_20_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [20,20,20,20]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 20, i64 20, i64 20, i64 20>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_20_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_20_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [20,20]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_20_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [20,20,20,20]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_20_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [20,20,20,20]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_20_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [20,20,20,20]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_20_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [20,20,20,20]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_20_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [20,20,20,20]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 20, i64 20, i64 20, i64 20>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_21_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_21_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [21,21]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_21_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [21,21,21,21]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_21_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [21,21,21,21]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_21_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [21,21,21,21]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_21_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [21,21,21,21]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_21_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [21,21,21,21]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 21, i64 21, i64 21, i64 21>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_21_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_21_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [21,21]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_21_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [21,21,21,21]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_21_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [21,21,21,21]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_21_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [21,21,21,21]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_21_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [21,21,21,21]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_21_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [21,21,21,21]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 21, i64 21, i64 21, i64 21>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_22_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_22_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [22,22]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_22_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [22,22,22,22]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_22_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [22,22,22,22]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_22_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [22,22,22,22]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_22_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [22,22,22,22]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_22_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [22,22,22,22]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 22, i64 22, i64 22, i64 22>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_22_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_22_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [22,22]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_22_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [22,22,22,22]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_22_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [22,22,22,22]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_22_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [22,22,22,22]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_22_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [22,22,22,22]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_22_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [22,22,22,22]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 22, i64 22, i64 22, i64 22>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_23_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_23_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [23,23]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_23_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [23,23,23,23]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_23_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [23,23,23,23]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_23_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [23,23,23,23]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_23_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [23,23,23,23]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_23_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [23,23,23,23]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 23, i64 23, i64 23, i64 23>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_23_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_23_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [23,23]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_23_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [23,23,23,23]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_23_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [23,23,23,23]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_23_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [23,23,23,23]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_23_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [23,23,23,23]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_23_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [23,23,23,23]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 23, i64 23, i64 23, i64 23>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_24_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_24_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [24,24]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_24_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [24,24,24,24]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_24_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [24,24,24,24]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_24_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [24,24,24,24]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_24_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [24,24,24,24]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_24_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [24,24,24,24]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 24, i64 24, i64 24, i64 24>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_24_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_24_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [24,24]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_24_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [24,24,24,24]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_24_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [24,24,24,24]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_24_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [24,24,24,24]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_24_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [24,24,24,24]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_24_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [24,24,24,24]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 24, i64 24, i64 24, i64 24>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_25_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_25_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [25,25]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_25_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [25,25,25,25]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_25_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [25,25,25,25]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_25_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [25,25,25,25]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_25_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [25,25,25,25]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_25_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [25,25,25,25]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 25, i64 25, i64 25, i64 25>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_25_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_25_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [25,25]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_25_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [25,25,25,25]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_25_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [25,25,25,25]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_25_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [25,25,25,25]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_25_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [25,25,25,25]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_25_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [25,25,25,25]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 25, i64 25, i64 25, i64 25>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_26_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_26_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [26,26]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_26_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [26,26,26,26]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_26_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [26,26,26,26]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_26_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [26,26,26,26]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_26_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [26,26,26,26]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_26_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [26,26,26,26]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 26, i64 26, i64 26, i64 26>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_26_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_26_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [26,26]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_26_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [26,26,26,26]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_26_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [26,26,26,26]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_26_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [26,26,26,26]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_26_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [26,26,26,26]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_26_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [26,26,26,26]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 26, i64 26, i64 26, i64 26>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_27_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_27_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [27,27]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_27_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [27,27,27,27]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_27_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [27,27,27,27]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_27_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [27,27,27,27]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_27_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [27,27,27,27]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_27_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [27,27,27,27]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 27, i64 27, i64 27, i64 27>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_27_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_27_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [27,27]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_27_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [27,27,27,27]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_27_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [27,27,27,27]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_27_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [27,27,27,27]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_27_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [27,27,27,27]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_27_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [27,27,27,27]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 27, i64 27, i64 27, i64 27>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_28_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_28_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [28,28]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_28_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [28,28,28,28]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_28_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [28,28,28,28]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_28_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [28,28,28,28]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_28_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [28,28,28,28]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_28_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [28,28,28,28]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 28, i64 28, i64 28, i64 28>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_28_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_28_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [28,28]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_28_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [28,28,28,28]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_28_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [28,28,28,28]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_28_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [28,28,28,28]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_28_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [28,28,28,28]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_28_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [28,28,28,28]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 28, i64 28, i64 28, i64 28>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_29_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_29_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [29,29]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_29_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [29,29,29,29]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_29_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [29,29,29,29]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_29_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [29,29,29,29]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_29_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [29,29,29,29]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_29_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [29,29,29,29]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 29, i64 29, i64 29, i64 29>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_29_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_29_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [29,29]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_29_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [29,29,29,29]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_29_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [29,29,29,29]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_29_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [29,29,29,29]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_29_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [29,29,29,29]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_29_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [29,29,29,29]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 29, i64 29, i64 29, i64 29>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_30_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_30_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [30,30]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_30_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [30,30,30,30]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_30_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [30,30,30,30]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_30_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [30,30,30,30]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_30_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [30,30,30,30]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_30_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [30,30,30,30]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 30, i64 30, i64 30, i64 30>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_30_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_30_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [30,30]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_30_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [30,30,30,30]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_30_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [30,30,30,30]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_30_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [30,30,30,30]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_30_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [30,30,30,30]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_30_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [30,30,30,30]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 30, i64 30, i64 30, i64 30>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_31_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_31_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [31,31]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_31_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [31,31,31,31]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_31_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [31,31,31,31]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_31_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [31,31,31,31]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_31_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [31,31,31,31]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_31_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [31,31,31,31]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 31, i64 31, i64 31, i64 31>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_31_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_31_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [31,31]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_31_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [31,31,31,31]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_31_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [31,31,31,31]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_31_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [31,31,31,31]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_31_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [31,31,31,31]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_31_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [31,31,31,31]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 31, i64 31, i64 31, i64 31>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_32_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_32_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [32,32]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_32_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [32,32,32,32]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_32_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [32,32,32,32]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_32_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [32,32,32,32]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_32_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [32,32,32,32]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_32_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [32,32,32,32]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 32, i64 32, i64 32, i64 32>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_32_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_32_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [32,32]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_32_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [32,32,32,32]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_32_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [32,32,32,32]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_32_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [32,32,32,32]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_32_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [32,32,32,32]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_32_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [32,32,32,32]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 32, i64 32, i64 32, i64 32>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_33_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_33_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [33,33]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_33_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [33,33,33,33]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_33_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [33,33,33,33]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_33_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [33,33,33,33]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_33_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [33,33,33,33]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_33_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [33,33,33,33]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 33, i64 33, i64 33, i64 33>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_33_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_33_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [33,33]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_33_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [33,33,33,33]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_33_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [33,33,33,33]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_33_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [33,33,33,33]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_33_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [33,33,33,33]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_33_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [33,33,33,33]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 33, i64 33, i64 33, i64 33>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_34_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_34_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [34,34]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_34_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [34,34,34,34]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_34_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [34,34,34,34]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_34_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [34,34,34,34]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_34_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [34,34,34,34]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_34_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [34,34,34,34]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 34, i64 34, i64 34, i64 34>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_34_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_34_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [34,34]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_34_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [34,34,34,34]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_34_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [34,34,34,34]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_34_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [34,34,34,34]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_34_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [34,34,34,34]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_34_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [34,34,34,34]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 34, i64 34, i64 34, i64 34>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_35_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_35_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [35,35]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_35_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [35,35,35,35]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_35_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [35,35,35,35]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_35_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [35,35,35,35]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_35_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [35,35,35,35]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_35_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [35,35,35,35]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 35, i64 35, i64 35, i64 35>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_35_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_35_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [35,35]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_35_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [35,35,35,35]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_35_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [35,35,35,35]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_35_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [35,35,35,35]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_35_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [35,35,35,35]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_35_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [35,35,35,35]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 35, i64 35, i64 35, i64 35>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_36_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_36_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [36,36]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_36_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [36,36,36,36]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_36_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [36,36,36,36]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_36_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [36,36,36,36]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_36_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [36,36,36,36]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_36_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [36,36,36,36]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 36, i64 36, i64 36, i64 36>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_36_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_36_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [36,36]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_36_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [36,36,36,36]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_36_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [36,36,36,36]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_36_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [36,36,36,36]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_36_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [36,36,36,36]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_36_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [36,36,36,36]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 36, i64 36, i64 36, i64 36>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_37_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_37_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [37,37]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_37_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [37,37,37,37]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_37_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [37,37,37,37]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_37_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [37,37,37,37]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_37_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [37,37,37,37]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_37_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [37,37,37,37]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 37, i64 37, i64 37, i64 37>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_37_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_37_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [37,37]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_37_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [37,37,37,37]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_37_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [37,37,37,37]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_37_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [37,37,37,37]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_37_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [37,37,37,37]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_37_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [37,37,37,37]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 37, i64 37, i64 37, i64 37>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_38_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_38_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [38,38]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_38_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [38,38,38,38]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_38_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [38,38,38,38]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_38_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [38,38,38,38]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_38_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [38,38,38,38]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_38_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [38,38,38,38]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 38, i64 38, i64 38, i64 38>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_38_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_38_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [38,38]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_38_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [38,38,38,38]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_38_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [38,38,38,38]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_38_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [38,38,38,38]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_38_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [38,38,38,38]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_38_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [38,38,38,38]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 38, i64 38, i64 38, i64 38>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_39_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_39_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [39,39]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_39_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [39,39,39,39]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_39_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [39,39,39,39]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_39_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [39,39,39,39]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_39_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [39,39,39,39]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_39_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [39,39,39,39]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 39, i64 39, i64 39, i64 39>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_39_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_39_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [39,39]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_39_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [39,39,39,39]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_39_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [39,39,39,39]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_39_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [39,39,39,39]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_39_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [39,39,39,39]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_39_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [39,39,39,39]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 39, i64 39, i64 39, i64 39>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_40_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_40_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [40,40]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_40_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [40,40,40,40]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_40_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [40,40,40,40]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_40_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [40,40,40,40]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_40_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [40,40,40,40]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_40_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [40,40,40,40]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 40, i64 40, i64 40, i64 40>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_40_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_40_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [40,40]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_40_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [40,40,40,40]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_40_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [40,40,40,40]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_40_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [40,40,40,40]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_40_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [40,40,40,40]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_40_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [40,40,40,40]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 40, i64 40, i64 40, i64 40>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_41_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_41_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [41,41]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_41_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [41,41,41,41]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_41_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [41,41,41,41]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_41_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [41,41,41,41]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_41_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [41,41,41,41]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_41_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [41,41,41,41]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 41, i64 41, i64 41, i64 41>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_41_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_41_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [41,41]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_41_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [41,41,41,41]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_41_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [41,41,41,41]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_41_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [41,41,41,41]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_41_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [41,41,41,41]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_41_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [41,41,41,41]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 41, i64 41, i64 41, i64 41>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_42_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_42_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [42,42]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_42_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [42,42,42,42]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_42_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [42,42,42,42]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_42_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [42,42,42,42]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_42_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [42,42,42,42]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_42_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [42,42,42,42]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 42, i64 42, i64 42, i64 42>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_42_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_42_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [42,42]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_42_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [42,42,42,42]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_42_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [42,42,42,42]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_42_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [42,42,42,42]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_42_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [42,42,42,42]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_42_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [42,42,42,42]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 42, i64 42, i64 42, i64 42>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_43_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_43_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [43,43]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_43_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [43,43,43,43]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_43_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [43,43,43,43]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_43_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [43,43,43,43]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_43_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [43,43,43,43]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_43_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [43,43,43,43]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 43, i64 43, i64 43, i64 43>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_43_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_43_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [43,43]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_43_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [43,43,43,43]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_43_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [43,43,43,43]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_43_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [43,43,43,43]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_43_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [43,43,43,43]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_43_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [43,43,43,43]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 43, i64 43, i64 43, i64 43>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_44_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_44_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [44,44]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_44_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [44,44,44,44]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_44_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [44,44,44,44]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_44_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [44,44,44,44]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_44_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [44,44,44,44]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_44_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [44,44,44,44]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 44, i64 44, i64 44, i64 44>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_44_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_44_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [44,44]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_44_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [44,44,44,44]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_44_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [44,44,44,44]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_44_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [44,44,44,44]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_44_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [44,44,44,44]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_44_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [44,44,44,44]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 44, i64 44, i64 44, i64 44>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_45_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_45_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [45,45]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_45_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [45,45,45,45]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_45_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [45,45,45,45]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_45_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [45,45,45,45]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_45_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [45,45,45,45]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_45_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [45,45,45,45]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 45, i64 45, i64 45, i64 45>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_45_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_45_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [45,45]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_45_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [45,45,45,45]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_45_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [45,45,45,45]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_45_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [45,45,45,45]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_45_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [45,45,45,45]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_45_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [45,45,45,45]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 45, i64 45, i64 45, i64 45>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_46_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_46_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [46,46]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_46_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [46,46,46,46]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_46_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [46,46,46,46]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_46_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [46,46,46,46]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_46_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [46,46,46,46]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_46_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [46,46,46,46]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 46, i64 46, i64 46, i64 46>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_46_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_46_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [46,46]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_46_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [46,46,46,46]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_46_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [46,46,46,46]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_46_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [46,46,46,46]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_46_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [46,46,46,46]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_46_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [46,46,46,46]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 46, i64 46, i64 46, i64 46>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_47_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_47_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [47,47]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_47_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [47,47,47,47]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_47_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [47,47,47,47]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_47_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [47,47,47,47]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_47_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [47,47,47,47]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_47_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [47,47,47,47]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 47, i64 47, i64 47, i64 47>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_47_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_47_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [47,47]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_47_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [47,47,47,47]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_47_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [47,47,47,47]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_47_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [47,47,47,47]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_47_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [47,47,47,47]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_47_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [47,47,47,47]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 47, i64 47, i64 47, i64 47>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_48_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_48_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [48,48]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_48_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [48,48,48,48]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_48_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [48,48,48,48]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_48_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [48,48,48,48]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_48_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [48,48,48,48]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_48_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [48,48,48,48]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 48, i64 48, i64 48, i64 48>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_48_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_48_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [48,48]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_48_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [48,48,48,48]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_48_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [48,48,48,48]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_48_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [48,48,48,48]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_48_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [48,48,48,48]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_48_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [48,48,48,48]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 48, i64 48, i64 48, i64 48>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_49_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_49_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [49,49]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_49_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [49,49,49,49]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_49_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [49,49,49,49]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_49_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [49,49,49,49]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_49_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [49,49,49,49]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_49_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [49,49,49,49]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 49, i64 49, i64 49, i64 49>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_49_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_49_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [49,49]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_49_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [49,49,49,49]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_49_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [49,49,49,49]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_49_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [49,49,49,49]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_49_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [49,49,49,49]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_49_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [49,49,49,49]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 49, i64 49, i64 49, i64 49>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_50_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_50_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [50,50]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_50_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [50,50,50,50]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_50_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [50,50,50,50]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_50_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [50,50,50,50]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_50_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [50,50,50,50]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_50_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [50,50,50,50]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 50, i64 50, i64 50, i64 50>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_50_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_50_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [50,50]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_50_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [50,50,50,50]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_50_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [50,50,50,50]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_50_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [50,50,50,50]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_50_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [50,50,50,50]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_50_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [50,50,50,50]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 50, i64 50, i64 50, i64 50>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_51_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_51_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [51,51]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_51_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [51,51,51,51]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_51_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [51,51,51,51]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_51_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [51,51,51,51]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_51_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [51,51,51,51]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_51_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [51,51,51,51]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 51, i64 51, i64 51, i64 51>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_51_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_51_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [51,51]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_51_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [51,51,51,51]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_51_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [51,51,51,51]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_51_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [51,51,51,51]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_51_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [51,51,51,51]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_51_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [51,51,51,51]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 51, i64 51, i64 51, i64 51>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_52_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_52_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [52,52]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_52_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [52,52,52,52]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_52_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [52,52,52,52]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_52_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [52,52,52,52]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_52_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [52,52,52,52]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_52_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [52,52,52,52]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 52, i64 52, i64 52, i64 52>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_52_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_52_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [52,52]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_52_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [52,52,52,52]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_52_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [52,52,52,52]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_52_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [52,52,52,52]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_52_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [52,52,52,52]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_52_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [52,52,52,52]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 52, i64 52, i64 52, i64 52>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_53_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_53_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [53,53]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_53_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [53,53,53,53]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_53_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [53,53,53,53]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_53_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [53,53,53,53]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_53_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [53,53,53,53]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_53_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [53,53,53,53]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 53, i64 53, i64 53, i64 53>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_53_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_53_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [53,53]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_53_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [53,53,53,53]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_53_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [53,53,53,53]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_53_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [53,53,53,53]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_53_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [53,53,53,53]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_53_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [53,53,53,53]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 53, i64 53, i64 53, i64 53>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_54_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_54_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [54,54]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_54_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [54,54,54,54]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_54_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [54,54,54,54]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_54_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [54,54,54,54]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_54_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [54,54,54,54]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_54_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [54,54,54,54]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 54, i64 54, i64 54, i64 54>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_54_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_54_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [54,54]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_54_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [54,54,54,54]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_54_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [54,54,54,54]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_54_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [54,54,54,54]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_54_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [54,54,54,54]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_54_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [54,54,54,54]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 54, i64 54, i64 54, i64 54>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_55_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_55_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [55,55]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_55_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [55,55,55,55]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_55_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [55,55,55,55]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_55_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [55,55,55,55]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_55_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [55,55,55,55]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_55_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [55,55,55,55]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 55, i64 55, i64 55, i64 55>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_55_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_55_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [55,55]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_55_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [55,55,55,55]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_55_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [55,55,55,55]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_55_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [55,55,55,55]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_55_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [55,55,55,55]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_55_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [55,55,55,55]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 55, i64 55, i64 55, i64 55>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_56_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_56_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [56,56]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_56_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [56,56,56,56]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_56_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [56,56,56,56]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_56_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [56,56,56,56]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_56_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [56,56,56,56]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_56_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [56,56,56,56]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 56, i64 56, i64 56, i64 56>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_56_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_56_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [56,56]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_56_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [56,56,56,56]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_56_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [56,56,56,56]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_56_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [56,56,56,56]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_56_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [56,56,56,56]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_56_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [56,56,56,56]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 56, i64 56, i64 56, i64 56>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_57_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_57_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [57,57]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_57_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [57,57,57,57]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_57_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [57,57,57,57]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_57_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [57,57,57,57]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_57_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [57,57,57,57]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_57_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [57,57,57,57]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 57, i64 57, i64 57, i64 57>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_57_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_57_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [57,57]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_57_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [57,57,57,57]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_57_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [57,57,57,57]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_57_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [57,57,57,57]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_57_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [57,57,57,57]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_57_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [57,57,57,57]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 57, i64 57, i64 57, i64 57>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_58_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_58_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [58,58]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_58_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [58,58,58,58]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_58_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [58,58,58,58]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_58_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [58,58,58,58]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_58_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [58,58,58,58]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_58_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [58,58,58,58]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 58, i64 58, i64 58, i64 58>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_58_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_58_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [58,58]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_58_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [58,58,58,58]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_58_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [58,58,58,58]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_58_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [58,58,58,58]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_58_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [58,58,58,58]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_58_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [58,58,58,58]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 58, i64 58, i64 58, i64 58>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_59_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_59_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [59,59]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_59_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [59,59,59,59]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_59_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [59,59,59,59]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_59_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [59,59,59,59]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_59_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [59,59,59,59]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_59_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [59,59,59,59]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 59, i64 59, i64 59, i64 59>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_59_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_59_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [59,59]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_59_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [59,59,59,59]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_59_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [59,59,59,59]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_59_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [59,59,59,59]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_59_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [59,59,59,59]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_59_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [59,59,59,59]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 59, i64 59, i64 59, i64 59>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_60_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_60_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [60,60]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_60_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [60,60,60,60]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_60_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [60,60,60,60]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_60_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [60,60,60,60]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_60_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [60,60,60,60]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_60_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [60,60,60,60]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 60, i64 60, i64 60, i64 60>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_60_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_60_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [60,60]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_60_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [60,60,60,60]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_60_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [60,60,60,60]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_60_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [60,60,60,60]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_60_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [60,60,60,60]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_60_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [60,60,60,60]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 60, i64 60, i64 60, i64 60>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_61_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_61_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [61,61]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_61_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [61,61,61,61]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_61_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [61,61,61,61]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_61_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [61,61,61,61]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_61_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [61,61,61,61]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_61_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [61,61,61,61]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 61, i64 61, i64 61, i64 61>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_61_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_61_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [61,61]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_61_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [61,61,61,61]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_61_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [61,61,61,61]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_61_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [61,61,61,61]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_61_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [61,61,61,61]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_61_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [61,61,61,61]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 61, i64 61, i64 61, i64 61>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_62_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_62_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [62,62]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_62_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [62,62,62,62]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_62_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [62,62,62,62]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_62_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [62,62,62,62]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_62_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [62,62,62,62]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_62_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [62,62,62,62]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 62, i64 62, i64 62, i64 62>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ugt_62_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ugt_62_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [62,62]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ugt_62_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [62,62,62,62]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ugt_62_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [62,62,62,62]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ugt_62_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [62,62,62,62]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ugt_62_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [62,62,62,62]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ugt_62_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [62,62,62,62]
; BITALG-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ugt <4 x i64> %2, <i64 62, i64 62, i64 62, i64 62>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @ult_63_v4i64(<4 x i64> %0) {
; AVX1-LABEL: ult_63_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpsadbw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm1 = [63,63]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ult_63_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [63,63,63,63]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VPOPCNTDQ-LABEL: ult_63_v4i64:
; AVX512VPOPCNTDQ:       # %bb.0:
; AVX512VPOPCNTDQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512VPOPCNTDQ-NEXT:    vpopcntq %zmm0, %zmm0
; AVX512VPOPCNTDQ-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [63,63,63,63]
; AVX512VPOPCNTDQ-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQ-NEXT:    retq
;
; AVX512VPOPCNTDQVL-LABEL: ult_63_v4i64:
; AVX512VPOPCNTDQVL:       # %bb.0:
; AVX512VPOPCNTDQVL-NEXT:    vpopcntq %ymm0, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [63,63,63,63]
; AVX512VPOPCNTDQVL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; AVX512VPOPCNTDQVL-NEXT:    retq
;
; BITALG_NOVLX-LABEL: ult_63_v4i64:
; BITALG_NOVLX:       # %bb.0:
; BITALG_NOVLX-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; BITALG_NOVLX-NEXT:    vpopcntb %zmm0, %zmm0
; BITALG_NOVLX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG_NOVLX-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG_NOVLX-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [63,63,63,63]
; BITALG_NOVLX-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG_NOVLX-NEXT:    retq
;
; BITALG-LABEL: ult_63_v4i64:
; BITALG:       # %bb.0:
; BITALG-NEXT:    vpopcntb %ymm0, %ymm0
; BITALG-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; BITALG-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; BITALG-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [63,63,63,63]
; BITALG-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm0
; BITALG-NEXT:    retq
  %2 = tail call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %0)
  %3 = icmp ult <4 x i64> %2, <i64 63, i64 63, i64 63, i64 63>
  %4 = sext <4 x i1> %3 to <4 x i64>
  ret <4 x i64> %4
}

declare <32 x i8> @llvm.ctpop.v32i8(<32 x i8>)
declare <16 x i16> @llvm.ctpop.v16i16(<16 x i16>)
declare <8 x i32> @llvm.ctpop.v8i32(<8 x i32>)
declare <4 x i64> @llvm.ctpop.v4i64(<4 x i64>)
