; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn -mcpu=hawaii < %s | FileCheck --check-prefix=GFX7 %s
; RUN: llc -mtriple=amdgcn -mcpu=tonga < %s | FileCheck --check-prefix=GFX8 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 < %s | FileCheck --check-prefix=GFX9 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 < %s | FileCheck --check-prefix=GFX10 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -amdgpu-enable-delay-alu=0 < %s | FileCheck --check-prefixes=GFX11 %s

define amdgpu_ps void @buffer_store_bf16(ptr addrspace(8) inreg %rsrc, bfloat %data, i32 %offset) {
; GFX7-LABEL: buffer_store_bf16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    buffer_store_short v0, v1, s[0:3], 0 offen
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: buffer_store_bf16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    buffer_store_short v0, v1, s[0:3], 0 offen
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: buffer_store_bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    buffer_store_short v0, v1, s[0:3], 0 offen
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: buffer_store_bf16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    buffer_store_short v0, v1, s[0:3], 0 offen
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: buffer_store_bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    buffer_store_b16 v0, v1, s[0:3], 0 offen
; GFX11-NEXT:    s_endpgm
  call void @llvm.amdgcn.raw.ptr.buffer.store.bf16(bfloat %data, ptr addrspace(8) %rsrc, i32 %offset, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @buffer_store_v2bf16(ptr addrspace(8) inreg %rsrc, <2 x bfloat> %data, i32 %offset) {
; GFX7-LABEL: buffer_store_v2bf16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    v_alignbit_b32 v0, v1, v0, 16
; GFX7-NEXT:    buffer_store_dword v0, v2, s[0:3], 0 offen
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: buffer_store_v2bf16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: buffer_store_v2bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: buffer_store_v2bf16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: buffer_store_v2bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    buffer_store_b32 v0, v1, s[0:3], 0 offen
; GFX11-NEXT:    s_endpgm
  call void @llvm.amdgcn.raw.ptr.buffer.store.v2bf16(<2 x bfloat> %data, ptr addrspace(8) %rsrc, i32 %offset, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @buffer_store_v4bf16(ptr addrspace(8) inreg %rsrc, <4 x bfloat> %data, i32 %offset) #0 {
; GFX7-LABEL: buffer_store_v4bf16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    v_alignbit_b32 v2, v3, v2, 16
; GFX7-NEXT:    v_alignbit_b32 v1, v1, v0, 16
; GFX7-NEXT:    buffer_store_dwordx2 v[1:2], v4, s[0:3], 0 offen
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: buffer_store_v4bf16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    buffer_store_dwordx2 v[0:1], v2, s[0:3], 0 offen
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: buffer_store_v4bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], v2, s[0:3], 0 offen
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: buffer_store_v4bf16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    buffer_store_dwordx2 v[0:1], v2, s[0:3], 0 offen
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: buffer_store_v4bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    buffer_store_b64 v[0:1], v2, s[0:3], 0 offen
; GFX11-NEXT:    s_endpgm
  call void @llvm.amdgcn.raw.ptr.buffer.store.v4bf16(<4 x bfloat> %data, ptr addrspace(8) %rsrc, i32 %offset, i32 0, i32 0)
  ret void
}

; FIXME
; define amdgpu_ps void @buffer_store_v6bf16(ptr addrspace(8) inreg %rsrc, <6 x bfloat> %data, i32 %offset) #0 {
;   call void @llvm.amdgcn.raw.ptr.buffer.store.v6bf16(<6 x bfloat> %data, ptr addrspace(8) %rsrc, i32 %offset, i32 0, i32 0)
;   ret void
; }

define amdgpu_ps void @buffer_store_v8bf16(ptr addrspace(8) inreg %rsrc, <8 x bfloat> %data, i32 %offset) #0 {
; GFX7-LABEL: buffer_store_v8bf16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    v_mul_f32_e32 v7, 1.0, v7
; GFX7-NEXT:    v_mul_f32_e32 v5, 1.0, v5
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 16, v7
; GFX7-NEXT:    v_mul_f32_e32 v6, 1.0, v6
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX7-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    v_alignbit_b32 v6, v7, v6, 16
; GFX7-NEXT:    v_alignbit_b32 v5, v5, v4, 16
; GFX7-NEXT:    v_alignbit_b32 v4, v3, v2, 16
; GFX7-NEXT:    v_alignbit_b32 v3, v1, v0, 16
; GFX7-NEXT:    buffer_store_dwordx4 v[3:6], v8, s[0:3], 0 offen
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: buffer_store_v8bf16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    buffer_store_dwordx4 v[0:3], v4, s[0:3], 0 offen
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: buffer_store_v8bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    buffer_store_dwordx4 v[0:3], v4, s[0:3], 0 offen
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: buffer_store_v8bf16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    buffer_store_dwordx4 v[0:3], v4, s[0:3], 0 offen
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: buffer_store_v8bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    buffer_store_b128 v[0:3], v4, s[0:3], 0 offen
; GFX11-NEXT:    s_endpgm
  call void @llvm.amdgcn.raw.ptr.buffer.store.v8bf16(<8 x bfloat> %data, ptr addrspace(8) %rsrc, i32 %offset, i32 0, i32 0)
  ret void
}
