; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -global-isel=0 -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 < %s | FileCheck -check-prefix=GFX9-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 < %s | FileCheck -check-prefix=GFX9-GISEL %s
; RUN: llc -global-isel=0 -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1100 < %s | FileCheck -check-prefix=GFX11-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1100 < %s | FileCheck -check-prefix=GFX11-GISEL %s
target datalayout = "A5"

define amdgpu_kernel void @test_dynamic_stackalloc_kernel_uniform(i32 %n) {
; GFX9-SDAG-LABEL: test_dynamic_stackalloc_kernel_uniform:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dword s4, s[8:9], 0x0
; GFX9-SDAG-NEXT:    s_add_u32 s0, s0, s17
; GFX9-SDAG-NEXT:    s_addc_u32 s1, s1, 0
; GFX9-SDAG-NEXT:    s_movk_i32 s32, 0x400
; GFX9-SDAG-NEXT:    s_mov_b32 s5, s32
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_lshl_b32 s4, s4, 2
; GFX9-SDAG-NEXT:    s_add_i32 s4, s4, 15
; GFX9-SDAG-NEXT:    s_and_b32 s4, s4, -16
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, 0x7b
; GFX9-SDAG-NEXT:    s_lshl_b32 s4, s4, 6
; GFX9-SDAG-NEXT:    s_mov_b32 s33, 0
; GFX9-SDAG-NEXT:    s_add_i32 s32, s5, s4
; GFX9-SDAG-NEXT:    buffer_store_dword v0, off, s[0:3], s5
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: test_dynamic_stackalloc_kernel_uniform:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dword s5, s[8:9], 0x0
; GFX9-GISEL-NEXT:    s_add_u32 s0, s0, s17
; GFX9-GISEL-NEXT:    s_movk_i32 s32, 0x400
; GFX9-GISEL-NEXT:    s_addc_u32 s1, s1, 0
; GFX9-GISEL-NEXT:    s_mov_b32 s4, s32
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_lshl2_add_u32 s5, s5, 15
; GFX9-GISEL-NEXT:    s_and_b32 s5, s5, -16
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, 0x7b
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-GISEL-NEXT:    s_lshl_b32 s5, s5, 6
; GFX9-GISEL-NEXT:    s_mov_b32 s33, 0
; GFX9-GISEL-NEXT:    s_add_u32 s32, s4, s5
; GFX9-GISEL-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: test_dynamic_stackalloc_kernel_uniform:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v0, 0x7b
; GFX11-SDAG-NEXT:    s_mov_b32 s32, 16
; GFX11-SDAG-NEXT:    s_mov_b32 s33, 0
; GFX11-SDAG-NEXT:    s_mov_b32 s1, s32
; GFX11-SDAG-NEXT:    scratch_store_b32 off, v0, s1 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-NEXT:    s_add_i32 s0, s0, 15
; GFX11-SDAG-NEXT:    s_and_b32 s0, s0, -16
; GFX11-SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-NEXT:    s_lshl_b32 s0, s0, 5
; GFX11-SDAG-NEXT:    s_add_i32 s32, s1, s0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: test_dynamic_stackalloc_kernel_uniform:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b32 s1, s[4:5], 0x0
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v0, 0x7b
; GFX11-GISEL-NEXT:    s_mov_b32 s32, 16
; GFX11-GISEL-NEXT:    s_mov_b32 s33, 0
; GFX11-GISEL-NEXT:    s_mov_b32 s0, s32
; GFX11-GISEL-NEXT:    scratch_store_b32 off, v0, s0 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_lshl2_add_u32 s1, s1, 15
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    s_and_b32 s1, s1, -16
; GFX11-GISEL-NEXT:    s_lshl_b32 s1, s1, 5
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    s_add_u32 s32, s0, s1
; GFX11-GISEL-NEXT:    s_endpgm
  %alloca = alloca i32, i32 %n, addrspace(5)
  store volatile i32 123, ptr addrspace(5) %alloca
  ret void
}

define amdgpu_kernel void @test_dynamic_stackalloc_kernel_uniform_over_aligned(i32 %n) {
; GFX9-SDAG-LABEL: test_dynamic_stackalloc_kernel_uniform_over_aligned:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dword s4, s[8:9], 0x0
; GFX9-SDAG-NEXT:    s_add_u32 s0, s0, s17
; GFX9-SDAG-NEXT:    s_movk_i32 s32, 0x2000
; GFX9-SDAG-NEXT:    s_addc_u32 s1, s1, 0
; GFX9-SDAG-NEXT:    s_add_i32 s5, s32, 0x1fff
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_lshl_b32 s4, s4, 2
; GFX9-SDAG-NEXT:    s_add_i32 s4, s4, 15
; GFX9-SDAG-NEXT:    s_and_b32 s5, s5, 0xffffe000
; GFX9-SDAG-NEXT:    s_and_b32 s4, s4, -16
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, 10
; GFX9-SDAG-NEXT:    s_lshl_b32 s4, s4, 6
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-SDAG-NEXT:    s_mov_b32 s33, 0
; GFX9-SDAG-NEXT:    s_add_i32 s32, s5, s4
; GFX9-SDAG-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: test_dynamic_stackalloc_kernel_uniform_over_aligned:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dword s4, s[8:9], 0x0
; GFX9-GISEL-NEXT:    s_movk_i32 s32, 0x2000
; GFX9-GISEL-NEXT:    s_add_u32 s0, s0, s17
; GFX9-GISEL-NEXT:    s_addc_u32 s1, s1, 0
; GFX9-GISEL-NEXT:    s_add_u32 s5, s32, 0x1fff
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_lshl2_add_u32 s4, s4, 15
; GFX9-GISEL-NEXT:    s_and_b32 s5, s5, 0xffffe000
; GFX9-GISEL-NEXT:    s_and_b32 s4, s4, -16
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, 10
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-GISEL-NEXT:    s_lshl_b32 s4, s4, 6
; GFX9-GISEL-NEXT:    s_mov_b32 s33, 0
; GFX9-GISEL-NEXT:    s_add_u32 s32, s5, s4
; GFX9-GISEL-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: test_dynamic_stackalloc_kernel_uniform_over_aligned:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-SDAG-NEXT:    s_movk_i32 s32, 0x80
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v0, 10
; GFX11-SDAG-NEXT:    s_add_i32 s1, s32, 0xfff
; GFX11-SDAG-NEXT:    s_mov_b32 s33, 0
; GFX11-SDAG-NEXT:    s_and_b32 s1, s1, 0xfffff000
; GFX11-SDAG-NEXT:    scratch_store_b32 off, v0, s1 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-NEXT:    s_add_i32 s0, s0, 15
; GFX11-SDAG-NEXT:    s_and_b32 s0, s0, -16
; GFX11-SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-NEXT:    s_lshl_b32 s0, s0, 5
; GFX11-SDAG-NEXT:    s_add_i32 s32, s1, s0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: test_dynamic_stackalloc_kernel_uniform_over_aligned:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-GISEL-NEXT:    s_movk_i32 s32, 0x80
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v0, 10
; GFX11-GISEL-NEXT:    s_add_u32 s1, s32, 0xfff
; GFX11-GISEL-NEXT:    s_mov_b32 s33, 0
; GFX11-GISEL-NEXT:    s_and_b32 s1, s1, 0xfffff000
; GFX11-GISEL-NEXT:    scratch_store_b32 off, v0, s1 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_lshl2_add_u32 s0, s0, 15
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    s_and_b32 s0, s0, -16
; GFX11-GISEL-NEXT:    s_lshl_b32 s0, s0, 5
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    s_add_u32 s32, s1, s0
; GFX11-GISEL-NEXT:    s_endpgm
  %alloca = alloca i32, i32 %n, align 128, addrspace(5)
  store volatile i32 10, ptr addrspace(5) %alloca
  ret void
}

define amdgpu_kernel void @test_dynamic_stackalloc_kernel_uniform_under_aligned(i32 %n) {
; GFX9-SDAG-LABEL: test_dynamic_stackalloc_kernel_uniform_under_aligned:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dword s4, s[8:9], 0x0
; GFX9-SDAG-NEXT:    s_add_u32 s0, s0, s17
; GFX9-SDAG-NEXT:    s_addc_u32 s1, s1, 0
; GFX9-SDAG-NEXT:    s_movk_i32 s32, 0x400
; GFX9-SDAG-NEXT:    s_mov_b32 s5, s32
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_lshl_b32 s4, s4, 2
; GFX9-SDAG-NEXT:    s_add_i32 s4, s4, 15
; GFX9-SDAG-NEXT:    s_and_b32 s4, s4, -16
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, 22
; GFX9-SDAG-NEXT:    s_lshl_b32 s4, s4, 6
; GFX9-SDAG-NEXT:    s_mov_b32 s33, 0
; GFX9-SDAG-NEXT:    s_add_i32 s32, s5, s4
; GFX9-SDAG-NEXT:    buffer_store_dword v0, off, s[0:3], s5
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: test_dynamic_stackalloc_kernel_uniform_under_aligned:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dword s5, s[8:9], 0x0
; GFX9-GISEL-NEXT:    s_add_u32 s0, s0, s17
; GFX9-GISEL-NEXT:    s_movk_i32 s32, 0x400
; GFX9-GISEL-NEXT:    s_addc_u32 s1, s1, 0
; GFX9-GISEL-NEXT:    s_mov_b32 s4, s32
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_lshl2_add_u32 s5, s5, 15
; GFX9-GISEL-NEXT:    s_and_b32 s5, s5, -16
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, 22
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-GISEL-NEXT:    s_lshl_b32 s5, s5, 6
; GFX9-GISEL-NEXT:    s_mov_b32 s33, 0
; GFX9-GISEL-NEXT:    s_add_u32 s32, s4, s5
; GFX9-GISEL-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: test_dynamic_stackalloc_kernel_uniform_under_aligned:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v0, 22
; GFX11-SDAG-NEXT:    s_mov_b32 s32, 16
; GFX11-SDAG-NEXT:    s_mov_b32 s33, 0
; GFX11-SDAG-NEXT:    s_mov_b32 s1, s32
; GFX11-SDAG-NEXT:    scratch_store_b32 off, v0, s1 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-NEXT:    s_add_i32 s0, s0, 15
; GFX11-SDAG-NEXT:    s_and_b32 s0, s0, -16
; GFX11-SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-NEXT:    s_lshl_b32 s0, s0, 5
; GFX11-SDAG-NEXT:    s_add_i32 s32, s1, s0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: test_dynamic_stackalloc_kernel_uniform_under_aligned:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b32 s1, s[4:5], 0x0
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v0, 22
; GFX11-GISEL-NEXT:    s_mov_b32 s32, 16
; GFX11-GISEL-NEXT:    s_mov_b32 s33, 0
; GFX11-GISEL-NEXT:    s_mov_b32 s0, s32
; GFX11-GISEL-NEXT:    scratch_store_b32 off, v0, s0 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_lshl2_add_u32 s1, s1, 15
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    s_and_b32 s1, s1, -16
; GFX11-GISEL-NEXT:    s_lshl_b32 s1, s1, 5
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    s_add_u32 s32, s0, s1
; GFX11-GISEL-NEXT:    s_endpgm
  %alloca = alloca i32, i32 %n, align 2, addrspace(5)
  store volatile i32 22, ptr addrspace(5) %alloca
  ret void
}

define amdgpu_kernel void @test_dynamic_stackalloc_kernel_divergent() {
; GFX9-SDAG-LABEL: test_dynamic_stackalloc_kernel_divergent:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_add_u32 s0, s0, s17
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX9-SDAG-NEXT:    s_addc_u32 s1, s1, 0
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, 0x1ff0, v0
; GFX9-SDAG-NEXT:    s_mov_b64 s[4:5], exec
; GFX9-SDAG-NEXT:    s_mov_b32 s6, 0
; GFX9-SDAG-NEXT:    s_mov_b32 s33, 0
; GFX9-SDAG-NEXT:    s_movk_i32 s32, 0x400
; GFX9-SDAG-NEXT:  .LBB3_1: ; =>This Inner Loop Header: Depth=1
; GFX9-SDAG-NEXT:    s_ff1_i32_b64 s7, s[4:5]
; GFX9-SDAG-NEXT:    v_readlane_b32 s8, v0, s7
; GFX9-SDAG-NEXT:    s_bitset0_b64 s[4:5], s7
; GFX9-SDAG-NEXT:    s_max_u32 s6, s6, s8
; GFX9-SDAG-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX9-SDAG-NEXT:    s_cbranch_scc1 .LBB3_1
; GFX9-SDAG-NEXT:  ; %bb.2:
; GFX9-SDAG-NEXT:    s_mov_b32 s4, s32
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v0, s6, 6, v0
; GFX9-SDAG-NEXT:    v_readfirstlane_b32 s32, v0
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, 0x7b
; GFX9-SDAG-NEXT:    buffer_store_dword v0, off, s[0:3], s4
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: test_dynamic_stackalloc_kernel_divergent:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_add_u32 s0, s0, s17
; GFX9-GISEL-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX9-GISEL-NEXT:    s_addc_u32 s1, s1, 0
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX9-GISEL-NEXT:    s_mov_b64 s[4:5], exec
; GFX9-GISEL-NEXT:    s_mov_b32 s6, 0
; GFX9-GISEL-NEXT:    s_mov_b32 s33, 0
; GFX9-GISEL-NEXT:    s_movk_i32 s32, 0x400
; GFX9-GISEL-NEXT:  .LBB3_1: ; =>This Inner Loop Header: Depth=1
; GFX9-GISEL-NEXT:    s_ff1_i32_b64 s7, s[4:5]
; GFX9-GISEL-NEXT:    v_readlane_b32 s8, v0, s7
; GFX9-GISEL-NEXT:    s_bitset0_b64 s[4:5], s7
; GFX9-GISEL-NEXT:    s_max_u32 s6, s6, s8
; GFX9-GISEL-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX9-GISEL-NEXT:    s_cbranch_scc1 .LBB3_1
; GFX9-GISEL-NEXT:  ; %bb.2:
; GFX9-GISEL-NEXT:    s_mov_b32 s4, s32
; GFX9-GISEL-NEXT:    s_lshl_b32 s5, s6, 6
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, 0x7b
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-GISEL-NEXT:    s_add_u32 s32, s4, s5
; GFX9-GISEL-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: test_dynamic_stackalloc_kernel_divergent:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-SDAG-NEXT:    s_mov_b32 s1, exec_lo
; GFX11-SDAG-NEXT:    s_mov_b32 s0, 0
; GFX11-SDAG-NEXT:    s_mov_b32 s33, 0
; GFX11-SDAG-NEXT:    s_mov_b32 s32, 16
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, 0x1ff0, v0
; GFX11-SDAG-NEXT:  .LBB3_1: ; =>This Inner Loop Header: Depth=1
; GFX11-SDAG-NEXT:    s_ctz_i32_b32 s2, s1
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-NEXT:    v_readlane_b32 s3, v0, s2
; GFX11-SDAG-NEXT:    s_bitset0_b32 s1, s2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    s_max_u32 s0, s0, s3
; GFX11-SDAG-NEXT:    s_cmp_lg_u32 s1, 0
; GFX11-SDAG-NEXT:    s_cbranch_scc1 .LBB3_1
; GFX11-SDAG-NEXT:  ; %bb.2:
; GFX11-SDAG-NEXT:    s_mov_b32 s1, s32
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, 0x7b
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v0, s0, 5, s1
; GFX11-SDAG-NEXT:    scratch_store_b32 off, v1, s1 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s32, v0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: test_dynamic_stackalloc_kernel_divergent:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-GISEL-NEXT:    s_mov_b32 s1, exec_lo
; GFX11-GISEL-NEXT:    s_mov_b32 s0, 0
; GFX11-GISEL-NEXT:    s_mov_b32 s33, 0
; GFX11-GISEL-NEXT:    s_mov_b32 s32, 16
; GFX11-GISEL-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX11-GISEL-NEXT:  .LBB3_1: ; =>This Inner Loop Header: Depth=1
; GFX11-GISEL-NEXT:    s_ctz_i32_b32 s2, s1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_readlane_b32 s3, v0, s2
; GFX11-GISEL-NEXT:    s_bitset0_b32 s1, s2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    s_max_u32 s0, s0, s3
; GFX11-GISEL-NEXT:    s_cmp_lg_u32 s1, 0
; GFX11-GISEL-NEXT:    s_cbranch_scc1 .LBB3_1
; GFX11-GISEL-NEXT:  ; %bb.2:
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v0, 0x7b
; GFX11-GISEL-NEXT:    s_mov_b32 s1, s32
; GFX11-GISEL-NEXT:    s_lshl_b32 s0, s0, 5
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    s_add_u32 s32, s1, s0
; GFX11-GISEL-NEXT:    scratch_store_b32 off, v0, s1 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_endpgm
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %alloca = alloca float, i32 %idx, addrspace(5)
  store volatile i32 123, ptr addrspace(5) %alloca
  ret void
}

define amdgpu_kernel void @test_dynamic_stackalloc_kernel_divergent_over_aligned() {
; GFX9-SDAG-LABEL: test_dynamic_stackalloc_kernel_divergent_over_aligned:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_add_u32 s0, s0, s17
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX9-SDAG-NEXT:    s_addc_u32 s1, s1, 0
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, 0x1ff0, v0
; GFX9-SDAG-NEXT:    s_mov_b64 s[4:5], exec
; GFX9-SDAG-NEXT:    s_mov_b32 s6, 0
; GFX9-SDAG-NEXT:    s_mov_b32 s33, 0
; GFX9-SDAG-NEXT:    s_movk_i32 s32, 0x2000
; GFX9-SDAG-NEXT:  .LBB4_1: ; =>This Inner Loop Header: Depth=1
; GFX9-SDAG-NEXT:    s_ff1_i32_b64 s7, s[4:5]
; GFX9-SDAG-NEXT:    v_readlane_b32 s8, v0, s7
; GFX9-SDAG-NEXT:    s_bitset0_b64 s[4:5], s7
; GFX9-SDAG-NEXT:    s_max_u32 s6, s6, s8
; GFX9-SDAG-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX9-SDAG-NEXT:    s_cbranch_scc1 .LBB4_1
; GFX9-SDAG-NEXT:  ; %bb.2:
; GFX9-SDAG-NEXT:    s_add_i32 s4, s32, 0x1fff
; GFX9-SDAG-NEXT:    s_and_b32 s4, s4, 0xffffe000
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v1, s6, 6, v0
; GFX9-SDAG-NEXT:    v_readfirstlane_b32 s32, v1
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v1, 0x1bc
; GFX9-SDAG-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: test_dynamic_stackalloc_kernel_divergent_over_aligned:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_add_u32 s0, s0, s17
; GFX9-GISEL-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX9-GISEL-NEXT:    s_addc_u32 s1, s1, 0
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX9-GISEL-NEXT:    s_mov_b64 s[4:5], exec
; GFX9-GISEL-NEXT:    s_mov_b32 s6, 0
; GFX9-GISEL-NEXT:    s_mov_b32 s33, 0
; GFX9-GISEL-NEXT:    s_movk_i32 s32, 0x2000
; GFX9-GISEL-NEXT:  .LBB4_1: ; =>This Inner Loop Header: Depth=1
; GFX9-GISEL-NEXT:    s_ff1_i32_b64 s7, s[4:5]
; GFX9-GISEL-NEXT:    v_readlane_b32 s8, v0, s7
; GFX9-GISEL-NEXT:    s_bitset0_b64 s[4:5], s7
; GFX9-GISEL-NEXT:    s_max_u32 s6, s6, s8
; GFX9-GISEL-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX9-GISEL-NEXT:    s_cbranch_scc1 .LBB4_1
; GFX9-GISEL-NEXT:  ; %bb.2:
; GFX9-GISEL-NEXT:    s_add_u32 s5, s32, 0x1fff
; GFX9-GISEL-NEXT:    s_and_b32 s5, s5, 0xffffe000
; GFX9-GISEL-NEXT:    s_lshl_b32 s4, s6, 6
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, 0x1bc
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-GISEL-NEXT:    s_add_u32 s32, s5, s4
; GFX9-GISEL-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: test_dynamic_stackalloc_kernel_divergent_over_aligned:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-SDAG-NEXT:    s_movk_i32 s32, 0x80
; GFX11-SDAG-NEXT:    s_mov_b32 s2, exec_lo
; GFX11-SDAG-NEXT:    s_add_i32 s0, s32, 0xfff
; GFX11-SDAG-NEXT:    s_mov_b32 s1, 0
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX11-SDAG-NEXT:    s_and_b32 s0, s0, 0xfffff000
; GFX11-SDAG-NEXT:    s_mov_b32 s33, 0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, 0x1ff0, v0
; GFX11-SDAG-NEXT:  .LBB4_1: ; =>This Inner Loop Header: Depth=1
; GFX11-SDAG-NEXT:    s_ctz_i32_b32 s3, s2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-NEXT:    v_readlane_b32 s4, v0, s3
; GFX11-SDAG-NEXT:    s_bitset0_b32 s2, s3
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    s_max_u32 s1, s1, s4
; GFX11-SDAG-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-SDAG-NEXT:    s_cbranch_scc1 .LBB4_1
; GFX11-SDAG-NEXT:  ; %bb.2:
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v0, s1, 5, s0
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, 0x1bc
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s32, v0
; GFX11-SDAG-NEXT:    scratch_store_b32 off, v1, s0 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: test_dynamic_stackalloc_kernel_divergent_over_aligned:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-GISEL-NEXT:    s_mov_b32 s1, exec_lo
; GFX11-GISEL-NEXT:    s_mov_b32 s0, 0
; GFX11-GISEL-NEXT:    s_mov_b32 s33, 0
; GFX11-GISEL-NEXT:    s_movk_i32 s32, 0x80
; GFX11-GISEL-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX11-GISEL-NEXT:  .LBB4_1: ; =>This Inner Loop Header: Depth=1
; GFX11-GISEL-NEXT:    s_ctz_i32_b32 s2, s1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_readlane_b32 s3, v0, s2
; GFX11-GISEL-NEXT:    s_bitset0_b32 s1, s2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    s_max_u32 s0, s0, s3
; GFX11-GISEL-NEXT:    s_cmp_lg_u32 s1, 0
; GFX11-GISEL-NEXT:    s_cbranch_scc1 .LBB4_1
; GFX11-GISEL-NEXT:  ; %bb.2:
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v0, 0x1bc
; GFX11-GISEL-NEXT:    s_add_u32 s1, s32, 0xfff
; GFX11-GISEL-NEXT:    s_lshl_b32 s0, s0, 5
; GFX11-GISEL-NEXT:    s_and_b32 s1, s1, 0xfffff000
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    s_add_u32 s32, s1, s0
; GFX11-GISEL-NEXT:    scratch_store_b32 off, v0, s1 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_endpgm
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %alloca = alloca i32, i32 %idx, align 128, addrspace(5)
  store volatile i32 444, ptr addrspace(5) %alloca
  ret void
}

define amdgpu_kernel void @test_dynamic_stackalloc_kernel_divergent_under_aligned() {
; GFX9-SDAG-LABEL: test_dynamic_stackalloc_kernel_divergent_under_aligned:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_add_u32 s0, s0, s17
; GFX9-SDAG-NEXT:    s_addc_u32 s1, s1, 0
; GFX9-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX9-SDAG-NEXT:    s_mov_b64 s[4:5], exec
; GFX9-SDAG-NEXT:    s_mov_b32 s6, 0
; GFX9-SDAG-NEXT:    s_mov_b32 s33, 0
; GFX9-SDAG-NEXT:    s_movk_i32 s32, 0x400
; GFX9-SDAG-NEXT:  .LBB5_1: ; =>This Inner Loop Header: Depth=1
; GFX9-SDAG-NEXT:    s_ff1_i32_b64 s7, s[4:5]
; GFX9-SDAG-NEXT:    v_readlane_b32 s8, v0, s7
; GFX9-SDAG-NEXT:    s_bitset0_b64 s[4:5], s7
; GFX9-SDAG-NEXT:    s_max_u32 s6, s6, s8
; GFX9-SDAG-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX9-SDAG-NEXT:    s_cbranch_scc1 .LBB5_1
; GFX9-SDAG-NEXT:  ; %bb.2:
; GFX9-SDAG-NEXT:    s_mov_b32 s4, s32
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v0, s6, 6, v0
; GFX9-SDAG-NEXT:    v_readfirstlane_b32 s32, v0
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, 0x29a
; GFX9-SDAG-NEXT:    buffer_store_dword v0, off, s[0:3], s4
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: test_dynamic_stackalloc_kernel_divergent_under_aligned:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_add_u32 s0, s0, s17
; GFX9-GISEL-NEXT:    v_lshl_add_u32 v0, v0, 4, 15
; GFX9-GISEL-NEXT:    s_addc_u32 s1, s1, 0
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX9-GISEL-NEXT:    s_mov_b64 s[4:5], exec
; GFX9-GISEL-NEXT:    s_mov_b32 s6, 0
; GFX9-GISEL-NEXT:    s_mov_b32 s33, 0
; GFX9-GISEL-NEXT:    s_movk_i32 s32, 0x400
; GFX9-GISEL-NEXT:  .LBB5_1: ; =>This Inner Loop Header: Depth=1
; GFX9-GISEL-NEXT:    s_ff1_i32_b64 s7, s[4:5]
; GFX9-GISEL-NEXT:    v_readlane_b32 s8, v0, s7
; GFX9-GISEL-NEXT:    s_bitset0_b64 s[4:5], s7
; GFX9-GISEL-NEXT:    s_max_u32 s6, s6, s8
; GFX9-GISEL-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX9-GISEL-NEXT:    s_cbranch_scc1 .LBB5_1
; GFX9-GISEL-NEXT:  ; %bb.2:
; GFX9-GISEL-NEXT:    s_mov_b32 s4, s32
; GFX9-GISEL-NEXT:    s_lshl_b32 s5, s6, 6
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, 0x29a
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-GISEL-NEXT:    s_add_u32 s32, s4, s5
; GFX9-GISEL-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: test_dynamic_stackalloc_kernel_divergent_under_aligned:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-SDAG-NEXT:    s_mov_b32 s1, exec_lo
; GFX11-SDAG-NEXT:    s_mov_b32 s0, 0
; GFX11-SDAG-NEXT:    s_mov_b32 s33, 0
; GFX11-SDAG-NEXT:    s_mov_b32 s32, 16
; GFX11-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX11-SDAG-NEXT:  .LBB5_1: ; =>This Inner Loop Header: Depth=1
; GFX11-SDAG-NEXT:    s_ctz_i32_b32 s2, s1
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-NEXT:    v_readlane_b32 s3, v0, s2
; GFX11-SDAG-NEXT:    s_bitset0_b32 s1, s2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    s_max_u32 s0, s0, s3
; GFX11-SDAG-NEXT:    s_cmp_lg_u32 s1, 0
; GFX11-SDAG-NEXT:    s_cbranch_scc1 .LBB5_1
; GFX11-SDAG-NEXT:  ; %bb.2:
; GFX11-SDAG-NEXT:    s_mov_b32 s1, s32
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, 0x29a
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v0, s0, 5, s1
; GFX11-SDAG-NEXT:    scratch_store_b32 off, v1, s1 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s32, v0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: test_dynamic_stackalloc_kernel_divergent_under_aligned:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-GISEL-NEXT:    s_mov_b32 s1, exec_lo
; GFX11-GISEL-NEXT:    s_mov_b32 s0, 0
; GFX11-GISEL-NEXT:    s_mov_b32 s33, 0
; GFX11-GISEL-NEXT:    s_mov_b32 s32, 16
; GFX11-GISEL-NEXT:    v_lshl_add_u32 v0, v0, 4, 15
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX11-GISEL-NEXT:  .LBB5_1: ; =>This Inner Loop Header: Depth=1
; GFX11-GISEL-NEXT:    s_ctz_i32_b32 s2, s1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_readlane_b32 s3, v0, s2
; GFX11-GISEL-NEXT:    s_bitset0_b32 s1, s2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    s_max_u32 s0, s0, s3
; GFX11-GISEL-NEXT:    s_cmp_lg_u32 s1, 0
; GFX11-GISEL-NEXT:    s_cbranch_scc1 .LBB5_1
; GFX11-GISEL-NEXT:  ; %bb.2:
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v0, 0x29a
; GFX11-GISEL-NEXT:    s_mov_b32 s1, s32
; GFX11-GISEL-NEXT:    s_lshl_b32 s0, s0, 5
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    s_add_u32 s32, s1, s0
; GFX11-GISEL-NEXT:    scratch_store_b32 off, v0, s1 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_endpgm
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %alloca = alloca i128, i32 %idx, align 2, addrspace(5)
  store volatile i32 666, ptr addrspace(5) %alloca
  ret void
}

define amdgpu_kernel void @test_dynamic_stackalloc_kernel_multiple_allocas(i32 %n, i32 %m) {
; GFX9-SDAG-LABEL: test_dynamic_stackalloc_kernel_multiple_allocas:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; GFX9-SDAG-NEXT:    s_add_u32 s0, s0, s17
; GFX9-SDAG-NEXT:    s_addc_u32 s1, s1, 0
; GFX9-SDAG-NEXT:    s_mov_b32 s8, 0
; GFX9-SDAG-NEXT:    s_mov_b32 s33, 0
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_cmp_lg_u32 s4, 0
; GFX9-SDAG-NEXT:    s_movk_i32 s32, 0x2000
; GFX9-SDAG-NEXT:    s_cbranch_scc1 .LBB6_4
; GFX9-SDAG-NEXT:  ; %bb.1: ; %bb.0
; GFX9-SDAG-NEXT:    s_lshl_b32 s5, s5, 2
; GFX9-SDAG-NEXT:    s_add_i32 s5, s5, 15
; GFX9-SDAG-NEXT:    s_add_i32 s6, s32, 0xfff
; GFX9-SDAG-NEXT:    s_and_b32 s5, s5, -16
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX9-SDAG-NEXT:    s_and_b32 s9, s6, 0xfffff000
; GFX9-SDAG-NEXT:    s_lshl_b32 s5, s5, 6
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, 0x1ff0, v0
; GFX9-SDAG-NEXT:    s_mov_b64 s[6:7], exec
; GFX9-SDAG-NEXT:    s_add_i32 s32, s9, s5
; GFX9-SDAG-NEXT:  .LBB6_2: ; =>This Inner Loop Header: Depth=1
; GFX9-SDAG-NEXT:    s_ff1_i32_b64 s5, s[6:7]
; GFX9-SDAG-NEXT:    v_readlane_b32 s10, v0, s5
; GFX9-SDAG-NEXT:    s_bitset0_b64 s[6:7], s5
; GFX9-SDAG-NEXT:    s_max_u32 s8, s8, s10
; GFX9-SDAG-NEXT:    s_cmp_lg_u64 s[6:7], 0
; GFX9-SDAG-NEXT:    s_cbranch_scc1 .LBB6_2
; GFX9-SDAG-NEXT:  ; %bb.3:
; GFX9-SDAG-NEXT:    s_mov_b32 s5, s32
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s5
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v0, s8, 6, v0
; GFX9-SDAG-NEXT:    v_readfirstlane_b32 s32, v0
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, 3
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-SDAG-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, 4
; GFX9-SDAG-NEXT:    buffer_store_dword v0, off, s[0:3], s5
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:  .LBB6_4: ; %bb.1
; GFX9-SDAG-NEXT:    s_lshl_b32 s4, s4, 2
; GFX9-SDAG-NEXT:    s_add_i32 s4, s4, 15
; GFX9-SDAG-NEXT:    s_and_b32 s4, s4, -16
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, 1
; GFX9-SDAG-NEXT:    s_lshl_b32 s4, s4, 6
; GFX9-SDAG-NEXT:    s_mov_b32 s5, s32
; GFX9-SDAG-NEXT:    buffer_store_dword v0, off, s[0:3], s33
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, 2
; GFX9-SDAG-NEXT:    s_add_i32 s32, s5, s4
; GFX9-SDAG-NEXT:    buffer_store_dword v0, off, s[0:3], s5
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: test_dynamic_stackalloc_kernel_multiple_allocas:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; GFX9-GISEL-NEXT:    s_add_u32 s0, s0, s17
; GFX9-GISEL-NEXT:    s_addc_u32 s1, s1, 0
; GFX9-GISEL-NEXT:    s_mov_b32 s8, 0
; GFX9-GISEL-NEXT:    s_mov_b32 s33, 0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_cmp_lg_u32 s4, 0
; GFX9-GISEL-NEXT:    s_movk_i32 s32, 0x2000
; GFX9-GISEL-NEXT:    s_cbranch_scc1 .LBB6_4
; GFX9-GISEL-NEXT:  ; %bb.1: ; %bb.0
; GFX9-GISEL-NEXT:    s_lshl2_add_u32 s5, s5, 15
; GFX9-GISEL-NEXT:    s_and_b32 s5, s5, -16
; GFX9-GISEL-NEXT:    s_lshl_b32 s6, s5, 6
; GFX9-GISEL-NEXT:    s_add_u32 s5, s32, 0xfff
; GFX9-GISEL-NEXT:    s_and_b32 s5, s5, 0xfffff000
; GFX9-GISEL-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX9-GISEL-NEXT:    s_add_u32 s32, s5, s6
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX9-GISEL-NEXT:    s_mov_b64 s[6:7], exec
; GFX9-GISEL-NEXT:  .LBB6_2: ; =>This Inner Loop Header: Depth=1
; GFX9-GISEL-NEXT:    s_ff1_i32_b64 s9, s[6:7]
; GFX9-GISEL-NEXT:    v_readlane_b32 s10, v0, s9
; GFX9-GISEL-NEXT:    s_bitset0_b64 s[6:7], s9
; GFX9-GISEL-NEXT:    s_max_u32 s8, s8, s10
; GFX9-GISEL-NEXT:    s_cmp_lg_u64 s[6:7], 0
; GFX9-GISEL-NEXT:    s_cbranch_scc1 .LBB6_2
; GFX9-GISEL-NEXT:  ; %bb.3:
; GFX9-GISEL-NEXT:    s_mov_b32 s6, s32
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, 3
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-GISEL-NEXT:    s_lshl_b32 s7, s8, 6
; GFX9-GISEL-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, 4
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-GISEL-NEXT:    s_add_u32 s32, s6, s7
; GFX9-GISEL-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:  .LBB6_4: ; %bb.1
; GFX9-GISEL-NEXT:    s_lshl2_add_u32 s4, s4, 15
; GFX9-GISEL-NEXT:    s_mov_b32 s5, s32
; GFX9-GISEL-NEXT:    s_and_b32 s4, s4, -16
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, 1
; GFX9-GISEL-NEXT:    s_lshl_b32 s4, s4, 6
; GFX9-GISEL-NEXT:    buffer_store_dword v0, off, s[0:3], s33
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, 2
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-GISEL-NEXT:    s_add_u32 s32, s5, s4
; GFX9-GISEL-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: test_dynamic_stackalloc_kernel_multiple_allocas:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX11-SDAG-NEXT:    s_mov_b32 s2, 0
; GFX11-SDAG-NEXT:    s_mov_b32 s33, 0
; GFX11-SDAG-NEXT:    s_movk_i32 s32, 0x80
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_cmp_lg_u32 s0, 0
; GFX11-SDAG-NEXT:    s_cbranch_scc1 .LBB6_4
; GFX11-SDAG-NEXT:  ; %bb.1: ; %bb.0
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-SDAG-NEXT:    s_lshl_b32 s1, s1, 2
; GFX11-SDAG-NEXT:    s_add_i32 s3, s32, 0x7ff
; GFX11-SDAG-NEXT:    s_add_i32 s1, s1, 15
; GFX11-SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-NEXT:    s_and_b32 s4, s1, -16
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX11-SDAG-NEXT:    s_and_b32 s1, s3, 0xfffff800
; GFX11-SDAG-NEXT:    s_lshl_b32 s3, s4, 5
; GFX11-SDAG-NEXT:    s_add_i32 s32, s1, s3
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, 0x1ff0, v0
; GFX11-SDAG-NEXT:    s_mov_b32 s3, exec_lo
; GFX11-SDAG-NEXT:  .LBB6_2: ; =>This Inner Loop Header: Depth=1
; GFX11-SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-SDAG-NEXT:    s_ctz_i32_b32 s4, s3
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-NEXT:    v_readlane_b32 s5, v0, s4
; GFX11-SDAG-NEXT:    s_bitset0_b32 s3, s4
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    s_max_u32 s2, s2, s5
; GFX11-SDAG-NEXT:    s_cmp_lg_u32 s3, 0
; GFX11-SDAG-NEXT:    s_cbranch_scc1 .LBB6_2
; GFX11-SDAG-NEXT:  ; %bb.3:
; GFX11-SDAG-NEXT:    s_mov_b32 s3, s32
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v1, 3 :: v_dual_mov_b32 v2, 4
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v0, s2, 5, s3
; GFX11-SDAG-NEXT:    scratch_store_b32 off, v1, s1 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    scratch_store_b32 off, v2, s3 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s32, v0
; GFX11-SDAG-NEXT:  .LBB6_4: ; %bb.1
; GFX11-SDAG-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v0, 1 :: v_dual_mov_b32 v1, 2
; GFX11-SDAG-NEXT:    s_add_i32 s0, s0, 15
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-SDAG-NEXT:    s_mov_b32 s1, s32
; GFX11-SDAG-NEXT:    s_and_b32 s0, s0, -16
; GFX11-SDAG-NEXT:    scratch_store_b32 off, v0, s33 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    scratch_store_b32 off, v1, s1 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    s_lshl_b32 s0, s0, 5
; GFX11-SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-SDAG-NEXT:    s_add_i32 s32, s1, s0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: test_dynamic_stackalloc_kernel_multiple_allocas:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX11-GISEL-NEXT:    s_mov_b32 s2, 0
; GFX11-GISEL-NEXT:    s_mov_b32 s33, 0
; GFX11-GISEL-NEXT:    s_movk_i32 s32, 0x80
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_cmp_lg_u32 s0, 0
; GFX11-GISEL-NEXT:    s_cbranch_scc1 .LBB6_4
; GFX11-GISEL-NEXT:  ; %bb.1: ; %bb.0
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-GISEL-NEXT:    s_lshl2_add_u32 s1, s1, 15
; GFX11-GISEL-NEXT:    s_add_u32 s3, s32, 0x7ff
; GFX11-GISEL-NEXT:    s_and_b32 s1, s1, -16
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    s_lshl_b32 s4, s1, 5
; GFX11-GISEL-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX11-GISEL-NEXT:    s_and_b32 s1, s3, 0xfffff800
; GFX11-GISEL-NEXT:    s_mov_b32 s3, exec_lo
; GFX11-GISEL-NEXT:    s_add_u32 s32, s1, s4
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX11-GISEL-NEXT:  .LBB6_2: ; =>This Inner Loop Header: Depth=1
; GFX11-GISEL-NEXT:    s_ctz_i32_b32 s4, s3
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_readlane_b32 s5, v0, s4
; GFX11-GISEL-NEXT:    s_bitset0_b32 s3, s4
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    s_max_u32 s2, s2, s5
; GFX11-GISEL-NEXT:    s_cmp_lg_u32 s3, 0
; GFX11-GISEL-NEXT:    s_cbranch_scc1 .LBB6_2
; GFX11-GISEL-NEXT:  ; %bb.3:
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v0, 3 :: v_dual_mov_b32 v1, 4
; GFX11-GISEL-NEXT:    s_mov_b32 s3, s32
; GFX11-GISEL-NEXT:    s_lshl_b32 s2, s2, 5
; GFX11-GISEL-NEXT:    scratch_store_b32 off, v0, s1 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b32 off, v1, s3 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_add_u32 s32, s3, s2
; GFX11-GISEL-NEXT:  .LBB6_4: ; %bb.1
; GFX11-GISEL-NEXT:    s_lshl2_add_u32 s0, s0, 15
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v0, 1 :: v_dual_mov_b32 v1, 2
; GFX11-GISEL-NEXT:    s_and_b32 s0, s0, -16
; GFX11-GISEL-NEXT:    s_mov_b32 s1, s32
; GFX11-GISEL-NEXT:    s_lshl_b32 s0, s0, 5
; GFX11-GISEL-NEXT:    scratch_store_b32 off, v0, s33 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b32 off, v1, s1 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_add_u32 s32, s1, s0
; GFX11-GISEL-NEXT:    s_endpgm
entry:
  %cond = icmp eq i32 %n, 0
  %alloca1 = alloca i32, i32 8, addrspace(5)
  %alloca2 = alloca i17, i32 %n, addrspace(5)
  br i1 %cond, label %bb.0, label %bb.1
bb.0:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %alloca3 = alloca i32, i32 %m, align 64, addrspace(5)
  %alloca4 = alloca i32, i32 %idx, align 4, addrspace(5)
  store volatile i32 3, ptr addrspace(5) %alloca3
  store volatile i32 4, ptr addrspace(5) %alloca4
  br label %bb.1
bb.1:
  store volatile i32 1, ptr addrspace(5) %alloca1
  store volatile i32 2, ptr addrspace(5) %alloca2
  ret void
}

define amdgpu_kernel void @test_dynamic_stackalloc_kernel_control_flow(i32 %n, i32 %m) {
; GFX9-SDAG-LABEL: test_dynamic_stackalloc_kernel_control_flow:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; GFX9-SDAG-NEXT:    s_add_u32 s0, s0, s17
; GFX9-SDAG-NEXT:    s_addc_u32 s1, s1, 0
; GFX9-SDAG-NEXT:    s_mov_b32 s33, 0
; GFX9-SDAG-NEXT:    s_movk_i32 s32, 0x1000
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_cmp_lg_u32 s4, 0
; GFX9-SDAG-NEXT:    s_mov_b32 s4, 0
; GFX9-SDAG-NEXT:    s_cbranch_scc0 .LBB7_6
; GFX9-SDAG-NEXT:  ; %bb.1: ; %bb.1
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, 0x1ff0, v0
; GFX9-SDAG-NEXT:    s_mov_b64 s[6:7], exec
; GFX9-SDAG-NEXT:  .LBB7_2: ; =>This Inner Loop Header: Depth=1
; GFX9-SDAG-NEXT:    s_ff1_i32_b64 s8, s[6:7]
; GFX9-SDAG-NEXT:    v_readlane_b32 s9, v0, s8
; GFX9-SDAG-NEXT:    s_bitset0_b64 s[6:7], s8
; GFX9-SDAG-NEXT:    s_max_u32 s4, s4, s9
; GFX9-SDAG-NEXT:    s_cmp_lg_u64 s[6:7], 0
; GFX9-SDAG-NEXT:    s_cbranch_scc1 .LBB7_2
; GFX9-SDAG-NEXT:  ; %bb.3:
; GFX9-SDAG-NEXT:    s_mov_b32 s6, s32
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v0, s4, 6, v0
; GFX9-SDAG-NEXT:    v_readfirstlane_b32 s32, v0
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, 1
; GFX9-SDAG-NEXT:    buffer_store_dword v0, off, s[0:3], s6
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    s_cbranch_execnz .LBB7_5
; GFX9-SDAG-NEXT:  .LBB7_4: ; %bb.0
; GFX9-SDAG-NEXT:    s_lshl_b32 s5, s5, 2
; GFX9-SDAG-NEXT:    s_add_i32 s4, s32, 0xfff
; GFX9-SDAG-NEXT:    s_add_i32 s5, s5, 15
; GFX9-SDAG-NEXT:    s_and_b32 s4, s4, 0xfffff000
; GFX9-SDAG-NEXT:    s_and_b32 s5, s5, -16
; GFX9-SDAG-NEXT:    s_lshl_b32 s5, s5, 6
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, 2
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-SDAG-NEXT:    s_add_i32 s32, s4, s5
; GFX9-SDAG-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:  .LBB7_5: ; %bb.2
; GFX9-SDAG-NEXT:    s_endpgm
; GFX9-SDAG-NEXT:  .LBB7_6:
; GFX9-SDAG-NEXT:    s_branch .LBB7_4
;
; GFX9-GISEL-LABEL: test_dynamic_stackalloc_kernel_control_flow:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; GFX9-GISEL-NEXT:    s_add_u32 s0, s0, s17
; GFX9-GISEL-NEXT:    s_addc_u32 s1, s1, 0
; GFX9-GISEL-NEXT:    s_mov_b32 s8, 0
; GFX9-GISEL-NEXT:    s_mov_b32 s33, 0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_cmp_lg_u32 s4, 0
; GFX9-GISEL-NEXT:    s_mov_b32 s4, 1
; GFX9-GISEL-NEXT:    s_movk_i32 s32, 0x1000
; GFX9-GISEL-NEXT:    s_cbranch_scc0 .LBB7_4
; GFX9-GISEL-NEXT:  ; %bb.1: ; %bb.1
; GFX9-GISEL-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX9-GISEL-NEXT:    s_mov_b64 s[6:7], exec
; GFX9-GISEL-NEXT:  .LBB7_2: ; =>This Inner Loop Header: Depth=1
; GFX9-GISEL-NEXT:    s_ff1_i32_b64 s4, s[6:7]
; GFX9-GISEL-NEXT:    v_readlane_b32 s9, v0, s4
; GFX9-GISEL-NEXT:    s_bitset0_b64 s[6:7], s4
; GFX9-GISEL-NEXT:    s_max_u32 s8, s8, s9
; GFX9-GISEL-NEXT:    s_cmp_lg_u64 s[6:7], 0
; GFX9-GISEL-NEXT:    s_cbranch_scc1 .LBB7_2
; GFX9-GISEL-NEXT:  ; %bb.3:
; GFX9-GISEL-NEXT:    s_mov_b32 s4, s32
; GFX9-GISEL-NEXT:    s_lshl_b32 s6, s8, 6
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, 1
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-GISEL-NEXT:    s_add_u32 s32, s4, s6
; GFX9-GISEL-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    s_mov_b32 s4, 0
; GFX9-GISEL-NEXT:  .LBB7_4: ; %Flow
; GFX9-GISEL-NEXT:    s_xor_b32 s4, s4, 1
; GFX9-GISEL-NEXT:    s_and_b32 s4, s4, 1
; GFX9-GISEL-NEXT:    s_cmp_lg_u32 s4, 0
; GFX9-GISEL-NEXT:    s_cbranch_scc1 .LBB7_6
; GFX9-GISEL-NEXT:  ; %bb.5: ; %bb.0
; GFX9-GISEL-NEXT:    s_lshl2_add_u32 s4, s5, 15
; GFX9-GISEL-NEXT:    s_add_u32 s5, s32, 0xfff
; GFX9-GISEL-NEXT:    s_and_b32 s4, s4, -16
; GFX9-GISEL-NEXT:    s_and_b32 s5, s5, 0xfffff000
; GFX9-GISEL-NEXT:    s_lshl_b32 s4, s4, 6
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, 2
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-GISEL-NEXT:    s_add_u32 s32, s5, s4
; GFX9-GISEL-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:  .LBB7_6: ; %bb.2
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: test_dynamic_stackalloc_kernel_control_flow:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX11-SDAG-NEXT:    s_mov_b32 s33, 0
; GFX11-SDAG-NEXT:    s_mov_b32 s32, 64
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_cmp_lg_u32 s0, 0
; GFX11-SDAG-NEXT:    s_mov_b32 s0, 0
; GFX11-SDAG-NEXT:    s_cbranch_scc0 .LBB7_6
; GFX11-SDAG-NEXT:  ; %bb.1: ; %bb.1
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-SDAG-NEXT:    s_mov_b32 s2, exec_lo
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, 0x1ff0, v0
; GFX11-SDAG-NEXT:  .LBB7_2: ; =>This Inner Loop Header: Depth=1
; GFX11-SDAG-NEXT:    s_ctz_i32_b32 s3, s2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-NEXT:    v_readlane_b32 s4, v0, s3
; GFX11-SDAG-NEXT:    s_bitset0_b32 s2, s3
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    s_max_u32 s0, s0, s4
; GFX11-SDAG-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-SDAG-NEXT:    s_cbranch_scc1 .LBB7_2
; GFX11-SDAG-NEXT:  ; %bb.3:
; GFX11-SDAG-NEXT:    s_mov_b32 s2, s32
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, 1
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v0, s0, 5, s2
; GFX11-SDAG-NEXT:    scratch_store_b32 off, v1, s2 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s32, v0
; GFX11-SDAG-NEXT:    s_cbranch_execnz .LBB7_5
; GFX11-SDAG-NEXT:  .LBB7_4: ; %bb.0
; GFX11-SDAG-NEXT:    s_lshl_b32 s0, s1, 2
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v0, 2
; GFX11-SDAG-NEXT:    s_add_i32 s0, s0, 15
; GFX11-SDAG-NEXT:    s_add_i32 s1, s32, 0x7ff
; GFX11-SDAG-NEXT:    s_and_b32 s0, s0, -16
; GFX11-SDAG-NEXT:    s_and_b32 s1, s1, 0xfffff800
; GFX11-SDAG-NEXT:    s_lshl_b32 s0, s0, 5
; GFX11-SDAG-NEXT:    scratch_store_b32 off, v0, s1 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    s_add_i32 s32, s1, s0
; GFX11-SDAG-NEXT:  .LBB7_5: ; %bb.2
; GFX11-SDAG-NEXT:    s_endpgm
; GFX11-SDAG-NEXT:  .LBB7_6:
; GFX11-SDAG-NEXT:    s_branch .LBB7_4
;
; GFX11-GISEL-LABEL: test_dynamic_stackalloc_kernel_control_flow:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX11-GISEL-NEXT:    s_mov_b32 s2, 0
; GFX11-GISEL-NEXT:    s_mov_b32 s33, 0
; GFX11-GISEL-NEXT:    s_mov_b32 s32, 64
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_cmp_lg_u32 s0, 0
; GFX11-GISEL-NEXT:    s_mov_b32 s0, 1
; GFX11-GISEL-NEXT:    s_cbranch_scc0 .LBB7_4
; GFX11-GISEL-NEXT:  ; %bb.1: ; %bb.1
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-GISEL-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX11-GISEL-NEXT:  .LBB7_2: ; =>This Inner Loop Header: Depth=1
; GFX11-GISEL-NEXT:    s_ctz_i32_b32 s3, s0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_readlane_b32 s4, v0, s3
; GFX11-GISEL-NEXT:    s_bitset0_b32 s0, s3
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    s_max_u32 s2, s2, s4
; GFX11-GISEL-NEXT:    s_cmp_lg_u32 s0, 0
; GFX11-GISEL-NEXT:    s_cbranch_scc1 .LBB7_2
; GFX11-GISEL-NEXT:  ; %bb.3:
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v0, 1
; GFX11-GISEL-NEXT:    s_mov_b32 s3, s32
; GFX11-GISEL-NEXT:    s_lshl_b32 s0, s2, 5
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    s_add_u32 s32, s3, s0
; GFX11-GISEL-NEXT:    s_mov_b32 s0, 0
; GFX11-GISEL-NEXT:    scratch_store_b32 off, v0, s3 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:  .LBB7_4: ; %Flow
; GFX11-GISEL-NEXT:    s_xor_b32 s0, s0, 1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    s_and_b32 s0, s0, 1
; GFX11-GISEL-NEXT:    s_cmp_lg_u32 s0, 0
; GFX11-GISEL-NEXT:    s_cbranch_scc1 .LBB7_6
; GFX11-GISEL-NEXT:  ; %bb.5: ; %bb.0
; GFX11-GISEL-NEXT:    s_lshl2_add_u32 s0, s1, 15
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v0, 2
; GFX11-GISEL-NEXT:    s_add_u32 s1, s32, 0x7ff
; GFX11-GISEL-NEXT:    s_and_b32 s0, s0, -16
; GFX11-GISEL-NEXT:    s_and_b32 s1, s1, 0xfffff800
; GFX11-GISEL-NEXT:    s_lshl_b32 s0, s0, 5
; GFX11-GISEL-NEXT:    scratch_store_b32 off, v0, s1 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_add_u32 s32, s1, s0
; GFX11-GISEL-NEXT:  .LBB7_6: ; %bb.2
; GFX11-GISEL-NEXT:    s_endpgm
entry:
  %cond = icmp eq i32 %n, 0
  br i1 %cond, label %bb.0, label %bb.1
bb.0:
  %alloca2 = alloca i32, i32 %m, align 64, addrspace(5)
  store volatile i32 2, ptr addrspace(5) %alloca2
  br label %bb.2
bb.1:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %alloca1 = alloca i32, i32 %idx, align 4, addrspace(5)
  store volatile i32 1, ptr addrspace(5) %alloca1
  br label %bb.2
bb.2:
  ret void
}

define void @test_dynamic_stackalloc_device_uniform(i32 %n) {
; GFX9-SDAG-LABEL: test_dynamic_stackalloc_device_uniform:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX9-SDAG-NEXT:    s_mov_b32 s9, s33
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX9-SDAG-NEXT:    s_mov_b64 s[4:5], exec
; GFX9-SDAG-NEXT:    s_mov_b32 s6, 0
; GFX9-SDAG-NEXT:    s_mov_b32 s33, s32
; GFX9-SDAG-NEXT:    s_addk_i32 s32, 0x400
; GFX9-SDAG-NEXT:  .LBB8_1: ; =>This Inner Loop Header: Depth=1
; GFX9-SDAG-NEXT:    s_ff1_i32_b64 s7, s[4:5]
; GFX9-SDAG-NEXT:    v_readlane_b32 s8, v0, s7
; GFX9-SDAG-NEXT:    s_bitset0_b64 s[4:5], s7
; GFX9-SDAG-NEXT:    s_max_u32 s6, s6, s8
; GFX9-SDAG-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX9-SDAG-NEXT:    s_cbranch_scc1 .LBB8_1
; GFX9-SDAG-NEXT:  ; %bb.2:
; GFX9-SDAG-NEXT:    s_mov_b32 s4, s32
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v0, s6, 6, v0
; GFX9-SDAG-NEXT:    v_readfirstlane_b32 s32, v0
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, 0x7b
; GFX9-SDAG-NEXT:    buffer_store_dword v0, off, s[0:3], s4
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s32, s33
; GFX9-SDAG-NEXT:    s_mov_b32 s33, s9
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_dynamic_stackalloc_device_uniform:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX9-GISEL-NEXT:    s_mov_b32 s9, s33
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX9-GISEL-NEXT:    s_mov_b64 s[4:5], exec
; GFX9-GISEL-NEXT:    s_mov_b32 s6, 0
; GFX9-GISEL-NEXT:    s_mov_b32 s33, s32
; GFX9-GISEL-NEXT:    s_addk_i32 s32, 0x400
; GFX9-GISEL-NEXT:  .LBB8_1: ; =>This Inner Loop Header: Depth=1
; GFX9-GISEL-NEXT:    s_ff1_i32_b64 s7, s[4:5]
; GFX9-GISEL-NEXT:    v_readlane_b32 s8, v0, s7
; GFX9-GISEL-NEXT:    s_bitset0_b64 s[4:5], s7
; GFX9-GISEL-NEXT:    s_max_u32 s6, s6, s8
; GFX9-GISEL-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX9-GISEL-NEXT:    s_cbranch_scc1 .LBB8_1
; GFX9-GISEL-NEXT:  ; %bb.2:
; GFX9-GISEL-NEXT:    s_mov_b32 s4, s32
; GFX9-GISEL-NEXT:    s_lshl_b32 s5, s6, 6
; GFX9-GISEL-NEXT:    s_add_u32 s32, s4, s5
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, 0x7b
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-GISEL-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    s_mov_b32 s32, s33
; GFX9-GISEL-NEXT:    s_mov_b32 s33, s9
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_dynamic_stackalloc_device_uniform:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX11-SDAG-NEXT:    s_mov_b32 s4, s33
; GFX11-SDAG-NEXT:    s_mov_b32 s1, exec_lo
; GFX11-SDAG-NEXT:    s_mov_b32 s0, 0
; GFX11-SDAG-NEXT:    s_mov_b32 s33, s32
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX11-SDAG-NEXT:    s_add_i32 s32, s32, 16
; GFX11-SDAG-NEXT:  .LBB8_1: ; =>This Inner Loop Header: Depth=1
; GFX11-SDAG-NEXT:    s_ctz_i32_b32 s2, s1
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-NEXT:    v_readlane_b32 s3, v0, s2
; GFX11-SDAG-NEXT:    s_bitset0_b32 s1, s2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    s_max_u32 s0, s0, s3
; GFX11-SDAG-NEXT:    s_cmp_lg_u32 s1, 0
; GFX11-SDAG-NEXT:    s_cbranch_scc1 .LBB8_1
; GFX11-SDAG-NEXT:  ; %bb.2:
; GFX11-SDAG-NEXT:    s_mov_b32 s1, s32
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, 0x7b
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v0, s0, 5, s1
; GFX11-SDAG-NEXT:    scratch_store_b32 off, v1, s1 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s32, v0
; GFX11-SDAG-NEXT:    s_mov_b32 s32, s33
; GFX11-SDAG-NEXT:    s_mov_b32 s33, s4
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_dynamic_stackalloc_device_uniform:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX11-GISEL-NEXT:    s_mov_b32 s4, s33
; GFX11-GISEL-NEXT:    s_mov_b32 s1, exec_lo
; GFX11-GISEL-NEXT:    s_mov_b32 s0, 0
; GFX11-GISEL-NEXT:    s_mov_b32 s33, s32
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX11-GISEL-NEXT:    s_add_i32 s32, s32, 16
; GFX11-GISEL-NEXT:  .LBB8_1: ; =>This Inner Loop Header: Depth=1
; GFX11-GISEL-NEXT:    s_ctz_i32_b32 s2, s1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_readlane_b32 s3, v0, s2
; GFX11-GISEL-NEXT:    s_bitset0_b32 s1, s2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    s_max_u32 s0, s0, s3
; GFX11-GISEL-NEXT:    s_cmp_lg_u32 s1, 0
; GFX11-GISEL-NEXT:    s_cbranch_scc1 .LBB8_1
; GFX11-GISEL-NEXT:  ; %bb.2:
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v0, 0x7b
; GFX11-GISEL-NEXT:    s_mov_b32 s1, s32
; GFX11-GISEL-NEXT:    s_lshl_b32 s0, s0, 5
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    s_add_u32 s32, s1, s0
; GFX11-GISEL-NEXT:    scratch_store_b32 off, v0, s1 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_mov_b32 s32, s33
; GFX11-GISEL-NEXT:    s_mov_b32 s33, s4
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %alloca = alloca i32, i32 %n, addrspace(5)
  store volatile i32 123, ptr addrspace(5) %alloca
  ret void
}

define void @test_dynamic_stackalloc_device_uniform_over_aligned(i32 %n) {
; GFX9-SDAG-LABEL: test_dynamic_stackalloc_device_uniform_over_aligned:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX9-SDAG-NEXT:    s_mov_b32 s9, s33
; GFX9-SDAG-NEXT:    s_add_i32 s33, s32, 0x1fc0
; GFX9-SDAG-NEXT:    s_mov_b32 s10, s34
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX9-SDAG-NEXT:    s_mov_b64 s[4:5], exec
; GFX9-SDAG-NEXT:    s_mov_b32 s6, 0
; GFX9-SDAG-NEXT:    s_and_b32 s33, s33, 0xffffe000
; GFX9-SDAG-NEXT:    s_mov_b32 s34, s32
; GFX9-SDAG-NEXT:    s_addk_i32 s32, 0x4000
; GFX9-SDAG-NEXT:  .LBB9_1: ; =>This Inner Loop Header: Depth=1
; GFX9-SDAG-NEXT:    s_ff1_i32_b64 s7, s[4:5]
; GFX9-SDAG-NEXT:    v_readlane_b32 s8, v0, s7
; GFX9-SDAG-NEXT:    s_bitset0_b64 s[4:5], s7
; GFX9-SDAG-NEXT:    s_max_u32 s6, s6, s8
; GFX9-SDAG-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX9-SDAG-NEXT:    s_cbranch_scc1 .LBB9_1
; GFX9-SDAG-NEXT:  ; %bb.2:
; GFX9-SDAG-NEXT:    s_add_i32 s4, s32, 0x1fff
; GFX9-SDAG-NEXT:    s_and_b32 s4, s4, 0xffffe000
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v1, s6, 6, v0
; GFX9-SDAG-NEXT:    v_readfirstlane_b32 s32, v1
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v1, 10
; GFX9-SDAG-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s32, s34
; GFX9-SDAG-NEXT:    s_mov_b32 s34, s10
; GFX9-SDAG-NEXT:    s_mov_b32 s33, s9
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_dynamic_stackalloc_device_uniform_over_aligned:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX9-GISEL-NEXT:    s_mov_b32 s9, s33
; GFX9-GISEL-NEXT:    s_add_i32 s33, s32, 0x1fc0
; GFX9-GISEL-NEXT:    s_mov_b32 s10, s34
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX9-GISEL-NEXT:    s_mov_b64 s[4:5], exec
; GFX9-GISEL-NEXT:    s_mov_b32 s6, 0
; GFX9-GISEL-NEXT:    s_and_b32 s33, s33, 0xffffe000
; GFX9-GISEL-NEXT:    s_mov_b32 s34, s32
; GFX9-GISEL-NEXT:    s_addk_i32 s32, 0x4000
; GFX9-GISEL-NEXT:  .LBB9_1: ; =>This Inner Loop Header: Depth=1
; GFX9-GISEL-NEXT:    s_ff1_i32_b64 s7, s[4:5]
; GFX9-GISEL-NEXT:    v_readlane_b32 s8, v0, s7
; GFX9-GISEL-NEXT:    s_bitset0_b64 s[4:5], s7
; GFX9-GISEL-NEXT:    s_max_u32 s6, s6, s8
; GFX9-GISEL-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX9-GISEL-NEXT:    s_cbranch_scc1 .LBB9_1
; GFX9-GISEL-NEXT:  ; %bb.2:
; GFX9-GISEL-NEXT:    s_add_u32 s5, s32, 0x1fff
; GFX9-GISEL-NEXT:    s_lshl_b32 s4, s6, 6
; GFX9-GISEL-NEXT:    s_and_b32 s5, s5, 0xffffe000
; GFX9-GISEL-NEXT:    s_add_u32 s32, s5, s4
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, 10
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-GISEL-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    s_mov_b32 s32, s34
; GFX9-GISEL-NEXT:    s_mov_b32 s34, s10
; GFX9-GISEL-NEXT:    s_mov_b32 s33, s9
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_dynamic_stackalloc_device_uniform_over_aligned:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX11-SDAG-NEXT:    s_mov_b32 s4, s33
; GFX11-SDAG-NEXT:    s_add_i32 s33, s32, 0x7f
; GFX11-SDAG-NEXT:    s_mov_b32 s5, s34
; GFX11-SDAG-NEXT:    s_mov_b32 s1, exec_lo
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX11-SDAG-NEXT:    s_mov_b32 s0, 0
; GFX11-SDAG-NEXT:    s_and_b32 s33, s33, 0xffffff80
; GFX11-SDAG-NEXT:    s_mov_b32 s34, s32
; GFX11-SDAG-NEXT:    s_addk_i32 s32, 0x100
; GFX11-SDAG-NEXT:  .LBB9_1: ; =>This Inner Loop Header: Depth=1
; GFX11-SDAG-NEXT:    s_ctz_i32_b32 s2, s1
; GFX11-SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_readlane_b32 s3, v0, s2
; GFX11-SDAG-NEXT:    s_bitset0_b32 s1, s2
; GFX11-SDAG-NEXT:    s_max_u32 s0, s0, s3
; GFX11-SDAG-NEXT:    s_cmp_lg_u32 s1, 0
; GFX11-SDAG-NEXT:    s_cbranch_scc1 .LBB9_1
; GFX11-SDAG-NEXT:  ; %bb.2:
; GFX11-SDAG-NEXT:    s_add_i32 s1, s32, 0xfff
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, 10
; GFX11-SDAG-NEXT:    s_and_b32 s1, s1, 0xfffff000
; GFX11-SDAG-NEXT:    s_mov_b32 s33, s4
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v0, s0, 5, s1
; GFX11-SDAG-NEXT:    scratch_store_b32 off, v1, s1 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s32, v0
; GFX11-SDAG-NEXT:    s_mov_b32 s32, s34
; GFX11-SDAG-NEXT:    s_mov_b32 s34, s5
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_dynamic_stackalloc_device_uniform_over_aligned:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX11-GISEL-NEXT:    s_mov_b32 s4, s33
; GFX11-GISEL-NEXT:    s_add_i32 s33, s32, 0x7f
; GFX11-GISEL-NEXT:    s_mov_b32 s5, s34
; GFX11-GISEL-NEXT:    s_mov_b32 s1, exec_lo
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX11-GISEL-NEXT:    s_mov_b32 s0, 0
; GFX11-GISEL-NEXT:    s_and_b32 s33, s33, 0xffffff80
; GFX11-GISEL-NEXT:    s_mov_b32 s34, s32
; GFX11-GISEL-NEXT:    s_addk_i32 s32, 0x100
; GFX11-GISEL-NEXT:  .LBB9_1: ; =>This Inner Loop Header: Depth=1
; GFX11-GISEL-NEXT:    s_ctz_i32_b32 s2, s1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_readlane_b32 s3, v0, s2
; GFX11-GISEL-NEXT:    s_bitset0_b32 s1, s2
; GFX11-GISEL-NEXT:    s_max_u32 s0, s0, s3
; GFX11-GISEL-NEXT:    s_cmp_lg_u32 s1, 0
; GFX11-GISEL-NEXT:    s_cbranch_scc1 .LBB9_1
; GFX11-GISEL-NEXT:  ; %bb.2:
; GFX11-GISEL-NEXT:    s_add_u32 s1, s32, 0xfff
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v0, 10
; GFX11-GISEL-NEXT:    s_lshl_b32 s0, s0, 5
; GFX11-GISEL-NEXT:    s_and_b32 s1, s1, 0xfffff000
; GFX11-GISEL-NEXT:    s_mov_b32 s33, s4
; GFX11-GISEL-NEXT:    s_add_u32 s32, s1, s0
; GFX11-GISEL-NEXT:    scratch_store_b32 off, v0, s1 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_mov_b32 s32, s34
; GFX11-GISEL-NEXT:    s_mov_b32 s34, s5
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %alloca = alloca i32, i32 %n, align 128, addrspace(5)
  store volatile i32 10, ptr addrspace(5) %alloca
  ret void
}

define void @test_dynamic_stackalloc_device_uniform_under_aligned(i32 %n) {
; GFX9-SDAG-LABEL: test_dynamic_stackalloc_device_uniform_under_aligned:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX9-SDAG-NEXT:    s_mov_b32 s9, s33
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX9-SDAG-NEXT:    s_mov_b64 s[4:5], exec
; GFX9-SDAG-NEXT:    s_mov_b32 s6, 0
; GFX9-SDAG-NEXT:    s_mov_b32 s33, s32
; GFX9-SDAG-NEXT:    s_addk_i32 s32, 0x400
; GFX9-SDAG-NEXT:  .LBB10_1: ; =>This Inner Loop Header: Depth=1
; GFX9-SDAG-NEXT:    s_ff1_i32_b64 s7, s[4:5]
; GFX9-SDAG-NEXT:    v_readlane_b32 s8, v0, s7
; GFX9-SDAG-NEXT:    s_bitset0_b64 s[4:5], s7
; GFX9-SDAG-NEXT:    s_max_u32 s6, s6, s8
; GFX9-SDAG-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX9-SDAG-NEXT:    s_cbranch_scc1 .LBB10_1
; GFX9-SDAG-NEXT:  ; %bb.2:
; GFX9-SDAG-NEXT:    s_mov_b32 s4, s32
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v0, s6, 6, v0
; GFX9-SDAG-NEXT:    v_readfirstlane_b32 s32, v0
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, 22
; GFX9-SDAG-NEXT:    buffer_store_dword v0, off, s[0:3], s4
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s32, s33
; GFX9-SDAG-NEXT:    s_mov_b32 s33, s9
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_dynamic_stackalloc_device_uniform_under_aligned:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX9-GISEL-NEXT:    s_mov_b32 s9, s33
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX9-GISEL-NEXT:    s_mov_b64 s[4:5], exec
; GFX9-GISEL-NEXT:    s_mov_b32 s6, 0
; GFX9-GISEL-NEXT:    s_mov_b32 s33, s32
; GFX9-GISEL-NEXT:    s_addk_i32 s32, 0x400
; GFX9-GISEL-NEXT:  .LBB10_1: ; =>This Inner Loop Header: Depth=1
; GFX9-GISEL-NEXT:    s_ff1_i32_b64 s7, s[4:5]
; GFX9-GISEL-NEXT:    v_readlane_b32 s8, v0, s7
; GFX9-GISEL-NEXT:    s_bitset0_b64 s[4:5], s7
; GFX9-GISEL-NEXT:    s_max_u32 s6, s6, s8
; GFX9-GISEL-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX9-GISEL-NEXT:    s_cbranch_scc1 .LBB10_1
; GFX9-GISEL-NEXT:  ; %bb.2:
; GFX9-GISEL-NEXT:    s_mov_b32 s4, s32
; GFX9-GISEL-NEXT:    s_lshl_b32 s5, s6, 6
; GFX9-GISEL-NEXT:    s_add_u32 s32, s4, s5
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, 22
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-GISEL-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    s_mov_b32 s32, s33
; GFX9-GISEL-NEXT:    s_mov_b32 s33, s9
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_dynamic_stackalloc_device_uniform_under_aligned:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX11-SDAG-NEXT:    s_mov_b32 s4, s33
; GFX11-SDAG-NEXT:    s_mov_b32 s1, exec_lo
; GFX11-SDAG-NEXT:    s_mov_b32 s0, 0
; GFX11-SDAG-NEXT:    s_mov_b32 s33, s32
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX11-SDAG-NEXT:    s_add_i32 s32, s32, 16
; GFX11-SDAG-NEXT:  .LBB10_1: ; =>This Inner Loop Header: Depth=1
; GFX11-SDAG-NEXT:    s_ctz_i32_b32 s2, s1
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-NEXT:    v_readlane_b32 s3, v0, s2
; GFX11-SDAG-NEXT:    s_bitset0_b32 s1, s2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    s_max_u32 s0, s0, s3
; GFX11-SDAG-NEXT:    s_cmp_lg_u32 s1, 0
; GFX11-SDAG-NEXT:    s_cbranch_scc1 .LBB10_1
; GFX11-SDAG-NEXT:  ; %bb.2:
; GFX11-SDAG-NEXT:    s_mov_b32 s1, s32
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, 22
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v0, s0, 5, s1
; GFX11-SDAG-NEXT:    scratch_store_b32 off, v1, s1 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s32, v0
; GFX11-SDAG-NEXT:    s_mov_b32 s32, s33
; GFX11-SDAG-NEXT:    s_mov_b32 s33, s4
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_dynamic_stackalloc_device_uniform_under_aligned:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX11-GISEL-NEXT:    s_mov_b32 s4, s33
; GFX11-GISEL-NEXT:    s_mov_b32 s1, exec_lo
; GFX11-GISEL-NEXT:    s_mov_b32 s0, 0
; GFX11-GISEL-NEXT:    s_mov_b32 s33, s32
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX11-GISEL-NEXT:    s_add_i32 s32, s32, 16
; GFX11-GISEL-NEXT:  .LBB10_1: ; =>This Inner Loop Header: Depth=1
; GFX11-GISEL-NEXT:    s_ctz_i32_b32 s2, s1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_readlane_b32 s3, v0, s2
; GFX11-GISEL-NEXT:    s_bitset0_b32 s1, s2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    s_max_u32 s0, s0, s3
; GFX11-GISEL-NEXT:    s_cmp_lg_u32 s1, 0
; GFX11-GISEL-NEXT:    s_cbranch_scc1 .LBB10_1
; GFX11-GISEL-NEXT:  ; %bb.2:
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v0, 22
; GFX11-GISEL-NEXT:    s_mov_b32 s1, s32
; GFX11-GISEL-NEXT:    s_lshl_b32 s0, s0, 5
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    s_add_u32 s32, s1, s0
; GFX11-GISEL-NEXT:    scratch_store_b32 off, v0, s1 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_mov_b32 s32, s33
; GFX11-GISEL-NEXT:    s_mov_b32 s33, s4
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %alloca = alloca i32, i32 %n, align 2, addrspace(5)
  store volatile i32 22, ptr addrspace(5) %alloca
  ret void
}

define void @test_dynamic_stackalloc_device_divergent() {
; GFX9-SDAG-LABEL: test_dynamic_stackalloc_device_divergent:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v31
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX9-SDAG-NEXT:    s_mov_b32 s9, s33
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, 0x1ff0, v0
; GFX9-SDAG-NEXT:    s_mov_b64 s[4:5], exec
; GFX9-SDAG-NEXT:    s_mov_b32 s6, 0
; GFX9-SDAG-NEXT:    s_mov_b32 s33, s32
; GFX9-SDAG-NEXT:    s_addk_i32 s32, 0x400
; GFX9-SDAG-NEXT:  .LBB11_1: ; =>This Inner Loop Header: Depth=1
; GFX9-SDAG-NEXT:    s_ff1_i32_b64 s7, s[4:5]
; GFX9-SDAG-NEXT:    v_readlane_b32 s8, v0, s7
; GFX9-SDAG-NEXT:    s_bitset0_b64 s[4:5], s7
; GFX9-SDAG-NEXT:    s_max_u32 s6, s6, s8
; GFX9-SDAG-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX9-SDAG-NEXT:    s_cbranch_scc1 .LBB11_1
; GFX9-SDAG-NEXT:  ; %bb.2:
; GFX9-SDAG-NEXT:    s_mov_b32 s4, s32
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v0, s6, 6, v0
; GFX9-SDAG-NEXT:    v_readfirstlane_b32 s32, v0
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, 0x7b
; GFX9-SDAG-NEXT:    buffer_store_dword v0, off, s[0:3], s4
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s32, s33
; GFX9-SDAG-NEXT:    s_mov_b32 s33, s9
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_dynamic_stackalloc_device_divergent:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v31
; GFX9-GISEL-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX9-GISEL-NEXT:    s_mov_b32 s9, s33
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX9-GISEL-NEXT:    s_mov_b64 s[4:5], exec
; GFX9-GISEL-NEXT:    s_mov_b32 s6, 0
; GFX9-GISEL-NEXT:    s_mov_b32 s33, s32
; GFX9-GISEL-NEXT:    s_addk_i32 s32, 0x400
; GFX9-GISEL-NEXT:  .LBB11_1: ; =>This Inner Loop Header: Depth=1
; GFX9-GISEL-NEXT:    s_ff1_i32_b64 s7, s[4:5]
; GFX9-GISEL-NEXT:    v_readlane_b32 s8, v0, s7
; GFX9-GISEL-NEXT:    s_bitset0_b64 s[4:5], s7
; GFX9-GISEL-NEXT:    s_max_u32 s6, s6, s8
; GFX9-GISEL-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX9-GISEL-NEXT:    s_cbranch_scc1 .LBB11_1
; GFX9-GISEL-NEXT:  ; %bb.2:
; GFX9-GISEL-NEXT:    s_mov_b32 s4, s32
; GFX9-GISEL-NEXT:    s_lshl_b32 s5, s6, 6
; GFX9-GISEL-NEXT:    s_add_u32 s32, s4, s5
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, 0x7b
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-GISEL-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    s_mov_b32 s32, s33
; GFX9-GISEL-NEXT:    s_mov_b32 s33, s9
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_dynamic_stackalloc_device_divergent:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v31
; GFX11-SDAG-NEXT:    s_mov_b32 s4, s33
; GFX11-SDAG-NEXT:    s_mov_b32 s1, exec_lo
; GFX11-SDAG-NEXT:    s_mov_b32 s0, 0
; GFX11-SDAG-NEXT:    s_mov_b32 s33, s32
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX11-SDAG-NEXT:    s_add_i32 s32, s32, 16
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, 0x1ff0, v0
; GFX11-SDAG-NEXT:  .LBB11_1: ; =>This Inner Loop Header: Depth=1
; GFX11-SDAG-NEXT:    s_ctz_i32_b32 s2, s1
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-NEXT:    v_readlane_b32 s3, v0, s2
; GFX11-SDAG-NEXT:    s_bitset0_b32 s1, s2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    s_max_u32 s0, s0, s3
; GFX11-SDAG-NEXT:    s_cmp_lg_u32 s1, 0
; GFX11-SDAG-NEXT:    s_cbranch_scc1 .LBB11_1
; GFX11-SDAG-NEXT:  ; %bb.2:
; GFX11-SDAG-NEXT:    s_mov_b32 s1, s32
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, 0x7b
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v0, s0, 5, s1
; GFX11-SDAG-NEXT:    scratch_store_b32 off, v1, s1 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s32, v0
; GFX11-SDAG-NEXT:    s_mov_b32 s32, s33
; GFX11-SDAG-NEXT:    s_mov_b32 s33, s4
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_dynamic_stackalloc_device_divergent:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v31
; GFX11-GISEL-NEXT:    s_mov_b32 s4, s33
; GFX11-GISEL-NEXT:    s_mov_b32 s1, exec_lo
; GFX11-GISEL-NEXT:    s_mov_b32 s0, 0
; GFX11-GISEL-NEXT:    s_mov_b32 s33, s32
; GFX11-GISEL-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX11-GISEL-NEXT:    s_add_i32 s32, s32, 16
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX11-GISEL-NEXT:  .LBB11_1: ; =>This Inner Loop Header: Depth=1
; GFX11-GISEL-NEXT:    s_ctz_i32_b32 s2, s1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_readlane_b32 s3, v0, s2
; GFX11-GISEL-NEXT:    s_bitset0_b32 s1, s2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    s_max_u32 s0, s0, s3
; GFX11-GISEL-NEXT:    s_cmp_lg_u32 s1, 0
; GFX11-GISEL-NEXT:    s_cbranch_scc1 .LBB11_1
; GFX11-GISEL-NEXT:  ; %bb.2:
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v0, 0x7b
; GFX11-GISEL-NEXT:    s_mov_b32 s1, s32
; GFX11-GISEL-NEXT:    s_lshl_b32 s0, s0, 5
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    s_add_u32 s32, s1, s0
; GFX11-GISEL-NEXT:    scratch_store_b32 off, v0, s1 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_mov_b32 s32, s33
; GFX11-GISEL-NEXT:    s_mov_b32 s33, s4
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %alloca = alloca i32, i32 %idx, addrspace(5)
  store volatile i32 123, ptr addrspace(5) %alloca
  ret void
}

define void @test_dynamic_stackalloc_device_divergent_over_aligned() {
; GFX9-SDAG-LABEL: test_dynamic_stackalloc_device_divergent_over_aligned:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s10, s33
; GFX9-SDAG-NEXT:    s_add_i32 s33, s32, 0x1fc0
; GFX9-SDAG-NEXT:    s_mov_b32 s11, s34
; GFX9-SDAG-NEXT:    s_mov_b32 s34, s32
; GFX9-SDAG-NEXT:    s_addk_i32 s32, 0x4000
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v31
; GFX9-SDAG-NEXT:    s_add_i32 s4, s32, 0x1fff
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX9-SDAG-NEXT:    s_and_b32 s6, s4, 0xffffe000
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, 0x1ff0, v0
; GFX9-SDAG-NEXT:    s_mov_b64 s[4:5], exec
; GFX9-SDAG-NEXT:    s_mov_b32 s7, 0
; GFX9-SDAG-NEXT:    s_and_b32 s33, s33, 0xffffe000
; GFX9-SDAG-NEXT:  .LBB12_1: ; =>This Inner Loop Header: Depth=1
; GFX9-SDAG-NEXT:    s_ff1_i32_b64 s8, s[4:5]
; GFX9-SDAG-NEXT:    v_readlane_b32 s9, v0, s8
; GFX9-SDAG-NEXT:    s_bitset0_b64 s[4:5], s8
; GFX9-SDAG-NEXT:    s_max_u32 s7, s7, s9
; GFX9-SDAG-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX9-SDAG-NEXT:    s_cbranch_scc1 .LBB12_1
; GFX9-SDAG-NEXT:  ; %bb.2:
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v1, s7, 6, v0
; GFX9-SDAG-NEXT:    v_readfirstlane_b32 s32, v1
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v1, 0x1bc
; GFX9-SDAG-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s32, s34
; GFX9-SDAG-NEXT:    s_mov_b32 s34, s11
; GFX9-SDAG-NEXT:    s_mov_b32 s33, s10
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_dynamic_stackalloc_device_divergent_over_aligned:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v31
; GFX9-GISEL-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX9-GISEL-NEXT:    s_mov_b32 s9, s33
; GFX9-GISEL-NEXT:    s_add_i32 s33, s32, 0x1fc0
; GFX9-GISEL-NEXT:    s_mov_b32 s10, s34
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX9-GISEL-NEXT:    s_mov_b64 s[4:5], exec
; GFX9-GISEL-NEXT:    s_mov_b32 s6, 0
; GFX9-GISEL-NEXT:    s_and_b32 s33, s33, 0xffffe000
; GFX9-GISEL-NEXT:    s_mov_b32 s34, s32
; GFX9-GISEL-NEXT:    s_addk_i32 s32, 0x4000
; GFX9-GISEL-NEXT:  .LBB12_1: ; =>This Inner Loop Header: Depth=1
; GFX9-GISEL-NEXT:    s_ff1_i32_b64 s7, s[4:5]
; GFX9-GISEL-NEXT:    v_readlane_b32 s8, v0, s7
; GFX9-GISEL-NEXT:    s_bitset0_b64 s[4:5], s7
; GFX9-GISEL-NEXT:    s_max_u32 s6, s6, s8
; GFX9-GISEL-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX9-GISEL-NEXT:    s_cbranch_scc1 .LBB12_1
; GFX9-GISEL-NEXT:  ; %bb.2:
; GFX9-GISEL-NEXT:    s_add_u32 s5, s32, 0x1fff
; GFX9-GISEL-NEXT:    s_lshl_b32 s4, s6, 6
; GFX9-GISEL-NEXT:    s_and_b32 s5, s5, 0xffffe000
; GFX9-GISEL-NEXT:    s_add_u32 s32, s5, s4
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, 0x1bc
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-GISEL-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    s_mov_b32 s32, s34
; GFX9-GISEL-NEXT:    s_mov_b32 s34, s10
; GFX9-GISEL-NEXT:    s_mov_b32 s33, s9
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_dynamic_stackalloc_device_divergent_over_aligned:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v31
; GFX11-SDAG-NEXT:    s_mov_b32 s5, s33
; GFX11-SDAG-NEXT:    s_add_i32 s33, s32, 0x7f
; GFX11-SDAG-NEXT:    s_mov_b32 s6, s34
; GFX11-SDAG-NEXT:    s_mov_b32 s34, s32
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX11-SDAG-NEXT:    s_addk_i32 s32, 0x100
; GFX11-SDAG-NEXT:    s_mov_b32 s2, exec_lo
; GFX11-SDAG-NEXT:    s_add_i32 s0, s32, 0xfff
; GFX11-SDAG-NEXT:    s_mov_b32 s1, 0
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, 0x1ff0, v0
; GFX11-SDAG-NEXT:    s_and_b32 s0, s0, 0xfffff000
; GFX11-SDAG-NEXT:    s_and_b32 s33, s33, 0xffffff80
; GFX11-SDAG-NEXT:  .LBB12_1: ; =>This Inner Loop Header: Depth=1
; GFX11-SDAG-NEXT:    s_ctz_i32_b32 s3, s2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-NEXT:    v_readlane_b32 s4, v0, s3
; GFX11-SDAG-NEXT:    s_bitset0_b32 s2, s3
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    s_max_u32 s1, s1, s4
; GFX11-SDAG-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-SDAG-NEXT:    s_cbranch_scc1 .LBB12_1
; GFX11-SDAG-NEXT:  ; %bb.2:
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v0, s1, 5, s0
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, 0x1bc
; GFX11-SDAG-NEXT:    s_mov_b32 s33, s5
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s32, v0
; GFX11-SDAG-NEXT:    scratch_store_b32 off, v1, s0 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    s_mov_b32 s32, s34
; GFX11-SDAG-NEXT:    s_mov_b32 s34, s6
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_dynamic_stackalloc_device_divergent_over_aligned:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v31
; GFX11-GISEL-NEXT:    s_mov_b32 s4, s33
; GFX11-GISEL-NEXT:    s_add_i32 s33, s32, 0x7f
; GFX11-GISEL-NEXT:    s_mov_b32 s5, s34
; GFX11-GISEL-NEXT:    s_mov_b32 s1, exec_lo
; GFX11-GISEL-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX11-GISEL-NEXT:    s_mov_b32 s0, 0
; GFX11-GISEL-NEXT:    s_and_b32 s33, s33, 0xffffff80
; GFX11-GISEL-NEXT:    s_mov_b32 s34, s32
; GFX11-GISEL-NEXT:    s_addk_i32 s32, 0x100
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX11-GISEL-NEXT:  .LBB12_1: ; =>This Inner Loop Header: Depth=1
; GFX11-GISEL-NEXT:    s_ctz_i32_b32 s2, s1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_readlane_b32 s3, v0, s2
; GFX11-GISEL-NEXT:    s_bitset0_b32 s1, s2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    s_max_u32 s0, s0, s3
; GFX11-GISEL-NEXT:    s_cmp_lg_u32 s1, 0
; GFX11-GISEL-NEXT:    s_cbranch_scc1 .LBB12_1
; GFX11-GISEL-NEXT:  ; %bb.2:
; GFX11-GISEL-NEXT:    s_add_u32 s1, s32, 0xfff
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v0, 0x1bc
; GFX11-GISEL-NEXT:    s_lshl_b32 s0, s0, 5
; GFX11-GISEL-NEXT:    s_and_b32 s1, s1, 0xfffff000
; GFX11-GISEL-NEXT:    s_mov_b32 s33, s4
; GFX11-GISEL-NEXT:    s_add_u32 s32, s1, s0
; GFX11-GISEL-NEXT:    scratch_store_b32 off, v0, s1 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_mov_b32 s32, s34
; GFX11-GISEL-NEXT:    s_mov_b32 s34, s5
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %alloca = alloca i32, i32 %idx, align 128, addrspace(5)
  store volatile i32 444, ptr addrspace(5) %alloca
  ret void
}

define void @test_dynamic_stackalloc_device_divergent_under_aligned() {
; GFX9-SDAG-LABEL: test_dynamic_stackalloc_device_divergent_under_aligned:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v31
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX9-SDAG-NEXT:    s_mov_b32 s9, s33
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, 0x1ff0, v0
; GFX9-SDAG-NEXT:    s_mov_b64 s[4:5], exec
; GFX9-SDAG-NEXT:    s_mov_b32 s6, 0
; GFX9-SDAG-NEXT:    s_mov_b32 s33, s32
; GFX9-SDAG-NEXT:    s_addk_i32 s32, 0x400
; GFX9-SDAG-NEXT:  .LBB13_1: ; =>This Inner Loop Header: Depth=1
; GFX9-SDAG-NEXT:    s_ff1_i32_b64 s7, s[4:5]
; GFX9-SDAG-NEXT:    v_readlane_b32 s8, v0, s7
; GFX9-SDAG-NEXT:    s_bitset0_b64 s[4:5], s7
; GFX9-SDAG-NEXT:    s_max_u32 s6, s6, s8
; GFX9-SDAG-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX9-SDAG-NEXT:    s_cbranch_scc1 .LBB13_1
; GFX9-SDAG-NEXT:  ; %bb.2:
; GFX9-SDAG-NEXT:    s_mov_b32 s4, s32
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v0, s6, 6, v0
; GFX9-SDAG-NEXT:    v_readfirstlane_b32 s32, v0
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, 0x29a
; GFX9-SDAG-NEXT:    buffer_store_dword v0, off, s[0:3], s4
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s32, s33
; GFX9-SDAG-NEXT:    s_mov_b32 s33, s9
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_dynamic_stackalloc_device_divergent_under_aligned:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v31
; GFX9-GISEL-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX9-GISEL-NEXT:    s_mov_b32 s9, s33
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX9-GISEL-NEXT:    s_mov_b64 s[4:5], exec
; GFX9-GISEL-NEXT:    s_mov_b32 s6, 0
; GFX9-GISEL-NEXT:    s_mov_b32 s33, s32
; GFX9-GISEL-NEXT:    s_addk_i32 s32, 0x400
; GFX9-GISEL-NEXT:  .LBB13_1: ; =>This Inner Loop Header: Depth=1
; GFX9-GISEL-NEXT:    s_ff1_i32_b64 s7, s[4:5]
; GFX9-GISEL-NEXT:    v_readlane_b32 s8, v0, s7
; GFX9-GISEL-NEXT:    s_bitset0_b64 s[4:5], s7
; GFX9-GISEL-NEXT:    s_max_u32 s6, s6, s8
; GFX9-GISEL-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX9-GISEL-NEXT:    s_cbranch_scc1 .LBB13_1
; GFX9-GISEL-NEXT:  ; %bb.2:
; GFX9-GISEL-NEXT:    s_mov_b32 s4, s32
; GFX9-GISEL-NEXT:    s_lshl_b32 s5, s6, 6
; GFX9-GISEL-NEXT:    s_add_u32 s32, s4, s5
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, 0x29a
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-GISEL-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    s_mov_b32 s32, s33
; GFX9-GISEL-NEXT:    s_mov_b32 s33, s9
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_dynamic_stackalloc_device_divergent_under_aligned:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v31
; GFX11-SDAG-NEXT:    s_mov_b32 s4, s33
; GFX11-SDAG-NEXT:    s_mov_b32 s1, exec_lo
; GFX11-SDAG-NEXT:    s_mov_b32 s0, 0
; GFX11-SDAG-NEXT:    s_mov_b32 s33, s32
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX11-SDAG-NEXT:    s_add_i32 s32, s32, 16
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, 0x1ff0, v0
; GFX11-SDAG-NEXT:  .LBB13_1: ; =>This Inner Loop Header: Depth=1
; GFX11-SDAG-NEXT:    s_ctz_i32_b32 s2, s1
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-NEXT:    v_readlane_b32 s3, v0, s2
; GFX11-SDAG-NEXT:    s_bitset0_b32 s1, s2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    s_max_u32 s0, s0, s3
; GFX11-SDAG-NEXT:    s_cmp_lg_u32 s1, 0
; GFX11-SDAG-NEXT:    s_cbranch_scc1 .LBB13_1
; GFX11-SDAG-NEXT:  ; %bb.2:
; GFX11-SDAG-NEXT:    s_mov_b32 s1, s32
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, 0x29a
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v0, s0, 5, s1
; GFX11-SDAG-NEXT:    scratch_store_b32 off, v1, s1 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s32, v0
; GFX11-SDAG-NEXT:    s_mov_b32 s32, s33
; GFX11-SDAG-NEXT:    s_mov_b32 s33, s4
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_dynamic_stackalloc_device_divergent_under_aligned:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v31
; GFX11-GISEL-NEXT:    s_mov_b32 s4, s33
; GFX11-GISEL-NEXT:    s_mov_b32 s1, exec_lo
; GFX11-GISEL-NEXT:    s_mov_b32 s0, 0
; GFX11-GISEL-NEXT:    s_mov_b32 s33, s32
; GFX11-GISEL-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX11-GISEL-NEXT:    s_add_i32 s32, s32, 16
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX11-GISEL-NEXT:  .LBB13_1: ; =>This Inner Loop Header: Depth=1
; GFX11-GISEL-NEXT:    s_ctz_i32_b32 s2, s1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_readlane_b32 s3, v0, s2
; GFX11-GISEL-NEXT:    s_bitset0_b32 s1, s2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    s_max_u32 s0, s0, s3
; GFX11-GISEL-NEXT:    s_cmp_lg_u32 s1, 0
; GFX11-GISEL-NEXT:    s_cbranch_scc1 .LBB13_1
; GFX11-GISEL-NEXT:  ; %bb.2:
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v0, 0x29a
; GFX11-GISEL-NEXT:    s_mov_b32 s1, s32
; GFX11-GISEL-NEXT:    s_lshl_b32 s0, s0, 5
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    s_add_u32 s32, s1, s0
; GFX11-GISEL-NEXT:    scratch_store_b32 off, v0, s1 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_mov_b32 s32, s33
; GFX11-GISEL-NEXT:    s_mov_b32 s33, s4
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %alloca = alloca i32, i32 %idx, align 2, addrspace(5)
  store volatile i32 666, ptr addrspace(5) %alloca
  ret void
}

define void @test_dynamic_stackalloc_device_multiple_allocas(i32 %n, i32 %m) {
; GFX9-SDAG-LABEL: test_dynamic_stackalloc_device_multiple_allocas:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s13, s33
; GFX9-SDAG-NEXT:    s_add_i32 s33, s32, 0xfc0
; GFX9-SDAG-NEXT:    s_mov_b32 s14, s34
; GFX9-SDAG-NEXT:    s_mov_b32 s8, 0
; GFX9-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    s_and_b32 s33, s33, 0xfffff000
; GFX9-SDAG-NEXT:    s_mov_b32 s34, s32
; GFX9-SDAG-NEXT:    s_addk_i32 s32, 0x3000
; GFX9-SDAG-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-SDAG-NEXT:    s_cbranch_execz .LBB14_6
; GFX9-SDAG-NEXT:  ; %bb.1: ; %bb.0
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v1, v1, 2, 15
; GFX9-SDAG-NEXT:    v_and_b32_e32 v1, -16, v1
; GFX9-SDAG-NEXT:    s_mov_b64 s[6:7], exec
; GFX9-SDAG-NEXT:    s_mov_b32 s10, 0
; GFX9-SDAG-NEXT:  .LBB14_2: ; =>This Inner Loop Header: Depth=1
; GFX9-SDAG-NEXT:    s_ff1_i32_b64 s9, s[6:7]
; GFX9-SDAG-NEXT:    v_readlane_b32 s11, v1, s9
; GFX9-SDAG-NEXT:    s_bitset0_b64 s[6:7], s9
; GFX9-SDAG-NEXT:    s_max_u32 s10, s10, s11
; GFX9-SDAG-NEXT:    s_cmp_lg_u64 s[6:7], 0
; GFX9-SDAG-NEXT:    s_cbranch_scc1 .LBB14_2
; GFX9-SDAG-NEXT:  ; %bb.3:
; GFX9-SDAG-NEXT:    s_add_i32 s6, s32, 0xfff
; GFX9-SDAG-NEXT:    s_and_b32 s9, s6, 0xfffff000
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v1, s10, 6, v1
; GFX9-SDAG-NEXT:    v_readfirstlane_b32 s32, v1
; GFX9-SDAG-NEXT:    v_and_b32_e32 v1, 0x3ff, v31
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v1, v1, 2, 15
; GFX9-SDAG-NEXT:    v_and_b32_e32 v1, 0x1ff0, v1
; GFX9-SDAG-NEXT:    s_mov_b64 s[6:7], exec
; GFX9-SDAG-NEXT:    s_mov_b32 s10, 0
; GFX9-SDAG-NEXT:  .LBB14_4: ; =>This Inner Loop Header: Depth=1
; GFX9-SDAG-NEXT:    s_ff1_i32_b64 s11, s[6:7]
; GFX9-SDAG-NEXT:    v_readlane_b32 s12, v1, s11
; GFX9-SDAG-NEXT:    s_bitset0_b64 s[6:7], s11
; GFX9-SDAG-NEXT:    s_max_u32 s10, s10, s12
; GFX9-SDAG-NEXT:    s_cmp_lg_u64 s[6:7], 0
; GFX9-SDAG-NEXT:    s_cbranch_scc1 .LBB14_4
; GFX9-SDAG-NEXT:  ; %bb.5:
; GFX9-SDAG-NEXT:    s_mov_b32 s6, s32
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v1, s10, 6, v1
; GFX9-SDAG-NEXT:    v_readfirstlane_b32 s32, v1
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v1, 3
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v2, s9
; GFX9-SDAG-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v1, 4
; GFX9-SDAG-NEXT:    buffer_store_dword v1, off, s[0:3], s6
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:  .LBB14_6: ; %bb.1
; GFX9-SDAG-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v1, 2
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX9-SDAG-NEXT:    s_mov_b64 s[4:5], exec
; GFX9-SDAG-NEXT:  .LBB14_7: ; =>This Inner Loop Header: Depth=1
; GFX9-SDAG-NEXT:    s_ff1_i32_b64 s6, s[4:5]
; GFX9-SDAG-NEXT:    v_readlane_b32 s7, v0, s6
; GFX9-SDAG-NEXT:    s_bitset0_b64 s[4:5], s6
; GFX9-SDAG-NEXT:    s_max_u32 s8, s8, s7
; GFX9-SDAG-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX9-SDAG-NEXT:    s_cbranch_scc1 .LBB14_7
; GFX9-SDAG-NEXT:  ; %bb.8:
; GFX9-SDAG-NEXT:    s_mov_b32 s4, s32
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v0, s8, 6, v0
; GFX9-SDAG-NEXT:    v_readfirstlane_b32 s32, v0
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, 1
; GFX9-SDAG-NEXT:    buffer_store_dword v0, off, s[0:3], s33
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    buffer_store_dword v1, off, s[0:3], s4
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s32, s34
; GFX9-SDAG-NEXT:    s_mov_b32 s34, s14
; GFX9-SDAG-NEXT:    s_mov_b32 s33, s13
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_dynamic_stackalloc_device_multiple_allocas:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_mov_b32 s13, s33
; GFX9-GISEL-NEXT:    s_add_i32 s33, s32, 0xfc0
; GFX9-GISEL-NEXT:    s_mov_b32 s14, s34
; GFX9-GISEL-NEXT:    s_mov_b32 s8, 0
; GFX9-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    s_and_b32 s33, s33, 0xfffff000
; GFX9-GISEL-NEXT:    s_mov_b32 s34, s32
; GFX9-GISEL-NEXT:    s_addk_i32 s32, 0x3000
; GFX9-GISEL-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-GISEL-NEXT:    s_cbranch_execz .LBB14_6
; GFX9-GISEL-NEXT:  ; %bb.1: ; %bb.0
; GFX9-GISEL-NEXT:    v_lshl_add_u32 v1, v1, 2, 15
; GFX9-GISEL-NEXT:    v_and_b32_e32 v2, 0x3ff, v31
; GFX9-GISEL-NEXT:    v_and_b32_e32 v1, -16, v1
; GFX9-GISEL-NEXT:    s_mov_b64 s[6:7], exec
; GFX9-GISEL-NEXT:    s_mov_b32 s9, 0
; GFX9-GISEL-NEXT:  .LBB14_2: ; =>This Inner Loop Header: Depth=1
; GFX9-GISEL-NEXT:    s_ff1_i32_b64 s10, s[6:7]
; GFX9-GISEL-NEXT:    v_readlane_b32 s11, v1, s10
; GFX9-GISEL-NEXT:    s_bitset0_b64 s[6:7], s10
; GFX9-GISEL-NEXT:    s_max_u32 s9, s9, s11
; GFX9-GISEL-NEXT:    s_cmp_lg_u64 s[6:7], 0
; GFX9-GISEL-NEXT:    s_cbranch_scc1 .LBB14_2
; GFX9-GISEL-NEXT:  ; %bb.3:
; GFX9-GISEL-NEXT:    s_add_u32 s7, s32, 0xfff
; GFX9-GISEL-NEXT:    s_lshl_b32 s6, s9, 6
; GFX9-GISEL-NEXT:    s_and_b32 s9, s7, 0xfffff000
; GFX9-GISEL-NEXT:    v_lshl_add_u32 v1, v2, 2, 15
; GFX9-GISEL-NEXT:    s_add_u32 s32, s9, s6
; GFX9-GISEL-NEXT:    v_and_b32_e32 v1, -16, v1
; GFX9-GISEL-NEXT:    s_mov_b64 s[6:7], exec
; GFX9-GISEL-NEXT:    s_mov_b32 s10, 0
; GFX9-GISEL-NEXT:  .LBB14_4: ; =>This Inner Loop Header: Depth=1
; GFX9-GISEL-NEXT:    s_ff1_i32_b64 s11, s[6:7]
; GFX9-GISEL-NEXT:    v_readlane_b32 s12, v1, s11
; GFX9-GISEL-NEXT:    s_bitset0_b64 s[6:7], s11
; GFX9-GISEL-NEXT:    s_max_u32 s10, s10, s12
; GFX9-GISEL-NEXT:    s_cmp_lg_u64 s[6:7], 0
; GFX9-GISEL-NEXT:    s_cbranch_scc1 .LBB14_4
; GFX9-GISEL-NEXT:  ; %bb.5:
; GFX9-GISEL-NEXT:    s_mov_b32 s6, s32
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, 3
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, s9
; GFX9-GISEL-NEXT:    s_lshl_b32 s7, s10, 6
; GFX9-GISEL-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, 4
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-GISEL-NEXT:    s_add_u32 s32, s6, s7
; GFX9-GISEL-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:  .LBB14_6: ; %bb.1
; GFX9-GISEL-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-GISEL-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX9-GISEL-NEXT:    s_mov_b64 s[4:5], exec
; GFX9-GISEL-NEXT:  .LBB14_7: ; =>This Inner Loop Header: Depth=1
; GFX9-GISEL-NEXT:    s_ff1_i32_b64 s6, s[4:5]
; GFX9-GISEL-NEXT:    v_readlane_b32 s7, v0, s6
; GFX9-GISEL-NEXT:    s_bitset0_b64 s[4:5], s6
; GFX9-GISEL-NEXT:    s_max_u32 s8, s8, s7
; GFX9-GISEL-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX9-GISEL-NEXT:    s_cbranch_scc1 .LBB14_7
; GFX9-GISEL-NEXT:  ; %bb.8:
; GFX9-GISEL-NEXT:    s_mov_b32 s4, s32
; GFX9-GISEL-NEXT:    s_lshl_b32 s5, s8, 6
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, 1
; GFX9-GISEL-NEXT:    s_add_u32 s32, s4, s5
; GFX9-GISEL-NEXT:    buffer_store_dword v0, off, s[0:3], s33
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, 2
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-GISEL-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    s_mov_b32 s32, s34
; GFX9-GISEL-NEXT:    s_mov_b32 s34, s14
; GFX9-GISEL-NEXT:    s_mov_b32 s33, s13
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_dynamic_stackalloc_device_multiple_allocas:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_mov_b32 s7, s33
; GFX11-SDAG-NEXT:    s_add_i32 s33, s32, 63
; GFX11-SDAG-NEXT:    s_mov_b32 s8, s34
; GFX11-SDAG-NEXT:    s_mov_b32 s0, 0
; GFX11-SDAG-NEXT:    s_mov_b32 s1, exec_lo
; GFX11-SDAG-NEXT:    s_and_not1_b32 s33, s33, 63
; GFX11-SDAG-NEXT:    s_mov_b32 s34, s32
; GFX11-SDAG-NEXT:    s_addk_i32 s32, 0xc0
; GFX11-SDAG-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX11-SDAG-NEXT:    s_cbranch_execz .LBB14_6
; GFX11-SDAG-NEXT:  ; %bb.1: ; %bb.0
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v1, v1, 2, 15
; GFX11-SDAG-NEXT:    s_mov_b32 s2, exec_lo
; GFX11-SDAG-NEXT:    s_mov_b32 s3, 0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v1, -16, v1
; GFX11-SDAG-NEXT:  .LBB14_2: ; =>This Inner Loop Header: Depth=1
; GFX11-SDAG-NEXT:    s_ctz_i32_b32 s4, s2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-NEXT:    v_readlane_b32 s5, v1, s4
; GFX11-SDAG-NEXT:    s_bitset0_b32 s2, s4
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    s_max_u32 s3, s3, s5
; GFX11-SDAG-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-SDAG-NEXT:    s_cbranch_scc1 .LBB14_2
; GFX11-SDAG-NEXT:  ; %bb.3:
; GFX11-SDAG-NEXT:    v_and_b32_e32 v1, 0x3ff, v31
; GFX11-SDAG-NEXT:    s_add_i32 s2, s32, 0x7ff
; GFX11-SDAG-NEXT:    s_mov_b32 s4, exec_lo
; GFX11-SDAG-NEXT:    s_and_b32 s2, s2, 0xfffff800
; GFX11-SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v2, s3, 5, s2
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v1, v1, 2, 15
; GFX11-SDAG-NEXT:    s_mov_b32 s3, 0
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s32, v2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v1, 0x1ff0, v1
; GFX11-SDAG-NEXT:  .LBB14_4: ; =>This Inner Loop Header: Depth=1
; GFX11-SDAG-NEXT:    s_ctz_i32_b32 s5, s4
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-NEXT:    v_readlane_b32 s6, v1, s5
; GFX11-SDAG-NEXT:    s_bitset0_b32 s4, s5
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    s_max_u32 s3, s3, s6
; GFX11-SDAG-NEXT:    s_cmp_lg_u32 s4, 0
; GFX11-SDAG-NEXT:    s_cbranch_scc1 .LBB14_4
; GFX11-SDAG-NEXT:  ; %bb.5:
; GFX11-SDAG-NEXT:    s_mov_b32 s4, s32
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v2, 3 :: v_dual_mov_b32 v3, 4
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v1, s3, 5, s4
; GFX11-SDAG-NEXT:    scratch_store_b32 off, v2, s2 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    scratch_store_b32 off, v3, s4 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s32, v1
; GFX11-SDAG-NEXT:  .LBB14_6: ; %bb.1
; GFX11-SDAG-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v1, v0, 2, 15
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v0, 2
; GFX11-SDAG-NEXT:    s_mov_b32 s1, exec_lo
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v1, -16, v1
; GFX11-SDAG-NEXT:  .LBB14_7: ; =>This Inner Loop Header: Depth=1
; GFX11-SDAG-NEXT:    s_ctz_i32_b32 s2, s1
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-NEXT:    v_readlane_b32 s3, v1, s2
; GFX11-SDAG-NEXT:    s_bitset0_b32 s1, s2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    s_max_u32 s0, s0, s3
; GFX11-SDAG-NEXT:    s_cmp_lg_u32 s1, 0
; GFX11-SDAG-NEXT:    s_cbranch_scc1 .LBB14_7
; GFX11-SDAG-NEXT:  ; %bb.8:
; GFX11-SDAG-NEXT:    s_mov_b32 s1, s32
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v2, 1
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v1, s0, 5, s1
; GFX11-SDAG-NEXT:    scratch_store_b32 off, v2, s33 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    scratch_store_b32 off, v0, s1 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s32, v1
; GFX11-SDAG-NEXT:    s_mov_b32 s32, s34
; GFX11-SDAG-NEXT:    s_mov_b32 s34, s8
; GFX11-SDAG-NEXT:    s_mov_b32 s33, s7
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_dynamic_stackalloc_device_multiple_allocas:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_mov_b32 s7, s33
; GFX11-GISEL-NEXT:    s_add_i32 s33, s32, 63
; GFX11-GISEL-NEXT:    s_mov_b32 s8, s34
; GFX11-GISEL-NEXT:    s_mov_b32 s0, 0
; GFX11-GISEL-NEXT:    s_mov_b32 s1, exec_lo
; GFX11-GISEL-NEXT:    s_and_not1_b32 s33, s33, 63
; GFX11-GISEL-NEXT:    s_mov_b32 s34, s32
; GFX11-GISEL-NEXT:    s_addk_i32 s32, 0xc0
; GFX11-GISEL-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX11-GISEL-NEXT:    s_cbranch_execz .LBB14_6
; GFX11-GISEL-NEXT:  ; %bb.1: ; %bb.0
; GFX11-GISEL-NEXT:    v_lshl_add_u32 v2, v1, 2, 15
; GFX11-GISEL-NEXT:    v_and_b32_e32 v1, 0x3ff, v31
; GFX11-GISEL-NEXT:    s_mov_b32 s3, exec_lo
; GFX11-GISEL-NEXT:    s_mov_b32 s2, 0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v2, -16, v2
; GFX11-GISEL-NEXT:  .LBB14_2: ; =>This Inner Loop Header: Depth=1
; GFX11-GISEL-NEXT:    s_ctz_i32_b32 s4, s3
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_readlane_b32 s5, v2, s4
; GFX11-GISEL-NEXT:    s_bitset0_b32 s3, s4
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    s_max_u32 s2, s2, s5
; GFX11-GISEL-NEXT:    s_cmp_lg_u32 s3, 0
; GFX11-GISEL-NEXT:    s_cbranch_scc1 .LBB14_2
; GFX11-GISEL-NEXT:  ; %bb.3:
; GFX11-GISEL-NEXT:    v_lshl_add_u32 v1, v1, 2, 15
; GFX11-GISEL-NEXT:    s_lshl_b32 s5, s2, 5
; GFX11-GISEL-NEXT:    s_add_u32 s2, s32, 0x7ff
; GFX11-GISEL-NEXT:    s_mov_b32 s4, exec_lo
; GFX11-GISEL-NEXT:    s_and_b32 s2, s2, 0xfffff800
; GFX11-GISEL-NEXT:    v_and_b32_e32 v1, -16, v1
; GFX11-GISEL-NEXT:    s_mov_b32 s3, 0
; GFX11-GISEL-NEXT:    s_add_u32 s32, s2, s5
; GFX11-GISEL-NEXT:  .LBB14_4: ; =>This Inner Loop Header: Depth=1
; GFX11-GISEL-NEXT:    s_ctz_i32_b32 s5, s4
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_readlane_b32 s6, v1, s5
; GFX11-GISEL-NEXT:    s_bitset0_b32 s4, s5
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    s_max_u32 s3, s3, s6
; GFX11-GISEL-NEXT:    s_cmp_lg_u32 s4, 0
; GFX11-GISEL-NEXT:    s_cbranch_scc1 .LBB14_4
; GFX11-GISEL-NEXT:  ; %bb.5:
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v1, 3 :: v_dual_mov_b32 v2, 4
; GFX11-GISEL-NEXT:    s_mov_b32 s4, s32
; GFX11-GISEL-NEXT:    s_lshl_b32 s3, s3, 5
; GFX11-GISEL-NEXT:    scratch_store_b32 off, v1, s2 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b32 off, v2, s4 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_add_u32 s32, s4, s3
; GFX11-GISEL-NEXT:  .LBB14_6: ; %bb.1
; GFX11-GISEL-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-GISEL-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX11-GISEL-NEXT:    s_mov_b32 s1, exec_lo
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX11-GISEL-NEXT:  .LBB14_7: ; =>This Inner Loop Header: Depth=1
; GFX11-GISEL-NEXT:    s_ctz_i32_b32 s2, s1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_readlane_b32 s3, v0, s2
; GFX11-GISEL-NEXT:    s_bitset0_b32 s1, s2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    s_max_u32 s0, s0, s3
; GFX11-GISEL-NEXT:    s_cmp_lg_u32 s1, 0
; GFX11-GISEL-NEXT:    s_cbranch_scc1 .LBB14_7
; GFX11-GISEL-NEXT:  ; %bb.8:
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v0, 1 :: v_dual_mov_b32 v1, 2
; GFX11-GISEL-NEXT:    s_mov_b32 s1, s32
; GFX11-GISEL-NEXT:    s_lshl_b32 s0, s0, 5
; GFX11-GISEL-NEXT:    scratch_store_b32 off, v0, s33 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b32 off, v1, s1 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_add_u32 s32, s1, s0
; GFX11-GISEL-NEXT:    s_mov_b32 s32, s34
; GFX11-GISEL-NEXT:    s_mov_b32 s34, s8
; GFX11-GISEL-NEXT:    s_mov_b32 s33, s7
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %cond = icmp eq i32 %n, 0
  %alloca1 = alloca i32, i32 8, addrspace(5)
  %alloca2 = alloca i32, i32 %n, addrspace(5)
  br i1 %cond, label %bb.0, label %bb.1
bb.0:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %alloca3 = alloca i32, i32 %m, align 64, addrspace(5)
  %alloca4 = alloca i32, i32 %idx, align 4, addrspace(5)
  store volatile i32 3, ptr addrspace(5) %alloca3
  store volatile i32 4, ptr addrspace(5) %alloca4
  br label %bb.1
bb.1:
  store volatile i32 1, ptr addrspace(5) %alloca1
  store volatile i32 2, ptr addrspace(5) %alloca2
  ret void
}

define void @test_dynamic_stackalloc_device_control_flow(i32 %n, i32 %m) {
; GFX9-SDAG-LABEL: test_dynamic_stackalloc_device_control_flow:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s11, s33
; GFX9-SDAG-NEXT:    s_add_i32 s33, s32, 0xfc0
; GFX9-SDAG-NEXT:    s_mov_b32 s12, s34
; GFX9-SDAG-NEXT:    s_mov_b32 s8, 0
; GFX9-SDAG-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX9-SDAG-NEXT:    s_and_b32 s33, s33, 0xfffff000
; GFX9-SDAG-NEXT:    s_mov_b32 s34, s32
; GFX9-SDAG-NEXT:    s_addk_i32 s32, 0x2000
; GFX9-SDAG-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-SDAG-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-SDAG-NEXT:    s_cbranch_execz .LBB15_4
; GFX9-SDAG-NEXT:  ; %bb.1: ; %bb.1
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v1, v1, 2, 15
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, 2
; GFX9-SDAG-NEXT:    v_and_b32_e32 v1, -16, v1
; GFX9-SDAG-NEXT:    s_mov_b64 s[6:7], exec
; GFX9-SDAG-NEXT:  .LBB15_2: ; =>This Inner Loop Header: Depth=1
; GFX9-SDAG-NEXT:    s_ff1_i32_b64 s9, s[6:7]
; GFX9-SDAG-NEXT:    v_readlane_b32 s10, v1, s9
; GFX9-SDAG-NEXT:    s_bitset0_b64 s[6:7], s9
; GFX9-SDAG-NEXT:    s_max_u32 s8, s8, s10
; GFX9-SDAG-NEXT:    s_cmp_lg_u64 s[6:7], 0
; GFX9-SDAG-NEXT:    s_cbranch_scc1 .LBB15_2
; GFX9-SDAG-NEXT:  ; %bb.3:
; GFX9-SDAG-NEXT:    s_add_i32 s6, s32, 0xfff
; GFX9-SDAG-NEXT:    s_and_b32 s6, s6, 0xfffff000
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v2, s8, 6, v1
; GFX9-SDAG-NEXT:    v_readfirstlane_b32 s32, v2
; GFX9-SDAG-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    ; implicit-def: $vgpr31
; GFX9-SDAG-NEXT:  .LBB15_4: ; %Flow
; GFX9-SDAG-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-SDAG-NEXT:    s_cbranch_execz .LBB15_8
; GFX9-SDAG-NEXT:  ; %bb.5: ; %bb.0
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v31
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, 0x1ff0, v0
; GFX9-SDAG-NEXT:    s_mov_b64 s[6:7], exec
; GFX9-SDAG-NEXT:    s_mov_b32 s8, 0
; GFX9-SDAG-NEXT:  .LBB15_6: ; =>This Inner Loop Header: Depth=1
; GFX9-SDAG-NEXT:    s_ff1_i32_b64 s9, s[6:7]
; GFX9-SDAG-NEXT:    v_readlane_b32 s10, v0, s9
; GFX9-SDAG-NEXT:    s_bitset0_b64 s[6:7], s9
; GFX9-SDAG-NEXT:    s_max_u32 s8, s8, s10
; GFX9-SDAG-NEXT:    s_cmp_lg_u64 s[6:7], 0
; GFX9-SDAG-NEXT:    s_cbranch_scc1 .LBB15_6
; GFX9-SDAG-NEXT:  ; %bb.7:
; GFX9-SDAG-NEXT:    s_mov_b32 s6, s32
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v0, s8, 6, v0
; GFX9-SDAG-NEXT:    v_readfirstlane_b32 s32, v0
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, 1
; GFX9-SDAG-NEXT:    buffer_store_dword v0, off, s[0:3], s6
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:  .LBB15_8: ; %bb.2
; GFX9-SDAG-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-SDAG-NEXT:    s_mov_b32 s32, s34
; GFX9-SDAG-NEXT:    s_mov_b32 s34, s12
; GFX9-SDAG-NEXT:    s_mov_b32 s33, s11
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_dynamic_stackalloc_device_control_flow:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_mov_b32 s11, s33
; GFX9-GISEL-NEXT:    s_add_i32 s33, s32, 0xfc0
; GFX9-GISEL-NEXT:    s_mov_b32 s12, s34
; GFX9-GISEL-NEXT:    s_mov_b32 s8, 0
; GFX9-GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX9-GISEL-NEXT:    s_and_b32 s33, s33, 0xfffff000
; GFX9-GISEL-NEXT:    s_mov_b32 s34, s32
; GFX9-GISEL-NEXT:    s_addk_i32 s32, 0x2000
; GFX9-GISEL-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-GISEL-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-GISEL-NEXT:    s_cbranch_execz .LBB15_4
; GFX9-GISEL-NEXT:  ; %bb.1: ; %bb.1
; GFX9-GISEL-NEXT:    v_lshl_add_u32 v0, v1, 2, 15
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX9-GISEL-NEXT:    s_mov_b64 s[6:7], exec
; GFX9-GISEL-NEXT:  .LBB15_2: ; =>This Inner Loop Header: Depth=1
; GFX9-GISEL-NEXT:    s_ff1_i32_b64 s9, s[6:7]
; GFX9-GISEL-NEXT:    v_readlane_b32 s10, v0, s9
; GFX9-GISEL-NEXT:    s_bitset0_b64 s[6:7], s9
; GFX9-GISEL-NEXT:    s_max_u32 s8, s8, s10
; GFX9-GISEL-NEXT:    s_cmp_lg_u64 s[6:7], 0
; GFX9-GISEL-NEXT:    s_cbranch_scc1 .LBB15_2
; GFX9-GISEL-NEXT:  ; %bb.3:
; GFX9-GISEL-NEXT:    s_add_u32 s7, s32, 0xfff
; GFX9-GISEL-NEXT:    s_and_b32 s7, s7, 0xfffff000
; GFX9-GISEL-NEXT:    s_lshl_b32 s6, s8, 6
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, 2
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-GISEL-NEXT:    s_add_u32 s32, s7, s6
; GFX9-GISEL-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    ; implicit-def: $vgpr31
; GFX9-GISEL-NEXT:  .LBB15_4: ; %Flow
; GFX9-GISEL-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-GISEL-NEXT:    s_cbranch_execz .LBB15_8
; GFX9-GISEL-NEXT:  ; %bb.5: ; %bb.0
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v31
; GFX9-GISEL-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX9-GISEL-NEXT:    s_mov_b64 s[6:7], exec
; GFX9-GISEL-NEXT:    s_mov_b32 s8, 0
; GFX9-GISEL-NEXT:  .LBB15_6: ; =>This Inner Loop Header: Depth=1
; GFX9-GISEL-NEXT:    s_ff1_i32_b64 s9, s[6:7]
; GFX9-GISEL-NEXT:    v_readlane_b32 s10, v0, s9
; GFX9-GISEL-NEXT:    s_bitset0_b64 s[6:7], s9
; GFX9-GISEL-NEXT:    s_max_u32 s8, s8, s10
; GFX9-GISEL-NEXT:    s_cmp_lg_u64 s[6:7], 0
; GFX9-GISEL-NEXT:    s_cbranch_scc1 .LBB15_6
; GFX9-GISEL-NEXT:  ; %bb.7:
; GFX9-GISEL-NEXT:    s_mov_b32 s6, s32
; GFX9-GISEL-NEXT:    s_lshl_b32 s7, s8, 6
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, 1
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-GISEL-NEXT:    s_add_u32 s32, s6, s7
; GFX9-GISEL-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:  .LBB15_8: ; %bb.2
; GFX9-GISEL-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-GISEL-NEXT:    s_mov_b32 s32, s34
; GFX9-GISEL-NEXT:    s_mov_b32 s34, s12
; GFX9-GISEL-NEXT:    s_mov_b32 s33, s11
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_dynamic_stackalloc_device_control_flow:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_mov_b32 s5, s33
; GFX11-SDAG-NEXT:    s_add_i32 s33, s32, 63
; GFX11-SDAG-NEXT:    s_mov_b32 s6, s34
; GFX11-SDAG-NEXT:    s_mov_b32 s1, 0
; GFX11-SDAG-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-SDAG-NEXT:    s_and_not1_b32 s33, s33, 63
; GFX11-SDAG-NEXT:    s_mov_b32 s34, s32
; GFX11-SDAG-NEXT:    s_addk_i32 s32, 0x80
; GFX11-SDAG-NEXT:    v_cmpx_ne_u32_e32 0, v0
; GFX11-SDAG-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-SDAG-NEXT:    s_cbranch_execz .LBB15_4
; GFX11-SDAG-NEXT:  ; %bb.1: ; %bb.1
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v1, v1, 2, 15
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v0, 2
; GFX11-SDAG-NEXT:    s_mov_b32 s2, exec_lo
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v1, -16, v1
; GFX11-SDAG-NEXT:  .LBB15_2: ; =>This Inner Loop Header: Depth=1
; GFX11-SDAG-NEXT:    s_ctz_i32_b32 s3, s2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-NEXT:    v_readlane_b32 s4, v1, s3
; GFX11-SDAG-NEXT:    s_bitset0_b32 s2, s3
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    s_max_u32 s1, s1, s4
; GFX11-SDAG-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-SDAG-NEXT:    s_cbranch_scc1 .LBB15_2
; GFX11-SDAG-NEXT:  ; %bb.3:
; GFX11-SDAG-NEXT:    s_add_i32 s2, s32, 0x7ff
; GFX11-SDAG-NEXT:    ; implicit-def: $vgpr31
; GFX11-SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-NEXT:    s_and_b32 s2, s2, 0xfffff800
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v1, s1, 5, s2
; GFX11-SDAG-NEXT:    scratch_store_b32 off, v0, s2 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s32, v1
; GFX11-SDAG-NEXT:  .LBB15_4: ; %Flow
; GFX11-SDAG-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-SDAG-NEXT:    s_cbranch_execz .LBB15_8
; GFX11-SDAG-NEXT:  ; %bb.5: ; %bb.0
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v31
; GFX11-SDAG-NEXT:    s_mov_b32 s2, exec_lo
; GFX11-SDAG-NEXT:    s_mov_b32 s1, 0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, 0x1ff0, v0
; GFX11-SDAG-NEXT:  .LBB15_6: ; =>This Inner Loop Header: Depth=1
; GFX11-SDAG-NEXT:    s_ctz_i32_b32 s3, s2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-NEXT:    v_readlane_b32 s4, v0, s3
; GFX11-SDAG-NEXT:    s_bitset0_b32 s2, s3
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    s_max_u32 s1, s1, s4
; GFX11-SDAG-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-SDAG-NEXT:    s_cbranch_scc1 .LBB15_6
; GFX11-SDAG-NEXT:  ; %bb.7:
; GFX11-SDAG-NEXT:    s_mov_b32 s2, s32
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, 1
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v0, s1, 5, s2
; GFX11-SDAG-NEXT:    scratch_store_b32 off, v1, s2 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s32, v0
; GFX11-SDAG-NEXT:  .LBB15_8: ; %bb.2
; GFX11-SDAG-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-SDAG-NEXT:    s_mov_b32 s32, s34
; GFX11-SDAG-NEXT:    s_mov_b32 s34, s6
; GFX11-SDAG-NEXT:    s_mov_b32 s33, s5
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_dynamic_stackalloc_device_control_flow:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_mov_b32 s5, s33
; GFX11-GISEL-NEXT:    s_add_i32 s33, s32, 63
; GFX11-GISEL-NEXT:    s_mov_b32 s6, s34
; GFX11-GISEL-NEXT:    s_mov_b32 s1, 0
; GFX11-GISEL-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-GISEL-NEXT:    s_and_not1_b32 s33, s33, 63
; GFX11-GISEL-NEXT:    s_mov_b32 s34, s32
; GFX11-GISEL-NEXT:    s_addk_i32 s32, 0x80
; GFX11-GISEL-NEXT:    v_cmpx_ne_u32_e32 0, v0
; GFX11-GISEL-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-GISEL-NEXT:    s_cbranch_execz .LBB15_4
; GFX11-GISEL-NEXT:  ; %bb.1: ; %bb.1
; GFX11-GISEL-NEXT:    v_lshl_add_u32 v0, v1, 2, 15
; GFX11-GISEL-NEXT:    s_mov_b32 s2, exec_lo
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX11-GISEL-NEXT:  .LBB15_2: ; =>This Inner Loop Header: Depth=1
; GFX11-GISEL-NEXT:    s_ctz_i32_b32 s3, s2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_readlane_b32 s4, v0, s3
; GFX11-GISEL-NEXT:    s_bitset0_b32 s2, s3
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    s_max_u32 s1, s1, s4
; GFX11-GISEL-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-GISEL-NEXT:    s_cbranch_scc1 .LBB15_2
; GFX11-GISEL-NEXT:  ; %bb.3:
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v0, 2
; GFX11-GISEL-NEXT:    s_add_u32 s2, s32, 0x7ff
; GFX11-GISEL-NEXT:    s_lshl_b32 s1, s1, 5
; GFX11-GISEL-NEXT:    s_and_b32 s2, s2, 0xfffff800
; GFX11-GISEL-NEXT:    ; implicit-def: $vgpr31
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    s_add_u32 s32, s2, s1
; GFX11-GISEL-NEXT:    scratch_store_b32 off, v0, s2 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:  .LBB15_4: ; %Flow
; GFX11-GISEL-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-GISEL-NEXT:    s_cbranch_execz .LBB15_8
; GFX11-GISEL-NEXT:  ; %bb.5: ; %bb.0
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v31
; GFX11-GISEL-NEXT:    s_mov_b32 s2, exec_lo
; GFX11-GISEL-NEXT:    s_mov_b32 s1, 0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX11-GISEL-NEXT:  .LBB15_6: ; =>This Inner Loop Header: Depth=1
; GFX11-GISEL-NEXT:    s_ctz_i32_b32 s3, s2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_readlane_b32 s4, v0, s3
; GFX11-GISEL-NEXT:    s_bitset0_b32 s2, s3
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    s_max_u32 s1, s1, s4
; GFX11-GISEL-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-GISEL-NEXT:    s_cbranch_scc1 .LBB15_6
; GFX11-GISEL-NEXT:  ; %bb.7:
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v0, 1
; GFX11-GISEL-NEXT:    s_mov_b32 s2, s32
; GFX11-GISEL-NEXT:    s_lshl_b32 s1, s1, 5
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    s_add_u32 s32, s2, s1
; GFX11-GISEL-NEXT:    scratch_store_b32 off, v0, s2 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:  .LBB15_8: ; %bb.2
; GFX11-GISEL-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-GISEL-NEXT:    s_mov_b32 s32, s34
; GFX11-GISEL-NEXT:    s_mov_b32 s34, s6
; GFX11-GISEL-NEXT:    s_mov_b32 s33, s5
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %cond = icmp eq i32 %n, 0
  br i1 %cond, label %bb.0, label %bb.1
bb.0:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %alloca1 = alloca i32, i32 %idx, align 4, addrspace(5)
  store volatile i32 1, ptr addrspace(5) %alloca1
  br label %bb.2
bb.1:
  %alloca2 = alloca i32, i32 %m, align 64, addrspace(5)
  store volatile i32 2, ptr addrspace(5) %alloca2
  br label %bb.2
bb.2:
  ret void
}

define void @test_dynamic_stackalloc_device_divergent_non_standard_size_i16(i16 %n) {
; GFX9-SDAG-LABEL: test_dynamic_stackalloc_device_divergent_non_standard_size_i16:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX9-SDAG-NEXT:    s_mov_b32 s9, s33
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, 0x7fff0, v0
; GFX9-SDAG-NEXT:    s_mov_b64 s[4:5], exec
; GFX9-SDAG-NEXT:    s_mov_b32 s6, 0
; GFX9-SDAG-NEXT:    s_mov_b32 s33, s32
; GFX9-SDAG-NEXT:    s_addk_i32 s32, 0x400
; GFX9-SDAG-NEXT:  .LBB16_1: ; =>This Inner Loop Header: Depth=1
; GFX9-SDAG-NEXT:    s_ff1_i32_b64 s7, s[4:5]
; GFX9-SDAG-NEXT:    v_readlane_b32 s8, v0, s7
; GFX9-SDAG-NEXT:    s_bitset0_b64 s[4:5], s7
; GFX9-SDAG-NEXT:    s_max_u32 s6, s6, s8
; GFX9-SDAG-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX9-SDAG-NEXT:    s_cbranch_scc1 .LBB16_1
; GFX9-SDAG-NEXT:  ; %bb.2:
; GFX9-SDAG-NEXT:    s_mov_b32 s4, s32
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v0, s6, 6, v0
; GFX9-SDAG-NEXT:    v_readfirstlane_b32 s32, v0
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, 0x29a
; GFX9-SDAG-NEXT:    buffer_store_dword v0, off, s[0:3], s4
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s32, s33
; GFX9-SDAG-NEXT:    s_mov_b32 s33, s9
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_dynamic_stackalloc_device_divergent_non_standard_size_i16:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX9-GISEL-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX9-GISEL-NEXT:    s_mov_b32 s9, s33
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX9-GISEL-NEXT:    s_mov_b64 s[4:5], exec
; GFX9-GISEL-NEXT:    s_mov_b32 s6, 0
; GFX9-GISEL-NEXT:    s_mov_b32 s33, s32
; GFX9-GISEL-NEXT:    s_addk_i32 s32, 0x400
; GFX9-GISEL-NEXT:  .LBB16_1: ; =>This Inner Loop Header: Depth=1
; GFX9-GISEL-NEXT:    s_ff1_i32_b64 s7, s[4:5]
; GFX9-GISEL-NEXT:    v_readlane_b32 s8, v0, s7
; GFX9-GISEL-NEXT:    s_bitset0_b64 s[4:5], s7
; GFX9-GISEL-NEXT:    s_max_u32 s6, s6, s8
; GFX9-GISEL-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX9-GISEL-NEXT:    s_cbranch_scc1 .LBB16_1
; GFX9-GISEL-NEXT:  ; %bb.2:
; GFX9-GISEL-NEXT:    s_mov_b32 s4, s32
; GFX9-GISEL-NEXT:    s_lshl_b32 s5, s6, 6
; GFX9-GISEL-NEXT:    s_add_u32 s32, s4, s5
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, 0x29a
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-GISEL-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    s_mov_b32 s32, s33
; GFX9-GISEL-NEXT:    s_mov_b32 s33, s9
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_dynamic_stackalloc_device_divergent_non_standard_size_i16:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-SDAG-NEXT:    s_mov_b32 s4, s33
; GFX11-SDAG-NEXT:    s_mov_b32 s1, exec_lo
; GFX11-SDAG-NEXT:    s_mov_b32 s0, 0
; GFX11-SDAG-NEXT:    s_mov_b32 s33, s32
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX11-SDAG-NEXT:    s_add_i32 s32, s32, 16
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, 0x7fff0, v0
; GFX11-SDAG-NEXT:  .LBB16_1: ; =>This Inner Loop Header: Depth=1
; GFX11-SDAG-NEXT:    s_ctz_i32_b32 s2, s1
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-NEXT:    v_readlane_b32 s3, v0, s2
; GFX11-SDAG-NEXT:    s_bitset0_b32 s1, s2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    s_max_u32 s0, s0, s3
; GFX11-SDAG-NEXT:    s_cmp_lg_u32 s1, 0
; GFX11-SDAG-NEXT:    s_cbranch_scc1 .LBB16_1
; GFX11-SDAG-NEXT:  ; %bb.2:
; GFX11-SDAG-NEXT:    s_mov_b32 s1, s32
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, 0x29a
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v0, s0, 5, s1
; GFX11-SDAG-NEXT:    scratch_store_b32 off, v1, s1 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s32, v0
; GFX11-SDAG-NEXT:    s_mov_b32 s32, s33
; GFX11-SDAG-NEXT:    s_mov_b32 s33, s4
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_dynamic_stackalloc_device_divergent_non_standard_size_i16:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-GISEL-NEXT:    s_mov_b32 s4, s33
; GFX11-GISEL-NEXT:    s_mov_b32 s1, exec_lo
; GFX11-GISEL-NEXT:    s_mov_b32 s0, 0
; GFX11-GISEL-NEXT:    s_mov_b32 s33, s32
; GFX11-GISEL-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX11-GISEL-NEXT:    s_add_i32 s32, s32, 16
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX11-GISEL-NEXT:  .LBB16_1: ; =>This Inner Loop Header: Depth=1
; GFX11-GISEL-NEXT:    s_ctz_i32_b32 s2, s1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_readlane_b32 s3, v0, s2
; GFX11-GISEL-NEXT:    s_bitset0_b32 s1, s2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    s_max_u32 s0, s0, s3
; GFX11-GISEL-NEXT:    s_cmp_lg_u32 s1, 0
; GFX11-GISEL-NEXT:    s_cbranch_scc1 .LBB16_1
; GFX11-GISEL-NEXT:  ; %bb.2:
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v0, 0x29a
; GFX11-GISEL-NEXT:    s_mov_b32 s1, s32
; GFX11-GISEL-NEXT:    s_lshl_b32 s0, s0, 5
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    s_add_u32 s32, s1, s0
; GFX11-GISEL-NEXT:    scratch_store_b32 off, v0, s1 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_mov_b32 s32, s33
; GFX11-GISEL-NEXT:    s_mov_b32 s33, s4
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %alloca = alloca i32, i16 %n, align 2, addrspace(5)
  store volatile i32 666, ptr addrspace(5) %alloca
  ret void
}

define void @test_dynamic_stackalloc_device_divergent_non_standard_size_i64(i64 %n) {
; GFX9-SDAG-LABEL: test_dynamic_stackalloc_device_divergent_non_standard_size_i64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX9-SDAG-NEXT:    s_mov_b32 s9, s33
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX9-SDAG-NEXT:    s_mov_b64 s[4:5], exec
; GFX9-SDAG-NEXT:    s_mov_b32 s6, 0
; GFX9-SDAG-NEXT:    s_mov_b32 s33, s32
; GFX9-SDAG-NEXT:    s_addk_i32 s32, 0x400
; GFX9-SDAG-NEXT:  .LBB17_1: ; =>This Inner Loop Header: Depth=1
; GFX9-SDAG-NEXT:    s_ff1_i32_b64 s7, s[4:5]
; GFX9-SDAG-NEXT:    v_readlane_b32 s8, v0, s7
; GFX9-SDAG-NEXT:    s_bitset0_b64 s[4:5], s7
; GFX9-SDAG-NEXT:    s_max_u32 s6, s6, s8
; GFX9-SDAG-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX9-SDAG-NEXT:    s_cbranch_scc1 .LBB17_1
; GFX9-SDAG-NEXT:  ; %bb.2:
; GFX9-SDAG-NEXT:    s_mov_b32 s4, s32
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-SDAG-NEXT:    v_lshl_add_u32 v0, s6, 6, v0
; GFX9-SDAG-NEXT:    v_readfirstlane_b32 s32, v0
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, 0x29a
; GFX9-SDAG-NEXT:    buffer_store_dword v0, off, s[0:3], s4
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s32, s33
; GFX9-SDAG-NEXT:    s_mov_b32 s33, s9
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_dynamic_stackalloc_device_divergent_non_standard_size_i64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX9-GISEL-NEXT:    s_mov_b32 s9, s33
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX9-GISEL-NEXT:    s_mov_b64 s[4:5], exec
; GFX9-GISEL-NEXT:    s_mov_b32 s6, 0
; GFX9-GISEL-NEXT:    s_mov_b32 s33, s32
; GFX9-GISEL-NEXT:    s_addk_i32 s32, 0x400
; GFX9-GISEL-NEXT:  .LBB17_1: ; =>This Inner Loop Header: Depth=1
; GFX9-GISEL-NEXT:    s_ff1_i32_b64 s7, s[4:5]
; GFX9-GISEL-NEXT:    v_readlane_b32 s8, v0, s7
; GFX9-GISEL-NEXT:    s_bitset0_b64 s[4:5], s7
; GFX9-GISEL-NEXT:    s_max_u32 s6, s6, s8
; GFX9-GISEL-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX9-GISEL-NEXT:    s_cbranch_scc1 .LBB17_1
; GFX9-GISEL-NEXT:  ; %bb.2:
; GFX9-GISEL-NEXT:    s_mov_b32 s4, s32
; GFX9-GISEL-NEXT:    s_lshl_b32 s5, s6, 6
; GFX9-GISEL-NEXT:    s_add_u32 s32, s4, s5
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, 0x29a
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-GISEL-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 offen
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    s_mov_b32 s32, s33
; GFX9-GISEL-NEXT:    s_mov_b32 s33, s9
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_dynamic_stackalloc_device_divergent_non_standard_size_i64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX11-SDAG-NEXT:    s_mov_b32 s4, s33
; GFX11-SDAG-NEXT:    s_mov_b32 s1, exec_lo
; GFX11-SDAG-NEXT:    s_mov_b32 s0, 0
; GFX11-SDAG-NEXT:    s_mov_b32 s33, s32
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX11-SDAG-NEXT:    s_add_i32 s32, s32, 16
; GFX11-SDAG-NEXT:  .LBB17_1: ; =>This Inner Loop Header: Depth=1
; GFX11-SDAG-NEXT:    s_ctz_i32_b32 s2, s1
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-NEXT:    v_readlane_b32 s3, v0, s2
; GFX11-SDAG-NEXT:    s_bitset0_b32 s1, s2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    s_max_u32 s0, s0, s3
; GFX11-SDAG-NEXT:    s_cmp_lg_u32 s1, 0
; GFX11-SDAG-NEXT:    s_cbranch_scc1 .LBB17_1
; GFX11-SDAG-NEXT:  ; %bb.2:
; GFX11-SDAG-NEXT:    s_mov_b32 s1, s32
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, 0x29a
; GFX11-SDAG-NEXT:    v_lshl_add_u32 v0, s0, 5, s1
; GFX11-SDAG-NEXT:    scratch_store_b32 off, v1, s1 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s32, v0
; GFX11-SDAG-NEXT:    s_mov_b32 s32, s33
; GFX11-SDAG-NEXT:    s_mov_b32 s33, s4
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_dynamic_stackalloc_device_divergent_non_standard_size_i64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_lshl_add_u32 v0, v0, 2, 15
; GFX11-GISEL-NEXT:    s_mov_b32 s4, s33
; GFX11-GISEL-NEXT:    s_mov_b32 s1, exec_lo
; GFX11-GISEL-NEXT:    s_mov_b32 s0, 0
; GFX11-GISEL-NEXT:    s_mov_b32 s33, s32
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, -16, v0
; GFX11-GISEL-NEXT:    s_add_i32 s32, s32, 16
; GFX11-GISEL-NEXT:  .LBB17_1: ; =>This Inner Loop Header: Depth=1
; GFX11-GISEL-NEXT:    s_ctz_i32_b32 s2, s1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_readlane_b32 s3, v0, s2
; GFX11-GISEL-NEXT:    s_bitset0_b32 s1, s2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    s_max_u32 s0, s0, s3
; GFX11-GISEL-NEXT:    s_cmp_lg_u32 s1, 0
; GFX11-GISEL-NEXT:    s_cbranch_scc1 .LBB17_1
; GFX11-GISEL-NEXT:  ; %bb.2:
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v0, 0x29a
; GFX11-GISEL-NEXT:    s_mov_b32 s1, s32
; GFX11-GISEL-NEXT:    s_lshl_b32 s0, s0, 5
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    s_add_u32 s32, s1, s0
; GFX11-GISEL-NEXT:    scratch_store_b32 off, v0, s1 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_mov_b32 s32, s33
; GFX11-GISEL-NEXT:    s_mov_b32 s33, s4
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %alloca = alloca i32, i64 %n, align 2, addrspace(5)
  store volatile i32 666, ptr addrspace(5) %alloca
  ret void
}
