; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -stop-after=amdgpu-isel < %s | FileCheck -enable-var-scope -check-prefixes=GCN-ISEL                %s
; RUN: llc -mtriple=amdgcn -stop-after=amdgpu-isel -enable-new-pm < %s | FileCheck -enable-var-scope -check-prefixes=GCN-ISEL                %s

; RUN: llc -mtriple=amdgcn -mcpu=verde   -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=CISI    %s
; RUN: llc -mtriple=amdgcn -mcpu=fiji    -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=VI      %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900  -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX9    %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX1010 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1030 -mattr=+wavefrontsize32 -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX1030W32 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1030 -mattr=+wavefrontsize64 -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX1030W64 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX11 %s

; GCN-ISEL-LABEL: name:   sadd64rr
; GCN-ISEL-LABEL: body:
; GCN-ISEL-LABEL: bb.0.entry:
; GCN-ISEL: S_ADD_U64_PSEUDO

define amdgpu_kernel void @sadd64rr(ptr addrspace(1) %out, i64 %a, i64 %b) {
; CISI-LABEL: sadd64rr:
; CISI:       ; %bb.0: ; %entry
; CISI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; CISI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0xd
; CISI-NEXT:    s_mov_b32 s7, 0xf000
; CISI-NEXT:    s_mov_b32 s6, -1
; CISI-NEXT:    s_waitcnt lgkmcnt(0)
; CISI-NEXT:    s_mov_b32 s4, s0
; CISI-NEXT:    s_add_u32 s0, s2, s8
; CISI-NEXT:    s_mov_b32 s5, s1
; CISI-NEXT:    s_addc_u32 s1, s3, s9
; CISI-NEXT:    v_mov_b32_e32 v0, s0
; CISI-NEXT:    v_mov_b32_e32 v1, s1
; CISI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; CISI-NEXT:    s_endpgm
;
; VI-LABEL: sadd64rr:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    s_add_u32 s0, s2, s4
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_addc_u32 s1, s3, s5
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: sadd64rr:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_add_u32 s2, s2, s6
; GFX9-NEXT:    s_addc_u32 s3, s3, s7
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX1010-LABEL: sadd64rr:
; GFX1010:       ; %bb.0: ; %entry
; GFX1010-NEXT:    s_clause 0x1
; GFX1010-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1010-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX1010-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-NEXT:    s_add_u32 s2, s2, s6
; GFX1010-NEXT:    s_addc_u32 s3, s3, s7
; GFX1010-NEXT:    v_mov_b32_e32 v0, s2
; GFX1010-NEXT:    v_mov_b32_e32 v1, s3
; GFX1010-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1010-NEXT:    s_endpgm
;
; GFX1030W32-LABEL: sadd64rr:
; GFX1030W32:       ; %bb.0: ; %entry
; GFX1030W32-NEXT:    s_clause 0x1
; GFX1030W32-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1030W32-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX1030W32-NEXT:    v_mov_b32_e32 v2, 0
; GFX1030W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W32-NEXT:    s_add_u32 s2, s2, s4
; GFX1030W32-NEXT:    s_addc_u32 s3, s3, s5
; GFX1030W32-NEXT:    v_mov_b32_e32 v0, s2
; GFX1030W32-NEXT:    v_mov_b32_e32 v1, s3
; GFX1030W32-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1030W32-NEXT:    s_endpgm
;
; GFX1030W64-LABEL: sadd64rr:
; GFX1030W64:       ; %bb.0: ; %entry
; GFX1030W64-NEXT:    s_clause 0x1
; GFX1030W64-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1030W64-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX1030W64-NEXT:    v_mov_b32_e32 v2, 0
; GFX1030W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W64-NEXT:    s_add_u32 s2, s2, s4
; GFX1030W64-NEXT:    s_addc_u32 s3, s3, s5
; GFX1030W64-NEXT:    v_mov_b32_e32 v0, s2
; GFX1030W64-NEXT:    v_mov_b32_e32 v1, s3
; GFX1030W64-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1030W64-NEXT:    s_endpgm
;
; GFX11-LABEL: sadd64rr:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_add_u32 s2, s2, s4
; GFX11-NEXT:    s_addc_u32 s3, s3, s5
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
entry:
  %add = add i64 %a, %b
  store i64 %add, ptr addrspace(1) %out
  ret void
}

; GCN-ISEL-LABEL: name:   sadd64ri
; GCN-ISEL-LABEL: body:
; GCN-ISEL-LABEL: bb.0.entry:
; GCN-ISEL: S_ADD_U64_PSEUDO

define amdgpu_kernel void @sadd64ri(ptr addrspace(1) %out, i64 %a) {
; CISI-LABEL: sadd64ri:
; CISI:       ; %bb.0: ; %entry
; CISI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; CISI-NEXT:    s_mov_b32 s7, 0xf000
; CISI-NEXT:    s_mov_b32 s6, -1
; CISI-NEXT:    s_waitcnt lgkmcnt(0)
; CISI-NEXT:    s_mov_b32 s4, s0
; CISI-NEXT:    s_add_u32 s0, s2, 0x56789876
; CISI-NEXT:    s_mov_b32 s5, s1
; CISI-NEXT:    s_addc_u32 s1, s3, 0x1234
; CISI-NEXT:    v_mov_b32_e32 v0, s0
; CISI-NEXT:    v_mov_b32_e32 v1, s1
; CISI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; CISI-NEXT:    s_endpgm
;
; VI-LABEL: sadd64ri:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    s_add_u32 s0, s2, 0x56789876
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_addc_u32 s1, s3, 0x1234
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: sadd64ri:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_add_u32 s2, s2, 0x56789876
; GFX9-NEXT:    s_addc_u32 s3, s3, 0x1234
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX1010-LABEL: sadd64ri:
; GFX1010:       ; %bb.0: ; %entry
; GFX1010-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1010-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-NEXT:    s_add_u32 s2, s2, 0x56789876
; GFX1010-NEXT:    s_addc_u32 s3, s3, 0x1234
; GFX1010-NEXT:    v_mov_b32_e32 v0, s2
; GFX1010-NEXT:    v_mov_b32_e32 v1, s3
; GFX1010-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1010-NEXT:    s_endpgm
;
; GFX1030W32-LABEL: sadd64ri:
; GFX1030W32:       ; %bb.0: ; %entry
; GFX1030W32-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1030W32-NEXT:    v_mov_b32_e32 v2, 0
; GFX1030W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W32-NEXT:    s_add_u32 s2, s2, 0x56789876
; GFX1030W32-NEXT:    s_addc_u32 s3, s3, 0x1234
; GFX1030W32-NEXT:    v_mov_b32_e32 v0, s2
; GFX1030W32-NEXT:    v_mov_b32_e32 v1, s3
; GFX1030W32-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1030W32-NEXT:    s_endpgm
;
; GFX1030W64-LABEL: sadd64ri:
; GFX1030W64:       ; %bb.0: ; %entry
; GFX1030W64-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1030W64-NEXT:    v_mov_b32_e32 v2, 0
; GFX1030W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W64-NEXT:    s_add_u32 s2, s2, 0x56789876
; GFX1030W64-NEXT:    s_addc_u32 s3, s3, 0x1234
; GFX1030W64-NEXT:    v_mov_b32_e32 v0, s2
; GFX1030W64-NEXT:    v_mov_b32_e32 v1, s3
; GFX1030W64-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1030W64-NEXT:    s_endpgm
;
; GFX11-LABEL: sadd64ri:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_add_u32 s2, s2, 0x56789876
; GFX11-NEXT:    s_addc_u32 s3, s3, 0x1234
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
entry:
  %add = add i64 20015998343286, %a
  store i64 %add, ptr addrspace(1) %out
  ret void
}

; GCN-ISEL-LABEL: name:   vadd64rr
; GCN-ISEL-LABEL: body:
; GCN-ISEL-LABEL: bb.0.entry:
; GCN-ISEL: V_ADD_U64_PSEUDO

define amdgpu_kernel void @vadd64rr(ptr addrspace(1) %out, i64 %a) {
; CISI-LABEL: vadd64rr:
; CISI:       ; %bb.0: ; %entry
; CISI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; CISI-NEXT:    s_mov_b32 s7, 0xf000
; CISI-NEXT:    s_mov_b32 s6, -1
; CISI-NEXT:    s_waitcnt lgkmcnt(0)
; CISI-NEXT:    v_mov_b32_e32 v1, s3
; CISI-NEXT:    v_add_i32_e32 v0, vcc, s2, v0
; CISI-NEXT:    s_mov_b32 s4, s0
; CISI-NEXT:    s_mov_b32 s5, s1
; CISI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CISI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; CISI-NEXT:    s_endpgm
;
; VI-LABEL: vadd64rr:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v4, s3
; VI-NEXT:    v_add_u32_e32 v3, vcc, s2, v0
; VI-NEXT:    v_mov_b32_e32 v1, s0
; VI-NEXT:    v_mov_b32_e32 v2, s1
; VI-NEXT:    v_addc_u32_e32 v4, vcc, 0, v4, vcc
; VI-NEXT:    flat_store_dwordx2 v[1:2], v[3:4]
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: vadd64rr:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, s2, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX1010-LABEL: vadd64rr:
; GFX1010:       ; %bb.0: ; %entry
; GFX1010-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1010-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-NEXT:    v_add_co_u32 v0, s2, s2, v0
; GFX1010-NEXT:    v_add_co_ci_u32_e64 v1, s2, s3, 0, s2
; GFX1010-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1010-NEXT:    s_endpgm
;
; GFX1030W32-LABEL: vadd64rr:
; GFX1030W32:       ; %bb.0: ; %entry
; GFX1030W32-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1030W32-NEXT:    v_mov_b32_e32 v2, 0
; GFX1030W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W32-NEXT:    v_add_co_u32 v0, s2, s2, v0
; GFX1030W32-NEXT:    v_add_co_ci_u32_e64 v1, null, s3, 0, s2
; GFX1030W32-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1030W32-NEXT:    s_endpgm
;
; GFX1030W64-LABEL: vadd64rr:
; GFX1030W64:       ; %bb.0: ; %entry
; GFX1030W64-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1030W64-NEXT:    v_mov_b32_e32 v2, 0
; GFX1030W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W64-NEXT:    v_add_co_u32 v0, s[4:5], s2, v0
; GFX1030W64-NEXT:    v_add_co_ci_u32_e64 v1, null, s3, 0, s[4:5]
; GFX1030W64-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1030W64-NEXT:    s_endpgm
;
; GFX11-LABEL: vadd64rr:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_u32 v0, s2, s2, v0
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, s3, 0, s2
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
entry:
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %add = add i64 %a, %tid.ext
  store i64 %add, ptr addrspace(1) %out
  ret void
}

; GCN-ISEL-LABEL: name:   vadd64ri
; GCN-ISEL-LABEL: body:
; GCN-ISEL-LABEL: bb.0.entry:
; GCN-ISEL: V_ADD_U64_PSEUDO

define amdgpu_kernel void @vadd64ri(ptr addrspace(1) %out) {
; CISI-LABEL: vadd64ri:
; CISI:       ; %bb.0: ; %entry
; CISI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; CISI-NEXT:    v_add_i32_e32 v0, vcc, 0x56789876, v0
; CISI-NEXT:    v_mov_b32_e32 v1, 0x1234
; CISI-NEXT:    s_mov_b32 s3, 0xf000
; CISI-NEXT:    s_mov_b32 s2, -1
; CISI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CISI-NEXT:    s_waitcnt lgkmcnt(0)
; CISI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; CISI-NEXT:    s_endpgm
;
; VI-LABEL: vadd64ri:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x56789876, v0
; VI-NEXT:    v_mov_b32_e32 v1, 0x1234
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: vadd64ri:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0x56789876, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x1234
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX1010-LABEL: vadd64ri:
; GFX1010:       ; %bb.0: ; %entry
; GFX1010-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1010-NEXT:    v_add_co_u32 v0, s2, 0x56789876, v0
; GFX1010-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-NEXT:    v_add_co_ci_u32_e64 v1, s2, 0x1234, 0, s2
; GFX1010-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1010-NEXT:    s_endpgm
;
; GFX1030W32-LABEL: vadd64ri:
; GFX1030W32:       ; %bb.0: ; %entry
; GFX1030W32-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1030W32-NEXT:    v_add_co_u32 v0, s2, 0x56789876, v0
; GFX1030W32-NEXT:    v_mov_b32_e32 v2, 0
; GFX1030W32-NEXT:    v_add_co_ci_u32_e64 v1, null, 0x1234, 0, s2
; GFX1030W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W32-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1030W32-NEXT:    s_endpgm
;
; GFX1030W64-LABEL: vadd64ri:
; GFX1030W64:       ; %bb.0: ; %entry
; GFX1030W64-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1030W64-NEXT:    v_add_co_u32 v0, s[2:3], 0x56789876, v0
; GFX1030W64-NEXT:    v_mov_b32_e32 v2, 0
; GFX1030W64-NEXT:    v_add_co_ci_u32_e64 v1, null, 0x1234, 0, s[2:3]
; GFX1030W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W64-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1030W64-NEXT:    s_endpgm
;
; GFX11-LABEL: vadd64ri:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_u32 v0, s2, 0x56789876, v0
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, 0x1234, 0, s2
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
entry:
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %add = add i64 20015998343286, %tid.ext
  store i64 %add, ptr addrspace(1) %out
  ret void
}

; GCN-ISEL-LABEL: name:   suaddo32
; GCN-ISEL-LABEL: body:
; GCN-ISEL-LABEL: bb.0
; GCN-ISEL: S_ADD_I32
define amdgpu_kernel void @suaddo32(ptr addrspace(1) %out, ptr addrspace(1) %carryout, i32 %a, i32 %b) #0 {
; CISI-LABEL: suaddo32:
; CISI:       ; %bb.0:
; CISI-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0xd
; CISI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; CISI-NEXT:    s_mov_b32 s3, 0xf000
; CISI-NEXT:    s_mov_b32 s2, -1
; CISI-NEXT:    s_waitcnt lgkmcnt(0)
; CISI-NEXT:    s_add_i32 s4, s6, s7
; CISI-NEXT:    v_mov_b32_e32 v0, s4
; CISI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; CISI-NEXT:    s_endpgm
;
; VI-LABEL: suaddo32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x34
; VI-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_add_i32 s0, s0, s1
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: suaddo32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x34
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_add_i32 s0, s0, s1
; GFX9-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX1010-LABEL: suaddo32:
; GFX1010:       ; %bb.0:
; GFX1010-NEXT:    s_clause 0x1
; GFX1010-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x34
; GFX1010-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x24
; GFX1010-NEXT:    v_mov_b32_e32 v0, 0
; GFX1010-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-NEXT:    s_add_i32 s0, s0, s1
; GFX1010-NEXT:    v_mov_b32_e32 v1, s0
; GFX1010-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX1010-NEXT:    s_endpgm
;
; GFX1030W32-LABEL: suaddo32:
; GFX1030W32:       ; %bb.0:
; GFX1030W32-NEXT:    s_clause 0x1
; GFX1030W32-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x34
; GFX1030W32-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x24
; GFX1030W32-NEXT:    v_mov_b32_e32 v0, 0
; GFX1030W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W32-NEXT:    s_add_i32 s0, s0, s1
; GFX1030W32-NEXT:    v_mov_b32_e32 v1, s0
; GFX1030W32-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX1030W32-NEXT:    s_endpgm
;
; GFX1030W64-LABEL: suaddo32:
; GFX1030W64:       ; %bb.0:
; GFX1030W64-NEXT:    s_clause 0x1
; GFX1030W64-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x34
; GFX1030W64-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x24
; GFX1030W64-NEXT:    v_mov_b32_e32 v0, 0
; GFX1030W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W64-NEXT:    s_add_i32 s0, s0, s1
; GFX1030W64-NEXT:    v_mov_b32_e32 v1, s0
; GFX1030W64-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX1030W64-NEXT:    s_endpgm
;
; GFX11-LABEL: suaddo32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x34
; GFX11-NEXT:    s_load_b64 s[2:3], s[4:5], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_add_i32 s0, s0, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s0
; GFX11-NEXT:    global_store_b32 v0, v1, s[2:3]
; GFX11-NEXT:    s_endpgm
  %uadd = call { i32, i1 } @llvm.uadd.with.overflow.i32(i32 %a, i32 %b)
  %val = extractvalue { i32, i1 } %uadd, 0
  %carry = extractvalue { i32, i1 } %uadd, 1
  store i32 %val, ptr addrspace(1) %out, align 4
  ret void
}


; GCN-ISEL-LABEL: name:   uaddo32_vcc_user
; GCN-ISEL-LABEL: body:
; GCN-ISEL-LABEL: bb.0
; GCN-ISEL: V_ADD_CO_U32_e64

; below we check selection to v_add/addc
; because the only user of VCC produced by the UADDOis v_cndmask.
; We select to VALU form to avoid unnecessary s_cselect to copy SCC to VCC

define amdgpu_kernel void @uaddo32_vcc_user(ptr addrspace(1) %out, ptr addrspace(1) %carryout, i32 %a, i32 %b) #0 {
; CISI-LABEL: uaddo32_vcc_user:
; CISI:       ; %bb.0:
; CISI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; CISI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0xd
; CISI-NEXT:    s_mov_b32 s7, 0xf000
; CISI-NEXT:    s_mov_b32 s6, -1
; CISI-NEXT:    s_waitcnt lgkmcnt(0)
; CISI-NEXT:    s_mov_b32 s4, s0
; CISI-NEXT:    v_mov_b32_e32 v0, s9
; CISI-NEXT:    s_mov_b32 s5, s1
; CISI-NEXT:    v_add_i32_e32 v0, vcc, s8, v0
; CISI-NEXT:    s_mov_b32 s0, s2
; CISI-NEXT:    s_mov_b32 s1, s3
; CISI-NEXT:    s_mov_b32 s2, s6
; CISI-NEXT:    s_mov_b32 s3, s7
; CISI-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; CISI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; CISI-NEXT:    buffer_store_byte v1, off, s[0:3], 0
; CISI-NEXT:    s_endpgm
;
; VI-LABEL: uaddo32_vcc_user:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v4, s5
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_add_u32_e32 v4, vcc, s4, v4
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    v_cndmask_b32_e64 v5, 0, 1, vcc
; VI-NEXT:    flat_store_dword v[0:1], v4
; VI-NEXT:    flat_store_byte v[2:3], v5
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: uaddo32_vcc_user:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    v_add_co_u32_e32 v1, vcc, s6, v1
; GFX9-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    global_store_byte v0, v2, s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX1010-LABEL: uaddo32_vcc_user:
; GFX1010:       ; %bb.0:
; GFX1010-NEXT:    s_clause 0x1
; GFX1010-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX1010-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1010-NEXT:    v_mov_b32_e32 v0, 0
; GFX1010-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-NEXT:    v_add_co_u32 v1, s4, s6, s7
; GFX1010-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s4
; GFX1010-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX1010-NEXT:    global_store_byte v0, v2, s[2:3]
; GFX1010-NEXT:    s_endpgm
;
; GFX1030W32-LABEL: uaddo32_vcc_user:
; GFX1030W32:       ; %bb.0:
; GFX1030W32-NEXT:    s_clause 0x1
; GFX1030W32-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX1030W32-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1030W32-NEXT:    v_mov_b32_e32 v0, 0
; GFX1030W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W32-NEXT:    v_add_co_u32 v1, s4, s6, s7
; GFX1030W32-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s4
; GFX1030W32-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX1030W32-NEXT:    global_store_byte v0, v2, s[2:3]
; GFX1030W32-NEXT:    s_endpgm
;
; GFX1030W64-LABEL: uaddo32_vcc_user:
; GFX1030W64:       ; %bb.0:
; GFX1030W64-NEXT:    s_clause 0x1
; GFX1030W64-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX1030W64-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1030W64-NEXT:    v_mov_b32_e32 v0, 0
; GFX1030W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W64-NEXT:    v_add_co_u32 v1, s[4:5], s6, s7
; GFX1030W64-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s[4:5]
; GFX1030W64-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX1030W64-NEXT:    global_store_byte v0, v2, s[2:3]
; GFX1030W64-NEXT:    s_endpgm
;
; GFX11-LABEL: uaddo32_vcc_user:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v1, s4, s6, s7
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s4
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    global_store_b8 v0, v2, s[2:3]
; GFX11-NEXT:    s_endpgm
  %uadd = call { i32, i1 } @llvm.uadd.with.overflow.i32(i32 %a, i32 %b)
  %val = extractvalue { i32, i1 } %uadd, 0
  %carry = extractvalue { i32, i1 } %uadd, 1
  store i32 %val, ptr addrspace(1) %out, align 4
  store i1 %carry, ptr addrspace(1) %carryout
  ret void
}

; GCN-ISEL-LABEL: name:   suaddo64
; GCN-ISEL-LABEL: body:
; GCN-ISEL-LABEL: bb.0
; GCN-ISEL: S_ADD_U64_PSEUDO

define amdgpu_kernel void @suaddo64(ptr addrspace(1) %out, ptr addrspace(1) %carryout, i64 %a, i64 %b) #0 {
; CISI-LABEL: suaddo64:
; CISI:       ; %bb.0:
; CISI-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; CISI-NEXT:    s_mov_b32 s11, 0xf000
; CISI-NEXT:    s_mov_b32 s10, -1
; CISI-NEXT:    s_waitcnt lgkmcnt(0)
; CISI-NEXT:    s_add_u32 s6, s4, s6
; CISI-NEXT:    v_mov_b32_e32 v0, s4
; CISI-NEXT:    s_addc_u32 s7, s5, s7
; CISI-NEXT:    v_mov_b32_e32 v1, s5
; CISI-NEXT:    v_cmp_lt_u64_e32 vcc, s[6:7], v[0:1]
; CISI-NEXT:    v_mov_b32_e32 v2, s6
; CISI-NEXT:    s_mov_b32 s8, s0
; CISI-NEXT:    s_mov_b32 s9, s1
; CISI-NEXT:    s_mov_b32 s0, s2
; CISI-NEXT:    s_mov_b32 s1, s3
; CISI-NEXT:    s_mov_b32 s2, s10
; CISI-NEXT:    s_mov_b32 s3, s11
; CISI-NEXT:    v_mov_b32_e32 v3, s7
; CISI-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; CISI-NEXT:    buffer_store_dwordx2 v[2:3], off, s[8:11], 0
; CISI-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; CISI-NEXT:    s_endpgm
;
; VI-LABEL: suaddo64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    s_add_u32 s0, s4, s6
; VI-NEXT:    v_mov_b32_e32 v4, s4
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_addc_u32 s1, s5, s7
; VI-NEXT:    v_mov_b32_e32 v5, s5
; VI-NEXT:    v_mov_b32_e32 v7, s1
; VI-NEXT:    v_cmp_lt_u64_e32 vcc, s[0:1], v[4:5]
; VI-NEXT:    v_mov_b32_e32 v6, s0
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    flat_store_dwordx2 v[0:1], v[6:7]
; VI-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; VI-NEXT:    flat_store_byte v[2:3], v0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: suaddo64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_add_u32 s0, s12, s14
; GFX9-NEXT:    v_mov_b32_e32 v0, s12
; GFX9-NEXT:    v_mov_b32_e32 v1, s13
; GFX9-NEXT:    s_addc_u32 s1, s13, s15
; GFX9-NEXT:    v_mov_b32_e32 v3, s1
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, s[0:1], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v2, s0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9-NEXT:    global_store_dwordx2 v4, v[2:3], s[8:9]
; GFX9-NEXT:    global_store_byte v4, v0, s[10:11]
; GFX9-NEXT:    s_endpgm
;
; GFX1010-LABEL: suaddo64:
; GFX1010:       ; %bb.0:
; GFX1010-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x24
; GFX1010-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-NEXT:    s_add_u32 s0, s12, s14
; GFX1010-NEXT:    s_addc_u32 s1, s13, s15
; GFX1010-NEXT:    v_mov_b32_e32 v0, s0
; GFX1010-NEXT:    v_mov_b32_e32 v1, s1
; GFX1010-NEXT:    v_cmp_lt_u64_e64 s0, s[0:1], s[12:13]
; GFX1010-NEXT:    v_cndmask_b32_e64 v3, 0, 1, s0
; GFX1010-NEXT:    global_store_dwordx2 v2, v[0:1], s[8:9]
; GFX1010-NEXT:    global_store_byte v2, v3, s[10:11]
; GFX1010-NEXT:    s_endpgm
;
; GFX1030W32-LABEL: suaddo64:
; GFX1030W32:       ; %bb.0:
; GFX1030W32-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX1030W32-NEXT:    v_mov_b32_e32 v2, 0
; GFX1030W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W32-NEXT:    s_add_u32 s6, s4, s6
; GFX1030W32-NEXT:    s_addc_u32 s7, s5, s7
; GFX1030W32-NEXT:    v_mov_b32_e32 v0, s6
; GFX1030W32-NEXT:    v_cmp_lt_u64_e64 s4, s[6:7], s[4:5]
; GFX1030W32-NEXT:    v_mov_b32_e32 v1, s7
; GFX1030W32-NEXT:    v_cndmask_b32_e64 v3, 0, 1, s4
; GFX1030W32-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1030W32-NEXT:    global_store_byte v2, v3, s[2:3]
; GFX1030W32-NEXT:    s_endpgm
;
; GFX1030W64-LABEL: suaddo64:
; GFX1030W64:       ; %bb.0:
; GFX1030W64-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX1030W64-NEXT:    v_mov_b32_e32 v2, 0
; GFX1030W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W64-NEXT:    s_add_u32 s6, s4, s6
; GFX1030W64-NEXT:    s_addc_u32 s7, s5, s7
; GFX1030W64-NEXT:    v_mov_b32_e32 v0, s6
; GFX1030W64-NEXT:    v_cmp_lt_u64_e64 s[4:5], s[6:7], s[4:5]
; GFX1030W64-NEXT:    v_mov_b32_e32 v1, s7
; GFX1030W64-NEXT:    v_cndmask_b32_e64 v3, 0, 1, s[4:5]
; GFX1030W64-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1030W64-NEXT:    global_store_byte v2, v3, s[2:3]
; GFX1030W64-NEXT:    s_endpgm
;
; GFX11-LABEL: suaddo64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_add_u32 s6, s4, s6
; GFX11-NEXT:    s_addc_u32 s7, s5, s7
; GFX11-NEXT:    v_mov_b32_e32 v0, s6
; GFX11-NEXT:    v_cmp_lt_u64_e64 s4, s[6:7], s[4:5]
; GFX11-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s7
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e64 v3, 0, 1, s4
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    global_store_b8 v2, v3, s[2:3]
; GFX11-NEXT:    s_endpgm
  %uadd = call { i64, i1 } @llvm.uadd.with.overflow.i64(i64 %a, i64 %b)
  %val = extractvalue { i64, i1 } %uadd, 0
  %carry = extractvalue { i64, i1 } %uadd, 1
  store i64 %val, ptr addrspace(1) %out, align 8
  store i1 %carry, ptr addrspace(1) %carryout
  ret void
}

; GCN-ISEL-LABEL: name:   vuaddo64
; GCN-ISEL-LABEL: body:
; GCN-ISEL-LABEL: bb.0
; GCN-ISEL: V_ADD_U64_PSEUDO

define amdgpu_kernel void @vuaddo64(ptr addrspace(1) %out, ptr addrspace(1) %carryout, i64 %a) #0 {
; CISI-LABEL: vuaddo64:
; CISI:       ; %bb.0:
; CISI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; CISI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0xd
; CISI-NEXT:    s_mov_b32 s7, 0xf000
; CISI-NEXT:    s_mov_b32 s6, -1
; CISI-NEXT:    s_waitcnt lgkmcnt(0)
; CISI-NEXT:    s_mov_b32 s4, s0
; CISI-NEXT:    v_mov_b32_e32 v1, s9
; CISI-NEXT:    v_add_i32_e32 v0, vcc, s8, v0
; CISI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CISI-NEXT:    v_cmp_gt_u64_e32 vcc, s[8:9], v[0:1]
; CISI-NEXT:    s_mov_b32 s5, s1
; CISI-NEXT:    s_mov_b32 s0, s2
; CISI-NEXT:    s_mov_b32 s1, s3
; CISI-NEXT:    s_mov_b32 s2, s6
; CISI-NEXT:    s_mov_b32 s3, s7
; CISI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; CISI-NEXT:    s_waitcnt expcnt(0)
; CISI-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; CISI-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; CISI-NEXT:    s_endpgm
;
; VI-LABEL: vuaddo64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s0
; VI-NEXT:    v_mov_b32_e32 v6, s5
; VI-NEXT:    v_add_u32_e32 v5, vcc, s4, v0
; VI-NEXT:    v_addc_u32_e32 v6, vcc, 0, v6, vcc
; VI-NEXT:    v_cmp_gt_u64_e32 vcc, s[4:5], v[5:6]
; VI-NEXT:    v_mov_b32_e32 v2, s1
; VI-NEXT:    v_mov_b32_e32 v3, s2
; VI-NEXT:    v_mov_b32_e32 v4, s3
; VI-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; VI-NEXT:    flat_store_dwordx2 v[1:2], v[5:6]
; VI-NEXT:    flat_store_byte v[3:4], v0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: vuaddo64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, s6, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:    v_cmp_gt_u64_e32 vcc, s[6:7], v[0:1]
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9-NEXT:    global_store_byte v2, v0, s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX1010-LABEL: vuaddo64:
; GFX1010:       ; %bb.0:
; GFX1010-NEXT:    s_clause 0x1
; GFX1010-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX1010-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1010-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-NEXT:    v_add_co_u32 v0, s4, s6, v0
; GFX1010-NEXT:    v_add_co_ci_u32_e64 v1, s4, s7, 0, s4
; GFX1010-NEXT:    v_cmp_gt_u64_e32 vcc_lo, s[6:7], v[0:1]
; GFX1010-NEXT:    v_cndmask_b32_e64 v3, 0, 1, vcc_lo
; GFX1010-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1010-NEXT:    global_store_byte v2, v3, s[2:3]
; GFX1010-NEXT:    s_endpgm
;
; GFX1030W32-LABEL: vuaddo64:
; GFX1030W32:       ; %bb.0:
; GFX1030W32-NEXT:    s_clause 0x1
; GFX1030W32-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX1030W32-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1030W32-NEXT:    v_mov_b32_e32 v2, 0
; GFX1030W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W32-NEXT:    v_add_co_u32 v0, s4, s6, v0
; GFX1030W32-NEXT:    v_add_co_ci_u32_e64 v1, null, s7, 0, s4
; GFX1030W32-NEXT:    v_cmp_gt_u64_e32 vcc_lo, s[6:7], v[0:1]
; GFX1030W32-NEXT:    v_cndmask_b32_e64 v3, 0, 1, vcc_lo
; GFX1030W32-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1030W32-NEXT:    global_store_byte v2, v3, s[2:3]
; GFX1030W32-NEXT:    s_endpgm
;
; GFX1030W64-LABEL: vuaddo64:
; GFX1030W64:       ; %bb.0:
; GFX1030W64-NEXT:    s_clause 0x1
; GFX1030W64-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX1030W64-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1030W64-NEXT:    v_mov_b32_e32 v2, 0
; GFX1030W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W64-NEXT:    v_add_co_u32 v0, s[4:5], s6, v0
; GFX1030W64-NEXT:    v_add_co_ci_u32_e64 v1, null, s7, 0, s[4:5]
; GFX1030W64-NEXT:    v_cmp_gt_u64_e32 vcc, s[6:7], v[0:1]
; GFX1030W64-NEXT:    v_cndmask_b32_e64 v3, 0, 1, vcc
; GFX1030W64-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1030W64-NEXT:    global_store_byte v2, v3, s[2:3]
; GFX1030W64-NEXT:    s_endpgm
;
; GFX11-LABEL: vuaddo64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_u32 v0, s4, s6, v0
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, s7, 0, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cmp_gt_u64_e32 vcc_lo, s[6:7], v[0:1]
; GFX11-NEXT:    v_cndmask_b32_e64 v3, 0, 1, vcc_lo
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    global_store_b8 v2, v3, s[2:3]
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %uadd = call { i64, i1 } @llvm.uadd.with.overflow.i64(i64 %a, i64 %tid.ext)
  %val = extractvalue { i64, i1 } %uadd, 0
  %carry = extractvalue { i64, i1 } %uadd, 1
  store i64 %val, ptr addrspace(1) %out, align 8
  store i1 %carry, ptr addrspace(1) %carryout
  ret void
}

; GCN-ISEL-LABEL: name:   ssub64rr
; GCN-ISEL-LABEL: body:
; GCN-ISEL-LABEL: bb.0.entry:
; GCN-ISEL: S_SUB_U64_PSEUDO

define amdgpu_kernel void @ssub64rr(ptr addrspace(1) %out, i64 %a, i64 %b) {
; CISI-LABEL: ssub64rr:
; CISI:       ; %bb.0: ; %entry
; CISI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; CISI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0xd
; CISI-NEXT:    s_mov_b32 s7, 0xf000
; CISI-NEXT:    s_mov_b32 s6, -1
; CISI-NEXT:    s_waitcnt lgkmcnt(0)
; CISI-NEXT:    s_mov_b32 s4, s0
; CISI-NEXT:    s_sub_u32 s0, s2, s8
; CISI-NEXT:    s_mov_b32 s5, s1
; CISI-NEXT:    s_subb_u32 s1, s3, s9
; CISI-NEXT:    v_mov_b32_e32 v0, s0
; CISI-NEXT:    v_mov_b32_e32 v1, s1
; CISI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; CISI-NEXT:    s_endpgm
;
; VI-LABEL: ssub64rr:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    s_sub_u32 s0, s2, s4
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_subb_u32 s1, s3, s5
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: ssub64rr:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_sub_u32 s2, s2, s6
; GFX9-NEXT:    s_subb_u32 s3, s3, s7
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX1010-LABEL: ssub64rr:
; GFX1010:       ; %bb.0: ; %entry
; GFX1010-NEXT:    s_clause 0x1
; GFX1010-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1010-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX1010-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-NEXT:    s_sub_u32 s2, s2, s6
; GFX1010-NEXT:    s_subb_u32 s3, s3, s7
; GFX1010-NEXT:    v_mov_b32_e32 v0, s2
; GFX1010-NEXT:    v_mov_b32_e32 v1, s3
; GFX1010-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1010-NEXT:    s_endpgm
;
; GFX1030W32-LABEL: ssub64rr:
; GFX1030W32:       ; %bb.0: ; %entry
; GFX1030W32-NEXT:    s_clause 0x1
; GFX1030W32-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1030W32-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX1030W32-NEXT:    v_mov_b32_e32 v2, 0
; GFX1030W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W32-NEXT:    s_sub_u32 s2, s2, s4
; GFX1030W32-NEXT:    s_subb_u32 s3, s3, s5
; GFX1030W32-NEXT:    v_mov_b32_e32 v0, s2
; GFX1030W32-NEXT:    v_mov_b32_e32 v1, s3
; GFX1030W32-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1030W32-NEXT:    s_endpgm
;
; GFX1030W64-LABEL: ssub64rr:
; GFX1030W64:       ; %bb.0: ; %entry
; GFX1030W64-NEXT:    s_clause 0x1
; GFX1030W64-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1030W64-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX1030W64-NEXT:    v_mov_b32_e32 v2, 0
; GFX1030W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W64-NEXT:    s_sub_u32 s2, s2, s4
; GFX1030W64-NEXT:    s_subb_u32 s3, s3, s5
; GFX1030W64-NEXT:    v_mov_b32_e32 v0, s2
; GFX1030W64-NEXT:    v_mov_b32_e32 v1, s3
; GFX1030W64-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1030W64-NEXT:    s_endpgm
;
; GFX11-LABEL: ssub64rr:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_sub_u32 s2, s2, s4
; GFX11-NEXT:    s_subb_u32 s3, s3, s5
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
entry:
  %sub = sub i64 %a, %b
  store i64 %sub, ptr addrspace(1) %out
  ret void
}

; GCN-ISEL-LABEL: name:   ssub64ri
; GCN-ISEL-LABEL: body:
; GCN-ISEL-LABEL: bb.0.entry:
; GCN-ISEL: S_SUB_U64_PSEUDO

define amdgpu_kernel void @ssub64ri(ptr addrspace(1) %out, i64 %a) {
; CISI-LABEL: ssub64ri:
; CISI:       ; %bb.0: ; %entry
; CISI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; CISI-NEXT:    s_mov_b32 s7, 0xf000
; CISI-NEXT:    s_mov_b32 s6, -1
; CISI-NEXT:    s_waitcnt lgkmcnt(0)
; CISI-NEXT:    s_mov_b32 s4, s0
; CISI-NEXT:    s_sub_u32 s0, 0x56789876, s2
; CISI-NEXT:    s_mov_b32 s5, s1
; CISI-NEXT:    s_subb_u32 s1, 0x1234, s3
; CISI-NEXT:    v_mov_b32_e32 v0, s0
; CISI-NEXT:    v_mov_b32_e32 v1, s1
; CISI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; CISI-NEXT:    s_endpgm
;
; VI-LABEL: ssub64ri:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    s_sub_u32 s0, 0x56789876, s2
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_subb_u32 s1, 0x1234, s3
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: ssub64ri:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_sub_u32 s2, 0x56789876, s2
; GFX9-NEXT:    s_subb_u32 s3, 0x1234, s3
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX1010-LABEL: ssub64ri:
; GFX1010:       ; %bb.0: ; %entry
; GFX1010-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1010-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-NEXT:    s_sub_u32 s2, 0x56789876, s2
; GFX1010-NEXT:    s_subb_u32 s3, 0x1234, s3
; GFX1010-NEXT:    v_mov_b32_e32 v0, s2
; GFX1010-NEXT:    v_mov_b32_e32 v1, s3
; GFX1010-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1010-NEXT:    s_endpgm
;
; GFX1030W32-LABEL: ssub64ri:
; GFX1030W32:       ; %bb.0: ; %entry
; GFX1030W32-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1030W32-NEXT:    v_mov_b32_e32 v2, 0
; GFX1030W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W32-NEXT:    s_sub_u32 s2, 0x56789876, s2
; GFX1030W32-NEXT:    s_subb_u32 s3, 0x1234, s3
; GFX1030W32-NEXT:    v_mov_b32_e32 v0, s2
; GFX1030W32-NEXT:    v_mov_b32_e32 v1, s3
; GFX1030W32-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1030W32-NEXT:    s_endpgm
;
; GFX1030W64-LABEL: ssub64ri:
; GFX1030W64:       ; %bb.0: ; %entry
; GFX1030W64-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1030W64-NEXT:    v_mov_b32_e32 v2, 0
; GFX1030W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W64-NEXT:    s_sub_u32 s2, 0x56789876, s2
; GFX1030W64-NEXT:    s_subb_u32 s3, 0x1234, s3
; GFX1030W64-NEXT:    v_mov_b32_e32 v0, s2
; GFX1030W64-NEXT:    v_mov_b32_e32 v1, s3
; GFX1030W64-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1030W64-NEXT:    s_endpgm
;
; GFX11-LABEL: ssub64ri:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_sub_u32 s2, 0x56789876, s2
; GFX11-NEXT:    s_subb_u32 s3, 0x1234, s3
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
entry:
  %sub = sub i64 20015998343286, %a
  store i64 %sub, ptr addrspace(1) %out
  ret void
}

; GCN-ISEL-LABEL: name:   vsub64rr
; GCN-ISEL-LABEL: body:
; GCN-ISEL-LABEL: bb.0.entry:
; GCN-ISEL: V_SUB_U64_PSEUDO

define amdgpu_kernel void @vsub64rr(ptr addrspace(1) %out, i64 %a) {
; CISI-LABEL: vsub64rr:
; CISI:       ; %bb.0: ; %entry
; CISI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; CISI-NEXT:    s_mov_b32 s7, 0xf000
; CISI-NEXT:    s_mov_b32 s6, -1
; CISI-NEXT:    s_waitcnt lgkmcnt(0)
; CISI-NEXT:    v_mov_b32_e32 v1, s3
; CISI-NEXT:    v_sub_i32_e32 v0, vcc, s2, v0
; CISI-NEXT:    s_mov_b32 s4, s0
; CISI-NEXT:    s_mov_b32 s5, s1
; CISI-NEXT:    v_subbrev_u32_e32 v1, vcc, 0, v1, vcc
; CISI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; CISI-NEXT:    s_endpgm
;
; VI-LABEL: vsub64rr:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v4, s3
; VI-NEXT:    v_sub_u32_e32 v3, vcc, s2, v0
; VI-NEXT:    v_mov_b32_e32 v1, s0
; VI-NEXT:    v_mov_b32_e32 v2, s1
; VI-NEXT:    v_subbrev_u32_e32 v4, vcc, 0, v4, vcc
; VI-NEXT:    flat_store_dwordx2 v[1:2], v[3:4]
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: vsub64rr:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    v_sub_co_u32_e32 v0, vcc, s2, v0
; GFX9-NEXT:    v_subbrev_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX1010-LABEL: vsub64rr:
; GFX1010:       ; %bb.0: ; %entry
; GFX1010-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1010-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-NEXT:    v_sub_co_u32 v0, s2, s2, v0
; GFX1010-NEXT:    v_sub_co_ci_u32_e64 v1, s2, s3, 0, s2
; GFX1010-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1010-NEXT:    s_endpgm
;
; GFX1030W32-LABEL: vsub64rr:
; GFX1030W32:       ; %bb.0: ; %entry
; GFX1030W32-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1030W32-NEXT:    v_mov_b32_e32 v2, 0
; GFX1030W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W32-NEXT:    v_sub_co_u32 v0, s2, s2, v0
; GFX1030W32-NEXT:    v_sub_co_ci_u32_e64 v1, null, s3, 0, s2
; GFX1030W32-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1030W32-NEXT:    s_endpgm
;
; GFX1030W64-LABEL: vsub64rr:
; GFX1030W64:       ; %bb.0: ; %entry
; GFX1030W64-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1030W64-NEXT:    v_mov_b32_e32 v2, 0
; GFX1030W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W64-NEXT:    v_sub_co_u32 v0, s[4:5], s2, v0
; GFX1030W64-NEXT:    v_sub_co_ci_u32_e64 v1, null, s3, 0, s[4:5]
; GFX1030W64-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1030W64-NEXT:    s_endpgm
;
; GFX11-LABEL: vsub64rr:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_sub_co_u32 v0, s2, s2, v0
; GFX11-NEXT:    v_sub_co_ci_u32_e64 v1, null, s3, 0, s2
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
entry:
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %sub = sub i64 %a, %tid.ext
  store i64 %sub, ptr addrspace(1) %out
  ret void
}

; GCN-ISEL-LABEL: name:   vsub64ri
; GCN-ISEL-LABEL: body:
; GCN-ISEL-LABEL: bb.0.entry:
; GCN-ISEL: V_SUB_U64_PSEUDO

define amdgpu_kernel void @vsub64ri(ptr addrspace(1) %out) {
; CISI-LABEL: vsub64ri:
; CISI:       ; %bb.0: ; %entry
; CISI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; CISI-NEXT:    v_sub_i32_e32 v0, vcc, 0x56789876, v0
; CISI-NEXT:    v_mov_b32_e32 v1, 0x1234
; CISI-NEXT:    s_mov_b32 s3, 0xf000
; CISI-NEXT:    s_mov_b32 s2, -1
; CISI-NEXT:    v_subbrev_u32_e32 v1, vcc, 0, v1, vcc
; CISI-NEXT:    s_waitcnt lgkmcnt(0)
; CISI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; CISI-NEXT:    s_endpgm
;
; VI-LABEL: vsub64ri:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; VI-NEXT:    v_sub_u32_e32 v0, vcc, 0x56789876, v0
; VI-NEXT:    v_mov_b32_e32 v1, 0x1234
; VI-NEXT:    v_subbrev_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: vsub64ri:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    v_sub_co_u32_e32 v0, vcc, 0x56789876, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x1234
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    v_subbrev_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX1010-LABEL: vsub64ri:
; GFX1010:       ; %bb.0: ; %entry
; GFX1010-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1010-NEXT:    v_sub_co_u32 v0, s2, 0x56789876, v0
; GFX1010-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-NEXT:    v_sub_co_ci_u32_e64 v1, s2, 0x1234, 0, s2
; GFX1010-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1010-NEXT:    s_endpgm
;
; GFX1030W32-LABEL: vsub64ri:
; GFX1030W32:       ; %bb.0: ; %entry
; GFX1030W32-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1030W32-NEXT:    v_sub_co_u32 v0, s2, 0x56789876, v0
; GFX1030W32-NEXT:    v_mov_b32_e32 v2, 0
; GFX1030W32-NEXT:    v_sub_co_ci_u32_e64 v1, null, 0x1234, 0, s2
; GFX1030W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W32-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1030W32-NEXT:    s_endpgm
;
; GFX1030W64-LABEL: vsub64ri:
; GFX1030W64:       ; %bb.0: ; %entry
; GFX1030W64-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1030W64-NEXT:    v_sub_co_u32 v0, s[2:3], 0x56789876, v0
; GFX1030W64-NEXT:    v_mov_b32_e32 v2, 0
; GFX1030W64-NEXT:    v_sub_co_ci_u32_e64 v1, null, 0x1234, 0, s[2:3]
; GFX1030W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W64-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1030W64-NEXT:    s_endpgm
;
; GFX11-LABEL: vsub64ri:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_sub_co_u32 v0, s2, 0x56789876, v0
; GFX11-NEXT:    v_sub_co_ci_u32_e64 v1, null, 0x1234, 0, s2
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
entry:
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %sub = sub i64 20015998343286, %tid.ext
  store i64 %sub, ptr addrspace(1) %out
  ret void
}

; GCN-ISEL-LABEL: name:   susubo32
; GCN-ISEL-LABEL: body:
; GCN-ISEL-LABEL: bb.0
; GCN-ISEL: S_SUB_I32

define amdgpu_kernel void @susubo32(ptr addrspace(1) %out, ptr addrspace(1) %carryout, i32 %a, i32 %b) #0 {
; CISI-LABEL: susubo32:
; CISI:       ; %bb.0:
; CISI-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0xd
; CISI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; CISI-NEXT:    s_mov_b32 s3, 0xf000
; CISI-NEXT:    s_mov_b32 s2, -1
; CISI-NEXT:    s_waitcnt lgkmcnt(0)
; CISI-NEXT:    s_sub_i32 s4, s6, s7
; CISI-NEXT:    v_mov_b32_e32 v0, s4
; CISI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; CISI-NEXT:    s_endpgm
;
; VI-LABEL: susubo32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x34
; VI-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_sub_i32 s0, s0, s1
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: susubo32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x34
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_sub_i32 s0, s0, s1
; GFX9-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX1010-LABEL: susubo32:
; GFX1010:       ; %bb.0:
; GFX1010-NEXT:    s_clause 0x1
; GFX1010-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x34
; GFX1010-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x24
; GFX1010-NEXT:    v_mov_b32_e32 v0, 0
; GFX1010-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-NEXT:    s_sub_i32 s0, s0, s1
; GFX1010-NEXT:    v_mov_b32_e32 v1, s0
; GFX1010-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX1010-NEXT:    s_endpgm
;
; GFX1030W32-LABEL: susubo32:
; GFX1030W32:       ; %bb.0:
; GFX1030W32-NEXT:    s_clause 0x1
; GFX1030W32-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x34
; GFX1030W32-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x24
; GFX1030W32-NEXT:    v_mov_b32_e32 v0, 0
; GFX1030W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W32-NEXT:    s_sub_i32 s0, s0, s1
; GFX1030W32-NEXT:    v_mov_b32_e32 v1, s0
; GFX1030W32-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX1030W32-NEXT:    s_endpgm
;
; GFX1030W64-LABEL: susubo32:
; GFX1030W64:       ; %bb.0:
; GFX1030W64-NEXT:    s_clause 0x1
; GFX1030W64-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x34
; GFX1030W64-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x24
; GFX1030W64-NEXT:    v_mov_b32_e32 v0, 0
; GFX1030W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W64-NEXT:    s_sub_i32 s0, s0, s1
; GFX1030W64-NEXT:    v_mov_b32_e32 v1, s0
; GFX1030W64-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX1030W64-NEXT:    s_endpgm
;
; GFX11-LABEL: susubo32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x34
; GFX11-NEXT:    s_load_b64 s[2:3], s[4:5], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_sub_i32 s0, s0, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s0
; GFX11-NEXT:    global_store_b32 v0, v1, s[2:3]
; GFX11-NEXT:    s_endpgm
  %usub = call { i32, i1 } @llvm.usub.with.overflow.i32(i32 %a, i32 %b)
  %val = extractvalue { i32, i1 } %usub, 0
  %carry = extractvalue { i32, i1 } %usub, 1
  store i32 %val, ptr addrspace(1) %out, align 4
  ret void
}


; GCN-ISEL-LABEL: name:   usubo32_vcc_user
; GCN-ISEL-LABEL: body:
; GCN-ISEL-LABEL: bb.0
; GCN-ISEL: V_SUB_CO_U32_e64

; below we check selection to v_sub/subb
; because the only user of VCC produced by the USUBOis v_cndmask.
; We select to VALU form to avoid unnecessary s_cselect to copy SCC to VCC

define amdgpu_kernel void @usubo32_vcc_user(ptr addrspace(1) %out, ptr addrspace(1) %carryout, i32 %a, i32 %b) #0 {
; CISI-LABEL: usubo32_vcc_user:
; CISI:       ; %bb.0:
; CISI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; CISI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0xd
; CISI-NEXT:    s_mov_b32 s7, 0xf000
; CISI-NEXT:    s_mov_b32 s6, -1
; CISI-NEXT:    s_waitcnt lgkmcnt(0)
; CISI-NEXT:    s_mov_b32 s4, s0
; CISI-NEXT:    v_mov_b32_e32 v0, s9
; CISI-NEXT:    s_mov_b32 s5, s1
; CISI-NEXT:    v_sub_i32_e32 v0, vcc, s8, v0
; CISI-NEXT:    s_mov_b32 s0, s2
; CISI-NEXT:    s_mov_b32 s1, s3
; CISI-NEXT:    s_mov_b32 s2, s6
; CISI-NEXT:    s_mov_b32 s3, s7
; CISI-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; CISI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; CISI-NEXT:    buffer_store_byte v1, off, s[0:3], 0
; CISI-NEXT:    s_endpgm
;
; VI-LABEL: usubo32_vcc_user:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v4, s5
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_sub_u32_e32 v4, vcc, s4, v4
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    v_cndmask_b32_e64 v5, 0, 1, vcc
; VI-NEXT:    flat_store_dword v[0:1], v4
; VI-NEXT:    flat_store_byte v[2:3], v5
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: usubo32_vcc_user:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    v_sub_co_u32_e32 v1, vcc, s6, v1
; GFX9-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    global_store_byte v0, v2, s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX1010-LABEL: usubo32_vcc_user:
; GFX1010:       ; %bb.0:
; GFX1010-NEXT:    s_clause 0x1
; GFX1010-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX1010-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1010-NEXT:    v_mov_b32_e32 v0, 0
; GFX1010-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-NEXT:    v_sub_co_u32 v1, s4, s6, s7
; GFX1010-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s4
; GFX1010-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX1010-NEXT:    global_store_byte v0, v2, s[2:3]
; GFX1010-NEXT:    s_endpgm
;
; GFX1030W32-LABEL: usubo32_vcc_user:
; GFX1030W32:       ; %bb.0:
; GFX1030W32-NEXT:    s_clause 0x1
; GFX1030W32-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX1030W32-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1030W32-NEXT:    v_mov_b32_e32 v0, 0
; GFX1030W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W32-NEXT:    v_sub_co_u32 v1, s4, s6, s7
; GFX1030W32-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s4
; GFX1030W32-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX1030W32-NEXT:    global_store_byte v0, v2, s[2:3]
; GFX1030W32-NEXT:    s_endpgm
;
; GFX1030W64-LABEL: usubo32_vcc_user:
; GFX1030W64:       ; %bb.0:
; GFX1030W64-NEXT:    s_clause 0x1
; GFX1030W64-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX1030W64-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1030W64-NEXT:    v_mov_b32_e32 v0, 0
; GFX1030W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W64-NEXT:    v_sub_co_u32 v1, s[4:5], s6, s7
; GFX1030W64-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s[4:5]
; GFX1030W64-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX1030W64-NEXT:    global_store_byte v0, v2, s[2:3]
; GFX1030W64-NEXT:    s_endpgm
;
; GFX11-LABEL: usubo32_vcc_user:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_sub_co_u32 v1, s4, s6, s7
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s4
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    global_store_b8 v0, v2, s[2:3]
; GFX11-NEXT:    s_endpgm
  %usub = call { i32, i1 } @llvm.usub.with.overflow.i32(i32 %a, i32 %b)
  %val = extractvalue { i32, i1 } %usub, 0
  %carry = extractvalue { i32, i1 } %usub, 1
  store i32 %val, ptr addrspace(1) %out, align 4
  store i1 %carry, ptr addrspace(1) %carryout
  ret void
}

; GCN-ISEL-LABEL: name:   susubo64
; GCN-ISEL-LABEL: body:
; GCN-ISEL-LABEL: bb.0
; GCN-ISEL: S_SUB_U64_PSEUDO

define amdgpu_kernel void @susubo64(ptr addrspace(1) %out, ptr addrspace(1) %carryout, i64 %a, i64 %b) #0 {
; CISI-LABEL: susubo64:
; CISI:       ; %bb.0:
; CISI-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; CISI-NEXT:    s_mov_b32 s11, 0xf000
; CISI-NEXT:    s_mov_b32 s10, -1
; CISI-NEXT:    s_waitcnt lgkmcnt(0)
; CISI-NEXT:    s_sub_u32 s6, s4, s6
; CISI-NEXT:    v_mov_b32_e32 v0, s4
; CISI-NEXT:    s_subb_u32 s7, s5, s7
; CISI-NEXT:    v_mov_b32_e32 v1, s5
; CISI-NEXT:    v_cmp_gt_u64_e32 vcc, s[6:7], v[0:1]
; CISI-NEXT:    v_mov_b32_e32 v2, s6
; CISI-NEXT:    s_mov_b32 s8, s0
; CISI-NEXT:    s_mov_b32 s9, s1
; CISI-NEXT:    s_mov_b32 s0, s2
; CISI-NEXT:    s_mov_b32 s1, s3
; CISI-NEXT:    s_mov_b32 s2, s10
; CISI-NEXT:    s_mov_b32 s3, s11
; CISI-NEXT:    v_mov_b32_e32 v3, s7
; CISI-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; CISI-NEXT:    buffer_store_dwordx2 v[2:3], off, s[8:11], 0
; CISI-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; CISI-NEXT:    s_endpgm
;
; VI-LABEL: susubo64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    s_sub_u32 s0, s4, s6
; VI-NEXT:    v_mov_b32_e32 v4, s4
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_subb_u32 s1, s5, s7
; VI-NEXT:    v_mov_b32_e32 v5, s5
; VI-NEXT:    v_mov_b32_e32 v7, s1
; VI-NEXT:    v_cmp_gt_u64_e32 vcc, s[0:1], v[4:5]
; VI-NEXT:    v_mov_b32_e32 v6, s0
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    flat_store_dwordx2 v[0:1], v[6:7]
; VI-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; VI-NEXT:    flat_store_byte v[2:3], v0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: susubo64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_sub_u32 s0, s12, s14
; GFX9-NEXT:    v_mov_b32_e32 v0, s12
; GFX9-NEXT:    v_mov_b32_e32 v1, s13
; GFX9-NEXT:    s_subb_u32 s1, s13, s15
; GFX9-NEXT:    v_mov_b32_e32 v3, s1
; GFX9-NEXT:    v_cmp_gt_u64_e32 vcc, s[0:1], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v2, s0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9-NEXT:    global_store_dwordx2 v4, v[2:3], s[8:9]
; GFX9-NEXT:    global_store_byte v4, v0, s[10:11]
; GFX9-NEXT:    s_endpgm
;
; GFX1010-LABEL: susubo64:
; GFX1010:       ; %bb.0:
; GFX1010-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x24
; GFX1010-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-NEXT:    s_sub_u32 s0, s12, s14
; GFX1010-NEXT:    s_subb_u32 s1, s13, s15
; GFX1010-NEXT:    v_mov_b32_e32 v0, s0
; GFX1010-NEXT:    v_mov_b32_e32 v1, s1
; GFX1010-NEXT:    v_cmp_gt_u64_e64 s0, s[0:1], s[12:13]
; GFX1010-NEXT:    v_cndmask_b32_e64 v3, 0, 1, s0
; GFX1010-NEXT:    global_store_dwordx2 v2, v[0:1], s[8:9]
; GFX1010-NEXT:    global_store_byte v2, v3, s[10:11]
; GFX1010-NEXT:    s_endpgm
;
; GFX1030W32-LABEL: susubo64:
; GFX1030W32:       ; %bb.0:
; GFX1030W32-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX1030W32-NEXT:    v_mov_b32_e32 v2, 0
; GFX1030W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W32-NEXT:    s_sub_u32 s6, s4, s6
; GFX1030W32-NEXT:    s_subb_u32 s7, s5, s7
; GFX1030W32-NEXT:    v_mov_b32_e32 v0, s6
; GFX1030W32-NEXT:    v_cmp_gt_u64_e64 s4, s[6:7], s[4:5]
; GFX1030W32-NEXT:    v_mov_b32_e32 v1, s7
; GFX1030W32-NEXT:    v_cndmask_b32_e64 v3, 0, 1, s4
; GFX1030W32-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1030W32-NEXT:    global_store_byte v2, v3, s[2:3]
; GFX1030W32-NEXT:    s_endpgm
;
; GFX1030W64-LABEL: susubo64:
; GFX1030W64:       ; %bb.0:
; GFX1030W64-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX1030W64-NEXT:    v_mov_b32_e32 v2, 0
; GFX1030W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W64-NEXT:    s_sub_u32 s6, s4, s6
; GFX1030W64-NEXT:    s_subb_u32 s7, s5, s7
; GFX1030W64-NEXT:    v_mov_b32_e32 v0, s6
; GFX1030W64-NEXT:    v_cmp_gt_u64_e64 s[4:5], s[6:7], s[4:5]
; GFX1030W64-NEXT:    v_mov_b32_e32 v1, s7
; GFX1030W64-NEXT:    v_cndmask_b32_e64 v3, 0, 1, s[4:5]
; GFX1030W64-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1030W64-NEXT:    global_store_byte v2, v3, s[2:3]
; GFX1030W64-NEXT:    s_endpgm
;
; GFX11-LABEL: susubo64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_sub_u32 s6, s4, s6
; GFX11-NEXT:    s_subb_u32 s7, s5, s7
; GFX11-NEXT:    v_mov_b32_e32 v0, s6
; GFX11-NEXT:    v_cmp_gt_u64_e64 s4, s[6:7], s[4:5]
; GFX11-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s7
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e64 v3, 0, 1, s4
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    global_store_b8 v2, v3, s[2:3]
; GFX11-NEXT:    s_endpgm
  %usub = call { i64, i1 } @llvm.usub.with.overflow.i64(i64 %a, i64 %b)
  %val = extractvalue { i64, i1 } %usub, 0
  %carry = extractvalue { i64, i1 } %usub, 1
  store i64 %val, ptr addrspace(1) %out, align 8
  store i1 %carry, ptr addrspace(1) %carryout
  ret void
}

; GCN-ISEL-LABEL: name:   vusubo64
; GCN-ISEL-LABEL: body:
; GCN-ISEL-LABEL: bb.0
; GCN-ISEL: V_SUB_U64_PSEUDO

define amdgpu_kernel void @vusubo64(ptr addrspace(1) %out, ptr addrspace(1) %carryout, i64 %a) #0 {
; CISI-LABEL: vusubo64:
; CISI:       ; %bb.0:
; CISI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; CISI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0xd
; CISI-NEXT:    s_mov_b32 s7, 0xf000
; CISI-NEXT:    s_mov_b32 s6, -1
; CISI-NEXT:    s_waitcnt lgkmcnt(0)
; CISI-NEXT:    s_mov_b32 s4, s0
; CISI-NEXT:    v_mov_b32_e32 v1, s9
; CISI-NEXT:    v_sub_i32_e32 v0, vcc, s8, v0
; CISI-NEXT:    v_subbrev_u32_e32 v1, vcc, 0, v1, vcc
; CISI-NEXT:    v_cmp_lt_u64_e32 vcc, s[8:9], v[0:1]
; CISI-NEXT:    s_mov_b32 s5, s1
; CISI-NEXT:    s_mov_b32 s0, s2
; CISI-NEXT:    s_mov_b32 s1, s3
; CISI-NEXT:    s_mov_b32 s2, s6
; CISI-NEXT:    s_mov_b32 s3, s7
; CISI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; CISI-NEXT:    s_waitcnt expcnt(0)
; CISI-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; CISI-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; CISI-NEXT:    s_endpgm
;
; VI-LABEL: vusubo64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s0
; VI-NEXT:    v_mov_b32_e32 v6, s5
; VI-NEXT:    v_sub_u32_e32 v5, vcc, s4, v0
; VI-NEXT:    v_subbrev_u32_e32 v6, vcc, 0, v6, vcc
; VI-NEXT:    v_cmp_lt_u64_e32 vcc, s[4:5], v[5:6]
; VI-NEXT:    v_mov_b32_e32 v2, s1
; VI-NEXT:    v_mov_b32_e32 v3, s2
; VI-NEXT:    v_mov_b32_e32 v4, s3
; VI-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; VI-NEXT:    flat_store_dwordx2 v[1:2], v[5:6]
; VI-NEXT:    flat_store_byte v[3:4], v0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: vusubo64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    v_sub_co_u32_e32 v0, vcc, s6, v0
; GFX9-NEXT:    v_subbrev_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, s[6:7], v[0:1]
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9-NEXT:    global_store_byte v2, v0, s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX1010-LABEL: vusubo64:
; GFX1010:       ; %bb.0:
; GFX1010-NEXT:    s_clause 0x1
; GFX1010-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX1010-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1010-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-NEXT:    v_sub_co_u32 v0, s4, s6, v0
; GFX1010-NEXT:    v_sub_co_ci_u32_e64 v1, s4, s7, 0, s4
; GFX1010-NEXT:    v_cmp_lt_u64_e32 vcc_lo, s[6:7], v[0:1]
; GFX1010-NEXT:    v_cndmask_b32_e64 v3, 0, 1, vcc_lo
; GFX1010-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1010-NEXT:    global_store_byte v2, v3, s[2:3]
; GFX1010-NEXT:    s_endpgm
;
; GFX1030W32-LABEL: vusubo64:
; GFX1030W32:       ; %bb.0:
; GFX1030W32-NEXT:    s_clause 0x1
; GFX1030W32-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX1030W32-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1030W32-NEXT:    v_mov_b32_e32 v2, 0
; GFX1030W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W32-NEXT:    v_sub_co_u32 v0, s4, s6, v0
; GFX1030W32-NEXT:    v_sub_co_ci_u32_e64 v1, null, s7, 0, s4
; GFX1030W32-NEXT:    v_cmp_lt_u64_e32 vcc_lo, s[6:7], v[0:1]
; GFX1030W32-NEXT:    v_cndmask_b32_e64 v3, 0, 1, vcc_lo
; GFX1030W32-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1030W32-NEXT:    global_store_byte v2, v3, s[2:3]
; GFX1030W32-NEXT:    s_endpgm
;
; GFX1030W64-LABEL: vusubo64:
; GFX1030W64:       ; %bb.0:
; GFX1030W64-NEXT:    s_clause 0x1
; GFX1030W64-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX1030W64-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1030W64-NEXT:    v_mov_b32_e32 v2, 0
; GFX1030W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W64-NEXT:    v_sub_co_u32 v0, s[4:5], s6, v0
; GFX1030W64-NEXT:    v_sub_co_ci_u32_e64 v1, null, s7, 0, s[4:5]
; GFX1030W64-NEXT:    v_cmp_lt_u64_e32 vcc, s[6:7], v[0:1]
; GFX1030W64-NEXT:    v_cndmask_b32_e64 v3, 0, 1, vcc
; GFX1030W64-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1030W64-NEXT:    global_store_byte v2, v3, s[2:3]
; GFX1030W64-NEXT:    s_endpgm
;
; GFX11-LABEL: vusubo64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_sub_co_u32 v0, s4, s6, v0
; GFX11-NEXT:    v_sub_co_ci_u32_e64 v1, null, s7, 0, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cmp_lt_u64_e32 vcc_lo, s[6:7], v[0:1]
; GFX11-NEXT:    v_cndmask_b32_e64 v3, 0, 1, vcc_lo
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    global_store_b8 v2, v3, s[2:3]
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %usub = call { i64, i1 } @llvm.usub.with.overflow.i64(i64 %a, i64 %tid.ext)
  %val = extractvalue { i64, i1 } %usub, 0
  %carry = extractvalue { i64, i1 } %usub, 1
  store i64 %val, ptr addrspace(1) %out, align 8
  store i1 %carry, ptr addrspace(1) %carryout
  ret void
}

; GCN-ISEL-LABEL: name:   sudiv64
; GCN-ISEL-LABEL: body:
; GCN-ISEL-LABEL: bb.3
; GCN-ISEL: %[[CARRY:[0-9]+]]:sreg_64_xexec = V_ADD_CO_U32_e64
; GCN-ISEL: S_ADD_CO_PSEUDO %{{[0-9]+}}, killed %{{[0-9]+}}, killed %[[CARRY]]
; GCN-ISEL: %[[CARRY:[0-9]+]]:sreg_64_xexec = V_SUB_CO_U32_e64
; GCN-ISEL: S_SUB_CO_PSEUDO killed %{{[0-9]+}}, %{{[0-9]+}}, %[[CARRY]]

define amdgpu_kernel void @sudiv64(ptr addrspace(1) %out, i64 %x, i64 %y) {
; CISI-LABEL: sudiv64:
; CISI:       ; %bb.0:
; CISI-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x9
; CISI-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0xd
; CISI-NEXT:    s_waitcnt lgkmcnt(0)
; CISI-NEXT:    s_or_b64 s[0:1], s[10:11], s[2:3]
; CISI-NEXT:    s_mov_b32 s0, 0
; CISI-NEXT:    v_cmp_ne_u64_e64 s[0:1], s[0:1], 0
; CISI-NEXT:    s_and_b64 vcc, exec, s[0:1]
; CISI-NEXT:    s_cbranch_vccz .LBB16_4
; CISI-NEXT:  ; %bb.1:
; CISI-NEXT:    v_cvt_f32_u32_e32 v0, s2
; CISI-NEXT:    v_cvt_f32_u32_e32 v1, s3
; CISI-NEXT:    s_sub_u32 s0, 0, s2
; CISI-NEXT:    s_subb_u32 s1, 0, s3
; CISI-NEXT:    v_madmk_f32 v0, v1, 0x4f800000, v0
; CISI-NEXT:    v_rcp_f32_e32 v0, v0
; CISI-NEXT:    v_mul_f32_e32 v0, 0x5f7ffffc, v0
; CISI-NEXT:    v_mul_f32_e32 v1, 0x2f800000, v0
; CISI-NEXT:    v_trunc_f32_e32 v1, v1
; CISI-NEXT:    v_madmk_f32 v0, v1, 0xcf800000, v0
; CISI-NEXT:    v_cvt_u32_f32_e32 v1, v1
; CISI-NEXT:    v_cvt_u32_f32_e32 v0, v0
; CISI-NEXT:    v_mul_lo_u32 v2, s0, v1
; CISI-NEXT:    v_mul_hi_u32 v3, s0, v0
; CISI-NEXT:    v_mul_lo_u32 v5, s1, v0
; CISI-NEXT:    v_mul_lo_u32 v4, s0, v0
; CISI-NEXT:    v_add_i32_e32 v2, vcc, v2, v3
; CISI-NEXT:    v_add_i32_e32 v2, vcc, v2, v5
; CISI-NEXT:    v_mul_hi_u32 v3, v0, v4
; CISI-NEXT:    v_mul_lo_u32 v5, v0, v2
; CISI-NEXT:    v_mul_hi_u32 v7, v0, v2
; CISI-NEXT:    v_mul_lo_u32 v6, v1, v4
; CISI-NEXT:    v_mul_hi_u32 v4, v1, v4
; CISI-NEXT:    v_add_i32_e32 v3, vcc, v3, v5
; CISI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v7, vcc
; CISI-NEXT:    v_mul_hi_u32 v7, v1, v2
; CISI-NEXT:    v_mul_lo_u32 v2, v1, v2
; CISI-NEXT:    v_add_i32_e32 v3, vcc, v3, v6
; CISI-NEXT:    v_addc_u32_e32 v3, vcc, v5, v4, vcc
; CISI-NEXT:    v_addc_u32_e32 v4, vcc, 0, v7, vcc
; CISI-NEXT:    v_add_i32_e32 v2, vcc, v3, v2
; CISI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v4, vcc
; CISI-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; CISI-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; CISI-NEXT:    v_mul_lo_u32 v2, s0, v1
; CISI-NEXT:    v_mul_hi_u32 v3, s0, v0
; CISI-NEXT:    v_mul_lo_u32 v4, s1, v0
; CISI-NEXT:    v_add_i32_e32 v2, vcc, v2, v3
; CISI-NEXT:    v_mul_lo_u32 v3, s0, v0
; CISI-NEXT:    v_add_i32_e32 v2, vcc, v2, v4
; CISI-NEXT:    v_mul_lo_u32 v6, v0, v2
; CISI-NEXT:    v_mul_hi_u32 v7, v0, v3
; CISI-NEXT:    v_mul_hi_u32 v8, v0, v2
; CISI-NEXT:    v_mul_hi_u32 v5, v1, v3
; CISI-NEXT:    v_mul_lo_u32 v3, v1, v3
; CISI-NEXT:    v_mul_hi_u32 v4, v1, v2
; CISI-NEXT:    v_add_i32_e32 v6, vcc, v7, v6
; CISI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v8, vcc
; CISI-NEXT:    v_mul_lo_u32 v2, v1, v2
; CISI-NEXT:    v_add_i32_e32 v3, vcc, v6, v3
; CISI-NEXT:    v_addc_u32_e32 v3, vcc, v7, v5, vcc
; CISI-NEXT:    v_addc_u32_e32 v4, vcc, 0, v4, vcc
; CISI-NEXT:    v_add_i32_e32 v2, vcc, v3, v2
; CISI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v4, vcc
; CISI-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; CISI-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; CISI-NEXT:    v_mul_lo_u32 v2, s10, v1
; CISI-NEXT:    v_mul_hi_u32 v3, s10, v0
; CISI-NEXT:    v_mul_hi_u32 v4, s10, v1
; CISI-NEXT:    v_mul_hi_u32 v5, s11, v1
; CISI-NEXT:    v_mul_lo_u32 v1, s11, v1
; CISI-NEXT:    v_add_i32_e32 v2, vcc, v3, v2
; CISI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v4, vcc
; CISI-NEXT:    v_mul_lo_u32 v4, s11, v0
; CISI-NEXT:    v_mul_hi_u32 v0, s11, v0
; CISI-NEXT:    v_add_i32_e32 v2, vcc, v2, v4
; CISI-NEXT:    v_addc_u32_e32 v0, vcc, v3, v0, vcc
; CISI-NEXT:    v_addc_u32_e32 v2, vcc, 0, v5, vcc
; CISI-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; CISI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v2, vcc
; CISI-NEXT:    v_mul_lo_u32 v2, s2, v1
; CISI-NEXT:    v_mul_hi_u32 v3, s2, v0
; CISI-NEXT:    v_mul_lo_u32 v4, s3, v0
; CISI-NEXT:    v_mov_b32_e32 v5, s3
; CISI-NEXT:    v_add_i32_e32 v2, vcc, v2, v3
; CISI-NEXT:    v_mul_lo_u32 v3, s2, v0
; CISI-NEXT:    v_add_i32_e32 v2, vcc, v4, v2
; CISI-NEXT:    v_sub_i32_e32 v4, vcc, s11, v2
; CISI-NEXT:    v_sub_i32_e32 v3, vcc, s10, v3
; CISI-NEXT:    v_subb_u32_e64 v4, s[0:1], v4, v5, vcc
; CISI-NEXT:    v_subrev_i32_e64 v5, s[0:1], s2, v3
; CISI-NEXT:    v_subbrev_u32_e64 v4, s[0:1], 0, v4, s[0:1]
; CISI-NEXT:    v_cmp_le_u32_e64 s[0:1], s3, v4
; CISI-NEXT:    v_cndmask_b32_e64 v6, 0, -1, s[0:1]
; CISI-NEXT:    v_cmp_le_u32_e64 s[0:1], s2, v5
; CISI-NEXT:    v_cndmask_b32_e64 v5, 0, -1, s[0:1]
; CISI-NEXT:    v_cmp_eq_u32_e64 s[0:1], s3, v4
; CISI-NEXT:    v_cndmask_b32_e64 v4, v6, v5, s[0:1]
; CISI-NEXT:    v_add_i32_e64 v5, s[0:1], 1, v0
; CISI-NEXT:    v_addc_u32_e64 v6, s[0:1], 0, v1, s[0:1]
; CISI-NEXT:    v_add_i32_e64 v7, s[0:1], 2, v0
; CISI-NEXT:    v_addc_u32_e64 v8, s[0:1], 0, v1, s[0:1]
; CISI-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, v4
; CISI-NEXT:    v_cndmask_b32_e64 v4, v5, v7, s[0:1]
; CISI-NEXT:    v_cndmask_b32_e64 v5, v6, v8, s[0:1]
; CISI-NEXT:    v_mov_b32_e32 v6, s11
; CISI-NEXT:    v_subb_u32_e32 v2, vcc, v6, v2, vcc
; CISI-NEXT:    v_cmp_le_u32_e32 vcc, s3, v2
; CISI-NEXT:    v_cndmask_b32_e64 v6, 0, -1, vcc
; CISI-NEXT:    v_cmp_le_u32_e32 vcc, s2, v3
; CISI-NEXT:    v_cndmask_b32_e64 v3, 0, -1, vcc
; CISI-NEXT:    v_cmp_eq_u32_e32 vcc, s3, v2
; CISI-NEXT:    v_cndmask_b32_e32 v2, v6, v3, vcc
; CISI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; CISI-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; CISI-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; CISI-NEXT:    s_cbranch_execnz .LBB16_3
; CISI-NEXT:  .LBB16_2:
; CISI-NEXT:    v_cvt_f32_u32_e32 v0, s2
; CISI-NEXT:    s_sub_i32 s0, 0, s2
; CISI-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; CISI-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; CISI-NEXT:    v_cvt_u32_f32_e32 v0, v0
; CISI-NEXT:    v_mul_lo_u32 v1, s0, v0
; CISI-NEXT:    v_mul_hi_u32 v1, v0, v1
; CISI-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; CISI-NEXT:    v_mul_hi_u32 v0, s10, v0
; CISI-NEXT:    v_readfirstlane_b32 s0, v0
; CISI-NEXT:    s_mul_i32 s0, s0, s2
; CISI-NEXT:    s_sub_i32 s0, s10, s0
; CISI-NEXT:    s_sub_i32 s1, s0, s2
; CISI-NEXT:    v_add_i32_e32 v1, vcc, 1, v0
; CISI-NEXT:    s_cmp_ge_u32 s0, s2
; CISI-NEXT:    s_cselect_b64 vcc, -1, 0
; CISI-NEXT:    s_cselect_b32 s0, s1, s0
; CISI-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; CISI-NEXT:    v_add_i32_e32 v1, vcc, 1, v0
; CISI-NEXT:    s_cmp_ge_u32 s0, s2
; CISI-NEXT:    s_cselect_b64 vcc, -1, 0
; CISI-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; CISI-NEXT:    v_mov_b32_e32 v1, 0
; CISI-NEXT:  .LBB16_3:
; CISI-NEXT:    s_mov_b32 s11, 0xf000
; CISI-NEXT:    s_mov_b32 s10, -1
; CISI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0
; CISI-NEXT:    s_endpgm
; CISI-NEXT:  .LBB16_4:
; CISI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; CISI-NEXT:    s_branch .LBB16_2
;
; VI-LABEL: sudiv64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x24
; VI-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_or_b64 s[0:1], s[10:11], s[2:3]
; VI-NEXT:    s_mov_b32 s0, 0
; VI-NEXT:    s_cmp_lg_u64 s[0:1], 0
; VI-NEXT:    s_cbranch_scc0 .LBB16_4
; VI-NEXT:  ; %bb.1:
; VI-NEXT:    v_cvt_f32_u32_e32 v0, s2
; VI-NEXT:    v_cvt_f32_u32_e32 v1, s3
; VI-NEXT:    s_sub_u32 s4, 0, s2
; VI-NEXT:    s_subb_u32 s5, 0, s3
; VI-NEXT:    v_madmk_f32 v0, v1, 0x4f800000, v0
; VI-NEXT:    v_rcp_f32_e32 v0, v0
; VI-NEXT:    v_mul_f32_e32 v0, 0x5f7ffffc, v0
; VI-NEXT:    v_mul_f32_e32 v1, 0x2f800000, v0
; VI-NEXT:    v_trunc_f32_e32 v1, v1
; VI-NEXT:    v_madmk_f32 v0, v1, 0xcf800000, v0
; VI-NEXT:    v_cvt_u32_f32_e32 v4, v1
; VI-NEXT:    v_cvt_u32_f32_e32 v5, v0
; VI-NEXT:    v_mul_lo_u32 v2, s4, v4
; VI-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], s4, v5, 0
; VI-NEXT:    v_mul_lo_u32 v3, s5, v5
; VI-NEXT:    v_add_u32_e32 v1, vcc, v1, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, v1, v3
; VI-NEXT:    v_mul_hi_u32 v6, v5, v0
; VI-NEXT:    v_mad_u64_u32 v[1:2], s[0:1], v5, v3, 0
; VI-NEXT:    v_add_u32_e32 v6, vcc, v6, v1
; VI-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], v4, v0, 0
; VI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v2, vcc
; VI-NEXT:    v_mad_u64_u32 v[2:3], s[0:1], v4, v3, 0
; VI-NEXT:    v_add_u32_e32 v0, vcc, v6, v0
; VI-NEXT:    v_addc_u32_e32 v0, vcc, v7, v1, vcc
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v3, vcc
; VI-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    v_add_u32_e32 v6, vcc, v5, v0
; VI-NEXT:    v_addc_u32_e32 v7, vcc, v4, v1, vcc
; VI-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], s4, v6, 0
; VI-NEXT:    v_mul_lo_u32 v4, s4, v7
; VI-NEXT:    v_mul_lo_u32 v5, s5, v6
; VI-NEXT:    v_mul_hi_u32 v8, v6, v0
; VI-NEXT:    v_mad_u64_u32 v[2:3], s[0:1], v7, v0, 0
; VI-NEXT:    v_add_u32_e32 v1, vcc, v4, v1
; VI-NEXT:    v_add_u32_e32 v1, vcc, v1, v5
; VI-NEXT:    v_mad_u64_u32 v[4:5], s[0:1], v6, v1, 0
; VI-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], v7, v1, 0
; VI-NEXT:    v_add_u32_e32 v4, vcc, v8, v4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, v4, v2
; VI-NEXT:    v_addc_u32_e32 v2, vcc, v5, v3, vcc
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    v_add_u32_e32 v0, vcc, v2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, v6, v0
; VI-NEXT:    v_addc_u32_e32 v3, vcc, v7, v1, vcc
; VI-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], s10, v3, 0
; VI-NEXT:    v_mul_hi_u32 v4, s10, v2
; VI-NEXT:    v_readfirstlane_b32 s4, v1
; VI-NEXT:    v_readfirstlane_b32 s5, v0
; VI-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], s11, v3, 0
; VI-NEXT:    v_mad_u64_u32 v[2:3], s[0:1], s11, v2, 0
; VI-NEXT:    v_readfirstlane_b32 s6, v4
; VI-NEXT:    s_add_u32 s0, s6, s5
; VI-NEXT:    s_addc_u32 s1, 0, s4
; VI-NEXT:    v_readfirstlane_b32 s6, v2
; VI-NEXT:    v_readfirstlane_b32 s5, v3
; VI-NEXT:    s_add_u32 s0, s0, s6
; VI-NEXT:    v_readfirstlane_b32 s4, v1
; VI-NEXT:    s_addc_u32 s0, s1, s5
; VI-NEXT:    s_addc_u32 s6, s4, 0
; VI-NEXT:    v_readfirstlane_b32 s1, v0
; VI-NEXT:    s_add_u32 s7, s0, s1
; VI-NEXT:    v_mov_b32_e32 v2, s7
; VI-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], s2, v2, 0
; VI-NEXT:    s_addc_u32 s6, 0, s6
; VI-NEXT:    s_mul_i32 s0, s2, s6
; VI-NEXT:    v_readfirstlane_b32 s1, v1
; VI-NEXT:    s_add_i32 s0, s1, s0
; VI-NEXT:    s_mul_i32 s1, s3, s7
; VI-NEXT:    s_add_i32 s12, s0, s1
; VI-NEXT:    s_sub_i32 s0, s11, s12
; VI-NEXT:    v_sub_u32_e32 v0, vcc, s10, v0
; VI-NEXT:    s_cmp_lg_u64 vcc, 0
; VI-NEXT:    s_subb_u32 s13, s0, s3
; VI-NEXT:    v_subrev_u32_e64 v1, s[0:1], s2, v0
; VI-NEXT:    s_cmp_lg_u64 s[0:1], 0
; VI-NEXT:    s_subb_u32 s13, s13, 0
; VI-NEXT:    s_cmp_ge_u32 s13, s3
; VI-NEXT:    s_cselect_b32 s14, -1, 0
; VI-NEXT:    v_cmp_le_u32_e64 s[0:1], s2, v1
; VI-NEXT:    s_cmp_eq_u32 s13, s3
; VI-NEXT:    v_cndmask_b32_e64 v1, 0, -1, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, s14
; VI-NEXT:    s_cselect_b64 s[0:1], -1, 0
; VI-NEXT:    v_cndmask_b32_e64 v1, v3, v1, s[0:1]
; VI-NEXT:    s_add_u32 s0, s7, 1
; VI-NEXT:    s_addc_u32 s13, s6, 0
; VI-NEXT:    s_add_u32 s1, s7, 2
; VI-NEXT:    s_addc_u32 s7, s6, 0
; VI-NEXT:    v_mov_b32_e32 v3, s0
; VI-NEXT:    v_mov_b32_e32 v4, s1
; VI-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, v1
; VI-NEXT:    v_cndmask_b32_e64 v3, v3, v4, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v1, s13
; VI-NEXT:    v_mov_b32_e32 v4, s7
; VI-NEXT:    s_cmp_lg_u64 vcc, 0
; VI-NEXT:    v_cndmask_b32_e64 v1, v1, v4, s[0:1]
; VI-NEXT:    s_subb_u32 s0, s11, s12
; VI-NEXT:    s_cmp_ge_u32 s0, s3
; VI-NEXT:    s_cselect_b32 s1, -1, 0
; VI-NEXT:    v_cmp_le_u32_e32 vcc, s2, v0
; VI-NEXT:    s_cmp_eq_u32 s0, s3
; VI-NEXT:    v_cndmask_b32_e64 v0, 0, -1, vcc
; VI-NEXT:    v_mov_b32_e32 v4, s1
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; VI-NEXT:    v_mov_b32_e32 v4, s6
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v1, v4, v1, vcc
; VI-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; VI-NEXT:    s_cbranch_execnz .LBB16_3
; VI-NEXT:  .LBB16_2:
; VI-NEXT:    v_cvt_f32_u32_e32 v0, s2
; VI-NEXT:    s_sub_i32 s0, 0, s2
; VI-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; VI-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; VI-NEXT:    v_cvt_u32_f32_e32 v0, v0
; VI-NEXT:    v_mul_lo_u32 v1, s0, v0
; VI-NEXT:    v_mul_hi_u32 v1, v0, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, v0, v1
; VI-NEXT:    v_mul_hi_u32 v0, s10, v0
; VI-NEXT:    v_readfirstlane_b32 s0, v0
; VI-NEXT:    s_mul_i32 s0, s0, s2
; VI-NEXT:    s_sub_i32 s0, s10, s0
; VI-NEXT:    s_sub_i32 s1, s0, s2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 1, v0
; VI-NEXT:    s_cmp_ge_u32 s0, s2
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cselect_b32 s0, s1, s0
; VI-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; VI-NEXT:    v_add_u32_e32 v1, vcc, 1, v0
; VI-NEXT:    s_cmp_ge_u32 s0, s2
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; VI-NEXT:    v_mov_b32_e32 v1, 0
; VI-NEXT:  .LBB16_3:
; VI-NEXT:    v_mov_b32_e32 v2, s8
; VI-NEXT:    v_mov_b32_e32 v3, s9
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
; VI-NEXT:  .LBB16_4:
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; VI-NEXT:    s_branch .LBB16_2
;
; GFX9-LABEL: sudiv64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x34
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_or_b64 s[0:1], s[10:11], s[2:3]
; GFX9-NEXT:    s_mov_b32 s0, 0
; GFX9-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB16_4
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    v_cvt_f32_u32_e32 v0, s2
; GFX9-NEXT:    v_cvt_f32_u32_e32 v1, s3
; GFX9-NEXT:    s_sub_u32 s0, 0, s2
; GFX9-NEXT:    s_subb_u32 s1, 0, s3
; GFX9-NEXT:    v_madmk_f32 v0, v1, 0x4f800000, v0
; GFX9-NEXT:    v_rcp_f32_e32 v0, v0
; GFX9-NEXT:    v_mul_f32_e32 v0, 0x5f7ffffc, v0
; GFX9-NEXT:    v_mul_f32_e32 v1, 0x2f800000, v0
; GFX9-NEXT:    v_trunc_f32_e32 v1, v1
; GFX9-NEXT:    v_madmk_f32 v0, v1, 0xcf800000, v0
; GFX9-NEXT:    v_cvt_u32_f32_e32 v1, v1
; GFX9-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GFX9-NEXT:    v_readfirstlane_b32 s6, v1
; GFX9-NEXT:    v_readfirstlane_b32 s7, v0
; GFX9-NEXT:    s_mul_i32 s12, s0, s6
; GFX9-NEXT:    s_mul_hi_u32 s14, s0, s7
; GFX9-NEXT:    s_mul_i32 s13, s1, s7
; GFX9-NEXT:    s_add_i32 s12, s14, s12
; GFX9-NEXT:    s_add_i32 s12, s12, s13
; GFX9-NEXT:    s_mul_i32 s15, s0, s7
; GFX9-NEXT:    s_mul_hi_u32 s13, s7, s12
; GFX9-NEXT:    s_mul_i32 s14, s7, s12
; GFX9-NEXT:    s_mul_hi_u32 s7, s7, s15
; GFX9-NEXT:    s_add_u32 s7, s7, s14
; GFX9-NEXT:    s_addc_u32 s13, 0, s13
; GFX9-NEXT:    s_mul_hi_u32 s16, s6, s15
; GFX9-NEXT:    s_mul_i32 s15, s6, s15
; GFX9-NEXT:    s_add_u32 s7, s7, s15
; GFX9-NEXT:    s_mul_hi_u32 s14, s6, s12
; GFX9-NEXT:    s_addc_u32 s7, s13, s16
; GFX9-NEXT:    s_addc_u32 s13, s14, 0
; GFX9-NEXT:    s_mul_i32 s12, s6, s12
; GFX9-NEXT:    s_add_u32 s7, s7, s12
; GFX9-NEXT:    s_addc_u32 s12, 0, s13
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, s7, v0
; GFX9-NEXT:    s_cmp_lg_u64 vcc, 0
; GFX9-NEXT:    s_addc_u32 s6, s6, s12
; GFX9-NEXT:    v_readfirstlane_b32 s12, v0
; GFX9-NEXT:    s_mul_i32 s7, s0, s6
; GFX9-NEXT:    s_mul_hi_u32 s13, s0, s12
; GFX9-NEXT:    s_add_i32 s7, s13, s7
; GFX9-NEXT:    s_mul_i32 s1, s1, s12
; GFX9-NEXT:    s_add_i32 s7, s7, s1
; GFX9-NEXT:    s_mul_i32 s0, s0, s12
; GFX9-NEXT:    s_mul_hi_u32 s13, s6, s0
; GFX9-NEXT:    s_mul_i32 s14, s6, s0
; GFX9-NEXT:    s_mul_i32 s16, s12, s7
; GFX9-NEXT:    s_mul_hi_u32 s0, s12, s0
; GFX9-NEXT:    s_mul_hi_u32 s15, s12, s7
; GFX9-NEXT:    s_add_u32 s0, s0, s16
; GFX9-NEXT:    s_addc_u32 s12, 0, s15
; GFX9-NEXT:    s_add_u32 s0, s0, s14
; GFX9-NEXT:    s_mul_hi_u32 s1, s6, s7
; GFX9-NEXT:    s_addc_u32 s0, s12, s13
; GFX9-NEXT:    s_addc_u32 s1, s1, 0
; GFX9-NEXT:    s_mul_i32 s7, s6, s7
; GFX9-NEXT:    s_add_u32 s0, s0, s7
; GFX9-NEXT:    s_addc_u32 s1, 0, s1
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, s0, v0
; GFX9-NEXT:    s_cmp_lg_u64 vcc, 0
; GFX9-NEXT:    s_addc_u32 s0, s6, s1
; GFX9-NEXT:    v_readfirstlane_b32 s7, v0
; GFX9-NEXT:    s_mul_i32 s6, s10, s0
; GFX9-NEXT:    s_mul_hi_u32 s12, s10, s7
; GFX9-NEXT:    s_mul_hi_u32 s1, s10, s0
; GFX9-NEXT:    s_add_u32 s6, s12, s6
; GFX9-NEXT:    s_addc_u32 s1, 0, s1
; GFX9-NEXT:    s_mul_hi_u32 s13, s11, s7
; GFX9-NEXT:    s_mul_i32 s7, s11, s7
; GFX9-NEXT:    s_add_u32 s6, s6, s7
; GFX9-NEXT:    s_mul_hi_u32 s12, s11, s0
; GFX9-NEXT:    s_addc_u32 s1, s1, s13
; GFX9-NEXT:    s_addc_u32 s6, s12, 0
; GFX9-NEXT:    s_mul_i32 s0, s11, s0
; GFX9-NEXT:    s_add_u32 s7, s1, s0
; GFX9-NEXT:    s_addc_u32 s6, 0, s6
; GFX9-NEXT:    s_mul_i32 s0, s2, s6
; GFX9-NEXT:    s_mul_hi_u32 s1, s2, s7
; GFX9-NEXT:    s_add_i32 s0, s1, s0
; GFX9-NEXT:    s_mul_i32 s1, s3, s7
; GFX9-NEXT:    s_add_i32 s12, s0, s1
; GFX9-NEXT:    s_mul_i32 s1, s2, s7
; GFX9-NEXT:    v_mov_b32_e32 v0, s1
; GFX9-NEXT:    s_sub_i32 s0, s11, s12
; GFX9-NEXT:    v_sub_co_u32_e32 v0, vcc, s10, v0
; GFX9-NEXT:    s_cmp_lg_u64 vcc, 0
; GFX9-NEXT:    s_subb_u32 s13, s0, s3
; GFX9-NEXT:    v_subrev_co_u32_e64 v1, s[0:1], s2, v0
; GFX9-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX9-NEXT:    s_subb_u32 s13, s13, 0
; GFX9-NEXT:    s_cmp_ge_u32 s13, s3
; GFX9-NEXT:    s_cselect_b32 s14, -1, 0
; GFX9-NEXT:    v_cmp_le_u32_e64 s[0:1], s2, v1
; GFX9-NEXT:    s_cmp_eq_u32 s13, s3
; GFX9-NEXT:    v_cndmask_b32_e64 v1, 0, -1, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v2, s14
; GFX9-NEXT:    s_cselect_b64 s[0:1], -1, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v2, v1, s[0:1]
; GFX9-NEXT:    s_add_u32 s0, s7, 1
; GFX9-NEXT:    s_addc_u32 s13, s6, 0
; GFX9-NEXT:    s_add_u32 s1, s7, 2
; GFX9-NEXT:    s_addc_u32 s14, s6, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, s0
; GFX9-NEXT:    v_mov_b32_e32 v3, s1
; GFX9-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, v1
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, v3, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v1, s13
; GFX9-NEXT:    v_mov_b32_e32 v3, s14
; GFX9-NEXT:    s_cmp_lg_u64 vcc, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, v3, s[0:1]
; GFX9-NEXT:    s_subb_u32 s0, s11, s12
; GFX9-NEXT:    s_cmp_ge_u32 s0, s3
; GFX9-NEXT:    s_cselect_b32 s1, -1, 0
; GFX9-NEXT:    v_cmp_le_u32_e32 vcc, s2, v0
; GFX9-NEXT:    s_cmp_eq_u32 s0, s3
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 0, -1, vcc
; GFX9-NEXT:    v_mov_b32_e32 v3, s1
; GFX9-NEXT:    s_cselect_b64 vcc, -1, 0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX9-NEXT:    v_mov_b32_e32 v3, s6
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s7
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX9-NEXT:    s_cbranch_execnz .LBB16_3
; GFX9-NEXT:  .LBB16_2:
; GFX9-NEXT:    v_cvt_f32_u32_e32 v0, s2
; GFX9-NEXT:    s_sub_i32 s0, 0, s2
; GFX9-NEXT:    s_mov_b32 s1, 0
; GFX9-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; GFX9-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; GFX9-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GFX9-NEXT:    v_readfirstlane_b32 s3, v0
; GFX9-NEXT:    s_mul_i32 s0, s0, s3
; GFX9-NEXT:    s_mul_hi_u32 s0, s3, s0
; GFX9-NEXT:    s_add_i32 s3, s3, s0
; GFX9-NEXT:    s_mul_hi_u32 s0, s10, s3
; GFX9-NEXT:    s_mul_i32 s4, s0, s2
; GFX9-NEXT:    s_sub_i32 s4, s10, s4
; GFX9-NEXT:    s_add_i32 s3, s0, 1
; GFX9-NEXT:    s_sub_i32 s5, s4, s2
; GFX9-NEXT:    s_cmp_ge_u32 s4, s2
; GFX9-NEXT:    s_cselect_b32 s0, s3, s0
; GFX9-NEXT:    s_cselect_b32 s4, s5, s4
; GFX9-NEXT:    s_add_i32 s3, s0, 1
; GFX9-NEXT:    s_cmp_ge_u32 s4, s2
; GFX9-NEXT:    s_cselect_b32 s0, s3, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:  .LBB16_3:
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[8:9]
; GFX9-NEXT:    s_endpgm
; GFX9-NEXT:  .LBB16_4:
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX9-NEXT:    s_branch .LBB16_2
;
; GFX1010-LABEL: sudiv64:
; GFX1010:       ; %bb.0:
; GFX1010-NEXT:    s_clause 0x1
; GFX1010-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x24
; GFX1010-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x34
; GFX1010-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-NEXT:    s_or_b64 s[4:5], s[10:11], s[2:3]
; GFX1010-NEXT:    s_mov_b32 s4, 0
; GFX1010-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX1010-NEXT:    s_cbranch_scc0 .LBB16_4
; GFX1010-NEXT:  ; %bb.1:
; GFX1010-NEXT:    v_cvt_f32_u32_e32 v0, s2
; GFX1010-NEXT:    v_cvt_f32_u32_e32 v1, s3
; GFX1010-NEXT:    s_sub_u32 s5, 0, s2
; GFX1010-NEXT:    s_subb_u32 s6, 0, s3
; GFX1010-NEXT:    v_madmk_f32 v0, v1, 0x4f800000, v0
; GFX1010-NEXT:    v_rcp_f32_e32 v0, v0
; GFX1010-NEXT:    v_mul_f32_e32 v0, 0x5f7ffffc, v0
; GFX1010-NEXT:    v_mul_f32_e32 v1, 0x2f800000, v0
; GFX1010-NEXT:    v_trunc_f32_e32 v1, v1
; GFX1010-NEXT:    v_madmk_f32 v0, v1, 0xcf800000, v0
; GFX1010-NEXT:    v_cvt_u32_f32_e32 v1, v1
; GFX1010-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GFX1010-NEXT:    v_readfirstlane_b32 s0, v1
; GFX1010-NEXT:    v_readfirstlane_b32 s1, v0
; GFX1010-NEXT:    s_mul_i32 s7, s5, s0
; GFX1010-NEXT:    s_mul_hi_u32 s13, s5, s1
; GFX1010-NEXT:    s_mul_i32 s12, s6, s1
; GFX1010-NEXT:    s_add_i32 s7, s13, s7
; GFX1010-NEXT:    s_mul_i32 s14, s5, s1
; GFX1010-NEXT:    s_add_i32 s7, s7, s12
; GFX1010-NEXT:    s_mul_hi_u32 s13, s1, s14
; GFX1010-NEXT:    s_mul_hi_u32 s15, s0, s14
; GFX1010-NEXT:    s_mul_i32 s12, s0, s14
; GFX1010-NEXT:    s_mul_hi_u32 s14, s1, s7
; GFX1010-NEXT:    s_mul_i32 s1, s1, s7
; GFX1010-NEXT:    s_mul_hi_u32 s16, s0, s7
; GFX1010-NEXT:    s_add_u32 s1, s13, s1
; GFX1010-NEXT:    s_addc_u32 s13, 0, s14
; GFX1010-NEXT:    s_add_u32 s1, s1, s12
; GFX1010-NEXT:    s_mul_i32 s7, s0, s7
; GFX1010-NEXT:    s_addc_u32 s1, s13, s15
; GFX1010-NEXT:    s_addc_u32 s12, s16, 0
; GFX1010-NEXT:    s_add_u32 s1, s1, s7
; GFX1010-NEXT:    s_addc_u32 s7, 0, s12
; GFX1010-NEXT:    v_add_co_u32 v0, s1, v0, s1
; GFX1010-NEXT:    s_cmp_lg_u32 s1, 0
; GFX1010-NEXT:    s_addc_u32 s0, s0, s7
; GFX1010-NEXT:    v_readfirstlane_b32 s1, v0
; GFX1010-NEXT:    s_mul_i32 s7, s5, s0
; GFX1010-NEXT:    s_mul_hi_u32 s12, s5, s1
; GFX1010-NEXT:    s_mul_i32 s6, s6, s1
; GFX1010-NEXT:    s_add_i32 s7, s12, s7
; GFX1010-NEXT:    s_mul_i32 s5, s5, s1
; GFX1010-NEXT:    s_add_i32 s7, s7, s6
; GFX1010-NEXT:    s_mul_hi_u32 s12, s0, s5
; GFX1010-NEXT:    s_mul_i32 s13, s0, s5
; GFX1010-NEXT:    s_mul_hi_u32 s5, s1, s5
; GFX1010-NEXT:    s_mul_hi_u32 s14, s1, s7
; GFX1010-NEXT:    s_mul_i32 s1, s1, s7
; GFX1010-NEXT:    s_mul_hi_u32 s6, s0, s7
; GFX1010-NEXT:    s_add_u32 s1, s5, s1
; GFX1010-NEXT:    s_addc_u32 s5, 0, s14
; GFX1010-NEXT:    s_add_u32 s1, s1, s13
; GFX1010-NEXT:    s_mul_i32 s7, s0, s7
; GFX1010-NEXT:    s_addc_u32 s1, s5, s12
; GFX1010-NEXT:    s_addc_u32 s5, s6, 0
; GFX1010-NEXT:    s_add_u32 s1, s1, s7
; GFX1010-NEXT:    s_addc_u32 s5, 0, s5
; GFX1010-NEXT:    v_add_co_u32 v0, s1, v0, s1
; GFX1010-NEXT:    s_cmp_lg_u32 s1, 0
; GFX1010-NEXT:    s_addc_u32 s0, s0, s5
; GFX1010-NEXT:    v_readfirstlane_b32 s1, v0
; GFX1010-NEXT:    s_mul_i32 s6, s10, s0
; GFX1010-NEXT:    s_mul_hi_u32 s5, s10, s0
; GFX1010-NEXT:    s_mul_hi_u32 s7, s11, s0
; GFX1010-NEXT:    s_mul_i32 s0, s11, s0
; GFX1010-NEXT:    s_mul_hi_u32 s12, s10, s1
; GFX1010-NEXT:    s_mul_hi_u32 s13, s11, s1
; GFX1010-NEXT:    s_mul_i32 s1, s11, s1
; GFX1010-NEXT:    s_add_u32 s6, s12, s6
; GFX1010-NEXT:    s_addc_u32 s5, 0, s5
; GFX1010-NEXT:    s_add_u32 s1, s6, s1
; GFX1010-NEXT:    s_addc_u32 s1, s5, s13
; GFX1010-NEXT:    s_addc_u32 s5, s7, 0
; GFX1010-NEXT:    s_add_u32 s1, s1, s0
; GFX1010-NEXT:    s_addc_u32 s5, 0, s5
; GFX1010-NEXT:    s_mul_hi_u32 s0, s2, s1
; GFX1010-NEXT:    s_mul_i32 s7, s2, s5
; GFX1010-NEXT:    s_mul_i32 s12, s2, s1
; GFX1010-NEXT:    s_add_i32 s0, s0, s7
; GFX1010-NEXT:    v_sub_co_u32 v0, s7, s10, s12
; GFX1010-NEXT:    s_mul_i32 s6, s3, s1
; GFX1010-NEXT:    s_add_i32 s0, s0, s6
; GFX1010-NEXT:    v_sub_co_u32 v1, s12, v0, s2
; GFX1010-NEXT:    s_sub_i32 s6, s11, s0
; GFX1010-NEXT:    s_cmp_lg_u32 s7, 0
; GFX1010-NEXT:    s_subb_u32 s6, s6, s3
; GFX1010-NEXT:    s_cmp_lg_u32 s12, 0
; GFX1010-NEXT:    v_cmp_le_u32_e32 vcc_lo, s2, v1
; GFX1010-NEXT:    s_subb_u32 s6, s6, 0
; GFX1010-NEXT:    s_cmp_ge_u32 s6, s3
; GFX1010-NEXT:    v_cndmask_b32_e64 v1, 0, -1, vcc_lo
; GFX1010-NEXT:    s_cselect_b32 s12, -1, 0
; GFX1010-NEXT:    s_cmp_eq_u32 s6, s3
; GFX1010-NEXT:    s_cselect_b32 vcc_lo, -1, 0
; GFX1010-NEXT:    s_add_u32 s6, s1, 1
; GFX1010-NEXT:    v_cndmask_b32_e32 v1, s12, v1, vcc_lo
; GFX1010-NEXT:    s_addc_u32 s12, s5, 0
; GFX1010-NEXT:    s_add_u32 s13, s1, 2
; GFX1010-NEXT:    s_addc_u32 s14, s5, 0
; GFX1010-NEXT:    s_cmp_lg_u32 s7, 0
; GFX1010-NEXT:    v_cmp_le_u32_e32 vcc_lo, s2, v0
; GFX1010-NEXT:    s_subb_u32 s0, s11, s0
; GFX1010-NEXT:    v_mov_b32_e32 v2, s13
; GFX1010-NEXT:    s_cmp_ge_u32 s0, s3
; GFX1010-NEXT:    v_cndmask_b32_e64 v0, 0, -1, vcc_lo
; GFX1010-NEXT:    s_cselect_b32 s7, -1, 0
; GFX1010-NEXT:    s_cmp_eq_u32 s0, s3
; GFX1010-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v1
; GFX1010-NEXT:    s_cselect_b32 s0, -1, 0
; GFX1010-NEXT:    v_mov_b32_e32 v1, s14
; GFX1010-NEXT:    v_cndmask_b32_e64 v0, s7, v0, s0
; GFX1010-NEXT:    v_cndmask_b32_e32 v2, s6, v2, vcc_lo
; GFX1010-NEXT:    v_cndmask_b32_e32 v1, s12, v1, vcc_lo
; GFX1010-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v0
; GFX1010-NEXT:    v_cndmask_b32_e32 v1, s5, v1, vcc_lo
; GFX1010-NEXT:    v_cndmask_b32_e32 v0, s1, v2, vcc_lo
; GFX1010-NEXT:    s_andn2_b32 vcc_lo, exec_lo, s4
; GFX1010-NEXT:    s_cbranch_vccnz .LBB16_3
; GFX1010-NEXT:  .LBB16_2:
; GFX1010-NEXT:    v_cvt_f32_u32_e32 v0, s2
; GFX1010-NEXT:    s_sub_i32 s1, 0, s2
; GFX1010-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; GFX1010-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; GFX1010-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GFX1010-NEXT:    v_readfirstlane_b32 s0, v0
; GFX1010-NEXT:    s_mul_i32 s1, s1, s0
; GFX1010-NEXT:    s_mul_hi_u32 s1, s0, s1
; GFX1010-NEXT:    s_add_i32 s0, s0, s1
; GFX1010-NEXT:    s_mul_hi_u32 s0, s10, s0
; GFX1010-NEXT:    s_mul_i32 s1, s0, s2
; GFX1010-NEXT:    s_add_i32 s3, s0, 1
; GFX1010-NEXT:    s_sub_i32 s1, s10, s1
; GFX1010-NEXT:    s_sub_i32 s4, s1, s2
; GFX1010-NEXT:    s_cmp_ge_u32 s1, s2
; GFX1010-NEXT:    s_cselect_b32 s0, s3, s0
; GFX1010-NEXT:    s_cselect_b32 s1, s4, s1
; GFX1010-NEXT:    s_add_i32 s3, s0, 1
; GFX1010-NEXT:    s_cmp_ge_u32 s1, s2
; GFX1010-NEXT:    s_mov_b32 s1, 0
; GFX1010-NEXT:    s_cselect_b32 s0, s3, s0
; GFX1010-NEXT:    v_mov_b32_e32 v0, s0
; GFX1010-NEXT:    v_mov_b32_e32 v1, s1
; GFX1010-NEXT:  .LBB16_3:
; GFX1010-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-NEXT:    global_store_dwordx2 v2, v[0:1], s[8:9]
; GFX1010-NEXT:    s_endpgm
; GFX1010-NEXT:  .LBB16_4:
; GFX1010-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1010-NEXT:    s_branch .LBB16_2
;
; GFX1030W32-LABEL: sudiv64:
; GFX1030W32:       ; %bb.0:
; GFX1030W32-NEXT:    s_clause 0x1
; GFX1030W32-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x24
; GFX1030W32-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x34
; GFX1030W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W32-NEXT:    s_or_b64 s[4:5], s[10:11], s[2:3]
; GFX1030W32-NEXT:    s_mov_b32 s4, 0
; GFX1030W32-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX1030W32-NEXT:    s_cbranch_scc0 .LBB16_4
; GFX1030W32-NEXT:  ; %bb.1:
; GFX1030W32-NEXT:    v_cvt_f32_u32_e32 v0, s2
; GFX1030W32-NEXT:    v_cvt_f32_u32_e32 v1, s3
; GFX1030W32-NEXT:    s_sub_u32 s5, 0, s2
; GFX1030W32-NEXT:    s_subb_u32 s6, 0, s3
; GFX1030W32-NEXT:    v_fmamk_f32 v0, v1, 0x4f800000, v0
; GFX1030W32-NEXT:    v_rcp_f32_e32 v0, v0
; GFX1030W32-NEXT:    v_mul_f32_e32 v0, 0x5f7ffffc, v0
; GFX1030W32-NEXT:    v_mul_f32_e32 v1, 0x2f800000, v0
; GFX1030W32-NEXT:    v_trunc_f32_e32 v1, v1
; GFX1030W32-NEXT:    v_fmamk_f32 v0, v1, 0xcf800000, v0
; GFX1030W32-NEXT:    v_cvt_u32_f32_e32 v1, v1
; GFX1030W32-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GFX1030W32-NEXT:    v_readfirstlane_b32 s0, v1
; GFX1030W32-NEXT:    v_readfirstlane_b32 s1, v0
; GFX1030W32-NEXT:    s_mul_i32 s7, s5, s0
; GFX1030W32-NEXT:    s_mul_hi_u32 s13, s5, s1
; GFX1030W32-NEXT:    s_mul_i32 s12, s6, s1
; GFX1030W32-NEXT:    s_add_i32 s7, s13, s7
; GFX1030W32-NEXT:    s_mul_i32 s14, s5, s1
; GFX1030W32-NEXT:    s_add_i32 s7, s7, s12
; GFX1030W32-NEXT:    s_mul_hi_u32 s13, s1, s14
; GFX1030W32-NEXT:    s_mul_hi_u32 s15, s0, s14
; GFX1030W32-NEXT:    s_mul_i32 s12, s0, s14
; GFX1030W32-NEXT:    s_mul_hi_u32 s14, s1, s7
; GFX1030W32-NEXT:    s_mul_i32 s1, s1, s7
; GFX1030W32-NEXT:    s_mul_hi_u32 s16, s0, s7
; GFX1030W32-NEXT:    s_add_u32 s1, s13, s1
; GFX1030W32-NEXT:    s_addc_u32 s13, 0, s14
; GFX1030W32-NEXT:    s_add_u32 s1, s1, s12
; GFX1030W32-NEXT:    s_mul_i32 s7, s0, s7
; GFX1030W32-NEXT:    s_addc_u32 s1, s13, s15
; GFX1030W32-NEXT:    s_addc_u32 s12, s16, 0
; GFX1030W32-NEXT:    s_add_u32 s1, s1, s7
; GFX1030W32-NEXT:    s_addc_u32 s7, 0, s12
; GFX1030W32-NEXT:    v_add_co_u32 v0, s1, v0, s1
; GFX1030W32-NEXT:    s_cmp_lg_u32 s1, 0
; GFX1030W32-NEXT:    s_addc_u32 s0, s0, s7
; GFX1030W32-NEXT:    v_readfirstlane_b32 s1, v0
; GFX1030W32-NEXT:    s_mul_i32 s7, s5, s0
; GFX1030W32-NEXT:    s_mul_hi_u32 s12, s5, s1
; GFX1030W32-NEXT:    s_mul_i32 s6, s6, s1
; GFX1030W32-NEXT:    s_add_i32 s7, s12, s7
; GFX1030W32-NEXT:    s_mul_i32 s5, s5, s1
; GFX1030W32-NEXT:    s_add_i32 s7, s7, s6
; GFX1030W32-NEXT:    s_mul_hi_u32 s12, s0, s5
; GFX1030W32-NEXT:    s_mul_i32 s13, s0, s5
; GFX1030W32-NEXT:    s_mul_hi_u32 s5, s1, s5
; GFX1030W32-NEXT:    s_mul_hi_u32 s14, s1, s7
; GFX1030W32-NEXT:    s_mul_i32 s1, s1, s7
; GFX1030W32-NEXT:    s_mul_hi_u32 s6, s0, s7
; GFX1030W32-NEXT:    s_add_u32 s1, s5, s1
; GFX1030W32-NEXT:    s_addc_u32 s5, 0, s14
; GFX1030W32-NEXT:    s_add_u32 s1, s1, s13
; GFX1030W32-NEXT:    s_mul_i32 s7, s0, s7
; GFX1030W32-NEXT:    s_addc_u32 s1, s5, s12
; GFX1030W32-NEXT:    s_addc_u32 s5, s6, 0
; GFX1030W32-NEXT:    s_add_u32 s1, s1, s7
; GFX1030W32-NEXT:    s_addc_u32 s5, 0, s5
; GFX1030W32-NEXT:    v_add_co_u32 v0, s1, v0, s1
; GFX1030W32-NEXT:    s_cmp_lg_u32 s1, 0
; GFX1030W32-NEXT:    s_addc_u32 s0, s0, s5
; GFX1030W32-NEXT:    v_readfirstlane_b32 s1, v0
; GFX1030W32-NEXT:    s_mul_i32 s6, s10, s0
; GFX1030W32-NEXT:    s_mul_hi_u32 s5, s10, s0
; GFX1030W32-NEXT:    s_mul_hi_u32 s7, s11, s0
; GFX1030W32-NEXT:    s_mul_i32 s0, s11, s0
; GFX1030W32-NEXT:    s_mul_hi_u32 s12, s10, s1
; GFX1030W32-NEXT:    s_mul_hi_u32 s13, s11, s1
; GFX1030W32-NEXT:    s_mul_i32 s1, s11, s1
; GFX1030W32-NEXT:    s_add_u32 s6, s12, s6
; GFX1030W32-NEXT:    s_addc_u32 s5, 0, s5
; GFX1030W32-NEXT:    s_add_u32 s1, s6, s1
; GFX1030W32-NEXT:    s_addc_u32 s1, s5, s13
; GFX1030W32-NEXT:    s_addc_u32 s5, s7, 0
; GFX1030W32-NEXT:    s_add_u32 s1, s1, s0
; GFX1030W32-NEXT:    s_addc_u32 s5, 0, s5
; GFX1030W32-NEXT:    s_mul_hi_u32 s0, s2, s1
; GFX1030W32-NEXT:    s_mul_i32 s7, s2, s5
; GFX1030W32-NEXT:    s_mul_i32 s12, s2, s1
; GFX1030W32-NEXT:    s_add_i32 s0, s0, s7
; GFX1030W32-NEXT:    v_sub_co_u32 v0, s7, s10, s12
; GFX1030W32-NEXT:    s_mul_i32 s6, s3, s1
; GFX1030W32-NEXT:    s_add_i32 s0, s0, s6
; GFX1030W32-NEXT:    v_sub_co_u32 v1, s12, v0, s2
; GFX1030W32-NEXT:    s_sub_i32 s6, s11, s0
; GFX1030W32-NEXT:    s_cmp_lg_u32 s7, 0
; GFX1030W32-NEXT:    s_subb_u32 s6, s6, s3
; GFX1030W32-NEXT:    s_cmp_lg_u32 s12, 0
; GFX1030W32-NEXT:    v_cmp_le_u32_e32 vcc_lo, s2, v1
; GFX1030W32-NEXT:    s_subb_u32 s6, s6, 0
; GFX1030W32-NEXT:    s_cmp_ge_u32 s6, s3
; GFX1030W32-NEXT:    v_cndmask_b32_e64 v1, 0, -1, vcc_lo
; GFX1030W32-NEXT:    s_cselect_b32 s12, -1, 0
; GFX1030W32-NEXT:    s_cmp_eq_u32 s6, s3
; GFX1030W32-NEXT:    s_cselect_b32 vcc_lo, -1, 0
; GFX1030W32-NEXT:    s_add_u32 s6, s1, 1
; GFX1030W32-NEXT:    v_cndmask_b32_e32 v1, s12, v1, vcc_lo
; GFX1030W32-NEXT:    s_addc_u32 s12, s5, 0
; GFX1030W32-NEXT:    s_add_u32 s13, s1, 2
; GFX1030W32-NEXT:    s_addc_u32 s14, s5, 0
; GFX1030W32-NEXT:    s_cmp_lg_u32 s7, 0
; GFX1030W32-NEXT:    v_cmp_le_u32_e32 vcc_lo, s2, v0
; GFX1030W32-NEXT:    s_subb_u32 s0, s11, s0
; GFX1030W32-NEXT:    v_mov_b32_e32 v2, s13
; GFX1030W32-NEXT:    s_cmp_ge_u32 s0, s3
; GFX1030W32-NEXT:    v_cndmask_b32_e64 v0, 0, -1, vcc_lo
; GFX1030W32-NEXT:    s_cselect_b32 s7, -1, 0
; GFX1030W32-NEXT:    s_cmp_eq_u32 s0, s3
; GFX1030W32-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v1
; GFX1030W32-NEXT:    s_cselect_b32 s0, -1, 0
; GFX1030W32-NEXT:    v_mov_b32_e32 v1, s14
; GFX1030W32-NEXT:    v_cndmask_b32_e64 v0, s7, v0, s0
; GFX1030W32-NEXT:    v_cndmask_b32_e32 v2, s6, v2, vcc_lo
; GFX1030W32-NEXT:    v_cndmask_b32_e32 v1, s12, v1, vcc_lo
; GFX1030W32-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v0
; GFX1030W32-NEXT:    v_cndmask_b32_e32 v1, s5, v1, vcc_lo
; GFX1030W32-NEXT:    v_cndmask_b32_e32 v0, s1, v2, vcc_lo
; GFX1030W32-NEXT:    s_andn2_b32 vcc_lo, exec_lo, s4
; GFX1030W32-NEXT:    s_cbranch_vccnz .LBB16_3
; GFX1030W32-NEXT:  .LBB16_2:
; GFX1030W32-NEXT:    v_cvt_f32_u32_e32 v0, s2
; GFX1030W32-NEXT:    s_sub_i32 s1, 0, s2
; GFX1030W32-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; GFX1030W32-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; GFX1030W32-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GFX1030W32-NEXT:    v_readfirstlane_b32 s0, v0
; GFX1030W32-NEXT:    s_mul_i32 s1, s1, s0
; GFX1030W32-NEXT:    s_mul_hi_u32 s1, s0, s1
; GFX1030W32-NEXT:    s_add_i32 s0, s0, s1
; GFX1030W32-NEXT:    s_mul_hi_u32 s0, s10, s0
; GFX1030W32-NEXT:    s_mul_i32 s1, s0, s2
; GFX1030W32-NEXT:    s_add_i32 s3, s0, 1
; GFX1030W32-NEXT:    s_sub_i32 s1, s10, s1
; GFX1030W32-NEXT:    s_sub_i32 s4, s1, s2
; GFX1030W32-NEXT:    s_cmp_ge_u32 s1, s2
; GFX1030W32-NEXT:    s_cselect_b32 s0, s3, s0
; GFX1030W32-NEXT:    s_cselect_b32 s1, s4, s1
; GFX1030W32-NEXT:    s_add_i32 s3, s0, 1
; GFX1030W32-NEXT:    s_cmp_ge_u32 s1, s2
; GFX1030W32-NEXT:    s_mov_b32 s1, 0
; GFX1030W32-NEXT:    s_cselect_b32 s0, s3, s0
; GFX1030W32-NEXT:    v_mov_b32_e32 v0, s0
; GFX1030W32-NEXT:    v_mov_b32_e32 v1, s1
; GFX1030W32-NEXT:  .LBB16_3:
; GFX1030W32-NEXT:    v_mov_b32_e32 v2, 0
; GFX1030W32-NEXT:    global_store_dwordx2 v2, v[0:1], s[8:9]
; GFX1030W32-NEXT:    s_endpgm
; GFX1030W32-NEXT:  .LBB16_4:
; GFX1030W32-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1030W32-NEXT:    s_branch .LBB16_2
;
; GFX1030W64-LABEL: sudiv64:
; GFX1030W64:       ; %bb.0:
; GFX1030W64-NEXT:    s_clause 0x1
; GFX1030W64-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x24
; GFX1030W64-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x34
; GFX1030W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030W64-NEXT:    s_or_b64 s[0:1], s[10:11], s[2:3]
; GFX1030W64-NEXT:    s_mov_b32 s0, 0
; GFX1030W64-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1030W64-NEXT:    s_cbranch_scc0 .LBB16_4
; GFX1030W64-NEXT:  ; %bb.1:
; GFX1030W64-NEXT:    v_cvt_f32_u32_e32 v0, s2
; GFX1030W64-NEXT:    v_cvt_f32_u32_e32 v1, s3
; GFX1030W64-NEXT:    s_sub_u32 s5, 0, s2
; GFX1030W64-NEXT:    s_subb_u32 s6, 0, s3
; GFX1030W64-NEXT:    v_fmamk_f32 v0, v1, 0x4f800000, v0
; GFX1030W64-NEXT:    v_rcp_f32_e32 v0, v0
; GFX1030W64-NEXT:    v_mul_f32_e32 v0, 0x5f7ffffc, v0
; GFX1030W64-NEXT:    v_mul_f32_e32 v1, 0x2f800000, v0
; GFX1030W64-NEXT:    v_trunc_f32_e32 v1, v1
; GFX1030W64-NEXT:    v_fmamk_f32 v0, v1, 0xcf800000, v0
; GFX1030W64-NEXT:    v_cvt_u32_f32_e32 v1, v1
; GFX1030W64-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GFX1030W64-NEXT:    v_readfirstlane_b32 s4, v1
; GFX1030W64-NEXT:    v_readfirstlane_b32 s0, v0
; GFX1030W64-NEXT:    s_mul_i32 s1, s5, s4
; GFX1030W64-NEXT:    s_mul_hi_u32 s12, s5, s0
; GFX1030W64-NEXT:    s_mul_i32 s7, s6, s0
; GFX1030W64-NEXT:    s_add_i32 s1, s12, s1
; GFX1030W64-NEXT:    s_mul_i32 s13, s5, s0
; GFX1030W64-NEXT:    s_add_i32 s1, s1, s7
; GFX1030W64-NEXT:    s_mul_hi_u32 s12, s0, s13
; GFX1030W64-NEXT:    s_mul_hi_u32 s14, s4, s13
; GFX1030W64-NEXT:    s_mul_i32 s7, s4, s13
; GFX1030W64-NEXT:    s_mul_hi_u32 s13, s0, s1
; GFX1030W64-NEXT:    s_mul_i32 s0, s0, s1
; GFX1030W64-NEXT:    s_mul_hi_u32 s15, s4, s1
; GFX1030W64-NEXT:    s_add_u32 s0, s12, s0
; GFX1030W64-NEXT:    s_addc_u32 s12, 0, s13
; GFX1030W64-NEXT:    s_add_u32 s0, s0, s7
; GFX1030W64-NEXT:    s_mul_i32 s1, s4, s1
; GFX1030W64-NEXT:    s_addc_u32 s0, s12, s14
; GFX1030W64-NEXT:    s_addc_u32 s7, s15, 0
; GFX1030W64-NEXT:    s_add_u32 s0, s0, s1
; GFX1030W64-NEXT:    s_addc_u32 s7, 0, s7
; GFX1030W64-NEXT:    v_add_co_u32 v0, s[0:1], v0, s0
; GFX1030W64-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1030W64-NEXT:    s_addc_u32 s4, s4, s7
; GFX1030W64-NEXT:    v_readfirstlane_b32 s0, v0
; GFX1030W64-NEXT:    s_mul_i32 s1, s5, s4
; GFX1030W64-NEXT:    s_mul_hi_u32 s7, s5, s0
; GFX1030W64-NEXT:    s_mul_i32 s6, s6, s0
; GFX1030W64-NEXT:    s_add_i32 s1, s7, s1
; GFX1030W64-NEXT:    s_mul_i32 s5, s5, s0
; GFX1030W64-NEXT:    s_add_i32 s1, s1, s6
; GFX1030W64-NEXT:    s_mul_hi_u32 s7, s4, s5
; GFX1030W64-NEXT:    s_mul_i32 s12, s4, s5
; GFX1030W64-NEXT:    s_mul_hi_u32 s5, s0, s5
; GFX1030W64-NEXT:    s_mul_hi_u32 s13, s0, s1
; GFX1030W64-NEXT:    s_mul_i32 s0, s0, s1
; GFX1030W64-NEXT:    s_mul_hi_u32 s6, s4, s1
; GFX1030W64-NEXT:    s_add_u32 s0, s5, s0
; GFX1030W64-NEXT:    s_addc_u32 s5, 0, s13
; GFX1030W64-NEXT:    s_add_u32 s0, s0, s12
; GFX1030W64-NEXT:    s_mul_i32 s1, s4, s1
; GFX1030W64-NEXT:    s_addc_u32 s0, s5, s7
; GFX1030W64-NEXT:    s_addc_u32 s5, s6, 0
; GFX1030W64-NEXT:    s_add_u32 s0, s0, s1
; GFX1030W64-NEXT:    s_addc_u32 s5, 0, s5
; GFX1030W64-NEXT:    v_add_co_u32 v0, s[0:1], v0, s0
; GFX1030W64-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1030W64-NEXT:    s_addc_u32 s0, s4, s5
; GFX1030W64-NEXT:    v_readfirstlane_b32 s1, v0
; GFX1030W64-NEXT:    s_mul_i32 s5, s10, s0
; GFX1030W64-NEXT:    s_mul_hi_u32 s4, s10, s0
; GFX1030W64-NEXT:    s_mul_hi_u32 s6, s11, s0
; GFX1030W64-NEXT:    s_mul_i32 s0, s11, s0
; GFX1030W64-NEXT:    s_mul_hi_u32 s7, s10, s1
; GFX1030W64-NEXT:    s_mul_hi_u32 s12, s11, s1
; GFX1030W64-NEXT:    s_mul_i32 s1, s11, s1
; GFX1030W64-NEXT:    s_add_u32 s5, s7, s5
; GFX1030W64-NEXT:    s_addc_u32 s4, 0, s4
; GFX1030W64-NEXT:    s_add_u32 s1, s5, s1
; GFX1030W64-NEXT:    s_addc_u32 s1, s4, s12
; GFX1030W64-NEXT:    s_addc_u32 s4, s6, 0
; GFX1030W64-NEXT:    s_add_u32 s6, s1, s0
; GFX1030W64-NEXT:    s_addc_u32 s7, 0, s4
; GFX1030W64-NEXT:    s_mul_hi_u32 s0, s2, s6
; GFX1030W64-NEXT:    s_mul_i32 s1, s2, s7
; GFX1030W64-NEXT:    s_mul_i32 s5, s2, s6
; GFX1030W64-NEXT:    s_add_i32 s12, s0, s1
; GFX1030W64-NEXT:    v_sub_co_u32 v0, s[0:1], s10, s5
; GFX1030W64-NEXT:    s_mul_i32 s4, s3, s6
; GFX1030W64-NEXT:    s_add_i32 s12, s12, s4
; GFX1030W64-NEXT:    v_sub_co_u32 v1, s[4:5], v0, s2
; GFX1030W64-NEXT:    s_sub_i32 s13, s11, s12
; GFX1030W64-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1030W64-NEXT:    s_subb_u32 s13, s13, s3
; GFX1030W64-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX1030W64-NEXT:    v_cmp_le_u32_e32 vcc, s2, v1
; GFX1030W64-NEXT:    s_subb_u32 s4, s13, 0
; GFX1030W64-NEXT:    s_cmp_ge_u32 s4, s3
; GFX1030W64-NEXT:    v_cndmask_b32_e64 v1, 0, -1, vcc
; GFX1030W64-NEXT:    s_cselect_b32 s5, -1, 0
; GFX1030W64-NEXT:    s_cmp_eq_u32 s4, s3
; GFX1030W64-NEXT:    s_cselect_b64 vcc, -1, 0
; GFX1030W64-NEXT:    s_add_u32 s4, s6, 1
; GFX1030W64-NEXT:    v_cndmask_b32_e32 v1, s5, v1, vcc
; GFX1030W64-NEXT:    s_addc_u32 s5, s7, 0
; GFX1030W64-NEXT:    s_add_u32 s13, s6, 2
; GFX1030W64-NEXT:    s_addc_u32 s14, s7, 0
; GFX1030W64-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1030W64-NEXT:    v_cmp_le_u32_e32 vcc, s2, v0
; GFX1030W64-NEXT:    s_subb_u32 s0, s11, s12
; GFX1030W64-NEXT:    v_mov_b32_e32 v2, s13
; GFX1030W64-NEXT:    s_cmp_ge_u32 s0, s3
; GFX1030W64-NEXT:    v_cndmask_b32_e64 v0, 0, -1, vcc
; GFX1030W64-NEXT:    s_cselect_b32 s11, -1, 0
; GFX1030W64-NEXT:    s_cmp_eq_u32 s0, s3
; GFX1030W64-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; GFX1030W64-NEXT:    s_cselect_b64 s[0:1], -1, 0
; GFX1030W64-NEXT:    v_mov_b32_e32 v1, s14
; GFX1030W64-NEXT:    v_cndmask_b32_e64 v0, s11, v0, s[0:1]
; GFX1030W64-NEXT:    v_cndmask_b32_e32 v2, s4, v2, vcc
; GFX1030W64-NEXT:    v_cndmask_b32_e32 v1, s5, v1, vcc
; GFX1030W64-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX1030W64-NEXT:    v_cndmask_b32_e32 v1, s7, v1, vcc
; GFX1030W64-NEXT:    v_cndmask_b32_e32 v0, s6, v2, vcc
; GFX1030W64-NEXT:    s_cbranch_execnz .LBB16_3
; GFX1030W64-NEXT:  .LBB16_2:
; GFX1030W64-NEXT:    v_cvt_f32_u32_e32 v0, s2
; GFX1030W64-NEXT:    s_sub_i32 s1, 0, s2
; GFX1030W64-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; GFX1030W64-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; GFX1030W64-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GFX1030W64-NEXT:    v_readfirstlane_b32 s0, v0
; GFX1030W64-NEXT:    s_mul_i32 s1, s1, s0
; GFX1030W64-NEXT:    s_mul_hi_u32 s1, s0, s1
; GFX1030W64-NEXT:    s_add_i32 s0, s0, s1
; GFX1030W64-NEXT:    s_mul_hi_u32 s0, s10, s0
; GFX1030W64-NEXT:    s_mul_i32 s1, s0, s2
; GFX1030W64-NEXT:    s_add_i32 s3, s0, 1
; GFX1030W64-NEXT:    s_sub_i32 s1, s10, s1
; GFX1030W64-NEXT:    s_sub_i32 s4, s1, s2
; GFX1030W64-NEXT:    s_cmp_ge_u32 s1, s2
; GFX1030W64-NEXT:    s_cselect_b32 s0, s3, s0
; GFX1030W64-NEXT:    s_cselect_b32 s1, s4, s1
; GFX1030W64-NEXT:    s_add_i32 s3, s0, 1
; GFX1030W64-NEXT:    s_cmp_ge_u32 s1, s2
; GFX1030W64-NEXT:    s_mov_b32 s1, 0
; GFX1030W64-NEXT:    s_cselect_b32 s0, s3, s0
; GFX1030W64-NEXT:    v_mov_b32_e32 v0, s0
; GFX1030W64-NEXT:    v_mov_b32_e32 v1, s1
; GFX1030W64-NEXT:  .LBB16_3:
; GFX1030W64-NEXT:    v_mov_b32_e32 v2, 0
; GFX1030W64-NEXT:    global_store_dwordx2 v2, v[0:1], s[8:9]
; GFX1030W64-NEXT:    s_endpgm
; GFX1030W64-NEXT:  .LBB16_4:
; GFX1030W64-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1030W64-NEXT:    s_branch .LBB16_2
;
; GFX11-LABEL: sudiv64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[8:11], s[4:5], 0x24
; GFX11-NEXT:    s_load_b64 s[2:3], s[4:5], 0x34
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_or_b64 s[4:5], s[10:11], s[2:3]
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB16_4
; GFX11-NEXT:  ; %bb.1:
; GFX11-NEXT:    v_cvt_f32_u32_e32 v0, s2
; GFX11-NEXT:    v_cvt_f32_u32_e32 v1, s3
; GFX11-NEXT:    s_sub_u32 s5, 0, s2
; GFX11-NEXT:    s_subb_u32 s6, 0, s3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_fmamk_f32 v0, v1, 0x4f800000, v0
; GFX11-NEXT:    v_rcp_f32_e32 v0, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v0, 0x5f7ffffc, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v1, 0x2f800000, v0
; GFX11-NEXT:    v_trunc_f32_e32 v1, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_fmamk_f32 v0, v1, 0xcf800000, v0
; GFX11-NEXT:    v_cvt_u32_f32_e32 v1, v1
; GFX11-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_readfirstlane_b32 s0, v1
; GFX11-NEXT:    v_readfirstlane_b32 s1, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    s_mul_i32 s7, s5, s0
; GFX11-NEXT:    s_mul_hi_u32 s13, s5, s1
; GFX11-NEXT:    s_mul_i32 s12, s6, s1
; GFX11-NEXT:    s_add_i32 s7, s13, s7
; GFX11-NEXT:    s_mul_i32 s14, s5, s1
; GFX11-NEXT:    s_add_i32 s7, s7, s12
; GFX11-NEXT:    s_mul_hi_u32 s13, s1, s14
; GFX11-NEXT:    s_mul_hi_u32 s15, s0, s14
; GFX11-NEXT:    s_mul_i32 s12, s0, s14
; GFX11-NEXT:    s_mul_hi_u32 s14, s1, s7
; GFX11-NEXT:    s_mul_i32 s1, s1, s7
; GFX11-NEXT:    s_mul_hi_u32 s16, s0, s7
; GFX11-NEXT:    s_add_u32 s1, s13, s1
; GFX11-NEXT:    s_addc_u32 s13, 0, s14
; GFX11-NEXT:    s_add_u32 s1, s1, s12
; GFX11-NEXT:    s_mul_i32 s7, s0, s7
; GFX11-NEXT:    s_addc_u32 s1, s13, s15
; GFX11-NEXT:    s_addc_u32 s12, s16, 0
; GFX11-NEXT:    s_add_u32 s1, s1, s7
; GFX11-NEXT:    s_addc_u32 s7, 0, s12
; GFX11-NEXT:    v_add_co_u32 v0, s1, v0, s1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    s_cmp_lg_u32 s1, 0
; GFX11-NEXT:    s_addc_u32 s0, s0, s7
; GFX11-NEXT:    v_readfirstlane_b32 s1, v0
; GFX11-NEXT:    s_mul_i32 s7, s5, s0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    s_mul_hi_u32 s12, s5, s1
; GFX11-NEXT:    s_mul_i32 s6, s6, s1
; GFX11-NEXT:    s_add_i32 s7, s12, s7
; GFX11-NEXT:    s_mul_i32 s5, s5, s1
; GFX11-NEXT:    s_add_i32 s7, s7, s6
; GFX11-NEXT:    s_mul_hi_u32 s12, s0, s5
; GFX11-NEXT:    s_mul_i32 s13, s0, s5
; GFX11-NEXT:    s_mul_hi_u32 s5, s1, s5
; GFX11-NEXT:    s_mul_hi_u32 s14, s1, s7
; GFX11-NEXT:    s_mul_i32 s1, s1, s7
; GFX11-NEXT:    s_mul_hi_u32 s6, s0, s7
; GFX11-NEXT:    s_add_u32 s1, s5, s1
; GFX11-NEXT:    s_addc_u32 s5, 0, s14
; GFX11-NEXT:    s_add_u32 s1, s1, s13
; GFX11-NEXT:    s_mul_i32 s7, s0, s7
; GFX11-NEXT:    s_addc_u32 s1, s5, s12
; GFX11-NEXT:    s_addc_u32 s5, s6, 0
; GFX11-NEXT:    s_add_u32 s1, s1, s7
; GFX11-NEXT:    s_addc_u32 s5, 0, s5
; GFX11-NEXT:    v_add_co_u32 v0, s1, v0, s1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    s_cmp_lg_u32 s1, 0
; GFX11-NEXT:    s_addc_u32 s0, s0, s5
; GFX11-NEXT:    v_readfirstlane_b32 s1, v0
; GFX11-NEXT:    s_mul_i32 s6, s10, s0
; GFX11-NEXT:    s_mul_hi_u32 s5, s10, s0
; GFX11-NEXT:    s_mul_hi_u32 s7, s11, s0
; GFX11-NEXT:    s_mul_i32 s0, s11, s0
; GFX11-NEXT:    s_mul_hi_u32 s12, s10, s1
; GFX11-NEXT:    s_mul_hi_u32 s13, s11, s1
; GFX11-NEXT:    s_mul_i32 s1, s11, s1
; GFX11-NEXT:    s_add_u32 s6, s12, s6
; GFX11-NEXT:    s_addc_u32 s5, 0, s5
; GFX11-NEXT:    s_add_u32 s1, s6, s1
; GFX11-NEXT:    s_addc_u32 s1, s5, s13
; GFX11-NEXT:    s_addc_u32 s5, s7, 0
; GFX11-NEXT:    s_add_u32 s1, s1, s0
; GFX11-NEXT:    s_addc_u32 s5, 0, s5
; GFX11-NEXT:    s_mul_hi_u32 s0, s2, s1
; GFX11-NEXT:    s_mul_i32 s7, s2, s5
; GFX11-NEXT:    s_mul_i32 s12, s2, s1
; GFX11-NEXT:    s_add_i32 s0, s0, s7
; GFX11-NEXT:    v_sub_co_u32 v0, s7, s10, s12
; GFX11-NEXT:    s_mul_i32 s6, s3, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    s_add_i32 s0, s0, s6
; GFX11-NEXT:    v_sub_co_u32 v1, s12, v0, s2
; GFX11-NEXT:    s_sub_i32 s6, s11, s0
; GFX11-NEXT:    s_cmp_lg_u32 s7, 0
; GFX11-NEXT:    s_subb_u32 s6, s6, s3
; GFX11-NEXT:    s_cmp_lg_u32 s12, 0
; GFX11-NEXT:    v_cmp_le_u32_e32 vcc_lo, s2, v1
; GFX11-NEXT:    s_subb_u32 s6, s6, 0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_cmp_ge_u32 s6, s3
; GFX11-NEXT:    v_cndmask_b32_e64 v1, 0, -1, vcc_lo
; GFX11-NEXT:    s_cselect_b32 s12, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s6, s3
; GFX11-NEXT:    s_cselect_b32 vcc_lo, -1, 0
; GFX11-NEXT:    s_add_u32 s6, s1, 1
; GFX11-NEXT:    v_cndmask_b32_e32 v1, s12, v1, vcc_lo
; GFX11-NEXT:    s_addc_u32 s12, s5, 0
; GFX11-NEXT:    s_add_u32 s13, s1, 2
; GFX11-NEXT:    s_addc_u32 s14, s5, 0
; GFX11-NEXT:    v_mov_b32_e32 v2, s13
; GFX11-NEXT:    s_cmp_lg_u32 s7, 0
; GFX11-NEXT:    v_cmp_le_u32_e32 vcc_lo, s2, v0
; GFX11-NEXT:    s_subb_u32 s0, s11, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_cmp_ge_u32 s0, s3
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, -1, vcc_lo
; GFX11-NEXT:    s_cselect_b32 s7, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s0, s3
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    s_cselect_b32 s0, -1, 0
; GFX11-NEXT:    v_mov_b32_e32 v1, s14
; GFX11-NEXT:    v_cndmask_b32_e64 v0, s7, v0, s0
; GFX11-NEXT:    v_cndmask_b32_e32 v2, s6, v2, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, s12, v1, vcc_lo
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, s5, v1, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e32 v0, s1, v2, vcc_lo
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB16_3
; GFX11-NEXT:  .LBB16_2:
; GFX11-NEXT:    v_cvt_f32_u32_e32 v0, s2
; GFX11-NEXT:    s_sub_i32 s1, 0, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; GFX11-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_readfirstlane_b32 s0, v0
; GFX11-NEXT:    s_mul_i32 s1, s1, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_mul_hi_u32 s1, s0, s1
; GFX11-NEXT:    s_add_i32 s0, s0, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_mul_hi_u32 s0, s10, s0
; GFX11-NEXT:    s_mul_i32 s1, s0, s2
; GFX11-NEXT:    s_add_i32 s3, s0, 1
; GFX11-NEXT:    s_sub_i32 s1, s10, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_sub_i32 s4, s1, s2
; GFX11-NEXT:    s_cmp_ge_u32 s1, s2
; GFX11-NEXT:    s_cselect_b32 s0, s3, s0
; GFX11-NEXT:    s_cselect_b32 s1, s4, s1
; GFX11-NEXT:    s_add_i32 s3, s0, 1
; GFX11-NEXT:    s_cmp_ge_u32 s1, s2
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_cselect_b32 s0, s3, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:  .LBB16_3:
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[8:9]
; GFX11-NEXT:    s_endpgm
; GFX11-NEXT:  .LBB16_4:
; GFX11-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX11-NEXT:    s_branch .LBB16_2
  %result = udiv i64 %x, %y
  store i64 %result, ptr addrspace(1) %out
  ret void
}



declare { i64, i1 } @llvm.uadd.with.overflow.i64(i64, i64) #1

declare { i32, i1 } @llvm.uadd.with.overflow.i32(i32, i32) #1

declare { i64, i1 } @llvm.usub.with.overflow.i64(i64, i64) #1

declare { i32, i1 } @llvm.usub.with.overflow.i32(i32, i32) #1

declare i32 @llvm.amdgcn.workitem.id.x() #1

attributes #0 = { nounwind }
attributes #1 = { nounwind readnone }

;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GCN-ISEL: {{.*}}
