; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -fast-isel -mtriple=i386-unknown-unknown -mattr=+sse3 | FileCheck %s --check-prefixes=SSE,X86-SSE
; RUN: llc < %s -fast-isel -mtriple=i386-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=AVX,X86-AVX
; RUN: llc < %s -fast-isel -mtriple=i386-unknown-unknown -mattr=+avx512f,+avx512bw,+avx512dq,+avx512vl | FileCheck %s --check-prefixes=AVX,X86-AVX
; RUN: llc < %s -fast-isel -mtriple=x86_64-unknown-unknown -mattr=+sse3 | FileCheck %s --check-prefixes=SSE,X64-SSE
; RUN: llc < %s -fast-isel -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=AVX,X64-AVX
; RUN: llc < %s -fast-isel -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512bw,+avx512dq,+avx512vl | FileCheck %s --check-prefixes=AVX,X64-AVX

; NOTE: This should use IR equivalent to what is generated by clang/test/CodeGen/sse3-builtins.c

define <2 x double> @test_mm_addsub_pd(<2 x double> %a0, <2 x double> %a1) {
; SSE-LABEL: test_mm_addsub_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    addsubpd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_addsub_pd:
; AVX:       # %bb.0:
; AVX-NEXT:    vaddsubpd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <2 x double> @llvm.x86.sse3.addsub.pd(<2 x double> %a0, <2 x double> %a1)
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse3.addsub.pd(<2 x double>, <2 x double>) nounwind readnone

define <4 x float> @test_mm_addsub_ps(<4 x float> %a0, <4 x float> %a1) {
; SSE-LABEL: test_mm_addsub_ps:
; SSE:       # %bb.0:
; SSE-NEXT:    addsubps %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_addsub_ps:
; AVX:       # %bb.0:
; AVX-NEXT:    vaddsubps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <4 x float> @llvm.x86.sse3.addsub.ps(<4 x float> %a0, <4 x float> %a1)
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse3.addsub.ps(<4 x float>, <4 x float>) nounwind readnone

define <2 x double> @test_mm_hadd_pd(<2 x double> %a0, <2 x double> %a1) {
; SSE-LABEL: test_mm_hadd_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    haddpd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_hadd_pd:
; AVX:       # %bb.0:
; AVX-NEXT:    vhaddpd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <2 x double> @llvm.x86.sse3.hadd.pd(<2 x double> %a0, <2 x double> %a1)
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse3.hadd.pd(<2 x double>, <2 x double>) nounwind readnone

define <4 x float> @test_mm_hadd_ps(<4 x float> %a0, <4 x float> %a1) {
; SSE-LABEL: test_mm_hadd_ps:
; SSE:       # %bb.0:
; SSE-NEXT:    haddps %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_hadd_ps:
; AVX:       # %bb.0:
; AVX-NEXT:    vhaddps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <4 x float> @llvm.x86.sse3.hadd.ps(<4 x float> %a0, <4 x float> %a1)
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse3.hadd.ps(<4 x float>, <4 x float>) nounwind readnone

define <2 x double> @test_mm_hsub_pd(<2 x double> %a0, <2 x double> %a1) {
; SSE-LABEL: test_mm_hsub_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    hsubpd %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_hsub_pd:
; AVX:       # %bb.0:
; AVX-NEXT:    vhsubpd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <2 x double> @llvm.x86.sse3.hsub.pd(<2 x double> %a0, <2 x double> %a1)
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse3.hsub.pd(<2 x double>, <2 x double>) nounwind readnone

define <4 x float> @test_mm_hsub_ps(<4 x float> %a0, <4 x float> %a1) {
; SSE-LABEL: test_mm_hsub_ps:
; SSE:       # %bb.0:
; SSE-NEXT:    hsubps %xmm1, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_hsub_ps:
; AVX:       # %bb.0:
; AVX-NEXT:    vhsubps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <4 x float> @llvm.x86.sse3.hsub.ps(<4 x float> %a0, <4 x float> %a1)
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse3.hsub.ps(<4 x float>, <4 x float>) nounwind readnone

define <2 x i64> @test_mm_lddqu_si128(ptr %a0) {
; X86-SSE-LABEL: test_mm_lddqu_si128:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    lddqu (%eax), %xmm0
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_lddqu_si128:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vlddqu (%eax), %xmm0
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_lddqu_si128:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    lddqu (%rdi), %xmm0
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_lddqu_si128:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vlddqu (%rdi), %xmm0
; X64-AVX-NEXT:    retq
  %call = call <16 x i8> @llvm.x86.sse3.ldu.dq(ptr %a0)
  %res = bitcast <16 x i8> %call to <2 x i64>
  ret <2 x i64> %res
}
declare <16 x i8> @llvm.x86.sse3.ldu.dq(ptr) nounwind readonly

define <2 x double> @test_mm_loaddup_pd(ptr %a0) {
; X86-SSE-LABEL: test_mm_loaddup_pd:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movddup {{.*#+}} xmm0 = mem[0,0]
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: test_mm_loaddup_pd:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    vmovddup {{.*#+}} xmm0 = mem[0,0]
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: test_mm_loaddup_pd:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movddup {{.*#+}} xmm0 = mem[0,0]
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: test_mm_loaddup_pd:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovddup {{.*#+}} xmm0 = mem[0,0]
; X64-AVX-NEXT:    retq
  %ld = load double, ptr %a0
  %res0 = insertelement <2 x double> undef, double %ld, i32 0
  %res1 = insertelement <2 x double> %res0, double %ld, i32 1
  ret <2 x double> %res1
}

define <2 x double> @test_mm_movedup_pd(<2 x double> %a0) {
; SSE-LABEL: test_mm_movedup_pd:
; SSE:       # %bb.0:
; SSE-NEXT:    movddup {{.*#+}} xmm0 = xmm0[0,0]
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_movedup_pd:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovddup {{.*#+}} xmm0 = xmm0[0,0]
; AVX-NEXT:    ret{{[l|q]}}
  %res = shufflevector <2 x double> %a0, <2 x double> %a0, <2 x i32> zeroinitializer
  ret <2 x double> %res
}

define <4 x float> @test_mm_movehdup_ps(<4 x float> %a0) {
; SSE-LABEL: test_mm_movehdup_ps:
; SSE:       # %bb.0:
; SSE-NEXT:    movshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_movehdup_ps:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX-NEXT:    ret{{[l|q]}}
  %res = shufflevector <4 x float> %a0, <4 x float> %a0, <4 x i32> <i32 1, i32 1, i32 3, i32 3>
  ret <4 x float> %res
}

define <4 x float> @test_mm_moveldup_ps(<4 x float> %a0) {
; SSE-LABEL: test_mm_moveldup_ps:
; SSE:       # %bb.0:
; SSE-NEXT:    movsldup {{.*#+}} xmm0 = xmm0[0,0,2,2]
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: test_mm_moveldup_ps:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovsldup {{.*#+}} xmm0 = xmm0[0,0,2,2]
; AVX-NEXT:    ret{{[l|q]}}
  %res = shufflevector <4 x float> %a0, <4 x float> %a0, <4 x i32> <i32 0, i32 0, i32 2, i32 2>
  ret <4 x float> %res
}
