; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -mtriple=i686 < %s | FileCheck %s --check-prefixes=CHECK,X86
; RUN: llc -mtriple=x86_64 < %s | FileCheck %s --check-prefixes=CHECK,X64

@var = internal global i32 0, align 4

define dso_local void @test_c() nounwind {
; CHECK-LABEL: test_c:
; CHECK:       # %bb.0:
; CHECK-NEXT:    #APP
; CHECK-NEXT:    #TEST 42
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    #TEST var
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    ret{{[l|q]}}
  tail call void asm sideeffect "#TEST ${0:c}", "i"(i32 42)
  tail call void asm sideeffect "#TEST ${0:c}", "i"(ptr nonnull @var)
  ret void
}

define dso_local void @test_n() nounwind {
; CHECK-LABEL: test_n:
; CHECK:       # %bb.0:
; CHECK-NEXT:    #APP
; CHECK-NEXT:    #TEST 37
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    ret{{[l|q]}}
  tail call void asm sideeffect "#TEST ${0:n}", "i"(i32 -37)
  ret void
}

define void @test_q() {
; CHECK-LABEL: test_q:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    #APP
; CHECK-NEXT:    #TEST 0
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  call void asm sideeffect "#TEST ${0:q}", "=*imr"( ptr elementtype( i64) null )
  ret void
}

define void @test_V(ptr %p) {
; X86-LABEL: test_V:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    #APP
; X86-NEXT:    calll __x86_indirect_thunk_eax
; X86-NEXT:    #NO_APP
; X86-NEXT:    retl
;
; X64-LABEL: test_V:
; X64:       # %bb.0: # %entry
; X64-NEXT:    #APP
; X64-NEXT:    callq __x86_indirect_thunk_rdi
; X64-NEXT:    #NO_APP
; X64-NEXT:    retq
entry:
  tail call void asm sideeffect "call __x86_indirect_thunk_${0:V}", "r,~{dirflag},~{fpsr},~{flags}"(ptr %p)
  ret void
}

