; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+zve64x -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,CHECK-ZVE64X,RV32,RV32I
; RUN: llc -mtriple=riscv64 -mattr=+zve64x -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,CHECK-ZVE64X,RV64,RV64I
; RUN: llc -mtriple=riscv32 -mattr=+zve64f,+f -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,CHECK-F,RV32F
; RUN: llc -mtriple=riscv64 -mattr=+zve64f,+f -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,CHECK-F,RV64F
; RUN: llc -mtriple=riscv32 -mattr=+v,+d -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,CHECK-D,RV32
; RUN: llc -mtriple=riscv64 -mattr=+v,+d -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,CHECK-D,RV64
; RUN: llc -mtriple=riscv32 -mattr=+v,+zvbb -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK-ZVBB
; RUN: llc -mtriple=riscv64 -mattr=+v,+zvbb -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK-ZVBB

define <vscale x 1 x i8> @ctlz_nxv1i8(<vscale x 1 x i8> %va) {
; CHECK-ZVE64X-LABEL: ctlz_nxv1i8:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    li a0, 85
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 2
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    vand.vx v9, v9, a0
; CHECK-ZVE64X-NEXT:    li a0, 51
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v9, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vi v8, v8, 15
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_nxv1i8:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-F-NEXT:    vzext.vf2 v9, v8
; CHECK-F-NEXT:    li a0, 134
; CHECK-F-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-F-NEXT:    vnsrl.wi v8, v8, 23
; CHECK-F-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-F-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-F-NEXT:    vrsub.vx v8, v8, a0
; CHECK-F-NEXT:    li a0, 8
; CHECK-F-NEXT:    vminu.vx v8, v8, a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_nxv1i8:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-D-NEXT:    vzext.vf2 v9, v8
; CHECK-D-NEXT:    li a0, 134
; CHECK-D-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-D-NEXT:    vnsrl.wi v8, v8, 23
; CHECK-D-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-D-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-D-NEXT:    vrsub.vx v8, v8, a0
; CHECK-D-NEXT:    li a0, 8
; CHECK-D-NEXT:    vminu.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_nxv1i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 1 x i8> @llvm.ctlz.nxv1i8(<vscale x 1 x i8> %va, i1 false)
  ret <vscale x 1 x i8> %a
}
declare <vscale x 1 x i8> @llvm.ctlz.nxv1i8(<vscale x 1 x i8>, i1)

define <vscale x 2 x i8> @ctlz_nxv2i8(<vscale x 2 x i8> %va) {
; CHECK-ZVE64X-LABEL: ctlz_nxv2i8:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    li a0, 85
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 2
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    vand.vx v9, v9, a0
; CHECK-ZVE64X-NEXT:    li a0, 51
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v9, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vi v8, v8, 15
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_nxv2i8:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-F-NEXT:    vzext.vf2 v9, v8
; CHECK-F-NEXT:    li a0, 134
; CHECK-F-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-F-NEXT:    vnsrl.wi v8, v8, 23
; CHECK-F-NEXT:    vsetvli zero, zero, e8, mf4, ta, ma
; CHECK-F-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-F-NEXT:    vrsub.vx v8, v8, a0
; CHECK-F-NEXT:    li a0, 8
; CHECK-F-NEXT:    vminu.vx v8, v8, a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_nxv2i8:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-D-NEXT:    vzext.vf2 v9, v8
; CHECK-D-NEXT:    li a0, 134
; CHECK-D-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-D-NEXT:    vnsrl.wi v8, v8, 23
; CHECK-D-NEXT:    vsetvli zero, zero, e8, mf4, ta, ma
; CHECK-D-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-D-NEXT:    vrsub.vx v8, v8, a0
; CHECK-D-NEXT:    li a0, 8
; CHECK-D-NEXT:    vminu.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_nxv2i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 2 x i8> @llvm.ctlz.nxv2i8(<vscale x 2 x i8> %va, i1 false)
  ret <vscale x 2 x i8> %a
}
declare <vscale x 2 x i8> @llvm.ctlz.nxv2i8(<vscale x 2 x i8>, i1)

define <vscale x 4 x i8> @ctlz_nxv4i8(<vscale x 4 x i8> %va) {
; CHECK-ZVE64X-LABEL: ctlz_nxv4i8:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    li a0, 85
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 2
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    vand.vx v9, v9, a0
; CHECK-ZVE64X-NEXT:    li a0, 51
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v9, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vi v8, v8, 15
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_nxv4i8:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-F-NEXT:    vzext.vf2 v9, v8
; CHECK-F-NEXT:    li a0, 134
; CHECK-F-NEXT:    vfwcvt.f.xu.v v10, v9
; CHECK-F-NEXT:    vnsrl.wi v8, v10, 23
; CHECK-F-NEXT:    vsetvli zero, zero, e8, mf2, ta, ma
; CHECK-F-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-F-NEXT:    vrsub.vx v8, v8, a0
; CHECK-F-NEXT:    li a0, 8
; CHECK-F-NEXT:    vminu.vx v8, v8, a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_nxv4i8:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-D-NEXT:    vzext.vf2 v9, v8
; CHECK-D-NEXT:    li a0, 134
; CHECK-D-NEXT:    vfwcvt.f.xu.v v10, v9
; CHECK-D-NEXT:    vnsrl.wi v8, v10, 23
; CHECK-D-NEXT:    vsetvli zero, zero, e8, mf2, ta, ma
; CHECK-D-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-D-NEXT:    vrsub.vx v8, v8, a0
; CHECK-D-NEXT:    li a0, 8
; CHECK-D-NEXT:    vminu.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_nxv4i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 4 x i8> @llvm.ctlz.nxv4i8(<vscale x 4 x i8> %va, i1 false)
  ret <vscale x 4 x i8> %a
}
declare <vscale x 4 x i8> @llvm.ctlz.nxv4i8(<vscale x 4 x i8>, i1)

define <vscale x 8 x i8> @ctlz_nxv8i8(<vscale x 8 x i8> %va) {
; CHECK-ZVE64X-LABEL: ctlz_nxv8i8:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    li a0, 85
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 2
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    vand.vx v9, v9, a0
; CHECK-ZVE64X-NEXT:    li a0, 51
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v9, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vi v8, v8, 15
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_nxv8i8:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-F-NEXT:    vzext.vf2 v10, v8
; CHECK-F-NEXT:    li a0, 134
; CHECK-F-NEXT:    vfwcvt.f.xu.v v12, v10
; CHECK-F-NEXT:    vnsrl.wi v8, v12, 23
; CHECK-F-NEXT:    vsetvli zero, zero, e8, m1, ta, ma
; CHECK-F-NEXT:    vnsrl.wi v10, v8, 0
; CHECK-F-NEXT:    vrsub.vx v8, v10, a0
; CHECK-F-NEXT:    li a0, 8
; CHECK-F-NEXT:    vminu.vx v8, v8, a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_nxv8i8:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-D-NEXT:    vzext.vf2 v10, v8
; CHECK-D-NEXT:    li a0, 134
; CHECK-D-NEXT:    vfwcvt.f.xu.v v12, v10
; CHECK-D-NEXT:    vnsrl.wi v8, v12, 23
; CHECK-D-NEXT:    vsetvli zero, zero, e8, m1, ta, ma
; CHECK-D-NEXT:    vnsrl.wi v10, v8, 0
; CHECK-D-NEXT:    vrsub.vx v8, v10, a0
; CHECK-D-NEXT:    li a0, 8
; CHECK-D-NEXT:    vminu.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_nxv8i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 8 x i8> @llvm.ctlz.nxv8i8(<vscale x 8 x i8> %va, i1 false)
  ret <vscale x 8 x i8> %a
}
declare <vscale x 8 x i8> @llvm.ctlz.nxv8i8(<vscale x 8 x i8>, i1)

define <vscale x 16 x i8> @ctlz_nxv16i8(<vscale x 16 x i8> %va) {
; CHECK-ZVE64X-LABEL: ctlz_nxv16i8:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 1
; CHECK-ZVE64X-NEXT:    li a0, 85
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 2
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 4
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 1
; CHECK-ZVE64X-NEXT:    vand.vx v10, v10, a0
; CHECK-ZVE64X-NEXT:    li a0, 51
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vand.vx v10, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v10, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vand.vi v8, v8, 15
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_nxv16i8:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-F-NEXT:    vzext.vf2 v12, v8
; CHECK-F-NEXT:    li a0, 134
; CHECK-F-NEXT:    vfwcvt.f.xu.v v16, v12
; CHECK-F-NEXT:    vnsrl.wi v8, v16, 23
; CHECK-F-NEXT:    vsetvli zero, zero, e8, m2, ta, ma
; CHECK-F-NEXT:    vnsrl.wi v12, v8, 0
; CHECK-F-NEXT:    vrsub.vx v8, v12, a0
; CHECK-F-NEXT:    li a0, 8
; CHECK-F-NEXT:    vminu.vx v8, v8, a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_nxv16i8:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-D-NEXT:    vzext.vf2 v12, v8
; CHECK-D-NEXT:    li a0, 134
; CHECK-D-NEXT:    vfwcvt.f.xu.v v16, v12
; CHECK-D-NEXT:    vnsrl.wi v8, v16, 23
; CHECK-D-NEXT:    vsetvli zero, zero, e8, m2, ta, ma
; CHECK-D-NEXT:    vnsrl.wi v12, v8, 0
; CHECK-D-NEXT:    vrsub.vx v8, v12, a0
; CHECK-D-NEXT:    li a0, 8
; CHECK-D-NEXT:    vminu.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_nxv16i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 16 x i8> @llvm.ctlz.nxv16i8(<vscale x 16 x i8> %va, i1 false)
  ret <vscale x 16 x i8> %a
}
declare <vscale x 16 x i8> @llvm.ctlz.nxv16i8(<vscale x 16 x i8>, i1)

define <vscale x 32 x i8> @ctlz_nxv32i8(<vscale x 32 x i8> %va) {
; CHECK-LABEL: ctlz_nxv32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-NEXT:    vsrl.vi v12, v8, 1
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vor.vv v8, v8, v12
; CHECK-NEXT:    vsrl.vi v12, v8, 2
; CHECK-NEXT:    vor.vv v8, v8, v12
; CHECK-NEXT:    vsrl.vi v12, v8, 4
; CHECK-NEXT:    vor.vv v8, v8, v12
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vsrl.vi v12, v8, 1
; CHECK-NEXT:    vand.vx v12, v12, a0
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vsub.vv v8, v8, v12
; CHECK-NEXT:    vand.vx v12, v8, a0
; CHECK-NEXT:    vsrl.vi v8, v8, 2
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v12, v8
; CHECK-NEXT:    vsrl.vi v12, v8, 4
; CHECK-NEXT:    vadd.vv v8, v8, v12
; CHECK-NEXT:    vand.vi v8, v8, 15
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_nxv32i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 32 x i8> @llvm.ctlz.nxv32i8(<vscale x 32 x i8> %va, i1 false)
  ret <vscale x 32 x i8> %a
}
declare <vscale x 32 x i8> @llvm.ctlz.nxv32i8(<vscale x 32 x i8>, i1)

define <vscale x 64 x i8> @ctlz_nxv64i8(<vscale x 64 x i8> %va) {
; CHECK-LABEL: ctlz_nxv64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-NEXT:    vsrl.vi v16, v8, 1
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vsrl.vi v16, v8, 2
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vsrl.vi v16, v8, 4
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vsrl.vi v16, v8, 1
; CHECK-NEXT:    vand.vx v16, v16, a0
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vsub.vv v8, v8, v16
; CHECK-NEXT:    vand.vx v16, v8, a0
; CHECK-NEXT:    vsrl.vi v8, v8, 2
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v16, v8
; CHECK-NEXT:    vsrl.vi v16, v8, 4
; CHECK-NEXT:    vadd.vv v8, v8, v16
; CHECK-NEXT:    vand.vi v8, v8, 15
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_nxv64i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 64 x i8> @llvm.ctlz.nxv64i8(<vscale x 64 x i8> %va, i1 false)
  ret <vscale x 64 x i8> %a
}
declare <vscale x 64 x i8> @llvm.ctlz.nxv64i8(<vscale x 64 x i8>, i1)

define <vscale x 1 x i16> @ctlz_nxv1i16(<vscale x 1 x i16> %va) {
; CHECK-ZVE64X-LABEL: ctlz_nxv1i16:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    lui a0, 5
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    addi a0, a0, 1365
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 2
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 8
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    vand.vx v9, v9, a0
; CHECK-ZVE64X-NEXT:    lui a0, 3
; CHECK-ZVE64X-NEXT:    addi a0, a0, 819
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    lui a0, 1
; CHECK-ZVE64X-NEXT:    addi a0, a0, -241
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v9, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    li a0, 257
; CHECK-ZVE64X-NEXT:    vmul.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 8
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_nxv1i16:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-F-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-F-NEXT:    li a0, 142
; CHECK-F-NEXT:    vnsrl.wi v8, v9, 23
; CHECK-F-NEXT:    vrsub.vx v8, v8, a0
; CHECK-F-NEXT:    li a0, 16
; CHECK-F-NEXT:    vminu.vx v8, v8, a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_nxv1i16:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-D-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-D-NEXT:    li a0, 142
; CHECK-D-NEXT:    vnsrl.wi v8, v9, 23
; CHECK-D-NEXT:    vrsub.vx v8, v8, a0
; CHECK-D-NEXT:    li a0, 16
; CHECK-D-NEXT:    vminu.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_nxv1i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 1 x i16> @llvm.ctlz.nxv1i16(<vscale x 1 x i16> %va, i1 false)
  ret <vscale x 1 x i16> %a
}
declare <vscale x 1 x i16> @llvm.ctlz.nxv1i16(<vscale x 1 x i16>, i1)

define <vscale x 2 x i16> @ctlz_nxv2i16(<vscale x 2 x i16> %va) {
; CHECK-ZVE64X-LABEL: ctlz_nxv2i16:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    lui a0, 5
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    addi a0, a0, 1365
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 2
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 8
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    vand.vx v9, v9, a0
; CHECK-ZVE64X-NEXT:    lui a0, 3
; CHECK-ZVE64X-NEXT:    addi a0, a0, 819
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    lui a0, 1
; CHECK-ZVE64X-NEXT:    addi a0, a0, -241
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v9, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    li a0, 257
; CHECK-ZVE64X-NEXT:    vmul.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 8
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_nxv2i16:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-F-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-F-NEXT:    li a0, 142
; CHECK-F-NEXT:    vnsrl.wi v8, v9, 23
; CHECK-F-NEXT:    vrsub.vx v8, v8, a0
; CHECK-F-NEXT:    li a0, 16
; CHECK-F-NEXT:    vminu.vx v8, v8, a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_nxv2i16:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-D-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-D-NEXT:    li a0, 142
; CHECK-D-NEXT:    vnsrl.wi v8, v9, 23
; CHECK-D-NEXT:    vrsub.vx v8, v8, a0
; CHECK-D-NEXT:    li a0, 16
; CHECK-D-NEXT:    vminu.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_nxv2i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 2 x i16> @llvm.ctlz.nxv2i16(<vscale x 2 x i16> %va, i1 false)
  ret <vscale x 2 x i16> %a
}
declare <vscale x 2 x i16> @llvm.ctlz.nxv2i16(<vscale x 2 x i16>, i1)

define <vscale x 4 x i16> @ctlz_nxv4i16(<vscale x 4 x i16> %va) {
; CHECK-ZVE64X-LABEL: ctlz_nxv4i16:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    lui a0, 5
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    addi a0, a0, 1365
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 2
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 8
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    vand.vx v9, v9, a0
; CHECK-ZVE64X-NEXT:    lui a0, 3
; CHECK-ZVE64X-NEXT:    addi a0, a0, 819
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    lui a0, 1
; CHECK-ZVE64X-NEXT:    addi a0, a0, -241
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v9, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    li a0, 257
; CHECK-ZVE64X-NEXT:    vmul.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 8
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_nxv4i16:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-F-NEXT:    vfwcvt.f.xu.v v10, v8
; CHECK-F-NEXT:    li a0, 142
; CHECK-F-NEXT:    vnsrl.wi v8, v10, 23
; CHECK-F-NEXT:    vrsub.vx v8, v8, a0
; CHECK-F-NEXT:    li a0, 16
; CHECK-F-NEXT:    vminu.vx v8, v8, a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_nxv4i16:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-D-NEXT:    vfwcvt.f.xu.v v10, v8
; CHECK-D-NEXT:    li a0, 142
; CHECK-D-NEXT:    vnsrl.wi v8, v10, 23
; CHECK-D-NEXT:    vrsub.vx v8, v8, a0
; CHECK-D-NEXT:    li a0, 16
; CHECK-D-NEXT:    vminu.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_nxv4i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 4 x i16> @llvm.ctlz.nxv4i16(<vscale x 4 x i16> %va, i1 false)
  ret <vscale x 4 x i16> %a
}
declare <vscale x 4 x i16> @llvm.ctlz.nxv4i16(<vscale x 4 x i16>, i1)

define <vscale x 8 x i16> @ctlz_nxv8i16(<vscale x 8 x i16> %va) {
; CHECK-ZVE64X-LABEL: ctlz_nxv8i16:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 1
; CHECK-ZVE64X-NEXT:    lui a0, 5
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    addi a0, a0, 1365
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 2
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 4
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 8
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 1
; CHECK-ZVE64X-NEXT:    vand.vx v10, v10, a0
; CHECK-ZVE64X-NEXT:    lui a0, 3
; CHECK-ZVE64X-NEXT:    addi a0, a0, 819
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vand.vx v10, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    lui a0, 1
; CHECK-ZVE64X-NEXT:    addi a0, a0, -241
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v10, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    li a0, 257
; CHECK-ZVE64X-NEXT:    vmul.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 8
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_nxv8i16:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-F-NEXT:    vfwcvt.f.xu.v v12, v8
; CHECK-F-NEXT:    li a0, 142
; CHECK-F-NEXT:    vnsrl.wi v8, v12, 23
; CHECK-F-NEXT:    vrsub.vx v8, v8, a0
; CHECK-F-NEXT:    li a0, 16
; CHECK-F-NEXT:    vminu.vx v8, v8, a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_nxv8i16:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-D-NEXT:    vfwcvt.f.xu.v v12, v8
; CHECK-D-NEXT:    li a0, 142
; CHECK-D-NEXT:    vnsrl.wi v8, v12, 23
; CHECK-D-NEXT:    vrsub.vx v8, v8, a0
; CHECK-D-NEXT:    li a0, 16
; CHECK-D-NEXT:    vminu.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_nxv8i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 8 x i16> @llvm.ctlz.nxv8i16(<vscale x 8 x i16> %va, i1 false)
  ret <vscale x 8 x i16> %a
}
declare <vscale x 8 x i16> @llvm.ctlz.nxv8i16(<vscale x 8 x i16>, i1)

define <vscale x 16 x i16> @ctlz_nxv16i16(<vscale x 16 x i16> %va) {
; CHECK-ZVE64X-LABEL: ctlz_nxv16i16:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-ZVE64X-NEXT:    vsrl.vi v12, v8, 1
; CHECK-ZVE64X-NEXT:    lui a0, 5
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v12
; CHECK-ZVE64X-NEXT:    addi a0, a0, 1365
; CHECK-ZVE64X-NEXT:    vsrl.vi v12, v8, 2
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v12
; CHECK-ZVE64X-NEXT:    vsrl.vi v12, v8, 4
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v12
; CHECK-ZVE64X-NEXT:    vsrl.vi v12, v8, 8
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v12
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v12, v8, 1
; CHECK-ZVE64X-NEXT:    vand.vx v12, v12, a0
; CHECK-ZVE64X-NEXT:    lui a0, 3
; CHECK-ZVE64X-NEXT:    addi a0, a0, 819
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v12
; CHECK-ZVE64X-NEXT:    vand.vx v12, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    lui a0, 1
; CHECK-ZVE64X-NEXT:    addi a0, a0, -241
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v12, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v12, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v12
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    li a0, 257
; CHECK-ZVE64X-NEXT:    vmul.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 8
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_nxv16i16:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-F-NEXT:    vfwcvt.f.xu.v v16, v8
; CHECK-F-NEXT:    li a0, 142
; CHECK-F-NEXT:    vnsrl.wi v8, v16, 23
; CHECK-F-NEXT:    vrsub.vx v8, v8, a0
; CHECK-F-NEXT:    li a0, 16
; CHECK-F-NEXT:    vminu.vx v8, v8, a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_nxv16i16:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-D-NEXT:    vfwcvt.f.xu.v v16, v8
; CHECK-D-NEXT:    li a0, 142
; CHECK-D-NEXT:    vnsrl.wi v8, v16, 23
; CHECK-D-NEXT:    vrsub.vx v8, v8, a0
; CHECK-D-NEXT:    li a0, 16
; CHECK-D-NEXT:    vminu.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_nxv16i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 16 x i16> @llvm.ctlz.nxv16i16(<vscale x 16 x i16> %va, i1 false)
  ret <vscale x 16 x i16> %a
}
declare <vscale x 16 x i16> @llvm.ctlz.nxv16i16(<vscale x 16 x i16>, i1)

define <vscale x 32 x i16> @ctlz_nxv32i16(<vscale x 32 x i16> %va) {
; CHECK-LABEL: ctlz_nxv32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vsrl.vi v16, v8, 1
; CHECK-NEXT:    lui a0, 5
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    addi a0, a0, 1365
; CHECK-NEXT:    vsrl.vi v16, v8, 2
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vsrl.vi v16, v8, 4
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vsrl.vi v16, v8, 8
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vsrl.vi v16, v8, 1
; CHECK-NEXT:    vand.vx v16, v16, a0
; CHECK-NEXT:    lui a0, 3
; CHECK-NEXT:    addi a0, a0, 819
; CHECK-NEXT:    vsub.vv v8, v8, v16
; CHECK-NEXT:    vand.vx v16, v8, a0
; CHECK-NEXT:    vsrl.vi v8, v8, 2
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    lui a0, 1
; CHECK-NEXT:    addi a0, a0, -241
; CHECK-NEXT:    vadd.vv v8, v16, v8
; CHECK-NEXT:    vsrl.vi v16, v8, 4
; CHECK-NEXT:    vadd.vv v8, v8, v16
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    li a0, 257
; CHECK-NEXT:    vmul.vx v8, v8, a0
; CHECK-NEXT:    vsrl.vi v8, v8, 8
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_nxv32i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 32 x i16> @llvm.ctlz.nxv32i16(<vscale x 32 x i16> %va, i1 false)
  ret <vscale x 32 x i16> %a
}
declare <vscale x 32 x i16> @llvm.ctlz.nxv32i16(<vscale x 32 x i16>, i1)

define <vscale x 1 x i32> @ctlz_nxv1i32(<vscale x 1 x i32> %va) {
; CHECK-ZVE64X-LABEL: ctlz_nxv1i32:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    lui a0, 349525
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    addi a0, a0, 1365
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 2
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 8
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 16
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    vand.vx v9, v9, a0
; CHECK-ZVE64X-NEXT:    lui a0, 209715
; CHECK-ZVE64X-NEXT:    addi a0, a0, 819
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    lui a0, 61681
; CHECK-ZVE64X-NEXT:    addi a0, a0, -241
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v9, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    lui a0, 4112
; CHECK-ZVE64X-NEXT:    addi a0, a0, 257
; CHECK-ZVE64X-NEXT:    vmul.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 24
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_nxv1i32:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    fsrmi a0, 1
; CHECK-F-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-F-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-F-NEXT:    li a1, 158
; CHECK-F-NEXT:    vsrl.vi v8, v8, 23
; CHECK-F-NEXT:    vrsub.vx v8, v8, a1
; CHECK-F-NEXT:    li a1, 32
; CHECK-F-NEXT:    vminu.vx v8, v8, a1
; CHECK-F-NEXT:    fsrm a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_nxv1i32:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-D-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-D-NEXT:    li a0, 52
; CHECK-D-NEXT:    vnsrl.wx v8, v9, a0
; CHECK-D-NEXT:    li a0, 1054
; CHECK-D-NEXT:    vrsub.vx v8, v8, a0
; CHECK-D-NEXT:    li a0, 32
; CHECK-D-NEXT:    vminu.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_nxv1i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 1 x i32> @llvm.ctlz.nxv1i32(<vscale x 1 x i32> %va, i1 false)
  ret <vscale x 1 x i32> %a
}
declare <vscale x 1 x i32> @llvm.ctlz.nxv1i32(<vscale x 1 x i32>, i1)

define <vscale x 2 x i32> @ctlz_nxv2i32(<vscale x 2 x i32> %va) {
; CHECK-ZVE64X-LABEL: ctlz_nxv2i32:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    lui a0, 349525
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    addi a0, a0, 1365
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 2
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 8
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 16
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    vand.vx v9, v9, a0
; CHECK-ZVE64X-NEXT:    lui a0, 209715
; CHECK-ZVE64X-NEXT:    addi a0, a0, 819
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    lui a0, 61681
; CHECK-ZVE64X-NEXT:    addi a0, a0, -241
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v9, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    lui a0, 4112
; CHECK-ZVE64X-NEXT:    addi a0, a0, 257
; CHECK-ZVE64X-NEXT:    vmul.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 24
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_nxv2i32:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    fsrmi a0, 1
; CHECK-F-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-F-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-F-NEXT:    li a1, 158
; CHECK-F-NEXT:    vsrl.vi v8, v8, 23
; CHECK-F-NEXT:    vrsub.vx v8, v8, a1
; CHECK-F-NEXT:    li a1, 32
; CHECK-F-NEXT:    vminu.vx v8, v8, a1
; CHECK-F-NEXT:    fsrm a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_nxv2i32:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-D-NEXT:    vfwcvt.f.xu.v v10, v8
; CHECK-D-NEXT:    li a0, 52
; CHECK-D-NEXT:    vnsrl.wx v8, v10, a0
; CHECK-D-NEXT:    li a0, 1054
; CHECK-D-NEXT:    vrsub.vx v8, v8, a0
; CHECK-D-NEXT:    li a0, 32
; CHECK-D-NEXT:    vminu.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_nxv2i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 2 x i32> @llvm.ctlz.nxv2i32(<vscale x 2 x i32> %va, i1 false)
  ret <vscale x 2 x i32> %a
}
declare <vscale x 2 x i32> @llvm.ctlz.nxv2i32(<vscale x 2 x i32>, i1)

define <vscale x 4 x i32> @ctlz_nxv4i32(<vscale x 4 x i32> %va) {
; CHECK-ZVE64X-LABEL: ctlz_nxv4i32:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 1
; CHECK-ZVE64X-NEXT:    lui a0, 349525
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    addi a0, a0, 1365
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 2
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 4
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 8
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 16
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 1
; CHECK-ZVE64X-NEXT:    vand.vx v10, v10, a0
; CHECK-ZVE64X-NEXT:    lui a0, 209715
; CHECK-ZVE64X-NEXT:    addi a0, a0, 819
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vand.vx v10, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    lui a0, 61681
; CHECK-ZVE64X-NEXT:    addi a0, a0, -241
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v10, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    lui a0, 4112
; CHECK-ZVE64X-NEXT:    addi a0, a0, 257
; CHECK-ZVE64X-NEXT:    vmul.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 24
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_nxv4i32:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    fsrmi a0, 1
; CHECK-F-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; CHECK-F-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-F-NEXT:    li a1, 158
; CHECK-F-NEXT:    vsrl.vi v8, v8, 23
; CHECK-F-NEXT:    vrsub.vx v8, v8, a1
; CHECK-F-NEXT:    li a1, 32
; CHECK-F-NEXT:    vminu.vx v8, v8, a1
; CHECK-F-NEXT:    fsrm a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_nxv4i32:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-D-NEXT:    vfwcvt.f.xu.v v12, v8
; CHECK-D-NEXT:    li a0, 52
; CHECK-D-NEXT:    vnsrl.wx v8, v12, a0
; CHECK-D-NEXT:    li a0, 1054
; CHECK-D-NEXT:    vrsub.vx v8, v8, a0
; CHECK-D-NEXT:    li a0, 32
; CHECK-D-NEXT:    vminu.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_nxv4i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 4 x i32> @llvm.ctlz.nxv4i32(<vscale x 4 x i32> %va, i1 false)
  ret <vscale x 4 x i32> %a
}
declare <vscale x 4 x i32> @llvm.ctlz.nxv4i32(<vscale x 4 x i32>, i1)

define <vscale x 8 x i32> @ctlz_nxv8i32(<vscale x 8 x i32> %va) {
; CHECK-ZVE64X-LABEL: ctlz_nxv8i32:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-ZVE64X-NEXT:    vsrl.vi v12, v8, 1
; CHECK-ZVE64X-NEXT:    lui a0, 349525
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v12
; CHECK-ZVE64X-NEXT:    addi a0, a0, 1365
; CHECK-ZVE64X-NEXT:    vsrl.vi v12, v8, 2
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v12
; CHECK-ZVE64X-NEXT:    vsrl.vi v12, v8, 4
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v12
; CHECK-ZVE64X-NEXT:    vsrl.vi v12, v8, 8
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v12
; CHECK-ZVE64X-NEXT:    vsrl.vi v12, v8, 16
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v12
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v12, v8, 1
; CHECK-ZVE64X-NEXT:    vand.vx v12, v12, a0
; CHECK-ZVE64X-NEXT:    lui a0, 209715
; CHECK-ZVE64X-NEXT:    addi a0, a0, 819
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v12
; CHECK-ZVE64X-NEXT:    vand.vx v12, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    lui a0, 61681
; CHECK-ZVE64X-NEXT:    addi a0, a0, -241
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v12, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v12, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v12
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    lui a0, 4112
; CHECK-ZVE64X-NEXT:    addi a0, a0, 257
; CHECK-ZVE64X-NEXT:    vmul.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 24
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_nxv8i32:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    fsrmi a0, 1
; CHECK-F-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-F-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-F-NEXT:    li a1, 158
; CHECK-F-NEXT:    vsrl.vi v8, v8, 23
; CHECK-F-NEXT:    vrsub.vx v8, v8, a1
; CHECK-F-NEXT:    li a1, 32
; CHECK-F-NEXT:    vminu.vx v8, v8, a1
; CHECK-F-NEXT:    fsrm a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_nxv8i32:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-D-NEXT:    vfwcvt.f.xu.v v16, v8
; CHECK-D-NEXT:    li a0, 52
; CHECK-D-NEXT:    vnsrl.wx v8, v16, a0
; CHECK-D-NEXT:    li a0, 1054
; CHECK-D-NEXT:    vrsub.vx v8, v8, a0
; CHECK-D-NEXT:    li a0, 32
; CHECK-D-NEXT:    vminu.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_nxv8i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 8 x i32> @llvm.ctlz.nxv8i32(<vscale x 8 x i32> %va, i1 false)
  ret <vscale x 8 x i32> %a
}
declare <vscale x 8 x i32> @llvm.ctlz.nxv8i32(<vscale x 8 x i32>, i1)

define <vscale x 16 x i32> @ctlz_nxv16i32(<vscale x 16 x i32> %va) {
; CHECK-ZVE64X-LABEL: ctlz_nxv16i32:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-ZVE64X-NEXT:    vsrl.vi v16, v8, 1
; CHECK-ZVE64X-NEXT:    lui a0, 349525
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v16
; CHECK-ZVE64X-NEXT:    addi a0, a0, 1365
; CHECK-ZVE64X-NEXT:    vsrl.vi v16, v8, 2
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v16
; CHECK-ZVE64X-NEXT:    vsrl.vi v16, v8, 4
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v16
; CHECK-ZVE64X-NEXT:    vsrl.vi v16, v8, 8
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v16
; CHECK-ZVE64X-NEXT:    vsrl.vi v16, v8, 16
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v16
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v16, v8, 1
; CHECK-ZVE64X-NEXT:    vand.vx v16, v16, a0
; CHECK-ZVE64X-NEXT:    lui a0, 209715
; CHECK-ZVE64X-NEXT:    addi a0, a0, 819
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v16
; CHECK-ZVE64X-NEXT:    vand.vx v16, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    lui a0, 61681
; CHECK-ZVE64X-NEXT:    addi a0, a0, -241
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v16, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v16, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v16
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    lui a0, 4112
; CHECK-ZVE64X-NEXT:    addi a0, a0, 257
; CHECK-ZVE64X-NEXT:    vmul.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 24
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_nxv16i32:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    fsrmi a0, 1
; CHECK-F-NEXT:    vsetvli a1, zero, e32, m8, ta, ma
; CHECK-F-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-F-NEXT:    li a1, 158
; CHECK-F-NEXT:    vsrl.vi v8, v8, 23
; CHECK-F-NEXT:    vrsub.vx v8, v8, a1
; CHECK-F-NEXT:    li a1, 32
; CHECK-F-NEXT:    vminu.vx v8, v8, a1
; CHECK-F-NEXT:    fsrm a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_nxv16i32:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    fsrmi a0, 1
; CHECK-D-NEXT:    vsetvli a1, zero, e32, m8, ta, ma
; CHECK-D-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-D-NEXT:    li a1, 158
; CHECK-D-NEXT:    vsrl.vi v8, v8, 23
; CHECK-D-NEXT:    vrsub.vx v8, v8, a1
; CHECK-D-NEXT:    li a1, 32
; CHECK-D-NEXT:    vminu.vx v8, v8, a1
; CHECK-D-NEXT:    fsrm a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_nxv16i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 16 x i32> @llvm.ctlz.nxv16i32(<vscale x 16 x i32> %va, i1 false)
  ret <vscale x 16 x i32> %a
}
declare <vscale x 16 x i32> @llvm.ctlz.nxv16i32(<vscale x 16 x i32>, i1)

define <vscale x 1 x i64> @ctlz_nxv1i64(<vscale x 1 x i64> %va) {
; RV32I-LABEL: ctlz_nxv1i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; RV32I-NEXT:    vmv.v.x v10, a0
; RV32I-NEXT:    li a0, 32
; RV32I-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 8
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 16
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vx v9, v8, a0
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    vand.vv v9, v9, v10
; RV32I-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; RV32I-NEXT:    vmv.v.x v10, a0
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; RV32I-NEXT:    vsub.vv v8, v8, v9
; RV32I-NEXT:    vand.vv v9, v8, v10
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vv v8, v8, v10
; RV32I-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; RV32I-NEXT:    vmv.v.x v10, a0
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; RV32I-NEXT:    vadd.vv v8, v9, v8
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v9
; RV32I-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; RV32I-NEXT:    vmv.v.x v9, a0
; RV32I-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV32I-NEXT:    vand.vv v8, v8, v10
; RV32I-NEXT:    vmul.vv v8, v8, v9
; RV32I-NEXT:    li a0, 56
; RV32I-NEXT:    vsrl.vx v8, v8, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_nxv1i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    lui a1, 209715
; RV64I-NEXT:    lui a2, 61681
; RV64I-NEXT:    lui a3, 4112
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    addiw a1, a1, 819
; RV64I-NEXT:    addiw a2, a2, -241
; RV64I-NEXT:    addiw a3, a3, 257
; RV64I-NEXT:    slli a4, a0, 32
; RV64I-NEXT:    add a0, a0, a4
; RV64I-NEXT:    slli a4, a1, 32
; RV64I-NEXT:    add a1, a1, a4
; RV64I-NEXT:    slli a4, a2, 32
; RV64I-NEXT:    add a2, a2, a4
; RV64I-NEXT:    slli a4, a3, 32
; RV64I-NEXT:    add a3, a3, a4
; RV64I-NEXT:    li a4, 32
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 8
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 16
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vx v9, v8, a4
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    vand.vx v9, v9, a0
; RV64I-NEXT:    vsub.vv v8, v8, v9
; RV64I-NEXT:    vand.vx v9, v8, a1
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a1
; RV64I-NEXT:    vadd.vv v8, v9, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    vand.vx v8, v8, a2
; RV64I-NEXT:    vmul.vx v8, v8, a3
; RV64I-NEXT:    li a0, 56
; RV64I-NEXT:    vsrl.vx v8, v8, a0
; RV64I-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_nxv1i64:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    li a0, 190
; CHECK-F-NEXT:    fsrmi a1, 1
; CHECK-F-NEXT:    vsetvli a2, zero, e32, mf2, ta, ma
; CHECK-F-NEXT:    vfncvt.f.xu.w v9, v8
; CHECK-F-NEXT:    vmv.v.x v8, a0
; CHECK-F-NEXT:    vsrl.vi v9, v9, 23
; CHECK-F-NEXT:    vwsubu.vv v10, v8, v9
; CHECK-F-NEXT:    li a0, 64
; CHECK-F-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; CHECK-F-NEXT:    vminu.vx v8, v10, a0
; CHECK-F-NEXT:    fsrm a1
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_nxv1i64:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    fsrmi a0, 1
; CHECK-D-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-D-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-D-NEXT:    li a1, 52
; CHECK-D-NEXT:    vsrl.vx v8, v8, a1
; CHECK-D-NEXT:    li a1, 1086
; CHECK-D-NEXT:    vrsub.vx v8, v8, a1
; CHECK-D-NEXT:    li a1, 64
; CHECK-D-NEXT:    vminu.vx v8, v8, a1
; CHECK-D-NEXT:    fsrm a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_nxv1i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 1 x i64> @llvm.ctlz.nxv1i64(<vscale x 1 x i64> %va, i1 false)
  ret <vscale x 1 x i64> %a
}
declare <vscale x 1 x i64> @llvm.ctlz.nxv1i64(<vscale x 1 x i64>, i1)

define <vscale x 2 x i64> @ctlz_nxv2i64(<vscale x 2 x i64> %va) {
; RV32I-LABEL: ctlz_nxv2i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; RV32I-NEXT:    vsrl.vi v10, v8, 1
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; RV32I-NEXT:    vmv.v.x v12, a0
; RV32I-NEXT:    li a0, 32
; RV32I-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vsrl.vi v10, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vsrl.vi v10, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vsrl.vi v10, v8, 8
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vsrl.vi v10, v8, 16
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vsrl.vx v10, v8, a0
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vsrl.vi v10, v8, 1
; RV32I-NEXT:    vand.vv v10, v10, v12
; RV32I-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; RV32I-NEXT:    vmv.v.x v12, a0
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; RV32I-NEXT:    vsub.vv v8, v8, v10
; RV32I-NEXT:    vand.vv v10, v8, v12
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vv v8, v8, v12
; RV32I-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; RV32I-NEXT:    vmv.v.x v12, a0
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; RV32I-NEXT:    vadd.vv v8, v10, v8
; RV32I-NEXT:    vsrl.vi v10, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v10
; RV32I-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; RV32I-NEXT:    vmv.v.x v10, a0
; RV32I-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; RV32I-NEXT:    vand.vv v8, v8, v12
; RV32I-NEXT:    vmul.vv v8, v8, v10
; RV32I-NEXT:    li a0, 56
; RV32I-NEXT:    vsrl.vx v8, v8, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_nxv2i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; RV64I-NEXT:    vsrl.vi v10, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    lui a1, 209715
; RV64I-NEXT:    lui a2, 61681
; RV64I-NEXT:    lui a3, 4112
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    addiw a1, a1, 819
; RV64I-NEXT:    addiw a2, a2, -241
; RV64I-NEXT:    addiw a3, a3, 257
; RV64I-NEXT:    slli a4, a0, 32
; RV64I-NEXT:    add a0, a0, a4
; RV64I-NEXT:    slli a4, a1, 32
; RV64I-NEXT:    add a1, a1, a4
; RV64I-NEXT:    slli a4, a2, 32
; RV64I-NEXT:    add a2, a2, a4
; RV64I-NEXT:    slli a4, a3, 32
; RV64I-NEXT:    add a3, a3, a4
; RV64I-NEXT:    li a4, 32
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vi v10, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vi v10, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vi v10, v8, 8
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vi v10, v8, 16
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vx v10, v8, a4
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vsrl.vi v10, v8, 1
; RV64I-NEXT:    vand.vx v10, v10, a0
; RV64I-NEXT:    vsub.vv v8, v8, v10
; RV64I-NEXT:    vand.vx v10, v8, a1
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a1
; RV64I-NEXT:    vadd.vv v8, v10, v8
; RV64I-NEXT:    vsrl.vi v10, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v10
; RV64I-NEXT:    vand.vx v8, v8, a2
; RV64I-NEXT:    vmul.vx v8, v8, a3
; RV64I-NEXT:    li a0, 56
; RV64I-NEXT:    vsrl.vx v8, v8, a0
; RV64I-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_nxv2i64:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    li a0, 190
; CHECK-F-NEXT:    fsrmi a1, 1
; CHECK-F-NEXT:    vsetvli a2, zero, e32, m1, ta, ma
; CHECK-F-NEXT:    vfncvt.f.xu.w v10, v8
; CHECK-F-NEXT:    vmv.v.x v8, a0
; CHECK-F-NEXT:    vsrl.vi v9, v10, 23
; CHECK-F-NEXT:    vwsubu.vv v10, v8, v9
; CHECK-F-NEXT:    li a0, 64
; CHECK-F-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-F-NEXT:    vminu.vx v8, v10, a0
; CHECK-F-NEXT:    fsrm a1
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_nxv2i64:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    fsrmi a0, 1
; CHECK-D-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; CHECK-D-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-D-NEXT:    li a1, 52
; CHECK-D-NEXT:    vsrl.vx v8, v8, a1
; CHECK-D-NEXT:    li a1, 1086
; CHECK-D-NEXT:    vrsub.vx v8, v8, a1
; CHECK-D-NEXT:    li a1, 64
; CHECK-D-NEXT:    vminu.vx v8, v8, a1
; CHECK-D-NEXT:    fsrm a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_nxv2i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 2 x i64> @llvm.ctlz.nxv2i64(<vscale x 2 x i64> %va, i1 false)
  ret <vscale x 2 x i64> %a
}
declare <vscale x 2 x i64> @llvm.ctlz.nxv2i64(<vscale x 2 x i64>, i1)

define <vscale x 4 x i64> @ctlz_nxv4i64(<vscale x 4 x i64> %va) {
; RV32I-LABEL: ctlz_nxv4i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; RV32I-NEXT:    vsrl.vi v12, v8, 1
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; RV32I-NEXT:    vmv.v.x v16, a0
; RV32I-NEXT:    li a0, 32
; RV32I-NEXT:    vsetvli a1, zero, e64, m4, ta, ma
; RV32I-NEXT:    vor.vv v8, v8, v12
; RV32I-NEXT:    vsrl.vi v12, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v12
; RV32I-NEXT:    vsrl.vi v12, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v12
; RV32I-NEXT:    vsrl.vi v12, v8, 8
; RV32I-NEXT:    vor.vv v8, v8, v12
; RV32I-NEXT:    vsrl.vi v12, v8, 16
; RV32I-NEXT:    vor.vv v8, v8, v12
; RV32I-NEXT:    vsrl.vx v12, v8, a0
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vor.vv v8, v8, v12
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vsrl.vi v12, v8, 1
; RV32I-NEXT:    vand.vv v12, v12, v16
; RV32I-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; RV32I-NEXT:    vmv.v.x v16, a0
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vsetvli a1, zero, e64, m4, ta, ma
; RV32I-NEXT:    vsub.vv v8, v8, v12
; RV32I-NEXT:    vand.vv v12, v8, v16
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vv v8, v8, v16
; RV32I-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; RV32I-NEXT:    vmv.v.x v16, a0
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    vsetvli a1, zero, e64, m4, ta, ma
; RV32I-NEXT:    vadd.vv v8, v12, v8
; RV32I-NEXT:    vsrl.vi v12, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v12
; RV32I-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; RV32I-NEXT:    vmv.v.x v12, a0
; RV32I-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; RV32I-NEXT:    vand.vv v8, v8, v16
; RV32I-NEXT:    vmul.vv v8, v8, v12
; RV32I-NEXT:    li a0, 56
; RV32I-NEXT:    vsrl.vx v8, v8, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_nxv4i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; RV64I-NEXT:    vsrl.vi v12, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    lui a1, 209715
; RV64I-NEXT:    lui a2, 61681
; RV64I-NEXT:    lui a3, 4112
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    addiw a1, a1, 819
; RV64I-NEXT:    addiw a2, a2, -241
; RV64I-NEXT:    addiw a3, a3, 257
; RV64I-NEXT:    slli a4, a0, 32
; RV64I-NEXT:    add a0, a0, a4
; RV64I-NEXT:    slli a4, a1, 32
; RV64I-NEXT:    add a1, a1, a4
; RV64I-NEXT:    slli a4, a2, 32
; RV64I-NEXT:    add a2, a2, a4
; RV64I-NEXT:    slli a4, a3, 32
; RV64I-NEXT:    add a3, a3, a4
; RV64I-NEXT:    li a4, 32
; RV64I-NEXT:    vor.vv v8, v8, v12
; RV64I-NEXT:    vsrl.vi v12, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v12
; RV64I-NEXT:    vsrl.vi v12, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v12
; RV64I-NEXT:    vsrl.vi v12, v8, 8
; RV64I-NEXT:    vor.vv v8, v8, v12
; RV64I-NEXT:    vsrl.vi v12, v8, 16
; RV64I-NEXT:    vor.vv v8, v8, v12
; RV64I-NEXT:    vsrl.vx v12, v8, a4
; RV64I-NEXT:    vor.vv v8, v8, v12
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vsrl.vi v12, v8, 1
; RV64I-NEXT:    vand.vx v12, v12, a0
; RV64I-NEXT:    vsub.vv v8, v8, v12
; RV64I-NEXT:    vand.vx v12, v8, a1
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a1
; RV64I-NEXT:    vadd.vv v8, v12, v8
; RV64I-NEXT:    vsrl.vi v12, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v12
; RV64I-NEXT:    vand.vx v8, v8, a2
; RV64I-NEXT:    vmul.vx v8, v8, a3
; RV64I-NEXT:    li a0, 56
; RV64I-NEXT:    vsrl.vx v8, v8, a0
; RV64I-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_nxv4i64:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    li a0, 190
; CHECK-F-NEXT:    fsrmi a1, 1
; CHECK-F-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; CHECK-F-NEXT:    vfncvt.f.xu.w v12, v8
; CHECK-F-NEXT:    vmv.v.x v8, a0
; CHECK-F-NEXT:    vsrl.vi v10, v12, 23
; CHECK-F-NEXT:    vwsubu.vv v12, v8, v10
; CHECK-F-NEXT:    li a0, 64
; CHECK-F-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; CHECK-F-NEXT:    vminu.vx v8, v12, a0
; CHECK-F-NEXT:    fsrm a1
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_nxv4i64:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    fsrmi a0, 1
; CHECK-D-NEXT:    vsetvli a1, zero, e64, m4, ta, ma
; CHECK-D-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-D-NEXT:    li a1, 52
; CHECK-D-NEXT:    vsrl.vx v8, v8, a1
; CHECK-D-NEXT:    li a1, 1086
; CHECK-D-NEXT:    vrsub.vx v8, v8, a1
; CHECK-D-NEXT:    li a1, 64
; CHECK-D-NEXT:    vminu.vx v8, v8, a1
; CHECK-D-NEXT:    fsrm a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_nxv4i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 4 x i64> @llvm.ctlz.nxv4i64(<vscale x 4 x i64> %va, i1 false)
  ret <vscale x 4 x i64> %a
}
declare <vscale x 4 x i64> @llvm.ctlz.nxv4i64(<vscale x 4 x i64>, i1)

define <vscale x 8 x i64> @ctlz_nxv8i64(<vscale x 8 x i64> %va) {
; RV32I-LABEL: ctlz_nxv8i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; RV32I-NEXT:    vsrl.vi v16, v8, 1
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vsetvli a1, zero, e32, m8, ta, ma
; RV32I-NEXT:    vmv.v.x v24, a0
; RV32I-NEXT:    li a0, 32
; RV32I-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32I-NEXT:    vor.vv v8, v8, v16
; RV32I-NEXT:    vsrl.vi v16, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v16
; RV32I-NEXT:    vsrl.vi v16, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v16
; RV32I-NEXT:    vsrl.vi v16, v8, 8
; RV32I-NEXT:    vor.vv v8, v8, v16
; RV32I-NEXT:    vsrl.vi v16, v8, 16
; RV32I-NEXT:    vor.vv v8, v8, v16
; RV32I-NEXT:    vsrl.vx v16, v8, a0
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vor.vv v8, v8, v16
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vsrl.vi v16, v8, 1
; RV32I-NEXT:    vand.vv v24, v16, v24
; RV32I-NEXT:    vsetvli a1, zero, e32, m8, ta, ma
; RV32I-NEXT:    vmv.v.x v16, a0
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32I-NEXT:    vsub.vv v8, v8, v24
; RV32I-NEXT:    vand.vv v24, v8, v16
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vv v8, v8, v16
; RV32I-NEXT:    vsetvli a1, zero, e32, m8, ta, ma
; RV32I-NEXT:    vmv.v.x v16, a0
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32I-NEXT:    vadd.vv v8, v24, v8
; RV32I-NEXT:    vsrl.vi v24, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v24
; RV32I-NEXT:    vsetvli a1, zero, e32, m8, ta, ma
; RV32I-NEXT:    vmv.v.x v24, a0
; RV32I-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; RV32I-NEXT:    vand.vv v8, v8, v16
; RV32I-NEXT:    vmul.vv v8, v8, v24
; RV32I-NEXT:    li a0, 56
; RV32I-NEXT:    vsrl.vx v8, v8, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_nxv8i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; RV64I-NEXT:    vsrl.vi v16, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    lui a1, 209715
; RV64I-NEXT:    lui a2, 61681
; RV64I-NEXT:    lui a3, 4112
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    addiw a1, a1, 819
; RV64I-NEXT:    addiw a2, a2, -241
; RV64I-NEXT:    addiw a3, a3, 257
; RV64I-NEXT:    slli a4, a0, 32
; RV64I-NEXT:    add a0, a0, a4
; RV64I-NEXT:    slli a4, a1, 32
; RV64I-NEXT:    add a1, a1, a4
; RV64I-NEXT:    slli a4, a2, 32
; RV64I-NEXT:    add a2, a2, a4
; RV64I-NEXT:    slli a4, a3, 32
; RV64I-NEXT:    add a3, a3, a4
; RV64I-NEXT:    li a4, 32
; RV64I-NEXT:    vor.vv v8, v8, v16
; RV64I-NEXT:    vsrl.vi v16, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v16
; RV64I-NEXT:    vsrl.vi v16, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v16
; RV64I-NEXT:    vsrl.vi v16, v8, 8
; RV64I-NEXT:    vor.vv v8, v8, v16
; RV64I-NEXT:    vsrl.vi v16, v8, 16
; RV64I-NEXT:    vor.vv v8, v8, v16
; RV64I-NEXT:    vsrl.vx v16, v8, a4
; RV64I-NEXT:    vor.vv v8, v8, v16
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vsrl.vi v16, v8, 1
; RV64I-NEXT:    vand.vx v16, v16, a0
; RV64I-NEXT:    vsub.vv v8, v8, v16
; RV64I-NEXT:    vand.vx v16, v8, a1
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a1
; RV64I-NEXT:    vadd.vv v8, v16, v8
; RV64I-NEXT:    vsrl.vi v16, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v16
; RV64I-NEXT:    vand.vx v8, v8, a2
; RV64I-NEXT:    vmul.vx v8, v8, a3
; RV64I-NEXT:    li a0, 56
; RV64I-NEXT:    vsrl.vx v8, v8, a0
; RV64I-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_nxv8i64:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    li a0, 190
; CHECK-F-NEXT:    fsrmi a1, 1
; CHECK-F-NEXT:    vsetvli a2, zero, e32, m4, ta, ma
; CHECK-F-NEXT:    vfncvt.f.xu.w v16, v8
; CHECK-F-NEXT:    vmv.v.x v8, a0
; CHECK-F-NEXT:    vsrl.vi v12, v16, 23
; CHECK-F-NEXT:    vwsubu.vv v16, v8, v12
; CHECK-F-NEXT:    li a0, 64
; CHECK-F-NEXT:    vsetvli zero, zero, e64, m8, ta, ma
; CHECK-F-NEXT:    vminu.vx v8, v16, a0
; CHECK-F-NEXT:    fsrm a1
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_nxv8i64:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    fsrmi a0, 1
; CHECK-D-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; CHECK-D-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-D-NEXT:    li a1, 52
; CHECK-D-NEXT:    vsrl.vx v8, v8, a1
; CHECK-D-NEXT:    li a1, 1086
; CHECK-D-NEXT:    vrsub.vx v8, v8, a1
; CHECK-D-NEXT:    li a1, 64
; CHECK-D-NEXT:    vminu.vx v8, v8, a1
; CHECK-D-NEXT:    fsrm a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_nxv8i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 8 x i64> @llvm.ctlz.nxv8i64(<vscale x 8 x i64> %va, i1 false)
  ret <vscale x 8 x i64> %a
}
declare <vscale x 8 x i64> @llvm.ctlz.nxv8i64(<vscale x 8 x i64>, i1)

define <vscale x 1 x i8> @ctlz_zero_undef_nxv1i8(<vscale x 1 x i8> %va) {
; CHECK-ZVE64X-LABEL: ctlz_zero_undef_nxv1i8:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    li a0, 85
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 2
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    vand.vx v9, v9, a0
; CHECK-ZVE64X-NEXT:    li a0, 51
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v9, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vi v8, v8, 15
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_zero_undef_nxv1i8:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-F-NEXT:    vzext.vf2 v9, v8
; CHECK-F-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-F-NEXT:    vnsrl.wi v8, v8, 23
; CHECK-F-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-F-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-F-NEXT:    li a0, 134
; CHECK-F-NEXT:    vrsub.vx v8, v8, a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_zero_undef_nxv1i8:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-D-NEXT:    vzext.vf2 v9, v8
; CHECK-D-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-D-NEXT:    vnsrl.wi v8, v8, 23
; CHECK-D-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-D-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-D-NEXT:    li a0, 134
; CHECK-D-NEXT:    vrsub.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_zero_undef_nxv1i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 1 x i8> @llvm.ctlz.nxv1i8(<vscale x 1 x i8> %va, i1 true)
  ret <vscale x 1 x i8> %a
}

define <vscale x 2 x i8> @ctlz_zero_undef_nxv2i8(<vscale x 2 x i8> %va) {
; CHECK-ZVE64X-LABEL: ctlz_zero_undef_nxv2i8:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    li a0, 85
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 2
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    vand.vx v9, v9, a0
; CHECK-ZVE64X-NEXT:    li a0, 51
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v9, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vi v8, v8, 15
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_zero_undef_nxv2i8:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-F-NEXT:    vzext.vf2 v9, v8
; CHECK-F-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-F-NEXT:    vnsrl.wi v8, v8, 23
; CHECK-F-NEXT:    vsetvli zero, zero, e8, mf4, ta, ma
; CHECK-F-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-F-NEXT:    li a0, 134
; CHECK-F-NEXT:    vrsub.vx v8, v8, a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_zero_undef_nxv2i8:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-D-NEXT:    vzext.vf2 v9, v8
; CHECK-D-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-D-NEXT:    vnsrl.wi v8, v8, 23
; CHECK-D-NEXT:    vsetvli zero, zero, e8, mf4, ta, ma
; CHECK-D-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-D-NEXT:    li a0, 134
; CHECK-D-NEXT:    vrsub.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_zero_undef_nxv2i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 2 x i8> @llvm.ctlz.nxv2i8(<vscale x 2 x i8> %va, i1 true)
  ret <vscale x 2 x i8> %a
}

define <vscale x 4 x i8> @ctlz_zero_undef_nxv4i8(<vscale x 4 x i8> %va) {
; CHECK-ZVE64X-LABEL: ctlz_zero_undef_nxv4i8:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    li a0, 85
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 2
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    vand.vx v9, v9, a0
; CHECK-ZVE64X-NEXT:    li a0, 51
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v9, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vi v8, v8, 15
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_zero_undef_nxv4i8:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-F-NEXT:    vzext.vf2 v9, v8
; CHECK-F-NEXT:    vfwcvt.f.xu.v v10, v9
; CHECK-F-NEXT:    vnsrl.wi v8, v10, 23
; CHECK-F-NEXT:    vsetvli zero, zero, e8, mf2, ta, ma
; CHECK-F-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-F-NEXT:    li a0, 134
; CHECK-F-NEXT:    vrsub.vx v8, v8, a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_zero_undef_nxv4i8:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-D-NEXT:    vzext.vf2 v9, v8
; CHECK-D-NEXT:    vfwcvt.f.xu.v v10, v9
; CHECK-D-NEXT:    vnsrl.wi v8, v10, 23
; CHECK-D-NEXT:    vsetvli zero, zero, e8, mf2, ta, ma
; CHECK-D-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-D-NEXT:    li a0, 134
; CHECK-D-NEXT:    vrsub.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_zero_undef_nxv4i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 4 x i8> @llvm.ctlz.nxv4i8(<vscale x 4 x i8> %va, i1 true)
  ret <vscale x 4 x i8> %a
}

define <vscale x 8 x i8> @ctlz_zero_undef_nxv8i8(<vscale x 8 x i8> %va) {
; CHECK-ZVE64X-LABEL: ctlz_zero_undef_nxv8i8:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    li a0, 85
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 2
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    vand.vx v9, v9, a0
; CHECK-ZVE64X-NEXT:    li a0, 51
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v9, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vi v8, v8, 15
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_zero_undef_nxv8i8:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-F-NEXT:    vzext.vf2 v10, v8
; CHECK-F-NEXT:    vfwcvt.f.xu.v v12, v10
; CHECK-F-NEXT:    vnsrl.wi v8, v12, 23
; CHECK-F-NEXT:    vsetvli zero, zero, e8, m1, ta, ma
; CHECK-F-NEXT:    vnsrl.wi v10, v8, 0
; CHECK-F-NEXT:    li a0, 134
; CHECK-F-NEXT:    vrsub.vx v8, v10, a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_zero_undef_nxv8i8:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-D-NEXT:    vzext.vf2 v10, v8
; CHECK-D-NEXT:    vfwcvt.f.xu.v v12, v10
; CHECK-D-NEXT:    vnsrl.wi v8, v12, 23
; CHECK-D-NEXT:    vsetvli zero, zero, e8, m1, ta, ma
; CHECK-D-NEXT:    vnsrl.wi v10, v8, 0
; CHECK-D-NEXT:    li a0, 134
; CHECK-D-NEXT:    vrsub.vx v8, v10, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_zero_undef_nxv8i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 8 x i8> @llvm.ctlz.nxv8i8(<vscale x 8 x i8> %va, i1 true)
  ret <vscale x 8 x i8> %a
}

define <vscale x 16 x i8> @ctlz_zero_undef_nxv16i8(<vscale x 16 x i8> %va) {
; CHECK-ZVE64X-LABEL: ctlz_zero_undef_nxv16i8:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 1
; CHECK-ZVE64X-NEXT:    li a0, 85
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 2
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 4
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 1
; CHECK-ZVE64X-NEXT:    vand.vx v10, v10, a0
; CHECK-ZVE64X-NEXT:    li a0, 51
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vand.vx v10, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v10, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vand.vi v8, v8, 15
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_zero_undef_nxv16i8:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-F-NEXT:    vzext.vf2 v12, v8
; CHECK-F-NEXT:    vfwcvt.f.xu.v v16, v12
; CHECK-F-NEXT:    vnsrl.wi v8, v16, 23
; CHECK-F-NEXT:    vsetvli zero, zero, e8, m2, ta, ma
; CHECK-F-NEXT:    vnsrl.wi v12, v8, 0
; CHECK-F-NEXT:    li a0, 134
; CHECK-F-NEXT:    vrsub.vx v8, v12, a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_zero_undef_nxv16i8:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-D-NEXT:    vzext.vf2 v12, v8
; CHECK-D-NEXT:    vfwcvt.f.xu.v v16, v12
; CHECK-D-NEXT:    vnsrl.wi v8, v16, 23
; CHECK-D-NEXT:    vsetvli zero, zero, e8, m2, ta, ma
; CHECK-D-NEXT:    vnsrl.wi v12, v8, 0
; CHECK-D-NEXT:    li a0, 134
; CHECK-D-NEXT:    vrsub.vx v8, v12, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_zero_undef_nxv16i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 16 x i8> @llvm.ctlz.nxv16i8(<vscale x 16 x i8> %va, i1 true)
  ret <vscale x 16 x i8> %a
}

define <vscale x 32 x i8> @ctlz_zero_undef_nxv32i8(<vscale x 32 x i8> %va) {
; CHECK-LABEL: ctlz_zero_undef_nxv32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-NEXT:    vsrl.vi v12, v8, 1
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vor.vv v8, v8, v12
; CHECK-NEXT:    vsrl.vi v12, v8, 2
; CHECK-NEXT:    vor.vv v8, v8, v12
; CHECK-NEXT:    vsrl.vi v12, v8, 4
; CHECK-NEXT:    vor.vv v8, v8, v12
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vsrl.vi v12, v8, 1
; CHECK-NEXT:    vand.vx v12, v12, a0
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vsub.vv v8, v8, v12
; CHECK-NEXT:    vand.vx v12, v8, a0
; CHECK-NEXT:    vsrl.vi v8, v8, 2
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v12, v8
; CHECK-NEXT:    vsrl.vi v12, v8, 4
; CHECK-NEXT:    vadd.vv v8, v8, v12
; CHECK-NEXT:    vand.vi v8, v8, 15
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_zero_undef_nxv32i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 32 x i8> @llvm.ctlz.nxv32i8(<vscale x 32 x i8> %va, i1 true)
  ret <vscale x 32 x i8> %a
}

define <vscale x 64 x i8> @ctlz_zero_undef_nxv64i8(<vscale x 64 x i8> %va) {
; CHECK-LABEL: ctlz_zero_undef_nxv64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-NEXT:    vsrl.vi v16, v8, 1
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vsrl.vi v16, v8, 2
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vsrl.vi v16, v8, 4
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vsrl.vi v16, v8, 1
; CHECK-NEXT:    vand.vx v16, v16, a0
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vsub.vv v8, v8, v16
; CHECK-NEXT:    vand.vx v16, v8, a0
; CHECK-NEXT:    vsrl.vi v8, v8, 2
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v16, v8
; CHECK-NEXT:    vsrl.vi v16, v8, 4
; CHECK-NEXT:    vadd.vv v8, v8, v16
; CHECK-NEXT:    vand.vi v8, v8, 15
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_zero_undef_nxv64i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 64 x i8> @llvm.ctlz.nxv64i8(<vscale x 64 x i8> %va, i1 true)
  ret <vscale x 64 x i8> %a
}

define <vscale x 1 x i16> @ctlz_zero_undef_nxv1i16(<vscale x 1 x i16> %va) {
; CHECK-ZVE64X-LABEL: ctlz_zero_undef_nxv1i16:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    lui a0, 5
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    addi a0, a0, 1365
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 2
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 8
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    vand.vx v9, v9, a0
; CHECK-ZVE64X-NEXT:    lui a0, 3
; CHECK-ZVE64X-NEXT:    addi a0, a0, 819
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    lui a0, 1
; CHECK-ZVE64X-NEXT:    addi a0, a0, -241
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v9, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    li a0, 257
; CHECK-ZVE64X-NEXT:    vmul.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 8
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_zero_undef_nxv1i16:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-F-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-F-NEXT:    vnsrl.wi v8, v9, 23
; CHECK-F-NEXT:    li a0, 142
; CHECK-F-NEXT:    vrsub.vx v8, v8, a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_zero_undef_nxv1i16:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-D-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-D-NEXT:    vnsrl.wi v8, v9, 23
; CHECK-D-NEXT:    li a0, 142
; CHECK-D-NEXT:    vrsub.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_zero_undef_nxv1i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 1 x i16> @llvm.ctlz.nxv1i16(<vscale x 1 x i16> %va, i1 true)
  ret <vscale x 1 x i16> %a
}

define <vscale x 2 x i16> @ctlz_zero_undef_nxv2i16(<vscale x 2 x i16> %va) {
; CHECK-ZVE64X-LABEL: ctlz_zero_undef_nxv2i16:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    lui a0, 5
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    addi a0, a0, 1365
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 2
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 8
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    vand.vx v9, v9, a0
; CHECK-ZVE64X-NEXT:    lui a0, 3
; CHECK-ZVE64X-NEXT:    addi a0, a0, 819
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    lui a0, 1
; CHECK-ZVE64X-NEXT:    addi a0, a0, -241
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v9, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    li a0, 257
; CHECK-ZVE64X-NEXT:    vmul.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 8
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_zero_undef_nxv2i16:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-F-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-F-NEXT:    vnsrl.wi v8, v9, 23
; CHECK-F-NEXT:    li a0, 142
; CHECK-F-NEXT:    vrsub.vx v8, v8, a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_zero_undef_nxv2i16:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-D-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-D-NEXT:    vnsrl.wi v8, v9, 23
; CHECK-D-NEXT:    li a0, 142
; CHECK-D-NEXT:    vrsub.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_zero_undef_nxv2i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 2 x i16> @llvm.ctlz.nxv2i16(<vscale x 2 x i16> %va, i1 true)
  ret <vscale x 2 x i16> %a
}

define <vscale x 4 x i16> @ctlz_zero_undef_nxv4i16(<vscale x 4 x i16> %va) {
; CHECK-ZVE64X-LABEL: ctlz_zero_undef_nxv4i16:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    lui a0, 5
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    addi a0, a0, 1365
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 2
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 8
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    vand.vx v9, v9, a0
; CHECK-ZVE64X-NEXT:    lui a0, 3
; CHECK-ZVE64X-NEXT:    addi a0, a0, 819
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    lui a0, 1
; CHECK-ZVE64X-NEXT:    addi a0, a0, -241
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v9, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    li a0, 257
; CHECK-ZVE64X-NEXT:    vmul.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 8
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_zero_undef_nxv4i16:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-F-NEXT:    vfwcvt.f.xu.v v10, v8
; CHECK-F-NEXT:    vnsrl.wi v8, v10, 23
; CHECK-F-NEXT:    li a0, 142
; CHECK-F-NEXT:    vrsub.vx v8, v8, a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_zero_undef_nxv4i16:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-D-NEXT:    vfwcvt.f.xu.v v10, v8
; CHECK-D-NEXT:    vnsrl.wi v8, v10, 23
; CHECK-D-NEXT:    li a0, 142
; CHECK-D-NEXT:    vrsub.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_zero_undef_nxv4i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 4 x i16> @llvm.ctlz.nxv4i16(<vscale x 4 x i16> %va, i1 true)
  ret <vscale x 4 x i16> %a
}

define <vscale x 8 x i16> @ctlz_zero_undef_nxv8i16(<vscale x 8 x i16> %va) {
; CHECK-ZVE64X-LABEL: ctlz_zero_undef_nxv8i16:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 1
; CHECK-ZVE64X-NEXT:    lui a0, 5
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    addi a0, a0, 1365
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 2
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 4
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 8
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 1
; CHECK-ZVE64X-NEXT:    vand.vx v10, v10, a0
; CHECK-ZVE64X-NEXT:    lui a0, 3
; CHECK-ZVE64X-NEXT:    addi a0, a0, 819
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vand.vx v10, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    lui a0, 1
; CHECK-ZVE64X-NEXT:    addi a0, a0, -241
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v10, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    li a0, 257
; CHECK-ZVE64X-NEXT:    vmul.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 8
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_zero_undef_nxv8i16:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-F-NEXT:    vfwcvt.f.xu.v v12, v8
; CHECK-F-NEXT:    vnsrl.wi v8, v12, 23
; CHECK-F-NEXT:    li a0, 142
; CHECK-F-NEXT:    vrsub.vx v8, v8, a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_zero_undef_nxv8i16:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-D-NEXT:    vfwcvt.f.xu.v v12, v8
; CHECK-D-NEXT:    vnsrl.wi v8, v12, 23
; CHECK-D-NEXT:    li a0, 142
; CHECK-D-NEXT:    vrsub.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_zero_undef_nxv8i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 8 x i16> @llvm.ctlz.nxv8i16(<vscale x 8 x i16> %va, i1 true)
  ret <vscale x 8 x i16> %a
}

define <vscale x 16 x i16> @ctlz_zero_undef_nxv16i16(<vscale x 16 x i16> %va) {
; CHECK-ZVE64X-LABEL: ctlz_zero_undef_nxv16i16:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-ZVE64X-NEXT:    vsrl.vi v12, v8, 1
; CHECK-ZVE64X-NEXT:    lui a0, 5
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v12
; CHECK-ZVE64X-NEXT:    addi a0, a0, 1365
; CHECK-ZVE64X-NEXT:    vsrl.vi v12, v8, 2
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v12
; CHECK-ZVE64X-NEXT:    vsrl.vi v12, v8, 4
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v12
; CHECK-ZVE64X-NEXT:    vsrl.vi v12, v8, 8
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v12
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v12, v8, 1
; CHECK-ZVE64X-NEXT:    vand.vx v12, v12, a0
; CHECK-ZVE64X-NEXT:    lui a0, 3
; CHECK-ZVE64X-NEXT:    addi a0, a0, 819
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v12
; CHECK-ZVE64X-NEXT:    vand.vx v12, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    lui a0, 1
; CHECK-ZVE64X-NEXT:    addi a0, a0, -241
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v12, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v12, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v12
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    li a0, 257
; CHECK-ZVE64X-NEXT:    vmul.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 8
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_zero_undef_nxv16i16:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-F-NEXT:    vfwcvt.f.xu.v v16, v8
; CHECK-F-NEXT:    vnsrl.wi v8, v16, 23
; CHECK-F-NEXT:    li a0, 142
; CHECK-F-NEXT:    vrsub.vx v8, v8, a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_zero_undef_nxv16i16:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-D-NEXT:    vfwcvt.f.xu.v v16, v8
; CHECK-D-NEXT:    vnsrl.wi v8, v16, 23
; CHECK-D-NEXT:    li a0, 142
; CHECK-D-NEXT:    vrsub.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_zero_undef_nxv16i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 16 x i16> @llvm.ctlz.nxv16i16(<vscale x 16 x i16> %va, i1 true)
  ret <vscale x 16 x i16> %a
}

define <vscale x 32 x i16> @ctlz_zero_undef_nxv32i16(<vscale x 32 x i16> %va) {
; CHECK-LABEL: ctlz_zero_undef_nxv32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vsrl.vi v16, v8, 1
; CHECK-NEXT:    lui a0, 5
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    addi a0, a0, 1365
; CHECK-NEXT:    vsrl.vi v16, v8, 2
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vsrl.vi v16, v8, 4
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vsrl.vi v16, v8, 8
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vsrl.vi v16, v8, 1
; CHECK-NEXT:    vand.vx v16, v16, a0
; CHECK-NEXT:    lui a0, 3
; CHECK-NEXT:    addi a0, a0, 819
; CHECK-NEXT:    vsub.vv v8, v8, v16
; CHECK-NEXT:    vand.vx v16, v8, a0
; CHECK-NEXT:    vsrl.vi v8, v8, 2
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    lui a0, 1
; CHECK-NEXT:    addi a0, a0, -241
; CHECK-NEXT:    vadd.vv v8, v16, v8
; CHECK-NEXT:    vsrl.vi v16, v8, 4
; CHECK-NEXT:    vadd.vv v8, v8, v16
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    li a0, 257
; CHECK-NEXT:    vmul.vx v8, v8, a0
; CHECK-NEXT:    vsrl.vi v8, v8, 8
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_zero_undef_nxv32i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 32 x i16> @llvm.ctlz.nxv32i16(<vscale x 32 x i16> %va, i1 true)
  ret <vscale x 32 x i16> %a
}

define <vscale x 1 x i32> @ctlz_zero_undef_nxv1i32(<vscale x 1 x i32> %va) {
; CHECK-ZVE64X-LABEL: ctlz_zero_undef_nxv1i32:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    lui a0, 349525
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    addi a0, a0, 1365
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 2
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 8
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 16
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    vand.vx v9, v9, a0
; CHECK-ZVE64X-NEXT:    lui a0, 209715
; CHECK-ZVE64X-NEXT:    addi a0, a0, 819
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    lui a0, 61681
; CHECK-ZVE64X-NEXT:    addi a0, a0, -241
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v9, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    lui a0, 4112
; CHECK-ZVE64X-NEXT:    addi a0, a0, 257
; CHECK-ZVE64X-NEXT:    vmul.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 24
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_zero_undef_nxv1i32:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    fsrmi a0, 1
; CHECK-F-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-F-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-F-NEXT:    vsrl.vi v8, v8, 23
; CHECK-F-NEXT:    li a1, 158
; CHECK-F-NEXT:    vrsub.vx v8, v8, a1
; CHECK-F-NEXT:    fsrm a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_zero_undef_nxv1i32:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-D-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-D-NEXT:    li a0, 52
; CHECK-D-NEXT:    vnsrl.wx v8, v9, a0
; CHECK-D-NEXT:    li a0, 1054
; CHECK-D-NEXT:    vrsub.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_zero_undef_nxv1i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 1 x i32> @llvm.ctlz.nxv1i32(<vscale x 1 x i32> %va, i1 true)
  ret <vscale x 1 x i32> %a
}

define <vscale x 2 x i32> @ctlz_zero_undef_nxv2i32(<vscale x 2 x i32> %va) {
; CHECK-ZVE64X-LABEL: ctlz_zero_undef_nxv2i32:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    lui a0, 349525
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    addi a0, a0, 1365
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 2
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 8
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 16
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    vand.vx v9, v9, a0
; CHECK-ZVE64X-NEXT:    lui a0, 209715
; CHECK-ZVE64X-NEXT:    addi a0, a0, 819
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    lui a0, 61681
; CHECK-ZVE64X-NEXT:    addi a0, a0, -241
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v9, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    lui a0, 4112
; CHECK-ZVE64X-NEXT:    addi a0, a0, 257
; CHECK-ZVE64X-NEXT:    vmul.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 24
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_zero_undef_nxv2i32:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    fsrmi a0, 1
; CHECK-F-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-F-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-F-NEXT:    vsrl.vi v8, v8, 23
; CHECK-F-NEXT:    li a1, 158
; CHECK-F-NEXT:    vrsub.vx v8, v8, a1
; CHECK-F-NEXT:    fsrm a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_zero_undef_nxv2i32:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-D-NEXT:    vfwcvt.f.xu.v v10, v8
; CHECK-D-NEXT:    li a0, 52
; CHECK-D-NEXT:    vnsrl.wx v8, v10, a0
; CHECK-D-NEXT:    li a0, 1054
; CHECK-D-NEXT:    vrsub.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_zero_undef_nxv2i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 2 x i32> @llvm.ctlz.nxv2i32(<vscale x 2 x i32> %va, i1 true)
  ret <vscale x 2 x i32> %a
}

define <vscale x 4 x i32> @ctlz_zero_undef_nxv4i32(<vscale x 4 x i32> %va) {
; CHECK-ZVE64X-LABEL: ctlz_zero_undef_nxv4i32:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 1
; CHECK-ZVE64X-NEXT:    lui a0, 349525
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    addi a0, a0, 1365
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 2
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 4
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 8
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 16
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 1
; CHECK-ZVE64X-NEXT:    vand.vx v10, v10, a0
; CHECK-ZVE64X-NEXT:    lui a0, 209715
; CHECK-ZVE64X-NEXT:    addi a0, a0, 819
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vand.vx v10, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    lui a0, 61681
; CHECK-ZVE64X-NEXT:    addi a0, a0, -241
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v10, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    lui a0, 4112
; CHECK-ZVE64X-NEXT:    addi a0, a0, 257
; CHECK-ZVE64X-NEXT:    vmul.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 24
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_zero_undef_nxv4i32:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    fsrmi a0, 1
; CHECK-F-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; CHECK-F-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-F-NEXT:    vsrl.vi v8, v8, 23
; CHECK-F-NEXT:    li a1, 158
; CHECK-F-NEXT:    vrsub.vx v8, v8, a1
; CHECK-F-NEXT:    fsrm a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_zero_undef_nxv4i32:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-D-NEXT:    vfwcvt.f.xu.v v12, v8
; CHECK-D-NEXT:    li a0, 52
; CHECK-D-NEXT:    vnsrl.wx v8, v12, a0
; CHECK-D-NEXT:    li a0, 1054
; CHECK-D-NEXT:    vrsub.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_zero_undef_nxv4i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 4 x i32> @llvm.ctlz.nxv4i32(<vscale x 4 x i32> %va, i1 true)
  ret <vscale x 4 x i32> %a
}

define <vscale x 8 x i32> @ctlz_zero_undef_nxv8i32(<vscale x 8 x i32> %va) {
; CHECK-ZVE64X-LABEL: ctlz_zero_undef_nxv8i32:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-ZVE64X-NEXT:    vsrl.vi v12, v8, 1
; CHECK-ZVE64X-NEXT:    lui a0, 349525
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v12
; CHECK-ZVE64X-NEXT:    addi a0, a0, 1365
; CHECK-ZVE64X-NEXT:    vsrl.vi v12, v8, 2
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v12
; CHECK-ZVE64X-NEXT:    vsrl.vi v12, v8, 4
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v12
; CHECK-ZVE64X-NEXT:    vsrl.vi v12, v8, 8
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v12
; CHECK-ZVE64X-NEXT:    vsrl.vi v12, v8, 16
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v12
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v12, v8, 1
; CHECK-ZVE64X-NEXT:    vand.vx v12, v12, a0
; CHECK-ZVE64X-NEXT:    lui a0, 209715
; CHECK-ZVE64X-NEXT:    addi a0, a0, 819
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v12
; CHECK-ZVE64X-NEXT:    vand.vx v12, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    lui a0, 61681
; CHECK-ZVE64X-NEXT:    addi a0, a0, -241
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v12, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v12, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v12
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    lui a0, 4112
; CHECK-ZVE64X-NEXT:    addi a0, a0, 257
; CHECK-ZVE64X-NEXT:    vmul.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 24
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_zero_undef_nxv8i32:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    fsrmi a0, 1
; CHECK-F-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-F-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-F-NEXT:    vsrl.vi v8, v8, 23
; CHECK-F-NEXT:    li a1, 158
; CHECK-F-NEXT:    vrsub.vx v8, v8, a1
; CHECK-F-NEXT:    fsrm a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_zero_undef_nxv8i32:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-D-NEXT:    vfwcvt.f.xu.v v16, v8
; CHECK-D-NEXT:    li a0, 52
; CHECK-D-NEXT:    vnsrl.wx v8, v16, a0
; CHECK-D-NEXT:    li a0, 1054
; CHECK-D-NEXT:    vrsub.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_zero_undef_nxv8i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 8 x i32> @llvm.ctlz.nxv8i32(<vscale x 8 x i32> %va, i1 true)
  ret <vscale x 8 x i32> %a
}

define <vscale x 16 x i32> @ctlz_zero_undef_nxv16i32(<vscale x 16 x i32> %va) {
; CHECK-ZVE64X-LABEL: ctlz_zero_undef_nxv16i32:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-ZVE64X-NEXT:    vsrl.vi v16, v8, 1
; CHECK-ZVE64X-NEXT:    lui a0, 349525
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v16
; CHECK-ZVE64X-NEXT:    addi a0, a0, 1365
; CHECK-ZVE64X-NEXT:    vsrl.vi v16, v8, 2
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v16
; CHECK-ZVE64X-NEXT:    vsrl.vi v16, v8, 4
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v16
; CHECK-ZVE64X-NEXT:    vsrl.vi v16, v8, 8
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v16
; CHECK-ZVE64X-NEXT:    vsrl.vi v16, v8, 16
; CHECK-ZVE64X-NEXT:    vor.vv v8, v8, v16
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v16, v8, 1
; CHECK-ZVE64X-NEXT:    vand.vx v16, v16, a0
; CHECK-ZVE64X-NEXT:    lui a0, 209715
; CHECK-ZVE64X-NEXT:    addi a0, a0, 819
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v16
; CHECK-ZVE64X-NEXT:    vand.vx v16, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    lui a0, 61681
; CHECK-ZVE64X-NEXT:    addi a0, a0, -241
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v16, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v16, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v16
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    lui a0, 4112
; CHECK-ZVE64X-NEXT:    addi a0, a0, 257
; CHECK-ZVE64X-NEXT:    vmul.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 24
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_zero_undef_nxv16i32:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    fsrmi a0, 1
; CHECK-F-NEXT:    vsetvli a1, zero, e32, m8, ta, ma
; CHECK-F-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-F-NEXT:    vsrl.vi v8, v8, 23
; CHECK-F-NEXT:    li a1, 158
; CHECK-F-NEXT:    vrsub.vx v8, v8, a1
; CHECK-F-NEXT:    fsrm a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_zero_undef_nxv16i32:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    fsrmi a0, 1
; CHECK-D-NEXT:    vsetvli a1, zero, e32, m8, ta, ma
; CHECK-D-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-D-NEXT:    vsrl.vi v8, v8, 23
; CHECK-D-NEXT:    li a1, 158
; CHECK-D-NEXT:    vrsub.vx v8, v8, a1
; CHECK-D-NEXT:    fsrm a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_zero_undef_nxv16i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 16 x i32> @llvm.ctlz.nxv16i32(<vscale x 16 x i32> %va, i1 true)
  ret <vscale x 16 x i32> %a
}

define <vscale x 1 x i64> @ctlz_zero_undef_nxv1i64(<vscale x 1 x i64> %va) {
; RV32I-LABEL: ctlz_zero_undef_nxv1i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; RV32I-NEXT:    vmv.v.x v10, a0
; RV32I-NEXT:    li a0, 32
; RV32I-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 8
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 16
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vx v9, v8, a0
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    vand.vv v9, v9, v10
; RV32I-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; RV32I-NEXT:    vmv.v.x v10, a0
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; RV32I-NEXT:    vsub.vv v8, v8, v9
; RV32I-NEXT:    vand.vv v9, v8, v10
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vv v8, v8, v10
; RV32I-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; RV32I-NEXT:    vmv.v.x v10, a0
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; RV32I-NEXT:    vadd.vv v8, v9, v8
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v9
; RV32I-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; RV32I-NEXT:    vmv.v.x v9, a0
; RV32I-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV32I-NEXT:    vand.vv v8, v8, v10
; RV32I-NEXT:    vmul.vv v8, v8, v9
; RV32I-NEXT:    li a0, 56
; RV32I-NEXT:    vsrl.vx v8, v8, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_zero_undef_nxv1i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    lui a1, 209715
; RV64I-NEXT:    lui a2, 61681
; RV64I-NEXT:    lui a3, 4112
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    addiw a1, a1, 819
; RV64I-NEXT:    addiw a2, a2, -241
; RV64I-NEXT:    addiw a3, a3, 257
; RV64I-NEXT:    slli a4, a0, 32
; RV64I-NEXT:    add a0, a0, a4
; RV64I-NEXT:    slli a4, a1, 32
; RV64I-NEXT:    add a1, a1, a4
; RV64I-NEXT:    slli a4, a2, 32
; RV64I-NEXT:    add a2, a2, a4
; RV64I-NEXT:    slli a4, a3, 32
; RV64I-NEXT:    add a3, a3, a4
; RV64I-NEXT:    li a4, 32
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 8
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 16
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vx v9, v8, a4
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    vand.vx v9, v9, a0
; RV64I-NEXT:    vsub.vv v8, v8, v9
; RV64I-NEXT:    vand.vx v9, v8, a1
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a1
; RV64I-NEXT:    vadd.vv v8, v9, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    vand.vx v8, v8, a2
; RV64I-NEXT:    vmul.vx v8, v8, a3
; RV64I-NEXT:    li a0, 56
; RV64I-NEXT:    vsrl.vx v8, v8, a0
; RV64I-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_zero_undef_nxv1i64:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    li a0, 190
; CHECK-F-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-F-NEXT:    vmv.v.x v9, a0
; CHECK-F-NEXT:    fsrmi a0, 1
; CHECK-F-NEXT:    vfncvt.f.xu.w v10, v8
; CHECK-F-NEXT:    vsrl.vi v10, v10, 23
; CHECK-F-NEXT:    vwsubu.vv v8, v9, v10
; CHECK-F-NEXT:    fsrm a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_zero_undef_nxv1i64:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    fsrmi a0, 1
; CHECK-D-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-D-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-D-NEXT:    li a1, 52
; CHECK-D-NEXT:    vsrl.vx v8, v8, a1
; CHECK-D-NEXT:    li a1, 1086
; CHECK-D-NEXT:    vrsub.vx v8, v8, a1
; CHECK-D-NEXT:    fsrm a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_zero_undef_nxv1i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 1 x i64> @llvm.ctlz.nxv1i64(<vscale x 1 x i64> %va, i1 true)
  ret <vscale x 1 x i64> %a
}

define <vscale x 2 x i64> @ctlz_zero_undef_nxv2i64(<vscale x 2 x i64> %va) {
; RV32I-LABEL: ctlz_zero_undef_nxv2i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; RV32I-NEXT:    vsrl.vi v10, v8, 1
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; RV32I-NEXT:    vmv.v.x v12, a0
; RV32I-NEXT:    li a0, 32
; RV32I-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vsrl.vi v10, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vsrl.vi v10, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vsrl.vi v10, v8, 8
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vsrl.vi v10, v8, 16
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vsrl.vx v10, v8, a0
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vsrl.vi v10, v8, 1
; RV32I-NEXT:    vand.vv v10, v10, v12
; RV32I-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; RV32I-NEXT:    vmv.v.x v12, a0
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; RV32I-NEXT:    vsub.vv v8, v8, v10
; RV32I-NEXT:    vand.vv v10, v8, v12
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vv v8, v8, v12
; RV32I-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; RV32I-NEXT:    vmv.v.x v12, a0
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; RV32I-NEXT:    vadd.vv v8, v10, v8
; RV32I-NEXT:    vsrl.vi v10, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v10
; RV32I-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; RV32I-NEXT:    vmv.v.x v10, a0
; RV32I-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; RV32I-NEXT:    vand.vv v8, v8, v12
; RV32I-NEXT:    vmul.vv v8, v8, v10
; RV32I-NEXT:    li a0, 56
; RV32I-NEXT:    vsrl.vx v8, v8, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_zero_undef_nxv2i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; RV64I-NEXT:    vsrl.vi v10, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    lui a1, 209715
; RV64I-NEXT:    lui a2, 61681
; RV64I-NEXT:    lui a3, 4112
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    addiw a1, a1, 819
; RV64I-NEXT:    addiw a2, a2, -241
; RV64I-NEXT:    addiw a3, a3, 257
; RV64I-NEXT:    slli a4, a0, 32
; RV64I-NEXT:    add a0, a0, a4
; RV64I-NEXT:    slli a4, a1, 32
; RV64I-NEXT:    add a1, a1, a4
; RV64I-NEXT:    slli a4, a2, 32
; RV64I-NEXT:    add a2, a2, a4
; RV64I-NEXT:    slli a4, a3, 32
; RV64I-NEXT:    add a3, a3, a4
; RV64I-NEXT:    li a4, 32
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vi v10, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vi v10, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vi v10, v8, 8
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vi v10, v8, 16
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vx v10, v8, a4
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vsrl.vi v10, v8, 1
; RV64I-NEXT:    vand.vx v10, v10, a0
; RV64I-NEXT:    vsub.vv v8, v8, v10
; RV64I-NEXT:    vand.vx v10, v8, a1
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a1
; RV64I-NEXT:    vadd.vv v8, v10, v8
; RV64I-NEXT:    vsrl.vi v10, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v10
; RV64I-NEXT:    vand.vx v8, v8, a2
; RV64I-NEXT:    vmul.vx v8, v8, a3
; RV64I-NEXT:    li a0, 56
; RV64I-NEXT:    vsrl.vx v8, v8, a0
; RV64I-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_zero_undef_nxv2i64:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    li a0, 190
; CHECK-F-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-F-NEXT:    vmv.v.x v10, a0
; CHECK-F-NEXT:    fsrmi a0, 1
; CHECK-F-NEXT:    vfncvt.f.xu.w v11, v8
; CHECK-F-NEXT:    vsrl.vi v11, v11, 23
; CHECK-F-NEXT:    vwsubu.vv v8, v10, v11
; CHECK-F-NEXT:    fsrm a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_zero_undef_nxv2i64:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    fsrmi a0, 1
; CHECK-D-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; CHECK-D-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-D-NEXT:    li a1, 52
; CHECK-D-NEXT:    vsrl.vx v8, v8, a1
; CHECK-D-NEXT:    li a1, 1086
; CHECK-D-NEXT:    vrsub.vx v8, v8, a1
; CHECK-D-NEXT:    fsrm a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_zero_undef_nxv2i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 2 x i64> @llvm.ctlz.nxv2i64(<vscale x 2 x i64> %va, i1 true)
  ret <vscale x 2 x i64> %a
}

define <vscale x 4 x i64> @ctlz_zero_undef_nxv4i64(<vscale x 4 x i64> %va) {
; RV32I-LABEL: ctlz_zero_undef_nxv4i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; RV32I-NEXT:    vsrl.vi v12, v8, 1
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; RV32I-NEXT:    vmv.v.x v16, a0
; RV32I-NEXT:    li a0, 32
; RV32I-NEXT:    vsetvli a1, zero, e64, m4, ta, ma
; RV32I-NEXT:    vor.vv v8, v8, v12
; RV32I-NEXT:    vsrl.vi v12, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v12
; RV32I-NEXT:    vsrl.vi v12, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v12
; RV32I-NEXT:    vsrl.vi v12, v8, 8
; RV32I-NEXT:    vor.vv v8, v8, v12
; RV32I-NEXT:    vsrl.vi v12, v8, 16
; RV32I-NEXT:    vor.vv v8, v8, v12
; RV32I-NEXT:    vsrl.vx v12, v8, a0
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vor.vv v8, v8, v12
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vsrl.vi v12, v8, 1
; RV32I-NEXT:    vand.vv v12, v12, v16
; RV32I-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; RV32I-NEXT:    vmv.v.x v16, a0
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vsetvli a1, zero, e64, m4, ta, ma
; RV32I-NEXT:    vsub.vv v8, v8, v12
; RV32I-NEXT:    vand.vv v12, v8, v16
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vv v8, v8, v16
; RV32I-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; RV32I-NEXT:    vmv.v.x v16, a0
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    vsetvli a1, zero, e64, m4, ta, ma
; RV32I-NEXT:    vadd.vv v8, v12, v8
; RV32I-NEXT:    vsrl.vi v12, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v12
; RV32I-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; RV32I-NEXT:    vmv.v.x v12, a0
; RV32I-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; RV32I-NEXT:    vand.vv v8, v8, v16
; RV32I-NEXT:    vmul.vv v8, v8, v12
; RV32I-NEXT:    li a0, 56
; RV32I-NEXT:    vsrl.vx v8, v8, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_zero_undef_nxv4i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; RV64I-NEXT:    vsrl.vi v12, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    lui a1, 209715
; RV64I-NEXT:    lui a2, 61681
; RV64I-NEXT:    lui a3, 4112
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    addiw a1, a1, 819
; RV64I-NEXT:    addiw a2, a2, -241
; RV64I-NEXT:    addiw a3, a3, 257
; RV64I-NEXT:    slli a4, a0, 32
; RV64I-NEXT:    add a0, a0, a4
; RV64I-NEXT:    slli a4, a1, 32
; RV64I-NEXT:    add a1, a1, a4
; RV64I-NEXT:    slli a4, a2, 32
; RV64I-NEXT:    add a2, a2, a4
; RV64I-NEXT:    slli a4, a3, 32
; RV64I-NEXT:    add a3, a3, a4
; RV64I-NEXT:    li a4, 32
; RV64I-NEXT:    vor.vv v8, v8, v12
; RV64I-NEXT:    vsrl.vi v12, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v12
; RV64I-NEXT:    vsrl.vi v12, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v12
; RV64I-NEXT:    vsrl.vi v12, v8, 8
; RV64I-NEXT:    vor.vv v8, v8, v12
; RV64I-NEXT:    vsrl.vi v12, v8, 16
; RV64I-NEXT:    vor.vv v8, v8, v12
; RV64I-NEXT:    vsrl.vx v12, v8, a4
; RV64I-NEXT:    vor.vv v8, v8, v12
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vsrl.vi v12, v8, 1
; RV64I-NEXT:    vand.vx v12, v12, a0
; RV64I-NEXT:    vsub.vv v8, v8, v12
; RV64I-NEXT:    vand.vx v12, v8, a1
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a1
; RV64I-NEXT:    vadd.vv v8, v12, v8
; RV64I-NEXT:    vsrl.vi v12, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v12
; RV64I-NEXT:    vand.vx v8, v8, a2
; RV64I-NEXT:    vmul.vx v8, v8, a3
; RV64I-NEXT:    li a0, 56
; RV64I-NEXT:    vsrl.vx v8, v8, a0
; RV64I-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_zero_undef_nxv4i64:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    li a0, 190
; CHECK-F-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; CHECK-F-NEXT:    vmv.v.x v12, a0
; CHECK-F-NEXT:    fsrmi a0, 1
; CHECK-F-NEXT:    vfncvt.f.xu.w v14, v8
; CHECK-F-NEXT:    vsrl.vi v14, v14, 23
; CHECK-F-NEXT:    vwsubu.vv v8, v12, v14
; CHECK-F-NEXT:    fsrm a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_zero_undef_nxv4i64:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    fsrmi a0, 1
; CHECK-D-NEXT:    vsetvli a1, zero, e64, m4, ta, ma
; CHECK-D-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-D-NEXT:    li a1, 52
; CHECK-D-NEXT:    vsrl.vx v8, v8, a1
; CHECK-D-NEXT:    li a1, 1086
; CHECK-D-NEXT:    vrsub.vx v8, v8, a1
; CHECK-D-NEXT:    fsrm a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_zero_undef_nxv4i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 4 x i64> @llvm.ctlz.nxv4i64(<vscale x 4 x i64> %va, i1 true)
  ret <vscale x 4 x i64> %a
}

define <vscale x 8 x i64> @ctlz_zero_undef_nxv8i64(<vscale x 8 x i64> %va) {
; RV32I-LABEL: ctlz_zero_undef_nxv8i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; RV32I-NEXT:    vsrl.vi v16, v8, 1
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vsetvli a1, zero, e32, m8, ta, ma
; RV32I-NEXT:    vmv.v.x v24, a0
; RV32I-NEXT:    li a0, 32
; RV32I-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32I-NEXT:    vor.vv v8, v8, v16
; RV32I-NEXT:    vsrl.vi v16, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v16
; RV32I-NEXT:    vsrl.vi v16, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v16
; RV32I-NEXT:    vsrl.vi v16, v8, 8
; RV32I-NEXT:    vor.vv v8, v8, v16
; RV32I-NEXT:    vsrl.vi v16, v8, 16
; RV32I-NEXT:    vor.vv v8, v8, v16
; RV32I-NEXT:    vsrl.vx v16, v8, a0
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vor.vv v8, v8, v16
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vsrl.vi v16, v8, 1
; RV32I-NEXT:    vand.vv v24, v16, v24
; RV32I-NEXT:    vsetvli a1, zero, e32, m8, ta, ma
; RV32I-NEXT:    vmv.v.x v16, a0
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32I-NEXT:    vsub.vv v8, v8, v24
; RV32I-NEXT:    vand.vv v24, v8, v16
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vv v8, v8, v16
; RV32I-NEXT:    vsetvli a1, zero, e32, m8, ta, ma
; RV32I-NEXT:    vmv.v.x v16, a0
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32I-NEXT:    vadd.vv v8, v24, v8
; RV32I-NEXT:    vsrl.vi v24, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v24
; RV32I-NEXT:    vsetvli a1, zero, e32, m8, ta, ma
; RV32I-NEXT:    vmv.v.x v24, a0
; RV32I-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; RV32I-NEXT:    vand.vv v8, v8, v16
; RV32I-NEXT:    vmul.vv v8, v8, v24
; RV32I-NEXT:    li a0, 56
; RV32I-NEXT:    vsrl.vx v8, v8, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_zero_undef_nxv8i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; RV64I-NEXT:    vsrl.vi v16, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    lui a1, 209715
; RV64I-NEXT:    lui a2, 61681
; RV64I-NEXT:    lui a3, 4112
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    addiw a1, a1, 819
; RV64I-NEXT:    addiw a2, a2, -241
; RV64I-NEXT:    addiw a3, a3, 257
; RV64I-NEXT:    slli a4, a0, 32
; RV64I-NEXT:    add a0, a0, a4
; RV64I-NEXT:    slli a4, a1, 32
; RV64I-NEXT:    add a1, a1, a4
; RV64I-NEXT:    slli a4, a2, 32
; RV64I-NEXT:    add a2, a2, a4
; RV64I-NEXT:    slli a4, a3, 32
; RV64I-NEXT:    add a3, a3, a4
; RV64I-NEXT:    li a4, 32
; RV64I-NEXT:    vor.vv v8, v8, v16
; RV64I-NEXT:    vsrl.vi v16, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v16
; RV64I-NEXT:    vsrl.vi v16, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v16
; RV64I-NEXT:    vsrl.vi v16, v8, 8
; RV64I-NEXT:    vor.vv v8, v8, v16
; RV64I-NEXT:    vsrl.vi v16, v8, 16
; RV64I-NEXT:    vor.vv v8, v8, v16
; RV64I-NEXT:    vsrl.vx v16, v8, a4
; RV64I-NEXT:    vor.vv v8, v8, v16
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vsrl.vi v16, v8, 1
; RV64I-NEXT:    vand.vx v16, v16, a0
; RV64I-NEXT:    vsub.vv v8, v8, v16
; RV64I-NEXT:    vand.vx v16, v8, a1
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a1
; RV64I-NEXT:    vadd.vv v8, v16, v8
; RV64I-NEXT:    vsrl.vi v16, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v16
; RV64I-NEXT:    vand.vx v8, v8, a2
; RV64I-NEXT:    vmul.vx v8, v8, a3
; RV64I-NEXT:    li a0, 56
; RV64I-NEXT:    vsrl.vx v8, v8, a0
; RV64I-NEXT:    ret
;
; CHECK-F-LABEL: ctlz_zero_undef_nxv8i64:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    li a0, 190
; CHECK-F-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-F-NEXT:    vmv.v.x v16, a0
; CHECK-F-NEXT:    fsrmi a0, 1
; CHECK-F-NEXT:    vfncvt.f.xu.w v20, v8
; CHECK-F-NEXT:    vsrl.vi v20, v20, 23
; CHECK-F-NEXT:    vwsubu.vv v8, v16, v20
; CHECK-F-NEXT:    fsrm a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: ctlz_zero_undef_nxv8i64:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    fsrmi a0, 1
; CHECK-D-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; CHECK-D-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-D-NEXT:    li a1, 52
; CHECK-D-NEXT:    vsrl.vx v8, v8, a1
; CHECK-D-NEXT:    li a1, 1086
; CHECK-D-NEXT:    vrsub.vx v8, v8, a1
; CHECK-D-NEXT:    fsrm a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctlz_zero_undef_nxv8i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-ZVBB-NEXT:    vclz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 8 x i64> @llvm.ctlz.nxv8i64(<vscale x 8 x i64> %va, i1 true)
  ret <vscale x 8 x i64> %a
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; RV32: {{.*}}
; RV32F: {{.*}}
; RV64: {{.*}}
; RV64F: {{.*}}
