; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc < %s -mtriple=i686-- | FileCheck %s --check-prefixes=X86,X86-GENERIC
; RUN: llc < %s -mtriple=x86_64-- | FileCheck %s --check-prefixes=X64,X64-GENERIC
; RUN: llc < %s -mtriple=i686-- -mattr=+fast-imm16 | FileCheck %s --check-prefixes=X86,X86-FAST
; RUN: llc < %s -mtriple=x86_64-- -mattr=+fast-imm16 | FileCheck %s --check-prefixes=X64,X64-FAST
; RUN: llc < %s -mtriple=i686-- -mcpu=atom | FileCheck %s --check-prefixes=X86,X86-ATOM
; RUN: llc < %s -mtriple=x86_64-- -mcpu=atom | FileCheck %s --check-prefixes=X64,X64-ATOM
; RUN: llc < %s -mtriple=x86_64-- -mcpu=slm | FileCheck %s --check-prefixes=X64,X64-FAST
; RUN: llc < %s -mtriple=x86_64-- -mcpu=knl | FileCheck %s --check-prefixes=X64,X64-FAST
; RUN: llc < %s -mtriple=x86_64-- -mcpu=btver1 | FileCheck %s --check-prefixes=X64,X64-FAST
; RUN: llc < %s -mtriple=x86_64-- -mcpu=btver2 | FileCheck %s --check-prefixes=X64,X64-FAST
; RUN: llc < %s -mtriple=x86_64-- -mcpu=znver1 | FileCheck %s --check-prefixes=X64,X64-FAST
; RUN: llc < %s -mtriple=x86_64-- -mcpu=znver2 | FileCheck %s --check-prefixes=X64,X64-FAST
; RUN: llc < %s -mtriple=x86_64-- -mcpu=znver3 | FileCheck %s --check-prefixes=X64,X64-FAST
; RUN: llc < %s -mtriple=x86_64-- -mcpu=znver4 | FileCheck %s --check-prefixes=X64,X64-FAST
; RUN: llc < %s -mtriple=x86_64-- -mcpu=znver5 | FileCheck %s --check-prefixes=X64,X64-FAST

define i1 @cmp16_reg_eq_reg(i16 %a0, i16 %a1) {
; X86-GENERIC-LABEL: cmp16_reg_eq_reg:
; X86-GENERIC:       # %bb.0:
; X86-GENERIC-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-GENERIC-NEXT:    cmpw {{[0-9]+}}(%esp), %ax
; X86-GENERIC-NEXT:    sete %al
; X86-GENERIC-NEXT:    retl
;
; X64-GENERIC-LABEL: cmp16_reg_eq_reg:
; X64-GENERIC:       # %bb.0:
; X64-GENERIC-NEXT:    cmpw %si, %di
; X64-GENERIC-NEXT:    sete %al
; X64-GENERIC-NEXT:    retq
;
; X86-FAST-LABEL: cmp16_reg_eq_reg:
; X86-FAST:       # %bb.0:
; X86-FAST-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-FAST-NEXT:    cmpw {{[0-9]+}}(%esp), %ax
; X86-FAST-NEXT:    sete %al
; X86-FAST-NEXT:    retl
;
; X64-FAST-LABEL: cmp16_reg_eq_reg:
; X64-FAST:       # %bb.0:
; X64-FAST-NEXT:    cmpw %si, %di
; X64-FAST-NEXT:    sete %al
; X64-FAST-NEXT:    retq
;
; X86-ATOM-LABEL: cmp16_reg_eq_reg:
; X86-ATOM:       # %bb.0:
; X86-ATOM-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-ATOM-NEXT:    cmpw {{[0-9]+}}(%esp), %ax
; X86-ATOM-NEXT:    sete %al
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    retl
;
; X64-ATOM-LABEL: cmp16_reg_eq_reg:
; X64-ATOM:       # %bb.0:
; X64-ATOM-NEXT:    cmpw %si, %di
; X64-ATOM-NEXT:    sete %al
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    retq
  %cmp = icmp eq i16 %a0, %a1
  ret i1 %cmp
}
define i1 @cmp16_reg_eq_imm8(i16 %a0) {
; X86-GENERIC-LABEL: cmp16_reg_eq_imm8:
; X86-GENERIC:       # %bb.0:
; X86-GENERIC-NEXT:    cmpw $15, {{[0-9]+}}(%esp)
; X86-GENERIC-NEXT:    sete %al
; X86-GENERIC-NEXT:    retl
;
; X64-GENERIC-LABEL: cmp16_reg_eq_imm8:
; X64-GENERIC:       # %bb.0:
; X64-GENERIC-NEXT:    cmpw $15, %di
; X64-GENERIC-NEXT:    sete %al
; X64-GENERIC-NEXT:    retq
;
; X86-FAST-LABEL: cmp16_reg_eq_imm8:
; X86-FAST:       # %bb.0:
; X86-FAST-NEXT:    cmpw $15, {{[0-9]+}}(%esp)
; X86-FAST-NEXT:    sete %al
; X86-FAST-NEXT:    retl
;
; X64-FAST-LABEL: cmp16_reg_eq_imm8:
; X64-FAST:       # %bb.0:
; X64-FAST-NEXT:    cmpw $15, %di
; X64-FAST-NEXT:    sete %al
; X64-FAST-NEXT:    retq
;
; X86-ATOM-LABEL: cmp16_reg_eq_imm8:
; X86-ATOM:       # %bb.0:
; X86-ATOM-NEXT:    cmpw $15, {{[0-9]+}}(%esp)
; X86-ATOM-NEXT:    sete %al
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    retl
;
; X64-ATOM-LABEL: cmp16_reg_eq_imm8:
; X64-ATOM:       # %bb.0:
; X64-ATOM-NEXT:    cmpw $15, %di
; X64-ATOM-NEXT:    sete %al
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    retq
  %cmp = icmp eq i16 %a0, 15
  ret i1 %cmp
}

define i1 @cmp16_reg_eq_imm16(i16 %a0) {
; X86-GENERIC-LABEL: cmp16_reg_eq_imm16:
; X86-GENERIC:       # %bb.0:
; X86-GENERIC-NEXT:    cmpw $1024, {{[0-9]+}}(%esp) # imm = 0x400
; X86-GENERIC-NEXT:    sete %al
; X86-GENERIC-NEXT:    retl
;
; X64-GENERIC-LABEL: cmp16_reg_eq_imm16:
; X64-GENERIC:       # %bb.0:
; X64-GENERIC-NEXT:    movzwl %di, %eax
; X64-GENERIC-NEXT:    cmpl $1024, %eax # imm = 0x400
; X64-GENERIC-NEXT:    sete %al
; X64-GENERIC-NEXT:    retq
;
; X86-FAST-LABEL: cmp16_reg_eq_imm16:
; X86-FAST:       # %bb.0:
; X86-FAST-NEXT:    cmpw $1024, {{[0-9]+}}(%esp) # imm = 0x400
; X86-FAST-NEXT:    sete %al
; X86-FAST-NEXT:    retl
;
; X64-FAST-LABEL: cmp16_reg_eq_imm16:
; X64-FAST:       # %bb.0:
; X64-FAST-NEXT:    cmpw $1024, %di # imm = 0x400
; X64-FAST-NEXT:    sete %al
; X64-FAST-NEXT:    retq
;
; X86-ATOM-LABEL: cmp16_reg_eq_imm16:
; X86-ATOM:       # %bb.0:
; X86-ATOM-NEXT:    cmpw $1024, {{[0-9]+}}(%esp) # imm = 0x400
; X86-ATOM-NEXT:    sete %al
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    retl
;
; X64-ATOM-LABEL: cmp16_reg_eq_imm16:
; X64-ATOM:       # %bb.0:
; X64-ATOM-NEXT:    cmpw $1024, %di # imm = 0x400
; X64-ATOM-NEXT:    sete %al
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    retq
  %cmp = icmp eq i16 %a0, 1024
  ret i1 %cmp
}

define i1 @cmp16_reg_eq_imm16_minsize(i16 %a0) minsize {
; X86-LABEL: cmp16_reg_eq_imm16_minsize:
; X86:       # %bb.0:
; X86-NEXT:    cmpw $1024, {{[0-9]+}}(%esp) # imm = 0x400
; X86-NEXT:    sete %al
; X86-NEXT:    retl
;
; X64-LABEL: cmp16_reg_eq_imm16_minsize:
; X64:       # %bb.0:
; X64-NEXT:    cmpw $1024, %di # imm = 0x400
; X64-NEXT:    sete %al
; X64-NEXT:    retq
  %cmp = icmp eq i16 %a0, 1024
  ret i1 %cmp
}

define i1 @cmp16_reg_eq_imm16_optsize(i16 %a0) optsize {
; X86-LABEL: cmp16_reg_eq_imm16_optsize:
; X86:       # %bb.0:
; X86-NEXT:    cmpw $1024, {{[0-9]+}}(%esp) # imm = 0x400
; X86-NEXT:    sete %al
; X86-NEXT:    retl
;
; X64-GENERIC-LABEL: cmp16_reg_eq_imm16_optsize:
; X64-GENERIC:       # %bb.0:
; X64-GENERIC-NEXT:    movzwl %di, %eax
; X64-GENERIC-NEXT:    cmpl $1024, %eax # imm = 0x400
; X64-GENERIC-NEXT:    sete %al
; X64-GENERIC-NEXT:    retq
;
; X64-FAST-LABEL: cmp16_reg_eq_imm16_optsize:
; X64-FAST:       # %bb.0:
; X64-FAST-NEXT:    cmpw $1024, %di # imm = 0x400
; X64-FAST-NEXT:    sete %al
; X64-FAST-NEXT:    retq
;
; X64-ATOM-LABEL: cmp16_reg_eq_imm16_optsize:
; X64-ATOM:       # %bb.0:
; X64-ATOM-NEXT:    cmpw $1024, %di # imm = 0x400
; X64-ATOM-NEXT:    sete %al
; X64-ATOM-NEXT:    retq
  %cmp = icmp eq i16 %a0, 1024
  ret i1 %cmp
}

define i1 @cmp16_reg_sgt_imm8(i16 %a0) {
; X86-GENERIC-LABEL: cmp16_reg_sgt_imm8:
; X86-GENERIC:       # %bb.0:
; X86-GENERIC-NEXT:    cmpw $16, {{[0-9]+}}(%esp)
; X86-GENERIC-NEXT:    setge %al
; X86-GENERIC-NEXT:    retl
;
; X64-GENERIC-LABEL: cmp16_reg_sgt_imm8:
; X64-GENERIC:       # %bb.0:
; X64-GENERIC-NEXT:    cmpw $16, %di
; X64-GENERIC-NEXT:    setge %al
; X64-GENERIC-NEXT:    retq
;
; X86-FAST-LABEL: cmp16_reg_sgt_imm8:
; X86-FAST:       # %bb.0:
; X86-FAST-NEXT:    cmpw $16, {{[0-9]+}}(%esp)
; X86-FAST-NEXT:    setge %al
; X86-FAST-NEXT:    retl
;
; X64-FAST-LABEL: cmp16_reg_sgt_imm8:
; X64-FAST:       # %bb.0:
; X64-FAST-NEXT:    cmpw $16, %di
; X64-FAST-NEXT:    setge %al
; X64-FAST-NEXT:    retq
;
; X86-ATOM-LABEL: cmp16_reg_sgt_imm8:
; X86-ATOM:       # %bb.0:
; X86-ATOM-NEXT:    cmpw $16, {{[0-9]+}}(%esp)
; X86-ATOM-NEXT:    setge %al
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    retl
;
; X64-ATOM-LABEL: cmp16_reg_sgt_imm8:
; X64-ATOM:       # %bb.0:
; X64-ATOM-NEXT:    cmpw $16, %di
; X64-ATOM-NEXT:    setge %al
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    retq
  %cmp = icmp sgt i16 %a0, 15
  ret i1 %cmp
}

define i1 @cmp16_reg_sgt_imm16(i16 %a0) {
; X86-GENERIC-LABEL: cmp16_reg_sgt_imm16:
; X86-GENERIC:       # %bb.0:
; X86-GENERIC-NEXT:    cmpw $-1023, {{[0-9]+}}(%esp) # imm = 0xFC01
; X86-GENERIC-NEXT:    setge %al
; X86-GENERIC-NEXT:    retl
;
; X64-GENERIC-LABEL: cmp16_reg_sgt_imm16:
; X64-GENERIC:       # %bb.0:
; X64-GENERIC-NEXT:    movswl %di, %eax
; X64-GENERIC-NEXT:    cmpl $-1023, %eax # imm = 0xFC01
; X64-GENERIC-NEXT:    setge %al
; X64-GENERIC-NEXT:    retq
;
; X86-FAST-LABEL: cmp16_reg_sgt_imm16:
; X86-FAST:       # %bb.0:
; X86-FAST-NEXT:    cmpw $-1023, {{[0-9]+}}(%esp) # imm = 0xFC01
; X86-FAST-NEXT:    setge %al
; X86-FAST-NEXT:    retl
;
; X64-FAST-LABEL: cmp16_reg_sgt_imm16:
; X64-FAST:       # %bb.0:
; X64-FAST-NEXT:    cmpw $-1023, %di # imm = 0xFC01
; X64-FAST-NEXT:    setge %al
; X64-FAST-NEXT:    retq
;
; X86-ATOM-LABEL: cmp16_reg_sgt_imm16:
; X86-ATOM:       # %bb.0:
; X86-ATOM-NEXT:    cmpw $-1023, {{[0-9]+}}(%esp) # imm = 0xFC01
; X86-ATOM-NEXT:    setge %al
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    retl
;
; X64-ATOM-LABEL: cmp16_reg_sgt_imm16:
; X64-ATOM:       # %bb.0:
; X64-ATOM-NEXT:    cmpw $-1023, %di # imm = 0xFC01
; X64-ATOM-NEXT:    setge %al
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    retq
  %cmp = icmp sgt i16 %a0, -1024
  ret i1 %cmp
}

define i1 @cmp16_reg_sgt_imm16_minsize(i16 %a0) minsize {
; X86-LABEL: cmp16_reg_sgt_imm16_minsize:
; X86:       # %bb.0:
; X86-NEXT:    cmpw $-1023, {{[0-9]+}}(%esp) # imm = 0xFC01
; X86-NEXT:    setge %al
; X86-NEXT:    retl
;
; X64-LABEL: cmp16_reg_sgt_imm16_minsize:
; X64:       # %bb.0:
; X64-NEXT:    cmpw $-1023, %di # imm = 0xFC01
; X64-NEXT:    setge %al
; X64-NEXT:    retq
  %cmp = icmp sgt i16 %a0, -1024
  ret i1 %cmp
}

define i1 @cmp16_reg_sgt_imm16_optsize(i16 %a0) optsize {
; X86-LABEL: cmp16_reg_sgt_imm16_optsize:
; X86:       # %bb.0:
; X86-NEXT:    cmpw $-1023, {{[0-9]+}}(%esp) # imm = 0xFC01
; X86-NEXT:    setge %al
; X86-NEXT:    retl
;
; X64-GENERIC-LABEL: cmp16_reg_sgt_imm16_optsize:
; X64-GENERIC:       # %bb.0:
; X64-GENERIC-NEXT:    movswl %di, %eax
; X64-GENERIC-NEXT:    cmpl $-1023, %eax # imm = 0xFC01
; X64-GENERIC-NEXT:    setge %al
; X64-GENERIC-NEXT:    retq
;
; X64-FAST-LABEL: cmp16_reg_sgt_imm16_optsize:
; X64-FAST:       # %bb.0:
; X64-FAST-NEXT:    cmpw $-1023, %di # imm = 0xFC01
; X64-FAST-NEXT:    setge %al
; X64-FAST-NEXT:    retq
;
; X64-ATOM-LABEL: cmp16_reg_sgt_imm16_optsize:
; X64-ATOM:       # %bb.0:
; X64-ATOM-NEXT:    cmpw $-1023, %di # imm = 0xFC01
; X64-ATOM-NEXT:    setge %al
; X64-ATOM-NEXT:    retq
  %cmp = icmp sgt i16 %a0, -1024
  ret i1 %cmp
}

define i1 @cmp16_reg_uge_imm16(i16 %a0) {
; X86-GENERIC-LABEL: cmp16_reg_uge_imm16:
; X86-GENERIC:       # %bb.0:
; X86-GENERIC-NEXT:    cmpw $-1024, {{[0-9]+}}(%esp) # imm = 0xFC00
; X86-GENERIC-NEXT:    setae %al
; X86-GENERIC-NEXT:    retl
;
; X64-GENERIC-LABEL: cmp16_reg_uge_imm16:
; X64-GENERIC:       # %bb.0:
; X64-GENERIC-NEXT:    movzwl %di, %eax
; X64-GENERIC-NEXT:    cmpl $64512, %eax # imm = 0xFC00
; X64-GENERIC-NEXT:    setae %al
; X64-GENERIC-NEXT:    retq
;
; X86-FAST-LABEL: cmp16_reg_uge_imm16:
; X86-FAST:       # %bb.0:
; X86-FAST-NEXT:    cmpw $-1024, {{[0-9]+}}(%esp) # imm = 0xFC00
; X86-FAST-NEXT:    setae %al
; X86-FAST-NEXT:    retl
;
; X64-FAST-LABEL: cmp16_reg_uge_imm16:
; X64-FAST:       # %bb.0:
; X64-FAST-NEXT:    cmpw $-1024, %di # imm = 0xFC00
; X64-FAST-NEXT:    setae %al
; X64-FAST-NEXT:    retq
;
; X86-ATOM-LABEL: cmp16_reg_uge_imm16:
; X86-ATOM:       # %bb.0:
; X86-ATOM-NEXT:    cmpw $-1024, {{[0-9]+}}(%esp) # imm = 0xFC00
; X86-ATOM-NEXT:    setae %al
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    retl
;
; X64-ATOM-LABEL: cmp16_reg_uge_imm16:
; X64-ATOM:       # %bb.0:
; X64-ATOM-NEXT:    cmpw $-1024, %di # imm = 0xFC00
; X64-ATOM-NEXT:    setae %al
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    retq
  %cmp = icmp uge i16 %a0, -1024
  ret i1 %cmp
}

define i1 @cmp16_reg_uge_imm16_minsize(i16 %a0) minsize {
; X86-LABEL: cmp16_reg_uge_imm16_minsize:
; X86:       # %bb.0:
; X86-NEXT:    cmpw $-1024, {{[0-9]+}}(%esp) # imm = 0xFC00
; X86-NEXT:    setae %al
; X86-NEXT:    retl
;
; X64-LABEL: cmp16_reg_uge_imm16_minsize:
; X64:       # %bb.0:
; X64-NEXT:    cmpw $-1024, %di # imm = 0xFC00
; X64-NEXT:    setae %al
; X64-NEXT:    retq
  %cmp = icmp uge i16 %a0, -1024
  ret i1 %cmp
}

define i1 @cmp16_reg_uge_imm16_optsize(i16 %a0) optsize {
; X86-LABEL: cmp16_reg_uge_imm16_optsize:
; X86:       # %bb.0:
; X86-NEXT:    cmpw $-1024, {{[0-9]+}}(%esp) # imm = 0xFC00
; X86-NEXT:    setae %al
; X86-NEXT:    retl
;
; X64-GENERIC-LABEL: cmp16_reg_uge_imm16_optsize:
; X64-GENERIC:       # %bb.0:
; X64-GENERIC-NEXT:    movzwl %di, %eax
; X64-GENERIC-NEXT:    cmpl $64512, %eax # imm = 0xFC00
; X64-GENERIC-NEXT:    setae %al
; X64-GENERIC-NEXT:    retq
;
; X64-FAST-LABEL: cmp16_reg_uge_imm16_optsize:
; X64-FAST:       # %bb.0:
; X64-FAST-NEXT:    cmpw $-1024, %di # imm = 0xFC00
; X64-FAST-NEXT:    setae %al
; X64-FAST-NEXT:    retq
;
; X64-ATOM-LABEL: cmp16_reg_uge_imm16_optsize:
; X64-ATOM:       # %bb.0:
; X64-ATOM-NEXT:    cmpw $-1024, %di # imm = 0xFC00
; X64-ATOM-NEXT:    setae %al
; X64-ATOM-NEXT:    retq
  %cmp = icmp uge i16 %a0, -1024
  ret i1 %cmp
}

define i1 @cmp16_load_ne_load(ptr %p0, ptr %p1) {
; X86-GENERIC-LABEL: cmp16_load_ne_load:
; X86-GENERIC:       # %bb.0:
; X86-GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-GENERIC-NEXT:    movzwl (%ecx), %ecx
; X86-GENERIC-NEXT:    cmpw (%eax), %cx
; X86-GENERIC-NEXT:    setne %al
; X86-GENERIC-NEXT:    retl
;
; X64-GENERIC-LABEL: cmp16_load_ne_load:
; X64-GENERIC:       # %bb.0:
; X64-GENERIC-NEXT:    movzwl (%rdi), %eax
; X64-GENERIC-NEXT:    cmpw (%rsi), %ax
; X64-GENERIC-NEXT:    setne %al
; X64-GENERIC-NEXT:    retq
;
; X86-FAST-LABEL: cmp16_load_ne_load:
; X86-FAST:       # %bb.0:
; X86-FAST-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-FAST-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-FAST-NEXT:    movzwl (%ecx), %ecx
; X86-FAST-NEXT:    cmpw (%eax), %cx
; X86-FAST-NEXT:    setne %al
; X86-FAST-NEXT:    retl
;
; X64-FAST-LABEL: cmp16_load_ne_load:
; X64-FAST:       # %bb.0:
; X64-FAST-NEXT:    movzwl (%rdi), %eax
; X64-FAST-NEXT:    cmpw (%rsi), %ax
; X64-FAST-NEXT:    setne %al
; X64-FAST-NEXT:    retq
;
; X86-ATOM-LABEL: cmp16_load_ne_load:
; X86-ATOM:       # %bb.0:
; X86-ATOM-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-ATOM-NEXT:    movzwl (%ecx), %ecx
; X86-ATOM-NEXT:    cmpw (%eax), %cx
; X86-ATOM-NEXT:    setne %al
; X86-ATOM-NEXT:    retl
;
; X64-ATOM-LABEL: cmp16_load_ne_load:
; X64-ATOM:       # %bb.0:
; X64-ATOM-NEXT:    movzwl (%rdi), %eax
; X64-ATOM-NEXT:    cmpw (%rsi), %ax
; X64-ATOM-NEXT:    setne %al
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    retq
  %ld0 = load i16, ptr %p0
  %ld1 = load i16, ptr %p1
  %cmp = icmp ne i16 %ld0, %ld1
  ret i1 %cmp
}

define i1 @cmp16_load_ne_imm8(ptr %p0) {
; X86-GENERIC-LABEL: cmp16_load_ne_imm8:
; X86-GENERIC:       # %bb.0:
; X86-GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-GENERIC-NEXT:    cmpw $15, (%eax)
; X86-GENERIC-NEXT:    setne %al
; X86-GENERIC-NEXT:    retl
;
; X64-GENERIC-LABEL: cmp16_load_ne_imm8:
; X64-GENERIC:       # %bb.0:
; X64-GENERIC-NEXT:    cmpw $15, (%rdi)
; X64-GENERIC-NEXT:    setne %al
; X64-GENERIC-NEXT:    retq
;
; X86-FAST-LABEL: cmp16_load_ne_imm8:
; X86-FAST:       # %bb.0:
; X86-FAST-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-FAST-NEXT:    cmpw $15, (%eax)
; X86-FAST-NEXT:    setne %al
; X86-FAST-NEXT:    retl
;
; X64-FAST-LABEL: cmp16_load_ne_imm8:
; X64-FAST:       # %bb.0:
; X64-FAST-NEXT:    cmpw $15, (%rdi)
; X64-FAST-NEXT:    setne %al
; X64-FAST-NEXT:    retq
;
; X86-ATOM-LABEL: cmp16_load_ne_imm8:
; X86-ATOM:       # %bb.0:
; X86-ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-ATOM-NEXT:    cmpw $15, (%eax)
; X86-ATOM-NEXT:    setne %al
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    retl
;
; X64-ATOM-LABEL: cmp16_load_ne_imm8:
; X64-ATOM:       # %bb.0:
; X64-ATOM-NEXT:    cmpw $15, (%rdi)
; X64-ATOM-NEXT:    setne %al
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    retq
  %ld = load i16, ptr %p0
  %cmp = icmp ne i16 %ld, 15
  ret i1 %cmp
}

define i1 @cmp16_load_ne_imm16(ptr %p0) {
; X86-GENERIC-LABEL: cmp16_load_ne_imm16:
; X86-GENERIC:       # %bb.0:
; X86-GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-GENERIC-NEXT:    cmpw $512, (%eax) # imm = 0x200
; X86-GENERIC-NEXT:    setne %al
; X86-GENERIC-NEXT:    retl
;
; X64-GENERIC-LABEL: cmp16_load_ne_imm16:
; X64-GENERIC:       # %bb.0:
; X64-GENERIC-NEXT:    cmpw $512, (%rdi) # imm = 0x200
; X64-GENERIC-NEXT:    setne %al
; X64-GENERIC-NEXT:    retq
;
; X86-FAST-LABEL: cmp16_load_ne_imm16:
; X86-FAST:       # %bb.0:
; X86-FAST-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-FAST-NEXT:    cmpw $512, (%eax) # imm = 0x200
; X86-FAST-NEXT:    setne %al
; X86-FAST-NEXT:    retl
;
; X64-FAST-LABEL: cmp16_load_ne_imm16:
; X64-FAST:       # %bb.0:
; X64-FAST-NEXT:    cmpw $512, (%rdi) # imm = 0x200
; X64-FAST-NEXT:    setne %al
; X64-FAST-NEXT:    retq
;
; X86-ATOM-LABEL: cmp16_load_ne_imm16:
; X86-ATOM:       # %bb.0:
; X86-ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-ATOM-NEXT:    cmpw $512, (%eax) # imm = 0x200
; X86-ATOM-NEXT:    setne %al
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    retl
;
; X64-ATOM-LABEL: cmp16_load_ne_imm16:
; X64-ATOM:       # %bb.0:
; X64-ATOM-NEXT:    cmpw $512, (%rdi) # imm = 0x200
; X64-ATOM-NEXT:    setne %al
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    retq
  %ld = load i16, ptr %p0
  %cmp = icmp ne i16 %ld, 512
  ret i1 %cmp
}

define i1 @cmp16_load_slt_imm8(ptr %p0) {
; X86-GENERIC-LABEL: cmp16_load_slt_imm8:
; X86-GENERIC:       # %bb.0:
; X86-GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-GENERIC-NEXT:    cmpw $15, (%eax)
; X86-GENERIC-NEXT:    setl %al
; X86-GENERIC-NEXT:    retl
;
; X64-GENERIC-LABEL: cmp16_load_slt_imm8:
; X64-GENERIC:       # %bb.0:
; X64-GENERIC-NEXT:    cmpw $15, (%rdi)
; X64-GENERIC-NEXT:    setl %al
; X64-GENERIC-NEXT:    retq
;
; X86-FAST-LABEL: cmp16_load_slt_imm8:
; X86-FAST:       # %bb.0:
; X86-FAST-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-FAST-NEXT:    cmpw $15, (%eax)
; X86-FAST-NEXT:    setl %al
; X86-FAST-NEXT:    retl
;
; X64-FAST-LABEL: cmp16_load_slt_imm8:
; X64-FAST:       # %bb.0:
; X64-FAST-NEXT:    cmpw $15, (%rdi)
; X64-FAST-NEXT:    setl %al
; X64-FAST-NEXT:    retq
;
; X86-ATOM-LABEL: cmp16_load_slt_imm8:
; X86-ATOM:       # %bb.0:
; X86-ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-ATOM-NEXT:    cmpw $15, (%eax)
; X86-ATOM-NEXT:    setl %al
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    retl
;
; X64-ATOM-LABEL: cmp16_load_slt_imm8:
; X64-ATOM:       # %bb.0:
; X64-ATOM-NEXT:    cmpw $15, (%rdi)
; X64-ATOM-NEXT:    setl %al
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    retq
  %ld = load i16, ptr %p0
  %cmp = icmp slt i16 %ld, 15
  ret i1 %cmp
}

define i1 @cmp16_load_slt_imm16(ptr %p0) {
; X86-GENERIC-LABEL: cmp16_load_slt_imm16:
; X86-GENERIC:       # %bb.0:
; X86-GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-GENERIC-NEXT:    cmpw $512, (%eax) # imm = 0x200
; X86-GENERIC-NEXT:    setl %al
; X86-GENERIC-NEXT:    retl
;
; X64-GENERIC-LABEL: cmp16_load_slt_imm16:
; X64-GENERIC:       # %bb.0:
; X64-GENERIC-NEXT:    cmpw $512, (%rdi) # imm = 0x200
; X64-GENERIC-NEXT:    setl %al
; X64-GENERIC-NEXT:    retq
;
; X86-FAST-LABEL: cmp16_load_slt_imm16:
; X86-FAST:       # %bb.0:
; X86-FAST-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-FAST-NEXT:    cmpw $512, (%eax) # imm = 0x200
; X86-FAST-NEXT:    setl %al
; X86-FAST-NEXT:    retl
;
; X64-FAST-LABEL: cmp16_load_slt_imm16:
; X64-FAST:       # %bb.0:
; X64-FAST-NEXT:    cmpw $512, (%rdi) # imm = 0x200
; X64-FAST-NEXT:    setl %al
; X64-FAST-NEXT:    retq
;
; X86-ATOM-LABEL: cmp16_load_slt_imm16:
; X86-ATOM:       # %bb.0:
; X86-ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-ATOM-NEXT:    cmpw $512, (%eax) # imm = 0x200
; X86-ATOM-NEXT:    setl %al
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    retl
;
; X64-ATOM-LABEL: cmp16_load_slt_imm16:
; X64-ATOM:       # %bb.0:
; X64-ATOM-NEXT:    cmpw $512, (%rdi) # imm = 0x200
; X64-ATOM-NEXT:    setl %al
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    retq
  %ld = load i16, ptr %p0
  %cmp = icmp slt i16 %ld, 512
  ret i1 %cmp
}

define i1 @cmp16_load_slt_imm16_minsize(ptr %p0) minsize {
; X86-LABEL: cmp16_load_slt_imm16_minsize:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpw $512, (%eax) # imm = 0x200
; X86-NEXT:    setl %al
; X86-NEXT:    retl
;
; X64-LABEL: cmp16_load_slt_imm16_minsize:
; X64:       # %bb.0:
; X64-NEXT:    cmpw $512, (%rdi) # imm = 0x200
; X64-NEXT:    setl %al
; X64-NEXT:    retq
  %ld = load i16, ptr %p0
  %cmp = icmp slt i16 %ld, 512
  ret i1 %cmp
}

define i1 @cmp16_load_slt_imm16_optsize(ptr %p0) optsize {
; X86-LABEL: cmp16_load_slt_imm16_optsize:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpw $512, (%eax) # imm = 0x200
; X86-NEXT:    setl %al
; X86-NEXT:    retl
;
; X64-LABEL: cmp16_load_slt_imm16_optsize:
; X64:       # %bb.0:
; X64-NEXT:    cmpw $512, (%rdi) # imm = 0x200
; X64-NEXT:    setl %al
; X64-NEXT:    retq
  %ld = load i16, ptr %p0
  %cmp = icmp slt i16 %ld, 512
  ret i1 %cmp
}

define i1 @cmp16_load_ule_imm8(ptr %p0) {
; X86-GENERIC-LABEL: cmp16_load_ule_imm8:
; X86-GENERIC:       # %bb.0:
; X86-GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-GENERIC-NEXT:    cmpw $16, (%eax)
; X86-GENERIC-NEXT:    setb %al
; X86-GENERIC-NEXT:    retl
;
; X64-GENERIC-LABEL: cmp16_load_ule_imm8:
; X64-GENERIC:       # %bb.0:
; X64-GENERIC-NEXT:    cmpw $16, (%rdi)
; X64-GENERIC-NEXT:    setb %al
; X64-GENERIC-NEXT:    retq
;
; X86-FAST-LABEL: cmp16_load_ule_imm8:
; X86-FAST:       # %bb.0:
; X86-FAST-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-FAST-NEXT:    cmpw $16, (%eax)
; X86-FAST-NEXT:    setb %al
; X86-FAST-NEXT:    retl
;
; X64-FAST-LABEL: cmp16_load_ule_imm8:
; X64-FAST:       # %bb.0:
; X64-FAST-NEXT:    cmpw $16, (%rdi)
; X64-FAST-NEXT:    setb %al
; X64-FAST-NEXT:    retq
;
; X86-ATOM-LABEL: cmp16_load_ule_imm8:
; X86-ATOM:       # %bb.0:
; X86-ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-ATOM-NEXT:    cmpw $16, (%eax)
; X86-ATOM-NEXT:    setb %al
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    retl
;
; X64-ATOM-LABEL: cmp16_load_ule_imm8:
; X64-ATOM:       # %bb.0:
; X64-ATOM-NEXT:    cmpw $16, (%rdi)
; X64-ATOM-NEXT:    setb %al
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    retq
  %ld = load i16, ptr %p0
  %cmp = icmp ule i16 %ld, 15
  ret i1 %cmp
}

define i1 @cmp16_load_ule_imm16(ptr %p0) {
; X86-GENERIC-LABEL: cmp16_load_ule_imm16:
; X86-GENERIC:       # %bb.0:
; X86-GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-GENERIC-NEXT:    cmpw $513, (%eax) # imm = 0x201
; X86-GENERIC-NEXT:    setb %al
; X86-GENERIC-NEXT:    retl
;
; X64-GENERIC-LABEL: cmp16_load_ule_imm16:
; X64-GENERIC:       # %bb.0:
; X64-GENERIC-NEXT:    cmpw $513, (%rdi) # imm = 0x201
; X64-GENERIC-NEXT:    setb %al
; X64-GENERIC-NEXT:    retq
;
; X86-FAST-LABEL: cmp16_load_ule_imm16:
; X86-FAST:       # %bb.0:
; X86-FAST-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-FAST-NEXT:    cmpw $513, (%eax) # imm = 0x201
; X86-FAST-NEXT:    setb %al
; X86-FAST-NEXT:    retl
;
; X64-FAST-LABEL: cmp16_load_ule_imm16:
; X64-FAST:       # %bb.0:
; X64-FAST-NEXT:    cmpw $513, (%rdi) # imm = 0x201
; X64-FAST-NEXT:    setb %al
; X64-FAST-NEXT:    retq
;
; X86-ATOM-LABEL: cmp16_load_ule_imm16:
; X86-ATOM:       # %bb.0:
; X86-ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-ATOM-NEXT:    cmpw $513, (%eax) # imm = 0x201
; X86-ATOM-NEXT:    setb %al
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    nop
; X86-ATOM-NEXT:    retl
;
; X64-ATOM-LABEL: cmp16_load_ule_imm16:
; X64-ATOM:       # %bb.0:
; X64-ATOM-NEXT:    cmpw $513, (%rdi) # imm = 0x201
; X64-ATOM-NEXT:    setb %al
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    nop
; X64-ATOM-NEXT:    retq
  %ld = load i16, ptr %p0
  %cmp = icmp ule i16 %ld, 512
  ret i1 %cmp
}

define i1 @cmp16_load_ule_imm16_minsize(ptr %p0) minsize {
; X86-LABEL: cmp16_load_ule_imm16_minsize:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpw $513, (%eax) # imm = 0x201
; X86-NEXT:    setb %al
; X86-NEXT:    retl
;
; X64-LABEL: cmp16_load_ule_imm16_minsize:
; X64:       # %bb.0:
; X64-NEXT:    cmpw $513, (%rdi) # imm = 0x201
; X64-NEXT:    setb %al
; X64-NEXT:    retq
  %ld = load i16, ptr %p0
  %cmp = icmp ule i16 %ld, 512
  ret i1 %cmp
}

define i1 @cmp16_load_ule_imm16_optsize(ptr %p0) optsize {
; X86-LABEL: cmp16_load_ule_imm16_optsize:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpw $513, (%eax) # imm = 0x201
; X86-NEXT:    setb %al
; X86-NEXT:    retl
;
; X64-LABEL: cmp16_load_ule_imm16_optsize:
; X64:       # %bb.0:
; X64-NEXT:    cmpw $513, (%rdi) # imm = 0x201
; X64-NEXT:    setb %al
; X64-NEXT:    retq
  %ld = load i16, ptr %p0
  %cmp = icmp ule i16 %ld, 512
  ret i1 %cmp
}
