; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+ccmp -show-mc-encoding -verify-machineinstrs | FileCheck %s
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+ccmp,+ndd -show-mc-encoding -verify-machineinstrs | FileCheck %s --check-prefix=NDD

define void @ccmp8rr_zf(i8 noundef %a, i8 noundef %b, i8 noundef %c) {
; CHECK-LABEL: ccmp8rr_zf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpb %dl, %dil # encoding: [0x40,0x38,0xd7]
; CHECK-NEXT:    ccmpneb {dfv=zf} %dl, %sil # encoding: [0x62,0xf4,0x14,0x05,0x38,0xd6]
; CHECK-NEXT:    jne .LBB0_1 # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB0_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %if.then
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    jmp foo # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB0_1: # %if.end
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NDD-LABEL: ccmp8rr_zf:
; NDD:       # %bb.0: # %entry
; NDD-NEXT:    cmpb %dl, %dil # encoding: [0x40,0x38,0xd7]
; NDD-NEXT:    ccmpneb {dfv=zf} %dl, %sil # encoding: [0x62,0xf4,0x14,0x05,0x38,0xd6]
; NDD-NEXT:    jne .LBB0_1 # encoding: [0x75,A]
; NDD-NEXT:    # fixup A - offset: 1, value: .LBB0_1-1, kind: FK_PCRel_1
; NDD-NEXT:  # %bb.2: # %if.then
; NDD-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; NDD-NEXT:    jmp foo # TAILCALL
; NDD-NEXT:    # encoding: [0xeb,A]
; NDD-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; NDD-NEXT:  .LBB0_1: # %if.end
; NDD-NEXT:    retq # encoding: [0xc3]
entry:
  %cmp = icmp eq i8 %a, %c
  %cmp1 = icmp eq i8 %b, %c
  %or.cond = or i1 %cmp, %cmp1
  br i1 %or.cond, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  tail call void (...) @foo()
  br label %if.end

if.end:                                           ; preds = %entry, %if.then
  ret void
}

define void @ccmp8rr_cf(i8 noundef %a, i8 noundef %b) {
; CHECK-LABEL: ccmp8rr_cf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpb $2, %dil # encoding: [0x40,0x80,0xff,0x02]
; CHECK-NEXT:    ccmpgeb {dfv=cf} $2, %sil # encoding: [0x62,0xf4,0x0c,0x0d,0x80,0xfe,0x02]
; CHECK-NEXT:    jb .LBB1_1 # encoding: [0x72,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB1_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %if.then
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    jmp foo # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB1_1: # %if.end
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NDD-LABEL: ccmp8rr_cf:
; NDD:       # %bb.0: # %entry
; NDD-NEXT:    cmpb $2, %dil # encoding: [0x40,0x80,0xff,0x02]
; NDD-NEXT:    ccmpgeb {dfv=cf} $2, %sil # encoding: [0x62,0xf4,0x0c,0x0d,0x80,0xfe,0x02]
; NDD-NEXT:    jb .LBB1_1 # encoding: [0x72,A]
; NDD-NEXT:    # fixup A - offset: 1, value: .LBB1_1-1, kind: FK_PCRel_1
; NDD-NEXT:  # %bb.2: # %if.then
; NDD-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; NDD-NEXT:    jmp foo # TAILCALL
; NDD-NEXT:    # encoding: [0xeb,A]
; NDD-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; NDD-NEXT:  .LBB1_1: # %if.end
; NDD-NEXT:    retq # encoding: [0xc3]
entry:
  %cmp = icmp sgt i8 %a, 1
  %tobool = icmp ugt i8 %b, 1
  %or.cond = and i1 %cmp, %tobool
  br i1 %or.cond, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  tail call void (...) @foo()
  br label %if.end

if.end:                                           ; preds = %if.then, %entry
  ret void
}

define i8 @ccmp8rr_sf(i8 %a, i8 %b, i8* nocapture %c)  {
; CHECK-LABEL: ccmp8rr_sf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    testb %dil, %dil # encoding: [0x40,0x84,0xff]
; CHECK-NEXT:    ccmpneb {dfv=sf} $2, %sil # encoding: [0x62,0xf4,0x24,0x05,0x80,0xfe,0x02]
; CHECK-NEXT:    jl .LBB2_2 # encoding: [0x7c,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB2_2-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %if.then
; CHECK-NEXT:    movb %dil, (%rdx) # encoding: [0x40,0x88,0x3a]
; CHECK-NEXT:  .LBB2_2: # %if.end
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NDD-LABEL: ccmp8rr_sf:
; NDD:       # %bb.0: # %entry
; NDD-NEXT:    testb %dil, %dil # encoding: [0x40,0x84,0xff]
; NDD-NEXT:    ccmpneb {dfv=sf} $2, %sil # encoding: [0x62,0xf4,0x24,0x05,0x80,0xfe,0x02]
; NDD-NEXT:    jl .LBB2_2 # encoding: [0x7c,A]
; NDD-NEXT:    # fixup A - offset: 1, value: .LBB2_2-1, kind: FK_PCRel_1
; NDD-NEXT:  # %bb.1: # %if.then
; NDD-NEXT:    movb %dil, (%rdx) # encoding: [0x40,0x88,0x3a]
; NDD-NEXT:  .LBB2_2: # %if.end
; NDD-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; NDD-NEXT:    retq # encoding: [0xc3]
entry:
  %tobool = icmp ne i8 %a, 0
  %cmp = icmp sgt i8 %b, 1
  %or.cond = select i1 %tobool, i1 %cmp, i1 false
  br i1 %or.cond, label %if.then, label %if.end

if.then:
  store i8 %a, i8* %c, align 4
  br label %if.end

if.end:
  ret i8 0
}

define i8 @ccmp8rr_none(i8 %a, i8 %b, i8* nocapture %c)  {
; CHECK-LABEL: ccmp8rr_none:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    testb %dil, %dil # encoding: [0x40,0x84,0xff]
; CHECK-NEXT:    ccmpeb {dfv=} $2, %sil # encoding: [0x62,0xf4,0x04,0x04,0x80,0xfe,0x02]
; CHECK-NEXT:    jl .LBB3_2 # encoding: [0x7c,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB3_2-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %if.then
; CHECK-NEXT:    movb %dil, (%rdx) # encoding: [0x40,0x88,0x3a]
; CHECK-NEXT:  .LBB3_2: # %if.end
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NDD-LABEL: ccmp8rr_none:
; NDD:       # %bb.0: # %entry
; NDD-NEXT:    testb %dil, %dil # encoding: [0x40,0x84,0xff]
; NDD-NEXT:    ccmpeb {dfv=} $2, %sil # encoding: [0x62,0xf4,0x04,0x04,0x80,0xfe,0x02]
; NDD-NEXT:    jl .LBB3_2 # encoding: [0x7c,A]
; NDD-NEXT:    # fixup A - offset: 1, value: .LBB3_2-1, kind: FK_PCRel_1
; NDD-NEXT:  # %bb.1: # %if.then
; NDD-NEXT:    movb %dil, (%rdx) # encoding: [0x40,0x88,0x3a]
; NDD-NEXT:  .LBB3_2: # %if.end
; NDD-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; NDD-NEXT:    retq # encoding: [0xc3]
entry:
  %tobool = icmp ne i8 %a, 0
  %cmp = icmp sgt i8 %b, 1
  %or.cond = select i1 %tobool, i1 true, i1 %cmp
  br i1 %or.cond, label %if.then, label %if.end

if.then:
  store i8 %a, i8* %c, align 4
  br label %if.end

if.end:
  ret i8 0
}

define void @ccmp16rr_sf(i16 noundef %a, i16 noundef %b, i16 noundef %c) {
; CHECK-LABEL: ccmp16rr_sf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpw %dx, %di # encoding: [0x66,0x39,0xd7]
; CHECK-NEXT:    ccmplew {dfv=sf} %dx, %si # encoding: [0x62,0xf4,0x25,0x0e,0x39,0xd6]
; CHECK-NEXT:    jge .LBB4_1 # encoding: [0x7d,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB4_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %if.then
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    jmp foo # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB4_1: # %if.end
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NDD-LABEL: ccmp16rr_sf:
; NDD:       # %bb.0: # %entry
; NDD-NEXT:    cmpw %dx, %di # encoding: [0x66,0x39,0xd7]
; NDD-NEXT:    ccmplew {dfv=sf} %dx, %si # encoding: [0x62,0xf4,0x25,0x0e,0x39,0xd6]
; NDD-NEXT:    jge .LBB4_1 # encoding: [0x7d,A]
; NDD-NEXT:    # fixup A - offset: 1, value: .LBB4_1-1, kind: FK_PCRel_1
; NDD-NEXT:  # %bb.2: # %if.then
; NDD-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; NDD-NEXT:    jmp foo # TAILCALL
; NDD-NEXT:    # encoding: [0xeb,A]
; NDD-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; NDD-NEXT:  .LBB4_1: # %if.end
; NDD-NEXT:    retq # encoding: [0xc3]
entry:
  %cmp = icmp sgt i16 %a, %c
  %cmp1 = icmp slt i16 %b, %c
  %or.cond = or i1 %cmp, %cmp1
  br i1 %or.cond, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  tail call void (...) @foo()
  br label %if.end

if.end:                                           ; preds = %entry, %if.then
  ret void
}

define void @ccmp32rr_cf(i32 noundef %a, i32 noundef %b, i32 noundef %c) {
; CHECK-LABEL: ccmp32rr_cf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpl %edx, %edi # encoding: [0x39,0xd7]
; CHECK-NEXT:    ccmpbl {dfv=cf} %edx, %esi # encoding: [0x62,0xf4,0x0c,0x02,0x39,0xd6]
; CHECK-NEXT:    ja .LBB5_1 # encoding: [0x77,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB5_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %if.then
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    jmp foo # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB5_1: # %if.end
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NDD-LABEL: ccmp32rr_cf:
; NDD:       # %bb.0: # %entry
; NDD-NEXT:    cmpl %edx, %edi # encoding: [0x39,0xd7]
; NDD-NEXT:    ccmpbl {dfv=cf} %edx, %esi # encoding: [0x62,0xf4,0x0c,0x02,0x39,0xd6]
; NDD-NEXT:    ja .LBB5_1 # encoding: [0x77,A]
; NDD-NEXT:    # fixup A - offset: 1, value: .LBB5_1-1, kind: FK_PCRel_1
; NDD-NEXT:  # %bb.2: # %if.then
; NDD-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; NDD-NEXT:    jmp foo # TAILCALL
; NDD-NEXT:    # encoding: [0xeb,A]
; NDD-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; NDD-NEXT:  .LBB5_1: # %if.end
; NDD-NEXT:    retq # encoding: [0xc3]
entry:
  %cmp = icmp uge i32 %a, %c
  %cmp1 = icmp ule i32 %b, %c
  %or.cond = or i1 %cmp, %cmp1
  br i1 %or.cond, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  tail call void (...) @foo()
  br label %if.end

if.end:                                           ; preds = %entry, %if.then
  ret void
}

define void @ccmp64rr_of(i64 %a, i64 %b, i64 %c) {
; CHECK-LABEL: ccmp64rr_of:
; CHECK:       # %bb.0: # %bb
; CHECK-NEXT:    cmpq %rdx, %rdi # encoding: [0x48,0x39,0xd7]
; CHECK-NEXT:    ccmpbq {dfv=of} %rsi, %rdi # encoding: [0x62,0xf4,0xc4,0x02,0x39,0xf7]
; CHECK-NEXT:    jno .LBB6_1 # encoding: [0x71,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB6_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %if.then
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    jmp foo # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB6_1: # %if.end
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NDD-LABEL: ccmp64rr_of:
; NDD:       # %bb.0: # %bb
; NDD-NEXT:    cmpq %rdx, %rdi # encoding: [0x48,0x39,0xd7]
; NDD-NEXT:    ccmpbq {dfv=of} %rsi, %rdi # encoding: [0x62,0xf4,0xc4,0x02,0x39,0xf7]
; NDD-NEXT:    jno .LBB6_1 # encoding: [0x71,A]
; NDD-NEXT:    # fixup A - offset: 1, value: .LBB6_1-1, kind: FK_PCRel_1
; NDD-NEXT:  # %bb.2: # %if.then
; NDD-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; NDD-NEXT:    jmp foo # TAILCALL
; NDD-NEXT:    # encoding: [0xeb,A]
; NDD-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; NDD-NEXT:  .LBB6_1: # %if.end
; NDD-NEXT:    retq # encoding: [0xc3]
bb:
  %cmp = icmp uge i64 %a, %c
  %smul = call {i64, i1} @llvm.ssub.with.overflow.i64(i64 %a, i64 %b)
  %obit = extractvalue {i64, i1} %smul, 1
  %or.cond = or i1 %cmp, %obit
  br i1 %or.cond, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  tail call void (...) @foo()
  br label %if.end

if.end:                                           ; preds = %entry, %if.then
  ret void
}

define void @ccmp64rr_of_crossbb(i64 %a, i64 %b) {
; CHECK-LABEL: ccmp64rr_of_crossbb:
; CHECK:       # %bb.0: # %bb
; CHECK-NEXT:    testq %rdi, %rdi # encoding: [0x48,0x85,0xff]
; CHECK-NEXT:    je .LBB7_2 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB7_2-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %bb1
; CHECK-NEXT:    cmpq %rsi, %rdi # encoding: [0x48,0x39,0xf7]
; CHECK-NEXT:  .LBB7_2: # %bb3
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NDD-LABEL: ccmp64rr_of_crossbb:
; NDD:       # %bb.0: # %bb
; NDD-NEXT:    testq %rdi, %rdi # encoding: [0x48,0x85,0xff]
; NDD-NEXT:    je .LBB7_2 # encoding: [0x74,A]
; NDD-NEXT:    # fixup A - offset: 1, value: .LBB7_2-1, kind: FK_PCRel_1
; NDD-NEXT:  # %bb.1: # %bb1
; NDD-NEXT:    cmpq %rsi, %rdi # encoding: [0x48,0x39,0xf7]
; NDD-NEXT:  .LBB7_2: # %bb3
; NDD-NEXT:    retq # encoding: [0xc3]
bb:
  %cond1 = icmp eq i64 %a, 0
  br i1 %cond1, label %bb3, label %bb1

bb1:                                              ; preds = %bb
  %smul = call {i64, i1} @llvm.ssub.with.overflow.i64(i64 %a, i64 %b)
  %obit = extractvalue {i64, i1} %smul, 1
  br i1 %obit, label %bb3, label %bb2

bb2:                                              ; preds = %bb1
  %tmp = ptrtoint ptr null to i64
  br label %bb3

bb3:                                              ; preds = %bb2, %bb1, %bb
  ret void
}

define void @ccmp8ri_zf(i8 noundef %a, i8 noundef %b, i8 noundef %c) {
; CHECK-LABEL: ccmp8ri_zf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpb %dl, %dil # encoding: [0x40,0x38,0xd7]
; CHECK-NEXT:    ccmpleb {dfv=zf} $123, %sil # encoding: [0x62,0xf4,0x14,0x0e,0x80,0xfe,0x7b]
; CHECK-NEXT:    jne .LBB8_1 # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB8_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %if.then
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    jmp foo # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB8_1: # %if.end
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NDD-LABEL: ccmp8ri_zf:
; NDD:       # %bb.0: # %entry
; NDD-NEXT:    cmpb %dl, %dil # encoding: [0x40,0x38,0xd7]
; NDD-NEXT:    ccmpleb {dfv=zf} $123, %sil # encoding: [0x62,0xf4,0x14,0x0e,0x80,0xfe,0x7b]
; NDD-NEXT:    jne .LBB8_1 # encoding: [0x75,A]
; NDD-NEXT:    # fixup A - offset: 1, value: .LBB8_1-1, kind: FK_PCRel_1
; NDD-NEXT:  # %bb.2: # %if.then
; NDD-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; NDD-NEXT:    jmp foo # TAILCALL
; NDD-NEXT:    # encoding: [0xeb,A]
; NDD-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; NDD-NEXT:  .LBB8_1: # %if.end
; NDD-NEXT:    retq # encoding: [0xc3]
entry:
  %cmp = icmp sgt i8 %a, %c
  %cmp1 = icmp eq i8 %b, 123
  %or.cond = or i1 %cmp, %cmp1
  br i1 %or.cond, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  tail call void (...) @foo()
  br label %if.end

if.end:                                           ; preds = %entry, %if.then
  ret void
}

define i8 @ccmp8ri_zf_double(i8 %a, double %b, i8* nocapture %c)  {
; CHECK-LABEL: ccmp8ri_zf_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorpd %xmm1, %xmm1 # encoding: [0x66,0x0f,0x57,0xc9]
; CHECK-NEXT:    ucomisd %xmm1, %xmm0 # encoding: [0x66,0x0f,0x2e,0xc1]
; CHECK-NEXT:    ccmpeb {dfv=zf} $123, %dil # encoding: [0x62,0xf4,0x14,0x04,0x80,0xff,0x7b]
; CHECK-NEXT:    je .LBB9_2 # encoding: [0x74,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB9_2-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %if.then
; CHECK-NEXT:    movb %dil, (%rsi) # encoding: [0x40,0x88,0x3e]
; CHECK-NEXT:  .LBB9_2: # %if.end
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NDD-LABEL: ccmp8ri_zf_double:
; NDD:       # %bb.0: # %entry
; NDD-NEXT:    xorpd %xmm1, %xmm1 # encoding: [0x66,0x0f,0x57,0xc9]
; NDD-NEXT:    ucomisd %xmm1, %xmm0 # encoding: [0x66,0x0f,0x2e,0xc1]
; NDD-NEXT:    ccmpeb {dfv=zf} $123, %dil # encoding: [0x62,0xf4,0x14,0x04,0x80,0xff,0x7b]
; NDD-NEXT:    je .LBB9_2 # encoding: [0x74,A]
; NDD-NEXT:    # fixup A - offset: 1, value: .LBB9_2-1, kind: FK_PCRel_1
; NDD-NEXT:  # %bb.1: # %if.then
; NDD-NEXT:    movb %dil, (%rsi) # encoding: [0x40,0x88,0x3e]
; NDD-NEXT:  .LBB9_2: # %if.end
; NDD-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; NDD-NEXT:    retq # encoding: [0xc3]
entry:
  %tobool = icmp ne i8 %a, 123
  %cmp = fcmp ueq double %b, 0.0
  %or.cond = select i1 %tobool, i1 %cmp, i1 false
  br i1 %or.cond, label %if.then, label %if.end

if.then:
  store i8 %a, i8* %c, align 4
  br label %if.end

if.end:
  ret i8 0
}

define i8 @ccmp8ri_zf_double_p(i8 %a, double %b, i8* nocapture %c)  {
; CHECK-LABEL: ccmp8ri_zf_double_p:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpb $123, %dil # encoding: [0x40,0x80,0xff,0x7b]
; CHECK-NEXT:    setne %al # encoding: [0x0f,0x95,0xc0]
; CHECK-NEXT:    ucomisd %xmm0, %xmm0 # encoding: [0x66,0x0f,0x2e,0xc0]
; CHECK-NEXT:    setp %cl # encoding: [0x0f,0x9a,0xc1]
; CHECK-NEXT:    andb %al, %cl # encoding: [0x20,0xc1]
; CHECK-NEXT:    cmpb $1, %cl # encoding: [0x80,0xf9,0x01]
; CHECK-NEXT:    jne .LBB10_2 # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB10_2-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %if.then
; CHECK-NEXT:    movb %dil, (%rsi) # encoding: [0x40,0x88,0x3e]
; CHECK-NEXT:  .LBB10_2: # %if.end
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NDD-LABEL: ccmp8ri_zf_double_p:
; NDD:       # %bb.0: # %entry
; NDD-NEXT:    cmpb $123, %dil # encoding: [0x40,0x80,0xff,0x7b]
; NDD-NEXT:    setne %al # encoding: [0x0f,0x95,0xc0]
; NDD-NEXT:    ucomisd %xmm0, %xmm0 # encoding: [0x66,0x0f,0x2e,0xc0]
; NDD-NEXT:    setp %cl # encoding: [0x0f,0x9a,0xc1]
; NDD-NEXT:    andb %cl, %al # EVEX TO LEGACY Compression encoding: [0x20,0xc8]
; NDD-NEXT:    cmpb $1, %al # encoding: [0x3c,0x01]
; NDD-NEXT:    jne .LBB10_2 # encoding: [0x75,A]
; NDD-NEXT:    # fixup A - offset: 1, value: .LBB10_2-1, kind: FK_PCRel_1
; NDD-NEXT:  # %bb.1: # %if.then
; NDD-NEXT:    movb %dil, (%rsi) # encoding: [0x40,0x88,0x3e]
; NDD-NEXT:  .LBB10_2: # %if.end
; NDD-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; NDD-NEXT:    retq # encoding: [0xc3]
entry:
  %tobool = icmp ne i8 %a, 123
  %cmp = fcmp uno double %b, 0.0
  %or.cond = select i1 %tobool, i1 %cmp, i1 false
  br i1 %or.cond, label %if.then, label %if.end

if.then:
  store i8 %a, i8* %c, align 4
  br label %if.end

if.end:
  ret i8 0
}

define i8 @ccmp8ri_zf_double_np(i8 %a, double %b, i8* nocapture %c)  {
; CHECK-LABEL: ccmp8ri_zf_double_np:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpb $123, %dil # encoding: [0x40,0x80,0xff,0x7b]
; CHECK-NEXT:    setne %al # encoding: [0x0f,0x95,0xc0]
; CHECK-NEXT:    ucomisd %xmm0, %xmm0 # encoding: [0x66,0x0f,0x2e,0xc0]
; CHECK-NEXT:    setnp %cl # encoding: [0x0f,0x9b,0xc1]
; CHECK-NEXT:    andb %al, %cl # encoding: [0x20,0xc1]
; CHECK-NEXT:    cmpb $1, %cl # encoding: [0x80,0xf9,0x01]
; CHECK-NEXT:    jne .LBB11_2 # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB11_2-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %if.then
; CHECK-NEXT:    movb %dil, (%rsi) # encoding: [0x40,0x88,0x3e]
; CHECK-NEXT:  .LBB11_2: # %if.end
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NDD-LABEL: ccmp8ri_zf_double_np:
; NDD:       # %bb.0: # %entry
; NDD-NEXT:    cmpb $123, %dil # encoding: [0x40,0x80,0xff,0x7b]
; NDD-NEXT:    setne %al # encoding: [0x0f,0x95,0xc0]
; NDD-NEXT:    ucomisd %xmm0, %xmm0 # encoding: [0x66,0x0f,0x2e,0xc0]
; NDD-NEXT:    setnp %cl # encoding: [0x0f,0x9b,0xc1]
; NDD-NEXT:    andb %cl, %al # EVEX TO LEGACY Compression encoding: [0x20,0xc8]
; NDD-NEXT:    cmpb $1, %al # encoding: [0x3c,0x01]
; NDD-NEXT:    jne .LBB11_2 # encoding: [0x75,A]
; NDD-NEXT:    # fixup A - offset: 1, value: .LBB11_2-1, kind: FK_PCRel_1
; NDD-NEXT:  # %bb.1: # %if.then
; NDD-NEXT:    movb %dil, (%rsi) # encoding: [0x40,0x88,0x3e]
; NDD-NEXT:  .LBB11_2: # %if.end
; NDD-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; NDD-NEXT:    retq # encoding: [0xc3]
entry:
  %tobool = icmp ne i8 %a, 123
  %cmp = fcmp ord double %b, 0.0
  %or.cond = select i1 %tobool, i1 %cmp, i1 false
  br i1 %or.cond, label %if.then, label %if.end

if.then:
  store i8 %a, i8* %c, align 4
  br label %if.end

if.end:
  ret i8 0
}

define void @ccmp16ri_zf(i16 noundef %a, i16 noundef %b, i16 noundef %c) {
; CHECK-LABEL: ccmp16ri_zf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpw %dx, %di # encoding: [0x66,0x39,0xd7]
; CHECK-NEXT:    movswl %si, %eax # encoding: [0x0f,0xbf,0xc6]
; CHECK-NEXT:    ccmpael {dfv=sf} $1234, %eax # encoding: [0x62,0xf4,0x24,0x03,0x81,0xf8,0xd2,0x04,0x00,0x00]
; CHECK-NEXT:    # imm = 0x4D2
; CHECK-NEXT:    jge .LBB12_1 # encoding: [0x7d,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB12_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %if.then
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    jmp foo # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB12_1: # %if.end
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NDD-LABEL: ccmp16ri_zf:
; NDD:       # %bb.0: # %entry
; NDD-NEXT:    cmpw %dx, %di # encoding: [0x66,0x39,0xd7]
; NDD-NEXT:    movswl %si, %eax # encoding: [0x0f,0xbf,0xc6]
; NDD-NEXT:    ccmpael {dfv=sf} $1234, %eax # encoding: [0x62,0xf4,0x24,0x03,0x81,0xf8,0xd2,0x04,0x00,0x00]
; NDD-NEXT:    # imm = 0x4D2
; NDD-NEXT:    jge .LBB12_1 # encoding: [0x7d,A]
; NDD-NEXT:    # fixup A - offset: 1, value: .LBB12_1-1, kind: FK_PCRel_1
; NDD-NEXT:  # %bb.2: # %if.then
; NDD-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; NDD-NEXT:    jmp foo # TAILCALL
; NDD-NEXT:    # encoding: [0xeb,A]
; NDD-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; NDD-NEXT:  .LBB12_1: # %if.end
; NDD-NEXT:    retq # encoding: [0xc3]
entry:
  %cmp = icmp ult i16 %a, %c
  %cmp1 = icmp slt i16 %b, 1234
  %or.cond = or i1 %cmp, %cmp1
  br i1 %or.cond, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  tail call void (...) @foo()
  br label %if.end

if.end:                                           ; preds = %entry, %if.then
  ret void
}

define void @ccmp32ri_cf(i32 noundef %a, i32 noundef %b, i32 noundef %c) {
; CHECK-LABEL: ccmp32ri_cf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpl %edx, %edi # encoding: [0x39,0xd7]
; CHECK-NEXT:    ccmpbl {dfv=cf} $1048577, %esi # encoding: [0x62,0xf4,0x0c,0x02,0x81,0xfe,0x01,0x00,0x10,0x00]
; CHECK-NEXT:    # imm = 0x100001
; CHECK-NEXT:    jae .LBB13_1 # encoding: [0x73,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB13_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %if.then
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    jmp foo # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB13_1: # %if.end
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NDD-LABEL: ccmp32ri_cf:
; NDD:       # %bb.0: # %entry
; NDD-NEXT:    cmpl %edx, %edi # encoding: [0x39,0xd7]
; NDD-NEXT:    ccmpbl {dfv=cf} $1048577, %esi # encoding: [0x62,0xf4,0x0c,0x02,0x81,0xfe,0x01,0x00,0x10,0x00]
; NDD-NEXT:    # imm = 0x100001
; NDD-NEXT:    jae .LBB13_1 # encoding: [0x73,A]
; NDD-NEXT:    # fixup A - offset: 1, value: .LBB13_1-1, kind: FK_PCRel_1
; NDD-NEXT:  # %bb.2: # %if.then
; NDD-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; NDD-NEXT:    jmp foo # TAILCALL
; NDD-NEXT:    # encoding: [0xeb,A]
; NDD-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; NDD-NEXT:  .LBB13_1: # %if.end
; NDD-NEXT:    retq # encoding: [0xc3]
entry:
  %cmp = icmp uge i32 %a, %c
  %cmp1 = icmp ule i32 %b, 1048576
  %or.cond = or i1 %cmp, %cmp1
  br i1 %or.cond, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  tail call void (...) @foo()
  br label %if.end

if.end:                                           ; preds = %entry, %if.then
  ret void
}

define void @ccmp64ri32_zf(i64 noundef %a, i64 noundef %b, i64 noundef %c) {
; CHECK-LABEL: ccmp64ri32_zf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpq %rdx, %rdi # encoding: [0x48,0x39,0xd7]
; CHECK-NEXT:    ccmpbeq {dfv=sf} $123456, %rsi # encoding: [0x62,0xf4,0xa4,0x06,0x81,0xfe,0x40,0xe2,0x01,0x00]
; CHECK-NEXT:    # imm = 0x1E240
; CHECK-NEXT:    jge .LBB14_1 # encoding: [0x7d,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB14_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %if.then
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    jmp foo # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB14_1: # %if.end
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NDD-LABEL: ccmp64ri32_zf:
; NDD:       # %bb.0: # %entry
; NDD-NEXT:    cmpq %rdx, %rdi # encoding: [0x48,0x39,0xd7]
; NDD-NEXT:    ccmpbeq {dfv=sf} $123456, %rsi # encoding: [0x62,0xf4,0xa4,0x06,0x81,0xfe,0x40,0xe2,0x01,0x00]
; NDD-NEXT:    # imm = 0x1E240
; NDD-NEXT:    jge .LBB14_1 # encoding: [0x7d,A]
; NDD-NEXT:    # fixup A - offset: 1, value: .LBB14_1-1, kind: FK_PCRel_1
; NDD-NEXT:  # %bb.2: # %if.then
; NDD-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; NDD-NEXT:    jmp foo # TAILCALL
; NDD-NEXT:    # encoding: [0xeb,A]
; NDD-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; NDD-NEXT:  .LBB14_1: # %if.end
; NDD-NEXT:    retq # encoding: [0xc3]
entry:
  %cmp = icmp ugt i64 %a, %c
  %cmp1 = icmp slt i64 %b, 123456
  %or.cond = or i1 %cmp, %cmp1
  br i1 %or.cond, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  tail call void (...) @foo()
  br label %if.end

if.end:                                           ; preds = %entry, %if.then
  ret void
}

define void @ccmp8rm_zf(i8 noundef %a, i8 noundef %b, i8 noundef %c, ptr %ptr) {
; CHECK-LABEL: ccmp8rm_zf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpb %dl, %dil # encoding: [0x40,0x38,0xd7]
; CHECK-NEXT:    ccmpneb {dfv=zf} (%rcx), %sil # encoding: [0x62,0xf4,0x14,0x05,0x3a,0x31]
; CHECK-NEXT:    jne .LBB15_1 # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB15_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %if.then
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    jmp foo # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB15_1: # %if.end
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NDD-LABEL: ccmp8rm_zf:
; NDD:       # %bb.0: # %entry
; NDD-NEXT:    cmpb %dl, %dil # encoding: [0x40,0x38,0xd7]
; NDD-NEXT:    ccmpneb {dfv=zf} (%rcx), %sil # encoding: [0x62,0xf4,0x14,0x05,0x3a,0x31]
; NDD-NEXT:    jne .LBB15_1 # encoding: [0x75,A]
; NDD-NEXT:    # fixup A - offset: 1, value: .LBB15_1-1, kind: FK_PCRel_1
; NDD-NEXT:  # %bb.2: # %if.then
; NDD-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; NDD-NEXT:    jmp foo # TAILCALL
; NDD-NEXT:    # encoding: [0xeb,A]
; NDD-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; NDD-NEXT:  .LBB15_1: # %if.end
; NDD-NEXT:    retq # encoding: [0xc3]
entry:
  %d = load i8, ptr %ptr
  %cmp = icmp eq i8 %a, %c
  %cmp1 = icmp eq i8 %b, %d
  %or.cond = or i1 %cmp, %cmp1
  br i1 %or.cond, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  tail call void (...) @foo()
  br label %if.end

if.end:                                           ; preds = %entry, %if.then
  ret void
}

define void @ccmp16rm_sf(i16 noundef %a, i16 noundef %b, i16 noundef %c, ptr %ptr) {
; CHECK-LABEL: ccmp16rm_sf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpw %dx, %di # encoding: [0x66,0x39,0xd7]
; CHECK-NEXT:    ccmplew {dfv=sf} (%rcx), %si # encoding: [0x62,0xf4,0x25,0x0e,0x3b,0x31]
; CHECK-NEXT:    jge .LBB16_1 # encoding: [0x7d,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB16_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %if.then
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    jmp foo # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB16_1: # %if.end
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NDD-LABEL: ccmp16rm_sf:
; NDD:       # %bb.0: # %entry
; NDD-NEXT:    cmpw %dx, %di # encoding: [0x66,0x39,0xd7]
; NDD-NEXT:    ccmplew {dfv=sf} (%rcx), %si # encoding: [0x62,0xf4,0x25,0x0e,0x3b,0x31]
; NDD-NEXT:    jge .LBB16_1 # encoding: [0x7d,A]
; NDD-NEXT:    # fixup A - offset: 1, value: .LBB16_1-1, kind: FK_PCRel_1
; NDD-NEXT:  # %bb.2: # %if.then
; NDD-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; NDD-NEXT:    jmp foo # TAILCALL
; NDD-NEXT:    # encoding: [0xeb,A]
; NDD-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; NDD-NEXT:  .LBB16_1: # %if.end
; NDD-NEXT:    retq # encoding: [0xc3]
entry:
  %d = load i16, ptr %ptr
  %cmp = icmp sgt i16 %a, %c
  %cmp1 = icmp slt i16 %b, %d
  %or.cond = or i1 %cmp, %cmp1
  br i1 %or.cond, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  tail call void (...) @foo()
  br label %if.end

if.end:                                           ; preds = %entry, %if.then
  ret void
}

define void @ccmp32rm_cf(i32 noundef %a, i32 noundef %b, i32 noundef %c, ptr %ptr) {
; CHECK-LABEL: ccmp32rm_cf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpl %edx, %edi # encoding: [0x39,0xd7]
; CHECK-NEXT:    ccmpgl {dfv=cf} (%rcx), %esi # encoding: [0x62,0xf4,0x0c,0x0f,0x3b,0x31]
; CHECK-NEXT:    ja .LBB17_1 # encoding: [0x77,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB17_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %if.then
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    jmp foo # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB17_1: # %if.end
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NDD-LABEL: ccmp32rm_cf:
; NDD:       # %bb.0: # %entry
; NDD-NEXT:    cmpl %edx, %edi # encoding: [0x39,0xd7]
; NDD-NEXT:    ccmpgl {dfv=cf} (%rcx), %esi # encoding: [0x62,0xf4,0x0c,0x0f,0x3b,0x31]
; NDD-NEXT:    ja .LBB17_1 # encoding: [0x77,A]
; NDD-NEXT:    # fixup A - offset: 1, value: .LBB17_1-1, kind: FK_PCRel_1
; NDD-NEXT:  # %bb.2: # %if.then
; NDD-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; NDD-NEXT:    jmp foo # TAILCALL
; NDD-NEXT:    # encoding: [0xeb,A]
; NDD-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; NDD-NEXT:  .LBB17_1: # %if.end
; NDD-NEXT:    retq # encoding: [0xc3]
entry:
  %d = load i32, ptr %ptr
  %cmp = icmp sle i32 %a, %c
  %cmp1 = icmp ule i32 %b, %d
  %or.cond = or i1 %cmp, %cmp1
  br i1 %or.cond, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  tail call void (...) @foo()
  br label %if.end

if.end:                                           ; preds = %entry, %if.then
  ret void
}

define void @ccmp64rm_sf(i64 noundef %a, i64 noundef %b, i64 noundef %c, ptr %ptr) {
; CHECK-LABEL: ccmp64rm_sf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpq %rdx, %rdi # encoding: [0x48,0x39,0xd7]
; CHECK-NEXT:    ccmpleq {dfv=sf} (%rcx), %rsi # encoding: [0x62,0xf4,0xa4,0x0e,0x3b,0x31]
; CHECK-NEXT:    jge .LBB18_1 # encoding: [0x7d,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB18_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %if.then
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    jmp foo # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB18_1: # %if.end
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NDD-LABEL: ccmp64rm_sf:
; NDD:       # %bb.0: # %entry
; NDD-NEXT:    cmpq %rdx, %rdi # encoding: [0x48,0x39,0xd7]
; NDD-NEXT:    ccmpleq {dfv=sf} (%rcx), %rsi # encoding: [0x62,0xf4,0xa4,0x0e,0x3b,0x31]
; NDD-NEXT:    jge .LBB18_1 # encoding: [0x7d,A]
; NDD-NEXT:    # fixup A - offset: 1, value: .LBB18_1-1, kind: FK_PCRel_1
; NDD-NEXT:  # %bb.2: # %if.then
; NDD-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; NDD-NEXT:    jmp foo # TAILCALL
; NDD-NEXT:    # encoding: [0xeb,A]
; NDD-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; NDD-NEXT:  .LBB18_1: # %if.end
; NDD-NEXT:    retq # encoding: [0xc3]
entry:
  %d = load i64, ptr %ptr
  %cmp = icmp sgt i64 %a, %c
  %cmp1 = icmp slt i64 %b, %d
  %or.cond = or i1 %cmp, %cmp1
  br i1 %or.cond, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  tail call void (...) @foo()
  br label %if.end

if.end:                                           ; preds = %entry, %if.then
  ret void
}

define void @ccmp8mr_zf(i8 noundef %a, i8 noundef %c, ptr %ptr) {
; CHECK-LABEL: ccmp8mr_zf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpb %sil, %dil # encoding: [0x40,0x38,0xf7]
; CHECK-NEXT:    ccmpgeb {dfv=zf} %sil, (%rdx) # encoding: [0x62,0xf4,0x14,0x0d,0x38,0x32]
; CHECK-NEXT:    jne .LBB19_1 # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB19_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %if.then
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    jmp foo # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB19_1: # %if.end
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NDD-LABEL: ccmp8mr_zf:
; NDD:       # %bb.0: # %entry
; NDD-NEXT:    cmpb %sil, %dil # encoding: [0x40,0x38,0xf7]
; NDD-NEXT:    ccmpgeb {dfv=zf} %sil, (%rdx) # encoding: [0x62,0xf4,0x14,0x0d,0x38,0x32]
; NDD-NEXT:    jne .LBB19_1 # encoding: [0x75,A]
; NDD-NEXT:    # fixup A - offset: 1, value: .LBB19_1-1, kind: FK_PCRel_1
; NDD-NEXT:  # %bb.2: # %if.then
; NDD-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; NDD-NEXT:    jmp foo # TAILCALL
; NDD-NEXT:    # encoding: [0xeb,A]
; NDD-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; NDD-NEXT:  .LBB19_1: # %if.end
; NDD-NEXT:    retq # encoding: [0xc3]
entry:
  %b = load i8, ptr %ptr
  %cmp = icmp slt i8 %a, %c
  %cmp1 = icmp eq i8 %b, %c
  %or.cond = or i1 %cmp, %cmp1
  br i1 %or.cond, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  tail call void (...) @foo()
  br label %if.end

if.end:                                           ; preds = %entry, %if.then
  ret void
}

define void @ccmp16mr_sf(i16 noundef %a, i16 noundef %c, ptr %ptr) {
; CHECK-LABEL: ccmp16mr_sf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpw %si, %di # encoding: [0x66,0x39,0xf7]
; CHECK-NEXT:    ccmplew {dfv=sf} %si, (%rdx) # encoding: [0x62,0xf4,0x25,0x0e,0x39,0x32]
; CHECK-NEXT:    jge .LBB20_1 # encoding: [0x7d,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB20_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %if.then
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    jmp foo # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB20_1: # %if.end
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NDD-LABEL: ccmp16mr_sf:
; NDD:       # %bb.0: # %entry
; NDD-NEXT:    cmpw %si, %di # encoding: [0x66,0x39,0xf7]
; NDD-NEXT:    ccmplew {dfv=sf} %si, (%rdx) # encoding: [0x62,0xf4,0x25,0x0e,0x39,0x32]
; NDD-NEXT:    jge .LBB20_1 # encoding: [0x7d,A]
; NDD-NEXT:    # fixup A - offset: 1, value: .LBB20_1-1, kind: FK_PCRel_1
; NDD-NEXT:  # %bb.2: # %if.then
; NDD-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; NDD-NEXT:    jmp foo # TAILCALL
; NDD-NEXT:    # encoding: [0xeb,A]
; NDD-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; NDD-NEXT:  .LBB20_1: # %if.end
; NDD-NEXT:    retq # encoding: [0xc3]
entry:
  %b = load i16, ptr %ptr
  %cmp = icmp sgt i16 %a, %c
  %cmp1 = icmp slt i16 %b, %c
  %or.cond = or i1 %cmp, %cmp1
  br i1 %or.cond, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  tail call void (...) @foo()
  br label %if.end

if.end:                                           ; preds = %entry, %if.then
  ret void
}

define void @ccmp32mr_cf(i32 noundef %a, i32 noundef %c, ptr %ptr) {
; CHECK-LABEL: ccmp32mr_cf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpl %esi, %edi # encoding: [0x39,0xf7]
; CHECK-NEXT:    ccmpll {dfv=cf} %esi, (%rdx) # encoding: [0x62,0xf4,0x0c,0x0c,0x39,0x32]
; CHECK-NEXT:    ja .LBB21_1 # encoding: [0x77,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB21_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %if.then
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    jmp foo # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB21_1: # %if.end
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NDD-LABEL: ccmp32mr_cf:
; NDD:       # %bb.0: # %entry
; NDD-NEXT:    cmpl %esi, %edi # encoding: [0x39,0xf7]
; NDD-NEXT:    ccmpll {dfv=cf} %esi, (%rdx) # encoding: [0x62,0xf4,0x0c,0x0c,0x39,0x32]
; NDD-NEXT:    ja .LBB21_1 # encoding: [0x77,A]
; NDD-NEXT:    # fixup A - offset: 1, value: .LBB21_1-1, kind: FK_PCRel_1
; NDD-NEXT:  # %bb.2: # %if.then
; NDD-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; NDD-NEXT:    jmp foo # TAILCALL
; NDD-NEXT:    # encoding: [0xeb,A]
; NDD-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; NDD-NEXT:  .LBB21_1: # %if.end
; NDD-NEXT:    retq # encoding: [0xc3]
entry:
  %b = load i32, ptr %ptr
  %cmp = icmp sge i32 %a, %c
  %cmp1 = icmp ule i32 %b, %c
  %or.cond = or i1 %cmp, %cmp1
  br i1 %or.cond, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  tail call void (...) @foo()
  br label %if.end

if.end:                                           ; preds = %entry, %if.then
  ret void
}

define void @ccmp64mr_sf(i64 noundef %a, i64 noundef %c, ptr %ptr) {
; CHECK-LABEL: ccmp64mr_sf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpq %rsi, %rdi # encoding: [0x48,0x39,0xf7]
; CHECK-NEXT:    ccmpleq {dfv=sf} %rsi, (%rdx) # encoding: [0x62,0xf4,0xa4,0x0e,0x39,0x32]
; CHECK-NEXT:    jge .LBB22_1 # encoding: [0x7d,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB22_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %if.then
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    jmp foo # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB22_1: # %if.end
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NDD-LABEL: ccmp64mr_sf:
; NDD:       # %bb.0: # %entry
; NDD-NEXT:    cmpq %rsi, %rdi # encoding: [0x48,0x39,0xf7]
; NDD-NEXT:    ccmpleq {dfv=sf} %rsi, (%rdx) # encoding: [0x62,0xf4,0xa4,0x0e,0x39,0x32]
; NDD-NEXT:    jge .LBB22_1 # encoding: [0x7d,A]
; NDD-NEXT:    # fixup A - offset: 1, value: .LBB22_1-1, kind: FK_PCRel_1
; NDD-NEXT:  # %bb.2: # %if.then
; NDD-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; NDD-NEXT:    jmp foo # TAILCALL
; NDD-NEXT:    # encoding: [0xeb,A]
; NDD-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; NDD-NEXT:  .LBB22_1: # %if.end
; NDD-NEXT:    retq # encoding: [0xc3]
entry:
  %b = load i64, ptr %ptr
  %cmp = icmp sgt i64 %a, %c
  %cmp1 = icmp slt i64 %b, %c
  %or.cond = or i1 %cmp, %cmp1
  br i1 %or.cond, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  tail call void (...) @foo()
  br label %if.end

if.end:                                           ; preds = %entry, %if.then
  ret void
}

define void @ccmp8mi_zf(i8 noundef %a, i8 noundef %c, ptr %ptr) {
; CHECK-LABEL: ccmp8mi_zf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpb %sil, %dil # encoding: [0x40,0x38,0xf7]
; CHECK-NEXT:    ccmpneb {dfv=zf} $123, (%rdx) # encoding: [0x62,0xf4,0x14,0x05,0x80,0x3a,0x7b]
; CHECK-NEXT:    jne .LBB23_1 # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB23_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %if.then
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    jmp foo # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB23_1: # %if.end
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NDD-LABEL: ccmp8mi_zf:
; NDD:       # %bb.0: # %entry
; NDD-NEXT:    cmpb %sil, %dil # encoding: [0x40,0x38,0xf7]
; NDD-NEXT:    ccmpneb {dfv=zf} $123, (%rdx) # encoding: [0x62,0xf4,0x14,0x05,0x80,0x3a,0x7b]
; NDD-NEXT:    jne .LBB23_1 # encoding: [0x75,A]
; NDD-NEXT:    # fixup A - offset: 1, value: .LBB23_1-1, kind: FK_PCRel_1
; NDD-NEXT:  # %bb.2: # %if.then
; NDD-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; NDD-NEXT:    jmp foo # TAILCALL
; NDD-NEXT:    # encoding: [0xeb,A]
; NDD-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; NDD-NEXT:  .LBB23_1: # %if.end
; NDD-NEXT:    retq # encoding: [0xc3]
entry:
  %b = load i8, ptr %ptr
  %cmp = icmp eq i8 %a, %c
  %cmp1 = icmp eq i8 %b, 123
  %or.cond = or i1 %cmp, %cmp1
  br i1 %or.cond, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  tail call void (...) @foo()
  br label %if.end

if.end:                                           ; preds = %entry, %if.then
  ret void
}

define void @ccmp16mi_zf(i16 noundef %a, i16 noundef %c, ptr %ptr) {
; CHECK-LABEL: ccmp16mi_zf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpw %si, %di # encoding: [0x66,0x39,0xf7]
; CHECK-NEXT:    ccmplew {dfv=sf} $1234, (%rdx) # encoding: [0x62,0xf4,0x25,0x0e,0x81,0x3a,0xd2,0x04]
; CHECK-NEXT:    # imm = 0x4D2
; CHECK-NEXT:    jge .LBB24_1 # encoding: [0x7d,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB24_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %if.then
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    jmp foo # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB24_1: # %if.end
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NDD-LABEL: ccmp16mi_zf:
; NDD:       # %bb.0: # %entry
; NDD-NEXT:    cmpw %si, %di # encoding: [0x66,0x39,0xf7]
; NDD-NEXT:    ccmplew {dfv=sf} $1234, (%rdx) # encoding: [0x62,0xf4,0x25,0x0e,0x81,0x3a,0xd2,0x04]
; NDD-NEXT:    # imm = 0x4D2
; NDD-NEXT:    jge .LBB24_1 # encoding: [0x7d,A]
; NDD-NEXT:    # fixup A - offset: 1, value: .LBB24_1-1, kind: FK_PCRel_1
; NDD-NEXT:  # %bb.2: # %if.then
; NDD-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; NDD-NEXT:    jmp foo # TAILCALL
; NDD-NEXT:    # encoding: [0xeb,A]
; NDD-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; NDD-NEXT:  .LBB24_1: # %if.end
; NDD-NEXT:    retq # encoding: [0xc3]
entry:
  %b = load i16, ptr %ptr
  %cmp = icmp sgt i16 %a, %c
  %cmp1 = icmp slt i16 %b, 1234
  %or.cond = or i1 %cmp, %cmp1
  br i1 %or.cond, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  tail call void (...) @foo()
  br label %if.end

if.end:                                           ; preds = %entry, %if.then
  ret void
}

define void @ccmp32mi_cf(i32 noundef %a, i32 noundef %c, ptr %ptr) {
; CHECK-LABEL: ccmp32mi_cf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpl %esi, %edi # encoding: [0x39,0xf7]
; CHECK-NEXT:    ccmpnel {dfv=cf} $123457, (%rdx) # encoding: [0x62,0xf4,0x0c,0x05,0x81,0x3a,0x41,0xe2,0x01,0x00]
; CHECK-NEXT:    # imm = 0x1E241
; CHECK-NEXT:    jae .LBB25_1 # encoding: [0x73,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB25_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %if.then
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    jmp foo # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB25_1: # %if.end
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NDD-LABEL: ccmp32mi_cf:
; NDD:       # %bb.0: # %entry
; NDD-NEXT:    cmpl %esi, %edi # encoding: [0x39,0xf7]
; NDD-NEXT:    ccmpnel {dfv=cf} $123457, (%rdx) # encoding: [0x62,0xf4,0x0c,0x05,0x81,0x3a,0x41,0xe2,0x01,0x00]
; NDD-NEXT:    # imm = 0x1E241
; NDD-NEXT:    jae .LBB25_1 # encoding: [0x73,A]
; NDD-NEXT:    # fixup A - offset: 1, value: .LBB25_1-1, kind: FK_PCRel_1
; NDD-NEXT:  # %bb.2: # %if.then
; NDD-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; NDD-NEXT:    jmp foo # TAILCALL
; NDD-NEXT:    # encoding: [0xeb,A]
; NDD-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; NDD-NEXT:  .LBB25_1: # %if.end
; NDD-NEXT:    retq # encoding: [0xc3]
entry:
  %b = load i32, ptr %ptr
  %cmp = icmp eq i32 %a, %c
  %cmp1 = icmp ule i32 %b, 123456
  %or.cond = or i1 %cmp, %cmp1
  br i1 %or.cond, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  tail call void (...) @foo()
  br label %if.end

if.end:                                           ; preds = %entry, %if.then
  ret void
}

define void @ccmp64mi32_zf(i64 noundef %a, i64 noundef %c, ptr %ptr) {
; CHECK-LABEL: ccmp64mi32_zf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpq %rsi, %rdi # encoding: [0x48,0x39,0xf7]
; CHECK-NEXT:    ccmpleq {dfv=sf} $123456, (%rdx) # encoding: [0x62,0xf4,0xa4,0x0e,0x81,0x3a,0x40,0xe2,0x01,0x00]
; CHECK-NEXT:    # imm = 0x1E240
; CHECK-NEXT:    jge .LBB26_1 # encoding: [0x7d,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB26_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %if.then
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    jmp foo # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB26_1: # %if.end
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NDD-LABEL: ccmp64mi32_zf:
; NDD:       # %bb.0: # %entry
; NDD-NEXT:    cmpq %rsi, %rdi # encoding: [0x48,0x39,0xf7]
; NDD-NEXT:    ccmpleq {dfv=sf} $123456, (%rdx) # encoding: [0x62,0xf4,0xa4,0x0e,0x81,0x3a,0x40,0xe2,0x01,0x00]
; NDD-NEXT:    # imm = 0x1E240
; NDD-NEXT:    jge .LBB26_1 # encoding: [0x7d,A]
; NDD-NEXT:    # fixup A - offset: 1, value: .LBB26_1-1, kind: FK_PCRel_1
; NDD-NEXT:  # %bb.2: # %if.then
; NDD-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; NDD-NEXT:    jmp foo # TAILCALL
; NDD-NEXT:    # encoding: [0xeb,A]
; NDD-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; NDD-NEXT:  .LBB26_1: # %if.end
; NDD-NEXT:    retq # encoding: [0xc3]
entry:
  %b = load i64, ptr %ptr
  %cmp = icmp sgt i64 %a, %c
  %cmp1 = icmp slt i64 %b, 123456
  %or.cond = or i1 %cmp, %cmp1
  br i1 %or.cond, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  tail call void (...) @foo()
  br label %if.end

if.end:                                           ; preds = %entry, %if.then
  ret void
}

define void @ccmp_continous(i32 noundef %a, i32 noundef %b, i32 noundef %c) {
; CHECK-LABEL: ccmp_continous:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    testl %edi, %edi # encoding: [0x85,0xff]
; CHECK-NEXT:    ccmplel {dfv=} $2, %esi # encoding: [0x62,0xf4,0x04,0x0e,0x83,0xfe,0x02]
; CHECK-NEXT:    ccmpll {dfv=} $3, %edx # encoding: [0x62,0xf4,0x04,0x0c,0x83,0xfa,0x03]
; CHECK-NEXT:    jge .LBB27_1 # encoding: [0x7d,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB27_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %if.then
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    jmp foo # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB27_1: # %if.end
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NDD-LABEL: ccmp_continous:
; NDD:       # %bb.0: # %entry
; NDD-NEXT:    testl %edi, %edi # encoding: [0x85,0xff]
; NDD-NEXT:    ccmplel {dfv=} $2, %esi # encoding: [0x62,0xf4,0x04,0x0e,0x83,0xfe,0x02]
; NDD-NEXT:    ccmpll {dfv=} $3, %edx # encoding: [0x62,0xf4,0x04,0x0c,0x83,0xfa,0x03]
; NDD-NEXT:    jge .LBB27_1 # encoding: [0x7d,A]
; NDD-NEXT:    # fixup A - offset: 1, value: .LBB27_1-1, kind: FK_PCRel_1
; NDD-NEXT:  # %bb.2: # %if.then
; NDD-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; NDD-NEXT:    jmp foo # TAILCALL
; NDD-NEXT:    # encoding: [0xeb,A]
; NDD-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; NDD-NEXT:  .LBB27_1: # %if.end
; NDD-NEXT:    retq # encoding: [0xc3]
entry:
  %cmp = icmp slt i32 %a, 1
  %cmp1 = icmp slt i32 %b, 2
  %or.cond = and i1 %cmp, %cmp1
  %cmp3 = icmp slt i32 %c, 3
  %or.cond4 = and i1 %or.cond, %cmp3
  br i1 %or.cond4, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  tail call void (...) @foo()
  br label %if.end

if.end:                                           ; preds = %if.then, %entry
  ret void
}

define i32 @ccmp_nobranch(i32 noundef %a, i32 noundef %b) {
; CHECK-LABEL: ccmp_nobranch:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    testl %edi, %edi # encoding: [0x85,0xff]
; CHECK-NEXT:    ccmplel {dfv=} $2, %esi # encoding: [0x62,0xf4,0x04,0x0e,0x83,0xfe,0x02]
; CHECK-NEXT:    setge %al # encoding: [0x0f,0x9d,0xc0]
; CHECK-NEXT:    movzbl %al, %eax # encoding: [0x0f,0xb6,0xc0]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NDD-LABEL: ccmp_nobranch:
; NDD:       # %bb.0: # %entry
; NDD-NEXT:    testl %edi, %edi # encoding: [0x85,0xff]
; NDD-NEXT:    ccmplel {dfv=} $2, %esi # encoding: [0x62,0xf4,0x04,0x0e,0x83,0xfe,0x02]
; NDD-NEXT:    setge %al # encoding: [0x0f,0x9d,0xc0]
; NDD-NEXT:    movzbl %al, %eax # encoding: [0x0f,0xb6,0xc0]
; NDD-NEXT:    retq # encoding: [0xc3]
entry:
  %cmp = icmp sgt i32 %a, 0
  %cmp1 = icmp sgt i32 %b, 1
  %or.cond.not = or i1 %cmp, %cmp1
  %. = zext i1 %or.cond.not to i32
  ret i32 %.
}

define i32 @ccmp_continous_nobranch(i32 noundef %a, i32 noundef %b, i32 noundef %c) {
; CHECK-LABEL: ccmp_continous_nobranch:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpl $2, %edi # encoding: [0x83,0xff,0x02]
; CHECK-NEXT:    ccmpll {dfv=sf} $2, %esi # encoding: [0x62,0xf4,0x24,0x0c,0x83,0xfe,0x02]
; CHECK-NEXT:    ccmpll {dfv=sf} $4, %edx # encoding: [0x62,0xf4,0x24,0x0c,0x83,0xfa,0x04]
; CHECK-NEXT:    setge %al # encoding: [0x0f,0x9d,0xc0]
; CHECK-NEXT:    movzbl %al, %eax # encoding: [0x0f,0xb6,0xc0]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NDD-LABEL: ccmp_continous_nobranch:
; NDD:       # %bb.0: # %entry
; NDD-NEXT:    cmpl $2, %edi # encoding: [0x83,0xff,0x02]
; NDD-NEXT:    ccmpll {dfv=sf} $2, %esi # encoding: [0x62,0xf4,0x24,0x0c,0x83,0xfe,0x02]
; NDD-NEXT:    ccmpll {dfv=sf} $4, %edx # encoding: [0x62,0xf4,0x24,0x0c,0x83,0xfa,0x04]
; NDD-NEXT:    setge %al # encoding: [0x0f,0x9d,0xc0]
; NDD-NEXT:    movzbl %al, %eax # encoding: [0x0f,0xb6,0xc0]
; NDD-NEXT:    retq # encoding: [0xc3]
entry:
  %cmp = icmp sgt i32 %a, 1
  %cmp1 = icmp slt i32 %b, 2
  %cmp2 = icmp sgt i32 %c, 3
  %or1 = or i1 %cmp, %cmp1
  %or2 =  and i1 %or1, %cmp2
  %. = zext i1 %or2 to i32
  ret i32 %.
}

define void @ccmp64ri64(i64 noundef %a, i64 noundef %b, i64 noundef %c) {
; CHECK-LABEL: ccmp64ri64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpq %rdx, %rdi # encoding: [0x48,0x39,0xd7]
; CHECK-NEXT:    movabsq $9992147483646, %rax # encoding: [0x48,0xb8,0xfe,0xbb,0x66,0x7a,0x16,0x09,0x00,0x00]
; CHECK-NEXT:    # imm = 0x9167A66BBFE
; CHECK-NEXT:    ccmpbeq {dfv=zf} %rax, %rsi # encoding: [0x62,0xf4,0x94,0x06,0x39,0xc6]
; CHECK-NEXT:    jg .LBB30_1 # encoding: [0x7f,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: .LBB30_1-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.2: # %if.then
; CHECK-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; CHECK-NEXT:    jmp foo # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; CHECK-NEXT:  .LBB30_1: # %if.end
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NDD-LABEL: ccmp64ri64:
; NDD:       # %bb.0: # %entry
; NDD-NEXT:    cmpq %rdx, %rdi # encoding: [0x48,0x39,0xd7]
; NDD-NEXT:    movabsq $9992147483646, %rax # encoding: [0x48,0xb8,0xfe,0xbb,0x66,0x7a,0x16,0x09,0x00,0x00]
; NDD-NEXT:    # imm = 0x9167A66BBFE
; NDD-NEXT:    ccmpbeq {dfv=zf} %rax, %rsi # encoding: [0x62,0xf4,0x94,0x06,0x39,0xc6]
; NDD-NEXT:    jg .LBB30_1 # encoding: [0x7f,A]
; NDD-NEXT:    # fixup A - offset: 1, value: .LBB30_1-1, kind: FK_PCRel_1
; NDD-NEXT:  # %bb.2: # %if.then
; NDD-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; NDD-NEXT:    jmp foo # TAILCALL
; NDD-NEXT:    # encoding: [0xeb,A]
; NDD-NEXT:    # fixup A - offset: 1, value: foo-1, kind: FK_PCRel_1
; NDD-NEXT:  .LBB30_1: # %if.end
; NDD-NEXT:    retq # encoding: [0xc3]
entry:
  %cmp = icmp ugt i64 %a, %c
  %cmp1 = icmp slt i64 %b, 9992147483647
  %or.cond = or i1 %cmp, %cmp1
  br i1 %or.cond, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  tail call void (...) @foo()
  br label %if.end

if.end:                                           ; preds = %entry, %if.then
  ret void
}

declare dso_local void @foo(...)
declare {i64, i1} @llvm.ssub.with.overflow.i64(i64, i64) nounwind readnone
