; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+zvfh,+zvfbfmin,+v \
; RUN:     -target-abi=ilp32d -verify-machineinstrs < %s | FileCheck %s \
; RUN:     --check-prefixes=CHECK,ZVFH
; RUN: llc -mtriple=riscv64 -mattr=+d,+zvfh,+zvfbfmin,+v \
; RUN:     -target-abi=lp64d -verify-machineinstrs < %s | FileCheck %s \
; RUN:     --check-prefixes=CHECK,ZVFH
; RUN: llc -mtriple=riscv32 -mattr=+d,+zfhmin,+zvfhmin,+zvfbfmin,+v \
; RUN:     -target-abi=ilp32d -verify-machineinstrs < %s | FileCheck %s \
; RUN:     --check-prefixes=CHECK,ZVFHMIN
; RUN: llc -mtriple=riscv64 -mattr=+d,+zfhmin,+zvfhmin,+zvfbfmin,+v \
; RUN:     -target-abi=lp64d -verify-machineinstrs < %s | FileCheck %s \
; RUN:     --check-prefixes=CHECK,ZVFHMIN

define <vscale x 1 x bfloat> @nxv1bf16(<vscale x 1 x bfloat> %vm, <vscale x 1 x bfloat> %vs) {
; CHECK-LABEL: nxv1bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a0, 8
; CHECK-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    addi a0, a0, -1
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vor.vv v8, v8, v9
; CHECK-NEXT:    ret
  %r = call <vscale x 1 x bfloat> @llvm.copysign.nxv1bf16(<vscale x 1 x bfloat> %vm, <vscale x 1 x bfloat> %vs)
  ret <vscale x 1 x bfloat> %r
}

define <vscale x 2 x bfloat> @nxv2bf16(<vscale x 2 x bfloat> %vm, <vscale x 2 x bfloat> %vs) {
; CHECK-LABEL: nxv2bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a0, 8
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    addi a0, a0, -1
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vor.vv v8, v8, v9
; CHECK-NEXT:    ret
  %r = call <vscale x 2 x bfloat> @llvm.copysign.nxv2bf16(<vscale x 2 x bfloat> %vm, <vscale x 2 x bfloat> %vs)
  ret <vscale x 2 x bfloat> %r
}

define <vscale x 4 x bfloat> @nxv4bf16(<vscale x 4 x bfloat> %vm, <vscale x 4 x bfloat> %vs) {
; CHECK-LABEL: nxv4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a0, 8
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    addi a0, a0, -1
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vor.vv v8, v8, v9
; CHECK-NEXT:    ret
  %r = call <vscale x 4 x bfloat> @llvm.copysign.nxv4bf16(<vscale x 4 x bfloat> %vm, <vscale x 4 x bfloat> %vs)
  ret <vscale x 4 x bfloat> %r
}

define <vscale x 8 x bfloat> @nxv8bf16(<vscale x 8 x bfloat> %vm, <vscale x 8 x bfloat> %vs) {
; CHECK-LABEL: nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a0, 8
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vand.vx v10, v10, a0
; CHECK-NEXT:    addi a0, a0, -1
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vor.vv v8, v8, v10
; CHECK-NEXT:    ret
  %r = call <vscale x 8 x bfloat> @llvm.copysign.nxv8bf16(<vscale x 8 x bfloat> %vm, <vscale x 8 x bfloat> %vs)
  ret <vscale x 8 x bfloat> %r
}

define <vscale x 16 x bfloat> @nxv16bf16(<vscale x 16 x bfloat> %vm, <vscale x 16 x bfloat> %vs) {
; CHECK-LABEL: nxv16bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a0, 8
; CHECK-NEXT:    vsetvli a1, zero, e16, m4, ta, ma
; CHECK-NEXT:    vand.vx v12, v12, a0
; CHECK-NEXT:    addi a0, a0, -1
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vor.vv v8, v8, v12
; CHECK-NEXT:    ret
  %r = call <vscale x 16 x bfloat> @llvm.copysign.nxv16bf16(<vscale x 16 x bfloat> %vm, <vscale x 16 x bfloat> %vs)
  ret <vscale x 16 x bfloat> %r
}

define <vscale x 32 x bfloat> @nxv32bf32(<vscale x 32 x bfloat> %vm, <vscale x 32 x bfloat> %vs) {
; CHECK-LABEL: nxv32bf32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a0, 8
; CHECK-NEXT:    vsetvli a1, zero, e16, m8, ta, ma
; CHECK-NEXT:    vand.vx v16, v16, a0
; CHECK-NEXT:    addi a0, a0, -1
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    ret
  %r = call <vscale x 32 x bfloat> @llvm.copysign.nxv32bf32(<vscale x 32 x bfloat> %vm, <vscale x 32 x bfloat> %vs)
  ret <vscale x 32 x bfloat> %r
}

declare <vscale x 1 x half> @llvm.copysign.nxv1f16(<vscale x 1 x half>, <vscale x 1 x half>)

define <vscale x 1 x half> @vfcopysign_vv_nxv1f16(<vscale x 1 x half> %vm, <vscale x 1 x half> %vs) {
; ZVFH-LABEL: vfcopysign_vv_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfsgnj.vv v8, v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopysign_vv_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    lui a0, 8
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vand.vx v9, v9, a0
; ZVFHMIN-NEXT:    addi a0, a0, -1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a0
; ZVFHMIN-NEXT:    vor.vv v8, v8, v9
; ZVFHMIN-NEXT:    ret
  %r = call <vscale x 1 x half> @llvm.copysign.nxv1f16(<vscale x 1 x half> %vm, <vscale x 1 x half> %vs)
  ret <vscale x 1 x half> %r
}

define <vscale x 1 x half> @vfcopysign_vf_nxv1f16(<vscale x 1 x half> %vm, half %s) {
; ZVFH-LABEL: vfcopysign_vf_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfsgnj.vf v8, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopysign_vf_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fmv.x.h a0, fa0
; ZVFHMIN-NEXT:    lui a1, 8
; ZVFHMIN-NEXT:    vsetvli a2, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vmv.v.x v9, a0
; ZVFHMIN-NEXT:    addi a0, a1, -1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a0
; ZVFHMIN-NEXT:    vand.vx v9, v9, a1
; ZVFHMIN-NEXT:    vor.vv v8, v8, v9
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %s, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %r = call <vscale x 1 x half> @llvm.copysign.nxv1f16(<vscale x 1 x half> %vm, <vscale x 1 x half> %splat)
  ret <vscale x 1 x half> %r
}

define <vscale x 1 x half> @vfcopynsign_vv_nxv1f16(<vscale x 1 x half> %vm, <vscale x 1 x half> %vs) {
; ZVFH-LABEL: vfcopynsign_vv_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfsgnjn.vv v8, v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopynsign_vv_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    lui a0, 8
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vxor.vx v9, v9, a0
; ZVFHMIN-NEXT:    vand.vx v9, v9, a0
; ZVFHMIN-NEXT:    addi a0, a0, -1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a0
; ZVFHMIN-NEXT:    vor.vv v8, v8, v9
; ZVFHMIN-NEXT:    ret
  %n = fneg <vscale x 1 x half> %vs
  %r = call <vscale x 1 x half> @llvm.copysign.nxv1f16(<vscale x 1 x half> %vm, <vscale x 1 x half> %n)
  ret <vscale x 1 x half> %r
}

define <vscale x 1 x half> @vfcopynsign_vf_nxv1f16(<vscale x 1 x half> %vm, half %s) {
; ZVFH-LABEL: vfcopynsign_vf_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfsgnjn.vf v8, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopynsign_vf_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fmv.x.h a0, fa0
; ZVFHMIN-NEXT:    lui a1, 8
; ZVFHMIN-NEXT:    vsetvli a2, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vmv.v.x v9, a0
; ZVFHMIN-NEXT:    addi a0, a1, -1
; ZVFHMIN-NEXT:    vxor.vx v9, v9, a1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a0
; ZVFHMIN-NEXT:    vand.vx v9, v9, a1
; ZVFHMIN-NEXT:    vor.vv v8, v8, v9
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %s, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %n = fneg <vscale x 1 x half> %splat
  %r = call <vscale x 1 x half> @llvm.copysign.nxv1f16(<vscale x 1 x half> %vm, <vscale x 1 x half> %n)
  ret <vscale x 1 x half> %r
}

define <vscale x 1 x half> @vfcopysign_exttrunc_vv_nxv1f16_nxv1f32(<vscale x 1 x half> %vm, <vscale x 1 x float> %vs) {
; ZVFH-LABEL: vfcopysign_exttrunc_vv_nxv1f16_nxv1f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfncvt.f.f.w v10, v9
; ZVFH-NEXT:    vfsgnj.vv v8, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopysign_exttrunc_vv_nxv1f16_nxv1f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    lui a0, 8
; ZVFHMIN-NEXT:    vand.vx v9, v10, a0
; ZVFHMIN-NEXT:    addi a0, a0, -1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a0
; ZVFHMIN-NEXT:    vor.vv v8, v8, v9
; ZVFHMIN-NEXT:    ret
  %e = fptrunc <vscale x 1 x float> %vs to <vscale x 1 x half>
  %r = call <vscale x 1 x half> @llvm.copysign.nxv1f16(<vscale x 1 x half> %vm, <vscale x 1 x half> %e)
  ret <vscale x 1 x half> %r
}

define <vscale x 1 x half> @vfcopysign_exttrunc_vf_nxv1f16_nxv1f32(<vscale x 1 x half> %vm, float %s) {
; ZVFH-LABEL: vfcopysign_exttrunc_vf_nxv1f16_nxv1f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; ZVFH-NEXT:    vfmv.v.f v9, fa0
; ZVFH-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfncvt.f.f.w v10, v9
; ZVFH-NEXT:    vfsgnj.vv v8, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopysign_exttrunc_vf_nxv1f16_nxv1f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v9, fa0
; ZVFHMIN-NEXT:    lui a0, 8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    addi a1, a0, -1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a1
; ZVFHMIN-NEXT:    vand.vx v9, v10, a0
; ZVFHMIN-NEXT:    vor.vv v8, v8, v9
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %s, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %esplat = fptrunc <vscale x 1 x float> %splat to <vscale x 1 x half>
  %r = call <vscale x 1 x half> @llvm.copysign.nxv1f16(<vscale x 1 x half> %vm, <vscale x 1 x half> %esplat)
  ret <vscale x 1 x half> %r
}

define <vscale x 1 x half> @vfcopynsign_exttrunc_vv_nxv1f16_nxv1f32(<vscale x 1 x half> %vm, <vscale x 1 x float> %vs) {
; ZVFH-LABEL: vfcopynsign_exttrunc_vv_nxv1f16_nxv1f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfncvt.f.f.w v10, v9
; ZVFH-NEXT:    vfsgnjn.vv v8, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopynsign_exttrunc_vv_nxv1f16_nxv1f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    lui a0, 8
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    addi a1, a0, -1
; ZVFHMIN-NEXT:    vxor.vx v9, v10, a0
; ZVFHMIN-NEXT:    vand.vx v8, v8, a1
; ZVFHMIN-NEXT:    vand.vx v9, v9, a0
; ZVFHMIN-NEXT:    vor.vv v8, v8, v9
; ZVFHMIN-NEXT:    ret
  %n = fneg <vscale x 1 x float> %vs
  %eneg = fptrunc <vscale x 1 x float> %n to <vscale x 1 x half>
  %r = call <vscale x 1 x half> @llvm.copysign.nxv1f16(<vscale x 1 x half> %vm, <vscale x 1 x half> %eneg)
  ret <vscale x 1 x half> %r
}

define <vscale x 1 x half> @vfcopynsign_exttrunc_vf_nxv1f16_nxv1f32(<vscale x 1 x half> %vm, float %s) {
; ZVFH-LABEL: vfcopynsign_exttrunc_vf_nxv1f16_nxv1f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; ZVFH-NEXT:    vfmv.v.f v9, fa0
; ZVFH-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfncvt.f.f.w v10, v9
; ZVFH-NEXT:    vfsgnjn.vv v8, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopynsign_exttrunc_vf_nxv1f16_nxv1f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v9, fa0
; ZVFHMIN-NEXT:    lui a0, 8
; ZVFHMIN-NEXT:    addi a1, a0, -1
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    vand.vx v8, v8, a1
; ZVFHMIN-NEXT:    vxor.vx v9, v10, a0
; ZVFHMIN-NEXT:    vand.vx v9, v9, a0
; ZVFHMIN-NEXT:    vor.vv v8, v8, v9
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %s, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %n = fneg <vscale x 1 x float> %splat
  %eneg = fptrunc <vscale x 1 x float> %n to <vscale x 1 x half>
  %r = call <vscale x 1 x half> @llvm.copysign.nxv1f16(<vscale x 1 x half> %vm, <vscale x 1 x half> %eneg)
  ret <vscale x 1 x half> %r
}

define <vscale x 1 x half> @vfcopysign_exttrunc_vv_nxv1f16_nxv1f64(<vscale x 1 x half> %vm, <vscale x 1 x double> %vs) {
; ZVFH-LABEL: vfcopysign_exttrunc_vv_nxv1f16_nxv1f64:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; ZVFH-NEXT:    vfncvt.rod.f.f.w v10, v9
; ZVFH-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfncvt.f.f.w v9, v10
; ZVFH-NEXT:    vfsgnj.vv v8, v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopysign_exttrunc_vv_nxv1f16_nxv1f64:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.rod.f.f.w v10, v9
; ZVFHMIN-NEXT:    lui a0, 8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v9, v10
; ZVFHMIN-NEXT:    addi a1, a0, -1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a1
; ZVFHMIN-NEXT:    vand.vx v9, v9, a0
; ZVFHMIN-NEXT:    vor.vv v8, v8, v9
; ZVFHMIN-NEXT:    ret
  %e = fptrunc <vscale x 1 x double> %vs to <vscale x 1 x half>
  %r = call <vscale x 1 x half> @llvm.copysign.nxv1f16(<vscale x 1 x half> %vm, <vscale x 1 x half> %e)
  ret <vscale x 1 x half> %r
}

define <vscale x 1 x half> @vfcopysign_exttrunc_vf_nxv1f16_nxv1f64(<vscale x 1 x half> %vm, double %s) {
; ZVFH-LABEL: vfcopysign_exttrunc_vf_nxv1f16_nxv1f64:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; ZVFH-NEXT:    vfmv.v.f v9, fa0
; ZVFH-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; ZVFH-NEXT:    vfncvt.rod.f.f.w v10, v9
; ZVFH-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfncvt.f.f.w v9, v10
; ZVFH-NEXT:    vfsgnj.vv v8, v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopysign_exttrunc_vf_nxv1f16_nxv1f64:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v9, fa0
; ZVFHMIN-NEXT:    lui a0, 8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.rod.f.f.w v10, v9
; ZVFHMIN-NEXT:    addi a1, a0, -1
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v9, v10
; ZVFHMIN-NEXT:    vand.vx v8, v8, a1
; ZVFHMIN-NEXT:    vand.vx v9, v9, a0
; ZVFHMIN-NEXT:    vor.vv v8, v8, v9
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %s, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %esplat = fptrunc <vscale x 1 x double> %splat to <vscale x 1 x half>
  %r = call <vscale x 1 x half> @llvm.copysign.nxv1f16(<vscale x 1 x half> %vm, <vscale x 1 x half> %esplat)
  ret <vscale x 1 x half> %r
}

define <vscale x 1 x half> @vfcopynsign_exttrunc_vv_nxv1f16_nxv1f64(<vscale x 1 x half> %vm, <vscale x 1 x double> %vs) {
; ZVFH-LABEL: vfcopynsign_exttrunc_vv_nxv1f16_nxv1f64:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; ZVFH-NEXT:    vfncvt.rod.f.f.w v10, v9
; ZVFH-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfncvt.f.f.w v9, v10
; ZVFH-NEXT:    vfsgnjn.vv v8, v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopynsign_exttrunc_vv_nxv1f16_nxv1f64:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    lui a0, 8
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.rod.f.f.w v10, v9
; ZVFHMIN-NEXT:    addi a1, a0, -1
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v9, v10
; ZVFHMIN-NEXT:    vand.vx v8, v8, a1
; ZVFHMIN-NEXT:    vxor.vx v9, v9, a0
; ZVFHMIN-NEXT:    vand.vx v9, v9, a0
; ZVFHMIN-NEXT:    vor.vv v8, v8, v9
; ZVFHMIN-NEXT:    ret
  %n = fneg <vscale x 1 x double> %vs
  %eneg = fptrunc <vscale x 1 x double> %n to <vscale x 1 x half>
  %r = call <vscale x 1 x half> @llvm.copysign.nxv1f16(<vscale x 1 x half> %vm, <vscale x 1 x half> %eneg)
  ret <vscale x 1 x half> %r
}

define <vscale x 1 x half> @vfcopynsign_exttrunc_vf_nxv1f16_nxv1f64(<vscale x 1 x half> %vm, double %s) {
; ZVFH-LABEL: vfcopynsign_exttrunc_vf_nxv1f16_nxv1f64:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; ZVFH-NEXT:    vfmv.v.f v9, fa0
; ZVFH-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; ZVFH-NEXT:    vfncvt.rod.f.f.w v10, v9
; ZVFH-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfncvt.f.f.w v9, v10
; ZVFH-NEXT:    vfsgnjn.vv v8, v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopynsign_exttrunc_vf_nxv1f16_nxv1f64:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v9, fa0
; ZVFHMIN-NEXT:    lui a0, 8
; ZVFHMIN-NEXT:    addi a1, a0, -1
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.rod.f.f.w v10, v9
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vand.vx v8, v8, a1
; ZVFHMIN-NEXT:    vfncvt.f.f.w v9, v10
; ZVFHMIN-NEXT:    vxor.vx v9, v9, a0
; ZVFHMIN-NEXT:    vand.vx v9, v9, a0
; ZVFHMIN-NEXT:    vor.vv v8, v8, v9
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %s, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %n = fneg <vscale x 1 x double> %splat
  %eneg = fptrunc <vscale x 1 x double> %n to <vscale x 1 x half>
  %r = call <vscale x 1 x half> @llvm.copysign.nxv1f16(<vscale x 1 x half> %vm, <vscale x 1 x half> %eneg)
  ret <vscale x 1 x half> %r
}

declare <vscale x 2 x half> @llvm.copysign.nxv2f16(<vscale x 2 x half>, <vscale x 2 x half>)

define <vscale x 2 x half> @vfcopysign_vv_nxv2f16(<vscale x 2 x half> %vm, <vscale x 2 x half> %vs) {
; ZVFH-LABEL: vfcopysign_vv_nxv2f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFH-NEXT:    vfsgnj.vv v8, v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopysign_vv_nxv2f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    lui a0, 8
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vand.vx v9, v9, a0
; ZVFHMIN-NEXT:    addi a0, a0, -1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a0
; ZVFHMIN-NEXT:    vor.vv v8, v8, v9
; ZVFHMIN-NEXT:    ret
  %r = call <vscale x 2 x half> @llvm.copysign.nxv2f16(<vscale x 2 x half> %vm, <vscale x 2 x half> %vs)
  ret <vscale x 2 x half> %r
}

define <vscale x 2 x half> @vfcopysign_vf_nxv2f16(<vscale x 2 x half> %vm, half %s) {
; ZVFH-LABEL: vfcopysign_vf_nxv2f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFH-NEXT:    vfsgnj.vf v8, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopysign_vf_nxv2f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fmv.x.h a0, fa0
; ZVFHMIN-NEXT:    lui a1, 8
; ZVFHMIN-NEXT:    vsetvli a2, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vmv.v.x v9, a0
; ZVFHMIN-NEXT:    addi a0, a1, -1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a0
; ZVFHMIN-NEXT:    vand.vx v9, v9, a1
; ZVFHMIN-NEXT:    vor.vv v8, v8, v9
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %s, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %r = call <vscale x 2 x half> @llvm.copysign.nxv2f16(<vscale x 2 x half> %vm, <vscale x 2 x half> %splat)
  ret <vscale x 2 x half> %r
}

define <vscale x 2 x half> @vfcopynsign_vv_nxv2f16(<vscale x 2 x half> %vm, <vscale x 2 x half> %vs) {
; ZVFH-LABEL: vfcopynsign_vv_nxv2f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFH-NEXT:    vfsgnjn.vv v8, v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopynsign_vv_nxv2f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    lui a0, 8
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vxor.vx v9, v9, a0
; ZVFHMIN-NEXT:    vand.vx v9, v9, a0
; ZVFHMIN-NEXT:    addi a0, a0, -1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a0
; ZVFHMIN-NEXT:    vor.vv v8, v8, v9
; ZVFHMIN-NEXT:    ret
  %n = fneg <vscale x 2 x half> %vs
  %r = call <vscale x 2 x half> @llvm.copysign.nxv2f16(<vscale x 2 x half> %vm, <vscale x 2 x half> %n)
  ret <vscale x 2 x half> %r
}

define <vscale x 2 x half> @vfcopynsign_vf_nxv2f16(<vscale x 2 x half> %vm, half %s) {
; ZVFH-LABEL: vfcopynsign_vf_nxv2f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFH-NEXT:    vfsgnjn.vf v8, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopynsign_vf_nxv2f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fmv.x.h a0, fa0
; ZVFHMIN-NEXT:    lui a1, 8
; ZVFHMIN-NEXT:    vsetvli a2, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vmv.v.x v9, a0
; ZVFHMIN-NEXT:    addi a0, a1, -1
; ZVFHMIN-NEXT:    vxor.vx v9, v9, a1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a0
; ZVFHMIN-NEXT:    vand.vx v9, v9, a1
; ZVFHMIN-NEXT:    vor.vv v8, v8, v9
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %s, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %n = fneg <vscale x 2 x half> %splat
  %r = call <vscale x 2 x half> @llvm.copysign.nxv2f16(<vscale x 2 x half> %vm, <vscale x 2 x half> %n)
  ret <vscale x 2 x half> %r
}

declare <vscale x 4 x half> @llvm.copysign.nxv4f16(<vscale x 4 x half>, <vscale x 4 x half>)

define <vscale x 4 x half> @vfcopysign_vv_nxv4f16(<vscale x 4 x half> %vm, <vscale x 4 x half> %vs) {
; ZVFH-LABEL: vfcopysign_vv_nxv4f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFH-NEXT:    vfsgnj.vv v8, v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopysign_vv_nxv4f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    lui a0, 8
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vand.vx v9, v9, a0
; ZVFHMIN-NEXT:    addi a0, a0, -1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a0
; ZVFHMIN-NEXT:    vor.vv v8, v8, v9
; ZVFHMIN-NEXT:    ret
  %r = call <vscale x 4 x half> @llvm.copysign.nxv4f16(<vscale x 4 x half> %vm, <vscale x 4 x half> %vs)
  ret <vscale x 4 x half> %r
}

define <vscale x 4 x half> @vfcopysign_vf_nxv4f16(<vscale x 4 x half> %vm, half %s) {
; ZVFH-LABEL: vfcopysign_vf_nxv4f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFH-NEXT:    vfsgnj.vf v8, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopysign_vf_nxv4f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fmv.x.h a0, fa0
; ZVFHMIN-NEXT:    lui a1, 8
; ZVFHMIN-NEXT:    vsetvli a2, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vmv.v.x v9, a0
; ZVFHMIN-NEXT:    addi a0, a1, -1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a0
; ZVFHMIN-NEXT:    vand.vx v9, v9, a1
; ZVFHMIN-NEXT:    vor.vv v8, v8, v9
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %s, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %r = call <vscale x 4 x half> @llvm.copysign.nxv4f16(<vscale x 4 x half> %vm, <vscale x 4 x half> %splat)
  ret <vscale x 4 x half> %r
}

define <vscale x 4 x half> @vfcopynsign_vv_nxv4f16(<vscale x 4 x half> %vm, <vscale x 4 x half> %vs) {
; ZVFH-LABEL: vfcopynsign_vv_nxv4f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFH-NEXT:    vfsgnjn.vv v8, v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopynsign_vv_nxv4f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    lui a0, 8
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vxor.vx v9, v9, a0
; ZVFHMIN-NEXT:    vand.vx v9, v9, a0
; ZVFHMIN-NEXT:    addi a0, a0, -1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a0
; ZVFHMIN-NEXT:    vor.vv v8, v8, v9
; ZVFHMIN-NEXT:    ret
  %n = fneg <vscale x 4 x half> %vs
  %r = call <vscale x 4 x half> @llvm.copysign.nxv4f16(<vscale x 4 x half> %vm, <vscale x 4 x half> %n)
  ret <vscale x 4 x half> %r
}

define <vscale x 4 x half> @vfcopynsign_vf_nxv4f16(<vscale x 4 x half> %vm, half %s) {
; ZVFH-LABEL: vfcopynsign_vf_nxv4f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFH-NEXT:    vfsgnjn.vf v8, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopynsign_vf_nxv4f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fmv.x.h a0, fa0
; ZVFHMIN-NEXT:    lui a1, 8
; ZVFHMIN-NEXT:    vsetvli a2, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vmv.v.x v9, a0
; ZVFHMIN-NEXT:    addi a0, a1, -1
; ZVFHMIN-NEXT:    vxor.vx v9, v9, a1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a0
; ZVFHMIN-NEXT:    vand.vx v9, v9, a1
; ZVFHMIN-NEXT:    vor.vv v8, v8, v9
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %s, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %n = fneg <vscale x 4 x half> %splat
  %r = call <vscale x 4 x half> @llvm.copysign.nxv4f16(<vscale x 4 x half> %vm, <vscale x 4 x half> %n)
  ret <vscale x 4 x half> %r
}

declare <vscale x 8 x half> @llvm.copysign.nxv8f16(<vscale x 8 x half>, <vscale x 8 x half>)

define <vscale x 8 x half> @vfcopysign_vv_nxv8f16(<vscale x 8 x half> %vm, <vscale x 8 x half> %vs) {
; ZVFH-LABEL: vfcopysign_vv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfsgnj.vv v8, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopysign_vv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    lui a0, 8
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vand.vx v10, v10, a0
; ZVFHMIN-NEXT:    addi a0, a0, -1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a0
; ZVFHMIN-NEXT:    vor.vv v8, v8, v10
; ZVFHMIN-NEXT:    ret
  %r = call <vscale x 8 x half> @llvm.copysign.nxv8f16(<vscale x 8 x half> %vm, <vscale x 8 x half> %vs)
  ret <vscale x 8 x half> %r
}

define <vscale x 8 x half> @vfcopysign_vf_nxv8f16(<vscale x 8 x half> %vm, half %s) {
; ZVFH-LABEL: vfcopysign_vf_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfsgnj.vf v8, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopysign_vf_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fmv.x.h a0, fa0
; ZVFHMIN-NEXT:    lui a1, 8
; ZVFHMIN-NEXT:    vsetvli a2, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vmv.v.x v10, a0
; ZVFHMIN-NEXT:    addi a0, a1, -1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a0
; ZVFHMIN-NEXT:    vand.vx v10, v10, a1
; ZVFHMIN-NEXT:    vor.vv v8, v8, v10
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %s, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %r = call <vscale x 8 x half> @llvm.copysign.nxv8f16(<vscale x 8 x half> %vm, <vscale x 8 x half> %splat)
  ret <vscale x 8 x half> %r
}

define <vscale x 8 x half> @vfcopynsign_vv_nxv8f16(<vscale x 8 x half> %vm, <vscale x 8 x half> %vs) {
; ZVFH-LABEL: vfcopynsign_vv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfsgnjn.vv v8, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopynsign_vv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    lui a0, 8
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vxor.vx v10, v10, a0
; ZVFHMIN-NEXT:    vand.vx v10, v10, a0
; ZVFHMIN-NEXT:    addi a0, a0, -1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a0
; ZVFHMIN-NEXT:    vor.vv v8, v8, v10
; ZVFHMIN-NEXT:    ret
  %n = fneg <vscale x 8 x half> %vs
  %r = call <vscale x 8 x half> @llvm.copysign.nxv8f16(<vscale x 8 x half> %vm, <vscale x 8 x half> %n)
  ret <vscale x 8 x half> %r
}

define <vscale x 8 x half> @vfcopynsign_vf_nxv8f16(<vscale x 8 x half> %vm, half %s) {
; ZVFH-LABEL: vfcopynsign_vf_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfsgnjn.vf v8, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopynsign_vf_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fmv.x.h a0, fa0
; ZVFHMIN-NEXT:    lui a1, 8
; ZVFHMIN-NEXT:    vsetvli a2, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vmv.v.x v10, a0
; ZVFHMIN-NEXT:    addi a0, a1, -1
; ZVFHMIN-NEXT:    vxor.vx v10, v10, a1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a0
; ZVFHMIN-NEXT:    vand.vx v10, v10, a1
; ZVFHMIN-NEXT:    vor.vv v8, v8, v10
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %s, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %n = fneg <vscale x 8 x half> %splat
  %r = call <vscale x 8 x half> @llvm.copysign.nxv8f16(<vscale x 8 x half> %vm, <vscale x 8 x half> %n)
  ret <vscale x 8 x half> %r
}

define <vscale x 8 x half> @vfcopysign_exttrunc_vv_nxv8f16_nxv8f32(<vscale x 8 x half> %vm, <vscale x 8 x float> %vs) {
; ZVFH-LABEL: vfcopysign_exttrunc_vv_nxv8f16_nxv8f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfncvt.f.f.w v10, v12
; ZVFH-NEXT:    vfsgnj.vv v8, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopysign_exttrunc_vv_nxv8f16_nxv8f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    lui a0, 8
; ZVFHMIN-NEXT:    vand.vx v10, v10, a0
; ZVFHMIN-NEXT:    addi a0, a0, -1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a0
; ZVFHMIN-NEXT:    vor.vv v8, v8, v10
; ZVFHMIN-NEXT:    ret
  %e = fptrunc <vscale x 8 x float> %vs to <vscale x 8 x half>
  %r = call <vscale x 8 x half> @llvm.copysign.nxv8f16(<vscale x 8 x half> %vm, <vscale x 8 x half> %e)
  ret <vscale x 8 x half> %r
}

define <vscale x 8 x half> @vfcopysign_exttrunc_vf_nxv8f16_nxv8f32(<vscale x 8 x half> %vm, float %s) {
; ZVFH-LABEL: vfcopysign_exttrunc_vf_nxv8f16_nxv8f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; ZVFH-NEXT:    vfmv.v.f v12, fa0
; ZVFH-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfncvt.f.f.w v10, v12
; ZVFH-NEXT:    vfsgnj.vv v8, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopysign_exttrunc_vf_nxv8f16_nxv8f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa0
; ZVFHMIN-NEXT:    lui a0, 8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    addi a1, a0, -1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a1
; ZVFHMIN-NEXT:    vand.vx v10, v10, a0
; ZVFHMIN-NEXT:    vor.vv v8, v8, v10
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %s, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %esplat = fptrunc <vscale x 8 x float> %splat to <vscale x 8 x half>
  %r = call <vscale x 8 x half> @llvm.copysign.nxv8f16(<vscale x 8 x half> %vm, <vscale x 8 x half> %esplat)
  ret <vscale x 8 x half> %r
}

define <vscale x 8 x half> @vfcopynsign_exttrunc_vv_nxv8f16_nxv8f32(<vscale x 8 x half> %vm, <vscale x 8 x float> %vs) {
; ZVFH-LABEL: vfcopynsign_exttrunc_vv_nxv8f16_nxv8f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfncvt.f.f.w v10, v12
; ZVFH-NEXT:    vfsgnjn.vv v8, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopynsign_exttrunc_vv_nxv8f16_nxv8f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    lui a0, 8
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    addi a1, a0, -1
; ZVFHMIN-NEXT:    vxor.vx v10, v10, a0
; ZVFHMIN-NEXT:    vand.vx v8, v8, a1
; ZVFHMIN-NEXT:    vand.vx v10, v10, a0
; ZVFHMIN-NEXT:    vor.vv v8, v8, v10
; ZVFHMIN-NEXT:    ret
  %n = fneg <vscale x 8 x float> %vs
  %eneg = fptrunc <vscale x 8 x float> %n to <vscale x 8 x half>
  %r = call <vscale x 8 x half> @llvm.copysign.nxv8f16(<vscale x 8 x half> %vm, <vscale x 8 x half> %eneg)
  ret <vscale x 8 x half> %r
}

define <vscale x 8 x half> @vfcopynsign_exttrunc_vf_nxv8f16_nxv8f32(<vscale x 8 x half> %vm, float %s) {
; ZVFH-LABEL: vfcopynsign_exttrunc_vf_nxv8f16_nxv8f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; ZVFH-NEXT:    vfmv.v.f v12, fa0
; ZVFH-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfncvt.f.f.w v10, v12
; ZVFH-NEXT:    vfsgnjn.vv v8, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopynsign_exttrunc_vf_nxv8f16_nxv8f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa0
; ZVFHMIN-NEXT:    lui a0, 8
; ZVFHMIN-NEXT:    addi a1, a0, -1
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    vand.vx v8, v8, a1
; ZVFHMIN-NEXT:    vxor.vx v10, v10, a0
; ZVFHMIN-NEXT:    vand.vx v10, v10, a0
; ZVFHMIN-NEXT:    vor.vv v8, v8, v10
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %s, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %n = fneg <vscale x 8 x float> %splat
  %eneg = fptrunc <vscale x 8 x float> %n to <vscale x 8 x half>
  %r = call <vscale x 8 x half> @llvm.copysign.nxv8f16(<vscale x 8 x half> %vm, <vscale x 8 x half> %eneg)
  ret <vscale x 8 x half> %r
}

define <vscale x 8 x half> @vfcopysign_exttrunc_vv_nxv8f16_nxv8f64(<vscale x 8 x half> %vm, <vscale x 8 x double> %vs) {
; ZVFH-LABEL: vfcopysign_exttrunc_vv_nxv8f16_nxv8f64:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; ZVFH-NEXT:    vfncvt.rod.f.f.w v12, v16
; ZVFH-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfncvt.f.f.w v10, v12
; ZVFH-NEXT:    vfsgnj.vv v8, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopysign_exttrunc_vv_nxv8f16_nxv8f64:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.rod.f.f.w v12, v16
; ZVFHMIN-NEXT:    lui a0, 8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    addi a1, a0, -1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a1
; ZVFHMIN-NEXT:    vand.vx v10, v10, a0
; ZVFHMIN-NEXT:    vor.vv v8, v8, v10
; ZVFHMIN-NEXT:    ret
  %e = fptrunc <vscale x 8 x double> %vs to <vscale x 8 x half>
  %r = call <vscale x 8 x half> @llvm.copysign.nxv8f16(<vscale x 8 x half> %vm, <vscale x 8 x half> %e)
  ret <vscale x 8 x half> %r
}

define <vscale x 8 x half> @vfcopysign_exttrunc_vf_nxv8f16_nxv8f64(<vscale x 8 x half> %vm, double %s) {
; ZVFH-LABEL: vfcopysign_exttrunc_vf_nxv8f16_nxv8f64:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; ZVFH-NEXT:    vfmv.v.f v16, fa0
; ZVFH-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFH-NEXT:    vfncvt.rod.f.f.w v12, v16
; ZVFH-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfncvt.f.f.w v10, v12
; ZVFH-NEXT:    vfsgnj.vv v8, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopysign_exttrunc_vf_nxv8f16_nxv8f64:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v16, fa0
; ZVFHMIN-NEXT:    lui a0, 8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.rod.f.f.w v12, v16
; ZVFHMIN-NEXT:    addi a1, a0, -1
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    vand.vx v8, v8, a1
; ZVFHMIN-NEXT:    vand.vx v10, v10, a0
; ZVFHMIN-NEXT:    vor.vv v8, v8, v10
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %s, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %esplat = fptrunc <vscale x 8 x double> %splat to <vscale x 8 x half>
  %r = call <vscale x 8 x half> @llvm.copysign.nxv8f16(<vscale x 8 x half> %vm, <vscale x 8 x half> %esplat)
  ret <vscale x 8 x half> %r
}

define <vscale x 8 x half> @vfcopynsign_exttrunc_vv_nxv8f16_nxv8f64(<vscale x 8 x half> %vm, <vscale x 8 x double> %vs) {
; ZVFH-LABEL: vfcopynsign_exttrunc_vv_nxv8f16_nxv8f64:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; ZVFH-NEXT:    vfncvt.rod.f.f.w v12, v16
; ZVFH-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfncvt.f.f.w v10, v12
; ZVFH-NEXT:    vfsgnjn.vv v8, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopynsign_exttrunc_vv_nxv8f16_nxv8f64:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    lui a0, 8
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.rod.f.f.w v12, v16
; ZVFHMIN-NEXT:    addi a1, a0, -1
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    vand.vx v8, v8, a1
; ZVFHMIN-NEXT:    vxor.vx v10, v10, a0
; ZVFHMIN-NEXT:    vand.vx v10, v10, a0
; ZVFHMIN-NEXT:    vor.vv v8, v8, v10
; ZVFHMIN-NEXT:    ret
  %n = fneg <vscale x 8 x double> %vs
  %eneg = fptrunc <vscale x 8 x double> %n to <vscale x 8 x half>
  %r = call <vscale x 8 x half> @llvm.copysign.nxv8f16(<vscale x 8 x half> %vm, <vscale x 8 x half> %eneg)
  ret <vscale x 8 x half> %r
}

define <vscale x 8 x half> @vfcopynsign_exttrunc_vf_nxv8f16_nxv8f64(<vscale x 8 x half> %vm, double %s) {
; ZVFH-LABEL: vfcopynsign_exttrunc_vf_nxv8f16_nxv8f64:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; ZVFH-NEXT:    vfmv.v.f v16, fa0
; ZVFH-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFH-NEXT:    vfncvt.rod.f.f.w v12, v16
; ZVFH-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfncvt.f.f.w v10, v12
; ZVFH-NEXT:    vfsgnjn.vv v8, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopynsign_exttrunc_vf_nxv8f16_nxv8f64:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v16, fa0
; ZVFHMIN-NEXT:    lui a0, 8
; ZVFHMIN-NEXT:    addi a1, a0, -1
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.rod.f.f.w v12, v16
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vand.vx v8, v8, a1
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    vxor.vx v10, v10, a0
; ZVFHMIN-NEXT:    vand.vx v10, v10, a0
; ZVFHMIN-NEXT:    vor.vv v8, v8, v10
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %s, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %n = fneg <vscale x 8 x double> %splat
  %eneg = fptrunc <vscale x 8 x double> %n to <vscale x 8 x half>
  %r = call <vscale x 8 x half> @llvm.copysign.nxv8f16(<vscale x 8 x half> %vm, <vscale x 8 x half> %eneg)
  ret <vscale x 8 x half> %r
}

declare <vscale x 16 x half> @llvm.copysign.nxv16f16(<vscale x 16 x half>, <vscale x 16 x half>)

define <vscale x 16 x half> @vfcopysign_vv_nxv16f16(<vscale x 16 x half> %vm, <vscale x 16 x half> %vs) {
; ZVFH-LABEL: vfcopysign_vv_nxv16f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFH-NEXT:    vfsgnj.vv v8, v8, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopysign_vv_nxv16f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    lui a0, 8
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vand.vx v12, v12, a0
; ZVFHMIN-NEXT:    addi a0, a0, -1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a0
; ZVFHMIN-NEXT:    vor.vv v8, v8, v12
; ZVFHMIN-NEXT:    ret
  %r = call <vscale x 16 x half> @llvm.copysign.nxv16f16(<vscale x 16 x half> %vm, <vscale x 16 x half> %vs)
  ret <vscale x 16 x half> %r
}

define <vscale x 16 x half> @vfcopysign_vf_nxv16f16(<vscale x 16 x half> %vm, half %s) {
; ZVFH-LABEL: vfcopysign_vf_nxv16f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFH-NEXT:    vfsgnj.vf v8, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopysign_vf_nxv16f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fmv.x.h a0, fa0
; ZVFHMIN-NEXT:    lui a1, 8
; ZVFHMIN-NEXT:    vsetvli a2, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vmv.v.x v12, a0
; ZVFHMIN-NEXT:    addi a0, a1, -1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a0
; ZVFHMIN-NEXT:    vand.vx v12, v12, a1
; ZVFHMIN-NEXT:    vor.vv v8, v8, v12
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %s, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %r = call <vscale x 16 x half> @llvm.copysign.nxv16f16(<vscale x 16 x half> %vm, <vscale x 16 x half> %splat)
  ret <vscale x 16 x half> %r
}

define <vscale x 16 x half> @vfcopynsign_vv_nxv16f16(<vscale x 16 x half> %vm, <vscale x 16 x half> %vs) {
; ZVFH-LABEL: vfcopynsign_vv_nxv16f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFH-NEXT:    vfsgnjn.vv v8, v8, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopynsign_vv_nxv16f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    lui a0, 8
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vxor.vx v12, v12, a0
; ZVFHMIN-NEXT:    vand.vx v12, v12, a0
; ZVFHMIN-NEXT:    addi a0, a0, -1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a0
; ZVFHMIN-NEXT:    vor.vv v8, v8, v12
; ZVFHMIN-NEXT:    ret
  %n = fneg <vscale x 16 x half> %vs
  %r = call <vscale x 16 x half> @llvm.copysign.nxv16f16(<vscale x 16 x half> %vm, <vscale x 16 x half> %n)
  ret <vscale x 16 x half> %r
}

define <vscale x 16 x half> @vfcopynsign_vf_nxv16f16(<vscale x 16 x half> %vm, half %s) {
; ZVFH-LABEL: vfcopynsign_vf_nxv16f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFH-NEXT:    vfsgnjn.vf v8, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopynsign_vf_nxv16f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fmv.x.h a0, fa0
; ZVFHMIN-NEXT:    lui a1, 8
; ZVFHMIN-NEXT:    vsetvli a2, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vmv.v.x v12, a0
; ZVFHMIN-NEXT:    addi a0, a1, -1
; ZVFHMIN-NEXT:    vxor.vx v12, v12, a1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a0
; ZVFHMIN-NEXT:    vand.vx v12, v12, a1
; ZVFHMIN-NEXT:    vor.vv v8, v8, v12
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %s, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %n = fneg <vscale x 16 x half> %splat
  %r = call <vscale x 16 x half> @llvm.copysign.nxv16f16(<vscale x 16 x half> %vm, <vscale x 16 x half> %n)
  ret <vscale x 16 x half> %r
}

declare <vscale x 32 x half> @llvm.copysign.nxv32f16(<vscale x 32 x half>, <vscale x 32 x half>)

define <vscale x 32 x half> @vfcopysign_vv_nxv32f16(<vscale x 32 x half> %vm, <vscale x 32 x half> %vs) {
; ZVFH-LABEL: vfcopysign_vv_nxv32f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; ZVFH-NEXT:    vfsgnj.vv v8, v8, v16
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopysign_vv_nxv32f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    lui a0, 8
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m8, ta, ma
; ZVFHMIN-NEXT:    vand.vx v16, v16, a0
; ZVFHMIN-NEXT:    addi a0, a0, -1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a0
; ZVFHMIN-NEXT:    vor.vv v8, v8, v16
; ZVFHMIN-NEXT:    ret
  %r = call <vscale x 32 x half> @llvm.copysign.nxv32f16(<vscale x 32 x half> %vm, <vscale x 32 x half> %vs)
  ret <vscale x 32 x half> %r
}

define <vscale x 32 x half> @vfcopysign_vf_nxv32f16(<vscale x 32 x half> %vm, half %s) {
; ZVFH-LABEL: vfcopysign_vf_nxv32f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; ZVFH-NEXT:    vfsgnj.vf v8, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopysign_vf_nxv32f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fmv.x.h a0, fa0
; ZVFHMIN-NEXT:    lui a1, 8
; ZVFHMIN-NEXT:    vsetvli a2, zero, e16, m8, ta, ma
; ZVFHMIN-NEXT:    vmv.v.x v16, a0
; ZVFHMIN-NEXT:    addi a0, a1, -1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a0
; ZVFHMIN-NEXT:    vand.vx v16, v16, a1
; ZVFHMIN-NEXT:    vor.vv v8, v8, v16
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 32 x half> poison, half %s, i32 0
  %splat = shufflevector <vscale x 32 x half> %head, <vscale x 32 x half> poison, <vscale x 32 x i32> zeroinitializer
  %r = call <vscale x 32 x half> @llvm.copysign.nxv32f16(<vscale x 32 x half> %vm, <vscale x 32 x half> %splat)
  ret <vscale x 32 x half> %r
}

define <vscale x 32 x half> @vfcopynsign_vv_nxv32f16(<vscale x 32 x half> %vm, <vscale x 32 x half> %vs) {
; ZVFH-LABEL: vfcopynsign_vv_nxv32f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; ZVFH-NEXT:    vfsgnjn.vv v8, v8, v16
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopynsign_vv_nxv32f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    lui a0, 8
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m8, ta, ma
; ZVFHMIN-NEXT:    vxor.vx v16, v16, a0
; ZVFHMIN-NEXT:    vand.vx v16, v16, a0
; ZVFHMIN-NEXT:    addi a0, a0, -1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a0
; ZVFHMIN-NEXT:    vor.vv v8, v8, v16
; ZVFHMIN-NEXT:    ret
  %n = fneg <vscale x 32 x half> %vs
  %r = call <vscale x 32 x half> @llvm.copysign.nxv32f16(<vscale x 32 x half> %vm, <vscale x 32 x half> %n)
  ret <vscale x 32 x half> %r
}

define <vscale x 32 x half> @vfcopynsign_vf_nxv32f16(<vscale x 32 x half> %vm, half %s) {
; ZVFH-LABEL: vfcopynsign_vf_nxv32f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; ZVFH-NEXT:    vfsgnjn.vf v8, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfcopynsign_vf_nxv32f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fmv.x.h a0, fa0
; ZVFHMIN-NEXT:    lui a1, 8
; ZVFHMIN-NEXT:    vsetvli a2, zero, e16, m8, ta, ma
; ZVFHMIN-NEXT:    vmv.v.x v16, a0
; ZVFHMIN-NEXT:    addi a0, a1, -1
; ZVFHMIN-NEXT:    vxor.vx v16, v16, a1
; ZVFHMIN-NEXT:    vand.vx v8, v8, a0
; ZVFHMIN-NEXT:    vand.vx v16, v16, a1
; ZVFHMIN-NEXT:    vor.vv v8, v8, v16
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 32 x half> poison, half %s, i32 0
  %splat = shufflevector <vscale x 32 x half> %head, <vscale x 32 x half> poison, <vscale x 32 x i32> zeroinitializer
  %n = fneg <vscale x 32 x half> %splat
  %r = call <vscale x 32 x half> @llvm.copysign.nxv32f16(<vscale x 32 x half> %vm, <vscale x 32 x half> %n)
  ret <vscale x 32 x half> %r
}

declare <vscale x 1 x float> @llvm.copysign.nxv1f32(<vscale x 1 x float>, <vscale x 1 x float>)

define <vscale x 1 x float> @vfcopysign_vv_nxv1f32(<vscale x 1 x float> %vm, <vscale x 1 x float> %vs) {
; CHECK-LABEL: vfcopysign_vv_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfsgnj.vv v8, v8, v9
; CHECK-NEXT:    ret
  %r = call <vscale x 1 x float> @llvm.copysign.nxv1f32(<vscale x 1 x float> %vm, <vscale x 1 x float> %vs)
  ret <vscale x 1 x float> %r
}

define <vscale x 1 x float> @vfcopysign_vf_nxv1f32(<vscale x 1 x float> %vm, float %s) {
; CHECK-LABEL: vfcopysign_vf_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %s, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %r = call <vscale x 1 x float> @llvm.copysign.nxv1f32(<vscale x 1 x float> %vm, <vscale x 1 x float> %splat)
  ret <vscale x 1 x float> %r
}

define <vscale x 1 x float> @vfcopynsign_vv_nxv1f32(<vscale x 1 x float> %vm, <vscale x 1 x float> %vs) {
; CHECK-LABEL: vfcopynsign_vv_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v9
; CHECK-NEXT:    ret
  %n = fneg <vscale x 1 x float> %vs
  %r = call <vscale x 1 x float> @llvm.copysign.nxv1f32(<vscale x 1 x float> %vm, <vscale x 1 x float> %n)
  ret <vscale x 1 x float> %r
}

define <vscale x 1 x float> @vfcopynsign_vf_nxv1f32(<vscale x 1 x float> %vm, float %s) {
; CHECK-LABEL: vfcopynsign_vf_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfsgnjn.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %s, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %n = fneg <vscale x 1 x float> %splat
  %r = call <vscale x 1 x float> @llvm.copysign.nxv1f32(<vscale x 1 x float> %vm, <vscale x 1 x float> %n)
  ret <vscale x 1 x float> %r
}

define <vscale x 1 x float> @vfcopysign_exttrunc_vv_nxv1f32_nxv1f16(<vscale x 1 x float> %vm, <vscale x 1 x half> %vs) {
; CHECK-LABEL: vfcopysign_exttrunc_vv_nxv1f32_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v10, v9
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfsgnj.vv v8, v8, v10
; CHECK-NEXT:    ret
  %e = fpext <vscale x 1 x half> %vs to <vscale x 1 x float>
  %r = call <vscale x 1 x float> @llvm.copysign.nxv1f32(<vscale x 1 x float> %vm, <vscale x 1 x float> %e)
  ret <vscale x 1 x float> %r
}

define <vscale x 1 x float> @vfcopysign_exttrunc_vf_nxv1f32_nxv1f16(<vscale x 1 x float> %vm, half %s) {
; CHECK-LABEL: vfcopysign_exttrunc_vf_nxv1f32_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.h fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %s, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %esplat = fpext <vscale x 1 x half> %splat to <vscale x 1 x float>
  %r = call <vscale x 1 x float> @llvm.copysign.nxv1f32(<vscale x 1 x float> %vm, <vscale x 1 x float> %esplat)
  ret <vscale x 1 x float> %r
}

define <vscale x 1 x float> @vfcopynsign_exttrunc_vv_nxv1f32_nxv1f16(<vscale x 1 x float> %vm, <vscale x 1 x half> %vs) {
; CHECK-LABEL: vfcopynsign_exttrunc_vv_nxv1f32_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v10, v9
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v10
; CHECK-NEXT:    ret
  %n = fneg <vscale x 1 x half> %vs
  %eneg = fpext <vscale x 1 x half> %n to <vscale x 1 x float>
  %r = call <vscale x 1 x float> @llvm.copysign.nxv1f32(<vscale x 1 x float> %vm, <vscale x 1 x float> %eneg)
  ret <vscale x 1 x float> %r
}

define <vscale x 1 x float> @vfcopynsign_exttrunc_vf_nxv1f32_nxv1f16(<vscale x 1 x float> %vm, half %s) {
; CHECK-LABEL: vfcopynsign_exttrunc_vf_nxv1f32_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.h fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfsgnjn.vf v8, v8, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %s, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %n = fneg <vscale x 1 x half> %splat
  %eneg = fpext <vscale x 1 x half> %n to <vscale x 1 x float>
  %r = call <vscale x 1 x float> @llvm.copysign.nxv1f32(<vscale x 1 x float> %vm, <vscale x 1 x float> %eneg)
  ret <vscale x 1 x float> %r
}

define <vscale x 1 x float> @vfcopysign_exttrunc_vv_nxv1f32_nxv1f64(<vscale x 1 x float> %vm, <vscale x 1 x double> %vs) {
; CHECK-LABEL: vfcopysign_exttrunc_vv_nxv1f32_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v10, v9
; CHECK-NEXT:    vfsgnj.vv v8, v8, v10
; CHECK-NEXT:    ret
  %e = fptrunc <vscale x 1 x double> %vs to <vscale x 1 x float>
  %r = call <vscale x 1 x float> @llvm.copysign.nxv1f32(<vscale x 1 x float> %vm, <vscale x 1 x float> %e)
  ret <vscale x 1 x float> %r
}

define <vscale x 1 x float> @vfcopysign_exttrunc_vf_nxv1f32_nxv1f64(<vscale x 1 x float> %vm, double %s) {
; CHECK-LABEL: vfcopysign_exttrunc_vf_nxv1f32_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v10, v9
; CHECK-NEXT:    vfsgnj.vv v8, v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %s, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %esplat = fptrunc <vscale x 1 x double> %splat to <vscale x 1 x float>
  %r = call <vscale x 1 x float> @llvm.copysign.nxv1f32(<vscale x 1 x float> %vm, <vscale x 1 x float> %esplat)
  ret <vscale x 1 x float> %r
}

define <vscale x 1 x float> @vfcopynsign_exttrunc_vv_nxv1f32_nxv1f64(<vscale x 1 x float> %vm, <vscale x 1 x double> %vs) {
; CHECK-LABEL: vfcopynsign_exttrunc_vv_nxv1f32_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v10, v9
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v10
; CHECK-NEXT:    ret
  %n = fneg <vscale x 1 x double> %vs
  %eneg = fptrunc <vscale x 1 x double> %n to <vscale x 1 x float>
  %r = call <vscale x 1 x float> @llvm.copysign.nxv1f32(<vscale x 1 x float> %vm, <vscale x 1 x float> %eneg)
  ret <vscale x 1 x float> %r
}

define <vscale x 1 x float> @vfcopynsign_exttrunc_vf_nxv1f32_nxv1f64(<vscale x 1 x float> %vm, double %s) {
; CHECK-LABEL: vfcopynsign_exttrunc_vf_nxv1f32_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v10, v9
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %s, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %n = fneg <vscale x 1 x double> %splat
  %eneg = fptrunc <vscale x 1 x double> %n to <vscale x 1 x float>
  %r = call <vscale x 1 x float> @llvm.copysign.nxv1f32(<vscale x 1 x float> %vm, <vscale x 1 x float> %eneg)
  ret <vscale x 1 x float> %r
}

declare <vscale x 2 x float> @llvm.copysign.nxv2f32(<vscale x 2 x float>, <vscale x 2 x float>)

define <vscale x 2 x float> @vfcopysign_vv_nxv2f32(<vscale x 2 x float> %vm, <vscale x 2 x float> %vs) {
; CHECK-LABEL: vfcopysign_vv_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfsgnj.vv v8, v8, v9
; CHECK-NEXT:    ret
  %r = call <vscale x 2 x float> @llvm.copysign.nxv2f32(<vscale x 2 x float> %vm, <vscale x 2 x float> %vs)
  ret <vscale x 2 x float> %r
}

define <vscale x 2 x float> @vfcopysign_vf_nxv2f32(<vscale x 2 x float> %vm, float %s) {
; CHECK-LABEL: vfcopysign_vf_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %s, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %r = call <vscale x 2 x float> @llvm.copysign.nxv2f32(<vscale x 2 x float> %vm, <vscale x 2 x float> %splat)
  ret <vscale x 2 x float> %r
}

define <vscale x 2 x float> @vfcopynsign_vv_nxv2f32(<vscale x 2 x float> %vm, <vscale x 2 x float> %vs) {
; CHECK-LABEL: vfcopynsign_vv_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v9
; CHECK-NEXT:    ret
  %n = fneg <vscale x 2 x float> %vs
  %r = call <vscale x 2 x float> @llvm.copysign.nxv2f32(<vscale x 2 x float> %vm, <vscale x 2 x float> %n)
  ret <vscale x 2 x float> %r
}

define <vscale x 2 x float> @vfcopynsign_vf_nxv2f32(<vscale x 2 x float> %vm, float %s) {
; CHECK-LABEL: vfcopynsign_vf_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfsgnjn.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %s, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %n = fneg <vscale x 2 x float> %splat
  %r = call <vscale x 2 x float> @llvm.copysign.nxv2f32(<vscale x 2 x float> %vm, <vscale x 2 x float> %n)
  ret <vscale x 2 x float> %r
}

declare <vscale x 4 x float> @llvm.copysign.nxv4f32(<vscale x 4 x float>, <vscale x 4 x float>)

define <vscale x 4 x float> @vfcopysign_vv_nxv4f32(<vscale x 4 x float> %vm, <vscale x 4 x float> %vs) {
; CHECK-LABEL: vfcopysign_vv_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfsgnj.vv v8, v8, v10
; CHECK-NEXT:    ret
  %r = call <vscale x 4 x float> @llvm.copysign.nxv4f32(<vscale x 4 x float> %vm, <vscale x 4 x float> %vs)
  ret <vscale x 4 x float> %r
}

define <vscale x 4 x float> @vfcopysign_vf_nxv4f32(<vscale x 4 x float> %vm, float %s) {
; CHECK-LABEL: vfcopysign_vf_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %s, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %r = call <vscale x 4 x float> @llvm.copysign.nxv4f32(<vscale x 4 x float> %vm, <vscale x 4 x float> %splat)
  ret <vscale x 4 x float> %r
}

define <vscale x 4 x float> @vfcopynsign_vv_nxv4f32(<vscale x 4 x float> %vm, <vscale x 4 x float> %vs) {
; CHECK-LABEL: vfcopynsign_vv_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v10
; CHECK-NEXT:    ret
  %n = fneg <vscale x 4 x float> %vs
  %r = call <vscale x 4 x float> @llvm.copysign.nxv4f32(<vscale x 4 x float> %vm, <vscale x 4 x float> %n)
  ret <vscale x 4 x float> %r
}

define <vscale x 4 x float> @vfcopynsign_vf_nxv4f32(<vscale x 4 x float> %vm, float %s) {
; CHECK-LABEL: vfcopynsign_vf_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfsgnjn.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %s, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %n = fneg <vscale x 4 x float> %splat
  %r = call <vscale x 4 x float> @llvm.copysign.nxv4f32(<vscale x 4 x float> %vm, <vscale x 4 x float> %n)
  ret <vscale x 4 x float> %r
}

declare <vscale x 8 x float> @llvm.copysign.nxv8f32(<vscale x 8 x float>, <vscale x 8 x float>)

define <vscale x 8 x float> @vfcopysign_vv_nxv8f32(<vscale x 8 x float> %vm, <vscale x 8 x float> %vs) {
; CHECK-LABEL: vfcopysign_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfsgnj.vv v8, v8, v12
; CHECK-NEXT:    ret
  %r = call <vscale x 8 x float> @llvm.copysign.nxv8f32(<vscale x 8 x float> %vm, <vscale x 8 x float> %vs)
  ret <vscale x 8 x float> %r
}

define <vscale x 8 x float> @vfcopysign_vf_nxv8f32(<vscale x 8 x float> %vm, float %s) {
; CHECK-LABEL: vfcopysign_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %s, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %r = call <vscale x 8 x float> @llvm.copysign.nxv8f32(<vscale x 8 x float> %vm, <vscale x 8 x float> %splat)
  ret <vscale x 8 x float> %r
}

define <vscale x 8 x float> @vfcopynsign_vv_nxv8f32(<vscale x 8 x float> %vm, <vscale x 8 x float> %vs) {
; CHECK-LABEL: vfcopynsign_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v12
; CHECK-NEXT:    ret
  %n = fneg <vscale x 8 x float> %vs
  %r = call <vscale x 8 x float> @llvm.copysign.nxv8f32(<vscale x 8 x float> %vm, <vscale x 8 x float> %n)
  ret <vscale x 8 x float> %r
}

define <vscale x 8 x float> @vfcopynsign_vf_nxv8f32(<vscale x 8 x float> %vm, float %s) {
; CHECK-LABEL: vfcopynsign_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfsgnjn.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %s, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %n = fneg <vscale x 8 x float> %splat
  %r = call <vscale x 8 x float> @llvm.copysign.nxv8f32(<vscale x 8 x float> %vm, <vscale x 8 x float> %n)
  ret <vscale x 8 x float> %r
}

define <vscale x 8 x float> @vfcopysign_exttrunc_vv_nxv8f32_nxv8f16(<vscale x 8 x float> %vm, <vscale x 8 x half> %vs) {
; CHECK-LABEL: vfcopysign_exttrunc_vv_nxv8f32_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v16, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfsgnj.vv v8, v8, v16
; CHECK-NEXT:    ret
  %e = fpext <vscale x 8 x half> %vs to <vscale x 8 x float>
  %r = call <vscale x 8 x float> @llvm.copysign.nxv8f32(<vscale x 8 x float> %vm, <vscale x 8 x float> %e)
  ret <vscale x 8 x float> %r
}

define <vscale x 8 x float> @vfcopysign_exttrunc_vf_nxv8f32_nxv8f16(<vscale x 8 x float> %vm, half %s) {
; CHECK-LABEL: vfcopysign_exttrunc_vf_nxv8f32_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.h fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %s, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %esplat = fpext <vscale x 8 x half> %splat to <vscale x 8 x float>
  %r = call <vscale x 8 x float> @llvm.copysign.nxv8f32(<vscale x 8 x float> %vm, <vscale x 8 x float> %esplat)
  ret <vscale x 8 x float> %r
}

define <vscale x 8 x float> @vfcopynsign_exttrunc_vv_nxv8f32_nxv8f16(<vscale x 8 x float> %vm, <vscale x 8 x half> %vs) {
; CHECK-LABEL: vfcopynsign_exttrunc_vv_nxv8f32_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v16, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v16
; CHECK-NEXT:    ret
  %n = fneg <vscale x 8 x half> %vs
  %eneg = fpext <vscale x 8 x half> %n to <vscale x 8 x float>
  %r = call <vscale x 8 x float> @llvm.copysign.nxv8f32(<vscale x 8 x float> %vm, <vscale x 8 x float> %eneg)
  ret <vscale x 8 x float> %r
}

define <vscale x 8 x float> @vfcopynsign_exttrunc_vf_nxv8f32_nxv8f16(<vscale x 8 x float> %vm, half %s) {
; CHECK-LABEL: vfcopynsign_exttrunc_vf_nxv8f32_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.h fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfsgnjn.vf v8, v8, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %s, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %n = fneg <vscale x 8 x half> %splat
  %eneg = fpext <vscale x 8 x half> %n to <vscale x 8 x float>
  %r = call <vscale x 8 x float> @llvm.copysign.nxv8f32(<vscale x 8 x float> %vm, <vscale x 8 x float> %eneg)
  ret <vscale x 8 x float> %r
}

define <vscale x 8 x float> @vfcopysign_exttrunc_vv_nxv8f32_nxv8f64(<vscale x 8 x float> %vm, <vscale x 8 x double> %vs) {
; CHECK-LABEL: vfcopysign_exttrunc_vv_nxv8f32_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v12, v16
; CHECK-NEXT:    vfsgnj.vv v8, v8, v12
; CHECK-NEXT:    ret
  %e = fptrunc <vscale x 8 x double> %vs to <vscale x 8 x float>
  %r = call <vscale x 8 x float> @llvm.copysign.nxv8f32(<vscale x 8 x float> %vm, <vscale x 8 x float> %e)
  ret <vscale x 8 x float> %r
}

define <vscale x 8 x float> @vfcopysign_exttrunc_vf_nxv8f32_nxv8f64(<vscale x 8 x float> %vm, double %s) {
; CHECK-LABEL: vfcopysign_exttrunc_vf_nxv8f32_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v12, v16
; CHECK-NEXT:    vfsgnj.vv v8, v8, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %s, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %esplat = fptrunc <vscale x 8 x double> %splat to <vscale x 8 x float>
  %r = call <vscale x 8 x float> @llvm.copysign.nxv8f32(<vscale x 8 x float> %vm, <vscale x 8 x float> %esplat)
  ret <vscale x 8 x float> %r
}

define <vscale x 8 x float> @vfcopynsign_exttrunc_vv_nxv8f32_nxv8f64(<vscale x 8 x float> %vm, <vscale x 8 x double> %vs) {
; CHECK-LABEL: vfcopynsign_exttrunc_vv_nxv8f32_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v12, v16
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v12
; CHECK-NEXT:    ret
  %n = fneg <vscale x 8 x double> %vs
  %eneg = fptrunc <vscale x 8 x double> %n to <vscale x 8 x float>
  %r = call <vscale x 8 x float> @llvm.copysign.nxv8f32(<vscale x 8 x float> %vm, <vscale x 8 x float> %eneg)
  ret <vscale x 8 x float> %r
}

define <vscale x 8 x float> @vfcopynsign_exttrunc_vf_nxv8f32_nxv8f64(<vscale x 8 x float> %vm, double %s) {
; CHECK-LABEL: vfcopynsign_exttrunc_vf_nxv8f32_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v12, v16
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %s, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %n = fneg <vscale x 8 x double> %splat
  %eneg = fptrunc <vscale x 8 x double> %n to <vscale x 8 x float>
  %r = call <vscale x 8 x float> @llvm.copysign.nxv8f32(<vscale x 8 x float> %vm, <vscale x 8 x float> %eneg)
  ret <vscale x 8 x float> %r
}

declare <vscale x 16 x float> @llvm.copysign.nxv16f32(<vscale x 16 x float>, <vscale x 16 x float>)

define <vscale x 16 x float> @vfcopysign_vv_nxv16f32(<vscale x 16 x float> %vm, <vscale x 16 x float> %vs) {
; CHECK-LABEL: vfcopysign_vv_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfsgnj.vv v8, v8, v16
; CHECK-NEXT:    ret
  %r = call <vscale x 16 x float> @llvm.copysign.nxv16f32(<vscale x 16 x float> %vm, <vscale x 16 x float> %vs)
  ret <vscale x 16 x float> %r
}

define <vscale x 16 x float> @vfcopysign_vf_nxv16f32(<vscale x 16 x float> %vm, float %s) {
; CHECK-LABEL: vfcopysign_vf_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x float> poison, float %s, i32 0
  %splat = shufflevector <vscale x 16 x float> %head, <vscale x 16 x float> poison, <vscale x 16 x i32> zeroinitializer
  %r = call <vscale x 16 x float> @llvm.copysign.nxv16f32(<vscale x 16 x float> %vm, <vscale x 16 x float> %splat)
  ret <vscale x 16 x float> %r
}

define <vscale x 16 x float> @vfcopynsign_vv_nxv16f32(<vscale x 16 x float> %vm, <vscale x 16 x float> %vs) {
; CHECK-LABEL: vfcopynsign_vv_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v16
; CHECK-NEXT:    ret
  %n = fneg <vscale x 16 x float> %vs
  %r = call <vscale x 16 x float> @llvm.copysign.nxv16f32(<vscale x 16 x float> %vm, <vscale x 16 x float> %n)
  ret <vscale x 16 x float> %r
}

define <vscale x 16 x float> @vfcopynsign_vf_nxv16f32(<vscale x 16 x float> %vm, float %s) {
; CHECK-LABEL: vfcopynsign_vf_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfsgnjn.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x float> poison, float %s, i32 0
  %splat = shufflevector <vscale x 16 x float> %head, <vscale x 16 x float> poison, <vscale x 16 x i32> zeroinitializer
  %n = fneg <vscale x 16 x float> %splat
  %r = call <vscale x 16 x float> @llvm.copysign.nxv16f32(<vscale x 16 x float> %vm, <vscale x 16 x float> %n)
  ret <vscale x 16 x float> %r
}

declare <vscale x 1 x double> @llvm.copysign.nxv1f64(<vscale x 1 x double>, <vscale x 1 x double>)

define <vscale x 1 x double> @vfcopysign_vv_nxv1f64(<vscale x 1 x double> %vm, <vscale x 1 x double> %vs) {
; CHECK-LABEL: vfcopysign_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfsgnj.vv v8, v8, v9
; CHECK-NEXT:    ret
  %r = call <vscale x 1 x double> @llvm.copysign.nxv1f64(<vscale x 1 x double> %vm, <vscale x 1 x double> %vs)
  ret <vscale x 1 x double> %r
}

define <vscale x 1 x double> @vfcopysign_vf_nxv1f64(<vscale x 1 x double> %vm, double %s) {
; CHECK-LABEL: vfcopysign_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %s, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %r = call <vscale x 1 x double> @llvm.copysign.nxv1f64(<vscale x 1 x double> %vm, <vscale x 1 x double> %splat)
  ret <vscale x 1 x double> %r
}

define <vscale x 1 x double> @vfcopynsign_vv_nxv1f64(<vscale x 1 x double> %vm, <vscale x 1 x double> %vs) {
; CHECK-LABEL: vfcopynsign_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v9
; CHECK-NEXT:    ret
  %n = fneg <vscale x 1 x double> %vs
  %r = call <vscale x 1 x double> @llvm.copysign.nxv1f64(<vscale x 1 x double> %vm, <vscale x 1 x double> %n)
  ret <vscale x 1 x double> %r
}

define <vscale x 1 x double> @vfcopynsign_vf_nxv1f64(<vscale x 1 x double> %vm, double %s) {
; CHECK-LABEL: vfcopynsign_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfsgnjn.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %s, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %n = fneg <vscale x 1 x double> %splat
  %r = call <vscale x 1 x double> @llvm.copysign.nxv1f64(<vscale x 1 x double> %vm, <vscale x 1 x double> %n)
  ret <vscale x 1 x double> %r
}

define <vscale x 1 x double> @vfcopysign_exttrunc_vv_nxv1f64_nxv1f16(<vscale x 1 x double> %vm, <vscale x 1 x half> %vs) {
; CHECK-LABEL: vfcopysign_exttrunc_vv_nxv1f64_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v10, v9
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v9, v10
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfsgnj.vv v8, v8, v9
; CHECK-NEXT:    ret
  %e = fpext <vscale x 1 x half> %vs to <vscale x 1 x double>
  %r = call <vscale x 1 x double> @llvm.copysign.nxv1f64(<vscale x 1 x double> %vm, <vscale x 1 x double> %e)
  ret <vscale x 1 x double> %r
}

define <vscale x 1 x double> @vfcopysign_exttrunc_vf_nxv1f64_nxv1f16(<vscale x 1 x double> %vm, half %s) {
; CHECK-LABEL: vfcopysign_exttrunc_vf_nxv1f64_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.d.h fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %s, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %esplat = fpext <vscale x 1 x half> %splat to <vscale x 1 x double>
  %r = call <vscale x 1 x double> @llvm.copysign.nxv1f64(<vscale x 1 x double> %vm, <vscale x 1 x double> %esplat)
  ret <vscale x 1 x double> %r
}

define <vscale x 1 x double> @vfcopynsign_exttrunc_vv_nxv1f64_nxv1f16(<vscale x 1 x double> %vm, <vscale x 1 x half> %vs) {
; CHECK-LABEL: vfcopynsign_exttrunc_vv_nxv1f64_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v10, v9
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v9, v10
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v9
; CHECK-NEXT:    ret
  %n = fneg <vscale x 1 x half> %vs
  %eneg = fpext <vscale x 1 x half> %n to <vscale x 1 x double>
  %r = call <vscale x 1 x double> @llvm.copysign.nxv1f64(<vscale x 1 x double> %vm, <vscale x 1 x double> %eneg)
  ret <vscale x 1 x double> %r
}

define <vscale x 1 x double> @vfcopynsign_exttrunc_vf_nxv1f64_nxv1f16(<vscale x 1 x double> %vm, half %s) {
; CHECK-LABEL: vfcopynsign_exttrunc_vf_nxv1f64_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.d.h fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfsgnjn.vf v8, v8, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %s, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %n = fneg <vscale x 1 x half> %splat
  %eneg = fpext <vscale x 1 x half> %n to <vscale x 1 x double>
  %r = call <vscale x 1 x double> @llvm.copysign.nxv1f64(<vscale x 1 x double> %vm, <vscale x 1 x double> %eneg)
  ret <vscale x 1 x double> %r
}

define <vscale x 1 x double> @vfcopysign_exttrunc_vv_nxv1f64_nxv1f32(<vscale x 1 x double> %vm, <vscale x 1 x float> %vs) {
; CHECK-LABEL: vfcopysign_exttrunc_vv_nxv1f64_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v10, v9
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfsgnj.vv v8, v8, v10
; CHECK-NEXT:    ret
  %e = fpext <vscale x 1 x float> %vs to <vscale x 1 x double>
  %r = call <vscale x 1 x double> @llvm.copysign.nxv1f64(<vscale x 1 x double> %vm, <vscale x 1 x double> %e)
  ret <vscale x 1 x double> %r
}

define <vscale x 1 x double> @vfcopysign_exttrunc_vf_nxv1f64_nxv1f32(<vscale x 1 x double> %vm, float %s) {
; CHECK-LABEL: vfcopysign_exttrunc_vf_nxv1f64_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.d.s fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %s, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %esplat = fpext <vscale x 1 x float> %splat to <vscale x 1 x double>
  %r = call <vscale x 1 x double> @llvm.copysign.nxv1f64(<vscale x 1 x double> %vm, <vscale x 1 x double> %esplat)
  ret <vscale x 1 x double> %r
}

define <vscale x 1 x double> @vfcopynsign_exttrunc_vv_nxv1f64_nxv1f32(<vscale x 1 x double> %vm, <vscale x 1 x float> %vs) {
; CHECK-LABEL: vfcopynsign_exttrunc_vv_nxv1f64_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v10, v9
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v10
; CHECK-NEXT:    ret
  %n = fneg <vscale x 1 x float> %vs
  %eneg = fpext <vscale x 1 x float> %n to <vscale x 1 x double>
  %r = call <vscale x 1 x double> @llvm.copysign.nxv1f64(<vscale x 1 x double> %vm, <vscale x 1 x double> %eneg)
  ret <vscale x 1 x double> %r
}

define <vscale x 1 x double> @vfcopynsign_exttrunc_vf_nxv1f64_nxv1f32(<vscale x 1 x double> %vm, float %s) {
; CHECK-LABEL: vfcopynsign_exttrunc_vf_nxv1f64_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.d.s fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfsgnjn.vf v8, v8, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %s, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %n = fneg <vscale x 1 x float> %splat
  %eneg = fpext <vscale x 1 x float> %n to <vscale x 1 x double>
  %r = call <vscale x 1 x double> @llvm.copysign.nxv1f64(<vscale x 1 x double> %vm, <vscale x 1 x double> %eneg)
  ret <vscale x 1 x double> %r
}

declare <vscale x 2 x double> @llvm.copysign.nxv2f64(<vscale x 2 x double>, <vscale x 2 x double>)

define <vscale x 2 x double> @vfcopysign_vv_nxv2f64(<vscale x 2 x double> %vm, <vscale x 2 x double> %vs) {
; CHECK-LABEL: vfcopysign_vv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vfsgnj.vv v8, v8, v10
; CHECK-NEXT:    ret
  %r = call <vscale x 2 x double> @llvm.copysign.nxv2f64(<vscale x 2 x double> %vm, <vscale x 2 x double> %vs)
  ret <vscale x 2 x double> %r
}

define <vscale x 2 x double> @vfcopysign_vf_nxv2f64(<vscale x 2 x double> %vm, double %s) {
; CHECK-LABEL: vfcopysign_vf_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x double> poison, double %s, i32 0
  %splat = shufflevector <vscale x 2 x double> %head, <vscale x 2 x double> poison, <vscale x 2 x i32> zeroinitializer
  %r = call <vscale x 2 x double> @llvm.copysign.nxv2f64(<vscale x 2 x double> %vm, <vscale x 2 x double> %splat)
  ret <vscale x 2 x double> %r
}

define <vscale x 2 x double> @vfcopynsign_vv_nxv2f64(<vscale x 2 x double> %vm, <vscale x 2 x double> %vs) {
; CHECK-LABEL: vfcopynsign_vv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v10
; CHECK-NEXT:    ret
  %n = fneg <vscale x 2 x double> %vs
  %r = call <vscale x 2 x double> @llvm.copysign.nxv2f64(<vscale x 2 x double> %vm, <vscale x 2 x double> %n)
  ret <vscale x 2 x double> %r
}

define <vscale x 2 x double> @vfcopynsign_vf_nxv2f64(<vscale x 2 x double> %vm, double %s) {
; CHECK-LABEL: vfcopynsign_vf_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vfsgnjn.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x double> poison, double %s, i32 0
  %splat = shufflevector <vscale x 2 x double> %head, <vscale x 2 x double> poison, <vscale x 2 x i32> zeroinitializer
  %n = fneg <vscale x 2 x double> %splat
  %r = call <vscale x 2 x double> @llvm.copysign.nxv2f64(<vscale x 2 x double> %vm, <vscale x 2 x double> %n)
  ret <vscale x 2 x double> %r
}

declare <vscale x 4 x double> @llvm.copysign.nxv4f64(<vscale x 4 x double>, <vscale x 4 x double>)

define <vscale x 4 x double> @vfcopysign_vv_nxv4f64(<vscale x 4 x double> %vm, <vscale x 4 x double> %vs) {
; CHECK-LABEL: vfcopysign_vv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vfsgnj.vv v8, v8, v12
; CHECK-NEXT:    ret
  %r = call <vscale x 4 x double> @llvm.copysign.nxv4f64(<vscale x 4 x double> %vm, <vscale x 4 x double> %vs)
  ret <vscale x 4 x double> %r
}

define <vscale x 4 x double> @vfcopysign_vf_nxv4f64(<vscale x 4 x double> %vm, double %s) {
; CHECK-LABEL: vfcopysign_vf_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x double> poison, double %s, i32 0
  %splat = shufflevector <vscale x 4 x double> %head, <vscale x 4 x double> poison, <vscale x 4 x i32> zeroinitializer
  %r = call <vscale x 4 x double> @llvm.copysign.nxv4f64(<vscale x 4 x double> %vm, <vscale x 4 x double> %splat)
  ret <vscale x 4 x double> %r
}

define <vscale x 4 x double> @vfcopynsign_vv_nxv4f64(<vscale x 4 x double> %vm, <vscale x 4 x double> %vs) {
; CHECK-LABEL: vfcopynsign_vv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v12
; CHECK-NEXT:    ret
  %n = fneg <vscale x 4 x double> %vs
  %r = call <vscale x 4 x double> @llvm.copysign.nxv4f64(<vscale x 4 x double> %vm, <vscale x 4 x double> %n)
  ret <vscale x 4 x double> %r
}

define <vscale x 4 x double> @vfcopynsign_vf_nxv4f64(<vscale x 4 x double> %vm, double %s) {
; CHECK-LABEL: vfcopynsign_vf_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vfsgnjn.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x double> poison, double %s, i32 0
  %splat = shufflevector <vscale x 4 x double> %head, <vscale x 4 x double> poison, <vscale x 4 x i32> zeroinitializer
  %n = fneg <vscale x 4 x double> %splat
  %r = call <vscale x 4 x double> @llvm.copysign.nxv4f64(<vscale x 4 x double> %vm, <vscale x 4 x double> %n)
  ret <vscale x 4 x double> %r
}

declare <vscale x 8 x double> @llvm.copysign.nxv8f64(<vscale x 8 x double>, <vscale x 8 x double>)

define <vscale x 8 x double> @vfcopysign_vv_nxv8f64(<vscale x 8 x double> %vm, <vscale x 8 x double> %vs) {
; CHECK-LABEL: vfcopysign_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfsgnj.vv v8, v8, v16
; CHECK-NEXT:    ret
  %r = call <vscale x 8 x double> @llvm.copysign.nxv8f64(<vscale x 8 x double> %vm, <vscale x 8 x double> %vs)
  ret <vscale x 8 x double> %r
}

define <vscale x 8 x double> @vfcopysign_vf_nxv8f64(<vscale x 8 x double> %vm, double %s) {
; CHECK-LABEL: vfcopysign_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %s, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %r = call <vscale x 8 x double> @llvm.copysign.nxv8f64(<vscale x 8 x double> %vm, <vscale x 8 x double> %splat)
  ret <vscale x 8 x double> %r
}

define <vscale x 8 x double> @vfcopynsign_vv_nxv8f64(<vscale x 8 x double> %vm, <vscale x 8 x double> %vs) {
; CHECK-LABEL: vfcopynsign_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v16
; CHECK-NEXT:    ret
  %n = fneg <vscale x 8 x double> %vs
  %r = call <vscale x 8 x double> @llvm.copysign.nxv8f64(<vscale x 8 x double> %vm, <vscale x 8 x double> %n)
  ret <vscale x 8 x double> %r
}

define <vscale x 8 x double> @vfcopynsign_vf_nxv8f64(<vscale x 8 x double> %vm, double %s) {
; CHECK-LABEL: vfcopynsign_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfsgnjn.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %s, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %n = fneg <vscale x 8 x double> %splat
  %r = call <vscale x 8 x double> @llvm.copysign.nxv8f64(<vscale x 8 x double> %vm, <vscale x 8 x double> %n)
  ret <vscale x 8 x double> %r
}

define <vscale x 8 x double> @vfcopysign_exttrunc_vv_nxv8f64_nxv8f16(<vscale x 8 x double> %vm, <vscale x 8 x half> %vs) {
; CHECK-LABEL: vfcopysign_exttrunc_vv_nxv8f64_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v20, v16
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v24, v20
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfsgnj.vv v8, v8, v24
; CHECK-NEXT:    ret
  %e = fpext <vscale x 8 x half> %vs to <vscale x 8 x double>
  %r = call <vscale x 8 x double> @llvm.copysign.nxv8f64(<vscale x 8 x double> %vm, <vscale x 8 x double> %e)
  ret <vscale x 8 x double> %r
}

define <vscale x 8 x double> @vfcopysign_exttrunc_vf_nxv8f64_nxv8f16(<vscale x 8 x double> %vm, half %s) {
; CHECK-LABEL: vfcopysign_exttrunc_vf_nxv8f64_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.d.h fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %s, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %esplat = fpext <vscale x 8 x half> %splat to <vscale x 8 x double>
  %r = call <vscale x 8 x double> @llvm.copysign.nxv8f64(<vscale x 8 x double> %vm, <vscale x 8 x double> %esplat)
  ret <vscale x 8 x double> %r
}

define <vscale x 8 x double> @vfcopynsign_exttrunc_vv_nxv8f64_nxv8f16(<vscale x 8 x double> %vm, <vscale x 8 x half> %vs) {
; CHECK-LABEL: vfcopynsign_exttrunc_vv_nxv8f64_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v20, v16
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v24, v20
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v24
; CHECK-NEXT:    ret
  %n = fneg <vscale x 8 x half> %vs
  %eneg = fpext <vscale x 8 x half> %n to <vscale x 8 x double>
  %r = call <vscale x 8 x double> @llvm.copysign.nxv8f64(<vscale x 8 x double> %vm, <vscale x 8 x double> %eneg)
  ret <vscale x 8 x double> %r
}

define <vscale x 8 x double> @vfcopynsign_exttrunc_vf_nxv8f64_nxv8f16(<vscale x 8 x double> %vm, half %s) {
; CHECK-LABEL: vfcopynsign_exttrunc_vf_nxv8f64_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.d.h fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfsgnjn.vf v8, v8, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %s, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %n = fneg <vscale x 8 x half> %splat
  %eneg = fpext <vscale x 8 x half> %n to <vscale x 8 x double>
  %r = call <vscale x 8 x double> @llvm.copysign.nxv8f64(<vscale x 8 x double> %vm, <vscale x 8 x double> %eneg)
  ret <vscale x 8 x double> %r
}

define <vscale x 8 x double> @vfcopysign_exttrunc_vv_nxv8f64_nxv8f32(<vscale x 8 x double> %vm, <vscale x 8 x float> %vs) {
; CHECK-LABEL: vfcopysign_exttrunc_vv_nxv8f64_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v24, v16
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfsgnj.vv v8, v8, v24
; CHECK-NEXT:    ret
  %e = fpext <vscale x 8 x float> %vs to <vscale x 8 x double>
  %r = call <vscale x 8 x double> @llvm.copysign.nxv8f64(<vscale x 8 x double> %vm, <vscale x 8 x double> %e)
  ret <vscale x 8 x double> %r
}

define <vscale x 8 x double> @vfcopysign_exttrunc_vf_nxv8f64_nxv8f32(<vscale x 8 x double> %vm, float %s) {
; CHECK-LABEL: vfcopysign_exttrunc_vf_nxv8f64_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.d.s fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %s, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %esplat = fpext <vscale x 8 x float> %splat to <vscale x 8 x double>
  %r = call <vscale x 8 x double> @llvm.copysign.nxv8f64(<vscale x 8 x double> %vm, <vscale x 8 x double> %esplat)
  ret <vscale x 8 x double> %r
}

define <vscale x 8 x double> @vfcopynsign_exttrunc_vv_nxv8f64_nxv8f32(<vscale x 8 x double> %vm, <vscale x 8 x float> %vs) {
; CHECK-LABEL: vfcopynsign_exttrunc_vv_nxv8f64_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v24, v16
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v24
; CHECK-NEXT:    ret
  %n = fneg <vscale x 8 x float> %vs
  %eneg = fpext <vscale x 8 x float> %n to <vscale x 8 x double>
  %r = call <vscale x 8 x double> @llvm.copysign.nxv8f64(<vscale x 8 x double> %vm, <vscale x 8 x double> %eneg)
  ret <vscale x 8 x double> %r
}

define <vscale x 8 x double> @vfcopynsign_exttrunc_vf_nxv8f64_nxv8f32(<vscale x 8 x double> %vm, float %s) {
; CHECK-LABEL: vfcopynsign_exttrunc_vf_nxv8f64_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.d.s fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfsgnjn.vf v8, v8, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %s, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %n = fneg <vscale x 8 x float> %splat
  %eneg = fpext <vscale x 8 x float> %n to <vscale x 8 x double>
  %r = call <vscale x 8 x double> @llvm.copysign.nxv8f64(<vscale x 8 x double> %vm, <vscale x 8 x double> %eneg)
  ret <vscale x 8 x double> %r
}

define <vscale x 2 x float> @fptrunc_of_copysign_nxv2f32_nxv2f64(<vscale x 2 x double> %X, <vscale x 2 x double> %Y) {
; CHECK-LABEL: fptrunc_of_copysign_nxv2f32_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vfsgnj.vv v10, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v10
; CHECK-NEXT:    ret
  %copy = call fast <vscale x 2 x double> @llvm.copysign.nxv2f64(<vscale x 2 x double> %X, <vscale x 2 x double> %Y)
  %trunc = fptrunc <vscale x 2 x double> %copy to <vscale x 2 x float>
  ret <vscale x 2 x float> %trunc
}
