; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx1200 < %s | FileCheck -check-prefix=GFX12 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx940 < %s | FileCheck -check-prefix=GFX940 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx1100 < %s | FileCheck -check-prefix=GFX11 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx1010 < %s | FileCheck -check-prefix=GFX10 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx90a < %s | FileCheck -check-prefix=GFX90A %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx908 < %s | FileCheck -check-prefix=GFX908 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=tonga < %s | FileCheck -check-prefix=GFX8 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=hawaii < %s | FileCheck -check-prefix=GFX7 %s

; --------------------------------------------------------------------
; float
; --------------------------------------------------------------------

define float @flat_agent_atomic_fadd_ret_f32__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode(ptr %ptr, float %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_load_dword v3, v[0:1]
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB0_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB0_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v1
; GFX90A-NEXT:    ; implicit-def: $vgpr3
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX90A-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execz .LBB0_6
; GFX90A-NEXT:  ; %bb.1: ; %atomicrmw.check.private
; GFX90A-NEXT:    s_mov_b64 s[6:7], src_private_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s7, v1
; GFX90A-NEXT:    ; implicit-def: $vgpr3
; GFX90A-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX90A-NEXT:    s_xor_b64 s[6:7], exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB0_3
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.global
; GFX90A-NEXT:    global_atomic_add_f32 v3, v[0:1], v2, off glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:  .LBB0_3: ; %Flow
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB0_5
; GFX90A-NEXT:  ; %bb.4: ; %atomicrmw.private
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX90A-NEXT:    buffer_load_dword v3, v0, s[0:3], 0 offen
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_add_f32_e32 v1, v3, v2
; GFX90A-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; GFX90A-NEXT:  .LBB0_5: ; %Flow1
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:  .LBB0_6: ; %Flow2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execz .LBB0_8
; GFX90A-NEXT:  ; %bb.7: ; %atomicrmw.shared
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX90A-NEXT:    ds_add_rtn_f32 v3, v0, v2
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:  .LBB0_8: ; %atomicrmw.phi
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v3, v[0:1]
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB0_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB0_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB0_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB0_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v0, v3
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    flat_load_dword v3, v[0:1]
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB0_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v4, v3
; GFX7-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX7-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB0_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v0, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr %ptr, float %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0, !amdgpu.ignore.denormal.mode !0
  ret float %result
}

define float @flat_agent_atomic_fadd_ret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode(ptr %ptr, float %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_ret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 offset:2044 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_ret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 offset:2044 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_ret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 offset:2044 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_ret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fc, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v4, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v0, v[3:4]
; GFX10-NEXT:  .LBB1_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, v0
; GFX10-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB1_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_ret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v4, vcc, 0x7fc, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v1, vcc
; GFX90A-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v5
; GFX90A-NEXT:    ; implicit-def: $vgpr0
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX90A-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB1_3
; GFX90A-NEXT:  ; %bb.1: ; %Flow2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB1_8
; GFX90A-NEXT:  .LBB1_2: ; %atomicrmw.phi
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
; GFX90A-NEXT:  .LBB1_3: ; %atomicrmw.check.private
; GFX90A-NEXT:    s_mov_b64 s[6:7], src_private_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s7, v5
; GFX90A-NEXT:    ; implicit-def: $vgpr0
; GFX90A-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX90A-NEXT:    s_xor_b64 s[6:7], exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB1_5
; GFX90A-NEXT:  ; %bb.4: ; %atomicrmw.global
; GFX90A-NEXT:    global_atomic_add_f32 v0, v[4:5], v2, off glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:  .LBB1_5: ; %Flow
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB1_7
; GFX90A-NEXT:  ; %bb.6: ; %atomicrmw.private
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v1, -1, v4, vcc
; GFX90A-NEXT:    buffer_load_dword v0, v1, s[0:3], 0 offen
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_add_f32_e32 v2, v0, v2
; GFX90A-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; GFX90A-NEXT:  .LBB1_7: ; %Flow1
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execz .LBB1_2
; GFX90A-NEXT:  .LBB1_8: ; %atomicrmw.shared
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v4, vcc
; GFX90A-NEXT:    ds_add_rtn_f32 v0, v0, v2
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_ret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v3, v[0:1] offset:2044
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB1_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] offset:2044 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB1_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_ret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v4, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[3:4]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB1_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, v0
; GFX8-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX8-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB1_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_ret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v3, vcc, 0x7fc, v0
; GFX7-NEXT:    v_addc_u32_e32 v4, vcc, 0, v1, vcc
; GFX7-NEXT:    flat_load_dword v0, v[3:4]
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB1_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v1, v0
; GFX7-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX7-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB1_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr %ptr, i64 511
  %result = atomicrmw fadd ptr %gep, float %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0, !amdgpu.ignore.denormal.mode !0
  ret float %result
}

define float @flat_agent_atomic_fadd_ret_f32__offset12b_neg__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode(ptr %ptr, float %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_ret_f32__offset12b_neg__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 offset:-2048 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_ret_f32__offset12b_neg__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff800, v0
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_ret_f32__offset12b_neg__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, 0xfffff800, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_ret_f32__offset12b_neg__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v3, vcc_lo, 0xfffff800, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v4, vcc_lo, -1, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v0, v[3:4]
; GFX10-NEXT:  .LBB2_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, v0
; GFX10-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB2_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_ret_f32__offset12b_neg__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v4, vcc, 0xfffff800, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v5, vcc, -1, v1, vcc
; GFX90A-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v5
; GFX90A-NEXT:    ; implicit-def: $vgpr0
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX90A-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB2_3
; GFX90A-NEXT:  ; %bb.1: ; %Flow2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB2_8
; GFX90A-NEXT:  .LBB2_2: ; %atomicrmw.phi
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
; GFX90A-NEXT:  .LBB2_3: ; %atomicrmw.check.private
; GFX90A-NEXT:    s_mov_b64 s[6:7], src_private_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s7, v5
; GFX90A-NEXT:    ; implicit-def: $vgpr0
; GFX90A-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX90A-NEXT:    s_xor_b64 s[6:7], exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB2_5
; GFX90A-NEXT:  ; %bb.4: ; %atomicrmw.global
; GFX90A-NEXT:    global_atomic_add_f32 v0, v[4:5], v2, off glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:  .LBB2_5: ; %Flow
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB2_7
; GFX90A-NEXT:  ; %bb.6: ; %atomicrmw.private
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v1, -1, v4, vcc
; GFX90A-NEXT:    buffer_load_dword v0, v1, s[0:3], 0 offen
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_add_f32_e32 v2, v0, v2
; GFX90A-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; GFX90A-NEXT:  .LBB2_7: ; %Flow1
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execz .LBB2_2
; GFX90A-NEXT:  .LBB2_8: ; %atomicrmw.shared
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v4, vcc
; GFX90A-NEXT:    ds_add_rtn_f32 v0, v0, v2
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_ret_f32__offset12b_neg__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v3, vcc, 0xfffff800, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v4, vcc, -1, v1, vcc
; GFX908-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff800, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX908-NEXT:    flat_load_dword v0, v[0:1]
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB2_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v1, v0
; GFX908-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX908-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB2_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_ret_f32__offset12b_neg__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0xfffff800, v0
; GFX8-NEXT:    v_addc_u32_e32 v4, vcc, -1, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[3:4]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB2_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, v0
; GFX8-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX8-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB2_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_ret_f32__offset12b_neg__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v3, vcc, 0xfffff800, v0
; GFX7-NEXT:    v_addc_u32_e32 v4, vcc, -1, v1, vcc
; GFX7-NEXT:    flat_load_dword v0, v[3:4]
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB2_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v1, v0
; GFX7-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX7-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB2_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr %ptr, i64 -512
  %result = atomicrmw fadd ptr %gep, float %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0, !amdgpu.ignore.denormal.mode !0
  ret float %result
}

define void @flat_agent_atomic_fadd_noret_f32__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode(ptr %ptr, float %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_add_f32 v[0:1], v2 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_add_f32 v[0:1], v2
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_add_f32 v[0:1], v2
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_load_dword v4, v[0:1]
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB3_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB3_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v1
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX90A-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB3_3
; GFX90A-NEXT:  ; %bb.1: ; %Flow2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB3_8
; GFX90A-NEXT:  .LBB3_2: ; %atomicrmw.phi
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
; GFX90A-NEXT:  .LBB3_3: ; %atomicrmw.check.private
; GFX90A-NEXT:    s_mov_b64 s[6:7], src_private_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s7, v1
; GFX90A-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX90A-NEXT:    s_xor_b64 s[6:7], exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB3_5
; GFX90A-NEXT:  ; %bb.4: ; %atomicrmw.global
; GFX90A-NEXT:    global_atomic_add_f32 v[0:1], v2, off
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:  .LBB3_5: ; %Flow
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB3_7
; GFX90A-NEXT:  ; %bb.6: ; %atomicrmw.private
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX90A-NEXT:    buffer_load_dword v1, v0, s[0:3], 0 offen
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX90A-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; GFX90A-NEXT:  .LBB3_7: ; %Flow1
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execz .LBB3_2
; GFX90A-NEXT:  .LBB3_8: ; %atomicrmw.shared
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX90A-NEXT:    ds_add_f32 v0, v2
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX908-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v1
; GFX908-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX908-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB3_3
; GFX908-NEXT:  ; %bb.1: ; %Flow2
; GFX908-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB3_8
; GFX908-NEXT:  .LBB3_2: ; %atomicrmw.phi
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
; GFX908-NEXT:  .LBB3_3: ; %atomicrmw.check.private
; GFX908-NEXT:    s_mov_b64 s[6:7], src_private_base
; GFX908-NEXT:    v_cmp_ne_u32_e32 vcc, s7, v1
; GFX908-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX908-NEXT:    s_xor_b64 s[6:7], exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execz .LBB3_5
; GFX908-NEXT:  ; %bb.4: ; %atomicrmw.global
; GFX908-NEXT:    global_atomic_add_f32 v[0:1], v2, off
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX908-NEXT:    ; implicit-def: $vgpr2
; GFX908-NEXT:  .LBB3_5: ; %Flow
; GFX908-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; GFX908-NEXT:    s_cbranch_execz .LBB3_7
; GFX908-NEXT:  ; %bb.6: ; %atomicrmw.private
; GFX908-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX908-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX908-NEXT:    buffer_load_dword v1, v0, s[0:3], 0 offen
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX908-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; GFX908-NEXT:  .LBB3_7: ; %Flow1
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX908-NEXT:    ; implicit-def: $vgpr2
; GFX908-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_cbranch_execz .LBB3_2
; GFX908-NEXT:  .LBB3_8: ; %atomicrmw.shared
; GFX908-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX908-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX908-NEXT:    ds_add_f32 v0, v2
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB3_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB3_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    flat_load_dword v4, v[0:1]
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB3_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX7-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v4, v3
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB3_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %unused = atomicrmw fadd ptr %ptr, float %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0, !amdgpu.ignore.denormal.mode !0
  ret void
}

define void @flat_agent_atomic_fadd_noret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode(ptr %ptr, float %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_add_f32 v[0:1], v2 offset:2044 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_add_f32 v[0:1], v2 offset:2044
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_add_f32 v[0:1], v2 offset:2044
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0x7fc, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v4, v[0:1]
; GFX10-NEXT:  .LBB4_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB4_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v0, vcc, 0x7fc, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX90A-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v1
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX90A-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB4_3
; GFX90A-NEXT:  ; %bb.1: ; %Flow2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB4_8
; GFX90A-NEXT:  .LBB4_2: ; %atomicrmw.phi
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
; GFX90A-NEXT:  .LBB4_3: ; %atomicrmw.check.private
; GFX90A-NEXT:    s_mov_b64 s[6:7], src_private_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s7, v1
; GFX90A-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX90A-NEXT:    s_xor_b64 s[6:7], exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB4_5
; GFX90A-NEXT:  ; %bb.4: ; %atomicrmw.global
; GFX90A-NEXT:    global_atomic_add_f32 v[0:1], v2, off
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:  .LBB4_5: ; %Flow
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB4_7
; GFX90A-NEXT:  ; %bb.6: ; %atomicrmw.private
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX90A-NEXT:    buffer_load_dword v1, v0, s[0:3], 0 offen
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX90A-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; GFX90A-NEXT:  .LBB4_7: ; %Flow1
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execz .LBB4_2
; GFX90A-NEXT:  .LBB4_8: ; %atomicrmw.shared
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX90A-NEXT:    ds_add_f32 v0, v2
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v0, vcc, 0x7fc, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX908-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX908-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v1
; GFX908-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX908-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB4_3
; GFX908-NEXT:  ; %bb.1: ; %Flow2
; GFX908-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB4_8
; GFX908-NEXT:  .LBB4_2: ; %atomicrmw.phi
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
; GFX908-NEXT:  .LBB4_3: ; %atomicrmw.check.private
; GFX908-NEXT:    s_mov_b64 s[6:7], src_private_base
; GFX908-NEXT:    v_cmp_ne_u32_e32 vcc, s7, v1
; GFX908-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX908-NEXT:    s_xor_b64 s[6:7], exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execz .LBB4_5
; GFX908-NEXT:  ; %bb.4: ; %atomicrmw.global
; GFX908-NEXT:    global_atomic_add_f32 v[0:1], v2, off
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX908-NEXT:    ; implicit-def: $vgpr2
; GFX908-NEXT:  .LBB4_5: ; %Flow
; GFX908-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; GFX908-NEXT:    s_cbranch_execz .LBB4_7
; GFX908-NEXT:  ; %bb.6: ; %atomicrmw.private
; GFX908-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX908-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX908-NEXT:    buffer_load_dword v1, v0, s[0:3], 0 offen
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX908-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; GFX908-NEXT:  .LBB4_7: ; %Flow1
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX908-NEXT:    ; implicit-def: $vgpr2
; GFX908-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_cbranch_execz .LBB4_2
; GFX908-NEXT:  .LBB4_8: ; %atomicrmw.shared
; GFX908-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX908-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX908-NEXT:    ds_add_f32 v0, v2
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB4_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB4_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, 0x7fc, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    flat_load_dword v4, v[0:1]
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB4_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX7-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v4, v3
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB4_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr %ptr, i64 511
  %unused = atomicrmw fadd ptr %gep, float %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0, !amdgpu.ignore.denormal.mode !0
  ret void
}

define void @flat_agent_atomic_fadd_noret_f32__offset12b_neg__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode(ptr %ptr, float %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_f32__offset12b_neg__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_add_f32 v[0:1], v2 offset:-2048 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_f32__offset12b_neg__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff800, v0
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_add_f32 v[0:1], v2
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_f32__offset12b_neg__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, 0xfffff800, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_add_f32 v[0:1], v2
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_f32__offset12b_neg__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0xfffff800, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v4, v[0:1]
; GFX10-NEXT:  .LBB5_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB5_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_f32__offset12b_neg__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff800, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX90A-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v1
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX90A-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB5_3
; GFX90A-NEXT:  ; %bb.1: ; %Flow2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB5_8
; GFX90A-NEXT:  .LBB5_2: ; %atomicrmw.phi
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
; GFX90A-NEXT:  .LBB5_3: ; %atomicrmw.check.private
; GFX90A-NEXT:    s_mov_b64 s[6:7], src_private_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s7, v1
; GFX90A-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX90A-NEXT:    s_xor_b64 s[6:7], exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB5_5
; GFX90A-NEXT:  ; %bb.4: ; %atomicrmw.global
; GFX90A-NEXT:    global_atomic_add_f32 v[0:1], v2, off
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:  .LBB5_5: ; %Flow
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB5_7
; GFX90A-NEXT:  ; %bb.6: ; %atomicrmw.private
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX90A-NEXT:    buffer_load_dword v1, v0, s[0:3], 0 offen
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX90A-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; GFX90A-NEXT:  .LBB5_7: ; %Flow1
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execz .LBB5_2
; GFX90A-NEXT:  .LBB5_8: ; %atomicrmw.shared
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX90A-NEXT:    ds_add_f32 v0, v2
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_f32__offset12b_neg__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff800, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX908-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX908-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v1
; GFX908-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX908-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB5_3
; GFX908-NEXT:  ; %bb.1: ; %Flow2
; GFX908-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB5_8
; GFX908-NEXT:  .LBB5_2: ; %atomicrmw.phi
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
; GFX908-NEXT:  .LBB5_3: ; %atomicrmw.check.private
; GFX908-NEXT:    s_mov_b64 s[6:7], src_private_base
; GFX908-NEXT:    v_cmp_ne_u32_e32 vcc, s7, v1
; GFX908-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX908-NEXT:    s_xor_b64 s[6:7], exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execz .LBB5_5
; GFX908-NEXT:  ; %bb.4: ; %atomicrmw.global
; GFX908-NEXT:    global_atomic_add_f32 v[0:1], v2, off
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX908-NEXT:    ; implicit-def: $vgpr2
; GFX908-NEXT:  .LBB5_5: ; %Flow
; GFX908-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; GFX908-NEXT:    s_cbranch_execz .LBB5_7
; GFX908-NEXT:  ; %bb.6: ; %atomicrmw.private
; GFX908-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX908-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX908-NEXT:    buffer_load_dword v1, v0, s[0:3], 0 offen
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX908-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; GFX908-NEXT:  .LBB5_7: ; %Flow1
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX908-NEXT:    ; implicit-def: $vgpr2
; GFX908-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_cbranch_execz .LBB5_2
; GFX908-NEXT:  .LBB5_8: ; %atomicrmw.shared
; GFX908-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX908-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX908-NEXT:    ds_add_f32 v0, v2
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_f32__offset12b_neg__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0xfffff800, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB5_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB5_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_f32__offset12b_neg__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, 0xfffff800, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX7-NEXT:    flat_load_dword v4, v[0:1]
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB5_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX7-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v4, v3
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB5_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr %ptr, i64 -512
  %unused = atomicrmw fadd ptr %gep, float %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0, !amdgpu.ignore.denormal.mode !0
  ret void
}

define float @flat_system_atomic_fadd_ret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode(ptr %ptr, float %val) #0 {
; GFX12-LABEL: flat_system_atomic_fadd_ret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 offset:2044 th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_system_atomic_fadd_ret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 offset:2044 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc0 sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_system_atomic_fadd_ret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 offset:2044 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_system_atomic_fadd_ret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fc, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v4, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v0, v[3:4]
; GFX10-NEXT:  .LBB6_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, v0
; GFX10-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB6_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_system_atomic_fadd_ret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v4, vcc, 0x7fc, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v1, vcc
; GFX90A-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v5
; GFX90A-NEXT:    ; implicit-def: $vgpr0
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX90A-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB6_3
; GFX90A-NEXT:  ; %bb.1: ; %Flow2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB6_8
; GFX90A-NEXT:  .LBB6_2: ; %atomicrmw.phi
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
; GFX90A-NEXT:  .LBB6_3: ; %atomicrmw.check.private
; GFX90A-NEXT:    s_mov_b64 s[6:7], src_private_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s7, v5
; GFX90A-NEXT:    ; implicit-def: $vgpr0
; GFX90A-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX90A-NEXT:    s_xor_b64 s[6:7], exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB6_5
; GFX90A-NEXT:  ; %bb.4: ; %atomicrmw.global
; GFX90A-NEXT:    buffer_wbl2
; GFX90A-NEXT:    global_atomic_add_f32 v0, v[4:5], v2, off glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_invl2
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:  .LBB6_5: ; %Flow
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB6_7
; GFX90A-NEXT:  ; %bb.6: ; %atomicrmw.private
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v1, -1, v4, vcc
; GFX90A-NEXT:    buffer_load_dword v0, v1, s[0:3], 0 offen
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_add_f32_e32 v2, v0, v2
; GFX90A-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; GFX90A-NEXT:  .LBB6_7: ; %Flow1
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execz .LBB6_2
; GFX90A-NEXT:  .LBB6_8: ; %atomicrmw.shared
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v4, vcc
; GFX90A-NEXT:    ds_add_rtn_f32 v0, v0, v2
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_system_atomic_fadd_ret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v3, v[0:1] offset:2044
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB6_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] offset:2044 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB6_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_system_atomic_fadd_ret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v4, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[3:4]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB6_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, v0
; GFX8-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX8-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB6_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_system_atomic_fadd_ret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v3, vcc, 0x7fc, v0
; GFX7-NEXT:    v_addc_u32_e32 v4, vcc, 0, v1, vcc
; GFX7-NEXT:    flat_load_dword v0, v[3:4]
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB6_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v1, v0
; GFX7-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX7-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB6_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr %ptr, i64 511
  %result = atomicrmw fadd ptr %gep, float %val seq_cst, !amdgpu.no.fine.grained.memory !0, !amdgpu.ignore.denormal.mode !0
  ret float %result
}

define void @flat_system_atomic_fadd_noret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode(ptr %ptr, float %val) #0 {
; GFX12-LABEL: flat_system_atomic_fadd_noret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_add_f32 v[0:1], v2 offset:2044 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_system_atomic_fadd_noret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-NEXT:    flat_atomic_add_f32 v[0:1], v2 offset:2044 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc0 sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_system_atomic_fadd_noret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_add_f32 v[0:1], v2 offset:2044
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_system_atomic_fadd_noret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0x7fc, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v4, v[0:1]
; GFX10-NEXT:  .LBB7_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB7_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_system_atomic_fadd_noret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v0, vcc, 0x7fc, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX90A-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v1
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX90A-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB7_3
; GFX90A-NEXT:  ; %bb.1: ; %Flow2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB7_8
; GFX90A-NEXT:  .LBB7_2: ; %atomicrmw.phi
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
; GFX90A-NEXT:  .LBB7_3: ; %atomicrmw.check.private
; GFX90A-NEXT:    s_mov_b64 s[6:7], src_private_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s7, v1
; GFX90A-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX90A-NEXT:    s_xor_b64 s[6:7], exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB7_5
; GFX90A-NEXT:  ; %bb.4: ; %atomicrmw.global
; GFX90A-NEXT:    buffer_wbl2
; GFX90A-NEXT:    global_atomic_add_f32 v[0:1], v2, off
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_invl2
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:  .LBB7_5: ; %Flow
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB7_7
; GFX90A-NEXT:  ; %bb.6: ; %atomicrmw.private
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX90A-NEXT:    buffer_load_dword v1, v0, s[0:3], 0 offen
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX90A-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; GFX90A-NEXT:  .LBB7_7: ; %Flow1
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execz .LBB7_2
; GFX90A-NEXT:  .LBB7_8: ; %atomicrmw.shared
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX90A-NEXT:    ds_add_f32 v0, v2
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_system_atomic_fadd_noret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v0, vcc, 0x7fc, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX908-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX908-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v1
; GFX908-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX908-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB7_3
; GFX908-NEXT:  ; %bb.1: ; %Flow2
; GFX908-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB7_8
; GFX908-NEXT:  .LBB7_2: ; %atomicrmw.phi
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
; GFX908-NEXT:  .LBB7_3: ; %atomicrmw.check.private
; GFX908-NEXT:    s_mov_b64 s[6:7], src_private_base
; GFX908-NEXT:    v_cmp_ne_u32_e32 vcc, s7, v1
; GFX908-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX908-NEXT:    s_xor_b64 s[6:7], exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execz .LBB7_5
; GFX908-NEXT:  ; %bb.4: ; %atomicrmw.global
; GFX908-NEXT:    global_atomic_add_f32 v[0:1], v2, off
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX908-NEXT:    ; implicit-def: $vgpr2
; GFX908-NEXT:  .LBB7_5: ; %Flow
; GFX908-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; GFX908-NEXT:    s_cbranch_execz .LBB7_7
; GFX908-NEXT:  ; %bb.6: ; %atomicrmw.private
; GFX908-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX908-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX908-NEXT:    buffer_load_dword v1, v0, s[0:3], 0 offen
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX908-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; GFX908-NEXT:  .LBB7_7: ; %Flow1
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX908-NEXT:    ; implicit-def: $vgpr2
; GFX908-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_cbranch_execz .LBB7_2
; GFX908-NEXT:  .LBB7_8: ; %atomicrmw.shared
; GFX908-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX908-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX908-NEXT:    ds_add_f32 v0, v2
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_system_atomic_fadd_noret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB7_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB7_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_system_atomic_fadd_noret_f32__offset12b_pos__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, 0x7fc, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    flat_load_dword v4, v[0:1]
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB7_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX7-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v4, v3
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB7_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr %ptr, i64 511
  %unused = atomicrmw fadd ptr %gep, float %val seq_cst, !amdgpu.no.fine.grained.memory !0, !amdgpu.ignore.denormal.mode !0
  ret void
}

define void @flat_agent_atomic_fadd_noret_f32_maybe_remote(ptr %ptr, float %val) {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_f32_maybe_remote:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_add_f32 v[0:1], v2 offset:2044 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_f32_maybe_remote:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_add_f32 v[0:1], v2 offset:2044
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_f32_maybe_remote:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_b32 v4, v[0:1] offset:2044
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB8_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[3:4] offset:2044 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB8_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_f32_maybe_remote:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0x7fc, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v4, v[0:1]
; GFX10-NEXT:  .LBB8_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB8_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_f32_maybe_remote:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    flat_load_dword v5, v[0:1] offset:2044
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB8_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX90A-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[4:5] offset:2044 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB8_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_f32_maybe_remote:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v4, v[0:1] offset:2044
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB8_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] offset:2044 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB8_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_f32_maybe_remote:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB8_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB8_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_f32_maybe_remote:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, 0x7fc, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    flat_load_dword v4, v[0:1]
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB8_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX7-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v4, v3
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB8_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr %ptr, i64 511
  %unused = atomicrmw fadd ptr %gep, float %val syncscope("agent") seq_cst
  ret void
}

define void @flat_agent_atomic_fadd_noret_f32___amdgpu_no_fine_grained_memory(ptr %ptr, float %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_f32___amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_add_f32 v[0:1], v2 offset:2044 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_f32___amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_add_f32 v[0:1], v2 offset:2044
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_f32___amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_add_f32 v[0:1], v2 offset:2044
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_f32___amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0x7fc, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v4, v[0:1]
; GFX10-NEXT:  .LBB9_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB9_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_f32___amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    flat_load_dword v5, v[0:1] offset:2044
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB9_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX90A-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[4:5] offset:2044 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB9_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_f32___amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v4, v[0:1] offset:2044
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB9_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] offset:2044 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB9_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_f32___amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB9_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB9_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_f32___amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, 0x7fc, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    flat_load_dword v4, v[0:1]
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB9_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX7-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v4, v3
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB9_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr %ptr, i64 511
  %unused = atomicrmw fadd ptr %gep, float %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret void
}

define void @flat_agent_atomic_fadd_noret_f32___amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode(ptr %ptr, float %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_f32___amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_add_f32 v[0:1], v2 offset:2044 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_f32___amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_add_f32 v[0:1], v2 offset:2044
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_f32___amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_add_f32 v[0:1], v2 offset:2044
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_f32___amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0x7fc, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v4, v[0:1]
; GFX10-NEXT:  .LBB10_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB10_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_f32___amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v0, vcc, 0x7fc, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX90A-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v1
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX90A-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB10_3
; GFX90A-NEXT:  ; %bb.1: ; %Flow2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB10_8
; GFX90A-NEXT:  .LBB10_2: ; %atomicrmw.phi
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
; GFX90A-NEXT:  .LBB10_3: ; %atomicrmw.check.private
; GFX90A-NEXT:    s_mov_b64 s[6:7], src_private_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s7, v1
; GFX90A-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX90A-NEXT:    s_xor_b64 s[6:7], exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB10_5
; GFX90A-NEXT:  ; %bb.4: ; %atomicrmw.global
; GFX90A-NEXT:    global_atomic_add_f32 v[0:1], v2, off
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:  .LBB10_5: ; %Flow
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB10_7
; GFX90A-NEXT:  ; %bb.6: ; %atomicrmw.private
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX90A-NEXT:    buffer_load_dword v1, v0, s[0:3], 0 offen
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX90A-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; GFX90A-NEXT:  .LBB10_7: ; %Flow1
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execz .LBB10_2
; GFX90A-NEXT:  .LBB10_8: ; %atomicrmw.shared
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX90A-NEXT:    ds_add_f32 v0, v2
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_f32___amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v0, vcc, 0x7fc, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX908-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX908-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v1
; GFX908-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX908-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB10_3
; GFX908-NEXT:  ; %bb.1: ; %Flow2
; GFX908-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB10_8
; GFX908-NEXT:  .LBB10_2: ; %atomicrmw.phi
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
; GFX908-NEXT:  .LBB10_3: ; %atomicrmw.check.private
; GFX908-NEXT:    s_mov_b64 s[6:7], src_private_base
; GFX908-NEXT:    v_cmp_ne_u32_e32 vcc, s7, v1
; GFX908-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX908-NEXT:    s_xor_b64 s[6:7], exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execz .LBB10_5
; GFX908-NEXT:  ; %bb.4: ; %atomicrmw.global
; GFX908-NEXT:    global_atomic_add_f32 v[0:1], v2, off
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX908-NEXT:    ; implicit-def: $vgpr2
; GFX908-NEXT:  .LBB10_5: ; %Flow
; GFX908-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; GFX908-NEXT:    s_cbranch_execz .LBB10_7
; GFX908-NEXT:  ; %bb.6: ; %atomicrmw.private
; GFX908-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX908-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX908-NEXT:    buffer_load_dword v1, v0, s[0:3], 0 offen
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX908-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; GFX908-NEXT:  .LBB10_7: ; %Flow1
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX908-NEXT:    ; implicit-def: $vgpr2
; GFX908-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_cbranch_execz .LBB10_2
; GFX908-NEXT:  .LBB10_8: ; %atomicrmw.shared
; GFX908-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX908-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX908-NEXT:    ds_add_f32 v0, v2
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_f32___amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB10_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB10_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_f32___amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, 0x7fc, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    flat_load_dword v4, v[0:1]
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB10_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX7-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v4, v3
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB10_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr %ptr, i64 511
  %unused = atomicrmw fadd ptr %gep, float %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0, !amdgpu.ignore.denormal.mode !0
  ret void
}

define void @flat_agent_atomic_fadd_noret_f32_amdgpu_ignore_denormal_mode(ptr %ptr, float %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_f32_amdgpu_ignore_denormal_mode:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_add_f32 v[0:1], v2 offset:2044 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_f32_amdgpu_ignore_denormal_mode:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_add_f32 v[0:1], v2 offset:2044
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_f32_amdgpu_ignore_denormal_mode:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_b32 v4, v[0:1] offset:2044
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB11_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[3:4] offset:2044 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB11_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_f32_amdgpu_ignore_denormal_mode:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0x7fc, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v4, v[0:1]
; GFX10-NEXT:  .LBB11_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB11_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_f32_amdgpu_ignore_denormal_mode:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    flat_load_dword v5, v[0:1] offset:2044
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB11_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX90A-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[4:5] offset:2044 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB11_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_f32_amdgpu_ignore_denormal_mode:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v4, v[0:1] offset:2044
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB11_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] offset:2044 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB11_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_f32_amdgpu_ignore_denormal_mode:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB11_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB11_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_f32_amdgpu_ignore_denormal_mode:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, 0x7fc, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    flat_load_dword v4, v[0:1]
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB11_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX7-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v4, v3
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB11_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr %ptr, i64 511
  %unused = atomicrmw fadd ptr %gep, float %val syncscope("agent") seq_cst, !amdgpu.ignore.denormal.mode !0
  ret void
}

; --------------------------------------------------------------------
; float with ftz/daz
; --------------------------------------------------------------------

define float @flat_agent_atomic_fadd_ret_f32__ftz__amdgpu_no_fine_grained_memory(ptr %ptr, float %val) #1 {
; GFX12-LABEL: flat_agent_atomic_fadd_ret_f32__ftz__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_ret_f32__ftz__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_ret_f32__ftz__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_ret_f32__ftz__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_load_dword v3, v[0:1]
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB12_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB12_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_ret_f32__ftz__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v1
; GFX90A-NEXT:    ; implicit-def: $vgpr3
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX90A-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execz .LBB12_6
; GFX90A-NEXT:  ; %bb.1: ; %atomicrmw.check.private
; GFX90A-NEXT:    s_mov_b64 s[6:7], src_private_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s7, v1
; GFX90A-NEXT:    ; implicit-def: $vgpr3
; GFX90A-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX90A-NEXT:    s_xor_b64 s[6:7], exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB12_3
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.global
; GFX90A-NEXT:    global_atomic_add_f32 v3, v[0:1], v2, off glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:  .LBB12_3: ; %Flow
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB12_5
; GFX90A-NEXT:  ; %bb.4: ; %atomicrmw.private
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX90A-NEXT:    buffer_load_dword v3, v0, s[0:3], 0 offen
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_add_f32_e32 v1, v3, v2
; GFX90A-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; GFX90A-NEXT:  .LBB12_5: ; %Flow1
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:  .LBB12_6: ; %Flow2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execz .LBB12_8
; GFX90A-NEXT:  ; %bb.7: ; %atomicrmw.shared
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX90A-NEXT:    ds_add_rtn_f32 v3, v0, v2
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:  .LBB12_8: ; %atomicrmw.phi
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_ret_f32__ftz__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v3, v[0:1]
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB12_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB12_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_ret_f32__ftz__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB12_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB12_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v0, v3
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_ret_f32__ftz__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    flat_load_dword v3, v[0:1]
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB12_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v4, v3
; GFX7-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX7-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB12_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v0, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr %ptr, float %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret float %result
}

define float @flat_agent_atomic_fadd_ret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory(ptr %ptr, float %val) #1 {
; GFX12-LABEL: flat_agent_atomic_fadd_ret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 offset:2044 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_ret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 offset:2044 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_ret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 offset:2044 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_ret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fc, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v4, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v0, v[3:4]
; GFX10-NEXT:  .LBB13_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, v0
; GFX10-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB13_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_ret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v4, vcc, 0x7fc, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v1, vcc
; GFX90A-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v5
; GFX90A-NEXT:    ; implicit-def: $vgpr0
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX90A-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB13_3
; GFX90A-NEXT:  ; %bb.1: ; %Flow2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB13_8
; GFX90A-NEXT:  .LBB13_2: ; %atomicrmw.phi
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
; GFX90A-NEXT:  .LBB13_3: ; %atomicrmw.check.private
; GFX90A-NEXT:    s_mov_b64 s[6:7], src_private_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s7, v5
; GFX90A-NEXT:    ; implicit-def: $vgpr0
; GFX90A-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX90A-NEXT:    s_xor_b64 s[6:7], exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB13_5
; GFX90A-NEXT:  ; %bb.4: ; %atomicrmw.global
; GFX90A-NEXT:    global_atomic_add_f32 v0, v[4:5], v2, off glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:  .LBB13_5: ; %Flow
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB13_7
; GFX90A-NEXT:  ; %bb.6: ; %atomicrmw.private
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v1, -1, v4, vcc
; GFX90A-NEXT:    buffer_load_dword v0, v1, s[0:3], 0 offen
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_add_f32_e32 v2, v0, v2
; GFX90A-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; GFX90A-NEXT:  .LBB13_7: ; %Flow1
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execz .LBB13_2
; GFX90A-NEXT:  .LBB13_8: ; %atomicrmw.shared
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v4, vcc
; GFX90A-NEXT:    ds_add_rtn_f32 v0, v0, v2
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_ret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v3, v[0:1] offset:2044
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB13_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] offset:2044 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB13_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_ret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v4, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[3:4]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB13_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, v0
; GFX8-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX8-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB13_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_ret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v3, vcc, 0x7fc, v0
; GFX7-NEXT:    v_addc_u32_e32 v4, vcc, 0, v1, vcc
; GFX7-NEXT:    flat_load_dword v0, v[3:4]
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB13_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v1, v0
; GFX7-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX7-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB13_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr %ptr, i64 511
  %result = atomicrmw fadd ptr %gep, float %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret float %result
}

define float @flat_agent_atomic_fadd_ret_f32__offset12b_neg__ftz__amdgpu_no_fine_grained_memory(ptr %ptr, float %val) #1 {
; GFX12-LABEL: flat_agent_atomic_fadd_ret_f32__offset12b_neg__ftz__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 offset:-2048 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_ret_f32__offset12b_neg__ftz__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff800, v0
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_ret_f32__offset12b_neg__ftz__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, 0xfffff800, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_ret_f32__offset12b_neg__ftz__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v3, vcc_lo, 0xfffff800, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v4, vcc_lo, -1, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v0, v[3:4]
; GFX10-NEXT:  .LBB14_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, v0
; GFX10-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB14_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_ret_f32__offset12b_neg__ftz__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v4, vcc, 0xfffff800, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v5, vcc, -1, v1, vcc
; GFX90A-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v5
; GFX90A-NEXT:    ; implicit-def: $vgpr0
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX90A-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB14_3
; GFX90A-NEXT:  ; %bb.1: ; %Flow2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB14_8
; GFX90A-NEXT:  .LBB14_2: ; %atomicrmw.phi
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
; GFX90A-NEXT:  .LBB14_3: ; %atomicrmw.check.private
; GFX90A-NEXT:    s_mov_b64 s[6:7], src_private_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s7, v5
; GFX90A-NEXT:    ; implicit-def: $vgpr0
; GFX90A-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX90A-NEXT:    s_xor_b64 s[6:7], exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB14_5
; GFX90A-NEXT:  ; %bb.4: ; %atomicrmw.global
; GFX90A-NEXT:    global_atomic_add_f32 v0, v[4:5], v2, off glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:  .LBB14_5: ; %Flow
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB14_7
; GFX90A-NEXT:  ; %bb.6: ; %atomicrmw.private
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v1, -1, v4, vcc
; GFX90A-NEXT:    buffer_load_dword v0, v1, s[0:3], 0 offen
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_add_f32_e32 v2, v0, v2
; GFX90A-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; GFX90A-NEXT:  .LBB14_7: ; %Flow1
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execz .LBB14_2
; GFX90A-NEXT:  .LBB14_8: ; %atomicrmw.shared
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v4, vcc
; GFX90A-NEXT:    ds_add_rtn_f32 v0, v0, v2
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_ret_f32__offset12b_neg__ftz__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v3, vcc, 0xfffff800, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v4, vcc, -1, v1, vcc
; GFX908-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff800, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX908-NEXT:    flat_load_dword v0, v[0:1]
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB14_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v1, v0
; GFX908-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX908-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB14_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_ret_f32__offset12b_neg__ftz__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0xfffff800, v0
; GFX8-NEXT:    v_addc_u32_e32 v4, vcc, -1, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[3:4]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB14_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, v0
; GFX8-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX8-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB14_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_ret_f32__offset12b_neg__ftz__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v3, vcc, 0xfffff800, v0
; GFX7-NEXT:    v_addc_u32_e32 v4, vcc, -1, v1, vcc
; GFX7-NEXT:    flat_load_dword v0, v[3:4]
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB14_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v1, v0
; GFX7-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX7-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB14_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr %ptr, i64 -512
  %result = atomicrmw fadd ptr %gep, float %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret float %result
}

define void @flat_agent_atomic_fadd_noret_f32__ftz__amdgpu_no_fine_grained_memory(ptr %ptr, float %val) #1 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_f32__ftz__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_add_f32 v[0:1], v2 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_f32__ftz__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_add_f32 v[0:1], v2
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_f32__ftz__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_add_f32 v[0:1], v2
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_f32__ftz__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_load_dword v4, v[0:1]
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB15_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB15_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_f32__ftz__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v1
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX90A-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB15_3
; GFX90A-NEXT:  ; %bb.1: ; %Flow2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB15_8
; GFX90A-NEXT:  .LBB15_2: ; %atomicrmw.phi
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
; GFX90A-NEXT:  .LBB15_3: ; %atomicrmw.check.private
; GFX90A-NEXT:    s_mov_b64 s[6:7], src_private_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s7, v1
; GFX90A-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX90A-NEXT:    s_xor_b64 s[6:7], exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB15_5
; GFX90A-NEXT:  ; %bb.4: ; %atomicrmw.global
; GFX90A-NEXT:    global_atomic_add_f32 v[0:1], v2, off
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:  .LBB15_5: ; %Flow
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB15_7
; GFX90A-NEXT:  ; %bb.6: ; %atomicrmw.private
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX90A-NEXT:    buffer_load_dword v1, v0, s[0:3], 0 offen
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX90A-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; GFX90A-NEXT:  .LBB15_7: ; %Flow1
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execz .LBB15_2
; GFX90A-NEXT:  .LBB15_8: ; %atomicrmw.shared
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX90A-NEXT:    ds_add_f32 v0, v2
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_f32__ftz__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX908-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v1
; GFX908-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX908-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB15_3
; GFX908-NEXT:  ; %bb.1: ; %Flow2
; GFX908-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB15_8
; GFX908-NEXT:  .LBB15_2: ; %atomicrmw.phi
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
; GFX908-NEXT:  .LBB15_3: ; %atomicrmw.check.private
; GFX908-NEXT:    s_mov_b64 s[6:7], src_private_base
; GFX908-NEXT:    v_cmp_ne_u32_e32 vcc, s7, v1
; GFX908-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX908-NEXT:    s_xor_b64 s[6:7], exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execz .LBB15_5
; GFX908-NEXT:  ; %bb.4: ; %atomicrmw.global
; GFX908-NEXT:    global_atomic_add_f32 v[0:1], v2, off
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX908-NEXT:    ; implicit-def: $vgpr2
; GFX908-NEXT:  .LBB15_5: ; %Flow
; GFX908-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; GFX908-NEXT:    s_cbranch_execz .LBB15_7
; GFX908-NEXT:  ; %bb.6: ; %atomicrmw.private
; GFX908-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX908-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX908-NEXT:    buffer_load_dword v1, v0, s[0:3], 0 offen
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX908-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; GFX908-NEXT:  .LBB15_7: ; %Flow1
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX908-NEXT:    ; implicit-def: $vgpr2
; GFX908-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_cbranch_execz .LBB15_2
; GFX908-NEXT:  .LBB15_8: ; %atomicrmw.shared
; GFX908-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX908-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX908-NEXT:    ds_add_f32 v0, v2
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_f32__ftz__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB15_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB15_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_f32__ftz__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    flat_load_dword v4, v[0:1]
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB15_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX7-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v4, v3
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB15_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %unused = atomicrmw fadd ptr %ptr, float %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret void
}

define void @flat_agent_atomic_fadd_noret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory(ptr %ptr, float %val) #1 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_add_f32 v[0:1], v2 offset:2044 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_add_f32 v[0:1], v2 offset:2044
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_add_f32 v[0:1], v2 offset:2044
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0x7fc, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v4, v[0:1]
; GFX10-NEXT:  .LBB16_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB16_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v0, vcc, 0x7fc, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX90A-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v1
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX90A-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB16_3
; GFX90A-NEXT:  ; %bb.1: ; %Flow2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB16_8
; GFX90A-NEXT:  .LBB16_2: ; %atomicrmw.phi
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
; GFX90A-NEXT:  .LBB16_3: ; %atomicrmw.check.private
; GFX90A-NEXT:    s_mov_b64 s[6:7], src_private_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s7, v1
; GFX90A-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX90A-NEXT:    s_xor_b64 s[6:7], exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB16_5
; GFX90A-NEXT:  ; %bb.4: ; %atomicrmw.global
; GFX90A-NEXT:    global_atomic_add_f32 v[0:1], v2, off
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:  .LBB16_5: ; %Flow
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB16_7
; GFX90A-NEXT:  ; %bb.6: ; %atomicrmw.private
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX90A-NEXT:    buffer_load_dword v1, v0, s[0:3], 0 offen
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX90A-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; GFX90A-NEXT:  .LBB16_7: ; %Flow1
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execz .LBB16_2
; GFX90A-NEXT:  .LBB16_8: ; %atomicrmw.shared
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX90A-NEXT:    ds_add_f32 v0, v2
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v0, vcc, 0x7fc, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX908-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX908-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v1
; GFX908-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX908-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB16_3
; GFX908-NEXT:  ; %bb.1: ; %Flow2
; GFX908-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB16_8
; GFX908-NEXT:  .LBB16_2: ; %atomicrmw.phi
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
; GFX908-NEXT:  .LBB16_3: ; %atomicrmw.check.private
; GFX908-NEXT:    s_mov_b64 s[6:7], src_private_base
; GFX908-NEXT:    v_cmp_ne_u32_e32 vcc, s7, v1
; GFX908-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX908-NEXT:    s_xor_b64 s[6:7], exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execz .LBB16_5
; GFX908-NEXT:  ; %bb.4: ; %atomicrmw.global
; GFX908-NEXT:    global_atomic_add_f32 v[0:1], v2, off
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX908-NEXT:    ; implicit-def: $vgpr2
; GFX908-NEXT:  .LBB16_5: ; %Flow
; GFX908-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; GFX908-NEXT:    s_cbranch_execz .LBB16_7
; GFX908-NEXT:  ; %bb.6: ; %atomicrmw.private
; GFX908-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX908-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX908-NEXT:    buffer_load_dword v1, v0, s[0:3], 0 offen
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX908-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; GFX908-NEXT:  .LBB16_7: ; %Flow1
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX908-NEXT:    ; implicit-def: $vgpr2
; GFX908-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_cbranch_execz .LBB16_2
; GFX908-NEXT:  .LBB16_8: ; %atomicrmw.shared
; GFX908-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX908-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX908-NEXT:    ds_add_f32 v0, v2
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB16_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB16_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, 0x7fc, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    flat_load_dword v4, v[0:1]
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB16_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX7-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v4, v3
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB16_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr %ptr, i64 511
  %unused = atomicrmw fadd ptr %gep, float %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret void
}

define void @flat_agent_atomic_fadd_noret_f32__offset12b_neg__ftz__amdgpu_no_fine_grained_memory(ptr %ptr, float %val) #1 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_f32__offset12b_neg__ftz__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_add_f32 v[0:1], v2 offset:-2048 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_f32__offset12b_neg__ftz__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff800, v0
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_add_f32 v[0:1], v2
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_f32__offset12b_neg__ftz__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, 0xfffff800, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_add_f32 v[0:1], v2
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_f32__offset12b_neg__ftz__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0xfffff800, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v4, v[0:1]
; GFX10-NEXT:  .LBB17_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB17_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_f32__offset12b_neg__ftz__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff800, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX90A-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v1
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX90A-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB17_3
; GFX90A-NEXT:  ; %bb.1: ; %Flow2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB17_8
; GFX90A-NEXT:  .LBB17_2: ; %atomicrmw.phi
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
; GFX90A-NEXT:  .LBB17_3: ; %atomicrmw.check.private
; GFX90A-NEXT:    s_mov_b64 s[6:7], src_private_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s7, v1
; GFX90A-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX90A-NEXT:    s_xor_b64 s[6:7], exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB17_5
; GFX90A-NEXT:  ; %bb.4: ; %atomicrmw.global
; GFX90A-NEXT:    global_atomic_add_f32 v[0:1], v2, off
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:  .LBB17_5: ; %Flow
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB17_7
; GFX90A-NEXT:  ; %bb.6: ; %atomicrmw.private
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX90A-NEXT:    buffer_load_dword v1, v0, s[0:3], 0 offen
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX90A-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; GFX90A-NEXT:  .LBB17_7: ; %Flow1
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execz .LBB17_2
; GFX90A-NEXT:  .LBB17_8: ; %atomicrmw.shared
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX90A-NEXT:    ds_add_f32 v0, v2
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_f32__offset12b_neg__ftz__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff800, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX908-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX908-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v1
; GFX908-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX908-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB17_3
; GFX908-NEXT:  ; %bb.1: ; %Flow2
; GFX908-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB17_8
; GFX908-NEXT:  .LBB17_2: ; %atomicrmw.phi
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
; GFX908-NEXT:  .LBB17_3: ; %atomicrmw.check.private
; GFX908-NEXT:    s_mov_b64 s[6:7], src_private_base
; GFX908-NEXT:    v_cmp_ne_u32_e32 vcc, s7, v1
; GFX908-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX908-NEXT:    s_xor_b64 s[6:7], exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execz .LBB17_5
; GFX908-NEXT:  ; %bb.4: ; %atomicrmw.global
; GFX908-NEXT:    global_atomic_add_f32 v[0:1], v2, off
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX908-NEXT:    ; implicit-def: $vgpr2
; GFX908-NEXT:  .LBB17_5: ; %Flow
; GFX908-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; GFX908-NEXT:    s_cbranch_execz .LBB17_7
; GFX908-NEXT:  ; %bb.6: ; %atomicrmw.private
; GFX908-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX908-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX908-NEXT:    buffer_load_dword v1, v0, s[0:3], 0 offen
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX908-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; GFX908-NEXT:  .LBB17_7: ; %Flow1
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX908-NEXT:    ; implicit-def: $vgpr2
; GFX908-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_cbranch_execz .LBB17_2
; GFX908-NEXT:  .LBB17_8: ; %atomicrmw.shared
; GFX908-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX908-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX908-NEXT:    ds_add_f32 v0, v2
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_f32__offset12b_neg__ftz__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0xfffff800, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB17_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB17_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_f32__offset12b_neg__ftz__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, 0xfffff800, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX7-NEXT:    flat_load_dword v4, v[0:1]
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB17_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX7-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v4, v3
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB17_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr %ptr, i64 -512
  %unused = atomicrmw fadd ptr %gep, float %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret void
}

define float @flat_system_atomic_fadd_ret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory(ptr %ptr, float %val) #1 {
; GFX12-LABEL: flat_system_atomic_fadd_ret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 offset:2044 th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_system_atomic_fadd_ret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 offset:2044 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc0 sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_system_atomic_fadd_ret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 offset:2044 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_system_atomic_fadd_ret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fc, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v4, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v0, v[3:4]
; GFX10-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, v0
; GFX10-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB18_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_system_atomic_fadd_ret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v4, vcc, 0x7fc, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v1, vcc
; GFX90A-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v5
; GFX90A-NEXT:    ; implicit-def: $vgpr0
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX90A-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB18_3
; GFX90A-NEXT:  ; %bb.1: ; %Flow2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB18_8
; GFX90A-NEXT:  .LBB18_2: ; %atomicrmw.phi
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
; GFX90A-NEXT:  .LBB18_3: ; %atomicrmw.check.private
; GFX90A-NEXT:    s_mov_b64 s[6:7], src_private_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s7, v5
; GFX90A-NEXT:    ; implicit-def: $vgpr0
; GFX90A-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX90A-NEXT:    s_xor_b64 s[6:7], exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB18_5
; GFX90A-NEXT:  ; %bb.4: ; %atomicrmw.global
; GFX90A-NEXT:    buffer_wbl2
; GFX90A-NEXT:    global_atomic_add_f32 v0, v[4:5], v2, off glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_invl2
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:  .LBB18_5: ; %Flow
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB18_7
; GFX90A-NEXT:  ; %bb.6: ; %atomicrmw.private
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v1, -1, v4, vcc
; GFX90A-NEXT:    buffer_load_dword v0, v1, s[0:3], 0 offen
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_add_f32_e32 v2, v0, v2
; GFX90A-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; GFX90A-NEXT:  .LBB18_7: ; %Flow1
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execz .LBB18_2
; GFX90A-NEXT:  .LBB18_8: ; %atomicrmw.shared
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v4, vcc
; GFX90A-NEXT:    ds_add_rtn_f32 v0, v0, v2
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_system_atomic_fadd_ret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v3, v[0:1] offset:2044
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] offset:2044 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB18_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_system_atomic_fadd_ret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v4, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[3:4]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, v0
; GFX8-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX8-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB18_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_system_atomic_fadd_ret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v3, vcc, 0x7fc, v0
; GFX7-NEXT:    v_addc_u32_e32 v4, vcc, 0, v1, vcc
; GFX7-NEXT:    flat_load_dword v0, v[3:4]
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v1, v0
; GFX7-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX7-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB18_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr %ptr, i64 511
  %result = atomicrmw fadd ptr %gep, float %val seq_cst, !amdgpu.no.fine.grained.memory !0
  ret float %result
}

define void @flat_system_atomic_fadd_noret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory(ptr %ptr, float %val) #1 {
; GFX12-LABEL: flat_system_atomic_fadd_noret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_add_f32 v[0:1], v2 offset:2044 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_system_atomic_fadd_noret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-NEXT:    flat_atomic_add_f32 v[0:1], v2 offset:2044 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc0 sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_system_atomic_fadd_noret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_add_f32 v[0:1], v2 offset:2044
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_system_atomic_fadd_noret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0x7fc, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v4, v[0:1]
; GFX10-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB19_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_system_atomic_fadd_noret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v0, vcc, 0x7fc, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX90A-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v1
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX90A-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB19_3
; GFX90A-NEXT:  ; %bb.1: ; %Flow2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB19_8
; GFX90A-NEXT:  .LBB19_2: ; %atomicrmw.phi
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
; GFX90A-NEXT:  .LBB19_3: ; %atomicrmw.check.private
; GFX90A-NEXT:    s_mov_b64 s[6:7], src_private_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s7, v1
; GFX90A-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX90A-NEXT:    s_xor_b64 s[6:7], exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB19_5
; GFX90A-NEXT:  ; %bb.4: ; %atomicrmw.global
; GFX90A-NEXT:    buffer_wbl2
; GFX90A-NEXT:    global_atomic_add_f32 v[0:1], v2, off
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_invl2
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:  .LBB19_5: ; %Flow
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB19_7
; GFX90A-NEXT:  ; %bb.6: ; %atomicrmw.private
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX90A-NEXT:    buffer_load_dword v1, v0, s[0:3], 0 offen
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX90A-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; GFX90A-NEXT:  .LBB19_7: ; %Flow1
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execz .LBB19_2
; GFX90A-NEXT:  .LBB19_8: ; %atomicrmw.shared
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX90A-NEXT:    ds_add_f32 v0, v2
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_system_atomic_fadd_noret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v0, vcc, 0x7fc, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX908-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX908-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v1
; GFX908-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX908-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB19_3
; GFX908-NEXT:  ; %bb.1: ; %Flow2
; GFX908-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB19_8
; GFX908-NEXT:  .LBB19_2: ; %atomicrmw.phi
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
; GFX908-NEXT:  .LBB19_3: ; %atomicrmw.check.private
; GFX908-NEXT:    s_mov_b64 s[6:7], src_private_base
; GFX908-NEXT:    v_cmp_ne_u32_e32 vcc, s7, v1
; GFX908-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX908-NEXT:    s_xor_b64 s[6:7], exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execz .LBB19_5
; GFX908-NEXT:  ; %bb.4: ; %atomicrmw.global
; GFX908-NEXT:    global_atomic_add_f32 v[0:1], v2, off
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX908-NEXT:    ; implicit-def: $vgpr2
; GFX908-NEXT:  .LBB19_5: ; %Flow
; GFX908-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; GFX908-NEXT:    s_cbranch_execz .LBB19_7
; GFX908-NEXT:  ; %bb.6: ; %atomicrmw.private
; GFX908-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX908-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX908-NEXT:    buffer_load_dword v1, v0, s[0:3], 0 offen
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX908-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; GFX908-NEXT:  .LBB19_7: ; %Flow1
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX908-NEXT:    ; implicit-def: $vgpr2
; GFX908-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_cbranch_execz .LBB19_2
; GFX908-NEXT:  .LBB19_8: ; %atomicrmw.shared
; GFX908-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX908-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX908-NEXT:    ds_add_f32 v0, v2
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_system_atomic_fadd_noret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB19_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_system_atomic_fadd_noret_f32__offset12b_pos__ftz__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, 0x7fc, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    flat_load_dword v4, v[0:1]
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX7-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v4, v3
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB19_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr %ptr, i64 511
  %unused = atomicrmw fadd ptr %gep, float %val seq_cst, !amdgpu.no.fine.grained.memory !0
  ret void
}

define float @flat_agent_atomic_fadd_ret_f32__ieee__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode(ptr %ptr, float %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_ret_f32__ieee__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 offset:2044 th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_ret_f32__ieee__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 offset:2044 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc0 sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_ret_f32__ieee__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 offset:2044 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_ret_f32__ieee__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fc, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v4, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v0, v[3:4]
; GFX10-NEXT:  .LBB20_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, v0
; GFX10-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB20_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_ret_f32__ieee__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v4, vcc, 0x7fc, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v1, vcc
; GFX90A-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v5
; GFX90A-NEXT:    ; implicit-def: $vgpr0
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX90A-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB20_3
; GFX90A-NEXT:  ; %bb.1: ; %Flow2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB20_8
; GFX90A-NEXT:  .LBB20_2: ; %atomicrmw.phi
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
; GFX90A-NEXT:  .LBB20_3: ; %atomicrmw.check.private
; GFX90A-NEXT:    s_mov_b64 s[6:7], src_private_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s7, v5
; GFX90A-NEXT:    ; implicit-def: $vgpr0
; GFX90A-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX90A-NEXT:    s_xor_b64 s[6:7], exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB20_5
; GFX90A-NEXT:  ; %bb.4: ; %atomicrmw.global
; GFX90A-NEXT:    buffer_wbl2
; GFX90A-NEXT:    global_atomic_add_f32 v0, v[4:5], v2, off glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_invl2
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:  .LBB20_5: ; %Flow
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB20_7
; GFX90A-NEXT:  ; %bb.6: ; %atomicrmw.private
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v1, -1, v4, vcc
; GFX90A-NEXT:    buffer_load_dword v0, v1, s[0:3], 0 offen
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_add_f32_e32 v2, v0, v2
; GFX90A-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; GFX90A-NEXT:  .LBB20_7: ; %Flow1
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execz .LBB20_2
; GFX90A-NEXT:  .LBB20_8: ; %atomicrmw.shared
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v4, vcc
; GFX90A-NEXT:    ds_add_rtn_f32 v0, v0, v2
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_ret_f32__ieee__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v3, v[0:1] offset:2044
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB20_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] offset:2044 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB20_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_ret_f32__ieee__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v4, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[3:4]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB20_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, v0
; GFX8-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX8-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB20_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_ret_f32__ieee__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v3, vcc, 0x7fc, v0
; GFX7-NEXT:    v_addc_u32_e32 v4, vcc, 0, v1, vcc
; GFX7-NEXT:    flat_load_dword v0, v[3:4]
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB20_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v1, v0
; GFX7-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX7-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB20_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr %ptr, i64 511
  %result = atomicrmw fadd ptr %gep, float %val seq_cst, !amdgpu.no.fine.grained.memory !0, !amdgpu.ignore.denormal.mode !0
  ret float %result
}

define void @flat_agent_atomic_fadd_noret_f32__ieee__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode(ptr %ptr, float %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_f32__ieee__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_add_f32 v[0:1], v2 offset:2044 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_f32__ieee__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-NEXT:    flat_atomic_add_f32 v[0:1], v2 offset:2044 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc0 sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_f32__ieee__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_add_f32 v[0:1], v2 offset:2044
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_f32__ieee__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0x7fc, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v4, v[0:1]
; GFX10-NEXT:  .LBB21_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB21_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_f32__ieee__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v0, vcc, 0x7fc, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX90A-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v1
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX90A-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB21_3
; GFX90A-NEXT:  ; %bb.1: ; %Flow2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB21_8
; GFX90A-NEXT:  .LBB21_2: ; %atomicrmw.phi
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
; GFX90A-NEXT:  .LBB21_3: ; %atomicrmw.check.private
; GFX90A-NEXT:    s_mov_b64 s[6:7], src_private_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s7, v1
; GFX90A-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX90A-NEXT:    s_xor_b64 s[6:7], exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB21_5
; GFX90A-NEXT:  ; %bb.4: ; %atomicrmw.global
; GFX90A-NEXT:    buffer_wbl2
; GFX90A-NEXT:    global_atomic_add_f32 v[0:1], v2, off
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_invl2
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:  .LBB21_5: ; %Flow
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB21_7
; GFX90A-NEXT:  ; %bb.6: ; %atomicrmw.private
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX90A-NEXT:    buffer_load_dword v1, v0, s[0:3], 0 offen
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX90A-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; GFX90A-NEXT:  .LBB21_7: ; %Flow1
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execz .LBB21_2
; GFX90A-NEXT:  .LBB21_8: ; %atomicrmw.shared
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX90A-NEXT:    ds_add_f32 v0, v2
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_f32__ieee__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v0, vcc, 0x7fc, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX908-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX908-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v1
; GFX908-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX908-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB21_3
; GFX908-NEXT:  ; %bb.1: ; %Flow2
; GFX908-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB21_8
; GFX908-NEXT:  .LBB21_2: ; %atomicrmw.phi
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
; GFX908-NEXT:  .LBB21_3: ; %atomicrmw.check.private
; GFX908-NEXT:    s_mov_b64 s[6:7], src_private_base
; GFX908-NEXT:    v_cmp_ne_u32_e32 vcc, s7, v1
; GFX908-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX908-NEXT:    s_xor_b64 s[6:7], exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execz .LBB21_5
; GFX908-NEXT:  ; %bb.4: ; %atomicrmw.global
; GFX908-NEXT:    global_atomic_add_f32 v[0:1], v2, off
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX908-NEXT:    ; implicit-def: $vgpr2
; GFX908-NEXT:  .LBB21_5: ; %Flow
; GFX908-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; GFX908-NEXT:    s_cbranch_execz .LBB21_7
; GFX908-NEXT:  ; %bb.6: ; %atomicrmw.private
; GFX908-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX908-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX908-NEXT:    buffer_load_dword v1, v0, s[0:3], 0 offen
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX908-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; GFX908-NEXT:  .LBB21_7: ; %Flow1
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX908-NEXT:    ; implicit-def: $vgpr2
; GFX908-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_cbranch_execz .LBB21_2
; GFX908-NEXT:  .LBB21_8: ; %atomicrmw.shared
; GFX908-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX908-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX908-NEXT:    ds_add_f32 v0, v2
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_f32__ieee__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB21_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB21_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_f32__ieee__amdgpu_no_fine_grained_memory__amdgpu_ignore_denormal_mode:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, 0x7fc, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    flat_load_dword v4, v[0:1]
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB21_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX7-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v4, v3
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB21_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr %ptr, i64 511
  %unused = atomicrmw fadd ptr %gep, float %val seq_cst, !amdgpu.no.fine.grained.memory !0, !amdgpu.ignore.denormal.mode !0
  ret void
}

define float @flat_agent_atomic_fadd_ret_f32__amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode(ptr %ptr, float %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_b32 v3, v[0:1]
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB22_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[3:4] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB22_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_load_dword v3, v[0:1]
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB22_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB22_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    flat_load_dword v3, v[0:1]
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB22_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX90A-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[4:5] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB22_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v3, v[0:1]
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB22_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB22_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB22_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB22_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v0, v3
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    flat_load_dword v3, v[0:1]
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB22_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v4, v3
; GFX7-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX7-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB22_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v0, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr %ptr, float %val syncscope("agent") seq_cst, !amdgpu.no.remote.memory !0, !amdgpu.ignore.denormal.mode !0
  ret float %result
}

define void @flat_agent_atomic_fadd_noret_f32__amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode(ptr %ptr, float %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_add_f32 v[0:1], v2 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_add_f32 v[0:1], v2
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_b32 v4, v[0:1]
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB23_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[3:4] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB23_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_load_dword v4, v[0:1]
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB23_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB23_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    flat_load_dword v5, v[0:1]
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB23_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX90A-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[4:5] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB23_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v4, v[0:1]
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB23_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB23_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB23_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB23_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    flat_load_dword v4, v[0:1]
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB23_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX7-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v4, v3
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB23_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %unused = atomicrmw fadd ptr %ptr, float %val syncscope("agent") seq_cst, !amdgpu.no.remote.memory !0, !amdgpu.ignore.denormal.mode !0
  ret void
}

define float @flat_agent_atomic_fadd_ret_f32__amdgpu_no_remote_memory(ptr %ptr, float %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_remote_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_remote_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_remote_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_b32 v3, v[0:1]
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB24_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[3:4] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB24_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_remote_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_load_dword v3, v[0:1]
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB24_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB24_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_remote_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    flat_load_dword v3, v[0:1]
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB24_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX90A-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[4:5] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB24_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_remote_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v3, v[0:1]
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB24_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB24_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_remote_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB24_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB24_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v0, v3
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_remote_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    flat_load_dword v3, v[0:1]
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB24_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v4, v3
; GFX7-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX7-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB24_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v0, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr %ptr, float %val syncscope("agent") seq_cst, !amdgpu.no.remote.memory !0
  ret float %result
}

define void @flat_agent_atomic_fadd_noret_f32__amdgpu_no_remote_memory(ptr %ptr, float %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_remote_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_add_f32 v[0:1], v2 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_remote_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_add_f32 v[0:1], v2
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_remote_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_b32 v4, v[0:1]
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB25_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[3:4] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB25_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_remote_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_load_dword v4, v[0:1]
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB25_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB25_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_remote_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    flat_load_dword v5, v[0:1]
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB25_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX90A-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[4:5] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB25_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_remote_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v4, v[0:1]
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB25_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB25_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_remote_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB25_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB25_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_remote_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    flat_load_dword v4, v[0:1]
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB25_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX7-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v4, v3
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB25_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %unused = atomicrmw fadd ptr %ptr, float %val syncscope("agent") seq_cst, !amdgpu.no.remote.memory !0
  ret void
}

define float @flat_agent_atomic_fadd_ret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode(ptr %ptr, float %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_load_dword v3, v[0:1]
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB26_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB26_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v1
; GFX90A-NEXT:    ; implicit-def: $vgpr3
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX90A-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execz .LBB26_6
; GFX90A-NEXT:  ; %bb.1: ; %atomicrmw.check.private
; GFX90A-NEXT:    s_mov_b64 s[6:7], src_private_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s7, v1
; GFX90A-NEXT:    ; implicit-def: $vgpr3
; GFX90A-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX90A-NEXT:    s_xor_b64 s[6:7], exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB26_3
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.global
; GFX90A-NEXT:    global_atomic_add_f32 v3, v[0:1], v2, off glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:  .LBB26_3: ; %Flow
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB26_5
; GFX90A-NEXT:  ; %bb.4: ; %atomicrmw.private
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX90A-NEXT:    buffer_load_dword v3, v0, s[0:3], 0 offen
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_add_f32_e32 v1, v3, v2
; GFX90A-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; GFX90A-NEXT:  .LBB26_5: ; %Flow1
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:  .LBB26_6: ; %Flow2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execz .LBB26_8
; GFX90A-NEXT:  ; %bb.7: ; %atomicrmw.shared
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX90A-NEXT:    ds_add_rtn_f32 v3, v0, v2
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:  .LBB26_8: ; %atomicrmw.phi
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v3, v[0:1]
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB26_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB26_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB26_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB26_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v0, v3
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    flat_load_dword v3, v[0:1]
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB26_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v4, v3
; GFX7-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX7-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB26_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v0, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr %ptr, float %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0, !amdgpu.no.remote.memory !0, !amdgpu.ignore.denormal.mode !0
  ret float %result
}

define void @flat_agent_atomic_fadd_noret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode(ptr %ptr, float %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_add_f32 v[0:1], v2 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_add_f32 v[0:1], v2
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_add_f32 v[0:1], v2
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_load_dword v4, v[0:1]
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB27_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB27_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v1
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX90A-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB27_3
; GFX90A-NEXT:  ; %bb.1: ; %Flow2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB27_8
; GFX90A-NEXT:  .LBB27_2: ; %atomicrmw.phi
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
; GFX90A-NEXT:  .LBB27_3: ; %atomicrmw.check.private
; GFX90A-NEXT:    s_mov_b64 s[6:7], src_private_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s7, v1
; GFX90A-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX90A-NEXT:    s_xor_b64 s[6:7], exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB27_5
; GFX90A-NEXT:  ; %bb.4: ; %atomicrmw.global
; GFX90A-NEXT:    global_atomic_add_f32 v[0:1], v2, off
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:  .LBB27_5: ; %Flow
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; GFX90A-NEXT:    s_cbranch_execz .LBB27_7
; GFX90A-NEXT:  ; %bb.6: ; %atomicrmw.private
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX90A-NEXT:    buffer_load_dword v1, v0, s[0:3], 0 offen
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX90A-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; GFX90A-NEXT:  .LBB27_7: ; %Flow1
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    ; implicit-def: $vgpr2
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execz .LBB27_2
; GFX90A-NEXT:  .LBB27_8: ; %atomicrmw.shared
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX90A-NEXT:    ds_add_f32 v0, v2
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX908-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v1
; GFX908-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX908-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB27_3
; GFX908-NEXT:  ; %bb.1: ; %Flow2
; GFX908-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB27_8
; GFX908-NEXT:  .LBB27_2: ; %atomicrmw.phi
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
; GFX908-NEXT:  .LBB27_3: ; %atomicrmw.check.private
; GFX908-NEXT:    s_mov_b64 s[6:7], src_private_base
; GFX908-NEXT:    v_cmp_ne_u32_e32 vcc, s7, v1
; GFX908-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX908-NEXT:    s_xor_b64 s[6:7], exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execz .LBB27_5
; GFX908-NEXT:  ; %bb.4: ; %atomicrmw.global
; GFX908-NEXT:    global_atomic_add_f32 v[0:1], v2, off
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX908-NEXT:    ; implicit-def: $vgpr2
; GFX908-NEXT:  .LBB27_5: ; %Flow
; GFX908-NEXT:    s_andn2_saveexec_b64 s[6:7], s[6:7]
; GFX908-NEXT:    s_cbranch_execz .LBB27_7
; GFX908-NEXT:  ; %bb.6: ; %atomicrmw.private
; GFX908-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX908-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX908-NEXT:    buffer_load_dword v1, v0, s[0:3], 0 offen
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX908-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; GFX908-NEXT:  .LBB27_7: ; %Flow1
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX908-NEXT:    ; implicit-def: $vgpr2
; GFX908-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_cbranch_execz .LBB27_2
; GFX908-NEXT:  .LBB27_8: ; %atomicrmw.shared
; GFX908-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX908-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; GFX908-NEXT:    ds_add_f32 v0, v2
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB27_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB27_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory__amdgpu_ignore_denormal_mode:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    flat_load_dword v4, v[0:1]
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB27_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX7-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v4, v3
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB27_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr %ptr, float %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0, !amdgpu.no.remote.memory !0, !amdgpu.ignore.denormal.mode !0
  ret void
}

define float @flat_agent_atomic_fadd_ret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory(ptr %ptr, float %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_add_f32 v0, v[0:1], v2 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_load_dword v3, v[0:1]
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB28_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB28_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    flat_load_dword v3, v[0:1]
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB28_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX90A-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[4:5] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB28_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v3, v[0:1]
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB28_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB28_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB28_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB28_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v0, v3
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_ret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    flat_load_dword v3, v[0:1]
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB28_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v4, v3
; GFX7-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX7-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB28_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v0, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr %ptr, float %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0, !amdgpu.no.remote.memory !0
  ret float %result
}

define void @flat_agent_atomic_fadd_noret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory(ptr %ptr, float %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_add_f32 v[0:1], v2 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_add_f32 v[0:1], v2
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_add_f32 v[0:1], v2
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_load_dword v4, v[0:1]
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB29_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB29_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    flat_load_dword v5, v[0:1]
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB29_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX90A-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[4:5] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB29_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v4, v[0:1]
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB29_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB29_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB29_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB29_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_f32__amdgpu_no_fine_grained_memory_amdgpu_no_remote_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    flat_load_dword v4, v[0:1]
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB29_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX7-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v4, v3
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB29_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr %ptr, float %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0, !amdgpu.no.remote.memory !0
  ret void
}

; --------------------------------------------------------------------
; double
; --------------------------------------------------------------------

define double @flat_agent_atomic_fadd_ret_f64__amdgpu_no_fine_grained_memory(ptr %ptr, double %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_ret_f64__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_mov_b64 s[0:1], src_private_base
; GFX12-NEXT:    s_mov_b32 s0, exec_lo
; GFX12-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    v_cmpx_ne_u32_e64 s1, v1
; GFX12-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execz .LBB30_4
; GFX12-NEXT:  ; %bb.1: ; %atomicrmw.global
; GFX12-NEXT:    flat_load_b64 v[4:5], v[0:1]
; GFX12-NEXT:    s_mov_b32 s1, 0
; GFX12-NEXT:  .LBB30_2: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v7, v5 :: v_dual_mov_b32 v6, v4
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_add_f64_e32 v[4:5], v[6:7], v[2:3]
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_cmpswap_b64 v[4:5], v[0:1], v[4:7] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[4:5], v[6:7]
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX12-NEXT:    s_cbranch_execnz .LBB30_2
; GFX12-NEXT:  ; %bb.3: ; %Flow
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX12-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX12-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX12-NEXT:  .LBB30_4: ; %Flow3
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX12-NEXT:    s_cbranch_execz .LBB30_6
; GFX12-NEXT:  ; %bb.5: ; %atomicrmw.private
; GFX12-NEXT:    v_cmp_ne_u64_e32 vcc_lo, 0, v[0:1]
; GFX12-NEXT:    v_cndmask_b32_e32 v6, -1, v0, vcc_lo
; GFX12-NEXT:    scratch_load_b64 v[4:5], v6, off
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_add_f64_e32 v[0:1], v[4:5], v[2:3]
; GFX12-NEXT:    scratch_store_b64 v6, v[0:1], off
; GFX12-NEXT:  .LBB30_6: ; %atomicrmw.phi
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    v_dual_mov_b32 v0, v4 :: v_dual_mov_b32 v1, v5
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_ret_f64__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v5, v1
; GFX940-NEXT:    s_mov_b64 s[0:1], src_private_base
; GFX940-NEXT:    v_mov_b32_e32 v4, v0
; GFX940-NEXT:    v_cmp_ne_u32_e32 vcc, s1, v5
; GFX940-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX940-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX940-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB30_3
; GFX940-NEXT:  ; %bb.1: ; %Flow
; GFX940-NEXT:    s_andn2_saveexec_b64 s[0:1], s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB30_4
; GFX940-NEXT:  .LBB30_2: ; %atomicrmw.phi
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
; GFX940-NEXT:  .LBB30_3: ; %atomicrmw.global
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_add_f64 v[0:1], v[4:5], v[2:3] sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX940-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX940-NEXT:    s_andn2_saveexec_b64 s[0:1], s[0:1]
; GFX940-NEXT:    s_cbranch_execz .LBB30_2
; GFX940-NEXT:  .LBB30_4: ; %atomicrmw.private
; GFX940-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[4:5]
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v4, -1, v4, vcc
; GFX940-NEXT:    scratch_load_dwordx2 v[0:1], v4, off
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_add_f64 v[2:3], v[0:1], v[2:3]
; GFX940-NEXT:    scratch_store_dwordx2 v4, v[2:3], off sc0 sc1
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_ret_f64__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b64 s[0:1], src_private_base
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX11-NEXT:    v_cmpx_ne_u32_e64 s1, v1
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execz .LBB30_4
; GFX11-NEXT:  ; %bb.1: ; %atomicrmw.global
; GFX11-NEXT:    flat_load_b64 v[4:5], v[0:1]
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:  .LBB30_2: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v7, v5 :: v_dual_mov_b32 v6, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b64 v[4:5], v[0:1], v[4:7] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[4:5], v[6:7]
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB30_2
; GFX11-NEXT:  ; %bb.3: ; %Flow
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX11-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX11-NEXT:  .LBB30_4: ; %Flow3
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB30_6
; GFX11-NEXT:  ; %bb.5: ; %atomicrmw.private
; GFX11-NEXT:    v_cmp_ne_u64_e32 vcc_lo, 0, v[0:1]
; GFX11-NEXT:    v_cndmask_b32_e32 v6, -1, v0, vcc_lo
; GFX11-NEXT:    scratch_load_b64 v[4:5], v6, off
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_f64 v[0:1], v[4:5], v[2:3]
; GFX11-NEXT:    scratch_store_b64 v6, v[0:1], off
; GFX11-NEXT:  .LBB30_6: ; %atomicrmw.phi
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_dual_mov_b32 v0, v4 :: v_dual_mov_b32 v1, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_ret_f64__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_mov_b64 s[4:5], src_private_base
; GFX10-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX10-NEXT:    v_cmp_ne_u32_e32 vcc_lo, s5, v1
; GFX10-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX10-NEXT:    s_xor_b32 s4, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execz .LBB30_4
; GFX10-NEXT:  ; %bb.1: ; %atomicrmw.global
; GFX10-NEXT:    flat_load_dwordx2 v[4:5], v[0:1]
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:  .LBB30_2: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v7, v5
; GFX10-NEXT:    v_mov_b32_e32 v6, v4
; GFX10-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap_x2 v[4:5], v[0:1], v[4:7] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[4:5], v[6:7]
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB30_2
; GFX10-NEXT:  ; %bb.3: ; %Flow
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX10-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX10-NEXT:  .LBB30_4: ; %Flow3
; GFX10-NEXT:    s_andn2_saveexec_b32 s4, s4
; GFX10-NEXT:    s_cbranch_execz .LBB30_6
; GFX10-NEXT:  ; %bb.5: ; %atomicrmw.private
; GFX10-NEXT:    v_cmp_ne_u64_e32 vcc_lo, 0, v[0:1]
; GFX10-NEXT:    v_cndmask_b32_e32 v6, -1, v0, vcc_lo
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    buffer_load_dword v4, v6, s[0:3], 0 offen
; GFX10-NEXT:    buffer_load_dword v5, v6, s[0:3], 0 offen offset:4
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_add_f64 v[0:1], v[4:5], v[2:3]
; GFX10-NEXT:    buffer_store_dword v0, v6, s[0:3], 0 offen
; GFX10-NEXT:    buffer_store_dword v1, v6, s[0:3], 0 offen offset:4
; GFX10-NEXT:  .LBB30_6: ; %atomicrmw.phi
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_mov_b32_e32 v0, v4
; GFX10-NEXT:    v_mov_b32_e32 v1, v5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_ret_f64__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v5, v1
; GFX90A-NEXT:    s_mov_b64 s[4:5], src_private_base
; GFX90A-NEXT:    v_mov_b32_e32 v4, v0
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v5
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX90A-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB30_3
; GFX90A-NEXT:  ; %bb.1: ; %Flow
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB30_4
; GFX90A-NEXT:  .LBB30_2: ; %atomicrmw.phi
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
; GFX90A-NEXT:  .LBB30_3: ; %atomicrmw.global
; GFX90A-NEXT:    flat_atomic_add_f64 v[0:1], v[4:5], v[2:3] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX90A-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execz .LBB30_2
; GFX90A-NEXT:  .LBB30_4: ; %atomicrmw.private
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v4, -1, v4, vcc
; GFX90A-NEXT:    buffer_load_dword v0, v4, s[0:3], 0 offen
; GFX90A-NEXT:    buffer_load_dword v1, v4, s[0:3], 0 offen offset:4
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_add_f64 v[2:3], v[0:1], v[2:3]
; GFX90A-NEXT:    buffer_store_dword v2, v4, s[0:3], 0 offen
; GFX90A-NEXT:    buffer_store_dword v3, v4, s[0:3], 0 offen offset:4
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_ret_f64__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    s_mov_b64 s[4:5], src_private_base
; GFX908-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v1
; GFX908-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX908-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX908-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execz .LBB30_4
; GFX908-NEXT:  ; %bb.1: ; %atomicrmw.global
; GFX908-NEXT:    flat_load_dwordx2 v[4:5], v[0:1]
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:  .LBB30_2: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v7, v5
; GFX908-NEXT:    v_mov_b32_e32 v6, v4
; GFX908-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX908-NEXT:    flat_atomic_cmpswap_x2 v[4:5], v[0:1], v[4:7] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[6:7]
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB30_2
; GFX908-NEXT:  ; %bb.3: ; %Flow
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX908-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX908-NEXT:  .LBB30_4: ; %Flow3
; GFX908-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_cbranch_execz .LBB30_6
; GFX908-NEXT:  ; %bb.5: ; %atomicrmw.private
; GFX908-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX908-NEXT:    v_cndmask_b32_e32 v6, -1, v0, vcc
; GFX908-NEXT:    buffer_load_dword v4, v6, s[0:3], 0 offen
; GFX908-NEXT:    buffer_load_dword v5, v6, s[0:3], 0 offen offset:4
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_add_f64 v[0:1], v[4:5], v[2:3]
; GFX908-NEXT:    buffer_store_dword v0, v6, s[0:3], 0 offen
; GFX908-NEXT:    buffer_store_dword v1, v6, s[0:3], 0 offen offset:4
; GFX908-NEXT:  .LBB30_6: ; %atomicrmw.phi
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v4
; GFX908-NEXT:    v_mov_b32_e32 v1, v5
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_ret_f64__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b64 s[4:5], 0xc0
; GFX8-NEXT:    s_load_dword s4, s[4:5], 0x0
; GFX8-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_cmp_ne_u32_e32 vcc, s4, v1
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execz .LBB30_4
; GFX8-NEXT:  ; %bb.1: ; %atomicrmw.global
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, 4, v0
; GFX8-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v5, v[4:5]
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:  .LBB30_2: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v7, v5
; GFX8-NEXT:    v_mov_b32_e32 v6, v4
; GFX8-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX8-NEXT:    flat_atomic_cmpswap_x2 v[4:5], v[0:1], v[4:7] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[6:7]
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB30_2
; GFX8-NEXT:  ; %bb.3: ; %Flow
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX8-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX8-NEXT:  .LBB30_4: ; %Flow3
; GFX8-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX8-NEXT:    s_cbranch_execz .LBB30_6
; GFX8-NEXT:  ; %bb.5: ; %atomicrmw.private
; GFX8-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX8-NEXT:    v_cndmask_b32_e32 v6, -1, v0, vcc
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, 4, v6
; GFX8-NEXT:    buffer_load_dword v4, v6, s[0:3], 0 offen
; GFX8-NEXT:    buffer_load_dword v5, v7, s[0:3], 0 offen
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_f64 v[0:1], v[4:5], v[2:3]
; GFX8-NEXT:    buffer_store_dword v0, v6, s[0:3], 0 offen
; GFX8-NEXT:    buffer_store_dword v1, v7, s[0:3], 0 offen
; GFX8-NEXT:  .LBB30_6: ; %atomicrmw.phi
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v0, v4
; GFX8-NEXT:    v_mov_b32_e32 v1, v5
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_ret_f64__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[4:5], 0xc0
; GFX7-NEXT:    s_load_dword s4, s[4:5], 0x0
; GFX7-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_ne_u32_e32 vcc, s4, v1
; GFX7-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX7-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execz .LBB30_4
; GFX7-NEXT:  ; %bb.1: ; %atomicrmw.global
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 4, v0
; GFX7-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; GFX7-NEXT:    flat_load_dword v5, v[4:5]
; GFX7-NEXT:    flat_load_dword v4, v[0:1]
; GFX7-NEXT:    s_mov_b64 s[6:7], 0
; GFX7-NEXT:  .LBB30_2: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v7, v5
; GFX7-NEXT:    v_mov_b32_e32 v6, v4
; GFX7-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX7-NEXT:    flat_atomic_cmpswap_x2 v[4:5], v[0:1], v[4:7] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[6:7]
; GFX7-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX7-NEXT:    s_cbranch_execnz .LBB30_2
; GFX7-NEXT:  ; %bb.3: ; %Flow
; GFX7-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX7-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX7-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX7-NEXT:  .LBB30_4: ; %Flow3
; GFX7-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX7-NEXT:    s_cbranch_execz .LBB30_6
; GFX7-NEXT:  ; %bb.5: ; %atomicrmw.private
; GFX7-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX7-NEXT:    v_cndmask_b32_e32 v6, -1, v0, vcc
; GFX7-NEXT:    v_add_i32_e32 v7, vcc, 4, v6
; GFX7-NEXT:    buffer_load_dword v4, v6, s[0:3], 0 offen
; GFX7-NEXT:    buffer_load_dword v5, v7, s[0:3], 0 offen
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_add_f64 v[0:1], v[4:5], v[2:3]
; GFX7-NEXT:    buffer_store_dword v0, v6, s[0:3], 0 offen
; GFX7-NEXT:    buffer_store_dword v1, v7, s[0:3], 0 offen
; GFX7-NEXT:  .LBB30_6: ; %atomicrmw.phi
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v0, v4
; GFX7-NEXT:    v_mov_b32_e32 v1, v5
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr %ptr, double %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret double %result
}

define double @flat_agent_atomic_fadd_ret_f64__offset12b_pos__amdgpu_no_fine_grained_memory(ptr %ptr, double %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_ret_f64__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_co_u32 v4, vcc_lo, 0x7f8, v0
; GFX12-NEXT:    v_add_co_ci_u32_e32 v5, vcc_lo, 0, v1, vcc_lo
; GFX12-NEXT:    s_mov_b64 s[0:1], src_private_base
; GFX12-NEXT:    s_mov_b32 s0, exec_lo
; GFX12-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_cmpx_ne_u32_e64 s1, v5
; GFX12-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB31_3
; GFX12-NEXT:  ; %bb.1: ; %Flow3
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB31_6
; GFX12-NEXT:  .LBB31_2: ; %atomicrmw.phi
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_setpc_b64 s[30:31]
; GFX12-NEXT:  .LBB31_3: ; %atomicrmw.global
; GFX12-NEXT:    flat_load_b64 v[0:1], v[4:5]
; GFX12-NEXT:    s_mov_b32 s1, 0
; GFX12-NEXT:  .LBB31_4: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v9, v1 :: v_dual_mov_b32 v8, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_add_f64_e32 v[6:7], v[8:9], v[2:3]
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_cmpswap_b64 v[0:1], v[4:5], v[6:9] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[8:9]
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX12-NEXT:    s_cbranch_execnz .LBB31_4
; GFX12-NEXT:  ; %bb.5: ; %Flow
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX12-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX12-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX12-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX12-NEXT:    s_cbranch_execz .LBB31_2
; GFX12-NEXT:  .LBB31_6: ; %atomicrmw.private
; GFX12-NEXT:    v_cmp_ne_u64_e32 vcc_lo, 0, v[4:5]
; GFX12-NEXT:    v_cndmask_b32_e32 v4, -1, v4, vcc_lo
; GFX12-NEXT:    scratch_load_b64 v[0:1], v4, off
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_add_f64_e32 v[2:3], v[0:1], v[2:3]
; GFX12-NEXT:    scratch_store_b64 v4, v[2:3], off
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_ret_f64__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_mov_b64 s[0:1], 0x7f8
; GFX940-NEXT:    v_lshl_add_u64 v[4:5], v[0:1], 0, s[0:1]
; GFX940-NEXT:    s_mov_b64 s[0:1], src_private_base
; GFX940-NEXT:    v_cmp_ne_u32_e32 vcc, s1, v5
; GFX940-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX940-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX940-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB31_3
; GFX940-NEXT:  ; %bb.1: ; %Flow
; GFX940-NEXT:    s_andn2_saveexec_b64 s[0:1], s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB31_4
; GFX940-NEXT:  .LBB31_2: ; %atomicrmw.phi
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
; GFX940-NEXT:  .LBB31_3: ; %atomicrmw.global
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_add_f64 v[0:1], v[4:5], v[2:3] sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX940-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX940-NEXT:    s_andn2_saveexec_b64 s[0:1], s[0:1]
; GFX940-NEXT:    s_cbranch_execz .LBB31_2
; GFX940-NEXT:  .LBB31_4: ; %atomicrmw.private
; GFX940-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[4:5]
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v4, -1, v4, vcc
; GFX940-NEXT:    scratch_load_dwordx2 v[0:1], v4, off
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_add_f64 v[2:3], v[0:1], v[2:3]
; GFX940-NEXT:    scratch_store_dwordx2 v4, v[2:3], off sc0 sc1
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_ret_f64__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, 0x7f8, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v5, vcc_lo, 0, v1, vcc_lo
; GFX11-NEXT:    s_mov_b64 s[0:1], src_private_base
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cmpx_ne_u32_e64 s1, v5
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB31_3
; GFX11-NEXT:  ; %bb.1: ; %Flow3
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB31_6
; GFX11-NEXT:  .LBB31_2: ; %atomicrmw.phi
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB31_3: ; %atomicrmw.global
; GFX11-NEXT:    flat_load_b64 v[0:1], v[4:5]
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:  .LBB31_4: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v9, v1 :: v_dual_mov_b32 v8, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_f64 v[6:7], v[8:9], v[2:3]
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b64 v[0:1], v[4:5], v[6:9] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[8:9]
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB31_4
; GFX11-NEXT:  ; %bb.5: ; %Flow
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX11-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB31_2
; GFX11-NEXT:  .LBB31_6: ; %atomicrmw.private
; GFX11-NEXT:    v_cmp_ne_u64_e32 vcc_lo, 0, v[4:5]
; GFX11-NEXT:    v_cndmask_b32_e32 v4, -1, v4, vcc_lo
; GFX11-NEXT:    scratch_load_b64 v[0:1], v4, off
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_f64 v[2:3], v[0:1], v[2:3]
; GFX11-NEXT:    scratch_store_b64 v4, v[2:3], off
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_ret_f64__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v4, vcc_lo, 0x7f8, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v5, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    s_mov_b64 s[4:5], src_private_base
; GFX10-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX10-NEXT:    v_cmp_ne_u32_e32 vcc_lo, s5, v5
; GFX10-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX10-NEXT:    s_xor_b32 s4, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB31_3
; GFX10-NEXT:  ; %bb.1: ; %Flow3
; GFX10-NEXT:    s_andn2_saveexec_b32 s4, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB31_6
; GFX10-NEXT:  .LBB31_2: ; %atomicrmw.phi
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
; GFX10-NEXT:  .LBB31_3: ; %atomicrmw.global
; GFX10-NEXT:    flat_load_dwordx2 v[0:1], v[4:5]
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:  .LBB31_4: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v9, v1
; GFX10-NEXT:    v_mov_b32_e32 v8, v0
; GFX10-NEXT:    v_add_f64 v[6:7], v[8:9], v[2:3]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap_x2 v[0:1], v[4:5], v[6:9] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[8:9]
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB31_4
; GFX10-NEXT:  ; %bb.5: ; %Flow
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX10-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX10-NEXT:    s_andn2_saveexec_b32 s4, s4
; GFX10-NEXT:    s_cbranch_execz .LBB31_2
; GFX10-NEXT:  .LBB31_6: ; %atomicrmw.private
; GFX10-NEXT:    v_cmp_ne_u64_e32 vcc_lo, 0, v[4:5]
; GFX10-NEXT:    v_cndmask_b32_e32 v4, -1, v4, vcc_lo
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    buffer_load_dword v0, v4, s[0:3], 0 offen
; GFX10-NEXT:    buffer_load_dword v1, v4, s[0:3], 0 offen offset:4
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_add_f64 v[2:3], v[0:1], v[2:3]
; GFX10-NEXT:    buffer_store_dword v2, v4, s[0:3], 0 offen
; GFX10-NEXT:    buffer_store_dword v3, v4, s[0:3], 0 offen offset:4
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_ret_f64__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v4, vcc, 0x7f8, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v1, vcc
; GFX90A-NEXT:    s_mov_b64 s[4:5], src_private_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v5
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX90A-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB31_3
; GFX90A-NEXT:  ; %bb.1: ; %Flow
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB31_4
; GFX90A-NEXT:  .LBB31_2: ; %atomicrmw.phi
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
; GFX90A-NEXT:  .LBB31_3: ; %atomicrmw.global
; GFX90A-NEXT:    flat_atomic_add_f64 v[0:1], v[4:5], v[2:3] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX90A-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execz .LBB31_2
; GFX90A-NEXT:  .LBB31_4: ; %atomicrmw.private
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v4, -1, v4, vcc
; GFX90A-NEXT:    buffer_load_dword v0, v4, s[0:3], 0 offen
; GFX90A-NEXT:    buffer_load_dword v1, v4, s[0:3], 0 offen offset:4
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_add_f64 v[2:3], v[0:1], v[2:3]
; GFX90A-NEXT:    buffer_store_dword v2, v4, s[0:3], 0 offen
; GFX90A-NEXT:    buffer_store_dword v3, v4, s[0:3], 0 offen offset:4
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_ret_f64__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v4, vcc, 0x7f8, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v1, vcc
; GFX908-NEXT:    s_mov_b64 s[4:5], src_private_base
; GFX908-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v5
; GFX908-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX908-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX908-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB31_3
; GFX908-NEXT:  ; %bb.1: ; %Flow3
; GFX908-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB31_6
; GFX908-NEXT:  .LBB31_2: ; %atomicrmw.phi
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
; GFX908-NEXT:  .LBB31_3: ; %atomicrmw.global
; GFX908-NEXT:    flat_load_dwordx2 v[0:1], v[4:5]
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:  .LBB31_4: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v9, v1
; GFX908-NEXT:    v_mov_b32_e32 v8, v0
; GFX908-NEXT:    v_add_f64 v[6:7], v[8:9], v[2:3]
; GFX908-NEXT:    flat_atomic_cmpswap_x2 v[0:1], v[4:5], v[6:9] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[8:9]
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB31_4
; GFX908-NEXT:  ; %bb.5: ; %Flow
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX908-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX908-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_cbranch_execz .LBB31_2
; GFX908-NEXT:  .LBB31_6: ; %atomicrmw.private
; GFX908-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[4:5]
; GFX908-NEXT:    v_cndmask_b32_e32 v4, -1, v4, vcc
; GFX908-NEXT:    buffer_load_dword v0, v4, s[0:3], 0 offen
; GFX908-NEXT:    buffer_load_dword v1, v4, s[0:3], 0 offen offset:4
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_add_f64 v[2:3], v[0:1], v[2:3]
; GFX908-NEXT:    buffer_store_dword v2, v4, s[0:3], 0 offen
; GFX908-NEXT:    buffer_store_dword v3, v4, s[0:3], 0 offen offset:4
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_ret_f64__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b64 s[4:5], 0xc0
; GFX8-NEXT:    s_load_dword s4, s[4:5], 0x0
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, 0x7f8, v0
; GFX8-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_cmp_ne_u32_e32 vcc, s4, v5
; GFX8-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB31_3
; GFX8-NEXT:  ; %bb.1: ; %Flow3
; GFX8-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB31_6
; GFX8-NEXT:  .LBB31_2: ; %atomicrmw.phi
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
; GFX8-NEXT:  .LBB31_3: ; %atomicrmw.global
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 4, v4
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v5, vcc
; GFX8-NEXT:    flat_load_dword v1, v[0:1]
; GFX8-NEXT:    flat_load_dword v0, v[4:5]
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:  .LBB31_4: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v9, v1
; GFX8-NEXT:    v_mov_b32_e32 v8, v0
; GFX8-NEXT:    v_add_f64 v[6:7], v[8:9], v[2:3]
; GFX8-NEXT:    flat_atomic_cmpswap_x2 v[0:1], v[4:5], v[6:9] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[8:9]
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB31_4
; GFX8-NEXT:  ; %bb.5: ; %Flow
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX8-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX8-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX8-NEXT:    s_cbranch_execz .LBB31_2
; GFX8-NEXT:  .LBB31_6: ; %atomicrmw.private
; GFX8-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[4:5]
; GFX8-NEXT:    v_cndmask_b32_e32 v4, -1, v4, vcc
; GFX8-NEXT:    v_add_u32_e32 v5, vcc, 4, v4
; GFX8-NEXT:    buffer_load_dword v0, v4, s[0:3], 0 offen
; GFX8-NEXT:    buffer_load_dword v1, v5, s[0:3], 0 offen
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_f64 v[2:3], v[0:1], v[2:3]
; GFX8-NEXT:    buffer_store_dword v2, v4, s[0:3], 0 offen
; GFX8-NEXT:    buffer_store_dword v3, v5, s[0:3], 0 offen
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_ret_f64__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[4:5], 0xc0
; GFX7-NEXT:    s_load_dword s4, s[4:5], 0x0
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 0x7f8, v0
; GFX7-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_ne_u32_e32 vcc, s4, v5
; GFX7-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX7-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX7-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB31_3
; GFX7-NEXT:  ; %bb.1: ; %Flow3
; GFX7-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB31_6
; GFX7-NEXT:  .LBB31_2: ; %atomicrmw.phi
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
; GFX7-NEXT:  .LBB31_3: ; %atomicrmw.global
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, 4, v4
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v5, vcc
; GFX7-NEXT:    flat_load_dword v1, v[0:1]
; GFX7-NEXT:    flat_load_dword v0, v[4:5]
; GFX7-NEXT:    s_mov_b64 s[6:7], 0
; GFX7-NEXT:  .LBB31_4: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v9, v1
; GFX7-NEXT:    v_mov_b32_e32 v8, v0
; GFX7-NEXT:    v_add_f64 v[6:7], v[8:9], v[2:3]
; GFX7-NEXT:    flat_atomic_cmpswap_x2 v[0:1], v[4:5], v[6:9] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[8:9]
; GFX7-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX7-NEXT:    s_cbranch_execnz .LBB31_4
; GFX7-NEXT:  ; %bb.5: ; %Flow
; GFX7-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX7-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX7-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX7-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX7-NEXT:    s_cbranch_execz .LBB31_2
; GFX7-NEXT:  .LBB31_6: ; %atomicrmw.private
; GFX7-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[4:5]
; GFX7-NEXT:    v_cndmask_b32_e32 v4, -1, v4, vcc
; GFX7-NEXT:    v_add_i32_e32 v5, vcc, 4, v4
; GFX7-NEXT:    buffer_load_dword v0, v4, s[0:3], 0 offen
; GFX7-NEXT:    buffer_load_dword v1, v5, s[0:3], 0 offen
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_add_f64 v[2:3], v[0:1], v[2:3]
; GFX7-NEXT:    buffer_store_dword v2, v4, s[0:3], 0 offen
; GFX7-NEXT:    buffer_store_dword v3, v5, s[0:3], 0 offen
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr double, ptr %ptr, i64 255
  %result = atomicrmw fadd ptr %gep, double %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret double %result
}

define double @flat_agent_atomic_fadd_ret_f64__offset12b_neg__amdgpu_no_fine_grained_memory(ptr %ptr, double %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_ret_f64__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_co_u32 v4, vcc_lo, 0xfffff800, v0
; GFX12-NEXT:    v_add_co_ci_u32_e32 v5, vcc_lo, -1, v1, vcc_lo
; GFX12-NEXT:    s_mov_b64 s[0:1], src_private_base
; GFX12-NEXT:    s_mov_b32 s0, exec_lo
; GFX12-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_cmpx_ne_u32_e64 s1, v5
; GFX12-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB32_3
; GFX12-NEXT:  ; %bb.1: ; %Flow3
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB32_6
; GFX12-NEXT:  .LBB32_2: ; %atomicrmw.phi
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_setpc_b64 s[30:31]
; GFX12-NEXT:  .LBB32_3: ; %atomicrmw.global
; GFX12-NEXT:    flat_load_b64 v[0:1], v[4:5]
; GFX12-NEXT:    s_mov_b32 s1, 0
; GFX12-NEXT:  .LBB32_4: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v9, v1 :: v_dual_mov_b32 v8, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_add_f64_e32 v[6:7], v[8:9], v[2:3]
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_cmpswap_b64 v[0:1], v[4:5], v[6:9] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[8:9]
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX12-NEXT:    s_cbranch_execnz .LBB32_4
; GFX12-NEXT:  ; %bb.5: ; %Flow
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX12-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX12-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX12-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX12-NEXT:    s_cbranch_execz .LBB32_2
; GFX12-NEXT:  .LBB32_6: ; %atomicrmw.private
; GFX12-NEXT:    v_cmp_ne_u64_e32 vcc_lo, 0, v[4:5]
; GFX12-NEXT:    v_cndmask_b32_e32 v4, -1, v4, vcc_lo
; GFX12-NEXT:    scratch_load_b64 v[0:1], v4, off
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_add_f64_e32 v[2:3], v[0:1], v[2:3]
; GFX12-NEXT:    scratch_store_b64 v4, v[2:3], off
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_ret_f64__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_movk_i32 s0, 0xf800
; GFX940-NEXT:    s_mov_b32 s1, -1
; GFX940-NEXT:    v_lshl_add_u64 v[4:5], v[0:1], 0, s[0:1]
; GFX940-NEXT:    s_mov_b64 s[0:1], src_private_base
; GFX940-NEXT:    v_cmp_ne_u32_e32 vcc, s1, v5
; GFX940-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX940-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX940-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB32_3
; GFX940-NEXT:  ; %bb.1: ; %Flow
; GFX940-NEXT:    s_andn2_saveexec_b64 s[0:1], s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB32_4
; GFX940-NEXT:  .LBB32_2: ; %atomicrmw.phi
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
; GFX940-NEXT:  .LBB32_3: ; %atomicrmw.global
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_add_f64 v[0:1], v[4:5], v[2:3] sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX940-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX940-NEXT:    s_andn2_saveexec_b64 s[0:1], s[0:1]
; GFX940-NEXT:    s_cbranch_execz .LBB32_2
; GFX940-NEXT:  .LBB32_4: ; %atomicrmw.private
; GFX940-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[4:5]
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v4, -1, v4, vcc
; GFX940-NEXT:    scratch_load_dwordx2 v[0:1], v4, off
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_add_f64 v[2:3], v[0:1], v[2:3]
; GFX940-NEXT:    scratch_store_dwordx2 v4, v[2:3], off sc0 sc1
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_ret_f64__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, 0xfffff800, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v5, vcc_lo, -1, v1, vcc_lo
; GFX11-NEXT:    s_mov_b64 s[0:1], src_private_base
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cmpx_ne_u32_e64 s1, v5
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB32_3
; GFX11-NEXT:  ; %bb.1: ; %Flow3
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB32_6
; GFX11-NEXT:  .LBB32_2: ; %atomicrmw.phi
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB32_3: ; %atomicrmw.global
; GFX11-NEXT:    flat_load_b64 v[0:1], v[4:5]
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:  .LBB32_4: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v9, v1 :: v_dual_mov_b32 v8, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_f64 v[6:7], v[8:9], v[2:3]
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b64 v[0:1], v[4:5], v[6:9] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[8:9]
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB32_4
; GFX11-NEXT:  ; %bb.5: ; %Flow
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX11-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB32_2
; GFX11-NEXT:  .LBB32_6: ; %atomicrmw.private
; GFX11-NEXT:    v_cmp_ne_u64_e32 vcc_lo, 0, v[4:5]
; GFX11-NEXT:    v_cndmask_b32_e32 v4, -1, v4, vcc_lo
; GFX11-NEXT:    scratch_load_b64 v[0:1], v4, off
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_f64 v[2:3], v[0:1], v[2:3]
; GFX11-NEXT:    scratch_store_b64 v4, v[2:3], off
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_ret_f64__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v4, vcc_lo, 0xfffff800, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v5, vcc_lo, -1, v1, vcc_lo
; GFX10-NEXT:    s_mov_b64 s[4:5], src_private_base
; GFX10-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX10-NEXT:    v_cmp_ne_u32_e32 vcc_lo, s5, v5
; GFX10-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX10-NEXT:    s_xor_b32 s4, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB32_3
; GFX10-NEXT:  ; %bb.1: ; %Flow3
; GFX10-NEXT:    s_andn2_saveexec_b32 s4, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB32_6
; GFX10-NEXT:  .LBB32_2: ; %atomicrmw.phi
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
; GFX10-NEXT:  .LBB32_3: ; %atomicrmw.global
; GFX10-NEXT:    flat_load_dwordx2 v[0:1], v[4:5]
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:  .LBB32_4: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v9, v1
; GFX10-NEXT:    v_mov_b32_e32 v8, v0
; GFX10-NEXT:    v_add_f64 v[6:7], v[8:9], v[2:3]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap_x2 v[0:1], v[4:5], v[6:9] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[8:9]
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB32_4
; GFX10-NEXT:  ; %bb.5: ; %Flow
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX10-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX10-NEXT:    s_andn2_saveexec_b32 s4, s4
; GFX10-NEXT:    s_cbranch_execz .LBB32_2
; GFX10-NEXT:  .LBB32_6: ; %atomicrmw.private
; GFX10-NEXT:    v_cmp_ne_u64_e32 vcc_lo, 0, v[4:5]
; GFX10-NEXT:    v_cndmask_b32_e32 v4, -1, v4, vcc_lo
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    buffer_load_dword v0, v4, s[0:3], 0 offen
; GFX10-NEXT:    buffer_load_dword v1, v4, s[0:3], 0 offen offset:4
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_add_f64 v[2:3], v[0:1], v[2:3]
; GFX10-NEXT:    buffer_store_dword v2, v4, s[0:3], 0 offen
; GFX10-NEXT:    buffer_store_dword v3, v4, s[0:3], 0 offen offset:4
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_ret_f64__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v4, vcc, 0xfffff800, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v5, vcc, -1, v1, vcc
; GFX90A-NEXT:    s_mov_b64 s[4:5], src_private_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v5
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX90A-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB32_3
; GFX90A-NEXT:  ; %bb.1: ; %Flow
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB32_4
; GFX90A-NEXT:  .LBB32_2: ; %atomicrmw.phi
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
; GFX90A-NEXT:  .LBB32_3: ; %atomicrmw.global
; GFX90A-NEXT:    flat_atomic_add_f64 v[0:1], v[4:5], v[2:3] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX90A-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execz .LBB32_2
; GFX90A-NEXT:  .LBB32_4: ; %atomicrmw.private
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v4, -1, v4, vcc
; GFX90A-NEXT:    buffer_load_dword v0, v4, s[0:3], 0 offen
; GFX90A-NEXT:    buffer_load_dword v1, v4, s[0:3], 0 offen offset:4
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_add_f64 v[2:3], v[0:1], v[2:3]
; GFX90A-NEXT:    buffer_store_dword v2, v4, s[0:3], 0 offen
; GFX90A-NEXT:    buffer_store_dword v3, v4, s[0:3], 0 offen offset:4
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_ret_f64__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v4, vcc, 0xfffff800, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v5, vcc, -1, v1, vcc
; GFX908-NEXT:    s_mov_b64 s[4:5], src_private_base
; GFX908-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v5
; GFX908-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX908-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX908-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB32_3
; GFX908-NEXT:  ; %bb.1: ; %Flow3
; GFX908-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB32_6
; GFX908-NEXT:  .LBB32_2: ; %atomicrmw.phi
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
; GFX908-NEXT:  .LBB32_3: ; %atomicrmw.global
; GFX908-NEXT:    flat_load_dwordx2 v[0:1], v[4:5]
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:  .LBB32_4: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v9, v1
; GFX908-NEXT:    v_mov_b32_e32 v8, v0
; GFX908-NEXT:    v_add_f64 v[6:7], v[8:9], v[2:3]
; GFX908-NEXT:    flat_atomic_cmpswap_x2 v[0:1], v[4:5], v[6:9] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[8:9]
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB32_4
; GFX908-NEXT:  ; %bb.5: ; %Flow
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX908-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX908-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_cbranch_execz .LBB32_2
; GFX908-NEXT:  .LBB32_6: ; %atomicrmw.private
; GFX908-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[4:5]
; GFX908-NEXT:    v_cndmask_b32_e32 v4, -1, v4, vcc
; GFX908-NEXT:    buffer_load_dword v0, v4, s[0:3], 0 offen
; GFX908-NEXT:    buffer_load_dword v1, v4, s[0:3], 0 offen offset:4
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_add_f64 v[2:3], v[0:1], v[2:3]
; GFX908-NEXT:    buffer_store_dword v2, v4, s[0:3], 0 offen
; GFX908-NEXT:    buffer_store_dword v3, v4, s[0:3], 0 offen offset:4
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_ret_f64__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b64 s[4:5], 0xc0
; GFX8-NEXT:    s_load_dword s4, s[4:5], 0x0
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, 0xfffff800, v0
; GFX8-NEXT:    v_addc_u32_e32 v5, vcc, -1, v1, vcc
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_cmp_ne_u32_e32 vcc, s4, v5
; GFX8-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB32_3
; GFX8-NEXT:  ; %bb.1: ; %Flow3
; GFX8-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB32_6
; GFX8-NEXT:  .LBB32_2: ; %atomicrmw.phi
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
; GFX8-NEXT:  .LBB32_3: ; %atomicrmw.global
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 4, v4
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v5, vcc
; GFX8-NEXT:    flat_load_dword v1, v[0:1]
; GFX8-NEXT:    flat_load_dword v0, v[4:5]
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:  .LBB32_4: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v9, v1
; GFX8-NEXT:    v_mov_b32_e32 v8, v0
; GFX8-NEXT:    v_add_f64 v[6:7], v[8:9], v[2:3]
; GFX8-NEXT:    flat_atomic_cmpswap_x2 v[0:1], v[4:5], v[6:9] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[8:9]
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB32_4
; GFX8-NEXT:  ; %bb.5: ; %Flow
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX8-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX8-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX8-NEXT:    s_cbranch_execz .LBB32_2
; GFX8-NEXT:  .LBB32_6: ; %atomicrmw.private
; GFX8-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[4:5]
; GFX8-NEXT:    v_cndmask_b32_e32 v4, -1, v4, vcc
; GFX8-NEXT:    v_add_u32_e32 v5, vcc, 4, v4
; GFX8-NEXT:    buffer_load_dword v0, v4, s[0:3], 0 offen
; GFX8-NEXT:    buffer_load_dword v1, v5, s[0:3], 0 offen
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_f64 v[2:3], v[0:1], v[2:3]
; GFX8-NEXT:    buffer_store_dword v2, v4, s[0:3], 0 offen
; GFX8-NEXT:    buffer_store_dword v3, v5, s[0:3], 0 offen
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_ret_f64__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[4:5], 0xc0
; GFX7-NEXT:    s_load_dword s4, s[4:5], 0x0
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 0xfffff800, v0
; GFX7-NEXT:    v_addc_u32_e32 v5, vcc, -1, v1, vcc
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_ne_u32_e32 vcc, s4, v5
; GFX7-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX7-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX7-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB32_3
; GFX7-NEXT:  ; %bb.1: ; %Flow3
; GFX7-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB32_6
; GFX7-NEXT:  .LBB32_2: ; %atomicrmw.phi
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
; GFX7-NEXT:  .LBB32_3: ; %atomicrmw.global
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, 4, v4
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v5, vcc
; GFX7-NEXT:    flat_load_dword v1, v[0:1]
; GFX7-NEXT:    flat_load_dword v0, v[4:5]
; GFX7-NEXT:    s_mov_b64 s[6:7], 0
; GFX7-NEXT:  .LBB32_4: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v9, v1
; GFX7-NEXT:    v_mov_b32_e32 v8, v0
; GFX7-NEXT:    v_add_f64 v[6:7], v[8:9], v[2:3]
; GFX7-NEXT:    flat_atomic_cmpswap_x2 v[0:1], v[4:5], v[6:9] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[8:9]
; GFX7-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX7-NEXT:    s_cbranch_execnz .LBB32_4
; GFX7-NEXT:  ; %bb.5: ; %Flow
; GFX7-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX7-NEXT:    ; implicit-def: $vgpr4_vgpr5
; GFX7-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX7-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX7-NEXT:    s_cbranch_execz .LBB32_2
; GFX7-NEXT:  .LBB32_6: ; %atomicrmw.private
; GFX7-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[4:5]
; GFX7-NEXT:    v_cndmask_b32_e32 v4, -1, v4, vcc
; GFX7-NEXT:    v_add_i32_e32 v5, vcc, 4, v4
; GFX7-NEXT:    buffer_load_dword v0, v4, s[0:3], 0 offen
; GFX7-NEXT:    buffer_load_dword v1, v5, s[0:3], 0 offen
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_add_f64 v[2:3], v[0:1], v[2:3]
; GFX7-NEXT:    buffer_store_dword v2, v4, s[0:3], 0 offen
; GFX7-NEXT:    buffer_store_dword v3, v5, s[0:3], 0 offen
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr double, ptr %ptr, i64 -256
  %result = atomicrmw fadd ptr %gep, double %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret double %result
}

define void @flat_agent_atomic_fadd_noret_f64__amdgpu_no_fine_grained_memory(ptr %ptr, double %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_f64__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_mov_b64 s[0:1], src_private_base
; GFX12-NEXT:    s_mov_b32 s0, exec_lo
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    v_cmpx_ne_u32_e64 s1, v1
; GFX12-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB33_3
; GFX12-NEXT:  ; %bb.1: ; %Flow3
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB33_6
; GFX12-NEXT:  .LBB33_2: ; %atomicrmw.phi
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_setpc_b64 s[30:31]
; GFX12-NEXT:  .LBB33_3: ; %atomicrmw.global
; GFX12-NEXT:    flat_load_b64 v[6:7], v[0:1]
; GFX12-NEXT:    s_mov_b32 s1, 0
; GFX12-NEXT:  .LBB33_4: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    v_add_f64_e32 v[4:5], v[6:7], v[2:3]
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_cmpswap_b64 v[4:5], v[0:1], v[4:7] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[4:5], v[6:7]
; GFX12-NEXT:    v_dual_mov_b32 v7, v5 :: v_dual_mov_b32 v6, v4
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX12-NEXT:    s_cbranch_execnz .LBB33_4
; GFX12-NEXT:  ; %bb.5: ; %Flow
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX12-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX12-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX12-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX12-NEXT:    s_cbranch_execz .LBB33_2
; GFX12-NEXT:  .LBB33_6: ; %atomicrmw.private
; GFX12-NEXT:    v_cmp_ne_u64_e32 vcc_lo, 0, v[0:1]
; GFX12-NEXT:    v_cndmask_b32_e32 v4, -1, v0, vcc_lo
; GFX12-NEXT:    scratch_load_b64 v[0:1], v4, off
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_add_f64_e32 v[0:1], v[0:1], v[2:3]
; GFX12-NEXT:    scratch_store_b64 v4, v[0:1], off
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_f64__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_mov_b64 s[0:1], src_private_base
; GFX940-NEXT:    v_cmp_ne_u32_e32 vcc, s1, v1
; GFX940-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX940-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB33_3
; GFX940-NEXT:  ; %bb.1: ; %Flow
; GFX940-NEXT:    s_andn2_saveexec_b64 s[0:1], s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB33_4
; GFX940-NEXT:  .LBB33_2: ; %atomicrmw.phi
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
; GFX940-NEXT:  .LBB33_3: ; %atomicrmw.global
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_add_f64 v[0:1], v[2:3]
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX940-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX940-NEXT:    s_andn2_saveexec_b64 s[0:1], s[0:1]
; GFX940-NEXT:    s_cbranch_execz .LBB33_2
; GFX940-NEXT:  .LBB33_4: ; %atomicrmw.private
; GFX940-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v4, -1, v0, vcc
; GFX940-NEXT:    scratch_load_dwordx2 v[0:1], v4, off
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX940-NEXT:    scratch_store_dwordx2 v4, v[0:1], off sc0 sc1
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_f64__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b64 s[0:1], src_private_base
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e64 s1, v1
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB33_3
; GFX11-NEXT:  ; %bb.1: ; %Flow3
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB33_6
; GFX11-NEXT:  .LBB33_2: ; %atomicrmw.phi
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB33_3: ; %atomicrmw.global
; GFX11-NEXT:    flat_load_b64 v[6:7], v[0:1]
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:  .LBB33_4: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b64 v[4:5], v[0:1], v[4:7] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[4:5], v[6:7]
; GFX11-NEXT:    v_dual_mov_b32 v7, v5 :: v_dual_mov_b32 v6, v4
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB33_4
; GFX11-NEXT:  ; %bb.5: ; %Flow
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX11-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB33_2
; GFX11-NEXT:  .LBB33_6: ; %atomicrmw.private
; GFX11-NEXT:    v_cmp_ne_u64_e32 vcc_lo, 0, v[0:1]
; GFX11-NEXT:    v_cndmask_b32_e32 v4, -1, v0, vcc_lo
; GFX11-NEXT:    scratch_load_b64 v[0:1], v4, off
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX11-NEXT:    scratch_store_b64 v4, v[0:1], off
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_f64__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_mov_b64 s[4:5], src_private_base
; GFX10-NEXT:    v_cmp_ne_u32_e32 vcc_lo, s5, v1
; GFX10-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX10-NEXT:    s_xor_b32 s4, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB33_3
; GFX10-NEXT:  ; %bb.1: ; %Flow3
; GFX10-NEXT:    s_andn2_saveexec_b32 s4, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB33_6
; GFX10-NEXT:  .LBB33_2: ; %atomicrmw.phi
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
; GFX10-NEXT:  .LBB33_3: ; %atomicrmw.global
; GFX10-NEXT:    flat_load_dwordx2 v[6:7], v[0:1]
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:  .LBB33_4: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap_x2 v[4:5], v[0:1], v[4:7] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[4:5], v[6:7]
; GFX10-NEXT:    v_mov_b32_e32 v7, v5
; GFX10-NEXT:    v_mov_b32_e32 v6, v4
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB33_4
; GFX10-NEXT:  ; %bb.5: ; %Flow
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX10-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX10-NEXT:    s_andn2_saveexec_b32 s4, s4
; GFX10-NEXT:    s_cbranch_execz .LBB33_2
; GFX10-NEXT:  .LBB33_6: ; %atomicrmw.private
; GFX10-NEXT:    v_cmp_ne_u64_e32 vcc_lo, 0, v[0:1]
; GFX10-NEXT:    v_cndmask_b32_e32 v4, -1, v0, vcc_lo
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    buffer_load_dword v0, v4, s[0:3], 0 offen
; GFX10-NEXT:    buffer_load_dword v1, v4, s[0:3], 0 offen offset:4
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX10-NEXT:    buffer_store_dword v0, v4, s[0:3], 0 offen
; GFX10-NEXT:    buffer_store_dword v1, v4, s[0:3], 0 offen offset:4
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_f64__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b64 s[4:5], src_private_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v1
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX90A-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB33_3
; GFX90A-NEXT:  ; %bb.1: ; %Flow
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB33_4
; GFX90A-NEXT:  .LBB33_2: ; %atomicrmw.phi
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
; GFX90A-NEXT:  .LBB33_3: ; %atomicrmw.global
; GFX90A-NEXT:    flat_atomic_add_f64 v[0:1], v[2:3]
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execz .LBB33_2
; GFX90A-NEXT:  .LBB33_4: ; %atomicrmw.private
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX90A-NEXT:    v_cndmask_b32_e32 v4, -1, v0, vcc
; GFX90A-NEXT:    buffer_load_dword v0, v4, s[0:3], 0 offen
; GFX90A-NEXT:    buffer_load_dword v1, v4, s[0:3], 0 offen offset:4
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX90A-NEXT:    buffer_store_dword v0, v4, s[0:3], 0 offen
; GFX90A-NEXT:    buffer_store_dword v1, v4, s[0:3], 0 offen offset:4
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_f64__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    s_mov_b64 s[4:5], src_private_base
; GFX908-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v1
; GFX908-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX908-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB33_3
; GFX908-NEXT:  ; %bb.1: ; %Flow3
; GFX908-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB33_6
; GFX908-NEXT:  .LBB33_2: ; %atomicrmw.phi
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
; GFX908-NEXT:  .LBB33_3: ; %atomicrmw.global
; GFX908-NEXT:    flat_load_dwordx2 v[6:7], v[0:1]
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:  .LBB33_4: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX908-NEXT:    flat_atomic_cmpswap_x2 v[4:5], v[0:1], v[4:7] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v7, v5
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v6, v4
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB33_4
; GFX908-NEXT:  ; %bb.5: ; %Flow
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX908-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX908-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_cbranch_execz .LBB33_2
; GFX908-NEXT:  .LBB33_6: ; %atomicrmw.private
; GFX908-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX908-NEXT:    v_cndmask_b32_e32 v4, -1, v0, vcc
; GFX908-NEXT:    buffer_load_dword v0, v4, s[0:3], 0 offen
; GFX908-NEXT:    buffer_load_dword v1, v4, s[0:3], 0 offen offset:4
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX908-NEXT:    buffer_store_dword v0, v4, s[0:3], 0 offen
; GFX908-NEXT:    buffer_store_dword v1, v4, s[0:3], 0 offen offset:4
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_f64__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b64 s[4:5], 0xc0
; GFX8-NEXT:    s_load_dword s4, s[4:5], 0x0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_cmp_ne_u32_e32 vcc, s4, v1
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB33_3
; GFX8-NEXT:  ; %bb.1: ; %Flow3
; GFX8-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB33_6
; GFX8-NEXT:  .LBB33_2: ; %atomicrmw.phi
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
; GFX8-NEXT:  .LBB33_3: ; %atomicrmw.global
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, 4, v0
; GFX8-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v7, v[4:5]
; GFX8-NEXT:    flat_load_dword v6, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:  .LBB33_4: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX8-NEXT:    flat_atomic_cmpswap_x2 v[4:5], v[0:1], v[4:7] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v7, v5
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v6, v4
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB33_4
; GFX8-NEXT:  ; %bb.5: ; %Flow
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX8-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX8-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX8-NEXT:    s_cbranch_execz .LBB33_2
; GFX8-NEXT:  .LBB33_6: ; %atomicrmw.private
; GFX8-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX8-NEXT:    v_cndmask_b32_e32 v4, -1, v0, vcc
; GFX8-NEXT:    v_add_u32_e32 v5, vcc, 4, v4
; GFX8-NEXT:    buffer_load_dword v0, v4, s[0:3], 0 offen
; GFX8-NEXT:    buffer_load_dword v1, v5, s[0:3], 0 offen
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX8-NEXT:    buffer_store_dword v0, v4, s[0:3], 0 offen
; GFX8-NEXT:    buffer_store_dword v1, v5, s[0:3], 0 offen
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_f64__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[4:5], 0xc0
; GFX7-NEXT:    s_load_dword s4, s[4:5], 0x0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_ne_u32_e32 vcc, s4, v1
; GFX7-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX7-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB33_3
; GFX7-NEXT:  ; %bb.1: ; %Flow3
; GFX7-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB33_6
; GFX7-NEXT:  .LBB33_2: ; %atomicrmw.phi
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
; GFX7-NEXT:  .LBB33_3: ; %atomicrmw.global
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 4, v0
; GFX7-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; GFX7-NEXT:    flat_load_dword v7, v[4:5]
; GFX7-NEXT:    flat_load_dword v6, v[0:1]
; GFX7-NEXT:    s_mov_b64 s[6:7], 0
; GFX7-NEXT:  .LBB33_4: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX7-NEXT:    flat_atomic_cmpswap_x2 v[4:5], v[0:1], v[4:7] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[6:7]
; GFX7-NEXT:    v_mov_b32_e32 v7, v5
; GFX7-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX7-NEXT:    v_mov_b32_e32 v6, v4
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX7-NEXT:    s_cbranch_execnz .LBB33_4
; GFX7-NEXT:  ; %bb.5: ; %Flow
; GFX7-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX7-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX7-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX7-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX7-NEXT:    s_cbranch_execz .LBB33_2
; GFX7-NEXT:  .LBB33_6: ; %atomicrmw.private
; GFX7-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX7-NEXT:    v_cndmask_b32_e32 v4, -1, v0, vcc
; GFX7-NEXT:    v_add_i32_e32 v5, vcc, 4, v4
; GFX7-NEXT:    buffer_load_dword v0, v4, s[0:3], 0 offen
; GFX7-NEXT:    buffer_load_dword v1, v5, s[0:3], 0 offen
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX7-NEXT:    buffer_store_dword v0, v4, s[0:3], 0 offen
; GFX7-NEXT:    buffer_store_dword v1, v5, s[0:3], 0 offen
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %unused = atomicrmw fadd ptr %ptr, double %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret void
}

define void @flat_agent_atomic_fadd_noret_f64__offset12b_pos__amdgpu_no_fine_grained_memory(ptr %ptr, double %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_f64__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_co_u32 v0, vcc_lo, 0x7f8, v0
; GFX12-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX12-NEXT:    s_mov_b64 s[0:1], src_private_base
; GFX12-NEXT:    s_mov_b32 s0, exec_lo
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_cmpx_ne_u32_e64 s1, v1
; GFX12-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB34_3
; GFX12-NEXT:  ; %bb.1: ; %Flow3
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB34_6
; GFX12-NEXT:  .LBB34_2: ; %atomicrmw.phi
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_setpc_b64 s[30:31]
; GFX12-NEXT:  .LBB34_3: ; %atomicrmw.global
; GFX12-NEXT:    flat_load_b64 v[6:7], v[0:1]
; GFX12-NEXT:    s_mov_b32 s1, 0
; GFX12-NEXT:  .LBB34_4: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    v_add_f64_e32 v[4:5], v[6:7], v[2:3]
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_cmpswap_b64 v[4:5], v[0:1], v[4:7] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[4:5], v[6:7]
; GFX12-NEXT:    v_dual_mov_b32 v7, v5 :: v_dual_mov_b32 v6, v4
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX12-NEXT:    s_cbranch_execnz .LBB34_4
; GFX12-NEXT:  ; %bb.5: ; %Flow
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX12-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX12-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX12-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX12-NEXT:    s_cbranch_execz .LBB34_2
; GFX12-NEXT:  .LBB34_6: ; %atomicrmw.private
; GFX12-NEXT:    v_cmp_ne_u64_e32 vcc_lo, 0, v[0:1]
; GFX12-NEXT:    v_cndmask_b32_e32 v4, -1, v0, vcc_lo
; GFX12-NEXT:    scratch_load_b64 v[0:1], v4, off
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_add_f64_e32 v[0:1], v[0:1], v[2:3]
; GFX12-NEXT:    scratch_store_b64 v4, v[0:1], off
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_f64__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_mov_b64 s[0:1], 0x7f8
; GFX940-NEXT:    v_lshl_add_u64 v[0:1], v[0:1], 0, s[0:1]
; GFX940-NEXT:    s_mov_b64 s[0:1], src_private_base
; GFX940-NEXT:    v_cmp_ne_u32_e32 vcc, s1, v1
; GFX940-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX940-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB34_3
; GFX940-NEXT:  ; %bb.1: ; %Flow
; GFX940-NEXT:    s_andn2_saveexec_b64 s[0:1], s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB34_4
; GFX940-NEXT:  .LBB34_2: ; %atomicrmw.phi
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
; GFX940-NEXT:  .LBB34_3: ; %atomicrmw.global
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_add_f64 v[0:1], v[2:3]
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX940-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX940-NEXT:    s_andn2_saveexec_b64 s[0:1], s[0:1]
; GFX940-NEXT:    s_cbranch_execz .LBB34_2
; GFX940-NEXT:  .LBB34_4: ; %atomicrmw.private
; GFX940-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v4, -1, v0, vcc
; GFX940-NEXT:    scratch_load_dwordx2 v[0:1], v4, off
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX940-NEXT:    scratch_store_dwordx2 v4, v[0:1], off sc0 sc1
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_f64__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, 0x7f8, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX11-NEXT:    s_mov_b64 s[0:1], src_private_base
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cmpx_ne_u32_e64 s1, v1
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB34_3
; GFX11-NEXT:  ; %bb.1: ; %Flow3
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB34_6
; GFX11-NEXT:  .LBB34_2: ; %atomicrmw.phi
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB34_3: ; %atomicrmw.global
; GFX11-NEXT:    flat_load_b64 v[6:7], v[0:1]
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:  .LBB34_4: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b64 v[4:5], v[0:1], v[4:7] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[4:5], v[6:7]
; GFX11-NEXT:    v_dual_mov_b32 v7, v5 :: v_dual_mov_b32 v6, v4
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB34_4
; GFX11-NEXT:  ; %bb.5: ; %Flow
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX11-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB34_2
; GFX11-NEXT:  .LBB34_6: ; %atomicrmw.private
; GFX11-NEXT:    v_cmp_ne_u64_e32 vcc_lo, 0, v[0:1]
; GFX11-NEXT:    v_cndmask_b32_e32 v4, -1, v0, vcc_lo
; GFX11-NEXT:    scratch_load_b64 v[0:1], v4, off
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX11-NEXT:    scratch_store_b64 v4, v[0:1], off
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_f64__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0x7f8, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    s_mov_b64 s[4:5], src_private_base
; GFX10-NEXT:    v_cmp_ne_u32_e32 vcc_lo, s5, v1
; GFX10-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX10-NEXT:    s_xor_b32 s4, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB34_3
; GFX10-NEXT:  ; %bb.1: ; %Flow3
; GFX10-NEXT:    s_andn2_saveexec_b32 s4, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB34_6
; GFX10-NEXT:  .LBB34_2: ; %atomicrmw.phi
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
; GFX10-NEXT:  .LBB34_3: ; %atomicrmw.global
; GFX10-NEXT:    flat_load_dwordx2 v[6:7], v[0:1]
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:  .LBB34_4: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap_x2 v[4:5], v[0:1], v[4:7] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[4:5], v[6:7]
; GFX10-NEXT:    v_mov_b32_e32 v7, v5
; GFX10-NEXT:    v_mov_b32_e32 v6, v4
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB34_4
; GFX10-NEXT:  ; %bb.5: ; %Flow
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX10-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX10-NEXT:    s_andn2_saveexec_b32 s4, s4
; GFX10-NEXT:    s_cbranch_execz .LBB34_2
; GFX10-NEXT:  .LBB34_6: ; %atomicrmw.private
; GFX10-NEXT:    v_cmp_ne_u64_e32 vcc_lo, 0, v[0:1]
; GFX10-NEXT:    v_cndmask_b32_e32 v4, -1, v0, vcc_lo
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    buffer_load_dword v0, v4, s[0:3], 0 offen
; GFX10-NEXT:    buffer_load_dword v1, v4, s[0:3], 0 offen offset:4
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX10-NEXT:    buffer_store_dword v0, v4, s[0:3], 0 offen
; GFX10-NEXT:    buffer_store_dword v1, v4, s[0:3], 0 offen offset:4
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_f64__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v0, vcc, 0x7f8, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX90A-NEXT:    s_mov_b64 s[4:5], src_private_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v1
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX90A-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB34_3
; GFX90A-NEXT:  ; %bb.1: ; %Flow
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB34_4
; GFX90A-NEXT:  .LBB34_2: ; %atomicrmw.phi
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
; GFX90A-NEXT:  .LBB34_3: ; %atomicrmw.global
; GFX90A-NEXT:    flat_atomic_add_f64 v[0:1], v[2:3]
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execz .LBB34_2
; GFX90A-NEXT:  .LBB34_4: ; %atomicrmw.private
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX90A-NEXT:    v_cndmask_b32_e32 v4, -1, v0, vcc
; GFX90A-NEXT:    buffer_load_dword v0, v4, s[0:3], 0 offen
; GFX90A-NEXT:    buffer_load_dword v1, v4, s[0:3], 0 offen offset:4
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX90A-NEXT:    buffer_store_dword v0, v4, s[0:3], 0 offen
; GFX90A-NEXT:    buffer_store_dword v1, v4, s[0:3], 0 offen offset:4
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_f64__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v0, vcc, 0x7f8, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX908-NEXT:    s_mov_b64 s[4:5], src_private_base
; GFX908-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v1
; GFX908-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX908-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB34_3
; GFX908-NEXT:  ; %bb.1: ; %Flow3
; GFX908-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB34_6
; GFX908-NEXT:  .LBB34_2: ; %atomicrmw.phi
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
; GFX908-NEXT:  .LBB34_3: ; %atomicrmw.global
; GFX908-NEXT:    flat_load_dwordx2 v[6:7], v[0:1]
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:  .LBB34_4: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX908-NEXT:    flat_atomic_cmpswap_x2 v[4:5], v[0:1], v[4:7] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v7, v5
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v6, v4
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB34_4
; GFX908-NEXT:  ; %bb.5: ; %Flow
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX908-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX908-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_cbranch_execz .LBB34_2
; GFX908-NEXT:  .LBB34_6: ; %atomicrmw.private
; GFX908-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX908-NEXT:    v_cndmask_b32_e32 v4, -1, v0, vcc
; GFX908-NEXT:    buffer_load_dword v0, v4, s[0:3], 0 offen
; GFX908-NEXT:    buffer_load_dword v1, v4, s[0:3], 0 offen offset:4
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX908-NEXT:    buffer_store_dword v0, v4, s[0:3], 0 offen
; GFX908-NEXT:    buffer_store_dword v1, v4, s[0:3], 0 offen offset:4
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_f64__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b64 s[4:5], 0xc0
; GFX8-NEXT:    s_load_dword s4, s[4:5], 0x0
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0x7f8, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_cmp_ne_u32_e32 vcc, s4, v1
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB34_3
; GFX8-NEXT:  ; %bb.1: ; %Flow3
; GFX8-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB34_6
; GFX8-NEXT:  .LBB34_2: ; %atomicrmw.phi
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
; GFX8-NEXT:  .LBB34_3: ; %atomicrmw.global
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, 4, v0
; GFX8-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v7, v[4:5]
; GFX8-NEXT:    flat_load_dword v6, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:  .LBB34_4: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX8-NEXT:    flat_atomic_cmpswap_x2 v[4:5], v[0:1], v[4:7] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v7, v5
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v6, v4
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB34_4
; GFX8-NEXT:  ; %bb.5: ; %Flow
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX8-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX8-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX8-NEXT:    s_cbranch_execz .LBB34_2
; GFX8-NEXT:  .LBB34_6: ; %atomicrmw.private
; GFX8-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX8-NEXT:    v_cndmask_b32_e32 v4, -1, v0, vcc
; GFX8-NEXT:    v_add_u32_e32 v5, vcc, 4, v4
; GFX8-NEXT:    buffer_load_dword v0, v4, s[0:3], 0 offen
; GFX8-NEXT:    buffer_load_dword v1, v5, s[0:3], 0 offen
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX8-NEXT:    buffer_store_dword v0, v4, s[0:3], 0 offen
; GFX8-NEXT:    buffer_store_dword v1, v5, s[0:3], 0 offen
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_f64__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[4:5], 0xc0
; GFX7-NEXT:    s_load_dword s4, s[4:5], 0x0
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, 0x7f8, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_ne_u32_e32 vcc, s4, v1
; GFX7-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX7-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB34_3
; GFX7-NEXT:  ; %bb.1: ; %Flow3
; GFX7-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB34_6
; GFX7-NEXT:  .LBB34_2: ; %atomicrmw.phi
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
; GFX7-NEXT:  .LBB34_3: ; %atomicrmw.global
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 4, v0
; GFX7-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; GFX7-NEXT:    flat_load_dword v7, v[4:5]
; GFX7-NEXT:    flat_load_dword v6, v[0:1]
; GFX7-NEXT:    s_mov_b64 s[6:7], 0
; GFX7-NEXT:  .LBB34_4: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX7-NEXT:    flat_atomic_cmpswap_x2 v[4:5], v[0:1], v[4:7] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[6:7]
; GFX7-NEXT:    v_mov_b32_e32 v7, v5
; GFX7-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX7-NEXT:    v_mov_b32_e32 v6, v4
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX7-NEXT:    s_cbranch_execnz .LBB34_4
; GFX7-NEXT:  ; %bb.5: ; %Flow
; GFX7-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX7-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX7-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX7-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX7-NEXT:    s_cbranch_execz .LBB34_2
; GFX7-NEXT:  .LBB34_6: ; %atomicrmw.private
; GFX7-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX7-NEXT:    v_cndmask_b32_e32 v4, -1, v0, vcc
; GFX7-NEXT:    v_add_i32_e32 v5, vcc, 4, v4
; GFX7-NEXT:    buffer_load_dword v0, v4, s[0:3], 0 offen
; GFX7-NEXT:    buffer_load_dword v1, v5, s[0:3], 0 offen
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX7-NEXT:    buffer_store_dword v0, v4, s[0:3], 0 offen
; GFX7-NEXT:    buffer_store_dword v1, v5, s[0:3], 0 offen
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr double, ptr %ptr, i64 255
  %unused = atomicrmw fadd ptr %gep, double %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret void
}

define void @flat_agent_atomic_fadd_noret_f64__offset12b_neg__amdgpu_no_fine_grained_memory(ptr %ptr, double %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_f64__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_co_u32 v0, vcc_lo, 0xfffff800, v0
; GFX12-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX12-NEXT:    s_mov_b64 s[0:1], src_private_base
; GFX12-NEXT:    s_mov_b32 s0, exec_lo
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_cmpx_ne_u32_e64 s1, v1
; GFX12-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB35_3
; GFX12-NEXT:  ; %bb.1: ; %Flow3
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB35_6
; GFX12-NEXT:  .LBB35_2: ; %atomicrmw.phi
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_setpc_b64 s[30:31]
; GFX12-NEXT:  .LBB35_3: ; %atomicrmw.global
; GFX12-NEXT:    flat_load_b64 v[6:7], v[0:1]
; GFX12-NEXT:    s_mov_b32 s1, 0
; GFX12-NEXT:  .LBB35_4: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    v_add_f64_e32 v[4:5], v[6:7], v[2:3]
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_cmpswap_b64 v[4:5], v[0:1], v[4:7] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[4:5], v[6:7]
; GFX12-NEXT:    v_dual_mov_b32 v7, v5 :: v_dual_mov_b32 v6, v4
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX12-NEXT:    s_cbranch_execnz .LBB35_4
; GFX12-NEXT:  ; %bb.5: ; %Flow
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX12-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX12-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX12-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX12-NEXT:    s_cbranch_execz .LBB35_2
; GFX12-NEXT:  .LBB35_6: ; %atomicrmw.private
; GFX12-NEXT:    v_cmp_ne_u64_e32 vcc_lo, 0, v[0:1]
; GFX12-NEXT:    v_cndmask_b32_e32 v4, -1, v0, vcc_lo
; GFX12-NEXT:    scratch_load_b64 v[0:1], v4, off
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_add_f64_e32 v[0:1], v[0:1], v[2:3]
; GFX12-NEXT:    scratch_store_b64 v4, v[0:1], off
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_f64__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_movk_i32 s0, 0xf800
; GFX940-NEXT:    s_mov_b32 s1, -1
; GFX940-NEXT:    v_lshl_add_u64 v[0:1], v[0:1], 0, s[0:1]
; GFX940-NEXT:    s_mov_b64 s[0:1], src_private_base
; GFX940-NEXT:    v_cmp_ne_u32_e32 vcc, s1, v1
; GFX940-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX940-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB35_3
; GFX940-NEXT:  ; %bb.1: ; %Flow
; GFX940-NEXT:    s_andn2_saveexec_b64 s[0:1], s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB35_4
; GFX940-NEXT:  .LBB35_2: ; %atomicrmw.phi
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
; GFX940-NEXT:  .LBB35_3: ; %atomicrmw.global
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_add_f64 v[0:1], v[2:3]
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX940-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX940-NEXT:    s_andn2_saveexec_b64 s[0:1], s[0:1]
; GFX940-NEXT:    s_cbranch_execz .LBB35_2
; GFX940-NEXT:  .LBB35_4: ; %atomicrmw.private
; GFX940-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v4, -1, v0, vcc
; GFX940-NEXT:    scratch_load_dwordx2 v[0:1], v4, off
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX940-NEXT:    scratch_store_dwordx2 v4, v[0:1], off sc0 sc1
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_f64__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, 0xfffff800, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX11-NEXT:    s_mov_b64 s[0:1], src_private_base
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cmpx_ne_u32_e64 s1, v1
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB35_3
; GFX11-NEXT:  ; %bb.1: ; %Flow3
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB35_6
; GFX11-NEXT:  .LBB35_2: ; %atomicrmw.phi
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB35_3: ; %atomicrmw.global
; GFX11-NEXT:    flat_load_b64 v[6:7], v[0:1]
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:  .LBB35_4: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b64 v[4:5], v[0:1], v[4:7] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[4:5], v[6:7]
; GFX11-NEXT:    v_dual_mov_b32 v7, v5 :: v_dual_mov_b32 v6, v4
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB35_4
; GFX11-NEXT:  ; %bb.5: ; %Flow
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX11-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB35_2
; GFX11-NEXT:  .LBB35_6: ; %atomicrmw.private
; GFX11-NEXT:    v_cmp_ne_u64_e32 vcc_lo, 0, v[0:1]
; GFX11-NEXT:    v_cndmask_b32_e32 v4, -1, v0, vcc_lo
; GFX11-NEXT:    scratch_load_b64 v[0:1], v4, off
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX11-NEXT:    scratch_store_b64 v4, v[0:1], off
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_f64__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0xfffff800, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX10-NEXT:    s_mov_b64 s[4:5], src_private_base
; GFX10-NEXT:    v_cmp_ne_u32_e32 vcc_lo, s5, v1
; GFX10-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX10-NEXT:    s_xor_b32 s4, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB35_3
; GFX10-NEXT:  ; %bb.1: ; %Flow3
; GFX10-NEXT:    s_andn2_saveexec_b32 s4, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB35_6
; GFX10-NEXT:  .LBB35_2: ; %atomicrmw.phi
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
; GFX10-NEXT:  .LBB35_3: ; %atomicrmw.global
; GFX10-NEXT:    flat_load_dwordx2 v[6:7], v[0:1]
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:  .LBB35_4: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap_x2 v[4:5], v[0:1], v[4:7] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[4:5], v[6:7]
; GFX10-NEXT:    v_mov_b32_e32 v7, v5
; GFX10-NEXT:    v_mov_b32_e32 v6, v4
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB35_4
; GFX10-NEXT:  ; %bb.5: ; %Flow
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX10-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX10-NEXT:    s_andn2_saveexec_b32 s4, s4
; GFX10-NEXT:    s_cbranch_execz .LBB35_2
; GFX10-NEXT:  .LBB35_6: ; %atomicrmw.private
; GFX10-NEXT:    v_cmp_ne_u64_e32 vcc_lo, 0, v[0:1]
; GFX10-NEXT:    v_cndmask_b32_e32 v4, -1, v0, vcc_lo
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    buffer_load_dword v0, v4, s[0:3], 0 offen
; GFX10-NEXT:    buffer_load_dword v1, v4, s[0:3], 0 offen offset:4
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX10-NEXT:    buffer_store_dword v0, v4, s[0:3], 0 offen
; GFX10-NEXT:    buffer_store_dword v1, v4, s[0:3], 0 offen offset:4
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_f64__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff800, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX90A-NEXT:    s_mov_b64 s[4:5], src_private_base
; GFX90A-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v1
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX90A-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB35_3
; GFX90A-NEXT:  ; %bb.1: ; %Flow
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB35_4
; GFX90A-NEXT:  .LBB35_2: ; %atomicrmw.phi
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
; GFX90A-NEXT:  .LBB35_3: ; %atomicrmw.global
; GFX90A-NEXT:    flat_atomic_add_f64 v[0:1], v[2:3]
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX90A-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX90A-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_cbranch_execz .LBB35_2
; GFX90A-NEXT:  .LBB35_4: ; %atomicrmw.private
; GFX90A-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX90A-NEXT:    v_cndmask_b32_e32 v4, -1, v0, vcc
; GFX90A-NEXT:    buffer_load_dword v0, v4, s[0:3], 0 offen
; GFX90A-NEXT:    buffer_load_dword v1, v4, s[0:3], 0 offen offset:4
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX90A-NEXT:    buffer_store_dword v0, v4, s[0:3], 0 offen
; GFX90A-NEXT:    buffer_store_dword v1, v4, s[0:3], 0 offen offset:4
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_f64__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff800, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX908-NEXT:    s_mov_b64 s[4:5], src_private_base
; GFX908-NEXT:    v_cmp_ne_u32_e32 vcc, s5, v1
; GFX908-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX908-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB35_3
; GFX908-NEXT:  ; %bb.1: ; %Flow3
; GFX908-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB35_6
; GFX908-NEXT:  .LBB35_2: ; %atomicrmw.phi
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
; GFX908-NEXT:  .LBB35_3: ; %atomicrmw.global
; GFX908-NEXT:    flat_load_dwordx2 v[6:7], v[0:1]
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:  .LBB35_4: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX908-NEXT:    flat_atomic_cmpswap_x2 v[4:5], v[0:1], v[4:7] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v7, v5
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v6, v4
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB35_4
; GFX908-NEXT:  ; %bb.5: ; %Flow
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX908-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX908-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_cbranch_execz .LBB35_2
; GFX908-NEXT:  .LBB35_6: ; %atomicrmw.private
; GFX908-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX908-NEXT:    v_cndmask_b32_e32 v4, -1, v0, vcc
; GFX908-NEXT:    buffer_load_dword v0, v4, s[0:3], 0 offen
; GFX908-NEXT:    buffer_load_dword v1, v4, s[0:3], 0 offen offset:4
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX908-NEXT:    buffer_store_dword v0, v4, s[0:3], 0 offen
; GFX908-NEXT:    buffer_store_dword v1, v4, s[0:3], 0 offen offset:4
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_f64__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b64 s[4:5], 0xc0
; GFX8-NEXT:    s_load_dword s4, s[4:5], 0x0
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0xfffff800, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_cmp_ne_u32_e32 vcc, s4, v1
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB35_3
; GFX8-NEXT:  ; %bb.1: ; %Flow3
; GFX8-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB35_6
; GFX8-NEXT:  .LBB35_2: ; %atomicrmw.phi
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
; GFX8-NEXT:  .LBB35_3: ; %atomicrmw.global
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, 4, v0
; GFX8-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v7, v[4:5]
; GFX8-NEXT:    flat_load_dword v6, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:  .LBB35_4: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX8-NEXT:    flat_atomic_cmpswap_x2 v[4:5], v[0:1], v[4:7] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v7, v5
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v6, v4
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB35_4
; GFX8-NEXT:  ; %bb.5: ; %Flow
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX8-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX8-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX8-NEXT:    s_cbranch_execz .LBB35_2
; GFX8-NEXT:  .LBB35_6: ; %atomicrmw.private
; GFX8-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX8-NEXT:    v_cndmask_b32_e32 v4, -1, v0, vcc
; GFX8-NEXT:    v_add_u32_e32 v5, vcc, 4, v4
; GFX8-NEXT:    buffer_load_dword v0, v4, s[0:3], 0 offen
; GFX8-NEXT:    buffer_load_dword v1, v5, s[0:3], 0 offen
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX8-NEXT:    buffer_store_dword v0, v4, s[0:3], 0 offen
; GFX8-NEXT:    buffer_store_dword v1, v5, s[0:3], 0 offen
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_f64__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[4:5], 0xc0
; GFX7-NEXT:    s_load_dword s4, s[4:5], 0x0
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, 0xfffff800, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_cmp_ne_u32_e32 vcc, s4, v1
; GFX7-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX7-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB35_3
; GFX7-NEXT:  ; %bb.1: ; %Flow3
; GFX7-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB35_6
; GFX7-NEXT:  .LBB35_2: ; %atomicrmw.phi
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
; GFX7-NEXT:  .LBB35_3: ; %atomicrmw.global
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 4, v0
; GFX7-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; GFX7-NEXT:    flat_load_dword v7, v[4:5]
; GFX7-NEXT:    flat_load_dword v6, v[0:1]
; GFX7-NEXT:    s_mov_b64 s[6:7], 0
; GFX7-NEXT:  .LBB35_4: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX7-NEXT:    flat_atomic_cmpswap_x2 v[4:5], v[0:1], v[4:7] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[6:7]
; GFX7-NEXT:    v_mov_b32_e32 v7, v5
; GFX7-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX7-NEXT:    v_mov_b32_e32 v6, v4
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX7-NEXT:    s_cbranch_execnz .LBB35_4
; GFX7-NEXT:  ; %bb.5: ; %Flow
; GFX7-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX7-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX7-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX7-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX7-NEXT:    s_cbranch_execz .LBB35_2
; GFX7-NEXT:  .LBB35_6: ; %atomicrmw.private
; GFX7-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX7-NEXT:    v_cndmask_b32_e32 v4, -1, v0, vcc
; GFX7-NEXT:    v_add_i32_e32 v5, vcc, 4, v4
; GFX7-NEXT:    buffer_load_dword v0, v4, s[0:3], 0 offen
; GFX7-NEXT:    buffer_load_dword v1, v5, s[0:3], 0 offen
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX7-NEXT:    buffer_store_dword v0, v4, s[0:3], 0 offen
; GFX7-NEXT:    buffer_store_dword v1, v5, s[0:3], 0 offen
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr double, ptr %ptr, i64 -256
  %unused = atomicrmw fadd ptr %gep, double %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret void
}

; --------------------------------------------------------------------
; half
; --------------------------------------------------------------------

define half @flat_agent_atomic_fadd_ret_f16__amdgpu_no_fine_grained_memory(ptr %ptr, half %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_ret_f16__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v3, v0
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX12-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX12-NEXT:    flat_load_b32 v5, v[0:1]
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX12-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v4, v4
; GFX12-NEXT:  .LBB36_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v6, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX12-NEXT:    v_add_f16_e32 v5, v5, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_cmpswap_b32 v5, v[0:1], v[5:6] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB36_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_ret_f16__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v3, v0
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX940-NEXT:    flat_load_dword v4, v[0:1]
; GFX940-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX940-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v5, v3, s0
; GFX940-NEXT:    v_not_b32_e32 v5, v5
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:  .LBB36_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v7, v4
; GFX940-NEXT:    v_lshrrev_b32_e32 v4, v3, v7
; GFX940-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX940-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX940-NEXT:    v_and_or_b32 v6, v7, v5, v4
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_cmpswap v4, v[0:1], v[6:7] sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v7
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB36_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    v_lshrrev_b32_e32 v0, v3, v4
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_ret_f16__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v3, v0
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX11-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX11-NEXT:    flat_load_b32 v5, v[0:1]
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX11-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v4, v4
; GFX11-NEXT:  .LBB36_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v6, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX11-NEXT:    v_add_f16_e32 v5, v5, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v5, v[0:1], v[5:6] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB36_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_ret_f16__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v3, v0
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX10-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX10-NEXT:    flat_load_dword v5, v[0:1]
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX10-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v4, v4
; GFX10-NEXT:  .LBB36_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v6, v5
; GFX10-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX10-NEXT:    v_add_f16_e32 v5, v5, v2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB36_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_ret_f16__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v3, v0
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX90A-NEXT:    flat_load_dword v4, v[0:1]
; GFX90A-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v5, v3, s4
; GFX90A-NEXT:    v_not_b32_e32 v5, v5
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB36_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, v4
; GFX90A-NEXT:    v_lshrrev_b32_e32 v4, v3, v7
; GFX90A-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX90A-NEXT:    v_and_or_b32 v6, v7, v5, v4
; GFX90A-NEXT:    flat_atomic_cmpswap v4, v[0:1], v[6:7] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v7
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB36_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_lshrrev_b32_e32 v0, v3, v4
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_ret_f16__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v3, v0
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX908-NEXT:    flat_load_dword v4, v[0:1]
; GFX908-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v5, v3, s4
; GFX908-NEXT:    v_not_b32_e32 v5, v5
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB36_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v7, v4
; GFX908-NEXT:    v_lshrrev_b32_e32 v4, v3, v7
; GFX908-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX908-NEXT:    v_and_or_b32 v6, v7, v5, v4
; GFX908-NEXT:    flat_atomic_cmpswap v4, v[0:1], v[6:7] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v7
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB36_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_lshrrev_b32_e32 v0, v3, v4
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_ret_f16__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v3, v0
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX8-NEXT:    flat_load_dword v5, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX8-NEXT:    v_not_b32_e32 v4, v4
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB36_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v6, v5
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX8-NEXT:    v_add_f16_e32 v5, v5, v2
; GFX8-NEXT:    v_and_b32_e32 v7, v6, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX8-NEXT:    v_or_b32_e32 v5, v7, v5
; GFX8-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v6
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB36_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_ret_f16__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v3, v0
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX7-NEXT:    flat_load_dword v5, v[0:1]
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v2
; GFX7-NEXT:    v_and_b32_e32 v2, 3, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 3, v2
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v4
; GFX7-NEXT:    v_lshl_b32_e32 v4, 0xffff, v2
; GFX7-NEXT:    v_not_b32_e32 v4, v4
; GFX7-NEXT:  .LBB36_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v6, v5
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, v2, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_and_b32_e32 v7, v6, v4
; GFX7-NEXT:    v_add_f32_e32 v5, v5, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, v2, v5
; GFX7-NEXT:    v_or_b32_e32 v5, v7, v5
; GFX7-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v6
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB36_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, v2, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr %ptr, half %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret half %result
}

define half @flat_agent_atomic_fadd_ret_f16__offset12b_pos__amdgpu_no_fine_grained_memory(ptr %ptr, half %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_ret_f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX12-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX12-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX12-NEXT:    flat_load_b32 v5, v[0:1]
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX12-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v4, v4
; GFX12-NEXT:  .LBB37_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v6, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX12-NEXT:    v_add_f16_e32 v5, v5, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_cmpswap_b32 v5, v[0:1], v[5:6] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB37_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_ret_f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_mov_b64 s[0:1], 0x7fe
; GFX940-NEXT:    v_lshl_add_u64 v[6:7], v[0:1], 0, s[0:1]
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v6
; GFX940-NEXT:    v_mov_b32_e32 v1, v7
; GFX940-NEXT:    flat_load_dword v4, v[0:1]
; GFX940-NEXT:    v_and_b32_e32 v3, 3, v6
; GFX940-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v5, v3, s0
; GFX940-NEXT:    v_not_b32_e32 v5, v5
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:  .LBB37_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v7, v4
; GFX940-NEXT:    v_lshrrev_b32_e32 v4, v3, v7
; GFX940-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX940-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX940-NEXT:    v_and_or_b32 v6, v7, v5, v4
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_cmpswap v4, v[0:1], v[6:7] sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v7
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB37_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    v_lshrrev_b32_e32 v0, v3, v4
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_ret_f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX11-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX11-NEXT:    flat_load_b32 v5, v[0:1]
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX11-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v4, v4
; GFX11-NEXT:  .LBB37_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v6, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX11-NEXT:    v_add_f16_e32 v5, v5, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v5, v[0:1], v[5:6] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB37_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_ret_f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX10-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX10-NEXT:    flat_load_dword v5, v[0:1]
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX10-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v4, v4
; GFX10-NEXT:  .LBB37_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v6, v5
; GFX10-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX10-NEXT:    v_add_f16_e32 v5, v5, v2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB37_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_ret_f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v3, vcc, 0x7fe, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX90A-NEXT:    flat_load_dword v4, v[0:1]
; GFX90A-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v5, v3, s4
; GFX90A-NEXT:    v_not_b32_e32 v5, v5
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB37_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, v4
; GFX90A-NEXT:    v_lshrrev_b32_e32 v4, v3, v7
; GFX90A-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX90A-NEXT:    v_and_or_b32 v6, v7, v5, v4
; GFX90A-NEXT:    flat_atomic_cmpswap v4, v[0:1], v[6:7] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v7
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB37_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_lshrrev_b32_e32 v0, v3, v4
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_ret_f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v3, vcc, 0x7fe, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX908-NEXT:    flat_load_dword v4, v[0:1]
; GFX908-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v5, v3, s4
; GFX908-NEXT:    v_not_b32_e32 v5, v5
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB37_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v7, v4
; GFX908-NEXT:    v_lshrrev_b32_e32 v4, v3, v7
; GFX908-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX908-NEXT:    v_and_or_b32 v6, v7, v5, v4
; GFX908-NEXT:    flat_atomic_cmpswap v4, v[0:1], v[6:7] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v7
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB37_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_lshrrev_b32_e32 v0, v3, v4
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_ret_f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fe, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX8-NEXT:    flat_load_dword v5, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX8-NEXT:    v_not_b32_e32 v4, v4
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB37_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v6, v5
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX8-NEXT:    v_add_f16_e32 v5, v5, v2
; GFX8-NEXT:    v_and_b32_e32 v7, v6, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX8-NEXT:    v_or_b32_e32 v5, v7, v5
; GFX8-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v6
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB37_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_ret_f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v3, vcc, 0x7fe, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX7-NEXT:    flat_load_dword v5, v[0:1]
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v2
; GFX7-NEXT:    v_and_b32_e32 v2, 3, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 3, v2
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v4
; GFX7-NEXT:    v_lshl_b32_e32 v4, 0xffff, v2
; GFX7-NEXT:    v_not_b32_e32 v4, v4
; GFX7-NEXT:  .LBB37_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v6, v5
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, v2, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_and_b32_e32 v7, v6, v4
; GFX7-NEXT:    v_add_f32_e32 v5, v5, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, v2, v5
; GFX7-NEXT:    v_or_b32_e32 v5, v7, v5
; GFX7-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v6
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB37_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, v2, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr half, ptr %ptr, i64 1023
  %result = atomicrmw fadd ptr %gep, half %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret half %result
}

define half @flat_agent_atomic_fadd_ret_f16__offset12b_neg__amdgpu_no_fine_grained_memory(ptr %ptr, half %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_ret_f16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_co_u32 v3, vcc_lo, 0xfffff800, v0
; GFX12-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX12-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX12-NEXT:    flat_load_b32 v5, v[0:1]
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX12-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v4, v4
; GFX12-NEXT:  .LBB38_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v6, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX12-NEXT:    v_add_f16_e32 v5, v5, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_cmpswap_b32 v5, v[0:1], v[5:6] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB38_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_ret_f16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_movk_i32 s0, 0xf800
; GFX940-NEXT:    s_mov_b32 s1, -1
; GFX940-NEXT:    v_lshl_add_u64 v[6:7], v[0:1], 0, s[0:1]
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v6
; GFX940-NEXT:    v_mov_b32_e32 v1, v7
; GFX940-NEXT:    flat_load_dword v4, v[0:1]
; GFX940-NEXT:    v_and_b32_e32 v3, 3, v6
; GFX940-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v5, v3, s0
; GFX940-NEXT:    v_not_b32_e32 v5, v5
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:  .LBB38_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v7, v4
; GFX940-NEXT:    v_lshrrev_b32_e32 v4, v3, v7
; GFX940-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX940-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX940-NEXT:    v_and_or_b32 v6, v7, v5, v4
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_cmpswap v4, v[0:1], v[6:7] sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v7
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB38_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    v_lshrrev_b32_e32 v0, v3, v4
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_ret_f16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v3, vcc_lo, 0xfffff800, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX11-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX11-NEXT:    flat_load_b32 v5, v[0:1]
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX11-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v4, v4
; GFX11-NEXT:  .LBB38_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v6, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX11-NEXT:    v_add_f16_e32 v5, v5, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v5, v[0:1], v[5:6] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB38_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_ret_f16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v3, vcc_lo, 0xfffff800, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX10-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX10-NEXT:    flat_load_dword v5, v[0:1]
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX10-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v4, v4
; GFX10-NEXT:  .LBB38_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v6, v5
; GFX10-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX10-NEXT:    v_add_f16_e32 v5, v5, v2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB38_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_ret_f16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v3, vcc, 0xfffff800, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX90A-NEXT:    flat_load_dword v4, v[0:1]
; GFX90A-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v5, v3, s4
; GFX90A-NEXT:    v_not_b32_e32 v5, v5
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB38_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, v4
; GFX90A-NEXT:    v_lshrrev_b32_e32 v4, v3, v7
; GFX90A-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX90A-NEXT:    v_and_or_b32 v6, v7, v5, v4
; GFX90A-NEXT:    flat_atomic_cmpswap v4, v[0:1], v[6:7] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v7
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB38_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_lshrrev_b32_e32 v0, v3, v4
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_ret_f16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v3, vcc, 0xfffff800, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX908-NEXT:    flat_load_dword v4, v[0:1]
; GFX908-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v5, v3, s4
; GFX908-NEXT:    v_not_b32_e32 v5, v5
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB38_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v7, v4
; GFX908-NEXT:    v_lshrrev_b32_e32 v4, v3, v7
; GFX908-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX908-NEXT:    v_and_or_b32 v6, v7, v5, v4
; GFX908-NEXT:    flat_atomic_cmpswap v4, v[0:1], v[6:7] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v7
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB38_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_lshrrev_b32_e32 v0, v3, v4
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_ret_f16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0xfffff800, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX8-NEXT:    flat_load_dword v5, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX8-NEXT:    v_not_b32_e32 v4, v4
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB38_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v6, v5
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX8-NEXT:    v_add_f16_e32 v5, v5, v2
; GFX8-NEXT:    v_and_b32_e32 v7, v6, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX8-NEXT:    v_or_b32_e32 v5, v7, v5
; GFX8-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v6
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB38_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_ret_f16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v3, vcc, 0xfffff800, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX7-NEXT:    flat_load_dword v5, v[0:1]
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v2
; GFX7-NEXT:    v_and_b32_e32 v2, 3, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 3, v2
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v4
; GFX7-NEXT:    v_lshl_b32_e32 v4, 0xffff, v2
; GFX7-NEXT:    v_not_b32_e32 v4, v4
; GFX7-NEXT:  .LBB38_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v6, v5
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, v2, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_and_b32_e32 v7, v6, v4
; GFX7-NEXT:    v_add_f32_e32 v5, v5, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, v2, v5
; GFX7-NEXT:    v_or_b32_e32 v5, v7, v5
; GFX7-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v6
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB38_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, v2, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr half, ptr %ptr, i64 -1024
  %result = atomicrmw fadd ptr %gep, half %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret half %result
 }

define void @flat_agent_atomic_fadd_noret_f16__amdgpu_no_fine_grained_memory(ptr %ptr, half %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_f16__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v3, v0
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX12-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX12-NEXT:    flat_load_b32 v4, v[0:1]
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX12-NEXT:    v_lshlrev_b32_e64 v3, v5, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v6, v3
; GFX12-NEXT:  .LBB39_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX12-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX12-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[3:4] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX12-NEXT:    v_mov_b32_e32 v4, v3
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB39_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_f16__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v3, v0
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX940-NEXT:    flat_load_dword v5, v[0:1]
; GFX940-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX940-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v4, v3, s0
; GFX940-NEXT:    v_not_b32_e32 v6, v4
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:  .LBB39_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_lshrrev_b32_e32 v4, v3, v5
; GFX940-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX940-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX940-NEXT:    v_and_or_b32 v4, v5, v6, v4
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_cmpswap v4, v[0:1], v[4:5] sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v5
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    v_mov_b32_e32 v5, v4
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB39_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_f16__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v3, v0
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX11-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX11-NEXT:    flat_load_b32 v4, v[0:1]
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX11-NEXT:    v_lshlrev_b32_e64 v3, v5, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v6, v3
; GFX11-NEXT:  .LBB39_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX11-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX11-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[3:4] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB39_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_f16__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v3, v0
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX10-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX10-NEXT:    flat_load_dword v4, v[0:1]
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX10-NEXT:    v_lshlrev_b32_e64 v3, v5, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v6, v3
; GFX10-NEXT:  .LBB39_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX10-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, v5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB39_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_f16__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v3, v0
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX90A-NEXT:    flat_load_dword v5, v[0:1]
; GFX90A-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX90A-NEXT:    v_not_b32_e32 v6, v4
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB39_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_lshrrev_b32_e32 v4, v3, v5
; GFX90A-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX90A-NEXT:    v_and_or_b32 v4, v5, v6, v4
; GFX90A-NEXT:    flat_atomic_cmpswap v4, v[0:1], v[4:5] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v5, v4
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB39_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_f16__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v3, v0
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX908-NEXT:    flat_load_dword v4, v[0:1]
; GFX908-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v3, v5, s4
; GFX908-NEXT:    v_not_b32_e32 v6, v3
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB39_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX908-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX908-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB39_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_f16__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v3, v0
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v3, v5, s4
; GFX8-NEXT:    v_not_b32_e32 v6, v3
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB39_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX8-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX8-NEXT:    v_and_b32_e32 v7, v4, v6
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX8-NEXT:    v_or_b32_e32 v3, v7, v3
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB39_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_f16__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v3, v0
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX7-NEXT:    flat_load_dword v4, v[0:1]
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v2
; GFX7-NEXT:    v_and_b32_e32 v2, 3, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 3, v2
; GFX7-NEXT:    v_lshl_b32_e32 v3, 0xffff, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_not_b32_e32 v6, v3
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB39_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, v2, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_and_b32_e32 v7, v4, v6
; GFX7-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, v2, v3
; GFX7-NEXT:    v_or_b32_e32 v3, v7, v3
; GFX7-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v4, v3
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB39_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %unused = atomicrmw fadd ptr %ptr, half %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret void
}

define void @flat_agent_atomic_fadd_noret_f16__offset12b_pos__amdgpu_no_fine_grained_memory(ptr %ptr, half %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX12-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX12-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX12-NEXT:    flat_load_b32 v4, v[0:1]
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX12-NEXT:    v_lshlrev_b32_e64 v3, v5, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v6, v3
; GFX12-NEXT:  .LBB40_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX12-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX12-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[3:4] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX12-NEXT:    v_mov_b32_e32 v4, v3
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB40_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_mov_b64 s[0:1], 0x7fe
; GFX940-NEXT:    v_lshl_add_u64 v[4:5], v[0:1], 0, s[0:1]
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX940-NEXT:    v_mov_b32_e32 v1, v5
; GFX940-NEXT:    flat_load_dword v5, v[0:1]
; GFX940-NEXT:    v_and_b32_e32 v3, 3, v4
; GFX940-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v4, v3, s0
; GFX940-NEXT:    v_not_b32_e32 v6, v4
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:  .LBB40_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_lshrrev_b32_e32 v4, v3, v5
; GFX940-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX940-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX940-NEXT:    v_and_or_b32 v4, v5, v6, v4
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_cmpswap v4, v[0:1], v[4:5] sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v5
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    v_mov_b32_e32 v5, v4
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB40_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX11-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX11-NEXT:    flat_load_b32 v4, v[0:1]
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX11-NEXT:    v_lshlrev_b32_e64 v3, v5, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v6, v3
; GFX11-NEXT:  .LBB40_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX11-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX11-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[3:4] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB40_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX10-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX10-NEXT:    flat_load_dword v4, v[0:1]
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX10-NEXT:    v_lshlrev_b32_e64 v3, v5, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v6, v3
; GFX10-NEXT:  .LBB40_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX10-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, v5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB40_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v3, vcc, 0x7fe, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX90A-NEXT:    flat_load_dword v5, v[0:1]
; GFX90A-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX90A-NEXT:    v_not_b32_e32 v6, v4
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB40_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_lshrrev_b32_e32 v4, v3, v5
; GFX90A-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX90A-NEXT:    v_and_or_b32 v4, v5, v6, v4
; GFX90A-NEXT:    flat_atomic_cmpswap v4, v[0:1], v[4:5] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v5, v4
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB40_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v3, vcc, 0x7fe, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX908-NEXT:    flat_load_dword v4, v[0:1]
; GFX908-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v3, v5, s4
; GFX908-NEXT:    v_not_b32_e32 v6, v3
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB40_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX908-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX908-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB40_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fe, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v3, v5, s4
; GFX8-NEXT:    v_not_b32_e32 v6, v3
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB40_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX8-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX8-NEXT:    v_and_b32_e32 v7, v4, v6
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX8-NEXT:    v_or_b32_e32 v3, v7, v3
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB40_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 0x7fe, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX7-NEXT:    flat_load_dword v3, v[0:1]
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v2
; GFX7-NEXT:    v_lshl_b32_e32 v2, 0xffff, v4
; GFX7-NEXT:    v_not_b32_e32 v6, v2
; GFX7-NEXT:  .LBB40_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, v4, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_and_b32_e32 v7, v3, v6
; GFX7-NEXT:    v_add_f32_e32 v2, v2, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v4, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v7, v2
; GFX7-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v3, v2
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB40_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr half, ptr %ptr, i64 1023
  %unused = atomicrmw fadd ptr %gep, half %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret void
}

define void @flat_agent_atomic_fadd_noret_f16__offset12b_neg__amdgpu_no_fine_grained_memory(ptr %ptr, half %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_f16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_co_u32 v3, vcc_lo, 0xfffff800, v0
; GFX12-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX12-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX12-NEXT:    flat_load_b32 v4, v[0:1]
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX12-NEXT:    v_lshlrev_b32_e64 v3, v5, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v6, v3
; GFX12-NEXT:  .LBB41_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX12-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX12-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[3:4] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX12-NEXT:    v_mov_b32_e32 v4, v3
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB41_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_f16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_movk_i32 s0, 0xf800
; GFX940-NEXT:    s_mov_b32 s1, -1
; GFX940-NEXT:    v_lshl_add_u64 v[4:5], v[0:1], 0, s[0:1]
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX940-NEXT:    v_mov_b32_e32 v1, v5
; GFX940-NEXT:    flat_load_dword v5, v[0:1]
; GFX940-NEXT:    v_and_b32_e32 v3, 3, v4
; GFX940-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v4, v3, s0
; GFX940-NEXT:    v_not_b32_e32 v6, v4
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:  .LBB41_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_lshrrev_b32_e32 v4, v3, v5
; GFX940-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX940-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX940-NEXT:    v_and_or_b32 v4, v5, v6, v4
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_cmpswap v4, v[0:1], v[4:5] sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v5
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    v_mov_b32_e32 v5, v4
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB41_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_f16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v3, vcc_lo, 0xfffff800, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX11-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX11-NEXT:    flat_load_b32 v4, v[0:1]
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX11-NEXT:    v_lshlrev_b32_e64 v3, v5, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v6, v3
; GFX11-NEXT:  .LBB41_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX11-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX11-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[3:4] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB41_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_f16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v3, vcc_lo, 0xfffff800, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX10-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX10-NEXT:    flat_load_dword v4, v[0:1]
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX10-NEXT:    v_lshlrev_b32_e64 v3, v5, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v6, v3
; GFX10-NEXT:  .LBB41_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX10-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, v5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB41_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_f16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v3, vcc, 0xfffff800, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX90A-NEXT:    flat_load_dword v5, v[0:1]
; GFX90A-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX90A-NEXT:    v_not_b32_e32 v6, v4
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB41_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_lshrrev_b32_e32 v4, v3, v5
; GFX90A-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX90A-NEXT:    v_and_or_b32 v4, v5, v6, v4
; GFX90A-NEXT:    flat_atomic_cmpswap v4, v[0:1], v[4:5] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v5, v4
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB41_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_f16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v3, vcc, 0xfffff800, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX908-NEXT:    flat_load_dword v4, v[0:1]
; GFX908-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v3, v5, s4
; GFX908-NEXT:    v_not_b32_e32 v6, v3
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB41_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX908-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX908-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB41_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_f16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0xfffff800, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v3, v5, s4
; GFX8-NEXT:    v_not_b32_e32 v6, v3
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB41_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX8-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX8-NEXT:    v_and_b32_e32 v7, v4, v6
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX8-NEXT:    v_or_b32_e32 v3, v7, v3
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB41_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_f16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 0xfffff800, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX7-NEXT:    flat_load_dword v3, v[0:1]
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v2
; GFX7-NEXT:    v_lshl_b32_e32 v2, 0xffff, v4
; GFX7-NEXT:    v_not_b32_e32 v6, v2
; GFX7-NEXT:  .LBB41_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, v4, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_and_b32_e32 v7, v3, v6
; GFX7-NEXT:    v_add_f32_e32 v2, v2, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v4, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v7, v2
; GFX7-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v3, v2
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB41_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr half, ptr %ptr, i64 -1024
  %unused = atomicrmw fadd ptr %gep, half %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret void
}

define void @flat_agent_atomic_fadd_noret_f16__offset12b__align4_pos__amdgpu_no_fine_grained_memory(ptr %ptr, half %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_f16__offset12b__align4_pos__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    flat_load_b32 v4, v[0:1] offset:2046
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:  .LBB42_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    v_add_f16_e32 v3, v4, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX12-NEXT:    v_and_or_b32 v3, 0xffff0000, v4, v3
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[3:4] offset:2046 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX12-NEXT:    v_mov_b32_e32 v4, v3
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB42_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_f16__offset12b__align4_pos__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    flat_load_dword v5, v[0:1] offset:2046
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:    s_mov_b32 s2, 0xffff0000
; GFX940-NEXT:  .LBB42_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_add_f16_e32 v3, v5, v2
; GFX940-NEXT:    v_and_or_b32 v4, v5, s2, v3
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[4:5] offset:2046 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    v_mov_b32_e32 v5, v3
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB42_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_f16__offset12b__align4_pos__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_b32 v4, v[0:1] offset:2046
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB42_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_f16_e32 v3, v4, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-NEXT:    v_and_or_b32 v3, 0xffff0000, v4, v3
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[3:4] offset:2046 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB42_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_f16__offset12b__align4_pos__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0x7fe, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v4, v[0:1]
; GFX10-NEXT:  .LBB42_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_f16_e32 v3, v4, v2
; GFX10-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX10-NEXT:    v_and_or_b32 v3, 0xffff0000, v4, v3
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB42_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_f16__offset12b__align4_pos__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    flat_load_dword v5, v[0:1] offset:2046
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    s_mov_b32 s6, 0xffff0000
; GFX90A-NEXT:  .LBB42_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_f16_e32 v3, v5, v2
; GFX90A-NEXT:    v_and_or_b32 v4, v5, s6, v3
; GFX90A-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[4:5] offset:2046 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB42_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_f16__offset12b__align4_pos__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v4, v[0:1] offset:2046
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    s_mov_b32 s6, 0xffff0000
; GFX908-NEXT:  .LBB42_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_f16_e32 v3, v4, v2
; GFX908-NEXT:    v_and_or_b32 v3, v4, s6, v3
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] offset:2046 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB42_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_f16__offset12b__align4_pos__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0x7fe, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB42_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_f16_e32 v3, v4, v2
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v4
; GFX8-NEXT:    v_or_b32_e32 v3, v5, v3
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB42_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_f16__offset12b__align4_pos__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, 0x7fe, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    flat_load_dword v3, v[0:1]
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v2
; GFX7-NEXT:  .LBB42_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v3
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff0000, v3
; GFX7-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v5, v2
; GFX7-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v3, v2
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB42_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr half, ptr %ptr, i64 1023
  %unused = atomicrmw fadd ptr %gep, half %val syncscope("agent") seq_cst, align 4, !amdgpu.no.fine.grained.memory !0
  ret void
}

define half @flat_agent_atomic_fadd_ret_f16__offset12b_pos__align4__amdgpu_no_fine_grained_memory(ptr %ptr, half %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_ret_f16__offset12b_pos__align4__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    flat_load_b32 v3, v[0:1] offset:2046
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:  .LBB43_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v4, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add_f16_e32 v3, v4, v2
; GFX12-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v3, 0xffff0000, v4, v3
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[3:4] offset:2046 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB43_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    v_mov_b32_e32 v0, v3
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_ret_f16__offset12b_pos__align4__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    flat_load_dword v3, v[0:1] offset:2046
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:    s_mov_b32 s2, 0xffff0000
; GFX940-NEXT:  .LBB43_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v5, v3
; GFX940-NEXT:    v_add_f16_e32 v3, v5, v2
; GFX940-NEXT:    v_and_or_b32 v4, v5, s2, v3
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[4:5] offset:2046 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB43_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    v_mov_b32_e32 v0, v3
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_ret_f16__offset12b_pos__align4__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_b32 v3, v[0:1] offset:2046
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB43_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f16_e32 v3, v4, v2
; GFX11-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v3, 0xffff0000, v4, v3
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[3:4] offset:2046 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB43_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_ret_f16__offset12b_pos__align4__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v4, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v0, v[3:4]
; GFX10-NEXT:  .LBB43_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, v0
; GFX10-NEXT:    v_add_f16_e32 v0, v1, v2
; GFX10-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX10-NEXT:    v_and_or_b32 v0, 0xffff0000, v1, v0
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB43_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_ret_f16__offset12b_pos__align4__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    flat_load_dword v3, v[0:1] offset:2046
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    s_mov_b32 s6, 0xffff0000
; GFX90A-NEXT:  .LBB43_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    v_add_f16_e32 v3, v5, v2
; GFX90A-NEXT:    v_and_or_b32 v4, v5, s6, v3
; GFX90A-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[4:5] offset:2046 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB43_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_ret_f16__offset12b_pos__align4__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v3, v[0:1] offset:2046
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    s_mov_b32 s6, 0xffff0000
; GFX908-NEXT:  .LBB43_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_add_f16_e32 v3, v4, v2
; GFX908-NEXT:    v_and_or_b32 v3, v4, s6, v3
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] offset:2046 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB43_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_ret_f16__offset12b_pos__align4__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fe, v0
; GFX8-NEXT:    v_addc_u32_e32 v4, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[3:4]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB43_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, v0
; GFX8-NEXT:    v_add_f16_e32 v0, v1, v2
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v1
; GFX8-NEXT:    v_or_b32_e32 v0, v5, v0
; GFX8-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB43_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_ret_f16__offset12b_pos__align4__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, 0x7fe, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    flat_load_dword v3, v[0:1]
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:  .LBB43_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v4, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v4
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff0000, v4
; GFX7-NEXT:    v_add_f32_e32 v3, v3, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_or_b32_e32 v3, v5, v3
; GFX7-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB43_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr half, ptr %ptr, i64 1023
  %result = atomicrmw fadd ptr %gep, half %val syncscope("agent") seq_cst, align 4, !amdgpu.no.fine.grained.memory !0
  ret half %result
}

define half @flat_system_atomic_fadd_ret_f16__offset12b_pos__amdgpu_no_fine_grained_memory(ptr %ptr, half %val) #0 {
; GFX12-LABEL: flat_system_atomic_fadd_ret_f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX12-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX12-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX12-NEXT:    flat_load_b32 v5, v[0:1]
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX12-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v4, v4
; GFX12-NEXT:  .LBB44_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v6, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX12-NEXT:    v_add_f16_e32 v5, v5, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_cmpswap_b32 v5, v[0:1], v[5:6] th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB44_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_system_atomic_fadd_ret_f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_mov_b64 s[0:1], 0x7fe
; GFX940-NEXT:    v_lshl_add_u64 v[6:7], v[0:1], 0, s[0:1]
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v6
; GFX940-NEXT:    v_mov_b32_e32 v1, v7
; GFX940-NEXT:    flat_load_dword v4, v[0:1]
; GFX940-NEXT:    v_and_b32_e32 v3, 3, v6
; GFX940-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v5, v3, s0
; GFX940-NEXT:    v_not_b32_e32 v5, v5
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:  .LBB44_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v7, v4
; GFX940-NEXT:    v_lshrrev_b32_e32 v4, v3, v7
; GFX940-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX940-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX940-NEXT:    v_and_or_b32 v6, v7, v5, v4
; GFX940-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-NEXT:    flat_atomic_cmpswap v4, v[0:1], v[6:7] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc0 sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v7
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB44_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    v_lshrrev_b32_e32 v0, v3, v4
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_system_atomic_fadd_ret_f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX11-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX11-NEXT:    flat_load_b32 v5, v[0:1]
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX11-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v4, v4
; GFX11-NEXT:  .LBB44_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v6, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX11-NEXT:    v_add_f16_e32 v5, v5, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v5, v[0:1], v[5:6] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB44_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_system_atomic_fadd_ret_f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX10-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX10-NEXT:    flat_load_dword v5, v[0:1]
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX10-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v4, v4
; GFX10-NEXT:  .LBB44_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v6, v5
; GFX10-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX10-NEXT:    v_add_f16_e32 v5, v5, v2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB44_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_system_atomic_fadd_ret_f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v3, vcc, 0x7fe, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX90A-NEXT:    flat_load_dword v4, v[0:1]
; GFX90A-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v5, v3, s4
; GFX90A-NEXT:    v_not_b32_e32 v5, v5
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB44_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, v4
; GFX90A-NEXT:    v_lshrrev_b32_e32 v4, v3, v7
; GFX90A-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX90A-NEXT:    v_and_or_b32 v6, v7, v5, v4
; GFX90A-NEXT:    buffer_wbl2
; GFX90A-NEXT:    flat_atomic_cmpswap v4, v[0:1], v[6:7] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_invl2
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v7
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB44_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_lshrrev_b32_e32 v0, v3, v4
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_system_atomic_fadd_ret_f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v3, vcc, 0x7fe, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX908-NEXT:    flat_load_dword v4, v[0:1]
; GFX908-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v5, v3, s4
; GFX908-NEXT:    v_not_b32_e32 v5, v5
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB44_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v7, v4
; GFX908-NEXT:    v_lshrrev_b32_e32 v4, v3, v7
; GFX908-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX908-NEXT:    v_and_or_b32 v6, v7, v5, v4
; GFX908-NEXT:    flat_atomic_cmpswap v4, v[0:1], v[6:7] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v7
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB44_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_lshrrev_b32_e32 v0, v3, v4
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_system_atomic_fadd_ret_f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fe, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX8-NEXT:    flat_load_dword v5, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX8-NEXT:    v_not_b32_e32 v4, v4
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB44_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v6, v5
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX8-NEXT:    v_add_f16_e32 v5, v5, v2
; GFX8-NEXT:    v_and_b32_e32 v7, v6, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX8-NEXT:    v_or_b32_e32 v5, v7, v5
; GFX8-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v6
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB44_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_system_atomic_fadd_ret_f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v3, vcc, 0x7fe, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX7-NEXT:    flat_load_dword v5, v[0:1]
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v2
; GFX7-NEXT:    v_and_b32_e32 v2, 3, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 3, v2
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v4
; GFX7-NEXT:    v_lshl_b32_e32 v4, 0xffff, v2
; GFX7-NEXT:    v_not_b32_e32 v4, v4
; GFX7-NEXT:  .LBB44_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v6, v5
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, v2, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_and_b32_e32 v7, v6, v4
; GFX7-NEXT:    v_add_f32_e32 v5, v5, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, v2, v5
; GFX7-NEXT:    v_or_b32_e32 v5, v7, v5
; GFX7-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v6
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB44_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, v2, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr half, ptr %ptr, i64 1023
  %result = atomicrmw fadd ptr %gep, half %val seq_cst, !amdgpu.no.fine.grained.memory !0
  ret half %result
}

define void @flat_system_atomic_fadd_noret_f16__offset12b_pos__amdgpu_no_fine_grained_memory(ptr %ptr, half %val) #0 {
; GFX12-LABEL: flat_system_atomic_fadd_noret_f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX12-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX12-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX12-NEXT:    flat_load_b32 v4, v[0:1]
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX12-NEXT:    v_lshlrev_b32_e64 v3, v5, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v6, v3
; GFX12-NEXT:  .LBB45_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX12-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX12-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[3:4] th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX12-NEXT:    v_mov_b32_e32 v4, v3
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB45_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_system_atomic_fadd_noret_f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_mov_b64 s[0:1], 0x7fe
; GFX940-NEXT:    v_lshl_add_u64 v[4:5], v[0:1], 0, s[0:1]
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX940-NEXT:    v_mov_b32_e32 v1, v5
; GFX940-NEXT:    flat_load_dword v5, v[0:1]
; GFX940-NEXT:    v_and_b32_e32 v3, 3, v4
; GFX940-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v4, v3, s0
; GFX940-NEXT:    v_not_b32_e32 v6, v4
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:  .LBB45_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_lshrrev_b32_e32 v4, v3, v5
; GFX940-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX940-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX940-NEXT:    v_and_or_b32 v4, v5, v6, v4
; GFX940-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-NEXT:    flat_atomic_cmpswap v4, v[0:1], v[4:5] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc0 sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v5
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    v_mov_b32_e32 v5, v4
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB45_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_system_atomic_fadd_noret_f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX11-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX11-NEXT:    flat_load_b32 v4, v[0:1]
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX11-NEXT:    v_lshlrev_b32_e64 v3, v5, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v6, v3
; GFX11-NEXT:  .LBB45_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX11-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX11-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[3:4] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB45_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_system_atomic_fadd_noret_f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX10-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX10-NEXT:    flat_load_dword v4, v[0:1]
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX10-NEXT:    v_lshlrev_b32_e64 v3, v5, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v6, v3
; GFX10-NEXT:  .LBB45_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX10-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, v5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB45_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_system_atomic_fadd_noret_f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v3, vcc, 0x7fe, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX90A-NEXT:    flat_load_dword v5, v[0:1]
; GFX90A-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX90A-NEXT:    v_not_b32_e32 v6, v4
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB45_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_lshrrev_b32_e32 v4, v3, v5
; GFX90A-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX90A-NEXT:    v_and_or_b32 v4, v5, v6, v4
; GFX90A-NEXT:    buffer_wbl2
; GFX90A-NEXT:    flat_atomic_cmpswap v4, v[0:1], v[4:5] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_invl2
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v5, v4
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB45_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_system_atomic_fadd_noret_f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v3, vcc, 0x7fe, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX908-NEXT:    flat_load_dword v4, v[0:1]
; GFX908-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v3, v5, s4
; GFX908-NEXT:    v_not_b32_e32 v6, v3
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB45_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX908-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX908-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB45_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_system_atomic_fadd_noret_f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fe, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v3, v5, s4
; GFX8-NEXT:    v_not_b32_e32 v6, v3
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB45_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX8-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX8-NEXT:    v_and_b32_e32 v7, v4, v6
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX8-NEXT:    v_or_b32_e32 v3, v7, v3
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB45_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_system_atomic_fadd_noret_f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 0x7fe, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX7-NEXT:    flat_load_dword v3, v[0:1]
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v2
; GFX7-NEXT:    v_lshl_b32_e32 v2, 0xffff, v4
; GFX7-NEXT:    v_not_b32_e32 v6, v2
; GFX7-NEXT:  .LBB45_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, v4, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_and_b32_e32 v7, v3, v6
; GFX7-NEXT:    v_add_f32_e32 v2, v2, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v4, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v7, v2
; GFX7-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v3, v2
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB45_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr half, ptr %ptr, i64 1023
  %unused = atomicrmw fadd ptr %gep, half %val seq_cst, !amdgpu.no.fine.grained.memory !0
  ret void
}

; --------------------------------------------------------------------
; bfloat
; --------------------------------------------------------------------

define bfloat @flat_agent_atomic_fadd_ret_bf16__amdgpu_no_fine_grained_memory(ptr %ptr, bfloat %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_ret_bf16__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v3, v0 :: v_dual_lshlrev_b32 v2, 16, v2
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX12-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX12-NEXT:    flat_load_b32 v5, v[0:1]
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX12-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v4, v4
; GFX12-NEXT:  .LBB46_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v6, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX12-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX12-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX12-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX12-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc_lo
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_cmpswap_b32 v5, v[0:1], v[5:6] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB46_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_ret_bf16__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v3, v0
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX940-NEXT:    flat_load_dword v5, v[0:1]
; GFX940-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX940-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v4, v3, s0
; GFX940-NEXT:    v_not_b32_e32 v4, v4
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX940-NEXT:    s_movk_i32 s2, 0x7fff
; GFX940-NEXT:  .LBB46_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v7, v5
; GFX940-NEXT:    v_lshrrev_b32_sdwa v5, v3, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX940-NEXT:    v_bfe_u32 v6, v5, 16, 1
; GFX940-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX940-NEXT:    v_add3_u32 v6, v6, v5, s2
; GFX940-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v5, v6, v8, vcc
; GFX940-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX940-NEXT:    v_and_or_b32 v6, v7, v4, v5
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[6:7] sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v7
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB46_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_ret_bf16__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v3, v0 :: v_dual_lshlrev_b32 v2, 16, v2
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX11-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX11-NEXT:    flat_load_b32 v5, v[0:1]
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX11-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v4, v4
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB46_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v6, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX11-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX11-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v5, v[0:1], v[5:6] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB46_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_ret_bf16__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v3, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX10-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX10-NEXT:    flat_load_dword v5, v[0:1]
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX10-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v4, v4
; GFX10-NEXT:  .LBB46_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v6, v5
; GFX10-NEXT:    v_lshrrev_b32_sdwa v5, v3, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX10-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX10-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB46_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_ret_bf16__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v3, v0
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX90A-NEXT:    flat_load_dword v5, v[0:1]
; GFX90A-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX90A-NEXT:    v_not_b32_e32 v4, v4
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX90A-NEXT:    s_movk_i32 s6, 0x7fff
; GFX90A-NEXT:  .LBB46_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, v5
; GFX90A-NEXT:    v_lshrrev_b32_sdwa v5, v3, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX90A-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX90A-NEXT:    v_bfe_u32 v6, v5, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX90A-NEXT:    v_add3_u32 v6, v6, v5, s6
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX90A-NEXT:    v_cndmask_b32_e32 v5, v6, v8, vcc
; GFX90A-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX90A-NEXT:    v_and_or_b32 v6, v7, v4, v5
; GFX90A-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[6:7] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v7
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB46_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_ret_bf16__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v3, v0
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX908-NEXT:    flat_load_dword v5, v[0:1]
; GFX908-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX908-NEXT:    v_not_b32_e32 v4, v4
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX908-NEXT:    s_movk_i32 s6, 0x7fff
; GFX908-NEXT:  .LBB46_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v6, v5
; GFX908-NEXT:    v_lshrrev_b32_sdwa v5, v3, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX908-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX908-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX908-NEXT:    v_add3_u32 v7, v7, v5, s6
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX908-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc
; GFX908-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX908-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX908-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v6
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB46_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_ret_bf16__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v3, v0
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX8-NEXT:    flat_load_dword v5, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX8-NEXT:    v_not_b32_e32 v4, v4
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX8-NEXT:  .LBB46_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v6, v5
; GFX8-NEXT:    v_lshrrev_b32_sdwa v5, v3, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX8-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, v8, v5
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, 0x7fff, v8
; GFX8-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v8, v9, vcc
; GFX8-NEXT:    v_and_b32_e32 v7, v6, v4
; GFX8-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v5, v7, v5
; GFX8-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v6
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB46_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_ret_bf16__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v3, v0
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX7-NEXT:    flat_load_dword v5, v[0:1]
; GFX7-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX7-NEXT:    v_lshl_b32_e32 v4, 0xffff, v3
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_not_b32_e32 v4, v4
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:  .LBB46_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v6, v5
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX7-NEXT:    v_and_b32_e32 v7, v6, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX7-NEXT:    v_or_b32_e32 v5, v7, v5
; GFX7-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v6
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB46_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr %ptr, bfloat %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret bfloat %result
}

define bfloat @flat_agent_atomic_fadd_ret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory(ptr %ptr, bfloat %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_ret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX12-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX12-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX12-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    flat_load_b32 v5, v[0:1]
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX12-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v4, v4
; GFX12-NEXT:  .LBB47_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v6, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX12-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX12-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX12-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX12-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc_lo
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_cmpswap_b32 v5, v[0:1], v[5:6] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB47_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_ret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_mov_b64 s[0:1], 0x7fe
; GFX940-NEXT:    v_lshl_add_u64 v[4:5], v[0:1], 0, s[0:1]
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX940-NEXT:    v_mov_b32_e32 v1, v5
; GFX940-NEXT:    flat_load_dword v5, v[0:1]
; GFX940-NEXT:    v_and_b32_e32 v3, 3, v4
; GFX940-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v4, v3, s0
; GFX940-NEXT:    v_not_b32_e32 v4, v4
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX940-NEXT:    s_movk_i32 s2, 0x7fff
; GFX940-NEXT:  .LBB47_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v7, v5
; GFX940-NEXT:    v_lshrrev_b32_sdwa v5, v3, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX940-NEXT:    v_bfe_u32 v6, v5, 16, 1
; GFX940-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX940-NEXT:    v_add3_u32 v6, v6, v5, s2
; GFX940-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v5, v6, v8, vcc
; GFX940-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX940-NEXT:    v_and_or_b32 v6, v7, v4, v5
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[6:7] sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v7
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB47_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_ret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX11-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    flat_load_b32 v5, v[0:1]
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX11-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v4, v4
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB47_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v6, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX11-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX11-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v5, v[0:1], v[5:6] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB47_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_ret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX10-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v5, v[0:1]
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX10-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v4, v4
; GFX10-NEXT:  .LBB47_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v6, v5
; GFX10-NEXT:    v_lshrrev_b32_sdwa v5, v3, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX10-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX10-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB47_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_ret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v3, vcc, 0x7fe, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX90A-NEXT:    flat_load_dword v5, v[0:1]
; GFX90A-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX90A-NEXT:    v_not_b32_e32 v4, v4
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX90A-NEXT:    s_movk_i32 s6, 0x7fff
; GFX90A-NEXT:  .LBB47_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, v5
; GFX90A-NEXT:    v_lshrrev_b32_sdwa v5, v3, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX90A-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX90A-NEXT:    v_bfe_u32 v6, v5, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX90A-NEXT:    v_add3_u32 v6, v6, v5, s6
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX90A-NEXT:    v_cndmask_b32_e32 v5, v6, v8, vcc
; GFX90A-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX90A-NEXT:    v_and_or_b32 v6, v7, v4, v5
; GFX90A-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[6:7] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v7
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB47_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_ret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v3, vcc, 0x7fe, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX908-NEXT:    flat_load_dword v5, v[0:1]
; GFX908-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX908-NEXT:    v_not_b32_e32 v4, v4
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX908-NEXT:    s_movk_i32 s6, 0x7fff
; GFX908-NEXT:  .LBB47_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v6, v5
; GFX908-NEXT:    v_lshrrev_b32_sdwa v5, v3, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX908-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX908-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX908-NEXT:    v_add3_u32 v7, v7, v5, s6
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX908-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc
; GFX908-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX908-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX908-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v6
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB47_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_ret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fe, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX8-NEXT:    flat_load_dword v5, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX8-NEXT:    v_not_b32_e32 v4, v4
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX8-NEXT:  .LBB47_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v6, v5
; GFX8-NEXT:    v_lshrrev_b32_sdwa v5, v3, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX8-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, v8, v5
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, 0x7fff, v8
; GFX8-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v8, v9, vcc
; GFX8-NEXT:    v_and_b32_e32 v7, v6, v4
; GFX8-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v5, v7, v5
; GFX8-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v6
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB47_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_ret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v3, vcc, 0x7fe, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX7-NEXT:    flat_load_dword v5, v[0:1]
; GFX7-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX7-NEXT:    v_lshl_b32_e32 v4, 0xffff, v3
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_not_b32_e32 v4, v4
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:  .LBB47_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v6, v5
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX7-NEXT:    v_and_b32_e32 v7, v6, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX7-NEXT:    v_or_b32_e32 v5, v7, v5
; GFX7-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v6
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB47_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr bfloat, ptr %ptr, i64 1023
  %result = atomicrmw fadd ptr %gep, bfloat %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret bfloat %result
}

define bfloat @flat_agent_atomic_fadd_ret_bf16__offset12b_neg__amdgpu_no_fine_grained_memory(ptr %ptr, bfloat %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_ret_bf16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_co_u32 v3, vcc_lo, 0xfffff800, v0
; GFX12-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX12-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX12-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    flat_load_b32 v5, v[0:1]
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX12-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v4, v4
; GFX12-NEXT:  .LBB48_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v6, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX12-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX12-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX12-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX12-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc_lo
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_cmpswap_b32 v5, v[0:1], v[5:6] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB48_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_ret_bf16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_movk_i32 s0, 0xf800
; GFX940-NEXT:    s_mov_b32 s1, -1
; GFX940-NEXT:    v_lshl_add_u64 v[4:5], v[0:1], 0, s[0:1]
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX940-NEXT:    v_mov_b32_e32 v1, v5
; GFX940-NEXT:    flat_load_dword v5, v[0:1]
; GFX940-NEXT:    v_and_b32_e32 v3, 3, v4
; GFX940-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v4, v3, s0
; GFX940-NEXT:    v_not_b32_e32 v4, v4
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX940-NEXT:    s_movk_i32 s2, 0x7fff
; GFX940-NEXT:  .LBB48_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v7, v5
; GFX940-NEXT:    v_lshrrev_b32_sdwa v5, v3, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX940-NEXT:    v_bfe_u32 v6, v5, 16, 1
; GFX940-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX940-NEXT:    v_add3_u32 v6, v6, v5, s2
; GFX940-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v5, v6, v8, vcc
; GFX940-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX940-NEXT:    v_and_or_b32 v6, v7, v4, v5
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[6:7] sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v7
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB48_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_ret_bf16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v3, vcc_lo, 0xfffff800, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX11-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    flat_load_b32 v5, v[0:1]
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX11-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v4, v4
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB48_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v6, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX11-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX11-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v5, v[0:1], v[5:6] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB48_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_ret_bf16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v3, vcc_lo, 0xfffff800, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX10-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v5, v[0:1]
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX10-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v4, v4
; GFX10-NEXT:  .LBB48_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v6, v5
; GFX10-NEXT:    v_lshrrev_b32_sdwa v5, v3, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX10-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX10-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB48_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_ret_bf16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v3, vcc, 0xfffff800, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX90A-NEXT:    flat_load_dword v5, v[0:1]
; GFX90A-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX90A-NEXT:    v_not_b32_e32 v4, v4
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX90A-NEXT:    s_movk_i32 s6, 0x7fff
; GFX90A-NEXT:  .LBB48_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, v5
; GFX90A-NEXT:    v_lshrrev_b32_sdwa v5, v3, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX90A-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX90A-NEXT:    v_bfe_u32 v6, v5, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX90A-NEXT:    v_add3_u32 v6, v6, v5, s6
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX90A-NEXT:    v_cndmask_b32_e32 v5, v6, v8, vcc
; GFX90A-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX90A-NEXT:    v_and_or_b32 v6, v7, v4, v5
; GFX90A-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[6:7] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v7
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB48_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_ret_bf16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v3, vcc, 0xfffff800, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX908-NEXT:    flat_load_dword v5, v[0:1]
; GFX908-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX908-NEXT:    v_not_b32_e32 v4, v4
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX908-NEXT:    s_movk_i32 s6, 0x7fff
; GFX908-NEXT:  .LBB48_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v6, v5
; GFX908-NEXT:    v_lshrrev_b32_sdwa v5, v3, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX908-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX908-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX908-NEXT:    v_add3_u32 v7, v7, v5, s6
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX908-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc
; GFX908-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX908-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX908-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v6
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB48_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_ret_bf16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0xfffff800, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX8-NEXT:    flat_load_dword v5, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX8-NEXT:    v_not_b32_e32 v4, v4
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX8-NEXT:  .LBB48_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v6, v5
; GFX8-NEXT:    v_lshrrev_b32_sdwa v5, v3, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX8-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, v8, v5
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, 0x7fff, v8
; GFX8-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v8, v9, vcc
; GFX8-NEXT:    v_and_b32_e32 v7, v6, v4
; GFX8-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v5, v7, v5
; GFX8-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v6
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB48_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_ret_bf16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v3, vcc, 0xfffff800, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX7-NEXT:    flat_load_dword v5, v[0:1]
; GFX7-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX7-NEXT:    v_lshl_b32_e32 v4, 0xffff, v3
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_not_b32_e32 v4, v4
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:  .LBB48_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v6, v5
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX7-NEXT:    v_and_b32_e32 v7, v6, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX7-NEXT:    v_or_b32_e32 v5, v7, v5
; GFX7-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v6
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB48_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr bfloat, ptr %ptr, i64 -1024
  %result = atomicrmw fadd ptr %gep, bfloat %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret bfloat %result
 }

define void @flat_agent_atomic_fadd_noret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory(ptr %ptr, bfloat %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_co_u32 v4, vcc_lo, 0x7fe, v0
; GFX12-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX12-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX12-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    flat_load_b32 v3, v[0:1]
; GFX12-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX12-NEXT:    v_lshlrev_b32_e64 v5, v4, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v5, v5
; GFX12-NEXT:  .LBB49_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    v_lshrrev_b32_e32 v2, v4, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX12-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX12-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX12-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX12-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX12-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc_lo
; GFX12-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v2, v4, v2
; GFX12-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_cmpswap_b32 v2, v[0:1], v[2:3] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX12-NEXT:    v_mov_b32_e32 v3, v2
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB49_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_mov_b64 s[0:1], 0x7fe
; GFX940-NEXT:    v_lshl_add_u64 v[4:5], v[0:1], 0, s[0:1]
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX940-NEXT:    v_mov_b32_e32 v1, v5
; GFX940-NEXT:    flat_load_dword v3, v[0:1]
; GFX940-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX940-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v5, v4, s0
; GFX940-NEXT:    v_not_b32_e32 v5, v5
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX940-NEXT:    s_movk_i32 s2, 0x7fff
; GFX940-NEXT:  .LBB49_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_lshrrev_b32_sdwa v2, v4, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX940-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX940-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX940-NEXT:    v_add3_u32 v7, v7, v2, s2
; GFX940-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc
; GFX940-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX940-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    v_mov_b32_e32 v3, v2
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB49_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, 0x7fe, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX11-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX11-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    flat_load_b32 v3, v[0:1]
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX11-NEXT:    v_lshlrev_b32_e64 v5, v4, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v5, v5
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB49_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, v4, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc_lo
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, v4, v2
; GFX11-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v2, v[0:1], v[2:3] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX11-NEXT:    v_mov_b32_e32 v3, v2
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB49_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v4, vcc_lo, 0x7fe, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX10-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v3, v[0:1]
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX10-NEXT:    v_lshlrev_b32_e64 v5, v4, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v5, v5
; GFX10-NEXT:  .LBB49_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_sdwa v2, v4, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX10-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX10-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX10-NEXT:    v_mov_b32_e32 v3, v2
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB49_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v4, vcc, 0x7fe, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX90A-NEXT:    flat_load_dword v3, v[0:1]
; GFX90A-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v5, v4, s4
; GFX90A-NEXT:    v_not_b32_e32 v5, v5
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX90A-NEXT:    s_movk_i32 s6, 0x7fff
; GFX90A-NEXT:  .LBB49_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_lshrrev_b32_sdwa v2, v4, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX90A-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX90A-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX90A-NEXT:    v_add3_u32 v7, v7, v2, s6
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX90A-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc
; GFX90A-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX90A-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX90A-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB49_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v4, vcc, 0x7fe, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX908-NEXT:    flat_load_dword v3, v[0:1]
; GFX908-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v5, v4, s4
; GFX908-NEXT:    v_not_b32_e32 v5, v5
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX908-NEXT:    s_movk_i32 s6, 0x7fff
; GFX908-NEXT:  .LBB49_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_lshrrev_b32_sdwa v2, v4, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX908-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX908-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX908-NEXT:    v_add3_u32 v7, v7, v2, s6
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX908-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc
; GFX908-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX908-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX908-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v3, v2
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB49_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, 0x7fe, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v5, v4, s4
; GFX8-NEXT:    v_not_b32_e32 v5, v5
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX8-NEXT:  .LBB49_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_sdwa v2, v4, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX8-NEXT:    v_bfe_u32 v8, v2, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, v8, v2
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, 0x7fff, v8
; GFX8-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v8, v9, vcc
; GFX8-NEXT:    v_and_b32_e32 v7, v3, v5
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v2, v7, v2
; GFX8-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v3, v2
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB49_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 0x7fe, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX7-NEXT:    flat_load_dword v3, v[0:1]
; GFX7-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX7-NEXT:    v_lshl_b32_e32 v5, 0xffff, v4
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_not_b32_e32 v5, v5
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v2
; GFX7-NEXT:  .LBB49_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, v4, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_and_b32_e32 v7, v3, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v4, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v7, v2
; GFX7-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v3, v2
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB49_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr bfloat, ptr %ptr, i64 1023
  %unused = atomicrmw fadd ptr %gep, bfloat %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret void
}

define void @flat_agent_atomic_fadd_noret_bf16__offset12b_neg__amdgpu_no_fine_grained_memory(ptr %ptr, bfloat %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_bf16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_co_u32 v4, vcc_lo, 0xfffff800, v0
; GFX12-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX12-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX12-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    flat_load_b32 v3, v[0:1]
; GFX12-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX12-NEXT:    v_lshlrev_b32_e64 v5, v4, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v5, v5
; GFX12-NEXT:  .LBB50_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    v_lshrrev_b32_e32 v2, v4, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX12-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX12-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX12-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX12-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX12-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc_lo
; GFX12-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v2, v4, v2
; GFX12-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_cmpswap_b32 v2, v[0:1], v[2:3] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX12-NEXT:    v_mov_b32_e32 v3, v2
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB50_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_bf16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_movk_i32 s0, 0xf800
; GFX940-NEXT:    s_mov_b32 s1, -1
; GFX940-NEXT:    v_lshl_add_u64 v[4:5], v[0:1], 0, s[0:1]
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX940-NEXT:    v_mov_b32_e32 v1, v5
; GFX940-NEXT:    flat_load_dword v3, v[0:1]
; GFX940-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX940-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v5, v4, s0
; GFX940-NEXT:    v_not_b32_e32 v5, v5
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX940-NEXT:    s_movk_i32 s2, 0x7fff
; GFX940-NEXT:  .LBB50_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_lshrrev_b32_sdwa v2, v4, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX940-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX940-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX940-NEXT:    v_add3_u32 v7, v7, v2, s2
; GFX940-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc
; GFX940-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX940-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    v_mov_b32_e32 v3, v2
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB50_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_bf16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, 0xfffff800, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX11-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX11-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    flat_load_b32 v3, v[0:1]
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX11-NEXT:    v_lshlrev_b32_e64 v5, v4, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v5, v5
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB50_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, v4, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc_lo
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, v4, v2
; GFX11-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v2, v[0:1], v[2:3] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX11-NEXT:    v_mov_b32_e32 v3, v2
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB50_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_bf16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v4, vcc_lo, 0xfffff800, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX10-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v3, v[0:1]
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX10-NEXT:    v_lshlrev_b32_e64 v5, v4, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v5, v5
; GFX10-NEXT:  .LBB50_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_sdwa v2, v4, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX10-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX10-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX10-NEXT:    v_mov_b32_e32 v3, v2
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB50_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_bf16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v4, vcc, 0xfffff800, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX90A-NEXT:    flat_load_dword v3, v[0:1]
; GFX90A-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v5, v4, s4
; GFX90A-NEXT:    v_not_b32_e32 v5, v5
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX90A-NEXT:    s_movk_i32 s6, 0x7fff
; GFX90A-NEXT:  .LBB50_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_lshrrev_b32_sdwa v2, v4, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX90A-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX90A-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX90A-NEXT:    v_add3_u32 v7, v7, v2, s6
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX90A-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc
; GFX90A-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX90A-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX90A-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB50_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_bf16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v4, vcc, 0xfffff800, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX908-NEXT:    flat_load_dword v3, v[0:1]
; GFX908-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v5, v4, s4
; GFX908-NEXT:    v_not_b32_e32 v5, v5
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX908-NEXT:    s_movk_i32 s6, 0x7fff
; GFX908-NEXT:  .LBB50_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_lshrrev_b32_sdwa v2, v4, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX908-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX908-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX908-NEXT:    v_add3_u32 v7, v7, v2, s6
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX908-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc
; GFX908-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX908-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX908-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v3, v2
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB50_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_bf16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, 0xfffff800, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v5, v4, s4
; GFX8-NEXT:    v_not_b32_e32 v5, v5
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX8-NEXT:  .LBB50_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_sdwa v2, v4, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX8-NEXT:    v_bfe_u32 v8, v2, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, v8, v2
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, 0x7fff, v8
; GFX8-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v8, v9, vcc
; GFX8-NEXT:    v_and_b32_e32 v7, v3, v5
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v2, v7, v2
; GFX8-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v3, v2
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB50_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_bf16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 0xfffff800, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX7-NEXT:    flat_load_dword v3, v[0:1]
; GFX7-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX7-NEXT:    v_lshl_b32_e32 v5, 0xffff, v4
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_not_b32_e32 v5, v5
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v2
; GFX7-NEXT:  .LBB50_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, v4, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_and_b32_e32 v7, v3, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v4, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v7, v2
; GFX7-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v3, v2
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB50_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr bfloat, ptr %ptr, i64 -1024
  %unused = atomicrmw fadd ptr %gep, bfloat %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret void
}

define bfloat @flat_agent_atomic_fadd_ret_bf16__offset12b_pos__align4__amdgpu_no_fine_grained_memory(ptr %ptr, bfloat %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_ret_bf16__offset12b_pos__align4__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    flat_load_b32 v3, v[0:1] offset:2046
; GFX12-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:  .LBB51_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v4, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; GFX12-NEXT:    v_add_f32_e32 v3, v3, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX12-NEXT:    v_bfe_u32 v5, v3, 16, 1
; GFX12-NEXT:    v_or_b32_e32 v6, 0x400000, v3
; GFX12-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX12-NEXT:    v_add3_u32 v5, v5, v3, 0x7fff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_cndmask_b32_e32 v3, v5, v6, vcc_lo
; GFX12-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v3, 0xffff0000, v4, v3
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[3:4] offset:2046 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB51_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    v_mov_b32_e32 v0, v3
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_ret_bf16__offset12b_pos__align4__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    flat_load_dword v3, v[0:1] offset:2046
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX940-NEXT:    s_movk_i32 s2, 0x7fff
; GFX940-NEXT:    s_mov_b32 s3, 0xffff0000
; GFX940-NEXT:  .LBB51_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v5, v3
; GFX940-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; GFX940-NEXT:    v_add_f32_e32 v3, v3, v2
; GFX940-NEXT:    v_bfe_u32 v4, v3, 16, 1
; GFX940-NEXT:    v_or_b32_e32 v6, 0x400000, v3
; GFX940-NEXT:    v_add3_u32 v4, v4, v3, s2
; GFX940-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v3, v4, v6, vcc
; GFX940-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX940-NEXT:    v_and_or_b32 v4, v5, s3, v3
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[4:5] offset:2046 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB51_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    v_mov_b32_e32 v0, v3
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_ret_bf16__offset12b_pos__align4__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_b32 v3, v[0:1] offset:2046
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB51_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; GFX11-NEXT:    v_add_f32_e32 v3, v3, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_bfe_u32 v5, v3, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v6, 0x400000, v3
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-NEXT:    v_add3_u32 v5, v5, v3, 0x7fff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v3, v5, v6, vcc_lo
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v3, 0xffff0000, v4, v3
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[3:4] offset:2046 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB51_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_ret_bf16__offset12b_pos__align4__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v4, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v0, v[3:4]
; GFX10-NEXT:  .LBB51_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v6, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; GFX10-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX10-NEXT:    v_add3_u32 v2, v2, v0, 0x7fff
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v2, v5, vcc_lo
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX10-NEXT:    v_and_or_b32 v5, 0xffff0000, v6, v0
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[5:6] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v6
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB51_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_ret_bf16__offset12b_pos__align4__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    flat_load_dword v3, v[0:1] offset:2046
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX90A-NEXT:    s_movk_i32 s6, 0x7fff
; GFX90A-NEXT:    s_mov_b32 s7, 0xffff0000
; GFX90A-NEXT:  .LBB51_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; GFX90A-NEXT:    v_add_f32_e32 v3, v3, v2
; GFX90A-NEXT:    v_bfe_u32 v4, v3, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v6, 0x400000, v3
; GFX90A-NEXT:    v_add3_u32 v4, v4, v3, s6
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX90A-NEXT:    v_cndmask_b32_e32 v3, v4, v6, vcc
; GFX90A-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX90A-NEXT:    v_and_or_b32 v4, v5, s7, v3
; GFX90A-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[4:5] offset:2046 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB51_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_ret_bf16__offset12b_pos__align4__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v3, v[0:1] offset:2046
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX908-NEXT:    s_movk_i32 s6, 0x7fff
; GFX908-NEXT:    s_mov_b32 s7, 0xffff0000
; GFX908-NEXT:  .LBB51_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; GFX908-NEXT:    v_add_f32_e32 v3, v3, v2
; GFX908-NEXT:    v_bfe_u32 v5, v3, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v6, 0x400000, v3
; GFX908-NEXT:    v_add3_u32 v5, v5, v3, s6
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX908-NEXT:    v_cndmask_b32_e32 v3, v5, v6, vcc
; GFX908-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX908-NEXT:    v_and_or_b32 v3, v4, s7, v3
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] offset:2046 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB51_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_ret_bf16__offset12b_pos__align4__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fe, v0
; GFX8-NEXT:    v_addc_u32_e32 v4, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[3:4]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX8-NEXT:  .LBB51_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v6, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; GFX8-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_bfe_u32 v5, v0, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v5, vcc, v5, v0
; GFX8-NEXT:    v_add_u32_e32 v5, vcc, 0x7fff, v5
; GFX8-NEXT:    v_or_b32_e32 v7, 0x400000, v0
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX8-NEXT:    v_and_b32_e32 v2, 0xffff0000, v6
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v5, v7, vcc
; GFX8-NEXT:    v_or_b32_sdwa v5, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[5:6] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v6
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB51_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_ret_bf16__offset12b_pos__align4__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, 0x7fe, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    flat_load_dword v3, v[0:1]
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:  .LBB51_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v4, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; GFX7-NEXT:    v_add_f32_e32 v3, v3, v2
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff0000, v4
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_or_b32_e32 v3, v5, v3
; GFX7-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB51_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr bfloat, ptr %ptr, i64 1023
  %result = atomicrmw fadd ptr %gep, bfloat %val syncscope("agent") seq_cst, align 4, !amdgpu.no.fine.grained.memory !0
  ret bfloat %result
}

define void @flat_agent_atomic_fadd_noret_bf16__offset12b__align4_pos__amdgpu_no_fine_grained_memory(ptr %ptr, bfloat %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_bf16__offset12b__align4_pos__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    flat_load_b32 v3, v[0:1] offset:2046
; GFX12-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:  .LBB52_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX12-NEXT:    v_bfe_u32 v5, v2, 16, 1
; GFX12-NEXT:    v_or_b32_e32 v6, 0x400000, v2
; GFX12-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add3_u32 v5, v5, v2, 0x7fff
; GFX12-NEXT:    v_cndmask_b32_e32 v2, v5, v6, vcc_lo
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX12-NEXT:    v_and_or_b32 v2, 0xffff0000, v3, v2
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_cmpswap_b32 v2, v[0:1], v[2:3] offset:2046 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX12-NEXT:    v_mov_b32_e32 v3, v2
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB52_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_bf16__offset12b__align4_pos__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    flat_load_dword v3, v[0:1] offset:2046
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX940-NEXT:    s_movk_i32 s2, 0x7fff
; GFX940-NEXT:    s_mov_b32 s3, 0xffff0000
; GFX940-NEXT:  .LBB52_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX940-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX940-NEXT:    v_bfe_u32 v5, v2, 16, 1
; GFX940-NEXT:    v_or_b32_e32 v6, 0x400000, v2
; GFX940-NEXT:    v_add3_u32 v5, v5, v2, s2
; GFX940-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v2, v5, v6, vcc
; GFX940-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX940-NEXT:    v_and_or_b32 v2, v3, s3, v2
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] offset:2046 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    v_mov_b32_e32 v3, v2
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB52_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_bf16__offset12b__align4_pos__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_b32 v3, v[0:1] offset:2046
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB52_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX11-NEXT:    v_bfe_u32 v5, v2, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v6, 0x400000, v2
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add3_u32 v5, v5, v2, 0x7fff
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v5, v6, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    v_and_or_b32 v2, 0xffff0000, v3, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v2, v[0:1], v[2:3] offset:2046 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX11-NEXT:    v_mov_b32_e32 v3, v2
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB52_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_bf16__offset12b__align4_pos__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0x7fe, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v3, v[0:1]
; GFX10-NEXT:  .LBB52_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX10-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX10-NEXT:    v_bfe_u32 v5, v2, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v6, 0x400000, v2
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX10-NEXT:    v_add3_u32 v5, v5, v2, 0x7fff
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v5, v6, vcc_lo
; GFX10-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX10-NEXT:    v_and_or_b32 v2, 0xffff0000, v3, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX10-NEXT:    v_mov_b32_e32 v3, v2
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB52_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_bf16__offset12b__align4_pos__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    flat_load_dword v3, v[0:1] offset:2046
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX90A-NEXT:    s_movk_i32 s6, 0x7fff
; GFX90A-NEXT:    s_mov_b32 s7, 0xffff0000
; GFX90A-NEXT:  .LBB52_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX90A-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX90A-NEXT:    v_bfe_u32 v5, v2, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v6, 0x400000, v2
; GFX90A-NEXT:    v_add3_u32 v5, v5, v2, s6
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX90A-NEXT:    v_cndmask_b32_e32 v2, v5, v6, vcc
; GFX90A-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX90A-NEXT:    v_and_or_b32 v2, v3, s7, v2
; GFX90A-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] offset:2046 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB52_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_bf16__offset12b__align4_pos__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v3, v[0:1] offset:2046
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX908-NEXT:    s_movk_i32 s6, 0x7fff
; GFX908-NEXT:    s_mov_b32 s7, 0xffff0000
; GFX908-NEXT:  .LBB52_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX908-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX908-NEXT:    v_bfe_u32 v5, v2, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v6, 0x400000, v2
; GFX908-NEXT:    v_add3_u32 v5, v5, v2, s6
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX908-NEXT:    v_cndmask_b32_e32 v2, v5, v6, vcc
; GFX908-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX908-NEXT:    v_and_or_b32 v2, v3, s7, v2
; GFX908-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] offset:2046 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v3, v2
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB52_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_bf16__offset12b__align4_pos__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0x7fe, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX8-NEXT:  .LBB52_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX8-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX8-NEXT:    v_bfe_u32 v6, v2, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v6, vcc, v6, v2
; GFX8-NEXT:    v_add_u32_e32 v6, vcc, 0x7fff, v6
; GFX8-NEXT:    v_or_b32_e32 v7, 0x400000, v2
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v6, v7, vcc
; GFX8-NEXT:    v_or_b32_sdwa v2, v5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v3, v2
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB52_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_bf16__offset12b__align4_pos__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, 0x7fe, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    flat_load_dword v3, v[0:1]
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v2
; GFX7-NEXT:  .LBB52_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX7-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff0000, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v5, v2
; GFX7-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v3, v2
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB52_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr bfloat, ptr %ptr, i64 1023
  %unused = atomicrmw fadd ptr %gep, bfloat %val syncscope("agent") seq_cst, align 4, !amdgpu.no.fine.grained.memory !0
  ret void
}

define void @flat_agent_atomic_fadd_noret_bf16__amdgpu_no_fine_grained_memory(ptr %ptr, bfloat %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_bf16__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v3, v0 :: v_dual_lshlrev_b32 v2, 16, v2
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX12-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX12-NEXT:    flat_load_b32 v4, v[0:1]
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX12-NEXT:    v_lshlrev_b32_e64 v3, v5, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v6, v3
; GFX12-NEXT:  .LBB53_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX12-NEXT:    v_add_f32_e32 v3, v3, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX12-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX12-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX12-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX12-NEXT:    v_add3_u32 v7, v7, v3, 0x7fff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_cndmask_b32_e32 v3, v7, v8, vcc_lo
; GFX12-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX12-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[3:4] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX12-NEXT:    v_mov_b32_e32 v4, v3
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB53_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_bf16__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v3, v0
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX940-NEXT:    flat_load_dword v5, v[0:1]
; GFX940-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX940-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v4, v3, s0
; GFX940-NEXT:    v_not_b32_e32 v6, v4
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX940-NEXT:    s_movk_i32 s2, 0x7fff
; GFX940-NEXT:  .LBB53_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_lshrrev_b32_sdwa v4, v3, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_add_f32_e32 v4, v4, v2
; GFX940-NEXT:    v_bfe_u32 v7, v4, 16, 1
; GFX940-NEXT:    v_or_b32_e32 v8, 0x400000, v4
; GFX940-NEXT:    v_add3_u32 v7, v7, v4, s2
; GFX940-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v4, v7, v8, vcc
; GFX940-NEXT:    v_lshlrev_b32_sdwa v4, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX940-NEXT:    v_and_or_b32 v4, v5, v6, v4
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_cmpswap v4, v[0:1], v[4:5] sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v5
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    v_mov_b32_e32 v5, v4
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB53_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_bf16__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v3, v0 :: v_dual_lshlrev_b32 v2, 16, v2
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX11-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX11-NEXT:    flat_load_b32 v4, v[0:1]
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX11-NEXT:    v_lshlrev_b32_e64 v3, v5, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v6, v3
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB53_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    v_add_f32_e32 v3, v3, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-NEXT:    v_add3_u32 v7, v7, v3, 0x7fff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v3, v7, v8, vcc_lo
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX11-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[3:4] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB53_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_bf16__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v3, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX10-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX10-NEXT:    flat_load_dword v4, v[0:1]
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX10-NEXT:    v_lshlrev_b32_e64 v3, v5, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v6, v3
; GFX10-NEXT:  .LBB53_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_sdwa v3, v5, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_add_f32_e32 v3, v3, v2
; GFX10-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX10-NEXT:    v_add3_u32 v7, v7, v3, 0x7fff
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v7, v8, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, v5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB53_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_bf16__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v3, v0
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX90A-NEXT:    flat_load_dword v5, v[0:1]
; GFX90A-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX90A-NEXT:    v_not_b32_e32 v6, v4
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX90A-NEXT:    s_movk_i32 s6, 0x7fff
; GFX90A-NEXT:  .LBB53_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_lshrrev_b32_sdwa v4, v3, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX90A-NEXT:    v_add_f32_e32 v4, v4, v2
; GFX90A-NEXT:    v_bfe_u32 v7, v4, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v4
; GFX90A-NEXT:    v_add3_u32 v7, v7, v4, s6
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX90A-NEXT:    v_cndmask_b32_e32 v4, v7, v8, vcc
; GFX90A-NEXT:    v_lshlrev_b32_sdwa v4, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX90A-NEXT:    v_and_or_b32 v4, v5, v6, v4
; GFX90A-NEXT:    flat_atomic_cmpswap v4, v[0:1], v[4:5] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v5, v4
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB53_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_bf16__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v3, v0
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX908-NEXT:    flat_load_dword v4, v[0:1]
; GFX908-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v3, v5, s4
; GFX908-NEXT:    v_not_b32_e32 v6, v3
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX908-NEXT:    s_movk_i32 s6, 0x7fff
; GFX908-NEXT:  .LBB53_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_lshrrev_b32_sdwa v3, v5, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX908-NEXT:    v_add_f32_e32 v3, v3, v2
; GFX908-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX908-NEXT:    v_add3_u32 v7, v7, v3, s6
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX908-NEXT:    v_cndmask_b32_e32 v3, v7, v8, vcc
; GFX908-NEXT:    v_lshlrev_b32_sdwa v3, v5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX908-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB53_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_bf16__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v3, v0
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v3, v5, s4
; GFX8-NEXT:    v_not_b32_e32 v6, v3
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX8-NEXT:  .LBB53_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_sdwa v3, v5, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_add_f32_e32 v3, v3, v2
; GFX8-NEXT:    v_bfe_u32 v8, v3, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, v8, v3
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, 0x7fff, v8
; GFX8-NEXT:    v_or_b32_e32 v9, 0x400000, v3
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v8, v9, vcc
; GFX8-NEXT:    v_and_b32_e32 v7, v4, v6
; GFX8-NEXT:    v_lshlrev_b32_sdwa v3, v5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v3, v7, v3
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB53_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_bf16__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v3, v0
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX7-NEXT:    flat_load_dword v4, v[0:1]
; GFX7-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX7-NEXT:    v_lshl_b32_e32 v3, 0xffff, v5
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_not_b32_e32 v6, v3
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:  .LBB53_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_add_f32_e32 v3, v3, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_and_b32_e32 v7, v4, v6
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX7-NEXT:    v_or_b32_e32 v3, v7, v3
; GFX7-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v4, v3
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB53_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %unused = atomicrmw fadd ptr %ptr, bfloat %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret void
}

define bfloat @flat_system_atomic_fadd_ret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory(ptr %ptr, bfloat %val) #0 {
; GFX12-LABEL: flat_system_atomic_fadd_ret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX12-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX12-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX12-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    flat_load_b32 v5, v[0:1]
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX12-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v4, v4
; GFX12-NEXT:  .LBB54_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v6, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX12-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX12-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX12-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX12-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc_lo
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_cmpswap_b32 v5, v[0:1], v[5:6] th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB54_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_system_atomic_fadd_ret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_mov_b64 s[0:1], 0x7fe
; GFX940-NEXT:    v_lshl_add_u64 v[4:5], v[0:1], 0, s[0:1]
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX940-NEXT:    v_mov_b32_e32 v1, v5
; GFX940-NEXT:    flat_load_dword v5, v[0:1]
; GFX940-NEXT:    v_and_b32_e32 v3, 3, v4
; GFX940-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v4, v3, s0
; GFX940-NEXT:    v_not_b32_e32 v4, v4
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX940-NEXT:    s_movk_i32 s2, 0x7fff
; GFX940-NEXT:  .LBB54_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v7, v5
; GFX940-NEXT:    v_lshrrev_b32_sdwa v5, v3, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX940-NEXT:    v_bfe_u32 v6, v5, 16, 1
; GFX940-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX940-NEXT:    v_add3_u32 v6, v6, v5, s2
; GFX940-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v5, v6, v8, vcc
; GFX940-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX940-NEXT:    v_and_or_b32 v6, v7, v4, v5
; GFX940-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[6:7] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc0 sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v7
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB54_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_system_atomic_fadd_ret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX11-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    flat_load_b32 v5, v[0:1]
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX11-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v4, v4
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB54_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v6, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX11-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX11-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v5, v[0:1], v[5:6] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB54_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_system_atomic_fadd_ret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX10-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v5, v[0:1]
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX10-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v4, v4
; GFX10-NEXT:  .LBB54_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v6, v5
; GFX10-NEXT:    v_lshrrev_b32_sdwa v5, v3, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX10-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX10-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB54_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_system_atomic_fadd_ret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v3, vcc, 0x7fe, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX90A-NEXT:    flat_load_dword v5, v[0:1]
; GFX90A-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX90A-NEXT:    v_not_b32_e32 v4, v4
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX90A-NEXT:    s_movk_i32 s6, 0x7fff
; GFX90A-NEXT:  .LBB54_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, v5
; GFX90A-NEXT:    v_lshrrev_b32_sdwa v5, v3, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX90A-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX90A-NEXT:    v_bfe_u32 v6, v5, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX90A-NEXT:    v_add3_u32 v6, v6, v5, s6
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX90A-NEXT:    v_cndmask_b32_e32 v5, v6, v8, vcc
; GFX90A-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX90A-NEXT:    v_and_or_b32 v6, v7, v4, v5
; GFX90A-NEXT:    buffer_wbl2
; GFX90A-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[6:7] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_invl2
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v7
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB54_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_system_atomic_fadd_ret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v3, vcc, 0x7fe, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX908-NEXT:    flat_load_dword v5, v[0:1]
; GFX908-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX908-NEXT:    v_not_b32_e32 v4, v4
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX908-NEXT:    s_movk_i32 s6, 0x7fff
; GFX908-NEXT:  .LBB54_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v6, v5
; GFX908-NEXT:    v_lshrrev_b32_sdwa v5, v3, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX908-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX908-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX908-NEXT:    v_add3_u32 v7, v7, v5, s6
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX908-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc
; GFX908-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX908-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX908-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v6
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB54_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_system_atomic_fadd_ret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fe, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX8-NEXT:    flat_load_dword v5, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX8-NEXT:    v_not_b32_e32 v4, v4
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX8-NEXT:  .LBB54_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v6, v5
; GFX8-NEXT:    v_lshrrev_b32_sdwa v5, v3, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX8-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, v8, v5
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, 0x7fff, v8
; GFX8-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v8, v9, vcc
; GFX8-NEXT:    v_and_b32_e32 v7, v6, v4
; GFX8-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v5, v7, v5
; GFX8-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v6
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB54_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_system_atomic_fadd_ret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v3, vcc, 0x7fe, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX7-NEXT:    flat_load_dword v5, v[0:1]
; GFX7-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX7-NEXT:    v_lshl_b32_e32 v4, 0xffff, v3
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_not_b32_e32 v4, v4
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:  .LBB54_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v6, v5
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX7-NEXT:    v_and_b32_e32 v7, v6, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX7-NEXT:    v_or_b32_e32 v5, v7, v5
; GFX7-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v6
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB54_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr bfloat, ptr %ptr, i64 1023
  %result = atomicrmw fadd ptr %gep, bfloat %val seq_cst, !amdgpu.no.fine.grained.memory !0
  ret bfloat %result
}

define void @flat_system_atomic_fadd_noret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory(ptr %ptr, bfloat %val) #0 {
; GFX12-LABEL: flat_system_atomic_fadd_noret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_co_u32 v4, vcc_lo, 0x7fe, v0
; GFX12-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX12-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX12-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    flat_load_b32 v3, v[0:1]
; GFX12-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX12-NEXT:    v_lshlrev_b32_e64 v5, v4, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v5, v5
; GFX12-NEXT:  .LBB55_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    v_lshrrev_b32_e32 v2, v4, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX12-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX12-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX12-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX12-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX12-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc_lo
; GFX12-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v2, v4, v2
; GFX12-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_cmpswap_b32 v2, v[0:1], v[2:3] th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX12-NEXT:    v_mov_b32_e32 v3, v2
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB55_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_system_atomic_fadd_noret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_mov_b64 s[0:1], 0x7fe
; GFX940-NEXT:    v_lshl_add_u64 v[4:5], v[0:1], 0, s[0:1]
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX940-NEXT:    v_mov_b32_e32 v1, v5
; GFX940-NEXT:    flat_load_dword v3, v[0:1]
; GFX940-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX940-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v5, v4, s0
; GFX940-NEXT:    v_not_b32_e32 v5, v5
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX940-NEXT:    s_movk_i32 s2, 0x7fff
; GFX940-NEXT:  .LBB55_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_lshrrev_b32_sdwa v2, v4, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX940-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX940-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX940-NEXT:    v_add3_u32 v7, v7, v2, s2
; GFX940-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc
; GFX940-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX940-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX940-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc0 sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    v_mov_b32_e32 v3, v2
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB55_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_system_atomic_fadd_noret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, 0x7fe, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX11-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX11-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    flat_load_b32 v3, v[0:1]
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX11-NEXT:    v_lshlrev_b32_e64 v5, v4, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v5, v5
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB55_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, v4, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc_lo
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, v4, v2
; GFX11-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v2, v[0:1], v[2:3] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX11-NEXT:    v_mov_b32_e32 v3, v2
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB55_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_system_atomic_fadd_noret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v4, vcc_lo, 0x7fe, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX10-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v3, v[0:1]
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX10-NEXT:    v_lshlrev_b32_e64 v5, v4, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v5, v5
; GFX10-NEXT:  .LBB55_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_sdwa v2, v4, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX10-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX10-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX10-NEXT:    v_mov_b32_e32 v3, v2
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB55_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_system_atomic_fadd_noret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v4, vcc, 0x7fe, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX90A-NEXT:    flat_load_dword v3, v[0:1]
; GFX90A-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v5, v4, s4
; GFX90A-NEXT:    v_not_b32_e32 v5, v5
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX90A-NEXT:    s_movk_i32 s6, 0x7fff
; GFX90A-NEXT:  .LBB55_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_lshrrev_b32_sdwa v2, v4, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX90A-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX90A-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX90A-NEXT:    v_add3_u32 v7, v7, v2, s6
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX90A-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc
; GFX90A-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX90A-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX90A-NEXT:    buffer_wbl2
; GFX90A-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_invl2
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB55_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_system_atomic_fadd_noret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v4, vcc, 0x7fe, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX908-NEXT:    flat_load_dword v3, v[0:1]
; GFX908-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v5, v4, s4
; GFX908-NEXT:    v_not_b32_e32 v5, v5
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX908-NEXT:    s_movk_i32 s6, 0x7fff
; GFX908-NEXT:  .LBB55_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_lshrrev_b32_sdwa v2, v4, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX908-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX908-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX908-NEXT:    v_add3_u32 v7, v7, v2, s6
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX908-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc
; GFX908-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX908-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX908-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v3, v2
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB55_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_system_atomic_fadd_noret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, 0x7fe, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v5, v4, s4
; GFX8-NEXT:    v_not_b32_e32 v5, v5
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX8-NEXT:  .LBB55_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_sdwa v2, v4, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX8-NEXT:    v_bfe_u32 v8, v2, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, v8, v2
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, 0x7fff, v8
; GFX8-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v8, v9, vcc
; GFX8-NEXT:    v_and_b32_e32 v7, v3, v5
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v2, v7, v2
; GFX8-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v3, v2
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB55_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_system_atomic_fadd_noret_bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 0x7fe, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX7-NEXT:    flat_load_dword v3, v[0:1]
; GFX7-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX7-NEXT:    v_lshl_b32_e32 v5, 0xffff, v4
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_not_b32_e32 v5, v5
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v2
; GFX7-NEXT:  .LBB55_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, v4, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_and_b32_e32 v7, v3, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v4, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v7, v2
; GFX7-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v3, v2
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB55_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr bfloat, ptr %ptr, i64 1023
  %unused = atomicrmw fadd ptr %gep, bfloat %val seq_cst, !amdgpu.no.fine.grained.memory !0
  ret void
}

; --------------------------------------------------------------------
; <2 x half>
; --------------------------------------------------------------------

define <2 x half> @flat_agent_atomic_fadd_ret_v2f16__amdgpu_no_fine_grained_memory(ptr %ptr, <2 x half> %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_ret_v2f16__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_pk_add_f16 v0, v[0:1], v2 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_ret_v2f16__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_pk_add_f16 v0, v[0:1], v2 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_ret_v2f16__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_b32 v3, v[0:1]
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB56_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[3:4] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB56_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_ret_v2f16__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_load_dword v3, v[0:1]
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB56_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB56_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_ret_v2f16__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    flat_load_dword v3, v[0:1]
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB56_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    v_pk_add_f16 v4, v5, v2
; GFX90A-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[4:5] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB56_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_ret_v2f16__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v3, v[0:1]
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB56_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB56_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_ret_v2f16__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB56_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 16, v4
; GFX8-NEXT:    v_add_f16_sdwa v3, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_add_f16_e32 v5, v4, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX8-NEXT:    v_or_b32_e32 v3, v5, v3
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB56_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v0, v3
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_ret_v2f16__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    flat_load_dword v5, v[0:1]
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v2
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v6
; GFX7-NEXT:  .LBB56_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v4
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v8, v7
; GFX7-NEXT:    v_or_b32_e32 v7, v2, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v6
; GFX7-NEXT:    v_or_b32_e32 v6, v8, v2
; GFX7-NEXT:    flat_atomic_cmpswap v6, v[0:1], v[6:7] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v7
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB56_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v0, v2
; GFX7-NEXT:    v_mov_b32_e32 v1, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr %ptr, <2 x half> %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret <2 x half> %result
}

define <2 x half> @flat_agent_atomic_fadd_ret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory(ptr %ptr, <2 x half> %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_ret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_pk_add_f16 v0, v[0:1], v2 offset:2044 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_ret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_pk_add_f16 v0, v[0:1], v2 offset:2044 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_ret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_b32 v3, v[0:1] offset:2044
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB57_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[3:4] offset:2044 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB57_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_ret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fc, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v4, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v0, v[3:4]
; GFX10-NEXT:  .LBB57_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, v0
; GFX10-NEXT:    v_pk_add_f16 v0, v1, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB57_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_ret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    flat_load_dword v3, v[0:1] offset:2044
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB57_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    v_pk_add_f16 v4, v5, v2
; GFX90A-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[4:5] offset:2044 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB57_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_ret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v3, v[0:1] offset:2044
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB57_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] offset:2044 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB57_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_ret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v4, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[3:4]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB57_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 16, v1
; GFX8-NEXT:    v_add_f16_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_add_f16_e32 v5, v1, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX8-NEXT:    v_or_b32_e32 v0, v5, v0
; GFX8-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB57_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_ret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 0x7fc, v0
; GFX7-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; GFX7-NEXT:    flat_load_dword v1, v[4:5]
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v2
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:  .LBB57_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v8, v7
; GFX7-NEXT:    v_or_b32_e32 v7, v0, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; GFX7-NEXT:    v_or_b32_e32 v6, v8, v0
; GFX7-NEXT:    flat_atomic_cmpswap v6, v[4:5], v[6:7] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v7
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB57_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x half>, ptr %ptr, i64 511
  %result = atomicrmw fadd ptr %gep, <2 x half> %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret <2 x half> %result
}

define <2 x half> @flat_agent_atomic_fadd_ret_v2f16__offset12b_neg__amdgpu_no_fine_grained_memory(ptr %ptr, <2 x half> %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_ret_v2f16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_pk_add_f16 v0, v[0:1], v2 offset:-2048 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_ret_v2f16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff800, v0
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_pk_add_f16 v0, v[0:1], v2 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_ret_v2f16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v3, v0
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, 0xfffff800, v3
; GFX11-NEXT:    v_add_co_ci_u32_e32 v5, vcc_lo, -1, v1, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v3, vcc_lo, 0xfffff800, v3
; GFX11-NEXT:    flat_load_b32 v0, v[4:5]
; GFX11-NEXT:    v_add_co_ci_u32_e32 v4, vcc_lo, -1, v1, vcc_lo
; GFX11-NEXT:  .LBB58_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v1, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_pk_add_f16 v0, v1, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v0, v[3:4], v[0:1] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB58_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_ret_v2f16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v3, vcc_lo, 0xfffff800, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v4, vcc_lo, -1, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v0, v[3:4]
; GFX10-NEXT:  .LBB58_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, v0
; GFX10-NEXT:    v_pk_add_f16 v0, v1, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB58_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_ret_v2f16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v4, vcc, 0xfffff800, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v5, vcc, -1, v1, vcc
; GFX90A-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff800, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX90A-NEXT:    flat_load_dword v0, v[0:1]
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB58_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v1, v0
; GFX90A-NEXT:    v_pk_add_f16 v0, v1, v2
; GFX90A-NEXT:    flat_atomic_cmpswap v0, v[4:5], v[0:1] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB58_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_ret_v2f16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v3, vcc, 0xfffff800, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v4, vcc, -1, v1, vcc
; GFX908-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff800, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX908-NEXT:    flat_load_dword v0, v[0:1]
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB58_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v1, v0
; GFX908-NEXT:    v_pk_add_f16 v0, v1, v2
; GFX908-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB58_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_ret_v2f16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0xfffff800, v0
; GFX8-NEXT:    v_addc_u32_e32 v4, vcc, -1, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[3:4]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB58_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 16, v1
; GFX8-NEXT:    v_add_f16_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_add_f16_e32 v5, v1, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX8-NEXT:    v_or_b32_e32 v0, v5, v0
; GFX8-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB58_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_ret_v2f16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 0xfffff800, v0
; GFX7-NEXT:    v_addc_u32_e32 v5, vcc, -1, v1, vcc
; GFX7-NEXT:    flat_load_dword v1, v[4:5]
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v2
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:  .LBB58_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v8, v7
; GFX7-NEXT:    v_or_b32_e32 v7, v0, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; GFX7-NEXT:    v_or_b32_e32 v6, v8, v0
; GFX7-NEXT:    flat_atomic_cmpswap v6, v[4:5], v[6:7] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v7
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB58_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x half>, ptr %ptr, i64 -512
  %result = atomicrmw fadd ptr %gep, <2 x half> %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret <2 x half> %result
}

define void @flat_agent_atomic_fadd_noret_v2f16__amdgpu_no_fine_grained_memory(ptr %ptr, <2 x half> %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_v2f16__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_pk_add_f16 v[0:1], v2 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_v2f16__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_pk_add_f16 v[0:1], v2
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_v2f16__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_b32 v4, v[0:1]
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB59_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[3:4] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB59_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_v2f16__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_load_dword v4, v[0:1]
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB59_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB59_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_v2f16__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    flat_load_dword v5, v[0:1]
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB59_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_pk_add_f16 v4, v5, v2
; GFX90A-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[4:5] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB59_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_v2f16__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v4, v[0:1]
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB59_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB59_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_v2f16__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB59_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 16, v4
; GFX8-NEXT:    v_add_f16_sdwa v3, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_add_f16_e32 v5, v4, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX8-NEXT:    v_or_b32_e32 v3, v5, v3
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB59_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_v2f16__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    flat_load_dword v5, v[0:1]
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v2
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v6
; GFX7-NEXT:  .LBB59_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v8, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX7-NEXT:    v_or_b32_e32 v6, v4, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v8
; GFX7-NEXT:    v_or_b32_e32 v5, v7, v4
; GFX7-NEXT:    flat_atomic_cmpswap v7, v[0:1], v[5:6] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 16, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v6
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB59_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %unused = atomicrmw fadd ptr %ptr, <2 x half> %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret void
}

define void @flat_agent_atomic_fadd_noret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory(ptr %ptr, <2 x half> %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_pk_add_f16 v[0:1], v2 offset:2044 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_pk_add_f16 v[0:1], v2 offset:2044
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_b32 v4, v[0:1] offset:2044
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB60_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[3:4] offset:2044 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB60_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0x7fc, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v4, v[0:1]
; GFX10-NEXT:  .LBB60_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB60_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    flat_load_dword v5, v[0:1] offset:2044
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB60_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_pk_add_f16 v4, v5, v2
; GFX90A-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[4:5] offset:2044 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB60_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v4, v[0:1] offset:2044
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB60_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] offset:2044 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB60_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB60_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 16, v4
; GFX8-NEXT:    v_add_f16_sdwa v3, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_add_f16_e32 v5, v4, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX8-NEXT:    v_or_b32_e32 v3, v5, v3
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB60_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, 0x7fc, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    flat_load_dword v5, v[0:1]
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v2
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v6
; GFX7-NEXT:  .LBB60_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v8, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX7-NEXT:    v_or_b32_e32 v6, v4, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v8
; GFX7-NEXT:    v_or_b32_e32 v5, v7, v4
; GFX7-NEXT:    flat_atomic_cmpswap v7, v[0:1], v[5:6] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 16, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v6
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB60_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x half>, ptr %ptr, i64 511
  %unused = atomicrmw fadd ptr %gep, <2 x half> %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret void
}

define void @flat_agent_atomic_fadd_noret_v2f16__offset12b_neg__amdgpu_no_fine_grained_memory(ptr %ptr, <2 x half> %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_v2f16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_pk_add_f16 v[0:1], v2 offset:-2048 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_v2f16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff800, v0
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_pk_add_f16 v[0:1], v2
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_v2f16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v3, vcc_lo, 0xfffff800, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v4, vcc_lo, -1, v1, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, 0xfffff800, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX11-NEXT:    flat_load_b32 v4, v[3:4]
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB61_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[3:4] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB61_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_v2f16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0xfffff800, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v4, v[0:1]
; GFX10-NEXT:  .LBB61_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB61_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_v2f16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v4, vcc, 0xfffff800, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v5, vcc, -1, v1, vcc
; GFX90A-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff800, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX90A-NEXT:    flat_load_dword v1, v[0:1]
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB61_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_pk_add_f16 v0, v1, v2
; GFX90A-NEXT:    flat_atomic_cmpswap v0, v[4:5], v[0:1] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v1, v0
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB61_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_v2f16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v3, vcc, 0xfffff800, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v4, vcc, -1, v1, vcc
; GFX908-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff800, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX908-NEXT:    flat_load_dword v1, v[0:1]
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB61_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_pk_add_f16 v0, v1, v2
; GFX908-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v1, v0
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB61_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_v2f16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0xfffff800, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB61_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 16, v4
; GFX8-NEXT:    v_add_f16_sdwa v3, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_add_f16_e32 v5, v4, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX8-NEXT:    v_or_b32_e32 v3, v5, v3
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB61_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_v2f16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, 0xfffff800, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX7-NEXT:    flat_load_dword v5, v[0:1]
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v2
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v6
; GFX7-NEXT:  .LBB61_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v8, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX7-NEXT:    v_or_b32_e32 v6, v4, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v8
; GFX7-NEXT:    v_or_b32_e32 v5, v7, v4
; GFX7-NEXT:    flat_atomic_cmpswap v7, v[0:1], v[5:6] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 16, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v6
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB61_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x half>, ptr %ptr, i64 -512
  %unused = atomicrmw fadd ptr %gep, <2 x half> %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret void
}

define <2 x half> @flat_system_atomic_fadd_ret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory(ptr %ptr, <2 x half> %val) #0 {
; GFX12-LABEL: flat_system_atomic_fadd_ret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_pk_add_f16 v0, v[0:1], v2 offset:2044 th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_system_atomic_fadd_ret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-NEXT:    flat_atomic_pk_add_f16 v0, v[0:1], v2 offset:2044 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc0 sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_system_atomic_fadd_ret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_b32 v3, v[0:1] offset:2044
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB62_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[3:4] offset:2044 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB62_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_system_atomic_fadd_ret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fc, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v4, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v0, v[3:4]
; GFX10-NEXT:  .LBB62_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, v0
; GFX10-NEXT:    v_pk_add_f16 v0, v1, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB62_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_system_atomic_fadd_ret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    flat_load_dword v3, v[0:1] offset:2044
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB62_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    v_pk_add_f16 v4, v5, v2
; GFX90A-NEXT:    buffer_wbl2
; GFX90A-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[4:5] offset:2044 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_invl2
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB62_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_system_atomic_fadd_ret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v3, v[0:1] offset:2044
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB62_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] offset:2044 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB62_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_system_atomic_fadd_ret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v4, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[3:4]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB62_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 16, v1
; GFX8-NEXT:    v_add_f16_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_add_f16_e32 v5, v1, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX8-NEXT:    v_or_b32_e32 v0, v5, v0
; GFX8-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB62_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_system_atomic_fadd_ret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 0x7fc, v0
; GFX7-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; GFX7-NEXT:    flat_load_dword v1, v[4:5]
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v2
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:  .LBB62_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v8, v7
; GFX7-NEXT:    v_or_b32_e32 v7, v0, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; GFX7-NEXT:    v_or_b32_e32 v6, v8, v0
; GFX7-NEXT:    flat_atomic_cmpswap v6, v[4:5], v[6:7] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v7
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB62_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x half>, ptr %ptr, i64 511
  %result = atomicrmw fadd ptr %gep, <2 x half> %val seq_cst, !amdgpu.no.fine.grained.memory !0
  ret <2 x half> %result
}

define void @flat_system_atomic_fadd_noret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory(ptr %ptr, <2 x half> %val) #0 {
; GFX12-LABEL: flat_system_atomic_fadd_noret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_pk_add_f16 v[0:1], v2 offset:2044 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_system_atomic_fadd_noret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-NEXT:    flat_atomic_pk_add_f16 v[0:1], v2 offset:2044 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc0 sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_system_atomic_fadd_noret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_b32 v4, v[0:1] offset:2044
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB63_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[3:4] offset:2044 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB63_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_system_atomic_fadd_noret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0x7fc, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    flat_load_dword v4, v[0:1]
; GFX10-NEXT:  .LBB63_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB63_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_system_atomic_fadd_noret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    flat_load_dword v5, v[0:1] offset:2044
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB63_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_pk_add_f16 v4, v5, v2
; GFX90A-NEXT:    buffer_wbl2
; GFX90A-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[4:5] offset:2044 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_invl2
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB63_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_system_atomic_fadd_noret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v4, v[0:1] offset:2044
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB63_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] offset:2044 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB63_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_system_atomic_fadd_noret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB63_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 16, v4
; GFX8-NEXT:    v_add_f16_sdwa v3, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_add_f16_e32 v5, v4, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX8-NEXT:    v_or_b32_e32 v3, v5, v3
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB63_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_system_atomic_fadd_noret_v2f16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, 0x7fc, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    flat_load_dword v5, v[0:1]
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v2
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v6
; GFX7-NEXT:  .LBB63_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v8, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX7-NEXT:    v_or_b32_e32 v6, v4, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v8
; GFX7-NEXT:    v_or_b32_e32 v5, v7, v4
; GFX7-NEXT:    flat_atomic_cmpswap v7, v[0:1], v[5:6] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 16, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v6
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB63_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x half>, ptr %ptr, i64 511
  %unused = atomicrmw fadd ptr %gep, <2 x half> %val seq_cst, !amdgpu.no.fine.grained.memory !0
  ret void
}

define <2 x half> @flat_agent_atomic_fadd_ret_v2f16__amdgpu_no_remote_memory(ptr %ptr, <2 x half> %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_ret_v2f16__amdgpu_no_remote_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_pk_add_f16 v0, v[0:1], v2 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_ret_v2f16__amdgpu_no_remote_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_pk_add_f16 v0, v[0:1], v2 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_ret_v2f16__amdgpu_no_remote_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_b32 v3, v[0:1]
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB64_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[3:4] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB64_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_ret_v2f16__amdgpu_no_remote_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_load_dword v3, v[0:1]
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB64_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB64_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_ret_v2f16__amdgpu_no_remote_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    flat_load_dword v3, v[0:1]
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB64_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    v_pk_add_f16 v4, v5, v2
; GFX90A-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[4:5] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB64_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_ret_v2f16__amdgpu_no_remote_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v3, v[0:1]
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB64_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB64_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_ret_v2f16__amdgpu_no_remote_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB64_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 16, v4
; GFX8-NEXT:    v_add_f16_sdwa v3, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_add_f16_e32 v5, v4, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX8-NEXT:    v_or_b32_e32 v3, v5, v3
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB64_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v0, v3
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_ret_v2f16__amdgpu_no_remote_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    flat_load_dword v5, v[0:1]
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v2
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v6
; GFX7-NEXT:  .LBB64_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v4
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v8, v7
; GFX7-NEXT:    v_or_b32_e32 v7, v2, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v6
; GFX7-NEXT:    v_or_b32_e32 v6, v8, v2
; GFX7-NEXT:    flat_atomic_cmpswap v6, v[0:1], v[6:7] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v7
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB64_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v0, v2
; GFX7-NEXT:    v_mov_b32_e32 v1, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr %ptr, <2 x half> %val syncscope("agent") seq_cst, !amdgpu.no.remote.memory !0
  ret <2 x half> %result
}

define void @flat_agent_atomic_fadd_noret_v2f16__amdgpu_no_remote_memory(ptr %ptr, <2 x half> %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_v2f16__amdgpu_no_remote_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_pk_add_f16 v[0:1], v2 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_v2f16__amdgpu_no_remote_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_pk_add_f16 v[0:1], v2
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_v2f16__amdgpu_no_remote_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_b32 v4, v[0:1]
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB65_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[3:4] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB65_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_v2f16__amdgpu_no_remote_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_load_dword v4, v[0:1]
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB65_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB65_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_v2f16__amdgpu_no_remote_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    flat_load_dword v5, v[0:1]
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB65_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_pk_add_f16 v4, v5, v2
; GFX90A-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[4:5] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB65_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_v2f16__amdgpu_no_remote_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v4, v[0:1]
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB65_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB65_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_v2f16__amdgpu_no_remote_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB65_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 16, v4
; GFX8-NEXT:    v_add_f16_sdwa v3, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_add_f16_e32 v5, v4, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX8-NEXT:    v_or_b32_e32 v3, v5, v3
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB65_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_v2f16__amdgpu_no_remote_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    flat_load_dword v5, v[0:1]
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v2
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v6
; GFX7-NEXT:  .LBB65_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v8, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX7-NEXT:    v_or_b32_e32 v6, v4, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v8
; GFX7-NEXT:    v_or_b32_e32 v5, v7, v4
; GFX7-NEXT:    flat_atomic_cmpswap v7, v[0:1], v[5:6] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 16, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v6
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB65_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %unused = atomicrmw fadd ptr %ptr, <2 x half> %val syncscope("agent") seq_cst, !amdgpu.no.remote.memory !0
  ret void
}

define <2 x half> @flat_agent_atomic_fadd_ret_v2f16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory(ptr %ptr, <2 x half> %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_ret_v2f16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_pk_add_f16 v0, v[0:1], v2 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_ret_v2f16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_pk_add_f16 v0, v[0:1], v2 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_ret_v2f16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_b32 v3, v[0:1]
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB66_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[3:4] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB66_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_ret_v2f16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_load_dword v3, v[0:1]
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB66_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB66_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_ret_v2f16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    flat_load_dword v3, v[0:1]
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB66_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    v_pk_add_f16 v4, v5, v2
; GFX90A-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[4:5] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB66_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_ret_v2f16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v3, v[0:1]
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB66_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB66_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_ret_v2f16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB66_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 16, v4
; GFX8-NEXT:    v_add_f16_sdwa v3, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_add_f16_e32 v5, v4, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX8-NEXT:    v_or_b32_e32 v3, v5, v3
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB66_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v0, v3
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_ret_v2f16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    flat_load_dword v5, v[0:1]
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v2
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v6
; GFX7-NEXT:  .LBB66_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v4
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v8, v7
; GFX7-NEXT:    v_or_b32_e32 v7, v2, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v6
; GFX7-NEXT:    v_or_b32_e32 v6, v8, v2
; GFX7-NEXT:    flat_atomic_cmpswap v6, v[0:1], v[6:7] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v7
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB66_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v0, v2
; GFX7-NEXT:    v_mov_b32_e32 v1, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr %ptr, <2 x half> %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0, !amdgpu.no.remote.memory !0
  ret <2 x half> %result
}

define void @flat_agent_atomic_fadd_noret_v2f16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory(ptr %ptr, <2 x half> %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_v2f16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_pk_add_f16 v[0:1], v2 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_v2f16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_pk_add_f16 v[0:1], v2
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_v2f16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_b32 v4, v[0:1]
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB67_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[3:4] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB67_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_v2f16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_load_dword v4, v[0:1]
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB67_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB67_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_v2f16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    flat_load_dword v5, v[0:1]
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB67_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_pk_add_f16 v4, v5, v2
; GFX90A-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[4:5] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB67_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_v2f16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v4, v[0:1]
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB67_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB67_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_v2f16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB67_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 16, v4
; GFX8-NEXT:    v_add_f16_sdwa v3, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_add_f16_e32 v5, v4, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX8-NEXT:    v_or_b32_e32 v3, v5, v3
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB67_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_v2f16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    flat_load_dword v5, v[0:1]
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v2
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v6
; GFX7-NEXT:  .LBB67_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v8, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX7-NEXT:    v_or_b32_e32 v6, v4, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v8
; GFX7-NEXT:    v_or_b32_e32 v5, v7, v4
; GFX7-NEXT:    flat_atomic_cmpswap v7, v[0:1], v[5:6] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 16, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v6
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB67_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %unused = atomicrmw fadd ptr %ptr, <2 x half> %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0, !amdgpu.no.remote.memory !0
  ret void
}

; --------------------------------------------------------------------
; <2 x bfloat>
; --------------------------------------------------------------------

define <2 x bfloat> @flat_agent_atomic_fadd_ret_v2bf16__amdgpu_no_fine_grained_memory(ptr %ptr, <2 x bfloat> %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_ret_v2bf16__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_pk_add_bf16 v0, v[0:1], v2 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_ret_v2bf16__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_pk_add_bf16 v0, v[0:1], v2 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_ret_v2bf16__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_b32 v3, v[0:1]
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB68_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v6, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX11-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX11-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_add3_u32 v8, v8, v5, 0x7fff
; GFX11-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v3
; GFX11-NEXT:    v_cmp_u_f32_e64 s0, v3, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_cndmask_b32_e32 v5, v8, v10, vcc_lo
; GFX11-NEXT:    v_add3_u32 v7, v7, v3, 0x7fff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v3, v7, v9, s0
; GFX11-NEXT:    v_perm_b32 v5, v5, v3, 0x7060302
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[5:6] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v6
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB68_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_ret_v2bf16__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_load_dword v3, v[0:1]
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX10-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:  .LBB68_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v6, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX10-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX10-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX10-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX10-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX10-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v9, 0x400000, v3
; GFX10-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX10-NEXT:    v_add3_u32 v7, v7, v3, 0x7fff
; GFX10-NEXT:    v_add3_u32 v8, v8, v5, 0x7fff
; GFX10-NEXT:    v_cmp_u_f32_e64 s4, v3, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v8, v10, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v7, v9, s4
; GFX10-NEXT:    v_perm_b32 v5, v5, v3, 0x7060302
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[5:6] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v6
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB68_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_ret_v2bf16__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    flat_load_dword v3, v[0:1]
; GFX90A-NEXT:    s_mov_b64 s[6:7], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX90A-NEXT:    s_movk_i32 s8, 0x7fff
; GFX90A-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX90A-NEXT:    s_mov_b32 s9, 0x7060302
; GFX90A-NEXT:  .LBB68_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 16, v7
; GFX90A-NEXT:    v_and_b32_e32 v5, 0xffff0000, v7
; GFX90A-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX90A-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX90A-NEXT:    v_bfe_u32 v6, v3, 16, 1
; GFX90A-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX90A-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX90A-NEXT:    v_add3_u32 v6, v6, v3, s8
; GFX90A-NEXT:    v_add3_u32 v9, v9, v5, s8
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX90A-NEXT:    v_cmp_u_f32_e64 s[4:5], v3, v3
; GFX90A-NEXT:    v_cndmask_b32_e64 v3, v6, v8, s[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; GFX90A-NEXT:    v_perm_b32 v6, v5, v3, s9
; GFX90A-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[6:7] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v7
; GFX90A-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execnz .LBB68_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_ret_v2bf16__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v3, v[0:1]
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX908-NEXT:    s_movk_i32 s8, 0x7fff
; GFX908-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX908-NEXT:    s_mov_b32 s9, 0x7060302
; GFX908-NEXT:  .LBB68_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v6, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX908-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX908-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX908-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX908-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX908-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX908-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX908-NEXT:    v_add3_u32 v7, v7, v3, s8
; GFX908-NEXT:    v_add3_u32 v9, v9, v5, s8
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX908-NEXT:    v_cmp_u_f32_e64 s[4:5], v3, v3
; GFX908-NEXT:    v_cndmask_b32_e64 v3, v7, v8, s[4:5]
; GFX908-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; GFX908-NEXT:    v_perm_b32 v5, v5, v3, s9
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[5:6] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v6
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB68_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_ret_v2bf16__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX8-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX8-NEXT:  .LBB68_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v6, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX8-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX8-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX8-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX8-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, v7, v3
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, v9, v5
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, 0x7fff, v7
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; GFX8-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX8-NEXT:    v_cmp_u_f32_e64 s[4:5], v3, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v7, v8, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX8-NEXT:    v_alignbit_b32 v5, v5, v3, 16
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[5:6] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v6
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB68_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v0, v3
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_ret_v2bf16__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    flat_load_dword v5, v[0:1]
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v6, 1.0, v3
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX7-NEXT:  .LBB68_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v5
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v4
; GFX7-NEXT:    v_alignbit_b32 v3, v2, v3, 16
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v7
; GFX7-NEXT:    v_alignbit_b32 v2, v2, v6, 16
; GFX7-NEXT:    flat_atomic_cmpswap v6, v[0:1], v[2:3] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v3
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v6
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB68_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v0, v3
; GFX7-NEXT:    v_mov_b32_e32 v1, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr %ptr, <2 x bfloat> %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret <2 x bfloat> %result
}

define <2 x bfloat> @flat_agent_atomic_fadd_ret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory(ptr %ptr, <2 x bfloat> %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_ret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_pk_add_bf16 v0, v[0:1], v2 offset:2044 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_ret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_pk_add_bf16 v0, v[0:1], v2 offset:2044 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_ret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_b32 v3, v[0:1] offset:2044
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB69_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v6, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX11-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX11-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_add3_u32 v8, v8, v5, 0x7fff
; GFX11-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v3
; GFX11-NEXT:    v_cmp_u_f32_e64 s0, v3, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_cndmask_b32_e32 v5, v8, v10, vcc_lo
; GFX11-NEXT:    v_add3_u32 v7, v7, v3, 0x7fff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v3, v7, v9, s0
; GFX11-NEXT:    v_perm_b32 v5, v5, v3, 0x7060302
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[5:6] offset:2044 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v6
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB69_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_ret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fc, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v4, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX10-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:    flat_load_dword v0, v[3:4]
; GFX10-NEXT:  .LBB69_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v6, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; GFX10-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX10-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX10-NEXT:    v_bfe_u32 v7, v0, 16, 1
; GFX10-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v9, 0x400000, v0
; GFX10-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX10-NEXT:    v_add3_u32 v7, v7, v0, 0x7fff
; GFX10-NEXT:    v_add3_u32 v8, v8, v5, 0x7fff
; GFX10-NEXT:    v_cmp_u_f32_e64 s4, v0, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v8, v10, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v7, v9, s4
; GFX10-NEXT:    v_perm_b32 v5, v5, v0, 0x7060302
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[5:6] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v6
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB69_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_ret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    flat_load_dword v3, v[0:1] offset:2044
; GFX90A-NEXT:    s_mov_b64 s[6:7], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX90A-NEXT:    s_movk_i32 s8, 0x7fff
; GFX90A-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX90A-NEXT:    s_mov_b32 s9, 0x7060302
; GFX90A-NEXT:  .LBB69_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 16, v7
; GFX90A-NEXT:    v_and_b32_e32 v5, 0xffff0000, v7
; GFX90A-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX90A-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX90A-NEXT:    v_bfe_u32 v6, v3, 16, 1
; GFX90A-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX90A-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX90A-NEXT:    v_add3_u32 v6, v6, v3, s8
; GFX90A-NEXT:    v_add3_u32 v9, v9, v5, s8
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX90A-NEXT:    v_cmp_u_f32_e64 s[4:5], v3, v3
; GFX90A-NEXT:    v_cndmask_b32_e64 v3, v6, v8, s[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; GFX90A-NEXT:    v_perm_b32 v6, v5, v3, s9
; GFX90A-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[6:7] offset:2044 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v7
; GFX90A-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execnz .LBB69_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_ret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v3, v[0:1] offset:2044
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX908-NEXT:    s_movk_i32 s8, 0x7fff
; GFX908-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX908-NEXT:    s_mov_b32 s9, 0x7060302
; GFX908-NEXT:  .LBB69_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v6, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX908-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX908-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX908-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX908-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX908-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX908-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX908-NEXT:    v_add3_u32 v7, v7, v3, s8
; GFX908-NEXT:    v_add3_u32 v9, v9, v5, s8
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX908-NEXT:    v_cmp_u_f32_e64 s[4:5], v3, v3
; GFX908-NEXT:    v_cndmask_b32_e64 v3, v7, v8, s[4:5]
; GFX908-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; GFX908-NEXT:    v_perm_b32 v5, v5, v3, s9
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[5:6] offset:2044 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v6
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB69_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_ret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v4, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[3:4]
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX8-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX8-NEXT:  .LBB69_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v6, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX8-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX8-NEXT:    v_bfe_u32 v7, v0, 16, 1
; GFX8-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, v7, v0
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, v9, v5
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, 0x7fff, v7
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; GFX8-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_or_b32_e32 v8, 0x400000, v0
; GFX8-NEXT:    v_cmp_u_f32_e64 s[4:5], v0, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v7, v8, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX8-NEXT:    v_alignbit_b32 v5, v5, v0, 16
; GFX8-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[5:6] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v6
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB69_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_ret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 0x7fc, v0
; GFX7-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; GFX7-NEXT:    flat_load_dword v0, v[4:5]
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v1
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:  .LBB69_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff0000, v1
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_alignbit_b32 v1, v1, v0, 16
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 16, v7
; GFX7-NEXT:    v_alignbit_b32 v0, v0, v6, 16
; GFX7-NEXT:    flat_atomic_cmpswap v0, v[4:5], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v0
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB69_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x bfloat>, ptr %ptr, i64 511
  %result = atomicrmw fadd ptr %gep, <2 x bfloat> %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret <2 x bfloat> %result
}

define <2 x bfloat> @flat_agent_atomic_fadd_ret_v2bf16__offset12b_neg__amdgpu_no_fine_grained_memory(ptr %ptr, <2 x bfloat> %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_ret_v2bf16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_pk_add_bf16 v0, v[0:1], v2 offset:-2048 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_ret_v2bf16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff800, v0
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_pk_add_bf16 v0, v[0:1], v2 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_ret_v2bf16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v3, v0
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, 0xfffff800, v3
; GFX11-NEXT:    v_add_co_ci_u32_e32 v5, vcc_lo, -1, v1, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v3, vcc_lo, 0xfffff800, v3
; GFX11-NEXT:    flat_load_b32 v0, v[4:5]
; GFX11-NEXT:    v_add_co_ci_u32_e32 v4, vcc_lo, -1, v1, vcc_lo
; GFX11-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX11-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB70_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v6, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX11-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX11-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_add3_u32 v8, v8, v5, 0x7fff
; GFX11-NEXT:    v_bfe_u32 v7, v0, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v0
; GFX11-NEXT:    v_cmp_u_f32_e64 s0, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_cndmask_b32_e32 v5, v8, v10, vcc_lo
; GFX11-NEXT:    v_add3_u32 v7, v7, v0, 0x7fff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v7, v9, s0
; GFX11-NEXT:    v_perm_b32 v5, v5, v0, 0x7060302
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v0, v[3:4], v[5:6] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v6
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB70_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_ret_v2bf16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v3, vcc_lo, 0xfffff800, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v4, vcc_lo, -1, v1, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX10-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:    flat_load_dword v0, v[3:4]
; GFX10-NEXT:  .LBB70_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v6, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; GFX10-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX10-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX10-NEXT:    v_bfe_u32 v7, v0, 16, 1
; GFX10-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v9, 0x400000, v0
; GFX10-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX10-NEXT:    v_add3_u32 v7, v7, v0, 0x7fff
; GFX10-NEXT:    v_add3_u32 v8, v8, v5, 0x7fff
; GFX10-NEXT:    v_cmp_u_f32_e64 s4, v0, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v8, v10, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v7, v9, s4
; GFX10-NEXT:    v_perm_b32 v5, v5, v0, 0x7060302
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[5:6] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v6
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB70_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_ret_v2bf16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v4, vcc, 0xfffff800, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v5, vcc, -1, v1, vcc
; GFX90A-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff800, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX90A-NEXT:    flat_load_dword v0, v[0:1]
; GFX90A-NEXT:    s_mov_b64 s[6:7], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX90A-NEXT:    s_movk_i32 s8, 0x7fff
; GFX90A-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX90A-NEXT:    s_mov_b32 s9, 0x7060302
; GFX90A-NEXT:  .LBB70_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, v0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v0, 16, v7
; GFX90A-NEXT:    v_and_b32_e32 v3, 0xffff0000, v7
; GFX90A-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX90A-NEXT:    v_add_f32_e32 v3, v3, v2
; GFX90A-NEXT:    v_bfe_u32 v6, v0, 16, 1
; GFX90A-NEXT:    v_bfe_u32 v9, v3, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v0
; GFX90A-NEXT:    v_or_b32_e32 v10, 0x400000, v3
; GFX90A-NEXT:    v_add3_u32 v6, v6, v0, s8
; GFX90A-NEXT:    v_add3_u32 v9, v9, v3, s8
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX90A-NEXT:    v_cmp_u_f32_e64 s[4:5], v0, v0
; GFX90A-NEXT:    v_cndmask_b32_e64 v0, v6, v8, s[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v3, v9, v10, vcc
; GFX90A-NEXT:    v_perm_b32 v6, v3, v0, s9
; GFX90A-NEXT:    flat_atomic_cmpswap v0, v[4:5], v[6:7] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v7
; GFX90A-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execnz .LBB70_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_ret_v2bf16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v3, vcc, 0xfffff800, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v4, vcc, -1, v1, vcc
; GFX908-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff800, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX908-NEXT:    flat_load_dword v0, v[0:1]
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX908-NEXT:    s_movk_i32 s8, 0x7fff
; GFX908-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX908-NEXT:    s_mov_b32 s9, 0x7060302
; GFX908-NEXT:  .LBB70_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v6, v0
; GFX908-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; GFX908-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX908-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX908-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX908-NEXT:    v_bfe_u32 v7, v0, 16, 1
; GFX908-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v0
; GFX908-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX908-NEXT:    v_add3_u32 v7, v7, v0, s8
; GFX908-NEXT:    v_add3_u32 v9, v9, v5, s8
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX908-NEXT:    v_cmp_u_f32_e64 s[4:5], v0, v0
; GFX908-NEXT:    v_cndmask_b32_e64 v0, v7, v8, s[4:5]
; GFX908-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; GFX908-NEXT:    v_perm_b32 v5, v5, v0, s9
; GFX908-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[5:6] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v6
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB70_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_ret_v2bf16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0xfffff800, v0
; GFX8-NEXT:    v_addc_u32_e32 v4, vcc, -1, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[3:4]
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX8-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX8-NEXT:  .LBB70_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v6, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX8-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX8-NEXT:    v_bfe_u32 v7, v0, 16, 1
; GFX8-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, v7, v0
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, v9, v5
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, 0x7fff, v7
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; GFX8-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_or_b32_e32 v8, 0x400000, v0
; GFX8-NEXT:    v_cmp_u_f32_e64 s[4:5], v0, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v7, v8, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX8-NEXT:    v_alignbit_b32 v5, v5, v0, 16
; GFX8-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[5:6] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v6
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB70_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_ret_v2bf16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 0xfffff800, v0
; GFX7-NEXT:    v_addc_u32_e32 v5, vcc, -1, v1, vcc
; GFX7-NEXT:    flat_load_dword v0, v[4:5]
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v1
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:  .LBB70_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff0000, v1
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_alignbit_b32 v1, v1, v0, 16
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 16, v7
; GFX7-NEXT:    v_alignbit_b32 v0, v0, v6, 16
; GFX7-NEXT:    flat_atomic_cmpswap v0, v[4:5], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v0
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB70_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x bfloat>, ptr %ptr, i64 -512
  %result = atomicrmw fadd ptr %gep, <2 x bfloat> %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret <2 x bfloat> %result
}

define void @flat_agent_atomic_fadd_noret_v2bf16__amdgpu_no_fine_grained_memory(ptr %ptr, <2 x bfloat> %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_v2bf16__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_pk_add_bf16 v[0:1], v2 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_v2bf16__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_pk_add_bf16 v[0:1], v2
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_v2bf16__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_b32 v3, v[0:1]
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB71_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX11-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX11-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX11-NEXT:    v_bfe_u32 v8, v6, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX11-NEXT:    v_add3_u32 v8, v8, v6, 0x7fff
; GFX11-NEXT:    v_cmp_u_f32_e64 s0, v2, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v6, v8, v10, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v2, v7, v9, s0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_perm_b32 v2, v6, v2, 0x7060302
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v2, v[0:1], v[2:3] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX11-NEXT:    v_mov_b32_e32 v3, v2
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB71_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_v2bf16__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_load_dword v3, v[0:1]
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX10-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:  .LBB71_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX10-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX10-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX10-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX10-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX10-NEXT:    v_bfe_u32 v8, v6, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX10-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX10-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX10-NEXT:    v_add3_u32 v8, v8, v6, 0x7fff
; GFX10-NEXT:    v_cmp_u_f32_e64 s4, v2, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v6, v8, v10, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v7, v9, s4
; GFX10-NEXT:    v_perm_b32 v2, v6, v2, 0x7060302
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX10-NEXT:    v_mov_b32_e32 v3, v2
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB71_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_v2bf16__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    flat_load_dword v3, v[0:1]
; GFX90A-NEXT:    s_mov_b64 s[6:7], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX90A-NEXT:    s_movk_i32 s8, 0x7fff
; GFX90A-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX90A-NEXT:    s_mov_b32 s9, 0x7060302
; GFX90A-NEXT:  .LBB71_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX90A-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX90A-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX90A-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX90A-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX90A-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX90A-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX90A-NEXT:    v_add3_u32 v7, v7, v2, s8
; GFX90A-NEXT:    v_add3_u32 v9, v9, v6, s8
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX90A-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX90A-NEXT:    v_cndmask_b32_e64 v2, v7, v8, s[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; GFX90A-NEXT:    v_perm_b32 v2, v6, v2, s9
; GFX90A-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX90A-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execnz .LBB71_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_v2bf16__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v3, v[0:1]
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX908-NEXT:    s_movk_i32 s8, 0x7fff
; GFX908-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX908-NEXT:    s_mov_b32 s9, 0x7060302
; GFX908-NEXT:  .LBB71_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX908-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX908-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX908-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX908-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX908-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX908-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX908-NEXT:    v_add3_u32 v7, v7, v2, s8
; GFX908-NEXT:    v_add3_u32 v9, v9, v6, s8
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX908-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX908-NEXT:    v_cndmask_b32_e64 v2, v7, v8, s[4:5]
; GFX908-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; GFX908-NEXT:    v_perm_b32 v2, v6, v2, s9
; GFX908-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v3, v2
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB71_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_v2bf16__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX8-NEXT:  .LBB71_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX8-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX8-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX8-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX8-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX8-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, v7, v2
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, v9, v6
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, 0x7fff, v7
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; GFX8-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX8-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX8-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v7, v8, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; GFX8-NEXT:    v_alignbit_b32 v2, v6, v2, 16
; GFX8-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v3, v2
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB71_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_v2bf16__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    flat_load_dword v5, v[0:1]
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:  .LBB71_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX7-NEXT:    v_mul_f32_e32 v5, 1.0, v5
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff0000, v4
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v5
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_alignbit_b32 v5, v4, v5, 16
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v7
; GFX7-NEXT:    v_alignbit_b32 v4, v4, v6, 16
; GFX7-NEXT:    flat_atomic_cmpswap v6, v[0:1], v[4:5] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v5
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v6
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v6
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB71_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %unused = atomicrmw fadd ptr %ptr, <2 x bfloat> %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret void
}

define void @flat_agent_atomic_fadd_noret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory(ptr %ptr, <2 x bfloat> %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_pk_add_bf16 v[0:1], v2 offset:2044 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_pk_add_bf16 v[0:1], v2 offset:2044
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_b32 v3, v[0:1] offset:2044
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB72_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX11-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX11-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX11-NEXT:    v_bfe_u32 v8, v6, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX11-NEXT:    v_add3_u32 v8, v8, v6, 0x7fff
; GFX11-NEXT:    v_cmp_u_f32_e64 s0, v2, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v6, v8, v10, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v2, v7, v9, s0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_perm_b32 v2, v6, v2, 0x7060302
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v2, v[0:1], v[2:3] offset:2044 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX11-NEXT:    v_mov_b32_e32 v3, v2
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB72_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0x7fc, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX10-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:    flat_load_dword v3, v[0:1]
; GFX10-NEXT:  .LBB72_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX10-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX10-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX10-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX10-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX10-NEXT:    v_bfe_u32 v8, v6, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX10-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX10-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX10-NEXT:    v_add3_u32 v8, v8, v6, 0x7fff
; GFX10-NEXT:    v_cmp_u_f32_e64 s4, v2, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v6, v8, v10, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v7, v9, s4
; GFX10-NEXT:    v_perm_b32 v2, v6, v2, 0x7060302
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX10-NEXT:    v_mov_b32_e32 v3, v2
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB72_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    flat_load_dword v3, v[0:1] offset:2044
; GFX90A-NEXT:    s_mov_b64 s[6:7], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX90A-NEXT:    s_movk_i32 s8, 0x7fff
; GFX90A-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX90A-NEXT:    s_mov_b32 s9, 0x7060302
; GFX90A-NEXT:  .LBB72_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX90A-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX90A-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX90A-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX90A-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX90A-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX90A-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX90A-NEXT:    v_add3_u32 v7, v7, v2, s8
; GFX90A-NEXT:    v_add3_u32 v9, v9, v6, s8
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX90A-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX90A-NEXT:    v_cndmask_b32_e64 v2, v7, v8, s[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; GFX90A-NEXT:    v_perm_b32 v2, v6, v2, s9
; GFX90A-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] offset:2044 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX90A-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execnz .LBB72_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v3, v[0:1] offset:2044
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX908-NEXT:    s_movk_i32 s8, 0x7fff
; GFX908-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX908-NEXT:    s_mov_b32 s9, 0x7060302
; GFX908-NEXT:  .LBB72_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX908-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX908-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX908-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX908-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX908-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX908-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX908-NEXT:    v_add3_u32 v7, v7, v2, s8
; GFX908-NEXT:    v_add3_u32 v9, v9, v6, s8
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX908-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX908-NEXT:    v_cndmask_b32_e64 v2, v7, v8, s[4:5]
; GFX908-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; GFX908-NEXT:    v_perm_b32 v2, v6, v2, s9
; GFX908-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] offset:2044 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v3, v2
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB72_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX8-NEXT:  .LBB72_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX8-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX8-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX8-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX8-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX8-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, v7, v2
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, v9, v6
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, 0x7fff, v7
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; GFX8-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX8-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX8-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v7, v8, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; GFX8-NEXT:    v_alignbit_b32 v2, v6, v2, 16
; GFX8-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v3, v2
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB72_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, 0x7fc, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    flat_load_dword v5, v[0:1]
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:  .LBB72_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX7-NEXT:    v_mul_f32_e32 v5, 1.0, v5
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff0000, v4
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v5
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_alignbit_b32 v5, v4, v5, 16
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v7
; GFX7-NEXT:    v_alignbit_b32 v4, v4, v6, 16
; GFX7-NEXT:    flat_atomic_cmpswap v6, v[0:1], v[4:5] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v5
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v6
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v6
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB72_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x bfloat>, ptr %ptr, i64 511
  %unused = atomicrmw fadd ptr %gep, <2 x bfloat> %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret void
}

define void @flat_agent_atomic_fadd_noret_v2bf16__offset12b_neg__amdgpu_no_fine_grained_memory(ptr %ptr, <2 x bfloat> %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_v2bf16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_pk_add_bf16 v[0:1], v2 offset:-2048 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_v2bf16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff800, v0
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_pk_add_bf16 v[0:1], v2
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_v2bf16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v3, vcc_lo, 0xfffff800, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v4, vcc_lo, -1, v1, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, 0xfffff800, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX11-NEXT:    flat_load_b32 v3, v[3:4]
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB73_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX11-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX11-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX11-NEXT:    v_bfe_u32 v8, v6, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX11-NEXT:    v_add3_u32 v8, v8, v6, 0x7fff
; GFX11-NEXT:    v_cmp_u_f32_e64 s0, v2, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v6, v8, v10, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v2, v7, v9, s0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_perm_b32 v2, v6, v2, 0x7060302
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v2, v[0:1], v[2:3] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX11-NEXT:    v_mov_b32_e32 v3, v2
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB73_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_v2bf16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0xfffff800, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX10-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:    flat_load_dword v3, v[0:1]
; GFX10-NEXT:  .LBB73_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX10-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX10-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX10-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX10-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX10-NEXT:    v_bfe_u32 v8, v6, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX10-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX10-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX10-NEXT:    v_add3_u32 v8, v8, v6, 0x7fff
; GFX10-NEXT:    v_cmp_u_f32_e64 s4, v2, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v6, v8, v10, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v7, v9, s4
; GFX10-NEXT:    v_perm_b32 v2, v6, v2, 0x7060302
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX10-NEXT:    v_mov_b32_e32 v3, v2
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB73_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_v2bf16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v4, vcc, 0xfffff800, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v5, vcc, -1, v1, vcc
; GFX90A-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff800, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX90A-NEXT:    flat_load_dword v1, v[0:1]
; GFX90A-NEXT:    s_mov_b64 s[6:7], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX90A-NEXT:    s_movk_i32 s8, 0x7fff
; GFX90A-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX90A-NEXT:    s_mov_b32 s9, 0x7060302
; GFX90A-NEXT:  .LBB73_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_lshlrev_b32_e32 v0, 16, v1
; GFX90A-NEXT:    v_and_b32_e32 v6, 0xffff0000, v1
; GFX90A-NEXT:    v_add_f32_e32 v0, v0, v3
; GFX90A-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX90A-NEXT:    v_bfe_u32 v7, v0, 16, 1
; GFX90A-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v0
; GFX90A-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX90A-NEXT:    v_add3_u32 v7, v7, v0, s8
; GFX90A-NEXT:    v_add3_u32 v9, v9, v6, s8
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX90A-NEXT:    v_cmp_u_f32_e64 s[4:5], v0, v0
; GFX90A-NEXT:    v_cndmask_b32_e64 v0, v7, v8, s[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; GFX90A-NEXT:    v_perm_b32 v0, v6, v0, s9
; GFX90A-NEXT:    flat_atomic_cmpswap v0, v[4:5], v[0:1] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX90A-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX90A-NEXT:    v_mov_b32_e32 v1, v0
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execnz .LBB73_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_v2bf16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v3, vcc, 0xfffff800, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v4, vcc, -1, v1, vcc
; GFX908-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff800, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX908-NEXT:    flat_load_dword v1, v[0:1]
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v5, 16, v2
; GFX908-NEXT:    s_movk_i32 s8, 0x7fff
; GFX908-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX908-NEXT:    s_mov_b32 s9, 0x7060302
; GFX908-NEXT:  .LBB73_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_lshlrev_b32_e32 v0, 16, v1
; GFX908-NEXT:    v_and_b32_e32 v6, 0xffff0000, v1
; GFX908-NEXT:    v_add_f32_e32 v0, v0, v5
; GFX908-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX908-NEXT:    v_bfe_u32 v7, v0, 16, 1
; GFX908-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v0
; GFX908-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX908-NEXT:    v_add3_u32 v7, v7, v0, s8
; GFX908-NEXT:    v_add3_u32 v9, v9, v6, s8
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX908-NEXT:    v_cmp_u_f32_e64 s[4:5], v0, v0
; GFX908-NEXT:    v_cndmask_b32_e64 v0, v7, v8, s[4:5]
; GFX908-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; GFX908-NEXT:    v_perm_b32 v0, v6, v0, s9
; GFX908-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v1, v0
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB73_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_v2bf16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0xfffff800, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX8-NEXT:  .LBB73_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX8-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX8-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX8-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX8-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX8-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, v7, v2
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, v9, v6
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, 0x7fff, v7
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; GFX8-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX8-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX8-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v7, v8, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; GFX8-NEXT:    v_alignbit_b32 v2, v6, v2, 16
; GFX8-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v3, v2
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB73_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_v2bf16__offset12b_neg__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, 0xfffff800, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX7-NEXT:    flat_load_dword v5, v[0:1]
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:  .LBB73_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX7-NEXT:    v_mul_f32_e32 v5, 1.0, v5
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff0000, v4
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v5
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_alignbit_b32 v5, v4, v5, 16
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v7
; GFX7-NEXT:    v_alignbit_b32 v4, v4, v6, 16
; GFX7-NEXT:    flat_atomic_cmpswap v6, v[0:1], v[4:5] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v5
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v6
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v6
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB73_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x bfloat>, ptr %ptr, i64 -512
  %unused = atomicrmw fadd ptr %gep, <2 x bfloat> %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0
  ret void
}

define <2 x bfloat> @flat_system_atomic_fadd_ret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory(ptr %ptr, <2 x bfloat> %val) #0 {
; GFX12-LABEL: flat_system_atomic_fadd_ret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_pk_add_bf16 v0, v[0:1], v2 offset:2044 th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_system_atomic_fadd_ret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-NEXT:    flat_atomic_pk_add_bf16 v0, v[0:1], v2 offset:2044 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc0 sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_system_atomic_fadd_ret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_b32 v3, v[0:1] offset:2044
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB74_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v6, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX11-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX11-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_add3_u32 v8, v8, v5, 0x7fff
; GFX11-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v3
; GFX11-NEXT:    v_cmp_u_f32_e64 s0, v3, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_cndmask_b32_e32 v5, v8, v10, vcc_lo
; GFX11-NEXT:    v_add3_u32 v7, v7, v3, 0x7fff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v3, v7, v9, s0
; GFX11-NEXT:    v_perm_b32 v5, v5, v3, 0x7060302
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[5:6] offset:2044 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v6
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB74_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_system_atomic_fadd_ret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fc, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v4, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX10-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:    flat_load_dword v0, v[3:4]
; GFX10-NEXT:  .LBB74_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v6, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; GFX10-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX10-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX10-NEXT:    v_bfe_u32 v7, v0, 16, 1
; GFX10-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v9, 0x400000, v0
; GFX10-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX10-NEXT:    v_add3_u32 v7, v7, v0, 0x7fff
; GFX10-NEXT:    v_add3_u32 v8, v8, v5, 0x7fff
; GFX10-NEXT:    v_cmp_u_f32_e64 s4, v0, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v8, v10, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v7, v9, s4
; GFX10-NEXT:    v_perm_b32 v5, v5, v0, 0x7060302
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[5:6] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v6
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB74_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_system_atomic_fadd_ret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    flat_load_dword v3, v[0:1] offset:2044
; GFX90A-NEXT:    s_mov_b64 s[6:7], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX90A-NEXT:    s_movk_i32 s8, 0x7fff
; GFX90A-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX90A-NEXT:    s_mov_b32 s9, 0x7060302
; GFX90A-NEXT:  .LBB74_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 16, v7
; GFX90A-NEXT:    v_and_b32_e32 v5, 0xffff0000, v7
; GFX90A-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX90A-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX90A-NEXT:    v_bfe_u32 v6, v3, 16, 1
; GFX90A-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX90A-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX90A-NEXT:    v_add3_u32 v6, v6, v3, s8
; GFX90A-NEXT:    v_add3_u32 v9, v9, v5, s8
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX90A-NEXT:    v_cmp_u_f32_e64 s[4:5], v3, v3
; GFX90A-NEXT:    v_cndmask_b32_e64 v3, v6, v8, s[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; GFX90A-NEXT:    v_perm_b32 v6, v5, v3, s9
; GFX90A-NEXT:    buffer_wbl2
; GFX90A-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[6:7] offset:2044 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_invl2
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v7
; GFX90A-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execnz .LBB74_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_system_atomic_fadd_ret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v3, v[0:1] offset:2044
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX908-NEXT:    s_movk_i32 s8, 0x7fff
; GFX908-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX908-NEXT:    s_mov_b32 s9, 0x7060302
; GFX908-NEXT:  .LBB74_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v6, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX908-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX908-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX908-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX908-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX908-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX908-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX908-NEXT:    v_add3_u32 v7, v7, v3, s8
; GFX908-NEXT:    v_add3_u32 v9, v9, v5, s8
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX908-NEXT:    v_cmp_u_f32_e64 s[4:5], v3, v3
; GFX908-NEXT:    v_cndmask_b32_e64 v3, v7, v8, s[4:5]
; GFX908-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; GFX908-NEXT:    v_perm_b32 v5, v5, v3, s9
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[5:6] offset:2044 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v6
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB74_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_system_atomic_fadd_ret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v4, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[3:4]
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX8-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX8-NEXT:  .LBB74_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v6, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX8-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX8-NEXT:    v_bfe_u32 v7, v0, 16, 1
; GFX8-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, v7, v0
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, v9, v5
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, 0x7fff, v7
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; GFX8-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_or_b32_e32 v8, 0x400000, v0
; GFX8-NEXT:    v_cmp_u_f32_e64 s[4:5], v0, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v7, v8, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX8-NEXT:    v_alignbit_b32 v5, v5, v0, 16
; GFX8-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[5:6] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v6
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB74_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_system_atomic_fadd_ret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 0x7fc, v0
; GFX7-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; GFX7-NEXT:    flat_load_dword v0, v[4:5]
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v1
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:  .LBB74_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff0000, v1
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_alignbit_b32 v1, v1, v0, 16
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 16, v7
; GFX7-NEXT:    v_alignbit_b32 v0, v0, v6, 16
; GFX7-NEXT:    flat_atomic_cmpswap v0, v[4:5], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v0
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB74_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x bfloat>, ptr %ptr, i64 511
  %result = atomicrmw fadd ptr %gep, <2 x bfloat> %val seq_cst, !amdgpu.no.fine.grained.memory !0
  ret <2 x bfloat> %result
}

define void @flat_system_atomic_fadd_noret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory(ptr %ptr, <2 x bfloat> %val) #0 {
; GFX12-LABEL: flat_system_atomic_fadd_noret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_pk_add_bf16 v[0:1], v2 offset:2044 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_system_atomic_fadd_noret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-NEXT:    flat_atomic_pk_add_bf16 v[0:1], v2 offset:2044 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc0 sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_system_atomic_fadd_noret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_b32 v3, v[0:1] offset:2044
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB75_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX11-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX11-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX11-NEXT:    v_bfe_u32 v8, v6, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX11-NEXT:    v_add3_u32 v8, v8, v6, 0x7fff
; GFX11-NEXT:    v_cmp_u_f32_e64 s0, v2, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v6, v8, v10, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v2, v7, v9, s0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_perm_b32 v2, v6, v2, 0x7060302
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v2, v[0:1], v[2:3] offset:2044 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX11-NEXT:    v_mov_b32_e32 v3, v2
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB75_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_system_atomic_fadd_noret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, 0x7fc, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX10-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:    flat_load_dword v3, v[0:1]
; GFX10-NEXT:  .LBB75_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX10-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX10-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX10-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX10-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX10-NEXT:    v_bfe_u32 v8, v6, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX10-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX10-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX10-NEXT:    v_add3_u32 v8, v8, v6, 0x7fff
; GFX10-NEXT:    v_cmp_u_f32_e64 s4, v2, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v6, v8, v10, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v7, v9, s4
; GFX10-NEXT:    v_perm_b32 v2, v6, v2, 0x7060302
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX10-NEXT:    v_mov_b32_e32 v3, v2
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB75_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_system_atomic_fadd_noret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    flat_load_dword v3, v[0:1] offset:2044
; GFX90A-NEXT:    s_mov_b64 s[6:7], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX90A-NEXT:    s_movk_i32 s8, 0x7fff
; GFX90A-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX90A-NEXT:    s_mov_b32 s9, 0x7060302
; GFX90A-NEXT:  .LBB75_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX90A-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX90A-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX90A-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX90A-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX90A-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX90A-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX90A-NEXT:    v_add3_u32 v7, v7, v2, s8
; GFX90A-NEXT:    v_add3_u32 v9, v9, v6, s8
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX90A-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX90A-NEXT:    v_cndmask_b32_e64 v2, v7, v8, s[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; GFX90A-NEXT:    v_perm_b32 v2, v6, v2, s9
; GFX90A-NEXT:    buffer_wbl2
; GFX90A-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] offset:2044 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_invl2
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX90A-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execnz .LBB75_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_system_atomic_fadd_noret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v3, v[0:1] offset:2044
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX908-NEXT:    s_movk_i32 s8, 0x7fff
; GFX908-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX908-NEXT:    s_mov_b32 s9, 0x7060302
; GFX908-NEXT:  .LBB75_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX908-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX908-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX908-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX908-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX908-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX908-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX908-NEXT:    v_add3_u32 v7, v7, v2, s8
; GFX908-NEXT:    v_add3_u32 v9, v9, v6, s8
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX908-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX908-NEXT:    v_cndmask_b32_e64 v2, v7, v8, s[4:5]
; GFX908-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; GFX908-NEXT:    v_perm_b32 v2, v6, v2, s9
; GFX908-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] offset:2044 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v3, v2
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB75_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_system_atomic_fadd_noret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX8-NEXT:  .LBB75_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX8-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX8-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX8-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX8-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX8-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, v7, v2
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, v9, v6
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, 0x7fff, v7
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; GFX8-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX8-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX8-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v7, v8, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; GFX8-NEXT:    v_alignbit_b32 v2, v6, v2, 16
; GFX8-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v3, v2
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB75_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_system_atomic_fadd_noret_v2bf16__offset12b_pos__amdgpu_no_fine_grained_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, 0x7fc, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    flat_load_dword v5, v[0:1]
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:  .LBB75_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX7-NEXT:    v_mul_f32_e32 v5, 1.0, v5
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff0000, v4
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v5
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_alignbit_b32 v5, v4, v5, 16
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v7
; GFX7-NEXT:    v_alignbit_b32 v4, v4, v6, 16
; GFX7-NEXT:    flat_atomic_cmpswap v6, v[0:1], v[4:5] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v5
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v6
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v6
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB75_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x bfloat>, ptr %ptr, i64 511
  %unused = atomicrmw fadd ptr %gep, <2 x bfloat> %val seq_cst, !amdgpu.no.fine.grained.memory !0
  ret void
}

define <2 x bfloat> @flat_agent_atomic_fadd_ret_v2bf16__amdgpu_no_remote_memory(ptr %ptr, <2 x bfloat> %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_ret_v2bf16__amdgpu_no_remote_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_pk_add_bf16 v0, v[0:1], v2 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_ret_v2bf16__amdgpu_no_remote_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_pk_add_bf16 v0, v[0:1], v2 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_ret_v2bf16__amdgpu_no_remote_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_b32 v3, v[0:1]
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB76_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v6, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX11-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX11-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_add3_u32 v8, v8, v5, 0x7fff
; GFX11-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v3
; GFX11-NEXT:    v_cmp_u_f32_e64 s0, v3, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_cndmask_b32_e32 v5, v8, v10, vcc_lo
; GFX11-NEXT:    v_add3_u32 v7, v7, v3, 0x7fff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v3, v7, v9, s0
; GFX11-NEXT:    v_perm_b32 v5, v5, v3, 0x7060302
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[5:6] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v6
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB76_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_ret_v2bf16__amdgpu_no_remote_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_load_dword v3, v[0:1]
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX10-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:  .LBB76_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v6, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX10-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX10-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX10-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX10-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX10-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v9, 0x400000, v3
; GFX10-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX10-NEXT:    v_add3_u32 v7, v7, v3, 0x7fff
; GFX10-NEXT:    v_add3_u32 v8, v8, v5, 0x7fff
; GFX10-NEXT:    v_cmp_u_f32_e64 s4, v3, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v8, v10, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v7, v9, s4
; GFX10-NEXT:    v_perm_b32 v5, v5, v3, 0x7060302
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[5:6] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v6
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB76_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_ret_v2bf16__amdgpu_no_remote_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    flat_load_dword v3, v[0:1]
; GFX90A-NEXT:    s_mov_b64 s[6:7], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX90A-NEXT:    s_movk_i32 s8, 0x7fff
; GFX90A-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX90A-NEXT:    s_mov_b32 s9, 0x7060302
; GFX90A-NEXT:  .LBB76_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 16, v7
; GFX90A-NEXT:    v_and_b32_e32 v5, 0xffff0000, v7
; GFX90A-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX90A-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX90A-NEXT:    v_bfe_u32 v6, v3, 16, 1
; GFX90A-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX90A-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX90A-NEXT:    v_add3_u32 v6, v6, v3, s8
; GFX90A-NEXT:    v_add3_u32 v9, v9, v5, s8
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX90A-NEXT:    v_cmp_u_f32_e64 s[4:5], v3, v3
; GFX90A-NEXT:    v_cndmask_b32_e64 v3, v6, v8, s[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; GFX90A-NEXT:    v_perm_b32 v6, v5, v3, s9
; GFX90A-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[6:7] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v7
; GFX90A-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execnz .LBB76_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_ret_v2bf16__amdgpu_no_remote_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v3, v[0:1]
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX908-NEXT:    s_movk_i32 s8, 0x7fff
; GFX908-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX908-NEXT:    s_mov_b32 s9, 0x7060302
; GFX908-NEXT:  .LBB76_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v6, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX908-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX908-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX908-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX908-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX908-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX908-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX908-NEXT:    v_add3_u32 v7, v7, v3, s8
; GFX908-NEXT:    v_add3_u32 v9, v9, v5, s8
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX908-NEXT:    v_cmp_u_f32_e64 s[4:5], v3, v3
; GFX908-NEXT:    v_cndmask_b32_e64 v3, v7, v8, s[4:5]
; GFX908-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; GFX908-NEXT:    v_perm_b32 v5, v5, v3, s9
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[5:6] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v6
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB76_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_ret_v2bf16__amdgpu_no_remote_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX8-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX8-NEXT:  .LBB76_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v6, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX8-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX8-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX8-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX8-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, v7, v3
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, v9, v5
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, 0x7fff, v7
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; GFX8-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX8-NEXT:    v_cmp_u_f32_e64 s[4:5], v3, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v7, v8, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX8-NEXT:    v_alignbit_b32 v5, v5, v3, 16
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[5:6] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v6
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB76_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v0, v3
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_ret_v2bf16__amdgpu_no_remote_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    flat_load_dword v5, v[0:1]
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v6, 1.0, v3
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX7-NEXT:  .LBB76_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v5
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v4
; GFX7-NEXT:    v_alignbit_b32 v3, v2, v3, 16
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v7
; GFX7-NEXT:    v_alignbit_b32 v2, v2, v6, 16
; GFX7-NEXT:    flat_atomic_cmpswap v6, v[0:1], v[2:3] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v3
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v6
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB76_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v0, v3
; GFX7-NEXT:    v_mov_b32_e32 v1, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr %ptr, <2 x bfloat> %val syncscope("agent") seq_cst, !amdgpu.no.remote.memory !0
  ret <2 x bfloat> %result
}

define void @flat_agent_atomic_fadd_noret_v2bf16__amdgpu_no_remote_memory(ptr %ptr, <2 x bfloat> %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_v2bf16__amdgpu_no_remote_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_pk_add_bf16 v[0:1], v2 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_v2bf16__amdgpu_no_remote_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_pk_add_bf16 v[0:1], v2
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_v2bf16__amdgpu_no_remote_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_b32 v3, v[0:1]
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB77_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX11-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX11-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX11-NEXT:    v_bfe_u32 v8, v6, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX11-NEXT:    v_add3_u32 v8, v8, v6, 0x7fff
; GFX11-NEXT:    v_cmp_u_f32_e64 s0, v2, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v6, v8, v10, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v2, v7, v9, s0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_perm_b32 v2, v6, v2, 0x7060302
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v2, v[0:1], v[2:3] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX11-NEXT:    v_mov_b32_e32 v3, v2
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB77_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_v2bf16__amdgpu_no_remote_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_load_dword v3, v[0:1]
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX10-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:  .LBB77_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX10-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX10-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX10-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX10-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX10-NEXT:    v_bfe_u32 v8, v6, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX10-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX10-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX10-NEXT:    v_add3_u32 v8, v8, v6, 0x7fff
; GFX10-NEXT:    v_cmp_u_f32_e64 s4, v2, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v6, v8, v10, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v7, v9, s4
; GFX10-NEXT:    v_perm_b32 v2, v6, v2, 0x7060302
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX10-NEXT:    v_mov_b32_e32 v3, v2
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB77_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_v2bf16__amdgpu_no_remote_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    flat_load_dword v3, v[0:1]
; GFX90A-NEXT:    s_mov_b64 s[6:7], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX90A-NEXT:    s_movk_i32 s8, 0x7fff
; GFX90A-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX90A-NEXT:    s_mov_b32 s9, 0x7060302
; GFX90A-NEXT:  .LBB77_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX90A-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX90A-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX90A-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX90A-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX90A-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX90A-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX90A-NEXT:    v_add3_u32 v7, v7, v2, s8
; GFX90A-NEXT:    v_add3_u32 v9, v9, v6, s8
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX90A-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX90A-NEXT:    v_cndmask_b32_e64 v2, v7, v8, s[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; GFX90A-NEXT:    v_perm_b32 v2, v6, v2, s9
; GFX90A-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX90A-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execnz .LBB77_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_v2bf16__amdgpu_no_remote_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v3, v[0:1]
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX908-NEXT:    s_movk_i32 s8, 0x7fff
; GFX908-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX908-NEXT:    s_mov_b32 s9, 0x7060302
; GFX908-NEXT:  .LBB77_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX908-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX908-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX908-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX908-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX908-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX908-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX908-NEXT:    v_add3_u32 v7, v7, v2, s8
; GFX908-NEXT:    v_add3_u32 v9, v9, v6, s8
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX908-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX908-NEXT:    v_cndmask_b32_e64 v2, v7, v8, s[4:5]
; GFX908-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; GFX908-NEXT:    v_perm_b32 v2, v6, v2, s9
; GFX908-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v3, v2
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB77_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_v2bf16__amdgpu_no_remote_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX8-NEXT:  .LBB77_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX8-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX8-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX8-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX8-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX8-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, v7, v2
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, v9, v6
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, 0x7fff, v7
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; GFX8-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX8-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX8-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v7, v8, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; GFX8-NEXT:    v_alignbit_b32 v2, v6, v2, 16
; GFX8-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v3, v2
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB77_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_v2bf16__amdgpu_no_remote_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    flat_load_dword v5, v[0:1]
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:  .LBB77_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX7-NEXT:    v_mul_f32_e32 v5, 1.0, v5
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff0000, v4
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v5
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_alignbit_b32 v5, v4, v5, 16
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v7
; GFX7-NEXT:    v_alignbit_b32 v4, v4, v6, 16
; GFX7-NEXT:    flat_atomic_cmpswap v6, v[0:1], v[4:5] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v5
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v6
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v6
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB77_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %unused = atomicrmw fadd ptr %ptr, <2 x bfloat> %val syncscope("agent") seq_cst, !amdgpu.no.remote.memory !0
  ret void
}

define <2 x bfloat> @flat_agent_atomic_fadd_ret_v2bf16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory(ptr %ptr, <2 x bfloat> %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_ret_v2bf16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_pk_add_bf16 v0, v[0:1], v2 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_ret_v2bf16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_pk_add_bf16 v0, v[0:1], v2 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_ret_v2bf16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_b32 v3, v[0:1]
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB78_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v6, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX11-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX11-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_add3_u32 v8, v8, v5, 0x7fff
; GFX11-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v3
; GFX11-NEXT:    v_cmp_u_f32_e64 s0, v3, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_cndmask_b32_e32 v5, v8, v10, vcc_lo
; GFX11-NEXT:    v_add3_u32 v7, v7, v3, 0x7fff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v3, v7, v9, s0
; GFX11-NEXT:    v_perm_b32 v5, v5, v3, 0x7060302
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v3, v[0:1], v[5:6] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v6
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB78_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_ret_v2bf16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_load_dword v3, v[0:1]
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX10-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:  .LBB78_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v6, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX10-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX10-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX10-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX10-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX10-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v9, 0x400000, v3
; GFX10-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX10-NEXT:    v_add3_u32 v7, v7, v3, 0x7fff
; GFX10-NEXT:    v_add3_u32 v8, v8, v5, 0x7fff
; GFX10-NEXT:    v_cmp_u_f32_e64 s4, v3, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v8, v10, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v7, v9, s4
; GFX10-NEXT:    v_perm_b32 v5, v5, v3, 0x7060302
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[5:6] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v6
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB78_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_ret_v2bf16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    flat_load_dword v3, v[0:1]
; GFX90A-NEXT:    s_mov_b64 s[6:7], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX90A-NEXT:    s_movk_i32 s8, 0x7fff
; GFX90A-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX90A-NEXT:    s_mov_b32 s9, 0x7060302
; GFX90A-NEXT:  .LBB78_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 16, v7
; GFX90A-NEXT:    v_and_b32_e32 v5, 0xffff0000, v7
; GFX90A-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX90A-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX90A-NEXT:    v_bfe_u32 v6, v3, 16, 1
; GFX90A-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX90A-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX90A-NEXT:    v_add3_u32 v6, v6, v3, s8
; GFX90A-NEXT:    v_add3_u32 v9, v9, v5, s8
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX90A-NEXT:    v_cmp_u_f32_e64 s[4:5], v3, v3
; GFX90A-NEXT:    v_cndmask_b32_e64 v3, v6, v8, s[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; GFX90A-NEXT:    v_perm_b32 v6, v5, v3, s9
; GFX90A-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[6:7] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v7
; GFX90A-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execnz .LBB78_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_ret_v2bf16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v3, v[0:1]
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX908-NEXT:    s_movk_i32 s8, 0x7fff
; GFX908-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX908-NEXT:    s_mov_b32 s9, 0x7060302
; GFX908-NEXT:  .LBB78_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v6, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX908-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX908-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX908-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX908-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX908-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX908-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX908-NEXT:    v_add3_u32 v7, v7, v3, s8
; GFX908-NEXT:    v_add3_u32 v9, v9, v5, s8
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX908-NEXT:    v_cmp_u_f32_e64 s[4:5], v3, v3
; GFX908-NEXT:    v_cndmask_b32_e64 v3, v7, v8, s[4:5]
; GFX908-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; GFX908-NEXT:    v_perm_b32 v5, v5, v3, s9
; GFX908-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[5:6] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v6
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB78_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_ret_v2bf16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX8-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX8-NEXT:  .LBB78_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v6, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX8-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX8-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX8-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX8-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, v7, v3
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, v9, v5
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, 0x7fff, v7
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; GFX8-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX8-NEXT:    v_cmp_u_f32_e64 s[4:5], v3, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v7, v8, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX8-NEXT:    v_alignbit_b32 v5, v5, v3, 16
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[5:6] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v6
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB78_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v0, v3
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_ret_v2bf16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    flat_load_dword v5, v[0:1]
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v6, 1.0, v3
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX7-NEXT:  .LBB78_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v5
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v4
; GFX7-NEXT:    v_alignbit_b32 v3, v2, v3, 16
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v7
; GFX7-NEXT:    v_alignbit_b32 v2, v2, v6, 16
; GFX7-NEXT:    flat_atomic_cmpswap v6, v[0:1], v[2:3] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v3
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v6
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB78_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v0, v3
; GFX7-NEXT:    v_mov_b32_e32 v1, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr %ptr, <2 x bfloat> %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0, !amdgpu.no.remote.memory !0
  ret <2 x bfloat> %result
}

define void @flat_agent_atomic_fadd_noret_v2bf16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory(ptr %ptr, <2 x bfloat> %val) #0 {
; GFX12-LABEL: flat_agent_atomic_fadd_noret_v2bf16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_atomic_pk_add_bf16 v[0:1], v2 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: flat_agent_atomic_fadd_noret_v2bf16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    flat_atomic_pk_add_bf16 v[0:1], v2
; GFX940-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: flat_agent_atomic_fadd_noret_v2bf16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    flat_load_b32 v3, v[0:1]
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB79_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX11-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX11-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX11-NEXT:    v_bfe_u32 v8, v6, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX11-NEXT:    v_add3_u32 v8, v8, v6, 0x7fff
; GFX11-NEXT:    v_cmp_u_f32_e64 s0, v2, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v6, v8, v10, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v2, v7, v9, s0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_perm_b32 v2, v6, v2, 0x7060302
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    flat_atomic_cmpswap_b32 v2, v[0:1], v[2:3] glc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX11-NEXT:    v_mov_b32_e32 v3, v2
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB79_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_agent_atomic_fadd_noret_v2bf16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_load_dword v3, v[0:1]
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX10-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:  .LBB79_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX10-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX10-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX10-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX10-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX10-NEXT:    v_bfe_u32 v8, v6, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX10-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX10-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX10-NEXT:    v_add3_u32 v8, v8, v6, 0x7fff
; GFX10-NEXT:    v_cmp_u_f32_e64 s4, v2, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v6, v8, v10, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v7, v9, s4
; GFX10-NEXT:    v_perm_b32 v2, v6, v2, 0x7060302
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX10-NEXT:    v_mov_b32_e32 v3, v2
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB79_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: flat_agent_atomic_fadd_noret_v2bf16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    flat_load_dword v3, v[0:1]
; GFX90A-NEXT:    s_mov_b64 s[6:7], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX90A-NEXT:    s_movk_i32 s8, 0x7fff
; GFX90A-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX90A-NEXT:    s_mov_b32 s9, 0x7060302
; GFX90A-NEXT:  .LBB79_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX90A-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX90A-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX90A-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX90A-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX90A-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX90A-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX90A-NEXT:    v_add3_u32 v7, v7, v2, s8
; GFX90A-NEXT:    v_add3_u32 v9, v9, v6, s8
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX90A-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX90A-NEXT:    v_cndmask_b32_e64 v2, v7, v8, s[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; GFX90A-NEXT:    v_perm_b32 v2, v6, v2, s9
; GFX90A-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX90A-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execnz .LBB79_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: flat_agent_atomic_fadd_noret_v2bf16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    flat_load_dword v3, v[0:1]
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX908-NEXT:    s_movk_i32 s8, 0x7fff
; GFX908-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX908-NEXT:    s_mov_b32 s9, 0x7060302
; GFX908-NEXT:  .LBB79_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX908-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX908-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX908-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX908-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX908-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX908-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX908-NEXT:    v_add3_u32 v7, v7, v2, s8
; GFX908-NEXT:    v_add3_u32 v9, v9, v6, s8
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX908-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX908-NEXT:    v_cndmask_b32_e64 v2, v7, v8, s[4:5]
; GFX908-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; GFX908-NEXT:    v_perm_b32 v2, v6, v2, s9
; GFX908-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX908-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v3, v2
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB79_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: flat_agent_atomic_fadd_noret_v2bf16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX8-NEXT:  .LBB79_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX8-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX8-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX8-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX8-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX8-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, v7, v2
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, v9, v6
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, 0x7fff, v7
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; GFX8-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX8-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX8-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v7, v8, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; GFX8-NEXT:    v_alignbit_b32 v2, v6, v2, 16
; GFX8-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v3, v2
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB79_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: flat_agent_atomic_fadd_noret_v2bf16__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    flat_load_dword v5, v[0:1]
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:  .LBB79_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX7-NEXT:    v_mul_f32_e32 v5, 1.0, v5
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff0000, v4
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v5
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_alignbit_b32 v5, v4, v5, 16
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v7
; GFX7-NEXT:    v_alignbit_b32 v4, v4, v6, 16
; GFX7-NEXT:    flat_atomic_cmpswap v6, v[0:1], v[4:5] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v5
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v6
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v6
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB79_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
  %unused = atomicrmw fadd ptr %ptr, <2 x bfloat> %val syncscope("agent") seq_cst, !amdgpu.no.fine.grained.memory !0, !amdgpu.no.remote.memory !0
  ret void
}

attributes #0 = { nounwind }
attributes #1 = { nounwind "denormal-fp-math-f32"="preserve-sign,preserve-sign" }

!0 = !{}
