; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -passes=amdgpu-simplifylib %s | FileCheck %s

target datalayout = "e-p:64:64-p1:64:64-p2:32:32-p3:32:32-p4:64:64-p5:32:32-p6:32:32-p7:160:256:256:32-p8:128:128-i64:64-v16:16-v24:32-v32:32-v48:64-v96:128-v192:256-v256:256-v512:512-v1024:1024-v2048:2048-n32:64-S32-A5-G1-ni:7:8:9"

declare float @_Z5ldexpfi(float, i32)
declare <2 x float> @_Z5ldexpDv2_fDv2_i(<2 x float>, <2 x i32>)
declare <3 x float> @_Z5ldexpDv3_fDv3_i(<3 x float>, <3 x i32>)
declare <4 x float> @_Z5ldexpDv4_fDv4_i(<4 x float>, <4 x i32>)
declare <8 x float> @_Z5ldexpDv8_fDv8_i(<8 x float>, <8 x i32>)
declare <16 x float> @_Z5ldexpDv16_fDv16_i(<16 x float>, <16 x i32>)
declare double @_Z5ldexpdi(double, i32)
declare <2 x double> @_Z5ldexpDv2_dDv2_i(<2 x double>, <2 x i32>)
declare <3 x double> @_Z5ldexpDv3_dDv3_i(<3 x double>, <3 x i32>)
declare <4 x double> @_Z5ldexpDv4_dDv4_i(<4 x double>, <4 x i32>)
declare <8 x double> @_Z5ldexpDv8_dDv8_i(<8 x double>, <8 x i32>)
declare <16 x double> @_Z5ldexpDv16_dDv16_i(<16 x double>, <16 x i32>)
declare half @_Z5ldexpDhi(half, i32)
declare <2 x half> @_Z5ldexpDv2_DhDv2_i(<2 x half>, <2 x i32>)
declare <3 x half> @_Z5ldexpDv3_DhDv3_i(<3 x half>, <3 x i32>)
declare <4 x half> @_Z5ldexpDv4_DhDv4_i(<4 x half>, <4 x i32>)
declare <8 x half> @_Z5ldexpDv8_DhDv8_i(<8 x half>, <8 x i32>)
declare <16 x half> @_Z5ldexpDv16_DhDv16_i(<16 x half>, <16 x i32>)

define float @test_ldexp_f32(float %x, i32 %y) {
; CHECK-LABEL: define float @test_ldexp_f32
; CHECK-SAME: (float [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[LDEXP:%.*]] = tail call float @llvm.ldexp.f32.i32(float [[X]], i32 [[Y]])
; CHECK-NEXT:    ret float [[LDEXP]]
;
  %ldexp = tail call float @_Z5ldexpfi(float %x, i32 %y)
  ret float %ldexp
}

define float @test_ldexp_f32_fast(float %x, i32 %y) {
; CHECK-LABEL: define float @test_ldexp_f32_fast
; CHECK-SAME: (float [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[LDEXP:%.*]] = tail call fast float @llvm.ldexp.f32.i32(float [[X]], i32 [[Y]])
; CHECK-NEXT:    ret float [[LDEXP]]
;
  %ldexp = tail call fast float @_Z5ldexpfi(float %x, i32 %y)
  ret float %ldexp
}

define <2 x float> @test_ldexp_v2f32(<2 x float> %x, <2 x i32> %y) {
; CHECK-LABEL: define <2 x float> @test_ldexp_v2f32
; CHECK-SAME: (<2 x float> [[X:%.*]], <2 x i32> [[Y:%.*]]) {
; CHECK-NEXT:    [[LDEXP:%.*]] = tail call <2 x float> @llvm.ldexp.v2f32.v2i32(<2 x float> [[X]], <2 x i32> [[Y]])
; CHECK-NEXT:    ret <2 x float> [[LDEXP]]
;
  %ldexp = tail call <2 x float> @_Z5ldexpDv2_fDv2_i(<2 x float> %x, <2 x i32> %y)
  ret <2 x float> %ldexp
}

define <3 x float> @test_ldexp_v3f32(<3 x float> %x, <3 x i32> %y) {
; CHECK-LABEL: define <3 x float> @test_ldexp_v3f32
; CHECK-SAME: (<3 x float> [[X:%.*]], <3 x i32> [[Y:%.*]]) {
; CHECK-NEXT:    [[LDEXP:%.*]] = tail call <3 x float> @llvm.ldexp.v3f32.v3i32(<3 x float> [[X]], <3 x i32> [[Y]])
; CHECK-NEXT:    ret <3 x float> [[LDEXP]]
;
  %ldexp = tail call <3 x float> @_Z5ldexpDv3_fDv3_i(<3 x float> %x, <3 x i32> %y)
  ret <3 x float> %ldexp
}

define <4 x float> @test_ldexp_v4f32(<4 x float> %x, <4 x i32> %y) {
; CHECK-LABEL: define <4 x float> @test_ldexp_v4f32
; CHECK-SAME: (<4 x float> [[X:%.*]], <4 x i32> [[Y:%.*]]) {
; CHECK-NEXT:    [[LDEXP:%.*]] = tail call <4 x float> @llvm.ldexp.v4f32.v4i32(<4 x float> [[X]], <4 x i32> [[Y]])
; CHECK-NEXT:    ret <4 x float> [[LDEXP]]
;
  %ldexp = tail call <4 x float> @_Z5ldexpDv4_fDv4_i(<4 x float> %x, <4 x i32> %y)
  ret <4 x float> %ldexp
}

define <8 x float> @test_ldexp_v8f32(<8 x float> %x, <8 x i32> %y) {
; CHECK-LABEL: define <8 x float> @test_ldexp_v8f32
; CHECK-SAME: (<8 x float> [[X:%.*]], <8 x i32> [[Y:%.*]]) {
; CHECK-NEXT:    [[LDEXP:%.*]] = tail call <8 x float> @llvm.ldexp.v8f32.v8i32(<8 x float> [[X]], <8 x i32> [[Y]])
; CHECK-NEXT:    ret <8 x float> [[LDEXP]]
;
  %ldexp = tail call <8 x float> @_Z5ldexpDv8_fDv8_i(<8 x float> %x, <8 x i32> %y)
  ret <8 x float> %ldexp
}

define <16 x float> @test_ldexp_v16f32(<16 x float> %x, <16 x i32> %y) {
; CHECK-LABEL: define <16 x float> @test_ldexp_v16f32
; CHECK-SAME: (<16 x float> [[X:%.*]], <16 x i32> [[Y:%.*]]) {
; CHECK-NEXT:    [[LDEXP:%.*]] = tail call <16 x float> @llvm.ldexp.v16f32.v16i32(<16 x float> [[X]], <16 x i32> [[Y]])
; CHECK-NEXT:    ret <16 x float> [[LDEXP]]
;
  %ldexp = tail call <16 x float> @_Z5ldexpDv16_fDv16_i(<16 x float> %x, <16 x i32> %y)
  ret <16 x float> %ldexp
}

define double @test_ldexp_f64(double %x, i32 %y) {
; CHECK-LABEL: define double @test_ldexp_f64
; CHECK-SAME: (double [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[LDEXP:%.*]] = tail call double @llvm.ldexp.f64.i32(double [[X]], i32 [[Y]])
; CHECK-NEXT:    ret double [[LDEXP]]
;
  %ldexp = tail call double @_Z5ldexpdi(double %x, i32 %y)
  ret double %ldexp
}

define <2 x double> @test_ldexp_v2f64(<2 x double> %x, <2 x i32> %y) {
; CHECK-LABEL: define <2 x double> @test_ldexp_v2f64
; CHECK-SAME: (<2 x double> [[X:%.*]], <2 x i32> [[Y:%.*]]) {
; CHECK-NEXT:    [[LDEXP:%.*]] = tail call <2 x double> @llvm.ldexp.v2f64.v2i32(<2 x double> [[X]], <2 x i32> [[Y]])
; CHECK-NEXT:    ret <2 x double> [[LDEXP]]
;
  %ldexp = tail call <2 x double> @_Z5ldexpDv2_dDv2_i(<2 x double> %x, <2 x i32> %y)
  ret <2 x double> %ldexp
}

define <3 x double> @test_ldexp_v3f64(<3 x double> %x, <3 x i32> %y) {
; CHECK-LABEL: define <3 x double> @test_ldexp_v3f64
; CHECK-SAME: (<3 x double> [[X:%.*]], <3 x i32> [[Y:%.*]]) {
; CHECK-NEXT:    [[LDEXP:%.*]] = tail call <3 x double> @llvm.ldexp.v3f64.v3i32(<3 x double> [[X]], <3 x i32> [[Y]])
; CHECK-NEXT:    ret <3 x double> [[LDEXP]]
;
  %ldexp = tail call <3 x double> @_Z5ldexpDv3_dDv3_i(<3 x double> %x, <3 x i32> %y)
  ret <3 x double> %ldexp
}

define <4 x double> @test_ldexp_v4f64(<4 x double> %x, <4 x i32> %y) {
; CHECK-LABEL: define <4 x double> @test_ldexp_v4f64
; CHECK-SAME: (<4 x double> [[X:%.*]], <4 x i32> [[Y:%.*]]) {
; CHECK-NEXT:    [[LDEXP:%.*]] = tail call <4 x double> @llvm.ldexp.v4f64.v4i32(<4 x double> [[X]], <4 x i32> [[Y]])
; CHECK-NEXT:    ret <4 x double> [[LDEXP]]
;
  %ldexp = tail call <4 x double> @_Z5ldexpDv4_dDv4_i(<4 x double> %x, <4 x i32> %y)
  ret <4 x double> %ldexp
}

define <8 x double> @test_ldexp_v8f64(<8 x double> %x, <8 x i32> %y) {
; CHECK-LABEL: define <8 x double> @test_ldexp_v8f64
; CHECK-SAME: (<8 x double> [[X:%.*]], <8 x i32> [[Y:%.*]]) {
; CHECK-NEXT:    [[LDEXP:%.*]] = tail call <8 x double> @llvm.ldexp.v8f64.v8i32(<8 x double> [[X]], <8 x i32> [[Y]])
; CHECK-NEXT:    ret <8 x double> [[LDEXP]]
;
  %ldexp = tail call <8 x double> @_Z5ldexpDv8_dDv8_i(<8 x double> %x, <8 x i32> %y)
  ret <8 x double> %ldexp
}

define <16 x double> @test_ldexp_v16f64(<16 x double> %x, <16 x i32> %y) {
; CHECK-LABEL: define <16 x double> @test_ldexp_v16f64
; CHECK-SAME: (<16 x double> [[X:%.*]], <16 x i32> [[Y:%.*]]) {
; CHECK-NEXT:    [[LDEXP:%.*]] = tail call <16 x double> @llvm.ldexp.v16f64.v16i32(<16 x double> [[X]], <16 x i32> [[Y]])
; CHECK-NEXT:    ret <16 x double> [[LDEXP]]
;
  %ldexp = tail call <16 x double> @_Z5ldexpDv16_dDv16_i(<16 x double> %x, <16 x i32> %y)
  ret <16 x double> %ldexp
}

define half @test_ldexp_f16(half %x, i32 %y) {
; CHECK-LABEL: define half @test_ldexp_f16
; CHECK-SAME: (half [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[LDEXP:%.*]] = tail call half @llvm.ldexp.f16.i32(half [[X]], i32 [[Y]])
; CHECK-NEXT:    ret half [[LDEXP]]
;
  %ldexp = tail call half @_Z5ldexpDhi(half %x, i32 %y)
  ret half %ldexp
}

define <2 x half> @test_ldexp_v2f16(<2 x half> %x, <2 x i32> %y) {
; CHECK-LABEL: define <2 x half> @test_ldexp_v2f16
; CHECK-SAME: (<2 x half> [[X:%.*]], <2 x i32> [[Y:%.*]]) {
; CHECK-NEXT:    [[LDEXP:%.*]] = tail call <2 x half> @llvm.ldexp.v2f16.v2i32(<2 x half> [[X]], <2 x i32> [[Y]])
; CHECK-NEXT:    ret <2 x half> [[LDEXP]]
;
  %ldexp = tail call <2 x half> @_Z5ldexpDv2_DhDv2_i(<2 x half> %x, <2 x i32> %y)
  ret <2 x half> %ldexp
}

define <3 x half> @test_ldexp_v3f16(<3 x half> %x, <3 x i32> %y) {
; CHECK-LABEL: define <3 x half> @test_ldexp_v3f16
; CHECK-SAME: (<3 x half> [[X:%.*]], <3 x i32> [[Y:%.*]]) {
; CHECK-NEXT:    [[LDEXP:%.*]] = tail call <3 x half> @llvm.ldexp.v3f16.v3i32(<3 x half> [[X]], <3 x i32> [[Y]])
; CHECK-NEXT:    ret <3 x half> [[LDEXP]]
;
  %ldexp = tail call <3 x half> @_Z5ldexpDv3_DhDv3_i(<3 x half> %x, <3 x i32> %y)
  ret <3 x half> %ldexp
}

define <4 x half> @test_ldexp_v4f16(<4 x half> %x, <4 x i32> %y) {
; CHECK-LABEL: define <4 x half> @test_ldexp_v4f16
; CHECK-SAME: (<4 x half> [[X:%.*]], <4 x i32> [[Y:%.*]]) {
; CHECK-NEXT:    [[LDEXP:%.*]] = tail call <4 x half> @llvm.ldexp.v4f16.v4i32(<4 x half> [[X]], <4 x i32> [[Y]])
; CHECK-NEXT:    ret <4 x half> [[LDEXP]]
;
  %ldexp = tail call <4 x half> @_Z5ldexpDv4_DhDv4_i(<4 x half> %x, <4 x i32> %y)
  ret <4 x half> %ldexp
}

define <8 x half> @test_ldexp_v8f16(<8 x half> %x, <8 x i32> %y) {
; CHECK-LABEL: define <8 x half> @test_ldexp_v8f16
; CHECK-SAME: (<8 x half> [[X:%.*]], <8 x i32> [[Y:%.*]]) {
; CHECK-NEXT:    [[LDEXP:%.*]] = tail call <8 x half> @llvm.ldexp.v8f16.v8i32(<8 x half> [[X]], <8 x i32> [[Y]])
; CHECK-NEXT:    ret <8 x half> [[LDEXP]]
;
  %ldexp = tail call <8 x half> @_Z5ldexpDv8_DhDv8_i(<8 x half> %x, <8 x i32> %y)
  ret <8 x half> %ldexp
}

define <16 x half> @test_ldexp_v16f16(<16 x half> %x, <16 x i32> %y) {
; CHECK-LABEL: define <16 x half> @test_ldexp_v16f16
; CHECK-SAME: (<16 x half> [[X:%.*]], <16 x i32> [[Y:%.*]]) {
; CHECK-NEXT:    [[LDEXP:%.*]] = tail call <16 x half> @llvm.ldexp.v16f16.v16i32(<16 x half> [[X]], <16 x i32> [[Y]])
; CHECK-NEXT:    ret <16 x half> [[LDEXP]]
;
  %ldexp = tail call <16 x half> @_Z5ldexpDv16_DhDv16_i(<16 x half> %x, <16 x i32> %y)
  ret <16 x half> %ldexp
}

define float @test_ldexp_f32_minsize(float %x, i32 %y) #3 {
; CHECK-LABEL: define float @test_ldexp_f32_minsize
; CHECK-SAME: (float [[X:%.*]], i32 [[Y:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    [[LDEXP:%.*]] = tail call float @llvm.ldexp.f32.i32(float [[X]], i32 [[Y]])
; CHECK-NEXT:    ret float [[LDEXP]]
;
  %ldexp = tail call float @_Z5ldexpfi(float %x, i32 %y)
  ret float %ldexp
}

define float @test_ldexp_f32_nobuiltin(float %x, i32 %y) {
; CHECK-LABEL: define float @test_ldexp_f32_nobuiltin
; CHECK-SAME: (float [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[LDEXP:%.*]] = tail call float @_Z5ldexpfi(float [[X]], i32 [[Y]]) #[[ATTR3:[0-9]+]]
; CHECK-NEXT:    ret float [[LDEXP]]
;
  %ldexp = tail call float @_Z5ldexpfi(float %x, i32 %y) #0
  ret float %ldexp
}

define float @test_ldexp_f32_strictfp(float %x, i32 %y) #4 {
; CHECK-LABEL: define float @test_ldexp_f32_strictfp
; CHECK-SAME: (float [[X:%.*]], i32 [[Y:%.*]]) #[[ATTR1:[0-9]+]] {
; CHECK-NEXT:    [[LDEXP:%.*]] = tail call nnan float @_Z5ldexpfi(float [[X]], i32 [[Y]]) #[[ATTR1]]
; CHECK-NEXT:    ret float [[LDEXP]]
;
  %ldexp = tail call nnan float @_Z5ldexpfi(float %x, i32 %y) #4
  ret float %ldexp
}

;---------------------------------------------------------------------
; Invalid signatures
;---------------------------------------------------------------------

; Declared with wrong type, second argument is float
declare float @_Z5ldexpff(float noundef, float noundef)

define float @call_wrong_typed_ldexp_f32_second_arg(float %x, float %wrongtype) {
; CHECK-LABEL: define float @call_wrong_typed_ldexp_f32_second_arg
; CHECK-SAME: (float [[X:%.*]], float [[WRONGTYPE:%.*]]) {
; CHECK-NEXT:    [[CALL:%.*]] = call float @_Z5ldexpff(float [[X]], float [[WRONGTYPE]])
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @_Z5ldexpff(float %x, float %wrongtype)
  ret float %call
}

declare <2 x float> @_Z5ldexpDv2_fS_(<2 x float>, <2 x float>)

define <2 x float> @call_wrong_typed_ldexp_v2f32_second_arg(<2 x float> %x, <2 x float> %wrongtype) {
; CHECK-LABEL: define <2 x float> @call_wrong_typed_ldexp_v2f32_second_arg
; CHECK-SAME: (<2 x float> [[X:%.*]], <2 x float> [[WRONGTYPE:%.*]]) {
; CHECK-NEXT:    [[CALL:%.*]] = call <2 x float> @_Z5ldexpDv2_fS_(<2 x float> [[X]], <2 x float> [[WRONGTYPE]])
; CHECK-NEXT:    ret <2 x float> [[CALL]]
;
  %call = call <2 x float> @_Z5ldexpDv2_fS_(<2 x float> %x, <2 x float> %wrongtype)
  ret <2 x float> %call
}

declare <2 x float> @_Z5ldexpDv2_ff(<2 x float>, float)

define <2 x float> @call_wrong_typed_ldexp_v2f32_f32(<2 x float> %x, float %wrongtype) {
; CHECK-LABEL: define <2 x float> @call_wrong_typed_ldexp_v2f32_f32
; CHECK-SAME: (<2 x float> [[X:%.*]], float [[WRONGTYPE:%.*]]) {
; CHECK-NEXT:    [[CALL:%.*]] = call <2 x float> @_Z5ldexpDv2_ff(<2 x float> [[X]], float [[WRONGTYPE]])
; CHECK-NEXT:    ret <2 x float> [[CALL]]
;
  %call = call <2 x float> @_Z5ldexpDv2_ff(<2 x float> %x, float %wrongtype)
  ret <2 x float> %call
}

attributes #0 = { nobuiltin }
attributes #1 = { "no-builtins" }
attributes #2 = { nounwind memory(none) }
attributes #3 = { minsize }
attributes #4 = { strictfp }
