; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=constraint-elimination -S %s | FileCheck %s

target datalayout = "e-m:o-p270:32:32-p271:32:32-p272:64:64-i64:64-f80:128-n8:16:32:64-S128"


declare void @use(i8)
declare void @use.i1(i1)
declare void @llvm.assume(i1)
declare i1 @cond()

define void @test_iv_wraps_1(i8 %len.n, i8 %a) {
; CHECK-LABEL: @test_iv_wraps_1(
; CHECK-NEXT:  loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[IV:%.*]] = phi i8 [ -1, [[LOOP_PH:%.*]] ], [ [[IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq i8 [[IV]], 1
; CHECK-NEXT:    br i1 [[C]], label [[EXIT:%.*]], label [[LOOP_LATCH]]
; CHECK:       loop.latch:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge i8 [[IV]], -1
; CHECK-NEXT:    call void @use.i1(i1 [[T_1]])
; CHECK-NEXT:    [[IV_NEXT]] = add i8 [[IV]], 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
loop.ph:
  br label %loop.header

loop.header:
  %iv = phi i8 [ 255, %loop.ph ], [ %iv.next, %loop.latch ]
  %c = icmp eq i8 %iv, 1
  br i1 %c, label %exit, label %loop.latch

loop.latch:
  %t.1 = icmp uge i8 %iv, 255
  call void @use.i1(i1 %t.1)
  %iv.next = add i8 %iv, 1
  br label %loop.header

exit:
  ret void
}

define void @test_iv_nuw_nsw_1_uge_start(i8 %len.n, i8 %a) {
; CHECK-LABEL: @test_iv_nuw_nsw_1_uge_start(
; CHECK-NEXT:  loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[IV:%.*]] = phi i8 [ -1, [[LOOP_PH:%.*]] ], [ [[IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq i8 [[IV]], 1
; CHECK-NEXT:    br i1 [[C]], label [[EXIT:%.*]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[C_2:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C_2]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use.i1(i1 true)
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i8 [[IV]], 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
loop.ph:
  br label %loop.header

loop.header:
  %iv = phi i8 [ 255, %loop.ph ], [ %iv.next, %loop.latch ]
  %c = icmp eq i8 %iv, 1
  br i1 %c, label %exit, label %for.body

for.body:
  %c.2 = call i1 @cond()
  br i1 %c.2, label %loop.latch, label %exit

loop.latch:
  %t.1 = icmp uge i8 %iv, 255
  call void @use.i1(i1 %t.1)
  %iv.next = add nsw nuw i8 %iv, 1
  br label %loop.header

exit:
  ret void
}

define void @test_iv_nuw_nsw_2_uge_start(i8 %len.n, i8 %a) {
; CHECK-LABEL: @test_iv_nuw_nsw_2_uge_start(
; CHECK-NEXT:  loop.ph:
; CHECK-NEXT:    [[START:%.*]] = add i8 -2, 1
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[IV:%.*]] = phi i8 [ [[START]], [[LOOP_PH:%.*]] ], [ [[IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq i8 [[IV]], 1
; CHECK-NEXT:    br i1 [[C]], label [[EXIT:%.*]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[C_2:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C_2]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use.i1(i1 true)
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i8 [[IV]], 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
loop.ph:
  %start = add i8 254, 1
  br label %loop.header

loop.header:
  %iv = phi i8 [ %start, %loop.ph ], [ %iv.next, %loop.latch ]
  %c = icmp eq i8 %iv, 1
  br i1 %c, label %exit, label %for.body

for.body:
  %c.2 = call i1 @cond()
  br i1 %c.2, label %loop.latch, label %exit

loop.latch:
  %t.1 = icmp uge i8 %iv, 255
  call void @use.i1(i1 %t.1)
  %iv.next = add nsw nuw i8 %iv, 1
  br label %loop.header

exit:
  ret void
}

define void @test_iv_nsw_nuw_1_ult_end(i8 %len.n, i8 %a) {
; CHECK-LABEL: @test_iv_nsw_nuw_1_ult_end(
; CHECK-NEXT:  loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[IV:%.*]] = phi i8 [ -2, [[LOOP_PH:%.*]] ], [ [[IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq i8 [[IV]], 1
; CHECK-NEXT:    br i1 [[C]], label [[EXIT:%.*]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[C_2:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C_2]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use.i1(i1 false)
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i8 [[IV]], 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
loop.ph:
  br label %loop.header

loop.header:
  %iv = phi i8 [ 254, %loop.ph ], [ %iv.next, %loop.latch ]
  %c = icmp eq i8 %iv, 1
  br i1 %c, label %exit, label %for.body

for.body:
  %c.2 = call i1 @cond()
  br i1 %c.2, label %loop.latch, label %exit

loop.latch:
  %t.1 = icmp ult i8 %iv, 1
  call void @use.i1(i1 %t.1)
  %iv.next = add nsw nuw i8 %iv, 1
  br label %loop.header

exit:
  ret void
}


define void @test_iv_nsw_nuw_2_ult_end(i8 %len.n, i8 %a, i8 %b) {
; CHECK-LABEL: @test_iv_nsw_nuw_2_ult_end(
; CHECK-NEXT:  loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[IV:%.*]] = phi i8 [ [[A:%.*]], [[LOOP_PH:%.*]] ], [ [[IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq i8 [[IV]], [[B:%.*]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT:%.*]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[C_2:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C_2]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    [[T_1:%.*]] = icmp ult i8 [[IV]], [[B]]
; CHECK-NEXT:    call void @use.i1(i1 [[T_1]])
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i8 [[IV]], 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
loop.ph:
  br label %loop.header

loop.header:
  %iv = phi i8 [ %a, %loop.ph ], [ %iv.next, %loop.latch ]
  %c = icmp eq i8 %iv, %b
  br i1 %c, label %exit, label %for.body

for.body:
  %c.2 = call i1 @cond()
  br i1 %c.2, label %loop.latch, label %exit

loop.latch:
  %t.1 = icmp ult i8 %iv, %b
  call void @use.i1(i1 %t.1)
  %iv.next = add nsw nuw i8 %iv, 1
  br label %loop.header

exit:
  ret void
}

define void @test_iv_nsw_nuw_3_ult_start_var(i8 %len.n, i8 %a, i8 %b) {
; CHECK-LABEL: @test_iv_nsw_nuw_3_ult_start_var(
; CHECK-NEXT:  loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[IV:%.*]] = phi i8 [ [[A:%.*]], [[LOOP_PH:%.*]] ], [ [[IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq i8 [[IV]], [[B:%.*]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT:%.*]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[C_2:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C_2]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use.i1(i1 false)
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i8 [[IV]], 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
loop.ph:
  br label %loop.header

loop.header:
  %iv = phi i8 [ %a, %loop.ph ], [ %iv.next, %loop.latch ]
  %c = icmp eq i8 %iv, %b
  br i1 %c, label %exit, label %for.body

for.body:
  %c.2 = call i1 @cond()
  br i1 %c.2, label %loop.latch, label %exit

loop.latch:
  %t.1 = icmp ult i8 %iv, %a
  call void @use.i1(i1 %t.1)
  %iv.next = add nsw nuw i8 %iv, 1
  br label %loop.header

exit:
  ret void
}

define void @test_iv_nsw_nuw_inc_2_ult_start_var(i8 %len.n, i8 %a, i8 %b) {
; CHECK-LABEL: @test_iv_nsw_nuw_inc_2_ult_start_var(
; CHECK-NEXT:  loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[IV:%.*]] = phi i8 [ [[A:%.*]], [[LOOP_PH:%.*]] ], [ [[IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq i8 [[IV]], [[B:%.*]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT:%.*]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[C_2:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C_2]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use.i1(i1 false)
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i8 [[IV]], 2
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
loop.ph:
  br label %loop.header

loop.header:
  %iv = phi i8 [ %a, %loop.ph ], [ %iv.next, %loop.latch ]
  %c = icmp eq i8 %iv, %b
  br i1 %c, label %exit, label %for.body

for.body:
  %c.2 = call i1 @cond()
  br i1 %c.2, label %loop.latch, label %exit

loop.latch:
  %t.1 = icmp ult i8 %iv, %a
  call void @use.i1(i1 %t.1)
  %iv.next = add nsw nuw i8 %iv, 2
  br label %loop.header

exit:
  ret void
}
