; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -verify-machineinstrs -show-mc-encoding | FileCheck %s

target triple = "x86_64-unknown-unknown"

@g64 = external dso_local global i64, align 8
@g32 = external dso_local global i32, align 4
@g16 = external dso_local global i16, align 2
@g8 = external dso_local global i8, align 1

declare dso_local void @a()
declare dso_local void @b()

define void @add64_imm32_br() nounwind {
; CHECK-LABEL: add64_imm32_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addq $16777214, g64(%rip) # encoding: [0x48,0x81,0x05,A,A,A,A,0xfe,0xff,0xff,0x00]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-8, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0xFFFFFE
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, ptr @g64
  ; Add 0x00FFFFFE, a positive immediate requiring 24-bits.
  %add = add i64 %load1, 16777214
  store i64 %add, ptr @g64
  %cond = icmp slt i64 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add64_sext_imm32_br() nounwind {
; CHECK-LABEL: add64_sext_imm32_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addq $-2147483648, g64(%rip) # encoding: [0x48,0x81,0x05,A,A,A,A,0x00,0x00,0x00,0x80]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-8, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0x80000000
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, ptr @g64
  ; Add -0x80000000, which requires sign-extended 32 bits.
  %add = add i64 %load1, -2147483648
  store i64 %add, ptr @g64
  %cond = icmp slt i64 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add64_imm32_via_sub_br() nounwind {
; CHECK-LABEL: add64_imm32_via_sub_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subq $-2147483648, g64(%rip) # encoding: [0x48,0x81,0x2d,A,A,A,A,0x00,0x00,0x00,0x80]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-8, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0x80000000
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, ptr @g64
  ; Add 0x80000000, which cannot fit in a sign extended 32-bit immediate. This
  ; get's folded because we can instead subtract -0x80000000.
  %add = add i64 %load1, 2147483648
  store i64 %add, ptr @g64
  %cond = icmp slt i64 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add64_no_imm32_via_sub_due_to_cf_br() nounwind {
; CHECK-LABEL: add64_no_imm32_via_sub_due_to_cf_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl $2147483648, %eax # encoding: [0xb8,0x00,0x00,0x00,0x80]
; CHECK-NEXT:    # imm = 0x80000000
; CHECK-NEXT:    addq %rax, g64(%rip) # encoding: [0x48,0x01,0x05,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    jae b # TAILCALL
; CHECK-NEXT:    # encoding: [0x73,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, ptr @g64
  ; Add 0x80000000, which cannot fit in a sign extended 32-bit immediate, but
  ; could in theory be folded into an immediate operand of a sub. However, we
  ; use the CF flag here and so shouldn't make that transformation.
  %add = add i64 %load1, 2147483648
  store i64 %add, ptr @g64
  %cond = icmp ult i64 %add, 2147483648
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add64_too_large_imm32_br() nounwind {
; CHECK-LABEL: add64_too_large_imm32_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl $2147483649, %eax # encoding: [0xb8,0x01,0x00,0x00,0x80]
; CHECK-NEXT:    # imm = 0x80000001
; CHECK-NEXT:    addq %rax, g64(%rip) # encoding: [0x48,0x01,0x05,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, ptr @g64
  ; Add 0x80000001, which cannot fit in a sign extended 32-bit immediate. This
  ; should not get folded into an immediate.
  %add = add i64 %load1, 2147483649
  store i64 %add, ptr @g64
  %cond = icmp slt i64 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add64_imm8_via_sub_br() nounwind {
; CHECK-LABEL: add64_imm8_via_sub_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subq $-128, g64(%rip) # encoding: [0x48,0x83,0x2d,A,A,A,A,0x80]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, ptr @g64
  ; Add 0x80 which can't quite fit into an imm8 because it would be sign
  ; extended, but which can fit if we convert to a sub and negate the value.
  %add = add i64 %load1, 128
  store i64 %add, ptr @g64
  %cond = icmp slt i64 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add64_imm8_br() nounwind {
; CHECK-LABEL: add64_imm8_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addq $42, g64(%rip) # encoding: [0x48,0x83,0x05,A,A,A,A,0x2a]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, ptr @g64
  %add = add i64 %load1, 42
  store i64 %add, ptr @g64
  %cond = icmp slt i64 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add64_imm8_neg_br() nounwind {
; CHECK-LABEL: add64_imm8_neg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addq $-42, g64(%rip) # encoding: [0x48,0x83,0x05,A,A,A,A,0xd6]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, ptr @g64
  %add = add i64 %load1, -42
  store i64 %add, ptr @g64
  %cond = icmp slt i64 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add32_imm_br() nounwind {
; CHECK-LABEL: add32_imm_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl $-2147483648, g32(%rip) # encoding: [0x81,0x05,A,A,A,A,0x00,0x00,0x00,0x80]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-8, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0x80000000
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, ptr @g32
  ; Add 0x80000000, a positive number requiring 32 bits of immediate.
  %add = add i32 %load1, 2147483648
  store i32 %add, ptr @g32
  %cond = icmp slt i32 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add32_imm8_br() nounwind {
; CHECK-LABEL: add32_imm8_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl $42, g32(%rip) # encoding: [0x83,0x05,A,A,A,A,0x2a]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, ptr @g32
  %add = add i32 %load1, 42
  store i32 %add, ptr @g32
  %cond = icmp slt i32 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add32_imm8_neg_br() nounwind {
; CHECK-LABEL: add32_imm8_neg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl $-42, g32(%rip) # encoding: [0x83,0x05,A,A,A,A,0xd6]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, ptr @g32
  %add = add i32 %load1, -42
  store i32 %add, ptr @g32
  %cond = icmp slt i32 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add16_imm_br() nounwind {
; CHECK-LABEL: add16_imm_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addw $-32768, g16(%rip) # encoding: [0x66,0x81,0x05,A,A,A,A,0x00,0x80]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-6, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0x8000
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, ptr @g16
  ; Add 0x8000, a positive number requiring 16 bits of immediate.
  %add = add i16 %load1, 32768
  store i16 %add, ptr @g16
  %cond = icmp slt i16 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add16_imm8_br() nounwind {
; CHECK-LABEL: add16_imm8_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addw $42, g16(%rip) # encoding: [0x66,0x83,0x05,A,A,A,A,0x2a]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, ptr @g16
  %add = add i16 %load1, 42
  store i16 %add, ptr @g16
  %cond = icmp slt i16 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add16_imm8_neg_br() nounwind {
; CHECK-LABEL: add16_imm8_neg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addw $-42, g16(%rip) # encoding: [0x66,0x83,0x05,A,A,A,A,0xd6]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, ptr @g16
  %add = add i16 %load1, -42
  store i16 %add, ptr @g16
  %cond = icmp slt i16 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add8_imm_br() nounwind {
; CHECK-LABEL: add8_imm_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addb $-2, g8(%rip) # encoding: [0x80,0x05,A,A,A,A,0xfe]
; CHECK-NEXT:    # fixup A - offset: 2, value: g8-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i8, ptr @g8
  %add = add i8 %load1, -2
  store i8 %add, ptr @g8
  %cond = icmp slt i8 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add64_reg_br(i64 %arg) nounwind {
; CHECK-LABEL: add64_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addq %rdi, g64(%rip) # encoding: [0x48,0x01,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, ptr @g64
  %add = add i64 %load1, %arg
  store i64 %add, ptr @g64
  %cond = icmp slt i64 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add32_reg_br(i32 %arg) nounwind {
; CHECK-LABEL: add32_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl %edi, g32(%rip) # encoding: [0x01,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, ptr @g32
  %add = add i32 %load1, %arg
  store i32 %add, ptr @g32
  %cond = icmp slt i32 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add16_reg_br(i16 %arg) nounwind {
; CHECK-LABEL: add16_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addw %di, g16(%rip) # encoding: [0x66,0x01,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, ptr @g16
  %add = add i16 %load1, %arg
  store i16 %add, ptr @g16
  %cond = icmp slt i16 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @add8_reg_br(i8 %arg) nounwind {
; CHECK-LABEL: add8_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addb %dil, g8(%rip) # encoding: [0x40,0x00,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g8-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i8, ptr @g8
  %add = add i8 %load1, %arg
  store i8 %add, ptr @g8
  %cond = icmp slt i8 %add, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @sub64_imm32_br() nounwind {
; CHECK-LABEL: sub64_imm32_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subq $-2147483648, g64(%rip) # encoding: [0x48,0x81,0x2d,A,A,A,A,0x00,0x00,0x00,0x80]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-8, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0x80000000
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, ptr @g64
  ; Subtract -0x80000000, which can't be negated into a sign-extended 32-bit
  ; immediate, so that we have to select sub here.
  %sub = sub i64 %load1, -2147483648
  store i64 %sub, ptr @g64
  %cond = icmp slt i64 %sub, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @sub64_too_large_imm32_br() nounwind {
; CHECK-LABEL: sub64_too_large_imm32_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movabsq $-4294967295, %rax # encoding: [0x48,0xb8,0x01,0x00,0x00,0x00,0xff,0xff,0xff,0xff]
; CHECK-NEXT:    # imm = 0xFFFFFFFF00000001
; CHECK-NEXT:    addq %rax, g64(%rip) # encoding: [0x48,0x01,0x05,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, ptr @g64
  ; Subtract 0xFFFFFFFF, which cannot fit in a sign extended 32-bit immediate,
  ; even if negated and sign extended as an add.
  %sub = sub i64 %load1, 4294967295
  store i64 %sub, ptr @g64
  %cond = icmp slt i64 %sub, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @sub64_imm8_br() nounwind {
; CHECK-LABEL: sub64_imm8_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subq $-128, g64(%rip) # encoding: [0x48,0x83,0x2d,A,A,A,A,0x80]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, ptr @g64
  ; Subtract -0x80, which can be done with an 8-bit immediate but only as
  ; a subtract where that immediate can be negative.
  %sub = sub i64 %load1, -128
  store i64 %sub, ptr @g64
  %cond = icmp slt i64 %sub, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @sub32_imm_br() nounwind {
; CHECK-LABEL: sub32_imm_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl $-2147483648, g32(%rip) # encoding: [0x81,0x05,A,A,A,A,0x00,0x00,0x00,0x80]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-8, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0x80000000
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, ptr @g32
  ; Subtract -0x80000000, which requires 32 bits of immediate but still gets
  ; lowered as an add.
  %sub = sub i32 %load1, -2147483648
  store i32 %sub, ptr @g32
  %cond = icmp slt i32 %sub, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @sub32_imm8_br() nounwind {
; CHECK-LABEL: sub32_imm8_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subl $-128, g32(%rip) # encoding: [0x83,0x2d,A,A,A,A,0x80]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, ptr @g32
  ; Subtract -0x80, which can be done with an 8-bit immediate but only as
  ; a subtract where that immediate can be negative.
  %sub = sub i32 %load1, -128
  store i32 %sub, ptr @g32
  %cond = icmp slt i32 %sub, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @sub16_imm_br() nounwind {
; CHECK-LABEL: sub16_imm_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addw $-32768, g16(%rip) # encoding: [0x66,0x81,0x05,A,A,A,A,0x00,0x80]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-6, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0x8000
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, ptr @g16
  ; Subtract -0x8000, which requires a 16 bits of immediate but still gets
  ; lowered as an add.
  %sub = sub i16 %load1, -32768
  store i16 %sub, ptr @g16
  %cond = icmp slt i16 %sub, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @sub16_imm8_br() nounwind {
; CHECK-LABEL: sub16_imm8_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subw $-128, g16(%rip) # encoding: [0x66,0x83,0x2d,A,A,A,A,0x80]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, ptr @g16
  ; Subtract -0x80, which can be done with an 8-bit immediate but only as
  ; a subtract where that immediate can be negative.
  %sub = sub i16 %load1, -128
  store i16 %sub, ptr @g16
  %cond = icmp slt i16 %sub, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @sub8_imm_br() nounwind {
; CHECK-LABEL: sub8_imm_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addb $-128, g8(%rip) # encoding: [0x80,0x05,A,A,A,A,0x80]
; CHECK-NEXT:    # fixup A - offset: 2, value: g8-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i8, ptr @g8
  ; Subtract -0x80, which requires an 8-bit immediate but still gets lowered as
  ; an add.
  %sub = sub i8 %load1, -128
  store i8 %sub, ptr @g8
  %cond = icmp slt i8 %sub, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @sub64_reg_br(i64 %arg) nounwind {
; CHECK-LABEL: sub64_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subq %rdi, g64(%rip) # encoding: [0x48,0x29,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, ptr @g64
  %sub = sub i64 %load1, %arg
  store i64 %sub, ptr @g64
  %cond = icmp slt i64 %sub, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @sub32_reg_br(i32 %arg) nounwind {
; CHECK-LABEL: sub32_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subl %edi, g32(%rip) # encoding: [0x29,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, ptr @g32
  %sub = sub i32 %load1, %arg
  store i32 %sub, ptr @g32
  %cond = icmp slt i32 %sub, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @sub16_reg_br(i16 %arg) nounwind {
; CHECK-LABEL: sub16_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subw %di, g16(%rip) # encoding: [0x66,0x29,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, ptr @g16
  %sub = sub i16 %load1, %arg
  store i16 %sub, ptr @g16
  %cond = icmp slt i16 %sub, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @sub8_reg_br(i8 %arg) nounwind {
; CHECK-LABEL: sub8_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subb %dil, g8(%rip) # encoding: [0x40,0x28,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g8-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i8, ptr @g8
  %sub = sub i8 %load1, %arg
  store i8 %sub, ptr @g8
  %cond = icmp slt i8 %sub, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @and64_imm32_br() nounwind {
; CHECK-LABEL: and64_imm32_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andq $16777215, g64(%rip) # encoding: [0x48,0x81,0x25,A,A,A,A,0xff,0xff,0xff,0x00]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-8, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0xFFFFFF
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, ptr @g64
  ; And 0x00FFFFFF, a positive immediate requiring 24-bits.
  %and = and i64 %load1, 16777215
  store i64 %and, ptr @g64
  %cond = icmp eq i64 %and, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @and64_sext_imm32_br() nounwind {
; CHECK-LABEL: and64_sext_imm32_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andq $-2147483648, g64(%rip) # encoding: [0x48,0x81,0x25,A,A,A,A,0x00,0x00,0x00,0x80]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-8, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0x80000000
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, ptr @g64
  ; And -0x80000000, which requires sign-extended 32 bits.
  %and = and i64 %load1, -2147483648
  store i64 %and, ptr @g64
  %cond = icmp eq i64 %and, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @and64_imm8_br() nounwind {
; CHECK-LABEL: and64_imm8_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andq $15, g64(%rip) # encoding: [0x48,0x83,0x25,A,A,A,A,0x0f]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, ptr @g64
  %and = and i64 %load1, 15
  store i64 %and, ptr @g64
  %cond = icmp eq i64 %and, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @and64_imm8_neg_br() nounwind {
; CHECK-LABEL: and64_imm8_neg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andq $-4, g64(%rip) # encoding: [0x48,0x83,0x25,A,A,A,A,0xfc]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, ptr @g64
  %and = and i64 %load1, -4
  store i64 %and, ptr @g64
  %cond = icmp eq i64 %and, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @and32_imm_br() nounwind {
; CHECK-LABEL: and32_imm_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andl $-2147483648, g32(%rip) # encoding: [0x81,0x25,A,A,A,A,0x00,0x00,0x00,0x80]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-8, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0x80000000
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, ptr @g32
  ; And 0x80000000, a positive number requiring 32 bits of immediate.
  %and = and i32 %load1, 2147483648
  store i32 %and, ptr @g32
  %cond = icmp eq i32 %and, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @and32_imm8_br() nounwind {
; CHECK-LABEL: and32_imm8_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andl $15, g32(%rip) # encoding: [0x83,0x25,A,A,A,A,0x0f]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, ptr @g32
  %and = and i32 %load1, 15
  store i32 %and, ptr @g32
  %cond = icmp eq i32 %and, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @and32_imm8_neg_br() nounwind {
; CHECK-LABEL: and32_imm8_neg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andl $-4, g32(%rip) # encoding: [0x83,0x25,A,A,A,A,0xfc]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, ptr @g32
  %and = and i32 %load1, -4
  store i32 %and, ptr @g32
  %cond = icmp eq i32 %and, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @and16_imm_br() nounwind {
; CHECK-LABEL: and16_imm_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andw $-32768, g16(%rip) # encoding: [0x66,0x81,0x25,A,A,A,A,0x00,0x80]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-6, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0x8000
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, ptr @g16
  %and = and i16 %load1, 32768
  store i16 %and, ptr @g16
  %cond = icmp eq i16 %and, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @and16_imm8_br() nounwind {
; CHECK-LABEL: and16_imm8_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andw $15, g16(%rip) # encoding: [0x66,0x83,0x25,A,A,A,A,0x0f]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, ptr @g16
  %and = and i16 %load1, 15
  store i16 %and, ptr @g16
  %cond = icmp eq i16 %and, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @and16_imm8_neg_br() nounwind {
; CHECK-LABEL: and16_imm8_neg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andw $-4, g16(%rip) # encoding: [0x66,0x83,0x25,A,A,A,A,0xfc]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, ptr @g16
  %and = and i16 %load1, -4
  store i16 %and, ptr @g16
  %cond = icmp eq i16 %and, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @and8_imm_br() nounwind {
; CHECK-LABEL: and8_imm_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andb $-4, g8(%rip) # encoding: [0x80,0x25,A,A,A,A,0xfc]
; CHECK-NEXT:    # fixup A - offset: 2, value: g8-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i8, ptr @g8
  %and = and i8 %load1, -4
  store i8 %and, ptr @g8
  %cond = icmp eq i8 %and, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @and64_reg_br(i64 %arg) nounwind {
; CHECK-LABEL: and64_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andq %rdi, g64(%rip) # encoding: [0x48,0x21,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, ptr @g64
  %and = and i64 %load1, %arg
  store i64 %and, ptr @g64
  %cond = icmp eq i64 %and, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @and32_reg_br(i32 %arg) nounwind {
; CHECK-LABEL: and32_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andl %edi, g32(%rip) # encoding: [0x21,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, ptr @g32
  %and = and i32 %load1, %arg
  store i32 %and, ptr @g32
  %cond = icmp eq i32 %and, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @and16_reg_br(i16 %arg) nounwind {
; CHECK-LABEL: and16_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andw %di, g16(%rip) # encoding: [0x66,0x21,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, ptr @g16
  %and = and i16 %load1, %arg
  store i16 %and, ptr @g16
  %cond = icmp eq i16 %and, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @and8_reg_br(i8 %arg) nounwind {
; CHECK-LABEL: and8_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andb %dil, g8(%rip) # encoding: [0x40,0x20,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g8-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i8, ptr @g8
  %and = and i8 %load1, %arg
  store i8 %and, ptr @g8
  %cond = icmp eq i8 %and, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @or64_imm32_br() nounwind {
; CHECK-LABEL: or64_imm32_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    orq $16777215, g64(%rip) # encoding: [0x48,0x81,0x0d,A,A,A,A,0xff,0xff,0xff,0x00]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-8, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0xFFFFFF
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, ptr @g64
  ; Or 0x00FFFFFF, a positive immediate requiring 24-bits.
  %or = or i64 %load1, 16777215
  store i64 %or, ptr @g64
  %cond = icmp eq i64 %or, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @or64_sext_imm32_br() nounwind {
; CHECK-LABEL: or64_sext_imm32_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    orq $-2147483648, g64(%rip) # encoding: [0x48,0x81,0x0d,A,A,A,A,0x00,0x00,0x00,0x80]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-8, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0x80000000
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, ptr @g64
  ; Or -0x80000000, which requires sign-extended 32 bits.
  %or = or i64 %load1, -2147483648
  store i64 %or, ptr @g64
  %cond = icmp eq i64 %or, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @or64_imm8_br() nounwind {
; CHECK-LABEL: or64_imm8_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    orq $15, g64(%rip) # encoding: [0x48,0x83,0x0d,A,A,A,A,0x0f]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, ptr @g64
  %or = or i64 %load1, 15
  store i64 %or, ptr @g64
  %cond = icmp eq i64 %or, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @or64_imm8_neg_br() nounwind {
; CHECK-LABEL: or64_imm8_neg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    orq $-4, g64(%rip) # encoding: [0x48,0x83,0x0d,A,A,A,A,0xfc]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, ptr @g64
  %or = or i64 %load1, -4
  store i64 %or, ptr @g64
  %cond = icmp eq i64 %or, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @or32_imm_br() nounwind {
; CHECK-LABEL: or32_imm_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    orl $-2147483648, g32(%rip) # encoding: [0x81,0x0d,A,A,A,A,0x00,0x00,0x00,0x80]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-8, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0x80000000
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, ptr @g32
  ; Or 0x80000000, a positive number requiring 32 bits of immediate.
  %or = or i32 %load1, 2147483648
  store i32 %or, ptr @g32
  %cond = icmp eq i32 %or, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @or32_imm8_br() nounwind {
; CHECK-LABEL: or32_imm8_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    orl $15, g32(%rip) # encoding: [0x83,0x0d,A,A,A,A,0x0f]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, ptr @g32
  %or = or i32 %load1, 15
  store i32 %or, ptr @g32
  %cond = icmp eq i32 %or, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @or32_imm8_neg_br() nounwind {
; CHECK-LABEL: or32_imm8_neg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    orl $-4, g32(%rip) # encoding: [0x83,0x0d,A,A,A,A,0xfc]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, ptr @g32
  %or = or i32 %load1, -4
  store i32 %or, ptr @g32
  %cond = icmp eq i32 %or, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @or16_imm_br() nounwind {
; CHECK-LABEL: or16_imm_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    orw $-32768, g16(%rip) # encoding: [0x66,0x81,0x0d,A,A,A,A,0x00,0x80]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-6, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0x8000
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, ptr @g16
  %or = or i16 %load1, 32768
  store i16 %or, ptr @g16
  %cond = icmp eq i16 %or, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @or16_imm8_br() nounwind {
; CHECK-LABEL: or16_imm8_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    orw $15, g16(%rip) # encoding: [0x66,0x83,0x0d,A,A,A,A,0x0f]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, ptr @g16
  %or = or i16 %load1, 15
  store i16 %or, ptr @g16
  %cond = icmp eq i16 %or, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @or16_imm8_neg_br() nounwind {
; CHECK-LABEL: or16_imm8_neg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    orw $-4, g16(%rip) # encoding: [0x66,0x83,0x0d,A,A,A,A,0xfc]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, ptr @g16
  %or = or i16 %load1, -4
  store i16 %or, ptr @g16
  %cond = icmp eq i16 %or, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @or8_imm_br() nounwind {
; CHECK-LABEL: or8_imm_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    orb $-4, g8(%rip) # encoding: [0x80,0x0d,A,A,A,A,0xfc]
; CHECK-NEXT:    # fixup A - offset: 2, value: g8-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i8, ptr @g8
  %or = or i8 %load1, -4
  store i8 %or, ptr @g8
  %cond = icmp eq i8 %or, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @or64_reg_br(i64 %arg) nounwind {
; CHECK-LABEL: or64_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    orq %rdi, g64(%rip) # encoding: [0x48,0x09,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, ptr @g64
  %or = or i64 %load1, %arg
  store i64 %or, ptr @g64
  %cond = icmp eq i64 %or, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @or32_reg_br(i32 %arg) nounwind {
; CHECK-LABEL: or32_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    orl %edi, g32(%rip) # encoding: [0x09,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, ptr @g32
  %or = or i32 %load1, %arg
  store i32 %or, ptr @g32
  %cond = icmp eq i32 %or, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @or16_reg_br(i16 %arg) nounwind {
; CHECK-LABEL: or16_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    orw %di, g16(%rip) # encoding: [0x66,0x09,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, ptr @g16
  %or = or i16 %load1, %arg
  store i16 %or, ptr @g16
  %cond = icmp eq i16 %or, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @or8_reg_br(i8 %arg) nounwind {
; CHECK-LABEL: or8_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    orb %dil, g8(%rip) # encoding: [0x40,0x08,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g8-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i8, ptr @g8
  %or = or i8 %load1, %arg
  store i8 %or, ptr @g8
  %cond = icmp eq i8 %or, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @xor64_imm32_br() nounwind {
; CHECK-LABEL: xor64_imm32_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorq $16777215, g64(%rip) # encoding: [0x48,0x81,0x35,A,A,A,A,0xff,0xff,0xff,0x00]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-8, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0xFFFFFF
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, ptr @g64
  ; Xor 0x00FFFFFF, a positive immediate requiring 24-bits.
  %xor = xor i64 %load1, 16777215
  store i64 %xor, ptr @g64
  %cond = icmp eq i64 %xor, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @xor64_sext_imm32_br() nounwind {
; CHECK-LABEL: xor64_sext_imm32_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorq $-2147483648, g64(%rip) # encoding: [0x48,0x81,0x35,A,A,A,A,0x00,0x00,0x00,0x80]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-8, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0x80000000
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, ptr @g64
  ; Xor -0x80000000, which requires sign-extended 32 bits.
  %xor = xor i64 %load1, -2147483648
  store i64 %xor, ptr @g64
  %cond = icmp eq i64 %xor, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @xor64_imm8_br() nounwind {
; CHECK-LABEL: xor64_imm8_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorq $15, g64(%rip) # encoding: [0x48,0x83,0x35,A,A,A,A,0x0f]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, ptr @g64
  %xor = xor i64 %load1, 15
  store i64 %xor, ptr @g64
  %cond = icmp eq i64 %xor, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @xor64_imm8_neg_br() nounwind {
; CHECK-LABEL: xor64_imm8_neg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorq $-4, g64(%rip) # encoding: [0x48,0x83,0x35,A,A,A,A,0xfc]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, ptr @g64
  %xor = xor i64 %load1, -4
  store i64 %xor, ptr @g64
  %cond = icmp eq i64 %xor, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @xor32_imm_br() nounwind {
; CHECK-LABEL: xor32_imm_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl $-2147483648, g32(%rip) # encoding: [0x81,0x35,A,A,A,A,0x00,0x00,0x00,0x80]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-8, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0x80000000
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, ptr @g32
  ; Xor 0x80000000, a positive number requiring 32 bits of immediate.
  %xor = xor i32 %load1, 2147483648
  store i32 %xor, ptr @g32
  %cond = icmp eq i32 %xor, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @xor32_imm8_br() nounwind {
; CHECK-LABEL: xor32_imm8_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl $15, g32(%rip) # encoding: [0x83,0x35,A,A,A,A,0x0f]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, ptr @g32
  %xor = xor i32 %load1, 15
  store i32 %xor, ptr @g32
  %cond = icmp eq i32 %xor, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @xor32_imm8_neg_br() nounwind {
; CHECK-LABEL: xor32_imm8_neg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl $-4, g32(%rip) # encoding: [0x83,0x35,A,A,A,A,0xfc]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, ptr @g32
  %xor = xor i32 %load1, -4
  store i32 %xor, ptr @g32
  %cond = icmp eq i32 %xor, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @xor16_imm_br() nounwind {
; CHECK-LABEL: xor16_imm_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorw $-32768, g16(%rip) # encoding: [0x66,0x81,0x35,A,A,A,A,0x00,0x80]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-6, kind: reloc_riprel_4byte
; CHECK-NEXT:    # imm = 0x8000
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, ptr @g16
  %xor = xor i16 %load1, 32768
  store i16 %xor, ptr @g16
  %cond = icmp eq i16 %xor, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @xor16_imm8_br() nounwind {
; CHECK-LABEL: xor16_imm8_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorw $15, g16(%rip) # encoding: [0x66,0x83,0x35,A,A,A,A,0x0f]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, ptr @g16
  %xor = xor i16 %load1, 15
  store i16 %xor, ptr @g16
  %cond = icmp eq i16 %xor, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @xor16_imm8_neg_br() nounwind {
; CHECK-LABEL: xor16_imm8_neg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorw $-4, g16(%rip) # encoding: [0x66,0x83,0x35,A,A,A,A,0xfc]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, ptr @g16
  %xor = xor i16 %load1, -4
  store i16 %xor, ptr @g16
  %cond = icmp eq i16 %xor, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @xor8_imm_br() nounwind {
; CHECK-LABEL: xor8_imm_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorb $-4, g8(%rip) # encoding: [0x80,0x35,A,A,A,A,0xfc]
; CHECK-NEXT:    # fixup A - offset: 2, value: g8-5, kind: reloc_riprel_4byte
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i8, ptr @g8
  %xor = xor i8 %load1, -4
  store i8 %xor, ptr @g8
  %cond = icmp eq i8 %xor, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @xor64_reg_br(i64 %arg) nounwind {
; CHECK-LABEL: xor64_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorq %rdi, g64(%rip) # encoding: [0x48,0x31,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, ptr @g64
  %xor = xor i64 %load1, %arg
  store i64 %xor, ptr @g64
  %cond = icmp eq i64 %xor, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @xor32_reg_br(i32 %arg) nounwind {
; CHECK-LABEL: xor32_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl %edi, g32(%rip) # encoding: [0x31,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, ptr @g32
  %xor = xor i32 %load1, %arg
  store i32 %xor, ptr @g32
  %cond = icmp eq i32 %xor, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @xor16_reg_br(i16 %arg) nounwind {
; CHECK-LABEL: xor16_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorw %di, g16(%rip) # encoding: [0x66,0x31,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, ptr @g16
  %xor = xor i16 %load1, %arg
  store i16 %xor, ptr @g16
  %cond = icmp eq i16 %xor, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @xor8_reg_br(i8 %arg) nounwind {
; CHECK-LABEL: xor8_reg_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorb %dil, g8(%rip) # encoding: [0x40,0x30,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g8-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    jne b # TAILCALL
; CHECK-NEXT:    # encoding: [0x75,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i8, ptr @g8
  %xor = xor i8 %load1, %arg
  store i8 %xor, ptr @g8
  %cond = icmp eq i8 %xor, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @neg64_br() nounwind {
; CHECK-LABEL: neg64_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    negq g64(%rip) # encoding: [0x48,0xf7,0x1d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g64-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i64, ptr @g64
  %sub = sub i64 0, %load1
  store i64 %sub, ptr @g64
  %cond = icmp slt i64 %sub, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @neg32_br() nounwind {
; CHECK-LABEL: neg32_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    negl g32(%rip) # encoding: [0xf7,0x1d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 2, value: g32-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i32, ptr @g32
  %sub = sub i32 0, %load1
  store i32 %sub, ptr @g32
  %cond = icmp slt i32 %sub, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @neg16_br() nounwind {
; CHECK-LABEL: neg16_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    negw g16(%rip) # encoding: [0x66,0xf7,0x1d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: g16-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i16, ptr @g16
  %sub = sub i16 0, %load1
  store i16 %sub, ptr @g16
  %cond = icmp slt i16 %sub, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}

define void @neg8_br() nounwind {
; CHECK-LABEL: neg8_br:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    negb g8(%rip) # encoding: [0xf6,0x1d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 2, value: g8-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    jns b # TAILCALL
; CHECK-NEXT:    # encoding: [0x79,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: b-1, kind: FK_PCRel_1
; CHECK-NEXT:  # %bb.1: # %a
; CHECK-NEXT:    jmp a # TAILCALL
; CHECK-NEXT:    # encoding: [0xeb,A]
; CHECK-NEXT:    # fixup A - offset: 1, value: a-1, kind: FK_PCRel_1
entry:
  %load1 = load i8, ptr @g8
  %sub = sub i8 0, %load1
  store i8 %sub, ptr @g8
  %cond = icmp slt i8 %sub, 0
  br i1 %cond, label %a, label %b

a:
  tail call void @a()
  ret void

b:
  tail call void @b()
  ret void
}
