; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=arm64-eabi -aarch64-neon-syntax=apple | FileCheck %s

define <8 x i8> @v_orrimm(ptr %A) nounwind {
; CHECK-LABEL: v_orrimm:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    orr.2s v0, #1, lsl #24
; CHECK-NEXT:    ret
  %tmp1 = load <8 x i8>, ptr %A
  %tmp3 = or <8 x i8> %tmp1, <i8 0, i8 0, i8 0, i8 1, i8 0, i8 0, i8 0, i8 1>
  ret <8 x i8> %tmp3
}

define <16 x i8> @v_orrimmQ(ptr %A) nounwind {
; CHECK-LABEL: v_orrimmQ:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    orr.4s v0, #1, lsl #24
; CHECK-NEXT:    ret
  %tmp1 = load <16 x i8>, ptr %A
  %tmp3 = or <16 x i8> %tmp1, <i8 0, i8 0, i8 0, i8 1, i8 0, i8 0, i8 0, i8 1, i8 0, i8 0, i8 0, i8 1, i8 0, i8 0, i8 0, i8 1>
  ret <16 x i8> %tmp3
}

define <8 x i8> @v_bicimm(ptr %A) nounwind {
; CHECK-LABEL: v_bicimm:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    bic.2s v0, #255, lsl #24
; CHECK-NEXT:    ret
  %tmp1 = load <8 x i8>, ptr %A
  %tmp3 = and <8 x i8> %tmp1, < i8 -1, i8 -1, i8 -1, i8 0, i8 -1, i8 -1, i8 -1, i8 0 >
  ret <8 x i8> %tmp3
}

define <16 x i8> @v_bicimmQ(ptr %A) nounwind {
; CHECK-LABEL: v_bicimmQ:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    bic.4s v0, #255, lsl #24
; CHECK-NEXT:    ret
  %tmp1 = load <16 x i8>, ptr %A
  %tmp3 = and <16 x i8> %tmp1, < i8 -1, i8 -1, i8 -1, i8 0, i8 -1, i8 -1, i8 -1, i8 0, i8 -1, i8 -1, i8 -1, i8 0, i8 -1, i8 -1, i8 -1, i8 0 >
  ret <16 x i8> %tmp3
}

define <2 x double> @foo(<2 x double> %bar) nounwind {
; CHECK-LABEL: foo:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmov.2d v1, #1.00000000
; CHECK-NEXT:    fadd.2d v0, v0, v1
; CHECK-NEXT:    ret
  %add = fadd <2 x double> %bar, <double 1.0, double 1.0>
  ret <2 x double> %add
}

define <4 x i32> @movi_4s_imm_t1() nounwind readnone ssp {
; CHECK-LABEL: movi_4s_imm_t1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi.4s v0, #75
; CHECK-NEXT:    ret
entry:
  ret <4 x i32> <i32 75, i32 75, i32 75, i32 75>
}

define <4 x i32> @movi_4s_imm_t2() nounwind readnone ssp {
; CHECK-LABEL: movi_4s_imm_t2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi.4s v0, #75, lsl #8
; CHECK-NEXT:    ret
entry:
  ret <4 x i32> <i32 19200, i32 19200, i32 19200, i32 19200>
}

define <4 x i32> @movi_4s_imm_t3() nounwind readnone ssp {
; CHECK-LABEL: movi_4s_imm_t3:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi.4s v0, #75, lsl #16
; CHECK-NEXT:    ret
entry:
  ret <4 x i32> <i32 4915200, i32 4915200, i32 4915200, i32 4915200>
}

define <4 x i32> @movi_4s_imm_t4() nounwind readnone ssp {
; CHECK-LABEL: movi_4s_imm_t4:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi.4s v0, #75, lsl #24
; CHECK-NEXT:    ret
entry:
  ret <4 x i32> <i32 1258291200, i32 1258291200, i32 1258291200, i32 1258291200>
}

define <8 x i16> @movi_8h_imm_t5() nounwind readnone ssp {
; CHECK-LABEL: movi_8h_imm_t5:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi.8h v0, #75
; CHECK-NEXT:    ret
entry:
  ret <8 x i16> <i16 75, i16 75, i16 75, i16 75, i16 75, i16 75, i16 75, i16 75>
}

; rdar://11989841
define <8 x i16> @movi_8h_imm_t6() nounwind readnone ssp {
; CHECK-LABEL: movi_8h_imm_t6:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi.8h v0, #75, lsl #8
; CHECK-NEXT:    ret
entry:
  ret <8 x i16> <i16 19200, i16 19200, i16 19200, i16 19200, i16 19200, i16 19200, i16 19200, i16 19200>
}

define <4 x i32> @movi_4s_imm_t7() nounwind readnone ssp {
; CHECK-LABEL: movi_4s_imm_t7:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi.4s v0, #75, msl #8
; CHECK-NEXT:    ret
entry:
  ret <4 x i32> <i32 19455, i32 19455, i32 19455, i32 19455>
}

define <4 x i32> @movi_4s_imm_t8() nounwind readnone ssp {
; CHECK-LABEL: movi_4s_imm_t8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi.4s v0, #75, msl #16
; CHECK-NEXT:    ret
entry:
  ret <4 x i32> <i32 4980735, i32 4980735, i32 4980735, i32 4980735>
}

define <16 x i8> @movi_16b_imm_t9() nounwind readnone ssp {
; CHECK-LABEL: movi_16b_imm_t9:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi.16b v0, #75
; CHECK-NEXT:    ret
entry:
  ret <16 x i8> <i8 75, i8 75, i8 75, i8 75, i8 75, i8 75, i8 75, i8 75, i8 75, i8 75, i8 75, i8 75, i8 75, i8 75, i8 75, i8 75>
}

define <2 x i64> @movi_2d_imm_t10() nounwind readnone ssp {
; CHECK-LABEL: movi_2d_imm_t10:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi.2d v0, #0xff00ff00ff00ff
; CHECK-NEXT:    ret
entry:
  ret <2 x i64> <i64 71777214294589695, i64 71777214294589695>
}

define <4 x i32> @movi_4s_imm_t11() nounwind readnone ssp {
; CHECK-LABEL: movi_4s_imm_t11:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmov.4s v0, #-0.32812500
; CHECK-NEXT:    ret
entry:
  ret <4 x i32> <i32 3198681088, i32 3198681088, i32 3198681088, i32 3198681088>
}

define <2 x i64> @movi_2d_imm_t12() nounwind readnone ssp {
; CHECK-LABEL: movi_2d_imm_t12:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmov.2d v0, #-0.17187500
; CHECK-NEXT:    ret
entry:
  ret <2 x i64> <i64 13818732506632945664, i64 13818732506632945664>
}
