; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt %s -mtriple=arm64-apple-macosx -passes="default<O3>" -inline-threshold=2 -inline-call-penalty=5 -S | FileCheck %s

declare i64 @llvm.objectsize.i64.p0(ptr, i1, i1, i1)
declare ptr @__memcpy_chk(ptr, ptr, i64, i64)
declare ptr @__memmove_chk(ptr, ptr, i64, i64)
declare ptr @__mempcpy_chk(ptr, ptr, i64, i64)
declare ptr @__memset_chk(ptr, i32, i64, i64)

define void @callee_memcpy(ptr %dst, ptr %src, i64 %size) {
; CHECK-LABEL: define void @callee_memcpy
; CHECK-SAME: (ptr [[DST:%.*]], ptr nocapture readonly [[SRC:%.*]], i64 [[SIZE:%.*]]) local_unnamed_addr #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    tail call void @llvm.memcpy.p0.p0.i64(ptr align 1 [[DST]], ptr align 1 [[SRC]], i64 [[SIZE]], i1 false)
; CHECK-NEXT:    ret void
;
  %objsize = call i64 @llvm.objectsize.i64.p0(ptr %dst, i1 false, i1 true, i1 false)
  %call.memcpy = call ptr @__memcpy_chk(ptr %dst, ptr %src, i64 %size, i64 %objsize)
  ret void
}

define void @callee_memmove(ptr %dst, ptr %src, i64 %size) {
; CHECK-LABEL: define void @callee_memmove
; CHECK-SAME: (ptr [[DST:%.*]], ptr [[SRC:%.*]], i64 [[SIZE:%.*]]) local_unnamed_addr #[[ATTR1:[0-9]+]] {
; CHECK-NEXT:    tail call void @llvm.memmove.p0.p0.i64(ptr align 1 [[DST]], ptr align 1 [[SRC]], i64 [[SIZE]], i1 false)
; CHECK-NEXT:    ret void
;
  %objsize = call i64 @llvm.objectsize.i64.p0(ptr %dst, i1 false, i1 true, i1 false)
  %call.memmove = call ptr @__memmove_chk(ptr %dst, ptr %src, i64 %size, i64 %objsize)
  ret void
}

define void @callee_mempcpy(ptr %dst, ptr %src, i64 %size) {
; CHECK-LABEL: define void @callee_mempcpy
; CHECK-SAME: (ptr [[DST:%.*]], ptr [[SRC:%.*]], i64 [[SIZE:%.*]]) local_unnamed_addr #[[ATTR1]] {
; CHECK-NEXT:    tail call void @llvm.memcpy.p0.p0.i64(ptr align 1 [[DST]], ptr align 1 [[SRC]], i64 [[SIZE]], i1 false)
; CHECK-NEXT:    ret void
;
  %objsize = call i64 @llvm.objectsize.i64.p0(ptr %dst, i1 false, i1 true, i1 false)
  %call.mempcpy = call ptr @__mempcpy_chk(ptr %dst, ptr %src, i64 %size, i64 %objsize)
  ret void
}

define void @callee_memset(ptr %dst, i64 %size) {
; CHECK-LABEL: define void @callee_memset
; CHECK-SAME: (ptr [[DST:%.*]], i64 [[SIZE:%.*]]) local_unnamed_addr #[[ATTR0]] {
; CHECK-NEXT:    tail call void @llvm.memset.p0.i64(ptr align 1 [[DST]], i8 0, i64 [[SIZE]], i1 false)
; CHECK-NEXT:    ret void
;
  %objsize = call i64 @llvm.objectsize.i64.p0(ptr %dst, i1 false, i1 true, i1 false)
  %call.mempcpy = call ptr @__memset_chk(ptr %dst, i32 0, i64 %size, i64 %objsize)
  ret void
}

define void @caller_memcpy(ptr %dst, ptr %src) {
; CHECK-LABEL: define void @caller_memcpy
; CHECK-SAME: (ptr [[DST:%.*]], ptr nocapture readonly [[SRC:%.*]]) local_unnamed_addr #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[SRC]], align 1
; CHECK-NEXT:    store i32 [[TMP1]], ptr [[DST]], align 1
; CHECK-NEXT:    ret void
;
  call void @callee_memcpy(ptr %dst, ptr %src, i64 4)
  ret void
}

define void @caller_memmove(ptr %dst, ptr %src) {
; CHECK-LABEL: define void @caller_memmove
; CHECK-SAME: (ptr [[DST:%.*]], ptr [[SRC:%.*]]) local_unnamed_addr #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[SRC]], align 1
; CHECK-NEXT:    store i32 [[TMP1]], ptr [[DST]], align 1
; CHECK-NEXT:    ret void
;
  call void @callee_memmove(ptr %dst, ptr %src, i64 4)
  ret void
}

define void @caller_mempcpy(ptr %dst, ptr %src) {
; CHECK-LABEL: define void @caller_mempcpy
; CHECK-SAME: (ptr [[DST:%.*]], ptr [[SRC:%.*]]) local_unnamed_addr #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[SRC]], align 1
; CHECK-NEXT:    store i32 [[TMP1]], ptr [[DST]], align 1
; CHECK-NEXT:    ret void
;
  call void @callee_mempcpy(ptr %dst, ptr %src, i64 4)
  ret void
}

define void @caller_memset(ptr %dst) {
; CHECK-LABEL: define void @caller_memset
; CHECK-SAME: (ptr [[DST:%.*]]) local_unnamed_addr #[[ATTR0]] {
; CHECK-NEXT:    store i32 0, ptr [[DST]], align 1
; CHECK-NEXT:    ret void
;
  call void @callee_memset(ptr %dst, i64 4)
  ret void
}
