; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -S -passes=instcombine %s | FileCheck %s

define float @fneg_as_int_f32_castback_noimplicitfloat(float %val) noimplicitfloat {
; CHECK-LABEL: define float @fneg_as_int_f32_castback_noimplicitfloat
; CHECK-SAME: (float [[VAL:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    [[BITCAST:%.*]] = bitcast float [[VAL]] to i32
; CHECK-NEXT:    [[XOR:%.*]] = xor i32 [[BITCAST]], -2147483648
; CHECK-NEXT:    [[FNEG:%.*]] = bitcast i32 [[XOR]] to float
; CHECK-NEXT:    ret float [[FNEG]]
;
  %bitcast = bitcast float %val to i32
  %xor = xor i32 %bitcast, -2147483648
  %fneg = bitcast i32 %xor to float
  ret float %fneg
}

define <2 x i32> @fneg_as_int_v2f32_noimplicitfloat(<2 x float> %x) noimplicitfloat {
; CHECK-LABEL: define <2 x i32> @fneg_as_int_v2f32_noimplicitfloat
; CHECK-SAME: (<2 x float> [[X:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[BC:%.*]] = bitcast <2 x float> [[X]] to <2 x i32>
; CHECK-NEXT:    [[XOR:%.*]] = xor <2 x i32> [[BC]], splat (i32 -2147483648)
; CHECK-NEXT:    ret <2 x i32> [[XOR]]
;
  %bc = bitcast <2 x float> %x to <2 x i32>
  %xor = xor <2 x i32> %bc, <i32 -2147483648, i32 -2147483648>
  ret <2 x i32> %xor
}

define float @fneg_as_int_f32_castback(float %val) {
; CHECK-LABEL: define float @fneg_as_int_f32_castback
; CHECK-SAME: (float [[VAL:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = fneg float [[VAL]]
; CHECK-NEXT:    ret float [[TMP1]]
;
  %bitcast = bitcast float %val to i32
  %xor = xor i32 %bitcast, -2147483648
  %fneg = bitcast i32 %xor to float
  ret float %fneg
}

define float @not_fneg_as_int_f32_castback_wrongconst(float %val) {
; CHECK-LABEL: define float @not_fneg_as_int_f32_castback_wrongconst
; CHECK-SAME: (float [[VAL:%.*]]) {
; CHECK-NEXT:    [[BITCAST:%.*]] = bitcast float [[VAL]] to i32
; CHECK-NEXT:    [[XOR:%.*]] = xor i32 [[BITCAST]], -2147483647
; CHECK-NEXT:    [[FNEG:%.*]] = bitcast i32 [[XOR]] to float
; CHECK-NEXT:    ret float [[FNEG]]
;
  %bitcast = bitcast float %val to i32
  %xor = xor i32 %bitcast, -2147483647
  %fneg = bitcast i32 %xor to float
  ret float %fneg
}

define float @fneg_as_int_f32_castback_multi_use(float %val, ptr %ptr) {
; CHECK-LABEL: define float @fneg_as_int_f32_castback_multi_use
; CHECK-SAME: (float [[VAL:%.*]], ptr [[PTR:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = fneg float [[VAL]]
; CHECK-NEXT:    store float [[TMP1]], ptr [[PTR]], align 4
; CHECK-NEXT:    ret float [[TMP1]]
;
  %bitcast = bitcast float %val to i32
  %xor = xor i32 %bitcast, -2147483648
  store i32 %xor, ptr %ptr
  %fneg = bitcast i32 %xor to float
  ret float %fneg
}

define i64 @fneg_as_int_f64(double %x) {
; CHECK-LABEL: define i64 @fneg_as_int_f64
; CHECK-SAME: (double [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = fneg double [[X]]
; CHECK-NEXT:    [[XOR:%.*]] = bitcast double [[TMP1]] to i64
; CHECK-NEXT:    ret i64 [[XOR]]
;
  %bc = bitcast double %x to i64
  %xor = xor i64 %bc, -9223372036854775808
  ret i64 %xor
}

define <2 x i64> @fneg_as_int_v2f64(<2 x double> %x) {
; CHECK-LABEL: define <2 x i64> @fneg_as_int_v2f64
; CHECK-SAME: (<2 x double> [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = fneg <2 x double> [[X]]
; CHECK-NEXT:    [[XOR:%.*]] = bitcast <2 x double> [[TMP1]] to <2 x i64>
; CHECK-NEXT:    ret <2 x i64> [[XOR]]
;
  %bc = bitcast <2 x double> %x to <2 x i64>
  %xor = xor <2 x i64> %bc, <i64 -9223372036854775808, i64 -9223372036854775808>
  ret <2 x i64> %xor
}

define i64 @fneg_as_int_f64_swap(double %x) {
; CHECK-LABEL: define i64 @fneg_as_int_f64_swap
; CHECK-SAME: (double [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = fneg double [[X]]
; CHECK-NEXT:    [[XOR:%.*]] = bitcast double [[TMP1]] to i64
; CHECK-NEXT:    ret i64 [[XOR]]
;
  %bc = bitcast double %x to i64
  %xor = xor i64 -9223372036854775808, %bc
  ret i64 %xor
}

define i32 @fneg_as_int_f32(float %x) {
; CHECK-LABEL: define i32 @fneg_as_int_f32
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = fneg float [[X]]
; CHECK-NEXT:    [[XOR:%.*]] = bitcast float [[TMP1]] to i32
; CHECK-NEXT:    ret i32 [[XOR]]
;
  %bc = bitcast float %x to i32
  %xor = xor i32 %bc, -2147483648
  ret i32 %xor
}

define <2 x i32> @fneg_as_int_v2f32(<2 x float> %x) {
; CHECK-LABEL: define <2 x i32> @fneg_as_int_v2f32
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = fneg <2 x float> [[X]]
; CHECK-NEXT:    [[XOR:%.*]] = bitcast <2 x float> [[TMP1]] to <2 x i32>
; CHECK-NEXT:    ret <2 x i32> [[XOR]]
;
  %bc = bitcast <2 x float> %x to <2 x i32>
  %xor = xor <2 x i32> %bc, <i32 -2147483648, i32 -2147483648>
  ret <2 x i32> %xor
}

define <2 x i32> @not_fneg_as_int_v2f32_nonsplat(<2 x float> %x) {
; CHECK-LABEL: define <2 x i32> @not_fneg_as_int_v2f32_nonsplat
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[BC:%.*]] = bitcast <2 x float> [[X]] to <2 x i32>
; CHECK-NEXT:    [[XOR:%.*]] = xor <2 x i32> [[BC]], <i32 -2147483648, i32 -2147483647>
; CHECK-NEXT:    ret <2 x i32> [[XOR]]
;
  %bc = bitcast <2 x float> %x to <2 x i32>
  %xor = xor <2 x i32> %bc, <i32 -2147483648, i32 -2147483647>
  ret <2 x i32> %xor
}

define <3 x i32> @fneg_as_int_v3f32_poison(<3 x float> %x) {
; CHECK-LABEL: define <3 x i32> @fneg_as_int_v3f32_poison
; CHECK-SAME: (<3 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = fneg <3 x float> [[X]]
; CHECK-NEXT:    [[XOR:%.*]] = bitcast <3 x float> [[TMP1]] to <3 x i32>
; CHECK-NEXT:    ret <3 x i32> [[XOR]]
;
  %bc = bitcast <3 x float> %x to <3 x i32>
  %xor = xor <3 x i32> %bc, <i32 -2147483648, i32 poison, i32 -2147483648>
  ret <3 x i32> %xor
}

; Make sure that only a bitcast is transformed.
define i64 @fneg_as_int_f64_not_bitcast(double %x) {
; CHECK-LABEL: define i64 @fneg_as_int_f64_not_bitcast
; CHECK-SAME: (double [[X:%.*]]) {
; CHECK-NEXT:    [[BC:%.*]] = fptoui double [[X]] to i64
; CHECK-NEXT:    [[XOR:%.*]] = xor i64 [[BC]], -9223372036854775808
; CHECK-NEXT:    ret i64 [[XOR]]
;
  %bc = fptoui double %x to i64
  %xor = xor i64 %bc, -9223372036854775808
  ret i64 %xor
}

define float @not_fneg_as_int_f32_bitcast_from_v2f16(<2 x half> %val) {
; CHECK-LABEL: define float @not_fneg_as_int_f32_bitcast_from_v2f16
; CHECK-SAME: (<2 x half> [[VAL:%.*]]) {
; CHECK-NEXT:    [[BITCAST:%.*]] = bitcast <2 x half> [[VAL]] to i32
; CHECK-NEXT:    [[XOR:%.*]] = xor i32 [[BITCAST]], -2147483648
; CHECK-NEXT:    [[FNEG:%.*]] = bitcast i32 [[XOR]] to float
; CHECK-NEXT:    ret float [[FNEG]]
;
  %bitcast = bitcast <2 x half> %val to i32
  %xor = xor i32 %bitcast, -2147483648
  %fneg = bitcast i32 %xor to float
  ret float %fneg
}

define float @not_fneg_as_int_f32_bitcast_from_v2i16(<2 x i16> %val) {
; CHECK-LABEL: define float @not_fneg_as_int_f32_bitcast_from_v2i16
; CHECK-SAME: (<2 x i16> [[VAL:%.*]]) {
; CHECK-NEXT:    [[BITCAST:%.*]] = bitcast <2 x i16> [[VAL]] to i32
; CHECK-NEXT:    [[XOR:%.*]] = xor i32 [[BITCAST]], -2147483648
; CHECK-NEXT:    [[FNEG:%.*]] = bitcast i32 [[XOR]] to float
; CHECK-NEXT:    ret float [[FNEG]]
;
  %bitcast = bitcast <2 x i16> %val to i32
  %xor = xor i32 %bitcast, -2147483648
  %fneg = bitcast i32 %xor to float
  ret float %fneg
}

define i128 @fneg_as_int_fp128_f64_mask(fp128 %x) {
; CHECK-LABEL: define i128 @fneg_as_int_fp128_f64_mask
; CHECK-SAME: (fp128 [[X:%.*]]) {
; CHECK-NEXT:    [[BC:%.*]] = bitcast fp128 [[X]] to i128
; CHECK-NEXT:    [[XOR:%.*]] = xor i128 [[BC]], -9223372036854775808
; CHECK-NEXT:    ret i128 [[XOR]]
;
  %bc = bitcast fp128 %x to i128
  %xor = xor i128 %bc, -9223372036854775808
  ret i128 %xor
}

define i128 @fneg_as_int_fp128_f128_mask(fp128 %x) {
; CHECK-LABEL: define i128 @fneg_as_int_fp128_f128_mask
; CHECK-SAME: (fp128 [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = fneg fp128 [[X]]
; CHECK-NEXT:    [[XOR:%.*]] = bitcast fp128 [[TMP1]] to i128
; CHECK-NEXT:    ret i128 [[XOR]]
;
  %bc = bitcast fp128 %x to i128
  %xor = xor i128 %bc, -170141183460469231731687303715884105728
  ret i128 %xor
}

define i16 @fneg_as_int_f16(half %x) {
; CHECK-LABEL: define i16 @fneg_as_int_f16
; CHECK-SAME: (half [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = fneg half [[X]]
; CHECK-NEXT:    [[XOR:%.*]] = bitcast half [[TMP1]] to i16
; CHECK-NEXT:    ret i16 [[XOR]]
;
  %bc = bitcast half %x to i16
  %xor = xor i16 %bc, -32768
  ret i16 %xor
}

define <2 x i16> @fneg_as_int_v2f16(<2 x half> %x) {
; CHECK-LABEL: define <2 x i16> @fneg_as_int_v2f16
; CHECK-SAME: (<2 x half> [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = fneg <2 x half> [[X]]
; CHECK-NEXT:    [[XOR:%.*]] = bitcast <2 x half> [[TMP1]] to <2 x i16>
; CHECK-NEXT:    ret <2 x i16> [[XOR]]
;
  %bc = bitcast <2 x half> %x to <2 x i16>
  %xor = xor <2 x i16> %bc, <i16 -32768, i16 -32768>
  ret <2 x i16> %xor
}

define i16 @fneg_as_int_bf16(bfloat %x) {
; CHECK-LABEL: define i16 @fneg_as_int_bf16
; CHECK-SAME: (bfloat [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = fneg bfloat [[X]]
; CHECK-NEXT:    [[XOR:%.*]] = bitcast bfloat [[TMP1]] to i16
; CHECK-NEXT:    ret i16 [[XOR]]
;
  %bc = bitcast bfloat %x to i16
  %xor = xor i16 %bc, -32768
  ret i16 %xor
}

define <2 x i16> @fneg_as_int_v2bf16(<2 x bfloat> %x) {
; CHECK-LABEL: define <2 x i16> @fneg_as_int_v2bf16
; CHECK-SAME: (<2 x bfloat> [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = fneg <2 x bfloat> [[X]]
; CHECK-NEXT:    [[XOR:%.*]] = bitcast <2 x bfloat> [[TMP1]] to <2 x i16>
; CHECK-NEXT:    ret <2 x i16> [[XOR]]
;
  %bc = bitcast <2 x bfloat> %x to <2 x i16>
  %xor = xor <2 x i16> %bc, <i16 -32768, i16 -32768>
  ret <2 x i16> %xor
}

define i80 @fneg_as_int_x86_fp80_f64_mask(x86_fp80 %x) {
; CHECK-LABEL: define i80 @fneg_as_int_x86_fp80_f64_mask
; CHECK-SAME: (x86_fp80 [[X:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = fneg x86_fp80 [[X]]
; CHECK-NEXT:    [[XOR:%.*]] = bitcast x86_fp80 [[TMP1]] to i80
; CHECK-NEXT:    ret i80 [[XOR]]
;
  %bc = bitcast x86_fp80 %x to i80
  %xor = xor i80 %bc, -604462909807314587353088
  ret i80 %xor
}

define i128 @fneg_as_int_ppc_fp128_f64_mask(ppc_fp128 %x) {
; CHECK-LABEL: define i128 @fneg_as_int_ppc_fp128_f64_mask
; CHECK-SAME: (ppc_fp128 [[X:%.*]]) {
; CHECK-NEXT:    [[BC:%.*]] = bitcast ppc_fp128 [[X]] to i128
; CHECK-NEXT:    [[XOR:%.*]] = xor i128 [[BC]], -9223372036854775808
; CHECK-NEXT:    ret i128 [[XOR]]
;
  %bc = bitcast ppc_fp128 %x to i128
  %xor = xor i128 %bc, -9223372036854775808
  ret i128 %xor
}

define i128 @fneg_as_int_ppc_fp128_f128_mask(ppc_fp128 %x) {
; CHECK-LABEL: define i128 @fneg_as_int_ppc_fp128_f128_mask
; CHECK-SAME: (ppc_fp128 [[X:%.*]]) {
; CHECK-NEXT:    [[BC:%.*]] = bitcast ppc_fp128 [[X]] to i128
; CHECK-NEXT:    [[XOR:%.*]] = xor i128 [[BC]], -170141183460469231731687303715884105728
; CHECK-NEXT:    ret i128 [[XOR]]
;
  %bc = bitcast ppc_fp128 %x to i128
  %xor = xor i128 %bc, -170141183460469231731687303715884105728
  ret i128 %xor
}
