; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -passes=infer-address-spaces -o - %s | FileCheck %s

define float @f0(ptr %p) {
; CHECK-LABEL: define float @f0(
; CHECK-SAME: ptr [[P:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[IS_SHARED:%.*]] = call i1 @llvm.amdgcn.is.shared(ptr [[P]])
; CHECK-NEXT:    tail call void @llvm.assume(i1 [[IS_SHARED]])
; CHECK-NEXT:    [[WORKITEM_ID_X:%.*]] = tail call i32 @llvm.amdgcn.workitem.id.x()
; CHECK-NEXT:    [[IDXPROM:%.*]] = zext i32 [[WORKITEM_ID_X]] to i64
; CHECK-NEXT:    [[TMP0:%.*]] = addrspacecast ptr [[P]] to ptr addrspace(3)
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, ptr addrspace(3) [[TMP0]], i64 [[IDXPROM]]
; CHECK-NEXT:    [[LOAD:%.*]] = load float, ptr addrspace(3) [[ARRAYIDX]], align 4
; CHECK-NEXT:    ret float [[LOAD]]
;
entry:
  %is.shared = call i1 @llvm.amdgcn.is.shared(ptr %p)
  tail call void @llvm.assume(i1 %is.shared)
  %workitem.id.x = tail call i32 @llvm.amdgcn.workitem.id.x()
  %idxprom = zext i32 %workitem.id.x to i64
  %arrayidx = getelementptr inbounds float, ptr %p, i64 %idxprom
  %load = load float, ptr %arrayidx, align 4
  ret float %load
}

define float @f1(ptr %p) {
; CHECK-LABEL: define float @f1(
; CHECK-SAME: ptr [[P:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[IS_PRIVATE:%.*]] = call i1 @llvm.amdgcn.is.private(ptr [[P]])
; CHECK-NEXT:    tail call void @llvm.assume(i1 [[IS_PRIVATE]])
; CHECK-NEXT:    [[WORKITEM_ID_X:%.*]] = tail call i32 @llvm.amdgcn.workitem.id.x()
; CHECK-NEXT:    [[IDXPROM:%.*]] = zext i32 [[WORKITEM_ID_X]] to i64
; CHECK-NEXT:    [[TMP0:%.*]] = addrspacecast ptr [[P]] to ptr addrspace(5)
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, ptr addrspace(5) [[TMP0]], i64 [[IDXPROM]]
; CHECK-NEXT:    [[LOAD:%.*]] = load float, ptr addrspace(5) [[ARRAYIDX]], align 4
; CHECK-NEXT:    ret float [[LOAD]]
;
entry:
  %is.private = call i1 @llvm.amdgcn.is.private(ptr %p)
  tail call void @llvm.assume(i1 %is.private)
  %workitem.id.x = tail call i32 @llvm.amdgcn.workitem.id.x()
  %idxprom = zext i32 %workitem.id.x to i64
  %arrayidx = getelementptr inbounds float, ptr %p, i64 %idxprom
  %load = load float, ptr %arrayidx, align 4
  ret float %load
}

define float @f2(ptr %p) {
; CHECK-LABEL: define float @f2(
; CHECK-SAME: ptr [[P:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[IS_PRIVATE:%.*]] = call i1 @llvm.amdgcn.is.private(ptr [[P]])
; CHECK-NEXT:    [[NOT_PRIVATE:%.*]] = xor i1 [[IS_PRIVATE]], true
; CHECK-NEXT:    [[IS_SHARED:%.*]] = call i1 @llvm.amdgcn.is.shared(ptr [[P]])
; CHECK-NEXT:    [[NOT_SHARED:%.*]] = xor i1 [[IS_SHARED]], true
; CHECK-NEXT:    [[NOT_PRIVATE_AND_NOT_SHARED:%.*]] = and i1 [[NOT_PRIVATE]], [[NOT_SHARED]]
; CHECK-NEXT:    tail call void @llvm.assume(i1 [[NOT_PRIVATE_AND_NOT_SHARED]])
; CHECK-NEXT:    [[WORKITEM_ID_X:%.*]] = tail call i32 @llvm.amdgcn.workitem.id.x()
; CHECK-NEXT:    [[IDXPROM:%.*]] = zext i32 [[WORKITEM_ID_X]] to i64
; CHECK-NEXT:    [[TMP0:%.*]] = addrspacecast ptr [[P]] to ptr addrspace(1)
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, ptr addrspace(1) [[TMP0]], i64 [[IDXPROM]]
; CHECK-NEXT:    [[LOAD:%.*]] = load float, ptr addrspace(1) [[ARRAYIDX]], align 4
; CHECK-NEXT:    ret float [[LOAD]]
;
entry:
  %is.private = call i1 @llvm.amdgcn.is.private(ptr %p)
  %not.private = xor i1 %is.private, true
  %is.shared = call i1 @llvm.amdgcn.is.shared(ptr %p)
  %not.shared = xor i1 %is.shared, true
  %not.private.and.not.shared = and i1 %not.private, %not.shared
  tail call void @llvm.assume(i1 %not.private.and.not.shared)
  %workitem.id.x = tail call i32 @llvm.amdgcn.workitem.id.x()
  %idxprom = zext i32 %workitem.id.x to i64
  %arrayidx = getelementptr inbounds float, ptr %p, i64 %idxprom
  %load = load float, ptr %arrayidx, align 4
  ret float %load
}

define float @g0(i32 %c, ptr %p) {
; CHECK-LABEL: define float @g0(
; CHECK-SAME: i32 [[C:%.*]], ptr [[P:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*]]:
; CHECK-NEXT:    [[TOBOOL_NOT:%.*]] = icmp eq i32 [[C]], 0
; CHECK-NEXT:    br i1 [[TOBOOL_NOT]], label %[[IF_END:.*]], label %[[IF_THEN:.*]]
; CHECK:       [[IF_THEN]]:
; CHECK-NEXT:    [[IS_SHARED:%.*]] = call i1 @llvm.amdgcn.is.shared(ptr [[P]])
; CHECK-NEXT:    tail call void @llvm.assume(i1 [[IS_SHARED]])
; CHECK-NEXT:    [[WORKITEM_ID_X_0:%.*]] = tail call i32 @llvm.amdgcn.workitem.id.x()
; CHECK-NEXT:    [[IDXPROM:%.*]] = zext i32 [[WORKITEM_ID_X_0]] to i64
; CHECK-NEXT:    [[TMP0:%.*]] = addrspacecast ptr [[P]] to ptr addrspace(3)
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, ptr addrspace(3) [[TMP0]], i64 [[IDXPROM]]
; CHECK-NEXT:    [[LOAD0:%.*]] = load float, ptr addrspace(3) [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[ADD:%.*]] = fadd float [[LOAD0]], 0.000000e+00
; CHECK-NEXT:    br label %[[IF_END]]
; CHECK:       [[IF_END]]:
; CHECK-NEXT:    [[S:%.*]] = phi float [ [[ADD]], %[[IF_THEN]] ], [ 0.000000e+00, %[[ENTRY]] ]
; CHECK-NEXT:    [[WORKITEM_ID_X_1:%.*]] = tail call i32 @llvm.amdgcn.workitem.id.y()
; CHECK-NEXT:    [[IDXPROM2:%.*]] = zext i32 [[WORKITEM_ID_X_1]] to i64
; CHECK-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds float, ptr [[P]], i64 [[IDXPROM2]]
; CHECK-NEXT:    [[LOAD1:%.*]] = load float, ptr [[ARRAYIDX2]], align 4
; CHECK-NEXT:    [[ADD2:%.*]] = fadd float [[S]], [[LOAD1]]
; CHECK-NEXT:    ret float [[ADD2]]
;
entry:
  %tobool.not = icmp eq i32 %c, 0
  br i1 %tobool.not, label %if.end, label %if.then

if.then:
  %is.shared = call i1 @llvm.amdgcn.is.shared(ptr %p)
  tail call void @llvm.assume(i1 %is.shared)
  %workitem.id.x.0 = tail call i32 @llvm.amdgcn.workitem.id.x()
  %idxprom = zext i32 %workitem.id.x.0 to i64
  %arrayidx = getelementptr inbounds float, ptr %p, i64 %idxprom
  %load0 = load float, ptr %arrayidx, align 4
  %add = fadd float %load0, 0.0
  br label %if.end

if.end:
  %s = phi float [ %add, %if.then ], [ 0.0, %entry ]
  %workitem.id.x.1 = tail call i32 @llvm.amdgcn.workitem.id.y()
  %idxprom2 = zext i32 %workitem.id.x.1 to i64
  %arrayidx2 = getelementptr inbounds float, ptr %p, i64 %idxprom2
  %load1 = load float, ptr %arrayidx2, align 4
  %add2 = fadd float %s, %load1
  ret float %add2
}

declare void @llvm.assume(i1)
declare i1 @llvm.amdgcn.is.shared(ptr nocapture)
declare i1 @llvm.amdgcn.is.private(ptr nocapture)
declare i32 @llvm.amdgcn.workitem.id.x()
declare i32 @llvm.amdgcn.workitem.id.y()
