; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,SSE2-SSSE3,SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+ssse3 | FileCheck %s --check-prefixes=SSE,SSE2-SSSE3,SSSE3
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.1 | FileCheck %s --check-prefixes=SSE,SSE41
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=AVX,AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX2,AVX2-SLOW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX2-FAST,AVX2-FAST-ALL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX2-FAST,AVX2-FAST-PERLANE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f | FileCheck %s --check-prefixes=AVX512,AVX512F
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512,AVX512VL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vl,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512,AVX512VL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512,AVX512BW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512,AVX512BW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512,AVX512BWVL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+avx512vl,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512,AVX512BWVL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=skx | FileCheck %s --check-prefixes=SKX

;
; PACKUS saturation truncation to vXi32
;

define <2 x i32> @trunc_packus_v2i64_v2i32(<2 x i64> %a0) {
; SSE2-SSSE3-LABEL: trunc_packus_v2i64_v2i32:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648]
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm2
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[1,1,3,3]
; SSE2-SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm3, %xmm4
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [2147483647,2147483647]
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm0
; SSE2-SSSE3-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm3
; SSE2-SSSE3-NEXT:    movdqa %xmm3, %xmm0
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm2
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm1
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,2,2,3]
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_packus_v2i64_v2i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm1
; SSE41-NEXT:    movapd {{.*#+}} xmm2 = [4294967295,4294967295]
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm3 = [2147483648,2147483648]
; SSE41-NEXT:    pxor %xmm3, %xmm0
; SSE41-NEXT:    pmovsxdq {{.*#+}} xmm4 = [2147483647,2147483647]
; SSE41-NEXT:    movdqa %xmm0, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm4, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm2
; SSE41-NEXT:    xorpd %xmm1, %xmm1
; SSE41-NEXT:    movapd %xmm2, %xmm4
; SSE41-NEXT:    xorpd %xmm3, %xmm4
; SSE41-NEXT:    movapd %xmm4, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm3, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm1
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,2,2,3]
; SSE41-NEXT:    retq
;
; AVX-LABEL: trunc_packus_v2i64_v2i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmovsxbd {{.*#+}} xmm1 = [4294967295,0,4294967295,0]
; AVX-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm1
; AVX-NEXT:    vpand %xmm0, %xmm1, %xmm0
; AVX-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX-NEXT:    retq
;
; AVX512F-LABEL: trunc_packus_v2i64_v2i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    vpmovusqd %zmm0, %ymm0
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_packus_v2i64_v2i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vpmaxsq %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    vpmovusqd %xmm0, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_packus_v2i64_v2i32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512BW-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BW-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovusqd %zmm0, %ymm0
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_packus_v2i64_v2i32:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpmaxsq %xmm1, %xmm0, %xmm0
; AVX512BWVL-NEXT:    vpmovusqd %xmm0, %xmm0
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_packus_v2i64_v2i32:
; SKX:       # %bb.0:
; SKX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; SKX-NEXT:    vpmaxsq %xmm1, %xmm0, %xmm0
; SKX-NEXT:    vpmovusqd %xmm0, %xmm0
; SKX-NEXT:    retq
  %1 = icmp slt <2 x i64> %a0, <i64 4294967295, i64 4294967295>
  %2 = select <2 x i1> %1, <2 x i64> %a0, <2 x i64> <i64 4294967295, i64 4294967295>
  %3 = icmp sgt <2 x i64> %2, zeroinitializer
  %4 = select <2 x i1> %3, <2 x i64> %2, <2 x i64> zeroinitializer
  %5 = trunc <2 x i64> %4 to <2 x i32>
  ret <2 x i32> %5
}

define void @trunc_packus_v2i64_v2i32_store(<2 x i64> %a0, ptr %p1) {
; SSE2-SSSE3-LABEL: trunc_packus_v2i64_v2i32_store:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648]
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm2
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[1,1,3,3]
; SSE2-SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm3, %xmm4
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [2147483647,2147483647]
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm0
; SSE2-SSSE3-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm3
; SSE2-SSSE3-NEXT:    movdqa %xmm3, %xmm0
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm2
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm1
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,2,2,3]
; SSE2-SSSE3-NEXT:    movq %xmm0, (%rdi)
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_packus_v2i64_v2i32_store:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm1
; SSE41-NEXT:    movapd {{.*#+}} xmm2 = [4294967295,4294967295]
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm3 = [2147483648,2147483648]
; SSE41-NEXT:    pxor %xmm3, %xmm0
; SSE41-NEXT:    pmovsxdq {{.*#+}} xmm4 = [2147483647,2147483647]
; SSE41-NEXT:    movdqa %xmm0, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm4, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm2
; SSE41-NEXT:    xorpd %xmm1, %xmm1
; SSE41-NEXT:    movapd %xmm2, %xmm4
; SSE41-NEXT:    xorpd %xmm3, %xmm4
; SSE41-NEXT:    movapd %xmm4, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm3, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm1
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,2,2,3]
; SSE41-NEXT:    movq %xmm0, (%rdi)
; SSE41-NEXT:    retq
;
; AVX-LABEL: trunc_packus_v2i64_v2i32_store:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmovsxbd {{.*#+}} xmm1 = [4294967295,0,4294967295,0]
; AVX-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm1
; AVX-NEXT:    vpand %xmm0, %xmm1, %xmm0
; AVX-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX-NEXT:    vmovq %xmm0, (%rdi)
; AVX-NEXT:    retq
;
; AVX512F-LABEL: trunc_packus_v2i64_v2i32_store:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    vpmovusqd %zmm0, %ymm0
; AVX512F-NEXT:    vmovq %xmm0, (%rdi)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_packus_v2i64_v2i32_store:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vpmaxsq %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    vpmovusqd %xmm0, (%rdi)
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_packus_v2i64_v2i32_store:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512BW-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BW-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovusqd %zmm0, %ymm0
; AVX512BW-NEXT:    vmovq %xmm0, (%rdi)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_packus_v2i64_v2i32_store:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpmaxsq %xmm1, %xmm0, %xmm0
; AVX512BWVL-NEXT:    vpmovusqd %xmm0, (%rdi)
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_packus_v2i64_v2i32_store:
; SKX:       # %bb.0:
; SKX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; SKX-NEXT:    vpmaxsq %xmm1, %xmm0, %xmm0
; SKX-NEXT:    vpmovusqd %xmm0, (%rdi)
; SKX-NEXT:    retq
  %1 = icmp slt <2 x i64> %a0, <i64 4294967295, i64 4294967295>
  %2 = select <2 x i1> %1, <2 x i64> %a0, <2 x i64> <i64 4294967295, i64 4294967295>
  %3 = icmp sgt <2 x i64> %2, zeroinitializer
  %4 = select <2 x i1> %3, <2 x i64> %2, <2 x i64> zeroinitializer
  %5 = trunc <2 x i64> %4 to <2 x i32>
  store <2 x i32> %5, ptr %p1
  ret void
}

define <4 x i32> @trunc_packus_v4i64_v4i32(<4 x i64> %a0) {
; SSE2-SSSE3-LABEL: trunc_packus_v4i64_v4i32:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [4294967295,4294967295]
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648]
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm4
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[1,1,3,3]
; SSE2-SSSE3-NEXT:    pxor %xmm6, %xmm6
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm5
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm7 = [2147483647,2147483647]
; SSE2-SSSE3-NEXT:    movdqa %xmm7, %xmm8
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm4, %xmm8
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm8[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm8[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm0
; SSE2-SSSE3-NEXT:    pandn %xmm3, %xmm5
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm0
; SSE2-SSSE3-NEXT:    movdqa %xmm1, %xmm4
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm5
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm4, %xmm7
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm7[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm7[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm1
; SSE2-SSSE3-NEXT:    pandn %xmm3, %xmm5
; SSE2-SSSE3-NEXT:    por %xmm1, %xmm5
; SSE2-SSSE3-NEXT:    movdqa %xmm5, %xmm1
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm1
; SSE2-SSSE3-NEXT:    movdqa %xmm1, %xmm3
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm2, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm1, %xmm3
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm3
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm1
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm1
; SSE2-SSSE3-NEXT:    movdqa %xmm1, %xmm4
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm2, %xmm4
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm2, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm4[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    pand %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm3[0,2]
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_packus_v4i64_v4i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    movapd {{.*#+}} xmm4 = [4294967295,4294967295]
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm3 = [2147483648,2147483648]
; SSE41-NEXT:    movdqa %xmm0, %xmm5
; SSE41-NEXT:    pxor %xmm3, %xmm5
; SSE41-NEXT:    pmovsxdq {{.*#+}} xmm6 = [2147483647,2147483647]
; SSE41-NEXT:    movdqa %xmm6, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm5, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm5
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm7, %xmm0
; SSE41-NEXT:    movapd %xmm4, %xmm5
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm5
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    pxor %xmm3, %xmm0
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm2
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE41-NEXT:    pand %xmm2, %xmm0
; SSE41-NEXT:    por %xmm6, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm4
; SSE41-NEXT:    xorpd %xmm1, %xmm1
; SSE41-NEXT:    movapd %xmm4, %xmm2
; SSE41-NEXT:    xorpd %xmm3, %xmm2
; SSE41-NEXT:    movapd %xmm2, %xmm6
; SSE41-NEXT:    pcmpeqd %xmm3, %xmm6
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,0,2,2]
; SSE41-NEXT:    pand %xmm6, %xmm0
; SSE41-NEXT:    por %xmm2, %xmm0
; SSE41-NEXT:    pxor %xmm2, %xmm2
; SSE41-NEXT:    blendvpd %xmm0, %xmm4, %xmm2
; SSE41-NEXT:    movapd %xmm5, %xmm4
; SSE41-NEXT:    xorpd %xmm3, %xmm4
; SSE41-NEXT:    movapd %xmm4, %xmm6
; SSE41-NEXT:    pcmpeqd %xmm3, %xmm6
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,0,2,2]
; SSE41-NEXT:    pand %xmm6, %xmm0
; SSE41-NEXT:    por %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm1
; SSE41-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm2[0,2]
; SSE41-NEXT:    movaps %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_packus_v4i64_v4i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmovsxbd {{.*#+}} xmm1 = [4294967295,0,4294967295,0]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX1-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm3
; AVX1-NEXT:    vblendvpd %xmm3, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm3
; AVX1-NEXT:    vpand %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vshufps {{.*#+}} xmm0 = xmm1[0,2],xmm0[0,2]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_packus_v4i64_v4i32:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [4294967295,4294967295,4294967295,4294967295]
; AVX2-SLOW-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm2
; AVX2-SLOW-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-SLOW-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm1
; AVX2-SLOW-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: trunc_packus_v4i64_v4i32:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [4294967295,4294967295,4294967295,4294967295]
; AVX2-FAST-ALL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm2
; AVX2-FAST-ALL-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-ALL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-FAST-ALL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm1
; AVX2-FAST-ALL-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX2-FAST-ALL-NEXT:    vpmovsxbd {{.*#+}} ymm1 = [0,2,4,6,0,0,0,0]
; AVX2-FAST-ALL-NEXT:    vpermd %ymm0, %ymm1, %ymm0
; AVX2-FAST-ALL-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-FAST-ALL-NEXT:    vzeroupper
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: trunc_packus_v4i64_v4i32:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [4294967295,4294967295,4294967295,4294967295]
; AVX2-FAST-PERLANE-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512F-LABEL: trunc_packus_v4i64_v4i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    vpmovusqd %zmm0, %ymm0
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_packus_v4i64_v4i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vpmaxsq %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    vpmovusqd %ymm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_packus_v4i64_v4i32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BW-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovusqd %zmm0, %ymm0
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_packus_v4i64_v4i32:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpmaxsq %ymm1, %ymm0, %ymm0
; AVX512BWVL-NEXT:    vpmovusqd %ymm0, %xmm0
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_packus_v4i64_v4i32:
; SKX:       # %bb.0:
; SKX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; SKX-NEXT:    vpmaxsq %ymm1, %ymm0, %ymm0
; SKX-NEXT:    vpmovusqd %ymm0, %xmm0
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %1 = icmp slt <4 x i64> %a0, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %2 = select <4 x i1> %1, <4 x i64> %a0, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %3 = icmp sgt <4 x i64> %2, zeroinitializer
  %4 = select <4 x i1> %3, <4 x i64> %2, <4 x i64> zeroinitializer
  %5 = trunc <4 x i64> %4 to <4 x i32>
  ret <4 x i32> %5
}


define <8 x i32> @trunc_packus_v8i64_v8i32(ptr %p0) "min-legal-vector-width"="256" {
; SSE2-SSSE3-LABEL: trunc_packus_v8i64_v8i32:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    movdqa (%rdi), %xmm3
; SSE2-SSSE3-NEXT:    movdqa 16(%rdi), %xmm8
; SSE2-SSSE3-NEXT:    movdqa 32(%rdi), %xmm6
; SSE2-SSSE3-NEXT:    movdqa 48(%rdi), %xmm1
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm4 = [4294967295,4294967295]
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm0 = [2147483648,2147483648]
; SSE2-SSSE3-NEXT:    movdqa %xmm3, %xmm2
; SSE2-SSSE3-NEXT:    pxor %xmm0, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm2[1,1,3,3]
; SSE2-SSSE3-NEXT:    pxor %xmm7, %xmm7
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm7, %xmm9
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm5 = [2147483647,2147483647]
; SSE2-SSSE3-NEXT:    movdqa %xmm5, %xmm10
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm2, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm10[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm11
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm10[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm11, %xmm2
; SSE2-SSSE3-NEXT:    pand %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm2
; SSE2-SSSE3-NEXT:    por %xmm3, %xmm2
; SSE2-SSSE3-NEXT:    movdqa %xmm8, %xmm3
; SSE2-SSSE3-NEXT:    pxor %xmm0, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm7, %xmm9
; SSE2-SSSE3-NEXT:    movdqa %xmm5, %xmm10
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm3, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm10[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm11
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm10[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm11, %xmm3
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm8
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm3
; SSE2-SSSE3-NEXT:    por %xmm8, %xmm3
; SSE2-SSSE3-NEXT:    movdqa %xmm6, %xmm8
; SSE2-SSSE3-NEXT:    pxor %xmm0, %xmm8
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm8[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm7, %xmm9
; SSE2-SSSE3-NEXT:    movdqa %xmm5, %xmm10
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm8, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm10[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm11
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm8 = xmm10[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm11, %xmm8
; SSE2-SSSE3-NEXT:    pand %xmm8, %xmm6
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm8
; SSE2-SSSE3-NEXT:    por %xmm6, %xmm8
; SSE2-SSSE3-NEXT:    movdqa %xmm1, %xmm6
; SSE2-SSSE3-NEXT:    pxor %xmm0, %xmm6
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm6[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm7, %xmm9
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm6, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm6
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm6, %xmm5
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm1
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    por %xmm1, %xmm5
; SSE2-SSSE3-NEXT:    movdqa %xmm5, %xmm1
; SSE2-SSSE3-NEXT:    pxor %xmm0, %xmm1
; SSE2-SSSE3-NEXT:    movdqa %xmm1, %xmm4
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm0, %xmm4
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm1, %xmm4
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm4
; SSE2-SSSE3-NEXT:    movdqa %xmm8, %xmm1
; SSE2-SSSE3-NEXT:    pxor %xmm0, %xmm1
; SSE2-SSSE3-NEXT:    movdqa %xmm1, %xmm5
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm0, %xmm5
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm6
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm5[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm6, %xmm1
; SSE2-SSSE3-NEXT:    pand %xmm8, %xmm1
; SSE2-SSSE3-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm4[0,2]
; SSE2-SSSE3-NEXT:    movdqa %xmm3, %xmm4
; SSE2-SSSE3-NEXT:    pxor %xmm0, %xmm4
; SSE2-SSSE3-NEXT:    movdqa %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm0, %xmm5
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm0, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm5
; SSE2-SSSE3-NEXT:    movdqa %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pxor %xmm0, %xmm3
; SSE2-SSSE3-NEXT:    movdqa %xmm3, %xmm4
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm0, %xmm4
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm0, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm3, %xmm0
; SSE2-SSSE3-NEXT:    pand %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm5[0,2]
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_packus_v8i64_v8i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa (%rdi), %xmm5
; SSE41-NEXT:    movdqa 16(%rdi), %xmm8
; SSE41-NEXT:    movdqa 32(%rdi), %xmm7
; SSE41-NEXT:    movdqa 48(%rdi), %xmm2
; SSE41-NEXT:    movapd {{.*#+}} xmm1 = [4294967295,4294967295]
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm3 = [2147483648,2147483648]
; SSE41-NEXT:    movdqa %xmm5, %xmm4
; SSE41-NEXT:    pxor %xmm3, %xmm4
; SSE41-NEXT:    pmovsxdq {{.*#+}} xmm6 = [2147483647,2147483647]
; SSE41-NEXT:    movdqa %xmm6, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm4, %xmm9
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[0,0,2,2]
; SSE41-NEXT:    pand %xmm4, %xmm0
; SSE41-NEXT:    por %xmm9, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm4
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm4
; SSE41-NEXT:    movdqa %xmm8, %xmm5
; SSE41-NEXT:    pxor %xmm3, %xmm5
; SSE41-NEXT:    movdqa %xmm6, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm5, %xmm9
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm5
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm9, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm5
; SSE41-NEXT:    blendvpd %xmm0, %xmm8, %xmm5
; SSE41-NEXT:    movdqa %xmm7, %xmm8
; SSE41-NEXT:    pxor %xmm3, %xmm8
; SSE41-NEXT:    movdqa %xmm6, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm8, %xmm9
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm8
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[0,0,2,2]
; SSE41-NEXT:    pand %xmm8, %xmm0
; SSE41-NEXT:    por %xmm9, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm8
; SSE41-NEXT:    blendvpd %xmm0, %xmm7, %xmm8
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    pxor %xmm3, %xmm0
; SSE41-NEXT:    movdqa %xmm0, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    por %xmm6, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm1
; SSE41-NEXT:    xorpd %xmm2, %xmm2
; SSE41-NEXT:    movapd %xmm1, %xmm6
; SSE41-NEXT:    xorpd %xmm3, %xmm6
; SSE41-NEXT:    movapd %xmm6, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm3, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    por %xmm6, %xmm0
; SSE41-NEXT:    pxor %xmm6, %xmm6
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm6
; SSE41-NEXT:    movapd %xmm8, %xmm1
; SSE41-NEXT:    xorpd %xmm3, %xmm1
; SSE41-NEXT:    movapd %xmm1, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm3, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm1
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,0,2,2]
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    pxor %xmm1, %xmm1
; SSE41-NEXT:    blendvpd %xmm0, %xmm8, %xmm1
; SSE41-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm6[0,2]
; SSE41-NEXT:    movapd %xmm5, %xmm6
; SSE41-NEXT:    xorpd %xmm3, %xmm6
; SSE41-NEXT:    movapd %xmm6, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm3, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    por %xmm6, %xmm0
; SSE41-NEXT:    pxor %xmm6, %xmm6
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm6
; SSE41-NEXT:    movapd %xmm4, %xmm5
; SSE41-NEXT:    xorpd %xmm3, %xmm5
; SSE41-NEXT:    movapd %xmm5, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm3, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm5
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm5[0,0,2,2]
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    por %xmm5, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm4, %xmm2
; SSE41-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,2],xmm6[0,2]
; SSE41-NEXT:    movaps %xmm2, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_packus_v8i64_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX1-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX1-NEXT:    vmovdqa 48(%rdi), %xmm3
; AVX1-NEXT:    vpmovsxbd {{.*#+}} xmm4 = [4294967295,0,4294967295,0]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm4, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpcmpgtq %xmm3, %xmm4, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm4, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm4, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm2, %xmm5
; AVX1-NEXT:    vpand %xmm2, %xmm5, %xmm2
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm0, %xmm5
; AVX1-NEXT:    vpand %xmm0, %xmm5, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm3, %xmm5
; AVX1-NEXT:    vpand %xmm3, %xmm5, %xmm3
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm1, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm1[0,2],ymm0[4,6],ymm1[4,6]
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_packus_v8i64_v8i32:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-SLOW-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [4294967295,4294967295,4294967295,4294967295]
; AVX2-SLOW-NEXT:    vpcmpgtq %ymm0, %ymm2, %ymm3
; AVX2-SLOW-NEXT:    vblendvpd %ymm3, %ymm0, %ymm2, %ymm0
; AVX2-SLOW-NEXT:    vpcmpgtq %ymm1, %ymm2, %ymm3
; AVX2-SLOW-NEXT:    vblendvpd %ymm3, %ymm1, %ymm2, %ymm1
; AVX2-SLOW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-SLOW-NEXT:    vpcmpgtq %ymm2, %ymm1, %ymm3
; AVX2-SLOW-NEXT:    vpand %ymm1, %ymm3, %ymm1
; AVX2-SLOW-NEXT:    vpcmpgtq %ymm2, %ymm0, %ymm2
; AVX2-SLOW-NEXT:    vpand %ymm0, %ymm2, %ymm0
; AVX2-SLOW-NEXT:    vperm2i128 {{.*#+}} ymm2 = ymm0[2,3],ymm1[2,3]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm2[0,2],ymm0[4,6],ymm2[4,6]
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: trunc_packus_v8i64_v8i32:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-FAST-ALL-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-FAST-ALL-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [4294967295,4294967295,4294967295,4294967295]
; AVX2-FAST-ALL-NEXT:    vpcmpgtq %ymm0, %ymm2, %ymm3
; AVX2-FAST-ALL-NEXT:    vblendvpd %ymm3, %ymm0, %ymm2, %ymm0
; AVX2-FAST-ALL-NEXT:    vpcmpgtq %ymm1, %ymm2, %ymm3
; AVX2-FAST-ALL-NEXT:    vblendvpd %ymm3, %ymm1, %ymm2, %ymm1
; AVX2-FAST-ALL-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-FAST-ALL-NEXT:    vpcmpgtq %ymm2, %ymm1, %ymm3
; AVX2-FAST-ALL-NEXT:    vpand %ymm1, %ymm3, %ymm1
; AVX2-FAST-ALL-NEXT:    vpcmpgtq %ymm2, %ymm0, %ymm2
; AVX2-FAST-ALL-NEXT:    vpand %ymm0, %ymm2, %ymm0
; AVX2-FAST-ALL-NEXT:    vpmovsxbd {{.*#+}} ymm2 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-ALL-NEXT:    vpermd %ymm0, %ymm2, %ymm0
; AVX2-FAST-ALL-NEXT:    vpermd %ymm1, %ymm2, %ymm1
; AVX2-FAST-ALL-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: trunc_packus_v8i64_v8i32:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [4294967295,4294967295,4294967295,4294967295]
; AVX2-FAST-PERLANE-NEXT:    vpcmpgtq %ymm0, %ymm2, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vblendvpd %ymm3, %ymm0, %ymm2, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpcmpgtq %ymm1, %ymm2, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vblendvpd %ymm3, %ymm1, %ymm2, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-FAST-PERLANE-NEXT:    vpcmpgtq %ymm2, %ymm1, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpand %ymm1, %ymm3, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpcmpgtq %ymm2, %ymm0, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpand %ymm0, %ymm2, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vperm2i128 {{.*#+}} ymm2 = ymm0[2,3],ymm1[2,3]
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm2[0,2],ymm0[4,6],ymm2[4,6]
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512-LABEL: trunc_packus_v8i64_v8i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    vpmaxsq (%rdi), %zmm0, %zmm0
; AVX512-NEXT:    vpmovusqd %zmm0, %ymm0
; AVX512-NEXT:    retq
;
; SKX-LABEL: trunc_packus_v8i64_v8i32:
; SKX:       # %bb.0:
; SKX-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; SKX-NEXT:    vpmaxsq (%rdi), %ymm0, %ymm1
; SKX-NEXT:    vpmovusqd %ymm1, %xmm1
; SKX-NEXT:    vpmaxsq 32(%rdi), %ymm0, %ymm0
; SKX-NEXT:    vpmovusqd %ymm0, %xmm0
; SKX-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; SKX-NEXT:    retq
  %a0 = load <8 x i64>, ptr %p0
  %1 = icmp slt <8 x i64> %a0, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %2 = select <8 x i1> %1, <8 x i64> %a0, <8 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %3 = icmp sgt <8 x i64> %2, zeroinitializer
  %4 = select <8 x i1> %3, <8 x i64> %2, <8 x i64> zeroinitializer
  %5 = trunc <8 x i64> %4 to <8 x i32>
  ret <8 x i32> %5
}

;
; PACKUS saturation truncation to vXi16
;

define <2 x i16> @trunc_packus_v2i64_v2i16(<2 x i64> %a0) {
; SSE2-SSSE3-LABEL: trunc_packus_v2i64_v2i16:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648]
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm2
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[1,1,3,3]
; SSE2-SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm3, %xmm4
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [2147549183,2147549183]
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm0
; SSE2-SSSE3-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm3
; SSE2-SSSE3-NEXT:    movdqa %xmm3, %xmm0
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm2
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[0,0,2,2]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm1
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,2,2,3]
; SSE2-SSSE3-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_packus_v2i64_v2i16:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm1
; SSE41-NEXT:    movapd {{.*#+}} xmm2 = [65535,65535]
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm3 = [2147483648,2147483648]
; SSE41-NEXT:    pxor %xmm3, %xmm0
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm4 = [2147549183,2147549183]
; SSE41-NEXT:    movdqa %xmm0, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm4, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm2
; SSE41-NEXT:    xorpd %xmm1, %xmm1
; SSE41-NEXT:    movapd %xmm2, %xmm4
; SSE41-NEXT:    xorpd %xmm3, %xmm4
; SSE41-NEXT:    movapd %xmm4, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm3, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm1
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,2,2,3]
; SSE41-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_packus_v2i64_v2i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmovzxwq {{.*#+}} xmm1 = [65535,65535]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX1-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vpand %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_packus_v2i64_v2i16:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpmovzxwq {{.*#+}} xmm1 = [65535,65535]
; AVX2-SLOW-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX2-SLOW-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-SLOW-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-SLOW-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm1
; AVX2-SLOW-NEXT:    vpand %xmm0, %xmm1, %xmm0
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_packus_v2i64_v2i16:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vpmovzxwq {{.*#+}} xmm1 = [65535,65535]
; AVX2-FAST-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX2-FAST-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-FAST-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-FAST-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm1
; AVX2-FAST-NEXT:    vpand %xmm0, %xmm1, %xmm0
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,8,9,8,9,10,11,8,9,10,11,12,13,14,15]
; AVX2-FAST-NEXT:    retq
;
; AVX512F-LABEL: trunc_packus_v2i64_v2i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    vpmovusqw %zmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_packus_v2i64_v2i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vpmaxsq %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    vpmovusqw %xmm0, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_packus_v2i64_v2i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512BW-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BW-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovusqw %zmm0, %xmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_packus_v2i64_v2i16:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpmaxsq %xmm1, %xmm0, %xmm0
; AVX512BWVL-NEXT:    vpmovusqw %xmm0, %xmm0
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_packus_v2i64_v2i16:
; SKX:       # %bb.0:
; SKX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; SKX-NEXT:    vpmaxsq %xmm1, %xmm0, %xmm0
; SKX-NEXT:    vpmovusqw %xmm0, %xmm0
; SKX-NEXT:    retq
  %1 = icmp slt <2 x i64> %a0, <i64 65535, i64 65535>
  %2 = select <2 x i1> %1, <2 x i64> %a0, <2 x i64> <i64 65535, i64 65535>
  %3 = icmp sgt <2 x i64> %2, zeroinitializer
  %4 = select <2 x i1> %3, <2 x i64> %2, <2 x i64> zeroinitializer
  %5 = trunc <2 x i64> %4 to <2 x i16>
  ret <2 x i16> %5
}

define void @trunc_packus_v2i64_v2i16_store(<2 x i64> %a0, ptr%p1) {
; SSE2-SSSE3-LABEL: trunc_packus_v2i64_v2i16_store:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648]
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm2
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[1,1,3,3]
; SSE2-SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm3, %xmm4
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [2147549183,2147549183]
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm0
; SSE2-SSSE3-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm3
; SSE2-SSSE3-NEXT:    movdqa %xmm3, %xmm0
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm2
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[0,0,2,2]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm1
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,2,2,3]
; SSE2-SSSE3-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; SSE2-SSSE3-NEXT:    movd %xmm0, (%rdi)
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_packus_v2i64_v2i16_store:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm1
; SSE41-NEXT:    movapd {{.*#+}} xmm2 = [65535,65535]
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm3 = [2147483648,2147483648]
; SSE41-NEXT:    pxor %xmm3, %xmm0
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm4 = [2147549183,2147549183]
; SSE41-NEXT:    movdqa %xmm0, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm4, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm2
; SSE41-NEXT:    xorpd %xmm1, %xmm1
; SSE41-NEXT:    movapd %xmm2, %xmm4
; SSE41-NEXT:    xorpd %xmm3, %xmm4
; SSE41-NEXT:    movapd %xmm4, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm3, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm1
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,2,2,3]
; SSE41-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; SSE41-NEXT:    movd %xmm0, (%rdi)
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_packus_v2i64_v2i16_store:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmovzxwq {{.*#+}} xmm1 = [65535,65535]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX1-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vpand %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; AVX1-NEXT:    vmovd %xmm0, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_packus_v2i64_v2i16_store:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpmovzxwq {{.*#+}} xmm1 = [65535,65535]
; AVX2-SLOW-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX2-SLOW-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-SLOW-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-SLOW-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm1
; AVX2-SLOW-NEXT:    vpand %xmm0, %xmm1, %xmm0
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vmovd %xmm0, (%rdi)
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_packus_v2i64_v2i16_store:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vpmovzxwq {{.*#+}} xmm1 = [65535,65535]
; AVX2-FAST-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX2-FAST-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-FAST-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-FAST-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm1
; AVX2-FAST-NEXT:    vpand %xmm0, %xmm1, %xmm0
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,8,9,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vmovd %xmm0, (%rdi)
; AVX2-FAST-NEXT:    retq
;
; AVX512F-LABEL: trunc_packus_v2i64_v2i16_store:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    vpmovusqw %zmm0, %xmm0
; AVX512F-NEXT:    vmovd %xmm0, (%rdi)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_packus_v2i64_v2i16_store:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vpmaxsq %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    vpmovusqw %xmm0, (%rdi)
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_packus_v2i64_v2i16_store:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512BW-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BW-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovusqw %zmm0, %xmm0
; AVX512BW-NEXT:    vmovd %xmm0, (%rdi)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_packus_v2i64_v2i16_store:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpmaxsq %xmm1, %xmm0, %xmm0
; AVX512BWVL-NEXT:    vpmovusqw %xmm0, (%rdi)
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_packus_v2i64_v2i16_store:
; SKX:       # %bb.0:
; SKX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; SKX-NEXT:    vpmaxsq %xmm1, %xmm0, %xmm0
; SKX-NEXT:    vpmovusqw %xmm0, (%rdi)
; SKX-NEXT:    retq
  %1 = icmp slt <2 x i64> %a0, <i64 65535, i64 65535>
  %2 = select <2 x i1> %1, <2 x i64> %a0, <2 x i64> <i64 65535, i64 65535>
  %3 = icmp sgt <2 x i64> %2, zeroinitializer
  %4 = select <2 x i1> %3, <2 x i64> %2, <2 x i64> zeroinitializer
  %5 = trunc <2 x i64> %4 to <2 x i16>
  store <2 x i16> %5, ptr%p1
  ret void
}

define <4 x i16> @trunc_packus_v4i64_v4i16(<4 x i64> %a0) {
; SSE2-SSSE3-LABEL: trunc_packus_v4i64_v4i16:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm4 = [65535,65535]
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [2147483648,2147483648]
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm5
; SSE2-SSSE3-NEXT:    pxor %xmm3, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[1,1,3,3]
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm2
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm2, %xmm6
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm7 = [2147549183,2147549183]
; SSE2-SSSE3-NEXT:    movdqa %xmm7, %xmm8
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm5, %xmm8
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm8[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm6, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm8[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm6
; SSE2-SSSE3-NEXT:    pand %xmm6, %xmm0
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm6
; SSE2-SSSE3-NEXT:    por %xmm6, %xmm0
; SSE2-SSSE3-NEXT:    movdqa %xmm1, %xmm5
; SSE2-SSSE3-NEXT:    pxor %xmm3, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm2, %xmm6
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm5, %xmm7
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm7[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm6, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm7[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm6
; SSE2-SSSE3-NEXT:    pand %xmm6, %xmm1
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm6
; SSE2-SSSE3-NEXT:    por %xmm1, %xmm6
; SSE2-SSSE3-NEXT:    movdqa %xmm6, %xmm1
; SSE2-SSSE3-NEXT:    pxor %xmm3, %xmm1
; SSE2-SSSE3-NEXT:    movdqa %xmm1, %xmm4
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm3, %xmm4
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm3, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm1, %xmm4
; SSE2-SSSE3-NEXT:    pand %xmm6, %xmm4
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm1
; SSE2-SSSE3-NEXT:    pxor %xmm3, %xmm1
; SSE2-SSSE3-NEXT:    movdqa %xmm1, %xmm5
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm3, %xmm5
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm3, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm5[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm1, %xmm3
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm0
; SSE2-SSSE3-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm4[0,2]
; SSE2-SSSE3-NEXT:    pslld $16, %xmm0
; SSE2-SSSE3-NEXT:    psrad $16, %xmm0
; SSE2-SSSE3-NEXT:    packssdw %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_packus_v4i64_v4i16:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    movapd {{.*#+}} xmm4 = [65535,65535]
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm3 = [2147483648,2147483648]
; SSE41-NEXT:    movdqa %xmm0, %xmm5
; SSE41-NEXT:    pxor %xmm3, %xmm5
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm6 = [2147549183,2147549183]
; SSE41-NEXT:    movdqa %xmm6, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm5, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm5
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm7, %xmm0
; SSE41-NEXT:    movapd %xmm4, %xmm5
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm5
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    pxor %xmm3, %xmm0
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm2
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE41-NEXT:    pand %xmm2, %xmm0
; SSE41-NEXT:    por %xmm6, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm4
; SSE41-NEXT:    xorpd %xmm1, %xmm1
; SSE41-NEXT:    movapd %xmm4, %xmm2
; SSE41-NEXT:    xorpd %xmm3, %xmm2
; SSE41-NEXT:    movapd %xmm2, %xmm6
; SSE41-NEXT:    pcmpeqd %xmm3, %xmm6
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,0,2,2]
; SSE41-NEXT:    pand %xmm6, %xmm0
; SSE41-NEXT:    por %xmm2, %xmm0
; SSE41-NEXT:    pxor %xmm2, %xmm2
; SSE41-NEXT:    blendvpd %xmm0, %xmm4, %xmm2
; SSE41-NEXT:    movapd %xmm5, %xmm4
; SSE41-NEXT:    xorpd %xmm3, %xmm4
; SSE41-NEXT:    movapd %xmm4, %xmm6
; SSE41-NEXT:    pcmpeqd %xmm3, %xmm6
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,0,2,2]
; SSE41-NEXT:    pand %xmm6, %xmm0
; SSE41-NEXT:    por %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm1
; SSE41-NEXT:    packusdw %xmm2, %xmm1
; SSE41-NEXT:    packusdw %xmm1, %xmm1
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_packus_v4i64_v4i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmovzxwq {{.*#+}} xmm1 = [65535,65535]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX1-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm3
; AVX1-NEXT:    vblendvpd %xmm3, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm3
; AVX1-NEXT:    vpand %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpackusdw %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_packus_v4i64_v4i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [65535,65535,65535,65535]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_packus_v4i64_v4i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    vpmovusqw %zmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_packus_v4i64_v4i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vpmaxsq %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    vpmovusqw %ymm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_packus_v4i64_v4i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BW-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovusqw %zmm0, %xmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_packus_v4i64_v4i16:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpmaxsq %ymm1, %ymm0, %ymm0
; AVX512BWVL-NEXT:    vpmovusqw %ymm0, %xmm0
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_packus_v4i64_v4i16:
; SKX:       # %bb.0:
; SKX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; SKX-NEXT:    vpmaxsq %ymm1, %ymm0, %ymm0
; SKX-NEXT:    vpmovusqw %ymm0, %xmm0
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %1 = icmp slt <4 x i64> %a0, <i64 65535, i64 65535, i64 65535, i64 65535>
  %2 = select <4 x i1> %1, <4 x i64> %a0, <4 x i64> <i64 65535, i64 65535, i64 65535, i64 65535>
  %3 = icmp sgt <4 x i64> %2, zeroinitializer
  %4 = select <4 x i1> %3, <4 x i64> %2, <4 x i64> zeroinitializer
  %5 = trunc <4 x i64> %4 to <4 x i16>
  ret <4 x i16> %5
}

define void @trunc_packus_v4i64_v4i16_store(<4 x i64> %a0, ptr%p1) {
; SSE2-SSSE3-LABEL: trunc_packus_v4i64_v4i16_store:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm4 = [65535,65535]
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648]
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm3
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    pxor %xmm6, %xmm6
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm5
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm7 = [2147549183,2147549183]
; SSE2-SSSE3-NEXT:    movdqa %xmm7, %xmm8
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm3, %xmm8
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm8[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm9
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm8[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm9, %xmm3
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm0
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm3
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm3
; SSE2-SSSE3-NEXT:    movdqa %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm5
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm0, %xmm7
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm7[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm5
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm1
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    por %xmm1, %xmm5
; SSE2-SSSE3-NEXT:    movdqa %xmm5, %xmm0
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm1
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm2, %xmm1
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm1
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm1
; SSE2-SSSE3-NEXT:    movdqa %xmm3, %xmm0
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm4
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm2, %xmm4
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm4[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm2
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm2
; SSE2-SSSE3-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,2],xmm1[0,2]
; SSE2-SSSE3-NEXT:    pslld $16, %xmm2
; SSE2-SSSE3-NEXT:    psrad $16, %xmm2
; SSE2-SSSE3-NEXT:    packssdw %xmm2, %xmm2
; SSE2-SSSE3-NEXT:    movq %xmm2, (%rdi)
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_packus_v4i64_v4i16_store:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    movapd {{.*#+}} xmm4 = [65535,65535]
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm3 = [2147483648,2147483648]
; SSE41-NEXT:    movdqa %xmm0, %xmm5
; SSE41-NEXT:    pxor %xmm3, %xmm5
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm6 = [2147549183,2147549183]
; SSE41-NEXT:    movdqa %xmm6, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm5, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm5
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm7, %xmm0
; SSE41-NEXT:    movapd %xmm4, %xmm5
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm5
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    pxor %xmm3, %xmm0
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm2
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE41-NEXT:    pand %xmm2, %xmm0
; SSE41-NEXT:    por %xmm6, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm4
; SSE41-NEXT:    xorpd %xmm1, %xmm1
; SSE41-NEXT:    movapd %xmm4, %xmm2
; SSE41-NEXT:    xorpd %xmm3, %xmm2
; SSE41-NEXT:    movapd %xmm2, %xmm6
; SSE41-NEXT:    pcmpeqd %xmm3, %xmm6
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,0,2,2]
; SSE41-NEXT:    pand %xmm6, %xmm0
; SSE41-NEXT:    por %xmm2, %xmm0
; SSE41-NEXT:    pxor %xmm2, %xmm2
; SSE41-NEXT:    blendvpd %xmm0, %xmm4, %xmm2
; SSE41-NEXT:    movapd %xmm5, %xmm4
; SSE41-NEXT:    xorpd %xmm3, %xmm4
; SSE41-NEXT:    movapd %xmm4, %xmm6
; SSE41-NEXT:    pcmpeqd %xmm3, %xmm6
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,0,2,2]
; SSE41-NEXT:    pand %xmm6, %xmm0
; SSE41-NEXT:    por %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm1
; SSE41-NEXT:    packusdw %xmm2, %xmm1
; SSE41-NEXT:    packusdw %xmm1, %xmm1
; SSE41-NEXT:    movq %xmm1, (%rdi)
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_packus_v4i64_v4i16_store:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmovzxwq {{.*#+}} xmm1 = [65535,65535]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX1-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm3
; AVX1-NEXT:    vblendvpd %xmm3, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm3
; AVX1-NEXT:    vpand %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpackusdw %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vmovq %xmm0, (%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_packus_v4i64_v4i16_store:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [65535,65535,65535,65535]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vmovq %xmm0, (%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_packus_v4i64_v4i16_store:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    vpmovusqw %zmm0, %xmm0
; AVX512F-NEXT:    vmovq %xmm0, (%rdi)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_packus_v4i64_v4i16_store:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vpmaxsq %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    vpmovusqw %ymm0, (%rdi)
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_packus_v4i64_v4i16_store:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BW-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovusqw %zmm0, %xmm0
; AVX512BW-NEXT:    vmovq %xmm0, (%rdi)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_packus_v4i64_v4i16_store:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpmaxsq %ymm1, %ymm0, %ymm0
; AVX512BWVL-NEXT:    vpmovusqw %ymm0, (%rdi)
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_packus_v4i64_v4i16_store:
; SKX:       # %bb.0:
; SKX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; SKX-NEXT:    vpmaxsq %ymm1, %ymm0, %ymm0
; SKX-NEXT:    vpmovusqw %ymm0, (%rdi)
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %1 = icmp slt <4 x i64> %a0, <i64 65535, i64 65535, i64 65535, i64 65535>
  %2 = select <4 x i1> %1, <4 x i64> %a0, <4 x i64> <i64 65535, i64 65535, i64 65535, i64 65535>
  %3 = icmp sgt <4 x i64> %2, zeroinitializer
  %4 = select <4 x i1> %3, <4 x i64> %2, <4 x i64> zeroinitializer
  %5 = trunc <4 x i64> %4 to <4 x i16>
  store <4 x i16> %5, ptr%p1
  ret void
}

define <8 x i16> @trunc_packus_v8i64_v8i16(ptr %p0) "min-legal-vector-width"="256" {
; SSE2-SSSE3-LABEL: trunc_packus_v8i64_v8i16:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    movdqa (%rdi), %xmm5
; SSE2-SSSE3-NEXT:    movdqa 16(%rdi), %xmm0
; SSE2-SSSE3-NEXT:    movdqa 32(%rdi), %xmm3
; SSE2-SSSE3-NEXT:    movdqa 48(%rdi), %xmm8
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm4 = [65535,65535]
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648]
; SSE2-SSSE3-NEXT:    movdqa %xmm3, %xmm2
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm2[1,1,3,3]
; SSE2-SSSE3-NEXT:    pxor %xmm7, %xmm7
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm7, %xmm9
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm6 = [2147549183,2147549183]
; SSE2-SSSE3-NEXT:    movdqa %xmm6, %xmm10
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm2, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm10[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm11
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm10[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm11, %xmm2
; SSE2-SSSE3-NEXT:    pand %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm2
; SSE2-SSSE3-NEXT:    por %xmm3, %xmm2
; SSE2-SSSE3-NEXT:    movdqa %xmm8, %xmm3
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm7, %xmm9
; SSE2-SSSE3-NEXT:    movdqa %xmm6, %xmm10
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm3, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm10[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm11
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm10[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm11, %xmm3
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm8
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm3
; SSE2-SSSE3-NEXT:    por %xmm8, %xmm3
; SSE2-SSSE3-NEXT:    movdqa %xmm5, %xmm8
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm8
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm8[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm7, %xmm9
; SSE2-SSSE3-NEXT:    movdqa %xmm6, %xmm10
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm8, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm10[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm11
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm8 = xmm10[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm11, %xmm8
; SSE2-SSSE3-NEXT:    pand %xmm8, %xmm5
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm8
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm8
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm5
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm5[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm7, %xmm9
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm5, %xmm6
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm6[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm6
; SSE2-SSSE3-NEXT:    pand %xmm6, %xmm0
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm6
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm6
; SSE2-SSSE3-NEXT:    movdqa %xmm6, %xmm0
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm4
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm1, %xmm4
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm4
; SSE2-SSSE3-NEXT:    pand %xmm6, %xmm4
; SSE2-SSSE3-NEXT:    movdqa %xmm8, %xmm0
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm5
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm1, %xmm5
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm6
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm5[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm6, %xmm0
; SSE2-SSSE3-NEXT:    pand %xmm8, %xmm0
; SSE2-SSSE3-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm4[0,2]
; SSE2-SSSE3-NEXT:    movdqa %xmm3, %xmm4
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm4
; SSE2-SSSE3-NEXT:    movdqa %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm1, %xmm5
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm1, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm5
; SSE2-SSSE3-NEXT:    movdqa %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm3
; SSE2-SSSE3-NEXT:    movdqa %xmm3, %xmm4
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm1, %xmm4
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm1, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm4[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm1, %xmm3
; SSE2-SSSE3-NEXT:    pand %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,2],xmm5[0,2]
; SSE2-SSSE3-NEXT:    pslld $16, %xmm3
; SSE2-SSSE3-NEXT:    psrad $16, %xmm3
; SSE2-SSSE3-NEXT:    pslld $16, %xmm0
; SSE2-SSSE3-NEXT:    psrad $16, %xmm0
; SSE2-SSSE3-NEXT:    packssdw %xmm3, %xmm0
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_packus_v8i64_v8i16:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa (%rdi), %xmm7
; SSE41-NEXT:    movdqa 16(%rdi), %xmm5
; SSE41-NEXT:    movdqa 32(%rdi), %xmm4
; SSE41-NEXT:    movdqa 48(%rdi), %xmm8
; SSE41-NEXT:    movapd {{.*#+}} xmm1 = [65535,65535]
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm2 = [2147483648,2147483648]
; SSE41-NEXT:    movdqa %xmm4, %xmm3
; SSE41-NEXT:    pxor %xmm2, %xmm3
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm6 = [2147549183,2147549183]
; SSE41-NEXT:    movdqa %xmm6, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm9
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[0,0,2,2]
; SSE41-NEXT:    pand %xmm3, %xmm0
; SSE41-NEXT:    por %xmm9, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm3
; SSE41-NEXT:    blendvpd %xmm0, %xmm4, %xmm3
; SSE41-NEXT:    movdqa %xmm8, %xmm4
; SSE41-NEXT:    pxor %xmm2, %xmm4
; SSE41-NEXT:    movdqa %xmm6, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm4, %xmm9
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[0,0,2,2]
; SSE41-NEXT:    pand %xmm4, %xmm0
; SSE41-NEXT:    por %xmm9, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm4
; SSE41-NEXT:    blendvpd %xmm0, %xmm8, %xmm4
; SSE41-NEXT:    movdqa %xmm7, %xmm8
; SSE41-NEXT:    pxor %xmm2, %xmm8
; SSE41-NEXT:    movdqa %xmm6, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm8, %xmm9
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm8
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[0,0,2,2]
; SSE41-NEXT:    pand %xmm8, %xmm0
; SSE41-NEXT:    por %xmm9, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm8
; SSE41-NEXT:    blendvpd %xmm0, %xmm7, %xmm8
; SSE41-NEXT:    movdqa %xmm5, %xmm0
; SSE41-NEXT:    pxor %xmm2, %xmm0
; SSE41-NEXT:    movdqa %xmm0, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    por %xmm6, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm1
; SSE41-NEXT:    xorpd %xmm5, %xmm5
; SSE41-NEXT:    movapd %xmm1, %xmm6
; SSE41-NEXT:    xorpd %xmm2, %xmm6
; SSE41-NEXT:    movapd %xmm6, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm2, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    por %xmm6, %xmm0
; SSE41-NEXT:    pxor %xmm6, %xmm6
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm6
; SSE41-NEXT:    movapd %xmm8, %xmm1
; SSE41-NEXT:    xorpd %xmm2, %xmm1
; SSE41-NEXT:    movapd %xmm1, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm2, %xmm1
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,0,2,2]
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    pxor %xmm1, %xmm1
; SSE41-NEXT:    blendvpd %xmm0, %xmm8, %xmm1
; SSE41-NEXT:    packusdw %xmm6, %xmm1
; SSE41-NEXT:    movapd %xmm4, %xmm6
; SSE41-NEXT:    xorpd %xmm2, %xmm6
; SSE41-NEXT:    movapd %xmm6, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm2, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    por %xmm6, %xmm0
; SSE41-NEXT:    pxor %xmm6, %xmm6
; SSE41-NEXT:    blendvpd %xmm0, %xmm4, %xmm6
; SSE41-NEXT:    movapd %xmm3, %xmm4
; SSE41-NEXT:    xorpd %xmm2, %xmm4
; SSE41-NEXT:    movapd %xmm4, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm2, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,0,2,2]
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    por %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm3, %xmm5
; SSE41-NEXT:    packusdw %xmm6, %xmm5
; SSE41-NEXT:    packusdw %xmm5, %xmm1
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_packus_v8i64_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX1-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX1-NEXT:    vmovdqa 48(%rdi), %xmm3
; AVX1-NEXT:    vpmovzxwq {{.*#+}} xmm4 = [65535,65535]
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm4, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpcmpgtq %xmm3, %xmm4, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm4, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm4, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm1, %xmm5
; AVX1-NEXT:    vpand %xmm1, %xmm5, %xmm1
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm0, %xmm5
; AVX1-NEXT:    vpand %xmm0, %xmm5, %xmm0
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm3, %xmm1
; AVX1-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm2, %xmm3
; AVX1-NEXT:    vpand %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpackusdw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_packus_v8i64_v8i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [65535,65535,65535,65535]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm2, %ymm3
; AVX2-NEXT:    vblendvpd %ymm3, %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm2, %ymm3
; AVX2-NEXT:    vblendvpd %ymm3, %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm1, %ymm3
; AVX2-NEXT:    vpand %ymm1, %ymm3, %ymm1
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vpand %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpackusdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_packus_v8i64_v8i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    vpmaxsq (%rdi), %zmm0, %zmm0
; AVX512-NEXT:    vpmovusqw %zmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; SKX-LABEL: trunc_packus_v8i64_v8i16:
; SKX:       # %bb.0:
; SKX-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; SKX-NEXT:    vpmaxsq 32(%rdi), %ymm0, %ymm1
; SKX-NEXT:    vpmovusqw %ymm1, %xmm1
; SKX-NEXT:    vpmaxsq (%rdi), %ymm0, %ymm0
; SKX-NEXT:    vpmovusqw %ymm0, %xmm0
; SKX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %a0 = load <8 x i64>, ptr %p0
  %1 = icmp slt <8 x i64> %a0, <i64 65535, i64 65535, i64 65535, i64 65535, i64 65535, i64 65535, i64 65535, i64 65535>
  %2 = select <8 x i1> %1, <8 x i64> %a0, <8 x i64> <i64 65535, i64 65535, i64 65535, i64 65535, i64 65535, i64 65535, i64 65535, i64 65535>
  %3 = icmp sgt <8 x i64> %2, zeroinitializer
  %4 = select <8 x i1> %3, <8 x i64> %2, <8 x i64> zeroinitializer
  %5 = trunc <8 x i64> %4 to <8 x i16>
  ret <8 x i16> %5
}

define <4 x i16> @trunc_packus_v4i32_v4i16(<4 x i32> %a0) {
; SSE2-LABEL: trunc_packus_v4i32_v4i16:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,65535,65535]
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm2
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    pandn %xmm1, %xmm2
; SSE2-NEXT:    por %xmm0, %xmm2
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    movdqa %xmm2, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE2-NEXT:    pand %xmm2, %xmm1
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm1[0,2,2,3,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: trunc_packus_v4i32_v4i16:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,65535,65535]
; SSSE3-NEXT:    movdqa %xmm1, %xmm2
; SSSE3-NEXT:    pcmpgtd %xmm0, %xmm2
; SSSE3-NEXT:    pand %xmm2, %xmm0
; SSSE3-NEXT:    pandn %xmm1, %xmm2
; SSSE3-NEXT:    por %xmm2, %xmm0
; SSSE3-NEXT:    pxor %xmm1, %xmm1
; SSSE3-NEXT:    movdqa %xmm0, %xmm2
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm2
; SSSE3-NEXT:    pand %xmm2, %xmm0
; SSSE3-NEXT:    pshufb {{.*#+}} xmm0 = xmm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_packus_v4i32_v4i16:
; SSE41:       # %bb.0:
; SSE41-NEXT:    packusdw %xmm0, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: trunc_packus_v4i32_v4i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: trunc_packus_v4i32_v4i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    retq
;
; SKX-LABEL: trunc_packus_v4i32_v4i16:
; SKX:       # %bb.0:
; SKX-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; SKX-NEXT:    retq
  %1 = icmp slt <4 x i32> %a0, <i32 65535, i32 65535, i32 65535, i32 65535>
  %2 = select <4 x i1> %1, <4 x i32> %a0, <4 x i32> <i32 65535, i32 65535, i32 65535, i32 65535>
  %3 = icmp sgt <4 x i32> %2, zeroinitializer
  %4 = select <4 x i1> %3, <4 x i32> %2, <4 x i32> zeroinitializer
  %5 = trunc <4 x i32> %4 to <4 x i16>
  ret <4 x i16> %5
}

define void @trunc_packus_v4i32_v4i16_store(<4 x i32> %a0, ptr%p1) {
; SSE2-LABEL: trunc_packus_v4i32_v4i16_store:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,65535,65535]
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm2
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    pandn %xmm1, %xmm2
; SSE2-NEXT:    por %xmm0, %xmm2
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    movdqa %xmm2, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE2-NEXT:    pand %xmm2, %xmm1
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm1[0,2,2,3,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE2-NEXT:    movq %xmm0, (%rdi)
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: trunc_packus_v4i32_v4i16_store:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,65535,65535]
; SSSE3-NEXT:    movdqa %xmm1, %xmm2
; SSSE3-NEXT:    pcmpgtd %xmm0, %xmm2
; SSSE3-NEXT:    pand %xmm2, %xmm0
; SSSE3-NEXT:    pandn %xmm1, %xmm2
; SSSE3-NEXT:    por %xmm0, %xmm2
; SSSE3-NEXT:    pxor %xmm0, %xmm0
; SSSE3-NEXT:    movdqa %xmm2, %xmm1
; SSSE3-NEXT:    pcmpgtd %xmm0, %xmm1
; SSSE3-NEXT:    pand %xmm2, %xmm1
; SSSE3-NEXT:    pshufb {{.*#+}} xmm1 = xmm1[0,1,4,5,8,9,12,13,u,u,u,u,u,u,u,u]
; SSSE3-NEXT:    movq %xmm1, (%rdi)
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_packus_v4i32_v4i16_store:
; SSE41:       # %bb.0:
; SSE41-NEXT:    packusdw %xmm0, %xmm0
; SSE41-NEXT:    movq %xmm0, (%rdi)
; SSE41-NEXT:    retq
;
; AVX-LABEL: trunc_packus_v4i32_v4i16_store:
; AVX:       # %bb.0:
; AVX-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vmovq %xmm0, (%rdi)
; AVX-NEXT:    retq
;
; AVX512F-LABEL: trunc_packus_v4i32_v4i16_store:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    vmovq %xmm0, (%rdi)
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_packus_v4i32_v4i16_store:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    vpmovusdw %xmm0, (%rdi)
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_packus_v4i32_v4i16_store:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX512BW-NEXT:    vmovq %xmm0, (%rdi)
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_packus_v4i32_v4i16_store:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm0
; AVX512BWVL-NEXT:    vpmovusdw %xmm0, (%rdi)
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_packus_v4i32_v4i16_store:
; SKX:       # %bb.0:
; SKX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; SKX-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm0
; SKX-NEXT:    vpmovusdw %xmm0, (%rdi)
; SKX-NEXT:    retq
  %1 = icmp slt <4 x i32> %a0, <i32 65535, i32 65535, i32 65535, i32 65535>
  %2 = select <4 x i1> %1, <4 x i32> %a0, <4 x i32> <i32 65535, i32 65535, i32 65535, i32 65535>
  %3 = icmp sgt <4 x i32> %2, zeroinitializer
  %4 = select <4 x i1> %3, <4 x i32> %2, <4 x i32> zeroinitializer
  %5 = trunc <4 x i32> %4 to <4 x i16>
  store <4 x i16> %5, ptr%p1
  ret void
}

define <8 x i16> @trunc_packus_v8i32_v8i16(<8 x i32> %a0) {
; SSE2-LABEL: trunc_packus_v8i32_v8i16:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [65535,65535,65535,65535]
; SSE2-NEXT:    movdqa %xmm2, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm3
; SSE2-NEXT:    pand %xmm3, %xmm1
; SSE2-NEXT:    pandn %xmm2, %xmm3
; SSE2-NEXT:    por %xmm1, %xmm3
; SSE2-NEXT:    movdqa %xmm2, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    pandn %xmm2, %xmm1
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm2
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    movdqa %xmm3, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm2
; SSE2-NEXT:    pand %xmm3, %xmm2
; SSE2-NEXT:    pslld $16, %xmm2
; SSE2-NEXT:    psrad $16, %xmm2
; SSE2-NEXT:    pslld $16, %xmm0
; SSE2-NEXT:    psrad $16, %xmm0
; SSE2-NEXT:    packssdw %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: trunc_packus_v8i32_v8i16:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [65535,65535,65535,65535]
; SSSE3-NEXT:    movdqa %xmm2, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm3
; SSSE3-NEXT:    pand %xmm3, %xmm1
; SSSE3-NEXT:    pandn %xmm2, %xmm3
; SSSE3-NEXT:    por %xmm1, %xmm3
; SSSE3-NEXT:    movdqa %xmm2, %xmm1
; SSSE3-NEXT:    pcmpgtd %xmm0, %xmm1
; SSSE3-NEXT:    pand %xmm1, %xmm0
; SSSE3-NEXT:    pandn %xmm2, %xmm1
; SSSE3-NEXT:    por %xmm1, %xmm0
; SSSE3-NEXT:    pxor %xmm1, %xmm1
; SSSE3-NEXT:    movdqa %xmm0, %xmm2
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm2
; SSSE3-NEXT:    pand %xmm2, %xmm0
; SSSE3-NEXT:    movdqa %xmm3, %xmm2
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm2
; SSSE3-NEXT:    pand %xmm3, %xmm2
; SSSE3-NEXT:    movdqa {{.*#+}} xmm1 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; SSSE3-NEXT:    pshufb %xmm1, %xmm2
; SSSE3-NEXT:    pshufb %xmm1, %xmm0
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_packus_v8i32_v8i16:
; SSE41:       # %bb.0:
; SSE41-NEXT:    packusdw %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_packus_v8i32_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_packus_v8i32_v8i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_packus_v8i32_v8i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512F-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_packus_v8i32_v8i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vpmaxsd %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    vpmovusdw %ymm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_packus_v8i32_v8i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512BW-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_packus_v8i32_v8i16:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpmaxsd %ymm1, %ymm0, %ymm0
; AVX512BWVL-NEXT:    vpmovusdw %ymm0, %xmm0
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_packus_v8i32_v8i16:
; SKX:       # %bb.0:
; SKX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; SKX-NEXT:    vpmaxsd %ymm1, %ymm0, %ymm0
; SKX-NEXT:    vpmovusdw %ymm0, %xmm0
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %1 = icmp slt <8 x i32> %a0, <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>
  %2 = select <8 x i1> %1, <8 x i32> %a0, <8 x i32> <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>
  %3 = icmp sgt <8 x i32> %2, zeroinitializer
  %4 = select <8 x i1> %3, <8 x i32> %2, <8 x i32> zeroinitializer
  %5 = trunc <8 x i32> %4 to <8 x i16>
  ret <8 x i16> %5
}

define <16 x i16> @trunc_packus_v16i32_v16i16(ptr %p0) "min-legal-vector-width"="256" {
; SSE2-LABEL: trunc_packus_v16i32_v16i16:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa (%rdi), %xmm1
; SSE2-NEXT:    movdqa 16(%rdi), %xmm3
; SSE2-NEXT:    movdqa 32(%rdi), %xmm0
; SSE2-NEXT:    movdqa 48(%rdi), %xmm4
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [65535,65535,65535,65535]
; SSE2-NEXT:    movdqa %xmm5, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm3, %xmm2
; SSE2-NEXT:    pand %xmm2, %xmm3
; SSE2-NEXT:    pandn %xmm5, %xmm2
; SSE2-NEXT:    por %xmm3, %xmm2
; SSE2-NEXT:    movdqa %xmm5, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm3
; SSE2-NEXT:    pand %xmm3, %xmm1
; SSE2-NEXT:    pandn %xmm5, %xmm3
; SSE2-NEXT:    por %xmm1, %xmm3
; SSE2-NEXT:    movdqa %xmm5, %xmm6
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm6
; SSE2-NEXT:    pand %xmm6, %xmm4
; SSE2-NEXT:    pandn %xmm5, %xmm6
; SSE2-NEXT:    por %xmm4, %xmm6
; SSE2-NEXT:    movdqa %xmm5, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm4
; SSE2-NEXT:    pand %xmm4, %xmm0
; SSE2-NEXT:    pandn %xmm5, %xmm4
; SSE2-NEXT:    por %xmm0, %xmm4
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    movdqa %xmm4, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm5, %xmm1
; SSE2-NEXT:    pand %xmm4, %xmm1
; SSE2-NEXT:    movdqa %xmm6, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm5, %xmm4
; SSE2-NEXT:    pand %xmm6, %xmm4
; SSE2-NEXT:    movdqa %xmm3, %xmm0
; SSE2-NEXT:    pcmpgtd %xmm5, %xmm0
; SSE2-NEXT:    pand %xmm3, %xmm0
; SSE2-NEXT:    movdqa %xmm2, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm5, %xmm3
; SSE2-NEXT:    pand %xmm2, %xmm3
; SSE2-NEXT:    pslld $16, %xmm3
; SSE2-NEXT:    psrad $16, %xmm3
; SSE2-NEXT:    pslld $16, %xmm0
; SSE2-NEXT:    psrad $16, %xmm0
; SSE2-NEXT:    packssdw %xmm3, %xmm0
; SSE2-NEXT:    pslld $16, %xmm4
; SSE2-NEXT:    psrad $16, %xmm4
; SSE2-NEXT:    pslld $16, %xmm1
; SSE2-NEXT:    psrad $16, %xmm1
; SSE2-NEXT:    packssdw %xmm4, %xmm1
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: trunc_packus_v16i32_v16i16:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa (%rdi), %xmm1
; SSSE3-NEXT:    movdqa 16(%rdi), %xmm3
; SSSE3-NEXT:    movdqa 32(%rdi), %xmm0
; SSSE3-NEXT:    movdqa 48(%rdi), %xmm4
; SSSE3-NEXT:    movdqa {{.*#+}} xmm5 = [65535,65535,65535,65535]
; SSSE3-NEXT:    movdqa %xmm5, %xmm2
; SSSE3-NEXT:    pcmpgtd %xmm3, %xmm2
; SSSE3-NEXT:    pand %xmm2, %xmm3
; SSSE3-NEXT:    pandn %xmm5, %xmm2
; SSSE3-NEXT:    por %xmm3, %xmm2
; SSSE3-NEXT:    movdqa %xmm5, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm3
; SSSE3-NEXT:    pand %xmm3, %xmm1
; SSSE3-NEXT:    pandn %xmm5, %xmm3
; SSSE3-NEXT:    por %xmm1, %xmm3
; SSSE3-NEXT:    movdqa %xmm5, %xmm6
; SSSE3-NEXT:    pcmpgtd %xmm4, %xmm6
; SSSE3-NEXT:    pand %xmm6, %xmm4
; SSSE3-NEXT:    pandn %xmm5, %xmm6
; SSSE3-NEXT:    por %xmm4, %xmm6
; SSSE3-NEXT:    movdqa %xmm5, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm0, %xmm4
; SSSE3-NEXT:    pand %xmm4, %xmm0
; SSSE3-NEXT:    pandn %xmm5, %xmm4
; SSSE3-NEXT:    por %xmm0, %xmm4
; SSSE3-NEXT:    pxor %xmm5, %xmm5
; SSSE3-NEXT:    movdqa %xmm4, %xmm1
; SSSE3-NEXT:    pcmpgtd %xmm5, %xmm1
; SSSE3-NEXT:    pand %xmm4, %xmm1
; SSSE3-NEXT:    movdqa %xmm6, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm5, %xmm4
; SSSE3-NEXT:    pand %xmm6, %xmm4
; SSSE3-NEXT:    movdqa %xmm3, %xmm0
; SSSE3-NEXT:    pcmpgtd %xmm5, %xmm0
; SSSE3-NEXT:    pand %xmm3, %xmm0
; SSSE3-NEXT:    movdqa %xmm2, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm5, %xmm3
; SSSE3-NEXT:    pand %xmm2, %xmm3
; SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; SSSE3-NEXT:    pshufb %xmm2, %xmm3
; SSSE3-NEXT:    pshufb %xmm2, %xmm0
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm3[0]
; SSSE3-NEXT:    pshufb %xmm2, %xmm4
; SSSE3-NEXT:    pshufb %xmm2, %xmm1
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm4[0]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_packus_v16i32_v16i16:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa (%rdi), %xmm0
; SSE41-NEXT:    movdqa 32(%rdi), %xmm1
; SSE41-NEXT:    packusdw 16(%rdi), %xmm0
; SSE41-NEXT:    packusdw 48(%rdi), %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_packus_v16i32_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa 32(%rdi), %xmm1
; AVX1-NEXT:    vpackusdw 48(%rdi), %xmm1, %xmm1
; AVX1-NEXT:    vpackusdw 16(%rdi), %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_packus_v16i32_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vpackusdw 32(%rdi), %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_packus_v16i32_v16i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    vpmaxsd (%rdi), %zmm0, %zmm0
; AVX512-NEXT:    vpmovusdw %zmm0, %ymm0
; AVX512-NEXT:    retq
;
; SKX-LABEL: trunc_packus_v16i32_v16i16:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovdqa (%rdi), %ymm0
; SKX-NEXT:    vpackusdw 32(%rdi), %ymm0, %ymm0
; SKX-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; SKX-NEXT:    retq
  %a0 = load <16 x i32>, ptr %p0
  %1 = icmp slt <16 x i32> %a0, <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>
  %2 = select <16 x i1> %1, <16 x i32> %a0, <16 x i32> <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>
  %3 = icmp sgt <16 x i32> %2, zeroinitializer
  %4 = select <16 x i1> %3, <16 x i32> %2, <16 x i32> zeroinitializer
  %5 = trunc <16 x i32> %4 to <16 x i16>
  ret <16 x i16> %5
}

;
; PACKUS saturation truncation to vXi8
;

define <2 x i8> @trunc_packus_v2i64_v2i8(<2 x i64> %a0) {
; SSE2-LABEL: trunc_packus_v2i64_v2i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648]
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    pxor %xmm1, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[1,1,3,3]
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpeqd %xmm3, %xmm4
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [2147483903,2147483903]
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[0,0,2,2]
; SSE2-NEXT:    pand %xmm4, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2-NEXT:    por %xmm2, %xmm3
; SSE2-NEXT:    pand %xmm3, %xmm0
; SSE2-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSE2-NEXT:    por %xmm3, %xmm0
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    pxor %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm3[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,3,3]
; SSE2-NEXT:    pand %xmm4, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[1,1,3,3]
; SSE2-NEXT:    por %xmm1, %xmm2
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    packuswb %xmm0, %xmm0
; SSE2-NEXT:    packuswb %xmm0, %xmm0
; SSE2-NEXT:    packuswb %xmm0, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: trunc_packus_v2i64_v2i8:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648]
; SSSE3-NEXT:    movdqa %xmm0, %xmm2
; SSSE3-NEXT:    pxor %xmm1, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[1,1,3,3]
; SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSSE3-NEXT:    pcmpeqd %xmm3, %xmm4
; SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [2147483903,2147483903]
; SSSE3-NEXT:    pcmpgtd %xmm2, %xmm3
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[0,0,2,2]
; SSSE3-NEXT:    pand %xmm4, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSSE3-NEXT:    por %xmm2, %xmm3
; SSSE3-NEXT:    pand %xmm3, %xmm0
; SSSE3-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSSE3-NEXT:    por %xmm3, %xmm0
; SSSE3-NEXT:    movdqa %xmm0, %xmm2
; SSSE3-NEXT:    pxor %xmm1, %xmm2
; SSSE3-NEXT:    movdqa %xmm2, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm3
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm3[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm1, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,3,3]
; SSSE3-NEXT:    pand %xmm4, %xmm1
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[1,1,3,3]
; SSSE3-NEXT:    por %xmm1, %xmm2
; SSSE3-NEXT:    pand %xmm2, %xmm0
; SSSE3-NEXT:    pshufb {{.*#+}} xmm0 = xmm0[0,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_packus_v2i64_v2i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm1
; SSE41-NEXT:    movapd {{.*#+}} xmm2 = [255,255]
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm3 = [2147483648,2147483648]
; SSE41-NEXT:    pxor %xmm3, %xmm0
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm4 = [2147483903,2147483903]
; SSE41-NEXT:    movdqa %xmm0, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm4, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm2
; SSE41-NEXT:    xorpd %xmm1, %xmm1
; SSE41-NEXT:    movapd %xmm2, %xmm4
; SSE41-NEXT:    xorpd %xmm3, %xmm4
; SSE41-NEXT:    movapd %xmm4, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm3, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm1
; SSE41-NEXT:    pshufb {{.*#+}} xmm1 = xmm1[0,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: trunc_packus_v2i64_v2i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmovzxbq {{.*#+}} xmm1 = [255,255]
; AVX-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm1
; AVX-NEXT:    vpand %xmm0, %xmm1, %xmm0
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    retq
;
; AVX512F-LABEL: trunc_packus_v2i64_v2i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    vpmovusqb %zmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_packus_v2i64_v2i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vpmaxsq %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    vpmovusqb %xmm0, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_packus_v2i64_v2i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512BW-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BW-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovusqb %zmm0, %xmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_packus_v2i64_v2i8:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpmaxsq %xmm1, %xmm0, %xmm0
; AVX512BWVL-NEXT:    vpmovusqb %xmm0, %xmm0
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_packus_v2i64_v2i8:
; SKX:       # %bb.0:
; SKX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; SKX-NEXT:    vpmaxsq %xmm1, %xmm0, %xmm0
; SKX-NEXT:    vpmovusqb %xmm0, %xmm0
; SKX-NEXT:    retq
  %1 = icmp slt <2 x i64> %a0, <i64 255, i64 255>
  %2 = select <2 x i1> %1, <2 x i64> %a0, <2 x i64> <i64 255, i64 255>
  %3 = icmp sgt <2 x i64> %2, zeroinitializer
  %4 = select <2 x i1> %3, <2 x i64> %2, <2 x i64> zeroinitializer
  %5 = trunc <2 x i64> %4 to <2 x i8>
  ret <2 x i8> %5
}

define void @trunc_packus_v2i64_v2i8_store(<2 x i64> %a0, ptr%p1) {
; SSE2-LABEL: trunc_packus_v2i64_v2i8_store:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648]
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    pxor %xmm1, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[1,1,3,3]
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpeqd %xmm3, %xmm4
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [2147483903,2147483903]
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[0,0,2,2]
; SSE2-NEXT:    pand %xmm4, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2-NEXT:    por %xmm2, %xmm3
; SSE2-NEXT:    pand %xmm3, %xmm0
; SSE2-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSE2-NEXT:    por %xmm0, %xmm3
; SSE2-NEXT:    movdqa %xmm3, %xmm0
; SSE2-NEXT:    pxor %xmm1, %xmm0
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-NEXT:    pand %xmm4, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,3,3]
; SSE2-NEXT:    por %xmm0, %xmm1
; SSE2-NEXT:    pand %xmm3, %xmm1
; SSE2-NEXT:    packuswb %xmm1, %xmm1
; SSE2-NEXT:    packuswb %xmm1, %xmm1
; SSE2-NEXT:    packuswb %xmm1, %xmm1
; SSE2-NEXT:    movd %xmm1, %eax
; SSE2-NEXT:    movw %ax, (%rdi)
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: trunc_packus_v2i64_v2i8_store:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648]
; SSSE3-NEXT:    movdqa %xmm0, %xmm2
; SSSE3-NEXT:    pxor %xmm1, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[1,1,3,3]
; SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSSE3-NEXT:    pcmpeqd %xmm3, %xmm4
; SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [2147483903,2147483903]
; SSSE3-NEXT:    pcmpgtd %xmm2, %xmm3
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[0,0,2,2]
; SSSE3-NEXT:    pand %xmm4, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSSE3-NEXT:    por %xmm2, %xmm3
; SSSE3-NEXT:    pand %xmm3, %xmm0
; SSSE3-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSSE3-NEXT:    por %xmm0, %xmm3
; SSSE3-NEXT:    movdqa %xmm3, %xmm0
; SSSE3-NEXT:    pxor %xmm1, %xmm0
; SSSE3-NEXT:    movdqa %xmm0, %xmm2
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm1, %xmm0
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSSE3-NEXT:    pand %xmm4, %xmm0
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,3,3]
; SSSE3-NEXT:    por %xmm0, %xmm1
; SSSE3-NEXT:    pand %xmm3, %xmm1
; SSSE3-NEXT:    pshufb {{.*#+}} xmm1 = xmm1[0,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; SSSE3-NEXT:    movd %xmm1, %eax
; SSSE3-NEXT:    movw %ax, (%rdi)
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_packus_v2i64_v2i8_store:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm1
; SSE41-NEXT:    movapd {{.*#+}} xmm2 = [255,255]
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm3 = [2147483648,2147483648]
; SSE41-NEXT:    pxor %xmm3, %xmm0
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm4 = [2147483903,2147483903]
; SSE41-NEXT:    movdqa %xmm0, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm4, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm2
; SSE41-NEXT:    xorpd %xmm1, %xmm1
; SSE41-NEXT:    movapd %xmm2, %xmm4
; SSE41-NEXT:    xorpd %xmm3, %xmm4
; SSE41-NEXT:    movapd %xmm4, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm3, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm1
; SSE41-NEXT:    pshufb {{.*#+}} xmm1 = xmm1[0,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; SSE41-NEXT:    pextrw $0, %xmm1, (%rdi)
; SSE41-NEXT:    retq
;
; AVX-LABEL: trunc_packus_v2i64_v2i8_store:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmovzxbq {{.*#+}} xmm1 = [255,255]
; AVX-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm1
; AVX-NEXT:    vpand %xmm0, %xmm1, %xmm0
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpextrw $0, %xmm0, (%rdi)
; AVX-NEXT:    retq
;
; AVX512F-LABEL: trunc_packus_v2i64_v2i8_store:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    vpmovusqb %zmm0, %xmm0
; AVX512F-NEXT:    vpextrw $0, %xmm0, (%rdi)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_packus_v2i64_v2i8_store:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vpmaxsq %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    vpmovusqb %xmm0, (%rdi)
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_packus_v2i64_v2i8_store:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512BW-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BW-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovusqb %zmm0, %xmm0
; AVX512BW-NEXT:    vpextrw $0, %xmm0, (%rdi)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_packus_v2i64_v2i8_store:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpmaxsq %xmm1, %xmm0, %xmm0
; AVX512BWVL-NEXT:    vpmovusqb %xmm0, (%rdi)
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_packus_v2i64_v2i8_store:
; SKX:       # %bb.0:
; SKX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; SKX-NEXT:    vpmaxsq %xmm1, %xmm0, %xmm0
; SKX-NEXT:    vpmovusqb %xmm0, (%rdi)
; SKX-NEXT:    retq
  %1 = icmp slt <2 x i64> %a0, <i64 255, i64 255>
  %2 = select <2 x i1> %1, <2 x i64> %a0, <2 x i64> <i64 255, i64 255>
  %3 = icmp sgt <2 x i64> %2, zeroinitializer
  %4 = select <2 x i1> %3, <2 x i64> %2, <2 x i64> zeroinitializer
  %5 = trunc <2 x i64> %4 to <2 x i8>
  store <2 x i8> %5, ptr%p1
  ret void
}

define <4 x i8> @trunc_packus_v4i64_v4i8(<4 x i64> %a0) {
; SSE2-SSSE3-LABEL: trunc_packus_v4i64_v4i8:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [255,255]
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648]
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm4
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[1,1,3,3]
; SSE2-SSSE3-NEXT:    pxor %xmm6, %xmm6
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm5
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm7 = [2147483903,2147483903]
; SSE2-SSSE3-NEXT:    movdqa %xmm7, %xmm8
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm4, %xmm8
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm8[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm8[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm0
; SSE2-SSSE3-NEXT:    pandn %xmm3, %xmm5
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm0
; SSE2-SSSE3-NEXT:    movdqa %xmm1, %xmm4
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm5
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm4, %xmm7
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm7[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm7[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm1
; SSE2-SSSE3-NEXT:    pandn %xmm3, %xmm5
; SSE2-SSSE3-NEXT:    por %xmm1, %xmm5
; SSE2-SSSE3-NEXT:    movdqa %xmm5, %xmm1
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm1
; SSE2-SSSE3-NEXT:    movdqa %xmm1, %xmm3
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm3[0,0,2,2]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm2, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm1, %xmm3
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm3
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm1
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm1
; SSE2-SSSE3-NEXT:    movdqa %xmm1, %xmm4
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm2, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,2,2]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm2, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm4[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    pand %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    packuswb %xmm3, %xmm0
; SSE2-SSSE3-NEXT:    packuswb %xmm0, %xmm0
; SSE2-SSSE3-NEXT:    packuswb %xmm0, %xmm0
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_packus_v4i64_v4i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    movapd {{.*#+}} xmm4 = [255,255]
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm3 = [2147483648,2147483648]
; SSE41-NEXT:    movdqa %xmm0, %xmm5
; SSE41-NEXT:    pxor %xmm3, %xmm5
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm6 = [2147483903,2147483903]
; SSE41-NEXT:    movdqa %xmm6, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm5, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm5
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm7, %xmm0
; SSE41-NEXT:    movapd %xmm4, %xmm5
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm5
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    pxor %xmm3, %xmm0
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm2
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE41-NEXT:    pand %xmm2, %xmm0
; SSE41-NEXT:    por %xmm6, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm4
; SSE41-NEXT:    xorpd %xmm1, %xmm1
; SSE41-NEXT:    movapd %xmm4, %xmm2
; SSE41-NEXT:    xorpd %xmm3, %xmm2
; SSE41-NEXT:    movapd %xmm2, %xmm6
; SSE41-NEXT:    pcmpeqd %xmm3, %xmm6
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,0,2,2]
; SSE41-NEXT:    pand %xmm6, %xmm0
; SSE41-NEXT:    por %xmm2, %xmm0
; SSE41-NEXT:    pxor %xmm2, %xmm2
; SSE41-NEXT:    blendvpd %xmm0, %xmm4, %xmm2
; SSE41-NEXT:    movapd %xmm5, %xmm4
; SSE41-NEXT:    xorpd %xmm3, %xmm4
; SSE41-NEXT:    movapd %xmm4, %xmm6
; SSE41-NEXT:    pcmpeqd %xmm3, %xmm6
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,0,2,2]
; SSE41-NEXT:    pand %xmm6, %xmm0
; SSE41-NEXT:    por %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm1
; SSE41-NEXT:    packusdw %xmm2, %xmm1
; SSE41-NEXT:    packusdw %xmm1, %xmm1
; SSE41-NEXT:    packuswb %xmm1, %xmm1
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_packus_v4i64_v4i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmovzxbq {{.*#+}} xmm1 = [255,255]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX1-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm3
; AVX1-NEXT:    vblendvpd %xmm3, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm3
; AVX1-NEXT:    vpand %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpackusdw %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_packus_v4i64_v4i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [255,255,255,255]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_packus_v4i64_v4i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    vpmovusqb %zmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_packus_v4i64_v4i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vpmaxsq %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    vpmovusqb %ymm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_packus_v4i64_v4i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BW-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovusqb %zmm0, %xmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_packus_v4i64_v4i8:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpmaxsq %ymm1, %ymm0, %ymm0
; AVX512BWVL-NEXT:    vpmovusqb %ymm0, %xmm0
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_packus_v4i64_v4i8:
; SKX:       # %bb.0:
; SKX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; SKX-NEXT:    vpmaxsq %ymm1, %ymm0, %ymm0
; SKX-NEXT:    vpmovusqb %ymm0, %xmm0
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %1 = icmp slt <4 x i64> %a0, <i64 255, i64 255, i64 255, i64 255>
  %2 = select <4 x i1> %1, <4 x i64> %a0, <4 x i64> <i64 255, i64 255, i64 255, i64 255>
  %3 = icmp sgt <4 x i64> %2, zeroinitializer
  %4 = select <4 x i1> %3, <4 x i64> %2, <4 x i64> zeroinitializer
  %5 = trunc <4 x i64> %4 to <4 x i8>
  ret <4 x i8> %5
}

define void @trunc_packus_v4i64_v4i8_store(<4 x i64> %a0, ptr%p1) {
; SSE2-SSSE3-LABEL: trunc_packus_v4i64_v4i8_store:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm4 = [255,255]
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648]
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm3
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    pxor %xmm6, %xmm6
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm5
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm7 = [2147483903,2147483903]
; SSE2-SSSE3-NEXT:    movdqa %xmm7, %xmm8
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm3, %xmm8
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm8[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm9
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm8[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm9, %xmm3
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm0
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm3
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm3
; SSE2-SSSE3-NEXT:    movdqa %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm5
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm0, %xmm7
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm7[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm5
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm1
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    por %xmm1, %xmm5
; SSE2-SSSE3-NEXT:    movdqa %xmm5, %xmm0
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm1
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm2, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm1[0,0,2,2]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm1
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm1
; SSE2-SSSE3-NEXT:    movdqa %xmm3, %xmm0
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm4
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm2, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,2,2]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm4[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm2
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm2
; SSE2-SSSE3-NEXT:    packuswb %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    packuswb %xmm2, %xmm2
; SSE2-SSSE3-NEXT:    packuswb %xmm2, %xmm2
; SSE2-SSSE3-NEXT:    movd %xmm2, (%rdi)
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_packus_v4i64_v4i8_store:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    movapd {{.*#+}} xmm4 = [255,255]
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm3 = [2147483648,2147483648]
; SSE41-NEXT:    movdqa %xmm0, %xmm5
; SSE41-NEXT:    pxor %xmm3, %xmm5
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm6 = [2147483903,2147483903]
; SSE41-NEXT:    movdqa %xmm6, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm5, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm5
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm7, %xmm0
; SSE41-NEXT:    movapd %xmm4, %xmm5
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm5
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    pxor %xmm3, %xmm0
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm2
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE41-NEXT:    pand %xmm2, %xmm0
; SSE41-NEXT:    por %xmm6, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm4
; SSE41-NEXT:    xorpd %xmm1, %xmm1
; SSE41-NEXT:    movapd %xmm4, %xmm2
; SSE41-NEXT:    xorpd %xmm3, %xmm2
; SSE41-NEXT:    movapd %xmm2, %xmm6
; SSE41-NEXT:    pcmpeqd %xmm3, %xmm6
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,0,2,2]
; SSE41-NEXT:    pand %xmm6, %xmm0
; SSE41-NEXT:    por %xmm2, %xmm0
; SSE41-NEXT:    pxor %xmm2, %xmm2
; SSE41-NEXT:    blendvpd %xmm0, %xmm4, %xmm2
; SSE41-NEXT:    movapd %xmm5, %xmm4
; SSE41-NEXT:    xorpd %xmm3, %xmm4
; SSE41-NEXT:    movapd %xmm4, %xmm6
; SSE41-NEXT:    pcmpeqd %xmm3, %xmm6
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,0,2,2]
; SSE41-NEXT:    pand %xmm6, %xmm0
; SSE41-NEXT:    por %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm1
; SSE41-NEXT:    packusdw %xmm2, %xmm1
; SSE41-NEXT:    packusdw %xmm1, %xmm1
; SSE41-NEXT:    packuswb %xmm1, %xmm1
; SSE41-NEXT:    movd %xmm1, (%rdi)
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_packus_v4i64_v4i8_store:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmovzxbq {{.*#+}} xmm1 = [255,255]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX1-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm3
; AVX1-NEXT:    vblendvpd %xmm3, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm3
; AVX1-NEXT:    vpand %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpackusdw %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vmovd %xmm0, (%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_packus_v4i64_v4i8_store:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [255,255,255,255]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vmovd %xmm0, (%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_packus_v4i64_v4i8_store:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    vpmovusqb %zmm0, %xmm0
; AVX512F-NEXT:    vmovd %xmm0, (%rdi)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_packus_v4i64_v4i8_store:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vpmaxsq %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    vpmovusqb %ymm0, (%rdi)
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_packus_v4i64_v4i8_store:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BW-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovusqb %zmm0, %xmm0
; AVX512BW-NEXT:    vmovd %xmm0, (%rdi)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_packus_v4i64_v4i8_store:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpmaxsq %ymm1, %ymm0, %ymm0
; AVX512BWVL-NEXT:    vpmovusqb %ymm0, (%rdi)
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_packus_v4i64_v4i8_store:
; SKX:       # %bb.0:
; SKX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; SKX-NEXT:    vpmaxsq %ymm1, %ymm0, %ymm0
; SKX-NEXT:    vpmovusqb %ymm0, (%rdi)
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %1 = icmp slt <4 x i64> %a0, <i64 255, i64 255, i64 255, i64 255>
  %2 = select <4 x i1> %1, <4 x i64> %a0, <4 x i64> <i64 255, i64 255, i64 255, i64 255>
  %3 = icmp sgt <4 x i64> %2, zeroinitializer
  %4 = select <4 x i1> %3, <4 x i64> %2, <4 x i64> zeroinitializer
  %5 = trunc <4 x i64> %4 to <4 x i8>
  store <4 x i8> %5, ptr%p1
  ret void
}

define <8 x i8> @trunc_packus_v8i64_v8i8(ptr %p0) "min-legal-vector-width"="256" {
; SSE2-SSSE3-LABEL: trunc_packus_v8i64_v8i8:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    movdqa (%rdi), %xmm5
; SSE2-SSSE3-NEXT:    movdqa 16(%rdi), %xmm0
; SSE2-SSSE3-NEXT:    movdqa 32(%rdi), %xmm3
; SSE2-SSSE3-NEXT:    movdqa 48(%rdi), %xmm8
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm4 = [255,255]
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648]
; SSE2-SSSE3-NEXT:    movdqa %xmm3, %xmm2
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm2[1,1,3,3]
; SSE2-SSSE3-NEXT:    pxor %xmm7, %xmm7
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm7, %xmm9
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm6 = [2147483903,2147483903]
; SSE2-SSSE3-NEXT:    movdqa %xmm6, %xmm10
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm2, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm10[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm11
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm10[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm11, %xmm2
; SSE2-SSSE3-NEXT:    pand %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm2
; SSE2-SSSE3-NEXT:    por %xmm3, %xmm2
; SSE2-SSSE3-NEXT:    movdqa %xmm8, %xmm3
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm7, %xmm9
; SSE2-SSSE3-NEXT:    movdqa %xmm6, %xmm10
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm3, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm10[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm11
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm10[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm11, %xmm3
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm8
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm3
; SSE2-SSSE3-NEXT:    por %xmm8, %xmm3
; SSE2-SSSE3-NEXT:    movdqa %xmm5, %xmm8
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm8
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm8[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm7, %xmm9
; SSE2-SSSE3-NEXT:    movdqa %xmm6, %xmm10
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm8, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm10[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm11
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm8 = xmm10[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm11, %xmm8
; SSE2-SSSE3-NEXT:    pand %xmm8, %xmm5
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm8
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm8
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm5
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm5[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm7, %xmm9
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm5, %xmm6
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm6[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm6
; SSE2-SSSE3-NEXT:    pand %xmm6, %xmm0
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm6
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm6
; SSE2-SSSE3-NEXT:    movdqa %xmm6, %xmm0
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm4
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm1, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,2,2]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm4
; SSE2-SSSE3-NEXT:    pand %xmm6, %xmm4
; SSE2-SSSE3-NEXT:    movdqa %xmm8, %xmm0
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm5
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm1, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[0,0,2,2]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm7 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm6, %xmm7
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm5[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm7, %xmm0
; SSE2-SSSE3-NEXT:    pand %xmm8, %xmm0
; SSE2-SSSE3-NEXT:    packuswb %xmm4, %xmm0
; SSE2-SSSE3-NEXT:    movdqa %xmm3, %xmm4
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm4
; SSE2-SSSE3-NEXT:    movdqa %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm1, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[0,0,2,2]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm1, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm6, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm5
; SSE2-SSSE3-NEXT:    movdqa %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm3
; SSE2-SSSE3-NEXT:    movdqa %xmm3, %xmm4
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm1, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm4[0,0,2,2]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm1, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm6, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm4[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm1, %xmm3
; SSE2-SSSE3-NEXT:    pand %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    packuswb %xmm5, %xmm3
; SSE2-SSSE3-NEXT:    packuswb %xmm3, %xmm0
; SSE2-SSSE3-NEXT:    packuswb %xmm0, %xmm0
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_packus_v8i64_v8i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa (%rdi), %xmm7
; SSE41-NEXT:    movdqa 16(%rdi), %xmm5
; SSE41-NEXT:    movdqa 32(%rdi), %xmm4
; SSE41-NEXT:    movdqa 48(%rdi), %xmm8
; SSE41-NEXT:    movapd {{.*#+}} xmm1 = [255,255]
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm2 = [2147483648,2147483648]
; SSE41-NEXT:    movdqa %xmm4, %xmm3
; SSE41-NEXT:    pxor %xmm2, %xmm3
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm6 = [2147483903,2147483903]
; SSE41-NEXT:    movdqa %xmm6, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm9
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[0,0,2,2]
; SSE41-NEXT:    pand %xmm3, %xmm0
; SSE41-NEXT:    por %xmm9, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm3
; SSE41-NEXT:    blendvpd %xmm0, %xmm4, %xmm3
; SSE41-NEXT:    movdqa %xmm8, %xmm4
; SSE41-NEXT:    pxor %xmm2, %xmm4
; SSE41-NEXT:    movdqa %xmm6, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm4, %xmm9
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[0,0,2,2]
; SSE41-NEXT:    pand %xmm4, %xmm0
; SSE41-NEXT:    por %xmm9, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm4
; SSE41-NEXT:    blendvpd %xmm0, %xmm8, %xmm4
; SSE41-NEXT:    movdqa %xmm7, %xmm8
; SSE41-NEXT:    pxor %xmm2, %xmm8
; SSE41-NEXT:    movdqa %xmm6, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm8, %xmm9
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm8
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[0,0,2,2]
; SSE41-NEXT:    pand %xmm8, %xmm0
; SSE41-NEXT:    por %xmm9, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm8
; SSE41-NEXT:    blendvpd %xmm0, %xmm7, %xmm8
; SSE41-NEXT:    movdqa %xmm5, %xmm0
; SSE41-NEXT:    pxor %xmm2, %xmm0
; SSE41-NEXT:    movdqa %xmm0, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    por %xmm6, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm1
; SSE41-NEXT:    xorpd %xmm5, %xmm5
; SSE41-NEXT:    movapd %xmm1, %xmm6
; SSE41-NEXT:    xorpd %xmm2, %xmm6
; SSE41-NEXT:    movapd %xmm6, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm2, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    por %xmm6, %xmm0
; SSE41-NEXT:    pxor %xmm6, %xmm6
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm6
; SSE41-NEXT:    movapd %xmm8, %xmm1
; SSE41-NEXT:    xorpd %xmm2, %xmm1
; SSE41-NEXT:    movapd %xmm1, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm2, %xmm1
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,0,2,2]
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    pxor %xmm1, %xmm1
; SSE41-NEXT:    blendvpd %xmm0, %xmm8, %xmm1
; SSE41-NEXT:    packusdw %xmm6, %xmm1
; SSE41-NEXT:    movapd %xmm4, %xmm6
; SSE41-NEXT:    xorpd %xmm2, %xmm6
; SSE41-NEXT:    movapd %xmm6, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm2, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    por %xmm6, %xmm0
; SSE41-NEXT:    pxor %xmm6, %xmm6
; SSE41-NEXT:    blendvpd %xmm0, %xmm4, %xmm6
; SSE41-NEXT:    movapd %xmm3, %xmm4
; SSE41-NEXT:    xorpd %xmm2, %xmm4
; SSE41-NEXT:    movapd %xmm4, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm2, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,0,2,2]
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    por %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm3, %xmm5
; SSE41-NEXT:    packusdw %xmm6, %xmm5
; SSE41-NEXT:    packusdw %xmm5, %xmm1
; SSE41-NEXT:    packuswb %xmm1, %xmm1
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_packus_v8i64_v8i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX1-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX1-NEXT:    vmovdqa 48(%rdi), %xmm3
; AVX1-NEXT:    vpmovzxbq {{.*#+}} xmm4 = [255,255]
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm4, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpcmpgtq %xmm3, %xmm4, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm4, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm4, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm1, %xmm5
; AVX1-NEXT:    vpand %xmm1, %xmm5, %xmm1
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm0, %xmm5
; AVX1-NEXT:    vpand %xmm0, %xmm5, %xmm0
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm3, %xmm1
; AVX1-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm2, %xmm3
; AVX1-NEXT:    vpand %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpackusdw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_packus_v8i64_v8i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [255,255,255,255]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm2, %ymm3
; AVX2-NEXT:    vblendvpd %ymm3, %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm2, %ymm3
; AVX2-NEXT:    vblendvpd %ymm3, %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm1, %ymm3
; AVX2-NEXT:    vpand %ymm1, %ymm3, %ymm1
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vpand %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpackusdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX2-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_packus_v8i64_v8i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    vpmaxsq (%rdi), %zmm0, %zmm0
; AVX512-NEXT:    vpmovusqb %zmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; SKX-LABEL: trunc_packus_v8i64_v8i8:
; SKX:       # %bb.0:
; SKX-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; SKX-NEXT:    vpmaxsq 32(%rdi), %ymm0, %ymm1
; SKX-NEXT:    vpmovusqb %ymm1, %xmm1
; SKX-NEXT:    vpmaxsq (%rdi), %ymm0, %ymm0
; SKX-NEXT:    vpmovusqb %ymm0, %xmm0
; SKX-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %a0 = load <8 x i64>, ptr %p0
  %1 = icmp slt <8 x i64> %a0, <i64 255, i64 255, i64 255, i64 255, i64 255, i64 255, i64 255, i64 255>
  %2 = select <8 x i1> %1, <8 x i64> %a0, <8 x i64> <i64 255, i64 255, i64 255, i64 255, i64 255, i64 255, i64 255, i64 255>
  %3 = icmp sgt <8 x i64> %2, zeroinitializer
  %4 = select <8 x i1> %3, <8 x i64> %2, <8 x i64> zeroinitializer
  %5 = trunc <8 x i64> %4 to <8 x i8>
  ret <8 x i8> %5
}

define void @trunc_packus_v8i64_v8i8_store(ptr %p0, ptr%p1) "min-legal-vector-width"="256" {
; SSE2-SSSE3-LABEL: trunc_packus_v8i64_v8i8_store:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    movdqa (%rdi), %xmm5
; SSE2-SSSE3-NEXT:    movdqa 16(%rdi), %xmm3
; SSE2-SSSE3-NEXT:    movdqa 32(%rdi), %xmm2
; SSE2-SSSE3-NEXT:    movdqa 48(%rdi), %xmm8
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm4 = [255,255]
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm0 = [2147483648,2147483648]
; SSE2-SSSE3-NEXT:    movdqa %xmm2, %xmm1
; SSE2-SSSE3-NEXT:    pxor %xmm0, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    pxor %xmm7, %xmm7
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm7, %xmm9
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm6 = [2147483903,2147483903]
; SSE2-SSSE3-NEXT:    movdqa %xmm6, %xmm10
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm1, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm10[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm11
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm10[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm11, %xmm1
; SSE2-SSSE3-NEXT:    pand %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm1
; SSE2-SSSE3-NEXT:    por %xmm2, %xmm1
; SSE2-SSSE3-NEXT:    movdqa %xmm8, %xmm2
; SSE2-SSSE3-NEXT:    pxor %xmm0, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm2[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm7, %xmm9
; SSE2-SSSE3-NEXT:    movdqa %xmm6, %xmm10
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm2, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm10[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm11
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm10[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm11, %xmm2
; SSE2-SSSE3-NEXT:    pand %xmm2, %xmm8
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm2
; SSE2-SSSE3-NEXT:    por %xmm8, %xmm2
; SSE2-SSSE3-NEXT:    movdqa %xmm5, %xmm8
; SSE2-SSSE3-NEXT:    pxor %xmm0, %xmm8
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm8[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm7, %xmm9
; SSE2-SSSE3-NEXT:    movdqa %xmm6, %xmm10
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm8, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm10[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm11
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm8 = xmm10[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm11, %xmm8
; SSE2-SSSE3-NEXT:    pand %xmm8, %xmm5
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm8
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm8
; SSE2-SSSE3-NEXT:    movdqa %xmm3, %xmm5
; SSE2-SSSE3-NEXT:    pxor %xmm0, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm5[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm7, %xmm9
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm5, %xmm6
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm6[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm6
; SSE2-SSSE3-NEXT:    pand %xmm6, %xmm3
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm6
; SSE2-SSSE3-NEXT:    por %xmm3, %xmm6
; SSE2-SSSE3-NEXT:    movdqa %xmm6, %xmm3
; SSE2-SSSE3-NEXT:    pxor %xmm0, %xmm3
; SSE2-SSSE3-NEXT:    movdqa %xmm3, %xmm4
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm0, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,2,2]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm0, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm3, %xmm4
; SSE2-SSSE3-NEXT:    pand %xmm6, %xmm4
; SSE2-SSSE3-NEXT:    movdqa %xmm8, %xmm3
; SSE2-SSSE3-NEXT:    pxor %xmm0, %xmm3
; SSE2-SSSE3-NEXT:    movdqa %xmm3, %xmm5
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm0, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[0,0,2,2]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm0, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm7 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm6, %xmm7
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm5[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm7, %xmm3
; SSE2-SSSE3-NEXT:    pand %xmm8, %xmm3
; SSE2-SSSE3-NEXT:    packuswb %xmm4, %xmm3
; SSE2-SSSE3-NEXT:    movdqa %xmm2, %xmm4
; SSE2-SSSE3-NEXT:    pxor %xmm0, %xmm4
; SSE2-SSSE3-NEXT:    movdqa %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm0, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[0,0,2,2]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm0, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm6, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    pand %xmm2, %xmm5
; SSE2-SSSE3-NEXT:    movdqa %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    pxor %xmm0, %xmm2
; SSE2-SSSE3-NEXT:    movdqa %xmm2, %xmm4
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm0, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm4[0,0,2,2]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm6, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm4[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm2
; SSE2-SSSE3-NEXT:    pand %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    packuswb %xmm5, %xmm2
; SSE2-SSSE3-NEXT:    packuswb %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    packuswb %xmm3, %xmm3
; SSE2-SSSE3-NEXT:    movq %xmm3, (%rsi)
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_packus_v8i64_v8i8_store:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa (%rdi), %xmm7
; SSE41-NEXT:    movdqa 16(%rdi), %xmm5
; SSE41-NEXT:    movdqa 32(%rdi), %xmm3
; SSE41-NEXT:    movdqa 48(%rdi), %xmm8
; SSE41-NEXT:    movapd {{.*#+}} xmm4 = [255,255]
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm1 = [2147483648,2147483648]
; SSE41-NEXT:    movdqa %xmm3, %xmm2
; SSE41-NEXT:    pxor %xmm1, %xmm2
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm6 = [2147483903,2147483903]
; SSE41-NEXT:    movdqa %xmm6, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm2, %xmm9
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[0,0,2,2]
; SSE41-NEXT:    pand %xmm2, %xmm0
; SSE41-NEXT:    por %xmm9, %xmm0
; SSE41-NEXT:    movapd %xmm4, %xmm2
; SSE41-NEXT:    blendvpd %xmm0, %xmm3, %xmm2
; SSE41-NEXT:    movdqa %xmm8, %xmm3
; SSE41-NEXT:    pxor %xmm1, %xmm3
; SSE41-NEXT:    movdqa %xmm6, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm9
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[0,0,2,2]
; SSE41-NEXT:    pand %xmm3, %xmm0
; SSE41-NEXT:    por %xmm9, %xmm0
; SSE41-NEXT:    movapd %xmm4, %xmm3
; SSE41-NEXT:    blendvpd %xmm0, %xmm8, %xmm3
; SSE41-NEXT:    movdqa %xmm7, %xmm8
; SSE41-NEXT:    pxor %xmm1, %xmm8
; SSE41-NEXT:    movdqa %xmm6, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm8, %xmm9
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm8
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[0,0,2,2]
; SSE41-NEXT:    pand %xmm8, %xmm0
; SSE41-NEXT:    por %xmm9, %xmm0
; SSE41-NEXT:    movapd %xmm4, %xmm8
; SSE41-NEXT:    blendvpd %xmm0, %xmm7, %xmm8
; SSE41-NEXT:    movdqa %xmm5, %xmm0
; SSE41-NEXT:    pxor %xmm1, %xmm0
; SSE41-NEXT:    movdqa %xmm0, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    por %xmm6, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm4
; SSE41-NEXT:    xorpd %xmm5, %xmm5
; SSE41-NEXT:    movapd %xmm4, %xmm6
; SSE41-NEXT:    xorpd %xmm1, %xmm6
; SSE41-NEXT:    movapd %xmm6, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm1, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    por %xmm6, %xmm0
; SSE41-NEXT:    pxor %xmm6, %xmm6
; SSE41-NEXT:    blendvpd %xmm0, %xmm4, %xmm6
; SSE41-NEXT:    movapd %xmm8, %xmm4
; SSE41-NEXT:    xorpd %xmm1, %xmm4
; SSE41-NEXT:    movapd %xmm4, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm1, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,0,2,2]
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    por %xmm4, %xmm0
; SSE41-NEXT:    pxor %xmm4, %xmm4
; SSE41-NEXT:    blendvpd %xmm0, %xmm8, %xmm4
; SSE41-NEXT:    packusdw %xmm6, %xmm4
; SSE41-NEXT:    movapd %xmm3, %xmm6
; SSE41-NEXT:    xorpd %xmm1, %xmm6
; SSE41-NEXT:    movapd %xmm6, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm1, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    por %xmm6, %xmm0
; SSE41-NEXT:    pxor %xmm6, %xmm6
; SSE41-NEXT:    blendvpd %xmm0, %xmm3, %xmm6
; SSE41-NEXT:    movapd %xmm2, %xmm3
; SSE41-NEXT:    xorpd %xmm1, %xmm3
; SSE41-NEXT:    movapd %xmm3, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm1, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,0,2,2]
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    por %xmm3, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm5
; SSE41-NEXT:    packusdw %xmm6, %xmm5
; SSE41-NEXT:    packusdw %xmm5, %xmm4
; SSE41-NEXT:    packuswb %xmm4, %xmm4
; SSE41-NEXT:    movq %xmm4, (%rsi)
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_packus_v8i64_v8i8_store:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX1-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX1-NEXT:    vmovdqa 48(%rdi), %xmm3
; AVX1-NEXT:    vpmovzxbq {{.*#+}} xmm4 = [255,255]
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm4, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpcmpgtq %xmm3, %xmm4, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm4, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm4, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm1, %xmm5
; AVX1-NEXT:    vpand %xmm1, %xmm5, %xmm1
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm0, %xmm5
; AVX1-NEXT:    vpand %xmm0, %xmm5, %xmm0
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm3, %xmm1
; AVX1-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm2, %xmm3
; AVX1-NEXT:    vpand %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpackusdw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vmovq %xmm0, (%rsi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_packus_v8i64_v8i8_store:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [255,255,255,255]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm2, %ymm3
; AVX2-NEXT:    vblendvpd %ymm3, %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm2, %ymm3
; AVX2-NEXT:    vblendvpd %ymm3, %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm1, %ymm3
; AVX2-NEXT:    vpand %ymm1, %ymm3, %ymm1
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vpand %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpackusdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX2-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vmovq %xmm0, (%rsi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_packus_v8i64_v8i8_store:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    vpmaxsq (%rdi), %zmm0, %zmm0
; AVX512-NEXT:    vpmovusqb %zmm0, (%rsi)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; SKX-LABEL: trunc_packus_v8i64_v8i8_store:
; SKX:       # %bb.0:
; SKX-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; SKX-NEXT:    vpmaxsq 32(%rdi), %ymm0, %ymm1
; SKX-NEXT:    vpmovusqb %ymm1, %xmm1
; SKX-NEXT:    vpmaxsq (%rdi), %ymm0, %ymm0
; SKX-NEXT:    vpmovusqb %ymm0, %xmm0
; SKX-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SKX-NEXT:    vmovq %xmm0, (%rsi)
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %a0 = load <8 x i64>, ptr %p0
  %1 = icmp slt <8 x i64> %a0, <i64 255, i64 255, i64 255, i64 255, i64 255, i64 255, i64 255, i64 255>
  %2 = select <8 x i1> %1, <8 x i64> %a0, <8 x i64> <i64 255, i64 255, i64 255, i64 255, i64 255, i64 255, i64 255, i64 255>
  %3 = icmp sgt <8 x i64> %2, zeroinitializer
  %4 = select <8 x i1> %3, <8 x i64> %2, <8 x i64> zeroinitializer
  %5 = trunc <8 x i64> %4 to <8 x i8>
  store <8 x i8> %5, ptr%p1
  ret void
}

define <16 x i8> @trunc_packus_v16i64_v16i8(ptr %p0) "min-legal-vector-width"="256" {
; SSE2-SSSE3-LABEL: trunc_packus_v16i64_v16i8:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    movdqa (%rdi), %xmm7
; SSE2-SSSE3-NEXT:    movdqa 16(%rdi), %xmm0
; SSE2-SSSE3-NEXT:    movdqa 32(%rdi), %xmm12
; SSE2-SSSE3-NEXT:    movdqa 48(%rdi), %xmm11
; SSE2-SSSE3-NEXT:    movdqa 80(%rdi), %xmm10
; SSE2-SSSE3-NEXT:    movdqa 64(%rdi), %xmm5
; SSE2-SSSE3-NEXT:    movdqa 112(%rdi), %xmm4
; SSE2-SSSE3-NEXT:    movdqa 96(%rdi), %xmm3
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm6 = [255,255]
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648]
; SSE2-SSSE3-NEXT:    movdqa %xmm3, %xmm2
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm13 = xmm2[1,1,3,3]
; SSE2-SSSE3-NEXT:    pxor %xmm9, %xmm9
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm9, %xmm13
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm8 = [2147483903,2147483903]
; SSE2-SSSE3-NEXT:    movdqa %xmm8, %xmm14
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm2, %xmm14
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm15 = xmm14[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm13, %xmm15
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm14[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm15, %xmm2
; SSE2-SSSE3-NEXT:    pand %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pandn %xmm6, %xmm2
; SSE2-SSSE3-NEXT:    por %xmm3, %xmm2
; SSE2-SSSE3-NEXT:    movdqa %xmm4, %xmm3
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm13 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm9, %xmm13
; SSE2-SSSE3-NEXT:    movdqa %xmm8, %xmm14
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm3, %xmm14
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm15 = xmm14[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm13, %xmm15
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm14[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm15, %xmm3
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm4
; SSE2-SSSE3-NEXT:    pandn %xmm6, %xmm3
; SSE2-SSSE3-NEXT:    por %xmm4, %xmm3
; SSE2-SSSE3-NEXT:    movdqa %xmm5, %xmm4
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm13 = xmm4[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm9, %xmm13
; SSE2-SSSE3-NEXT:    movdqa %xmm8, %xmm14
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm4, %xmm14
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm15 = xmm14[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm13, %xmm15
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm14[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm15, %xmm4
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    pandn %xmm6, %xmm4
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm4
; SSE2-SSSE3-NEXT:    movdqa %xmm10, %xmm5
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm13 = xmm5[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm9, %xmm13
; SSE2-SSSE3-NEXT:    movdqa %xmm8, %xmm14
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm5, %xmm14
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm15 = xmm14[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm13, %xmm15
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm14[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm15, %xmm5
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm10
; SSE2-SSSE3-NEXT:    pandn %xmm6, %xmm5
; SSE2-SSSE3-NEXT:    por %xmm10, %xmm5
; SSE2-SSSE3-NEXT:    movdqa %xmm12, %xmm10
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm13 = xmm10[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm9, %xmm13
; SSE2-SSSE3-NEXT:    movdqa %xmm8, %xmm14
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm10, %xmm14
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm15 = xmm14[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm13, %xmm15
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm10 = xmm14[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm15, %xmm10
; SSE2-SSSE3-NEXT:    pand %xmm10, %xmm12
; SSE2-SSSE3-NEXT:    pandn %xmm6, %xmm10
; SSE2-SSSE3-NEXT:    por %xmm12, %xmm10
; SSE2-SSSE3-NEXT:    movdqa %xmm11, %xmm12
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm12
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm13 = xmm12[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm9, %xmm13
; SSE2-SSSE3-NEXT:    movdqa %xmm8, %xmm14
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm12, %xmm14
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm15 = xmm14[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm13, %xmm15
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm12 = xmm14[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm15, %xmm12
; SSE2-SSSE3-NEXT:    pand %xmm12, %xmm11
; SSE2-SSSE3-NEXT:    pandn %xmm6, %xmm12
; SSE2-SSSE3-NEXT:    por %xmm11, %xmm12
; SSE2-SSSE3-NEXT:    movdqa %xmm7, %xmm11
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm11
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm13 = xmm11[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm9, %xmm13
; SSE2-SSSE3-NEXT:    movdqa %xmm8, %xmm14
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm11, %xmm14
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm15 = xmm14[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm13, %xmm15
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm14[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm15, %xmm11
; SSE2-SSSE3-NEXT:    pand %xmm11, %xmm7
; SSE2-SSSE3-NEXT:    pandn %xmm6, %xmm11
; SSE2-SSSE3-NEXT:    por %xmm7, %xmm11
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm7
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm7
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm13 = xmm7[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm9, %xmm13
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm7, %xmm8
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm7 = xmm8[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm13, %xmm7
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm8 = xmm8[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm7, %xmm8
; SSE2-SSSE3-NEXT:    pand %xmm8, %xmm0
; SSE2-SSSE3-NEXT:    pandn %xmm6, %xmm8
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm8
; SSE2-SSSE3-NEXT:    movdqa %xmm8, %xmm0
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm6
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm1, %xmm6
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[0,0,2,2]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm7, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm6
; SSE2-SSSE3-NEXT:    pand %xmm8, %xmm6
; SSE2-SSSE3-NEXT:    movdqa %xmm11, %xmm0
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm7
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm1, %xmm7
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm8 = xmm7[0,0,2,2]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm8, %xmm9
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm9, %xmm0
; SSE2-SSSE3-NEXT:    pand %xmm11, %xmm0
; SSE2-SSSE3-NEXT:    packuswb %xmm6, %xmm0
; SSE2-SSSE3-NEXT:    movdqa %xmm12, %xmm6
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm6
; SSE2-SSSE3-NEXT:    movdqa %xmm6, %xmm7
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm1, %xmm7
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm8 = xmm7[0,0,2,2]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm1, %xmm6
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm8, %xmm6
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm6, %xmm7
; SSE2-SSSE3-NEXT:    pand %xmm12, %xmm7
; SSE2-SSSE3-NEXT:    movdqa %xmm10, %xmm6
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm6
; SSE2-SSSE3-NEXT:    movdqa %xmm6, %xmm8
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm1, %xmm8
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm8[0,0,2,2]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm1, %xmm6
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm6
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm8 = xmm8[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm6, %xmm8
; SSE2-SSSE3-NEXT:    pand %xmm10, %xmm8
; SSE2-SSSE3-NEXT:    packuswb %xmm7, %xmm8
; SSE2-SSSE3-NEXT:    packuswb %xmm8, %xmm0
; SSE2-SSSE3-NEXT:    movdqa %xmm5, %xmm6
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm6
; SSE2-SSSE3-NEXT:    movdqa %xmm6, %xmm7
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm1, %xmm7
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm8 = xmm7[0,0,2,2]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm1, %xmm6
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm8, %xmm6
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm6, %xmm7
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm7
; SSE2-SSSE3-NEXT:    movdqa %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm5
; SSE2-SSSE3-NEXT:    movdqa %xmm5, %xmm6
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm1, %xmm6
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm8 = xmm6[0,0,2,2]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm1, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm5[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm8, %xmm9
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm6[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm9, %xmm5
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    packuswb %xmm7, %xmm5
; SSE2-SSSE3-NEXT:    movdqa %xmm3, %xmm4
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm4
; SSE2-SSSE3-NEXT:    movdqa %xmm4, %xmm6
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm1, %xmm6
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[0,0,2,2]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm1, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm7, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm4, %xmm6
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm6
; SSE2-SSSE3-NEXT:    movdqa %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm3
; SSE2-SSSE3-NEXT:    movdqa %xmm3, %xmm4
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm1, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm7 = xmm4[0,0,2,2]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm1, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    pand %xmm7, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm4[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm1, %xmm3
; SSE2-SSSE3-NEXT:    pand %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    packuswb %xmm6, %xmm3
; SSE2-SSSE3-NEXT:    packuswb %xmm3, %xmm5
; SSE2-SSSE3-NEXT:    packuswb %xmm5, %xmm0
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_packus_v16i64_v16i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa (%rdi), %xmm8
; SSE41-NEXT:    movdqa 16(%rdi), %xmm7
; SSE41-NEXT:    movdqa 32(%rdi), %xmm12
; SSE41-NEXT:    movdqa 48(%rdi), %xmm11
; SSE41-NEXT:    movdqa 80(%rdi), %xmm10
; SSE41-NEXT:    movdqa 64(%rdi), %xmm6
; SSE41-NEXT:    movdqa 112(%rdi), %xmm5
; SSE41-NEXT:    movdqa 96(%rdi), %xmm4
; SSE41-NEXT:    movapd {{.*#+}} xmm1 = [255,255]
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm2 = [2147483648,2147483648]
; SSE41-NEXT:    movdqa %xmm4, %xmm3
; SSE41-NEXT:    pxor %xmm2, %xmm3
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm9 = [2147483903,2147483903]
; SSE41-NEXT:    movdqa %xmm9, %xmm13
; SSE41-NEXT:    pcmpgtd %xmm3, %xmm13
; SSE41-NEXT:    pcmpeqd %xmm9, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm13[0,0,2,2]
; SSE41-NEXT:    pand %xmm3, %xmm0
; SSE41-NEXT:    por %xmm13, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm3
; SSE41-NEXT:    blendvpd %xmm0, %xmm4, %xmm3
; SSE41-NEXT:    movdqa %xmm5, %xmm4
; SSE41-NEXT:    pxor %xmm2, %xmm4
; SSE41-NEXT:    movdqa %xmm9, %xmm13
; SSE41-NEXT:    pcmpgtd %xmm4, %xmm13
; SSE41-NEXT:    pcmpeqd %xmm9, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm13[0,0,2,2]
; SSE41-NEXT:    pand %xmm4, %xmm0
; SSE41-NEXT:    por %xmm13, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm4
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm4
; SSE41-NEXT:    movdqa %xmm6, %xmm5
; SSE41-NEXT:    pxor %xmm2, %xmm5
; SSE41-NEXT:    movdqa %xmm9, %xmm13
; SSE41-NEXT:    pcmpgtd %xmm5, %xmm13
; SSE41-NEXT:    pcmpeqd %xmm9, %xmm5
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm13[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm13, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm5
; SSE41-NEXT:    blendvpd %xmm0, %xmm6, %xmm5
; SSE41-NEXT:    movdqa %xmm10, %xmm6
; SSE41-NEXT:    pxor %xmm2, %xmm6
; SSE41-NEXT:    movdqa %xmm9, %xmm13
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm13
; SSE41-NEXT:    pcmpeqd %xmm9, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm13[0,0,2,2]
; SSE41-NEXT:    pand %xmm6, %xmm0
; SSE41-NEXT:    por %xmm13, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm6
; SSE41-NEXT:    blendvpd %xmm0, %xmm10, %xmm6
; SSE41-NEXT:    movdqa %xmm12, %xmm10
; SSE41-NEXT:    pxor %xmm2, %xmm10
; SSE41-NEXT:    movdqa %xmm9, %xmm13
; SSE41-NEXT:    pcmpgtd %xmm10, %xmm13
; SSE41-NEXT:    pcmpeqd %xmm9, %xmm10
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm13[0,0,2,2]
; SSE41-NEXT:    pand %xmm10, %xmm0
; SSE41-NEXT:    por %xmm13, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm10
; SSE41-NEXT:    blendvpd %xmm0, %xmm12, %xmm10
; SSE41-NEXT:    movdqa %xmm11, %xmm12
; SSE41-NEXT:    pxor %xmm2, %xmm12
; SSE41-NEXT:    movdqa %xmm9, %xmm13
; SSE41-NEXT:    pcmpgtd %xmm12, %xmm13
; SSE41-NEXT:    pcmpeqd %xmm9, %xmm12
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm13[0,0,2,2]
; SSE41-NEXT:    pand %xmm12, %xmm0
; SSE41-NEXT:    por %xmm13, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm12
; SSE41-NEXT:    blendvpd %xmm0, %xmm11, %xmm12
; SSE41-NEXT:    movdqa %xmm8, %xmm11
; SSE41-NEXT:    pxor %xmm2, %xmm11
; SSE41-NEXT:    movdqa %xmm9, %xmm13
; SSE41-NEXT:    pcmpgtd %xmm11, %xmm13
; SSE41-NEXT:    pcmpeqd %xmm9, %xmm11
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm13[0,0,2,2]
; SSE41-NEXT:    pand %xmm11, %xmm0
; SSE41-NEXT:    por %xmm13, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm11
; SSE41-NEXT:    blendvpd %xmm0, %xmm8, %xmm11
; SSE41-NEXT:    movdqa %xmm7, %xmm0
; SSE41-NEXT:    pxor %xmm2, %xmm0
; SSE41-NEXT:    movdqa %xmm0, %xmm8
; SSE41-NEXT:    pcmpeqd %xmm9, %xmm8
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm9
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[0,0,2,2]
; SSE41-NEXT:    pand %xmm8, %xmm0
; SSE41-NEXT:    por %xmm9, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm7, %xmm1
; SSE41-NEXT:    xorpd %xmm7, %xmm7
; SSE41-NEXT:    movapd %xmm1, %xmm8
; SSE41-NEXT:    xorpd %xmm2, %xmm8
; SSE41-NEXT:    movapd %xmm8, %xmm9
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm2, %xmm8
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm8[0,0,2,2]
; SSE41-NEXT:    pand %xmm9, %xmm0
; SSE41-NEXT:    por %xmm8, %xmm0
; SSE41-NEXT:    pxor %xmm8, %xmm8
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm8
; SSE41-NEXT:    movapd %xmm11, %xmm1
; SSE41-NEXT:    xorpd %xmm2, %xmm1
; SSE41-NEXT:    movapd %xmm1, %xmm9
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm2, %xmm1
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,0,2,2]
; SSE41-NEXT:    pand %xmm9, %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    pxor %xmm1, %xmm1
; SSE41-NEXT:    blendvpd %xmm0, %xmm11, %xmm1
; SSE41-NEXT:    packusdw %xmm8, %xmm1
; SSE41-NEXT:    movapd %xmm12, %xmm8
; SSE41-NEXT:    xorpd %xmm2, %xmm8
; SSE41-NEXT:    movapd %xmm8, %xmm9
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm2, %xmm8
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm8[0,0,2,2]
; SSE41-NEXT:    pand %xmm9, %xmm0
; SSE41-NEXT:    por %xmm8, %xmm0
; SSE41-NEXT:    pxor %xmm8, %xmm8
; SSE41-NEXT:    blendvpd %xmm0, %xmm12, %xmm8
; SSE41-NEXT:    movapd %xmm10, %xmm9
; SSE41-NEXT:    xorpd %xmm2, %xmm9
; SSE41-NEXT:    movapd %xmm9, %xmm11
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm11
; SSE41-NEXT:    pcmpgtd %xmm2, %xmm9
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[0,0,2,2]
; SSE41-NEXT:    pand %xmm11, %xmm0
; SSE41-NEXT:    por %xmm9, %xmm0
; SSE41-NEXT:    pxor %xmm9, %xmm9
; SSE41-NEXT:    blendvpd %xmm0, %xmm10, %xmm9
; SSE41-NEXT:    packusdw %xmm8, %xmm9
; SSE41-NEXT:    packusdw %xmm9, %xmm1
; SSE41-NEXT:    movapd %xmm6, %xmm8
; SSE41-NEXT:    xorpd %xmm2, %xmm8
; SSE41-NEXT:    movapd %xmm8, %xmm9
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm2, %xmm8
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm8[0,0,2,2]
; SSE41-NEXT:    pand %xmm9, %xmm0
; SSE41-NEXT:    por %xmm8, %xmm0
; SSE41-NEXT:    pxor %xmm8, %xmm8
; SSE41-NEXT:    blendvpd %xmm0, %xmm6, %xmm8
; SSE41-NEXT:    movapd %xmm5, %xmm6
; SSE41-NEXT:    xorpd %xmm2, %xmm6
; SSE41-NEXT:    movapd %xmm6, %xmm9
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm2, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE41-NEXT:    pand %xmm9, %xmm0
; SSE41-NEXT:    por %xmm6, %xmm0
; SSE41-NEXT:    pxor %xmm6, %xmm6
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm6
; SSE41-NEXT:    packusdw %xmm8, %xmm6
; SSE41-NEXT:    movapd %xmm4, %xmm5
; SSE41-NEXT:    xorpd %xmm2, %xmm5
; SSE41-NEXT:    movapd %xmm5, %xmm8
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm8
; SSE41-NEXT:    pcmpgtd %xmm2, %xmm5
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm5[0,0,2,2]
; SSE41-NEXT:    pand %xmm8, %xmm0
; SSE41-NEXT:    por %xmm5, %xmm0
; SSE41-NEXT:    pxor %xmm5, %xmm5
; SSE41-NEXT:    blendvpd %xmm0, %xmm4, %xmm5
; SSE41-NEXT:    movapd %xmm3, %xmm4
; SSE41-NEXT:    xorpd %xmm2, %xmm4
; SSE41-NEXT:    movapd %xmm4, %xmm8
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm8
; SSE41-NEXT:    pcmpgtd %xmm2, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,0,2,2]
; SSE41-NEXT:    pand %xmm8, %xmm0
; SSE41-NEXT:    por %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm3, %xmm7
; SSE41-NEXT:    packusdw %xmm5, %xmm7
; SSE41-NEXT:    packusdw %xmm7, %xmm6
; SSE41-NEXT:    packuswb %xmm6, %xmm1
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_packus_v16i64_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa 96(%rdi), %xmm0
; AVX1-NEXT:    vpmovzxbq {{.*#+}} xmm2 = [255,255]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm2, %xmm1
; AVX1-NEXT:    vblendvpd %xmm1, %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vmovdqa 112(%rdi), %xmm1
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm3
; AVX1-NEXT:    vblendvpd %xmm3, %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vmovdqa 64(%rdi), %xmm3
; AVX1-NEXT:    vpcmpgtq %xmm3, %xmm2, %xmm4
; AVX1-NEXT:    vblendvpd %xmm4, %xmm3, %xmm2, %xmm3
; AVX1-NEXT:    vmovdqa 80(%rdi), %xmm4
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm2, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm4, %xmm2, %xmm4
; AVX1-NEXT:    vmovdqa (%rdi), %xmm5
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm6
; AVX1-NEXT:    vmovdqa 32(%rdi), %xmm7
; AVX1-NEXT:    vmovdqa 48(%rdi), %xmm8
; AVX1-NEXT:    vpcmpgtq %xmm7, %xmm2, %xmm9
; AVX1-NEXT:    vblendvpd %xmm9, %xmm7, %xmm2, %xmm7
; AVX1-NEXT:    vpcmpgtq %xmm8, %xmm2, %xmm9
; AVX1-NEXT:    vblendvpd %xmm9, %xmm8, %xmm2, %xmm8
; AVX1-NEXT:    vpcmpgtq %xmm5, %xmm2, %xmm9
; AVX1-NEXT:    vblendvpd %xmm9, %xmm5, %xmm2, %xmm5
; AVX1-NEXT:    vpcmpgtq %xmm6, %xmm2, %xmm9
; AVX1-NEXT:    vblendvpd %xmm9, %xmm6, %xmm2, %xmm2
; AVX1-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; AVX1-NEXT:    vpcmpgtq %xmm6, %xmm2, %xmm9
; AVX1-NEXT:    vpand %xmm2, %xmm9, %xmm2
; AVX1-NEXT:    vpcmpgtq %xmm6, %xmm5, %xmm9
; AVX1-NEXT:    vpand %xmm5, %xmm9, %xmm5
; AVX1-NEXT:    vpackusdw %xmm2, %xmm5, %xmm2
; AVX1-NEXT:    vpcmpgtq %xmm6, %xmm8, %xmm5
; AVX1-NEXT:    vpand %xmm5, %xmm8, %xmm5
; AVX1-NEXT:    vpcmpgtq %xmm6, %xmm7, %xmm8
; AVX1-NEXT:    vpand %xmm7, %xmm8, %xmm7
; AVX1-NEXT:    vpackusdw %xmm5, %xmm7, %xmm5
; AVX1-NEXT:    vpackusdw %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpgtq %xmm6, %xmm4, %xmm5
; AVX1-NEXT:    vpand %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vpcmpgtq %xmm6, %xmm3, %xmm5
; AVX1-NEXT:    vpand %xmm3, %xmm5, %xmm3
; AVX1-NEXT:    vpackusdw %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpgtq %xmm6, %xmm1, %xmm4
; AVX1-NEXT:    vpand %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpcmpgtq %xmm6, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpackusdw %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpackuswb %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_packus_v16i64_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-NEXT:    vmovdqa 64(%rdi), %ymm2
; AVX2-NEXT:    vmovdqa 96(%rdi), %ymm3
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm4 = [255,255,255,255]
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm4, %ymm5
; AVX2-NEXT:    vblendvpd %ymm5, %ymm2, %ymm4, %ymm2
; AVX2-NEXT:    vpcmpgtq %ymm3, %ymm4, %ymm5
; AVX2-NEXT:    vblendvpd %ymm5, %ymm3, %ymm4, %ymm3
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm4, %ymm5
; AVX2-NEXT:    vblendvpd %ymm5, %ymm0, %ymm4, %ymm0
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm4, %ymm5
; AVX2-NEXT:    vblendvpd %ymm5, %ymm1, %ymm4, %ymm1
; AVX2-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vpcmpgtq %ymm4, %ymm1, %ymm5
; AVX2-NEXT:    vpand %ymm1, %ymm5, %ymm1
; AVX2-NEXT:    vpcmpgtq %ymm4, %ymm0, %ymm5
; AVX2-NEXT:    vpand %ymm0, %ymm5, %ymm0
; AVX2-NEXT:    vpackusdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtq %ymm4, %ymm3, %ymm1
; AVX2-NEXT:    vpand %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpgtq %ymm4, %ymm2, %ymm3
; AVX2-NEXT:    vpand %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpackusdw %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,1,3]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vpackusdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_packus_v16i64_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    vpmaxsq 64(%rdi), %zmm0, %zmm1
; AVX512-NEXT:    vpmovusqb %zmm1, %xmm1
; AVX512-NEXT:    vpmaxsq (%rdi), %zmm0, %zmm0
; AVX512-NEXT:    vpmovusqb %zmm0, %xmm0
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; SKX-LABEL: trunc_packus_v16i64_v16i8:
; SKX:       # %bb.0:
; SKX-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; SKX-NEXT:    vpmaxsq 96(%rdi), %ymm0, %ymm1
; SKX-NEXT:    vpmovusqb %ymm1, %xmm1
; SKX-NEXT:    vpmaxsq 64(%rdi), %ymm0, %ymm2
; SKX-NEXT:    vpmovusqb %ymm2, %xmm2
; SKX-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; SKX-NEXT:    vpmaxsq 32(%rdi), %ymm0, %ymm2
; SKX-NEXT:    vpmovusqb %ymm2, %xmm2
; SKX-NEXT:    vpmaxsq (%rdi), %ymm0, %ymm0
; SKX-NEXT:    vpmovusqb %ymm0, %xmm0
; SKX-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SKX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %a0 = load <16 x i64>, ptr %p0
  %1 = icmp slt <16 x i64> %a0, <i64 255, i64 255, i64 255, i64 255, i64 255, i64 255, i64 255, i64 255, i64 255, i64 255, i64 255, i64 255, i64 255, i64 255, i64 255, i64 255>
  %2 = select <16 x i1> %1, <16 x i64> %a0, <16 x i64> <i64 255, i64 255, i64 255, i64 255, i64 255, i64 255, i64 255, i64 255, i64 255, i64 255, i64 255, i64 255, i64 255, i64 255, i64 255, i64 255>
  %3 = icmp sgt <16 x i64> %2, zeroinitializer
  %4 = select <16 x i1> %3, <16 x i64> %2, <16 x i64> zeroinitializer
  %5 = trunc <16 x i64> %4 to <16 x i8>
  ret <16 x i8> %5
}

define <4 x i8> @trunc_packus_v4i32_v4i8(<4 x i32> %a0) "min-legal-vector-width"="256" {
; SSE-LABEL: trunc_packus_v4i32_v4i8:
; SSE:       # %bb.0:
; SSE-NEXT:    packssdw %xmm0, %xmm0
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: trunc_packus_v4i32_v4i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: trunc_packus_v4i32_v4i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    retq
;
; SKX-LABEL: trunc_packus_v4i32_v4i8:
; SKX:       # %bb.0:
; SKX-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; SKX-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; SKX-NEXT:    retq
  %1 = icmp slt <4 x i32> %a0, <i32 255, i32 255, i32 255, i32 255>
  %2 = select <4 x i1> %1, <4 x i32> %a0, <4 x i32> <i32 255, i32 255, i32 255, i32 255>
  %3 = icmp sgt <4 x i32> %2, zeroinitializer
  %4 = select <4 x i1> %3, <4 x i32> %2, <4 x i32> zeroinitializer
  %5 = trunc <4 x i32> %4 to <4 x i8>
  ret <4 x i8> %5
}

define void @trunc_packus_v4i32_v4i8_store(<4 x i32> %a0, ptr%p1) {
; SSE-LABEL: trunc_packus_v4i32_v4i8_store:
; SSE:       # %bb.0:
; SSE-NEXT:    packssdw %xmm0, %xmm0
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movd %xmm0, (%rdi)
; SSE-NEXT:    retq
;
; AVX-LABEL: trunc_packus_v4i32_v4i8_store:
; AVX:       # %bb.0:
; AVX-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vmovd %xmm0, (%rdi)
; AVX-NEXT:    retq
;
; AVX512F-LABEL: trunc_packus_v4i32_v4i8_store:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    vmovd %xmm0, (%rdi)
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_packus_v4i32_v4i8_store:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    vpmovusdb %xmm0, (%rdi)
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_packus_v4i32_v4i8_store:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX512BW-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX512BW-NEXT:    vmovd %xmm0, (%rdi)
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_packus_v4i32_v4i8_store:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm0
; AVX512BWVL-NEXT:    vpmovusdb %xmm0, (%rdi)
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_packus_v4i32_v4i8_store:
; SKX:       # %bb.0:
; SKX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; SKX-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm0
; SKX-NEXT:    vpmovusdb %xmm0, (%rdi)
; SKX-NEXT:    retq
  %1 = icmp slt <4 x i32> %a0, <i32 255, i32 255, i32 255, i32 255>
  %2 = select <4 x i1> %1, <4 x i32> %a0, <4 x i32> <i32 255, i32 255, i32 255, i32 255>
  %3 = icmp sgt <4 x i32> %2, zeroinitializer
  %4 = select <4 x i1> %3, <4 x i32> %2, <4 x i32> zeroinitializer
  %5 = trunc <4 x i32> %4 to <4 x i8>
  store <4 x i8> %5, ptr%p1
  ret void
}

define <8 x i8> @trunc_packus_v8i32_v8i8(<8 x i32> %a0) {
; SSE-LABEL: trunc_packus_v8i32_v8i8:
; SSE:       # %bb.0:
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_packus_v8i32_v8i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_packus_v8i32_v8i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_packus_v8i32_v8i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512F-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_packus_v8i32_v8i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vpmaxsd %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    vpmovusdb %ymm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_packus_v8i32_v8i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512BW-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX512BW-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_packus_v8i32_v8i8:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpmaxsd %ymm1, %ymm0, %ymm0
; AVX512BWVL-NEXT:    vpmovusdb %ymm0, %xmm0
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_packus_v8i32_v8i8:
; SKX:       # %bb.0:
; SKX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; SKX-NEXT:    vpmaxsd %ymm1, %ymm0, %ymm0
; SKX-NEXT:    vpmovusdb %ymm0, %xmm0
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %1 = icmp slt <8 x i32> %a0, <i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255>
  %2 = select <8 x i1> %1, <8 x i32> %a0, <8 x i32> <i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255>
  %3 = icmp sgt <8 x i32> %2, zeroinitializer
  %4 = select <8 x i1> %3, <8 x i32> %2, <8 x i32> zeroinitializer
  %5 = trunc <8 x i32> %4 to <8 x i8>
  ret <8 x i8> %5
}

define void @trunc_packus_v8i32_v8i8_store(<8 x i32> %a0, ptr%p1) {
; SSE-LABEL: trunc_packus_v8i32_v8i8_store:
; SSE:       # %bb.0:
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movq %xmm0, (%rdi)
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_packus_v8i32_v8i8_store:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vmovq %xmm0, (%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_packus_v8i32_v8i8_store:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vmovq %xmm0, (%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_packus_v8i32_v8i8_store:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512F-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    vmovq %xmm0, (%rdi)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_packus_v8i32_v8i8_store:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vpmaxsd %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    vpmovusdb %ymm0, (%rdi)
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_packus_v8i32_v8i8_store:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512BW-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX512BW-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX512BW-NEXT:    vmovq %xmm0, (%rdi)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_packus_v8i32_v8i8_store:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpmaxsd %ymm1, %ymm0, %ymm0
; AVX512BWVL-NEXT:    vpmovusdb %ymm0, (%rdi)
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_packus_v8i32_v8i8_store:
; SKX:       # %bb.0:
; SKX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; SKX-NEXT:    vpmaxsd %ymm1, %ymm0, %ymm0
; SKX-NEXT:    vpmovusdb %ymm0, (%rdi)
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %1 = icmp slt <8 x i32> %a0, <i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255>
  %2 = select <8 x i1> %1, <8 x i32> %a0, <8 x i32> <i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255>
  %3 = icmp sgt <8 x i32> %2, zeroinitializer
  %4 = select <8 x i1> %3, <8 x i32> %2, <8 x i32> zeroinitializer
  %5 = trunc <8 x i32> %4 to <8 x i8>
  store <8 x i8> %5, ptr%p1
  ret void
}

define <16 x i8> @trunc_packus_v16i32_v16i8(ptr %p0) "min-legal-vector-width"="256" {
; SSE-LABEL: trunc_packus_v16i32_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa 32(%rdi), %xmm1
; SSE-NEXT:    packssdw 48(%rdi), %xmm1
; SSE-NEXT:    packssdw 16(%rdi), %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_packus_v16i32_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa 32(%rdi), %xmm1
; AVX1-NEXT:    vpackssdw 48(%rdi), %xmm1, %xmm1
; AVX1-NEXT:    vpackssdw 16(%rdi), %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_packus_v16i32_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vpackssdw 32(%rdi), %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_packus_v16i32_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    vpmaxsd (%rdi), %zmm0, %zmm0
; AVX512-NEXT:    vpmovusdb %zmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; SKX-LABEL: trunc_packus_v16i32_v16i8:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovdqa (%rdi), %ymm0
; SKX-NEXT:    vpackusdw 32(%rdi), %ymm0, %ymm0
; SKX-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; SKX-NEXT:    vpmovuswb %ymm0, %xmm0
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %a0 = load <16 x i32>, ptr %p0
  %1 = icmp slt <16 x i32> %a0, <i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255>
  %2 = select <16 x i1> %1, <16 x i32> %a0, <16 x i32> <i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255>
  %3 = icmp sgt <16 x i32> %2, zeroinitializer
  %4 = select <16 x i1> %3, <16 x i32> %2, <16 x i32> zeroinitializer
  %5 = trunc <16 x i32> %4 to <16 x i8>
  ret <16 x i8> %5
}

define void @trunc_packus_v16i32_v16i8_store(ptr %p0, ptr %p1) "min-legal-vector-width"="256" {
; SSE-LABEL: trunc_packus_v16i32_v16i8_store:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa 32(%rdi), %xmm1
; SSE-NEXT:    packssdw 48(%rdi), %xmm1
; SSE-NEXT:    packssdw 16(%rdi), %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, (%rsi)
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_packus_v16i32_v16i8_store:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa 32(%rdi), %xmm1
; AVX1-NEXT:    vpackssdw 48(%rdi), %xmm1, %xmm1
; AVX1-NEXT:    vpackssdw 16(%rdi), %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, (%rsi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_packus_v16i32_v16i8_store:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vpackssdw 32(%rdi), %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX2-NEXT:    vmovdqa %xmm0, (%rsi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_packus_v16i32_v16i8_store:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    vpmaxsd (%rdi), %zmm0, %zmm0
; AVX512-NEXT:    vpmovusdb %zmm0, (%rsi)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; SKX-LABEL: trunc_packus_v16i32_v16i8_store:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovdqa (%rdi), %ymm0
; SKX-NEXT:    vpackusdw 32(%rdi), %ymm0, %ymm0
; SKX-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; SKX-NEXT:    vpmovuswb %ymm0, (%rsi)
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %a = load <16 x i32>, ptr %p0
  %b = icmp slt <16 x i32> %a, <i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255>
  %c = select <16 x i1> %b, <16 x i32> %a, <16 x i32> <i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255>
  %d = icmp sgt <16 x i32> %c, zeroinitializer
  %e = select <16 x i1> %d, <16 x i32> %c, <16 x i32> zeroinitializer
  %f = trunc <16 x i32> %e to <16 x i8>
  store <16 x i8> %f, ptr %p1
  ret void
}

define <8 x i8> @trunc_packus_v8i16_v8i8(<8 x i16> %a0) {
; SSE-LABEL: trunc_packus_v8i16_v8i8:
; SSE:       # %bb.0:
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: trunc_packus_v8i16_v8i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: trunc_packus_v8i16_v8i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    retq
;
; SKX-LABEL: trunc_packus_v8i16_v8i8:
; SKX:       # %bb.0:
; SKX-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; SKX-NEXT:    retq
  %1 = icmp slt <8 x i16> %a0, <i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255>
  %2 = select <8 x i1> %1, <8 x i16> %a0, <8 x i16> <i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255>
  %3 = icmp sgt <8 x i16> %2, zeroinitializer
  %4 = select <8 x i1> %3, <8 x i16> %2, <8 x i16> zeroinitializer
  %5 = trunc <8 x i16> %4 to <8 x i8>
  ret <8 x i8> %5
}

define void @trunc_packus_v8i16_v8i8_store(<8 x i16> %a0, ptr%p1) {
; SSE-LABEL: trunc_packus_v8i16_v8i8_store:
; SSE:       # %bb.0:
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movq %xmm0, (%rdi)
; SSE-NEXT:    retq
;
; AVX-LABEL: trunc_packus_v8i16_v8i8_store:
; AVX:       # %bb.0:
; AVX-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vmovq %xmm0, (%rdi)
; AVX-NEXT:    retq
;
; AVX512F-LABEL: trunc_packus_v8i16_v8i8_store:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    vmovq %xmm0, (%rdi)
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_packus_v8i16_v8i8_store:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX512VL-NEXT:    vmovq %xmm0, (%rdi)
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_packus_v8i16_v8i8_store:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX512BW-NEXT:    vmovq %xmm0, (%rdi)
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_packus_v8i16_v8i8_store:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpmaxsw %xmm1, %xmm0, %xmm0
; AVX512BWVL-NEXT:    vpmovuswb %xmm0, (%rdi)
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_packus_v8i16_v8i8_store:
; SKX:       # %bb.0:
; SKX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; SKX-NEXT:    vpmaxsw %xmm1, %xmm0, %xmm0
; SKX-NEXT:    vpmovuswb %xmm0, (%rdi)
; SKX-NEXT:    retq
  %1 = icmp slt <8 x i16> %a0, <i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255>
  %2 = select <8 x i1> %1, <8 x i16> %a0, <8 x i16> <i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255>
  %3 = icmp sgt <8 x i16> %2, zeroinitializer
  %4 = select <8 x i1> %3, <8 x i16> %2, <8 x i16> zeroinitializer
  %5 = trunc <8 x i16> %4 to <8 x i8>
  store <8 x i8> %5, ptr%p1
  ret void
}

define <16 x i8> @trunc_packus_v16i16_v16i8(<16 x i16> %a0) {
; SSE-LABEL: trunc_packus_v16i16_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_packus_v16i16_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_packus_v16i16_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_packus_v16i16_v16i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512F-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_packus_v16i16_v16i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512VL-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_packus_v16i16_v16i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512BW-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_packus_v16i16_v16i8:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BWVL-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm0
; AVX512BWVL-NEXT:    vpmovuswb %ymm0, %xmm0
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_packus_v16i16_v16i8:
; SKX:       # %bb.0:
; SKX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; SKX-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm0
; SKX-NEXT:    vpmovuswb %ymm0, %xmm0
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %1 = icmp slt <16 x i16> %a0, <i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255>
  %2 = select <16 x i1> %1, <16 x i16> %a0, <16 x i16> <i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255>
  %3 = icmp sgt <16 x i16> %2, zeroinitializer
  %4 = select <16 x i1> %3, <16 x i16> %2, <16 x i16> zeroinitializer
  %5 = trunc <16 x i16> %4 to <16 x i8>
  ret <16 x i8> %5
}

define <32 x i8> @trunc_packus_v32i16_v32i8(ptr %p0) "min-legal-vector-width"="256" {
; SSE-LABEL: trunc_packus_v32i16_v32i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa 32(%rdi), %xmm1
; SSE-NEXT:    packuswb 16(%rdi), %xmm0
; SSE-NEXT:    packuswb 48(%rdi), %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_packus_v32i16_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa 32(%rdi), %xmm1
; AVX1-NEXT:    vpackuswb 48(%rdi), %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb 16(%rdi), %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_packus_v32i16_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vpackuswb 32(%rdi), %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_packus_v32i16_v32i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512F-NEXT:    vpackuswb 32(%rdi), %ymm0, %ymm0
; AVX512F-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_packus_v32i16_v32i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512VL-NEXT:    vpackuswb 32(%rdi), %ymm0, %ymm0
; AVX512VL-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_packus_v32i16_v32i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX512BW-NEXT:    vpmaxsw (%rdi), %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovuswb %zmm0, %ymm0
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_packus_v32i16_v32i8:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX512BWVL-NEXT:    vpmaxsw (%rdi), %zmm0, %zmm0
; AVX512BWVL-NEXT:    vpmovuswb %zmm0, %ymm0
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_packus_v32i16_v32i8:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovdqa (%rdi), %ymm0
; SKX-NEXT:    vpackuswb 32(%rdi), %ymm0, %ymm0
; SKX-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; SKX-NEXT:    retq
  %a0 = load <32 x i16>, ptr %p0
  %1 = icmp slt <32 x i16> %a0, <i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255>
  %2 = select <32 x i1> %1, <32 x i16> %a0, <32 x i16> <i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255>
  %3 = icmp sgt <32 x i16> %2, zeroinitializer
  %4 = select <32 x i1> %3, <32 x i16> %2, <32 x i16> zeroinitializer
  %5 = trunc <32 x i16> %4 to <32 x i8>
  ret <32 x i8> %5
}

define <32 x i8> @trunc_packus_v32i32_v32i8(ptr %p0) "min-legal-vector-width"="256" {
; SSE-LABEL: trunc_packus_v32i32_v32i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa 32(%rdi), %xmm2
; SSE-NEXT:    movdqa 64(%rdi), %xmm1
; SSE-NEXT:    movdqa 96(%rdi), %xmm3
; SSE-NEXT:    packssdw 48(%rdi), %xmm2
; SSE-NEXT:    packssdw 16(%rdi), %xmm0
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    packssdw 112(%rdi), %xmm3
; SSE-NEXT:    packssdw 80(%rdi), %xmm1
; SSE-NEXT:    packuswb %xmm3, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_packus_v32i32_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa 32(%rdi), %xmm1
; AVX1-NEXT:    vmovdqa 64(%rdi), %xmm2
; AVX1-NEXT:    vmovdqa 96(%rdi), %xmm3
; AVX1-NEXT:    vpackssdw 112(%rdi), %xmm3, %xmm3
; AVX1-NEXT:    vpackssdw 80(%rdi), %xmm2, %xmm2
; AVX1-NEXT:    vpackuswb %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpackssdw 48(%rdi), %xmm1, %xmm1
; AVX1-NEXT:    vpackssdw 16(%rdi), %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_packus_v32i32_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovdqa 64(%rdi), %ymm1
; AVX2-NEXT:    vpackssdw 96(%rdi), %ymm1, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,1,3]
; AVX2-NEXT:    vpackssdw 32(%rdi), %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vpackuswb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_packus_v32i32_v32i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    vpmaxsd (%rdi), %zmm0, %zmm1
; AVX512-NEXT:    vpmovusdb %zmm1, %xmm1
; AVX512-NEXT:    vpmaxsd 64(%rdi), %zmm0, %zmm0
; AVX512-NEXT:    vpmovusdb %zmm0, %xmm0
; AVX512-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512-NEXT:    retq
;
; SKX-LABEL: trunc_packus_v32i32_v32i8:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovdqa (%rdi), %ymm0
; SKX-NEXT:    vmovdqa 64(%rdi), %ymm1
; SKX-NEXT:    vpackssdw 96(%rdi), %ymm1, %ymm1
; SKX-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,1,3]
; SKX-NEXT:    vpackssdw 32(%rdi), %ymm0, %ymm0
; SKX-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; SKX-NEXT:    vpackuswb %ymm1, %ymm0, %ymm0
; SKX-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; SKX-NEXT:    retq
  %a0 = load <32 x i32>, ptr %p0
  %1 = icmp slt <32 x i32> %a0, <i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255>
  %2 = select <32 x i1> %1, <32 x i32> %a0, <32 x i32> <i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255>
  %3 = icmp sgt <32 x i32> %2, zeroinitializer
  %4 = select <32 x i1> %3, <32 x i32> %2, <32 x i32> zeroinitializer
  %5 = trunc <32 x i32> %4 to <32 x i8>
  ret <32 x i8> %5
}
