; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64 -mcpu=skx | FileCheck %s --check-prefixes=SKX

;; Test no crash for AVX512 targets without prefer-vector-width=512.

define <16 x i32> @test_v16f32_oeq_q(<16 x i32> %a, <16 x i32> %b, <16 x float> %f1, <16 x float> %f2) #0 {
; SKX-LABEL: test_v16f32_oeq_q:
; SKX:       # %bb.0:
; SKX-NEXT:    vcmpeqps %ymm7, %ymm5, %k1
; SKX-NEXT:    vcmpeqps %ymm6, %ymm4, %k2
; SKX-NEXT:    vpblendmd %ymm0, %ymm2, %ymm0 {%k2}
; SKX-NEXT:    vpblendmd %ymm1, %ymm3, %ymm1 {%k1}
; SKX-NEXT:    retq
  %cond = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(
                                               <16 x float> %f1, <16 x float> %f2, metadata !"oeq",
                                               metadata !"fpexcept.strict") #0
  %res = select <16 x i1> %cond, <16 x i32> %a, <16 x i32> %b
  ret <16 x i32> %res
}

define <8 x i32> @test_v8f64_oeq_q(<8 x i32> %a, <8 x i32> %b, <8 x double> %f1, <8 x double> %f2) #0 {
; SKX-LABEL: test_v8f64_oeq_q:
; SKX:       # %bb.0:
; SKX-NEXT:    vcmpeqpd %ymm4, %ymm2, %k0
; SKX-NEXT:    vcmpeqpd %ymm5, %ymm3, %k1
; SKX-NEXT:    kshiftlb $4, %k1, %k1
; SKX-NEXT:    korb %k1, %k0, %k1
; SKX-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; SKX-NEXT:    retq
  %cond = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(
                                               <8 x double> %f1, <8 x double> %f2, metadata !"oeq",
                                               metadata !"fpexcept.strict") #0
  %res = select <8 x i1> %cond, <8 x i32> %a, <8 x i32> %b
  ret <8 x i32> %res
}

define <16 x i32> @test_v16f64_ogt(<16 x i32> %a, <16 x i32> %b, <16 x double> %f1, <16 x double> %f2) #0 {
; SKX-LABEL: test_v16f64_ogt
; SKX:       # %bb.0:
; SKX-NEXT:  pushq	%rbp
; SKX-NEXT:  movq	%rsp, %rbp
; SKX-NEXT:  andq	$-32, %rsp
; SKX-NEXT:  subq	$32, %rsp
; SKX-NEXT:  vcmpgtpd	80(%rbp), %ymm6, %k0
; SKX-NEXT:  vcmpgtpd	112(%rbp), %ymm7, %k1
; SKX-NEXT:  kshiftlb	$4, %k1, %k1
; SKX-NEXT:  korb	%k1, %k0, %k1
; SKX-NEXT:  vcmpgtpd	16(%rbp), %ymm4, %k0
; SKX-NEXT:  vcmpgtpd	48(%rbp), %ymm5, %k2
; SKX-NEXT:  kshiftlb	$4, %k2, %k2
; SKX-NEXT:  korb	%k2, %k0, %k2
; SKX-NEXT:  vpblendmd	%ymm0, %ymm2, %ymm0 {%k2}
; SKX-NEXT:  vpblendmd	%ymm1, %ymm3, %ymm1 {%k1}
; SKX-NEXT:  movq	%rbp, %rsp
; SKX-NEXT:  popq	%rbp
; SKX-NEXT:  retq
  %cond = tail call <16 x i1> @llvm.experimental.constrained.fcmps.v16f64(
    <16 x double> %f1, <16 x double> %f2, metadata !"ogt", metadata !"fpexcept.maytrap")
  %res = select <16 x i1> %cond, <16 x i32> %a, <16 x i32> %b
  ret <16 x i32> %res
}

declare <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float>, <16 x float>, metadata, metadata)
declare <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double>, <8 x double>, metadata, metadata)
declare <16 x i1> @llvm.experimental.constrained.fcmps.v16f64(<16 x double>, <16 x double>, metadata, metadata)

attributes #0 = { nounwind strictfp "min-legal-vector-width"="0" }
