; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx -O3 | FileCheck %s --check-prefix=AVX-32
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx -O3 | FileCheck %s --check-prefix=AVX-64
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx512f -mattr=+avx512vl -O3 | FileCheck %s --check-prefix=AVX512-32
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f -mattr=+avx512vl -O3 | FileCheck %s --check-prefix=AVX512-64
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx512f -O3 | FileCheck %s --check-prefix=AVX512F-32
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f -O3 | FileCheck %s --check-prefix=AVX512F-64

define <8 x i32> @test_v8f32_oeq_q(<8 x i32> %a, <8 x i32> %b, <8 x float> %f1, <8 x float> %f2) #0 {
; AVX-32-LABEL: test_v8f32_oeq_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpeqps 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v8f32_oeq_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpeqps %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v8f32_oeq_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpeqps 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v8f32_oeq_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpeqps %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v8f32_oeq_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpeqps 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v8f32_oeq_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpeqps %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(
                                               <8 x float> %f1, <8 x float> %f2, metadata !"oeq",
                                               metadata !"fpexcept.strict") #0
  %res = select <8 x i1> %cond, <8 x i32> %a, <8 x i32> %b
  ret <8 x i32> %res
}

define <8 x i32> @test_v8f32_ogt_q(<8 x i32> %a, <8 x i32> %b, <8 x float> %f1, <8 x float> %f2) #0 {
; AVX-32-LABEL: test_v8f32_ogt_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vmovaps 8(%ebp), %ymm3
; AVX-32-NEXT:    vcmplt_oqps %ymm2, %ymm3, %ymm2
; AVX-32-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v8f32_ogt_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmplt_oqps %ymm2, %ymm3, %ymm2
; AVX-64-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v8f32_ogt_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpgt_oqps 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v8f32_ogt_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmplt_oqps %ymm2, %ymm3, %k1
; AVX512-64-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v8f32_ogt_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vmovaps 8(%ebp), %ymm3
; AVX512F-32-NEXT:    vcmplt_oqps %ymm2, %ymm3, %ymm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v8f32_ogt_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmplt_oqps %ymm2, %ymm3, %ymm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(
                                               <8 x float> %f1, <8 x float> %f2, metadata !"ogt",
                                               metadata !"fpexcept.strict") #0
  %res = select <8 x i1> %cond, <8 x i32> %a, <8 x i32> %b
  ret <8 x i32> %res
}

define <8 x i32> @test_v8f32_oge_q(<8 x i32> %a, <8 x i32> %b, <8 x float> %f1, <8 x float> %f2) #0 {
; AVX-32-LABEL: test_v8f32_oge_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vmovaps 8(%ebp), %ymm3
; AVX-32-NEXT:    vcmple_oqps %ymm2, %ymm3, %ymm2
; AVX-32-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v8f32_oge_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmple_oqps %ymm2, %ymm3, %ymm2
; AVX-64-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v8f32_oge_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpge_oqps 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v8f32_oge_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmple_oqps %ymm2, %ymm3, %k1
; AVX512-64-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v8f32_oge_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vmovaps 8(%ebp), %ymm3
; AVX512F-32-NEXT:    vcmple_oqps %ymm2, %ymm3, %ymm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v8f32_oge_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmple_oqps %ymm2, %ymm3, %ymm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(
                                               <8 x float> %f1, <8 x float> %f2, metadata !"oge",
                                               metadata !"fpexcept.strict") #0
  %res = select <8 x i1> %cond, <8 x i32> %a, <8 x i32> %b
  ret <8 x i32> %res
}

define <8 x i32> @test_v8f32_olt_q(<8 x i32> %a, <8 x i32> %b, <8 x float> %f1, <8 x float> %f2) #0 {
; AVX-32-LABEL: test_v8f32_olt_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmplt_oqps 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v8f32_olt_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmplt_oqps %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v8f32_olt_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmplt_oqps 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v8f32_olt_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmplt_oqps %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v8f32_olt_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmplt_oqps 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v8f32_olt_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmplt_oqps %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(
                                               <8 x float> %f1, <8 x float> %f2, metadata !"olt",
                                               metadata !"fpexcept.strict") #0
  %res = select <8 x i1> %cond, <8 x i32> %a, <8 x i32> %b
  ret <8 x i32> %res
}

define <8 x i32> @test_v8f32_ole_q(<8 x i32> %a, <8 x i32> %b, <8 x float> %f1, <8 x float> %f2) #0 {
; AVX-32-LABEL: test_v8f32_ole_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmple_oqps 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v8f32_ole_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmple_oqps %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v8f32_ole_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmple_oqps 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v8f32_ole_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmple_oqps %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v8f32_ole_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmple_oqps 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v8f32_ole_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmple_oqps %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(
                                               <8 x float> %f1, <8 x float> %f2, metadata !"ole",
                                               metadata !"fpexcept.strict") #0
  %res = select <8 x i1> %cond, <8 x i32> %a, <8 x i32> %b
  ret <8 x i32> %res
}

define <8 x i32> @test_v8f32_one_q(<8 x i32> %a, <8 x i32> %b, <8 x float> %f1, <8 x float> %f2) #0 {
; AVX-32-LABEL: test_v8f32_one_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpneq_oqps 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v8f32_one_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpneq_oqps %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v8f32_one_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpneq_oqps 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v8f32_one_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpneq_oqps %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v8f32_one_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpneq_oqps 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v8f32_one_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpneq_oqps %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(
                                               <8 x float> %f1, <8 x float> %f2, metadata !"one",
                                               metadata !"fpexcept.strict") #0
  %res = select <8 x i1> %cond, <8 x i32> %a, <8 x i32> %b
  ret <8 x i32> %res
}

define <8 x i32> @test_v8f32_ord_q(<8 x i32> %a, <8 x i32> %b, <8 x float> %f1, <8 x float> %f2) #0 {
; AVX-32-LABEL: test_v8f32_ord_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpordps 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v8f32_ord_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpordps %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v8f32_ord_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpordps 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v8f32_ord_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpordps %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v8f32_ord_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpordps 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v8f32_ord_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpordps %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(
                                               <8 x float> %f1, <8 x float> %f2, metadata !"ord",
                                               metadata !"fpexcept.strict") #0
  %res = select <8 x i1> %cond, <8 x i32> %a, <8 x i32> %b
  ret <8 x i32> %res
}

define <8 x i32> @test_v8f32_ueq_q(<8 x i32> %a, <8 x i32> %b, <8 x float> %f1, <8 x float> %f2) #0 {
; AVX-32-LABEL: test_v8f32_ueq_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpeq_uqps 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v8f32_ueq_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpeq_uqps %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v8f32_ueq_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpeq_uqps 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v8f32_ueq_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpeq_uqps %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v8f32_ueq_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpeq_uqps 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v8f32_ueq_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpeq_uqps %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(
                                               <8 x float> %f1, <8 x float> %f2, metadata !"ueq",
                                               metadata !"fpexcept.strict") #0
  %res = select <8 x i1> %cond, <8 x i32> %a, <8 x i32> %b
  ret <8 x i32> %res
}

define <8 x i32> @test_v8f32_ugt_q(<8 x i32> %a, <8 x i32> %b, <8 x float> %f1, <8 x float> %f2) #0 {
; AVX-32-LABEL: test_v8f32_ugt_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpnle_uqps 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v8f32_ugt_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpnle_uqps %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v8f32_ugt_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpnle_uqps 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v8f32_ugt_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnle_uqps %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v8f32_ugt_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpnle_uqps 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v8f32_ugt_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpnle_uqps %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(
                                               <8 x float> %f1, <8 x float> %f2, metadata !"ugt",
                                               metadata !"fpexcept.strict") #0
  %res = select <8 x i1> %cond, <8 x i32> %a, <8 x i32> %b
  ret <8 x i32> %res
}

define <8 x i32> @test_v8f32_uge_q(<8 x i32> %a, <8 x i32> %b, <8 x float> %f1, <8 x float> %f2) #0 {
; AVX-32-LABEL: test_v8f32_uge_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpnlt_uqps 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v8f32_uge_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpnlt_uqps %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v8f32_uge_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpnlt_uqps 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v8f32_uge_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnlt_uqps %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v8f32_uge_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpnlt_uqps 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v8f32_uge_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpnlt_uqps %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(
                                               <8 x float> %f1, <8 x float> %f2, metadata !"uge",
                                               metadata !"fpexcept.strict") #0
  %res = select <8 x i1> %cond, <8 x i32> %a, <8 x i32> %b
  ret <8 x i32> %res
}

define <8 x i32> @test_v8f32_ult_q(<8 x i32> %a, <8 x i32> %b, <8 x float> %f1, <8 x float> %f2) #0 {
; AVX-32-LABEL: test_v8f32_ult_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vmovaps 8(%ebp), %ymm3
; AVX-32-NEXT:    vcmpnle_uqps %ymm2, %ymm3, %ymm2
; AVX-32-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v8f32_ult_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpnle_uqps %ymm2, %ymm3, %ymm2
; AVX-64-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v8f32_ult_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpnge_uqps 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v8f32_ult_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnle_uqps %ymm2, %ymm3, %k1
; AVX512-64-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v8f32_ult_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vmovaps 8(%ebp), %ymm3
; AVX512F-32-NEXT:    vcmpnle_uqps %ymm2, %ymm3, %ymm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v8f32_ult_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpnle_uqps %ymm2, %ymm3, %ymm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(
                                               <8 x float> %f1, <8 x float> %f2, metadata !"ult",
                                               metadata !"fpexcept.strict") #0
  %res = select <8 x i1> %cond, <8 x i32> %a, <8 x i32> %b
  ret <8 x i32> %res
}

define <8 x i32> @test_v8f32_ule_q(<8 x i32> %a, <8 x i32> %b, <8 x float> %f1, <8 x float> %f2) #0 {
; AVX-32-LABEL: test_v8f32_ule_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vmovaps 8(%ebp), %ymm3
; AVX-32-NEXT:    vcmpnlt_uqps %ymm2, %ymm3, %ymm2
; AVX-32-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v8f32_ule_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpnlt_uqps %ymm2, %ymm3, %ymm2
; AVX-64-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v8f32_ule_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpngt_uqps 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v8f32_ule_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnlt_uqps %ymm2, %ymm3, %k1
; AVX512-64-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v8f32_ule_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vmovaps 8(%ebp), %ymm3
; AVX512F-32-NEXT:    vcmpnlt_uqps %ymm2, %ymm3, %ymm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v8f32_ule_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpnlt_uqps %ymm2, %ymm3, %ymm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(
                                               <8 x float> %f1, <8 x float> %f2, metadata !"ule",
                                               metadata !"fpexcept.strict") #0
  %res = select <8 x i1> %cond, <8 x i32> %a, <8 x i32> %b
  ret <8 x i32> %res
}

define <8 x i32> @test_v8f32_une_q(<8 x i32> %a, <8 x i32> %b, <8 x float> %f1, <8 x float> %f2) #0 {
; AVX-32-LABEL: test_v8f32_une_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpneqps 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v8f32_une_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpneqps %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v8f32_une_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpneqps 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v8f32_une_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpneqps %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v8f32_une_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpneqps 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v8f32_une_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpneqps %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(
                                               <8 x float> %f1, <8 x float> %f2, metadata !"une",
                                               metadata !"fpexcept.strict") #0
  %res = select <8 x i1> %cond, <8 x i32> %a, <8 x i32> %b
  ret <8 x i32> %res
}

define <8 x i32> @test_v8f32_uno_q(<8 x i32> %a, <8 x i32> %b, <8 x float> %f1, <8 x float> %f2) #0 {
; AVX-32-LABEL: test_v8f32_uno_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpunordps 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v8f32_uno_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpunordps %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v8f32_uno_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpunordps 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v8f32_uno_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpunordps %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v8f32_uno_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpunordps 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v8f32_uno_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpunordps %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(
                                               <8 x float> %f1, <8 x float> %f2, metadata !"uno",
                                               metadata !"fpexcept.strict") #0
  %res = select <8 x i1> %cond, <8 x i32> %a, <8 x i32> %b
  ret <8 x i32> %res
}

define <4 x i64> @test_v4f64_oeq_q(<4 x i64> %a, <4 x i64> %b, <4 x double> %f1, <4 x double> %f2) #0 {
; AVX-32-LABEL: test_v4f64_oeq_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpeqpd 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f64_oeq_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpeqpd %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f64_oeq_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpeqpd 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f64_oeq_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpeqpd %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f64_oeq_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpeqpd 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f64_oeq_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpeqpd %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(
                                               <4 x double> %f1, <4 x double> %f2, metadata !"oeq",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i64> %a, <4 x i64> %b
  ret <4 x i64> %res
}

define <4 x i64> @test_v4f64_ogt_q(<4 x i64> %a, <4 x i64> %b, <4 x double> %f1, <4 x double> %f2) #0 {
; AVX-32-LABEL: test_v4f64_ogt_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vmovapd 8(%ebp), %ymm3
; AVX-32-NEXT:    vcmplt_oqpd %ymm2, %ymm3, %ymm2
; AVX-32-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f64_ogt_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmplt_oqpd %ymm2, %ymm3, %ymm2
; AVX-64-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f64_ogt_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpgt_oqpd 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f64_ogt_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmplt_oqpd %ymm2, %ymm3, %k1
; AVX512-64-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f64_ogt_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vmovapd 8(%ebp), %ymm3
; AVX512F-32-NEXT:    vcmplt_oqpd %ymm2, %ymm3, %ymm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f64_ogt_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmplt_oqpd %ymm2, %ymm3, %ymm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(
                                               <4 x double> %f1, <4 x double> %f2, metadata !"ogt",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i64> %a, <4 x i64> %b
  ret <4 x i64> %res
}

define <4 x i64> @test_v4f64_oge_q(<4 x i64> %a, <4 x i64> %b, <4 x double> %f1, <4 x double> %f2) #0 {
; AVX-32-LABEL: test_v4f64_oge_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vmovapd 8(%ebp), %ymm3
; AVX-32-NEXT:    vcmple_oqpd %ymm2, %ymm3, %ymm2
; AVX-32-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f64_oge_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmple_oqpd %ymm2, %ymm3, %ymm2
; AVX-64-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f64_oge_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpge_oqpd 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f64_oge_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmple_oqpd %ymm2, %ymm3, %k1
; AVX512-64-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f64_oge_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vmovapd 8(%ebp), %ymm3
; AVX512F-32-NEXT:    vcmple_oqpd %ymm2, %ymm3, %ymm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f64_oge_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmple_oqpd %ymm2, %ymm3, %ymm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(
                                               <4 x double> %f1, <4 x double> %f2, metadata !"oge",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i64> %a, <4 x i64> %b
  ret <4 x i64> %res
}

define <4 x i64> @test_v4f64_olt_q(<4 x i64> %a, <4 x i64> %b, <4 x double> %f1, <4 x double> %f2) #0 {
; AVX-32-LABEL: test_v4f64_olt_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmplt_oqpd 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f64_olt_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmplt_oqpd %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f64_olt_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmplt_oqpd 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f64_olt_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmplt_oqpd %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f64_olt_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmplt_oqpd 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f64_olt_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmplt_oqpd %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(
                                               <4 x double> %f1, <4 x double> %f2, metadata !"olt",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i64> %a, <4 x i64> %b
  ret <4 x i64> %res
}

define <4 x i64> @test_v4f64_ole_q(<4 x i64> %a, <4 x i64> %b, <4 x double> %f1, <4 x double> %f2) #0 {
; AVX-32-LABEL: test_v4f64_ole_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmple_oqpd 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f64_ole_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmple_oqpd %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f64_ole_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmple_oqpd 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f64_ole_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmple_oqpd %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f64_ole_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmple_oqpd 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f64_ole_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmple_oqpd %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(
                                               <4 x double> %f1, <4 x double> %f2, metadata !"ole",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i64> %a, <4 x i64> %b
  ret <4 x i64> %res
}

define <4 x i64> @test_v4f64_one_q(<4 x i64> %a, <4 x i64> %b, <4 x double> %f1, <4 x double> %f2) #0 {
; AVX-32-LABEL: test_v4f64_one_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpneq_oqpd 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f64_one_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpneq_oqpd %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f64_one_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpneq_oqpd 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f64_one_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpneq_oqpd %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f64_one_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpneq_oqpd 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f64_one_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpneq_oqpd %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(
                                               <4 x double> %f1, <4 x double> %f2, metadata !"one",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i64> %a, <4 x i64> %b
  ret <4 x i64> %res
}

define <4 x i64> @test_v4f64_ord_q(<4 x i64> %a, <4 x i64> %b, <4 x double> %f1, <4 x double> %f2) #0 {
; AVX-32-LABEL: test_v4f64_ord_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpordpd 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f64_ord_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpordpd %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f64_ord_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpordpd 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f64_ord_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpordpd %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f64_ord_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpordpd 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f64_ord_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpordpd %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(
                                               <4 x double> %f1, <4 x double> %f2, metadata !"ord",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i64> %a, <4 x i64> %b
  ret <4 x i64> %res
}

define <4 x i64> @test_v4f64_ueq_q(<4 x i64> %a, <4 x i64> %b, <4 x double> %f1, <4 x double> %f2) #0 {
; AVX-32-LABEL: test_v4f64_ueq_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpeq_uqpd 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f64_ueq_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpeq_uqpd %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f64_ueq_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpeq_uqpd 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f64_ueq_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpeq_uqpd %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f64_ueq_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpeq_uqpd 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f64_ueq_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpeq_uqpd %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(
                                               <4 x double> %f1, <4 x double> %f2, metadata !"ueq",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i64> %a, <4 x i64> %b
  ret <4 x i64> %res
}

define <4 x i64> @test_v4f64_ugt_q(<4 x i64> %a, <4 x i64> %b, <4 x double> %f1, <4 x double> %f2) #0 {
; AVX-32-LABEL: test_v4f64_ugt_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpnle_uqpd 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f64_ugt_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpnle_uqpd %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f64_ugt_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpnle_uqpd 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f64_ugt_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnle_uqpd %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f64_ugt_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpnle_uqpd 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f64_ugt_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpnle_uqpd %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(
                                               <4 x double> %f1, <4 x double> %f2, metadata !"ugt",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i64> %a, <4 x i64> %b
  ret <4 x i64> %res
}

define <4 x i64> @test_v4f64_uge_q(<4 x i64> %a, <4 x i64> %b, <4 x double> %f1, <4 x double> %f2) #0 {
; AVX-32-LABEL: test_v4f64_uge_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpnlt_uqpd 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f64_uge_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpnlt_uqpd %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f64_uge_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpnlt_uqpd 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f64_uge_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnlt_uqpd %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f64_uge_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpnlt_uqpd 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f64_uge_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpnlt_uqpd %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(
                                               <4 x double> %f1, <4 x double> %f2, metadata !"uge",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i64> %a, <4 x i64> %b
  ret <4 x i64> %res
}

define <4 x i64> @test_v4f64_ult_q(<4 x i64> %a, <4 x i64> %b, <4 x double> %f1, <4 x double> %f2) #0 {
; AVX-32-LABEL: test_v4f64_ult_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vmovapd 8(%ebp), %ymm3
; AVX-32-NEXT:    vcmpnle_uqpd %ymm2, %ymm3, %ymm2
; AVX-32-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f64_ult_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpnle_uqpd %ymm2, %ymm3, %ymm2
; AVX-64-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f64_ult_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpnge_uqpd 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f64_ult_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnle_uqpd %ymm2, %ymm3, %k1
; AVX512-64-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f64_ult_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vmovapd 8(%ebp), %ymm3
; AVX512F-32-NEXT:    vcmpnle_uqpd %ymm2, %ymm3, %ymm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f64_ult_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpnle_uqpd %ymm2, %ymm3, %ymm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(
                                               <4 x double> %f1, <4 x double> %f2, metadata !"ult",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i64> %a, <4 x i64> %b
  ret <4 x i64> %res
}

define <4 x i64> @test_v4f64_ule_q(<4 x i64> %a, <4 x i64> %b, <4 x double> %f1, <4 x double> %f2) #0 {
; AVX-32-LABEL: test_v4f64_ule_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vmovapd 8(%ebp), %ymm3
; AVX-32-NEXT:    vcmpnlt_uqpd %ymm2, %ymm3, %ymm2
; AVX-32-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f64_ule_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpnlt_uqpd %ymm2, %ymm3, %ymm2
; AVX-64-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f64_ule_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpngt_uqpd 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f64_ule_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnlt_uqpd %ymm2, %ymm3, %k1
; AVX512-64-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f64_ule_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vmovapd 8(%ebp), %ymm3
; AVX512F-32-NEXT:    vcmpnlt_uqpd %ymm2, %ymm3, %ymm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f64_ule_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpnlt_uqpd %ymm2, %ymm3, %ymm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(
                                               <4 x double> %f1, <4 x double> %f2, metadata !"ule",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i64> %a, <4 x i64> %b
  ret <4 x i64> %res
}

define <4 x i64> @test_v4f64_une_q(<4 x i64> %a, <4 x i64> %b, <4 x double> %f1, <4 x double> %f2) #0 {
; AVX-32-LABEL: test_v4f64_une_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpneqpd 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f64_une_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpneqpd %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f64_une_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpneqpd 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f64_une_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpneqpd %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f64_une_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpneqpd 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f64_une_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpneqpd %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(
                                               <4 x double> %f1, <4 x double> %f2, metadata !"une",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i64> %a, <4 x i64> %b
  ret <4 x i64> %res
}

define <4 x i64> @test_v4f64_uno_q(<4 x i64> %a, <4 x i64> %b, <4 x double> %f1, <4 x double> %f2) #0 {
; AVX-32-LABEL: test_v4f64_uno_q:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpunordpd 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f64_uno_q:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpunordpd %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f64_uno_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpunordpd 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f64_uno_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpunordpd %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f64_uno_q:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpunordpd 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f64_uno_q:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpunordpd %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(
                                               <4 x double> %f1, <4 x double> %f2, metadata !"uno",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i64> %a, <4 x i64> %b
  ret <4 x i64> %res
}

define <8 x i32> @test_v8f32_oeq_s(<8 x i32> %a, <8 x i32> %b, <8 x float> %f1, <8 x float> %f2) #0 {
; AVX-32-LABEL: test_v8f32_oeq_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpeq_osps 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v8f32_oeq_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpeq_osps %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v8f32_oeq_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpeq_osps 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v8f32_oeq_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpeq_osps %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v8f32_oeq_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpeq_osps 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v8f32_oeq_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpeq_osps %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <8 x i1> @llvm.experimental.constrained.fcmps.v8f32(
                                               <8 x float> %f1, <8 x float> %f2, metadata !"oeq",
                                               metadata !"fpexcept.strict") #0
  %res = select <8 x i1> %cond, <8 x i32> %a, <8 x i32> %b
  ret <8 x i32> %res
}

define <8 x i32> @test_v8f32_ogt_s(<8 x i32> %a, <8 x i32> %b, <8 x float> %f1, <8 x float> %f2) #0 {
; AVX-32-LABEL: test_v8f32_ogt_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vmovaps 8(%ebp), %ymm3
; AVX-32-NEXT:    vcmpltps %ymm2, %ymm3, %ymm2
; AVX-32-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v8f32_ogt_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpltps %ymm2, %ymm3, %ymm2
; AVX-64-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v8f32_ogt_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpgtps 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v8f32_ogt_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpltps %ymm2, %ymm3, %k1
; AVX512-64-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v8f32_ogt_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vmovaps 8(%ebp), %ymm3
; AVX512F-32-NEXT:    vcmpltps %ymm2, %ymm3, %ymm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v8f32_ogt_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpltps %ymm2, %ymm3, %ymm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <8 x i1> @llvm.experimental.constrained.fcmps.v8f32(
                                               <8 x float> %f1, <8 x float> %f2, metadata !"ogt",
                                               metadata !"fpexcept.strict") #0
  %res = select <8 x i1> %cond, <8 x i32> %a, <8 x i32> %b
  ret <8 x i32> %res
}

define <8 x i32> @test_v8f32_oge_s(<8 x i32> %a, <8 x i32> %b, <8 x float> %f1, <8 x float> %f2) #0 {
; AVX-32-LABEL: test_v8f32_oge_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vmovaps 8(%ebp), %ymm3
; AVX-32-NEXT:    vcmpleps %ymm2, %ymm3, %ymm2
; AVX-32-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v8f32_oge_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpleps %ymm2, %ymm3, %ymm2
; AVX-64-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v8f32_oge_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpgeps 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v8f32_oge_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpleps %ymm2, %ymm3, %k1
; AVX512-64-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v8f32_oge_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vmovaps 8(%ebp), %ymm3
; AVX512F-32-NEXT:    vcmpleps %ymm2, %ymm3, %ymm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v8f32_oge_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpleps %ymm2, %ymm3, %ymm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <8 x i1> @llvm.experimental.constrained.fcmps.v8f32(
                                               <8 x float> %f1, <8 x float> %f2, metadata !"oge",
                                               metadata !"fpexcept.strict") #0
  %res = select <8 x i1> %cond, <8 x i32> %a, <8 x i32> %b
  ret <8 x i32> %res
}

define <8 x i32> @test_v8f32_olt_s(<8 x i32> %a, <8 x i32> %b, <8 x float> %f1, <8 x float> %f2) #0 {
; AVX-32-LABEL: test_v8f32_olt_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpltps 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v8f32_olt_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpltps %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v8f32_olt_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpltps 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v8f32_olt_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpltps %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v8f32_olt_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpltps 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v8f32_olt_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpltps %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <8 x i1> @llvm.experimental.constrained.fcmps.v8f32(
                                               <8 x float> %f1, <8 x float> %f2, metadata !"olt",
                                               metadata !"fpexcept.strict") #0
  %res = select <8 x i1> %cond, <8 x i32> %a, <8 x i32> %b
  ret <8 x i32> %res
}

define <8 x i32> @test_v8f32_ole_s(<8 x i32> %a, <8 x i32> %b, <8 x float> %f1, <8 x float> %f2) #0 {
; AVX-32-LABEL: test_v8f32_ole_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpleps 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v8f32_ole_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpleps %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v8f32_ole_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpleps 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v8f32_ole_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpleps %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v8f32_ole_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpleps 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v8f32_ole_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpleps %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <8 x i1> @llvm.experimental.constrained.fcmps.v8f32(
                                               <8 x float> %f1, <8 x float> %f2, metadata !"ole",
                                               metadata !"fpexcept.strict") #0
  %res = select <8 x i1> %cond, <8 x i32> %a, <8 x i32> %b
  ret <8 x i32> %res
}

define <8 x i32> @test_v8f32_one_s(<8 x i32> %a, <8 x i32> %b, <8 x float> %f1, <8 x float> %f2) #0 {
; AVX-32-LABEL: test_v8f32_one_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpneq_osps 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v8f32_one_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpneq_osps %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v8f32_one_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpneq_osps 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v8f32_one_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpneq_osps %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v8f32_one_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpneq_osps 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v8f32_one_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpneq_osps %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <8 x i1> @llvm.experimental.constrained.fcmps.v8f32(
                                               <8 x float> %f1, <8 x float> %f2, metadata !"one",
                                               metadata !"fpexcept.strict") #0
  %res = select <8 x i1> %cond, <8 x i32> %a, <8 x i32> %b
  ret <8 x i32> %res
}

define <8 x i32> @test_v8f32_ord_s(<8 x i32> %a, <8 x i32> %b, <8 x float> %f1, <8 x float> %f2) #0 {
; AVX-32-LABEL: test_v8f32_ord_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpord_sps 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v8f32_ord_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpord_sps %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v8f32_ord_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpord_sps 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v8f32_ord_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpord_sps %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v8f32_ord_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpord_sps 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v8f32_ord_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpord_sps %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <8 x i1> @llvm.experimental.constrained.fcmps.v8f32(
                                               <8 x float> %f1, <8 x float> %f2, metadata !"ord",
                                               metadata !"fpexcept.strict") #0
  %res = select <8 x i1> %cond, <8 x i32> %a, <8 x i32> %b
  ret <8 x i32> %res
}

define <8 x i32> @test_v8f32_ueq_s(<8 x i32> %a, <8 x i32> %b, <8 x float> %f1, <8 x float> %f2) #0 {
; AVX-32-LABEL: test_v8f32_ueq_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpeq_usps 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v8f32_ueq_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpeq_usps %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v8f32_ueq_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpeq_usps 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v8f32_ueq_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpeq_usps %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v8f32_ueq_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpeq_usps 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v8f32_ueq_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpeq_usps %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <8 x i1> @llvm.experimental.constrained.fcmps.v8f32(
                                               <8 x float> %f1, <8 x float> %f2, metadata !"ueq",
                                               metadata !"fpexcept.strict") #0
  %res = select <8 x i1> %cond, <8 x i32> %a, <8 x i32> %b
  ret <8 x i32> %res
}

define <8 x i32> @test_v8f32_ugt_s(<8 x i32> %a, <8 x i32> %b, <8 x float> %f1, <8 x float> %f2) #0 {
; AVX-32-LABEL: test_v8f32_ugt_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpnleps 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v8f32_ugt_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpnleps %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v8f32_ugt_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpnleps 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v8f32_ugt_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnleps %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v8f32_ugt_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpnleps 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v8f32_ugt_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpnleps %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <8 x i1> @llvm.experimental.constrained.fcmps.v8f32(
                                               <8 x float> %f1, <8 x float> %f2, metadata !"ugt",
                                               metadata !"fpexcept.strict") #0
  %res = select <8 x i1> %cond, <8 x i32> %a, <8 x i32> %b
  ret <8 x i32> %res
}

define <8 x i32> @test_v8f32_uge_s(<8 x i32> %a, <8 x i32> %b, <8 x float> %f1, <8 x float> %f2) #0 {
; AVX-32-LABEL: test_v8f32_uge_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpnltps 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v8f32_uge_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpnltps %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v8f32_uge_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpnltps 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v8f32_uge_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnltps %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v8f32_uge_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpnltps 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v8f32_uge_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpnltps %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <8 x i1> @llvm.experimental.constrained.fcmps.v8f32(
                                               <8 x float> %f1, <8 x float> %f2, metadata !"uge",
                                               metadata !"fpexcept.strict") #0
  %res = select <8 x i1> %cond, <8 x i32> %a, <8 x i32> %b
  ret <8 x i32> %res
}

define <8 x i32> @test_v8f32_ult_s(<8 x i32> %a, <8 x i32> %b, <8 x float> %f1, <8 x float> %f2) #0 {
; AVX-32-LABEL: test_v8f32_ult_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vmovaps 8(%ebp), %ymm3
; AVX-32-NEXT:    vcmpnleps %ymm2, %ymm3, %ymm2
; AVX-32-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v8f32_ult_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpnleps %ymm2, %ymm3, %ymm2
; AVX-64-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v8f32_ult_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpngeps 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v8f32_ult_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnleps %ymm2, %ymm3, %k1
; AVX512-64-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v8f32_ult_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vmovaps 8(%ebp), %ymm3
; AVX512F-32-NEXT:    vcmpnleps %ymm2, %ymm3, %ymm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v8f32_ult_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpnleps %ymm2, %ymm3, %ymm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <8 x i1> @llvm.experimental.constrained.fcmps.v8f32(
                                               <8 x float> %f1, <8 x float> %f2, metadata !"ult",
                                               metadata !"fpexcept.strict") #0
  %res = select <8 x i1> %cond, <8 x i32> %a, <8 x i32> %b
  ret <8 x i32> %res
}

define <8 x i32> @test_v8f32_ule_s(<8 x i32> %a, <8 x i32> %b, <8 x float> %f1, <8 x float> %f2) #0 {
; AVX-32-LABEL: test_v8f32_ule_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vmovaps 8(%ebp), %ymm3
; AVX-32-NEXT:    vcmpnltps %ymm2, %ymm3, %ymm2
; AVX-32-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v8f32_ule_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpnltps %ymm2, %ymm3, %ymm2
; AVX-64-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v8f32_ule_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpngtps 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v8f32_ule_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnltps %ymm2, %ymm3, %k1
; AVX512-64-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v8f32_ule_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vmovaps 8(%ebp), %ymm3
; AVX512F-32-NEXT:    vcmpnltps %ymm2, %ymm3, %ymm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v8f32_ule_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpnltps %ymm2, %ymm3, %ymm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <8 x i1> @llvm.experimental.constrained.fcmps.v8f32(
                                               <8 x float> %f1, <8 x float> %f2, metadata !"ule",
                                               metadata !"fpexcept.strict") #0
  %res = select <8 x i1> %cond, <8 x i32> %a, <8 x i32> %b
  ret <8 x i32> %res
}

define <8 x i32> @test_v8f32_une_s(<8 x i32> %a, <8 x i32> %b, <8 x float> %f1, <8 x float> %f2) #0 {
; AVX-32-LABEL: test_v8f32_une_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpneq_usps 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v8f32_une_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpneq_usps %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v8f32_une_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpneq_usps 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v8f32_une_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpneq_usps %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v8f32_une_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpneq_usps 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v8f32_une_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpneq_usps %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <8 x i1> @llvm.experimental.constrained.fcmps.v8f32(
                                               <8 x float> %f1, <8 x float> %f2, metadata !"une",
                                               metadata !"fpexcept.strict") #0
  %res = select <8 x i1> %cond, <8 x i32> %a, <8 x i32> %b
  ret <8 x i32> %res
}

define <8 x i32> @test_v8f32_uno_s(<8 x i32> %a, <8 x i32> %b, <8 x float> %f1, <8 x float> %f2) #0 {
; AVX-32-LABEL: test_v8f32_uno_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpunord_sps 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v8f32_uno_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpunord_sps %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvps %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v8f32_uno_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpunord_sps 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v8f32_uno_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpunord_sps %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmd %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v8f32_uno_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpunord_sps 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v8f32_uno_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpunord_sps %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <8 x i1> @llvm.experimental.constrained.fcmps.v8f32(
                                               <8 x float> %f1, <8 x float> %f2, metadata !"uno",
                                               metadata !"fpexcept.strict") #0
  %res = select <8 x i1> %cond, <8 x i32> %a, <8 x i32> %b
  ret <8 x i32> %res
}

define <4 x i64> @test_v4f64_oeq_s(<4 x i64> %a, <4 x i64> %b, <4 x double> %f1, <4 x double> %f2) #0 {
; AVX-32-LABEL: test_v4f64_oeq_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpeq_ospd 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f64_oeq_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpeq_ospd %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f64_oeq_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpeq_ospd 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f64_oeq_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpeq_ospd %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f64_oeq_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpeq_ospd 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f64_oeq_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpeq_ospd %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmps.v4f64(
                                               <4 x double> %f1, <4 x double> %f2, metadata !"oeq",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i64> %a, <4 x i64> %b
  ret <4 x i64> %res
}

define <4 x i64> @test_v4f64_ogt_s(<4 x i64> %a, <4 x i64> %b, <4 x double> %f1, <4 x double> %f2) #0 {
; AVX-32-LABEL: test_v4f64_ogt_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vmovapd 8(%ebp), %ymm3
; AVX-32-NEXT:    vcmpltpd %ymm2, %ymm3, %ymm2
; AVX-32-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f64_ogt_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpltpd %ymm2, %ymm3, %ymm2
; AVX-64-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f64_ogt_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpgtpd 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f64_ogt_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpltpd %ymm2, %ymm3, %k1
; AVX512-64-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f64_ogt_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vmovapd 8(%ebp), %ymm3
; AVX512F-32-NEXT:    vcmpltpd %ymm2, %ymm3, %ymm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f64_ogt_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpltpd %ymm2, %ymm3, %ymm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmps.v4f64(
                                               <4 x double> %f1, <4 x double> %f2, metadata !"ogt",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i64> %a, <4 x i64> %b
  ret <4 x i64> %res
}

define <4 x i64> @test_v4f64_oge_s(<4 x i64> %a, <4 x i64> %b, <4 x double> %f1, <4 x double> %f2) #0 {
; AVX-32-LABEL: test_v4f64_oge_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vmovapd 8(%ebp), %ymm3
; AVX-32-NEXT:    vcmplepd %ymm2, %ymm3, %ymm2
; AVX-32-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f64_oge_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmplepd %ymm2, %ymm3, %ymm2
; AVX-64-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f64_oge_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpgepd 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f64_oge_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmplepd %ymm2, %ymm3, %k1
; AVX512-64-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f64_oge_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vmovapd 8(%ebp), %ymm3
; AVX512F-32-NEXT:    vcmplepd %ymm2, %ymm3, %ymm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f64_oge_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmplepd %ymm2, %ymm3, %ymm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmps.v4f64(
                                               <4 x double> %f1, <4 x double> %f2, metadata !"oge",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i64> %a, <4 x i64> %b
  ret <4 x i64> %res
}

define <4 x i64> @test_v4f64_olt_s(<4 x i64> %a, <4 x i64> %b, <4 x double> %f1, <4 x double> %f2) #0 {
; AVX-32-LABEL: test_v4f64_olt_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpltpd 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f64_olt_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpltpd %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f64_olt_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpltpd 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f64_olt_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpltpd %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f64_olt_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpltpd 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f64_olt_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpltpd %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmps.v4f64(
                                               <4 x double> %f1, <4 x double> %f2, metadata !"olt",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i64> %a, <4 x i64> %b
  ret <4 x i64> %res
}

define <4 x i64> @test_v4f64_ole_s(<4 x i64> %a, <4 x i64> %b, <4 x double> %f1, <4 x double> %f2) #0 {
; AVX-32-LABEL: test_v4f64_ole_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmplepd 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f64_ole_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmplepd %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f64_ole_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmplepd 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f64_ole_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmplepd %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f64_ole_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmplepd 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f64_ole_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmplepd %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmps.v4f64(
                                               <4 x double> %f1, <4 x double> %f2, metadata !"ole",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i64> %a, <4 x i64> %b
  ret <4 x i64> %res
}

define <4 x i64> @test_v4f64_one_s(<4 x i64> %a, <4 x i64> %b, <4 x double> %f1, <4 x double> %f2) #0 {
; AVX-32-LABEL: test_v4f64_one_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpneq_ospd 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f64_one_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpneq_ospd %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f64_one_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpneq_ospd 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f64_one_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpneq_ospd %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f64_one_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpneq_ospd 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f64_one_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpneq_ospd %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmps.v4f64(
                                               <4 x double> %f1, <4 x double> %f2, metadata !"one",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i64> %a, <4 x i64> %b
  ret <4 x i64> %res
}

define <4 x i64> @test_v4f64_ord_s(<4 x i64> %a, <4 x i64> %b, <4 x double> %f1, <4 x double> %f2) #0 {
; AVX-32-LABEL: test_v4f64_ord_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpord_spd 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f64_ord_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpord_spd %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f64_ord_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpord_spd 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f64_ord_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpord_spd %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f64_ord_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpord_spd 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f64_ord_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpord_spd %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmps.v4f64(
                                               <4 x double> %f1, <4 x double> %f2, metadata !"ord",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i64> %a, <4 x i64> %b
  ret <4 x i64> %res
}

define <4 x i64> @test_v4f64_ueq_s(<4 x i64> %a, <4 x i64> %b, <4 x double> %f1, <4 x double> %f2) #0 {
; AVX-32-LABEL: test_v4f64_ueq_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpeq_uspd 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f64_ueq_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpeq_uspd %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f64_ueq_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpeq_uspd 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f64_ueq_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpeq_uspd %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f64_ueq_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpeq_uspd 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f64_ueq_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpeq_uspd %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmps.v4f64(
                                               <4 x double> %f1, <4 x double> %f2, metadata !"ueq",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i64> %a, <4 x i64> %b
  ret <4 x i64> %res
}

define <4 x i64> @test_v4f64_ugt_s(<4 x i64> %a, <4 x i64> %b, <4 x double> %f1, <4 x double> %f2) #0 {
; AVX-32-LABEL: test_v4f64_ugt_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpnlepd 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f64_ugt_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpnlepd %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f64_ugt_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpnlepd 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f64_ugt_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnlepd %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f64_ugt_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpnlepd 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f64_ugt_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpnlepd %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmps.v4f64(
                                               <4 x double> %f1, <4 x double> %f2, metadata !"ugt",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i64> %a, <4 x i64> %b
  ret <4 x i64> %res
}

define <4 x i64> @test_v4f64_uge_s(<4 x i64> %a, <4 x i64> %b, <4 x double> %f1, <4 x double> %f2) #0 {
; AVX-32-LABEL: test_v4f64_uge_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpnltpd 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f64_uge_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpnltpd %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f64_uge_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpnltpd 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f64_uge_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnltpd %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f64_uge_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpnltpd 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f64_uge_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpnltpd %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmps.v4f64(
                                               <4 x double> %f1, <4 x double> %f2, metadata !"uge",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i64> %a, <4 x i64> %b
  ret <4 x i64> %res
}

define <4 x i64> @test_v4f64_ult_s(<4 x i64> %a, <4 x i64> %b, <4 x double> %f1, <4 x double> %f2) #0 {
; AVX-32-LABEL: test_v4f64_ult_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vmovapd 8(%ebp), %ymm3
; AVX-32-NEXT:    vcmpnlepd %ymm2, %ymm3, %ymm2
; AVX-32-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f64_ult_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpnlepd %ymm2, %ymm3, %ymm2
; AVX-64-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f64_ult_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpngepd 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f64_ult_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnlepd %ymm2, %ymm3, %k1
; AVX512-64-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f64_ult_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vmovapd 8(%ebp), %ymm3
; AVX512F-32-NEXT:    vcmpnlepd %ymm2, %ymm3, %ymm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f64_ult_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpnlepd %ymm2, %ymm3, %ymm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmps.v4f64(
                                               <4 x double> %f1, <4 x double> %f2, metadata !"ult",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i64> %a, <4 x i64> %b
  ret <4 x i64> %res
}

define <4 x i64> @test_v4f64_ule_s(<4 x i64> %a, <4 x i64> %b, <4 x double> %f1, <4 x double> %f2) #0 {
; AVX-32-LABEL: test_v4f64_ule_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vmovapd 8(%ebp), %ymm3
; AVX-32-NEXT:    vcmpnltpd %ymm2, %ymm3, %ymm2
; AVX-32-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f64_ule_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpnltpd %ymm2, %ymm3, %ymm2
; AVX-64-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f64_ule_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpngtpd 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f64_ule_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnltpd %ymm2, %ymm3, %k1
; AVX512-64-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f64_ule_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vmovapd 8(%ebp), %ymm3
; AVX512F-32-NEXT:    vcmpnltpd %ymm2, %ymm3, %ymm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f64_ule_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpnltpd %ymm2, %ymm3, %ymm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmps.v4f64(
                                               <4 x double> %f1, <4 x double> %f2, metadata !"ule",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i64> %a, <4 x i64> %b
  ret <4 x i64> %res
}

define <4 x i64> @test_v4f64_une_s(<4 x i64> %a, <4 x i64> %b, <4 x double> %f1, <4 x double> %f2) #0 {
; AVX-32-LABEL: test_v4f64_une_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpneq_uspd 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f64_une_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpneq_uspd %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f64_une_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpneq_uspd 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f64_une_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpneq_uspd %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f64_une_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpneq_uspd 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f64_une_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpneq_uspd %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmps.v4f64(
                                               <4 x double> %f1, <4 x double> %f2, metadata !"une",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i64> %a, <4 x i64> %b
  ret <4 x i64> %res
}

define <4 x i64> @test_v4f64_uno_s(<4 x i64> %a, <4 x i64> %b, <4 x double> %f1, <4 x double> %f2) #0 {
; AVX-32-LABEL: test_v4f64_uno_s:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    andl $-32, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vcmpunord_spd 8(%ebp), %ymm2, %ymm2
; AVX-32-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_v4f64_uno_s:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vcmpunord_spd %ymm3, %ymm2, %ymm2
; AVX-64-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512-32-LABEL: test_v4f64_uno_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpunord_spd 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v4f64_uno_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpunord_spd %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmq %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
;
; AVX512F-32-LABEL: test_v4f64_uno_s:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    andl $-32, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-32-NEXT:    vcmpunord_spd 8(%ebp), %ymm2, %ymm2
; AVX512F-32-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-32-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-32-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: test_v4f64_uno_s:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-64-NEXT:    vcmpunord_spd %ymm3, %ymm2, %ymm2
; AVX512F-64-NEXT:    vptestmq %zmm2, %zmm2, %k1
; AVX512F-64-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-64-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-64-NEXT:    retq
  %cond = call <4 x i1> @llvm.experimental.constrained.fcmps.v4f64(
                                               <4 x double> %f1, <4 x double> %f2, metadata !"uno",
                                               metadata !"fpexcept.strict") #0
  %res = select <4 x i1> %cond, <4 x i64> %a, <4 x i64> %b
  ret <4 x i64> %res
}

attributes #0 = { strictfp nounwind }

declare <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float>, <8 x float>, metadata, metadata)
declare <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double>, <4 x double>, metadata, metadata)
declare <8 x i1> @llvm.experimental.constrained.fcmps.v8f32(<8 x float>, <8 x float>, metadata, metadata)
declare <4 x i1> @llvm.experimental.constrained.fcmps.v4f64(<4 x double>, <4 x double>, metadata, metadata)
