; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-- | FileCheck %s --check-prefixes=CHECK,X86
; RUN: llc < %s -mtriple=x86_64-- | FileCheck %s --check-prefixes=CHECK,X64

define i32 @fold_add_freeze_i32() {
; CHECK-LABEL: fold_add_freeze_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movl $-1, %eax
; CHECK-NEXT:    ret{{[l|q]}}
  %1 = add i32 0, 0
  %2 = freeze i32 %1
  %3 = add i32 0, -1
  %4 = freeze i32 %3
  %5 = add i32 %2, %4
  ret i32 %5
}

define <4 x i32> @fold_add_freeze_v4i32() {
; X86-LABEL: fold_add_freeze_v4i32:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl $-1, 12(%eax)
; X86-NEXT:    movl $-1, 8(%eax)
; X86-NEXT:    movl $-1, 4(%eax)
; X86-NEXT:    movl $-1, (%eax)
; X86-NEXT:    retl $4
;
; X64-LABEL: fold_add_freeze_v4i32:
; X64:       # %bb.0:
; X64-NEXT:    pcmpeqd %xmm0, %xmm0
; X64-NEXT:    retq
  %1 = insertelement <4 x i32> poison, i32 0, i32 0
  %2 = shufflevector <4 x i32> %1, <4 x i32> poison, <4 x i32> zeroinitializer
  %3 = freeze <4 x i32> %2
  %4 = insertelement <4 x i32> poison, i32 -1, i32 0
  %5 = shufflevector <4 x i32> %4, <4 x i32> poison, <4 x i32> zeroinitializer
  %6 = freeze <4 x i32> %5
  %7 = add <4 x i32> %3, %6
  ret <4 x i32> %7
}
