; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; Test 256-bit addition on z13 and higher
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z13 | FileCheck %s

define zeroext i1 @f1(i256 %a, i256 %b, ptr %res) {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v2, 16(%r3), 3
; CHECK-NEXT:    vl %v3, 16(%r2), 3
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vl %v1, 0(%r2), 3
; CHECK-NEXT:    vaccq %v4, %v3, %v2
; CHECK-NEXT:    vacccq %v5, %v1, %v0, %v4
; CHECK-NEXT:    vlgvg %r2, %v5, 1
; CHECK-NEXT:    vacq %v0, %v1, %v0, %v4
; CHECK-NEXT:    vaq %v1, %v3, %v2
; CHECK-NEXT:    vst %v1, 16(%r4), 3
; CHECK-NEXT:    vst %v0, 0(%r4), 3
; CHECK-NEXT:    br %r14
  %t = call {i256, i1} @llvm.uadd.with.overflow.i256(i256 %a, i256 %b)
  %val = extractvalue {i256, i1} %t, 0
  %obit = extractvalue {i256, i1} %t, 1
  store i256 %val, ptr %res
  ret i1 %obit
}

define zeroext i1 @f2(i256 %a, i256 %b) {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v2, 16(%r3), 3
; CHECK-NEXT:    vl %v3, 16(%r2), 3
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vl %v1, 0(%r2), 3
; CHECK-NEXT:    vaccq %v2, %v3, %v2
; CHECK-NEXT:    vacccq %v0, %v1, %v0, %v2
; CHECK-NEXT:    vlgvg %r2, %v0, 1
; CHECK-NEXT:    br %r14
  %t = call {i256, i1} @llvm.uadd.with.overflow.i256(i256 %a, i256 %b)
  %obit = extractvalue {i256, i1} %t, 1
  ret i1 %obit
}

define i256 @f3(i256 %a, i256 %b) {
; CHECK-LABEL: f3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v2, 16(%r4), 3
; CHECK-NEXT:    vl %v3, 16(%r3), 3
; CHECK-NEXT:    vl %v0, 0(%r4), 3
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    vaccq %v4, %v3, %v2
; CHECK-NEXT:    vacq %v0, %v1, %v0, %v4
; CHECK-NEXT:    vaq %v1, %v3, %v2
; CHECK-NEXT:    vst %v1, 16(%r2), 3
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %t = call {i256, i1} @llvm.uadd.with.overflow.i256(i256 %a, i256 %b)
  %val = extractvalue {i256, i1} %t, 0
  ret i256 %val
}

declare {i256, i1} @llvm.uadd.with.overflow.i256(i256, i256) nounwind readnone

