; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc < %s -mtriple=riscv32 -mattr=+v,+zvfh -verify-machineinstrs | FileCheck %s -check-prefixes=CHECK,RV32
; RUN: llc < %s -mtriple=riscv64 -mattr=+v,+zvfh -verify-machineinstrs | FileCheck %s -check-prefixes=CHECK,RV64

define i8 @extract_last_i8(<16 x i8> %data, <16 x i8> %mask, i8 %passthru) {
; CHECK-LABEL: extract_last_i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, mu
; CHECK-NEXT:    vmsne.vi v0, v9, 0
; CHECK-NEXT:    vmv.v.i v9, 0
; CHECK-NEXT:    vcpop.m a1, v0
; CHECK-NEXT:    vid.v v9, v0.t
; CHECK-NEXT:    beqz a1, .LBB0_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    vredmaxu.vs v9, v9, v9
; CHECK-NEXT:    vmv.x.s a0, v9
; CHECK-NEXT:    andi a0, a0, 255
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:  .LBB0_2:
; CHECK-NEXT:    ret
  %notzero = icmp ne <16 x i8> %mask, zeroinitializer
  %res = call i8 @llvm.experimental.vector.extract.last.active.v16i8(<16 x i8> %data, <16 x i1> %notzero, i8 %passthru)
  ret i8 %res
}

define i16 @extract_last_i16(<8 x i16> %data, <8 x i16> %mask, i16 %passthru) {
; CHECK-LABEL: extract_last_i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vmsne.vi v0, v9, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf2, ta, mu
; CHECK-NEXT:    vmv.v.i v9, 0
; CHECK-NEXT:    vcpop.m a1, v0
; CHECK-NEXT:    vid.v v9, v0.t
; CHECK-NEXT:    beqz a1, .LBB1_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    vredmaxu.vs v9, v9, v9
; CHECK-NEXT:    vmv.x.s a0, v9
; CHECK-NEXT:    andi a0, a0, 255
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:  .LBB1_2:
; CHECK-NEXT:    ret
  %notzero = icmp ne <8 x i16> %mask, zeroinitializer
  %res = call i16 @llvm.experimental.vector.extract.last.active.v8i16(<8 x i16> %data, <8 x i1> %notzero, i16 %passthru)
  ret i16 %res
}

define i32 @extract_last_i32(<4 x i32> %data, <4 x i32> %mask, i32 %passthru) {
; CHECK-LABEL: extract_last_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vmsne.vi v0, v9, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, ta, mu
; CHECK-NEXT:    vmv.v.i v9, 0
; CHECK-NEXT:    vcpop.m a1, v0
; CHECK-NEXT:    vid.v v9, v0.t
; CHECK-NEXT:    beqz a1, .LBB2_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    vredmaxu.vs v9, v9, v9
; CHECK-NEXT:    vmv.x.s a0, v9
; CHECK-NEXT:    andi a0, a0, 255
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:  .LBB2_2:
; CHECK-NEXT:    ret
  %notzero = icmp ne <4 x i32> %mask, zeroinitializer
  %res = call i32 @llvm.experimental.vector.extract.last.active.v4i32(<4 x i32> %data, <4 x i1> %notzero, i32 %passthru)
  ret i32 %res
}

define i64 @extract_last_i64(<2 x i64> %data, <2 x i64> %mask, i64 %passthru) {
; RV32-LABEL: extract_last_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; RV32-NEXT:    vmsne.vi v0, v9, 0
; RV32-NEXT:    vsetvli zero, zero, e8, mf8, ta, mu
; RV32-NEXT:    vmv.v.i v9, 0
; RV32-NEXT:    vcpop.m a2, v0
; RV32-NEXT:    vid.v v9, v0.t
; RV32-NEXT:    beqz a2, .LBB3_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    vredmaxu.vs v9, v9, v9
; RV32-NEXT:    li a1, 32
; RV32-NEXT:    vmv.x.s a0, v9
; RV32-NEXT:    andi a0, a0, 255
; RV32-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; RV32-NEXT:    vslidedown.vx v8, v8, a0
; RV32-NEXT:    vmv.x.s a0, v8
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vsrl.vx v8, v8, a1
; RV32-NEXT:    vmv.x.s a1, v8
; RV32-NEXT:  .LBB3_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: extract_last_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; RV64-NEXT:    vmsne.vi v0, v9, 0
; RV64-NEXT:    vsetvli zero, zero, e8, mf8, ta, mu
; RV64-NEXT:    vmv.v.i v9, 0
; RV64-NEXT:    vcpop.m a1, v0
; RV64-NEXT:    vid.v v9, v0.t
; RV64-NEXT:    beqz a1, .LBB3_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    vredmaxu.vs v9, v9, v9
; RV64-NEXT:    vmv.x.s a0, v9
; RV64-NEXT:    andi a0, a0, 255
; RV64-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; RV64-NEXT:    vslidedown.vx v8, v8, a0
; RV64-NEXT:    vmv.x.s a0, v8
; RV64-NEXT:  .LBB3_2:
; RV64-NEXT:    ret
  %notzero = icmp ne <2 x i64> %mask, zeroinitializer
  %res = call i64 @llvm.experimental.vector.extract.last.active.v2i64(<2 x i64> %data, <2 x i1> %notzero, i64 %passthru)
  ret i64 %res
}

define float @extract_last_float(<4 x float> %data, <4 x i32> %mask, float %passthru) {
; CHECK-LABEL: extract_last_float:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vmsne.vi v0, v9, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, ta, mu
; CHECK-NEXT:    vmv.v.i v9, 0
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    vid.v v9, v0.t
; CHECK-NEXT:    beqz a0, .LBB4_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    vredmaxu.vs v9, v9, v9
; CHECK-NEXT:    vmv.x.s a0, v9
; CHECK-NEXT:    andi a0, a0, 255
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:  .LBB4_2:
; CHECK-NEXT:    ret
  %notzero = icmp ne <4 x i32> %mask, zeroinitializer
  %res = call float @llvm.experimental.vector.extract.last.active.v4f32(<4 x float> %data, <4 x i1> %notzero, float %passthru)
  ret float %res
}

define double @extract_last_double(<2 x double> %data, <2 x i64> %mask, double %passthru) {
; CHECK-LABEL: extract_last_double:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vmsne.vi v0, v9, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, mu
; CHECK-NEXT:    vmv.v.i v9, 0
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    vid.v v9, v0.t
; CHECK-NEXT:    beqz a0, .LBB5_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    vredmaxu.vs v9, v9, v9
; CHECK-NEXT:    vmv.x.s a0, v9
; CHECK-NEXT:    andi a0, a0, 255
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:  .LBB5_2:
; CHECK-NEXT:    ret
  %notzero = icmp ne <2 x i64> %mask, zeroinitializer
  %res = call double @llvm.experimental.vector.extract.last.active.v2f64(<2 x double> %data, <2 x i1> %notzero, double %passthru)
  ret double %res
}

define i8 @extract_last_i8_scalable(<vscale x 16 x i8> %data, <vscale x 16 x i1> %mask, i8 %passthru) {
; CHECK-LABEL: extract_last_i8_scalable:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m2, ta, mu
; CHECK-NEXT:    vmv.v.i v10, 0
; CHECK-NEXT:    vcpop.m a1, v0
; CHECK-NEXT:    vid.v v10, v0.t
; CHECK-NEXT:    beqz a1, .LBB6_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    vredmaxu.vs v10, v10, v10
; CHECK-NEXT:    vmv.x.s a0, v10
; CHECK-NEXT:    andi a0, a0, 255
; CHECK-NEXT:    vsetvli zero, zero, e8, m2, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:  .LBB6_2:
; CHECK-NEXT:    ret
  %res = call i8 @llvm.experimental.vector.extract.last.active.nxv16i8(<vscale x 16 x i8> %data, <vscale x 16 x i1> %mask, i8 %passthru)
  ret i8 %res
}

define i16 @extract_last_i16_scalable(<vscale x 8 x i16> %data, <vscale x 8 x i1> %mask, i16 %passthru) {
; CHECK-LABEL: extract_last_i16_scalable:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v10, 0
; CHECK-NEXT:    vcpop.m a1, v0
; CHECK-NEXT:    vid.v v10, v0.t
; CHECK-NEXT:    beqz a1, .LBB7_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    vredmaxu.vs v10, v10, v10
; CHECK-NEXT:    vmv.x.s a0, v10
; CHECK-NEXT:    andi a0, a0, 255
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:  .LBB7_2:
; CHECK-NEXT:    ret
  %res = call i16 @llvm.experimental.vector.extract.last.active.nxv8i16(<vscale x 8 x i16> %data, <vscale x 8 x i1> %mask, i16 %passthru)
  ret i16 %res
}

define i32 @extract_last_i32_scalable(<vscale x 4 x i32> %data, <vscale x 4 x i1> %mask, i32 %passthru) {
; CHECK-LABEL: extract_last_i32_scalable:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf2, ta, mu
; CHECK-NEXT:    vmv.v.i v10, 0
; CHECK-NEXT:    vcpop.m a1, v0
; CHECK-NEXT:    vid.v v10, v0.t
; CHECK-NEXT:    beqz a1, .LBB8_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    vredmaxu.vs v10, v10, v10
; CHECK-NEXT:    vmv.x.s a0, v10
; CHECK-NEXT:    andi a0, a0, 255
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vmv.x.s a0, v8
; CHECK-NEXT:  .LBB8_2:
; CHECK-NEXT:    ret
  %res = call i32 @llvm.experimental.vector.extract.last.active.nxv4i32(<vscale x 4 x i32> %data, <vscale x 4 x i1> %mask, i32 %passthru)
  ret i32 %res
}

define i64 @extract_last_i64_scalable(<vscale x 2 x i64> %data, <vscale x 2 x i1> %mask, i64 %passthru) {
; RV32-LABEL: extract_last_i64_scalable:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e8, mf4, ta, mu
; RV32-NEXT:    vmv.v.i v10, 0
; RV32-NEXT:    vcpop.m a2, v0
; RV32-NEXT:    vid.v v10, v0.t
; RV32-NEXT:    beqz a2, .LBB9_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    vredmaxu.vs v10, v10, v10
; RV32-NEXT:    li a1, 32
; RV32-NEXT:    vmv.x.s a0, v10
; RV32-NEXT:    andi a0, a0, 255
; RV32-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; RV32-NEXT:    vslidedown.vx v8, v8, a0
; RV32-NEXT:    vmv.x.s a0, v8
; RV32-NEXT:    vsetivli zero, 1, e64, m2, ta, ma
; RV32-NEXT:    vsrl.vx v8, v8, a1
; RV32-NEXT:    vmv.x.s a1, v8
; RV32-NEXT:  .LBB9_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: extract_last_i64_scalable:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a1, zero, e8, mf4, ta, mu
; RV64-NEXT:    vmv.v.i v10, 0
; RV64-NEXT:    vcpop.m a1, v0
; RV64-NEXT:    vid.v v10, v0.t
; RV64-NEXT:    beqz a1, .LBB9_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    vredmaxu.vs v10, v10, v10
; RV64-NEXT:    vmv.x.s a0, v10
; RV64-NEXT:    andi a0, a0, 255
; RV64-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; RV64-NEXT:    vslidedown.vx v8, v8, a0
; RV64-NEXT:    vmv.x.s a0, v8
; RV64-NEXT:  .LBB9_2:
; RV64-NEXT:    ret
  %res = call i64 @llvm.experimental.vector.extract.last.active.nxv2i64(<vscale x 2 x i64> %data, <vscale x 2 x i1> %mask, i64 %passthru)
  ret i64 %res
}

define float @extract_last_float_scalable(<vscale x 4 x float> %data, <vscale x 4 x i1> %mask, float %passthru) {
; CHECK-LABEL: extract_last_float_scalable:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, mu
; CHECK-NEXT:    vmv.v.i v10, 0
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    vid.v v10, v0.t
; CHECK-NEXT:    beqz a0, .LBB10_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    vredmaxu.vs v10, v10, v10
; CHECK-NEXT:    vmv.x.s a0, v10
; CHECK-NEXT:    andi a0, a0, 255
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:  .LBB10_2:
; CHECK-NEXT:    ret
  %res = call float @llvm.experimental.vector.extract.last.active.nxv4f32(<vscale x 4 x float> %data, <vscale x 4 x i1> %mask, float %passthru)
  ret float %res
}

define double @extract_last_double_scalable(<vscale x 2 x double> %data, <vscale x 2 x i1> %mask, double %passthru) {
; CHECK-LABEL: extract_last_double_scalable:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, mu
; CHECK-NEXT:    vmv.v.i v10, 0
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    vid.v v10, v0.t
; CHECK-NEXT:    beqz a0, .LBB11_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    vredmaxu.vs v10, v10, v10
; CHECK-NEXT:    vmv.x.s a0, v10
; CHECK-NEXT:    andi a0, a0, 255
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:  .LBB11_2:
; CHECK-NEXT:    ret
  %res = call double @llvm.experimental.vector.extract.last.active.nxv2f64(<vscale x 2 x double> %data, <vscale x 2 x i1> %mask, double %passthru)
  ret double %res
}

declare i8 @llvm.experimental.vector.extract.last.active.v16i8(<16 x i8>, <16 x i1>, i8)
declare i16 @llvm.experimental.vector.extract.last.active.v8i16(<8 x i16>, <8 x i1>, i16)
declare i32 @llvm.experimental.vector.extract.last.active.v4i32(<4 x i32>, <4 x i1>, i32)
declare i64 @llvm.experimental.vector.extract.last.active.v2i64(<2 x i64>, <2 x i1>, i64)
declare float @llvm.experimental.vector.extract.last.active.v4f32(<4 x float>, <4 x i1>, float)
declare double @llvm.experimental.vector.extract.last.active.v2f64(<2 x double>, <2 x i1>, double)
declare i8 @llvm.experimental.vector.extract.last.active.nxv16i8(<vscale x 16 x i8>, <vscale x 16 x i1>, i8)
declare i16 @llvm.experimental.vector.extract.last.active.nxv8i16(<vscale x 8 x i16>, <vscale x 8 x i1>, i16)
declare i32 @llvm.experimental.vector.extract.last.active.nxv4i32(<vscale x 4 x i32>, <vscale x 4 x i1>, i32)
declare i64 @llvm.experimental.vector.extract.last.active.nxv2i64(<vscale x 2 x i64>, <vscale x 2 x i1>, i64)
declare float @llvm.experimental.vector.extract.last.active.nxv4f32(<vscale x 4 x float>, <vscale x 4 x i1>, float)
declare double @llvm.experimental.vector.extract.last.active.nxv2f64(<vscale x 2 x double>, <vscale x 2 x i1>, double)
