; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+v -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefixes=CHECK
; RUN: llc -mtriple=riscv64 -mattr=+v -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefixes=CHECK


declare <2 x i1> @llvm.vp.icmp.v2i1(<2 x i1>, <2 x i1>, metadata, <2 x i1>, i32)

define <2 x i1> @icmp_eq_vv_v2i1(<2 x i1> %va, <2 x i1> %vb, <2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vv_v2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <2 x i1> @llvm.vp.icmp.v2i1(<2 x i1> %va, <2 x i1> %vb, metadata !"eq", <2 x i1> %m, i32 %evl)
  ret <2 x i1> %v
}

declare <4 x i1> @llvm.vp.icmp.v4i1(<4 x i1>, <4 x i1>, metadata, <4 x i1>, i32)

define <4 x i1> @icmp_eq_vv_v4i1(<4 x i1> %va, <4 x i1> %vb, <4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vv_v4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <4 x i1> @llvm.vp.icmp.v4i1(<4 x i1> %va, <4 x i1> %vb, metadata !"eq", <4 x i1> %m, i32 %evl)
  ret <4 x i1> %v
}

declare <8 x i1> @llvm.vp.icmp.v8i1(<8 x i1>, <8 x i1>, metadata, <8 x i1>, i32)

define <8 x i1> @icmp_eq_vv_v8i1(<8 x i1> %va, <8 x i1> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vv_v8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.icmp.v8i1(<8 x i1> %va, <8 x i1> %vb, metadata !"eq", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

declare <16 x i1> @llvm.vp.icmp.v16i1(<16 x i1>, <16 x i1>, metadata, <16 x i1>, i32)

define <16 x i1> @icmp_eq_vv_v16i1(<16 x i1> %va, <16 x i1> %vb, <16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vv_v16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <16 x i1> @llvm.vp.icmp.v16i1(<16 x i1> %va, <16 x i1> %vb, metadata !"eq", <16 x i1> %m, i32 %evl)
  ret <16 x i1> %v
}

define <2 x i1> @icmp_ne_vv_v2i1(<2 x i1> %va, <2 x i1> %vb, <2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vv_v2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmxor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <2 x i1> @llvm.vp.icmp.v2i1(<2 x i1> %va, <2 x i1> %vb, metadata !"ne", <2 x i1> %m, i32 %evl)
  ret <2 x i1> %v
}

define <4 x i1> @icmp_ne_vv_v4i1(<4 x i1> %va, <4 x i1> %vb, <4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vv_v4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    vmxor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <4 x i1> @llvm.vp.icmp.v4i1(<4 x i1> %va, <4 x i1> %vb, metadata !"ne", <4 x i1> %m, i32 %evl)
  ret <4 x i1> %v
}

define <8 x i1> @icmp_ne_vv_v8i1(<8 x i1> %va, <8 x i1> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vv_v8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    vmxor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.icmp.v8i1(<8 x i1> %va, <8 x i1> %vb, metadata !"ne", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <16 x i1> @icmp_ne_vv_v16i1(<16 x i1> %va, <16 x i1> %vb, <16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vv_v16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmxor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <16 x i1> @llvm.vp.icmp.v16i1(<16 x i1> %va, <16 x i1> %vb, metadata !"ne", <16 x i1> %m, i32 %evl)
  ret <16 x i1> %v
}

define <2 x i1> @icmp_slt_vv_v2i1(<2 x i1> %va, <2 x i1> %vb, <2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vv_v2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <2 x i1> @llvm.vp.icmp.v2i1(<2 x i1> %va, <2 x i1> %vb, metadata !"slt", <2 x i1> %m, i32 %evl)
  ret <2 x i1> %v
}

define <4 x i1> @icmp_slt_vv_v4i1(<4 x i1> %va, <4 x i1> %vb, <4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vv_v4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <4 x i1> @llvm.vp.icmp.v4i1(<4 x i1> %va, <4 x i1> %vb, metadata !"slt", <4 x i1> %m, i32 %evl)
  ret <4 x i1> %v
}

define <8 x i1> @icmp_slt_vv_v8i1(<8 x i1> %va, <8 x i1> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vv_v8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.icmp.v8i1(<8 x i1> %va, <8 x i1> %vb, metadata !"slt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <16 x i1> @icmp_slt_vv_v16i1(<16 x i1> %va, <16 x i1> %vb, <16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vv_v16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <16 x i1> @llvm.vp.icmp.v16i1(<16 x i1> %va, <16 x i1> %vb, metadata !"slt", <16 x i1> %m, i32 %evl)
  ret <16 x i1> %v
}

define <2 x i1> @icmp_ult_vv_v2i1(<2 x i1> %va, <2 x i1> %vb, <2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vv_v2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <2 x i1> @llvm.vp.icmp.v2i1(<2 x i1> %va, <2 x i1> %vb, metadata !"ult", <2 x i1> %m, i32 %evl)
  ret <2 x i1> %v
}

define <4 x i1> @icmp_ult_vv_v4i1(<4 x i1> %va, <4 x i1> %vb, <4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vv_v4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <4 x i1> @llvm.vp.icmp.v4i1(<4 x i1> %va, <4 x i1> %vb, metadata !"ult", <4 x i1> %m, i32 %evl)
  ret <4 x i1> %v
}

define <8 x i1> @icmp_ult_vv_v8i1(<8 x i1> %va, <8 x i1> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vv_v8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.icmp.v8i1(<8 x i1> %va, <8 x i1> %vb, metadata !"ult", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <16 x i1> @icmp_ult_vv_v16i1(<16 x i1> %va, <16 x i1> %vb, <16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vv_v16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <16 x i1> @llvm.vp.icmp.v16i1(<16 x i1> %va, <16 x i1> %vb, metadata !"ult", <16 x i1> %m, i32 %evl)
  ret <16 x i1> %v
}

define <2 x i1> @icmp_sgt_vv_v2i1(<2 x i1> %va, <2 x i1> %vb, <2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vv_v2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <2 x i1> @llvm.vp.icmp.v2i1(<2 x i1> %va, <2 x i1> %vb, metadata !"sgt", <2 x i1> %m, i32 %evl)
  ret <2 x i1> %v
}

define <4 x i1> @icmp_sgt_vv_v4i1(<4 x i1> %va, <4 x i1> %vb, <4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vv_v4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <4 x i1> @llvm.vp.icmp.v4i1(<4 x i1> %va, <4 x i1> %vb, metadata !"sgt", <4 x i1> %m, i32 %evl)
  ret <4 x i1> %v
}

define <8 x i1> @icmp_sgt_vv_v8i1(<8 x i1> %va, <8 x i1> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vv_v8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.icmp.v8i1(<8 x i1> %va, <8 x i1> %vb, metadata !"sgt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <16 x i1> @icmp_sgt_vv_v16i1(<16 x i1> %va, <16 x i1> %vb, <16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vv_v16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <16 x i1> @llvm.vp.icmp.v16i1(<16 x i1> %va, <16 x i1> %vb, metadata !"sgt", <16 x i1> %m, i32 %evl)
  ret <16 x i1> %v
}

define <2 x i1> @icmp_ugt_vv_v2i1(<2 x i1> %va, <2 x i1> %vb, <2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vv_v2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <2 x i1> @llvm.vp.icmp.v2i1(<2 x i1> %va, <2 x i1> %vb, metadata !"ugt", <2 x i1> %m, i32 %evl)
  ret <2 x i1> %v
}

define <4 x i1> @icmp_ugt_vv_v4i1(<4 x i1> %va, <4 x i1> %vb, <4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vv_v4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <4 x i1> @llvm.vp.icmp.v4i1(<4 x i1> %va, <4 x i1> %vb, metadata !"ugt", <4 x i1> %m, i32 %evl)
  ret <4 x i1> %v
}

define <8 x i1> @icmp_ugt_vv_v8i1(<8 x i1> %va, <8 x i1> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vv_v8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.icmp.v8i1(<8 x i1> %va, <8 x i1> %vb, metadata !"ugt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <16 x i1> @icmp_ugt_vv_v16i1(<16 x i1> %va, <16 x i1> %vb, <16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vv_v16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <16 x i1> @llvm.vp.icmp.v16i1(<16 x i1> %va, <16 x i1> %vb, metadata !"ugt", <16 x i1> %m, i32 %evl)
  ret <16 x i1> %v
}

define <2 x i1> @icmp_sle_vv_v2i1(<2 x i1> %va, <2 x i1> %vb, <2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vv_v2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <2 x i1> @llvm.vp.icmp.v2i1(<2 x i1> %va, <2 x i1> %vb, metadata !"sle", <2 x i1> %m, i32 %evl)
  ret <2 x i1> %v
}

define <4 x i1> @icmp_sle_vv_v4i1(<4 x i1> %va, <4 x i1> %vb, <4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vv_v4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <4 x i1> @llvm.vp.icmp.v4i1(<4 x i1> %va, <4 x i1> %vb, metadata !"sle", <4 x i1> %m, i32 %evl)
  ret <4 x i1> %v
}

define <8 x i1> @icmp_sle_vv_v8i1(<8 x i1> %va, <8 x i1> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vv_v8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.icmp.v8i1(<8 x i1> %va, <8 x i1> %vb, metadata !"sle", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <16 x i1> @icmp_sle_vv_v16i1(<16 x i1> %va, <16 x i1> %vb, <16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vv_v16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <16 x i1> @llvm.vp.icmp.v16i1(<16 x i1> %va, <16 x i1> %vb, metadata !"sle", <16 x i1> %m, i32 %evl)
  ret <16 x i1> %v
}

define <2 x i1> @icmp_ule_vv_v2i1(<2 x i1> %va, <2 x i1> %vb, <2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ule_vv_v2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <2 x i1> @llvm.vp.icmp.v2i1(<2 x i1> %va, <2 x i1> %vb, metadata !"ule", <2 x i1> %m, i32 %evl)
  ret <2 x i1> %v
}

define <4 x i1> @icmp_ule_vv_v4i1(<4 x i1> %va, <4 x i1> %vb, <4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ule_vv_v4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <4 x i1> @llvm.vp.icmp.v4i1(<4 x i1> %va, <4 x i1> %vb, metadata !"ule", <4 x i1> %m, i32 %evl)
  ret <4 x i1> %v
}

define <8 x i1> @icmp_ule_vv_v8i1(<8 x i1> %va, <8 x i1> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ule_vv_v8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.icmp.v8i1(<8 x i1> %va, <8 x i1> %vb, metadata !"ule", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <16 x i1> @icmp_ule_vv_v16i1(<16 x i1> %va, <16 x i1> %vb, <16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ule_vv_v16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <16 x i1> @llvm.vp.icmp.v16i1(<16 x i1> %va, <16 x i1> %vb, metadata !"ule", <16 x i1> %m, i32 %evl)
  ret <16 x i1> %v
}

define <2 x i1> @icmp_sge_vv_v2i1(<2 x i1> %va, <2 x i1> %vb, <2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vv_v2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <2 x i1> @llvm.vp.icmp.v2i1(<2 x i1> %va, <2 x i1> %vb, metadata !"sge", <2 x i1> %m, i32 %evl)
  ret <2 x i1> %v
}

define <4 x i1> @icmp_sge_vv_v4i1(<4 x i1> %va, <4 x i1> %vb, <4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vv_v4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <4 x i1> @llvm.vp.icmp.v4i1(<4 x i1> %va, <4 x i1> %vb, metadata !"sge", <4 x i1> %m, i32 %evl)
  ret <4 x i1> %v
}

define <8 x i1> @icmp_sge_vv_v8i1(<8 x i1> %va, <8 x i1> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vv_v8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.icmp.v8i1(<8 x i1> %va, <8 x i1> %vb, metadata !"sge", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <16 x i1> @icmp_sge_vv_v16i1(<16 x i1> %va, <16 x i1> %vb, <16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vv_v16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <16 x i1> @llvm.vp.icmp.v16i1(<16 x i1> %va, <16 x i1> %vb, metadata !"sge", <16 x i1> %m, i32 %evl)
  ret <16 x i1> %v
}

define <2 x i1> @icmp_uge_vv_v2i1(<2 x i1> %va, <2 x i1> %vb, <2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vv_v2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <2 x i1> @llvm.vp.icmp.v2i1(<2 x i1> %va, <2 x i1> %vb, metadata !"uge", <2 x i1> %m, i32 %evl)
  ret <2 x i1> %v
}

define <4 x i1> @icmp_uge_vv_v4i1(<4 x i1> %va, <4 x i1> %vb, <4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vv_v4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <4 x i1> @llvm.vp.icmp.v4i1(<4 x i1> %va, <4 x i1> %vb, metadata !"uge", <4 x i1> %m, i32 %evl)
  ret <4 x i1> %v
}

define <8 x i1> @icmp_uge_vv_v8i1(<8 x i1> %va, <8 x i1> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vv_v8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.icmp.v8i1(<8 x i1> %va, <8 x i1> %vb, metadata !"uge", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <16 x i1> @icmp_uge_vv_v16i1(<16 x i1> %va, <16 x i1> %vb, <16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vv_v16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <16 x i1> @llvm.vp.icmp.v16i1(<16 x i1> %va, <16 x i1> %vb, metadata !"uge", <16 x i1> %m, i32 %evl)
  ret <16 x i1> %v
}
