; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=nvptx64 -mcpu=sm_80 | FileCheck %s
; RUN: %if ptxas %{ llc < %s -mtriple=nvptx64 -mcpu=sm_80 | %ptxas-verify -arch=sm_80 %}

; Using FTZ should emit fma.ftz.relu for f16, not for bf16
; RUN: llc < %s -denormal-fp-math-f32=preserve-sign -mtriple=nvptx64 -mcpu=sm_80 | FileCheck %s --check-prefixes=CHECK-FTZ
; RUN: %if ptxas %{ llc < %s -denormal-fp-math-f32=preserve-sign -mtriple=nvptx64 -mcpu=sm_80 | %ptxas-verify -arch=sm_80 %}

; SM < 80 or (which needs PTX version >= 70) should not emit fma{.ftz}.relu
; RUN: llc < %s -mtriple=nvptx64 -mcpu=sm_70 | FileCheck %s --check-prefixes=CHECK-SM70

define half @fma_f16_no_nans(half %a, half %b, half %c) #0 {
; CHECK-LABEL: fma_f16_no_nans(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b16 %rs1, [fma_f16_no_nans_param_0];
; CHECK-NEXT:    ld.param.b16 %rs2, [fma_f16_no_nans_param_1];
; CHECK-NEXT:    ld.param.b16 %rs3, [fma_f16_no_nans_param_2];
; CHECK-NEXT:    fma.rn.relu.f16 %rs4, %rs1, %rs2, %rs3;
; CHECK-NEXT:    st.param.b16 [func_retval0], %rs4;
; CHECK-NEXT:    ret;
;
; CHECK-FTZ-LABEL: fma_f16_no_nans(
; CHECK-FTZ:       {
; CHECK-FTZ-NEXT:    .reg .b16 %rs<5>;
; CHECK-FTZ-EMPTY:
; CHECK-FTZ-NEXT:  // %bb.0:
; CHECK-FTZ-NEXT:    ld.param.b16 %rs1, [fma_f16_no_nans_param_0];
; CHECK-FTZ-NEXT:    ld.param.b16 %rs2, [fma_f16_no_nans_param_1];
; CHECK-FTZ-NEXT:    ld.param.b16 %rs3, [fma_f16_no_nans_param_2];
; CHECK-FTZ-NEXT:    fma.rn.ftz.relu.f16 %rs4, %rs1, %rs2, %rs3;
; CHECK-FTZ-NEXT:    st.param.b16 [func_retval0], %rs4;
; CHECK-FTZ-NEXT:    ret;
;
; CHECK-SM70-LABEL: fma_f16_no_nans(
; CHECK-SM70:       {
; CHECK-SM70-NEXT:    .reg .pred %p<2>;
; CHECK-SM70-NEXT:    .reg .b16 %rs<7>;
; CHECK-SM70-EMPTY:
; CHECK-SM70-NEXT:  // %bb.0:
; CHECK-SM70-NEXT:    ld.param.b16 %rs1, [fma_f16_no_nans_param_0];
; CHECK-SM70-NEXT:    ld.param.b16 %rs2, [fma_f16_no_nans_param_1];
; CHECK-SM70-NEXT:    ld.param.b16 %rs3, [fma_f16_no_nans_param_2];
; CHECK-SM70-NEXT:    fma.rn.f16 %rs4, %rs1, %rs2, %rs3;
; CHECK-SM70-NEXT:    mov.b16 %rs5, 0x0000;
; CHECK-SM70-NEXT:    setp.gt.f16 %p1, %rs4, %rs5;
; CHECK-SM70-NEXT:    selp.b16 %rs6, %rs4, 0x0000, %p1;
; CHECK-SM70-NEXT:    st.param.b16 [func_retval0], %rs6;
; CHECK-SM70-NEXT:    ret;
  %1 = call half @llvm.fma.f16(half %a, half %b, half %c)
  %2 = fcmp ogt half %1, 0.0
  %3 = select i1 %2, half %1, half 0.0
  ret half %3
}

; FMA relu shouldn't be selected if the FMA operation has multiple uses
define half @fma_f16_no_nans_multiple_uses_of_fma(half %a, half %b, half %c) #0 {
; CHECK-LABEL: fma_f16_no_nans_multiple_uses_of_fma(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<8>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b16 %rs1, [fma_f16_no_nans_multiple_uses_of_fma_param_0];
; CHECK-NEXT:    ld.param.b16 %rs2, [fma_f16_no_nans_multiple_uses_of_fma_param_1];
; CHECK-NEXT:    ld.param.b16 %rs3, [fma_f16_no_nans_multiple_uses_of_fma_param_2];
; CHECK-NEXT:    fma.rn.f16 %rs4, %rs1, %rs2, %rs3;
; CHECK-NEXT:    mov.b16 %rs5, 0x4700;
; CHECK-NEXT:    add.f16 %rs6, %rs4, %rs5;
; CHECK-NEXT:    add.f16 %rs7, %rs6, %rs4;
; CHECK-NEXT:    st.param.b16 [func_retval0], %rs7;
; CHECK-NEXT:    ret;
;
; CHECK-FTZ-LABEL: fma_f16_no_nans_multiple_uses_of_fma(
; CHECK-FTZ:       {
; CHECK-FTZ-NEXT:    .reg .b16 %rs<8>;
; CHECK-FTZ-EMPTY:
; CHECK-FTZ-NEXT:  // %bb.0:
; CHECK-FTZ-NEXT:    ld.param.b16 %rs1, [fma_f16_no_nans_multiple_uses_of_fma_param_0];
; CHECK-FTZ-NEXT:    ld.param.b16 %rs2, [fma_f16_no_nans_multiple_uses_of_fma_param_1];
; CHECK-FTZ-NEXT:    ld.param.b16 %rs3, [fma_f16_no_nans_multiple_uses_of_fma_param_2];
; CHECK-FTZ-NEXT:    fma.rn.ftz.f16 %rs4, %rs1, %rs2, %rs3;
; CHECK-FTZ-NEXT:    mov.b16 %rs5, 0x4700;
; CHECK-FTZ-NEXT:    add.ftz.f16 %rs6, %rs4, %rs5;
; CHECK-FTZ-NEXT:    add.ftz.f16 %rs7, %rs6, %rs4;
; CHECK-FTZ-NEXT:    st.param.b16 [func_retval0], %rs7;
; CHECK-FTZ-NEXT:    ret;
;
; CHECK-SM70-LABEL: fma_f16_no_nans_multiple_uses_of_fma(
; CHECK-SM70:       {
; CHECK-SM70-NEXT:    .reg .b16 %rs<8>;
; CHECK-SM70-EMPTY:
; CHECK-SM70-NEXT:  // %bb.0:
; CHECK-SM70-NEXT:    ld.param.b16 %rs1, [fma_f16_no_nans_multiple_uses_of_fma_param_0];
; CHECK-SM70-NEXT:    ld.param.b16 %rs2, [fma_f16_no_nans_multiple_uses_of_fma_param_1];
; CHECK-SM70-NEXT:    ld.param.b16 %rs3, [fma_f16_no_nans_multiple_uses_of_fma_param_2];
; CHECK-SM70-NEXT:    fma.rn.f16 %rs4, %rs1, %rs2, %rs3;
; CHECK-SM70-NEXT:    mov.b16 %rs5, 0x4700;
; CHECK-SM70-NEXT:    add.f16 %rs6, %rs4, %rs5;
; CHECK-SM70-NEXT:    add.f16 %rs7, %rs6, %rs4;
; CHECK-SM70-NEXT:    st.param.b16 [func_retval0], %rs7;
; CHECK-SM70-NEXT:    ret;
  %1 = call half @llvm.fma.f16(half %a, half %b, half %c)
  %2 = fcmp ogt half %1, 0.0
  %3 = select i1 %2, half %1, half 0.0
  %4 = fadd half %1, 7.0
  %5 = fadd half %4, %1
  ret half %5
}

define half @fma_f16_maxnum_no_nans(half %a, half %b, half %c) #0 {
; CHECK-LABEL: fma_f16_maxnum_no_nans(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b16 %rs1, [fma_f16_maxnum_no_nans_param_0];
; CHECK-NEXT:    ld.param.b16 %rs2, [fma_f16_maxnum_no_nans_param_1];
; CHECK-NEXT:    ld.param.b16 %rs3, [fma_f16_maxnum_no_nans_param_2];
; CHECK-NEXT:    fma.rn.relu.f16 %rs4, %rs1, %rs2, %rs3;
; CHECK-NEXT:    st.param.b16 [func_retval0], %rs4;
; CHECK-NEXT:    ret;
;
; CHECK-FTZ-LABEL: fma_f16_maxnum_no_nans(
; CHECK-FTZ:       {
; CHECK-FTZ-NEXT:    .reg .b16 %rs<5>;
; CHECK-FTZ-EMPTY:
; CHECK-FTZ-NEXT:  // %bb.0:
; CHECK-FTZ-NEXT:    ld.param.b16 %rs1, [fma_f16_maxnum_no_nans_param_0];
; CHECK-FTZ-NEXT:    ld.param.b16 %rs2, [fma_f16_maxnum_no_nans_param_1];
; CHECK-FTZ-NEXT:    ld.param.b16 %rs3, [fma_f16_maxnum_no_nans_param_2];
; CHECK-FTZ-NEXT:    fma.rn.ftz.relu.f16 %rs4, %rs1, %rs2, %rs3;
; CHECK-FTZ-NEXT:    st.param.b16 [func_retval0], %rs4;
; CHECK-FTZ-NEXT:    ret;
;
; CHECK-SM70-LABEL: fma_f16_maxnum_no_nans(
; CHECK-SM70:       {
; CHECK-SM70-NEXT:    .reg .b16 %rs<6>;
; CHECK-SM70-NEXT:    .reg .f32 %f<3>;
; CHECK-SM70-EMPTY:
; CHECK-SM70-NEXT:  // %bb.0:
; CHECK-SM70-NEXT:    ld.param.b16 %rs1, [fma_f16_maxnum_no_nans_param_0];
; CHECK-SM70-NEXT:    ld.param.b16 %rs2, [fma_f16_maxnum_no_nans_param_1];
; CHECK-SM70-NEXT:    ld.param.b16 %rs3, [fma_f16_maxnum_no_nans_param_2];
; CHECK-SM70-NEXT:    fma.rn.f16 %rs4, %rs1, %rs2, %rs3;
; CHECK-SM70-NEXT:    cvt.f32.f16 %f1, %rs4;
; CHECK-SM70-NEXT:    max.f32 %f2, %f1, 0f00000000;
; CHECK-SM70-NEXT:    cvt.rn.f16.f32 %rs5, %f2;
; CHECK-SM70-NEXT:    st.param.b16 [func_retval0], %rs5;
; CHECK-SM70-NEXT:    ret;
  %1 = call half @llvm.fma.f16(half %a, half %b, half %c)
  %2 = call half @llvm.maxnum.f16(half %1, half 0.0)
  ret half %2
}

define bfloat @fma_bf16_no_nans(bfloat %a, bfloat %b, bfloat %c) #0 {
; CHECK-LABEL: fma_bf16_no_nans(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b16 %rs1, [fma_bf16_no_nans_param_0];
; CHECK-NEXT:    ld.param.b16 %rs2, [fma_bf16_no_nans_param_1];
; CHECK-NEXT:    ld.param.b16 %rs3, [fma_bf16_no_nans_param_2];
; CHECK-NEXT:    fma.rn.relu.bf16 %rs4, %rs1, %rs2, %rs3;
; CHECK-NEXT:    st.param.b16 [func_retval0], %rs4;
; CHECK-NEXT:    ret;
;
; CHECK-FTZ-LABEL: fma_bf16_no_nans(
; CHECK-FTZ:       {
; CHECK-FTZ-NEXT:    .reg .b16 %rs<5>;
; CHECK-FTZ-EMPTY:
; CHECK-FTZ-NEXT:  // %bb.0:
; CHECK-FTZ-NEXT:    ld.param.b16 %rs1, [fma_bf16_no_nans_param_0];
; CHECK-FTZ-NEXT:    ld.param.b16 %rs2, [fma_bf16_no_nans_param_1];
; CHECK-FTZ-NEXT:    ld.param.b16 %rs3, [fma_bf16_no_nans_param_2];
; CHECK-FTZ-NEXT:    fma.rn.relu.bf16 %rs4, %rs1, %rs2, %rs3;
; CHECK-FTZ-NEXT:    st.param.b16 [func_retval0], %rs4;
; CHECK-FTZ-NEXT:    ret;
;
; CHECK-SM70-LABEL: fma_bf16_no_nans(
; CHECK-SM70:       {
; CHECK-SM70-NEXT:    .reg .pred %p<3>;
; CHECK-SM70-NEXT:    .reg .b16 %rs<3>;
; CHECK-SM70-NEXT:    .reg .b32 %r<14>;
; CHECK-SM70-NEXT:    .reg .f32 %f<6>;
; CHECK-SM70-EMPTY:
; CHECK-SM70-NEXT:  // %bb.0:
; CHECK-SM70-NEXT:    ld.param.u16 %r1, [fma_bf16_no_nans_param_2];
; CHECK-SM70-NEXT:    shl.b32 %r2, %r1, 16;
; CHECK-SM70-NEXT:    mov.b32 %f1, %r2;
; CHECK-SM70-NEXT:    ld.param.u16 %r3, [fma_bf16_no_nans_param_1];
; CHECK-SM70-NEXT:    shl.b32 %r4, %r3, 16;
; CHECK-SM70-NEXT:    mov.b32 %f2, %r4;
; CHECK-SM70-NEXT:    ld.param.u16 %r5, [fma_bf16_no_nans_param_0];
; CHECK-SM70-NEXT:    shl.b32 %r6, %r5, 16;
; CHECK-SM70-NEXT:    mov.b32 %f3, %r6;
; CHECK-SM70-NEXT:    fma.rn.f32 %f4, %f3, %f2, %f1;
; CHECK-SM70-NEXT:    mov.b32 %r7, %f4;
; CHECK-SM70-NEXT:    bfe.u32 %r8, %r7, 16, 1;
; CHECK-SM70-NEXT:    add.s32 %r9, %r8, %r7;
; CHECK-SM70-NEXT:    add.s32 %r10, %r9, 32767;
; CHECK-SM70-NEXT:    setp.nan.f32 %p1, %f4, %f4;
; CHECK-SM70-NEXT:    or.b32 %r11, %r7, 4194304;
; CHECK-SM70-NEXT:    selp.b32 %r12, %r11, %r10, %p1;
; CHECK-SM70-NEXT:    { .reg .b16 tmp; mov.b32 {tmp, %rs1}, %r12; }
; CHECK-SM70-NEXT:    and.b32 %r13, %r12, -65536;
; CHECK-SM70-NEXT:    mov.b32 %f5, %r13;
; CHECK-SM70-NEXT:    setp.gt.f32 %p2, %f5, 0f00000000;
; CHECK-SM70-NEXT:    selp.b16 %rs2, %rs1, 0x0000, %p2;
; CHECK-SM70-NEXT:    st.param.b16 [func_retval0], %rs2;
; CHECK-SM70-NEXT:    ret;
  %1 = call bfloat @llvm.fma.bf16(bfloat %a, bfloat %b, bfloat %c)
  %2 = fcmp ogt bfloat %1, 0.0
  %3 = select i1 %2, bfloat %1, bfloat 0.0
  ret bfloat %3
}

; FMA_relu shouldn't be selected if the FMA operation has multiple uses
define bfloat @fma_bf16_no_nans_multiple_uses_of_fma(bfloat %a, bfloat %b, bfloat %c) #0 {
; CHECK-LABEL: fma_bf16_no_nans_multiple_uses_of_fma(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<9>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b16 %rs1, [fma_bf16_no_nans_multiple_uses_of_fma_param_0];
; CHECK-NEXT:    ld.param.b16 %rs2, [fma_bf16_no_nans_multiple_uses_of_fma_param_1];
; CHECK-NEXT:    ld.param.b16 %rs3, [fma_bf16_no_nans_multiple_uses_of_fma_param_2];
; CHECK-NEXT:    fma.rn.bf16 %rs4, %rs1, %rs2, %rs3;
; CHECK-NEXT:    mov.b16 %rs5, 0x3F80;
; CHECK-NEXT:    mov.b16 %rs6, 0x40E0;
; CHECK-NEXT:    fma.rn.bf16 %rs7, %rs4, %rs5, %rs6;
; CHECK-NEXT:    fma.rn.bf16 %rs8, %rs7, %rs5, %rs4;
; CHECK-NEXT:    st.param.b16 [func_retval0], %rs8;
; CHECK-NEXT:    ret;
;
; CHECK-FTZ-LABEL: fma_bf16_no_nans_multiple_uses_of_fma(
; CHECK-FTZ:       {
; CHECK-FTZ-NEXT:    .reg .b16 %rs<7>;
; CHECK-FTZ-NEXT:    .reg .b32 %r<5>;
; CHECK-FTZ-NEXT:    .reg .f32 %f<5>;
; CHECK-FTZ-EMPTY:
; CHECK-FTZ-NEXT:  // %bb.0:
; CHECK-FTZ-NEXT:    ld.param.b16 %rs1, [fma_bf16_no_nans_multiple_uses_of_fma_param_0];
; CHECK-FTZ-NEXT:    ld.param.b16 %rs2, [fma_bf16_no_nans_multiple_uses_of_fma_param_1];
; CHECK-FTZ-NEXT:    ld.param.b16 %rs3, [fma_bf16_no_nans_multiple_uses_of_fma_param_2];
; CHECK-FTZ-NEXT:    fma.rn.bf16 %rs4, %rs1, %rs2, %rs3;
; CHECK-FTZ-NEXT:    cvt.u32.u16 %r1, %rs4;
; CHECK-FTZ-NEXT:    shl.b32 %r2, %r1, 16;
; CHECK-FTZ-NEXT:    mov.b32 %f1, %r2;
; CHECK-FTZ-NEXT:    add.ftz.f32 %f2, %f1, 0f40E00000;
; CHECK-FTZ-NEXT:    cvt.rn.bf16.f32 %rs5, %f2;
; CHECK-FTZ-NEXT:    cvt.u32.u16 %r3, %rs5;
; CHECK-FTZ-NEXT:    shl.b32 %r4, %r3, 16;
; CHECK-FTZ-NEXT:    mov.b32 %f3, %r4;
; CHECK-FTZ-NEXT:    add.ftz.f32 %f4, %f3, %f1;
; CHECK-FTZ-NEXT:    cvt.rn.bf16.f32 %rs6, %f4;
; CHECK-FTZ-NEXT:    st.param.b16 [func_retval0], %rs6;
; CHECK-FTZ-NEXT:    ret;
;
; CHECK-SM70-LABEL: fma_bf16_no_nans_multiple_uses_of_fma(
; CHECK-SM70:       {
; CHECK-SM70-NEXT:    .reg .pred %p<4>;
; CHECK-SM70-NEXT:    .reg .b16 %rs<2>;
; CHECK-SM70-NEXT:    .reg .b32 %r<27>;
; CHECK-SM70-NEXT:    .reg .f32 %f<9>;
; CHECK-SM70-EMPTY:
; CHECK-SM70-NEXT:  // %bb.0:
; CHECK-SM70-NEXT:    ld.param.u16 %r1, [fma_bf16_no_nans_multiple_uses_of_fma_param_2];
; CHECK-SM70-NEXT:    shl.b32 %r2, %r1, 16;
; CHECK-SM70-NEXT:    mov.b32 %f1, %r2;
; CHECK-SM70-NEXT:    ld.param.u16 %r3, [fma_bf16_no_nans_multiple_uses_of_fma_param_1];
; CHECK-SM70-NEXT:    shl.b32 %r4, %r3, 16;
; CHECK-SM70-NEXT:    mov.b32 %f2, %r4;
; CHECK-SM70-NEXT:    ld.param.u16 %r5, [fma_bf16_no_nans_multiple_uses_of_fma_param_0];
; CHECK-SM70-NEXT:    shl.b32 %r6, %r5, 16;
; CHECK-SM70-NEXT:    mov.b32 %f3, %r6;
; CHECK-SM70-NEXT:    fma.rn.f32 %f4, %f3, %f2, %f1;
; CHECK-SM70-NEXT:    mov.b32 %r7, %f4;
; CHECK-SM70-NEXT:    bfe.u32 %r8, %r7, 16, 1;
; CHECK-SM70-NEXT:    add.s32 %r9, %r8, %r7;
; CHECK-SM70-NEXT:    add.s32 %r10, %r9, 32767;
; CHECK-SM70-NEXT:    setp.nan.f32 %p1, %f4, %f4;
; CHECK-SM70-NEXT:    or.b32 %r11, %r7, 4194304;
; CHECK-SM70-NEXT:    selp.b32 %r12, %r11, %r10, %p1;
; CHECK-SM70-NEXT:    and.b32 %r13, %r12, -65536;
; CHECK-SM70-NEXT:    mov.b32 %f5, %r13;
; CHECK-SM70-NEXT:    add.f32 %f6, %f5, 0f40E00000;
; CHECK-SM70-NEXT:    mov.b32 %r14, %f6;
; CHECK-SM70-NEXT:    bfe.u32 %r15, %r14, 16, 1;
; CHECK-SM70-NEXT:    add.s32 %r16, %r15, %r14;
; CHECK-SM70-NEXT:    add.s32 %r17, %r16, 32767;
; CHECK-SM70-NEXT:    setp.nan.f32 %p2, %f6, %f6;
; CHECK-SM70-NEXT:    or.b32 %r18, %r14, 4194304;
; CHECK-SM70-NEXT:    selp.b32 %r19, %r18, %r17, %p2;
; CHECK-SM70-NEXT:    and.b32 %r20, %r19, -65536;
; CHECK-SM70-NEXT:    mov.b32 %f7, %r20;
; CHECK-SM70-NEXT:    add.f32 %f8, %f7, %f5;
; CHECK-SM70-NEXT:    mov.b32 %r21, %f8;
; CHECK-SM70-NEXT:    bfe.u32 %r22, %r21, 16, 1;
; CHECK-SM70-NEXT:    add.s32 %r23, %r22, %r21;
; CHECK-SM70-NEXT:    add.s32 %r24, %r23, 32767;
; CHECK-SM70-NEXT:    setp.nan.f32 %p3, %f8, %f8;
; CHECK-SM70-NEXT:    or.b32 %r25, %r21, 4194304;
; CHECK-SM70-NEXT:    selp.b32 %r26, %r25, %r24, %p3;
; CHECK-SM70-NEXT:    { .reg .b16 tmp; mov.b32 {tmp, %rs1}, %r26; }
; CHECK-SM70-NEXT:    st.param.b16 [func_retval0], %rs1;
; CHECK-SM70-NEXT:    ret;
  %1 = call bfloat @llvm.fma.bf16(bfloat %a, bfloat %b, bfloat %c)
  %2 = fcmp ogt bfloat %1, 0.0
  %3 = select i1 %2, bfloat %1, bfloat 0.0
  %4 = fadd bfloat %1, 7.0
  %5 = fadd bfloat %4, %1
  ret bfloat %5
}

define bfloat @fma_bf16_maxnum_no_nans(bfloat %a, bfloat %b, bfloat %c) #0 {
; CHECK-LABEL: fma_bf16_maxnum_no_nans(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b16 %rs1, [fma_bf16_maxnum_no_nans_param_0];
; CHECK-NEXT:    ld.param.b16 %rs2, [fma_bf16_maxnum_no_nans_param_1];
; CHECK-NEXT:    ld.param.b16 %rs3, [fma_bf16_maxnum_no_nans_param_2];
; CHECK-NEXT:    fma.rn.relu.bf16 %rs4, %rs1, %rs2, %rs3;
; CHECK-NEXT:    st.param.b16 [func_retval0], %rs4;
; CHECK-NEXT:    ret;
;
; CHECK-FTZ-LABEL: fma_bf16_maxnum_no_nans(
; CHECK-FTZ:       {
; CHECK-FTZ-NEXT:    .reg .b16 %rs<5>;
; CHECK-FTZ-EMPTY:
; CHECK-FTZ-NEXT:  // %bb.0:
; CHECK-FTZ-NEXT:    ld.param.b16 %rs1, [fma_bf16_maxnum_no_nans_param_0];
; CHECK-FTZ-NEXT:    ld.param.b16 %rs2, [fma_bf16_maxnum_no_nans_param_1];
; CHECK-FTZ-NEXT:    ld.param.b16 %rs3, [fma_bf16_maxnum_no_nans_param_2];
; CHECK-FTZ-NEXT:    fma.rn.relu.bf16 %rs4, %rs1, %rs2, %rs3;
; CHECK-FTZ-NEXT:    st.param.b16 [func_retval0], %rs4;
; CHECK-FTZ-NEXT:    ret;
;
; CHECK-SM70-LABEL: fma_bf16_maxnum_no_nans(
; CHECK-SM70:       {
; CHECK-SM70-NEXT:    .reg .pred %p<3>;
; CHECK-SM70-NEXT:    .reg .b16 %rs<2>;
; CHECK-SM70-NEXT:    .reg .b32 %r<20>;
; CHECK-SM70-NEXT:    .reg .f32 %f<7>;
; CHECK-SM70-EMPTY:
; CHECK-SM70-NEXT:  // %bb.0:
; CHECK-SM70-NEXT:    ld.param.u16 %r1, [fma_bf16_maxnum_no_nans_param_2];
; CHECK-SM70-NEXT:    shl.b32 %r2, %r1, 16;
; CHECK-SM70-NEXT:    mov.b32 %f1, %r2;
; CHECK-SM70-NEXT:    ld.param.u16 %r3, [fma_bf16_maxnum_no_nans_param_1];
; CHECK-SM70-NEXT:    shl.b32 %r4, %r3, 16;
; CHECK-SM70-NEXT:    mov.b32 %f2, %r4;
; CHECK-SM70-NEXT:    ld.param.u16 %r5, [fma_bf16_maxnum_no_nans_param_0];
; CHECK-SM70-NEXT:    shl.b32 %r6, %r5, 16;
; CHECK-SM70-NEXT:    mov.b32 %f3, %r6;
; CHECK-SM70-NEXT:    fma.rn.f32 %f4, %f3, %f2, %f1;
; CHECK-SM70-NEXT:    mov.b32 %r7, %f4;
; CHECK-SM70-NEXT:    bfe.u32 %r8, %r7, 16, 1;
; CHECK-SM70-NEXT:    add.s32 %r9, %r8, %r7;
; CHECK-SM70-NEXT:    add.s32 %r10, %r9, 32767;
; CHECK-SM70-NEXT:    setp.nan.f32 %p1, %f4, %f4;
; CHECK-SM70-NEXT:    or.b32 %r11, %r7, 4194304;
; CHECK-SM70-NEXT:    selp.b32 %r12, %r11, %r10, %p1;
; CHECK-SM70-NEXT:    and.b32 %r13, %r12, -65536;
; CHECK-SM70-NEXT:    mov.b32 %f5, %r13;
; CHECK-SM70-NEXT:    max.f32 %f6, %f5, 0f00000000;
; CHECK-SM70-NEXT:    mov.b32 %r14, %f6;
; CHECK-SM70-NEXT:    bfe.u32 %r15, %r14, 16, 1;
; CHECK-SM70-NEXT:    add.s32 %r16, %r15, %r14;
; CHECK-SM70-NEXT:    add.s32 %r17, %r16, 32767;
; CHECK-SM70-NEXT:    setp.nan.f32 %p2, %f6, %f6;
; CHECK-SM70-NEXT:    or.b32 %r18, %r14, 4194304;
; CHECK-SM70-NEXT:    selp.b32 %r19, %r18, %r17, %p2;
; CHECK-SM70-NEXT:    { .reg .b16 tmp; mov.b32 {tmp, %rs1}, %r19; }
; CHECK-SM70-NEXT:    st.param.b16 [func_retval0], %rs1;
; CHECK-SM70-NEXT:    ret;
  %1 = call bfloat @llvm.fma.bf16(bfloat %a, bfloat %b, bfloat %c)
  %2 = call bfloat @llvm.maxnum.bf16(bfloat %1, bfloat 0.0)
  ret bfloat %2
}

define <2 x half> @fma_f16x2_no_nans(<2 x half> %a, <2 x half> %b, <2 x half> %c) #0 {
; CHECK-LABEL: fma_f16x2_no_nans(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [fma_f16x2_no_nans_param_2];
; CHECK-NEXT:    ld.param.b32 %r2, [fma_f16x2_no_nans_param_1];
; CHECK-NEXT:    ld.param.b32 %r3, [fma_f16x2_no_nans_param_0];
; CHECK-NEXT:    fma.rn.relu.f16x2 %r4, %r3, %r2, %r1;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r4;
; CHECK-NEXT:    ret;
;
; CHECK-FTZ-LABEL: fma_f16x2_no_nans(
; CHECK-FTZ:       {
; CHECK-FTZ-NEXT:    .reg .b32 %r<5>;
; CHECK-FTZ-EMPTY:
; CHECK-FTZ-NEXT:  // %bb.0:
; CHECK-FTZ-NEXT:    ld.param.b32 %r1, [fma_f16x2_no_nans_param_2];
; CHECK-FTZ-NEXT:    ld.param.b32 %r2, [fma_f16x2_no_nans_param_1];
; CHECK-FTZ-NEXT:    ld.param.b32 %r3, [fma_f16x2_no_nans_param_0];
; CHECK-FTZ-NEXT:    fma.rn.ftz.relu.f16x2 %r4, %r3, %r2, %r1;
; CHECK-FTZ-NEXT:    st.param.b32 [func_retval0], %r4;
; CHECK-FTZ-NEXT:    ret;
;
; CHECK-SM70-LABEL: fma_f16x2_no_nans(
; CHECK-SM70:       {
; CHECK-SM70-NEXT:    .reg .pred %p<3>;
; CHECK-SM70-NEXT:    .reg .b16 %rs<5>;
; CHECK-SM70-NEXT:    .reg .b32 %r<7>;
; CHECK-SM70-EMPTY:
; CHECK-SM70-NEXT:  // %bb.0:
; CHECK-SM70-NEXT:    ld.param.b32 %r1, [fma_f16x2_no_nans_param_2];
; CHECK-SM70-NEXT:    ld.param.b32 %r2, [fma_f16x2_no_nans_param_1];
; CHECK-SM70-NEXT:    ld.param.b32 %r3, [fma_f16x2_no_nans_param_0];
; CHECK-SM70-NEXT:    fma.rn.f16x2 %r4, %r3, %r2, %r1;
; CHECK-SM70-NEXT:    mov.b32 %r5, 0;
; CHECK-SM70-NEXT:    setp.gt.f16x2 %p1|%p2, %r4, %r5;
; CHECK-SM70-NEXT:    mov.b32 {%rs1, %rs2}, %r4;
; CHECK-SM70-NEXT:    selp.b16 %rs3, %rs2, 0x0000, %p2;
; CHECK-SM70-NEXT:    selp.b16 %rs4, %rs1, 0x0000, %p1;
; CHECK-SM70-NEXT:    mov.b32 %r6, {%rs4, %rs3};
; CHECK-SM70-NEXT:    st.param.b32 [func_retval0], %r6;
; CHECK-SM70-NEXT:    ret;
  %1 = call <2 x half> @llvm.fma.f16x2(<2 x half> %a, <2 x half> %b, <2 x half> %c)
  %2 = fcmp ogt <2 x half> %1, <half 0.0, half 0.0>
  %3 = select <2 x i1> %2, <2 x half> %1, <2 x half> <half 0.0, half 0.0>
  ret <2 x half> %3
}

; FMA relu shouldn't be selected if the FMA operation has multiple uses
define <2 x half> @fma_f16x2_no_nans_multiple_uses_of_fma(<2 x half> %a, <2 x half> %b, <2 x half> %c) #0 {
; CHECK-LABEL: fma_f16x2_no_nans_multiple_uses_of_fma(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<8>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [fma_f16x2_no_nans_multiple_uses_of_fma_param_2];
; CHECK-NEXT:    ld.param.b32 %r2, [fma_f16x2_no_nans_multiple_uses_of_fma_param_1];
; CHECK-NEXT:    ld.param.b32 %r3, [fma_f16x2_no_nans_multiple_uses_of_fma_param_0];
; CHECK-NEXT:    fma.rn.f16x2 %r4, %r3, %r2, %r1;
; CHECK-NEXT:    mov.b32 %r5, 1191200512;
; CHECK-NEXT:    add.f16x2 %r6, %r4, %r5;
; CHECK-NEXT:    add.f16x2 %r7, %r6, %r4;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r7;
; CHECK-NEXT:    ret;
;
; CHECK-FTZ-LABEL: fma_f16x2_no_nans_multiple_uses_of_fma(
; CHECK-FTZ:       {
; CHECK-FTZ-NEXT:    .reg .b32 %r<8>;
; CHECK-FTZ-EMPTY:
; CHECK-FTZ-NEXT:  // %bb.0:
; CHECK-FTZ-NEXT:    ld.param.b32 %r1, [fma_f16x2_no_nans_multiple_uses_of_fma_param_2];
; CHECK-FTZ-NEXT:    ld.param.b32 %r2, [fma_f16x2_no_nans_multiple_uses_of_fma_param_1];
; CHECK-FTZ-NEXT:    ld.param.b32 %r3, [fma_f16x2_no_nans_multiple_uses_of_fma_param_0];
; CHECK-FTZ-NEXT:    fma.rn.ftz.f16x2 %r4, %r3, %r2, %r1;
; CHECK-FTZ-NEXT:    mov.b32 %r5, 1191200512;
; CHECK-FTZ-NEXT:    add.ftz.f16x2 %r6, %r4, %r5;
; CHECK-FTZ-NEXT:    add.ftz.f16x2 %r7, %r6, %r4;
; CHECK-FTZ-NEXT:    st.param.b32 [func_retval0], %r7;
; CHECK-FTZ-NEXT:    ret;
;
; CHECK-SM70-LABEL: fma_f16x2_no_nans_multiple_uses_of_fma(
; CHECK-SM70:       {
; CHECK-SM70-NEXT:    .reg .b32 %r<8>;
; CHECK-SM70-EMPTY:
; CHECK-SM70-NEXT:  // %bb.0:
; CHECK-SM70-NEXT:    ld.param.b32 %r1, [fma_f16x2_no_nans_multiple_uses_of_fma_param_2];
; CHECK-SM70-NEXT:    ld.param.b32 %r2, [fma_f16x2_no_nans_multiple_uses_of_fma_param_1];
; CHECK-SM70-NEXT:    ld.param.b32 %r3, [fma_f16x2_no_nans_multiple_uses_of_fma_param_0];
; CHECK-SM70-NEXT:    fma.rn.f16x2 %r4, %r3, %r2, %r1;
; CHECK-SM70-NEXT:    mov.b32 %r5, 1191200512;
; CHECK-SM70-NEXT:    add.f16x2 %r6, %r4, %r5;
; CHECK-SM70-NEXT:    add.f16x2 %r7, %r6, %r4;
; CHECK-SM70-NEXT:    st.param.b32 [func_retval0], %r7;
; CHECK-SM70-NEXT:    ret;
  %1 = call <2 x half> @llvm.fma.f16x2(<2 x half> %a, <2 x half> %b, <2 x half> %c)
  %2 = fcmp ogt <2 x half> %1, <half 0.0, half 0.0>
  %3 = select <2 x i1> %2, <2 x half> %1, <2 x half> <half 0.0, half 0.0>
  %4 = fadd <2 x half> %1, <half 7.0, half 7.0>
  %5 = fadd <2 x half> %4, %1
  ret <2 x half> %5
}

define <2 x half> @fma_f16x2_maxnum_no_nans(<2 x half> %a, <2 x half> %b, <2 x half> %c) #0 {
; CHECK-LABEL: fma_f16x2_maxnum_no_nans(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [fma_f16x2_maxnum_no_nans_param_2];
; CHECK-NEXT:    ld.param.b32 %r2, [fma_f16x2_maxnum_no_nans_param_1];
; CHECK-NEXT:    ld.param.b32 %r3, [fma_f16x2_maxnum_no_nans_param_0];
; CHECK-NEXT:    fma.rn.relu.f16x2 %r4, %r3, %r2, %r1;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r4;
; CHECK-NEXT:    ret;
;
; CHECK-FTZ-LABEL: fma_f16x2_maxnum_no_nans(
; CHECK-FTZ:       {
; CHECK-FTZ-NEXT:    .reg .b32 %r<5>;
; CHECK-FTZ-EMPTY:
; CHECK-FTZ-NEXT:  // %bb.0:
; CHECK-FTZ-NEXT:    ld.param.b32 %r1, [fma_f16x2_maxnum_no_nans_param_2];
; CHECK-FTZ-NEXT:    ld.param.b32 %r2, [fma_f16x2_maxnum_no_nans_param_1];
; CHECK-FTZ-NEXT:    ld.param.b32 %r3, [fma_f16x2_maxnum_no_nans_param_0];
; CHECK-FTZ-NEXT:    fma.rn.ftz.relu.f16x2 %r4, %r3, %r2, %r1;
; CHECK-FTZ-NEXT:    st.param.b32 [func_retval0], %r4;
; CHECK-FTZ-NEXT:    ret;
;
; CHECK-SM70-LABEL: fma_f16x2_maxnum_no_nans(
; CHECK-SM70:       {
; CHECK-SM70-NEXT:    .reg .b16 %rs<5>;
; CHECK-SM70-NEXT:    .reg .b32 %r<6>;
; CHECK-SM70-NEXT:    .reg .f32 %f<5>;
; CHECK-SM70-EMPTY:
; CHECK-SM70-NEXT:  // %bb.0:
; CHECK-SM70-NEXT:    ld.param.b32 %r1, [fma_f16x2_maxnum_no_nans_param_2];
; CHECK-SM70-NEXT:    ld.param.b32 %r2, [fma_f16x2_maxnum_no_nans_param_1];
; CHECK-SM70-NEXT:    ld.param.b32 %r3, [fma_f16x2_maxnum_no_nans_param_0];
; CHECK-SM70-NEXT:    fma.rn.f16x2 %r4, %r3, %r2, %r1;
; CHECK-SM70-NEXT:    mov.b32 {%rs1, %rs2}, %r4;
; CHECK-SM70-NEXT:    cvt.f32.f16 %f1, %rs2;
; CHECK-SM70-NEXT:    max.f32 %f2, %f1, 0f00000000;
; CHECK-SM70-NEXT:    cvt.rn.f16.f32 %rs3, %f2;
; CHECK-SM70-NEXT:    cvt.f32.f16 %f3, %rs1;
; CHECK-SM70-NEXT:    max.f32 %f4, %f3, 0f00000000;
; CHECK-SM70-NEXT:    cvt.rn.f16.f32 %rs4, %f4;
; CHECK-SM70-NEXT:    mov.b32 %r5, {%rs4, %rs3};
; CHECK-SM70-NEXT:    st.param.b32 [func_retval0], %r5;
; CHECK-SM70-NEXT:    ret;
  %1 = call <2 x half> @llvm.fma.f16x2(<2 x half> %a, <2 x half> %b, <2 x half> %c)
  %2 = call <2 x half> @llvm.maxnum.f16x2(<2 x half> %1, <2 x half> <half 0.0, half 0.0>)
  ret <2 x half> %2
}

define <2 x bfloat> @fma_bf16x2_no_nans(<2 x bfloat> %a, <2 x bfloat> %b, <2 x bfloat> %c) #0 {
; CHECK-LABEL: fma_bf16x2_no_nans(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [fma_bf16x2_no_nans_param_2];
; CHECK-NEXT:    ld.param.b32 %r2, [fma_bf16x2_no_nans_param_1];
; CHECK-NEXT:    ld.param.b32 %r3, [fma_bf16x2_no_nans_param_0];
; CHECK-NEXT:    fma.rn.relu.bf16x2 %r4, %r3, %r2, %r1;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r4;
; CHECK-NEXT:    ret;
;
; CHECK-FTZ-LABEL: fma_bf16x2_no_nans(
; CHECK-FTZ:       {
; CHECK-FTZ-NEXT:    .reg .b32 %r<5>;
; CHECK-FTZ-EMPTY:
; CHECK-FTZ-NEXT:  // %bb.0:
; CHECK-FTZ-NEXT:    ld.param.b32 %r1, [fma_bf16x2_no_nans_param_2];
; CHECK-FTZ-NEXT:    ld.param.b32 %r2, [fma_bf16x2_no_nans_param_1];
; CHECK-FTZ-NEXT:    ld.param.b32 %r3, [fma_bf16x2_no_nans_param_0];
; CHECK-FTZ-NEXT:    fma.rn.relu.bf16x2 %r4, %r3, %r2, %r1;
; CHECK-FTZ-NEXT:    st.param.b32 [func_retval0], %r4;
; CHECK-FTZ-NEXT:    ret;
;
; CHECK-SM70-LABEL: fma_bf16x2_no_nans(
; CHECK-SM70:       {
; CHECK-SM70-NEXT:    .reg .pred %p<5>;
; CHECK-SM70-NEXT:    .reg .b16 %rs<11>;
; CHECK-SM70-NEXT:    .reg .b32 %r<31>;
; CHECK-SM70-NEXT:    .reg .f32 %f<11>;
; CHECK-SM70-EMPTY:
; CHECK-SM70-NEXT:  // %bb.0:
; CHECK-SM70-NEXT:    ld.param.b32 %r1, [fma_bf16x2_no_nans_param_0];
; CHECK-SM70-NEXT:    ld.param.b32 %r2, [fma_bf16x2_no_nans_param_1];
; CHECK-SM70-NEXT:    ld.param.b32 %r3, [fma_bf16x2_no_nans_param_2];
; CHECK-SM70-NEXT:    mov.b32 {%rs1, %rs2}, %r3;
; CHECK-SM70-NEXT:    cvt.u32.u16 %r4, %rs1;
; CHECK-SM70-NEXT:    shl.b32 %r5, %r4, 16;
; CHECK-SM70-NEXT:    mov.b32 %f1, %r5;
; CHECK-SM70-NEXT:    mov.b32 {%rs3, %rs4}, %r2;
; CHECK-SM70-NEXT:    cvt.u32.u16 %r6, %rs3;
; CHECK-SM70-NEXT:    shl.b32 %r7, %r6, 16;
; CHECK-SM70-NEXT:    mov.b32 %f2, %r7;
; CHECK-SM70-NEXT:    mov.b32 {%rs5, %rs6}, %r1;
; CHECK-SM70-NEXT:    cvt.u32.u16 %r8, %rs5;
; CHECK-SM70-NEXT:    shl.b32 %r9, %r8, 16;
; CHECK-SM70-NEXT:    mov.b32 %f3, %r9;
; CHECK-SM70-NEXT:    fma.rn.f32 %f4, %f3, %f2, %f1;
; CHECK-SM70-NEXT:    mov.b32 %r10, %f4;
; CHECK-SM70-NEXT:    bfe.u32 %r11, %r10, 16, 1;
; CHECK-SM70-NEXT:    add.s32 %r12, %r11, %r10;
; CHECK-SM70-NEXT:    add.s32 %r13, %r12, 32767;
; CHECK-SM70-NEXT:    setp.nan.f32 %p1, %f4, %f4;
; CHECK-SM70-NEXT:    or.b32 %r14, %r10, 4194304;
; CHECK-SM70-NEXT:    selp.b32 %r15, %r14, %r13, %p1;
; CHECK-SM70-NEXT:    { .reg .b16 tmp; mov.b32 {tmp, %rs7}, %r15; }
; CHECK-SM70-NEXT:    cvt.u32.u16 %r16, %rs2;
; CHECK-SM70-NEXT:    shl.b32 %r17, %r16, 16;
; CHECK-SM70-NEXT:    mov.b32 %f5, %r17;
; CHECK-SM70-NEXT:    cvt.u32.u16 %r18, %rs4;
; CHECK-SM70-NEXT:    shl.b32 %r19, %r18, 16;
; CHECK-SM70-NEXT:    mov.b32 %f6, %r19;
; CHECK-SM70-NEXT:    cvt.u32.u16 %r20, %rs6;
; CHECK-SM70-NEXT:    shl.b32 %r21, %r20, 16;
; CHECK-SM70-NEXT:    mov.b32 %f7, %r21;
; CHECK-SM70-NEXT:    fma.rn.f32 %f8, %f7, %f6, %f5;
; CHECK-SM70-NEXT:    mov.b32 %r22, %f8;
; CHECK-SM70-NEXT:    bfe.u32 %r23, %r22, 16, 1;
; CHECK-SM70-NEXT:    add.s32 %r24, %r23, %r22;
; CHECK-SM70-NEXT:    add.s32 %r25, %r24, 32767;
; CHECK-SM70-NEXT:    setp.nan.f32 %p2, %f8, %f8;
; CHECK-SM70-NEXT:    or.b32 %r26, %r22, 4194304;
; CHECK-SM70-NEXT:    selp.b32 %r27, %r26, %r25, %p2;
; CHECK-SM70-NEXT:    { .reg .b16 tmp; mov.b32 {tmp, %rs8}, %r27; }
; CHECK-SM70-NEXT:    and.b32 %r28, %r15, -65536;
; CHECK-SM70-NEXT:    mov.b32 %f9, %r28;
; CHECK-SM70-NEXT:    setp.gt.f32 %p3, %f9, 0f00000000;
; CHECK-SM70-NEXT:    and.b32 %r29, %r27, -65536;
; CHECK-SM70-NEXT:    mov.b32 %f10, %r29;
; CHECK-SM70-NEXT:    setp.gt.f32 %p4, %f10, 0f00000000;
; CHECK-SM70-NEXT:    selp.b16 %rs9, %rs8, 0x0000, %p4;
; CHECK-SM70-NEXT:    selp.b16 %rs10, %rs7, 0x0000, %p3;
; CHECK-SM70-NEXT:    mov.b32 %r30, {%rs10, %rs9};
; CHECK-SM70-NEXT:    st.param.b32 [func_retval0], %r30;
; CHECK-SM70-NEXT:    ret;
  %1 = call <2 x bfloat> @llvm.fma.bf16x2(<2 x bfloat> %a, <2 x bfloat> %b, <2 x bfloat> %c)
  %2 = fcmp ogt <2 x bfloat> %1, <bfloat 0.0, bfloat 0.0>
  %3 = select <2 x i1> %2, <2 x bfloat> %1, <2 x bfloat> <bfloat 0.0, bfloat 0.0>
  ret <2 x bfloat> %3
}

; FMA_relu shouldn't be selected if the FMA operation has multiple uses
define <2 x bfloat> @fma_bf16x2_no_nans_multiple_uses_of_fma(<2 x bfloat> %a, <2 x bfloat> %b, <2 x bfloat> %c) #0 {
; CHECK-LABEL: fma_bf16x2_no_nans_multiple_uses_of_fma(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<9>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [fma_bf16x2_no_nans_multiple_uses_of_fma_param_2];
; CHECK-NEXT:    ld.param.b32 %r2, [fma_bf16x2_no_nans_multiple_uses_of_fma_param_1];
; CHECK-NEXT:    ld.param.b32 %r3, [fma_bf16x2_no_nans_multiple_uses_of_fma_param_0];
; CHECK-NEXT:    fma.rn.bf16x2 %r4, %r3, %r2, %r1;
; CHECK-NEXT:    mov.b32 %r5, 1065369472;
; CHECK-NEXT:    mov.b32 %r6, 1088438496;
; CHECK-NEXT:    fma.rn.bf16x2 %r7, %r4, %r5, %r6;
; CHECK-NEXT:    fma.rn.bf16x2 %r8, %r7, %r5, %r4;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r8;
; CHECK-NEXT:    ret;
;
; CHECK-FTZ-LABEL: fma_bf16x2_no_nans_multiple_uses_of_fma(
; CHECK-FTZ:       {
; CHECK-FTZ-NEXT:    .reg .b16 %rs<5>;
; CHECK-FTZ-NEXT:    .reg .b32 %r<14>;
; CHECK-FTZ-NEXT:    .reg .f32 %f<9>;
; CHECK-FTZ-EMPTY:
; CHECK-FTZ-NEXT:  // %bb.0:
; CHECK-FTZ-NEXT:    ld.param.b32 %r1, [fma_bf16x2_no_nans_multiple_uses_of_fma_param_2];
; CHECK-FTZ-NEXT:    ld.param.b32 %r2, [fma_bf16x2_no_nans_multiple_uses_of_fma_param_1];
; CHECK-FTZ-NEXT:    ld.param.b32 %r3, [fma_bf16x2_no_nans_multiple_uses_of_fma_param_0];
; CHECK-FTZ-NEXT:    fma.rn.bf16x2 %r4, %r3, %r2, %r1;
; CHECK-FTZ-NEXT:    mov.b32 {%rs1, %rs2}, %r4;
; CHECK-FTZ-NEXT:    cvt.u32.u16 %r5, %rs2;
; CHECK-FTZ-NEXT:    shl.b32 %r6, %r5, 16;
; CHECK-FTZ-NEXT:    mov.b32 %f1, %r6;
; CHECK-FTZ-NEXT:    add.ftz.f32 %f2, %f1, 0f40E00000;
; CHECK-FTZ-NEXT:    cvt.rn.bf16.f32 %rs3, %f2;
; CHECK-FTZ-NEXT:    cvt.u32.u16 %r7, %rs1;
; CHECK-FTZ-NEXT:    shl.b32 %r8, %r7, 16;
; CHECK-FTZ-NEXT:    mov.b32 %f3, %r8;
; CHECK-FTZ-NEXT:    add.ftz.f32 %f4, %f3, 0f40E00000;
; CHECK-FTZ-NEXT:    cvt.rn.bf16.f32 %rs4, %f4;
; CHECK-FTZ-NEXT:    cvt.u32.u16 %r9, %rs4;
; CHECK-FTZ-NEXT:    shl.b32 %r10, %r9, 16;
; CHECK-FTZ-NEXT:    mov.b32 %f5, %r10;
; CHECK-FTZ-NEXT:    add.ftz.f32 %f6, %f5, %f3;
; CHECK-FTZ-NEXT:    cvt.u32.u16 %r11, %rs3;
; CHECK-FTZ-NEXT:    shl.b32 %r12, %r11, 16;
; CHECK-FTZ-NEXT:    mov.b32 %f7, %r12;
; CHECK-FTZ-NEXT:    add.ftz.f32 %f8, %f7, %f1;
; CHECK-FTZ-NEXT:    cvt.rn.bf16x2.f32 %r13, %f8, %f6;
; CHECK-FTZ-NEXT:    st.param.b32 [func_retval0], %r13;
; CHECK-FTZ-NEXT:    ret;
;
; CHECK-SM70-LABEL: fma_bf16x2_no_nans_multiple_uses_of_fma(
; CHECK-SM70:       {
; CHECK-SM70-NEXT:    .reg .pred %p<7>;
; CHECK-SM70-NEXT:    .reg .b16 %rs<7>;
; CHECK-SM70-NEXT:    .reg .b32 %r<57>;
; CHECK-SM70-NEXT:    .reg .f32 %f<17>;
; CHECK-SM70-EMPTY:
; CHECK-SM70-NEXT:  // %bb.0:
; CHECK-SM70-NEXT:    ld.param.b32 %r1, [fma_bf16x2_no_nans_multiple_uses_of_fma_param_0];
; CHECK-SM70-NEXT:    ld.param.b32 %r2, [fma_bf16x2_no_nans_multiple_uses_of_fma_param_1];
; CHECK-SM70-NEXT:    ld.param.b32 %r3, [fma_bf16x2_no_nans_multiple_uses_of_fma_param_2];
; CHECK-SM70-NEXT:    mov.b32 {%rs1, %rs2}, %r3;
; CHECK-SM70-NEXT:    cvt.u32.u16 %r4, %rs2;
; CHECK-SM70-NEXT:    shl.b32 %r5, %r4, 16;
; CHECK-SM70-NEXT:    mov.b32 %f1, %r5;
; CHECK-SM70-NEXT:    mov.b32 {%rs3, %rs4}, %r2;
; CHECK-SM70-NEXT:    cvt.u32.u16 %r6, %rs4;
; CHECK-SM70-NEXT:    shl.b32 %r7, %r6, 16;
; CHECK-SM70-NEXT:    mov.b32 %f2, %r7;
; CHECK-SM70-NEXT:    mov.b32 {%rs5, %rs6}, %r1;
; CHECK-SM70-NEXT:    cvt.u32.u16 %r8, %rs6;
; CHECK-SM70-NEXT:    shl.b32 %r9, %r8, 16;
; CHECK-SM70-NEXT:    mov.b32 %f3, %r9;
; CHECK-SM70-NEXT:    fma.rn.f32 %f4, %f3, %f2, %f1;
; CHECK-SM70-NEXT:    mov.b32 %r10, %f4;
; CHECK-SM70-NEXT:    bfe.u32 %r11, %r10, 16, 1;
; CHECK-SM70-NEXT:    add.s32 %r12, %r11, %r10;
; CHECK-SM70-NEXT:    add.s32 %r13, %r12, 32767;
; CHECK-SM70-NEXT:    setp.nan.f32 %p1, %f4, %f4;
; CHECK-SM70-NEXT:    or.b32 %r14, %r10, 4194304;
; CHECK-SM70-NEXT:    selp.b32 %r15, %r14, %r13, %p1;
; CHECK-SM70-NEXT:    cvt.u32.u16 %r16, %rs1;
; CHECK-SM70-NEXT:    shl.b32 %r17, %r16, 16;
; CHECK-SM70-NEXT:    mov.b32 %f5, %r17;
; CHECK-SM70-NEXT:    cvt.u32.u16 %r18, %rs3;
; CHECK-SM70-NEXT:    shl.b32 %r19, %r18, 16;
; CHECK-SM70-NEXT:    mov.b32 %f6, %r19;
; CHECK-SM70-NEXT:    cvt.u32.u16 %r20, %rs5;
; CHECK-SM70-NEXT:    shl.b32 %r21, %r20, 16;
; CHECK-SM70-NEXT:    mov.b32 %f7, %r21;
; CHECK-SM70-NEXT:    fma.rn.f32 %f8, %f7, %f6, %f5;
; CHECK-SM70-NEXT:    mov.b32 %r22, %f8;
; CHECK-SM70-NEXT:    bfe.u32 %r23, %r22, 16, 1;
; CHECK-SM70-NEXT:    add.s32 %r24, %r23, %r22;
; CHECK-SM70-NEXT:    add.s32 %r25, %r24, 32767;
; CHECK-SM70-NEXT:    setp.nan.f32 %p2, %f8, %f8;
; CHECK-SM70-NEXT:    or.b32 %r26, %r22, 4194304;
; CHECK-SM70-NEXT:    selp.b32 %r27, %r26, %r25, %p2;
; CHECK-SM70-NEXT:    and.b32 %r28, %r27, -65536;
; CHECK-SM70-NEXT:    mov.b32 %f9, %r28;
; CHECK-SM70-NEXT:    add.f32 %f10, %f9, 0f40E00000;
; CHECK-SM70-NEXT:    mov.b32 %r29, %f10;
; CHECK-SM70-NEXT:    bfe.u32 %r30, %r29, 16, 1;
; CHECK-SM70-NEXT:    add.s32 %r31, %r30, %r29;
; CHECK-SM70-NEXT:    add.s32 %r32, %r31, 32767;
; CHECK-SM70-NEXT:    setp.nan.f32 %p3, %f10, %f10;
; CHECK-SM70-NEXT:    or.b32 %r33, %r29, 4194304;
; CHECK-SM70-NEXT:    selp.b32 %r34, %r33, %r32, %p3;
; CHECK-SM70-NEXT:    and.b32 %r35, %r15, -65536;
; CHECK-SM70-NEXT:    mov.b32 %f11, %r35;
; CHECK-SM70-NEXT:    add.f32 %f12, %f11, 0f40E00000;
; CHECK-SM70-NEXT:    mov.b32 %r36, %f12;
; CHECK-SM70-NEXT:    bfe.u32 %r37, %r36, 16, 1;
; CHECK-SM70-NEXT:    add.s32 %r38, %r37, %r36;
; CHECK-SM70-NEXT:    add.s32 %r39, %r38, 32767;
; CHECK-SM70-NEXT:    setp.nan.f32 %p4, %f12, %f12;
; CHECK-SM70-NEXT:    or.b32 %r40, %r36, 4194304;
; CHECK-SM70-NEXT:    selp.b32 %r41, %r40, %r39, %p4;
; CHECK-SM70-NEXT:    and.b32 %r42, %r41, -65536;
; CHECK-SM70-NEXT:    mov.b32 %f13, %r42;
; CHECK-SM70-NEXT:    add.f32 %f14, %f13, %f11;
; CHECK-SM70-NEXT:    mov.b32 %r43, %f14;
; CHECK-SM70-NEXT:    bfe.u32 %r44, %r43, 16, 1;
; CHECK-SM70-NEXT:    add.s32 %r45, %r44, %r43;
; CHECK-SM70-NEXT:    add.s32 %r46, %r45, 32767;
; CHECK-SM70-NEXT:    setp.nan.f32 %p5, %f14, %f14;
; CHECK-SM70-NEXT:    or.b32 %r47, %r43, 4194304;
; CHECK-SM70-NEXT:    selp.b32 %r48, %r47, %r46, %p5;
; CHECK-SM70-NEXT:    and.b32 %r49, %r34, -65536;
; CHECK-SM70-NEXT:    mov.b32 %f15, %r49;
; CHECK-SM70-NEXT:    add.f32 %f16, %f15, %f9;
; CHECK-SM70-NEXT:    mov.b32 %r50, %f16;
; CHECK-SM70-NEXT:    bfe.u32 %r51, %r50, 16, 1;
; CHECK-SM70-NEXT:    add.s32 %r52, %r51, %r50;
; CHECK-SM70-NEXT:    add.s32 %r53, %r52, 32767;
; CHECK-SM70-NEXT:    setp.nan.f32 %p6, %f16, %f16;
; CHECK-SM70-NEXT:    or.b32 %r54, %r50, 4194304;
; CHECK-SM70-NEXT:    selp.b32 %r55, %r54, %r53, %p6;
; CHECK-SM70-NEXT:    prmt.b32 %r56, %r55, %r48, 0x7632U;
; CHECK-SM70-NEXT:    st.param.b32 [func_retval0], %r56;
; CHECK-SM70-NEXT:    ret;
  %1 = call <2 x bfloat> @llvm.fma.bf16x2(<2 x bfloat> %a, <2 x bfloat> %b, <2 x bfloat> %c)
  %2 = fcmp ogt <2 x bfloat> %1, <bfloat 0.0, bfloat 0.0>
  %3 = select <2 x i1> %2, <2 x bfloat> %1, <2 x bfloat> <bfloat 0.0, bfloat 0.0>
  %4 = fadd <2 x bfloat> %1, <bfloat 7.0, bfloat 7.0>
  %5 = fadd <2 x bfloat> %4, %1
  ret <2 x bfloat> %5
}

define <2 x bfloat> @fma_bf16x2_maxnum_no_nans(<2 x bfloat> %a, <2 x bfloat> %b, <2 x bfloat> %c) #0 {
; CHECK-LABEL: fma_bf16x2_maxnum_no_nans(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [fma_bf16x2_maxnum_no_nans_param_2];
; CHECK-NEXT:    ld.param.b32 %r2, [fma_bf16x2_maxnum_no_nans_param_1];
; CHECK-NEXT:    ld.param.b32 %r3, [fma_bf16x2_maxnum_no_nans_param_0];
; CHECK-NEXT:    fma.rn.relu.bf16x2 %r4, %r3, %r2, %r1;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r4;
; CHECK-NEXT:    ret;
;
; CHECK-FTZ-LABEL: fma_bf16x2_maxnum_no_nans(
; CHECK-FTZ:       {
; CHECK-FTZ-NEXT:    .reg .b32 %r<5>;
; CHECK-FTZ-EMPTY:
; CHECK-FTZ-NEXT:  // %bb.0:
; CHECK-FTZ-NEXT:    ld.param.b32 %r1, [fma_bf16x2_maxnum_no_nans_param_2];
; CHECK-FTZ-NEXT:    ld.param.b32 %r2, [fma_bf16x2_maxnum_no_nans_param_1];
; CHECK-FTZ-NEXT:    ld.param.b32 %r3, [fma_bf16x2_maxnum_no_nans_param_0];
; CHECK-FTZ-NEXT:    fma.rn.relu.bf16x2 %r4, %r3, %r2, %r1;
; CHECK-FTZ-NEXT:    st.param.b32 [func_retval0], %r4;
; CHECK-FTZ-NEXT:    ret;
;
; CHECK-SM70-LABEL: fma_bf16x2_maxnum_no_nans(
; CHECK-SM70:       {
; CHECK-SM70-NEXT:    .reg .pred %p<5>;
; CHECK-SM70-NEXT:    .reg .b16 %rs<7>;
; CHECK-SM70-NEXT:    .reg .b32 %r<43>;
; CHECK-SM70-NEXT:    .reg .f32 %f<13>;
; CHECK-SM70-EMPTY:
; CHECK-SM70-NEXT:  // %bb.0:
; CHECK-SM70-NEXT:    ld.param.b32 %r1, [fma_bf16x2_maxnum_no_nans_param_0];
; CHECK-SM70-NEXT:    ld.param.b32 %r2, [fma_bf16x2_maxnum_no_nans_param_1];
; CHECK-SM70-NEXT:    ld.param.b32 %r3, [fma_bf16x2_maxnum_no_nans_param_2];
; CHECK-SM70-NEXT:    mov.b32 {%rs1, %rs2}, %r3;
; CHECK-SM70-NEXT:    cvt.u32.u16 %r4, %rs1;
; CHECK-SM70-NEXT:    shl.b32 %r5, %r4, 16;
; CHECK-SM70-NEXT:    mov.b32 %f1, %r5;
; CHECK-SM70-NEXT:    mov.b32 {%rs3, %rs4}, %r2;
; CHECK-SM70-NEXT:    cvt.u32.u16 %r6, %rs3;
; CHECK-SM70-NEXT:    shl.b32 %r7, %r6, 16;
; CHECK-SM70-NEXT:    mov.b32 %f2, %r7;
; CHECK-SM70-NEXT:    mov.b32 {%rs5, %rs6}, %r1;
; CHECK-SM70-NEXT:    cvt.u32.u16 %r8, %rs5;
; CHECK-SM70-NEXT:    shl.b32 %r9, %r8, 16;
; CHECK-SM70-NEXT:    mov.b32 %f3, %r9;
; CHECK-SM70-NEXT:    fma.rn.f32 %f4, %f3, %f2, %f1;
; CHECK-SM70-NEXT:    mov.b32 %r10, %f4;
; CHECK-SM70-NEXT:    bfe.u32 %r11, %r10, 16, 1;
; CHECK-SM70-NEXT:    add.s32 %r12, %r11, %r10;
; CHECK-SM70-NEXT:    add.s32 %r13, %r12, 32767;
; CHECK-SM70-NEXT:    setp.nan.f32 %p1, %f4, %f4;
; CHECK-SM70-NEXT:    or.b32 %r14, %r10, 4194304;
; CHECK-SM70-NEXT:    selp.b32 %r15, %r14, %r13, %p1;
; CHECK-SM70-NEXT:    cvt.u32.u16 %r16, %rs2;
; CHECK-SM70-NEXT:    shl.b32 %r17, %r16, 16;
; CHECK-SM70-NEXT:    mov.b32 %f5, %r17;
; CHECK-SM70-NEXT:    cvt.u32.u16 %r18, %rs4;
; CHECK-SM70-NEXT:    shl.b32 %r19, %r18, 16;
; CHECK-SM70-NEXT:    mov.b32 %f6, %r19;
; CHECK-SM70-NEXT:    cvt.u32.u16 %r20, %rs6;
; CHECK-SM70-NEXT:    shl.b32 %r21, %r20, 16;
; CHECK-SM70-NEXT:    mov.b32 %f7, %r21;
; CHECK-SM70-NEXT:    fma.rn.f32 %f8, %f7, %f6, %f5;
; CHECK-SM70-NEXT:    mov.b32 %r22, %f8;
; CHECK-SM70-NEXT:    bfe.u32 %r23, %r22, 16, 1;
; CHECK-SM70-NEXT:    add.s32 %r24, %r23, %r22;
; CHECK-SM70-NEXT:    add.s32 %r25, %r24, 32767;
; CHECK-SM70-NEXT:    setp.nan.f32 %p2, %f8, %f8;
; CHECK-SM70-NEXT:    or.b32 %r26, %r22, 4194304;
; CHECK-SM70-NEXT:    selp.b32 %r27, %r26, %r25, %p2;
; CHECK-SM70-NEXT:    and.b32 %r28, %r27, -65536;
; CHECK-SM70-NEXT:    mov.b32 %f9, %r28;
; CHECK-SM70-NEXT:    max.f32 %f10, %f9, 0f00000000;
; CHECK-SM70-NEXT:    mov.b32 %r29, %f10;
; CHECK-SM70-NEXT:    bfe.u32 %r30, %r29, 16, 1;
; CHECK-SM70-NEXT:    add.s32 %r31, %r30, %r29;
; CHECK-SM70-NEXT:    add.s32 %r32, %r31, 32767;
; CHECK-SM70-NEXT:    setp.nan.f32 %p3, %f10, %f10;
; CHECK-SM70-NEXT:    or.b32 %r33, %r29, 4194304;
; CHECK-SM70-NEXT:    selp.b32 %r34, %r33, %r32, %p3;
; CHECK-SM70-NEXT:    and.b32 %r35, %r15, -65536;
; CHECK-SM70-NEXT:    mov.b32 %f11, %r35;
; CHECK-SM70-NEXT:    max.f32 %f12, %f11, 0f00000000;
; CHECK-SM70-NEXT:    mov.b32 %r36, %f12;
; CHECK-SM70-NEXT:    bfe.u32 %r37, %r36, 16, 1;
; CHECK-SM70-NEXT:    add.s32 %r38, %r37, %r36;
; CHECK-SM70-NEXT:    add.s32 %r39, %r38, 32767;
; CHECK-SM70-NEXT:    setp.nan.f32 %p4, %f12, %f12;
; CHECK-SM70-NEXT:    or.b32 %r40, %r36, 4194304;
; CHECK-SM70-NEXT:    selp.b32 %r41, %r40, %r39, %p4;
; CHECK-SM70-NEXT:    prmt.b32 %r42, %r41, %r34, 0x7632U;
; CHECK-SM70-NEXT:    st.param.b32 [func_retval0], %r42;
; CHECK-SM70-NEXT:    ret;
  %1 = call <2 x bfloat> @llvm.fma.bf16x2(<2 x bfloat> %a, <2 x bfloat> %b, <2 x bfloat> %c)
  %2 = call <2 x bfloat> @llvm.maxnum.bf16x2(<2 x bfloat> %1, <2 x bfloat> <bfloat 0.0, bfloat 0.0>)
  ret <2 x bfloat> %2
}

attributes #0 = { "no-nans-fp-math"="true" "no-signed-zeros-fp-math"="true" "unsafe-fp-math"="true" }
attributes #1 = { "unsafe-fp-math"="true" }
