; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=tahiti < %s | FileCheck -check-prefixes=GCN,GFX6,GFX6-SDAG %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=tonga < %s | FileCheck -check-prefixes=GCN,GFX8,GFX8-SDAG %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx900 < %s | FileCheck -check-prefixes=GCN,GFX9,GFX9-SDAG %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1100 < %s | FileCheck -check-prefixes=GCN,GFX11,GFX11-SDAG %s

; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=tahiti < %s | FileCheck -check-prefixes=GCN,GFX6,GFX6-GISEL %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=tonga < %s | FileCheck -check-prefixes=GCN,GFX8,GFX8-GISEL %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx900 < %s | FileCheck -check-prefixes=GCN,GFX9,GFX9-GISEL %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1100 < %s | FileCheck -check-prefixes=GCN,GFX11,GFX11-GISEL %s

; define float @test_ldexp_f32_i16(ptr addrspace(1) %out, float %a, i16 %b) #0 {
;   %result = call float @llvm.experimental.constrained.ldexp.f32.i16(float %a, i16 %b, metadata !"round.dynamic", metadata !"fpexcept.strict")
;   ret float %result
; }

define float @test_ldexp_f32_i32(ptr addrspace(1) %out, float %a, i32 %b) #0 {
; GFX6-LABEL: test_ldexp_f32_i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v2, v3
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_ldexp_f32_i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_ldexp_f32 v0, v2, v3
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_ldexp_f32_i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_ldexp_f32 v0, v2, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_ldexp_f32_i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_ldexp_f32 v0, v2, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %result = call float @llvm.experimental.constrained.ldexp.f32.i32(float %a, i32 %b, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret float %result
}

; define <2 x float> @test_ldexp_v2f32_v2i16(ptr addrspace(1) %out, <2 x float> %a, <2 x i16> %b) #0 {
;   %result = call <2 x float> @llvm.experimental.constrained.ldexp.v2f32.v2i16(<2 x float> %a, <2 x i16> %b, metadata !"round.dynamic", metadata !"fpexcept.strict")
;   ret <2 x float> %result
; }

define <2 x float> @test_ldexp_v2f32_v2i32(ptr addrspace(1) %out, <2 x float> %a, <2 x i32> %b) #0 {
; GFX6-SDAG-LABEL: test_ldexp_v2f32_v2i32:
; GFX6-SDAG:       ; %bb.0:
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    v_ldexp_f32_e32 v1, v3, v5
; GFX6-SDAG-NEXT:    v_ldexp_f32_e32 v0, v2, v4
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_ldexp_v2f32_v2i32:
; GFX8-SDAG:       ; %bb.0:
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_ldexp_f32 v1, v3, v5
; GFX8-SDAG-NEXT:    v_ldexp_f32 v0, v2, v4
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_ldexp_v2f32_v2i32:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f32 v1, v3, v5
; GFX9-SDAG-NEXT:    v_ldexp_f32 v0, v2, v4
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_ldexp_v2f32_v2i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_ldexp_f32 v0, v2, v4
; GFX11-NEXT:    v_ldexp_f32 v1, v3, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-GISEL-LABEL: test_ldexp_v2f32_v2i32:
; GFX6-GISEL:       ; %bb.0:
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-GISEL-NEXT:    v_ldexp_f32_e32 v0, v2, v4
; GFX6-GISEL-NEXT:    v_ldexp_f32_e32 v1, v3, v5
; GFX6-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_ldexp_v2f32_v2i32:
; GFX8-GISEL:       ; %bb.0:
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_ldexp_f32 v0, v2, v4
; GFX8-GISEL-NEXT:    v_ldexp_f32 v1, v3, v5
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_ldexp_v2f32_v2i32:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_ldexp_f32 v0, v2, v4
; GFX9-GISEL-NEXT:    v_ldexp_f32 v1, v3, v5
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %result = call <2 x float> @llvm.experimental.constrained.ldexp.v2f32.v2i32(<2 x float> %a, <2 x i32> %b, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <2 x float> %result
}

define <3 x float> @test_ldexp_v3f32_v3i32(ptr addrspace(1) %out, <3 x float> %a, <3 x i32> %b) #0 {
; GFX6-SDAG-LABEL: test_ldexp_v3f32_v3i32:
; GFX6-SDAG:       ; %bb.0:
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    v_ldexp_f32_e32 v4, v4, v7
; GFX6-SDAG-NEXT:    v_ldexp_f32_e32 v1, v3, v6
; GFX6-SDAG-NEXT:    v_ldexp_f32_e32 v0, v2, v5
; GFX6-SDAG-NEXT:    v_mov_b32_e32 v2, v4
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_ldexp_v3f32_v3i32:
; GFX8-SDAG:       ; %bb.0:
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_ldexp_f32 v4, v4, v7
; GFX8-SDAG-NEXT:    v_ldexp_f32 v1, v3, v6
; GFX8-SDAG-NEXT:    v_ldexp_f32 v0, v2, v5
; GFX8-SDAG-NEXT:    v_mov_b32_e32 v2, v4
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_ldexp_v3f32_v3i32:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f32 v4, v4, v7
; GFX9-SDAG-NEXT:    v_ldexp_f32 v1, v3, v6
; GFX9-SDAG-NEXT:    v_ldexp_f32 v0, v2, v5
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v2, v4
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_ldexp_v3f32_v3i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_ldexp_f32 v0, v2, v5
; GFX11-NEXT:    v_ldexp_f32 v1, v3, v6
; GFX11-NEXT:    v_ldexp_f32 v2, v4, v7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-GISEL-LABEL: test_ldexp_v3f32_v3i32:
; GFX6-GISEL:       ; %bb.0:
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-GISEL-NEXT:    v_ldexp_f32_e32 v0, v2, v5
; GFX6-GISEL-NEXT:    v_ldexp_f32_e32 v1, v3, v6
; GFX6-GISEL-NEXT:    v_ldexp_f32_e32 v2, v4, v7
; GFX6-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_ldexp_v3f32_v3i32:
; GFX8-GISEL:       ; %bb.0:
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_ldexp_f32 v0, v2, v5
; GFX8-GISEL-NEXT:    v_ldexp_f32 v1, v3, v6
; GFX8-GISEL-NEXT:    v_ldexp_f32 v2, v4, v7
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_ldexp_v3f32_v3i32:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_ldexp_f32 v0, v2, v5
; GFX9-GISEL-NEXT:    v_ldexp_f32 v1, v3, v6
; GFX9-GISEL-NEXT:    v_ldexp_f32 v2, v4, v7
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %result = call <3 x float> @llvm.experimental.constrained.ldexp.v3f32.v3i32(<3 x float> %a, <3 x i32> %b, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <3 x float> %result
}

define <4 x float> @test_ldexp_v4f32_v4i32(ptr addrspace(1) %out, <4 x float> %a, <4 x i32> %b) #0 {
; GFX6-SDAG-LABEL: test_ldexp_v4f32_v4i32:
; GFX6-SDAG:       ; %bb.0:
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    v_ldexp_f32_e32 v5, v5, v9
; GFX6-SDAG-NEXT:    v_ldexp_f32_e32 v4, v4, v8
; GFX6-SDAG-NEXT:    v_ldexp_f32_e32 v1, v3, v7
; GFX6-SDAG-NEXT:    v_ldexp_f32_e32 v0, v2, v6
; GFX6-SDAG-NEXT:    v_mov_b32_e32 v2, v4
; GFX6-SDAG-NEXT:    v_mov_b32_e32 v3, v5
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_ldexp_v4f32_v4i32:
; GFX8-SDAG:       ; %bb.0:
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_ldexp_f32 v5, v5, v9
; GFX8-SDAG-NEXT:    v_ldexp_f32 v4, v4, v8
; GFX8-SDAG-NEXT:    v_ldexp_f32 v1, v3, v7
; GFX8-SDAG-NEXT:    v_ldexp_f32 v0, v2, v6
; GFX8-SDAG-NEXT:    v_mov_b32_e32 v2, v4
; GFX8-SDAG-NEXT:    v_mov_b32_e32 v3, v5
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_ldexp_v4f32_v4i32:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f32 v5, v5, v9
; GFX9-SDAG-NEXT:    v_ldexp_f32 v4, v4, v8
; GFX9-SDAG-NEXT:    v_ldexp_f32 v1, v3, v7
; GFX9-SDAG-NEXT:    v_ldexp_f32 v0, v2, v6
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v2, v4
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v3, v5
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_ldexp_v4f32_v4i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_ldexp_f32 v0, v2, v6
; GFX11-NEXT:    v_ldexp_f32 v1, v3, v7
; GFX11-NEXT:    v_ldexp_f32 v2, v4, v8
; GFX11-NEXT:    v_ldexp_f32 v3, v5, v9
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-GISEL-LABEL: test_ldexp_v4f32_v4i32:
; GFX6-GISEL:       ; %bb.0:
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-GISEL-NEXT:    v_ldexp_f32_e32 v0, v2, v6
; GFX6-GISEL-NEXT:    v_ldexp_f32_e32 v1, v3, v7
; GFX6-GISEL-NEXT:    v_ldexp_f32_e32 v2, v4, v8
; GFX6-GISEL-NEXT:    v_ldexp_f32_e32 v3, v5, v9
; GFX6-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_ldexp_v4f32_v4i32:
; GFX8-GISEL:       ; %bb.0:
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_ldexp_f32 v0, v2, v6
; GFX8-GISEL-NEXT:    v_ldexp_f32 v1, v3, v7
; GFX8-GISEL-NEXT:    v_ldexp_f32 v2, v4, v8
; GFX8-GISEL-NEXT:    v_ldexp_f32 v3, v5, v9
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_ldexp_v4f32_v4i32:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_ldexp_f32 v0, v2, v6
; GFX9-GISEL-NEXT:    v_ldexp_f32 v1, v3, v7
; GFX9-GISEL-NEXT:    v_ldexp_f32 v2, v4, v8
; GFX9-GISEL-NEXT:    v_ldexp_f32 v3, v5, v9
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %result = call <4 x float> @llvm.experimental.constrained.ldexp.v4f32.v4i32(<4 x float> %a, <4 x i32> %b, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <4 x float> %result
}

declare float @llvm.experimental.constrained.ldexp.f32.i16(float, i16, metadata, metadata) #1
declare float @llvm.experimental.constrained.ldexp.f32.i32(float, i32, metadata, metadata) #1
declare <2 x float> @llvm.experimental.constrained.ldexp.v2f32.v2i16(<2 x float>, <2 x i16>, metadata, metadata) #1
declare <2 x float> @llvm.experimental.constrained.ldexp.v2f32.v2i32(<2 x float>, <2 x i32>, metadata, metadata) #1
declare <3 x float> @llvm.experimental.constrained.ldexp.v3f32.v3i32(<3 x float>, <3 x i32>, metadata, metadata) #1
declare <4 x float> @llvm.experimental.constrained.ldexp.v4f32.v4i32(<4 x float>, <4 x i32>, metadata, metadata) #1

attributes #0 = { strictfp }
attributes #1 = { nocallback nofree nosync nounwind willreturn memory(inaccessiblemem: readwrite) }
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GCN: {{.*}}
; GFX11-GISEL: {{.*}}
; GFX11-SDAG: {{.*}}
