; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple aarch64-unknown-unknown | FileCheck %s --check-prefixes=CHECK,CHECK-CVT
; RUN: llc < %s -mtriple aarch64-unknown-unknown -mattr=+bf16 | FileCheck %s --check-prefixes=CHECK,CHECK-BF16,CHECK-SD
; RUN: llc < %s -mtriple aarch64-unknown-unknown -mattr=+bf16,+fullfp16 -global-isel -global-isel-abort=2 2>&1 | FileCheck %s --check-prefixes=CHECK,CHECK-BF16,CHECK-GI

; CHECK-GI:       warning: Instruction selection used fallback path for test_fadd
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_fsub
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_fmul
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_fmadd
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_fdiv
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_frem
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_call
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_call_flipped
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_tailcall_flipped
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_select_cc
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_select_cc_f32_f16
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_fcmp_une
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_fcmp_ueq
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_fcmp_ugt
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_fcmp_uge
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_fcmp_ult
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_fcmp_ule
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_fcmp_uno
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_fcmp_one
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_fcmp_oeq
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_fcmp_ogt
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_fcmp_oge
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_fcmp_olt
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_fcmp_ole
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_fcmp_ord
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_fccmp
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_br_cc
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_fptosi_i32
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_fptosi_i64
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_fptoui_i32
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_fptoui_i64
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_uitofp_i32
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_uitofp_i64
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_sitofp_i32
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_sitofp_i64
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_uitofp_i32_fadd
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_sitofp_i32_fadd
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_fptrunc_float
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_fptrunc_double
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_fpext_float
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_fpext_double
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_sqrt
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_powi
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_sin
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_cos
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_tan
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_acos
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_asin
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_atan
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_atan2
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_cosh
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_sinh
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_tanh
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_pow
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_exp
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_exp2
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_log
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_log10
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_log2
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_fma
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_fabs
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_minnum
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_maxnum
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_copysign
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_copysign_f32
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_copysign_f64
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_copysign_extended
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_floor
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_ceil
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_trunc
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_rint
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_nearbyint
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_round
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_roundeven
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for test_fmuladd

define bfloat @test_fadd(bfloat %a, bfloat %b) #0 {
; CHECK-CVT-LABEL: test_fadd:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    fadd s0, s0, s1
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_fadd:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    fadd s0, s0, s1
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ret
  %r = fadd bfloat %a, %b
  ret bfloat %r
}

define bfloat @test_fsub(bfloat %a, bfloat %b) #0 {
; CHECK-CVT-LABEL: test_fsub:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    fsub s0, s0, s1
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_fsub:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    fsub s0, s0, s1
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ret
  %r = fsub bfloat %a, %b
  ret bfloat %r
}

define bfloat @test_fmul(bfloat %a, bfloat %b) #0 {
; CHECK-CVT-LABEL: test_fmul:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    fmul s0, s0, s1
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_fmul:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    fmul s0, s0, s1
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ret
  %r = fmul bfloat %a, %b
  ret bfloat %r
}

define bfloat @test_fmadd(bfloat %a, bfloat %b, bfloat %c) #0 {
; CHECK-CVT-LABEL: test_fmadd:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    mov w10, #32767 // =0x7fff
; CHECK-CVT-NEXT:    // kill: def $h2 killed $h2 def $d2
; CHECK-CVT-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    fmul s0, s0, s1
; CHECK-CVT-NEXT:    shll v1.4s, v2.4h, #16
; CHECK-CVT-NEXT:    fmov w8, s0
; CHECK-CVT-NEXT:    ubfx w9, w8, #16, #1
; CHECK-CVT-NEXT:    add w8, w8, w10
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    fadd s0, s0, s1
; CHECK-CVT-NEXT:    fmov w8, s0
; CHECK-CVT-NEXT:    ubfx w9, w8, #16, #1
; CHECK-CVT-NEXT:    add w8, w8, w10
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_fmadd:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    // kill: def $h2 killed $h2 def $d2
; CHECK-BF16-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    fmul s0, s0, s1
; CHECK-BF16-NEXT:    shll v1.4s, v2.4h, #16
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    fadd s0, s0, s1
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ret
  %mul = fmul fast bfloat %a, %b
  %r = fadd fast bfloat %mul, %c
  ret bfloat %r
}

define bfloat @test_fdiv(bfloat %a, bfloat %b) #0 {
; CHECK-CVT-LABEL: test_fdiv:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    fdiv s0, s0, s1
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_fdiv:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    fdiv s0, s0, s1
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ret
  %r = fdiv bfloat %a, %b
  ret bfloat %r
}

define bfloat @test_frem(bfloat %a, bfloat %b) #0 {
; CHECK-CVT-LABEL: test_frem:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-CVT-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-CVT-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-CVT-NEXT:    // kill: def $s1 killed $s1 killed $q1
; CHECK-CVT-NEXT:    bl fmodf
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_frem:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-BF16-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-BF16-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-BF16-NEXT:    // kill: def $s1 killed $s1 killed $q1
; CHECK-BF16-NEXT:    bl fmodf
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-BF16-NEXT:    ret
  %r = frem bfloat %a, %b
  ret bfloat %r
}

define void @test_store(bfloat %a, ptr %b) #0 {
; CHECK-LABEL: test_store:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str h0, [x0]
; CHECK-NEXT:    ret
  store bfloat %a, ptr %b
  ret void
}

define bfloat @test_load(ptr %a) #0 {
; CHECK-LABEL: test_load:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr h0, [x0]
; CHECK-NEXT:    ret
  %r = load bfloat, ptr %a
  ret bfloat %r
}

declare bfloat @test_callee(bfloat %a, bfloat %b) #0

define bfloat @test_call(bfloat %a, bfloat %b) #0 {
; CHECK-LABEL: test_call:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    bl test_callee
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %r = call bfloat @test_callee(bfloat %a, bfloat %b)
  ret bfloat %r
}

define bfloat @test_call_flipped(bfloat %a, bfloat %b) #0 {
; CHECK-LABEL: test_call_flipped:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    fmov s2, s0
; CHECK-NEXT:    fmov s0, s1
; CHECK-NEXT:    fmov s1, s2
; CHECK-NEXT:    bl test_callee
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %r = call bfloat @test_callee(bfloat %b, bfloat %a)
  ret bfloat %r
}

define bfloat @test_tailcall_flipped(bfloat %a, bfloat %b) #0 {
; CHECK-LABEL: test_tailcall_flipped:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmov s2, s0
; CHECK-NEXT:    fmov s0, s1
; CHECK-NEXT:    fmov s1, s2
; CHECK-NEXT:    b test_callee
  %r = tail call bfloat @test_callee(bfloat %b, bfloat %a)
  ret bfloat %r
}

define bfloat @test_select(bfloat %a, bfloat %b, i1 zeroext %c) #0 {
; CHECK-CVT-LABEL: test_select:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $s0
; CHECK-CVT-NEXT:    cmp w0, #0
; CHECK-CVT-NEXT:    // kill: def $h1 killed $h1 def $s1
; CHECK-CVT-NEXT:    fcsel s0, s0, s1, ne
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-SD-LABEL: test_select:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    // kill: def $h0 killed $h0 def $s0
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    // kill: def $h1 killed $h1 def $s1
; CHECK-SD-NEXT:    fcsel s0, s0, s1, ne
; CHECK-SD-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_select:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    // kill: def $h0 killed $h0 def $s0
; CHECK-GI-NEXT:    // kill: def $h1 killed $h1 def $s1
; CHECK-GI-NEXT:    fmov w8, s0
; CHECK-GI-NEXT:    fmov w9, s1
; CHECK-GI-NEXT:    tst w0, #0x1
; CHECK-GI-NEXT:    csel w8, w8, w9, ne
; CHECK-GI-NEXT:    fmov s0, w8
; CHECK-GI-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-GI-NEXT:    ret
  %r = select i1 %c, bfloat %a, bfloat %b
  ret bfloat %r
}

define bfloat @test_select_cc(bfloat %a, bfloat %b, bfloat %c, bfloat %d) #0 {
; CHECK-CVT-LABEL: test_select_cc:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    // kill: def $h3 killed $h3 def $d3
; CHECK-CVT-NEXT:    // kill: def $h2 killed $h2 def $d2
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $s0
; CHECK-CVT-NEXT:    // kill: def $h1 killed $h1 def $s1
; CHECK-CVT-NEXT:    shll v3.4s, v3.4h, #16
; CHECK-CVT-NEXT:    shll v2.4s, v2.4h, #16
; CHECK-CVT-NEXT:    fcmp s2, s3
; CHECK-CVT-NEXT:    fcsel s0, s0, s1, ne
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-SD-LABEL: test_select_cc:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    // kill: def $h3 killed $h3 def $d3
; CHECK-SD-NEXT:    // kill: def $h2 killed $h2 def $d2
; CHECK-SD-NEXT:    // kill: def $h0 killed $h0 def $s0
; CHECK-SD-NEXT:    // kill: def $h1 killed $h1 def $s1
; CHECK-SD-NEXT:    shll v3.4s, v3.4h, #16
; CHECK-SD-NEXT:    shll v2.4s, v2.4h, #16
; CHECK-SD-NEXT:    fcmp s2, s3
; CHECK-SD-NEXT:    fcsel s0, s0, s1, ne
; CHECK-SD-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_select_cc:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    // kill: def $h3 killed $h3 def $d3
; CHECK-GI-NEXT:    // kill: def $h2 killed $h2 def $d2
; CHECK-GI-NEXT:    shll v3.4s, v3.4h, #16
; CHECK-GI-NEXT:    shll v2.4s, v2.4h, #16
; CHECK-GI-NEXT:    fcmp s2, s3
; CHECK-GI-NEXT:    fcsel h0, h0, h1, ne
; CHECK-GI-NEXT:    ret
  %cc = fcmp une bfloat %c, %d
  %r = select i1 %cc, bfloat %a, bfloat %b
  ret bfloat %r
}

define float @test_select_cc_f32_f16(float %a, float %b, bfloat %c, bfloat %d) #0 {
; CHECK-LABEL: test_select_cc_f32_f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $h3 killed $h3 def $d3
; CHECK-NEXT:    // kill: def $h2 killed $h2 def $d2
; CHECK-NEXT:    shll v3.4s, v3.4h, #16
; CHECK-NEXT:    shll v2.4s, v2.4h, #16
; CHECK-NEXT:    fcmp s2, s3
; CHECK-NEXT:    fcsel s0, s0, s1, ne
; CHECK-NEXT:    ret
  %cc = fcmp une bfloat %c, %d
  %r = select i1 %cc, float %a, float %b
  ret float %r
}

define bfloat @test_select_cc_f16_f32(bfloat %a, bfloat %b, float %c, float %d) #0 {
; CHECK-CVT-LABEL: test_select_cc_f16_f32:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fcmp s2, s3
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $s0
; CHECK-CVT-NEXT:    // kill: def $h1 killed $h1 def $s1
; CHECK-CVT-NEXT:    fcsel s0, s0, s1, ne
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-SD-LABEL: test_select_cc_f16_f32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmp s2, s3
; CHECK-SD-NEXT:    // kill: def $h0 killed $h0 def $s0
; CHECK-SD-NEXT:    // kill: def $h1 killed $h1 def $s1
; CHECK-SD-NEXT:    fcsel s0, s0, s1, ne
; CHECK-SD-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_select_cc_f16_f32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    // kill: def $h0 killed $h0 def $s0
; CHECK-GI-NEXT:    // kill: def $h1 killed $h1 def $s1
; CHECK-GI-NEXT:    fcmp s2, s3
; CHECK-GI-NEXT:    fmov w8, s0
; CHECK-GI-NEXT:    fmov w9, s1
; CHECK-GI-NEXT:    csel w8, w8, w9, ne
; CHECK-GI-NEXT:    fmov s0, w8
; CHECK-GI-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-GI-NEXT:    ret
  %cc = fcmp une float %c, %d
  %r = select i1 %cc, bfloat %a, bfloat %b
  ret bfloat %r
}

define i1 @test_fcmp_une(bfloat %a, bfloat %b) #0 {
; CHECK-LABEL: test_fcmp_une:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    fcmp s0, s1
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ret
  %r = fcmp une bfloat %a, %b
  ret i1 %r
}

define i1 @test_fcmp_ueq(bfloat %a, bfloat %b) #0 {
; CHECK-LABEL: test_fcmp_ueq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    fcmp s0, s1
; CHECK-NEXT:    cset w8, eq
; CHECK-NEXT:    csinc w0, w8, wzr, vc
; CHECK-NEXT:    ret
  %r = fcmp ueq bfloat %a, %b
  ret i1 %r
}

define i1 @test_fcmp_ugt(bfloat %a, bfloat %b) #0 {
; CHECK-LABEL: test_fcmp_ugt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    fcmp s0, s1
; CHECK-NEXT:    cset w0, hi
; CHECK-NEXT:    ret
  %r = fcmp ugt bfloat %a, %b
  ret i1 %r
}

define i1 @test_fcmp_uge(bfloat %a, bfloat %b) #0 {
; CHECK-LABEL: test_fcmp_uge:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    fcmp s0, s1
; CHECK-NEXT:    cset w0, pl
; CHECK-NEXT:    ret
  %r = fcmp uge bfloat %a, %b
  ret i1 %r
}

define i1 @test_fcmp_ult(bfloat %a, bfloat %b) #0 {
; CHECK-LABEL: test_fcmp_ult:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    fcmp s0, s1
; CHECK-NEXT:    cset w0, lt
; CHECK-NEXT:    ret
  %r = fcmp ult bfloat %a, %b
  ret i1 %r
}

define i1 @test_fcmp_ule(bfloat %a, bfloat %b) #0 {
; CHECK-LABEL: test_fcmp_ule:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    fcmp s0, s1
; CHECK-NEXT:    cset w0, le
; CHECK-NEXT:    ret
  %r = fcmp ule bfloat %a, %b
  ret i1 %r
}

define i1 @test_fcmp_uno(bfloat %a, bfloat %b) #0 {
; CHECK-LABEL: test_fcmp_uno:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    fcmp s0, s1
; CHECK-NEXT:    cset w0, vs
; CHECK-NEXT:    ret
  %r = fcmp uno bfloat %a, %b
  ret i1 %r
}

define i1 @test_fcmp_one(bfloat %a, bfloat %b) #0 {
; CHECK-LABEL: test_fcmp_one:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    fcmp s0, s1
; CHECK-NEXT:    cset w8, mi
; CHECK-NEXT:    csinc w0, w8, wzr, le
; CHECK-NEXT:    ret
  %r = fcmp one bfloat %a, %b
  ret i1 %r
}

define i1 @test_fcmp_oeq(bfloat %a, bfloat %b) #0 {
; CHECK-LABEL: test_fcmp_oeq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    fcmp s0, s1
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
  %r = fcmp oeq bfloat %a, %b
  ret i1 %r
}

define i1 @test_fcmp_ogt(bfloat %a, bfloat %b) #0 {
; CHECK-LABEL: test_fcmp_ogt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    fcmp s0, s1
; CHECK-NEXT:    cset w0, gt
; CHECK-NEXT:    ret
  %r = fcmp ogt bfloat %a, %b
  ret i1 %r
}

define i1 @test_fcmp_oge(bfloat %a, bfloat %b) #0 {
; CHECK-LABEL: test_fcmp_oge:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    fcmp s0, s1
; CHECK-NEXT:    cset w0, ge
; CHECK-NEXT:    ret
  %r = fcmp oge bfloat %a, %b
  ret i1 %r
}

define i1 @test_fcmp_olt(bfloat %a, bfloat %b) #0 {
; CHECK-LABEL: test_fcmp_olt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    fcmp s0, s1
; CHECK-NEXT:    cset w0, mi
; CHECK-NEXT:    ret
  %r = fcmp olt bfloat %a, %b
  ret i1 %r
}

define i1 @test_fcmp_ole(bfloat %a, bfloat %b) #0 {
; CHECK-LABEL: test_fcmp_ole:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    fcmp s0, s1
; CHECK-NEXT:    cset w0, ls
; CHECK-NEXT:    ret
  %r = fcmp ole bfloat %a, %b
  ret i1 %r
}

define i1 @test_fcmp_ord(bfloat %a, bfloat %b) #0 {
; CHECK-LABEL: test_fcmp_ord:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    fcmp s0, s1
; CHECK-NEXT:    cset w0, vc
; CHECK-NEXT:    ret
  %r = fcmp ord bfloat %a, %b
  ret i1 %r
}

define void @test_fccmp(bfloat %in, ptr %out) {
; CHECK-CVT-LABEL: test_fccmp:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    movi v1.2s, #69, lsl #24
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    shll v2.4s, v0.4h, #16
; CHECK-CVT-NEXT:    adrp x8, .LCPI29_0
; CHECK-CVT-NEXT:    movi v3.2s, #72, lsl #24
; CHECK-CVT-NEXT:    fcmp s2, s1
; CHECK-CVT-NEXT:    ldr h1, [x8, :lo12:.LCPI29_0]
; CHECK-CVT-NEXT:    fccmp s2, s3, #4, mi
; CHECK-CVT-NEXT:    fcsel s0, s0, s1, gt
; CHECK-CVT-NEXT:    str h0, [x0]
; CHECK-CVT-NEXT:    ret
;
; CHECK-SD-LABEL: test_fccmp:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    movi v1.2s, #69, lsl #24
; CHECK-SD-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-SD-NEXT:    shll v2.4s, v0.4h, #16
; CHECK-SD-NEXT:    adrp x8, .LCPI29_0
; CHECK-SD-NEXT:    movi v3.2s, #72, lsl #24
; CHECK-SD-NEXT:    fcmp s2, s1
; CHECK-SD-NEXT:    ldr h1, [x8, :lo12:.LCPI29_0]
; CHECK-SD-NEXT:    fccmp s2, s3, #4, mi
; CHECK-SD-NEXT:    fcsel s0, s0, s1, gt
; CHECK-SD-NEXT:    str h0, [x0]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_fccmp:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2s, #69, lsl #24
; CHECK-GI-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-GI-NEXT:    shll v2.4s, v0.4h, #16
; CHECK-GI-NEXT:    movi v3.2s, #72, lsl #24
; CHECK-GI-NEXT:    fcmp s2, s1
; CHECK-GI-NEXT:    fmov h1, #5.00000000
; CHECK-GI-NEXT:    fccmp s2, s3, #4, mi
; CHECK-GI-NEXT:    fcsel h0, h0, h1, gt
; CHECK-GI-NEXT:    str h0, [x0]
; CHECK-GI-NEXT:    ret
  %cmp1 = fcmp ogt bfloat %in, 0xR4800
  %cmp2 = fcmp olt bfloat %in, 0xR4500
  %cond = and i1 %cmp1, %cmp2
  %result = select i1 %cond, bfloat %in, bfloat 0xR4500
  store bfloat %result, ptr %out
  ret void
}

define void @test_br_cc(bfloat %a, bfloat %b, ptr %p1, ptr %p2) #0 {
; CHECK-LABEL: test_br_cc:
; CHECK:       // %bb.0: // %common.ret
; CHECK-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    fcmp s0, s1
; CHECK-NEXT:    csel x8, x0, x1, pl
; CHECK-NEXT:    str wzr, [x8]
; CHECK-NEXT:    ret
  %c = fcmp uge bfloat %a, %b
  br i1 %c, label %then, label %else
then:
  store i32 0, ptr %p1
  ret void
else:
  store i32 0, ptr %p2
  ret void
}

define bfloat @test_phi(ptr %p1) #0 {
; CHECK-LABEL: test_phi:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    stp d9, d8, [sp, #-32]! // 16-byte Folded Spill
; CHECK-NEXT:    ldr h9, [x0]
; CHECK-NEXT:    stp x30, x19, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    mov x19, x0
; CHECK-NEXT:  .LBB31_1: // %loop
; CHECK-NEXT:    // =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    fmov s8, s9
; CHECK-NEXT:    ldr h9, [x19]
; CHECK-NEXT:    mov x0, x19
; CHECK-NEXT:    bl test_dummy
; CHECK-NEXT:    tbnz w0, #0, .LBB31_1
; CHECK-NEXT:  // %bb.2: // %return
; CHECK-NEXT:    ldp x30, x19, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    fmov s0, s8
; CHECK-NEXT:    ldp d9, d8, [sp], #32 // 16-byte Folded Reload
; CHECK-NEXT:    ret
entry:
  %a = load bfloat, ptr %p1
  br label %loop
loop:
  %r = phi bfloat [%a, %entry], [%b, %loop]
  %b = load bfloat, ptr %p1
  %c = call i1 @test_dummy(ptr %p1)
  br i1 %c, label %loop, label %return
return:
  ret bfloat %r
}

declare i1 @test_dummy(ptr %p1) #0

define i32 @test_fptosi_i32(bfloat %a) #0 {
; CHECK-LABEL: test_fptosi_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    fcvtzs w0, s0
; CHECK-NEXT:    ret
  %r = fptosi bfloat %a to i32
  ret i32 %r
}

define i64 @test_fptosi_i64(bfloat %a) #0 {
; CHECK-LABEL: test_fptosi_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    fcvtzs x0, s0
; CHECK-NEXT:    ret
  %r = fptosi bfloat %a to i64
  ret i64 %r
}

define i32 @test_fptoui_i32(bfloat %a) #0 {
; CHECK-LABEL: test_fptoui_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    fcvtzu w0, s0
; CHECK-NEXT:    ret
  %r = fptoui bfloat %a to i32
  ret i32 %r
}

define i64 @test_fptoui_i64(bfloat %a) #0 {
; CHECK-LABEL: test_fptoui_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    fcvtzu x0, s0
; CHECK-NEXT:    ret
  %r = fptoui bfloat %a to i64
  ret i64 %r
}

define bfloat @test_uitofp_i32(i32 %a) #0 {
; CHECK-CVT-LABEL: test_uitofp_i32:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    ucvtf d0, w0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    fcvtxn s0, d0
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_uitofp_i32:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    ucvtf d0, w0
; CHECK-BF16-NEXT:    fcvtxn s0, d0
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ret
  %r = uitofp i32 %a to bfloat
  ret bfloat %r
}

define bfloat @test_uitofp_i64(i64 %a) #0 {
; CHECK-CVT-LABEL: test_uitofp_i64:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    lsr x9, x0, #53
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    cmp x9, #0
; CHECK-CVT-NEXT:    and x9, x0, #0xfffffffffffff000
; CHECK-CVT-NEXT:    csel x9, x9, x0, ne
; CHECK-CVT-NEXT:    ucvtf d0, x9
; CHECK-CVT-NEXT:    cset w9, ne
; CHECK-CVT-NEXT:    tst x0, #0xfff
; CHECK-CVT-NEXT:    csel w9, wzr, w9, eq
; CHECK-CVT-NEXT:    fmov x10, d0
; CHECK-CVT-NEXT:    orr x9, x10, x9
; CHECK-CVT-NEXT:    fmov d0, x9
; CHECK-CVT-NEXT:    fcvtxn s0, d0
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_uitofp_i64:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    lsr x8, x0, #53
; CHECK-BF16-NEXT:    and x9, x0, #0xfffffffffffff000
; CHECK-BF16-NEXT:    cmp x8, #0
; CHECK-BF16-NEXT:    csel x8, x9, x0, ne
; CHECK-BF16-NEXT:    ucvtf d0, x8
; CHECK-BF16-NEXT:    cset w8, ne
; CHECK-BF16-NEXT:    tst x0, #0xfff
; CHECK-BF16-NEXT:    csel w8, wzr, w8, eq
; CHECK-BF16-NEXT:    fmov x9, d0
; CHECK-BF16-NEXT:    orr x8, x9, x8
; CHECK-BF16-NEXT:    fmov d0, x8
; CHECK-BF16-NEXT:    fcvtxn s0, d0
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ret
  %r = uitofp i64 %a to bfloat
  ret bfloat %r
}

define bfloat @test_sitofp_i32(i32 %a) #0 {
; CHECK-CVT-LABEL: test_sitofp_i32:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    scvtf d0, w0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    fcvtxn s0, d0
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_sitofp_i32:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    scvtf d0, w0
; CHECK-BF16-NEXT:    fcvtxn s0, d0
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ret
  %r = sitofp i32 %a to bfloat
  ret bfloat %r
}

define bfloat @test_sitofp_i64(i64 %a) #0 {
; CHECK-CVT-LABEL: test_sitofp_i64:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    cmp x0, #0
; CHECK-CVT-NEXT:    and x11, x0, #0x8000000000000000
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    cneg x9, x0, mi
; CHECK-CVT-NEXT:    lsr x10, x9, #53
; CHECK-CVT-NEXT:    cmp x10, #0
; CHECK-CVT-NEXT:    and x10, x9, #0xfffffffffffff000
; CHECK-CVT-NEXT:    csel x10, x10, x9, ne
; CHECK-CVT-NEXT:    scvtf d0, x10
; CHECK-CVT-NEXT:    cset w10, ne
; CHECK-CVT-NEXT:    tst x9, #0xfff
; CHECK-CVT-NEXT:    csel w10, wzr, w10, eq
; CHECK-CVT-NEXT:    fmov x9, d0
; CHECK-CVT-NEXT:    orr x9, x9, x11
; CHECK-CVT-NEXT:    orr x9, x9, x10
; CHECK-CVT-NEXT:    fmov d0, x9
; CHECK-CVT-NEXT:    fcvtxn s0, d0
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_sitofp_i64:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    cmp x0, #0
; CHECK-BF16-NEXT:    cneg x8, x0, mi
; CHECK-BF16-NEXT:    lsr x9, x8, #53
; CHECK-BF16-NEXT:    and x10, x8, #0xfffffffffffff000
; CHECK-BF16-NEXT:    cmp x9, #0
; CHECK-BF16-NEXT:    csel x9, x10, x8, ne
; CHECK-BF16-NEXT:    and x10, x0, #0x8000000000000000
; CHECK-BF16-NEXT:    cset w11, ne
; CHECK-BF16-NEXT:    scvtf d0, x9
; CHECK-BF16-NEXT:    tst x8, #0xfff
; CHECK-BF16-NEXT:    fmov x9, d0
; CHECK-BF16-NEXT:    orr x8, x9, x10
; CHECK-BF16-NEXT:    csel w9, wzr, w11, eq
; CHECK-BF16-NEXT:    orr x8, x8, x9
; CHECK-BF16-NEXT:    fmov d0, x8
; CHECK-BF16-NEXT:    fcvtxn s0, d0
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ret
  %r = sitofp i64 %a to bfloat
  ret bfloat %r
}

define bfloat @test_uitofp_i32_fadd(i32 %a, bfloat %b) #0 {
; CHECK-CVT-LABEL: test_uitofp_i32_fadd:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    ucvtf d1, w0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    fcvtxn s1, d1
; CHECK-CVT-NEXT:    fmov w9, s1
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w9, w9, w8
; CHECK-CVT-NEXT:    add w9, w10, w9
; CHECK-CVT-NEXT:    lsr w9, w9, #16
; CHECK-CVT-NEXT:    fmov s1, w9
; CHECK-CVT-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-CVT-NEXT:    fadd s0, s0, s1
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_uitofp_i32_fadd:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    ucvtf d1, w0
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    fcvtxn s1, d1
; CHECK-BF16-NEXT:    bfcvt h1, s1
; CHECK-BF16-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-BF16-NEXT:    fadd s0, s0, s1
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ret
  %c = uitofp i32 %a to bfloat
  %r = fadd bfloat %b, %c
  ret bfloat %r
}

define bfloat @test_sitofp_i32_fadd(i32 %a, bfloat %b) #0 {
; CHECK-CVT-LABEL: test_sitofp_i32_fadd:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    scvtf d1, w0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    fcvtxn s1, d1
; CHECK-CVT-NEXT:    fmov w9, s1
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w9, w9, w8
; CHECK-CVT-NEXT:    add w9, w10, w9
; CHECK-CVT-NEXT:    lsr w9, w9, #16
; CHECK-CVT-NEXT:    fmov s1, w9
; CHECK-CVT-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-CVT-NEXT:    fadd s0, s0, s1
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_sitofp_i32_fadd:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    scvtf d1, w0
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    fcvtxn s1, d1
; CHECK-BF16-NEXT:    bfcvt h1, s1
; CHECK-BF16-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-BF16-NEXT:    fadd s0, s0, s1
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ret
  %c = sitofp i32 %a to bfloat
  %r = fadd bfloat %b, %c
  ret bfloat %r
}

define bfloat @test_fptrunc_float(float %a) #0 {
; CHECK-CVT-LABEL: test_fptrunc_float:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    fcmp s0, s0
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    orr w9, w9, #0x400000
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    csel w8, w9, w8, vs
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_fptrunc_float:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ret
  %r = fptrunc float %a to bfloat
  ret bfloat %r
}

define bfloat @test_fptrunc_double(double %a) #0 {
; CHECK-CVT-LABEL: test_fptrunc_double:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fcvtxn s0, d0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_fptrunc_double:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    fcvtxn s0, d0
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ret
  %r = fptrunc double %a to bfloat
  ret bfloat %r
}

define float @test_fpext_float(bfloat %a) #0 {
; CHECK-LABEL: test_fpext_float:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-NEXT:    ret
  %r = fpext bfloat %a to float
  ret float %r
}

define double @test_fpext_double(bfloat %a) #0 {
; CHECK-LABEL: test_fpext_double:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    fcvt d0, s0
; CHECK-NEXT:    ret
  %r = fpext bfloat %a to double
  ret double %r
}

define i16 @test_bitcast_bfloattoi16(bfloat %a) #0 {
; CHECK-LABEL: test_bitcast_bfloattoi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $h0 killed $h0 def $s0
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %r = bitcast bfloat %a to i16
  ret i16 %r
}

define bfloat @test_bitcast_i16tobfloat(i16 %a) #0 {
; CHECK-LABEL: test_bitcast_i16tobfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmov s0, w0
; CHECK-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-NEXT:    ret
  %r = bitcast i16 %a to bfloat
  ret bfloat %r
}

declare bfloat @llvm.sqrt.f16(bfloat %a) #0
declare bfloat @llvm.powi.f16.i32(bfloat %a, i32 %b) #0
declare bfloat @llvm.sin.f16(bfloat %a) #0
declare bfloat @llvm.cos.f16(bfloat %a) #0
declare bfloat @llvm.tan.f16(bfloat %a) #0
declare bfloat @llvm.asin.f16(bfloat %a) #0
declare bfloat @llvm.acos.f16(bfloat %a) #0
declare bfloat @llvm.atan.f16(bfloat %a) #0
declare bfloat @llvm.atan2.f16(bfloat %a, bfloat %b) #0
declare bfloat @llvm.sinh.f16(bfloat %a) #0
declare bfloat @llvm.cosh.f16(bfloat %a) #0
declare bfloat @llvm.tanh.f16(bfloat %a) #0
declare bfloat @llvm.pow.f16(bfloat %a, bfloat %b) #0
declare bfloat @llvm.exp.f16(bfloat %a) #0
declare bfloat @llvm.exp2.f16(bfloat %a) #0
declare bfloat @llvm.log.f16(bfloat %a) #0
declare bfloat @llvm.log10.f16(bfloat %a) #0
declare bfloat @llvm.log2.f16(bfloat %a) #0
declare bfloat @llvm.fma.f16(bfloat %a, bfloat %b, bfloat %c) #0
declare bfloat @llvm.fabs.f16(bfloat %a) #0
declare bfloat @llvm.minnum.f16(bfloat %a, bfloat %b) #0
declare bfloat @llvm.maxnum.f16(bfloat %a, bfloat %b) #0
declare bfloat @llvm.copysign.f16(bfloat %a, bfloat %b) #0
declare bfloat @llvm.floor.f16(bfloat %a) #0
declare bfloat @llvm.ceil.f16(bfloat %a) #0
declare bfloat @llvm.trunc.f16(bfloat %a) #0
declare bfloat @llvm.rint.f16(bfloat %a) #0
declare bfloat @llvm.nearbyint.f16(bfloat %a) #0
declare bfloat @llvm.round.f16(bfloat %a) #0
declare bfloat @llvm.roundeven.f16(bfloat %a) #0
declare bfloat @llvm.fmuladd.f16(bfloat %a, bfloat %b, bfloat %c) #0


define bfloat @test_sqrt(bfloat %a) #0 {
; CHECK-CVT-LABEL: test_sqrt:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    fsqrt s0, s0
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_sqrt:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    fsqrt s0, s0
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ret
  %r = call bfloat @llvm.sqrt.f16(bfloat %a)
  ret bfloat %r
}

define bfloat @test_powi(bfloat %a, i32 %b) #0 {
; CHECK-CVT-LABEL: test_powi:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-CVT-NEXT:    bl __powisf2
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_powi:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-BF16-NEXT:    bl __powisf2
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-BF16-NEXT:    ret
  %r = call bfloat @llvm.powi.f16.i32(bfloat %a, i32 %b)
  ret bfloat %r
}


define bfloat @test_sin(bfloat %a) #0 {
; CHECK-CVT-LABEL: test_sin:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-CVT-NEXT:    bl sinf
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_sin:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-BF16-NEXT:    bl sinf
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-BF16-NEXT:    ret
  %r = call bfloat @llvm.sin.f16(bfloat %a)
  ret bfloat %r
}

define bfloat @test_cos(bfloat %a) #0 {
; CHECK-CVT-LABEL: test_cos:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-CVT-NEXT:    bl cosf
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_cos:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-BF16-NEXT:    bl cosf
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-BF16-NEXT:    ret
  %r = call bfloat @llvm.cos.f16(bfloat %a)
  ret bfloat %r
}

define bfloat @test_tan(bfloat %a) #0 {
; CHECK-CVT-LABEL: test_tan:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-CVT-NEXT:    bl tanf
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_tan:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-BF16-NEXT:    bl tanf
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-BF16-NEXT:    ret
  %r = call bfloat @llvm.tan.f16(bfloat %a)
  ret bfloat %r
}

define bfloat @test_acos(bfloat %a) #0 {
; CHECK-CVT-LABEL: test_acos:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-CVT-NEXT:    bl acosf
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_acos:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-BF16-NEXT:    bl acosf
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-BF16-NEXT:    ret
  %r = call bfloat @llvm.acos.f16(bfloat %a)
  ret bfloat %r
}

define bfloat @test_asin(bfloat %a) #0 {
; CHECK-CVT-LABEL: test_asin:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-CVT-NEXT:    bl asinf
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_asin:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-BF16-NEXT:    bl asinf
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-BF16-NEXT:    ret
  %r = call bfloat @llvm.asin.f16(bfloat %a)
  ret bfloat %r
}

define bfloat @test_atan(bfloat %a) #0 {
; CHECK-CVT-LABEL: test_atan:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-CVT-NEXT:    bl atanf
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_atan:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-BF16-NEXT:    bl atanf
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-BF16-NEXT:    ret
  %r = call bfloat @llvm.atan.f16(bfloat %a)
  ret bfloat %r
}

define bfloat @test_atan2(bfloat %a, bfloat %b) #0 {
; CHECK-CVT-LABEL: test_atan2:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-CVT-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-CVT-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-CVT-NEXT:    // kill: def $s1 killed $s1 killed $q1
; CHECK-CVT-NEXT:    bl atan2f
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_atan2:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-BF16-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-BF16-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-BF16-NEXT:    // kill: def $s1 killed $s1 killed $q1
; CHECK-BF16-NEXT:    bl atan2f
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-BF16-NEXT:    ret
  %r = call bfloat @llvm.atan2.f16(bfloat %a, bfloat %b)
  ret bfloat %r
}

define bfloat @test_cosh(bfloat %a) #0 {
; CHECK-CVT-LABEL: test_cosh:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-CVT-NEXT:    bl coshf
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_cosh:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-BF16-NEXT:    bl coshf
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-BF16-NEXT:    ret
  %r = call bfloat @llvm.cosh.f16(bfloat %a)
  ret bfloat %r
}

define bfloat @test_sinh(bfloat %a) #0 {
; CHECK-CVT-LABEL: test_sinh:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-CVT-NEXT:    bl sinhf
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_sinh:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-BF16-NEXT:    bl sinhf
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-BF16-NEXT:    ret
  %r = call bfloat @llvm.sinh.f16(bfloat %a)
  ret bfloat %r
}

define bfloat @test_tanh(bfloat %a) #0 {
; CHECK-CVT-LABEL: test_tanh:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-CVT-NEXT:    bl tanhf
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_tanh:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-BF16-NEXT:    bl tanhf
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-BF16-NEXT:    ret
  %r = call bfloat @llvm.tanh.f16(bfloat %a)
  ret bfloat %r
}

define bfloat @test_pow(bfloat %a, bfloat %b) #0 {
; CHECK-CVT-LABEL: test_pow:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-CVT-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-CVT-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-CVT-NEXT:    // kill: def $s1 killed $s1 killed $q1
; CHECK-CVT-NEXT:    bl powf
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_pow:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-BF16-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-BF16-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-BF16-NEXT:    // kill: def $s1 killed $s1 killed $q1
; CHECK-BF16-NEXT:    bl powf
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-BF16-NEXT:    ret
  %r = call bfloat @llvm.pow.f16(bfloat %a, bfloat %b)
  ret bfloat %r
}

define bfloat @test_exp(bfloat %a) #0 {
; CHECK-CVT-LABEL: test_exp:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-CVT-NEXT:    bl expf
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_exp:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-BF16-NEXT:    bl expf
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-BF16-NEXT:    ret
  %r = call bfloat @llvm.exp.f16(bfloat %a)
  ret bfloat %r
}

define bfloat @test_exp2(bfloat %a) #0 {
; CHECK-CVT-LABEL: test_exp2:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-CVT-NEXT:    bl exp2f
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_exp2:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-BF16-NEXT:    bl exp2f
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-BF16-NEXT:    ret
  %r = call bfloat @llvm.exp2.f16(bfloat %a)
  ret bfloat %r
}

define bfloat @test_log(bfloat %a) #0 {
; CHECK-CVT-LABEL: test_log:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-CVT-NEXT:    bl logf
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_log:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-BF16-NEXT:    bl logf
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-BF16-NEXT:    ret
  %r = call bfloat @llvm.log.f16(bfloat %a)
  ret bfloat %r
}

define bfloat @test_log10(bfloat %a) #0 {
; CHECK-CVT-LABEL: test_log10:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-CVT-NEXT:    bl log10f
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_log10:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-BF16-NEXT:    bl log10f
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-BF16-NEXT:    ret
  %r = call bfloat @llvm.log10.f16(bfloat %a)
  ret bfloat %r
}

define bfloat @test_log2(bfloat %a) #0 {
; CHECK-CVT-LABEL: test_log2:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-CVT-NEXT:    bl log2f
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_log2:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-BF16-NEXT:    bl log2f
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-BF16-NEXT:    ret
  %r = call bfloat @llvm.log2.f16(bfloat %a)
  ret bfloat %r
}

define bfloat @test_fma(bfloat %a, bfloat %b, bfloat %c) #0 {
; CHECK-CVT-LABEL: test_fma:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    // kill: def $h2 killed $h2 def $d2
; CHECK-CVT-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    mov w10, #32767 // =0x7fff
; CHECK-CVT-NEXT:    shll v2.4s, v2.4h, #16
; CHECK-CVT-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    fmadd s0, s0, s1, s2
; CHECK-CVT-NEXT:    fmov w8, s0
; CHECK-CVT-NEXT:    ubfx w9, w8, #16, #1
; CHECK-CVT-NEXT:    add w8, w8, w10
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_fma:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    // kill: def $h2 killed $h2 def $d2
; CHECK-BF16-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v2.4s, v2.4h, #16
; CHECK-BF16-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    fmadd s0, s0, s1, s2
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ret
  %r = call bfloat @llvm.fma.f16(bfloat %a, bfloat %b, bfloat %c)
  ret bfloat %r
}

define bfloat @test_fabs(bfloat %a) #0 {
; CHECK-LABEL: test_fabs:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $h0 killed $h0 def $s0
; CHECK-NEXT:    fmov w8, s0
; CHECK-NEXT:    and w8, w8, #0x7fff
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-NEXT:    ret
  %r = call bfloat @llvm.fabs.f16(bfloat %a)
  ret bfloat %r
}

define bfloat @test_minnum(bfloat %a, bfloat %b) #0 {
; CHECK-CVT-LABEL: test_minnum:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    fminnm s0, s0, s1
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_minnum:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    fminnm s0, s0, s1
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ret
  %r = call bfloat @llvm.minnum.f16(bfloat %a, bfloat %b)
  ret bfloat %r
}

define bfloat @test_maxnum(bfloat %a, bfloat %b) #0 {
; CHECK-CVT-LABEL: test_maxnum:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    fmaxnm s0, s0, s1
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_maxnum:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    fmaxnm s0, s0, s1
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ret
  %r = call bfloat @llvm.maxnum.f16(bfloat %a, bfloat %b)
  ret bfloat %r
}

define bfloat @test_copysign(bfloat %a, bfloat %b) #0 {
; CHECK-CVT-LABEL: test_copysign:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    mvni v2.4s, #128, lsl #24
; CHECK-CVT-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-CVT-NEXT:    fmov w8, s0
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-SD-LABEL: test_copysign:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-SD-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-SD-NEXT:    mvni v2.4s, #128, lsl #24
; CHECK-SD-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-SD-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-SD-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-SD-NEXT:    bfcvt h0, s0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_copysign:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mvni v2.8h, #128, lsl #8
; CHECK-GI-NEXT:    // kill: def $h0 killed $h0 def $q0
; CHECK-GI-NEXT:    // kill: def $h1 killed $h1 def $q1
; CHECK-GI-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-GI-NEXT:    // kill: def $h0 killed $h0 killed $q0
; CHECK-GI-NEXT:    ret
  %r = call bfloat @llvm.copysign.f16(bfloat %a, bfloat %b)
  ret bfloat %r
}

define bfloat @test_copysign_f32(bfloat %a, float %b) #0 {
; CHECK-CVT-LABEL: test_copysign_f32:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    mvni v2.4s, #128, lsl #24
; CHECK-CVT-NEXT:    // kill: def $s1 killed $s1 def $q1
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-CVT-NEXT:    fmov w8, s0
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-SD-LABEL: test_copysign_f32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-SD-NEXT:    mvni v2.4s, #128, lsl #24
; CHECK-SD-NEXT:    // kill: def $s1 killed $s1 def $q1
; CHECK-SD-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-SD-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-SD-NEXT:    bfcvt h0, s0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_copysign_f32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    bfcvt h1, s1
; CHECK-GI-NEXT:    mvni v2.8h, #128, lsl #8
; CHECK-GI-NEXT:    // kill: def $h0 killed $h0 def $q0
; CHECK-GI-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-GI-NEXT:    // kill: def $h0 killed $h0 killed $q0
; CHECK-GI-NEXT:    ret
  %tb = fptrunc float %b to bfloat
  %r = call bfloat @llvm.copysign.f16(bfloat %a, bfloat %tb)
  ret bfloat %r
}

define bfloat @test_copysign_f64(bfloat %a, double %b) #0 {
; CHECK-CVT-LABEL: test_copysign_f64:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    fcvt s1, d1
; CHECK-CVT-NEXT:    mvni v2.4s, #128, lsl #24
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-CVT-NEXT:    fmov w8, s0
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-SD-LABEL: test_copysign_f64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-SD-NEXT:    fcvt s1, d1
; CHECK-SD-NEXT:    mvni v2.4s, #128, lsl #24
; CHECK-SD-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-SD-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-SD-NEXT:    bfcvt h0, s0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_copysign_f64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcvtxn s1, d1
; CHECK-GI-NEXT:    mvni v2.8h, #128, lsl #8
; CHECK-GI-NEXT:    // kill: def $h0 killed $h0 def $q0
; CHECK-GI-NEXT:    bfcvt h1, s1
; CHECK-GI-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-GI-NEXT:    // kill: def $h0 killed $h0 killed $q0
; CHECK-GI-NEXT:    ret
  %tb = fptrunc double %b to bfloat
  %r = call bfloat @llvm.copysign.f16(bfloat %a, bfloat %tb)
  ret bfloat %r
}

; away the (fpext (fp_round <result>)) here.

define float @test_copysign_extended(bfloat %a, bfloat %b) #0 {
; CHECK-CVT-LABEL: test_copysign_extended:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    movi v2.4s, #16
; CHECK-CVT-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-CVT-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-CVT-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-CVT-NEXT:    ushl v0.4s, v0.4s, v2.4s
; CHECK-CVT-NEXT:    mvni v2.4s, #128, lsl #24
; CHECK-CVT-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-CVT-NEXT:    fmov w8, s0
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-CVT-NEXT:    ret
;
; CHECK-SD-LABEL: test_copysign_extended:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-SD-NEXT:    movi v2.4s, #16
; CHECK-SD-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-SD-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-SD-NEXT:    ushl v0.4s, v0.4s, v2.4s
; CHECK-SD-NEXT:    mvni v2.4s, #128, lsl #24
; CHECK-SD-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-SD-NEXT:    bfcvt h0, s0
; CHECK-SD-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_copysign_extended:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mvni v2.8h, #128, lsl #8
; CHECK-GI-NEXT:    // kill: def $h0 killed $h0 def $q0
; CHECK-GI-NEXT:    // kill: def $h1 killed $h1 def $q1
; CHECK-GI-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-GI-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-GI-NEXT:    ret
  %r = call bfloat @llvm.copysign.f16(bfloat %a, bfloat %b)
  %xr = fpext bfloat %r to float
  ret float %xr
}

define bfloat @test_floor(bfloat %a) #0 {
; CHECK-CVT-LABEL: test_floor:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    frintm s0, s0
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_floor:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    frintm s0, s0
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ret
  %r = call bfloat @llvm.floor.f16(bfloat %a)
  ret bfloat %r
}

define bfloat @test_ceil(bfloat %a) #0 {
; CHECK-CVT-LABEL: test_ceil:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    frintp s0, s0
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_ceil:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    frintp s0, s0
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ret
  %r = call bfloat @llvm.ceil.f16(bfloat %a)
  ret bfloat %r
}

define bfloat @test_trunc(bfloat %a) #0 {
; CHECK-CVT-LABEL: test_trunc:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    frintz s0, s0
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_trunc:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    frintz s0, s0
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ret
  %r = call bfloat @llvm.trunc.f16(bfloat %a)
  ret bfloat %r
}

define bfloat @test_rint(bfloat %a) #0 {
; CHECK-CVT-LABEL: test_rint:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    frintx s0, s0
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_rint:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    frintx s0, s0
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ret
  %r = call bfloat @llvm.rint.f16(bfloat %a)
  ret bfloat %r
}

define bfloat @test_nearbyint(bfloat %a) #0 {
; CHECK-CVT-LABEL: test_nearbyint:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    frinti s0, s0
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_nearbyint:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    frinti s0, s0
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ret
  %r = call bfloat @llvm.nearbyint.f16(bfloat %a)
  ret bfloat %r
}

define bfloat @test_round(bfloat %a) #0 {
; CHECK-CVT-LABEL: test_round:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    frinta s0, s0
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_round:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    frinta s0, s0
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ret
  %r = call bfloat @llvm.round.f16(bfloat %a)
  ret bfloat %r
}

define bfloat @test_roundeven(bfloat %a) #0 {
; CHECK-CVT-LABEL: test_roundeven:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    frintn s0, s0
; CHECK-CVT-NEXT:    fmov w9, s0
; CHECK-CVT-NEXT:    ubfx w10, w9, #16, #1
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    add w8, w10, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_roundeven:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    frintn s0, s0
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ret
  %r = call bfloat @llvm.roundeven.f16(bfloat %a)
  ret bfloat %r
}

define bfloat @test_fmuladd(bfloat %a, bfloat %b, bfloat %c) #0 {
; CHECK-CVT-LABEL: test_fmuladd:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-CVT-NEXT:    mov w10, #32767 // =0x7fff
; CHECK-CVT-NEXT:    // kill: def $h2 killed $h2 def $d2
; CHECK-CVT-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    fmul s0, s0, s1
; CHECK-CVT-NEXT:    shll v1.4s, v2.4h, #16
; CHECK-CVT-NEXT:    fmov w8, s0
; CHECK-CVT-NEXT:    ubfx w9, w8, #16, #1
; CHECK-CVT-NEXT:    add w8, w8, w10
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    fadd s0, s0, s1
; CHECK-CVT-NEXT:    fmov w8, s0
; CHECK-CVT-NEXT:    ubfx w9, w8, #16, #1
; CHECK-CVT-NEXT:    add w8, w8, w10
; CHECK-CVT-NEXT:    add w8, w9, w8
; CHECK-CVT-NEXT:    lsr w8, w8, #16
; CHECK-CVT-NEXT:    fmov s0, w8
; CHECK-CVT-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: test_fmuladd:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-BF16-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-BF16-NEXT:    // kill: def $h2 killed $h2 def $d2
; CHECK-BF16-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    fmul s0, s0, s1
; CHECK-BF16-NEXT:    shll v1.4s, v2.4h, #16
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-BF16-NEXT:    fadd s0, s0, s1
; CHECK-BF16-NEXT:    bfcvt h0, s0
; CHECK-BF16-NEXT:    ret
  %r = call bfloat @llvm.fmuladd.f16(bfloat %a, bfloat %b, bfloat %c)
  ret bfloat %r
}

attributes #0 = { nounwind }
