; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -mtriple=x86_64-apple-macosx10.8.0 -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=throughput   -mcpu=corei7-avx | FileCheck %s --check-prefix=THRU
; RUN: opt < %s -mtriple=x86_64-apple-macosx10.8.0 -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=latency      -mcpu=corei7-avx | FileCheck %s --check-prefix=LATE
; RUN: opt < %s -mtriple=x86_64-apple-macosx10.8.0 -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=code-size    -mcpu=corei7-avx | FileCheck %s --check-prefix=SIZE
; RUN: opt < %s -mtriple=x86_64-apple-macosx10.8.0 -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mcpu=corei7-avx | FileCheck %s --check-prefix=SIZE_LATE

define void @test_geps() {
; THRU-LABEL: 'test_geps'
; THRU-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %giant_gep0 = getelementptr inbounds i8, ptr undef, i64 9223372036854775807
; THRU-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %giant_gep1 = getelementptr inbounds i8, ptr undef, i128 295147905179352825855
; THRU-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; LATE-LABEL: 'test_geps'
; LATE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %giant_gep0 = getelementptr inbounds i8, ptr undef, i64 9223372036854775807
; LATE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %giant_gep1 = getelementptr inbounds i8, ptr undef, i128 295147905179352825855
; LATE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
; SIZE-LABEL: 'test_geps'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %giant_gep0 = getelementptr inbounds i8, ptr undef, i64 9223372036854775807
; SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %giant_gep1 = getelementptr inbounds i8, ptr undef, i128 295147905179352825855
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
; SIZE_LATE-LABEL: 'test_geps'
; SIZE_LATE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %giant_gep0 = getelementptr inbounds i8, ptr undef, i64 9223372036854775807
; SIZE_LATE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %giant_gep1 = getelementptr inbounds i8, ptr undef, i128 295147905179352825855
; SIZE_LATE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;

  ; Cost of scalar geps should be zero.
  ; We expect it to be folded into the instruction addressing mode.


  ; Vector geps should also have zero cost.

  ; Check that we handle outlandishly large GEPs properly.  This is unlikely to
  ; be a valid pointer, but LLVM still generates GEPs like this sometimes in
  ; dead code.
  ; This GEP has index INT64_MAX, which is cost 1.
  %giant_gep0 = getelementptr inbounds i8, ptr undef, i64 9223372036854775807

  ; This GEP index wraps around to -1, which is cost 0.
  %giant_gep1 = getelementptr inbounds i8, ptr undef, i128 295147905179352825855

  ret void
}
