; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=debugify,loop-idiom -mtriple=x86_64 -mcpu=core-avx2 < %s -S | FileCheck --check-prefixes=ALL,LZCNT %s
; RUN: opt -passes=debugify,loop-idiom -mtriple=x86_64 -mcpu=corei7 < %s -S | FileCheck  --check-prefixes=ALL,NOLZCNT %s
; RUN: opt -passes=debugify,loop-idiom -mtriple=x86_64 -mcpu=core-avx2 < %s -S --try-experimental-debuginfo-iterators | FileCheck --check-prefixes=ALL,LZCNT %s

declare i32 @gen32()
declare void @use32(i32)
declare void @use1(i1)
declare void @external_side_effect()

; The patterns here are all have the same base form:
;   while (!(x & (1U << bit)))
;     x <<= 1;
; .. which is an uncountable loop.
; We should transform it into it's countable form.

; Most basic example.
define i32 @p0_i32(i32 %x, i32 %bit) {
; ALL-LABEL: @p0_i32(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[BIT_FR:%.*]] = freeze i32 [[BIT:%.*]]
; ALL-NEXT:    [[BITMASK:%.*]] = shl i32 1, [[BIT_FR]], !dbg [[DBG16:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[BITMASK]], [[META9:![0-9]+]], !DIExpression(), [[DBG16]])
; ALL-NEXT:    [[BIT_FR_LOWBITMASK:%.*]] = add i32 [[BITMASK]], -1, !dbg [[DBG17:![0-9]+]]
; ALL-NEXT:    [[BIT_FR_MASK:%.*]] = or i32 [[BIT_FR_LOWBITMASK]], [[BITMASK]], !dbg [[DBG17]]
; ALL-NEXT:    [[X_MASKED:%.*]] = and i32 [[X:%.*]], [[BIT_FR_MASK]], !dbg [[DBG17]]
; ALL-NEXT:    [[X_MASKED_NUMLEADINGZEROS:%.*]] = call i32 @llvm.ctlz.i32(i32 [[X_MASKED]], i1 true), !dbg [[DBG17]]
; ALL-NEXT:    [[X_MASKED_NUMACTIVEBITS:%.*]] = sub nuw nsw i32 32, [[X_MASKED_NUMLEADINGZEROS]], !dbg [[DBG17]]
; ALL-NEXT:    [[X_MASKED_LEADINGONEPOS:%.*]] = add nsw i32 [[X_MASKED_NUMACTIVEBITS]], -1, !dbg [[DBG17]]
; ALL-NEXT:    [[LOOP_BACKEDGETAKENCOUNT:%.*]] = sub nuw nsw i32 [[BIT_FR]], [[X_MASKED_LEADINGONEPOS]], !dbg [[DBG17]]
; ALL-NEXT:    [[LOOP_TRIPCOUNT:%.*]] = add nuw nsw i32 [[LOOP_BACKEDGETAKENCOUNT]], 1, !dbg [[DBG17]]
; ALL-NEXT:    [[X_CURR:%.*]] = shl i32 [[X]], [[LOOP_BACKEDGETAKENCOUNT]], !dbg [[DBG17]]
; ALL-NEXT:    [[X_NEXT:%.*]] = shl i32 [[X_CURR]], 1, !dbg [[DBG17]]
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG18:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:    [[LOOP_IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[LOOP_IV_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG17]]
; ALL-NEXT:    [[TMP0:%.*]] = phi i32 [ [[X]], [[ENTRY]] ], [ [[TMP1:%.*]], [[LOOP]] ], !dbg [[DBG17]]
; ALL-NEXT:      #dbg_value(i32 [[TMP0]], [[META11:![0-9]+]], !DIExpression(), [[DBG17]])
; ALL-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i32 [[TMP0]], [[BITMASK]], !dbg [[DBG19:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR_BITMASKED]], [[META12:![0-9]+]], !DIExpression(), [[DBG19]])
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i32 [[X_CURR_BITMASKED]], 0, !dbg [[DBG20:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META13:![0-9]+]], !DIExpression(), [[DBG20]])
; ALL-NEXT:    [[TMP1]] = shl i32 [[TMP0]], 1, !dbg [[DBG21:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[TMP1]], [[META15:![0-9]+]], !DIExpression(), [[DBG21]])
; ALL-NEXT:    [[LOOP_IV_NEXT]] = add nuw nsw i32 [[LOOP_IV]], 1, !dbg [[DBG22:![0-9]+]]
; ALL-NEXT:    [[LOOP_IVCHECK:%.*]] = icmp eq i32 [[LOOP_IV_NEXT]], [[LOOP_TRIPCOUNT]], !dbg [[DBG22]]
; ALL-NEXT:    br i1 [[LOOP_IVCHECK]], label [[END:%.*]], label [[LOOP]], !dbg [[DBG22]]
; ALL:       end:
; ALL-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i32 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG17]]
; ALL-NEXT:    ret i32 [[X_CURR_LCSSA]], !dbg [[DBG23:![0-9]+]]
;
entry:
  %bitmask = shl i32 1, %bit
  br label %loop

loop:
  %x.curr = phi i32 [ %x, %entry ], [ %x.next, %loop ]
  %x.curr.bitmasked = and i32 %x.curr, %bitmask
  %x.curr.isbitunset = icmp eq i32 %x.curr.bitmasked, 0
  %x.next = shl i32 %x.curr, 1
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  ret i32 %x.curr
}

; Same, but in some other bit width.
define i16 @p1_i16(i16 %x, i16 %bit) {
; LZCNT-LABEL: @p1_i16(
; LZCNT-NEXT:  entry:
; LZCNT-NEXT:    [[BIT_FR:%.*]] = freeze i16 [[BIT:%.*]]
; LZCNT-NEXT:    [[BITMASK:%.*]] = shl i16 1, [[BIT_FR]], !dbg [[DBG32:![0-9]+]]
; LZCNT-NEXT:      #dbg_value(i16 [[BITMASK]], [[META26:![0-9]+]], !DIExpression(), [[DBG32]])
; LZCNT-NEXT:    [[BIT_FR_LOWBITMASK:%.*]] = add i16 [[BITMASK]], -1, !dbg [[DBG33:![0-9]+]]
; LZCNT-NEXT:    [[BIT_FR_MASK:%.*]] = or i16 [[BIT_FR_LOWBITMASK]], [[BITMASK]], !dbg [[DBG33]]
; LZCNT-NEXT:    [[X_MASKED:%.*]] = and i16 [[X:%.*]], [[BIT_FR_MASK]], !dbg [[DBG33]]
; LZCNT-NEXT:    [[X_MASKED_NUMLEADINGZEROS:%.*]] = call i16 @llvm.ctlz.i16(i16 [[X_MASKED]], i1 true), !dbg [[DBG33]]
; LZCNT-NEXT:    [[X_MASKED_NUMACTIVEBITS:%.*]] = sub nuw nsw i16 16, [[X_MASKED_NUMLEADINGZEROS]], !dbg [[DBG33]]
; LZCNT-NEXT:    [[X_MASKED_LEADINGONEPOS:%.*]] = add nsw i16 [[X_MASKED_NUMACTIVEBITS]], -1, !dbg [[DBG33]]
; LZCNT-NEXT:    [[LOOP_BACKEDGETAKENCOUNT:%.*]] = sub nuw nsw i16 [[BIT_FR]], [[X_MASKED_LEADINGONEPOS]], !dbg [[DBG33]]
; LZCNT-NEXT:    [[LOOP_TRIPCOUNT:%.*]] = add nuw nsw i16 [[LOOP_BACKEDGETAKENCOUNT]], 1, !dbg [[DBG33]]
; LZCNT-NEXT:    [[X_CURR:%.*]] = shl i16 [[X]], [[LOOP_BACKEDGETAKENCOUNT]], !dbg [[DBG33]]
; LZCNT-NEXT:    [[X_NEXT:%.*]] = shl i16 [[X_CURR]], 1, !dbg [[DBG33]]
; LZCNT-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG34:![0-9]+]]
; LZCNT:       loop:
; LZCNT-NEXT:    [[LOOP_IV:%.*]] = phi i16 [ 0, [[ENTRY:%.*]] ], [ [[LOOP_IV_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG33]]
; LZCNT-NEXT:    [[TMP0:%.*]] = phi i16 [ [[X]], [[ENTRY]] ], [ [[TMP1:%.*]], [[LOOP]] ], !dbg [[DBG33]]
; LZCNT-NEXT:      #dbg_value(i16 [[TMP0]], [[META28:![0-9]+]], !DIExpression(), [[DBG33]])
; LZCNT-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i16 [[TMP0]], [[BITMASK]], !dbg [[DBG35:![0-9]+]]
; LZCNT-NEXT:      #dbg_value(i16 [[X_CURR_BITMASKED]], [[META29:![0-9]+]], !DIExpression(), [[DBG35]])
; LZCNT-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i16 [[X_CURR_BITMASKED]], 0, !dbg [[DBG36:![0-9]+]]
; LZCNT-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META30:![0-9]+]], !DIExpression(), [[DBG36]])
; LZCNT-NEXT:    [[TMP1]] = shl i16 [[TMP0]], 1, !dbg [[DBG37:![0-9]+]]
; LZCNT-NEXT:      #dbg_value(i16 [[TMP1]], [[META31:![0-9]+]], !DIExpression(), [[DBG37]])
; LZCNT-NEXT:    [[LOOP_IV_NEXT]] = add nuw nsw i16 [[LOOP_IV]], 1, !dbg [[DBG38:![0-9]+]]
; LZCNT-NEXT:    [[LOOP_IVCHECK:%.*]] = icmp eq i16 [[LOOP_IV_NEXT]], [[LOOP_TRIPCOUNT]], !dbg [[DBG38]]
; LZCNT-NEXT:    br i1 [[LOOP_IVCHECK]], label [[END:%.*]], label [[LOOP]], !dbg [[DBG38]]
; LZCNT:       end:
; LZCNT-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i16 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG33]]
; LZCNT-NEXT:    ret i16 [[X_CURR_LCSSA]], !dbg [[DBG39:![0-9]+]]
;
; NOLZCNT-LABEL: @p1_i16(
; NOLZCNT-NEXT:  entry:
; NOLZCNT-NEXT:    [[BITMASK:%.*]] = shl i16 1, [[BIT:%.*]], !dbg [[DBG32:![0-9]+]]
; NOLZCNT-NEXT:      #dbg_value(i16 [[BITMASK]], [[META26:![0-9]+]], !DIExpression(), [[DBG32]])
; NOLZCNT-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG33:![0-9]+]]
; NOLZCNT:       loop:
; NOLZCNT-NEXT:    [[X_CURR:%.*]] = phi i16 [ [[X:%.*]], [[ENTRY:%.*]] ], [ [[X_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG34:![0-9]+]]
; NOLZCNT-NEXT:      #dbg_value(i16 [[X_CURR]], [[META28:![0-9]+]], !DIExpression(), [[DBG34]])
; NOLZCNT-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i16 [[X_CURR]], [[BITMASK]], !dbg [[DBG35:![0-9]+]]
; NOLZCNT-NEXT:      #dbg_value(i16 [[X_CURR_BITMASKED]], [[META29:![0-9]+]], !DIExpression(), [[DBG35]])
; NOLZCNT-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i16 [[X_CURR_BITMASKED]], 0, !dbg [[DBG36:![0-9]+]]
; NOLZCNT-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META30:![0-9]+]], !DIExpression(), [[DBG36]])
; NOLZCNT-NEXT:    [[X_NEXT]] = shl i16 [[X_CURR]], 1, !dbg [[DBG37:![0-9]+]]
; NOLZCNT-NEXT:      #dbg_value(i16 [[X_NEXT]], [[META31:![0-9]+]], !DIExpression(), [[DBG37]])
; NOLZCNT-NEXT:    br i1 [[X_CURR_ISBITUNSET]], label [[LOOP]], label [[END:%.*]], !dbg [[DBG38:![0-9]+]]
; NOLZCNT:       end:
; NOLZCNT-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i16 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG34]]
; NOLZCNT-NEXT:    ret i16 [[X_CURR_LCSSA]], !dbg [[DBG39:![0-9]+]]
;
entry:
  %bitmask = shl i16 1, %bit
  br label %loop

loop:
  %x.curr = phi i16 [ %x, %entry ], [ %x.next, %loop ]
  %x.curr.bitmasked = and i16 %x.curr, %bitmask
  %x.curr.isbitunset = icmp eq i16 %x.curr.bitmasked, 0
  %x.next = shl i16 %x.curr, 1
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  ret i16 %x.curr
}

; We don't particularly care whether %x.curr or %x.curr will live-out.
define i32 @p2_different_liveout(i32 %x, i32 %bit) {
; ALL-LABEL: @p2_different_liveout(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[BIT_FR:%.*]] = freeze i32 [[BIT:%.*]]
; ALL-NEXT:    [[BITMASK:%.*]] = shl i32 1, [[BIT_FR]], !dbg [[DBG47:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[BITMASK]], [[META42:![0-9]+]], !DIExpression(), [[DBG47]])
; ALL-NEXT:    [[BIT_FR_LOWBITMASK:%.*]] = add i32 [[BITMASK]], -1, !dbg [[DBG48:![0-9]+]]
; ALL-NEXT:    [[BIT_FR_MASK:%.*]] = or i32 [[BIT_FR_LOWBITMASK]], [[BITMASK]], !dbg [[DBG48]]
; ALL-NEXT:    [[X_MASKED:%.*]] = and i32 [[X:%.*]], [[BIT_FR_MASK]], !dbg [[DBG48]]
; ALL-NEXT:    [[X_MASKED_NUMLEADINGZEROS:%.*]] = call i32 @llvm.ctlz.i32(i32 [[X_MASKED]], i1 true), !dbg [[DBG48]]
; ALL-NEXT:    [[X_MASKED_NUMACTIVEBITS:%.*]] = sub nuw nsw i32 32, [[X_MASKED_NUMLEADINGZEROS]], !dbg [[DBG48]]
; ALL-NEXT:    [[X_MASKED_LEADINGONEPOS:%.*]] = add nsw i32 [[X_MASKED_NUMACTIVEBITS]], -1, !dbg [[DBG48]]
; ALL-NEXT:    [[LOOP_BACKEDGETAKENCOUNT:%.*]] = sub nuw nsw i32 [[BIT_FR]], [[X_MASKED_LEADINGONEPOS]], !dbg [[DBG48]]
; ALL-NEXT:    [[LOOP_TRIPCOUNT:%.*]] = add nuw nsw i32 [[LOOP_BACKEDGETAKENCOUNT]], 1, !dbg [[DBG48]]
; ALL-NEXT:    [[X_CURR:%.*]] = shl i32 [[X]], [[LOOP_BACKEDGETAKENCOUNT]], !dbg [[DBG48]]
; ALL-NEXT:    [[X_NEXT:%.*]] = shl i32 [[X_CURR]], 1, !dbg [[DBG48]]
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG49:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:    [[LOOP_IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[LOOP_IV_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG48]]
; ALL-NEXT:    [[TMP0:%.*]] = phi i32 [ [[X]], [[ENTRY]] ], [ [[TMP1:%.*]], [[LOOP]] ], !dbg [[DBG48]]
; ALL-NEXT:      #dbg_value(i32 [[TMP0]], [[META43:![0-9]+]], !DIExpression(), [[DBG48]])
; ALL-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i32 [[TMP0]], [[BITMASK]], !dbg [[DBG50:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR_BITMASKED]], [[META44:![0-9]+]], !DIExpression(), [[DBG50]])
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i32 [[X_CURR_BITMASKED]], 0, !dbg [[DBG51:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META45:![0-9]+]], !DIExpression(), [[DBG51]])
; ALL-NEXT:    [[TMP1]] = shl i32 [[TMP0]], 1, !dbg [[DBG52:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[TMP1]], [[META46:![0-9]+]], !DIExpression(), [[DBG52]])
; ALL-NEXT:    [[LOOP_IV_NEXT]] = add nuw nsw i32 [[LOOP_IV]], 1, !dbg [[DBG53:![0-9]+]]
; ALL-NEXT:    [[LOOP_IVCHECK:%.*]] = icmp eq i32 [[LOOP_IV_NEXT]], [[LOOP_TRIPCOUNT]], !dbg [[DBG53]]
; ALL-NEXT:    br i1 [[LOOP_IVCHECK]], label [[END:%.*]], label [[LOOP]], !dbg [[DBG53]]
; ALL:       end:
; ALL-NEXT:    [[X_NEXT_LCSSA:%.*]] = phi i32 [ [[X_NEXT]], [[LOOP]] ], !dbg [[DBG52]]
; ALL-NEXT:    ret i32 [[X_NEXT_LCSSA]], !dbg [[DBG54:![0-9]+]]
;
entry:
  %bitmask = shl i32 1, %bit
  br label %loop

loop:
  %x.curr = phi i32 [ %x, %entry ], [ %x.next, %loop ]
  %x.curr.bitmasked = and i32 %x.curr, %bitmask
  %x.curr.isbitunset = icmp eq i32 %x.curr.bitmasked, 0
  %x.next = shl i32 %x.curr, 1
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  ret i32 %x.next ; not %x.curr
}

; Even both of them can liveout
define void @p3_constant_mask_24thbit(i32 %x, ptr %p0, ptr %p1) {
; ALL-LABEL: @p3_constant_mask_24thbit(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[X_MASKED:%.*]] = and i32 [[X:%.*]], 33554431, !dbg [[DBG61:![0-9]+]]
; ALL-NEXT:    [[X_MASKED_NUMLEADINGZEROS:%.*]] = call i32 @llvm.ctlz.i32(i32 [[X_MASKED]], i1 true), !dbg [[DBG61]]
; ALL-NEXT:    [[X_MASKED_NUMACTIVEBITS:%.*]] = sub nuw nsw i32 32, [[X_MASKED_NUMLEADINGZEROS]], !dbg [[DBG61]]
; ALL-NEXT:    [[X_MASKED_LEADINGONEPOS:%.*]] = add nsw i32 [[X_MASKED_NUMACTIVEBITS]], -1, !dbg [[DBG61]]
; ALL-NEXT:    [[LOOP_BACKEDGETAKENCOUNT:%.*]] = sub nuw nsw i32 24, [[X_MASKED_LEADINGONEPOS]], !dbg [[DBG61]]
; ALL-NEXT:    [[LOOP_TRIPCOUNT:%.*]] = add nuw nsw i32 [[LOOP_BACKEDGETAKENCOUNT]], 1, !dbg [[DBG61]]
; ALL-NEXT:    [[X_CURR:%.*]] = shl i32 [[X]], [[LOOP_BACKEDGETAKENCOUNT]], !dbg [[DBG61]]
; ALL-NEXT:    [[X_NEXT:%.*]] = shl i32 [[X]], [[LOOP_TRIPCOUNT]], !dbg [[DBG61]]
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG62:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:    [[LOOP_IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[LOOP_IV_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG61]]
; ALL-NEXT:    [[TMP0:%.*]] = phi i32 [ [[X]], [[ENTRY]] ], [ [[TMP1:%.*]], [[LOOP]] ], !dbg [[DBG61]]
; ALL-NEXT:      #dbg_value(i32 [[TMP0]], [[META57:![0-9]+]], !DIExpression(), [[DBG61]])
; ALL-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i32 [[TMP0]], 16777216, !dbg [[DBG63:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR_BITMASKED]], [[META58:![0-9]+]], !DIExpression(), [[DBG63]])
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i32 [[X_CURR_BITMASKED]], 0, !dbg [[DBG64:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META59:![0-9]+]], !DIExpression(), [[DBG64]])
; ALL-NEXT:    [[TMP1]] = shl i32 [[TMP0]], 1, !dbg [[DBG65:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[TMP1]], [[META60:![0-9]+]], !DIExpression(), [[DBG65]])
; ALL-NEXT:    [[LOOP_IV_NEXT]] = add nuw nsw i32 [[LOOP_IV]], 1, !dbg [[DBG66:![0-9]+]]
; ALL-NEXT:    [[LOOP_IVCHECK:%.*]] = icmp eq i32 [[LOOP_IV_NEXT]], [[LOOP_TRIPCOUNT]], !dbg [[DBG66]]
; ALL-NEXT:    br i1 [[LOOP_IVCHECK]], label [[END:%.*]], label [[LOOP]], !dbg [[DBG66]]
; ALL:       end:
; ALL-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i32 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG61]]
; ALL-NEXT:    [[X_NEXT_LCSSA:%.*]] = phi i32 [ [[X_NEXT]], [[LOOP]] ], !dbg [[DBG65]]
; ALL-NEXT:    store i32 [[X_CURR_LCSSA]], ptr [[P0:%.*]], align 4, !dbg [[DBG67:![0-9]+]]
; ALL-NEXT:    store i32 [[X_NEXT_LCSSA]], ptr [[P1:%.*]], align 4, !dbg [[DBG68:![0-9]+]]
; ALL-NEXT:    ret void, !dbg [[DBG69:![0-9]+]]
;
entry:
  br label %loop

loop:
  %x.curr = phi i32 [ %x, %entry ], [ %x.next, %loop ]
  %x.curr.bitmasked = and i32 %x.curr, 16777216
  %x.curr.isbitunset = icmp eq i32 %x.curr.bitmasked, 0
  %x.next = shl i32 %x.curr, 1
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  store i32 %x.curr, ptr %p0
  store i32 %x.next, ptr %p1
  ret void
}

define void @p4_constant_mask_15thbit(i32 %x, ptr %p0, ptr %p1) {
; ALL-LABEL: @p4_constant_mask_15thbit(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[X_MASKED:%.*]] = and i32 [[X:%.*]], 65535, !dbg [[DBG76:![0-9]+]]
; ALL-NEXT:    [[X_MASKED_NUMLEADINGZEROS:%.*]] = call i32 @llvm.ctlz.i32(i32 [[X_MASKED]], i1 true), !dbg [[DBG76]]
; ALL-NEXT:    [[X_MASKED_NUMACTIVEBITS:%.*]] = sub nuw nsw i32 32, [[X_MASKED_NUMLEADINGZEROS]], !dbg [[DBG76]]
; ALL-NEXT:    [[X_MASKED_LEADINGONEPOS:%.*]] = add nsw i32 [[X_MASKED_NUMACTIVEBITS]], -1, !dbg [[DBG76]]
; ALL-NEXT:    [[LOOP_BACKEDGETAKENCOUNT:%.*]] = sub nuw nsw i32 15, [[X_MASKED_LEADINGONEPOS]], !dbg [[DBG76]]
; ALL-NEXT:    [[LOOP_TRIPCOUNT:%.*]] = add nuw nsw i32 [[LOOP_BACKEDGETAKENCOUNT]], 1, !dbg [[DBG76]]
; ALL-NEXT:    [[X_CURR:%.*]] = shl i32 [[X]], [[LOOP_BACKEDGETAKENCOUNT]], !dbg [[DBG76]]
; ALL-NEXT:    [[X_NEXT:%.*]] = shl i32 [[X]], [[LOOP_TRIPCOUNT]], !dbg [[DBG76]]
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG77:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:    [[LOOP_IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[LOOP_IV_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG76]]
; ALL-NEXT:    [[TMP0:%.*]] = phi i32 [ [[X]], [[ENTRY]] ], [ [[TMP1:%.*]], [[LOOP]] ], !dbg [[DBG76]]
; ALL-NEXT:      #dbg_value(i32 [[TMP0]], [[META72:![0-9]+]], !DIExpression(), [[DBG76]])
; ALL-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i32 [[TMP0]], 32768, !dbg [[DBG78:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR_BITMASKED]], [[META73:![0-9]+]], !DIExpression(), [[DBG78]])
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i32 [[X_CURR_BITMASKED]], 0, !dbg [[DBG79:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META74:![0-9]+]], !DIExpression(), [[DBG79]])
; ALL-NEXT:    [[TMP1]] = shl i32 [[TMP0]], 1, !dbg [[DBG80:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[TMP1]], [[META75:![0-9]+]], !DIExpression(), [[DBG80]])
; ALL-NEXT:    [[LOOP_IV_NEXT]] = add nuw nsw i32 [[LOOP_IV]], 1, !dbg [[DBG81:![0-9]+]]
; ALL-NEXT:    [[LOOP_IVCHECK:%.*]] = icmp eq i32 [[LOOP_IV_NEXT]], [[LOOP_TRIPCOUNT]], !dbg [[DBG81]]
; ALL-NEXT:    br i1 [[LOOP_IVCHECK]], label [[END:%.*]], label [[LOOP]], !dbg [[DBG81]]
; ALL:       end:
; ALL-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i32 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG76]]
; ALL-NEXT:    [[X_NEXT_LCSSA:%.*]] = phi i32 [ [[X_NEXT]], [[LOOP]] ], !dbg [[DBG80]]
; ALL-NEXT:    store i32 [[X_CURR_LCSSA]], ptr [[P0:%.*]], align 4, !dbg [[DBG82:![0-9]+]]
; ALL-NEXT:    store i32 [[X_NEXT_LCSSA]], ptr [[P1:%.*]], align 4, !dbg [[DBG83:![0-9]+]]
; ALL-NEXT:    ret void, !dbg [[DBG84:![0-9]+]]
;
entry:
  br label %loop

loop:
  %x.curr = phi i32 [ %x, %entry ], [ %x.next, %loop ]
  %x.curr.bitmasked = and i32 %x.curr, 32768
  %x.curr.isbitunset = icmp eq i32 %x.curr.bitmasked, 0
  %x.next = shl i32 %x.curr, 1
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  store i32 %x.curr, ptr %p0
  store i32 %x.next, ptr %p1
  ret void
}

; All no-wrap flags can be kept on the shift.
define void @p5_nuw(i32 %x, i32 %bit, ptr %p0, ptr %p1) {
; ALL-LABEL: @p5_nuw(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[BIT_FR:%.*]] = freeze i32 [[BIT:%.*]]
; ALL-NEXT:    [[BITMASK:%.*]] = shl i32 1, [[BIT_FR]], !dbg [[DBG92:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[BITMASK]], [[META87:![0-9]+]], !DIExpression(), [[DBG92]])
; ALL-NEXT:    [[BIT_FR_LOWBITMASK:%.*]] = add i32 [[BITMASK]], -1, !dbg [[DBG93:![0-9]+]]
; ALL-NEXT:    [[BIT_FR_MASK:%.*]] = or i32 [[BIT_FR_LOWBITMASK]], [[BITMASK]], !dbg [[DBG93]]
; ALL-NEXT:    [[X_MASKED:%.*]] = and i32 [[X:%.*]], [[BIT_FR_MASK]], !dbg [[DBG93]]
; ALL-NEXT:    [[X_MASKED_NUMLEADINGZEROS:%.*]] = call i32 @llvm.ctlz.i32(i32 [[X_MASKED]], i1 true), !dbg [[DBG93]]
; ALL-NEXT:    [[X_MASKED_NUMACTIVEBITS:%.*]] = sub nuw nsw i32 32, [[X_MASKED_NUMLEADINGZEROS]], !dbg [[DBG93]]
; ALL-NEXT:    [[X_MASKED_LEADINGONEPOS:%.*]] = add nsw i32 [[X_MASKED_NUMACTIVEBITS]], -1, !dbg [[DBG93]]
; ALL-NEXT:    [[LOOP_BACKEDGETAKENCOUNT:%.*]] = sub nuw nsw i32 [[BIT_FR]], [[X_MASKED_LEADINGONEPOS]], !dbg [[DBG93]]
; ALL-NEXT:    [[LOOP_TRIPCOUNT:%.*]] = add nuw nsw i32 [[LOOP_BACKEDGETAKENCOUNT]], 1, !dbg [[DBG93]]
; ALL-NEXT:    [[X_CURR:%.*]] = shl nuw i32 [[X]], [[LOOP_BACKEDGETAKENCOUNT]], !dbg [[DBG93]]
; ALL-NEXT:    [[X_NEXT:%.*]] = shl nuw i32 [[X]], [[LOOP_TRIPCOUNT]], !dbg [[DBG93]]
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG94:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:    [[LOOP_IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[LOOP_IV_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG93]]
; ALL-NEXT:    [[TMP0:%.*]] = phi i32 [ [[X]], [[ENTRY]] ], [ [[TMP1:%.*]], [[LOOP]] ], !dbg [[DBG93]]
; ALL-NEXT:      #dbg_value(i32 [[TMP0]], [[META88:![0-9]+]], !DIExpression(), [[DBG93]])
; ALL-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i32 [[TMP0]], [[BITMASK]], !dbg [[DBG95:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR_BITMASKED]], [[META89:![0-9]+]], !DIExpression(), [[DBG95]])
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i32 [[X_CURR_BITMASKED]], 0, !dbg [[DBG96:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META90:![0-9]+]], !DIExpression(), [[DBG96]])
; ALL-NEXT:    [[TMP1]] = shl nuw i32 [[TMP0]], 1, !dbg [[DBG97:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[TMP1]], [[META91:![0-9]+]], !DIExpression(), [[DBG97]])
; ALL-NEXT:    [[LOOP_IV_NEXT]] = add nuw nsw i32 [[LOOP_IV]], 1, !dbg [[DBG98:![0-9]+]]
; ALL-NEXT:    [[LOOP_IVCHECK:%.*]] = icmp eq i32 [[LOOP_IV_NEXT]], [[LOOP_TRIPCOUNT]], !dbg [[DBG98]]
; ALL-NEXT:    br i1 [[LOOP_IVCHECK]], label [[END:%.*]], label [[LOOP]], !dbg [[DBG98]]
; ALL:       end:
; ALL-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i32 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG93]]
; ALL-NEXT:    [[X_NEXT_LCSSA:%.*]] = phi i32 [ [[X_NEXT]], [[LOOP]] ], !dbg [[DBG97]]
; ALL-NEXT:    store i32 [[X_CURR_LCSSA]], ptr [[P0:%.*]], align 4, !dbg [[DBG99:![0-9]+]]
; ALL-NEXT:    store i32 [[X_NEXT_LCSSA]], ptr [[P1:%.*]], align 4, !dbg [[DBG100:![0-9]+]]
; ALL-NEXT:    ret void, !dbg [[DBG101:![0-9]+]]
;
entry:
  %bitmask = shl i32 1, %bit
  br label %loop

loop:
  %x.curr = phi i32 [ %x, %entry ], [ %x.next, %loop ]
  %x.curr.bitmasked = and i32 %x.curr, %bitmask
  %x.curr.isbitunset = icmp eq i32 %x.curr.bitmasked, 0
  %x.next = shl nuw i32 %x.curr, 1
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  store i32 %x.curr, ptr %p0
  store i32 %x.next, ptr %p1
  ret void
}
define void @p6_nsw(i32 %x, i32 %bit, ptr %p0, ptr %p1) {
; ALL-LABEL: @p6_nsw(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[BIT_FR:%.*]] = freeze i32 [[BIT:%.*]]
; ALL-NEXT:    [[BITMASK:%.*]] = shl i32 1, [[BIT_FR]], !dbg [[DBG109:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[BITMASK]], [[META104:![0-9]+]], !DIExpression(), [[DBG109]])
; ALL-NEXT:    [[BIT_FR_LOWBITMASK:%.*]] = add i32 [[BITMASK]], -1, !dbg [[DBG110:![0-9]+]]
; ALL-NEXT:    [[BIT_FR_MASK:%.*]] = or i32 [[BIT_FR_LOWBITMASK]], [[BITMASK]], !dbg [[DBG110]]
; ALL-NEXT:    [[X_MASKED:%.*]] = and i32 [[X:%.*]], [[BIT_FR_MASK]], !dbg [[DBG110]]
; ALL-NEXT:    [[X_MASKED_NUMLEADINGZEROS:%.*]] = call i32 @llvm.ctlz.i32(i32 [[X_MASKED]], i1 true), !dbg [[DBG110]]
; ALL-NEXT:    [[X_MASKED_NUMACTIVEBITS:%.*]] = sub nuw nsw i32 32, [[X_MASKED_NUMLEADINGZEROS]], !dbg [[DBG110]]
; ALL-NEXT:    [[X_MASKED_LEADINGONEPOS:%.*]] = add nsw i32 [[X_MASKED_NUMACTIVEBITS]], -1, !dbg [[DBG110]]
; ALL-NEXT:    [[LOOP_BACKEDGETAKENCOUNT:%.*]] = sub nuw nsw i32 [[BIT_FR]], [[X_MASKED_LEADINGONEPOS]], !dbg [[DBG110]]
; ALL-NEXT:    [[LOOP_TRIPCOUNT:%.*]] = add nuw nsw i32 [[LOOP_BACKEDGETAKENCOUNT]], 1, !dbg [[DBG110]]
; ALL-NEXT:    [[X_CURR:%.*]] = shl nsw i32 [[X]], [[LOOP_BACKEDGETAKENCOUNT]], !dbg [[DBG110]]
; ALL-NEXT:    [[X_NEXT:%.*]] = shl nsw i32 [[X]], [[LOOP_TRIPCOUNT]], !dbg [[DBG110]]
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG111:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:    [[LOOP_IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[LOOP_IV_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG110]]
; ALL-NEXT:    [[TMP0:%.*]] = phi i32 [ [[X]], [[ENTRY]] ], [ [[TMP1:%.*]], [[LOOP]] ], !dbg [[DBG110]]
; ALL-NEXT:      #dbg_value(i32 [[TMP0]], [[META105:![0-9]+]], !DIExpression(), [[DBG110]])
; ALL-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i32 [[TMP0]], [[BITMASK]], !dbg [[DBG112:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR_BITMASKED]], [[META106:![0-9]+]], !DIExpression(), [[DBG112]])
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i32 [[X_CURR_BITMASKED]], 0, !dbg [[DBG113:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META107:![0-9]+]], !DIExpression(), [[DBG113]])
; ALL-NEXT:    [[TMP1]] = shl nsw i32 [[TMP0]], 1, !dbg [[DBG114:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[TMP1]], [[META108:![0-9]+]], !DIExpression(), [[DBG114]])
; ALL-NEXT:    [[LOOP_IV_NEXT]] = add nuw nsw i32 [[LOOP_IV]], 1, !dbg [[DBG115:![0-9]+]]
; ALL-NEXT:    [[LOOP_IVCHECK:%.*]] = icmp eq i32 [[LOOP_IV_NEXT]], [[LOOP_TRIPCOUNT]], !dbg [[DBG115]]
; ALL-NEXT:    br i1 [[LOOP_IVCHECK]], label [[END:%.*]], label [[LOOP]], !dbg [[DBG115]]
; ALL:       end:
; ALL-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i32 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG110]]
; ALL-NEXT:    [[X_NEXT_LCSSA:%.*]] = phi i32 [ [[X_NEXT]], [[LOOP]] ], !dbg [[DBG114]]
; ALL-NEXT:    store i32 [[X_CURR_LCSSA]], ptr [[P0:%.*]], align 4, !dbg [[DBG116:![0-9]+]]
; ALL-NEXT:    store i32 [[X_NEXT_LCSSA]], ptr [[P1:%.*]], align 4, !dbg [[DBG117:![0-9]+]]
; ALL-NEXT:    ret void, !dbg [[DBG118:![0-9]+]]
;
entry:
  %bitmask = shl i32 1, %bit
  br label %loop

loop:
  %x.curr = phi i32 [ %x, %entry ], [ %x.next, %loop ]
  %x.curr.bitmasked = and i32 %x.curr, %bitmask
  %x.curr.isbitunset = icmp eq i32 %x.curr.bitmasked, 0
  %x.next = shl nsw i32 %x.curr, 1
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  store i32 %x.curr, ptr %p0
  store i32 %x.next, ptr %p1
  ret void
}
define void @p7_nuwnsw(i32 %x, i32 %bit, ptr %p0, ptr %p1) {
; ALL-LABEL: @p7_nuwnsw(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[BIT_FR:%.*]] = freeze i32 [[BIT:%.*]]
; ALL-NEXT:    [[BITMASK:%.*]] = shl i32 1, [[BIT_FR]], !dbg [[DBG126:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[BITMASK]], [[META121:![0-9]+]], !DIExpression(), [[DBG126]])
; ALL-NEXT:    [[BIT_FR_LOWBITMASK:%.*]] = add i32 [[BITMASK]], -1, !dbg [[DBG127:![0-9]+]]
; ALL-NEXT:    [[BIT_FR_MASK:%.*]] = or i32 [[BIT_FR_LOWBITMASK]], [[BITMASK]], !dbg [[DBG127]]
; ALL-NEXT:    [[X_MASKED:%.*]] = and i32 [[X:%.*]], [[BIT_FR_MASK]], !dbg [[DBG127]]
; ALL-NEXT:    [[X_MASKED_NUMLEADINGZEROS:%.*]] = call i32 @llvm.ctlz.i32(i32 [[X_MASKED]], i1 true), !dbg [[DBG127]]
; ALL-NEXT:    [[X_MASKED_NUMACTIVEBITS:%.*]] = sub nuw nsw i32 32, [[X_MASKED_NUMLEADINGZEROS]], !dbg [[DBG127]]
; ALL-NEXT:    [[X_MASKED_LEADINGONEPOS:%.*]] = add nsw i32 [[X_MASKED_NUMACTIVEBITS]], -1, !dbg [[DBG127]]
; ALL-NEXT:    [[LOOP_BACKEDGETAKENCOUNT:%.*]] = sub nuw nsw i32 [[BIT_FR]], [[X_MASKED_LEADINGONEPOS]], !dbg [[DBG127]]
; ALL-NEXT:    [[LOOP_TRIPCOUNT:%.*]] = add nuw nsw i32 [[LOOP_BACKEDGETAKENCOUNT]], 1, !dbg [[DBG127]]
; ALL-NEXT:    [[X_CURR:%.*]] = shl nuw nsw i32 [[X]], [[LOOP_BACKEDGETAKENCOUNT]], !dbg [[DBG127]]
; ALL-NEXT:    [[X_NEXT:%.*]] = shl nuw nsw i32 [[X]], [[LOOP_TRIPCOUNT]], !dbg [[DBG127]]
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG128:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:    [[LOOP_IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[LOOP_IV_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG127]]
; ALL-NEXT:    [[TMP0:%.*]] = phi i32 [ [[X]], [[ENTRY]] ], [ [[TMP1:%.*]], [[LOOP]] ], !dbg [[DBG127]]
; ALL-NEXT:      #dbg_value(i32 [[TMP0]], [[META122:![0-9]+]], !DIExpression(), [[DBG127]])
; ALL-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i32 [[TMP0]], [[BITMASK]], !dbg [[DBG129:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR_BITMASKED]], [[META123:![0-9]+]], !DIExpression(), [[DBG129]])
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i32 [[X_CURR_BITMASKED]], 0, !dbg [[DBG130:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META124:![0-9]+]], !DIExpression(), [[DBG130]])
; ALL-NEXT:    [[TMP1]] = shl nuw nsw i32 [[TMP0]], 1, !dbg [[DBG131:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[TMP1]], [[META125:![0-9]+]], !DIExpression(), [[DBG131]])
; ALL-NEXT:    [[LOOP_IV_NEXT]] = add nuw nsw i32 [[LOOP_IV]], 1, !dbg [[DBG132:![0-9]+]]
; ALL-NEXT:    [[LOOP_IVCHECK:%.*]] = icmp eq i32 [[LOOP_IV_NEXT]], [[LOOP_TRIPCOUNT]], !dbg [[DBG132]]
; ALL-NEXT:    br i1 [[LOOP_IVCHECK]], label [[END:%.*]], label [[LOOP]], !dbg [[DBG132]]
; ALL:       end:
; ALL-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i32 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG127]]
; ALL-NEXT:    [[X_NEXT_LCSSA:%.*]] = phi i32 [ [[X_NEXT]], [[LOOP]] ], !dbg [[DBG131]]
; ALL-NEXT:    store i32 [[X_CURR_LCSSA]], ptr [[P0:%.*]], align 4, !dbg [[DBG133:![0-9]+]]
; ALL-NEXT:    store i32 [[X_NEXT_LCSSA]], ptr [[P1:%.*]], align 4, !dbg [[DBG134:![0-9]+]]
; ALL-NEXT:    ret void, !dbg [[DBG135:![0-9]+]]
;
entry:
  %bitmask = shl i32 1, %bit
  br label %loop

loop:
  %x.curr = phi i32 [ %x, %entry ], [ %x.next, %loop ]
  %x.curr.bitmasked = and i32 %x.curr, %bitmask
  %x.curr.isbitunset = icmp eq i32 %x.curr.bitmasked, 0
  %x.next = shl nuw nsw i32 %x.curr, 1
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  store i32 %x.curr, ptr %p0
  store i32 %x.next, ptr %p1
  ret void
}

define void @p8_constant_mask_signbit_noncanonical(i32 %x, ptr %p0, ptr %p1) {
; ALL-LABEL: @p8_constant_mask_signbit_noncanonical(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[X_MASKED:%.*]] = and i32 [[X:%.*]], -1, !dbg [[DBG142:![0-9]+]]
; ALL-NEXT:    [[X_MASKED_NUMLEADINGZEROS:%.*]] = call i32 @llvm.ctlz.i32(i32 [[X_MASKED]], i1 true), !dbg [[DBG142]]
; ALL-NEXT:    [[X_MASKED_NUMACTIVEBITS:%.*]] = sub nuw nsw i32 32, [[X_MASKED_NUMLEADINGZEROS]], !dbg [[DBG142]]
; ALL-NEXT:    [[X_MASKED_LEADINGONEPOS:%.*]] = add nsw i32 [[X_MASKED_NUMACTIVEBITS]], -1, !dbg [[DBG142]]
; ALL-NEXT:    [[LOOP_BACKEDGETAKENCOUNT:%.*]] = sub nuw nsw i32 31, [[X_MASKED_LEADINGONEPOS]], !dbg [[DBG142]]
; ALL-NEXT:    [[LOOP_TRIPCOUNT:%.*]] = add nuw nsw i32 [[LOOP_BACKEDGETAKENCOUNT]], 1, !dbg [[DBG142]]
; ALL-NEXT:    [[X_CURR:%.*]] = shl i32 [[X]], [[LOOP_BACKEDGETAKENCOUNT]], !dbg [[DBG142]]
; ALL-NEXT:    [[X_NEXT:%.*]] = shl i32 [[X_CURR]], 1, !dbg [[DBG142]]
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG143:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:    [[LOOP_IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[LOOP_IV_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG142]]
; ALL-NEXT:    [[TMP0:%.*]] = phi i32 [ [[X]], [[ENTRY]] ], [ [[TMP1:%.*]], [[LOOP]] ], !dbg [[DBG142]]
; ALL-NEXT:      #dbg_value(i32 [[TMP0]], [[META138:![0-9]+]], !DIExpression(), [[DBG142]])
; ALL-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i32 [[TMP0]], -2147483648, !dbg [[DBG144:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR_BITMASKED]], [[META139:![0-9]+]], !DIExpression(), [[DBG144]])
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i32 [[X_CURR_BITMASKED]], 0, !dbg [[DBG145:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META140:![0-9]+]], !DIExpression(), [[DBG145]])
; ALL-NEXT:    [[TMP1]] = shl i32 [[TMP0]], 1, !dbg [[DBG146:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[TMP1]], [[META141:![0-9]+]], !DIExpression(), [[DBG146]])
; ALL-NEXT:    [[LOOP_IV_NEXT]] = add nuw nsw i32 [[LOOP_IV]], 1, !dbg [[DBG147:![0-9]+]]
; ALL-NEXT:    [[LOOP_IVCHECK:%.*]] = icmp eq i32 [[LOOP_IV_NEXT]], [[LOOP_TRIPCOUNT]], !dbg [[DBG147]]
; ALL-NEXT:    br i1 [[LOOP_IVCHECK]], label [[END:%.*]], label [[LOOP]], !dbg [[DBG147]]
; ALL:       end:
; ALL-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i32 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG142]]
; ALL-NEXT:    [[X_NEXT_LCSSA:%.*]] = phi i32 [ [[X_NEXT]], [[LOOP]] ], !dbg [[DBG146]]
; ALL-NEXT:    store i32 [[X_CURR_LCSSA]], ptr [[P0:%.*]], align 4, !dbg [[DBG148:![0-9]+]]
; ALL-NEXT:    store i32 [[X_NEXT_LCSSA]], ptr [[P1:%.*]], align 4, !dbg [[DBG149:![0-9]+]]
; ALL-NEXT:    ret void, !dbg [[DBG150:![0-9]+]]
;
entry:
  br label %loop

loop:
  %x.curr = phi i32 [ %x, %entry ], [ %x.next, %loop ]
  %x.curr.bitmasked = and i32 %x.curr, 2147483648
  %x.curr.isbitunset = icmp eq i32 %x.curr.bitmasked, 0
  %x.next = shl i32 %x.curr, 1
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  store i32 %x.curr, ptr %p0
  store i32 %x.next, ptr %p1
  ret void
}

define void @p9_constant_mask_signbit_canonical(i32 %x, ptr %p0, ptr %p1) {
; ALL-LABEL: @p9_constant_mask_signbit_canonical(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[X_MASKED:%.*]] = and i32 [[X:%.*]], -1, !dbg [[DBG156:![0-9]+]]
; ALL-NEXT:    [[X_MASKED_NUMLEADINGZEROS:%.*]] = call i32 @llvm.ctlz.i32(i32 [[X_MASKED]], i1 true), !dbg [[DBG156]]
; ALL-NEXT:    [[X_MASKED_NUMACTIVEBITS:%.*]] = sub nuw nsw i32 32, [[X_MASKED_NUMLEADINGZEROS]], !dbg [[DBG156]]
; ALL-NEXT:    [[X_MASKED_LEADINGONEPOS:%.*]] = add nsw i32 [[X_MASKED_NUMACTIVEBITS]], -1, !dbg [[DBG156]]
; ALL-NEXT:    [[LOOP_BACKEDGETAKENCOUNT:%.*]] = sub nuw nsw i32 31, [[X_MASKED_LEADINGONEPOS]], !dbg [[DBG156]]
; ALL-NEXT:    [[LOOP_TRIPCOUNT:%.*]] = add nuw nsw i32 [[LOOP_BACKEDGETAKENCOUNT]], 1, !dbg [[DBG156]]
; ALL-NEXT:    [[X_CURR:%.*]] = shl i32 [[X]], [[LOOP_BACKEDGETAKENCOUNT]], !dbg [[DBG156]]
; ALL-NEXT:    [[X_NEXT:%.*]] = shl i32 [[X_CURR]], 1, !dbg [[DBG156]]
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG157:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:    [[LOOP_IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[LOOP_IV_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG156]]
; ALL-NEXT:    [[TMP0:%.*]] = phi i32 [ [[X]], [[ENTRY]] ], [ [[TMP1:%.*]], [[LOOP]] ], !dbg [[DBG156]]
; ALL-NEXT:      #dbg_value(i32 [[TMP0]], [[META153:![0-9]+]], !DIExpression(), [[DBG156]])
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp sgt i32 [[TMP0]], -1, !dbg [[DBG158:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META154:![0-9]+]], !DIExpression(), [[DBG158]])
; ALL-NEXT:    [[TMP1]] = shl i32 [[TMP0]], 1, !dbg [[DBG159:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[TMP1]], [[META155:![0-9]+]], !DIExpression(), [[DBG159]])
; ALL-NEXT:    [[LOOP_IV_NEXT]] = add nuw nsw i32 [[LOOP_IV]], 1, !dbg [[DBG160:![0-9]+]]
; ALL-NEXT:    [[LOOP_IVCHECK:%.*]] = icmp eq i32 [[LOOP_IV_NEXT]], [[LOOP_TRIPCOUNT]], !dbg [[DBG160]]
; ALL-NEXT:    br i1 [[LOOP_IVCHECK]], label [[END:%.*]], label [[LOOP]], !dbg [[DBG160]]
; ALL:       end:
; ALL-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i32 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG156]]
; ALL-NEXT:    [[X_NEXT_LCSSA:%.*]] = phi i32 [ [[X_NEXT]], [[LOOP]] ], !dbg [[DBG159]]
; ALL-NEXT:    store i32 [[X_CURR_LCSSA]], ptr [[P0:%.*]], align 4, !dbg [[DBG161:![0-9]+]]
; ALL-NEXT:    store i32 [[X_NEXT_LCSSA]], ptr [[P1:%.*]], align 4, !dbg [[DBG162:![0-9]+]]
; ALL-NEXT:    ret void, !dbg [[DBG163:![0-9]+]]
;
entry:
  br label %loop

loop:
  %x.curr = phi i32 [ %x, %entry ], [ %x.next, %loop ]
  %x.curr.isbitunset = icmp sgt i32 %x.curr, -1
  %x.next = shl i32 %x.curr, 1
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  store i32 %x.curr, ptr %p0
  store i32 %x.next, ptr %p1
  ret void
}

define void @p10_x_is_not_one(i32 %bit, ptr %p0, ptr %p1) {
; ALL-LABEL: @p10_x_is_not_one(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[BIT_FR:%.*]] = freeze i32 [[BIT:%.*]]
; ALL-NEXT:    [[BITMASK:%.*]] = shl i32 1, [[BIT_FR]], !dbg [[DBG171:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[BITMASK]], [[META166:![0-9]+]], !DIExpression(), [[DBG171]])
; ALL-NEXT:    [[BIT_FR_LOWBITMASK:%.*]] = add i32 [[BITMASK]], -1, !dbg [[DBG172:![0-9]+]]
; ALL-NEXT:    [[BIT_FR_MASK:%.*]] = or i32 [[BIT_FR_LOWBITMASK]], [[BITMASK]], !dbg [[DBG172]]
; ALL-NEXT:    [[DOTMASKED:%.*]] = and i32 2, [[BIT_FR_MASK]], !dbg [[DBG172]]
; ALL-NEXT:    [[DOTMASKED_NUMLEADINGZEROS:%.*]] = call i32 @llvm.ctlz.i32(i32 [[DOTMASKED]], i1 true), !dbg [[DBG172]]
; ALL-NEXT:    [[DOTMASKED_NUMACTIVEBITS:%.*]] = sub nuw nsw i32 32, [[DOTMASKED_NUMLEADINGZEROS]], !dbg [[DBG172]]
; ALL-NEXT:    [[DOTMASKED_LEADINGONEPOS:%.*]] = add nsw i32 [[DOTMASKED_NUMACTIVEBITS]], -1, !dbg [[DBG172]]
; ALL-NEXT:    [[LOOP_BACKEDGETAKENCOUNT:%.*]] = sub nuw nsw i32 [[BIT_FR]], [[DOTMASKED_LEADINGONEPOS]], !dbg [[DBG172]]
; ALL-NEXT:    [[LOOP_TRIPCOUNT:%.*]] = add nuw nsw i32 [[LOOP_BACKEDGETAKENCOUNT]], 1, !dbg [[DBG172]]
; ALL-NEXT:    [[X_CURR:%.*]] = shl i32 2, [[LOOP_BACKEDGETAKENCOUNT]], !dbg [[DBG172]]
; ALL-NEXT:    [[X_NEXT:%.*]] = shl i32 [[X_CURR]], 1, !dbg [[DBG172]]
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG173:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:    [[LOOP_IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[LOOP_IV_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG172]]
; ALL-NEXT:    [[TMP0:%.*]] = phi i32 [ 2, [[ENTRY]] ], [ [[TMP1:%.*]], [[LOOP]] ], !dbg [[DBG172]]
; ALL-NEXT:      #dbg_value(i32 [[TMP0]], [[META167:![0-9]+]], !DIExpression(), [[DBG172]])
; ALL-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i32 [[TMP0]], [[BITMASK]], !dbg [[DBG174:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR_BITMASKED]], [[META168:![0-9]+]], !DIExpression(), [[DBG174]])
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i32 [[X_CURR_BITMASKED]], 0, !dbg [[DBG175:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META169:![0-9]+]], !DIExpression(), [[DBG175]])
; ALL-NEXT:    [[TMP1]] = shl i32 [[TMP0]], 1, !dbg [[DBG176:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[TMP1]], [[META170:![0-9]+]], !DIExpression(), [[DBG176]])
; ALL-NEXT:    [[LOOP_IV_NEXT]] = add nuw nsw i32 [[LOOP_IV]], 1, !dbg [[DBG177:![0-9]+]]
; ALL-NEXT:    [[LOOP_IVCHECK:%.*]] = icmp eq i32 [[LOOP_IV_NEXT]], [[LOOP_TRIPCOUNT]], !dbg [[DBG177]]
; ALL-NEXT:    br i1 [[LOOP_IVCHECK]], label [[END:%.*]], label [[LOOP]], !dbg [[DBG177]]
; ALL:       end:
; ALL-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i32 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG172]]
; ALL-NEXT:    [[X_NEXT_LCSSA:%.*]] = phi i32 [ [[X_NEXT]], [[LOOP]] ], !dbg [[DBG176]]
; ALL-NEXT:    store i32 [[X_CURR_LCSSA]], ptr [[P0:%.*]], align 4, !dbg [[DBG178:![0-9]+]]
; ALL-NEXT:    store i32 [[X_NEXT_LCSSA]], ptr [[P1:%.*]], align 4, !dbg [[DBG179:![0-9]+]]
; ALL-NEXT:    ret void, !dbg [[DBG180:![0-9]+]]
;
entry:
  %bitmask = shl i32 1, %bit
  br label %loop

loop:
  %x.curr = phi i32 [ 2, %entry ], [ %x.next, %loop ]
  %x.curr.bitmasked = and i32 %x.curr, %bitmask
  %x.curr.isbitunset = icmp eq i32 %x.curr.bitmasked, 0
  %x.next = shl i32 %x.curr, 1
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  store i32 %x.curr, ptr %p0
  store i32 %x.next, ptr %p1
  ret void
}

; Check that loop backedge's cmp-br order is correctly handled
define i32 @p11(i32 %x, i32 %bit) {
; ALL-LABEL: @p11(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[BIT_FR:%.*]] = freeze i32 [[BIT:%.*]]
; ALL-NEXT:    [[BITMASK:%.*]] = shl i32 1, [[BIT_FR]], !dbg [[DBG188:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[BITMASK]], [[META183:![0-9]+]], !DIExpression(), [[DBG188]])
; ALL-NEXT:    [[BIT_FR_LOWBITMASK:%.*]] = add i32 [[BITMASK]], -1, !dbg [[DBG189:![0-9]+]]
; ALL-NEXT:    [[BIT_FR_MASK:%.*]] = or i32 [[BIT_FR_LOWBITMASK]], [[BITMASK]], !dbg [[DBG189]]
; ALL-NEXT:    [[X_MASKED:%.*]] = and i32 [[X:%.*]], [[BIT_FR_MASK]], !dbg [[DBG189]]
; ALL-NEXT:    [[X_MASKED_NUMLEADINGZEROS:%.*]] = call i32 @llvm.ctlz.i32(i32 [[X_MASKED]], i1 true), !dbg [[DBG189]]
; ALL-NEXT:    [[X_MASKED_NUMACTIVEBITS:%.*]] = sub nuw nsw i32 32, [[X_MASKED_NUMLEADINGZEROS]], !dbg [[DBG189]]
; ALL-NEXT:    [[X_MASKED_LEADINGONEPOS:%.*]] = add nsw i32 [[X_MASKED_NUMACTIVEBITS]], -1, !dbg [[DBG189]]
; ALL-NEXT:    [[LOOP_BACKEDGETAKENCOUNT:%.*]] = sub nuw nsw i32 [[BIT_FR]], [[X_MASKED_LEADINGONEPOS]], !dbg [[DBG189]]
; ALL-NEXT:    [[LOOP_TRIPCOUNT:%.*]] = add nuw nsw i32 [[LOOP_BACKEDGETAKENCOUNT]], 1, !dbg [[DBG189]]
; ALL-NEXT:    [[X_CURR:%.*]] = shl i32 [[X]], [[LOOP_BACKEDGETAKENCOUNT]], !dbg [[DBG189]]
; ALL-NEXT:    [[X_NEXT:%.*]] = shl i32 [[X_CURR]], 1, !dbg [[DBG189]]
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG190:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:    [[LOOP_IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[LOOP_IV_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG189]]
; ALL-NEXT:    [[TMP0:%.*]] = phi i32 [ [[X]], [[ENTRY]] ], [ [[TMP1:%.*]], [[LOOP]] ], !dbg [[DBG189]]
; ALL-NEXT:      #dbg_value(i32 [[TMP0]], [[META184:![0-9]+]], !DIExpression(), [[DBG189]])
; ALL-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i32 [[TMP0]], [[BITMASK]], !dbg [[DBG191:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR_BITMASKED]], [[META185:![0-9]+]], !DIExpression(), [[DBG191]])
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp ne i32 [[X_CURR_BITMASKED]], 0, !dbg [[DBG192:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META186:![0-9]+]], !DIExpression(), [[DBG192]])
; ALL-NEXT:    [[TMP1]] = shl i32 [[TMP0]], 1, !dbg [[DBG193:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[TMP1]], [[META187:![0-9]+]], !DIExpression(), [[DBG193]])
; ALL-NEXT:    [[LOOP_IV_NEXT]] = add nuw nsw i32 [[LOOP_IV]], 1, !dbg [[DBG194:![0-9]+]]
; ALL-NEXT:    [[LOOP_IVCHECK:%.*]] = icmp eq i32 [[LOOP_IV_NEXT]], [[LOOP_TRIPCOUNT]], !dbg [[DBG194]]
; ALL-NEXT:    br i1 [[LOOP_IVCHECK]], label [[END:%.*]], label [[LOOP]], !dbg [[DBG194]]
; ALL:       end:
; ALL-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i32 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG189]]
; ALL-NEXT:    ret i32 [[X_CURR_LCSSA]], !dbg [[DBG195:![0-9]+]]
;
entry:
  %bitmask = shl i32 1, %bit
  br label %loop

loop:
  %x.curr = phi i32 [ %x, %entry ], [ %x.next, %loop ]
  %x.curr.bitmasked = and i32 %x.curr, %bitmask
  %x.curr.isbitunset = icmp ne i32 %x.curr.bitmasked, 0 ; swapped predicate
  %x.next = shl i32 %x.curr, 1
  br i1 %x.curr.isbitunset, label %end, label %loop ; swapped dests

end:
  ret i32 %x.curr
}

; `and` is commutative, so ensure that order is irrelevant
define i32 @p12(i32 %x, i32 %bit) {
; ALL-LABEL: @p12(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[BIT_FR:%.*]] = freeze i32 [[BIT:%.*]]
; ALL-NEXT:    [[BITMASK:%.*]] = shl i32 1, [[BIT_FR]], !dbg [[DBG203:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[BITMASK]], [[META198:![0-9]+]], !DIExpression(), [[DBG203]])
; ALL-NEXT:    [[BIT_FR_LOWBITMASK:%.*]] = add i32 [[BITMASK]], -1, !dbg [[DBG204:![0-9]+]]
; ALL-NEXT:    [[BIT_FR_MASK:%.*]] = or i32 [[BIT_FR_LOWBITMASK]], [[BITMASK]], !dbg [[DBG204]]
; ALL-NEXT:    [[X_MASKED:%.*]] = and i32 [[X:%.*]], [[BIT_FR_MASK]], !dbg [[DBG204]]
; ALL-NEXT:    [[X_MASKED_NUMLEADINGZEROS:%.*]] = call i32 @llvm.ctlz.i32(i32 [[X_MASKED]], i1 true), !dbg [[DBG204]]
; ALL-NEXT:    [[X_MASKED_NUMACTIVEBITS:%.*]] = sub nuw nsw i32 32, [[X_MASKED_NUMLEADINGZEROS]], !dbg [[DBG204]]
; ALL-NEXT:    [[X_MASKED_LEADINGONEPOS:%.*]] = add nsw i32 [[X_MASKED_NUMACTIVEBITS]], -1, !dbg [[DBG204]]
; ALL-NEXT:    [[LOOP_BACKEDGETAKENCOUNT:%.*]] = sub nuw nsw i32 [[BIT_FR]], [[X_MASKED_LEADINGONEPOS]], !dbg [[DBG204]]
; ALL-NEXT:    [[LOOP_TRIPCOUNT:%.*]] = add nuw nsw i32 [[LOOP_BACKEDGETAKENCOUNT]], 1, !dbg [[DBG204]]
; ALL-NEXT:    [[X_CURR:%.*]] = shl i32 [[X]], [[LOOP_BACKEDGETAKENCOUNT]], !dbg [[DBG204]]
; ALL-NEXT:    [[X_NEXT:%.*]] = shl i32 [[X_CURR]], 1, !dbg [[DBG204]]
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG205:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:    [[LOOP_IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[LOOP_IV_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG204]]
; ALL-NEXT:    [[TMP0:%.*]] = phi i32 [ [[X]], [[ENTRY]] ], [ [[TMP1:%.*]], [[LOOP]] ], !dbg [[DBG204]]
; ALL-NEXT:      #dbg_value(i32 [[TMP0]], [[META199:![0-9]+]], !DIExpression(), [[DBG204]])
; ALL-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i32 [[BITMASK]], [[TMP0]], !dbg [[DBG206:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR_BITMASKED]], [[META200:![0-9]+]], !DIExpression(), [[DBG206]])
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i32 [[X_CURR_BITMASKED]], 0, !dbg [[DBG207:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META201:![0-9]+]], !DIExpression(), [[DBG207]])
; ALL-NEXT:    [[TMP1]] = shl i32 [[TMP0]], 1, !dbg [[DBG208:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[TMP1]], [[META202:![0-9]+]], !DIExpression(), [[DBG208]])
; ALL-NEXT:    [[LOOP_IV_NEXT]] = add nuw nsw i32 [[LOOP_IV]], 1, !dbg [[DBG209:![0-9]+]]
; ALL-NEXT:    [[LOOP_IVCHECK:%.*]] = icmp eq i32 [[LOOP_IV_NEXT]], [[LOOP_TRIPCOUNT]], !dbg [[DBG209]]
; ALL-NEXT:    br i1 [[LOOP_IVCHECK]], label [[END:%.*]], label [[LOOP]], !dbg [[DBG209]]
; ALL:       end:
; ALL-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i32 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG204]]
; ALL-NEXT:    ret i32 [[X_CURR_LCSSA]], !dbg [[DBG210:![0-9]+]]
;
entry:
  %bitmask = shl i32 1, %bit
  br label %loop

loop:
  %x.curr = phi i32 [ %x, %entry ], [ %x.next, %loop ]
  %x.curr.bitmasked = and i32 %bitmask, %x.curr ; swapped
  %x.curr.isbitunset = icmp eq i32 %x.curr.bitmasked, 0
  %x.next = shl i32 %x.curr, 1
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  ret i32 %x.curr
}

; PHI node does not have any particular order for it's incomings,
; but check that the other order still works.
define i32 @p13(i32 %x, i32 %bit) {
; ALL-LABEL: @p13(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[BIT_FR:%.*]] = freeze i32 [[BIT:%.*]]
; ALL-NEXT:    [[BITMASK:%.*]] = shl i32 1, [[BIT_FR]], !dbg [[DBG218:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[BITMASK]], [[META213:![0-9]+]], !DIExpression(), [[DBG218]])
; ALL-NEXT:    [[BIT_FR_LOWBITMASK:%.*]] = add i32 [[BITMASK]], -1, !dbg [[DBG219:![0-9]+]]
; ALL-NEXT:    [[BIT_FR_MASK:%.*]] = or i32 [[BIT_FR_LOWBITMASK]], [[BITMASK]], !dbg [[DBG219]]
; ALL-NEXT:    [[X_MASKED:%.*]] = and i32 [[X:%.*]], [[BIT_FR_MASK]], !dbg [[DBG219]]
; ALL-NEXT:    [[X_MASKED_NUMLEADINGZEROS:%.*]] = call i32 @llvm.ctlz.i32(i32 [[X_MASKED]], i1 true), !dbg [[DBG219]]
; ALL-NEXT:    [[X_MASKED_NUMACTIVEBITS:%.*]] = sub nuw nsw i32 32, [[X_MASKED_NUMLEADINGZEROS]], !dbg [[DBG219]]
; ALL-NEXT:    [[X_MASKED_LEADINGONEPOS:%.*]] = add nsw i32 [[X_MASKED_NUMACTIVEBITS]], -1, !dbg [[DBG219]]
; ALL-NEXT:    [[LOOP_BACKEDGETAKENCOUNT:%.*]] = sub nuw nsw i32 [[BIT_FR]], [[X_MASKED_LEADINGONEPOS]], !dbg [[DBG219]]
; ALL-NEXT:    [[LOOP_TRIPCOUNT:%.*]] = add nuw nsw i32 [[LOOP_BACKEDGETAKENCOUNT]], 1, !dbg [[DBG219]]
; ALL-NEXT:    [[X_CURR:%.*]] = shl i32 [[X]], [[LOOP_BACKEDGETAKENCOUNT]], !dbg [[DBG219]]
; ALL-NEXT:    [[X_NEXT:%.*]] = shl i32 [[X_CURR]], 1, !dbg [[DBG219]]
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG220:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:    [[LOOP_IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[LOOP_IV_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG219]]
; ALL-NEXT:    [[TMP0:%.*]] = phi i32 [ [[TMP1:%.*]], [[LOOP]] ], [ [[X]], [[ENTRY]] ], !dbg [[DBG219]]
; ALL-NEXT:      #dbg_value(i32 [[TMP0]], [[META214:![0-9]+]], !DIExpression(), [[DBG219]])
; ALL-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i32 [[TMP0]], [[BITMASK]], !dbg [[DBG221:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR_BITMASKED]], [[META215:![0-9]+]], !DIExpression(), [[DBG221]])
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i32 [[X_CURR_BITMASKED]], 0, !dbg [[DBG222:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META216:![0-9]+]], !DIExpression(), [[DBG222]])
; ALL-NEXT:    [[TMP1]] = shl i32 [[TMP0]], 1, !dbg [[DBG223:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[TMP1]], [[META217:![0-9]+]], !DIExpression(), [[DBG223]])
; ALL-NEXT:    [[LOOP_IV_NEXT]] = add nuw nsw i32 [[LOOP_IV]], 1, !dbg [[DBG224:![0-9]+]]
; ALL-NEXT:    [[LOOP_IVCHECK:%.*]] = icmp eq i32 [[LOOP_IV_NEXT]], [[LOOP_TRIPCOUNT]], !dbg [[DBG224]]
; ALL-NEXT:    br i1 [[LOOP_IVCHECK]], label [[END:%.*]], label [[LOOP]], !dbg [[DBG224]]
; ALL:       end:
; ALL-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i32 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG219]]
; ALL-NEXT:    ret i32 [[X_CURR_LCSSA]], !dbg [[DBG225:![0-9]+]]
;
entry:
  %bitmask = shl i32 1, %bit
  br label %loop

loop:
  %x.curr = phi i32 [ %x.next, %loop ], [ %x, %entry ]
  %x.curr.bitmasked = and i32 %x.curr, %bitmask
  %x.curr.isbitunset = icmp eq i32 %x.curr.bitmasked, 0
  %x.next = shl i32 %x.curr, 1
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  ret i32 %x.curr
}

; ICmp-Br are commutative
define i32 @p14(i32 %x) {
; ALL-LABEL: @p14(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[X_MASKED:%.*]] = and i32 [[X:%.*]], -1, !dbg [[DBG231:![0-9]+]]
; ALL-NEXT:    [[X_MASKED_NUMLEADINGZEROS:%.*]] = call i32 @llvm.ctlz.i32(i32 [[X_MASKED]], i1 true), !dbg [[DBG231]]
; ALL-NEXT:    [[X_MASKED_NUMACTIVEBITS:%.*]] = sub nuw nsw i32 32, [[X_MASKED_NUMLEADINGZEROS]], !dbg [[DBG231]]
; ALL-NEXT:    [[X_MASKED_LEADINGONEPOS:%.*]] = add nsw i32 [[X_MASKED_NUMACTIVEBITS]], -1, !dbg [[DBG231]]
; ALL-NEXT:    [[LOOP_BACKEDGETAKENCOUNT:%.*]] = sub nuw nsw i32 31, [[X_MASKED_LEADINGONEPOS]], !dbg [[DBG231]]
; ALL-NEXT:    [[LOOP_TRIPCOUNT:%.*]] = add nuw nsw i32 [[LOOP_BACKEDGETAKENCOUNT]], 1, !dbg [[DBG231]]
; ALL-NEXT:    [[X_CURR:%.*]] = shl i32 [[X]], [[LOOP_BACKEDGETAKENCOUNT]], !dbg [[DBG231]]
; ALL-NEXT:    [[X_NEXT:%.*]] = shl i32 [[X_CURR]], 1, !dbg [[DBG231]]
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG232:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:    [[LOOP_IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[LOOP_IV_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG231]]
; ALL-NEXT:    [[TMP0:%.*]] = phi i32 [ [[X]], [[ENTRY]] ], [ [[TMP1:%.*]], [[LOOP]] ], !dbg [[DBG231]]
; ALL-NEXT:      #dbg_value(i32 [[TMP0]], [[META228:![0-9]+]], !DIExpression(), [[DBG231]])
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp slt i32 [[TMP0]], 0, !dbg [[DBG233:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META229:![0-9]+]], !DIExpression(), [[DBG233]])
; ALL-NEXT:    [[TMP1]] = shl i32 [[TMP0]], 1, !dbg [[DBG234:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[TMP1]], [[META230:![0-9]+]], !DIExpression(), [[DBG234]])
; ALL-NEXT:    [[LOOP_IV_NEXT]] = add nuw nsw i32 [[LOOP_IV]], 1, !dbg [[DBG235:![0-9]+]]
; ALL-NEXT:    [[LOOP_IVCHECK:%.*]] = icmp eq i32 [[LOOP_IV_NEXT]], [[LOOP_TRIPCOUNT]], !dbg [[DBG235]]
; ALL-NEXT:    br i1 [[LOOP_IVCHECK]], label [[END:%.*]], label [[LOOP]], !dbg [[DBG235]]
; ALL:       end:
; ALL-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i32 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG231]]
; ALL-NEXT:    ret i32 [[X_CURR_LCSSA]], !dbg [[DBG236:![0-9]+]]
;
entry:
  br label %loop

loop:
  %x.curr = phi i32 [ %x, %entry ], [ %x.next, %loop ]
  %x.curr.isbitunset = icmp slt i32 %x.curr, 0
  %x.next = shl i32 %x.curr, 1
  br i1 %x.curr.isbitunset, label %end, label %loop

end:
  ret i32 %x.curr
}

;-------------------------------------------------------------------------------
; Negative tests

; The %bitmask must be outside of the loop.
define i32 @n15(i32 %x, i32 %bit) {
; ALL-LABEL: @n15(
; ALL-NEXT:  entry:
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG244:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:    [[X_CURR:%.*]] = phi i32 [ [[X:%.*]], [[ENTRY:%.*]] ], [ [[X_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG245:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR]], [[META239:![0-9]+]], !DIExpression(), [[DBG245]])
; ALL-NEXT:    [[BITMASK:%.*]] = shl i32 1, [[BIT:%.*]], !dbg [[DBG246:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[BITMASK]], [[META240:![0-9]+]], !DIExpression(), [[DBG246]])
; ALL-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i32 [[X_CURR]], [[BITMASK]], !dbg [[DBG247:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR_BITMASKED]], [[META241:![0-9]+]], !DIExpression(), [[DBG247]])
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i32 [[X_CURR_BITMASKED]], 0, !dbg [[DBG248:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META242:![0-9]+]], !DIExpression(), [[DBG248]])
; ALL-NEXT:    [[X_NEXT]] = shl i32 [[X_CURR]], 1, !dbg [[DBG249:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_NEXT]], [[META243:![0-9]+]], !DIExpression(), [[DBG249]])
; ALL-NEXT:    br i1 [[X_CURR_ISBITUNSET]], label [[LOOP]], label [[END:%.*]], !dbg [[DBG250:![0-9]+]]
; ALL:       end:
; ALL-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i32 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG245]]
; ALL-NEXT:    ret i32 [[X_CURR_LCSSA]], !dbg [[DBG251:![0-9]+]]
;
entry:
  br label %loop

loop:
  %x.curr = phi i32 [ %x, %entry ], [ %x.next, %loop ]
  %bitmask = shl i32 1, %bit ; not loop-invariant
  %x.curr.bitmasked = and i32 %x.curr, %bitmask
  %x.curr.isbitunset = icmp eq i32 %x.curr.bitmasked, 0
  %x.next = shl i32 %x.curr, 1
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  ret i32 %x.curr
}

; The %bitmask must be loop-invariant
define i32 @n16(i32 %x, i32 %bit) {
; ALL-LABEL: @n16(
; ALL-NEXT:  entry:
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG259:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:    [[X_CURR:%.*]] = phi i32 [ [[X:%.*]], [[ENTRY:%.*]] ], [ [[X_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG260:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR]], [[META254:![0-9]+]], !DIExpression(), [[DBG260]])
; ALL-NEXT:    [[BITMASK:%.*]] = call i32 @gen32(), !dbg [[DBG261:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[BITMASK]], [[META255:![0-9]+]], !DIExpression(), [[DBG261]])
; ALL-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i32 [[X_CURR]], [[BITMASK]], !dbg [[DBG262:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR_BITMASKED]], [[META256:![0-9]+]], !DIExpression(), [[DBG262]])
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i32 [[X_CURR_BITMASKED]], 0, !dbg [[DBG263:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META257:![0-9]+]], !DIExpression(), [[DBG263]])
; ALL-NEXT:    [[X_NEXT]] = shl i32 [[X_CURR]], 1, !dbg [[DBG264:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_NEXT]], [[META258:![0-9]+]], !DIExpression(), [[DBG264]])
; ALL-NEXT:    br i1 [[X_CURR_ISBITUNSET]], label [[LOOP]], label [[END:%.*]], !dbg [[DBG265:![0-9]+]]
; ALL:       end:
; ALL-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i32 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG260]]
; ALL-NEXT:    ret i32 [[X_CURR_LCSSA]], !dbg [[DBG266:![0-9]+]]
;
entry:
  br label %loop

loop:
  %x.curr = phi i32 [ %x, %entry ], [ %x.next, %loop ]
  %bitmask = call i32 @gen32() ; really not loop-invariant
  %x.curr.bitmasked = and i32 %x.curr, %bitmask
  %x.curr.isbitunset = icmp eq i32 %x.curr.bitmasked, 0
  %x.next = shl i32 %x.curr, 1
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  ret i32 %x.curr
}

; The %bitmask must be a left-shift of a single bit.
define i32 @n17(i32 %x, i32 %bit) {
; ALL-LABEL: @n17(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[BITMASK:%.*]] = shl i32 2, [[BIT:%.*]], !dbg [[DBG274:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[BITMASK]], [[META269:![0-9]+]], !DIExpression(), [[DBG274]])
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG275:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:    [[X_CURR:%.*]] = phi i32 [ [[X:%.*]], [[ENTRY:%.*]] ], [ [[X_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG276:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR]], [[META270:![0-9]+]], !DIExpression(), [[DBG276]])
; ALL-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i32 [[X_CURR]], [[BITMASK]], !dbg [[DBG277:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR_BITMASKED]], [[META271:![0-9]+]], !DIExpression(), [[DBG277]])
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i32 [[X_CURR_BITMASKED]], 0, !dbg [[DBG278:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META272:![0-9]+]], !DIExpression(), [[DBG278]])
; ALL-NEXT:    [[X_NEXT]] = shl i32 [[X_CURR]], 1, !dbg [[DBG279:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_NEXT]], [[META273:![0-9]+]], !DIExpression(), [[DBG279]])
; ALL-NEXT:    br i1 [[X_CURR_ISBITUNSET]], label [[LOOP]], label [[END:%.*]], !dbg [[DBG280:![0-9]+]]
; ALL:       end:
; ALL-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i32 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG276]]
; ALL-NEXT:    ret i32 [[X_CURR_LCSSA]], !dbg [[DBG281:![0-9]+]]
;
entry:
  %bitmask = shl i32 2, %bit ; not what we are looking for.
  br label %loop

loop:
  %x.curr = phi i32 [ %x, %entry ], [ %x.next, %loop ]
  %x.curr.bitmasked = and i32 %x.curr, %bitmask
  %x.curr.isbitunset = icmp eq i32 %x.curr.bitmasked, 0
  %x.next = shl i32 %x.curr, 1
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  ret i32 %x.curr
}

; Bad recurrence - should be a left-shift by 1.
define i32 @n18(i32 %x, i32 %bit) {
; ALL-LABEL: @n18(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[BITMASK:%.*]] = shl i32 1, [[BIT:%.*]], !dbg [[DBG289:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[BITMASK]], [[META284:![0-9]+]], !DIExpression(), [[DBG289]])
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG290:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:    [[X_CURR:%.*]] = phi i32 [ [[X:%.*]], [[ENTRY:%.*]] ], [ [[X_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG291:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR]], [[META285:![0-9]+]], !DIExpression(), [[DBG291]])
; ALL-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i32 [[X_CURR]], [[BITMASK]], !dbg [[DBG292:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR_BITMASKED]], [[META286:![0-9]+]], !DIExpression(), [[DBG292]])
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i32 [[X_CURR_BITMASKED]], 0, !dbg [[DBG293:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META287:![0-9]+]], !DIExpression(), [[DBG293]])
; ALL-NEXT:    [[X_NEXT]] = shl i32 [[X_CURR]], 2, !dbg [[DBG294:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_NEXT]], [[META288:![0-9]+]], !DIExpression(), [[DBG294]])
; ALL-NEXT:    br i1 [[X_CURR_ISBITUNSET]], label [[LOOP]], label [[END:%.*]], !dbg [[DBG295:![0-9]+]]
; ALL:       end:
; ALL-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i32 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG291]]
; ALL-NEXT:    ret i32 [[X_CURR_LCSSA]], !dbg [[DBG296:![0-9]+]]
;
entry:
  %bitmask = shl i32 1, %bit
  br label %loop

loop:
  %x.curr = phi i32 [ %x, %entry ], [ %x.next, %loop ]
  %x.curr.bitmasked = and i32 %x.curr, %bitmask
  %x.curr.isbitunset = icmp eq i32 %x.curr.bitmasked, 0
  %x.next = shl i32 %x.curr, 2 ; wrong shift amount.
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  ret i32 %x.curr
}

; The comparison is not what we are looking for.
define i32 @n19(i32 %x, i32 %bit) {
; ALL-LABEL: @n19(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[BITMASK:%.*]] = shl i32 1, [[BIT:%.*]], !dbg [[DBG304:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[BITMASK]], [[META299:![0-9]+]], !DIExpression(), [[DBG304]])
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG305:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:    [[X_CURR:%.*]] = phi i32 [ [[X:%.*]], [[ENTRY:%.*]] ], [ [[X_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG306:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR]], [[META300:![0-9]+]], !DIExpression(), [[DBG306]])
; ALL-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i32 [[X_CURR]], [[BITMASK]], !dbg [[DBG307:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR_BITMASKED]], [[META301:![0-9]+]], !DIExpression(), [[DBG307]])
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp ne i32 [[X_CURR_BITMASKED]], [[BITMASK]], !dbg [[DBG308:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META302:![0-9]+]], !DIExpression(), [[DBG308]])
; ALL-NEXT:    [[X_NEXT]] = shl i32 [[X_CURR]], 1, !dbg [[DBG309:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_NEXT]], [[META303:![0-9]+]], !DIExpression(), [[DBG309]])
; ALL-NEXT:    br i1 [[X_CURR_ISBITUNSET]], label [[LOOP]], label [[END:%.*]], !dbg [[DBG310:![0-9]+]]
; ALL:       end:
; ALL-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i32 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG306]]
; ALL-NEXT:    ret i32 [[X_CURR_LCSSA]], !dbg [[DBG311:![0-9]+]]
;
entry:
  %bitmask = shl i32 1, %bit
  br label %loop

loop:
  %x.curr = phi i32 [ %x, %entry ], [ %x.next, %loop ]
  %x.curr.bitmasked = and i32 %x.curr, %bitmask
  %x.curr.isbitunset = icmp ne i32 %x.curr.bitmasked, %bitmask ; should be `==0`
  %x.next = shl i32 %x.curr, 1
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  ret i32 %x.curr
}

; We should loop while %x.curr.bitmasked is 0, not exit when it is 0.
define i32 @n20(i32 %x, i32 %bit) {
; ALL-LABEL: @n20(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[BITMASK:%.*]] = shl i32 1, [[BIT:%.*]], !dbg [[DBG319:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[BITMASK]], [[META314:![0-9]+]], !DIExpression(), [[DBG319]])
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG320:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:    [[X_CURR:%.*]] = phi i32 [ [[X:%.*]], [[ENTRY:%.*]] ], [ [[X_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG321:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR]], [[META315:![0-9]+]], !DIExpression(), [[DBG321]])
; ALL-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i32 [[X_CURR]], [[BITMASK]], !dbg [[DBG322:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR_BITMASKED]], [[META316:![0-9]+]], !DIExpression(), [[DBG322]])
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i32 [[X_CURR_BITMASKED]], 0, !dbg [[DBG323:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META317:![0-9]+]], !DIExpression(), [[DBG323]])
; ALL-NEXT:    [[X_NEXT]] = shl i32 [[X_CURR]], 1, !dbg [[DBG324:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_NEXT]], [[META318:![0-9]+]], !DIExpression(), [[DBG324]])
; ALL-NEXT:    br i1 [[X_CURR_ISBITUNSET]], label [[END:%.*]], label [[LOOP]], !dbg [[DBG325:![0-9]+]]
; ALL:       end:
; ALL-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i32 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG321]]
; ALL-NEXT:    ret i32 [[X_CURR_LCSSA]], !dbg [[DBG326:![0-9]+]]
;
entry:
  %bitmask = shl i32 1, %bit
  br label %loop

loop:
  %x.curr = phi i32 [ %x, %entry ], [ %x.next, %loop ]
  %x.curr.bitmasked = and i32 %x.curr, %bitmask
  %x.curr.isbitunset = icmp eq i32 %x.curr.bitmasked, 0
  %x.next = shl i32 %x.curr, 1
  br i1 %x.curr.isbitunset, label %end, label %loop ; wrong order of successors

end:
  ret i32 %x.curr
}

; We should loop while %x.curr.bitmasked is 0, not while it is not 0.
define i32 @n21(i32 %x, i32 %bit) {
; ALL-LABEL: @n21(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[BITMASK:%.*]] = shl i32 1, [[BIT:%.*]], !dbg [[DBG334:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[BITMASK]], [[META329:![0-9]+]], !DIExpression(), [[DBG334]])
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG335:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:    [[X_CURR:%.*]] = phi i32 [ [[X:%.*]], [[ENTRY:%.*]] ], [ [[X_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG336:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR]], [[META330:![0-9]+]], !DIExpression(), [[DBG336]])
; ALL-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i32 [[X_CURR]], [[BITMASK]], !dbg [[DBG337:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR_BITMASKED]], [[META331:![0-9]+]], !DIExpression(), [[DBG337]])
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp ne i32 [[X_CURR_BITMASKED]], 0, !dbg [[DBG338:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META332:![0-9]+]], !DIExpression(), [[DBG338]])
; ALL-NEXT:    [[X_NEXT]] = shl i32 [[X_CURR]], 1, !dbg [[DBG339:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_NEXT]], [[META333:![0-9]+]], !DIExpression(), [[DBG339]])
; ALL-NEXT:    br i1 [[X_CURR_ISBITUNSET]], label [[LOOP]], label [[END:%.*]], !dbg [[DBG340:![0-9]+]]
; ALL:       end:
; ALL-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i32 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG336]]
; ALL-NEXT:    ret i32 [[X_CURR_LCSSA]], !dbg [[DBG341:![0-9]+]]
;
entry:
  %bitmask = shl i32 1, %bit
  br label %loop

loop:
  %x.curr = phi i32 [ %x, %entry ], [ %x.next, %loop ]
  %x.curr.bitmasked = and i32 %x.curr, %bitmask
  %x.curr.isbitunset = icmp ne i32 %x.curr.bitmasked, 0 ; wrong predicate
  %x.next = shl i32 %x.curr, 1
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  ret i32 %x.curr
}

; PHI node is not a recurrence
define i32 @n22(i32 %x, i32 %bit) {
; ALL-LABEL: @n22(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[BITMASK:%.*]] = shl i32 1, [[BIT:%.*]], !dbg [[DBG349:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[BITMASK]], [[META344:![0-9]+]], !DIExpression(), [[DBG349]])
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG350:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:      #dbg_value(i32 [[X:%.*]], [[META345:![0-9]+]], !DIExpression(), [[META351:![0-9]+]])
; ALL-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i32 [[X]], [[BITMASK]], !dbg [[DBG352:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR_BITMASKED]], [[META346:![0-9]+]], !DIExpression(), [[DBG352]])
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i32 [[X_CURR_BITMASKED]], 0, !dbg [[DBG353:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META347:![0-9]+]], !DIExpression(), [[DBG353]])
; ALL-NEXT:    [[X_NEXT:%.*]] = shl i32 [[X]], 1, !dbg [[DBG354:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_NEXT]], [[META348:![0-9]+]], !DIExpression(), [[DBG354]])
; ALL-NEXT:    br i1 [[X_CURR_ISBITUNSET]], label [[LOOP]], label [[END:%.*]], !dbg [[DBG355:![0-9]+]]
; ALL:       end:
; ALL-NEXT:    ret i32 [[X]], !dbg [[DBG356:![0-9]+]]
;
entry:
  %bitmask = shl i32 1, %bit
  br label %loop

loop:
  %x.curr = phi i32 [ %x, %entry ], [ %x, %loop ] ; should use %x.next when coming from %loop
  %x.curr.bitmasked = and i32 %x.curr, %bitmask
  %x.curr.isbitunset = icmp eq i32 %x.curr.bitmasked, 0
  %x.next = shl i32 %x.curr, 1
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  ret i32 %x.curr
}

; Masking wrong value
define i32 @n23(i32 %x, i32 %bit) {
; ALL-LABEL: @n23(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[BITMASK:%.*]] = shl i32 1, [[BIT:%.*]], !dbg [[DBG364:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[BITMASK]], [[META359:![0-9]+]], !DIExpression(), [[DBG364]])
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG365:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:    [[X_CURR:%.*]] = phi i32 [ [[X:%.*]], [[ENTRY:%.*]] ], [ [[X_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG366:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR]], [[META360:![0-9]+]], !DIExpression(), [[DBG366]])
; ALL-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i32 [[X]], [[BITMASK]], !dbg [[DBG367:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR_BITMASKED]], [[META361:![0-9]+]], !DIExpression(), [[DBG367]])
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i32 [[X_CURR_BITMASKED]], 0, !dbg [[DBG368:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META362:![0-9]+]], !DIExpression(), [[DBG368]])
; ALL-NEXT:    [[X_NEXT]] = shl i32 [[X_CURR]], 1, !dbg [[DBG369:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_NEXT]], [[META363:![0-9]+]], !DIExpression(), [[DBG369]])
; ALL-NEXT:    br i1 [[X_CURR_ISBITUNSET]], label [[LOOP]], label [[END:%.*]], !dbg [[DBG370:![0-9]+]]
; ALL:       end:
; ALL-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i32 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG366]]
; ALL-NEXT:    ret i32 [[X_CURR_LCSSA]], !dbg [[DBG371:![0-9]+]]
;
entry:
  %bitmask = shl i32 1, %bit
  br label %loop

loop:
  %x.curr = phi i32 [ %x, %entry ], [ %x.next, %loop ]
  %x.curr.bitmasked = and i32 %x, %bitmask ; should use %x.curr, not %x
  %x.curr.isbitunset = icmp eq i32 %x.curr.bitmasked, 0
  %x.next = shl i32 %x.curr, 1
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  ret i32 %x.curr
}

; Checking wrong value
define i32 @n24(i32 %x, i32 %bit) {
; ALL-LABEL: @n24(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[BITMASK:%.*]] = shl i32 1, [[BIT:%.*]], !dbg [[DBG379:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[BITMASK]], [[META374:![0-9]+]], !DIExpression(), [[DBG379]])
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG380:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:    [[X_CURR:%.*]] = phi i32 [ [[X:%.*]], [[ENTRY:%.*]] ], [ [[X_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG381:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR]], [[META375:![0-9]+]], !DIExpression(), [[DBG381]])
; ALL-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i32 [[X_CURR]], [[BITMASK]], !dbg [[DBG382:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR_BITMASKED]], [[META376:![0-9]+]], !DIExpression(), [[DBG382]])
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i32 [[X_CURR]], 0, !dbg [[DBG383:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META377:![0-9]+]], !DIExpression(), [[DBG383]])
; ALL-NEXT:    [[X_NEXT]] = shl i32 [[X_CURR]], 1, !dbg [[DBG384:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_NEXT]], [[META378:![0-9]+]], !DIExpression(), [[DBG384]])
; ALL-NEXT:    br i1 [[X_CURR_ISBITUNSET]], label [[LOOP]], label [[END:%.*]], !dbg [[DBG385:![0-9]+]]
; ALL:       end:
; ALL-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i32 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG381]]
; ALL-NEXT:    ret i32 [[X_CURR_LCSSA]], !dbg [[DBG386:![0-9]+]]
;
entry:
  %bitmask = shl i32 1, %bit
  br label %loop

loop:
  %x.curr = phi i32 [ %x, %entry ], [ %x.next, %loop ]
  %x.curr.bitmasked = and i32 %x.curr, %bitmask
  %x.curr.isbitunset = icmp eq i32 %x.curr, 0 ; should be checking %x.curr.bitmasked
  %x.next = shl i32 %x.curr, 1
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  ret i32 %x.curr
}

; Shifting wrong value
define i32 @n25(i32 %x, i32 %bit) {
; ALL-LABEL: @n25(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[BITMASK:%.*]] = shl i32 1, [[BIT:%.*]], !dbg [[DBG394:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[BITMASK]], [[META389:![0-9]+]], !DIExpression(), [[DBG394]])
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG395:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:    [[X_CURR:%.*]] = phi i32 [ [[X:%.*]], [[ENTRY:%.*]] ], [ [[X_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG396:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR]], [[META390:![0-9]+]], !DIExpression(), [[DBG396]])
; ALL-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i32 [[X_CURR]], [[BITMASK]], !dbg [[DBG397:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR_BITMASKED]], [[META391:![0-9]+]], !DIExpression(), [[DBG397]])
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i32 [[X_CURR_BITMASKED]], 0, !dbg [[DBG398:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META392:![0-9]+]], !DIExpression(), [[DBG398]])
; ALL-NEXT:    [[X_NEXT]] = shl i32 [[X]], 1, !dbg [[DBG399:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_NEXT]], [[META393:![0-9]+]], !DIExpression(), [[DBG399]])
; ALL-NEXT:    br i1 [[X_CURR_ISBITUNSET]], label [[LOOP]], label [[END:%.*]], !dbg [[DBG400:![0-9]+]]
; ALL:       end:
; ALL-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i32 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG396]]
; ALL-NEXT:    ret i32 [[X_CURR_LCSSA]], !dbg [[DBG401:![0-9]+]]
;
entry:
  %bitmask = shl i32 1, %bit
  br label %loop

loop:
  %x.curr = phi i32 [ %x, %entry ], [ %x.next, %loop ]
  %x.curr.bitmasked = and i32 %x.curr, %bitmask
  %x.curr.isbitunset = icmp eq i32 %x.curr.bitmasked, 0
  %x.next = shl i32 %x, 1 ; should be shifting %x.curr
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  ret i32 %x.curr
}

; Bit mask is not a power of 2
define i32 @n26(i32 %x) {
; ALL-LABEL: @n26(
; ALL-NEXT:  entry:
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG408:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:    [[X_CURR:%.*]] = phi i32 [ [[X:%.*]], [[ENTRY:%.*]] ], [ [[X_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG409:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR]], [[META404:![0-9]+]], !DIExpression(), [[DBG409]])
; ALL-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i32 [[X_CURR]], 16777215, !dbg [[DBG410:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR_BITMASKED]], [[META405:![0-9]+]], !DIExpression(), [[DBG410]])
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i32 [[X_CURR_BITMASKED]], 0, !dbg [[DBG411:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META406:![0-9]+]], !DIExpression(), [[DBG411]])
; ALL-NEXT:    [[X_NEXT]] = shl i32 [[X_CURR]], 1, !dbg [[DBG412:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_NEXT]], [[META407:![0-9]+]], !DIExpression(), [[DBG412]])
; ALL-NEXT:    br i1 [[X_CURR_ISBITUNSET]], label [[LOOP]], label [[END:%.*]], !dbg [[DBG413:![0-9]+]]
; ALL:       end:
; ALL-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i32 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG409]]
; ALL-NEXT:    ret i32 [[X_CURR_LCSSA]], !dbg [[DBG414:![0-9]+]]
;
entry:
  br label %loop

loop:
  %x.curr = phi i32 [ %x, %entry ], [ %x.next, %loop ]
  %x.curr.bitmasked = and i32 %x.curr, 16777215 ; not a power of 2
  %x.curr.isbitunset = icmp eq i32 %x.curr.bitmasked, 0
  %x.next = shl i32 %x.curr, 1
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  ret i32 %x.curr
}

; Bit mask is not a power of 2
define i32 @n27(i32 %x) {
; ALL-LABEL: @n27(
; ALL-NEXT:  entry:
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG421:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:    [[X_CURR:%.*]] = phi i32 [ [[X:%.*]], [[ENTRY:%.*]] ], [ [[X_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG422:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR]], [[META417:![0-9]+]], !DIExpression(), [[DBG422]])
; ALL-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i32 [[X_CURR]], 384, !dbg [[DBG423:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR_BITMASKED]], [[META418:![0-9]+]], !DIExpression(), [[DBG423]])
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i32 [[X_CURR_BITMASKED]], 0, !dbg [[DBG424:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META419:![0-9]+]], !DIExpression(), [[DBG424]])
; ALL-NEXT:    [[X_NEXT]] = shl i32 [[X_CURR]], 1, !dbg [[DBG425:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_NEXT]], [[META420:![0-9]+]], !DIExpression(), [[DBG425]])
; ALL-NEXT:    br i1 [[X_CURR_ISBITUNSET]], label [[LOOP]], label [[END:%.*]], !dbg [[DBG426:![0-9]+]]
; ALL:       end:
; ALL-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i32 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG422]]
; ALL-NEXT:    ret i32 [[X_CURR_LCSSA]], !dbg [[DBG427:![0-9]+]]
;
entry:
  br label %loop

loop:
  %x.curr = phi i32 [ %x, %entry ], [ %x.next, %loop ]
  %x.curr.bitmasked = and i32 %x.curr, 384 ; not a power of 2
  %x.curr.isbitunset = icmp eq i32 %x.curr.bitmasked, 0
  %x.next = shl i32 %x.curr, 1
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  ret i32 %x.curr
}

; Bit mask is not a power of 2
define i32 @n28(i32 %x) {
; ALL-LABEL: @n28(
; ALL-NEXT:  entry:
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG434:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:    [[X_CURR:%.*]] = phi i32 [ [[X:%.*]], [[ENTRY:%.*]] ], [ [[X_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG435:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR]], [[META430:![0-9]+]], !DIExpression(), [[DBG435]])
; ALL-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i32 [[X_CURR]], 32896, !dbg [[DBG436:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR_BITMASKED]], [[META431:![0-9]+]], !DIExpression(), [[DBG436]])
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i32 [[X_CURR_BITMASKED]], 0, !dbg [[DBG437:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META432:![0-9]+]], !DIExpression(), [[DBG437]])
; ALL-NEXT:    [[X_NEXT]] = shl i32 [[X_CURR]], 1, !dbg [[DBG438:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_NEXT]], [[META433:![0-9]+]], !DIExpression(), [[DBG438]])
; ALL-NEXT:    br i1 [[X_CURR_ISBITUNSET]], label [[LOOP]], label [[END:%.*]], !dbg [[DBG439:![0-9]+]]
; ALL:       end:
; ALL-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i32 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG435]]
; ALL-NEXT:    ret i32 [[X_CURR_LCSSA]], !dbg [[DBG440:![0-9]+]]
;
entry:
  br label %loop

loop:
  %x.curr = phi i32 [ %x, %entry ], [ %x.next, %loop ]
  %x.curr.bitmasked = and i32 %x.curr, 32896 ; not a power of 2
  %x.curr.isbitunset = icmp eq i32 %x.curr.bitmasked, 0
  %x.next = shl i32 %x.curr, 1
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  ret i32 %x.curr
}

;-------------------------------------------------------------------------------
; Tests with extra cruft.

; If loop body has any extra instructions we don't want to deal with it.
define i32 @n29(i32 %x, i32 %bit) {
; ALL-LABEL: @n29(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[BIT_FR:%.*]] = freeze i32 [[BIT:%.*]]
; ALL-NEXT:    [[BITMASK:%.*]] = shl i32 1, [[BIT_FR]], !dbg [[DBG448:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[BITMASK]], [[META443:![0-9]+]], !DIExpression(), [[DBG448]])
; ALL-NEXT:    [[BIT_FR_LOWBITMASK:%.*]] = add i32 [[BITMASK]], -1, !dbg [[DBG449:![0-9]+]]
; ALL-NEXT:    [[BIT_FR_MASK:%.*]] = or i32 [[BIT_FR_LOWBITMASK]], [[BITMASK]], !dbg [[DBG449]]
; ALL-NEXT:    [[X_MASKED:%.*]] = and i32 [[X:%.*]], [[BIT_FR_MASK]], !dbg [[DBG449]]
; ALL-NEXT:    [[X_MASKED_NUMLEADINGZEROS:%.*]] = call i32 @llvm.ctlz.i32(i32 [[X_MASKED]], i1 true), !dbg [[DBG449]]
; ALL-NEXT:    [[X_MASKED_NUMACTIVEBITS:%.*]] = sub nuw nsw i32 32, [[X_MASKED_NUMLEADINGZEROS]], !dbg [[DBG449]]
; ALL-NEXT:    [[X_MASKED_LEADINGONEPOS:%.*]] = add nsw i32 [[X_MASKED_NUMACTIVEBITS]], -1, !dbg [[DBG449]]
; ALL-NEXT:    [[LOOP_BACKEDGETAKENCOUNT:%.*]] = sub nuw nsw i32 [[BIT_FR]], [[X_MASKED_LEADINGONEPOS]], !dbg [[DBG449]]
; ALL-NEXT:    [[LOOP_TRIPCOUNT:%.*]] = add nuw nsw i32 [[LOOP_BACKEDGETAKENCOUNT]], 1, !dbg [[DBG449]]
; ALL-NEXT:    [[X_CURR:%.*]] = shl i32 [[X]], [[LOOP_BACKEDGETAKENCOUNT]], !dbg [[DBG449]]
; ALL-NEXT:    [[X_NEXT:%.*]] = shl i32 [[X_CURR]], 1, !dbg [[DBG449]]
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG450:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:    [[LOOP_IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[LOOP_IV_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG449]]
; ALL-NEXT:    [[TMP0:%.*]] = phi i32 [ [[X]], [[ENTRY]] ], [ [[TMP1:%.*]], [[LOOP]] ], !dbg [[DBG449]]
; ALL-NEXT:      #dbg_value(i32 [[TMP0]], [[META444:![0-9]+]], !DIExpression(), [[DBG449]])
; ALL-NEXT:    call void @external_side_effect(), !dbg [[DBG451:![0-9]+]]
; ALL-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i32 [[TMP0]], [[BITMASK]], !dbg [[DBG452:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR_BITMASKED]], [[META445:![0-9]+]], !DIExpression(), [[DBG452]])
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i32 [[X_CURR_BITMASKED]], 0, !dbg [[DBG453:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META446:![0-9]+]], !DIExpression(), [[DBG453]])
; ALL-NEXT:    [[TMP1]] = shl i32 [[TMP0]], 1, !dbg [[DBG454:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[TMP1]], [[META447:![0-9]+]], !DIExpression(), [[DBG454]])
; ALL-NEXT:    [[LOOP_IV_NEXT]] = add nuw nsw i32 [[LOOP_IV]], 1, !dbg [[DBG455:![0-9]+]]
; ALL-NEXT:    [[LOOP_IVCHECK:%.*]] = icmp eq i32 [[LOOP_IV_NEXT]], [[LOOP_TRIPCOUNT]], !dbg [[DBG455]]
; ALL-NEXT:    br i1 [[LOOP_IVCHECK]], label [[END:%.*]], label [[LOOP]], !dbg [[DBG455]]
; ALL:       end:
; ALL-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i32 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG449]]
; ALL-NEXT:    ret i32 [[X_CURR_LCSSA]], !dbg [[DBG456:![0-9]+]]
;
entry:
  %bitmask = shl i32 1, %bit
  br label %loop

loop:
  %x.curr = phi i32 [ %x, %entry ], [ %x.next, %loop ]
  call void @external_side_effect() ; not part of idiom.
  %x.curr.bitmasked = and i32 %x.curr, %bitmask
  %x.curr.isbitunset = icmp eq i32 %x.curr.bitmasked, 0
  %x.next = shl i32 %x.curr, 1
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  ret i32 %x.curr
}

define i32 @n30(i32 %x) {
; ALL-LABEL: @n30(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[X_MASKED:%.*]] = and i32 [[X:%.*]], -1, !dbg [[DBG462:![0-9]+]]
; ALL-NEXT:    [[X_MASKED_NUMLEADINGZEROS:%.*]] = call i32 @llvm.ctlz.i32(i32 [[X_MASKED]], i1 true), !dbg [[DBG462]]
; ALL-NEXT:    [[X_MASKED_NUMACTIVEBITS:%.*]] = sub nuw nsw i32 32, [[X_MASKED_NUMLEADINGZEROS]], !dbg [[DBG462]]
; ALL-NEXT:    [[X_MASKED_LEADINGONEPOS:%.*]] = add nsw i32 [[X_MASKED_NUMACTIVEBITS]], -1, !dbg [[DBG462]]
; ALL-NEXT:    [[LOOP_BACKEDGETAKENCOUNT:%.*]] = sub nuw nsw i32 31, [[X_MASKED_LEADINGONEPOS]], !dbg [[DBG462]]
; ALL-NEXT:    [[LOOP_TRIPCOUNT:%.*]] = add nuw nsw i32 [[LOOP_BACKEDGETAKENCOUNT]], 1, !dbg [[DBG462]]
; ALL-NEXT:    [[X_CURR:%.*]] = shl i32 [[X]], [[LOOP_BACKEDGETAKENCOUNT]], !dbg [[DBG462]]
; ALL-NEXT:    [[X_NEXT:%.*]] = shl i32 [[X_CURR]], 1, !dbg [[DBG462]]
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG463:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:    [[LOOP_IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[LOOP_IV_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG462]]
; ALL-NEXT:    [[TMP0:%.*]] = phi i32 [ [[X]], [[ENTRY]] ], [ [[TMP1:%.*]], [[LOOP]] ], !dbg [[DBG462]]
; ALL-NEXT:      #dbg_value(i32 [[TMP0]], [[META459:![0-9]+]], !DIExpression(), [[DBG462]])
; ALL-NEXT:    call void @external_side_effect(), !dbg [[DBG464:![0-9]+]]
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp sgt i32 [[TMP0]], -1, !dbg [[DBG465:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META460:![0-9]+]], !DIExpression(), [[DBG465]])
; ALL-NEXT:    [[TMP1]] = shl i32 [[TMP0]], 1, !dbg [[DBG466:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[TMP1]], [[META461:![0-9]+]], !DIExpression(), [[DBG466]])
; ALL-NEXT:    [[LOOP_IV_NEXT]] = add nuw nsw i32 [[LOOP_IV]], 1, !dbg [[DBG467:![0-9]+]]
; ALL-NEXT:    [[LOOP_IVCHECK:%.*]] = icmp eq i32 [[LOOP_IV_NEXT]], [[LOOP_TRIPCOUNT]], !dbg [[DBG467]]
; ALL-NEXT:    br i1 [[LOOP_IVCHECK]], label [[END:%.*]], label [[LOOP]], !dbg [[DBG467]]
; ALL:       end:
; ALL-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i32 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG462]]
; ALL-NEXT:    ret i32 [[X_CURR_LCSSA]], !dbg [[DBG468:![0-9]+]]
;
entry:
  br label %loop

loop:
  %x.curr = phi i32 [ %x, %entry ], [ %x.next, %loop ]
  call void @external_side_effect() ; not part of idiom.
  %x.curr.isbitunset = icmp sgt i32 %x.curr, -1
  %x.next = shl i32 %x.curr, 1
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  ret i32 %x.curr
}

; In-loop instructions should not have uses outside of the loop.
define i32 @n31(i32 %x, i32 %bit) {
; ALL-LABEL: @n31(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[BIT_FR:%.*]] = freeze i32 [[BIT:%.*]]
; ALL-NEXT:    [[BITMASK:%.*]] = shl i32 1, [[BIT_FR]], !dbg [[DBG476:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[BITMASK]], [[META471:![0-9]+]], !DIExpression(), [[DBG476]])
; ALL-NEXT:    [[BIT_FR_LOWBITMASK:%.*]] = add i32 [[BITMASK]], -1, !dbg [[DBG477:![0-9]+]]
; ALL-NEXT:    [[BIT_FR_MASK:%.*]] = or i32 [[BIT_FR_LOWBITMASK]], [[BITMASK]], !dbg [[DBG477]]
; ALL-NEXT:    [[X_MASKED:%.*]] = and i32 [[X:%.*]], [[BIT_FR_MASK]], !dbg [[DBG477]]
; ALL-NEXT:    [[X_MASKED_NUMLEADINGZEROS:%.*]] = call i32 @llvm.ctlz.i32(i32 [[X_MASKED]], i1 true), !dbg [[DBG477]]
; ALL-NEXT:    [[X_MASKED_NUMACTIVEBITS:%.*]] = sub nuw nsw i32 32, [[X_MASKED_NUMLEADINGZEROS]], !dbg [[DBG477]]
; ALL-NEXT:    [[X_MASKED_LEADINGONEPOS:%.*]] = add nsw i32 [[X_MASKED_NUMACTIVEBITS]], -1, !dbg [[DBG477]]
; ALL-NEXT:    [[LOOP_BACKEDGETAKENCOUNT:%.*]] = sub nuw nsw i32 [[BIT_FR]], [[X_MASKED_LEADINGONEPOS]], !dbg [[DBG477]]
; ALL-NEXT:    [[LOOP_TRIPCOUNT:%.*]] = add nuw nsw i32 [[LOOP_BACKEDGETAKENCOUNT]], 1, !dbg [[DBG477]]
; ALL-NEXT:    [[X_CURR:%.*]] = shl i32 [[X]], [[LOOP_BACKEDGETAKENCOUNT]], !dbg [[DBG477]]
; ALL-NEXT:    [[X_NEXT:%.*]] = shl i32 [[X_CURR]], 1, !dbg [[DBG477]]
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG478:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:    [[LOOP_IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[LOOP_IV_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG477]]
; ALL-NEXT:    [[TMP0:%.*]] = phi i32 [ [[X]], [[ENTRY]] ], [ [[TMP1:%.*]], [[LOOP]] ], !dbg [[DBG477]]
; ALL-NEXT:      #dbg_value(i32 [[TMP0]], [[META472:![0-9]+]], !DIExpression(), [[DBG477]])
; ALL-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i32 [[TMP0]], [[BITMASK]], !dbg [[DBG479:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR_BITMASKED]], [[META473:![0-9]+]], !DIExpression(), [[DBG479]])
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i32 [[X_CURR_BITMASKED]], 0, !dbg [[DBG480:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META474:![0-9]+]], !DIExpression(), [[DBG480]])
; ALL-NEXT:    [[TMP1]] = shl i32 [[TMP0]], 1, !dbg [[DBG481:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[TMP1]], [[META475:![0-9]+]], !DIExpression(), [[DBG481]])
; ALL-NEXT:    [[LOOP_IV_NEXT]] = add nuw nsw i32 [[LOOP_IV]], 1, !dbg [[DBG482:![0-9]+]]
; ALL-NEXT:    [[LOOP_IVCHECK:%.*]] = icmp eq i32 [[LOOP_IV_NEXT]], [[LOOP_TRIPCOUNT]], !dbg [[DBG482]]
; ALL-NEXT:    br i1 [[LOOP_IVCHECK]], label [[END:%.*]], label [[LOOP]], !dbg [[DBG482]]
; ALL:       end:
; ALL-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i32 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG477]]
; ALL-NEXT:    [[X_CURR_BITMASKED_LCSSA:%.*]] = phi i32 [ [[X_CURR_BITMASKED]], [[LOOP]] ], !dbg [[DBG479]]
; ALL-NEXT:    call void @use32(i32 [[X_CURR_BITMASKED_LCSSA]]), !dbg [[DBG483:![0-9]+]]
; ALL-NEXT:    ret i32 [[X_CURR_LCSSA]], !dbg [[DBG484:![0-9]+]]
;
entry:
  %bitmask = shl i32 1, %bit
  br label %loop

loop:
  %x.curr = phi i32 [ %x, %entry ], [ %x.next, %loop ]
  %x.curr.bitmasked = and i32 %x.curr, %bitmask
  %x.curr.isbitunset = icmp eq i32 %x.curr.bitmasked, 0
  %x.next = shl i32 %x.curr, 1
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  call void @use32(i32 %x.curr.bitmasked)
  ret i32 %x.curr
}
define i32 @n32(i32 %x, i32 %bit) {
; ALL-LABEL: @n32(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[BIT_FR:%.*]] = freeze i32 [[BIT:%.*]]
; ALL-NEXT:    [[BITMASK:%.*]] = shl i32 1, [[BIT_FR]], !dbg [[DBG492:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[BITMASK]], [[META487:![0-9]+]], !DIExpression(), [[DBG492]])
; ALL-NEXT:    [[BIT_FR_LOWBITMASK:%.*]] = add i32 [[BITMASK]], -1, !dbg [[DBG493:![0-9]+]]
; ALL-NEXT:    [[BIT_FR_MASK:%.*]] = or i32 [[BIT_FR_LOWBITMASK]], [[BITMASK]], !dbg [[DBG493]]
; ALL-NEXT:    [[X_MASKED:%.*]] = and i32 [[X:%.*]], [[BIT_FR_MASK]], !dbg [[DBG493]]
; ALL-NEXT:    [[X_MASKED_NUMLEADINGZEROS:%.*]] = call i32 @llvm.ctlz.i32(i32 [[X_MASKED]], i1 true), !dbg [[DBG493]]
; ALL-NEXT:    [[X_MASKED_NUMACTIVEBITS:%.*]] = sub nuw nsw i32 32, [[X_MASKED_NUMLEADINGZEROS]], !dbg [[DBG493]]
; ALL-NEXT:    [[X_MASKED_LEADINGONEPOS:%.*]] = add nsw i32 [[X_MASKED_NUMACTIVEBITS]], -1, !dbg [[DBG493]]
; ALL-NEXT:    [[LOOP_BACKEDGETAKENCOUNT:%.*]] = sub nuw nsw i32 [[BIT_FR]], [[X_MASKED_LEADINGONEPOS]], !dbg [[DBG493]]
; ALL-NEXT:    [[LOOP_TRIPCOUNT:%.*]] = add nuw nsw i32 [[LOOP_BACKEDGETAKENCOUNT]], 1, !dbg [[DBG493]]
; ALL-NEXT:    [[X_CURR:%.*]] = shl i32 [[X]], [[LOOP_BACKEDGETAKENCOUNT]], !dbg [[DBG493]]
; ALL-NEXT:    [[X_NEXT:%.*]] = shl i32 [[X_CURR]], 1, !dbg [[DBG493]]
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG494:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:    [[LOOP_IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[LOOP_IV_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG493]]
; ALL-NEXT:    [[TMP0:%.*]] = phi i32 [ [[X]], [[ENTRY]] ], [ [[TMP1:%.*]], [[LOOP]] ], !dbg [[DBG493]]
; ALL-NEXT:      #dbg_value(i32 [[TMP0]], [[META488:![0-9]+]], !DIExpression(), [[DBG493]])
; ALL-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i32 [[TMP0]], [[BITMASK]], !dbg [[DBG495:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR_BITMASKED]], [[META489:![0-9]+]], !DIExpression(), [[DBG495]])
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i32 [[X_CURR_BITMASKED]], 0, !dbg [[DBG496:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META490:![0-9]+]], !DIExpression(), [[DBG496]])
; ALL-NEXT:    [[TMP1]] = shl i32 [[TMP0]], 1, !dbg [[DBG497:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[TMP1]], [[META491:![0-9]+]], !DIExpression(), [[DBG497]])
; ALL-NEXT:    [[LOOP_IV_NEXT]] = add nuw nsw i32 [[LOOP_IV]], 1, !dbg [[DBG498:![0-9]+]]
; ALL-NEXT:    [[LOOP_IVCHECK:%.*]] = icmp eq i32 [[LOOP_IV_NEXT]], [[LOOP_TRIPCOUNT]], !dbg [[DBG498]]
; ALL-NEXT:    br i1 [[LOOP_IVCHECK]], label [[END:%.*]], label [[LOOP]], !dbg [[DBG498]]
; ALL:       end:
; ALL-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i32 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG493]]
; ALL-NEXT:    [[X_CURR_ISBITUNSET_LCSSA:%.*]] = phi i1 [ [[X_CURR_ISBITUNSET]], [[LOOP]] ], !dbg [[DBG496]]
; ALL-NEXT:    call void @use1(i1 [[X_CURR_ISBITUNSET_LCSSA]]), !dbg [[DBG499:![0-9]+]]
; ALL-NEXT:    ret i32 [[X_CURR_LCSSA]], !dbg [[DBG500:![0-9]+]]
;
entry:
  %bitmask = shl i32 1, %bit
  br label %loop

loop:
  %x.curr = phi i32 [ %x, %entry ], [ %x.next, %loop ]
  %x.curr.bitmasked = and i32 %x.curr, %bitmask
  %x.curr.isbitunset = icmp eq i32 %x.curr.bitmasked, 0
  %x.next = shl i32 %x.curr, 1
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  call void @use1(i1 %x.curr.isbitunset)
  ret i32 %x.curr
}

; %x.curr is not a PHI node
define i32 @n33(i32 %x, i32 %bit, i32 %x.curr) {
; ALL-LABEL: @n33(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[BITMASK:%.*]] = shl i32 1, [[BIT:%.*]], !dbg [[DBG507:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[BITMASK]], [[META503:![0-9]+]], !DIExpression(), [[DBG507]])
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG508:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i32 [[X_CURR:%.*]], [[BITMASK]], !dbg [[DBG509:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR_BITMASKED]], [[META504:![0-9]+]], !DIExpression(), [[DBG509]])
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i32 [[X_CURR_BITMASKED]], 0, !dbg [[DBG510:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META505:![0-9]+]], !DIExpression(), [[DBG510]])
; ALL-NEXT:    [[X_NEXT:%.*]] = shl i32 [[X_CURR]], 1, !dbg [[DBG511:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_NEXT]], [[META506:![0-9]+]], !DIExpression(), [[DBG511]])
; ALL-NEXT:    br i1 [[X_CURR_ISBITUNSET]], label [[LOOP]], label [[END:%.*]], !dbg [[DBG512:![0-9]+]]
; ALL:       end:
; ALL-NEXT:    ret i32 [[X_CURR]], !dbg [[DBG513:![0-9]+]]
;
entry:
  %bitmask = shl i32 1, %bit
  br label %loop

loop:
  %x.curr.bitmasked = and i32 %x.curr, %bitmask
  %x.curr.isbitunset = icmp eq i32 %x.curr.bitmasked, 0
  %x.next = shl i32 %x.curr, 1
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  ret i32 %x.curr
}

; %x.curr is a PHI node in a wrong block
define i32 @n34(i32 %bit, i1 %c, i32 %x0, i32 %x1) {
; ALL-LABEL: @n34(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[BITMASK:%.*]] = shl i32 1, [[BIT:%.*]], !dbg [[DBG521:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[BITMASK]], [[META516:![0-9]+]], !DIExpression(), [[DBG521]])
; ALL-NEXT:    br i1 [[C:%.*]], label [[BB0:%.*]], label [[BB1:%.*]], !dbg [[DBG522:![0-9]+]]
; ALL:       bb0:
; ALL-NEXT:    br label [[MERGE:%.*]], !dbg [[DBG523:![0-9]+]]
; ALL:       bb1:
; ALL-NEXT:    br label [[MERGE]], !dbg [[DBG524:![0-9]+]]
; ALL:       merge:
; ALL-NEXT:    [[X_CURR:%.*]] = phi i32 [ [[X0:%.*]], [[BB0]] ], [ [[X1:%.*]], [[BB1]] ], !dbg [[DBG525:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR]], [[META517:![0-9]+]], !DIExpression(), [[DBG525]])
; ALL-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG526:![0-9]+]]
; ALL:       loop:
; ALL-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i32 [[X_CURR]], [[BITMASK]], !dbg [[DBG527:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_CURR_BITMASKED]], [[META518:![0-9]+]], !DIExpression(), [[DBG527]])
; ALL-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i32 [[X_CURR_BITMASKED]], 0, !dbg [[DBG528:![0-9]+]]
; ALL-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META519:![0-9]+]], !DIExpression(), [[DBG528]])
; ALL-NEXT:    [[X_NEXT:%.*]] = shl i32 [[X_CURR]], 1, !dbg [[DBG529:![0-9]+]]
; ALL-NEXT:      #dbg_value(i32 [[X_NEXT]], [[META520:![0-9]+]], !DIExpression(), [[DBG529]])
; ALL-NEXT:    br i1 [[X_CURR_ISBITUNSET]], label [[LOOP]], label [[END:%.*]], !dbg [[DBG530:![0-9]+]]
; ALL:       end:
; ALL-NEXT:    ret i32 [[X_CURR]], !dbg [[DBG531:![0-9]+]]
;
entry:
  %bitmask = shl i32 1, %bit
  br i1 %c, label %bb0, label %bb1

bb0:
  br label %merge
bb1:
  br label %merge

merge:
  %x.curr = phi i32 [ %x0, %bb0 ], [ %x1, %bb1 ]
  br label %loop

loop:
  %x.curr.bitmasked = and i32 %x.curr, %bitmask
  %x.curr.isbitunset = icmp eq i32 %x.curr.bitmasked, 0
  %x.next = shl i32 %x.curr, 1
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  ret i32 %x.curr
}

; Various weird bit widths
define void @t35_i1(i1 %x, i1 %bit, ptr %p0, ptr %p1) {
; LZCNT-LABEL: @t35_i1(
; LZCNT-NEXT:  entry:
; LZCNT-NEXT:    [[BIT_FR:%.*]] = freeze i1 [[BIT:%.*]]
; LZCNT-NEXT:    [[BITMASK:%.*]] = shl i1 true, [[BIT_FR]], !dbg [[DBG539:![0-9]+]]
; LZCNT-NEXT:      #dbg_value(i1 [[BITMASK]], [[META534:![0-9]+]], !DIExpression(), [[DBG539]])
; LZCNT-NEXT:    [[BIT_FR_LOWBITMASK:%.*]] = add i1 [[BITMASK]], true, !dbg [[DBG540:![0-9]+]]
; LZCNT-NEXT:    [[BIT_FR_MASK:%.*]] = or i1 [[BIT_FR_LOWBITMASK]], [[BITMASK]], !dbg [[DBG540]]
; LZCNT-NEXT:    [[X_MASKED:%.*]] = and i1 [[X:%.*]], [[BIT_FR_MASK]], !dbg [[DBG540]]
; LZCNT-NEXT:    [[X_MASKED_NUMLEADINGZEROS:%.*]] = call i1 @llvm.ctlz.i1(i1 [[X_MASKED]], i1 true), !dbg [[DBG540]]
; LZCNT-NEXT:    [[X_MASKED_NUMACTIVEBITS:%.*]] = sub nuw nsw i1 true, [[X_MASKED_NUMLEADINGZEROS]], !dbg [[DBG540]]
; LZCNT-NEXT:    [[X_MASKED_LEADINGONEPOS:%.*]] = add i1 [[X_MASKED_NUMACTIVEBITS]], true, !dbg [[DBG540]]
; LZCNT-NEXT:    [[LOOP_BACKEDGETAKENCOUNT:%.*]] = sub nuw nsw i1 [[BIT_FR]], [[X_MASKED_LEADINGONEPOS]], !dbg [[DBG540]]
; LZCNT-NEXT:    [[LOOP_TRIPCOUNT:%.*]] = add nuw nsw i1 [[LOOP_BACKEDGETAKENCOUNT]], true, !dbg [[DBG540]]
; LZCNT-NEXT:    [[X_CURR:%.*]] = shl i1 [[X]], [[LOOP_BACKEDGETAKENCOUNT]], !dbg [[DBG540]]
; LZCNT-NEXT:    [[X_NEXT:%.*]] = shl i1 [[X_CURR]], true, !dbg [[DBG540]]
; LZCNT-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG541:![0-9]+]]
; LZCNT:       loop:
; LZCNT-NEXT:    [[LOOP_IV:%.*]] = phi i1 [ false, [[ENTRY:%.*]] ], [ [[LOOP_IV_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG540]]
; LZCNT-NEXT:    [[TMP0:%.*]] = phi i1 [ [[X]], [[ENTRY]] ], [ [[TMP1:%.*]], [[LOOP]] ], !dbg [[DBG540]]
; LZCNT-NEXT:      #dbg_value(i1 [[TMP0]], [[META535:![0-9]+]], !DIExpression(), [[DBG540]])
; LZCNT-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i1 [[TMP0]], [[BITMASK]], !dbg [[DBG542:![0-9]+]]
; LZCNT-NEXT:      #dbg_value(i1 [[X_CURR_BITMASKED]], [[META536:![0-9]+]], !DIExpression(), [[DBG542]])
; LZCNT-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i1 [[X_CURR_BITMASKED]], false, !dbg [[DBG543:![0-9]+]]
; LZCNT-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META537:![0-9]+]], !DIExpression(), [[DBG543]])
; LZCNT-NEXT:    [[TMP1]] = shl i1 [[TMP0]], true, !dbg [[DBG544:![0-9]+]]
; LZCNT-NEXT:      #dbg_value(i1 [[TMP1]], [[META538:![0-9]+]], !DIExpression(), [[DBG544]])
; LZCNT-NEXT:    [[LOOP_IV_NEXT]] = add nuw nsw i1 [[LOOP_IV]], true, !dbg [[DBG545:![0-9]+]]
; LZCNT-NEXT:    [[LOOP_IVCHECK:%.*]] = icmp eq i1 [[LOOP_IV_NEXT]], [[LOOP_TRIPCOUNT]], !dbg [[DBG545]]
; LZCNT-NEXT:    br i1 [[LOOP_IVCHECK]], label [[END:%.*]], label [[LOOP]], !dbg [[DBG545]]
; LZCNT:       end:
; LZCNT-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i1 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG540]]
; LZCNT-NEXT:    [[X_NEXT_LCSSA:%.*]] = phi i1 [ [[X_NEXT]], [[LOOP]] ], !dbg [[DBG544]]
; LZCNT-NEXT:    store i1 [[X_CURR_LCSSA]], ptr [[P0:%.*]], align 1, !dbg [[DBG546:![0-9]+]]
; LZCNT-NEXT:    store i1 [[X_NEXT_LCSSA]], ptr [[P1:%.*]], align 1, !dbg [[DBG547:![0-9]+]]
; LZCNT-NEXT:    ret void, !dbg [[DBG548:![0-9]+]]
;
; NOLZCNT-LABEL: @t35_i1(
; NOLZCNT-NEXT:  entry:
; NOLZCNT-NEXT:    [[BITMASK:%.*]] = shl i1 true, [[BIT:%.*]], !dbg [[DBG539:![0-9]+]]
; NOLZCNT-NEXT:      #dbg_value(i1 [[BITMASK]], [[META534:![0-9]+]], !DIExpression(), [[DBG539]])
; NOLZCNT-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG540:![0-9]+]]
; NOLZCNT:       loop:
; NOLZCNT-NEXT:    [[X_CURR:%.*]] = phi i1 [ [[X:%.*]], [[ENTRY:%.*]] ], [ [[X_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG541:![0-9]+]]
; NOLZCNT-NEXT:      #dbg_value(i1 [[X_CURR]], [[META535:![0-9]+]], !DIExpression(), [[DBG541]])
; NOLZCNT-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i1 [[X_CURR]], [[BITMASK]], !dbg [[DBG542:![0-9]+]]
; NOLZCNT-NEXT:      #dbg_value(i1 [[X_CURR_BITMASKED]], [[META536:![0-9]+]], !DIExpression(), [[DBG542]])
; NOLZCNT-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i1 [[X_CURR_BITMASKED]], false, !dbg [[DBG543:![0-9]+]]
; NOLZCNT-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META537:![0-9]+]], !DIExpression(), [[DBG543]])
; NOLZCNT-NEXT:    [[X_NEXT]] = shl i1 [[X_CURR]], true, !dbg [[DBG544:![0-9]+]]
; NOLZCNT-NEXT:      #dbg_value(i1 [[X_NEXT]], [[META538:![0-9]+]], !DIExpression(), [[DBG544]])
; NOLZCNT-NEXT:    br i1 [[X_CURR_ISBITUNSET]], label [[LOOP]], label [[END:%.*]], !dbg [[DBG545:![0-9]+]]
; NOLZCNT:       end:
; NOLZCNT-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i1 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG541]]
; NOLZCNT-NEXT:    [[X_NEXT_LCSSA:%.*]] = phi i1 [ [[X_NEXT]], [[LOOP]] ], !dbg [[DBG544]]
; NOLZCNT-NEXT:    store i1 [[X_CURR_LCSSA]], ptr [[P0:%.*]], align 1, !dbg [[DBG546:![0-9]+]]
; NOLZCNT-NEXT:    store i1 [[X_NEXT_LCSSA]], ptr [[P1:%.*]], align 1, !dbg [[DBG547:![0-9]+]]
; NOLZCNT-NEXT:    ret void, !dbg [[DBG548:![0-9]+]]
;
entry:
  %bitmask = shl i1 1, %bit
  br label %loop

loop:
  %x.curr = phi i1 [ %x, %entry ], [ %x.next, %loop ]
  %x.curr.bitmasked = and i1 %x.curr, %bitmask
  %x.curr.isbitunset = icmp eq i1 %x.curr.bitmasked, 0
  %x.next = shl i1 %x.curr, 1
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  store i1 %x.curr, ptr %p0
  store i1 %x.next, ptr %p1
  ret void
}
define void @t36_i2(i2 %x, i2 %bit, ptr %p0, ptr %p1) {
; LZCNT-LABEL: @t36_i2(
; LZCNT-NEXT:  entry:
; LZCNT-NEXT:    [[BIT_FR:%.*]] = freeze i2 [[BIT:%.*]]
; LZCNT-NEXT:    [[BITMASK:%.*]] = shl i2 1, [[BIT_FR]], !dbg [[DBG556:![0-9]+]]
; LZCNT-NEXT:      #dbg_value(i2 [[BITMASK]], [[META551:![0-9]+]], !DIExpression(), [[DBG556]])
; LZCNT-NEXT:    [[BIT_FR_LOWBITMASK:%.*]] = add i2 [[BITMASK]], -1, !dbg [[DBG557:![0-9]+]]
; LZCNT-NEXT:    [[BIT_FR_MASK:%.*]] = or i2 [[BIT_FR_LOWBITMASK]], [[BITMASK]], !dbg [[DBG557]]
; LZCNT-NEXT:    [[X_MASKED:%.*]] = and i2 [[X:%.*]], [[BIT_FR_MASK]], !dbg [[DBG557]]
; LZCNT-NEXT:    [[X_MASKED_NUMLEADINGZEROS:%.*]] = call i2 @llvm.ctlz.i2(i2 [[X_MASKED]], i1 true), !dbg [[DBG557]]
; LZCNT-NEXT:    [[X_MASKED_NUMACTIVEBITS:%.*]] = sub nuw i2 -2, [[X_MASKED_NUMLEADINGZEROS]], !dbg [[DBG557]]
; LZCNT-NEXT:    [[X_MASKED_LEADINGONEPOS:%.*]] = add i2 [[X_MASKED_NUMACTIVEBITS]], -1, !dbg [[DBG557]]
; LZCNT-NEXT:    [[LOOP_BACKEDGETAKENCOUNT:%.*]] = sub nuw nsw i2 [[BIT_FR]], [[X_MASKED_LEADINGONEPOS]], !dbg [[DBG557]]
; LZCNT-NEXT:    [[LOOP_TRIPCOUNT:%.*]] = add nuw i2 [[LOOP_BACKEDGETAKENCOUNT]], 1, !dbg [[DBG557]]
; LZCNT-NEXT:    [[X_CURR:%.*]] = shl i2 [[X]], [[LOOP_BACKEDGETAKENCOUNT]], !dbg [[DBG557]]
; LZCNT-NEXT:    [[X_NEXT:%.*]] = shl i2 [[X_CURR]], 1, !dbg [[DBG557]]
; LZCNT-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG558:![0-9]+]]
; LZCNT:       loop:
; LZCNT-NEXT:    [[LOOP_IV:%.*]] = phi i2 [ 0, [[ENTRY:%.*]] ], [ [[LOOP_IV_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG557]]
; LZCNT-NEXT:    [[TMP0:%.*]] = phi i2 [ [[X]], [[ENTRY]] ], [ [[TMP1:%.*]], [[LOOP]] ], !dbg [[DBG557]]
; LZCNT-NEXT:      #dbg_value(i2 [[TMP0]], [[META552:![0-9]+]], !DIExpression(), [[DBG557]])
; LZCNT-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i2 [[TMP0]], [[BITMASK]], !dbg [[DBG559:![0-9]+]]
; LZCNT-NEXT:      #dbg_value(i2 [[X_CURR_BITMASKED]], [[META553:![0-9]+]], !DIExpression(), [[DBG559]])
; LZCNT-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i2 [[X_CURR_BITMASKED]], 0, !dbg [[DBG560:![0-9]+]]
; LZCNT-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META554:![0-9]+]], !DIExpression(), [[DBG560]])
; LZCNT-NEXT:    [[TMP1]] = shl i2 [[TMP0]], 1, !dbg [[DBG561:![0-9]+]]
; LZCNT-NEXT:      #dbg_value(i2 [[TMP1]], [[META555:![0-9]+]], !DIExpression(), [[DBG561]])
; LZCNT-NEXT:    [[LOOP_IV_NEXT]] = add nuw i2 [[LOOP_IV]], 1, !dbg [[DBG562:![0-9]+]]
; LZCNT-NEXT:    [[LOOP_IVCHECK:%.*]] = icmp eq i2 [[LOOP_IV_NEXT]], [[LOOP_TRIPCOUNT]], !dbg [[DBG562]]
; LZCNT-NEXT:    br i1 [[LOOP_IVCHECK]], label [[END:%.*]], label [[LOOP]], !dbg [[DBG562]]
; LZCNT:       end:
; LZCNT-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i2 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG557]]
; LZCNT-NEXT:    [[X_NEXT_LCSSA:%.*]] = phi i2 [ [[X_NEXT]], [[LOOP]] ], !dbg [[DBG561]]
; LZCNT-NEXT:    store i2 [[X_CURR_LCSSA]], ptr [[P0:%.*]], align 1, !dbg [[DBG563:![0-9]+]]
; LZCNT-NEXT:    store i2 [[X_NEXT_LCSSA]], ptr [[P1:%.*]], align 1, !dbg [[DBG564:![0-9]+]]
; LZCNT-NEXT:    ret void, !dbg [[DBG565:![0-9]+]]
;
; NOLZCNT-LABEL: @t36_i2(
; NOLZCNT-NEXT:  entry:
; NOLZCNT-NEXT:    [[BITMASK:%.*]] = shl i2 1, [[BIT:%.*]], !dbg [[DBG556:![0-9]+]]
; NOLZCNT-NEXT:      #dbg_value(i2 [[BITMASK]], [[META551:![0-9]+]], !DIExpression(), [[DBG556]])
; NOLZCNT-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG557:![0-9]+]]
; NOLZCNT:       loop:
; NOLZCNT-NEXT:    [[X_CURR:%.*]] = phi i2 [ [[X:%.*]], [[ENTRY:%.*]] ], [ [[X_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG558:![0-9]+]]
; NOLZCNT-NEXT:      #dbg_value(i2 [[X_CURR]], [[META552:![0-9]+]], !DIExpression(), [[DBG558]])
; NOLZCNT-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i2 [[X_CURR]], [[BITMASK]], !dbg [[DBG559:![0-9]+]]
; NOLZCNT-NEXT:      #dbg_value(i2 [[X_CURR_BITMASKED]], [[META553:![0-9]+]], !DIExpression(), [[DBG559]])
; NOLZCNT-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i2 [[X_CURR_BITMASKED]], 0, !dbg [[DBG560:![0-9]+]]
; NOLZCNT-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META554:![0-9]+]], !DIExpression(), [[DBG560]])
; NOLZCNT-NEXT:    [[X_NEXT]] = shl i2 [[X_CURR]], 1, !dbg [[DBG561:![0-9]+]]
; NOLZCNT-NEXT:      #dbg_value(i2 [[X_NEXT]], [[META555:![0-9]+]], !DIExpression(), [[DBG561]])
; NOLZCNT-NEXT:    br i1 [[X_CURR_ISBITUNSET]], label [[LOOP]], label [[END:%.*]], !dbg [[DBG562:![0-9]+]]
; NOLZCNT:       end:
; NOLZCNT-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i2 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG558]]
; NOLZCNT-NEXT:    [[X_NEXT_LCSSA:%.*]] = phi i2 [ [[X_NEXT]], [[LOOP]] ], !dbg [[DBG561]]
; NOLZCNT-NEXT:    store i2 [[X_CURR_LCSSA]], ptr [[P0:%.*]], align 1, !dbg [[DBG563:![0-9]+]]
; NOLZCNT-NEXT:    store i2 [[X_NEXT_LCSSA]], ptr [[P1:%.*]], align 1, !dbg [[DBG564:![0-9]+]]
; NOLZCNT-NEXT:    ret void, !dbg [[DBG565:![0-9]+]]
;
entry:
  %bitmask = shl i2 1, %bit
  br label %loop

loop:
  %x.curr = phi i2 [ %x, %entry ], [ %x.next, %loop ]
  %x.curr.bitmasked = and i2 %x.curr, %bitmask
  %x.curr.isbitunset = icmp eq i2 %x.curr.bitmasked, 0
  %x.next = shl i2 %x.curr, 1
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  store i2 %x.curr, ptr %p0
  store i2 %x.next, ptr %p1
  ret void
}
define void @t37_i3(i3 %x, i3 %bit, ptr %p0, ptr %p1) {
; LZCNT-LABEL: @t37_i3(
; LZCNT-NEXT:  entry:
; LZCNT-NEXT:    [[BIT_FR:%.*]] = freeze i3 [[BIT:%.*]]
; LZCNT-NEXT:    [[BITMASK:%.*]] = shl i3 1, [[BIT_FR]], !dbg [[DBG573:![0-9]+]]
; LZCNT-NEXT:      #dbg_value(i3 [[BITMASK]], [[META568:![0-9]+]], !DIExpression(), [[DBG573]])
; LZCNT-NEXT:    [[BIT_FR_LOWBITMASK:%.*]] = add i3 [[BITMASK]], -1, !dbg [[DBG574:![0-9]+]]
; LZCNT-NEXT:    [[BIT_FR_MASK:%.*]] = or i3 [[BIT_FR_LOWBITMASK]], [[BITMASK]], !dbg [[DBG574]]
; LZCNT-NEXT:    [[X_MASKED:%.*]] = and i3 [[X:%.*]], [[BIT_FR_MASK]], !dbg [[DBG574]]
; LZCNT-NEXT:    [[X_MASKED_NUMLEADINGZEROS:%.*]] = call i3 @llvm.ctlz.i3(i3 [[X_MASKED]], i1 true), !dbg [[DBG574]]
; LZCNT-NEXT:    [[X_MASKED_NUMACTIVEBITS:%.*]] = sub nuw nsw i3 3, [[X_MASKED_NUMLEADINGZEROS]], !dbg [[DBG574]]
; LZCNT-NEXT:    [[X_MASKED_LEADINGONEPOS:%.*]] = add nsw i3 [[X_MASKED_NUMACTIVEBITS]], -1, !dbg [[DBG574]]
; LZCNT-NEXT:    [[LOOP_BACKEDGETAKENCOUNT:%.*]] = sub nuw nsw i3 [[BIT_FR]], [[X_MASKED_LEADINGONEPOS]], !dbg [[DBG574]]
; LZCNT-NEXT:    [[LOOP_TRIPCOUNT:%.*]] = add nuw nsw i3 [[LOOP_BACKEDGETAKENCOUNT]], 1, !dbg [[DBG574]]
; LZCNT-NEXT:    [[X_CURR:%.*]] = shl i3 [[X]], [[LOOP_BACKEDGETAKENCOUNT]], !dbg [[DBG574]]
; LZCNT-NEXT:    [[X_NEXT:%.*]] = shl i3 [[X_CURR]], 1, !dbg [[DBG574]]
; LZCNT-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG575:![0-9]+]]
; LZCNT:       loop:
; LZCNT-NEXT:    [[LOOP_IV:%.*]] = phi i3 [ 0, [[ENTRY:%.*]] ], [ [[LOOP_IV_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG574]]
; LZCNT-NEXT:    [[TMP0:%.*]] = phi i3 [ [[X]], [[ENTRY]] ], [ [[TMP1:%.*]], [[LOOP]] ], !dbg [[DBG574]]
; LZCNT-NEXT:      #dbg_value(i3 [[TMP0]], [[META569:![0-9]+]], !DIExpression(), [[DBG574]])
; LZCNT-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i3 [[TMP0]], [[BITMASK]], !dbg [[DBG576:![0-9]+]]
; LZCNT-NEXT:      #dbg_value(i3 [[X_CURR_BITMASKED]], [[META570:![0-9]+]], !DIExpression(), [[DBG576]])
; LZCNT-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i3 [[X_CURR_BITMASKED]], 0, !dbg [[DBG577:![0-9]+]]
; LZCNT-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META571:![0-9]+]], !DIExpression(), [[DBG577]])
; LZCNT-NEXT:    [[TMP1]] = shl i3 [[TMP0]], 1, !dbg [[DBG578:![0-9]+]]
; LZCNT-NEXT:      #dbg_value(i3 [[TMP1]], [[META572:![0-9]+]], !DIExpression(), [[DBG578]])
; LZCNT-NEXT:    [[LOOP_IV_NEXT]] = add nuw nsw i3 [[LOOP_IV]], 1, !dbg [[DBG579:![0-9]+]]
; LZCNT-NEXT:    [[LOOP_IVCHECK:%.*]] = icmp eq i3 [[LOOP_IV_NEXT]], [[LOOP_TRIPCOUNT]], !dbg [[DBG579]]
; LZCNT-NEXT:    br i1 [[LOOP_IVCHECK]], label [[END:%.*]], label [[LOOP]], !dbg [[DBG579]]
; LZCNT:       end:
; LZCNT-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i3 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG574]]
; LZCNT-NEXT:    [[X_NEXT_LCSSA:%.*]] = phi i3 [ [[X_NEXT]], [[LOOP]] ], !dbg [[DBG578]]
; LZCNT-NEXT:    store i3 [[X_CURR_LCSSA]], ptr [[P0:%.*]], align 1, !dbg [[DBG580:![0-9]+]]
; LZCNT-NEXT:    store i3 [[X_NEXT_LCSSA]], ptr [[P1:%.*]], align 1, !dbg [[DBG581:![0-9]+]]
; LZCNT-NEXT:    ret void, !dbg [[DBG582:![0-9]+]]
;
; NOLZCNT-LABEL: @t37_i3(
; NOLZCNT-NEXT:  entry:
; NOLZCNT-NEXT:    [[BITMASK:%.*]] = shl i3 1, [[BIT:%.*]], !dbg [[DBG573:![0-9]+]]
; NOLZCNT-NEXT:      #dbg_value(i3 [[BITMASK]], [[META568:![0-9]+]], !DIExpression(), [[DBG573]])
; NOLZCNT-NEXT:    br label [[LOOP:%.*]], !dbg [[DBG574:![0-9]+]]
; NOLZCNT:       loop:
; NOLZCNT-NEXT:    [[X_CURR:%.*]] = phi i3 [ [[X:%.*]], [[ENTRY:%.*]] ], [ [[X_NEXT:%.*]], [[LOOP]] ], !dbg [[DBG575:![0-9]+]]
; NOLZCNT-NEXT:      #dbg_value(i3 [[X_CURR]], [[META569:![0-9]+]], !DIExpression(), [[DBG575]])
; NOLZCNT-NEXT:    [[X_CURR_BITMASKED:%.*]] = and i3 [[X_CURR]], [[BITMASK]], !dbg [[DBG576:![0-9]+]]
; NOLZCNT-NEXT:      #dbg_value(i3 [[X_CURR_BITMASKED]], [[META570:![0-9]+]], !DIExpression(), [[DBG576]])
; NOLZCNT-NEXT:    [[X_CURR_ISBITUNSET:%.*]] = icmp eq i3 [[X_CURR_BITMASKED]], 0, !dbg [[DBG577:![0-9]+]]
; NOLZCNT-NEXT:      #dbg_value(i1 [[X_CURR_ISBITUNSET]], [[META571:![0-9]+]], !DIExpression(), [[DBG577]])
; NOLZCNT-NEXT:    [[X_NEXT]] = shl i3 [[X_CURR]], 1, !dbg [[DBG578:![0-9]+]]
; NOLZCNT-NEXT:      #dbg_value(i3 [[X_NEXT]], [[META572:![0-9]+]], !DIExpression(), [[DBG578]])
; NOLZCNT-NEXT:    br i1 [[X_CURR_ISBITUNSET]], label [[LOOP]], label [[END:%.*]], !dbg [[DBG579:![0-9]+]]
; NOLZCNT:       end:
; NOLZCNT-NEXT:    [[X_CURR_LCSSA:%.*]] = phi i3 [ [[X_CURR]], [[LOOP]] ], !dbg [[DBG575]]
; NOLZCNT-NEXT:    [[X_NEXT_LCSSA:%.*]] = phi i3 [ [[X_NEXT]], [[LOOP]] ], !dbg [[DBG578]]
; NOLZCNT-NEXT:    store i3 [[X_CURR_LCSSA]], ptr [[P0:%.*]], align 1, !dbg [[DBG580:![0-9]+]]
; NOLZCNT-NEXT:    store i3 [[X_NEXT_LCSSA]], ptr [[P1:%.*]], align 1, !dbg [[DBG581:![0-9]+]]
; NOLZCNT-NEXT:    ret void, !dbg [[DBG582:![0-9]+]]
;
entry:
  %bitmask = shl i3 1, %bit
  br label %loop

loop:
  %x.curr = phi i3 [ %x, %entry ], [ %x.next, %loop ]
  %x.curr.bitmasked = and i3 %x.curr, %bitmask
  %x.curr.isbitunset = icmp eq i3 %x.curr.bitmasked, 0
  %x.next = shl i3 %x.curr, 1
  br i1 %x.curr.isbitunset, label %loop, label %end

end:
  store i3 %x.curr, ptr %p0
  store i3 %x.next, ptr %p1
  ret void
}
