; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown -mattr=+sse4.2 | FileCheck %s --check-prefix=X86
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+sse4.2 | FileCheck %s --check-prefix=X64

; Test based on pr5626 to load/store
;

%i32vec3 = type <3 x i32>
define void @add3i32(ptr sret(%i32vec3) %ret, ptr %ap, ptr %bp)  {
; X86-LABEL: add3i32:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movdqa (%edx), %xmm0
; X86-NEXT:    paddd (%ecx), %xmm0
; X86-NEXT:    pextrd $2, %xmm0, 8(%eax)
; X86-NEXT:    pextrd $1, %xmm0, 4(%eax)
; X86-NEXT:    movd %xmm0, (%eax)
; X86-NEXT:    retl $4
;
; X64-LABEL: add3i32:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    movdqa (%rsi), %xmm0
; X64-NEXT:    paddd (%rdx), %xmm0
; X64-NEXT:    pextrd $2, %xmm0, 8(%rdi)
; X64-NEXT:    movq %xmm0, (%rdi)
; X64-NEXT:    retq
	%a = load %i32vec3, ptr %ap, align 16
	%b = load %i32vec3, ptr %bp, align 16
	%x = add %i32vec3 %a, %b
	store %i32vec3 %x, ptr %ret, align 16
	ret void
}

define void @add3i32_2(ptr sret(%i32vec3) %ret, ptr %ap, ptr %bp)  {
; X86-LABEL: add3i32_2:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-NEXT:    pinsrd $1, 4(%edx), %xmm0
; X86-NEXT:    pinsrd $2, 8(%edx), %xmm0
; X86-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X86-NEXT:    pinsrd $1, 4(%ecx), %xmm1
; X86-NEXT:    pinsrd $2, 8(%ecx), %xmm1
; X86-NEXT:    paddd %xmm0, %xmm1
; X86-NEXT:    movd %xmm1, (%eax)
; X86-NEXT:    pextrd $1, %xmm1, 4(%eax)
; X86-NEXT:    pextrd $2, %xmm1, 8(%eax)
; X86-NEXT:    retl $4
;
; X64-LABEL: add3i32_2:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X64-NEXT:    pinsrd $2, 8(%rsi), %xmm0
; X64-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; X64-NEXT:    pinsrd $2, 8(%rdx), %xmm1
; X64-NEXT:    paddd %xmm0, %xmm1
; X64-NEXT:    pextrd $2, %xmm1, 8(%rdi)
; X64-NEXT:    movq %xmm1, (%rdi)
; X64-NEXT:    retq
	%a = load %i32vec3, ptr %ap, align 8
	%b = load %i32vec3, ptr %bp, align 8
	%x = add %i32vec3 %a, %b
	store %i32vec3 %x, ptr %ret, align 8
	ret void
}

%i32vec7 = type <7 x i32>
define void @add7i32(ptr sret(%i32vec7) %ret, ptr %ap, ptr %bp)  {
; X86-LABEL: add7i32:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movdqa (%edx), %xmm0
; X86-NEXT:    movdqa 16(%edx), %xmm1
; X86-NEXT:    paddd (%ecx), %xmm0
; X86-NEXT:    paddd 16(%ecx), %xmm1
; X86-NEXT:    movd %xmm1, 16(%eax)
; X86-NEXT:    pextrd $1, %xmm1, 20(%eax)
; X86-NEXT:    pextrd $2, %xmm1, 24(%eax)
; X86-NEXT:    movdqa %xmm0, (%eax)
; X86-NEXT:    retl $4
;
; X64-LABEL: add7i32:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    movdqa (%rsi), %xmm0
; X64-NEXT:    movdqa 16(%rsi), %xmm1
; X64-NEXT:    paddd (%rdx), %xmm0
; X64-NEXT:    paddd 16(%rdx), %xmm1
; X64-NEXT:    movq %xmm1, 16(%rdi)
; X64-NEXT:    pextrd $2, %xmm1, 24(%rdi)
; X64-NEXT:    movdqa %xmm0, (%rdi)
; X64-NEXT:    retq
	%a = load %i32vec7, ptr %ap, align 16
	%b = load %i32vec7, ptr %bp, align 16
	%x = add %i32vec7 %a, %b
	store %i32vec7 %x, ptr %ret, align 16
	ret void
}

%i32vec12 = type <12 x i32>
define void @add12i32(ptr sret(%i32vec12) %ret, ptr %ap, ptr %bp)  {
; X86-LABEL: add12i32:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movdqa 32(%edx), %xmm0
; X86-NEXT:    movdqa (%edx), %xmm1
; X86-NEXT:    movdqa 16(%edx), %xmm2
; X86-NEXT:    paddd (%ecx), %xmm1
; X86-NEXT:    paddd 32(%ecx), %xmm0
; X86-NEXT:    paddd 16(%ecx), %xmm2
; X86-NEXT:    movdqa %xmm2, 16(%eax)
; X86-NEXT:    movdqa %xmm0, 32(%eax)
; X86-NEXT:    movdqa %xmm1, (%eax)
; X86-NEXT:    retl $4
;
; X64-LABEL: add12i32:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    movdqa (%rsi), %xmm0
; X64-NEXT:    movdqa 16(%rsi), %xmm1
; X64-NEXT:    movdqa 32(%rsi), %xmm2
; X64-NEXT:    paddd (%rdx), %xmm0
; X64-NEXT:    paddd 32(%rdx), %xmm2
; X64-NEXT:    paddd 16(%rdx), %xmm1
; X64-NEXT:    movdqa %xmm1, 16(%rdi)
; X64-NEXT:    movdqa %xmm2, 32(%rdi)
; X64-NEXT:    movdqa %xmm0, (%rdi)
; X64-NEXT:    retq
	%a = load %i32vec12, ptr %ap, align 16
	%b = load %i32vec12, ptr %bp, align 16
	%x = add %i32vec12 %a, %b
	store %i32vec12 %x, ptr %ret, align 16
	ret void
}


%i16vec3 = type <3 x i16>
define void @add3i16(ptr nocapture sret(%i16vec3) %ret, ptr %ap, ptr %bp) nounwind {
; X86-LABEL: add3i16:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-NEXT:    pinsrw $2, 4(%edx), %xmm0
; X86-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X86-NEXT:    pinsrw $2, 4(%ecx), %xmm1
; X86-NEXT:    paddw %xmm0, %xmm1
; X86-NEXT:    pextrw $2, %xmm1, 4(%eax)
; X86-NEXT:    movd %xmm1, (%eax)
; X86-NEXT:    retl $4
;
; X64-LABEL: add3i16:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X64-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; X64-NEXT:    paddw %xmm0, %xmm1
; X64-NEXT:    pextrw $2, %xmm1, 4(%rdi)
; X64-NEXT:    movd %xmm1, (%rdi)
; X64-NEXT:    retq
	%a = load %i16vec3, ptr %ap, align 16
	%b = load %i16vec3, ptr %bp, align 16
	%x = add %i16vec3 %a, %b
	store %i16vec3 %x, ptr %ret, align 16
	ret void
}

%i16vec4 = type <4 x i16>
define void @add4i16(ptr nocapture sret(%i16vec4) %ret, ptr %ap, ptr %bp) nounwind {
; X86-LABEL: add4i16:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X86-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; X86-NEXT:    paddw %xmm0, %xmm1
; X86-NEXT:    movq %xmm1, (%eax)
; X86-NEXT:    retl $4
;
; X64-LABEL: add4i16:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X64-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; X64-NEXT:    paddw %xmm0, %xmm1
; X64-NEXT:    movq %xmm1, (%rdi)
; X64-NEXT:    retq
	%a = load %i16vec4, ptr %ap, align 16
	%b = load %i16vec4, ptr %bp, align 16
	%x = add %i16vec4 %a, %b
	store %i16vec4 %x, ptr %ret, align 16
	ret void
}

%i16vec12 = type <12 x i16>
define void @add12i16(ptr nocapture sret(%i16vec12) %ret, ptr %ap, ptr %bp) nounwind {
; X86-LABEL: add12i16:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movdqa (%edx), %xmm0
; X86-NEXT:    movdqa 16(%edx), %xmm1
; X86-NEXT:    paddw (%ecx), %xmm0
; X86-NEXT:    paddw 16(%ecx), %xmm1
; X86-NEXT:    movd %xmm1, 16(%eax)
; X86-NEXT:    pextrd $1, %xmm1, 20(%eax)
; X86-NEXT:    movdqa %xmm0, (%eax)
; X86-NEXT:    retl $4
;
; X64-LABEL: add12i16:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    movdqa (%rsi), %xmm0
; X64-NEXT:    movdqa 16(%rsi), %xmm1
; X64-NEXT:    paddw (%rdx), %xmm0
; X64-NEXT:    paddw 16(%rdx), %xmm1
; X64-NEXT:    movq %xmm1, 16(%rdi)
; X64-NEXT:    movdqa %xmm0, (%rdi)
; X64-NEXT:    retq
	%a = load %i16vec12, ptr %ap, align 16
	%b = load %i16vec12, ptr %bp, align 16
	%x = add %i16vec12 %a, %b
	store %i16vec12 %x, ptr %ret, align 16
	ret void
}

%i16vec18 = type <18 x i16>
define void @add18i16(ptr nocapture sret(%i16vec18) %ret, ptr %ap, ptr %bp) nounwind {
; X86-LABEL: add18i16:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movdqa 32(%edx), %xmm0
; X86-NEXT:    movdqa (%edx), %xmm1
; X86-NEXT:    movdqa 16(%edx), %xmm2
; X86-NEXT:    paddw (%ecx), %xmm1
; X86-NEXT:    paddw 32(%ecx), %xmm0
; X86-NEXT:    paddw 16(%ecx), %xmm2
; X86-NEXT:    movdqa %xmm2, 16(%eax)
; X86-NEXT:    movd %xmm0, 32(%eax)
; X86-NEXT:    movdqa %xmm1, (%eax)
; X86-NEXT:    retl $4
;
; X64-LABEL: add18i16:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    movdqa (%rsi), %xmm0
; X64-NEXT:    movdqa 16(%rsi), %xmm1
; X64-NEXT:    movdqa 32(%rsi), %xmm2
; X64-NEXT:    paddw (%rdx), %xmm0
; X64-NEXT:    paddw 32(%rdx), %xmm2
; X64-NEXT:    paddw 16(%rdx), %xmm1
; X64-NEXT:    movdqa %xmm1, 16(%rdi)
; X64-NEXT:    movd %xmm2, 32(%rdi)
; X64-NEXT:    movdqa %xmm0, (%rdi)
; X64-NEXT:    retq
	%a = load %i16vec18, ptr %ap, align 16
	%b = load %i16vec18, ptr %bp, align 16
	%x = add %i16vec18 %a, %b
	store %i16vec18 %x, ptr %ret, align 16
	ret void
}


%i8vec3 = type <3 x i8>
define void @add3i8(ptr nocapture sret(%i8vec3) %ret, ptr %ap, ptr %bp) nounwind {
; X86-LABEL: add3i8:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X86-NEXT:    paddb %xmm0, %xmm1
; X86-NEXT:    pextrb $2, %xmm1, 2(%eax)
; X86-NEXT:    pextrw $0, %xmm1, (%eax)
; X86-NEXT:    retl $4
;
; X64-LABEL: add3i8:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X64-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X64-NEXT:    paddb %xmm0, %xmm1
; X64-NEXT:    pextrb $2, %xmm1, 2(%rdi)
; X64-NEXT:    pextrw $0, %xmm1, (%rdi)
; X64-NEXT:    retq
	%a = load %i8vec3, ptr %ap, align 16
	%b = load %i8vec3, ptr %bp, align 16
	%x = add %i8vec3 %a, %b
	store %i8vec3 %x, ptr %ret, align 16
	ret void
}

%i8vec31 = type <31 x i8>
define void @add31i8(ptr nocapture sret(%i8vec31) %ret, ptr %ap, ptr %bp) nounwind {
; X86-LABEL: add31i8:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movdqa (%edx), %xmm0
; X86-NEXT:    movdqa 16(%edx), %xmm1
; X86-NEXT:    paddb (%ecx), %xmm0
; X86-NEXT:    paddb 16(%ecx), %xmm1
; X86-NEXT:    movd %xmm1, 16(%eax)
; X86-NEXT:    pextrd $1, %xmm1, 20(%eax)
; X86-NEXT:    pextrd $2, %xmm1, 24(%eax)
; X86-NEXT:    pextrw $6, %xmm1, 28(%eax)
; X86-NEXT:    pextrb $14, %xmm1, 30(%eax)
; X86-NEXT:    movdqa %xmm0, (%eax)
; X86-NEXT:    retl $4
;
; X64-LABEL: add31i8:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    movdqa (%rsi), %xmm0
; X64-NEXT:    movdqa 16(%rsi), %xmm1
; X64-NEXT:    paddb (%rdx), %xmm0
; X64-NEXT:    paddb 16(%rdx), %xmm1
; X64-NEXT:    movq %xmm1, 16(%rdi)
; X64-NEXT:    pextrd $2, %xmm1, 24(%rdi)
; X64-NEXT:    pextrw $6, %xmm1, 28(%rdi)
; X64-NEXT:    pextrb $14, %xmm1, 30(%rdi)
; X64-NEXT:    movdqa %xmm0, (%rdi)
; X64-NEXT:    retq
	%a = load %i8vec31, ptr %ap, align 16
	%b = load %i8vec31, ptr %bp, align 16
	%x = add %i8vec31 %a, %b
	store %i8vec31 %x, ptr %ret, align 16
	ret void
}


%i8vec3pack = type { <3 x i8>, i8 }
define void @rot(ptr nocapture sret(%i8vec3pack) %result, ptr %X, ptr %rot) nounwind {
; X86-LABEL: rot:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movb $-98, 2(%edx)
; X86-NEXT:    movw $-24930, (%edx) # imm = 0x9E9E
; X86-NEXT:    movb $1, 2(%ecx)
; X86-NEXT:    movw $257, (%ecx) # imm = 0x101
; X86-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-NEXT:    psrlw $1, %xmm0
; X86-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0
; X86-NEXT:    pextrb $2, %xmm0, 2(%eax)
; X86-NEXT:    pextrw $0, %xmm0, (%eax)
; X86-NEXT:    retl $4
;
; X64-LABEL: rot:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    movb $-98, 2(%rsi)
; X64-NEXT:    movw $-24930, (%rsi) # imm = 0x9E9E
; X64-NEXT:    movb $1, 2(%rdx)
; X64-NEXT:    movw $257, (%rdx) # imm = 0x101
; X64-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X64-NEXT:    psrlw $1, %xmm0
; X64-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-NEXT:    pextrb $2, %xmm0, 2(%rdi)
; X64-NEXT:    pextrw $0, %xmm0, (%rdi)
; X64-NEXT:    retq
entry:
  store <3 x i8> <i8 -98, i8 -98, i8 -98>, ptr %X
  store <3 x i8> <i8 1, i8 1, i8 1>, ptr %rot
  %tmp = load %i8vec3pack, ptr %X
  %extractVec = extractvalue %i8vec3pack %tmp, 0
  %tmp2 = load %i8vec3pack, ptr %rot
  %extractVec3 = extractvalue %i8vec3pack %tmp2, 0
  %shr = lshr <3 x i8> %extractVec, %extractVec3
  store <3 x i8> %shr, ptr %result
  ret void
}

