; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-- -mattr=+sse2 -enable-unsafe-fp-math | FileCheck %s

; Don't fold the incoming stack arguments into the xorps instructions used
; to do floating-point negations, because the arguments aren't vectors
; and aren't vector-aligned.

define void @foo(ptr %p, ptr %q, float %s, float %y) {
; CHECK-LABEL: foo:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; CHECK-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-NEXT:    movaps {{.*#+}} xmm1 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; CHECK-NEXT:    xorps %xmm1, %xmm0
; CHECK-NEXT:    movss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; CHECK-NEXT:    xorps %xmm1, %xmm2
; CHECK-NEXT:    movss %xmm0, (%ecx)
; CHECK-NEXT:    movss %xmm2, (%eax)
; CHECK-NEXT:    retl
  %ss = fsub float -0.0, %s
  %yy = fsub float -0.0, %y
  store float %ss, ptr %p
  store float %yy, ptr %q
  ret void
}
